{"vars":[{"name":"Common","containerName":"strict::Bio::Tools::Analysis::Protein::Sopma::IO::String::Bio::SeqIO::HTTP::Request","line":153,"kind":2},{"line":158,"kind":2,"containerName":"","name":"base"},{"containerName":null,"name":"$URL","definition":"my","localvar":"my","kind":13,"line":161},{"line":162,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$ANALYSIS_NAME"},{"kind":13,"line":163,"definition":"my","name":"%ANALYSIS_SPEC","containerName":null,"localvar":"my"},{"kind":12,"line":163,"name":"name"},{"name":"type","kind":12,"line":163},{"kind":13,"line":164,"containerName":null,"name":"@INPUT_SPEC","definition":"my","localvar":"my"},{"name":"mandatory","line":165,"kind":12},{"line":166,"kind":12,"name":"type"},{"name":"mandatory","line":169,"kind":12},{"line":170,"kind":12,"name":"type"},{"line":171,"kind":12,"name":"name"},{"kind":12,"line":172,"name":"default"},{"kind":12,"line":174,"name":"mandatory"},{"name":"type","line":175,"kind":12},{"line":176,"kind":12,"name":"name"},{"kind":12,"line":177,"name":"default"},{"line":179,"kind":12,"name":"mandatory"},{"kind":12,"line":180,"name":"type"},{"name":"name","line":181,"kind":12},{"name":"default","line":182,"kind":12},{"line":185,"kind":13,"localvar":"my","definition":"my","name":"%RESULT_SPEC","containerName":null},{"name":"raw","kind":12,"line":188},{"kind":12,"line":189,"name":"meta"},{"name":"MIN_STRUC_LEN","definition":1,"containerName":"main::","line":192,"kind":14},{"line":206,"children":[{"kind":13,"line":207,"containerName":"similarity_threshold","name":"$self","definition":"my","localvar":"my"},{"containerName":"similarity_threshold","name":"$value","kind":13,"line":207},{"containerName":"similarity_threshold","name":"$value","line":208,"kind":13},{"containerName":"similarity_threshold","name":"$self","line":209,"kind":13},{"kind":12,"line":209,"containerName":"similarity_threshold","name":"throw"},{"containerName":"similarity_threshold","name":"$value","line":210,"kind":13},{"containerName":"similarity_threshold","name":"$self","kind":13,"line":211},{"containerName":"similarity_threshold","name":"$value","kind":13,"line":211},{"name":"$self","containerName":"similarity_threshold","line":213,"kind":13},{"line":213,"kind":13,"containerName":"similarity_threshold","name":"$self"},{"line":213,"kind":12,"containerName":"similarity_threshold","name":"input_spec"},{"name":"$self","containerName":"similarity_threshold","line":214,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"label":"similarity_threshold($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction."},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":206},"end":{"character":9999,"line":215}},"name":"similarity_threshold"},{"name":"window_width","range":{"end":{"line":240,"character":9999},"start":{"character":0,"line":229}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"window_width($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error."},"kind":12,"line":229,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"window_width","line":230,"kind":13},{"name":"$value","containerName":"window_width","line":230,"kind":13},{"name":"$value","containerName":"window_width","line":231,"kind":13},{"containerName":"window_width","name":"$self","line":232,"kind":13},{"kind":12,"line":232,"containerName":"window_width","name":"throw"},{"containerName":"window_width","name":"$value","line":233,"kind":13},{"line":234,"kind":13,"name":"$self","containerName":"window_width"},{"kind":13,"line":234,"name":"$value","containerName":"window_width"},{"containerName":"window_width","name":"$self","line":236,"kind":13},{"containerName":"window_width","name":"$self","line":236,"kind":13},{"line":236,"kind":12,"name":"input_spec","containerName":"window_width"},{"kind":13,"line":237,"name":"$self","containerName":"window_width"},{"kind":12,"line":237,"containerName":"window_width","name":"warn"},{"line":238,"kind":13,"name":"$self","containerName":"window_width"},{"name":"$self","containerName":"window_width","kind":13,"line":238},{"containerName":"window_width","name":"seq","kind":12,"line":238},{"kind":12,"line":238,"name":"length","containerName":"window_width"},{"name":"$self","containerName":"window_width","line":239,"kind":13}]},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"states($self,$value)","documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error.\n\n\nsub window_width {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"window_width must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_window_width'} = $value;\n    }\n    $self->{'_window_width'} ||= $self->input_spec->[2]{'default'};\n    $self->warn (\"window width longer than sequence!\")\n        unless $self->{'_window_width'} < $self->seq->length;\n    return $self->{'_window_width'};\n}\n\n=head2  states\n\n  Usage    : $job->states(...)\n  Returns  : The number of secondary structure prediction states\n  Args     : None (retrieves value) or either '3' or '4' to set\n             prior to running analysis.\n\nThis method gets/sets the number of states for the prediction, either\n3 or 4 (includes turns).","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":254,"children":[{"kind":13,"line":255,"name":"$self","definition":"my","containerName":"states","localvar":"my"},{"kind":13,"line":255,"name":"$value","containerName":"states"},{"kind":13,"line":256,"name":"$value","containerName":"states"},{"name":"$self","containerName":"states","line":257,"kind":13},{"containerName":"states","name":"throw","line":257,"kind":12},{"containerName":"states","name":"$value","kind":13,"line":258},{"containerName":"states","name":"$value","kind":13,"line":258},{"kind":13,"line":259,"name":"$self","containerName":"states"},{"kind":13,"line":259,"name":"$value","containerName":"states"},{"containerName":"states","name":"$self","kind":13,"line":261},{"name":"$self","containerName":"states","line":261,"kind":13},{"kind":12,"line":261,"name":"input_spec","containerName":"states"},{"name":"$self","containerName":"states","line":262,"kind":13}],"name":"states","range":{"end":{"character":9999,"line":263},"start":{"character":0,"line":254}}},{"containerName":"main::","definition":"sub","detail":"($self,$value,$run_id)","signature":{"label":"result($self,$value,$run_id)","documentation":"1;\n# $Id: Sopma.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Sopma\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Sopma - a wrapper around the\nSopma protein secondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Sopma;\n  #get a Bio::Seq or Bio::PrimarySeq\n  my $seq;\n\n  my $sopma = Bio::Tools::Analysis::Protein::Sopma->new\n      (-seq=>$seq, states=>4);\n  $sopma->run;\n  print $sopma->result;# #raw text to standard error\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of four different states (helix,\ncoil, turn or sheet), e.g.,\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::Sopma->new\n      ( -seq          => $seq,\n        -states       => 4,\n        -window_width => 15,\n      );\n\ncreates a new object.  Compulsory argument -seq.  Optional arguments\n-states, -window_width,-similarity_threshold. These arguments can also be\nset by direct methods , e.g.,\n\n  $analysis_object->states(4);\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output. Given an\namino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\nHash keys are 'helix', 'struc', 'sheet', 'coil', 'turn'.\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices/sheets.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence.  In this case, the sequence can be associated with a\narrays of Sopma prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->named_submeta_text(\"Sopma_helix\",10,20), \"\\n\";\n\nMeta sequence names are : Sopma_helix, Sopma_sheet, Sopma_turn,\nSopma_coil, Sopma_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>\nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::Sopma;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_sopma.pl';\nmy $ANALYSIS_NAME= 'Sopma';\nmy $ANALYSIS_SPEC= {name => 'Sopma', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  {mandatory=>'true',\n                   type     => 'Bio::PrimarySeqI',\n                   'name'   => 'seq',\n                  },\n                  {mandatory =>'false',\n                   type      => 'integer',\n                   name      => 'similarity_threshold',\n                   default   => 8,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'window_width',\n                   default    => 17,\n                  },\n                  {mandatory  =>'false',\n                   type       => 'integer',\n                   name       => 'states',\n                   default    => 4,\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''   => 'bulk',              # same as undef\n     raw  => '[{struc=>, helix=>, turn=>, coil=>, sheet=>}]',\n     meta => 'Bio::Seq::Meta::Array object',\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\n\n=head2  similarity_threshold\n\n  Useage  : $job->similarity_threshold(...)\n  Returns : The  similarity threshold used in the analysis\n  Args    : None (retrieves value) or  an integer (default = 8) \n            that sets the similarity threshold .\n\nThis method gets/sets the  similarity threshold for the prediction.\n\n\nsub similarity_threshold {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"similarity_threshold must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_similarity_threshold'} = $value;\n    }\n    $self->{'_similarity_threshold'} ||= $self->input_spec->[1]{'default'};\n    return $self->{'_similarity_threshold'};\n}\n\n=head2  window_width\n\n  Usage    : $job->window_width(...)\n  Returns  : The window width used in the analysis\n  Args     : None (retrieves value) or  an integer (default = 17)\n             that sets the window width.\n\nThis method gets/sets the window width for the prediction, .  If\nattempted to set longer than the sequence, warns of error.\n\n\nsub window_width {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"window_width must be integer\")\n            unless $value =~ /^\\d+$/;\n        $self->{'_window_width'} = $value;\n    }\n    $self->{'_window_width'} ||= $self->input_spec->[2]{'default'};\n    $self->warn (\"window width longer than sequence!\")\n        unless $self->{'_window_width'} < $self->seq->length;\n    return $self->{'_window_width'};\n}\n\n=head2  states\n\n  Usage    : $job->states(...)\n  Returns  : The number of secondary structure prediction states\n  Args     : None (retrieves value) or either '3' or '4' to set\n             prior to running analysis.\n\nThis method gets/sets the number of states for the prediction, either\n3 or 4 (includes turns).\n\n\nsub states {\n    my ($self, $value) = @_;\n    if ($value) {\n        $self->throw (\"number of states must be 3 or 4\")\n            unless $value == 3 or $value ==4;\n        $self->{'_states'} = $value;\n    }\n    $self->{'_states'} ||= $self->input_spec->[3]{'default'};\n    return $self->{'_states'};\n}\n\n=head2 result\n\n  Usage   : $job->result (...)\n  Returns : a result created by running an analysis\n  Args    : various\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet\ncoil, or turn if 4 state prediction requested) \"method\" (Sopma)\n\n* 'parsed'\n\nArray of hash references of scores/structure assignations \n{ helix =E<gt> , sheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are Sopma_helix, Sopma_sheet,\nSopma_coil, Sopma_turn (if defined), and Sopma_struc.","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$run_id"}]},"kind":12,"line":308,"children":[{"containerName":"result","name":"$self","definition":"my","localvar":"my","kind":13,"line":309},{"name":"$value","containerName":"result","line":309,"kind":13},{"kind":13,"line":309,"name":"$run_id","containerName":"result"},{"kind":13,"line":311,"containerName":"result","name":"@score","definition":"my","localvar":"my"},{"containerName":"result","definition":"my","name":"@fts","localvar":"my","kind":13,"line":312},{"line":314,"kind":13,"name":"$value","containerName":"result"},{"containerName":"result","name":"$self","line":315,"kind":13},{"line":316,"kind":13,"localvar":"my","definition":"my","name":"$result","containerName":"result"},{"containerName":"result","name":"new","line":316,"kind":12},{"line":316,"kind":13,"containerName":"result","name":"$self"},{"kind":13,"line":317,"containerName":"result","name":"$line","definition":"my","localvar":"my"},{"line":317,"kind":13,"name":"$result","containerName":"result"},{"containerName":"result","name":"$line","line":318,"kind":13},{"name":"$line","containerName":"result","line":319,"kind":13},{"name":"@score","containerName":"result","kind":13,"line":320},{"line":326,"kind":13,"name":"$score","containerName":"result"},{"line":326,"kind":13,"name":"$self","containerName":"result"},{"line":326,"kind":12,"name":"states","containerName":"result"},{"line":329,"kind":13,"name":"$self","containerName":"result"},{"line":329,"kind":13,"name":"@score","containerName":"result"},{"containerName":"result","name":"$value","line":331,"kind":13},{"containerName":"result","name":"$self","kind":13,"line":332},{"name":"_get_2ary_coords","containerName":"result","kind":12,"line":332},{"line":333,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"result"},{"containerName":"result","name":"$self","line":333,"kind":13},{"kind":13,"line":334,"containerName":"result","name":"$type"},{"kind":13,"line":338,"containerName":"result","definition":"my","name":"$tag_hash","localvar":"my"},{"containerName":"result","name":"$type","kind":13,"line":339},{"name":"$self","containerName":"result","line":340,"kind":13},{"kind":12,"line":340,"containerName":"result","name":"analysis_name"},{"kind":13,"line":342,"containerName":"result","name":"$self"},{"containerName":"result","name":"_add_params_to_result","kind":12,"line":342},{"name":"$tag_hash","containerName":"result","line":342,"kind":13},{"definition":"my","name":"$loc","containerName":"result","localvar":"my","kind":13,"line":345},{"containerName":"result","name":"$self","line":345,"kind":13},{"containerName":"result","name":"$type","kind":13,"line":345},{"name":"@fts","containerName":"result","kind":13,"line":346},{"containerName":"result","name":"new","line":347,"kind":12},{"line":347,"kind":13,"name":"$loc","containerName":"result"},{"containerName":"result","name":"$loc","line":348,"kind":13},{"kind":13,"line":351,"name":"$tag_hash","containerName":"result"},{"line":355,"kind":13,"containerName":"result","name":"$self"},{"containerName":"result","name":"@fts","line":356,"kind":13}],"name":"result","range":{"start":{"line":308,"character":0},"end":{"line":357,"character":9999}}},{"line":316,"kind":12,"containerName":"String","name":"IO"},{"kind":12,"line":320,"name":"struc"},{"name":"helix","line":321,"kind":12},{"line":322,"kind":12,"name":"sheet"},{"line":323,"kind":12,"name":"coil"},{"kind":12,"line":326,"name":"score"},{"name":"type","kind":12,"line":339},{"name":"method","kind":12,"line":340},{"line":346,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"kind":13,"line":359,"containerName":null,"name":"%value"},{"containerName":null,"definition":"my","name":"%type_scores","localvar":"my","kind":13,"line":361},{"kind":13,"line":362,"definition":"my","name":"$aa","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"line":362,"kind":13},{"definition":"my","name":"%type","containerName":null,"localvar":"my","kind":13,"line":363},{"name":"%type_scores","containerName":null,"line":364,"kind":13},{"line":364,"kind":13,"name":"$type","containerName":null},{"name":"%aa","containerName":null,"line":364,"kind":13},{"line":364,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"name":"%type_scores","line":366,"kind":13},{"containerName":null,"name":"%aa","kind":13,"line":366},{"name":"%aa","containerName":null,"line":366,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":370},{"kind":12,"line":370,"name":"seq","containerName":"main::"},{"kind":12,"line":370,"name":"isa","containerName":"main::"},{"line":371,"kind":13,"name":"$self","containerName":null},{"name":"seq","containerName":"main::","kind":12,"line":371},{"containerName":null,"name":"$self","line":373,"kind":13},{"containerName":"main::","name":"seq","kind":12,"line":373},{"containerName":"main::","name":"isa","line":373,"kind":12},{"kind":13,"line":374,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":374},{"line":377,"kind":13,"name":"$Bio","containerName":null},{"line":377,"kind":12,"name":"Seq","containerName":"Meta::Array::DEFAULT_NAME"},{"line":378,"kind":13,"localvar":"my","definition":"my","name":"$struc_type","containerName":null},{"name":"%type_scores","containerName":null,"kind":13,"line":378},{"kind":13,"line":379,"containerName":null,"name":"$meta_name","definition":"my","localvar":"my"},{"line":380,"kind":13,"name":"%run_id","containerName":null},{"kind":13,"line":381,"name":"$meta_name","containerName":null},{"kind":13,"line":383,"containerName":null,"definition":"my","name":"@meta","localvar":"my"},{"name":"$struc_type","containerName":null,"kind":13,"line":383},{"containerName":null,"name":"%self","line":383,"kind":13},{"kind":13,"line":384,"containerName":null,"name":"$meta_name"},{"name":"$self","containerName":null,"kind":13,"line":384},{"line":384,"kind":12,"name":"seq","containerName":"main::"},{"name":"meta_names","containerName":"main::","line":384,"kind":12},{"containerName":null,"name":"$self","line":385,"kind":13},{"containerName":"main::","name":"warn","line":385,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":388},{"name":"seq","containerName":"main::","kind":12,"line":388},{"line":388,"kind":12,"name":"named_meta","containerName":"main::"},{"line":388,"kind":13,"name":"$meta_name","containerName":null},{"containerName":null,"name":"@meta","line":388,"kind":13},{"line":391,"kind":13,"containerName":null,"name":"$self"},{"line":391,"kind":12,"containerName":"main::","name":"seq"},{"containerName":null,"name":"%self","kind":13,"line":396},{"containerName":null,"name":"%self","kind":13,"line":401},{"children":[{"kind":13,"line":405,"name":"$self","definition":"my","containerName":"_init","localvar":"my"},{"line":406,"kind":13,"name":"$self","containerName":"_init"},{"name":"url","containerName":"_init","line":406,"kind":12},{"line":406,"kind":13,"containerName":"_init","name":"$URL"},{"kind":13,"line":407,"containerName":"_init","name":"$self"},{"containerName":"_init","name":"$ANALYSIS_SPEC","kind":13,"line":407},{"kind":13,"line":408,"containerName":"_init","name":"$self"},{"kind":13,"line":408,"containerName":"_init","name":"$INPUT_SPEC"},{"containerName":"_init","name":"$self","line":409,"kind":13},{"name":"$RESULT_SPEC","containerName":"_init","line":409,"kind":13},{"kind":13,"line":410,"name":"$self","containerName":"_init"},{"name":"$ANALYSIS_NAME","containerName":"_init","line":410,"kind":13},{"kind":13,"line":411,"containerName":"_init","name":"$self"}],"line":404,"kind":12,"range":{"end":{"line":412,"character":9999},"start":{"line":404,"character":0}},"definition":"sub","name":"_init","containerName":"main::"},{"range":{"start":{"line":414,"character":0},"end":{"line":421,"character":9999}},"name":"_get_2ary_coords","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"_get_2ary_coords($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_get_2ary_coords","line":420,"kind":13},{"localvar":"my","containerName":"_get_2ary_coords","name":"@prot","definition":"my","line":421,"kind":13},{"containerName":"_get_2ary_coords","name":"$self","kind":13,"line":421}],"line":414,"kind":12},{"containerName":null,"name":"%Result","definition":"my","localvar":"my","kind":13,"line":422},{"name":"$index","definition":"my","containerName":null,"localvar":"my","kind":13,"line":423},{"line":423,"kind":13,"name":"$index","containerName":null},{"kind":12,"line":423,"name":"prot"},{"line":423,"kind":13,"name":"%index","containerName":null},{"line":425,"kind":13,"localvar":"my","containerName":null,"name":"$type","definition":"my"},{"name":"@prot","containerName":null,"line":425,"kind":13},{"line":425,"kind":13,"name":"%index","containerName":null},{"line":426,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"line":426,"name":"$type","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$length","line":427,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$j","line":428,"kind":13},{"containerName":null,"name":"$index","kind":13,"line":428},{"line":428,"kind":13,"containerName":null,"name":"$j"},{"line":428,"kind":12,"name":"prot"},{"line":428,"kind":13,"containerName":null,"name":"%j"},{"line":429,"kind":13,"localvar":"my","definition":"my","name":"$test","containerName":null},{"kind":13,"line":429,"name":"@prot","containerName":null},{"kind":13,"line":429,"name":"$j","containerName":null},{"containerName":null,"name":"%test","line":430,"kind":13},{"containerName":null,"name":"%type","kind":13,"line":430},{"name":"$length","containerName":null,"kind":13,"line":431},{"containerName":null,"name":"$length","line":432,"kind":13},{"line":432,"kind":12,"name":"MIN_STRUC_LEN"},{"line":433,"kind":13,"containerName":null,"name":"$length"},{"line":433,"kind":12,"name":"MIN_STRUC_LEN"},{"line":433,"kind":13,"name":"%type","containerName":null},{"kind":13,"line":434,"name":"%Result","containerName":null},{"line":434,"kind":13,"containerName":null,"name":"%type"},{"kind":12,"line":434,"name":"start"},{"line":434,"kind":13,"containerName":null,"name":"$index"},{"name":"end","kind":12,"line":434},{"containerName":null,"name":"$j","kind":13,"line":434},{"kind":13,"line":435,"name":"$index","containerName":null},{"kind":13,"line":435,"name":"%length","containerName":null},{"name":"$index","containerName":null,"kind":13,"line":438},{"containerName":null,"name":"$length","kind":13,"line":438},{"containerName":null,"name":"%self","kind":13,"line":443},{"line":443,"kind":13,"containerName":null,"name":"%Result"},{"children":[{"line":447,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$self"},{"kind":13,"line":448,"containerName":"_run","name":"$self"},{"name":"delay","containerName":"_run","kind":12,"line":448},{"containerName":"_run","name":"$self","line":450,"kind":13},{"containerName":"_run","name":"sleep","line":450,"kind":12},{"name":"$self","containerName":"_run","line":451,"kind":13},{"containerName":"_run","name":"status","kind":12,"line":451},{"kind":13,"line":452,"name":"$request","definition":"my","containerName":"_run","localvar":"my"},{"kind":13,"line":455,"name":"$self","containerName":"_run"},{"name":"seq","containerName":"_run","line":455,"kind":12},{"line":455,"kind":12,"containerName":"_run","name":"seq"},{"containerName":"_run","name":"$self","kind":13,"line":457},{"containerName":"_run","name":"states","kind":12,"line":457},{"line":458,"kind":13,"containerName":"_run","name":"$self"},{"name":"similarity_threshold","containerName":"_run","kind":12,"line":458},{"name":"$self","containerName":"_run","kind":13,"line":459},{"name":"window_width","containerName":"_run","kind":12,"line":459},{"localvar":"my","definition":"my","name":"$text","containerName":"_run","line":462,"kind":13},{"kind":13,"line":462,"name":"$self","containerName":"_run"},{"kind":12,"line":462,"name":"request","containerName":"_run"},{"containerName":"_run","name":"$request","line":462,"kind":13},{"name":"content","containerName":"_run","line":462,"kind":12},{"line":463,"kind":13,"containerName":"_run","name":"$self"},{"line":463,"kind":13,"name":"$text","containerName":"_run"},{"line":466,"kind":13,"localvar":"my","definition":"my","name":"$next","containerName":"_run"},{"name":"$text","containerName":"_run","kind":13,"line":466},{"localvar":"my","containerName":"_run","definition":"my","name":"$out","line":467,"kind":13},{"localvar":"my","name":"$req2","definition":"my","containerName":"_run","line":468,"kind":13},{"kind":12,"line":468,"name":"new","containerName":"_run"},{"name":"$out","containerName":"_run","kind":13,"line":468},{"localvar":"my","name":"$resp2","definition":"my","containerName":"_run","line":469,"kind":13},{"name":"$self","containerName":"_run","line":469,"kind":13},{"containerName":"_run","name":"request","kind":12,"line":469},{"containerName":"_run","name":"$req2","kind":13,"line":469},{"line":470,"kind":13,"containerName":"_run","name":"$self"},{"name":"$resp2","containerName":"_run","kind":13,"line":470},{"line":470,"kind":12,"name":"content","containerName":"_run"},{"line":471,"kind":13,"containerName":"_run","name":"$self"},{"name":"status","containerName":"_run","line":471,"kind":12},{"name":"$resp2","containerName":"_run","kind":13,"line":471},{"containerName":"_run","name":"$self","kind":13,"line":472}],"line":446,"kind":12,"range":{"start":{"character":0,"line":446},"end":{"character":9999,"line":473}},"name":"_run","definition":"sub","containerName":"main::"},{"name":"POST","line":452,"kind":12},{"name":"Content_Type","kind":12,"line":453},{"name":"Content","kind":12,"line":454},{"name":"title","line":454,"kind":12},{"line":455,"kind":12,"name":"notice"},{"name":"ali_width","kind":12,"line":456},{"kind":12,"line":457,"name":"states"},{"name":"threshold","kind":12,"line":458},{"name":"width","kind":12,"line":459},{"name":"HTTP","containerName":"Request","line":468,"kind":12},{"kind":12,"line":468,"name":"GET"},{"name":"_add_params_to_result","range":{"end":{"line":481,"character":9999},"start":{"character":0,"line":475}},"kind":12,"line":475,"children":[{"line":477,"kind":13,"localvar":"my","containerName":"_add_params_to_result","name":"$self","definition":"my"},{"containerName":"_add_params_to_result","name":"$tag_hash","line":477,"kind":13},{"localvar":"my","name":"$hash","definition":"my","containerName":"_add_params_to_result","line":478,"kind":13},{"containerName":"_add_params_to_result","name":"$hash","line":481,"kind":13},{"line":481,"kind":13,"name":"$self","containerName":"_add_params_to_result"},{"line":481,"kind":12,"name":"input_spec","containerName":"_add_params_to_result"}],"containerName":"main::","definition":"sub","detail":"($self,$tag_hash)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$tag_hash"}],"label":"_add_params_to_result($self,$tag_hash)"}},{"line":483,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$p"},{"containerName":null,"name":"%hash","line":483,"kind":13},{"name":"$self","containerName":null,"line":484,"kind":13},{"name":"$p","containerName":null,"line":484,"kind":13},{"line":484,"kind":13,"name":"$self","containerName":null},{"kind":13,"line":484,"containerName":null,"name":"$p"},{"name":"%hash","containerName":null,"line":484,"kind":13},{"kind":13,"line":484,"name":"%p","containerName":null},{"containerName":null,"name":"%tag_hash","kind":13,"line":485},{"containerName":null,"name":"$p","kind":13,"line":485},{"containerName":null,"name":"$self","line":485,"kind":13},{"kind":13,"line":485,"containerName":null,"name":"$p"}],"version":5}