{"version":5,"vars":[{"containerName":"","name":"vars","line":159,"kind":2},{"kind":2,"line":163,"name":"Common","containerName":"strict::IO::String::Bio::SeqIO::HTTP::Request"},{"name":"base","containerName":"","kind":2,"line":166},{"kind":13,"line":168,"containerName":null,"name":"$FLOAT"},{"kind":13,"line":169,"name":"@STRINGENCY","containerName":null},{"localvar":"my","definition":"my","name":"$URL","containerName":null,"line":170,"kind":13},{"kind":13,"line":173,"containerName":null,"name":"%ANALYSIS_SPEC","definition":"my","localvar":"my"},{"containerName":null,"name":"@INPUT_SPEC","definition":"my","localvar":"my","kind":13,"line":183},{"containerName":null,"definition":"my","name":"%RESULT_SPEC","localvar":"my","kind":13,"line":204},{"name":"result","range":{"start":{"line":255,"character":0},"end":{"character":9999,"line":286}},"kind":12,"line":255,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"result","line":256,"kind":13},{"kind":13,"line":256,"containerName":"result","name":"$value"},{"containerName":"result","name":"$self","kind":13,"line":257},{"kind":13,"line":257,"name":"$self","containerName":"result"},{"name":"status","containerName":"result","kind":12,"line":257},{"name":"$self","containerName":"result","line":258,"kind":13},{"name":"throw","containerName":"result","kind":12,"line":258},{"name":"@fts","definition":"my","containerName":"result","localvar":"my","kind":13,"line":260},{"name":"$value","containerName":"result","kind":13,"line":262},{"line":263,"kind":13,"name":"$value","containerName":"result"},{"localvar":"my","name":"$hit","definition":"my","containerName":"result","line":264,"kind":13},{"kind":13,"line":264,"containerName":"result","name":"$self"},{"kind":13,"line":265,"name":"@fts","containerName":"result"},{"kind":12,"line":265,"name":"new","containerName":"result"},{"line":266,"kind":13,"name":"$hit","containerName":"result"},{"line":267,"kind":13,"containerName":"result","name":"$hit"},{"name":"$hit","containerName":"result","kind":13,"line":271},{"kind":13,"line":272,"name":"$hit","containerName":"result"},{"containerName":"result","name":"$hit","line":273,"kind":13},{"name":"$hit","containerName":"result","kind":13,"line":274},{"containerName":"result","name":"$hit","kind":13,"line":275},{"line":279,"kind":13,"containerName":"result","name":"@fts"},{"kind":13,"line":281,"name":"$value","containerName":"result"},{"kind":13,"line":282,"containerName":"result","name":"$self"},{"name":"throw","containerName":"result","line":282,"kind":12},{"containerName":"result","name":"$self","kind":13,"line":285}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Scansite.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Scansite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Scansite - a wrapper around the Scansite server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Scansite;\n\n  my $seq; # a Bio::PrimarySeqI object\n\n  my $tool = Bio::Tools::Analysis::Protein::Scansite->new\n     ( -seq => $seq->primary_seq ); \n\n  # run Scansite prediction on a sequence\n  $tool->run();\n\n  # alternatively you can say\n  $tool->seq($seq->primary_seq)->run;\n\n  die \"Could not get a result\" unless $tool->status =~ /^COMPLETED/;\n\n  print $tool->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $tool->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Scansite 2.0 server which produces\npredictions for serine, threonine and tyrosine phosphorylation sites\nin eukaryotic proteins. At present this is a basic wrapper for the\n\"Scan protein by input sequence\" functionality, which takes a sequence\nand searches for motifs, with the option to select the search\nstringency. At present, searches for specific phosphorylation\nsites are not supported; all predicted sites are returned.\n\n=head2 Return formats\n\nThe Scansite results can be obtained in several formats:\n\n=over 3\n\n* 1.\n\nBy calling\n\n  my $res = $tool->result('');\n\n$res holds a string of the predicted sites in tabular format.\n\n* 2.\n\nBy calling \n\n  my $data_ref = $tool->result('value')\n\n$data_ref is a reference to an array of hashes. Each element in the\narray represents a predicted phosphorylation site. The hash keys are\nthe names of the data fields,i.e.,\n\n    'motif'      => 'Casn_Kin1'       # name of kinase\n    'percentile' => 0.155             # see Scansite docs\n    'position'   => 9                 # position in protein\n    'protein'    => 'A1'              # protein id\n    'score'      => 0.3696            # see Scansite docs\n    'sequence'   => 'ASYFDTASYFSADAT' # sequence surrounding site\n    'site'       => 'S9'              # phosphorylated residue\n    'zscore'     => '-3.110'          # see Scansite docs\n\n* 3.\n\nBy calling\n\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n\nwhich returns an array of L<Bio::SeqFeatureI> compliant objects with\nprimary tag value 'Site' and tag names of 'motif', 'score',\n'sequence', 'zscore' as above.\n\n\nSee L<http://scansite.mit.edu/>.\n\nThis inherits Bio::SimpleAnalysisI which hopefully makes it easier to\nwrite wrappers on various services. This class uses a web resource and\ntherefore inherits from L<Bio::WebAgent>.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Scansite;\nuse vars qw($FLOAT @STRINGENCY);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n$FLOAT = '[+-]?\\d*\\.\\d*';\n@STRINGENCY = qw(High Medium Low);\nmy $URL = 'http://scansite.mit.edu/cgi-bin/motifscan_seq';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'Scansite',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Massachusetts Institute of Technology',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'protein_id',\n          'default'   => 'unnamed',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'stringency',\n          'default'   => 'High',\n         },\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n         'raw'              => 'Array of {motif=>, percentile=>, position=>,\n\t\t\t\t\t  protein=>, score=>, site=>, zscore=>\n                                          sequence=>\n\t     \t\t\t\t }',\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error, the result may contain \nan error message instead of the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* 'parsed'\n\nReturns a reference to an array of hashes containing the data of one\nphosphorylation site prediction. Key values are:\n\nmotif, percentile, position, protein, score, site, zscore,  sequence.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"result($self,$value)"}},{"name":"Bio","containerName":"SeqFeature::Generic","line":265,"kind":12},{"name":"score","line":271,"kind":12},{"kind":12,"line":272,"name":"zscore"},{"line":273,"kind":12,"name":"motif"},{"name":"site","line":274,"kind":12},{"name":"sequence","line":275,"kind":12},{"name":"%self","containerName":null,"line":288,"kind":13},{"range":{"start":{"character":0,"line":300},"end":{"line":312,"character":9999}},"name":"stringency","children":[{"name":"$self","definition":"my","containerName":"stringency","localvar":"my","kind":13,"line":301},{"line":301,"kind":13,"name":"$value","containerName":"stringency"},{"name":"$value","containerName":"stringency","line":302,"kind":13},{"name":"@STRINGENCY","containerName":"stringency","line":303,"kind":13},{"containerName":"stringency","name":"$self","line":304,"kind":13},{"line":304,"kind":12,"containerName":"stringency","name":"throw"},{"containerName":"stringency","name":"@STRINGENCY","line":305,"kind":13},{"containerName":"stringency","name":"$self","kind":13,"line":308},{"containerName":"stringency","name":"$value","line":308,"kind":13},{"line":309,"kind":13,"containerName":"stringency","name":"$self"},{"containerName":"stringency","name":"$self","line":311,"kind":13},{"containerName":"stringency","name":"$self","kind":13,"line":311},{"containerName":"stringency","name":"input_spec","kind":12,"line":311}],"line":300,"kind":12,"signature":{"label":"stringency($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Scansite.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Scansite\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Richard Adams <richard.adams@ed.ac.uk>\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Scansite - a wrapper around the Scansite server\n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Analysis::Protein::Scansite;\n\n  my $seq; # a Bio::PrimarySeqI object\n\n  my $tool = Bio::Tools::Analysis::Protein::Scansite->new\n     ( -seq => $seq->primary_seq ); \n\n  # run Scansite prediction on a sequence\n  $tool->run();\n\n  # alternatively you can say\n  $tool->seq($seq->primary_seq)->run;\n\n  die \"Could not get a result\" unless $tool->status =~ /^COMPLETED/;\n\n  print $tool->result;     # print raw prediction to STDOUT\n\n  foreach my $feat ( $tool->result('Bio::SeqFeatureI') ) {\n\n      # do something to SeqFeature\n      # e.g. print as GFF\n      print $feat->gff_string, \"\\n\";\n      # or store within the sequence - if it is a Bio::RichSeqI\n      $seq->add_SeqFeature($feat);\n\n }\n\n=head1 DESCRIPTION\n\nThis class is a wrapper around the Scansite 2.0 server which produces\npredictions for serine, threonine and tyrosine phosphorylation sites\nin eukaryotic proteins. At present this is a basic wrapper for the\n\"Scan protein by input sequence\" functionality, which takes a sequence\nand searches for motifs, with the option to select the search\nstringency. At present, searches for specific phosphorylation\nsites are not supported; all predicted sites are returned.\n\n=head2 Return formats\n\nThe Scansite results can be obtained in several formats:\n\n=over 3\n\n* 1.\n\nBy calling\n\n  my $res = $tool->result('');\n\n$res holds a string of the predicted sites in tabular format.\n\n* 2.\n\nBy calling \n\n  my $data_ref = $tool->result('value')\n\n$data_ref is a reference to an array of hashes. Each element in the\narray represents a predicted phosphorylation site. The hash keys are\nthe names of the data fields,i.e.,\n\n    'motif'      => 'Casn_Kin1'       # name of kinase\n    'percentile' => 0.155             # see Scansite docs\n    'position'   => 9                 # position in protein\n    'protein'    => 'A1'              # protein id\n    'score'      => 0.3696            # see Scansite docs\n    'sequence'   => 'ASYFDTASYFSADAT' # sequence surrounding site\n    'site'       => 'S9'              # phosphorylated residue\n    'zscore'     => '-3.110'          # see Scansite docs\n\n* 3.\n\nBy calling\n\n  my @fts = $tool->Result('Bio::SeqFeatureI');\n\nwhich returns an array of L<Bio::SeqFeatureI> compliant objects with\nprimary tag value 'Site' and tag names of 'motif', 'score',\n'sequence', 'zscore' as above.\n\n\nSee L<http://scansite.mit.edu/>.\n\nThis inherits Bio::SimpleAnalysisI which hopefully makes it easier to\nwrite wrappers on various services. This class uses a web resource and\ntherefore inherits from L<Bio::WebAgent>.\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::Analysis::Protein::Scansite;\nuse vars qw($FLOAT @STRINGENCY);\nuse strict;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(POST);\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n$FLOAT = '[+-]?\\d*\\.\\d*';\n@STRINGENCY = qw(High Medium Low);\nmy $URL = 'http://scansite.mit.edu/cgi-bin/motifscan_seq';\n\n\n    my $ANALYSIS_SPEC =\n        {\n         'name'        => 'Scansite',\n         'type'        => 'Protein',\n         'version'     => '2.0',\n         'supplier'    => 'Massachusetts Institute of Technology',\n         'description' => 'Prediction of serine, threonine and tyrosine\n                             phosphorylation sites in eukaryotic proteins',\n        };\n\n    my $INPUT_SPEC =\n        [\n         {\n          'mandatory' => 'true',\n          'type'      => 'Bio::PrimarySeqI',\n          'name'      => 'seq',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'protein_id',\n          'default'   => 'unnamed',\n         },\n         {\n          'mandatory' => 'false',\n          'type'      => 'text',\n          'name'      => 'stringency',\n          'default'   => 'High',\n         },\n        ];\n\n    my $RESULT_SPEC =\n        {\n         ''                 => 'bulk',  # same as undef\n         'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n         'raw'              => 'Array of {motif=>, percentile=>, position=>,\n\t\t\t\t\t  protein=>, score=>, site=>, zscore=>\n                                          sequence=>\n\t     \t\t\t\t }',\n        };\n\n\n=head2 result\n\n Name    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : none (but an implementation may choose\n           to add arguments for instructions how to process\n           the raw result)\n\nThe method returns a scalar representing a result of an executed\njob. If the job was terminated by an error, the result may contain \nan error message instead of the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defined the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.\n\n* 'parsed'\n\nReturns a reference to an array of hashes containing the data of one\nphosphorylation site prediction. Key values are:\n\nmotif, percentile, position, protein, score, site, zscore,  sequence.\n\n\n\n\n\nsub result {\n    my ($self,$value) = @_;\n\tif( !exists($self->{'_result'}) || $self->status ne 'COMPLETED'){\n\t\t$self->throw(\"Cannot get results, analysis not run!\");\n\t\t}\t\n    my @fts;\n\n    if ($value ) {\n\t\tif ($value eq 'Bio::SeqFeatureI') {\n\t\t\tfor my $hit (@{$self->{'_parsed'}}) {\n\t\t\t\tpush @fts, Bio::SeqFeature::Generic->new(\n\t\t\t\t\t-start       => $hit->{'position'},\n\t\t\t\t\t-end         => $hit->{'position'},\n\t\t\t\t    -primary_tag => 'Site',\n\t\t\t\t\t-source      => 'Scansite',\n\t\t\t\t\t-tag => {\n\t\t\t\t\t\tscore     => $hit->{'score'},\n\t\t\t\t\t\tzscore    => $hit->{'zscore'},\n\t\t\t\t\t\tmotif     => $hit->{'motif'},\n\t\t\t\t\t\tsite      => $hit->{'site'},\n\t\t\t\t\t\tsequence  => $hit->{'sequence'},\n\t\t\t\t\t\t\t},\n\t\t\t\t);\n\t\t\t}\n\t\t\treturn @fts;\n\t\t}\n\t\telsif ($value eq 'meta') {\n\t\t\t$self->throw(\"No meta sequences available in this analysis!\");\n\t\t\t}\n\t\t## else get here\n\t\treturn $self->{'_parsed'};\n    }\n\n    return $self->{'_result'};\n}\n\n=head2  stringency\n\n Usage    : $job->stringency(...)\n Returns  : The significance stringency of a prediction\n Args     : None (retrieves value) or 'High', 'Medium' or 'Low'.\n Purpose  : Get/setter of the stringency to be sumitted for analysis."},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":328},"start":{"character":0,"line":324}},"containerName":"main::","name":"protein_id","definition":"sub","line":324,"children":[{"kind":13,"line":325,"containerName":"protein_id","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"protein_id","line":326,"kind":13},{"kind":12,"line":326,"containerName":"protein_id","name":"seq"},{"containerName":"protein_id","name":"$self","line":326,"kind":13},{"kind":12,"line":326,"containerName":"protein_id","name":"seq"},{"kind":12,"line":326,"name":"display_id","containerName":"protein_id"},{"kind":13,"line":327,"containerName":"protein_id","name":"$self"},{"containerName":"protein_id","name":"input_spec","line":327,"kind":12}],"kind":12},{"kind":12,"children":[{"kind":13,"line":332,"containerName":"_init","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"_init","kind":13,"line":333},{"kind":12,"line":333,"containerName":"_init","name":"url"},{"containerName":"_init","name":"$URL","kind":13,"line":333},{"line":334,"kind":13,"name":"$self","containerName":"_init"},{"line":334,"kind":13,"name":"$ANALYSIS_SPEC","containerName":"_init"},{"kind":13,"line":335,"containerName":"_init","name":"$self"},{"containerName":"_init","name":"$INPUT_SPEC","kind":13,"line":335},{"containerName":"_init","name":"$self","line":336,"kind":13},{"containerName":"_init","name":"$RESULT_SPEC","kind":13,"line":336},{"kind":13,"line":337,"containerName":"_init","name":"$self"},{"kind":13,"line":337,"name":"$ANALYSIS_SPEC","containerName":"_init"},{"name":"$self","containerName":"_init","line":338,"kind":13}],"line":330,"definition":"sub","name":"_init","containerName":"main::","range":{"end":{"character":9999,"line":339},"start":{"line":330,"character":0}}},{"range":{"end":{"line":405,"character":9999},"start":{"character":0,"line":341}},"definition":"sub","name":"_run","containerName":"main::","children":[{"localvar":"my","containerName":"_run","name":"$self","definition":"my","line":342,"kind":13},{"kind":13,"line":345,"name":"$self","containerName":"_run"},{"name":"delay","containerName":"_run","line":345,"kind":12},{"kind":13,"line":347,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"sleep","line":347,"kind":12},{"kind":13,"line":349,"name":"$self","containerName":"_run"},{"name":"status","containerName":"_run","line":349,"kind":12},{"line":351,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$request"},{"name":"$self","containerName":"_run","kind":13,"line":351},{"kind":12,"line":351,"containerName":"_run","name":"url"},{"line":352,"kind":13,"containerName":"_run","name":"$self"},{"kind":12,"line":352,"name":"seq","containerName":"_run"},{"line":352,"kind":12,"name":"seq","containerName":"_run"},{"kind":13,"line":353,"containerName":"_run","name":"$self"},{"line":353,"kind":12,"containerName":"_run","name":"protein_id"},{"kind":13,"line":357,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"stringency","line":357,"kind":12},{"line":362,"kind":13,"localvar":"my","containerName":"_run","name":"$content","definition":"my"},{"containerName":"_run","name":"$self","line":362,"kind":13},{"name":"request","containerName":"_run","kind":12,"line":362},{"name":"$request","containerName":"_run","line":362,"kind":13},{"line":363,"kind":13,"localvar":"my","name":"$text","definition":"my","containerName":"_run"},{"containerName":"_run","name":"$content","line":363,"kind":13},{"containerName":"_run","name":"content","kind":12,"line":363},{"kind":13,"line":366,"containerName":"_run","definition":"my","name":"@parsed_Results","localvar":"my"},{"line":367,"kind":13,"localvar":"my","definition":"my","name":"@unwantedParams","containerName":"_run"},{"definition":"my","name":"@results","containerName":"_run","localvar":"my","kind":13,"line":368},{"containerName":"_run","name":"$text","line":368,"kind":13},{"kind":13,"line":369,"name":"@results","containerName":"_run"},{"line":374,"kind":13,"localvar":"my","name":"$hit","definition":"my","containerName":"_run"},{"name":"@results","containerName":"_run","kind":13,"line":374},{"localvar":"my","containerName":"_run","name":"$res","definition":"my","line":376,"kind":13},{"name":"$hit","containerName":"_run","line":376,"kind":13},{"kind":13,"line":379,"containerName":"_run","name":"%params","definition":"my","localvar":"my"},{"line":379,"kind":13,"containerName":"_run","name":"$res"},{"kind":13,"line":382,"containerName":"_run","name":"$params"},{"containerName":"_run","name":"@unwantedParams","line":382,"kind":13},{"name":"@parsed_Results","containerName":"_run","kind":13,"line":383},{"kind":13,"line":383,"name":"%params","containerName":"_run"},{"localvar":"my","name":"$out_Str","definition":"my","containerName":"_run","line":387,"kind":13},{"containerName":"_run","name":"$out_Str","line":388,"kind":13},{"name":"$self","containerName":"_run","kind":13,"line":388},{"kind":12,"line":388,"name":"_make_header","containerName":"_run"},{"name":"@parsed_Results","containerName":"_run","line":388,"kind":13},{"name":"$out_Str","containerName":"_run","line":389,"kind":13},{"containerName":"_run","name":"$self","line":389,"kind":13},{"containerName":"_run","name":"_add_data","kind":12,"line":389},{"kind":13,"line":389,"containerName":"_run","name":"@parsed_Results"},{"name":"$self","containerName":"_run","line":392,"kind":13},{"containerName":"_run","name":"$out_Str","kind":13,"line":392},{"containerName":"_run","name":"$self","kind":13,"line":393},{"kind":13,"line":393,"containerName":"_run","name":"@parsed_Results"},{"name":"$self","containerName":"_run","line":397,"kind":13},{"name":"status","containerName":"_run","line":397,"kind":12},{"kind":13,"line":397,"name":"$text","containerName":"_run"},{"name":"@results","containerName":"_run","kind":13,"line":398},{"name":"@results","containerName":"_run","line":399,"kind":13},{"line":399,"kind":13,"containerName":"_run","name":"$text"},{"kind":13,"line":400,"name":"$text","containerName":"_run"},{"containerName":"_run","name":"$self","kind":13,"line":401},{"containerName":"_run","name":"warn","line":401,"kind":12},{"containerName":"_run","name":"$self","kind":13,"line":402},{"kind":12,"line":402,"name":"warn","containerName":"_run"},{"line":402,"kind":13,"containerName":"_run","name":"$text"}],"line":341,"kind":12},{"name":"POST","line":351,"kind":12},{"line":352,"kind":12,"name":"Content"},{"name":"sequence","line":352,"kind":12},{"name":"protein_id","kind":12,"line":353},{"line":354,"kind":12,"name":"motif_option"},{"name":"motifs","kind":12,"line":355},{"name":"motif_groups","line":356,"kind":12},{"line":357,"kind":12,"name":"stringency"},{"line":358,"kind":12,"name":"domain_flag"},{"kind":12,"line":359,"name":"submit"},{"range":{"end":{"character":9999,"line":420},"start":{"line":407,"character":0}},"name":"_process_arguments","children":[{"line":411,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_process_arguments"},{"kind":13,"line":411,"containerName":"_process_arguments","name":"$args"},{"containerName":"_process_arguments","name":"$self","kind":13,"line":413},{"containerName":"_process_arguments","name":"$args","line":413,"kind":13},{"kind":13,"line":416,"name":"$self","containerName":"_process_arguments"},{"line":416,"kind":12,"name":"throw","containerName":"_process_arguments"},{"kind":13,"line":417,"containerName":"_process_arguments","name":"$self"},{"line":417,"kind":12,"containerName":"_process_arguments","name":"seq"},{"containerName":"_process_arguments","name":"length","kind":12,"line":417},{"name":"$self","containerName":"_process_arguments","line":418,"kind":13},{"kind":12,"line":418,"name":"throw","containerName":"_process_arguments"},{"line":419,"kind":13,"containerName":"_process_arguments","name":"$self"},{"containerName":"_process_arguments","name":"seq","kind":12,"line":419},{"kind":12,"line":419,"name":"alphabet","containerName":"_process_arguments"}],"line":407,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$args"}],"documentation":"","label":"_process_arguments($self,$args)"},"detail":"($self,$args)","definition":"sub","containerName":"main::"},{"line":413,"kind":12,"containerName":"_process_arguments","name":"SUPER"},{"name":"_make_header","range":{"end":{"character":9999,"line":425},"start":{"character":0,"line":422}},"kind":12,"line":422,"children":[{"line":423,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_make_header"},{"containerName":"_make_header","name":"$res","kind":13,"line":423},{"kind":13,"line":424,"definition":"my","name":"$header","containerName":"_make_header","localvar":"my"},{"definition":"my","name":"$k","containerName":"_make_header","localvar":"my","kind":13,"line":425},{"kind":13,"line":425,"name":"$res","containerName":"_make_header"}],"containerName":"main::","definition":"sub","detail":"($self,$res)","signature":{"label":"_make_header($self,$res)","documentation":"","parameters":[{"label":"$self"},{"label":"$res"}]}},{"name":"$k","containerName":null,"line":426,"kind":13},{"name":"$header","containerName":null,"line":427,"kind":13},{"containerName":null,"name":"$k","kind":13,"line":427},{"kind":13,"line":428,"containerName":null,"name":"$header"},{"name":"$k","containerName":null,"line":428,"kind":13},{"line":430,"kind":13,"name":"$header","containerName":null},{"line":431,"kind":13,"containerName":null,"name":"$header"},{"containerName":"main::","definition":"sub","detail":"($self,$res)","signature":{"label":"_add_data($self,$res)","parameters":[{"label":"$self"},{"label":"$res"}],"documentation":""},"kind":12,"line":434,"children":[{"line":435,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_add_data"},{"name":"$res","containerName":"_add_data","kind":13,"line":435},{"definition":"my","name":"$outstr","containerName":"_add_data","localvar":"my","kind":13,"line":436},{"kind":13,"line":437,"containerName":"_add_data","definition":"my","name":"$hit","localvar":"my"},{"line":437,"kind":13,"name":"$res","containerName":"_add_data"},{"line":438,"kind":13,"localvar":"my","containerName":"_add_data","definition":"my","name":"$k"},{"containerName":"_add_data","name":"$hit","kind":13,"line":438},{"name":"$k","containerName":"_add_data","kind":13,"line":439},{"containerName":"_add_data","name":"$outstr","kind":13,"line":440},{"kind":13,"line":440,"name":"$hit","containerName":"_add_data"},{"name":"$k","containerName":"_add_data","kind":13,"line":440},{"line":441,"kind":13,"name":"$outstr","containerName":"_add_data"},{"name":"$hit","containerName":"_add_data","line":441,"kind":13},{"line":441,"kind":13,"name":"$k","containerName":"_add_data"},{"line":443,"kind":13,"name":"$outstr","containerName":"_add_data"},{"line":443,"kind":13,"name":"$hit","containerName":"_add_data"},{"line":443,"kind":13,"containerName":"_add_data","name":"$hit"},{"name":"$outstr","containerName":"_add_data","kind":13,"line":445}],"name":"_add_data","range":{"end":{"character":9999,"line":448},"start":{"character":0,"line":434}}}]}