{"vars":[{"line":153,"kind":2,"containerName":"strict::Bio::Tools::Analysis::Protein::HNN::IO::String::Bio::SeqIO::HTTP::Request","name":"Common"},{"name":"base","containerName":"","line":158,"kind":2},{"line":162,"kind":13,"localvar":"my","containerName":null,"name":"$URL","definition":"my"},{"kind":13,"line":163,"definition":"my","name":"$ANALYSIS_NAME","containerName":null,"localvar":"my"},{"kind":13,"line":164,"name":"%ANALYSIS_SPEC","definition":"my","containerName":null,"localvar":"my"},{"name":"name","line":164,"kind":12},{"line":164,"kind":12,"name":"type"},{"kind":13,"line":165,"containerName":null,"definition":"my","name":"@INPUT_SPEC","localvar":"my"},{"line":166,"kind":12,"name":"mandatory"},{"line":167,"kind":12,"name":"type"},{"localvar":"my","containerName":null,"definition":"my","name":"%RESULT_SPEC","line":171,"kind":13},{"kind":12,"line":175,"name":"raw"},{"name":"meta","kind":12,"line":176},{"containerName":"main::","name":"MIN_STRUC_LEN","definition":1,"line":178,"kind":14},{"definition":"sub","name":"_init","containerName":"main::","range":{"start":{"line":180,"character":0},"end":{"character":9999,"line":188}},"kind":12,"children":[{"line":181,"kind":13,"localvar":"my","containerName":"_init","name":"$self","definition":"my"},{"kind":13,"line":182,"containerName":"_init","name":"$self"},{"name":"url","containerName":"_init","line":182,"kind":12},{"kind":13,"line":182,"name":"$URL","containerName":"_init"},{"kind":13,"line":183,"name":"$self","containerName":"_init"},{"line":183,"kind":13,"containerName":"_init","name":"$ANALYSIS_SPEC"},{"line":184,"kind":13,"name":"$self","containerName":"_init"},{"name":"$INPUT_SPEC","containerName":"_init","line":184,"kind":13},{"kind":13,"line":185,"name":"$self","containerName":"_init"},{"kind":13,"line":185,"name":"$RESULT_SPEC","containerName":"_init"},{"line":186,"kind":13,"name":"$self","containerName":"_init"},{"containerName":"_init","name":"$ANALYSIS_NAME","line":186,"kind":13},{"line":187,"kind":13,"containerName":"_init","name":"$self"}],"line":180},{"kind":12,"children":[{"kind":13,"line":192,"containerName":"_run","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"_run","kind":13,"line":193},{"containerName":"_run","name":"delay","line":193,"kind":12},{"kind":13,"line":195,"containerName":"_run","name":"$self"},{"kind":12,"line":195,"name":"sleep","containerName":"_run"},{"containerName":"_run","name":"$self","line":196,"kind":13},{"kind":12,"line":196,"containerName":"_run","name":"status"},{"kind":13,"line":197,"containerName":"_run","definition":"my","name":"$request","localvar":"my"},{"containerName":"_run","name":"$self","line":200,"kind":13},{"kind":12,"line":200,"name":"seq","containerName":"_run"},{"line":200,"kind":12,"name":"seq","containerName":"_run"},{"containerName":"_run","definition":"my","name":"$text","localvar":"my","kind":13,"line":204},{"containerName":"_run","name":"$self","line":204,"kind":13},{"line":204,"kind":12,"containerName":"_run","name":"request"},{"containerName":"_run","name":"$request","line":204,"kind":13},{"line":204,"kind":12,"name":"content","containerName":"_run"},{"name":"$text","containerName":"_run","line":205,"kind":13},{"line":206,"kind":13,"localvar":"my","containerName":"_run","name":"$next","definition":"my"},{"kind":13,"line":206,"name":"$text","containerName":"_run"},{"kind":13,"line":207,"containerName":"_run","name":"$next"},{"line":208,"kind":13,"localvar":"my","definition":"my","name":"$out","containerName":"_run"},{"name":"$next","containerName":"_run","line":208,"kind":13},{"line":209,"kind":13,"localvar":"my","containerName":"_run","name":"$req2","definition":"my"},{"containerName":"_run","name":"new","kind":12,"line":209},{"kind":13,"line":209,"name":"$out","containerName":"_run"},{"line":210,"kind":13,"localvar":"my","containerName":"_run","definition":"my","name":"$resp2"},{"kind":13,"line":210,"name":"$self","containerName":"_run"},{"containerName":"_run","name":"request","kind":12,"line":210},{"name":"$req2","containerName":"_run","line":210,"kind":13},{"containerName":"_run","name":"$self","kind":13,"line":211},{"containerName":"_run","name":"status","kind":12,"line":211},{"name":"$resp2","containerName":"_run","line":211,"kind":13},{"containerName":"_run","name":"$self","kind":13,"line":212},{"kind":13,"line":212,"name":"$resp2","containerName":"_run"},{"line":212,"kind":12,"name":"content","containerName":"_run"},{"line":213,"kind":13,"containerName":"_run","name":"$self"}],"line":191,"name":"_run","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":191},"end":{"line":214,"character":9999}}},{"kind":12,"line":197,"name":"POST"},{"name":"Content_Type","line":198,"kind":12},{"line":199,"kind":12,"name":"Content"},{"line":199,"kind":12,"name":"title"},{"name":"notice","kind":12,"line":200},{"name":"ali_width","line":201,"kind":12},{"containerName":"Request","name":"HTTP","kind":12,"line":209},{"name":"GET","line":209,"kind":12},{"range":{"end":{"line":300,"character":9999},"start":{"line":261,"character":0}},"name":"result","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: HNN.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::HNN\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::HNN - a wrapper around the HNN protein\nsecondary structure prediction server\n\n=head1  SYNOPSIS\n\n  use\tBio::Tools::Analysis::Protein::HNN;\n  #get a Bio::Seq or Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n      (-seq=>'IKLCVHHJHJHJHJHJHJHNLAILAKAHLIELALAL',\n       -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $hnn = Bio::Tools::Analysis::Protein::HNN->new (-seq=>$seq);\n  $hnn->run;\n  print $hnn->result;# #raw text to standard error\n\n=head1  DESCRIPTION\t\n\nA module to remotely retrieve predictions of protein secondary\nstructure.  Each residue in the protein receives a score representing\nthe likelihood of existing in each of three different states (helix,\ncoil or sheet), e.g.:\n\n  my $analysis_object = Bio::Tools::SimpleAnalysis::Protein::HNN->new\n     (-seq => $seq);\n\ncreates a new object\n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output.\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method:\n\n=over 4\n\n* 1\n\nThe raw text of the program output.\n\n  my $rawdata = $analysis_object->result;\t\t\t\t\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state.\n\n  my $data_ref = $analysis_object->result('parsed');\t\t\t\t\t\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\t\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices.\n\n  my @fts = $analysis_object->result(Bio::SeqFeatureI);\n  for my $ft (@fts) {\t\t\n      print \" From \",  $ft->start, \" to  \",$ft->end, \" struc: \" ,\n             ($ft->each_tag_value('type'))[0]  ,\"\\n\";\n  }\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence In this case, the sequence can be associated with a\nsingle array of HNN prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n\n  print \"helix scores from residues 10-20 are \",\n      $meta_sequence->named_submeta_text(\"HNN_helix\",10,20), \"\\n\";\n\nMeta sequence default names are : HNN_helix, HNN_sheet, HNN_coil,\nHNN_struc, representing the scores for each residue.\n\nMany methods common to all analyses are inherited from\nL<Bio::Tools::Analysis::SimpleAnalysisBase>.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk,\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\nuse strict;\n\npackage Bio::Tools::Analysis::Protein::HNN;\n\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw (POST);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\n#extends array for 2struc.\n\nmy $URL = 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_hnn.pl';\nmy $ANALYSIS_NAME= 'HNN';\nmy $ANALYSIS_SPEC= {name => 'HNN', type => 'Protein'};\nmy $INPUT_SPEC = [\n                  { mandatory => 'true',\n                    type      => 'Bio::PrimarySeqI',\n                    'name'    => 'seq',\n                  },\n                 ];\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',  # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     raw                => '[ {helix=>, sheet=>, struc=>, coil=>}]',\n     meta               => 'Bio::Seq::Meta::Array object',\n    };\nuse constant MIN_STRUC_LEN => 3; \n\nsub _init {\n    my $self = shift;\n    $self->url($URL);\n    $self->{'_ANALYSIS_SPEC'} = $ANALYSIS_SPEC;\n    $self->{'_INPUT_SPEC'}    = $INPUT_SPEC;\n    $self->{'_RESULT_SPEC'}   = $RESULT_SPEC;\n    $self->{'_ANALYSIS_NAME'} = $ANALYSIS_NAME;\n    return $self;\n}\n\n\nsub  _run {\n    my $self  = shift;\n    $self->delay(1);\n    # delay repeated calls by default by 3 sec, set delay() to change\n    $self->sleep;\n    $self->status('TERMINATED_BY_ERROR');\n    my $request = POST 'http://npsa-pbil.ibcp.fr/cgi-bin/secpred_hnn.pl',\n        Content_Type => 'form-data',\n            Content  => [title => \"\",\n                         notice => $self->seq->seq,\n                         ali_width => 70,\n                        ];\n\n    my $text = $self->request($request)->content;\n    return unless $text;\n    my ($next) = $text =~ /Prediction.*?=(.*?)>/;\n    return unless $next;\n    my $out = \"http://npsa-pbil.ibcp.fr/\".$next;\n    my $req2 = HTTP::Request->new(GET=>$out);\n    my $resp2 = $self->request ($req2);\n\t$self->status('COMPLETED') if $resp2 ne '';\n    $self->{'_result'} = $resp2->content;\n\treturn $self;\n}\n\n\n=head2 result\n\n NAme    : result\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : see keys of $INPUT_SPEC\n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags.\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>.  Feature primary\ntag is \"2ary\".  Feature tags are \"type\" (which can be helix, sheet or\ncoil) \"method\" (HNN).\n\n* 'parsed'\n\nArray of hash references of scores/structure assignations { helix =E<gt>,\nsheet =E<gt> , coil =E<gt> , struc=E<gt>}.\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence names are HNN_helix, HNN_sheet,\nHNN_coil, HNN_struc.","label":"result($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"result","line":262,"kind":13},{"containerName":"result","name":"$value","kind":13,"line":262},{"line":264,"kind":13,"localvar":"my","definition":"my","name":"@scores","containerName":"result"},{"localvar":"my","containerName":"result","definition":"my","name":"@fts","line":265,"kind":13},{"name":"$value","containerName":"result","kind":13,"line":267},{"name":"$self","containerName":"result","line":269,"kind":13},{"localvar":"my","definition":"my","name":"$result","containerName":"result","line":270,"kind":13},{"name":"new","containerName":"result","kind":12,"line":270},{"containerName":"result","name":"$self","kind":13,"line":270},{"definition":"my","name":"$line","containerName":"result","localvar":"my","kind":13,"line":271},{"containerName":"result","name":"$result","kind":13,"line":271},{"kind":13,"line":272,"containerName":"result","name":"$line"},{"line":273,"kind":13,"containerName":"result","name":"$line"},{"kind":13,"line":274,"name":"@scores","containerName":"result"},{"name":"$self","containerName":"result","kind":13,"line":280},{"name":"@scores","containerName":"result","line":280,"kind":13},{"line":282,"kind":13,"containerName":"result","name":"$value"},{"line":283,"kind":13,"name":"$self","containerName":"result"},{"line":283,"kind":12,"name":"_get_2ary_coords","containerName":"result"},{"kind":13,"line":284,"containerName":"result","definition":"my","name":"$type","localvar":"my"},{"name":"$self","containerName":"result","line":284,"kind":13},{"kind":13,"line":285,"containerName":"result","name":"$type"},{"containerName":"result","definition":"my","name":"$loc","localvar":"my","kind":13,"line":286},{"line":286,"kind":13,"containerName":"result","name":"$self"},{"name":"$type","containerName":"result","kind":13,"line":286},{"containerName":"result","name":"@fts","kind":13,"line":287},{"containerName":"result","name":"new","kind":12,"line":288},{"kind":13,"line":288,"name":"$loc","containerName":"result"},{"name":"$loc","containerName":"result","kind":13,"line":289},{"name":"$type","containerName":"result","line":293,"kind":13},{"line":294,"kind":13,"containerName":"result","name":"$self"},{"kind":12,"line":294,"containerName":"result","name":"analysis_name"},{"kind":13,"line":298,"name":"$self","containerName":"result"},{"kind":13,"line":299,"containerName":"result","name":"@fts"}],"line":261,"kind":12},{"containerName":"String","name":"IO","kind":12,"line":270},{"name":"struc","kind":12,"line":274},{"line":275,"kind":12,"name":"helix"},{"name":"sheet","kind":12,"line":276},{"line":277,"kind":12,"name":"coil"},{"containerName":"SeqFeature::Generic","name":"Bio","kind":12,"line":287},{"kind":12,"line":293,"name":"type"},{"name":"method","line":294,"kind":12},{"kind":13,"line":302,"name":"%value","containerName":null},{"name":"%type_scores","definition":"my","containerName":null,"localvar":"my","kind":13,"line":304},{"name":"$aa","definition":"my","containerName":null,"localvar":"my","kind":13,"line":305},{"containerName":null,"name":"%self","line":305,"kind":13},{"line":306,"kind":13,"name":"%type_scores","containerName":null},{"kind":13,"line":306,"containerName":null,"name":"%aa"},{"kind":13,"line":307,"name":"%type_scores","containerName":null},{"name":"%aa","containerName":null,"line":307,"kind":13},{"kind":13,"line":308,"name":"%type_scores","containerName":null},{"line":308,"kind":13,"name":"%aa","containerName":null},{"containerName":null,"name":"%type_scores","kind":13,"line":309},{"kind":13,"line":309,"containerName":null,"name":"%aa"},{"containerName":null,"name":"$self","kind":13,"line":313},{"line":313,"kind":12,"name":"seq","containerName":"main::"},{"name":"isa","containerName":"main::","kind":12,"line":313},{"name":"$self","containerName":null,"line":314,"kind":13},{"line":314,"kind":12,"containerName":"main::","name":"seq"},{"kind":13,"line":316,"containerName":null,"name":"$self"},{"kind":12,"line":316,"name":"seq","containerName":"main::"},{"containerName":"main::","name":"isa","line":316,"kind":12},{"line":317,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":317,"containerName":"main::","name":"throw"},{"line":320,"kind":13,"containerName":null,"name":"$Bio"},{"kind":12,"line":320,"containerName":"Meta::Array::DEFAULT_NAME","name":"Seq"},{"kind":13,"line":321,"containerName":null,"definition":"my","name":"$struc_type","localvar":"my"},{"line":321,"kind":13,"name":"%type_scores","containerName":null},{"definition":"my","name":"$meta_name","containerName":null,"localvar":"my","kind":13,"line":322},{"line":323,"kind":13,"localvar":"my","name":"@meta","definition":"my","containerName":null},{"containerName":null,"name":"$struc_type","line":323,"kind":13},{"kind":13,"line":323,"name":"%self","containerName":null},{"containerName":null,"name":"$meta_name","kind":13,"line":324},{"containerName":null,"name":"$self","line":324,"kind":13},{"containerName":"main::","name":"seq","kind":12,"line":324},{"containerName":"main::","name":"meta_names","line":324,"kind":12},{"line":325,"kind":13,"containerName":null,"name":"$self"},{"name":"warn","containerName":"main::","line":325,"kind":12},{"containerName":null,"name":"$self","line":328,"kind":13},{"containerName":"main::","name":"seq","kind":12,"line":328},{"containerName":"main::","name":"named_meta","line":328,"kind":12},{"kind":13,"line":328,"containerName":null,"name":"$meta_name"},{"kind":13,"line":328,"containerName":null,"name":"@meta"},{"kind":13,"line":331,"name":"$self","containerName":null},{"kind":12,"line":331,"name":"seq","containerName":"main::"},{"name":"%self","containerName":null,"kind":13,"line":336},{"name":"%self","containerName":null,"kind":13,"line":341},{"range":{"start":{"line":345,"character":0},"end":{"character":9999,"line":352}},"name":"_get_2ary_coords","signature":{"label":"_get_2ary_coords($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"line":351,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_get_2ary_coords"},{"localvar":"my","containerName":"_get_2ary_coords","definition":"my","name":"@prot","line":352,"kind":13},{"kind":13,"line":352,"containerName":"_get_2ary_coords","name":"$self"}],"line":345,"kind":12},{"line":353,"kind":13,"localvar":"my","definition":"my","name":"%Result","containerName":null},{"kind":13,"line":354,"definition":"my","name":"$index","containerName":null,"localvar":"my"},{"kind":13,"line":354,"name":"$index","containerName":null},{"line":354,"kind":12,"name":"prot"},{"kind":13,"line":354,"containerName":null,"name":"%index"},{"localvar":"my","name":"$type","definition":"my","containerName":null,"line":355,"kind":13},{"name":"@prot","containerName":null,"line":355,"kind":13},{"containerName":null,"name":"%index","kind":13,"line":355},{"containerName":null,"name":"$type","line":356,"kind":13},{"line":357,"kind":13,"localvar":"my","definition":"my","name":"$length","containerName":null},{"line":358,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$j"},{"name":"$index","containerName":null,"kind":13,"line":358},{"line":358,"kind":13,"name":"$j","containerName":null},{"name":"prot","line":358,"kind":12},{"line":358,"kind":13,"name":"%j","containerName":null},{"localvar":"my","definition":"my","name":"$test","containerName":null,"line":359,"kind":13},{"name":"@prot","containerName":null,"kind":13,"line":359},{"line":359,"kind":13,"name":"$j","containerName":null},{"containerName":null,"name":"%test","kind":13,"line":360},{"line":360,"kind":13,"name":"%type","containerName":null},{"kind":13,"line":361,"name":"$length","containerName":null},{"line":362,"kind":13,"name":"$length","containerName":null},{"name":"MIN_STRUC_LEN","kind":12,"line":362},{"containerName":null,"name":"$length","line":363,"kind":13},{"name":"MIN_STRUC_LEN","kind":12,"line":363},{"kind":13,"line":363,"name":"%type","containerName":null},{"name":"%Result","containerName":null,"kind":13,"line":364},{"name":"%type","containerName":null,"line":364,"kind":13},{"name":"start","line":364,"kind":12},{"containerName":null,"name":"$index","line":364,"kind":13},{"line":364,"kind":12,"name":"end"},{"containerName":null,"name":"$j","kind":13,"line":364},{"containerName":null,"name":"$index","kind":13,"line":365},{"line":365,"kind":13,"containerName":null,"name":"%length"},{"containerName":null,"name":"$index","kind":13,"line":368},{"name":"$length","containerName":null,"line":368,"kind":13},{"kind":13,"line":373,"name":"%self","containerName":null},{"line":373,"kind":13,"containerName":null,"name":"%Result"}],"version":5}