{"version":5,"vars":[{"kind":2,"line":162,"name":"Common","containerName":"strict::Bio::Tools::Analysis::Protein::Domcut::IO::String::Bio::SeqIO::HTTP::Request"},{"line":166,"kind":2,"name":"base","containerName":""},{"localvar":"my","definition":"my","name":"$URL","containerName":null,"line":168,"kind":13},{"containerName":null,"name":"$ANALYSIS_NAME","definition":"my","localvar":"my","kind":13,"line":169},{"containerName":null,"name":"%ANALYSIS_SPEC","definition":"my","localvar":"my","kind":13,"line":170},{"localvar":"my","containerName":null,"definition":"my","name":"@INPUT_SPEC","line":183,"kind":13},{"line":192,"kind":13,"localvar":"my","name":"%RESULT_SPEC","definition":"my","containerName":null},{"range":{"start":{"line":241,"character":0},"end":{"line":332,"character":9999}},"name":"result","signature":{"label":"result($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Domcut.pm,v 1.0 2003/07/ 11\n#\n# BioPerl module for Bio::Tools::Analysis::Protein::Domcut\n#\n# Copyright Richard Adams\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Analysis::Protein::Domcut -  a wrapper around Domcut server\n\n=head1  SYNOPSIS\n\n  use   Bio::Tools::Analysis::Protein::Domcut;\n  #get a  Bio::PrimarySeq\n  use Bio::PrimarySeq;\n  my $seq = Bio::PrimarySeq->new\n     (-seq=>'IKLCVNLAILAKAHLIELALAL',\n     -primary_id=>'test'); # a Bio::PrimarySeqI object\n\n  my $domcut = Bio::Tools::Analysis::Protein::Domcut->new (-seq=>$seq);\n  $domcut->run;\n  print $domcut->result;# #raw text to standard out\n\n=head1  DESCRIPTION\n\nA module to remotely retrieve predictions of protein domain\nboundaries.  Each residue in the protein receives a score, those\nbetter than the significance threshold and at a local minimum receive\na rank - i.e., the best minimum is rank 1, the second best minimum is\nrank2 etc. These correspond to domain boundaries.  e.g.,\n\n  my $analysis_object = Bio::Tools::Analysis::Protein::Domcut->new\n     (-seq => $seq);\n\ncreates a new object. The sequence supplied must be a Bio::PrimarySeq and not\na Bio::Seq object. \n\n  $analysis_object->run;\n\nsubmits the query to the server and obtains raw text output\n\nGiven an amino acid sequence the results can be obtained in 4 formats,\ndetermined by the argument to the result method\n\n=over 4\n\n* 1\n\nThe raw text of the program output\n\n  my $rawdata = $analysis_object->result;\n\n* 2\n\nA reference to an array of hashes of scores for each state and the\nassigned state. Each element in the array is a residue (indexed from 0).\n\n  my $data_ref = $analysis_object->result('parsed');\n  print \"score for helix at residue 2 is $data_ref->[1]{'helix'}\\n\";\n  print \"predicted struc  at residue 2 is $data_ref->[1]{'struc}\\n\";\n\n* 3\n\nAn array of Bio::SeqFeature::Generic objects where each feature is a\npredicted unit of secondary structure. Only stretches of helix/sheet\npredictions for longer than 4 residues are defined as helices.\nSo, in order to add features to an existing Bio::Seq object;\n\n  # get a Bio::Seq object\n  my $seqobj;\n  my $tool = Bio::Tools::Analysis::Protein::Domcut->new\n      ( -seq => $seqobj->primary_seq);\n  $tool->run;\n\n  my @fts = $tool->result(Bio::SeqFeatureI);\n\n  $seqobj->add_SeqFeature(@fts);\n\n  # if you want  meta sequences as well :\n  my $meta = $tool->result('meta');\n  $seqobj->primary_seq($meta);\n\n  # can access meta data in a Bio::Seq object via a \n  # call to primary_seq:\n\n  print $seq4->primary_seq->named_submeta_text('Domcut', 1,2), \"\\n\";\n\n* 4\n\nA Bio::Seq::Meta::Array implementing sequence.\n\nThis is a Bio::Seq object that can also hold data about each residue\nin the sequence. In this case, the sequence can be associated with a\nsingle array of Domcut prediction scores.  e.g.,\n\n  my $meta_sequence = $analysis_object->result('meta');\n  print \"scores from residues 10 -20 are \",\n      $meta_sequence->submeta_text(10,20), \"\\n\";\n\nMany methods common to all analyses are inherited from\nBio::Tools::Analysis::SimpleAnalysisBase.\n\n\n=head1 SEE ALSO\n\nL<Bio::SimpleAnalysisI>, \nL<Bio::Tools::Analysis::SimpleAnalysisBase>, \nL<Bio::Seq::Meta::Array>, \nL<Bio::WebAgent>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\nRichard Adams, Richard.Adams@ed.ac.uk, \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n\nuse strict;\npackage Bio::Tools::Analysis::Protein::Domcut;\nuse IO::String;\nuse Bio::SeqIO;\nuse HTTP::Request::Common qw(GET);\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq::Meta::Array;\n\nuse base qw(Bio::Tools::Analysis::SimpleAnalysisBase);\n\nmy $URL = 'http://www.Bork.EMBL-Heidelberg.DE/Docu/mikita/domplot.cgi?';\nmy $ANALYSIS_NAME = 'Domcut';\nmy $ANALYSIS_SPEC =\n    {\n     'name'        => 'Domcut',\n     'type'        => 'protein', #compulsory entry as is used for seq checking\n     'version'     => 'n/a',\n     'supplier'    => 'Ohara lab, Laboratory of DNA technology, \n                       Kazusa DNA Research Institute, 1532-3 Yana,\n                       Kisarazu, Japan',\n     'description' => 'to predict domain boundaries in proteins',\n     'reference'   => 'Bioinformatics 19, 673-674 (2003)',\n    };\n\n\nmy $INPUT_SPEC =\n    [\n     {\n      'mandatory' => 'true',\n      'type'      => 'Bio::PrimarySeqI',\n      'name'      => 'seq',\n     },\n    ];\n\nmy  $RESULT_SPEC =\n    {\n     ''                 => 'bulk',              # same as undef\n     'Bio::SeqFeatureI' => 'ARRAY of Bio::SeqFeature::Generic',\n     'parsed'           => \"Array of {'score' =>, 'rank'=> ]\",\n     'meta'             => 'Bio::Seq::Meta::Array object'\n    };\n\n=head2 result\n\n Name    : result\n Purpose : To retrieve results of analysis in one of several formats.\n Usage   : $job->result (...)\n Returns : a result created by running an analysis\n Args    : various - see keysin $RESULT_SPEC. \n\nThe method returns a result of an executed job. If the job was\nterminated by an error the result may contain an error message instead\nof the real data.\n\nThis implementation returns differently processed data depending on\nargument:\n\n=over 3\n\n* undef\n\nReturns the raw ASCII data stream but without HTML tags\n\n* 'Bio::SeqFeatureI'\n\nThe argument string defines the type of bioperl objects returned in an\narray.  The objects are L<Bio::SeqFeature::Generic>. Tagnames are 'score' \nand 'rank'.\n\n* 'parsed'\n\nArray of array references of [score, rank].\n\n* 'all'\n\nA Bio::Seq::Meta::Array object. Scores can be accessed using methods\nfrom this class. Meta sequence name is Domcut."},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"result","line":242,"kind":13},{"kind":13,"line":242,"name":"$value","containerName":"result"},{"kind":13,"line":243,"containerName":"result","name":"@scores","definition":"my","localvar":"my"},{"localvar":"my","containerName":"result","name":"@fts","definition":"my","line":244,"kind":13},{"kind":13,"line":246,"name":"$value","containerName":"result"},{"name":"$self","containerName":"result","line":248,"kind":13},{"kind":13,"line":249,"containerName":"result","definition":"my","name":"$result","localvar":"my"},{"name":"new","containerName":"result","line":249,"kind":12},{"line":249,"kind":13,"containerName":"result","name":"$self"},{"line":250,"kind":13,"localvar":"my","definition":"my","name":"$line","containerName":"result"},{"kind":13,"line":250,"containerName":"result","name":"$result"},{"containerName":"result","name":"$line","kind":13,"line":251},{"containerName":"result","name":"$line","kind":13,"line":252},{"kind":13,"line":253,"containerName":"result","name":"@scores"},{"containerName":"result","name":"$self","kind":13,"line":258},{"containerName":"result","name":"@scores","line":258,"kind":13},{"kind":13,"line":261,"name":"$value","containerName":"result"},{"localvar":"my","definition":"my","name":"$i","containerName":"result","line":262,"kind":13},{"line":263,"kind":13,"localvar":"my","name":"$in_trough","definition":"my","containerName":"result"},{"localvar":"my","containerName":"result","definition":"my","name":"$st","line":264,"kind":13},{"kind":13,"line":264,"containerName":"result","name":"$end"},{"line":264,"kind":13,"containerName":"result","name":"$rank"},{"kind":13,"line":264,"name":"$min_score","containerName":"result"},{"name":"$min_locus","containerName":"result","kind":13,"line":264},{"definition":"my","name":"$seqlen","containerName":"result","localvar":"my","kind":13,"line":265},{"line":265,"kind":13,"name":"$self","containerName":"result"},{"containerName":"result","name":"seq","line":265,"kind":12},{"name":"length","containerName":"result","kind":12,"line":265},{"line":266,"kind":13,"localvar":"my","definition":"my","name":"$score","containerName":"result"},{"name":"$self","containerName":"result","line":266,"kind":13},{"name":"$in_trough","containerName":"result","kind":13,"line":269},{"containerName":"result","name":"$score","kind":13,"line":269},{"containerName":"result","name":"$in_trough","line":270,"kind":13},{"containerName":"result","name":"$st","kind":13,"line":271},{"containerName":"result","name":"$i","line":271,"kind":13},{"line":275,"kind":13,"name":"$in_trough","containerName":"result"},{"containerName":"result","name":"$score","kind":13,"line":275},{"line":275,"kind":13,"name":"$i","containerName":"result"},{"kind":13,"line":275,"containerName":"result","name":"$seqlen"},{"line":276,"kind":13,"name":"$score","containerName":"result"},{"containerName":"result","name":"$rank","line":277,"kind":13},{"line":277,"kind":13,"name":"$score","containerName":"result"},{"kind":13,"line":278,"containerName":"result","name":"$min_score"},{"line":278,"kind":13,"name":"$score","containerName":"result"},{"name":"$min_locus","containerName":"result","kind":13,"line":279},{"containerName":"result","name":"$i","kind":13,"line":279},{"name":"$in_trough","containerName":"result","kind":13,"line":285},{"line":285,"kind":13,"containerName":"result","name":"$score"},{"name":"$i","containerName":"result","line":286,"kind":13},{"kind":13,"line":286,"containerName":"result","name":"$seqlen"},{"line":287,"kind":13,"name":"$rank","containerName":"result"},{"line":288,"kind":13,"name":"@fts","containerName":"result"},{"name":"new","containerName":"result","line":288,"kind":12},{"containerName":"result","name":"$st","line":289,"kind":13},{"line":290,"kind":13,"name":"$i","containerName":"result"},{"name":"$min_score","containerName":"result","kind":13,"line":294},{"line":295,"kind":13,"containerName":"result","name":"$rank"},{"kind":13,"line":296,"containerName":"result","name":"$min_locus"},{"kind":13,"line":301,"name":"$st","containerName":"result"},{"line":301,"kind":13,"containerName":"result","name":"$in_trough"},{"kind":13,"line":301,"name":"$min_locus","containerName":"result"},{"name":"$min_score","containerName":"result","line":301,"kind":13},{"line":301,"kind":13,"name":"$rank","containerName":"result"},{"kind":13,"line":303,"containerName":"result","name":"$i"},{"containerName":"result","name":"@fts","kind":13,"line":305},{"kind":13,"line":308,"name":"$value","containerName":"result"},{"name":"$self","containerName":"result","kind":13,"line":311},{"name":"seq","containerName":"result","line":311,"kind":12},{"kind":12,"line":311,"containerName":"result","name":"isa"},{"name":"$self","containerName":"result","kind":13,"line":312},{"line":312,"kind":12,"containerName":"result","name":"seq"},{"kind":13,"line":314,"name":"$self","containerName":"result"},{"line":314,"kind":12,"name":"seq","containerName":"result"},{"name":"isa","containerName":"result","line":314,"kind":12},{"name":"$self","containerName":"result","line":315,"kind":13},{"name":"throw","containerName":"result","line":315,"kind":12},{"line":316,"kind":13,"localvar":"my","name":"$meta_name","definition":"my","containerName":"result"},{"kind":13,"line":319,"name":"$meta_name","containerName":"result"},{"kind":13,"line":319,"containerName":"result","name":"$self"},{"containerName":"result","name":"seq","kind":12,"line":319},{"name":"meta_names","containerName":"result","line":319,"kind":12},{"name":"$self","containerName":"result","kind":13,"line":320},{"name":"warn","containerName":"result","line":320,"kind":12},{"containerName":"result","name":"$Bio","line":325,"kind":13},{"localvar":"my","containerName":"result","name":"@meta","definition":"my","line":326,"kind":13},{"kind":13,"line":326,"name":"$self","containerName":"result"},{"line":327,"kind":13,"name":"$self","containerName":"result"},{"line":327,"kind":12,"name":"seq","containerName":"result"},{"name":"named_meta","containerName":"result","kind":12,"line":327},{"line":327,"kind":13,"containerName":"result","name":"$meta_name"},{"kind":13,"line":327,"containerName":"result","name":"@meta"},{"name":"$self","containerName":"result","kind":13,"line":330},{"kind":12,"line":330,"containerName":"result","name":"seq"}],"line":241,"kind":12},{"name":"IO","containerName":"String","kind":12,"line":249},{"kind":12,"line":253,"name":"score"},{"name":"rank","kind":12,"line":254},{"line":288,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"name":"score","line":294,"kind":12},{"name":"rank","line":295,"kind":12},{"line":296,"kind":12,"name":"residue"},{"name":"Seq","containerName":"Meta::Array::DEFAULT_NAME","line":325,"kind":12},{"line":334,"kind":13,"name":"%value","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":335},{"name":"%self","containerName":null,"kind":13,"line":339},{"kind":12,"children":[{"kind":13,"line":343,"containerName":"_init","name":"$self","definition":"my","localvar":"my"},{"containerName":"_init","name":"$self","line":344,"kind":13},{"containerName":"_init","name":"url","line":344,"kind":12},{"containerName":"_init","name":"$URL","line":344,"kind":13},{"containerName":"_init","name":"$self","line":345,"kind":13},{"name":"$ANALYSIS_SPEC","containerName":"_init","line":345,"kind":13},{"name":"$self","containerName":"_init","kind":13,"line":346},{"name":"$INPUT_SPEC","containerName":"_init","line":346,"kind":13},{"line":347,"kind":13,"containerName":"_init","name":"$self"},{"kind":13,"line":347,"containerName":"_init","name":"$RESULT_SPEC"},{"name":"$self","containerName":"_init","kind":13,"line":348},{"kind":13,"line":348,"containerName":"_init","name":"$ANALYSIS_NAME"},{"line":349,"kind":13,"containerName":"_init","name":"$self"}],"line":342,"definition":"sub","name":"_init","containerName":"main::","range":{"end":{"character":9999,"line":350},"start":{"line":342,"character":0}}},{"range":{"start":{"character":0,"line":352},"end":{"line":366,"character":9999}},"name":"_run","definition":"sub","containerName":"main::","children":[{"kind":13,"line":353,"name":"$self","definition":"my","containerName":"_run","localvar":"my"},{"definition":"my","name":"$seq_fasta","containerName":"_run","localvar":"my","kind":13,"line":354},{"kind":13,"line":354,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"seq","kind":12,"line":354},{"kind":12,"line":354,"name":"seq","containerName":"_run"},{"name":"$self","containerName":"_run","kind":13,"line":355},{"kind":12,"line":355,"name":"delay","containerName":"_run"},{"name":"$self","containerName":"_run","line":357,"kind":13},{"line":357,"kind":12,"name":"sleep","containerName":"_run"},{"line":358,"kind":13,"containerName":"_run","name":"$self"},{"containerName":"_run","name":"status","line":358,"kind":12},{"line":359,"kind":13,"localvar":"my","name":"$rqst","definition":"my","containerName":"_run"},{"kind":13,"line":359,"containerName":"_run","name":"$self"},{"kind":12,"line":359,"containerName":"_run","name":"url"},{"kind":13,"line":360,"containerName":"_run","name":"$seq_fasta"},{"kind":13,"line":362,"definition":"my","name":"$content","containerName":"_run","localvar":"my"},{"containerName":"_run","name":"$self","line":362,"kind":13},{"kind":12,"line":362,"containerName":"_run","name":"request"},{"line":362,"kind":13,"name":"$rqst","containerName":"_run"},{"definition":"my","name":"$text","containerName":"_run","localvar":"my","kind":13,"line":363},{"containerName":"_run","name":"$content","line":363,"kind":13},{"name":"content","containerName":"_run","kind":12,"line":363},{"line":364,"kind":13,"name":"$self","containerName":"_run"},{"name":"$text","containerName":"_run","kind":13,"line":364},{"line":365,"kind":13,"name":"$self","containerName":"_run"},{"line":365,"kind":12,"name":"status","containerName":"_run"},{"containerName":"_run","name":"$text","line":365,"kind":13}],"line":352,"kind":12},{"name":"GET","line":359,"kind":12}]}