{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":44},{"containerName":"Ext::Align","name":"Bio","kind":12,"line":50},{"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"kind":12,"line":56,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":57,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":57},{"line":58,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":58,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","kind":13,"line":58},{"kind":13,"line":59,"containerName":"new","name":"$self"},{"containerName":"new","name":"_initialize","line":59,"kind":12},{"line":59,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":62},{"line":63,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","line":64,"kind":13}],"name":"new","range":{"start":{"character":0,"line":56},"end":{"line":65,"character":9999}}},{"containerName":"new","name":"SUPER","line":58,"kind":12},{"range":{"start":{"character":0,"line":80},"end":{"character":9999,"line":87}},"name":"kbyte","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AlignFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Tools::AlignFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AlignFactory - Base object for alignment factories\n\n=head1 SYNOPSIS\n\nYou wont be using this as an object, but using a dervied class\nlike Bio::Tools::pSW\n\n=head1 DESCRIPTION\n\nHolds common Alignment Factory attributes in place\n\n=head1 CONTACT\n\nhttp://bio.perl.org/ or birney@sanger.ac.uk \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::AlignFactory;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tprint STDERR (\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  # set up defaults\n  \n  $self->{'kbyte'} = 20000;\n  $self->{'report'} = 0;  \n  return $self;\n}\n\n\n=head2 kbyte\n\n Title     : kbyte()\n Usage     : set/gets the amount of memory able to be used\n Function  : \n           : $factory->kbyte(200);\n           :\n Returns   : \n Argument  : memory in kilobytes","label":"kbyte($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"kbyte","line":81,"kind":13},{"line":81,"kind":13,"containerName":"kbyte","name":"$value"},{"kind":13,"line":83,"containerName":"kbyte","name":"$value"},{"name":"$self","containerName":"kbyte","kind":13,"line":84},{"name":"$value","containerName":"kbyte","line":84,"kind":13},{"kind":13,"line":86,"name":"$self","containerName":"kbyte"}],"line":80,"kind":12},{"name":"report","range":{"start":{"line":102,"character":0},"end":{"line":114,"character":9999}},"kind":12,"line":102,"children":[{"line":103,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"report"},{"name":"$value","containerName":"report","line":103,"kind":13},{"containerName":"report","name":"$value","line":106,"kind":13},{"containerName":"report","name":"$value","kind":13,"line":107},{"line":107,"kind":13,"containerName":"report","name":"$value"},{"kind":13,"line":108,"containerName":"report","name":"$self"},{"name":"throw","containerName":"report","kind":12,"line":108},{"kind":13,"line":110,"containerName":"report","name":"$self"},{"line":110,"kind":13,"containerName":"report","name":"$value"},{"line":113,"kind":13,"containerName":"report","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: AlignFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Tools::AlignFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AlignFactory - Base object for alignment factories\n\n=head1 SYNOPSIS\n\nYou wont be using this as an object, but using a dervied class\nlike Bio::Tools::pSW\n\n=head1 DESCRIPTION\n\nHolds common Alignment Factory attributes in place\n\n=head1 CONTACT\n\nhttp://bio.perl.org/ or birney@sanger.ac.uk \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::AlignFactory;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tprint STDERR (\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  # set up defaults\n  \n  $self->{'kbyte'} = 20000;\n  $self->{'report'} = 0;  \n  return $self;\n}\n\n\n=head2 kbyte\n\n Title     : kbyte()\n Usage     : set/gets the amount of memory able to be used\n Function  : \n           : $factory->kbyte(200);\n           :\n Returns   : \n Argument  : memory in kilobytes\n\n\nsub kbyte {\n    my ($self,$value) = @_;\n    \n    if( defined $value ) {\n\t$self->{'kbyte'} = $value;\n    } \n    return $self->{'kbyte'};\n}\n\n\n=head2 report\n\n Title     : report()\n Usage     : set/gets the report boolean to issue reports or not\n Function  : \n           : $factory->report(1); # reporting goes on\n           :\n Returns   : n/a\n Argument  : 1 or 0","parameters":[{"label":"$self"},{"label":"$value"}],"label":"report($self,$value)"}},{"kind":12,"children":[{"localvar":"my","containerName":"set_memory_and_report","name":"$self","definition":"my","line":129,"kind":13},{"kind":13,"line":131,"name":"$self","containerName":"set_memory_and_report"},{"kind":13,"line":132,"containerName":"set_memory_and_report","name":"$self"},{"line":132,"kind":12,"containerName":"set_memory_and_report","name":"throw"},{"line":135,"kind":13,"name":"$self","containerName":"set_memory_and_report"},{"containerName":"set_memory_and_report","name":"$self","line":137,"kind":13}],"line":128,"definition":"sub","containerName":"main::","signature":{"label":"set_memory_and_report($self)","documentation":"1;\n# $Id: AlignFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Tools::AlignFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::AlignFactory - Base object for alignment factories\n\n=head1 SYNOPSIS\n\nYou wont be using this as an object, but using a dervied class\nlike Bio::Tools::pSW\n\n=head1 DESCRIPTION\n\nHolds common Alignment Factory attributes in place\n\n=head1 CONTACT\n\nhttp://bio.perl.org/ or birney@sanger.ac.uk \n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Tools::AlignFactory;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    eval {\n\trequire Bio::Ext::Align;\n    };\n    if ( $@ ) {\n\tprint STDERR (\"\\nThe C-compiled engine for Smith Waterman alignments (Bio::Ext::Align) has not been installed.\\n Please install the bioperl-ext package\\n\\n\");\n\texit(1);\n    }\n}\n\nsub new {\n  my($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  $self->_initialize(@args);\n  # set up defaults\n  \n  $self->{'kbyte'} = 20000;\n  $self->{'report'} = 0;  \n  return $self;\n}\n\n\n=head2 kbyte\n\n Title     : kbyte()\n Usage     : set/gets the amount of memory able to be used\n Function  : \n           : $factory->kbyte(200);\n           :\n Returns   : \n Argument  : memory in kilobytes\n\n\nsub kbyte {\n    my ($self,$value) = @_;\n    \n    if( defined $value ) {\n\t$self->{'kbyte'} = $value;\n    } \n    return $self->{'kbyte'};\n}\n\n\n=head2 report\n\n Title     : report()\n Usage     : set/gets the report boolean to issue reports or not\n Function  : \n           : $factory->report(1); # reporting goes on\n           :\n Returns   : n/a\n Argument  : 1 or 0\n\n\nsub report {\n    my ($self,$value) = @_;\n    \n\n    if( defined $value ) {\n\tif( $value != 1 && $value != 0 ) {\n\t    $self->throw(\"Attempting to modify AlignFactory Report with no boolean value!\");\n\t}\n\t$self->{'report'} = $value;\n    } \n\n    return $self->{'report'};\n}\n\n=head2 set_memory_and_report\n\n Title   : set_memory_and_report\n Usage   : Only used by subclasses.\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","name":"set_memory_and_report","range":{"end":{"line":142,"character":9999},"start":{"line":128,"character":0}}},{"kind":12,"line":135,"name":"Bio","containerName":"Ext::Align::change_max_BaseMatrix_kbytes"},{"name":"Bio","containerName":"Ext::Align::error_off","line":138,"kind":12},{"name":"Bio","containerName":"Ext::Align::error_on","line":140,"kind":12}]}