{"vars":[{"name":"base","containerName":"","kind":2,"line":167},{"range":{"start":{"character":0,"line":183},"end":{"character":9999,"line":222}},"name":"new","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there"},"containerName":"main::","definition":"sub","line":183,"children":[{"line":184,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"kind":13,"line":184,"name":"@args","containerName":"new"},{"line":186,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":186},{"line":186,"kind":13,"name":"@args","containerName":"new"},{"line":187,"kind":13,"name":"$self","containerName":"new"},{"line":187,"kind":12,"name":"warn","containerName":"new"},{"line":189,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":190,"containerName":"new","name":"$self"},{"containerName":"new","name":"$self","kind":13,"line":191},{"line":192,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":193,"name":"$method","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$ranks","line":193,"kind":13},{"line":193,"kind":13,"name":"$order","containerName":"new"},{"line":193,"kind":13,"name":"$self","containerName":"new"},{"line":193,"kind":12,"name":"_rearrange","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":193},{"name":"$method","containerName":"new","line":195,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":196},{"name":"method","containerName":"new","kind":12,"line":196},{"kind":13,"line":196,"containerName":"new","name":"$method"},{"kind":13,"line":199,"containerName":"new","name":"$ranks"},{"name":"$ranks","containerName":"new","kind":13,"line":200},{"kind":13,"line":201,"name":"$self","containerName":"new"},{"name":"ranks","containerName":"new","kind":12,"line":201},{"name":"$ranks","containerName":"new","kind":13,"line":201},{"name":"$self","containerName":"new","kind":13,"line":209},{"line":209,"kind":12,"containerName":"new","name":"ranks"},{"name":"$self","containerName":"new","line":221,"kind":13}],"kind":12},{"name":"SUPER","containerName":"new","line":186,"kind":12},{"name":"_hierarchy","line":192,"kind":12},{"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj","parameters":[{"label":"$self"},{"label":"$value"}],"label":"method($self,$value)"},"containerName":"main::","definition":"sub","line":236,"children":[{"containerName":"method","name":"$self","definition":"my","localvar":"my","kind":13,"line":237},{"line":237,"kind":13,"name":"$value","containerName":"method"},{"line":238,"kind":13,"name":"$value","containerName":"method"},{"kind":13,"line":238,"containerName":"method","name":"$value"},{"containerName":"method","name":"$self","kind":13,"line":239},{"containerName":"method","name":"$value","kind":13,"line":239},{"line":241,"kind":13,"containerName":"method","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":242}},"name":"method"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object","label":"classify($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":257,"containerName":"classify","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":257,"name":"$value","containerName":"classify"},{"containerName":"classify","definition":"my","name":"@ranks","localvar":"my","kind":13,"line":258},{"containerName":"classify","name":"$value","kind":13,"line":260},{"kind":12,"line":260,"containerName":"classify","name":"isa"},{"name":"$self","containerName":"classify","line":261,"kind":13},{"kind":12,"line":261,"name":"throw","containerName":"classify"},{"containerName":"classify","definition":"my","name":"@classes","localvar":"my","kind":13,"line":264},{"name":"$value","containerName":"classify","line":264,"kind":13},{"name":"classification","containerName":"classify","kind":12,"line":264},{"name":"$self","containerName":"classify","line":266,"kind":13},{"kind":12,"line":266,"containerName":"classify","name":"method"},{"containerName":"classify","name":"$i","definition":"my","localvar":"my","kind":13,"line":267},{"containerName":"classify","name":"$i","kind":13,"line":267},{"name":"@classes","containerName":"classify","kind":13,"line":267},{"line":267,"kind":13,"name":"$i","containerName":"classify"},{"kind":13,"line":268,"containerName":"classify","name":"$ranks"},{"name":"$i","containerName":"classify","line":268,"kind":13},{"name":"$ranks","containerName":"classify","kind":13,"line":268},{"kind":13,"line":268,"containerName":"classify","name":"$i"},{"name":"$classes","containerName":"classify","kind":13,"line":268},{"kind":13,"line":268,"containerName":"classify","name":"$i"},{"containerName":"classify","name":"@ranks","kind":13,"line":270},{"containerName":"classify","name":"$classes","kind":13,"line":270},{"name":"@ranks","containerName":"classify","line":271,"kind":13},{"name":"$value","containerName":"classify","kind":13,"line":271},{"name":"binomial","containerName":"classify","kind":12,"line":271},{"kind":13,"line":272,"containerName":"classify","name":"$self"},{"name":"method","containerName":"classify","kind":12,"line":272},{"containerName":"classify","name":"@classes","kind":13,"line":273},{"containerName":"classify","name":"$self","kind":13,"line":273},{"containerName":"classify","name":"ranks","line":273,"kind":12},{"line":274,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"classify"},{"line":274,"kind":13,"containerName":"classify","name":"$i"},{"name":"@classes","containerName":"classify","kind":13,"line":274},{"kind":13,"line":274,"name":"$i","containerName":"classify"},{"kind":13,"line":275,"containerName":"classify","name":"$self"},{"line":275,"kind":12,"containerName":"classify","name":"rank_of_number"},{"kind":13,"line":275,"name":"$i","containerName":"classify"},{"line":276,"kind":13,"containerName":"classify","name":"@ranks"},{"line":276,"kind":13,"name":"$value","containerName":"classify"},{"containerName":"classify","name":"binomial","kind":12,"line":276},{"kind":13,"line":276,"containerName":"classify","name":"$self"},{"name":"rank_of_number","containerName":"classify","line":276,"kind":12},{"name":"$i","containerName":"classify","line":276,"kind":13},{"name":"@ranks","containerName":"classify","kind":13,"line":278},{"containerName":"classify","name":"$classes","kind":13,"line":278},{"kind":13,"line":278,"name":"$i","containerName":"classify"},{"name":"$self","containerName":"classify","line":278,"kind":13},{"kind":12,"line":278,"containerName":"classify","name":"rank_of_number"},{"line":278,"kind":13,"containerName":"classify","name":"$i"},{"containerName":"classify","name":"$self","line":282,"kind":13},{"kind":12,"line":282,"containerName":"classify","name":"throw"},{"kind":13,"line":284,"name":"$self","containerName":"classify"},{"kind":12,"line":284,"containerName":"classify","name":"method"},{"name":"$self","containerName":"classify","kind":13,"line":290},{"containerName":"classify","name":"throw_not_implemented","line":290,"kind":12},{"line":293,"kind":13,"name":"@ranks","containerName":"classify"}],"line":256,"name":"classify","range":{"start":{"character":0,"line":256},"end":{"line":294,"character":9999}}},{"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj","label":"level_of($self,$value)"},"containerName":"main::","definition":"sub","line":308,"children":[{"line":309,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"level_of"},{"containerName":"level_of","name":"$value","kind":13,"line":309},{"name":"$self","containerName":"level_of","line":311,"kind":13},{"containerName":"level_of","name":"$value","line":311,"kind":13}],"kind":12,"range":{"end":{"line":312,"character":9999},"start":{"character":0,"line":308}},"name":"level_of"},{"range":{"start":{"line":326,"character":0},"end":{"character":9999,"line":329}},"name":"rank_of_number","signature":{"label":"rank_of_number($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":327,"containerName":"rank_of_number","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":327,"containerName":"rank_of_number","name":"$value"},{"name":"$self","containerName":"rank_of_number","line":329,"kind":13}],"line":326,"kind":12},{"kind":13,"line":329,"name":"$value","containerName":null},{"name":"ranks","range":{"start":{"line":344,"character":0},"end":{"line":356,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@value)","signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj","parameters":[{"label":"$self"},{"label":"@value"}],"label":"ranks($self,@value)"},"kind":12,"line":344,"children":[{"kind":13,"line":345,"definition":"my","name":"$self","containerName":"ranks","localvar":"my"},{"kind":13,"line":345,"name":"@value","containerName":"ranks"},{"line":352,"kind":13,"name":"@value","containerName":"ranks"},{"containerName":"ranks","name":"$self","line":353,"kind":13},{"kind":13,"line":353,"containerName":"ranks","name":"@value"},{"kind":13,"line":356,"containerName":"ranks","definition":"my","name":"$i","localvar":"my"},{"name":"$i","containerName":"ranks","kind":13,"line":356},{"line":356,"kind":13,"name":"$self","containerName":"ranks"}]},{"kind":13,"line":356,"name":"%i","containerName":null},{"kind":13,"line":357,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":357},{"containerName":null,"name":"$i","line":357,"kind":13},{"kind":13,"line":357,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","kind":13,"line":357},{"name":"$i","containerName":null,"kind":13,"line":357},{"line":360,"kind":13,"containerName":null,"name":"%self"},{"detail":"($self,@nodes)","signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj\n\n\n\nsub ranks {\n   my ($self,@value) = @_;\n\n   # currently this makes no uniqueness sanity check (this should be done)\n   # I am think that adding a way of converting multiple 'no rank' ranks\n   # to unique 'no rank #' ranks so that the level of a 'no rank' is\n   # abstracted way from the user - I'm not sure of the value of this\n\n   if (@value) {\n      $self->{'_ranks'}=\\@value;\n   }\n\n   for (my $i=0; $i <= @{$self->{'_ranks'}}-1; $i++) {\n      $self->{'_rank_hash'}{$self->{'_ranks'}[$i]}=$i unless $self->{'_ranks'}[$i] eq 'no rank';\n   }\n\n   return @{$self->{'_ranks'}};\n}\n\n=head2 add_node\n\n  Title:    add_node\n  Usage:    $obj->add_node($node[, $node2, ...]);\n  Function: add one or more Bio::Taxonomy::Node objects\n  Returns:  None\n  Args:     any number of Bio::Taxonomy::Node(s)","parameters":[{"label":"$self"},{"label":"@nodes"}],"label":"add_node($self,@nodes)"},"containerName":"main::","definition":"sub","line":373,"children":[{"containerName":"add_node","definition":"my","name":"$self","localvar":"my","kind":13,"line":374},{"containerName":"add_node","name":"@nodes","line":374,"kind":13},{"name":"@nodes","containerName":"add_node","kind":13,"line":375},{"containerName":"add_node","name":"$self","line":376,"kind":13},{"containerName":"add_node","name":"throw","line":376,"kind":12},{"kind":12,"line":377,"name":"isa","containerName":"add_node"},{"kind":13,"line":378,"containerName":"add_node","definition":"my","name":"$node","localvar":"my"},{"name":"$rank","containerName":"add_node","kind":13,"line":378},{"kind":12,"line":378,"name":"rank","containerName":"add_node"},{"kind":13,"line":379,"name":"$self","containerName":"add_node"},{"kind":13,"line":379,"containerName":"add_node","name":"$rank"},{"name":"$self","containerName":"add_node","kind":13,"line":384},{"line":384,"kind":13,"name":"$rank","containerName":"add_node"},{"line":384,"kind":13,"containerName":"add_node","name":"$node"}],"kind":12,"range":{"start":{"character":0,"line":373},"end":{"line":386,"character":9999}},"name":"add_node"},{"name":"_hierarchy","line":379,"kind":12},{"name":"_hierarchy","kind":12,"line":384},{"containerName":"main::","name":"binomial","definition":"sub","range":{"end":{"character":9999,"line":405},"start":{"character":0,"line":399}},"kind":12,"line":399,"children":[{"kind":13,"line":400,"definition":"my","name":"$self","containerName":"binomial","localvar":"my"},{"containerName":"binomial","name":"$self","line":401,"kind":13},{"line":401,"kind":12,"name":"get_node","containerName":"binomial"},{"name":"scientific_name","containerName":"binomial","kind":12,"line":401},{"localvar":"my","containerName":"binomial","definition":"my","name":"$genus","line":402,"kind":13},{"kind":13,"line":402,"containerName":"binomial","name":"$self"},{"kind":12,"line":402,"name":"get_node","containerName":"binomial"},{"definition":"my","name":"$species","containerName":"binomial","localvar":"my","kind":13,"line":403},{"name":"$self","containerName":"binomial","kind":13,"line":403},{"containerName":"binomial","name":"get_node","line":403,"kind":12},{"line":404,"kind":13,"containerName":"binomial","name":"$species"},{"kind":13,"line":404,"name":"$genus","containerName":"binomial"}]},{"line":417,"children":[{"localvar":"my","containerName":"get_node","name":"$self","definition":"my","line":418,"kind":13},{"kind":13,"line":418,"containerName":"get_node","name":"$rank"},{"containerName":"get_node","name":"$self","line":419,"kind":13}],"kind":12,"detail":"($self,$rank)","signature":{"documentation":"1;\n# $Id: Taxonomy.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxonomy\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Juguang Xiao\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxonomy - representing Taxonomy.\n\n=head1 SYNOPSIS\n\n  # NB: This module is deprecated. Use Bio::Taxon in combination with\n  # Bio::Tree::Tree methods instead.\n\n  use Bio::Taxonomy;\n\n  # CREATION: You can either create an instance by assigning it,\n  # or fetch it through factory.\n\n  # Create the nodes first. See Bio::Taxonomy::Node for details.\n  my $node_species_sapiens = Bio::Taxonomy::Node->new(\n      -object_id => 9606, # or -ncbi_taxid. Requird tag\n      -names => {\n          'scientific' => ['sapiens'],\n          'common_name' => ['human']\n      },\n      -rank => 'species'  # Required tag\n  );\n  my $node_genus_Homo = Bio::Taxonomy::Node->new(\n      -object_id => 9605,\n      -names => { 'scientific' => ['Homo'] },\n      -rank => 'genus'\n  );\n  my $node_class_Mammalia = Bio::Taxonomy::Node->new(\n      -object_id => 40674,\n      -names => {\n          'scientific' => ['Mammalia'],\n          'common' => ['mammals']\n      },\n      -rank => 'class'\n  );\n  my $taxonomy = Bio::Taxonomy->new;\n  $taxonomy->add_node($node_class_Mammalia);\n  $taxonomy->add_node($node_species_sapiens);\n  $taxonomy->add_node($node_genus_Homo);\n\n  # OR you can fetch it through a factory implementing\n  # Bio::Taxonomy::FactoryI\n  my $factory;\n\n  my $taxonomy = $factory->fetch_by_ncbi_taxid(40674);\n\n  # USAGE\n\n  # In this case, binomial returns a defined value.\n  my $binomial = $taxonomy->binomial;\n\n  # 'common_names' refers to the lowest-rank node's common names, in\n  # array.\n  my @common_names = $taxonomy->common_names;\n\n  # 'get_node', will return undef if the rank is no defined in\n  # taxonomy object.  It will throw error if the rank string is not\n  # defined, say 'species lah'.\n  my $node = $taxonomy->get_node('class');\n  my @nodes = $taxonomy->get_all_nodes;\n\n  # Also, you can search for parent and children nodes, if taxonomy\n  # comes with factory.\n\n  my $parent_taxonomy = $taxonomy->get_parent\n\n=head1 DESCRIPTION\n\nBio::Taxonomy object represents any rank-level in taxonomy system,\nrather than Bio::Species which is able to represent only\nspecies-level.\n\nThere are two ways to create Taxonomy object, e.g.\n1) instantiate an object and assign all nodes on your own code; and\n2) fetch an object by factory.\n\n=head2 Creation by instantiation\n\nThe abstraction of Taxonomy is actually a hash in data structure\nterm. The keys of the hash are the rank names, such as 'genus' and\n'species', and the values are the instances of Bio::Taxonomy::Node.\n\n=head2 Creation by Factory fetching\n\nNCBI Taxonomy system is well accepted as the standard. The Taxonomy\nFactories in bioperl access this system, through HTTP to NCBI Entrez,\ndump file, and advanced biosql database.\n\nBio::Taxonomy::FactoryI defines all methods that all implementations\nmust obey.\n\n$factory-E<gt>fetch is a general method to fetch Taxonomy by either\nNCBI taxid or any types of names.\n\n$factory-E<gt>fetch_parent($taxonomy), returns a Taxonomy that is\none-step higher rank of the taxonomy specified as argument.\n\n$factory-E<gt>fetch_children($taxonomy), reports an array of Taxonomy\nthose are one-step lower rank of the taxonomy specified as the\nargument.\n\n=head2 Usage of Taxonomy object\n\n##\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 CONTACT\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# code begins...\n\n\npackage Bio::Taxonomy;\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy->new();\n Function: Builds a new Bio::Taxonomy object\n Returns : Bio::Taxonomy\n Args    : -method  -> method used to decide classification\n                       (none|trust|lookup)\n           -ranks   -> what ranks are there\n\n\n\nsub new {\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n   $self->warn(\"Bio::Taxonomy is deprecated. Use Bio::Taxon in combination with Bio::Tree::Tree instead.\");\n\n   $self->{'_method'}='none';\n   $self->{'_ranks'}=[];\n   $self->{'_rank_hash'}={};\n    $self->{_hierarchy} = {}; # used to store the nodes, with ranks as keys.\n   my ($method,$ranks,$order) = $self->_rearrange([qw(METHOD RANKS ORDER)], @args);\n\n   if ($method) {\n      $self->method($method);\n   }\n\n   if (defined $ranks &&\n      (ref($ranks) eq \"ARRAY\") ) {\n      $self->ranks(@$ranks);\n   } else {\n      # default ranks\n      # I think these are in the right order, but not sure:\n      # some parvorder|suborder and varietas|subspecies seem\n      # to be at the same level - any taxonomists?\n      # I don't expect that these will actually be used except as a way\n      # to find what ranks there are in taxonomic use\n      $self->ranks(('root',\n        'superkingdom', 'kingdom',\n        'superphylum', 'phylum', 'subphylum',\n        'superclass', 'class', 'subclass', 'infraclass',\n        'superorder', 'order', 'suborder', 'parvorder', 'infraorder',\n        'superfamily', 'family', 'subfamily',\n        'tribe', 'subtribe',\n        'genus', 'subgenus',\n        'species group', 'species subgroup', 'species', 'subspecies',\n        'varietas', 'forma', 'no rank'));\n   }\n\n   return $self;\n}\n\n\n=head2 method\n\n Title   : method\n Usage   : $obj = taxonomy->method($method);\n Function: set or return the method used to decide classification\n Returns : $obj\n Args    : $obj\n\n\n\nsub method {\n   my ($self,$value) = @_;\n   if (defined $value && $value=~/none|trust|lookup/) {\n       $self->{'_method'} = $value;\n   }\n   return $self->{'_method'};\n}\n\n\n=head2 classify\n\n Title   : classify\n Usage   : @obj[][0-1] = taxonomy->classify($species);\n Function: return a ranked classification\n Returns : @obj of taxa and ranks as word pairs separated by \"@\"\n Args    : Bio::Species object\n\n\n\nsub classify {\n   my ($self,$value) = @_;\n   my @ranks;\n\n   if (! $value->isa('Bio::Species') ) {\n      $self->throw(\"Trying to classify $value which is not a Bio::Species object\");\n   }\n\n   my @classes=reverse($value->classification);\n\n   if ($self->method eq 'none') {\n      for (my $i=0; $i < @classes-2; $i++) {\n         ($ranks[$i][0],$ranks[$i][1])=($classes[$i],'no rank');\n      }\n      push @ranks,[$classes[-2],'genus'];\n      push @ranks,[$value->binomial,'species'];\n   } elsif ($self->method eq 'trust') {\n      if (scalar(@classes)==scalar($self->ranks)) {\n         for (my $i=0; $i < @classes; $i++) {\n            if ($self->rank_of_number($i) eq 'species') {\n               push @ranks,[$value->binomial,$self->rank_of_number($i)];\n            } else {\n               push @ranks,[$classes[$i],$self->rank_of_number($i)];\n            }\n         }\n      } else {\n         $self->throw(\"Species object and taxonomy object cannot be reconciled\");\n      }\n   } elsif ($self->method eq 'lookup') {\n      # this will lookup a DB for the rank of a taxon name\n      # I imagine that some kind of Bio::DB class will be need to\n      # be given to the taxonomy object to act as an DB interface\n      # (I'm not sure how useful this is though - if you have a DB of\n      # taxonomy - why would you be doing things this way?)\n      $self->throw_not_implemented();\n   }\n\n   return @ranks;\n}\n\n\n=head2 level_of_rank\n\n Title   : level_of_rank\n Usage   : $obj = taxonomy->level_of_rank($obj);\n Function: returns the level of a rank name\n Returns : $obj\n Args    : $obj\n\n\n\nsub level_of {\n   my ($self,$value) = @_;\n\n   return $self->{'_rank_hash'}{$value};\n}\n\n\n=head2 rank_of_number\n\n Title   : rank_of_number\n Usage   : $obj = taxonomy->rank_of_number($obj);\n Function: returns the rank name of a rank level\n Returns : $obj\n Args    : $obj\n\n\n\nsub rank_of_number {\n   my ($self,$value) = @_;\n\n   return ${$self->{'_ranks'}}[$value];\n}\n\n\n=head2 ranks\n\n Title   : ranks\n Usage   : @obj = taxonomy->ranks(@obj);\n Function: set or return all ranks\n Returns : @obj\n Args    : @obj\n\n\n\nsub ranks {\n   my ($self,@value) = @_;\n\n   # currently this makes no uniqueness sanity check (this should be done)\n   # I am think that adding a way of converting multiple 'no rank' ranks\n   # to unique 'no rank #' ranks so that the level of a 'no rank' is\n   # abstracted way from the user - I'm not sure of the value of this\n\n   if (@value) {\n      $self->{'_ranks'}=\\@value;\n   }\n\n   for (my $i=0; $i <= @{$self->{'_ranks'}}-1; $i++) {\n      $self->{'_rank_hash'}{$self->{'_ranks'}[$i]}=$i unless $self->{'_ranks'}[$i] eq 'no rank';\n   }\n\n   return @{$self->{'_ranks'}};\n}\n\n=head2 add_node\n\n  Title:    add_node\n  Usage:    $obj->add_node($node[, $node2, ...]);\n  Function: add one or more Bio::Taxonomy::Node objects\n  Returns:  None\n  Args:     any number of Bio::Taxonomy::Node(s)\n\n\nsub add_node {\n    my ($self, @nodes) = @_;\n    foreach(@nodes){\n        $self->throw(\"A Bio::Taxonomy::Node object needed\")\n            unless($_->isa('Bio::Taxonomy::Node'));\n        my ($node, $rank) = ($_, $_->rank);\n        if(exists $self->{_hierarchy}->{$rank}){\n#            $self->throw(\"$rank has been defined\");\n#            print STDERR \"RANK:$rank\\n\";\n#            return;\n        }\n        $self->{_hierarchy}->{$rank} = $node;\n    }\n}\n\n=head2 binomial\n\n  Title   : binomial\n  Usage   : my $val = $obj->binomial;\n  Function: returns the binomial name if this taxonomy reachs species level\n  Returns : the binomial name\n            OR undef if taxonmy does not reach species level\n  Args    : [No arguments]\n\n\nsub binomial {\n    my $self = shift;\n    return $self->get_node('species')->scientific_name;\n    my $genus = $self->get_node('genus');\n    my $species = $self->get_node('species');\n    return ($species && $genus) ? \"$species $genus\" : undef;\n}\n\n=head2 get_node\n\n  Title   : get_node\n  Usage   : $node = $taxonomy->get_node('species');\n  Function: get a Bio::Taxonomy::Node object according to rank name\n  Returns : a Bio::Taxonomy::Node object or undef if null\n  Args    : a vaild rank name","parameters":[{"label":"$self"},{"label":"$rank"}],"label":"get_node($self,$rank)"},"containerName":"main::","definition":"sub","range":{"end":{"line":419,"character":9999},"start":{"line":417,"character":0}},"name":"get_node"},{"kind":12,"line":419,"name":"_hierarchy"},{"name":"$self","containerName":null,"line":420,"kind":13},{"line":420,"kind":12,"containerName":"main::","name":"throw"},{"line":422,"kind":13,"name":"%self","containerName":null},{"name":"_hierarchy","kind":12,"line":422},{"line":422,"kind":13,"containerName":null,"name":"$rank"},{"line":423,"kind":13,"name":"%self","containerName":null},{"name":"_hierarchy","kind":12,"line":423},{"containerName":null,"name":"$rank","line":423,"kind":13},{"kind":12,"children":[{"line":437,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"classification"},{"definition":"my","name":"%rank_hash","containerName":"classification","localvar":"my","kind":13,"line":438},{"name":"$self","containerName":"classification","kind":13,"line":438}],"line":436,"name":"classification","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":436},"end":{"character":9999,"line":438}}},{"kind":12,"line":438,"name":"_rank_hash"},{"kind":13,"line":439,"containerName":null,"definition":"my","name":"%hierarchy","localvar":"my"},{"name":"%self","containerName":null,"line":439,"kind":13},{"kind":12,"line":439,"name":"_hierarchy"},{"kind":13,"line":440,"name":"@ordered_nodes","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":441,"name":"%rank_hash","containerName":null},{"name":"$a","containerName":null,"line":441,"kind":13},{"kind":13,"line":441,"containerName":null,"name":"%rank_hash"},{"containerName":null,"name":"$b","line":441,"kind":13},{"kind":13,"line":442,"containerName":null,"name":"%hierarchy"},{"line":443,"kind":13,"name":"%hierarchy","containerName":null},{"kind":12,"line":443,"containerName":"main::","name":"scientific_name"},{"name":"@ordered_nodes","containerName":null,"line":443,"kind":13}],"version":5}