{"vars":[{"name":"base","containerName":"","line":154,"kind":2},{"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":181,"kind":13},{"line":181,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":182,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"kind":13,"line":182,"containerName":"new","name":"$class"},{"kind":13,"line":182,"containerName":"new","name":"@args"},{"localvar":"my","name":"$name","definition":"my","containerName":"new","line":183,"kind":13},{"kind":13,"line":183,"containerName":"new","name":"$id"},{"line":183,"kind":13,"name":"$objid","containerName":"new"},{"line":183,"kind":13,"name":"$rank","containerName":"new"},{"kind":13,"line":183,"containerName":"new","name":"$div"},{"kind":13,"line":183,"containerName":"new","name":"$dbh"},{"kind":13,"line":183,"name":"$ncbitaxid","containerName":"new"},{"containerName":"new","name":"$commonname","kind":13,"line":183},{"name":"$commonnames","containerName":"new","line":184,"kind":13},{"kind":13,"line":184,"name":"$gcode","containerName":"new"},{"name":"$mitocode","containerName":"new","kind":13,"line":184},{"containerName":"new","name":"$createdate","kind":13,"line":184},{"containerName":"new","name":"$updatedate","line":184,"kind":13},{"name":"$pubdate","containerName":"new","line":184,"kind":13},{"name":"$parent_id","containerName":"new","line":185,"kind":13},{"line":185,"kind":13,"name":"$self","containerName":"new"},{"line":185,"kind":12,"name":"_rearrange","containerName":"new"},{"line":189,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$id","line":191,"kind":13},{"name":"$ncbitaxid","containerName":"new","line":191,"kind":13},{"kind":13,"line":191,"name":"$ncbitaxid","containerName":"new"},{"name":"$id","containerName":"new","line":191,"kind":13},{"name":"$objid","containerName":"new","line":191,"kind":13},{"name":"$objid","containerName":"new","line":191,"kind":13},{"name":"$id","containerName":"new","line":191,"kind":13},{"name":"$self","containerName":"new","line":192,"kind":13},{"line":192,"kind":12,"name":"warn","containerName":"new"},{"name":"$id","containerName":"new","line":194,"kind":13},{"line":195,"kind":13,"containerName":"new","name":"$id"},{"name":"$objid","containerName":"new","kind":13,"line":195},{"containerName":"new","name":"$ncbitaxid","kind":13,"line":195},{"line":197,"kind":13,"name":"$id","containerName":"new"},{"kind":13,"line":197,"name":"$self","containerName":"new"},{"kind":12,"line":197,"containerName":"new","name":"id"},{"line":197,"kind":13,"name":"$id","containerName":"new"},{"name":"$self","containerName":"new","line":198,"kind":13},{"line":198,"kind":13,"name":"$ncbitaxid","containerName":"new"},{"containerName":"new","name":"$rank","kind":13,"line":200},{"name":"$self","containerName":"new","kind":13,"line":200},{"kind":12,"line":200,"name":"rank","containerName":"new"},{"name":"$rank","containerName":"new","line":200,"kind":13},{"kind":13,"line":201,"containerName":"new","name":"$name"},{"name":"$self","containerName":"new","kind":13,"line":201},{"name":"node_name","containerName":"new","line":201,"kind":12},{"kind":13,"line":201,"name":"$name","containerName":"new"},{"containerName":"new","definition":"my","name":"@common_names","localvar":"my","kind":13,"line":203},{"line":204,"kind":13,"name":"$commonnames","containerName":"new"},{"kind":13,"line":205,"name":"$self","containerName":"new"},{"containerName":"new","name":"throw","kind":12,"line":205},{"kind":13,"line":206,"name":"$commonnames","containerName":"new"},{"name":"$commonnames","containerName":"new","kind":13,"line":206},{"kind":13,"line":207,"containerName":"new","name":"@common_names"},{"line":207,"kind":13,"containerName":"new","name":"$commonnames"}],"line":180,"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","range":{"end":{"line":208,"character":9999},"start":{"character":0,"line":180}},"name":"new"},{"kind":12,"line":182,"containerName":"new","name":"SUPER"},{"line":198,"kind":12,"name":"_ncbi_tax_id_provided"},{"containerName":null,"name":"%commonname","line":209,"kind":13},{"containerName":null,"name":"%c_names","definition":"my","localvar":"my","kind":13,"line":210},{"containerName":null,"name":"@common_names","line":210,"kind":13},{"line":211,"kind":13,"containerName":null,"name":"%c_names"},{"line":211,"kind":13,"name":"%commonname","containerName":null},{"name":"@common_names","containerName":null,"line":212,"kind":13},{"line":212,"kind":13,"containerName":null,"name":"$commonname"},{"containerName":null,"name":"@common_names","kind":13,"line":215},{"kind":13,"line":215,"name":"$self","containerName":null},{"containerName":"main::","name":"common_names","kind":12,"line":215},{"containerName":null,"name":"@common_names","kind":13,"line":215},{"kind":13,"line":217,"name":"$gcode","containerName":null},{"line":217,"kind":13,"name":"$self","containerName":null},{"line":217,"kind":12,"containerName":"main::","name":"genetic_code"},{"line":217,"kind":13,"name":"$gcode","containerName":null},{"name":"$mitocode","containerName":null,"line":218,"kind":13},{"containerName":null,"name":"$self","line":218,"kind":13},{"kind":12,"line":218,"containerName":"main::","name":"mitochondrial_genetic_code"},{"name":"$mitocode","containerName":null,"line":218,"kind":13},{"containerName":null,"name":"$createdate","line":219,"kind":13},{"line":219,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":219,"containerName":"main::","name":"create_date"},{"line":219,"kind":13,"name":"$createdate","containerName":null},{"line":220,"kind":13,"containerName":null,"name":"$updatedate"},{"containerName":null,"name":"$self","kind":13,"line":220},{"line":220,"kind":12,"containerName":"main::","name":"update_date"},{"line":220,"kind":13,"name":"$updatedate","containerName":null},{"kind":13,"line":221,"name":"$pubdate","containerName":null},{"kind":13,"line":221,"containerName":null,"name":"$self"},{"containerName":"main::","name":"pub_date","line":221,"kind":12},{"name":"$pubdate","containerName":null,"kind":13,"line":221},{"name":"$div","containerName":null,"line":222,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":222},{"containerName":"main::","name":"division","kind":12,"line":222},{"containerName":null,"name":"$div","kind":13,"line":222},{"name":"$dbh","containerName":null,"line":223,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":223},{"kind":12,"line":223,"name":"db_handle","containerName":"main::"},{"containerName":null,"name":"$dbh","line":223,"kind":13},{"name":"$parent_id","containerName":null,"line":227,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":227},{"line":227,"kind":12,"name":"parent_id","containerName":"main::"},{"line":227,"kind":13,"containerName":null,"name":"$parent_id"},{"containerName":null,"name":"%self","kind":13,"line":231},{"name":"_root_cleanup_methods","kind":12,"line":231},{"containerName":null,"name":"$self","line":233,"kind":13},{"name":"version","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":249},"end":{"line":253,"character":9999}},"kind":12,"children":[{"line":250,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"version"},{"line":251,"kind":13,"containerName":"version","name":"$self"},{"kind":13,"line":252,"containerName":"version","name":"$self"}],"line":249},{"children":[{"containerName":"authority","definition":"my","name":"$self","localvar":"my","kind":13,"line":265},{"containerName":"authority","name":"$self","line":266,"kind":13},{"name":"$self","containerName":"authority","line":267,"kind":13}],"line":264,"kind":12,"range":{"start":{"character":0,"line":264},"end":{"line":268,"character":9999}},"name":"authority","definition":"sub","containerName":"main::"},{"line":279,"children":[{"localvar":"my","containerName":"namespace","definition":"my","name":"$self","line":280,"kind":13},{"kind":13,"line":281,"name":"$self","containerName":"namespace"},{"containerName":"namespace","name":"$self","line":282,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":279}},"containerName":"main::","definition":"sub","name":"namespace"},{"name":"db_handle","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":299},"end":{"character":9999,"line":317}},"kind":12,"children":[{"containerName":"db_handle","definition":"my","name":"$self","localvar":"my","kind":13,"line":300},{"line":302,"kind":13,"localvar":"my","containerName":"db_handle","definition":"my","name":"$db"},{"name":"$db","containerName":"db_handle","line":304,"kind":13},{"kind":13,"line":304,"name":"$db","containerName":"db_handle"},{"name":"isa","containerName":"db_handle","kind":12,"line":304},{"line":305,"kind":13,"containerName":"db_handle","name":"$self"},{"name":"throw","containerName":"db_handle","line":305,"kind":12},{"line":307,"kind":13,"containerName":"db_handle","name":"$self"},{"containerName":"db_handle","name":"$self","line":307,"kind":13},{"name":"$self","containerName":"db_handle","line":307,"kind":13},{"kind":13,"line":307,"containerName":"db_handle","name":"$db"},{"line":308,"kind":13,"localvar":"my","name":"$new_self","definition":"my","containerName":"db_handle"},{"containerName":"db_handle","name":"$self","line":308,"kind":13},{"line":308,"kind":12,"containerName":"db_handle","name":"_get_similar_taxon_from_db"},{"kind":13,"line":308,"containerName":"db_handle","name":"$self"},{"kind":13,"line":308,"containerName":"db_handle","name":"$db"},{"name":"$self","containerName":"db_handle","kind":13,"line":309},{"containerName":"db_handle","name":"_merge_taxa","line":309,"kind":12},{"line":309,"kind":13,"containerName":"db_handle","name":"$new_self"},{"line":309,"kind":13,"containerName":"db_handle","name":"$new_self"},{"name":"$self","containerName":"db_handle","kind":13,"line":314},{"kind":13,"line":314,"name":"$db","containerName":"db_handle"},{"containerName":"db_handle","name":"$self","line":316,"kind":13}],"line":299},{"line":329,"children":[{"localvar":"my","containerName":"rank","name":"$self","definition":"my","line":330,"kind":13},{"name":"$self","containerName":"rank","line":331,"kind":13},{"name":"$self","containerName":"rank","line":332,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":329},"end":{"line":333,"character":9999}},"containerName":"main::","name":"rank","definition":"sub"},{"line":346,"children":[{"line":347,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"id"},{"containerName":"id","name":"$self","kind":13,"line":348}],"kind":12,"range":{"end":{"character":9999,"line":349},"start":{"character":0,"line":346}},"containerName":"main::","definition":"sub","name":"id"},{"name":"SUPER","containerName":"id","kind":12,"line":348},{"detail":"($self,$id)","signature":{"label":"ncbi_taxid($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set"},"containerName":"main::","definition":"sub","line":365,"children":[{"line":366,"kind":13,"localvar":"my","containerName":"ncbi_taxid","definition":"my","name":"$self"},{"kind":13,"line":366,"containerName":"ncbi_taxid","name":"$id"},{"line":368,"kind":13,"containerName":"ncbi_taxid","name":"$id"},{"line":369,"kind":13,"name":"$self","containerName":"ncbi_taxid"},{"kind":13,"line":370,"name":"$self","containerName":"ncbi_taxid"},{"containerName":"ncbi_taxid","name":"$id","line":370,"kind":13},{"line":373,"kind":13,"containerName":"ncbi_taxid","name":"$self"},{"containerName":"ncbi_taxid","name":"$self","line":374,"kind":13}],"kind":12,"range":{"start":{"line":365,"character":0},"end":{"character":9999,"line":377}},"name":"ncbi_taxid"},{"name":"_ncbi_tax_id_provided","kind":12,"line":369},{"name":"SUPER","containerName":"id","line":370,"kind":12},{"name":"_ncbi_tax_id_provided","line":373,"kind":12},{"range":{"start":{"line":391,"character":0},"end":{"character":9999,"line":398}},"containerName":"main::","definition":"sub","name":"parent_id","line":391,"children":[{"localvar":"my","containerName":"parent_id","definition":"my","name":"$self","line":392,"kind":13},{"kind":13,"line":394,"name":"$self","containerName":"parent_id"},{"containerName":"parent_id","name":"warn","kind":12,"line":394},{"line":396,"kind":13,"localvar":"my","definition":"my","name":"$ancestor","containerName":"parent_id"},{"line":396,"kind":13,"containerName":"parent_id","name":"$self"},{"containerName":"parent_id","name":"ancestor","line":396,"kind":12},{"name":"$ancestor","containerName":"parent_id","line":397,"kind":13},{"line":397,"kind":12,"name":"id","containerName":"parent_id"}],"kind":12},{"kind":12,"line":392,"name":"SUPER","containerName":"id"},{"range":{"end":{"character":9999,"line":416},"start":{"character":0,"line":412}},"definition":"sub","name":"genetic_code","containerName":"main::","children":[{"line":413,"kind":13,"localvar":"my","containerName":"genetic_code","definition":"my","name":"$self"},{"name":"$self","containerName":"genetic_code","line":414,"kind":13},{"line":415,"kind":13,"containerName":"genetic_code","name":"$self"}],"line":412,"kind":12},{"children":[{"kind":13,"line":429,"definition":"my","name":"$self","containerName":"mitochondrial_genetic_code","localvar":"my"},{"kind":13,"line":430,"name":"$self","containerName":"mitochondrial_genetic_code"},{"containerName":"mitochondrial_genetic_code","name":"$self","kind":13,"line":431}],"line":428,"kind":12,"range":{"end":{"character":9999,"line":432},"start":{"line":428,"character":0}},"name":"mitochondrial_genetic_code","definition":"sub","containerName":"main::"},{"kind":12,"line":444,"children":[{"line":445,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"create_date"},{"line":446,"kind":13,"name":"$self","containerName":"create_date"},{"line":447,"kind":13,"name":"$self","containerName":"create_date"}],"containerName":"main::","definition":"sub","name":"create_date","range":{"end":{"character":9999,"line":448},"start":{"line":444,"character":0}}},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"update_date","line":461,"kind":13},{"line":462,"kind":13,"containerName":"update_date","name":"$self"},{"kind":13,"line":463,"containerName":"update_date","name":"$self"}],"line":460,"definition":"sub","name":"update_date","containerName":"main::","range":{"start":{"line":460,"character":0},"end":{"character":9999,"line":464}}},{"kind":12,"line":476,"children":[{"definition":"my","name":"$self","containerName":"pub_date","localvar":"my","kind":13,"line":477},{"containerName":"pub_date","name":"$self","line":478,"kind":13},{"line":479,"kind":13,"name":"$self","containerName":"pub_date"}],"containerName":"main::","name":"pub_date","definition":"sub","range":{"end":{"character":9999,"line":480},"start":{"line":476,"character":0}}},{"range":{"start":{"line":502,"character":0},"end":{"character":9999,"line":516}},"name":"ancestor","definition":"sub","containerName":"main::","children":[{"kind":13,"line":503,"containerName":"ancestor","definition":"my","name":"$self","localvar":"my"},{"line":504,"kind":13,"localvar":"my","containerName":"ancestor","definition":"my","name":"$ancestor"},{"name":"$self","containerName":"ancestor","kind":13,"line":504},{"containerName":"ancestor","definition":"my","name":"$dbh","localvar":"my","kind":13,"line":505},{"kind":13,"line":505,"name":"$self","containerName":"ancestor"},{"line":505,"kind":12,"containerName":"ancestor","name":"db_handle"},{"containerName":"ancestor","name":"$ancestor","line":505,"kind":13},{"line":507,"kind":13,"containerName":"ancestor","name":"$ancestor"},{"name":"$ancestor","containerName":"ancestor","line":508,"kind":13},{"containerName":"ancestor","name":"$definitely_from_dbh","definition":"my","localvar":"my","kind":13,"line":513},{"name":"$self","containerName":"ancestor","line":513,"kind":13},{"containerName":"ancestor","name":"_get_similar_taxon_from_db","kind":12,"line":513},{"line":513,"kind":13,"containerName":"ancestor","name":"$self"},{"name":"$dbh","containerName":"ancestor","line":514,"kind":13},{"line":514,"kind":12,"name":"ancestor","containerName":"ancestor"},{"containerName":"ancestor","name":"$definitely_from_dbh","line":514,"kind":13}],"line":502,"kind":12},{"line":504,"kind":12,"containerName":"ancestor","name":"SUPER"},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_Parent_Node","line":527,"kind":13},{"kind":13,"line":528,"name":"$self","containerName":"get_Parent_Node"},{"name":"warn","containerName":"get_Parent_Node","kind":12,"line":528},{"containerName":"get_Parent_Node","name":"$self","line":529,"kind":13},{"name":"ancestor","containerName":"get_Parent_Node","kind":12,"line":529}],"line":526,"definition":"sub","name":"get_Parent_Node","containerName":"main::","range":{"start":{"line":526,"character":0},"end":{"character":9999,"line":530}}},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_Children_Nodes","line":566,"kind":13},{"kind":13,"line":567,"containerName":"get_Children_Nodes","name":"$self"},{"containerName":"get_Children_Nodes","name":"warn","line":567,"kind":12},{"containerName":"get_Children_Nodes","name":"$self","kind":13,"line":568},{"line":568,"kind":12,"name":"each_Descendent","containerName":"get_Children_Nodes"}],"line":565,"kind":12,"range":{"start":{"character":0,"line":565},"end":{"character":9999,"line":569}},"definition":"sub","name":"get_Children_Nodes","containerName":"main::"},{"children":[{"definition":"my","name":"$self","containerName":"name","localvar":"my","kind":13,"line":591},{"line":591,"kind":13,"containerName":"name","name":"$name_class"},{"line":591,"kind":13,"containerName":"name","name":"@names"},{"kind":13,"line":592,"name":"$self","containerName":"name"},{"name":"throw","containerName":"name","line":592,"kind":12},{"name":"$name_class","containerName":"name","line":592,"kind":13},{"kind":13,"line":594,"name":"@names","containerName":"name"},{"kind":13,"line":595,"name":"$name_class","containerName":"name"},{"line":596,"kind":13,"containerName":"name","name":"$self"},{"name":"$name_class","containerName":"name","line":596,"kind":13},{"kind":13,"line":597,"name":"@names","containerName":"name"},{"name":"@names","containerName":"name","line":597,"kind":13},{"containerName":"name","name":"$self","line":599,"kind":13},{"kind":13,"line":599,"containerName":"name","name":"$name_class"},{"containerName":"name","name":"@names","kind":13,"line":599}],"line":590,"kind":12,"signature":{"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub ncbi_taxid {\n    my ($self, $id) = @_;\n    \n    if ($id) {\n        $self->{_ncbi_tax_id_provided} = 1;\n        return $self->SUPER::id($id);\n    }\n    \n    if ($self->{_ncbi_tax_id_provided}) {\n        return $self->SUPER::id;\n    }\n    return;\n}\n\n=head2 parent_id\n\n Title   : parent_id\n Usage   : $taxon->parent_id()\n Function: Get parent ID, (NCBI Taxonomy ID in most cases);\n           parent_taxon_id() is a synonym of this method.\n Returns : value of parent_id (a scalar)\n Args    : none\n Status  : deprecated\n\n\nsub parent_id {\n    my $self = shift;\n    if (@_) {\n        $self->warn(\"You can no longer set the parent_id - use ancestor() instead\");\n    }\n    my $ancestor = $self->ancestor() || return;\n    return $ancestor->id;\n}\n\n*parent_taxon_id = \\&parent_id;\n\n=head2 genetic_code\n\n Title   : genetic_code\n Usage   : $taxon->genetic_code($newval)\n Function: Get/set genetic code table\n Returns : value of genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub genetic_code {\n    my $self = shift;\n    return $self->{'genetic_code'} = shift if @_;\n    return $self->{'genetic_code'};\n}\n\n=head2 mitochondrial_genetic_code\n\n Title   : mitochondrial_genetic_code\n Usage   : $taxon->mitochondrial_genetic_code($newval)\n Function: Get/set mitochondrial genetic code table\n Returns : value of mitochondrial_genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub mitochondrial_genetic_code {\n    my $self = shift;\n    return $self->{'mitochondrial_genetic_code'} = shift if @_;\n    return $self->{'mitochondrial_genetic_code'};\n}\n\n=head2 create_date\n\n Title   : create_date\n Usage   : $taxon->create_date($newval)\n Function: Get/Set Date this node was created (in the database)\n Returns : value of create_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub create_date {\n    my $self = shift;\n    return $self->{'create_date'} = shift if @_;\n    return $self->{'create_date'};\n}\n\n=head2 update_date\n\n Title   : update_date\n Usage   : $taxon->update_date($newval)\n Function: Get/Set Date this node was updated (in the database)\n Returns : value of update_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub update_date {\n    my $self = shift;\n    return $self->{'update_date'} = shift if @_;\n    return $self->{'update_date'};\n}\n\n=head2 pub_date\n\n Title   : pub_date\n Usage   : $taxon->pub_date($newval)\n Function: Get/Set Date this node was published (in the database)\n Returns : value of pub_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub pub_date {\n    my $self = shift;\n    return $self->{'pub_date'} = shift if @_;\n    return $self->{'pub_date'};\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $ancestor_taxon = $taxon->ancestor()\n Function: Retrieve the ancestor taxon. Normally the database is asked what the\n           ancestor is.\n\n           If you manually set the ancestor (or you make a Bio::Tree::Tree with\n           this object as an argument to new()), the database (if any) will not\n           be used for the purposes of this method.\n\n           To restore normal database behaviour, call ancestor(undef) (which\n           would remove this object from the tree), or request this taxon again\n           as a new Taxon object from the database.\n\n Returns : Bio::Taxon\n Args    : none\n\n\nsub ancestor {\n    my $self = shift;\n    my $ancestor = $self->SUPER::ancestor(@_);\n    my $dbh = $self->db_handle || return $ancestor;\n    \n    if ($ancestor) {\n        return $ancestor;\n    }\n    else {\n        #*** could avoid the db lookup if we knew our current id was definitely\n        #    information from the db...\n        my $definitely_from_dbh = $self->_get_similar_taxon_from_db($self);\n        return $dbh->ancestor($definitely_from_dbh);\n    }\n}\n\n=head2 get_Parent_Node\n\n Title   : get_Parent_Node\n Function: Synonym of ancestor()\n Status  : deprecated\n\n\nsub get_Parent_Node {\n    my $self = shift;\n    $self->warn(\"get_Parent_Node is deprecated, use ancestor() instead\");\n    return $self->ancestor(@_);\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @taxa = $taxon->each_Descendent();\n Function: Get all the descendents for this Taxon (but not their descendents,\n           ie. not a recursive fetchall). get_Children_Nodes() is a synonym of\n           this method.\n\n           Note that this method never asks the database for the descendents;\n           it will only return objects you have manually set with\n           add_Descendent(), or where this was done for you by making a\n           Bio::Tree::Tree with this object as an argument to new().\n\n           To get the database descendents use\n           $taxon->db_handle->each_Descendent($taxon).\n\n Returns : Array of Bio::Taxon objects\n Args    : optionally, when you have set your own descendents, the string\n           \"height\", \"creation\", \"alpha\", \"revalpha\", or coderef to be used to\n           sort the order of children nodes.\n\n\n# implemented by Bio::Tree::Node\n\n=head2 get_Children_Nodes\n\n Title   : get_Children_Nodes\n Function: Synonym of each_Descendent()\n Status  : deprecated\n\n\nsub get_Children_Nodes {\n    my $self = shift;\n    $self->warn(\"get_Children_Nodes is deprecated, use each_Descendent() instead\");\n    return $self->each_Descendent(@_);\n}\n\n=head2 name\n\n  Title:    name\n  Usage:    $taxon->name('scientific', 'Homo sapiens');\n            $taxon->name('common', 'human', 'man');\n            my @names = @{$taxon->name('common')};\n  Function: Get/set the names. node_name(), scientific_name() and common_names()\n            are shorthands to name('scientific'), name('scientific') and\n            name('common') respectively.\n  Returns:  names (a array reference)\n  Args:     Arg1 => the name_class. You can assign any text, but the words\n                'scientific' and 'common' have the special meaning, as\n                scientific name and common name, respectively. 'scientific' and\n                'division' are treated specially, allowing only the first value\n                in the Arg2 list to be set.\n            Arg2 .. => list of names","parameters":[{"label":"$self"},{"label":"$name_class"},{"label":"@names"}],"label":"name($self,$name_class,@names)"},"detail":"($self,$name_class,@names)","definition":"sub","containerName":"main::","range":{"end":{"line":600,"character":9999},"start":{"line":590,"character":0}},"name":"name"},{"line":601,"kind":13,"containerName":null,"name":"%self"},{"line":601,"kind":13,"containerName":null,"name":"$name_class"},{"kind":12,"line":616,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"node_name","line":617,"kind":13},{"kind":13,"line":618,"name":"@v","definition":"my","containerName":"node_name","localvar":"my"},{"line":618,"kind":13,"name":"$self","containerName":"node_name"},{"line":618,"kind":12,"name":"name","containerName":"node_name"}],"containerName":"main::","definition":"sub","name":"node_name","range":{"start":{"line":616,"character":0},"end":{"character":9999,"line":618}}},{"kind":13,"line":619,"name":"@v","containerName":null},{"kind":12,"children":[{"kind":13,"line":637,"containerName":"common_names","name":"$self","definition":"my","localvar":"my"},{"containerName":"common_names","definition":"my","name":"@v","localvar":"my","kind":13,"line":638},{"containerName":"common_names","name":"$self","kind":13,"line":638},{"name":"name","containerName":"common_names","kind":12,"line":638}],"line":636,"name":"common_names","definition":"sub","containerName":"main::","range":{"start":{"line":636,"character":0},"end":{"line":638,"character":9999}}},{"containerName":null,"name":"@v","line":639,"kind":13},{"kind":13,"line":639,"containerName":null,"name":"@v"},{"children":[{"line":656,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"division"},{"line":657,"kind":13,"localvar":"my","definition":"my","name":"@v","containerName":"division"},{"kind":13,"line":657,"name":"$self","containerName":"division"},{"kind":12,"line":657,"name":"name","containerName":"division"}],"line":655,"kind":12,"range":{"end":{"character":9999,"line":657},"start":{"line":655,"character":0}},"definition":"sub","name":"division","containerName":"main::"},{"name":"@v","containerName":null,"kind":13,"line":658},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_get_similar_taxon_from_db","localvar":"my","kind":13,"line":665},{"name":"$taxon","containerName":"_get_similar_taxon_from_db","line":665,"kind":13},{"kind":13,"line":665,"name":"$db","containerName":"_get_similar_taxon_from_db"},{"name":"$self","containerName":"_get_similar_taxon_from_db","line":666,"kind":13},{"containerName":"_get_similar_taxon_from_db","name":"throw","kind":12,"line":666},{"kind":13,"line":666,"containerName":"_get_similar_taxon_from_db","name":"$taxon"},{"name":"$taxon","containerName":"_get_similar_taxon_from_db","kind":13,"line":666},{"line":666,"kind":12,"containerName":"_get_similar_taxon_from_db","name":"isa"},{"containerName":"_get_similar_taxon_from_db","name":"$self","kind":13,"line":667},{"containerName":"_get_similar_taxon_from_db","name":"id","line":667,"kind":12},{"name":"$self","containerName":"_get_similar_taxon_from_db","kind":13,"line":667},{"line":667,"kind":12,"containerName":"_get_similar_taxon_from_db","name":"node_name"},{"name":"$db","containerName":"_get_similar_taxon_from_db","kind":13,"line":668},{"containerName":"_get_similar_taxon_from_db","name":"$self","kind":13,"line":668},{"kind":12,"line":668,"containerName":"_get_similar_taxon_from_db","name":"db_handle"},{"kind":13,"line":670,"definition":"my","name":"$db_taxon","containerName":"_get_similar_taxon_from_db","localvar":"my"},{"line":670,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$db"},{"name":"get_taxon","containerName":"_get_similar_taxon_from_db","line":670,"kind":12},{"kind":13,"line":670,"containerName":"_get_similar_taxon_from_db","name":"$taxon"},{"kind":12,"line":670,"containerName":"_get_similar_taxon_from_db","name":"id"},{"line":670,"kind":13,"name":"$taxon","containerName":"_get_similar_taxon_from_db"},{"line":670,"kind":12,"name":"id","containerName":"_get_similar_taxon_from_db"},{"containerName":"_get_similar_taxon_from_db","name":"$db_taxon","line":671,"kind":13},{"containerName":"_get_similar_taxon_from_db","definition":"my","name":"@try_ids","localvar":"my","kind":13,"line":672},{"containerName":"_get_similar_taxon_from_db","name":"$db","kind":13,"line":672},{"containerName":"_get_similar_taxon_from_db","name":"get_taxonids","kind":12,"line":672},{"kind":13,"line":672,"name":"$taxon","containerName":"_get_similar_taxon_from_db"},{"line":672,"kind":12,"name":"node_name","containerName":"_get_similar_taxon_from_db"},{"line":672,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$taxon"},{"name":"node_name","containerName":"_get_similar_taxon_from_db","line":672,"kind":12},{"containerName":"_get_similar_taxon_from_db","definition":"my","name":"$own_rank","localvar":"my","kind":13,"line":674},{"kind":13,"line":674,"containerName":"_get_similar_taxon_from_db","name":"$taxon"},{"kind":12,"line":674,"name":"rank","containerName":"_get_similar_taxon_from_db"},{"line":675,"kind":13,"localvar":"my","name":"$try_id","definition":"my","containerName":"_get_similar_taxon_from_db"},{"kind":13,"line":675,"containerName":"_get_similar_taxon_from_db","name":"@try_ids"},{"kind":13,"line":676,"containerName":"_get_similar_taxon_from_db","name":"$try","definition":"my","localvar":"my"},{"name":"$db","containerName":"_get_similar_taxon_from_db","line":676,"kind":13},{"kind":12,"line":676,"containerName":"_get_similar_taxon_from_db","name":"get_taxon"},{"name":"$try_id","containerName":"_get_similar_taxon_from_db","kind":13,"line":676},{"line":677,"kind":13,"localvar":"my","containerName":"_get_similar_taxon_from_db","name":"$try_rank","definition":"my"},{"line":677,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$try"},{"kind":12,"line":677,"name":"rank","containerName":"_get_similar_taxon_from_db"},{"line":678,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$own_rank"},{"line":678,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$try_rank"},{"line":678,"kind":13,"name":"$own_rank","containerName":"_get_similar_taxon_from_db"},{"kind":13,"line":678,"containerName":"_get_similar_taxon_from_db","name":"$try_rank"},{"containerName":"_get_similar_taxon_from_db","name":"$db_taxon","line":679,"kind":13},{"line":679,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$try"},{"line":685,"kind":13,"containerName":"_get_similar_taxon_from_db","name":"$db_taxon"}],"line":662,"definition":"sub","containerName":"main::","signature":{"documentation":" get a node from the database that is like the supplied node","parameters":[{"label":"$self"},{"label":"$taxon"},{"label":"$db"}],"label":"_get_similar_taxon_from_db($self,$taxon,$db)"},"detail":"($self,$taxon,$db)","name":"_get_similar_taxon_from_db","range":{"start":{"character":0,"line":662},"end":{"line":686,"character":9999}}},{"line":689,"children":[{"line":690,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_merge_taxa"},{"line":690,"kind":13,"containerName":"_merge_taxa","name":"$taxon"},{"line":691,"kind":13,"name":"$self","containerName":"_merge_taxa"},{"line":691,"kind":12,"containerName":"_merge_taxa","name":"throw"},{"containerName":"_merge_taxa","name":"$taxon","kind":13,"line":691},{"containerName":"_merge_taxa","name":"$taxon","kind":13,"line":691},{"name":"isa","containerName":"_merge_taxa","kind":12,"line":691},{"line":692,"kind":13,"name":"$taxon","containerName":"_merge_taxa"},{"line":692,"kind":13,"name":"$self","containerName":"_merge_taxa"},{"localvar":"my","containerName":"_merge_taxa","name":"$attrib","definition":"my","line":694,"kind":13},{"line":695,"kind":13,"localvar":"my","containerName":"_merge_taxa","name":"$own","definition":"my"},{"kind":13,"line":695,"name":"$self","containerName":"_merge_taxa"},{"line":695,"kind":13,"name":"$attrib","containerName":"_merge_taxa"},{"line":696,"kind":13,"localvar":"my","containerName":"_merge_taxa","name":"$his","definition":"my"},{"kind":13,"line":696,"name":"$taxon","containerName":"_merge_taxa"},{"line":696,"kind":13,"containerName":"_merge_taxa","name":"$attrib"},{"name":"$own","containerName":"_merge_taxa","line":697,"kind":13},{"containerName":"_merge_taxa","name":"$his","kind":13,"line":697},{"kind":13,"line":698,"containerName":"_merge_taxa","name":"$self"},{"containerName":"_merge_taxa","name":"$attrib","line":698,"kind":13},{"containerName":"_merge_taxa","name":"$his","line":698,"kind":13},{"line":702,"kind":13,"localvar":"my","containerName":"_merge_taxa","definition":"my","name":"$own"},{"name":"$self","containerName":"_merge_taxa","line":702,"kind":13},{"containerName":"_merge_taxa","name":"rank","line":702,"kind":12},{"line":703,"kind":13,"localvar":"my","name":"$his","definition":"my","containerName":"_merge_taxa"},{"containerName":"_merge_taxa","name":"$taxon","line":703,"kind":13},{"line":703,"kind":12,"containerName":"_merge_taxa","name":"rank"},{"name":"$own","containerName":"_merge_taxa","kind":13,"line":704},{"containerName":"_merge_taxa","name":"$his","line":704,"kind":13},{"line":705,"kind":13,"name":"$self","containerName":"_merge_taxa"},{"kind":12,"line":705,"containerName":"_merge_taxa","name":"rank"},{"line":705,"kind":13,"containerName":"_merge_taxa","name":"$his"},{"localvar":"my","definition":"my","name":"%own_cnames","containerName":"_merge_taxa","line":708,"kind":13},{"line":708,"kind":13,"containerName":"_merge_taxa","name":"$self"},{"kind":12,"line":708,"name":"common_names","containerName":"_merge_taxa"},{"line":709,"kind":13,"localvar":"my","definition":"my","name":"%his_cnames","containerName":"_merge_taxa"},{"containerName":"_merge_taxa","name":"$taxon","line":709,"kind":13},{"containerName":"_merge_taxa","name":"common_names","kind":12,"line":709},{"containerName":"_merge_taxa","name":"%his_cnames","line":710,"kind":13},{"name":"$own_cnames","containerName":"_merge_taxa","kind":13,"line":711},{"line":712,"kind":13,"name":"$self","containerName":"_merge_taxa"},{"containerName":"_merge_taxa","name":"common_names","kind":12,"line":712}],"kind":12,"detail":"($self,$taxon)","signature":{"label":"_merge_taxa($self,$taxon)","parameters":[{"label":"$self"},{"label":"$taxon"}],"documentation":" merge data from supplied Taxon into self"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":689},"end":{"character":9999,"line":717}},"name":"_merge_taxa"},{"kind":12,"line":730,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"remove_Descendent","line":733,"kind":13},{"line":733,"kind":13,"name":"@nodes","containerName":"remove_Descendent"},{"localvar":"my","containerName":"remove_Descendent","name":"$c","definition":"my","line":734,"kind":13},{"name":"$n","definition":"my","containerName":"remove_Descendent","localvar":"my","kind":13,"line":735},{"kind":13,"line":735,"name":"@nodes","containerName":"remove_Descendent"},{"line":736,"kind":13,"containerName":"remove_Descendent","name":"$self"},{"containerName":"remove_Descendent","name":"$n","kind":13,"line":736},{"kind":12,"line":736,"name":"internal_id","containerName":"remove_Descendent"},{"line":737,"kind":13,"name":"$self","containerName":"remove_Descendent"},{"kind":13,"line":738,"containerName":"remove_Descendent","name":"$n"},{"kind":12,"line":738,"name":"ancestor","containerName":"remove_Descendent"},{"line":739,"kind":13,"containerName":"remove_Descendent","name":"$self"},{"name":"$self","containerName":"remove_Descendent","line":740,"kind":13},{"containerName":"remove_Descendent","name":"$n","line":740,"kind":13},{"name":"internal_id","containerName":"remove_Descendent","kind":12,"line":740},{"line":740,"kind":12,"name":"ancestor","containerName":"remove_Descendent"},{"name":"$self","containerName":"remove_Descendent","line":741,"kind":13},{"containerName":"remove_Descendent","name":"$n","line":741,"kind":13},{"kind":12,"line":741,"name":"internal_id","containerName":"remove_Descendent"},{"name":"$c","containerName":"remove_Descendent","kind":13,"line":742},{"kind":13,"line":745,"name":"$c","containerName":"remove_Descendent"}],"containerName":"main::","definition":"sub","detail":"($self,@nodes)","signature":{"label":"remove_Descendent($self,@nodes)","parameters":[{"label":"$self"},{"label":"@nodes"}],"documentation":"1;\n# $Id: Taxon.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Taxon\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala, based heavily on a module by Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Taxon - A node in a represented taxonomy\n\n=head1 SYNOPSIS\n\n  use Bio::Taxon;\n\n  # Typically you will get a Taxon from a Bio::DB::Taxonomy object\n  # but here is how you initialize one\n  my $taxon = Bio::Taxon->new(-name      => $name,\n                             -id        => $id,\n                             -rank      => $rank,\n                             -division  => $div);\n\n  # Get one from a database\n  my $dbh = Bio::DB::Taxonomy->new(-source   => 'flatfile',\n                                  -directory=> '/tmp',\n                                  -nodesfile=> '/path/to/nodes.dmp',\n                                  -namesfile=> '/path/to/names.dmp');\n  my $human = $dbh->get_taxon(-name => 'Homo sapiens');\n  $human = $dbh->get_taxon(-taxonid => '9606');\n\n  print \"id is \", $human->id, \"\\n\"; # 9606\n  print \"rank is \", $human->rank, \"\\n\"; # species\n  print \"scientific name is \", $human->scientific_name, \"\\n\"; # Homo sapiens\n  print \"division is \", $human->division, \"\\n\"; # Primates\n\n  my $mouse = $dbh->get_taxon(-name => 'Mus musculus');\n\n  # You can quickly make your own lineages with the list database\n  my @ranks = qw(superkingdom class genus species);\n  my @h_lineage = ('Eukaryota', 'Mammalia', 'Homo', 'Homo sapiens');\n  my $list_dbh = Bio::DB::Taxonomy->new(-source => 'list', -names => \\@h_lineage,\n                                                          -ranks => \\@ranks);\n  $human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my @names = $human->common_names; # @names is empty\n  $human->common_names('woman');\n  @names = $human->common_names; # @names contains woman\n\n  # You can switch to another database when you need more information\n  my $entrez_dbh = Bio::DB::Taxonomy->new(-source => 'entrez');\n  $human->db_handle($entrez_dbh);\n  @names = $human->common_names; # @names contains woman, human, man\n\n  # Since Bio::Taxon implements Bio::Tree::NodeI, we have access to those\n  # methods (and can manually create our own taxa and taxonomy without the use\n  # of any database)\n  my $homo = $human->ancestor;\n\n  # Though be careful with each_Descendent - unless you add_Descendent()\n  # yourself, you won't get an answer because unlike for ancestor(), Bio::Taxon\n  # does not ask the database for the answer. You can ask the database yourself\n  # using the same method:\n  ($human) = $homo->db_handle->each_Descendent($homo);\n\n  # We can also take advantage of Bio::Tree::Tree* methods:\n  # a) some methods are available with just an empty tree object\n  use Bio::Tree::Tree;\n  my $tree_functions = Bio::Tree::Tree->new();\n  my @lineage = $tree_functions->get_lineage_nodes($human);\n  my $lca = $tree_functions->get_lca($human, $mouse);\n\n  # b) for other methods, create a tree using your Taxon object\n  my $tree = Bio::Tree::Tree->new(-node => $human);\n  my @taxa = $tree->get_nodes;\n  $homo = $tree->find_node(-rank => 'genus');\n\n  # Normally you can't get the lca of a list-database derived Taxon and an\n  # entrez or flatfile-derived one because the two different databases might\n  # have different roots and different numbers of ranks between the root and the\n  # taxa of interest. To solve this, make a tree of the Taxon with the more\n  # detailed lineage and splice out all the taxa that won't be in the lineage of\n  # your other Taxon:\n  my $entrez_mouse = $entrez_dbh->get_taxon(-name => 'Mus musculus');\n  my $list_human = $list_dbh->get_taxon(-name => 'Homo sapiens');\n  my $mouse_tree = Bio::Tree::Tree->new(-node => $entrez_mouse);\n  $mouse_tree->splice(-keep_rank => \\@ranks);\n  $lca = $mouse_tree->get_lca($entrez_mouse, $list_human);\n\n=head1 DESCRIPTION\n\nThis is the next generation (for Bioperl) of representing Taxonomy\ninformation. Previously all information was managed by a single\nobject called Bio::Species. This new implementation allows\nrepresentation of the intermediate nodes not just the species nodes\nand can relate their connections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nJason Stajich,    jason-at-bioperl-dot-org (original Bio::Taxonomy::Node)\nJuguang Xiao,     juguang@tll.org.sg\nGabriel Valiente, valiente@lsi.upc.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Taxon;\nuse strict;\n\nuse Bio::DB::Taxonomy;\n\nuse base qw(Bio::Tree::Node Bio::IdentifiableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Taxonomy::Node->new();\n Function: Builds a new Bio::Taxonomy::Node object \n Returns : an instance of Bio::Taxonomy::Node\n Args    : -dbh               => a reference to a Bio::DB::Taxonomy object\n                                 [no default]\n           -name              => a string representing the taxon name\n                                 (scientific name)\n           -id                => human readable id - typically NCBI taxid\n           -ncbi_taxid        => same as -id, but explicitely say that it is an\n                                 NCBI taxid\n           -rank              => node rank (one of 'species', 'genus', etc)\n           -common_names      => array ref of all common names\n           -division          => 'Primates', 'Rodents', etc\n           -genetic_code      => genetic code table number\n           -mito_genetic_code => mitochondrial genetic code table number\n           -create_date       => date created in database\n           -update_date       => date last updated in database\n           -pub_date          => date published in database\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($name, $id, $objid, $rank, $div, $dbh, $ncbitaxid, $commonname,\n        $commonnames, $gcode, $mitocode, $createdate, $updatedate, $pubdate,\n        $parent_id) = $self->_rearrange([qw(NAME ID OBJECT_ID RANK DIVISION DBH\n                                            NCBI_TAXID COMMON_NAME COMMON_NAMES\n                                            GENETIC_CODE MITO_GENETIC_CODE\n                                            CREATE_DATE UPDATE_DATE PUB_DATE\n                                            PARENT_ID)], @args);\n    \n    if (defined $id && (defined $ncbitaxid && $ncbitaxid ne $id || defined $objid && $objid ne $id)) {\n        $self->warn(\"Only provide one of -id, -object_id or -ncbi_taxid, using $id\\n\");\n    }\n    elsif(!defined $id) { \n        $id = $objid || $ncbitaxid;\n    }\n    defined $id && $self->id($id);\n    $self->{_ncbi_tax_id_provided} = 1 if $ncbitaxid;\n    \n    defined $rank && $self->rank($rank);\n    defined $name && $self->node_name($name);\n    \n    my @common_names;\n    if ($commonnames) {\n        $self->throw(\"-common_names takes only an array reference\") unless $commonnames\n            && ref($commonnames) eq 'ARRAY';\n        @common_names = @{$commonnames};\n    }\n    if ($commonname) {\n        my %c_names = map { $_ => 1 } @common_names;\n        unless (exists $c_names{$commonname}) {\n            unshift(@common_names, $commonname);\n        }\n    }\n    @common_names > 0 && $self->common_names(@common_names);\n    \n    defined $gcode      && $self->genetic_code($gcode);\n    defined $mitocode   && $self->mitochondrial_genetic_code($mitocode);\n    defined $createdate && $self->create_date($createdate);\n    defined $updatedate && $self->update_date($updatedate);\n    defined $pubdate    && $self->pub_date($pubdate);\n    defined $div        && $self->division($div);\n    defined $dbh        && $self->db_handle($dbh);\n    \n    # deprecated and will issue a warning when method called,\n    # eventually to be removed completely as option\n    defined $parent_id  && $self->parent_id($parent_id);\n    \n    # some things want to freeze/thaw Bio::Species objects, but\n    # _root_cleanup_methods contains a CODE ref, delete it.\n    delete $self->{_root_cleanup_methods};\n    \n    return $self;\n}\n\n=head1 Bio::IdentifiableI interface \n\nAlso see L<Bio::IdentifiableI>\n\n=head2 version\n\n Title   : version\n Usage   : $taxon->version($newval)\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n    my $self = shift;\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n=head2 authority\n\n Title   : authority\n Usage   : $taxon->authority($newval)\n Returns : value of authority (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub authority {\n    my $self = shift;\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $taxon->namespace($newval)\n Returns : value of namespace (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub namespace {\n    my $self = shift;\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 Bio::Taxonomy::Node implementation\n\n=head2 db_handle\n\n Title   : db_handle\n Usage   : $taxon->db_handle($newval)\n Function: Get/Set Bio::DB::Taxonomy Handle\n Returns : value of db_handle (a scalar) (Bio::DB::Taxonomy object)\n Args    : on set, new value (a scalar, optional) Bio::DB::Taxonomy object\n\nAlso see L<Bio::DB::Taxonomy>\n\n\nsub db_handle {\n    my $self = shift;\n    if (@_) {\n        my $db = shift;\n        \n        if (! ref($db) || ! $db->isa('Bio::DB::Taxonomy')) {\n            $self->throw(\"Must provide a valid Bio::DB::Taxonomy object to db_handle()\");\n        }\n        if (!$self->{'db_handle'} || ($self->{'db_handle'} && $self->{'db_handle'} ne $db)) {\n            my $new_self = $self->_get_similar_taxon_from_db($self, $db);\n            $self->_merge_taxa($new_self) if $new_self;\n        }\n        \n        # NB: The Bio::DB::Taxonomy modules access this data member directly\n        # to avoid calling this method and going infinite\n        $self->{'db_handle'} = $db;\n    }\n    return $self->{'db_handle'};\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $taxon->rank($newval)\n Function: Get/set rank of this Taxon, 'species', 'genus', 'order', etc...\n Returns : value of rank (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'rank'} = shift if @_;\n    return $self->{'rank'};\n}\n\n=head2 id\n\n Title   : id\n Usage   : $taxon->id($newval)\n Function: Get/Set id (NCBI Taxonomy ID in most cases); object_id() and\n           ncbi_taxid() are synonyms of this method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub id {\n    my $self = shift;\n    return $self->SUPER::id(@_);\n}\n\n*object_id = \\&id;\n\n=head2 ncbi_taxid\n\n Title   : ncbi_taxid\n Usage   : $taxon->ncbi_taxid($newval)\n Function: Get/Set the NCBI Taxonomy ID; This actually sets the id() but only\n           returns an id when ncbi_taxid has been explictely set with this\n           method.\n Returns : id (a scalar)\n Args    : none to get, OR scalar to set\n\n\nsub ncbi_taxid {\n    my ($self, $id) = @_;\n    \n    if ($id) {\n        $self->{_ncbi_tax_id_provided} = 1;\n        return $self->SUPER::id($id);\n    }\n    \n    if ($self->{_ncbi_tax_id_provided}) {\n        return $self->SUPER::id;\n    }\n    return;\n}\n\n=head2 parent_id\n\n Title   : parent_id\n Usage   : $taxon->parent_id()\n Function: Get parent ID, (NCBI Taxonomy ID in most cases);\n           parent_taxon_id() is a synonym of this method.\n Returns : value of parent_id (a scalar)\n Args    : none\n Status  : deprecated\n\n\nsub parent_id {\n    my $self = shift;\n    if (@_) {\n        $self->warn(\"You can no longer set the parent_id - use ancestor() instead\");\n    }\n    my $ancestor = $self->ancestor() || return;\n    return $ancestor->id;\n}\n\n*parent_taxon_id = \\&parent_id;\n\n=head2 genetic_code\n\n Title   : genetic_code\n Usage   : $taxon->genetic_code($newval)\n Function: Get/set genetic code table\n Returns : value of genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub genetic_code {\n    my $self = shift;\n    return $self->{'genetic_code'} = shift if @_;\n    return $self->{'genetic_code'};\n}\n\n=head2 mitochondrial_genetic_code\n\n Title   : mitochondrial_genetic_code\n Usage   : $taxon->mitochondrial_genetic_code($newval)\n Function: Get/set mitochondrial genetic code table\n Returns : value of mitochondrial_genetic_code (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub mitochondrial_genetic_code {\n    my $self = shift;\n    return $self->{'mitochondrial_genetic_code'} = shift if @_;\n    return $self->{'mitochondrial_genetic_code'};\n}\n\n=head2 create_date\n\n Title   : create_date\n Usage   : $taxon->create_date($newval)\n Function: Get/Set Date this node was created (in the database)\n Returns : value of create_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub create_date {\n    my $self = shift;\n    return $self->{'create_date'} = shift if @_;\n    return $self->{'create_date'};\n}\n\n=head2 update_date\n\n Title   : update_date\n Usage   : $taxon->update_date($newval)\n Function: Get/Set Date this node was updated (in the database)\n Returns : value of update_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub update_date {\n    my $self = shift;\n    return $self->{'update_date'} = shift if @_;\n    return $self->{'update_date'};\n}\n\n=head2 pub_date\n\n Title   : pub_date\n Usage   : $taxon->pub_date($newval)\n Function: Get/Set Date this node was published (in the database)\n Returns : value of pub_date (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub pub_date {\n    my $self = shift;\n    return $self->{'pub_date'} = shift if @_;\n    return $self->{'pub_date'};\n}\n\n=head2 ancestor\n\n Title   : ancestor\n Usage   : my $ancestor_taxon = $taxon->ancestor()\n Function: Retrieve the ancestor taxon. Normally the database is asked what the\n           ancestor is.\n\n           If you manually set the ancestor (or you make a Bio::Tree::Tree with\n           this object as an argument to new()), the database (if any) will not\n           be used for the purposes of this method.\n\n           To restore normal database behaviour, call ancestor(undef) (which\n           would remove this object from the tree), or request this taxon again\n           as a new Taxon object from the database.\n\n Returns : Bio::Taxon\n Args    : none\n\n\nsub ancestor {\n    my $self = shift;\n    my $ancestor = $self->SUPER::ancestor(@_);\n    my $dbh = $self->db_handle || return $ancestor;\n    \n    if ($ancestor) {\n        return $ancestor;\n    }\n    else {\n        #*** could avoid the db lookup if we knew our current id was definitely\n        #    information from the db...\n        my $definitely_from_dbh = $self->_get_similar_taxon_from_db($self);\n        return $dbh->ancestor($definitely_from_dbh);\n    }\n}\n\n=head2 get_Parent_Node\n\n Title   : get_Parent_Node\n Function: Synonym of ancestor()\n Status  : deprecated\n\n\nsub get_Parent_Node {\n    my $self = shift;\n    $self->warn(\"get_Parent_Node is deprecated, use ancestor() instead\");\n    return $self->ancestor(@_);\n}\n\n=head2 each_Descendent\n\n Title   : each_Descendent\n Usage   : my @taxa = $taxon->each_Descendent();\n Function: Get all the descendents for this Taxon (but not their descendents,\n           ie. not a recursive fetchall). get_Children_Nodes() is a synonym of\n           this method.\n\n           Note that this method never asks the database for the descendents;\n           it will only return objects you have manually set with\n           add_Descendent(), or where this was done for you by making a\n           Bio::Tree::Tree with this object as an argument to new().\n\n           To get the database descendents use\n           $taxon->db_handle->each_Descendent($taxon).\n\n Returns : Array of Bio::Taxon objects\n Args    : optionally, when you have set your own descendents, the string\n           \"height\", \"creation\", \"alpha\", \"revalpha\", or coderef to be used to\n           sort the order of children nodes.\n\n\n# implemented by Bio::Tree::Node\n\n=head2 get_Children_Nodes\n\n Title   : get_Children_Nodes\n Function: Synonym of each_Descendent()\n Status  : deprecated\n\n\nsub get_Children_Nodes {\n    my $self = shift;\n    $self->warn(\"get_Children_Nodes is deprecated, use each_Descendent() instead\");\n    return $self->each_Descendent(@_);\n}\n\n=head2 name\n\n  Title:    name\n  Usage:    $taxon->name('scientific', 'Homo sapiens');\n            $taxon->name('common', 'human', 'man');\n            my @names = @{$taxon->name('common')};\n  Function: Get/set the names. node_name(), scientific_name() and common_names()\n            are shorthands to name('scientific'), name('scientific') and\n            name('common') respectively.\n  Returns:  names (a array reference)\n  Args:     Arg1 => the name_class. You can assign any text, but the words\n                'scientific' and 'common' have the special meaning, as\n                scientific name and common name, respectively. 'scientific' and\n                'division' are treated specially, allowing only the first value\n                in the Arg2 list to be set.\n            Arg2 .. => list of names\n\n\nsub name {\n    my ($self, $name_class, @names) = @_;\n    $self->throw('No name class specified') unless defined $name_class;\n    \n    if (@names) {\n        if ($name_class =~ /scientific|division/i) {\n            delete $self->{'_names_hash'}->{$name_class};\n            @names = (shift(@names));\n        }\n        push @{$self->{'_names_hash'}->{$name_class}}, @names;\n    }\n    return $self->{'_names_hash'}->{$name_class} || return;\n}\n\n=head2 node_name\n\n Title   : node_name\n Usage   : $taxon->node_name($newval)\n Function: Get/set the name of this taxon (node), typically the scientific name\n           of the taxon, eg. 'Primate' or 'Homo'; scientific_name() is a synonym\n           of this method.\n Returns : value of node_name (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub node_name {\n    my $self = shift;\n    my @v = @{$self->name('scientific', @_) || []};\n    return pop @v;\n}\n\n*scientific_name = \\&node_name;\n\n=head2 common_names\n\n Title   : common_names\n Usage   : $taxon->common_names($newval)\n Function: Get/add the other names of this taxon, typically the genbank common\n           name and others, eg. 'Human' and 'man'. common_name() is a synonym\n           of this method.\n Returns : array of names in list context, one of those names in scalar context\n Args    : on add, new list of names (scalars, optional)\n\n\nsub common_names {\n    my $self = shift;\n    my @v = @{$self->name('common', @_) || []};\n    return ( wantarray ) ? @v : pop @v;\n}\n\n*common_name = \\&common_names;\n\n=head2 division\n\n Title   : division\n Usage   : $taxon->division($newval)\n Function: Get/set the division this taxon belongs to, eg. 'Primates' or\n           'Bacteria'.\n Returns : value of division (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub division {\n    my $self = shift;\n    my @v = @{$self->name('division',@_) || []};\n    return pop @v;\n}\n\n# get a node from the database that is like the supplied node\nsub _get_similar_taxon_from_db {\n    #*** not really happy with this having to be called so much; there must be\n    #    a better way...\n    my ($self, $taxon, $db) = @_;\n    $self->throw(\"Must supply a Bio::Taxon\") unless ref($taxon) && $taxon->isa(\"Bio::Taxon\");\n    ($self->id || $self->node_name) || return;\n    $db ||= $self->db_handle || return;\n    \n    my $db_taxon = $db->get_taxon(-taxonid => $taxon->id) if $taxon->id;\n    unless ($db_taxon) {\n        my @try_ids = $db->get_taxonids($taxon->node_name) if $taxon->node_name;\n        \n        my $own_rank = $taxon->rank || 'no rank';\n        foreach my $try_id (@try_ids) {\n            my $try = $db->get_taxon(-taxonid => $try_id);\n            my $try_rank = $try->rank || 'no rank';\n            if ($own_rank eq 'no rank' || $try_rank eq 'no rank' || $own_rank eq $try_rank) {\n                $db_taxon = $try;\n                last;\n            }\n        }\n    }\n    \n    return $db_taxon;\n}\n\n# merge data from supplied Taxon into self\nsub _merge_taxa {\n    my ($self, $taxon) = @_;\n    $self->throw(\"Must supply a Bio::Taxon object\") unless ref($taxon) && $taxon->isa('Bio::Taxon');\n    return if ($taxon eq $self);\n    \n    foreach my $attrib (qw(scientific_name version authority namespace genetic_code mitochondrial_genetic_code create_date update_date pub_date division id)) {\n        my $own = $self->$attrib();\n        my $his = $taxon->$attrib();\n        if (!$own && $his) {\n            $self->$attrib($his);\n        }\n    }\n    \n    my $own = $self->rank || 'no rank';\n    my $his = $taxon->rank || 'no rank';\n    if ($own eq 'no rank' && $his ne 'no rank') {\n        $self->rank($his);\n    }\n    \n    my %own_cnames = map { $_ => 1 } $self->common_names;\n    my %his_cnames = map { $_ => 1 } $taxon->common_names;\n    foreach (keys %his_cnames) {\n        unless (exists $own_cnames{$_}) {\n            $self->common_names($_);\n        }\n    }\n    \n    #*** haven't merged the other things in names() hash, could do above much easier with direct access to object data\n}\n\n=head2 remove_Descendent\n\n Title   : remove_Descendent\n Usage   : $node->remove_Descedent($node_foo);\n Function: Removes a specific node from being a Descendent of this node\n Returns : nothing\n Args    : An array of Bio::Node::NodeI objects which have been previously\n           passed to the add_Descendent call of this object."},"name":"remove_Descendent","range":{"start":{"line":730,"character":0},"end":{"character":9999,"line":746}}},{"name":"_removing_descendent","line":737,"kind":12},{"name":"_removing_descendent","line":739,"kind":12}],"version":5}