{"vars":[{"name":"base","containerName":"","kind":2,"line":141},{"line":143,"kind":13,"containerName":"main::","definition":"our","name":"%ASGTable"},{"name":"%AATable","definition":"our","containerName":"main::","line":151,"kind":13},{"range":{"end":{"character":9999,"line":179},"start":{"line":172,"character":0}},"name":"new","line":172,"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"new","line":173,"kind":13},{"kind":13,"line":173,"containerName":"new","name":"@args"},{"kind":13,"line":174,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":174},{"name":"@args","containerName":"new","line":174,"kind":13},{"line":175,"kind":13,"localvar":"my","containerName":"new","name":"$io","definition":"my"},{"kind":12,"line":175,"containerName":"new","name":"new"},{"name":"@args","containerName":"new","line":175,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":176},{"kind":12,"line":176,"containerName":"new","name":"_parse"},{"containerName":"new","name":"$io","kind":13,"line":176},{"kind":13,"line":177,"name":"$io","containerName":"new"},{"name":"close","containerName":"new","line":177,"kind":12},{"line":178,"kind":13,"containerName":"new","name":"$self"}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $id $\n#\n# bioperl module for Bio::Structure::SecStr::STRIDE::Res.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ed Green <ed@compbio.berkeley.edu>\n#\n# Copyright Univ. of California\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::SecStr::STRIDE::Res - Module for parsing/accessing stride output\n\n=head1 SYNOPSIS\n\n my $stride_obj = Bio::Structure::SecStr::STRIDE::Res->new( '-file' => 'filename.stride' );\n\n # or\n\n my $stride_obj = Bio::Structure::SecStr::STRIDE::Res->new( '-fh' => \\*STDOUT );\n\n # Get secondary structure assignment for PDB residue 20 of chain A\n $sec_str = $stride_obj->resSecStr( '20:A' );\n\n # same\n $sec_str = $stride_obj->resSecStr( 20, 'A' )\n\n=head1 DESCRIPTION\n\nSTRIDE::Res is a module for objectifying STRIDE output.  STRIDE is a\nprogram (similar to DSSP) for assigning secondary structure to\nindividual residues of a pdb structure file.\n\n    ( Knowledge-Based Protein Secondary Structure Assignment,\n    PROTEINS: Structure, Function, and Genetics 23:566-579 (1995) )\n\nSTRIDE is available here:\nhttp://webclu.bio.wzw.tum.de/stride/\n\nMethods are then available for extracting all of the infomation\npresent within the output or convenient subsets of it.\n\nAlthough they are very similar in function, DSSP and STRIDE differ\nsomewhat in output format.  Thes differences are reflected in the\nreturn value of some methods of these modules.  For example, both\nthe STRIDE and DSSP parsers have resSecStr() methods for returning\nthe secondary structure of a given residue.  However, the range of\nreturn values for DSSP is ( H, B, E, G, I, T, and S ) whereas the\nrange of values for STRIDE is ( H, G, I, E, B, b, T, and C ).  See\nindividual methods for details.\n\nThe methods are roughly divided into 3 sections:\n\n  1.  Global features of this structure (PDB ID, total surface area,\n      etc.).  These methods do not require an argument. \n  2.  Residue specific features ( amino acid, secondary structure,\n      solvent exposed surface area, etc. ).  These methods do require an\n      arguement.  The argument is supposed to uniquely identify a\n      residue described within the structure.  It can be of any of the\n      following forms:\n      ('#A:B') or ( #, 'A', 'B' )\n  \t|| |\n  \t|| - Chain ID (blank for single chain)\n  \t|--- Insertion code for this residue.  Blank for most residues.\n  \t|--- Numeric portion of residue ID.\n\n      (#)\n       |\n       --- Numeric portion of residue ID.  If there is only one chain and\n  \t   it has no ID AND there is no residue with an insertion code at this\n  \t   number, then this can uniquely specify a residue.\n\n      ('#:C') or ( #, 'C' )\n  \t| |\n  \t| -Chain ID\n  \t---Numeric portion of residue ID.\n\n     If a residue is incompletely specified then the first residue that\n     fits the arguments is returned.  For example, if 19 is the argument\n     and there are three chains, A, B, and C with a residue whose number\n     is 19, then 19:A will be returned (assuming its listed first).\n\n     Since neither DSSP nor STRIDE correctly handle alt-loc codes, they\n     are not supported by these modules.\n\n 3.  Value-added methods.  Return values are not verbatem strings\n     parsed from DSSP or STRIDE output.  \n\n=head1 FEEDBACK\n\n=head2 MailingLists\n\nUsUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ed Green\n\nEmail ed@compbio.berkeley.edu\n\n\n=head1 APPENDIX\n\nThe Rest of the documentation details each method.\nInternal methods are preceded with a _.\n\n\n\npackage Bio::Structure::SecStr::STRIDE::Res;\nuse strict;\nuse Bio::Root::IO;\nuse Bio::PrimarySeq;\n\nuse base qw(Bio::Root::Root);\n\nour %ASGTable = ( 'aa'         =>  0,\n\t\t  'resNum'     =>  1,\n\t\t  'ssAbbr'     =>  2,\n\t\t  'ssName'     =>  3,\n\t\t  'phi'        =>  4,\n\t\t  'psi'        =>  5,\n\t\t  'surfArea'   =>  6 );\n\nour %AATable = ( 'ALA' => 'A', 'ARG' => 'R', 'ASN' => 'N',\n\t\t 'ASP' => 'D', 'CYS' => 'C', 'GLN' => 'Q',\n\t\t 'GLU' => 'E', 'GLY' => 'G', 'HIS' => 'H',\n\t\t 'ILE' => 'I', 'LEU' => 'L', 'LYS' => 'K',\n\t\t 'MET' => 'M', 'PHE' => 'F', 'PRO' => 'P',\n\t\t 'SER' => 'S', 'THR' => 'T', 'TRP' => 'W',\n\t\t 'TYR' => 'Y', 'VAL' => 'V' );\n\n=head2 new\n\n Title         : new\n Usage         : makes new object of this class\n Function      : Constructor\n Example       : $stride_obj = Bio::Structure::SecStr::STRIDE:Res->new( '-file' =>  filename \n\t\t\t\t\t\t     # or \n\t\t\t\t\t\t     '-fh'   => FILEHANDLE )\n Returns       : object (ref)\n Args          : filename or filehandle( must be proper STRIDE output )","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":174},{"containerName":"Root::IO","name":"Bio","line":175,"kind":12},{"range":{"start":{"line":196,"character":0},"end":{"character":9999,"line":210}},"name":"totSurfArea","definition":"sub","containerName":"main::","children":[{"line":197,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"totSurfArea"},{"kind":13,"line":198,"containerName":"totSurfArea","name":"$total","definition":"my","localvar":"my"},{"localvar":"my","containerName":"totSurfArea","definition":"my","name":"$chain","line":199,"kind":13},{"containerName":"totSurfArea","name":"$res","kind":13,"line":199},{"containerName":"totSurfArea","name":"$self","line":201,"kind":13},{"name":"$self","containerName":"totSurfArea","line":202,"kind":13},{"containerName":"totSurfArea","name":"$chain","kind":13,"line":205},{"name":"$self","containerName":"totSurfArea","line":205,"kind":13},{"containerName":"totSurfArea","definition":"my","name":"$i","localvar":"my","kind":13,"line":206},{"containerName":"totSurfArea","name":"$i","kind":13,"line":206},{"kind":13,"line":206,"name":"$self","containerName":"totSurfArea"},{"containerName":"totSurfArea","name":"$chain","line":206,"kind":13},{"name":"$i","containerName":"totSurfArea","line":206,"kind":13},{"containerName":"totSurfArea","name":"$total","kind":13,"line":207},{"kind":13,"line":208,"name":"$self","containerName":"totSurfArea"},{"line":208,"kind":13,"containerName":"totSurfArea","name":"$chain"},{"kind":13,"line":208,"containerName":"totSurfArea","name":"$i"},{"line":208,"kind":13,"containerName":"totSurfArea","name":"$ASGTable"}],"line":196,"kind":12},{"containerName":null,"name":"%self","kind":13,"line":213},{"name":"$total","containerName":null,"kind":13,"line":213},{"line":214,"kind":13,"containerName":null,"name":"%self"},{"name":"numResidues","definition":"sub","containerName":"main::","range":{"end":{"line":236,"character":9999},"start":{"line":231,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"numResidues","name":"$self","definition":"my","line":232,"kind":13},{"kind":13,"line":233,"containerName":"numResidues","definition":"my","name":"$chain","localvar":"my"},{"kind":13,"line":234,"containerName":"numResidues","name":"$total","definition":"my","localvar":"my"},{"line":235,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":"numResidues"},{"containerName":"numResidues","name":"$key","kind":13,"line":236},{"line":236,"kind":13,"containerName":"numResidues","name":"$self"}],"line":231},{"line":237,"kind":13,"name":"%chain","containerName":null},{"containerName":null,"name":"$key","line":238,"kind":13},{"line":238,"kind":13,"containerName":null,"name":"%chain"},{"kind":13,"line":239,"containerName":null,"name":"$total"},{"line":239,"kind":13,"name":"%self","containerName":null},{"line":239,"kind":13,"containerName":null,"name":"%key"},{"name":"$total","containerName":null,"line":243,"kind":13},{"kind":13,"line":243,"name":"%self","containerName":null},{"containerName":null,"name":"$key","kind":13,"line":243},{"line":246,"kind":13,"name":"$total","containerName":null},{"range":{"end":{"character":9999,"line":266},"start":{"character":0,"line":263}},"definition":"sub","name":"pdbID","containerName":"main::","children":[{"kind":13,"line":264,"containerName":"pdbID","name":"$self","definition":"my","localvar":"my"},{"containerName":"pdbID","name":"$self","line":265,"kind":13}],"line":263,"kind":12},{"line":279,"children":[{"localvar":"my","containerName":"pdbAuthor","definition":"my","name":"$self","line":280,"kind":13},{"line":281,"kind":13,"containerName":"pdbAuthor","name":"$self"}],"kind":12,"range":{"end":{"line":281,"character":9999},"start":{"line":279,"character":0}},"containerName":"main::","definition":"sub","name":"pdbAuthor"},{"children":[{"kind":13,"line":298,"containerName":"pdbCompound","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"pdbCompound","kind":13,"line":299}],"line":297,"kind":12,"range":{"end":{"line":299,"character":9999},"start":{"character":0,"line":297}},"definition":"sub","name":"pdbCompound","containerName":"main::"},{"kind":12,"line":314,"children":[{"kind":13,"line":315,"definition":"my","name":"$self","containerName":"pdbDate","localvar":"my"},{"name":"$self","containerName":"pdbDate","kind":13,"line":316}],"containerName":"main::","name":"pdbDate","definition":"sub","range":{"end":{"line":317,"character":9999},"start":{"line":314,"character":0}}},{"name":"pdbHeader","definition":"sub","containerName":"main::","range":{"end":{"line":334,"character":9999},"start":{"line":331,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"pdbHeader","definition":"my","name":"$self","line":332,"kind":13},{"name":"$self","containerName":"pdbHeader","line":333,"kind":13}],"line":331},{"kind":12,"line":348,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"pdbSource","line":349,"kind":13},{"name":"$self","containerName":"pdbSource","line":350,"kind":13}],"containerName":"main::","name":"pdbSource","definition":"sub","range":{"end":{"line":350,"character":9999},"start":{"character":0,"line":348}}},{"range":{"end":{"character":9999,"line":373},"start":{"line":368,"character":0}},"name":"resAA","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"resAA","localvar":"my","kind":13,"line":369},{"line":370,"kind":13,"localvar":"my","containerName":"resAA","name":"@args","definition":"my"},{"containerName":"resAA","definition":"my","name":"$ord","localvar":"my","kind":13,"line":371},{"kind":13,"line":371,"containerName":"resAA","name":"$chain"},{"containerName":"resAA","name":"$self","kind":13,"line":371},{"line":371,"kind":12,"name":"_toOrdChain","containerName":"resAA"},{"containerName":"resAA","name":"@args","line":371,"kind":13},{"name":"$AATable","containerName":"resAA","kind":13,"line":372},{"containerName":"resAA","name":"$self","kind":13,"line":372},{"name":"$chain","containerName":"resAA","line":372,"kind":13},{"containerName":"resAA","name":"$ord","kind":13,"line":372},{"line":372,"kind":13,"name":"$ASGTable","containerName":"resAA"}],"line":368,"kind":12},{"containerName":"main::","definition":"sub","name":"resPhi","range":{"start":{"line":387,"character":0},"end":{"character":9999,"line":392}},"kind":12,"line":387,"children":[{"line":388,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"resPhi"},{"definition":"my","name":"@args","containerName":"resPhi","localvar":"my","kind":13,"line":389},{"kind":13,"line":390,"name":"$ord","definition":"my","containerName":"resPhi","localvar":"my"},{"line":390,"kind":13,"name":"$chain","containerName":"resPhi"},{"containerName":"resPhi","name":"$self","kind":13,"line":390},{"name":"_toOrdChain","containerName":"resPhi","line":390,"kind":12},{"line":390,"kind":13,"containerName":"resPhi","name":"@args"},{"kind":13,"line":391,"name":"$self","containerName":"resPhi"},{"name":"$chain","containerName":"resPhi","kind":13,"line":391},{"line":391,"kind":13,"name":"$ord","containerName":"resPhi"},{"containerName":"resPhi","name":"$ASGTable","line":391,"kind":13}]},{"children":[{"containerName":"resPsi","definition":"my","name":"$self","localvar":"my","kind":13,"line":407},{"line":408,"kind":13,"localvar":"my","containerName":"resPsi","name":"@args","definition":"my"},{"localvar":"my","containerName":"resPsi","definition":"my","name":"$ord","line":409,"kind":13},{"line":409,"kind":13,"name":"$chain","containerName":"resPsi"},{"containerName":"resPsi","name":"$self","line":409,"kind":13},{"kind":12,"line":409,"name":"_toOrdChain","containerName":"resPsi"},{"kind":13,"line":409,"containerName":"resPsi","name":"@args"},{"line":410,"kind":13,"name":"$self","containerName":"resPsi"},{"containerName":"resPsi","name":"$chain","line":410,"kind":13},{"kind":13,"line":410,"name":"$ord","containerName":"resPsi"},{"line":410,"kind":13,"name":"$ASGTable","containerName":"resPsi"}],"line":406,"kind":12,"range":{"start":{"line":406,"character":0},"end":{"line":411,"character":9999}},"name":"resPsi","definition":"sub","containerName":"main::"},{"definition":"sub","name":"resSolvAcc","containerName":"main::","range":{"start":{"line":425,"character":0},"end":{"line":430,"character":9999}},"kind":12,"children":[{"kind":13,"line":426,"containerName":"resSolvAcc","name":"$self","definition":"my","localvar":"my"},{"containerName":"resSolvAcc","definition":"my","name":"@args","localvar":"my","kind":13,"line":427},{"definition":"my","name":"$ord","containerName":"resSolvAcc","localvar":"my","kind":13,"line":428},{"line":428,"kind":13,"containerName":"resSolvAcc","name":"$chain"},{"line":428,"kind":13,"containerName":"resSolvAcc","name":"$self"},{"name":"_toOrdChain","containerName":"resSolvAcc","kind":12,"line":428},{"line":428,"kind":13,"containerName":"resSolvAcc","name":"@args"},{"line":429,"kind":13,"name":"$self","containerName":"resSolvAcc"},{"kind":13,"line":429,"containerName":"resSolvAcc","name":"$chain"},{"kind":13,"line":429,"name":"$ord","containerName":"resSolvAcc"},{"containerName":"resSolvAcc","name":"$ASGTable","line":429,"kind":13}],"line":425},{"line":444,"children":[{"containerName":"resSurfArea","definition":"my","name":"$self","localvar":"my","kind":13,"line":445},{"line":446,"kind":13,"localvar":"my","containerName":"resSurfArea","definition":"my","name":"@args"},{"kind":13,"line":447,"name":"$ord","definition":"my","containerName":"resSurfArea","localvar":"my"},{"kind":13,"line":447,"name":"$chain","containerName":"resSurfArea"},{"containerName":"resSurfArea","name":"$self","kind":13,"line":447},{"containerName":"resSurfArea","name":"_toOrdChain","kind":12,"line":447},{"kind":13,"line":447,"containerName":"resSurfArea","name":"@args"},{"kind":13,"line":448,"containerName":"resSurfArea","name":"$self"},{"line":448,"kind":13,"containerName":"resSurfArea","name":"$chain"},{"name":"$ord","containerName":"resSurfArea","kind":13,"line":448},{"name":"$ASGTable","containerName":"resSurfArea","line":448,"kind":13}],"kind":12,"range":{"end":{"character":9999,"line":449},"start":{"line":444,"character":0}},"containerName":"main::","definition":"sub","name":"resSurfArea"},{"containerName":"main::","definition":"sub","name":"resSecStr","range":{"start":{"line":473,"character":0},"end":{"character":9999,"line":478}},"kind":12,"line":473,"children":[{"containerName":"resSecStr","name":"$self","definition":"my","localvar":"my","kind":13,"line":474},{"localvar":"my","name":"@args","definition":"my","containerName":"resSecStr","line":475,"kind":13},{"containerName":"resSecStr","name":"$ord","definition":"my","localvar":"my","kind":13,"line":476},{"containerName":"resSecStr","name":"$chain","kind":13,"line":476},{"name":"$self","containerName":"resSecStr","line":476,"kind":13},{"containerName":"resSecStr","name":"_toOrdChain","kind":12,"line":476},{"kind":13,"line":476,"name":"@args","containerName":"resSecStr"},{"name":"$self","containerName":"resSecStr","kind":13,"line":477},{"kind":13,"line":477,"name":"$chain","containerName":"resSecStr"},{"name":"$ord","containerName":"resSecStr","line":477,"kind":13},{"name":"$ASGTable","containerName":"resSecStr","kind":13,"line":477}]},{"containerName":"main::","definition":"sub","name":"resSecStrSum","range":{"start":{"character":0,"line":493},"end":{"character":9999,"line":510}},"kind":12,"line":493,"children":[{"line":494,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"resSecStrSum"},{"kind":13,"line":495,"name":"@args","definition":"my","containerName":"resSecStrSum","localvar":"my"},{"localvar":"my","definition":"my","name":"$ss_char","containerName":"resSecStrSum","line":496,"kind":13},{"containerName":"resSecStrSum","name":"$self","kind":13,"line":496},{"line":496,"kind":12,"name":"resSecStr","containerName":"resSecStrSum"},{"containerName":"resSecStrSum","name":"@args","kind":13,"line":496},{"line":498,"kind":13,"name":"$ss_char","containerName":"resSecStrSum"},{"containerName":"resSecStrSum","name":"$ss_char","line":498,"kind":13},{"containerName":"resSecStrSum","name":"$ss_char","line":498,"kind":13},{"line":501,"kind":13,"name":"$ss_char","containerName":"resSecStrSum"},{"kind":13,"line":501,"name":"$ss_char","containerName":"resSecStrSum"},{"line":501,"kind":13,"name":"$ss_char","containerName":"resSecStrSum"},{"line":504,"kind":13,"containerName":"resSecStrSum","name":"$ss_char"}]},{"range":{"end":{"line":532,"character":9999},"start":{"character":0,"line":527}},"name":"resSecStrName","definition":"sub","containerName":"main::","children":[{"kind":13,"line":528,"definition":"my","name":"$self","containerName":"resSecStrName","localvar":"my"},{"localvar":"my","definition":"my","name":"@args","containerName":"resSecStrName","line":529,"kind":13},{"localvar":"my","name":"$ord","definition":"my","containerName":"resSecStrName","line":530,"kind":13},{"containerName":"resSecStrName","name":"$chain","line":530,"kind":13},{"line":530,"kind":13,"containerName":"resSecStrName","name":"$self"},{"kind":12,"line":530,"name":"_toOrdChain","containerName":"resSecStrName"},{"kind":13,"line":530,"name":"@args","containerName":"resSecStrName"},{"containerName":"resSecStrName","name":"$self","line":531,"kind":13},{"kind":13,"line":531,"name":"$chain","containerName":"resSecStrName"},{"name":"$ord","containerName":"resSecStrName","kind":13,"line":531},{"kind":13,"line":531,"containerName":"resSecStrName","name":"$ASGTable"}],"line":527,"kind":12},{"range":{"end":{"character":9999,"line":556},"start":{"line":553,"character":0}},"containerName":"main::","definition":"sub","name":"strideLocs","line":553,"children":[{"localvar":"my","containerName":"strideLocs","name":"$self","definition":"my","line":554,"kind":13},{"name":"$self","containerName":"strideLocs","line":555,"kind":13}],"kind":12},{"range":{"start":{"line":577,"character":0},"end":{"line":600,"character":9999}},"name":"secBounds","definition":"sub","containerName":"main::","children":[{"kind":13,"line":579,"containerName":"secBounds","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"$chain","definition":"my","containerName":"secBounds","line":580,"kind":13},{"localvar":"my","name":"@SecBounds","definition":"my","containerName":"secBounds","line":581,"kind":13},{"containerName":"secBounds","name":"$chain","kind":13,"line":583},{"kind":13,"line":583,"containerName":"secBounds","name":"$chain"},{"kind":13,"line":583,"name":"$chain","containerName":"secBounds"},{"containerName":"secBounds","name":"$chain","line":583,"kind":13},{"name":"$self","containerName":"secBounds","kind":13,"line":586},{"kind":13,"line":586,"name":"$chain","containerName":"secBounds"},{"name":"$self","containerName":"secBounds","line":587,"kind":13},{"containerName":"secBounds","name":"$chain","line":587,"kind":13},{"containerName":"secBounds","name":"$self","line":591,"kind":13},{"containerName":"secBounds","name":"$chain","kind":13,"line":591},{"name":"$self","containerName":"secBounds","kind":13,"line":592},{"containerName":"secBounds","name":"throw","line":592,"kind":12},{"localvar":"my","definition":"my","name":"$cur_element","containerName":"secBounds","line":595,"kind":13},{"kind":13,"line":595,"containerName":"secBounds","name":"$self"},{"name":"$chain","containerName":"secBounds","line":595,"kind":13},{"kind":13,"line":596,"name":"$ASGTable","containerName":"secBounds"},{"localvar":"my","containerName":"secBounds","name":"$beg","definition":"my","line":597,"kind":13},{"containerName":"secBounds","definition":"my","name":"$i","localvar":"my","kind":13,"line":598},{"name":"$i","containerName":"secBounds","kind":13,"line":600},{"containerName":"secBounds","name":"$i","line":600,"kind":13},{"kind":13,"line":600,"name":"$self","containerName":"secBounds"},{"line":600,"kind":13,"containerName":"secBounds","name":"$chain"}],"line":577,"kind":12},{"name":"%i","containerName":null,"kind":13,"line":600},{"containerName":null,"name":"%self","line":601,"kind":13},{"containerName":null,"name":"@chain","line":601,"kind":13},{"name":"@i","containerName":null,"kind":13,"line":601},{"name":"%ASGTable","containerName":null,"line":601,"kind":13},{"containerName":null,"name":"%cur_element","line":602,"kind":13},{"containerName":null,"name":"@SecBounds","kind":13,"line":603},{"line":603,"kind":13,"name":"$beg","containerName":null},{"kind":13,"line":603,"name":"$i","containerName":null},{"containerName":null,"name":"$cur_element","line":603,"kind":13},{"containerName":null,"name":"$beg","line":604,"kind":13},{"name":"$i","containerName":null,"kind":13,"line":604},{"name":"$cur_element","containerName":null,"line":605,"kind":13},{"name":"%self","containerName":null,"line":605,"kind":13},{"kind":13,"line":605,"name":"@chain","containerName":null},{"name":"@i","containerName":null,"line":605,"kind":13},{"line":606,"kind":13,"name":"%ASGTable","containerName":null},{"kind":13,"line":610,"containerName":null,"name":"%self"},{"name":"@chain","containerName":null,"line":610,"kind":13},{"name":"@i","containerName":null,"line":610,"kind":13},{"kind":13,"line":610,"containerName":null,"name":"%ASGTable"},{"containerName":null,"name":"%cur_element","kind":13,"line":611},{"line":612,"kind":13,"containerName":null,"name":"@SecBounds"},{"line":612,"kind":13,"containerName":null,"name":"$beg"},{"containerName":null,"name":"$i","line":612,"kind":13},{"kind":13,"line":612,"name":"%cur_element","containerName":null},{"name":"@SecBounds","containerName":null,"kind":13,"line":615},{"name":"$beg","containerName":null,"line":615,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":615},{"line":615,"kind":13,"containerName":null,"name":"@cur_element"},{"name":"$i","containerName":null,"line":616,"kind":13},{"containerName":null,"name":"$i","kind":13,"line":616},{"kind":13,"line":616,"name":"%self","containerName":null},{"name":"@chain","containerName":null,"kind":13,"line":616},{"line":616,"kind":13,"name":"@i","containerName":null},{"name":"%ASGTable","containerName":null,"line":617,"kind":13},{"kind":13,"line":620,"name":"%self","containerName":null},{"kind":13,"line":620,"name":"$chain","containerName":null},{"containerName":null,"name":"@SecBounds","line":620,"kind":13},{"line":621,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"$chain","kind":13,"line":621},{"range":{"start":{"character":0,"line":636},"end":{"line":638,"character":9999}},"containerName":"main::","definition":"sub","name":"chains","line":636,"children":[{"kind":13,"line":637,"containerName":"chains","name":"$self","definition":"my","localvar":"my"},{"containerName":"chains","definition":"my","name":"@chains","localvar":"my","kind":13,"line":638},{"kind":13,"line":638,"containerName":"chains","name":"$self"}],"kind":12},{"name":"@chains","containerName":null,"kind":13,"line":639},{"name":"getSeq","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":714},"start":{"line":668,"character":0}},"kind":12,"children":[{"containerName":"getSeq","name":"$self","definition":"my","localvar":"my","kind":13,"line":669},{"localvar":"my","definition":"my","name":"$chain","containerName":"getSeq","line":670,"kind":13},{"kind":13,"line":671,"containerName":"getSeq","definition":"my","name":"$fill_in","localvar":"my"},{"containerName":"getSeq","name":"$chain","line":673,"kind":13},{"containerName":"getSeq","name":"$chain","kind":13,"line":674},{"name":"$self","containerName":"getSeq","line":677,"kind":13},{"line":677,"kind":13,"containerName":"getSeq","name":"$chain"},{"name":"$self","containerName":"getSeq","line":678,"kind":13},{"containerName":"getSeq","name":"$chain","line":678,"kind":13},{"localvar":"my","name":"$seq","definition":"my","containerName":"getSeq","line":681,"kind":13},{"name":"$num_res","containerName":"getSeq","line":682,"kind":13},{"name":"$last_res_num","containerName":"getSeq","line":683,"kind":13},{"kind":13,"line":684,"containerName":"getSeq","name":"$cur_res_num"},{"kind":13,"line":685,"name":"$i","containerName":"getSeq"},{"containerName":"getSeq","name":"$step","line":686,"kind":13},{"kind":13,"line":688,"name":"$id","containerName":"getSeq"},{"name":"$seq","containerName":"getSeq","kind":13,"line":690},{"line":691,"kind":13,"containerName":"getSeq","name":"$num_res"},{"containerName":"getSeq","name":"$self","kind":13,"line":691},{"containerName":"getSeq","name":"numResidues","kind":12,"line":691},{"name":"$chain","containerName":"getSeq","kind":13,"line":691},{"line":692,"kind":13,"containerName":"getSeq","name":"$last_res_num"},{"name":"$self","containerName":"getSeq","kind":13,"line":692},{"kind":12,"line":692,"name":"_pdbNum","containerName":"getSeq"},{"kind":13,"line":692,"containerName":"getSeq","name":"$chain"},{"containerName":"getSeq","name":"$i","kind":13,"line":693},{"containerName":"getSeq","name":"$i","kind":13,"line":693},{"containerName":"getSeq","name":"$num_res","line":693,"kind":13},{"name":"$i","containerName":"getSeq","kind":13,"line":693},{"name":"$fill_in","containerName":"getSeq","kind":13,"line":694},{"line":695,"kind":13,"containerName":"getSeq","name":"$cur_res_num"},{"name":"$self","containerName":"getSeq","kind":13,"line":695},{"kind":12,"line":695,"containerName":"getSeq","name":"_pdbNum"},{"kind":13,"line":695,"name":"$i","containerName":"getSeq"},{"name":"$chain","containerName":"getSeq","kind":13,"line":695},{"line":696,"kind":13,"name":"$step","containerName":"getSeq"},{"line":696,"kind":13,"containerName":"getSeq","name":"$cur_res_num"},{"containerName":"getSeq","name":"$last_res_num","line":696,"kind":13},{"name":"$step","containerName":"getSeq","line":697,"kind":13},{"containerName":"getSeq","name":"$seq","line":698,"kind":13},{"kind":13,"line":698,"containerName":"getSeq","name":"$step"},{"name":"$seq","containerName":"getSeq","kind":13,"line":701},{"containerName":"getSeq","name":"$self","line":701,"kind":13},{"line":701,"kind":12,"containerName":"getSeq","name":"_resAA"},{"kind":13,"line":701,"name":"$i","containerName":"getSeq"},{"name":"$chain","containerName":"getSeq","kind":13,"line":701},{"containerName":"getSeq","name":"$last_res_num","kind":13,"line":702},{"name":"$cur_res_num","containerName":"getSeq","line":702,"kind":13},{"line":705,"kind":13,"name":"$id","containerName":"getSeq"},{"name":"$self","containerName":"getSeq","line":705,"kind":13},{"line":705,"kind":12,"containerName":"getSeq","name":"pdbID"},{"containerName":"getSeq","name":"$id","kind":13,"line":706},{"kind":13,"line":708,"containerName":"getSeq","name":"$self"},{"line":708,"kind":13,"containerName":"getSeq","name":"$chain"},{"containerName":"getSeq","name":"new","kind":12,"line":708},{"name":"$seq","containerName":"getSeq","line":708,"kind":13},{"name":"$id","containerName":"getSeq","kind":13,"line":709},{"name":"$self","containerName":"getSeq","line":713,"kind":13},{"containerName":"getSeq","name":"$chain","line":713,"kind":13}],"line":668},{"line":708,"kind":12,"name":"Bio","containerName":"PrimarySeq"},{"containerName":"main::","definition":"sub","name":"_pdbNum","range":{"start":{"character":0,"line":733},"end":{"line":744,"character":9999}},"kind":12,"line":733,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_pdbNum","line":734,"kind":13},{"containerName":"_pdbNum","name":"$ord","definition":"my","localvar":"my","kind":13,"line":735},{"line":736,"kind":13,"localvar":"my","name":"$chain","definition":"my","containerName":"_pdbNum"},{"containerName":"_pdbNum","name":"$self","line":737,"kind":13},{"containerName":"_pdbNum","name":"$chain","kind":13,"line":737},{"line":737,"kind":13,"name":"$ord","containerName":"_pdbNum"},{"line":738,"kind":13,"name":"$self","containerName":"_pdbNum"},{"containerName":"_pdbNum","name":"throw","kind":12,"line":738},{"containerName":"_pdbNum","name":"$pdb_junk","definition":"my","localvar":"my","kind":13,"line":740},{"containerName":"_pdbNum","name":"$self","line":740,"kind":13},{"containerName":"_pdbNum","name":"$chain","kind":13,"line":740},{"line":740,"kind":13,"name":"$ord","containerName":"_pdbNum"},{"containerName":"_pdbNum","name":"$ASGTable","line":740,"kind":13},{"localvar":"my","definition":"my","name":"$num_part","containerName":"_pdbNum","line":741,"kind":13},{"containerName":"_pdbNum","name":"$num_part","line":742,"kind":13},{"name":"$pdb_junk","containerName":"_pdbNum","line":742,"kind":13},{"line":743,"kind":13,"name":"$num_part","containerName":"_pdbNum"}]},{"kind":12,"children":[{"kind":13,"line":760,"definition":"my","name":"$self","containerName":"_resAA","localvar":"my"},{"line":761,"kind":13,"localvar":"my","containerName":"_resAA","definition":"my","name":"$ord"},{"definition":"my","name":"$chain","containerName":"_resAA","localvar":"my","kind":13,"line":762},{"containerName":"_resAA","name":"$self","kind":13,"line":763},{"line":763,"kind":13,"name":"$chain","containerName":"_resAA"},{"containerName":"_resAA","name":"$ord","kind":13,"line":763},{"name":"$self","containerName":"_resAA","line":764,"kind":13},{"containerName":"_resAA","name":"throw","line":764,"kind":12},{"kind":13,"line":766,"name":"$AATable","containerName":"_resAA"},{"kind":13,"line":766,"name":"$self","containerName":"_resAA"},{"containerName":"_resAA","name":"$chain","kind":13,"line":766},{"containerName":"_resAA","name":"$ord","line":766,"kind":13},{"name":"$ASGTable","containerName":"_resAA","line":766,"kind":13}],"line":759,"name":"_resAA","definition":"sub","containerName":"main::","range":{"start":{"line":759,"character":0},"end":{"line":767,"character":9999}}},{"line":781,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_pdbInsCo","line":782,"kind":13},{"kind":13,"line":783,"containerName":"_pdbInsCo","definition":"my","name":"$ord","localvar":"my"},{"containerName":"_pdbInsCo","name":"$chain","definition":"my","localvar":"my","kind":13,"line":784},{"kind":13,"line":785,"containerName":"_pdbInsCo","name":"$self"},{"kind":13,"line":785,"containerName":"_pdbInsCo","name":"$chain"},{"containerName":"_pdbInsCo","name":"$ord","line":785,"kind":13},{"containerName":"_pdbInsCo","name":"$self","line":786,"kind":13},{"name":"throw","containerName":"_pdbInsCo","kind":12,"line":786},{"definition":"my","name":"$pdb_junk","containerName":"_pdbInsCo","localvar":"my","kind":13,"line":788},{"line":788,"kind":13,"name":"$self","containerName":"_pdbInsCo"},{"name":"$chain","containerName":"_pdbInsCo","kind":13,"line":788},{"line":788,"kind":13,"containerName":"_pdbInsCo","name":"$ord"},{"name":"$ASGTable","containerName":"_pdbInsCo","kind":13,"line":788},{"line":789,"kind":13,"localvar":"my","containerName":"_pdbInsCo","definition":"my","name":"$letter_part"},{"name":"$letter_part","containerName":"_pdbInsCo","kind":13,"line":790},{"line":790,"kind":13,"name":"$pdb_junk","containerName":"_pdbInsCo"},{"line":792,"kind":13,"name":"$letter_part","containerName":"_pdbInsCo"}],"kind":12,"range":{"end":{"character":9999,"line":793},"start":{"line":781,"character":0}},"containerName":"main::","definition":"sub","name":"_pdbInsCo"},{"kind":12,"line":832,"children":[{"kind":13,"line":833,"name":"$self","definition":"my","containerName":"_toOrdChain","localvar":"my"},{"containerName":"_toOrdChain","definition":"my","name":"$arg_str","localvar":"my","kind":13,"line":834},{"localvar":"my","name":"$key_num","definition":"my","containerName":"_toOrdChain","line":836,"kind":13},{"name":"$chain_id","containerName":"_toOrdChain","line":836,"kind":13},{"line":836,"kind":13,"containerName":"_toOrdChain","name":"$ins_code"},{"containerName":"_toOrdChain","name":"$key","line":836,"kind":13},{"kind":13,"line":836,"containerName":"_toOrdChain","name":"$i"},{"line":840,"kind":13,"name":"$key_num","containerName":"_toOrdChain"},{"containerName":"_toOrdChain","name":"$ins_code","line":842,"kind":13},{"kind":13,"line":843,"name":"$chain_id","containerName":"_toOrdChain"},{"containerName":"_toOrdChain","name":"$chain_id","kind":13,"line":846},{"containerName":"_toOrdChain","name":"$arg_str","line":850,"kind":13},{"name":"$arg_str","containerName":"_toOrdChain","kind":13,"line":851},{"name":"$chain_id","containerName":"_toOrdChain","kind":13,"line":853},{"containerName":"_toOrdChain","name":"$arg_str","line":853,"kind":13},{"line":854,"kind":13,"name":"$arg_str","containerName":"_toOrdChain"},{"containerName":"_toOrdChain","name":"$arg_str","kind":13,"line":856},{"name":"$ins_code","containerName":"_toOrdChain","kind":13,"line":858},{"line":858,"kind":13,"containerName":"_toOrdChain","name":"$arg_str"},{"line":859,"kind":13,"containerName":"_toOrdChain","name":"$arg_str"},{"line":862,"kind":13,"name":"$key_num","containerName":"_toOrdChain"},{"name":"$arg_str","containerName":"_toOrdChain","line":862,"kind":13},{"kind":13,"line":865,"name":"$key","containerName":"_toOrdChain"},{"kind":13,"line":866,"containerName":"_toOrdChain","name":"$chain_id"},{"line":866,"kind":13,"name":"$chain_id","containerName":"_toOrdChain"},{"line":867,"kind":13,"containerName":"_toOrdChain","name":"$chain_id"},{"kind":13,"line":870,"containerName":"_toOrdChain","name":"$self"},{"line":870,"kind":13,"name":"$chain_id","containerName":"_toOrdChain"},{"kind":13,"line":871,"name":"$self","containerName":"_toOrdChain"},{"line":871,"kind":12,"containerName":"_toOrdChain","name":"throw"},{"name":"$i","containerName":"_toOrdChain","kind":13,"line":874},{"line":874,"kind":13,"name":"$i","containerName":"_toOrdChain"},{"name":"$self","containerName":"_toOrdChain","kind":13,"line":874},{"name":"$chain_id","containerName":"_toOrdChain","kind":13,"line":874}],"containerName":"main::","name":"_toOrdChain","definition":"sub","range":{"end":{"line":874,"character":9999},"start":{"character":0,"line":832}}},{"line":874,"kind":13,"containerName":null,"name":"%i"},{"line":875,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"@chain_id","kind":13,"line":875},{"containerName":null,"name":"@i","line":875,"kind":13},{"line":875,"kind":13,"containerName":null,"name":"%ASGTable"},{"kind":13,"line":876,"name":"%key","containerName":null},{"kind":13,"line":877,"containerName":null,"name":"$i"},{"line":877,"kind":13,"name":"$chain_id","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":881},{"containerName":"main::","name":"throw","kind":12,"line":881},{"containerName":"main::","name":"_parse","definition":"sub","range":{"end":{"character":9999,"line":915},"start":{"character":0,"line":897}},"kind":12,"line":897,"children":[{"containerName":"_parse","name":"$self","definition":"my","localvar":"my","kind":13,"line":898},{"kind":13,"line":899,"containerName":"_parse","name":"$io","definition":"my","localvar":"my"},{"definition":"my","name":"$file","containerName":"_parse","localvar":"my","kind":13,"line":900},{"kind":13,"line":900,"name":"$io","containerName":"_parse"},{"name":"_fh","containerName":"_parse","line":900,"kind":12},{"containerName":"_parse","name":"$self","kind":13,"line":903},{"line":903,"kind":12,"containerName":"_parse","name":"_parseTop"},{"kind":13,"line":903,"containerName":"_parse","name":"$io"},{"kind":13,"line":904,"containerName":"_parse","name":"$self"},{"name":"throw","containerName":"_parse","line":904,"kind":12},{"name":"$self","containerName":"_parse","kind":13,"line":908},{"kind":12,"line":908,"name":"_parseHead","containerName":"_parse"},{"containerName":"_parse","name":"$io","line":908,"kind":13},{"containerName":"_parse","name":"$self","line":911,"kind":13},{"line":911,"kind":12,"containerName":"_parse","name":"_parseSummary"},{"name":"$io","containerName":"_parse","kind":13,"line":911},{"name":"$self","containerName":"_parse","line":914,"kind":13},{"containerName":"_parse","name":"_parseASG","kind":12,"line":914},{"line":914,"kind":13,"containerName":"_parse","name":"$io"}]},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_parseTop","line":930,"kind":13},{"kind":13,"line":931,"name":"$io","definition":"my","containerName":"_parseTop","localvar":"my"},{"kind":13,"line":932,"containerName":"_parseTop","definition":"my","name":"$file","localvar":"my"},{"containerName":"_parseTop","name":"$io","line":932,"kind":13},{"line":932,"kind":12,"name":"_fh","containerName":"_parseTop"},{"line":933,"kind":13,"localvar":"my","containerName":"_parseTop","name":"$cur","definition":"my"},{"kind":13,"line":933,"name":"$file","containerName":"_parseTop"},{"name":"$cur","containerName":"_parseTop","line":934,"kind":13}],"line":929,"name":"_parseTop","definition":"sub","containerName":"main::","range":{"start":{"line":929,"character":0},"end":{"line":938,"character":9999}}},{"range":{"end":{"character":9999,"line":1002},"start":{"line":952,"character":0}},"containerName":"main::","definition":"sub","name":"_parseHead","line":952,"children":[{"kind":13,"line":953,"containerName":"_parseHead","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","containerName":"_parseHead","definition":"my","name":"$io","line":954,"kind":13},{"localvar":"my","definition":"my","name":"$file","containerName":"_parseHead","line":955,"kind":13},{"line":955,"kind":13,"name":"$io","containerName":"_parseHead"},{"name":"_fh","containerName":"_parseHead","line":955,"kind":12},{"containerName":"_parseHead","definition":"my","name":"$cur","localvar":"my","kind":13,"line":956},{"localvar":"my","containerName":"_parseHead","name":"$element","definition":"my","line":957,"kind":13},{"line":958,"kind":13,"localvar":"my","name":"@elements","definition":"my","containerName":"_parseHead"},{"containerName":"_parseHead","name":"@cmp","line":958,"kind":13},{"containerName":"_parseHead","name":"@src","line":958,"kind":13},{"line":958,"kind":13,"name":"@aut","containerName":"_parseHead"},{"localvar":"my","name":"%head","definition":"my","containerName":"_parseHead","line":959,"kind":13},{"name":"$still_head","definition":"my","containerName":"_parseHead","localvar":"my","kind":13,"line":960},{"kind":13,"line":962,"name":"$cur","containerName":"_parseHead"},{"kind":13,"line":962,"containerName":"_parseHead","name":"$file"},{"line":963,"kind":13,"name":"$cur","containerName":"_parseHead"},{"containerName":"_parseHead","name":"$cur","line":964,"kind":13},{"line":964,"kind":13,"name":"$file","containerName":"_parseHead"},{"kind":13,"line":967,"containerName":"_parseHead","name":"$cur"},{"containerName":"_parseHead","name":"@elements","line":968,"kind":13},{"name":"$cur","containerName":"_parseHead","kind":13,"line":968},{"kind":13,"line":969,"containerName":"_parseHead","name":"@elements"},{"containerName":"_parseHead","name":"@elements","kind":13,"line":970},{"kind":13,"line":971,"containerName":"_parseHead","name":"$self"},{"name":"@elements","containerName":"_parseHead","line":971,"kind":13},{"containerName":"_parseHead","name":"$self","kind":13,"line":972},{"kind":13,"line":972,"name":"@elements","containerName":"_parseHead"},{"line":975,"kind":13,"name":"$element","containerName":"_parseHead"},{"line":975,"kind":13,"name":"@elements","containerName":"_parseHead"},{"containerName":"_parseHead","name":"$head","kind":13,"line":976},{"name":"$element","containerName":"_parseHead","line":976,"kind":13},{"name":"$cur","containerName":"_parseHead","line":979,"kind":13},{"name":"$file","containerName":"_parseHead","line":979,"kind":13},{"kind":13,"line":980,"name":"$cur","containerName":"_parseHead"},{"kind":13,"line":981,"name":"$cur","containerName":"_parseHead"},{"name":"$cur","containerName":"_parseHead","line":981,"kind":13},{"name":"@cmp","containerName":"_parseHead","line":982,"kind":13},{"line":982,"kind":13,"name":"$cur","containerName":"_parseHead"},{"line":983,"kind":13,"containerName":"_parseHead","name":"$cur"},{"kind":13,"line":983,"containerName":"_parseHead","name":"$file"},{"containerName":"_parseHead","name":"$cur","line":986,"kind":13},{"line":987,"kind":13,"containerName":"_parseHead","name":"$cur"},{"name":"$cur","containerName":"_parseHead","line":987,"kind":13},{"containerName":"_parseHead","name":"@src","kind":13,"line":988},{"containerName":"_parseHead","name":"$cur","line":988,"kind":13},{"containerName":"_parseHead","name":"$cur","kind":13,"line":989},{"line":989,"kind":13,"containerName":"_parseHead","name":"$file"},{"containerName":"_parseHead","name":"$cur","line":992,"kind":13},{"containerName":"_parseHead","name":"$cur","line":993,"kind":13},{"kind":13,"line":993,"name":"$cur","containerName":"_parseHead"},{"containerName":"_parseHead","name":"@aut","line":994,"kind":13},{"kind":13,"line":994,"name":"$cur","containerName":"_parseHead"},{"kind":13,"line":995,"name":"$cur","containerName":"_parseHead"},{"name":"$file","containerName":"_parseHead","kind":13,"line":995},{"kind":13,"line":998,"containerName":"_parseHead","name":"$head"},{"line":998,"kind":13,"containerName":"_parseHead","name":"@cmp"},{"line":999,"kind":13,"name":"$head","containerName":"_parseHead"},{"kind":13,"line":999,"name":"@src","containerName":"_parseHead"},{"kind":13,"line":1000,"containerName":"_parseHead","name":"$head"},{"line":1000,"kind":13,"containerName":"_parseHead","name":"@aut"},{"containerName":"_parseHead","name":"$self","line":1001,"kind":13},{"name":"%head","containerName":"_parseHead","line":1001,"kind":13}],"kind":12},{"range":{"end":{"character":9999,"line":1049},"start":{"line":1016,"character":0}},"definition":"sub","name":"_parseSummary","containerName":"main::","children":[{"line":1017,"kind":13,"localvar":"my","containerName":"_parseSummary","name":"$self","definition":"my"},{"line":1018,"kind":13,"localvar":"my","containerName":"_parseSummary","name":"$io","definition":"my"},{"definition":"my","name":"$file","containerName":"_parseSummary","localvar":"my","kind":13,"line":1019},{"containerName":"_parseSummary","name":"$io","line":1019,"kind":13},{"line":1019,"kind":12,"containerName":"_parseSummary","name":"_fh"},{"localvar":"my","definition":"my","name":"$cur","containerName":"_parseSummary","line":1020,"kind":13},{"name":"$file","containerName":"_parseSummary","line":1020,"kind":13},{"kind":13,"line":1021,"containerName":"_parseSummary","definition":"my","name":"$bound_set","localvar":"my"},{"kind":13,"line":1022,"containerName":"_parseSummary","name":"$element","definition":"my","localvar":"my"},{"kind":13,"line":1023,"name":"@elements","definition":"my","containerName":"_parseSummary","localvar":"my"},{"kind":13,"line":1023,"containerName":"_parseSummary","name":"@cur"},{"localvar":"my","definition":"my","name":"@LOC_lookup","containerName":"_parseSummary","line":1024,"kind":13},{"kind":13,"line":1033,"name":"$cur","containerName":"_parseSummary"},{"line":1034,"kind":13,"name":"$cur","containerName":"_parseSummary"},{"line":1034,"kind":13,"name":"$file","containerName":"_parseSummary"},{"name":"$cur","containerName":"_parseSummary","line":1037,"kind":13},{"name":"$bound_set","containerName":"_parseSummary","kind":13,"line":1038},{"name":"@LOC_lookup","containerName":"_parseSummary","line":1038,"kind":13},{"kind":13,"line":1039,"name":"$element","containerName":"_parseSummary"},{"name":"$cur","containerName":"_parseSummary","kind":13,"line":1039},{"line":1039,"kind":13,"name":"$bound_set","containerName":"_parseSummary"},{"name":"$bound_set","containerName":"_parseSummary","kind":13,"line":1039},{"containerName":"_parseSummary","name":"$element","line":1040,"kind":13},{"containerName":"_parseSummary","name":"@cur","kind":13,"line":1041},{"containerName":"_parseSummary","name":"$element","line":1041,"kind":13},{"containerName":"_parseSummary","name":"@elements","kind":13,"line":1043},{"kind":13,"line":1043,"name":"@cur","containerName":"_parseSummary"},{"line":1044,"kind":13,"name":"$cur","containerName":"_parseSummary"},{"containerName":"_parseSummary","name":"$file","line":1044,"kind":13},{"kind":13,"line":1045,"containerName":"_parseSummary","name":"@cur"},{"containerName":"_parseSummary","name":"$self","kind":13,"line":1047},{"name":"@elements","containerName":"_parseSummary","line":1047,"kind":13}],"line":1016,"kind":12},{"containerName":"main::","definition":"sub","name":"_parseASG","range":{"end":{"line":1117,"character":9999},"start":{"character":0,"line":1063}},"kind":12,"line":1063,"children":[{"localvar":"my","containerName":"_parseASG","definition":"my","name":"$self","line":1064,"kind":13},{"localvar":"my","containerName":"_parseASG","definition":"my","name":"$io","line":1065,"kind":13},{"name":"$file","definition":"my","containerName":"_parseASG","localvar":"my","kind":13,"line":1066},{"name":"$io","containerName":"_parseASG","line":1066,"kind":13},{"name":"_fh","containerName":"_parseASG","kind":12,"line":1066},{"definition":"my","name":"$cur","containerName":"_parseASG","localvar":"my","kind":13,"line":1067},{"line":1067,"kind":13,"name":"$file","containerName":"_parseASG"},{"line":1068,"kind":13,"localvar":"my","name":"$bound_set","definition":"my","containerName":"_parseASG"},{"kind":13,"line":1069,"name":"$ord_num","definition":"my","containerName":"_parseASG","localvar":"my"},{"line":1070,"kind":13,"localvar":"my","containerName":"_parseASG","definition":"my","name":"$chain"},{"name":"$last_chain","containerName":"_parseASG","kind":13,"line":1070},{"name":"$element","definition":"my","containerName":"_parseASG","localvar":"my","kind":13,"line":1071},{"line":1072,"kind":13,"localvar":"my","containerName":"_parseASG","name":"%ASG","definition":"my"},{"containerName":"_parseASG","definition":"my","name":"@cur","localvar":"my","kind":13,"line":1073},{"containerName":"_parseASG","name":"@elements","kind":13,"line":1073},{"localvar":"my","containerName":"_parseASG","name":"@ASG_lookup","definition":"my","line":1074,"kind":13},{"kind":13,"line":1084,"containerName":"_parseASG","name":"$cur"},{"name":"$cur","containerName":"_parseASG","kind":13,"line":1085},{"line":1085,"kind":13,"containerName":"_parseASG","name":"$file"},{"line":1088,"kind":13,"containerName":"_parseASG","name":"$cur"},{"kind":13,"line":1090,"containerName":"_parseASG","name":"$ord_num"},{"name":"$cur","containerName":"_parseASG","line":1090,"kind":13},{"line":1091,"kind":13,"name":"$ord_num","containerName":"_parseASG"},{"containerName":"_parseASG","name":"$chain","kind":13,"line":1094},{"kind":13,"line":1094,"containerName":"_parseASG","name":"$cur"},{"kind":13,"line":1096,"name":"$last_chain","containerName":"_parseASG"},{"name":"$chain","containerName":"_parseASG","kind":13,"line":1096},{"name":"$last_chain","containerName":"_parseASG","kind":13,"line":1096},{"line":1097,"kind":13,"containerName":"_parseASG","name":"$ASG"},{"kind":13,"line":1097,"name":"$last_chain","containerName":"_parseASG"},{"containerName":"_parseASG","name":"@elements","line":1097,"kind":13},{"containerName":"_parseASG","name":"@elements","kind":13,"line":1098},{"line":1102,"kind":13,"containerName":"_parseASG","name":"$bound_set"},{"containerName":"_parseASG","name":"@ASG_lookup","kind":13,"line":1102},{"kind":13,"line":1103,"containerName":"_parseASG","name":"$element"},{"line":1103,"kind":13,"containerName":"_parseASG","name":"$cur"},{"line":1103,"kind":13,"name":"$bound_set","containerName":"_parseASG"},{"containerName":"_parseASG","name":"$bound_set","line":1104,"kind":13},{"name":"$element","containerName":"_parseASG","kind":13,"line":1105},{"line":1106,"kind":13,"name":"@cur","containerName":"_parseASG"},{"line":1106,"kind":13,"name":"$element","containerName":"_parseASG"},{"line":1108,"kind":13,"containerName":"_parseASG","name":"$elements"},{"name":"$ord_num","containerName":"_parseASG","kind":13,"line":1108},{"line":1108,"kind":13,"containerName":"_parseASG","name":"@cur"},{"kind":13,"line":1109,"name":"$cur","containerName":"_parseASG"},{"containerName":"_parseASG","name":"$file","kind":13,"line":1109},{"line":1110,"kind":13,"containerName":"_parseASG","name":"@cur"},{"kind":13,"line":1111,"name":"$last_chain","containerName":"_parseASG"},{"containerName":"_parseASG","name":"$chain","line":1111,"kind":13},{"containerName":"_parseASG","name":"$ASG","line":1114,"kind":13},{"kind":13,"line":1114,"containerName":"_parseASG","name":"$chain"},{"name":"@elements","containerName":"_parseASG","kind":13,"line":1114},{"name":"$self","containerName":"_parseASG","line":1116,"kind":13},{"line":1116,"kind":13,"name":"%ASG","containerName":"_parseASG"}]}],"version":5}