{"vars":[{"containerName":"","name":"base","kind":2,"line":82},{"name":"new","range":{"start":{"character":0,"line":97},"end":{"line":113,"character":9999}},"kind":12,"children":[{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":98},{"line":98,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":99},{"kind":13,"line":99,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":99},{"line":101,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$id"},{"containerName":"new","name":"$model","line":101,"kind":13},{"kind":13,"line":101,"containerName":"new","name":"$chain"},{"name":"$residue","containerName":"new","kind":13,"line":101},{"name":"$self","containerName":"new","line":102,"kind":13},{"line":102,"kind":12,"containerName":"new","name":"_rearrange"},{"kind":13,"line":107,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","kind":13,"line":112},{"name":"$self","containerName":"new","line":113,"kind":13}],"line":97,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Entry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Structure::Entry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Kris Boulez <kris.boulez@algonomics.com>\n#\n# Copyright Kris Boulez\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Structure::Entry - Bioperl structure Object, describes the whole entry\n\n=head1 SYNOPSIS\n\n  #add synopsis here\n\n=head1 DESCRIPTION\n\nThis object stores a whole Bio::Structure entry. It can consist of one\nor more models (L<Bio::Structure::Model>), which in turn consist of one \nor more chains (L<Bio::Structure::Chain>). A chain is composed of residues \n(L<Bio::Structure::Residue>) and a residue consists of atoms \n(L<Bio::Structure::Atom>). If no specific model or chain is chosen, the \nfirst one is chosen.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Kris Boulez\n\nEmail kris.boulez@algonomics.com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal \nmethods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Structure::Entry;\nuse strict;\n\nuse Bio::Structure::Model;\nuse Bio::Structure::Chain;\nuse Bio::Annotation::Collection;\nuse Tie::RefHash;\n\nuse base qw(Bio::Root::Root Bio::Structure::StructureI);\n\n=head2 new()\n\n Title   : new()\n Usage   : $struc = Bio::Structure::Entry->new( \n                                           -id  => 'structure_id',\n                                           );\n\n Function: Returns a new Bio::Structure::Entry object from basic \n\t        constructors. Probably most called from Bio::Structure::IO.\n Returns : a new Bio::Structure::Model object","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)"},{"containerName":"new","name":"SUPER","line":99,"kind":12},{"kind":13,"line":116,"name":"%self","containerName":null},{"line":117,"kind":13,"name":"%self","containerName":null},{"line":119,"kind":13,"name":"$id","containerName":null},{"name":"$self","containerName":null,"line":119,"kind":13},{"line":119,"kind":12,"containerName":"main::","name":"id"},{"kind":13,"line":119,"containerName":null,"name":"$id"},{"name":"%self","containerName":null,"line":121,"kind":13},{"name":"$model","containerName":null,"kind":13,"line":122},{"line":122,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":122,"name":"model","containerName":"main::"},{"line":122,"kind":13,"containerName":null,"name":"$model"},{"kind":13,"line":124,"containerName":null,"name":"%chain"},{"line":125,"kind":13,"containerName":null,"name":"$self"},{"line":125,"kind":12,"containerName":"main::","name":"model"},{"containerName":null,"name":"$self","line":126,"kind":13},{"name":"_create_default_model","containerName":"main::","line":126,"kind":12},{"line":128,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$m"},{"name":"$self","containerName":null,"kind":13,"line":128},{"containerName":"main::","name":"model","line":128,"kind":12},{"kind":13,"line":129,"containerName":null,"name":"$m"},{"line":129,"kind":12,"name":"chain","containerName":"main::"},{"kind":13,"line":129,"containerName":null,"name":"$chain"},{"containerName":null,"name":"$residue","line":133,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":133},{"containerName":"main::","name":"residue","line":133,"kind":12},{"containerName":null,"name":"$residue","kind":13,"line":133},{"kind":13,"line":136,"containerName":null,"name":"$ann","definition":"my","localvar":"my"},{"containerName":"Annotation::Collection","name":"Bio","line":136,"kind":12},{"kind":12,"line":136,"containerName":"main::","name":"new"},{"kind":13,"line":137,"containerName":null,"name":"$self"},{"containerName":"main::","name":"annotation","kind":12,"line":137},{"kind":13,"line":137,"containerName":null,"name":"$ann"},{"line":139,"kind":13,"containerName":null,"name":"$self"},{"name":"model","range":{"end":{"line":177,"character":9999},"start":{"character":0,"line":154}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"model","localvar":"my","kind":13,"line":155},{"name":"$model","containerName":"model","line":155,"kind":13},{"line":157,"kind":13,"name":"$model","containerName":"model"},{"line":158,"kind":13,"name":"$model","containerName":"model"},{"line":159,"kind":13,"name":"$model","containerName":"model"},{"name":"isa","containerName":"model","line":159,"kind":12},{"localvar":"my","name":"@obj","definition":"my","containerName":"model","line":161,"kind":13},{"line":161,"kind":13,"containerName":"model","name":"$self"},{"line":161,"kind":12,"name":"model","containerName":"model"},{"name":"@obj","containerName":"model","line":162,"kind":13},{"kind":13,"line":163,"name":"$m","definition":"my","containerName":"model","localvar":"my"},{"kind":13,"line":163,"containerName":"model","name":"@obj"},{"name":"$self","containerName":"model","kind":13,"line":164},{"line":164,"kind":12,"containerName":"model","name":"_remove_from_graph"},{"line":164,"kind":13,"name":"$m","containerName":"model"},{"containerName":"model","name":"$self","kind":13,"line":165},{"containerName":"model","name":"$self","line":169,"kind":13},{"line":169,"kind":12,"containerName":"model","name":"add_model"},{"name":"$self","containerName":"model","kind":13,"line":169},{"kind":13,"line":169,"containerName":"model","name":"$model"},{"kind":13,"line":172,"name":"$self","containerName":"model"},{"containerName":"model","name":"throw","kind":12,"line":172},{"containerName":"model","name":"$self","line":176,"kind":13},{"kind":12,"line":176,"name":"get_models","containerName":"model"},{"name":"$self","containerName":"model","line":176,"kind":13}],"line":154,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"","label":"model($self,$model)"},"detail":"($self,$model)"},{"name":"add_model","range":{"start":{"line":191,"character":0},"end":{"character":9999,"line":220}},"kind":12,"line":191,"children":[{"line":192,"kind":13,"localvar":"my","containerName":"add_model","name":"$self","definition":"my"},{"containerName":"add_model","name":"$entry","kind":13,"line":192},{"kind":13,"line":192,"name":"$model","containerName":"add_model"},{"name":"$model","containerName":"add_model","line":196,"kind":13},{"containerName":"add_model","name":"$entry","kind":13,"line":196},{"containerName":"add_model","name":"$model","kind":13,"line":197},{"kind":13,"line":197,"containerName":"add_model","name":"$entry"},{"name":"$entry","containerName":"add_model","line":198,"kind":13},{"line":198,"kind":13,"name":"$self","containerName":"add_model"},{"kind":13,"line":201,"containerName":"add_model","name":"$entry"},{"containerName":"add_model","name":"$entry","line":201,"kind":13},{"kind":13,"line":202,"containerName":"add_model","name":"$self"},{"containerName":"add_model","name":"throw","line":202,"kind":12},{"kind":13,"line":204,"containerName":"add_model","name":"$model"},{"line":205,"kind":13,"name":"$model","containerName":"add_model"},{"localvar":"my","containerName":"add_model","definition":"my","name":"$m","line":207,"kind":13},{"name":"$model","containerName":"add_model","line":207,"kind":13},{"containerName":"add_model","name":"$m","line":208,"kind":13},{"kind":12,"line":208,"containerName":"add_model","name":"isa"},{"containerName":"add_model","name":"$self","kind":13,"line":209},{"kind":12,"line":209,"name":"throw","containerName":"add_model"},{"kind":13,"line":211,"name":"$self","containerName":"add_model"},{"line":211,"kind":12,"name":"_parent","containerName":"add_model"},{"containerName":"add_model","name":"$m","line":211,"kind":13},{"line":212,"kind":13,"name":"$self","containerName":"add_model"},{"kind":12,"line":212,"name":"throw","containerName":"add_model"},{"kind":13,"line":214,"name":"$self","containerName":"add_model"},{"containerName":"add_model","name":"$m","kind":13,"line":214}],"containerName":"main::","definition":"sub","detail":"($self,$entry,$model)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$model"}],"label":"add_model($self,$entry,$model)"}},{"containerName":null,"name":"$model","line":221,"kind":13},{"name":"isa","containerName":"main::","kind":12,"line":221},{"kind":13,"line":222,"name":"$self","containerName":null},{"kind":12,"line":222,"containerName":"main::","name":"_parent"},{"containerName":null,"name":"%model","line":222,"kind":13},{"containerName":null,"name":"$self","line":223,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":223},{"line":225,"kind":13,"name":"%self","containerName":null},{"line":225,"kind":13,"containerName":null,"name":"%model"},{"containerName":null,"name":"$self","kind":13,"line":231},{"line":231,"kind":12,"name":"throw","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"$array_ref","line":235,"kind":13},{"line":235,"kind":13,"containerName":null,"name":"%self"},{"line":236,"kind":13,"name":"$array_ref","containerName":null},{"kind":13,"line":236,"containerName":null,"name":"$array_ref"},{"kind":12,"children":[{"line":251,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_models"},{"containerName":"get_models","name":"$entry","kind":13,"line":251},{"line":254,"kind":13,"containerName":"get_models","name":"$entry"},{"line":255,"kind":13,"name":"$entry","containerName":"get_models"},{"line":255,"kind":13,"containerName":"get_models","name":"$self"},{"containerName":"get_models","name":"$self","line":258,"kind":13},{"line":258,"kind":12,"name":"add_model","containerName":"get_models"},{"line":258,"kind":13,"containerName":"get_models","name":"$entry"}],"line":250,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$entry"}],"label":"get_models($self,$entry)"},"detail":"($self,$entry)","name":"get_models","range":{"start":{"character":0,"line":250},"end":{"character":9999,"line":259}}},{"range":{"start":{"line":272,"character":0},"end":{"line":278,"character":9999}},"name":"id","detail":"($self,$value)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"id($self,$value)"},"containerName":"main::","definition":"sub","line":272,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"id","line":273,"kind":13},{"kind":13,"line":273,"containerName":"id","name":"$value"},{"line":274,"kind":13,"containerName":"id","name":"$value"},{"kind":13,"line":275,"name":"$self","containerName":"id"},{"line":275,"kind":13,"name":"$value","containerName":"id"},{"name":"$self","containerName":"id","kind":13,"line":277}],"kind":12},{"line":291,"children":[{"kind":13,"line":292,"definition":"my","name":"$self","containerName":"chain","localvar":"my"},{"kind":13,"line":292,"name":"$chain","containerName":"chain"},{"line":294,"kind":13,"name":"$self","containerName":"chain"},{"kind":12,"line":294,"name":"model","containerName":"chain"},{"line":295,"kind":13,"containerName":"chain","name":"$self"},{"name":"_create_default_model","containerName":"chain","line":295,"kind":12},{"line":297,"kind":13,"localvar":"my","name":"@models","definition":"my","containerName":"chain"},{"name":"$self","containerName":"chain","line":297,"kind":13},{"line":297,"kind":12,"containerName":"chain","name":"model"},{"containerName":"chain","name":"$first_model","definition":"my","localvar":"my","kind":13,"line":298},{"containerName":"chain","name":"$models","kind":13,"line":298},{"containerName":"chain","name":"$chain","line":300,"kind":13},{"name":"$chain","containerName":"chain","kind":13,"line":302},{"kind":13,"line":302,"name":"$chain","containerName":"chain"},{"name":"isa","containerName":"chain","line":302,"kind":12},{"kind":13,"line":304,"containerName":"chain","definition":"my","name":"@obj","localvar":"my"},{"line":304,"kind":13,"containerName":"chain","name":"$self"},{"kind":12,"line":304,"containerName":"chain","name":"get_chains"},{"line":304,"kind":13,"containerName":"chain","name":"$first_model"},{"kind":13,"line":305,"name":"@obj","containerName":"chain"},{"kind":13,"line":306,"name":"$c","definition":"my","containerName":"chain","localvar":"my"},{"kind":13,"line":306,"name":"@obj","containerName":"chain"},{"kind":13,"line":307,"containerName":"chain","name":"$self"},{"name":"_remove_from_graph","containerName":"chain","line":307,"kind":12},{"kind":13,"line":307,"name":"$c","containerName":"chain"},{"containerName":"chain","name":"$self","line":311,"kind":13},{"kind":12,"line":311,"name":"add_chain","containerName":"chain"},{"name":"$first_model","containerName":"chain","line":311,"kind":13},{"containerName":"chain","name":"$chain","line":311,"kind":13},{"name":"$self","containerName":"chain","kind":13,"line":314},{"line":314,"kind":12,"containerName":"chain","name":"throw"},{"containerName":"chain","name":"$self","line":317,"kind":13},{"kind":12,"line":317,"containerName":"chain","name":"get_chains"},{"name":"$first_model","containerName":"chain","line":317,"kind":13}],"kind":12,"detail":"($self,$chain)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$chain"}],"label":"chain($self,$chain)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":318},"start":{"line":291,"character":0}},"name":"chain"},{"detail":"($self,$model,$chain)","signature":{"parameters":[{"label":"$self"},{"label":"$model"},{"label":"$chain"}],"documentation":"","label":"add_chain($self,$model,$chain)"},"containerName":"main::","definition":"sub","line":332,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_chain","line":333,"kind":13},{"name":"$model","containerName":"add_chain","line":333,"kind":13},{"name":"$chain","containerName":"add_chain","line":333,"kind":13},{"containerName":"add_chain","name":"$model","kind":13,"line":335},{"name":"$self","containerName":"add_chain","line":336,"kind":13},{"name":"throw","containerName":"add_chain","line":336,"kind":12},{"containerName":"add_chain","name":"$chain","kind":13,"line":338},{"kind":13,"line":339,"name":"$chain","containerName":"add_chain"},{"line":341,"kind":13,"localvar":"my","containerName":"add_chain","name":"$c","definition":"my"},{"line":341,"kind":13,"containerName":"add_chain","name":"$chain"},{"name":"$c","containerName":"add_chain","line":342,"kind":13},{"containerName":"add_chain","name":"isa","kind":12,"line":342},{"line":343,"kind":13,"name":"$self","containerName":"add_chain"},{"kind":12,"line":343,"name":"throw","containerName":"add_chain"},{"line":345,"kind":13,"name":"$self","containerName":"add_chain"},{"name":"_parent","containerName":"add_chain","line":345,"kind":12},{"line":345,"kind":13,"containerName":"add_chain","name":"$c"},{"line":346,"kind":13,"name":"$self","containerName":"add_chain"},{"containerName":"add_chain","name":"throw","line":346,"kind":12},{"containerName":"add_chain","name":"$self","kind":13,"line":348},{"name":"_parent","containerName":"add_chain","line":348,"kind":12},{"name":"$c","containerName":"add_chain","kind":13,"line":348},{"containerName":"add_chain","name":"$model","line":348,"kind":13},{"line":349,"kind":13,"name":"$self","containerName":"add_chain"},{"containerName":"add_chain","name":"_child","kind":12,"line":349},{"kind":13,"line":349,"containerName":"add_chain","name":"$model"},{"containerName":"add_chain","name":"$c","kind":13,"line":349},{"name":"$chain","containerName":"add_chain","line":355,"kind":13},{"containerName":"add_chain","name":"isa","line":355,"kind":12},{"line":356,"kind":13,"containerName":"add_chain","name":"$self"},{"kind":12,"line":356,"containerName":"add_chain","name":"_parent"},{"line":356,"kind":13,"name":"$chain","containerName":"add_chain"},{"name":"$self","containerName":"add_chain","line":357,"kind":13},{"name":"throw","containerName":"add_chain","line":357,"kind":12},{"containerName":"add_chain","name":"$self","line":359,"kind":13},{"containerName":"add_chain","name":"_parent","line":359,"kind":12},{"line":359,"kind":13,"containerName":"add_chain","name":"$chain"},{"containerName":"add_chain","name":"$model","kind":13,"line":359},{"containerName":"add_chain","name":"$self","line":360,"kind":13},{"containerName":"add_chain","name":"_child","kind":12,"line":360},{"containerName":"add_chain","name":"$model","kind":13,"line":360},{"name":"$chain","containerName":"add_chain","line":360,"kind":13},{"kind":13,"line":366,"name":"$self","containerName":"add_chain"},{"kind":12,"line":366,"containerName":"add_chain","name":"throw"}],"kind":12,"range":{"start":{"character":0,"line":332},"end":{"line":368,"character":9999}},"name":"add_chain"},{"kind":13,"line":369,"containerName":null,"name":"$array_ref","definition":"my","localvar":"my"},{"containerName":null,"name":"$self","kind":13,"line":369},{"name":"_child","containerName":"main::","line":369,"kind":12},{"kind":13,"line":369,"name":"$model","containerName":null},{"line":370,"kind":13,"containerName":null,"name":"$array_ref"},{"kind":13,"line":370,"name":"$array_ref","containerName":null},{"name":"get_chains","range":{"start":{"line":384,"character":0},"end":{"line":392,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$model)","signature":{"parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"","label":"get_chains($self,$model)"},"kind":12,"line":384,"children":[{"localvar":"my","containerName":"get_chains","name":"$self","definition":"my","line":385,"kind":13},{"name":"$model","containerName":"get_chains","kind":13,"line":385},{"line":387,"kind":13,"containerName":"get_chains","name":"$model"},{"kind":13,"line":388,"name":"$model","containerName":"get_chains"},{"name":"$self","containerName":"get_chains","kind":13,"line":388},{"name":"get_models","containerName":"get_chains","line":388,"kind":12},{"kind":13,"line":391,"name":"$self","containerName":"get_chains"},{"kind":12,"line":391,"name":"add_chain","containerName":"get_chains"},{"line":391,"kind":13,"name":"$model","containerName":"get_chains"}]},{"containerName":"main::","definition":"sub","detail":"($self,$residue)","signature":{"parameters":[{"label":"$self"},{"label":"$residue"}],"documentation":"","label":"residue($self,$residue)"},"kind":12,"line":405,"children":[{"localvar":"my","containerName":"residue","name":"$self","definition":"my","line":406,"kind":13},{"kind":13,"line":406,"name":"$residue","containerName":"residue"},{"name":"$self","containerName":"residue","line":408,"kind":13},{"containerName":"residue","name":"model","kind":12,"line":408},{"localvar":"my","name":"$m","definition":"my","containerName":"residue","line":409,"kind":13},{"containerName":"residue","name":"$self","line":409,"kind":13},{"kind":12,"line":409,"containerName":"residue","name":"_create_default_model"},{"containerName":"residue","name":"$self","line":410,"kind":13},{"line":410,"kind":12,"containerName":"residue","name":"add_model"},{"kind":13,"line":410,"name":"$self","containerName":"residue"},{"kind":13,"line":410,"name":"$m","containerName":"residue"},{"kind":13,"line":412,"name":"@models","definition":"my","containerName":"residue","localvar":"my"},{"containerName":"residue","name":"$self","kind":13,"line":412},{"containerName":"residue","name":"model","line":412,"kind":12},{"localvar":"my","name":"$first_model","definition":"my","containerName":"residue","line":413,"kind":13},{"line":413,"kind":13,"containerName":"residue","name":"$models"},{"kind":13,"line":415,"name":"$self","containerName":"residue"},{"line":415,"kind":12,"name":"get_chains","containerName":"residue"},{"name":"$first_model","containerName":"residue","line":415,"kind":13},{"definition":"my","name":"$c","containerName":"residue","localvar":"my","kind":13,"line":416},{"containerName":"residue","name":"$self","line":416,"kind":13},{"name":"_create_default_chain","containerName":"residue","kind":12,"line":416},{"name":"$self","containerName":"residue","kind":13,"line":417},{"kind":12,"line":417,"name":"add_chain","containerName":"residue"},{"kind":13,"line":417,"name":"$first_model","containerName":"residue"},{"kind":13,"line":417,"containerName":"residue","name":"$c"},{"localvar":"my","definition":"my","name":"@chains","containerName":"residue","line":419,"kind":13},{"line":419,"kind":13,"containerName":"residue","name":"$self"},{"name":"get_chains","containerName":"residue","line":419,"kind":12},{"line":419,"kind":13,"name":"$first_model","containerName":"residue"},{"containerName":"residue","definition":"my","name":"$first_chain","localvar":"my","kind":13,"line":420},{"kind":13,"line":420,"name":"$chains","containerName":"residue"},{"kind":13,"line":422,"containerName":"residue","name":"$residue"},{"containerName":"residue","name":"$residue","line":423,"kind":13},{"name":"$residue","containerName":"residue","line":424,"kind":13},{"name":"isa","containerName":"residue","kind":12,"line":424},{"kind":13,"line":426,"containerName":"residue","name":"@obj","definition":"my","localvar":"my"},{"name":"$self","containerName":"residue","kind":13,"line":426},{"kind":12,"line":426,"containerName":"residue","name":"get_residues"},{"containerName":"residue","name":"$first_chain","line":426,"kind":13},{"kind":13,"line":427,"name":"@obj","containerName":"residue"},{"kind":13,"line":428,"definition":"my","name":"$r","containerName":"residue","localvar":"my"},{"name":"@obj","containerName":"residue","kind":13,"line":428},{"containerName":"residue","name":"$self","kind":13,"line":429},{"kind":12,"line":429,"containerName":"residue","name":"_remove_from_graph"},{"line":429,"kind":13,"name":"$r","containerName":"residue"},{"kind":13,"line":433,"name":"$self","containerName":"residue"},{"line":433,"kind":12,"containerName":"residue","name":"add_residue"},{"name":"$first_chain","containerName":"residue","kind":13,"line":433},{"line":433,"kind":13,"name":"$residue","containerName":"residue"},{"containerName":"residue","name":"$self","line":436,"kind":13},{"line":436,"kind":12,"containerName":"residue","name":"throw"},{"line":439,"kind":13,"name":"$self","containerName":"residue"},{"line":439,"kind":12,"name":"get_residues","containerName":"residue"},{"name":"$first_chain","containerName":"residue","line":439,"kind":13}],"name":"residue","range":{"end":{"character":9999,"line":440},"start":{"character":0,"line":405}}},{"range":{"start":{"line":454,"character":0},"end":{"character":9999,"line":490}},"name":"add_residue","line":454,"children":[{"containerName":"add_residue","name":"$self","definition":"my","localvar":"my","kind":13,"line":455},{"line":455,"kind":13,"name":"$chain","containerName":"add_residue"},{"kind":13,"line":455,"name":"$residue","containerName":"add_residue"},{"containerName":"add_residue","name":"$chain","kind":13,"line":457},{"name":"$self","containerName":"add_residue","line":458,"kind":13},{"name":"throw","containerName":"add_residue","kind":12,"line":458},{"containerName":"add_residue","name":"$residue","kind":13,"line":460},{"name":"$residue","containerName":"add_residue","line":461,"kind":13},{"kind":13,"line":463,"name":"$r","definition":"my","containerName":"add_residue","localvar":"my"},{"containerName":"add_residue","name":"$residue","line":463,"kind":13},{"containerName":"add_residue","name":"$r","line":464,"kind":13},{"containerName":"add_residue","name":"isa","kind":12,"line":464},{"line":465,"kind":13,"name":"$self","containerName":"add_residue"},{"name":"throw","containerName":"add_residue","line":465,"kind":12},{"containerName":"add_residue","name":"$self","kind":13,"line":467},{"name":"_parent","containerName":"add_residue","kind":12,"line":467},{"kind":13,"line":467,"containerName":"add_residue","name":"$r"},{"kind":13,"line":468,"name":"$self","containerName":"add_residue"},{"containerName":"add_residue","name":"throw","line":468,"kind":12},{"line":470,"kind":13,"containerName":"add_residue","name":"$self"},{"kind":12,"line":470,"containerName":"add_residue","name":"_parent"},{"containerName":"add_residue","name":"$r","line":470,"kind":13},{"line":470,"kind":13,"containerName":"add_residue","name":"$chain"},{"kind":13,"line":471,"containerName":"add_residue","name":"$self"},{"containerName":"add_residue","name":"_child","kind":12,"line":471},{"containerName":"add_residue","name":"$chain","kind":13,"line":471},{"containerName":"add_residue","name":"$r","line":471,"kind":13},{"kind":13,"line":473,"containerName":"add_residue","definition":"my","name":"$str_ref","localvar":"my"},{"line":474,"kind":13,"name":"$r","containerName":"add_residue"},{"kind":12,"line":474,"containerName":"add_residue","name":"_grandparent"},{"containerName":"add_residue","name":"$str_ref","line":474,"kind":13},{"name":"$residue","containerName":"add_residue","kind":13,"line":477},{"kind":12,"line":477,"containerName":"add_residue","name":"isa"},{"kind":13,"line":478,"name":"$self","containerName":"add_residue"},{"line":478,"kind":12,"name":"_parent","containerName":"add_residue"},{"kind":13,"line":478,"containerName":"add_residue","name":"$residue"},{"line":479,"kind":13,"name":"$self","containerName":"add_residue"},{"name":"throw","containerName":"add_residue","kind":12,"line":479},{"name":"$self","containerName":"add_residue","kind":13,"line":481},{"name":"_parent","containerName":"add_residue","kind":12,"line":481},{"line":481,"kind":13,"containerName":"add_residue","name":"$residue"},{"name":"$chain","containerName":"add_residue","kind":13,"line":481},{"line":482,"kind":13,"containerName":"add_residue","name":"$self"},{"name":"_child","containerName":"add_residue","kind":12,"line":482},{"name":"$chain","containerName":"add_residue","kind":13,"line":482},{"line":482,"kind":13,"containerName":"add_residue","name":"$residue"},{"containerName":"add_residue","definition":"my","name":"$str_ref","localvar":"my","kind":13,"line":484},{"kind":13,"line":485,"containerName":"add_residue","name":"$residue"},{"kind":12,"line":485,"name":"_grandparent","containerName":"add_residue"},{"name":"$str_ref","containerName":"add_residue","kind":13,"line":485},{"kind":13,"line":488,"containerName":"add_residue","name":"$self"},{"name":"throw","containerName":"add_residue","kind":12,"line":488}],"kind":12,"detail":"($self,$chain,$residue)","signature":{"label":"add_residue($self,$chain,$residue)","parameters":[{"label":"$self"},{"label":"$chain"},{"label":"$residue"}],"documentation":""},"containerName":"main::","definition":"sub"},{"name":"$array_ref","definition":"my","containerName":null,"localvar":"my","kind":13,"line":491},{"line":491,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":491,"containerName":"main::","name":"_child"},{"containerName":null,"name":"$chain","line":491,"kind":13},{"name":"$array_ref","containerName":null,"kind":13,"line":492},{"name":"$array_ref","containerName":null,"line":492,"kind":13},{"kind":12,"line":506,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_residues","line":507,"kind":13},{"name":"$chain","containerName":"get_residues","kind":13,"line":507},{"containerName":"get_residues","name":"$chain","line":509,"kind":13},{"kind":13,"line":510,"name":"$self","containerName":"get_residues"},{"containerName":"get_residues","name":"throw","line":510,"kind":12},{"line":513,"kind":13,"name":"$self","containerName":"get_residues"},{"name":"add_residue","containerName":"get_residues","kind":12,"line":513},{"kind":13,"line":513,"containerName":"get_residues","name":"$chain"}],"containerName":"main::","definition":"sub","detail":"($self,$chain)","signature":{"label":"get_residues($self,$chain)","documentation":"","parameters":[{"label":"$self"},{"label":"$chain"}]},"name":"get_residues","range":{"start":{"character":0,"line":506},"end":{"character":9999,"line":514}}},{"detail":"($self,$residue,$atom)","signature":{"parameters":[{"label":"$self"},{"label":"$residue"},{"label":"$atom"}],"documentation":"","label":"add_atom($self,$residue,$atom)"},"containerName":"main::","definition":"sub","line":527,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_atom","line":528,"kind":13},{"line":528,"kind":13,"containerName":"add_atom","name":"$residue"},{"kind":13,"line":528,"name":"$atom","containerName":"add_atom"},{"line":530,"kind":13,"containerName":"add_atom","name":"$residue"},{"name":"$self","containerName":"add_atom","kind":13,"line":531},{"containerName":"add_atom","name":"throw","line":531,"kind":12},{"name":"$atom","containerName":"add_atom","kind":13,"line":533},{"line":534,"kind":13,"name":"$atom","containerName":"add_atom"},{"line":536,"kind":13,"localvar":"my","containerName":"add_atom","definition":"my","name":"$a"},{"kind":13,"line":536,"name":"$atom","containerName":"add_atom"},{"containerName":"add_atom","name":"$a","line":537,"kind":13},{"name":"isa","containerName":"add_atom","kind":12,"line":537},{"containerName":"add_atom","name":"$self","line":538,"kind":13},{"line":538,"kind":12,"name":"throw","containerName":"add_atom"},{"containerName":"add_atom","name":"$self","line":540,"kind":13},{"name":"_parent","containerName":"add_atom","line":540,"kind":12},{"name":"$a","containerName":"add_atom","kind":13,"line":540},{"containerName":"add_atom","name":"$self","line":541,"kind":13},{"line":541,"kind":12,"name":"throw","containerName":"add_atom"},{"containerName":"add_atom","name":"$self","line":543,"kind":13},{"name":"_parent","containerName":"add_atom","kind":12,"line":543},{"line":543,"kind":13,"containerName":"add_atom","name":"$a"},{"line":543,"kind":13,"containerName":"add_atom","name":"$residue"},{"line":544,"kind":13,"containerName":"add_atom","name":"$self"},{"name":"_child","containerName":"add_atom","line":544,"kind":12},{"name":"$residue","containerName":"add_atom","line":544,"kind":13},{"kind":13,"line":544,"containerName":"add_atom","name":"$a"},{"kind":13,"line":551,"name":"$atom","containerName":"add_atom"},{"kind":13,"line":552,"name":"$self","containerName":"add_atom"},{"kind":12,"line":552,"name":"_parent","containerName":"add_atom"},{"line":552,"kind":13,"name":"$atom","containerName":"add_atom"},{"containerName":"add_atom","name":"$self","kind":13,"line":553},{"name":"throw","containerName":"add_atom","line":553,"kind":12},{"containerName":"add_atom","name":"$self","kind":13,"line":555},{"name":"_parent","containerName":"add_atom","line":555,"kind":12},{"kind":13,"line":555,"name":"$atom","containerName":"add_atom"},{"name":"$residue","containerName":"add_atom","line":555,"kind":13},{"name":"$self","containerName":"add_atom","kind":13,"line":556},{"containerName":"add_atom","name":"_child","line":556,"kind":12},{"name":"$residue","containerName":"add_atom","kind":13,"line":556},{"name":"$atom","containerName":"add_atom","line":556,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":527},"end":{"line":561,"character":9999}},"name":"add_atom"},{"line":562,"kind":13,"localvar":"my","containerName":null,"name":"$array_ref","definition":"my"},{"containerName":null,"name":"$self","kind":13,"line":562},{"name":"_child","containerName":"main::","line":562,"kind":12},{"containerName":null,"name":"$residue","line":562,"kind":13},{"kind":13,"line":563,"containerName":null,"name":"$array_ref"},{"line":563,"kind":13,"containerName":null,"name":"$array_ref"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$residue"}],"documentation":"","label":"get_atoms($self,$residue)"},"detail":"($self,$residue)","kind":12,"children":[{"kind":13,"line":578,"containerName":"get_atoms","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":578,"containerName":"get_atoms","name":"$residue"},{"containerName":"get_atoms","name":"$residue","kind":13,"line":580},{"kind":13,"line":581,"containerName":"get_atoms","name":"$self"},{"kind":12,"line":581,"name":"throw","containerName":"get_atoms"},{"kind":13,"line":584,"containerName":"get_atoms","name":"$self"},{"line":584,"kind":12,"containerName":"get_atoms","name":"add_atom"},{"line":584,"kind":13,"containerName":"get_atoms","name":"$residue"}],"line":577,"name":"get_atoms","range":{"start":{"line":577,"character":0},"end":{"character":9999,"line":585}}},{"range":{"start":{"character":0,"line":608},"end":{"character":9999,"line":611}},"definition":"sub","name":"connect","containerName":"main::","children":[{"localvar":"my","containerName":"connect","name":"$self","definition":"my","line":609,"kind":13},{"containerName":"connect","name":"$self","kind":13,"line":610},{"line":610,"kind":12,"name":"conect","containerName":"connect"}],"line":608,"kind":12},{"name":"conect","range":{"start":{"line":625,"character":0},"end":{"line":633,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$source,$serial,$type)","signature":{"label":"conect($self,$source,$serial,$type)","documentation":"","parameters":[{"label":"$self"},{"label":"$source"},{"label":"$serial"},{"label":"$type"}]},"kind":12,"line":625,"children":[{"kind":13,"line":626,"name":"$self","definition":"my","containerName":"conect","localvar":"my"},{"kind":13,"line":626,"name":"$source","containerName":"conect"},{"containerName":"conect","name":"$serial","line":626,"kind":13},{"kind":13,"line":626,"containerName":"conect","name":"$type"},{"line":628,"kind":13,"name":"$source","containerName":"conect"},{"kind":13,"line":629,"name":"$self","containerName":"conect"},{"line":629,"kind":12,"containerName":"conect","name":"throw"},{"line":631,"kind":13,"containerName":"conect","name":"$serial"},{"kind":13,"line":631,"containerName":"conect","name":"$type"},{"name":"$self","containerName":"conect","kind":13,"line":632},{"line":632,"kind":13,"containerName":"conect","name":"$source"},{"line":633,"kind":13,"name":"$self","containerName":"conect"}]},{"kind":13,"line":633,"containerName":null,"name":"%source"},{"line":634,"kind":13,"name":"%self","containerName":null},{"name":"@source","containerName":null,"line":634,"kind":13},{"containerName":null,"name":"$c","definition":"my","localvar":"my","kind":13,"line":637},{"name":"$serial","containerName":null,"line":637,"kind":13},{"kind":13,"line":637,"containerName":null,"name":"$type"},{"line":638,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"$source","line":638,"kind":13},{"containerName":null,"name":"$c","kind":13,"line":638},{"name":"%self","containerName":null,"kind":13,"line":641},{"containerName":null,"name":"$source","kind":13,"line":641},{"containerName":null,"name":"%self","kind":13,"line":642},{"line":642,"kind":13,"name":"$source","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":643},{"kind":13,"line":643,"name":"$source","containerName":null},{"line":656,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_all_connect_source","line":657,"kind":13}],"kind":12,"range":{"end":{"line":659,"character":9999},"start":{"line":656,"character":0}},"containerName":"main::","name":"get_all_connect_source","definition":"sub"},{"name":"get_all_conect_source","line":658,"kind":12},{"children":[{"line":676,"kind":13,"localvar":"my","containerName":"get_all_conect_source","definition":"my","name":"$self"},{"definition":"my","name":"@sources","containerName":"get_all_conect_source","localvar":"my","kind":13,"line":677},{"localvar":"my","name":"$source","definition":"my","containerName":"get_all_conect_source","line":679,"kind":13},{"line":679,"kind":13,"containerName":"get_all_conect_source","name":"$a"},{"containerName":"get_all_conect_source","name":"$b","kind":13,"line":679},{"kind":13,"line":679,"name":"$self","containerName":"get_all_conect_source"}],"line":675,"kind":12,"range":{"end":{"character":9999,"line":679},"start":{"character":0,"line":675}},"name":"get_all_conect_source","definition":"sub","containerName":"main::"},{"kind":13,"line":680,"containerName":null,"name":"@sources"},{"kind":13,"line":680,"name":"$source","containerName":null},{"kind":13,"line":682,"name":"@sources","containerName":null},{"range":{"start":{"line":696,"character":0},"end":{"line":702,"character":9999}},"name":"master","children":[{"kind":13,"line":697,"containerName":"master","definition":"my","name":"$self","localvar":"my"},{"line":697,"kind":13,"containerName":"master","name":"$value"},{"name":"$value","containerName":"master","line":698,"kind":13},{"containerName":"master","name":"$self","kind":13,"line":699},{"line":699,"kind":13,"name":"$value","containerName":"master"},{"line":701,"kind":13,"containerName":"master","name":"$self"}],"line":696,"kind":12,"signature":{"label":"master($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":""},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"seqres","range":{"end":{"character":9999,"line":756},"start":{"character":0,"line":717}},"containerName":"main::","definition":"sub","detail":"($self,$chainid)","signature":{"label":"seqres($self,$chainid)","documentation":"","parameters":[{"label":"$self"},{"label":"$chainid"}]},"kind":12,"line":717,"children":[{"line":718,"kind":13,"localvar":"my","containerName":"seqres","definition":"my","name":"$self"},{"name":"$chainid","containerName":"seqres","line":718,"kind":13},{"line":719,"kind":13,"localvar":"my","containerName":"seqres","definition":"my","name":"$s_u"},{"kind":13,"line":720,"name":"%seq_ch","definition":"my","containerName":"seqres","localvar":"my"},{"containerName":"seqres","name":"$chainid","kind":13,"line":721},{"line":722,"kind":13,"localvar":"my","name":"$m","definition":"my","containerName":"seqres"},{"name":"$self","containerName":"seqres","kind":13,"line":722},{"name":"get_models","containerName":"seqres","line":722,"kind":12},{"containerName":"seqres","name":"$self","line":722,"kind":13},{"line":723,"kind":13,"localvar":"my","definition":"my","name":"$c","containerName":"seqres"},{"name":"$self","containerName":"seqres","line":723,"kind":13},{"containerName":"seqres","name":"get_chains","line":723,"kind":12},{"line":723,"kind":13,"containerName":"seqres","name":"$m"},{"name":"$chainid","containerName":"seqres","kind":13,"line":724},{"name":"$c","containerName":"seqres","line":724,"kind":13},{"containerName":"seqres","name":"id","line":724,"kind":12},{"kind":13,"line":726,"definition":"my","name":"$seqres","containerName":"seqres","localvar":"my"},{"kind":13,"line":726,"name":"$self","containerName":"seqres"},{"containerName":"seqres","name":"annotation","line":726,"kind":12},{"kind":12,"line":726,"containerName":"seqres","name":"get_Annotations"},{"name":"$seqres_string","definition":"my","containerName":"seqres","localvar":"my","kind":13,"line":727},{"kind":13,"line":727,"name":"$seqres","containerName":"seqres"},{"name":"as_text","containerName":"seqres","kind":12,"line":727},{"kind":13,"line":728,"containerName":"seqres","name":"$self"},{"containerName":"seqres","name":"debug","kind":12,"line":728},{"kind":13,"line":729,"name":"$seqres_string","containerName":"seqres"},{"localvar":"my","name":"@l","definition":"my","containerName":"seqres","line":731,"kind":13},{"line":731,"kind":13,"name":"$seqres_string","containerName":"seqres"},{"line":731,"kind":13,"containerName":"seqres","name":"$seqres_string"},{"kind":13,"line":732,"name":"$line","definition":"my","containerName":"seqres","localvar":"my"},{"containerName":"seqres","name":"@l","kind":13,"line":732},{"definition":"my","name":"$chid","containerName":"seqres","localvar":"my","kind":13,"line":735},{"name":"$seq","containerName":"seqres","line":735,"kind":13},{"kind":13,"line":735,"containerName":"seqres","name":"$line"},{"name":"$chid","containerName":"seqres","kind":13,"line":736},{"containerName":"seqres","name":"$chid","line":737,"kind":13},{"name":"$seq","containerName":"seqres","line":739,"kind":13},{"line":740,"kind":13,"name":"$seq","containerName":"seqres"},{"name":"$seq_ch","containerName":"seqres","line":741,"kind":13},{"name":"$chid","containerName":"seqres","kind":13,"line":741},{"line":741,"kind":13,"name":"$seq","containerName":"seqres"},{"containerName":"seqres","name":"$self","line":742,"kind":13},{"containerName":"seqres","name":"debug","kind":12,"line":742},{"kind":13,"line":745,"containerName":"seqres","name":"$seq_ch"},{"kind":13,"line":745,"name":"$chainid","containerName":"seqres"},{"kind":13,"line":746,"containerName":"seqres","name":"$self"},{"containerName":"seqres","name":"warn","line":746,"kind":12},{"definition":"my","name":"$pseq","containerName":"seqres","localvar":"my","kind":13,"line":751},{"kind":12,"line":751,"containerName":"seqres","name":"new"},{"containerName":"seqres","name":"$pseq","kind":13,"line":752},{"containerName":"seqres","name":"seq3in","kind":12,"line":752},{"name":"$pseq","containerName":"seqres","line":752,"kind":13},{"kind":13,"line":752,"name":"$seq_ch","containerName":"seqres"},{"name":"$chainid","containerName":"seqres","line":752,"kind":13},{"containerName":"seqres","definition":"my","name":"$id","localvar":"my","kind":13,"line":753},{"line":753,"kind":13,"containerName":"seqres","name":"$self"},{"name":"id","containerName":"seqres","line":753,"kind":12},{"name":"$chainid","containerName":"seqres","line":753,"kind":13},{"name":"$pseq","containerName":"seqres","line":754,"kind":13},{"kind":12,"line":754,"containerName":"seqres","name":"id"},{"line":754,"kind":13,"containerName":"seqres","name":"$id"},{"containerName":"seqres","name":"$pseq","line":755,"kind":13}]},{"containerName":"PrimarySeq","name":"Bio","line":751,"kind":12},{"line":752,"kind":12,"containerName":"SeqUtils","name":"Bio"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$model"},{"label":"$serial"}],"documentation":"","label":"get_atom_by_serial($self,$model,$serial)"},"detail":"($self,$model,$serial)","kind":12,"children":[{"line":771,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_atom_by_serial"},{"line":771,"kind":13,"containerName":"get_atom_by_serial","name":"$model"},{"name":"$serial","containerName":"get_atom_by_serial","kind":13,"line":771},{"name":"$model","containerName":"get_atom_by_serial","kind":13,"line":773},{"kind":13,"line":773,"name":"$serial","containerName":"get_atom_by_serial"},{"kind":13,"line":774,"name":"$serial","containerName":"get_atom_by_serial"},{"line":774,"kind":13,"containerName":"get_atom_by_serial","name":"$model"},{"line":775,"kind":13,"localvar":"my","name":"@m","definition":"my","containerName":"get_atom_by_serial"},{"line":775,"kind":13,"name":"$self","containerName":"get_atom_by_serial"},{"containerName":"get_atom_by_serial","name":"get_models","kind":12,"line":775},{"kind":13,"line":775,"containerName":"get_atom_by_serial","name":"$self"},{"line":776,"kind":13,"name":"$model","containerName":"get_atom_by_serial"},{"kind":13,"line":776,"name":"$m","containerName":"get_atom_by_serial"},{"containerName":"get_atom_by_serial","name":"$model","line":778,"kind":13},{"name":"$model","containerName":"get_atom_by_serial","kind":13,"line":778},{"containerName":"get_atom_by_serial","name":"$self","kind":13,"line":779},{"line":779,"kind":12,"name":"throw","containerName":"get_atom_by_serial"},{"name":"$serial","containerName":"get_atom_by_serial","kind":13,"line":781},{"kind":13,"line":781,"containerName":"get_atom_by_serial","name":"$serial"},{"line":782,"kind":13,"name":"$self","containerName":"get_atom_by_serial"},{"name":"throw","containerName":"get_atom_by_serial","line":782,"kind":12},{"containerName":"get_atom_by_serial","name":"$chain","definition":"my","localvar":"my","kind":13,"line":784},{"kind":13,"line":784,"name":"$self","containerName":"get_atom_by_serial"},{"line":784,"kind":12,"containerName":"get_atom_by_serial","name":"get_chains"},{"containerName":"get_atom_by_serial","name":"$model","line":784,"kind":13},{"localvar":"my","name":"$residue","definition":"my","containerName":"get_atom_by_serial","line":785,"kind":13},{"containerName":"get_atom_by_serial","name":"$self","line":785,"kind":13},{"name":"get_residues","containerName":"get_atom_by_serial","line":785,"kind":12},{"containerName":"get_atom_by_serial","name":"$chain","line":785,"kind":13},{"line":786,"kind":13,"localvar":"my","definition":"my","name":"$atom","containerName":"get_atom_by_serial"},{"containerName":"get_atom_by_serial","name":"$self","kind":13,"line":786},{"kind":12,"line":786,"name":"get_atoms","containerName":"get_atom_by_serial"},{"kind":13,"line":786,"containerName":"get_atom_by_serial","name":"$residue"},{"containerName":"get_atom_by_serial","name":"$atom","line":788,"kind":13},{"line":788,"kind":12,"name":"serial","containerName":"get_atom_by_serial"},{"kind":13,"line":788,"containerName":"get_atom_by_serial","name":"$serial"},{"kind":13,"line":789,"name":"$atom","containerName":"get_atom_by_serial"}],"line":770,"name":"get_atom_by_serial","range":{"end":{"line":793,"character":9999},"start":{"character":0,"line":770}}},{"children":[{"line":796,"kind":13,"localvar":"my","containerName":"parent","definition":"my","name":"$self"},{"kind":13,"line":796,"name":"$obj","containerName":"parent"},{"containerName":"parent","name":"$obj","kind":13,"line":798},{"containerName":"parent","name":"$self","kind":13,"line":799},{"name":"throw","containerName":"parent","kind":12,"line":799},{"kind":13,"line":803,"containerName":"parent","name":"$self"},{"name":"_parent","containerName":"parent","line":803,"kind":12},{"name":"$obj","containerName":"parent","kind":13,"line":803}],"line":795,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$obj"}],"documentation":"","label":"parent($self,$obj)"},"detail":"($self,$obj)","definition":"sub","containerName":"main::","range":{"end":{"line":804,"character":9999},"start":{"character":0,"line":795}},"name":"parent"},{"kind":12,"line":806,"children":[{"kind":13,"line":807,"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my"},{"containerName":"DESTROY","name":"$self","kind":13,"line":809}],"containerName":"main::","name":"DESTROY","definition":"sub","range":{"start":{"character":0,"line":806},"end":{"character":9999,"line":809}}},{"name":"%self","containerName":null,"line":810,"kind":13},{"containerName":"main::","definition":"sub","detail":"($obj,$value)","signature":{"label":"annotation($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":""},"kind":12,"line":824,"children":[{"containerName":"annotation","name":"$obj","definition":"my","localvar":"my","kind":13,"line":825},{"line":825,"kind":13,"name":"$value","containerName":"annotation"},{"line":826,"kind":13,"name":"$value","containerName":"annotation"},{"kind":13,"line":827,"containerName":"annotation","name":"$obj"},{"line":827,"kind":13,"name":"$value","containerName":"annotation"},{"kind":13,"line":829,"name":"$obj","containerName":"annotation"}],"name":"annotation","range":{"start":{"line":824,"character":0},"end":{"character":9999,"line":830}}},{"kind":12,"line":850,"children":[{"localvar":"my","containerName":"_remove_models","definition":"my","name":"$self","line":851,"kind":13}],"containerName":"main::","definition":"sub","name":"_remove_models","range":{"end":{"line":854,"character":9999},"start":{"line":850,"character":0}}},{"containerName":"main::","definition":"sub","name":"_create_default_model","range":{"end":{"line":873,"character":9999},"start":{"line":868,"character":0}},"kind":12,"line":868,"children":[{"kind":13,"line":869,"containerName":"_create_default_model","definition":"my","name":"$self","localvar":"my"},{"containerName":"_create_default_model","name":"$model","definition":"my","localvar":"my","kind":13,"line":871},{"containerName":"_create_default_model","name":"new","kind":12,"line":871},{"line":872,"kind":13,"name":"$model","containerName":"_create_default_model"}]},{"kind":12,"line":871,"containerName":"Structure::Model","name":"Bio"},{"line":887,"children":[{"line":888,"kind":13,"localvar":"my","containerName":"_create_default_chain","definition":"my","name":"$self"},{"line":890,"kind":13,"localvar":"my","containerName":"_create_default_chain","name":"$chain","definition":"my"},{"containerName":"_create_default_chain","name":"new","line":890,"kind":12},{"kind":13,"line":891,"containerName":"_create_default_chain","name":"$chain"}],"kind":12,"range":{"start":{"character":0,"line":887},"end":{"line":892,"character":9999}},"containerName":"main::","name":"_create_default_chain","definition":"sub"},{"line":890,"kind":12,"containerName":"Structure::Chain","name":"Bio"},{"kind":12,"line":915,"children":[{"kind":13,"line":917,"containerName":"_parent","name":"$self","definition":"my","localvar":"my"},{"name":"$key","containerName":"_parent","kind":13,"line":917},{"kind":13,"line":917,"name":"$value","containerName":"_parent"},{"line":919,"kind":13,"containerName":"_parent","name":"$key"},{"containerName":"_parent","name":"$key","kind":13,"line":919},{"name":"$self","containerName":"_parent","line":920,"kind":13},{"containerName":"_parent","name":"throw","line":920,"kind":12},{"kind":13,"line":922,"name":"$value","containerName":"_parent"},{"line":922,"kind":13,"containerName":"_parent","name":"$value"},{"kind":13,"line":923,"containerName":"_parent","name":"$self"},{"containerName":"_parent","name":"throw","line":923,"kind":12},{"name":"$value","containerName":"_parent","line":927,"kind":13},{"containerName":"_parent","name":"$self","line":929,"kind":13},{"name":"$key","containerName":"_parent","kind":13,"line":929},{"name":"$self","containerName":"_parent","kind":13,"line":930},{"line":930,"kind":13,"name":"$key","containerName":"_parent"},{"name":"$self","containerName":"_parent","kind":13,"line":932},{"containerName":"_parent","name":"throw","kind":12,"line":932},{"containerName":"_parent","name":"$self","kind":13,"line":934},{"name":"$key","containerName":"_parent","kind":13,"line":934},{"kind":13,"line":934,"containerName":"_parent","name":"$value"}],"containerName":"main::","definition":"sub","detail":"($self,$key,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":"","label":"_parent($self,$key,$value)"},"name":"_parent","range":{"start":{"line":915,"character":0},"end":{"line":935,"character":9999}}},{"kind":12,"line":916,"name":"strict"},{"name":"%self","containerName":null,"line":936,"kind":13},{"name":"$key","containerName":null,"line":936,"kind":13},{"detail":"($self,$key,$value)","signature":{"label":"_child($self,$key,$value)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$value"}],"documentation":""},"containerName":"main::","definition":"sub","line":958,"children":[{"line":959,"kind":13,"localvar":"my","containerName":"_child","name":"$self","definition":"my"},{"line":959,"kind":13,"name":"$key","containerName":"_child"},{"name":"$value","containerName":"_child","line":959,"kind":13},{"containerName":"_child","name":"$key","kind":13,"line":961},{"kind":13,"line":961,"name":"$key","containerName":"_child"},{"containerName":"_child","name":"$self","line":962,"kind":13},{"kind":12,"line":962,"containerName":"_child","name":"throw"},{"kind":13,"line":964,"name":"$value","containerName":"_child"},{"line":964,"kind":13,"containerName":"_child","name":"$value"},{"kind":13,"line":965,"containerName":"_child","name":"$self"},{"line":965,"kind":12,"containerName":"_child","name":"throw"},{"name":"$value","containerName":"_child","kind":13,"line":969},{"line":970,"kind":13,"name":"$self","containerName":"_child"},{"line":970,"kind":13,"containerName":"_child","name":"$key"},{"containerName":"_child","name":"$self","kind":13,"line":970}],"kind":12,"range":{"end":{"line":970,"character":9999},"start":{"line":958,"character":0}},"name":"_child"},{"line":970,"kind":13,"name":"%key","containerName":null},{"name":"%self","containerName":null,"line":971,"kind":13},{"line":971,"kind":13,"containerName":null,"name":"@key"},{"containerName":null,"name":"%self","kind":13,"line":973},{"containerName":null,"name":"$key","line":973,"kind":13},{"containerName":null,"name":"$value","line":973,"kind":13},{"kind":13,"line":975,"containerName":null,"name":"%self"},{"kind":13,"line":975,"containerName":null,"name":"$key"},{"containerName":"main::","definition":"sub","detail":"($self,$object)","signature":{"parameters":[{"label":"$self"},{"label":"$object"}],"documentation":"","label":"_remove_from_graph($self,$object)"},"kind":12,"line":990,"children":[{"line":991,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_remove_from_graph"},{"containerName":"_remove_from_graph","name":"$object","kind":13,"line":991},{"containerName":"_remove_from_graph","name":"$object","line":993,"kind":13},{"kind":13,"line":993,"name":"$object","containerName":"_remove_from_graph"},{"containerName":"_remove_from_graph","name":"$self","line":994,"kind":13},{"containerName":"_remove_from_graph","name":"throw","line":994,"kind":12},{"containerName":"_remove_from_graph","name":"$self","kind":13,"line":996},{"kind":12,"line":996,"containerName":"_remove_from_graph","name":"_parent"},{"containerName":"_remove_from_graph","name":"$object","line":996,"kind":13},{"localvar":"my","containerName":"_remove_from_graph","name":"$dad","definition":"my","line":997,"kind":13},{"name":"$self","containerName":"_remove_from_graph","line":997,"kind":13},{"line":997,"kind":12,"containerName":"_remove_from_graph","name":"_parent"},{"name":"$object","containerName":"_remove_from_graph","kind":13,"line":997},{"containerName":"_remove_from_graph","definition":"my","name":"$k","localvar":"my","kind":13,"line":999},{"line":999,"kind":13,"name":"$self","containerName":"_remove_from_graph"},{"name":"_child","containerName":"_remove_from_graph","kind":12,"line":999},{"line":999,"kind":13,"name":"$dad","containerName":"_remove_from_graph"},{"name":"$object","containerName":"_remove_from_graph","line":1000,"kind":13},{"name":"$self","containerName":"_remove_from_graph","line":1000,"kind":13},{"kind":13,"line":1000,"name":"$dad","containerName":"_remove_from_graph"},{"name":"$k","containerName":"_remove_from_graph","line":1000,"kind":13},{"name":"$self","containerName":"_remove_from_graph","line":1001,"kind":13},{"containerName":"_remove_from_graph","name":"$dad","line":1001,"kind":13},{"kind":13,"line":1001,"containerName":"_remove_from_graph","name":"$k"}],"name":"_remove_from_graph","range":{"start":{"line":990,"character":0},"end":{"line":1002,"character":9999}}},{"name":"%self","containerName":null,"line":1004,"kind":13},{"containerName":null,"name":"$object","line":1004,"kind":13},{"kind":12,"line":1009,"children":[{"localvar":"my","containerName":"_print_stats_pc","name":"$self","definition":"my","line":1011,"kind":13},{"kind":13,"line":1012,"containerName":"_print_stats_pc","definition":"my","name":"$pc","localvar":"my"},{"kind":13,"line":1012,"containerName":"_print_stats_pc","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"_print_stats_pc($self)"},"name":"_print_stats_pc","range":{"end":{"line":1012,"character":9999},"start":{"line":1009,"character":0}}},{"line":1013,"kind":13,"localvar":"my","definition":"my","name":"$cp","containerName":null},{"name":"%self","containerName":null,"line":1013,"kind":13},{"definition":"my","name":"$now_time","containerName":null,"localvar":"my","kind":13,"line":1014},{"line":1014,"kind":12,"name":"Time","containerName":"HiRes::time"},{"name":"$self","containerName":null,"line":1015,"kind":13},{"kind":12,"line":1015,"containerName":"main::","name":"debug"}],"version":5}