{"version":5,"vars":[{"containerName":"","name":"vars","kind":2,"line":195},{"name":"base","containerName":"","kind":2,"line":209},{"containerName":"main::","definition":"our","name":"$LINE_LENGTH","kind":13,"line":211},{"name":"@Unknown_names","containerName":null,"kind":13,"line":214},{"line":222,"kind":13,"containerName":null,"name":"@Unknown_genus"},{"containerName":"main::","name":"@GENE_NAME_ORDER","definition":"our","kind":13,"line":225},{"name":"_initialize","range":{"end":{"character":9999,"line":239},"start":{"character":0,"line":227}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":"","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"_initialize","name":"$self","definition":"my","line":228,"kind":13},{"name":"@args","containerName":"_initialize","line":228,"kind":13},{"containerName":"_initialize","name":"$self","line":229,"kind":13},{"containerName":"_initialize","name":"@args","line":229,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":231},{"containerName":"_initialize","name":"$self","line":233,"kind":13},{"line":233,"kind":12,"containerName":"_initialize","name":"_show_dna"},{"kind":13,"line":234,"name":"$self","containerName":"_initialize"},{"line":234,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"kind":13,"line":235,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"sequence_factory","kind":12,"line":235},{"containerName":"_initialize","name":"new","kind":12,"line":236},{"containerName":"_initialize","name":"$self","line":236,"kind":13},{"name":"verbose","containerName":"_initialize","line":236,"kind":12}],"line":227},{"containerName":"_initialize","name":"SUPER","kind":12,"line":229},{"containerName":"Seq::SeqFactory","name":"Bio","kind":12,"line":235},{"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","label":"next_seq($self,@args)"},"containerName":"main::","definition":"sub","line":251,"children":[{"localvar":"my","containerName":"next_seq","name":"$self","definition":"my","line":252,"kind":13},{"containerName":"next_seq","name":"@args","line":252,"kind":13},{"localvar":"my","name":"$pseq","definition":"my","containerName":"next_seq","line":253,"kind":13},{"name":"$c","containerName":"next_seq","line":253,"kind":13},{"name":"$line","containerName":"next_seq","kind":13,"line":253},{"name":"$name","containerName":"next_seq","line":253,"kind":13},{"name":"$desc","containerName":"next_seq","line":253,"kind":13},{"name":"$acc","containerName":"next_seq","kind":13,"line":253},{"line":253,"kind":13,"containerName":"next_seq","name":"$seqc"},{"line":253,"kind":13,"name":"$mol","containerName":"next_seq"},{"name":"$div","containerName":"next_seq","kind":13,"line":253},{"containerName":"next_seq","name":"$sptr","line":253,"kind":13},{"line":253,"kind":13,"name":"$seq_div","containerName":"next_seq"},{"name":"$date","containerName":"next_seq","kind":13,"line":254},{"kind":13,"line":254,"containerName":"next_seq","name":"$comment"},{"kind":13,"line":254,"name":"@date_arr","containerName":"next_seq"},{"containerName":"next_seq","name":"$genename","definition":"my","localvar":"my","kind":13,"line":255},{"kind":13,"line":256,"containerName":"next_seq","definition":"my","name":"$annotation","localvar":"my"},{"line":256,"kind":13,"name":"%params","containerName":"next_seq"},{"line":256,"kind":13,"name":"@features","containerName":"next_seq"},{"line":256,"kind":12,"containerName":"next_seq","name":"new"},{"line":260,"kind":13,"name":"$self","containerName":"next_seq"},{"line":260,"kind":12,"name":"_readline","containerName":"next_seq"},{"kind":13,"line":280,"containerName":"next_seq","name":"$self"},{"containerName":"next_seq","name":"throw","kind":12,"line":280},{"name":"$name","containerName":"next_seq","kind":13,"line":282},{"line":282,"kind":13,"name":"$seq_div","containerName":"next_seq"},{"line":283,"kind":13,"name":"$params","containerName":"next_seq"},{"line":284,"kind":13,"containerName":"next_seq","name":"$seq_div"},{"name":"$seq_div","containerName":"next_seq","line":284,"kind":13},{"name":"$seq_div","containerName":"next_seq","kind":13,"line":285},{"line":285,"kind":13,"containerName":"next_seq","name":"$seq_div"},{"kind":13,"line":286,"containerName":"next_seq","name":"$seq_div"},{"line":288,"kind":13,"localvar":"my","containerName":"next_seq","name":"$junk","definition":"my"},{"kind":13,"line":288,"containerName":"next_seq","name":"$division"},{"kind":13,"line":288,"containerName":"next_seq","name":"$name"},{"containerName":"next_seq","name":"$params","kind":13,"line":289},{"name":"$division","containerName":"next_seq","kind":13,"line":289},{"containerName":"next_seq","name":"$params","kind":13,"line":290},{"line":293,"kind":13,"name":"$params","containerName":"next_seq"},{"name":"$name","containerName":"next_seq","line":293,"kind":13},{"line":296,"kind":13,"containerName":"next_seq","name":"$self"},{"containerName":"next_seq","name":"_readline","kind":12,"line":296},{"containerName":"next_seq","name":"$desc","kind":13,"line":303},{"name":"$desc","containerName":"next_seq","kind":13,"line":303},{"kind":13,"line":307,"containerName":"next_seq","name":"$genename"},{"name":"$genename","containerName":"next_seq","kind":13,"line":307},{"line":308,"kind":13,"containerName":"next_seq","name":"$genename"},{"line":312,"kind":13,"localvar":"my","definition":"my","name":"@accs","containerName":"next_seq"},{"containerName":"next_seq","name":"$params","kind":13,"line":313},{"kind":13,"line":314,"containerName":"next_seq","name":"@accs"},{"containerName":"next_seq","name":"$params","line":314,"kind":13},{"name":"$params","containerName":"next_seq","line":315,"kind":13},{"kind":13,"line":315,"containerName":"next_seq","name":"@accs"},{"line":319,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"next_seq"},{"line":320,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$date"},{"line":320,"kind":13,"name":"$version","containerName":"next_seq"},{"kind":13,"line":320,"containerName":"next_seq","name":"$line"},{"kind":13,"line":321,"name":"$date","containerName":"next_seq"},{"line":322,"kind":13,"containerName":"next_seq","name":"$version"},{"localvar":"my","containerName":"next_seq","name":"$update","definition":"my","line":324,"kind":13},{"kind":12,"line":325,"containerName":"next_seq","name":"new"},{"kind":13,"line":328,"name":"$annotation","containerName":"next_seq"},{"kind":12,"line":328,"containerName":"next_seq","name":"add_Annotation"},{"kind":13,"line":328,"containerName":"next_seq","name":"$update"},{"containerName":"next_seq","name":"$version","kind":13,"line":329},{"containerName":"next_seq","name":"$params","line":331,"kind":13},{"containerName":"next_seq","name":"$params","kind":13,"line":333},{"line":333,"kind":13,"name":"$date","containerName":"next_seq"}],"kind":12,"range":{"start":{"character":0,"line":251},"end":{"line":334,"character":9999}},"name":"next_seq"},{"kind":12,"line":256,"containerName":"Annotation::Collection","name":"Bio"},{"kind":12,"line":295,"name":"BEFORE_FEATURE_TABLE"},{"containerName":"Annotation::SimpleValue","name":"Bio","line":324,"kind":12},{"definition":"my","name":"$line","containerName":null,"localvar":"my","kind":13,"line":337},{"containerName":null,"name":"$line","line":338,"kind":13},{"line":339,"kind":13,"localvar":"my","definition":"my","name":"$evidence","containerName":null},{"containerName":"Annotation::SimpleValue","name":"Bio","line":339,"kind":12},{"line":340,"kind":12,"containerName":"main::","name":"new"},{"line":342,"kind":13,"name":"$line","containerName":null},{"line":343,"kind":13,"name":"$annotation","containerName":null},{"kind":12,"line":343,"containerName":"main::","name":"add_Annotation"},{"kind":13,"line":343,"name":"%evidence","containerName":null},{"line":347,"kind":13,"localvar":"my","name":"$species","definition":"my","containerName":null},{"line":347,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":347,"containerName":"main::","name":"_read_swissprot_Species"},{"containerName":null,"name":"%params","kind":13,"line":348},{"name":"%species","containerName":null,"kind":13,"line":348},{"line":354,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$refs"},{"containerName":null,"name":"$self","line":354,"kind":13},{"line":354,"kind":12,"containerName":"main::","name":"_read_swissprot_References"},{"localvar":"my","containerName":null,"definition":"my","name":"$r","line":355,"kind":13},{"line":355,"kind":13,"name":"%refs","containerName":null},{"name":"$annotation","containerName":null,"kind":13,"line":356},{"containerName":"main::","name":"add_Annotation","line":356,"kind":12},{"containerName":null,"name":"%r","kind":13,"line":356},{"kind":13,"line":361,"containerName":null,"name":"$comment"},{"name":"$comment","containerName":null,"kind":13,"line":362},{"containerName":null,"name":"$self","line":363,"kind":13},{"containerName":"main::","name":"_readline","line":363,"kind":12},{"kind":13,"line":364,"containerName":null,"name":"$comment"},{"line":370,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$commobj"},{"kind":12,"line":370,"containerName":"Annotation::Comment","name":"Bio"},{"kind":12,"line":370,"containerName":"main::","name":"new"},{"containerName":null,"name":"$comment","line":371,"kind":13},{"containerName":null,"name":"$annotation","line":372,"kind":13},{"name":"add_Annotation","containerName":"main::","line":372,"kind":12},{"line":372,"kind":13,"containerName":null,"name":"$commobj"},{"line":373,"kind":13,"name":"$comment","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":374},{"name":"_pushback","containerName":"main::","kind":12,"line":374},{"kind":13,"line":381,"containerName":null,"name":"$database","definition":"my","localvar":"my"},{"name":"$primaryid","containerName":null,"kind":13,"line":381},{"line":381,"kind":13,"containerName":null,"name":"$optional"},{"kind":13,"line":381,"containerName":null,"name":"$comment"},{"name":"$comment","containerName":null,"line":384,"kind":13},{"containerName":null,"name":"$comment","line":385,"kind":13},{"kind":13,"line":387,"name":"$dblinkobj","definition":"my","containerName":null,"localvar":"my"},{"name":"Bio","containerName":"Annotation::DBLink","line":387,"kind":12},{"kind":12,"line":388,"name":"new","containerName":"main::"},{"containerName":null,"name":"$database","kind":13,"line":388},{"name":"$primaryid","containerName":null,"kind":13,"line":389},{"containerName":null,"name":"$optional","line":390,"kind":13},{"kind":13,"line":391,"containerName":null,"name":"$comment"},{"name":"$annotation","containerName":null,"kind":13,"line":395},{"name":"add_Annotation","containerName":"main::","line":395,"kind":12},{"containerName":null,"name":"%dblinkobj","kind":13,"line":395},{"line":399,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@kw"},{"line":400,"kind":13,"containerName":null,"name":"@kw"},{"name":"@kw","containerName":null,"line":400,"kind":13},{"containerName":null,"name":"%params","line":401,"kind":13},{"line":401,"kind":13,"name":"@kw","containerName":null},{"line":408,"kind":13,"containerName":null,"name":"%genename"},{"kind":13,"line":409,"containerName":null,"name":"@stags","definition":"my","localvar":"my"},{"name":"%genename","containerName":null,"line":410,"kind":13},{"line":412,"kind":13,"localvar":"my","name":"$n","definition":"my","containerName":null},{"containerName":null,"name":"%genename","line":412,"kind":13},{"line":413,"kind":13,"localvar":"my","containerName":null,"name":"@genenames","definition":"my"},{"containerName":null,"name":"$section","definition":"my","localvar":"my","kind":13,"line":414},{"line":414,"kind":13,"name":"%n","containerName":null},{"containerName":null,"definition":"my","name":"$tag","localvar":"my","kind":13,"line":415},{"kind":13,"line":415,"name":"$rest","containerName":null},{"line":415,"kind":13,"name":"$section","containerName":null},{"kind":13,"line":416,"containerName":null,"name":"$rest"},{"localvar":"my","containerName":null,"name":"$val","definition":"my","line":417,"kind":13},{"line":417,"kind":13,"name":"%rest","containerName":null},{"containerName":null,"name":"@genenames","line":418,"kind":13},{"name":"$tag","containerName":null,"line":418,"kind":13},{"name":"$val","containerName":null,"kind":13,"line":418},{"name":"@stags","containerName":null,"line":421,"kind":13},{"line":421,"kind":13,"containerName":null,"name":"@genenames"},{"localvar":"my","containerName":null,"definition":"my","name":"$section","line":425,"kind":13},{"line":425,"kind":13,"containerName":null,"name":"%genename"},{"localvar":"my","containerName":null,"name":"@genenames","definition":"my","line":426,"kind":13},{"line":427,"kind":13,"name":"$section","containerName":null},{"kind":13,"line":428,"containerName":null,"definition":"my","name":"@names","localvar":"my"},{"kind":13,"line":428,"name":"$section","containerName":null},{"line":429,"kind":13,"containerName":null,"name":"@genenames"},{"line":429,"kind":13,"containerName":null,"name":"@names"},{"line":430,"kind":13,"containerName":null,"name":"@genenames"},{"kind":13,"line":430,"name":"@names","containerName":null},{"name":"@stags","containerName":null,"line":431,"kind":13},{"name":"@genenames","containerName":null,"kind":13,"line":431},{"kind":13,"line":434,"containerName":null,"name":"$gn","definition":"my","localvar":"my"},{"name":"Bio","containerName":"Annotation::TagTree","kind":12,"line":434},{"line":434,"kind":12,"name":"new","containerName":"main::"},{"name":"@stags","containerName":null,"line":435,"kind":13},{"line":436,"kind":13,"containerName":null,"name":"$annotation"},{"line":436,"kind":12,"containerName":"main::","name":"add_Annotation"},{"containerName":null,"name":"$gn","kind":13,"line":436},{"name":"FEATURE_TABLE","kind":12,"line":439},{"localvar":"my","name":"$ftunit","definition":"my","containerName":null,"line":443,"kind":13},{"containerName":null,"name":"$self","line":443,"kind":13},{"line":443,"kind":12,"name":"_read_FTHelper_swissprot","containerName":"main::"},{"kind":13,"line":447,"name":"%ftunit","containerName":null},{"line":448,"kind":13,"containerName":null,"name":"@features"},{"kind":13,"line":449,"containerName":null,"name":"$ftunit"},{"name":"_generic_seqfeature","containerName":"main::","line":449,"kind":12},{"line":449,"kind":13,"name":"$self","containerName":null},{"line":449,"kind":12,"containerName":"main::","name":"location_factory"},{"line":450,"kind":13,"containerName":null,"name":"%params"},{"name":"$self","containerName":null,"line":452,"kind":13},{"line":452,"kind":12,"name":"warn","containerName":"main::"},{"name":"%params","containerName":null,"kind":13,"line":453},{"containerName":null,"name":"$self","line":455,"kind":13},{"name":"_readline","containerName":"main::","kind":12,"line":455},{"name":"$self","containerName":null,"line":458,"kind":13},{"kind":12,"line":458,"name":"_readline","containerName":"main::"},{"containerName":null,"name":"$seqc","kind":13,"line":460},{"name":"$self","containerName":null,"kind":13,"line":461},{"containerName":"main::","name":"_readline","kind":12,"line":461},{"name":"$seqc","containerName":null,"kind":13,"line":464},{"containerName":null,"name":"$seq","definition":"my","localvar":"my","kind":13,"line":467},{"name":"$self","containerName":null,"line":467,"kind":13},{"line":467,"kind":12,"containerName":"main::","name":"sequence_factory"},{"line":468,"kind":12,"containerName":"main::","name":"create"},{"kind":13,"line":468,"name":"$self","containerName":null},{"kind":12,"line":468,"containerName":"main::","name":"verbose"},{"name":"%params","containerName":null,"kind":13,"line":469},{"containerName":null,"name":"$seqc","line":470,"kind":13},{"containerName":null,"name":"$desc","kind":13,"line":471},{"kind":13,"line":472,"name":"@features","containerName":null},{"containerName":null,"name":"$annotation","kind":13,"line":473},{"containerName":null,"name":"$seq","kind":13,"line":477},{"name":"annotation","containerName":"main::","kind":12,"line":477},{"kind":13,"line":477,"name":"$annotation","containerName":null},{"line":479,"kind":13,"name":"$seq","containerName":null},{"line":493,"children":[{"kind":13,"line":494,"containerName":"write_seq","name":"$self","definition":"my","localvar":"my"},{"name":"@seqs","containerName":"write_seq","line":494,"kind":13},{"localvar":"my","containerName":"write_seq","name":"$seq","definition":"my","line":495,"kind":13},{"containerName":"write_seq","name":"@seqs","line":495,"kind":13},{"name":"$self","containerName":"write_seq","kind":13,"line":496},{"name":"throw","containerName":"write_seq","kind":12,"line":496},{"containerName":"write_seq","name":"$seq","kind":13,"line":496},{"line":498,"kind":13,"containerName":"write_seq","name":"$seq"},{"name":"$seq","containerName":"write_seq","line":498,"kind":13},{"containerName":"write_seq","name":"isa","line":498,"kind":12},{"containerName":"write_seq","name":"$self","line":499,"kind":13},{"containerName":"write_seq","name":"warn","kind":12,"line":499},{"containerName":"write_seq","definition":"my","name":"$i","localvar":"my","kind":13,"line":502},{"kind":13,"line":503,"containerName":"write_seq","definition":"my","name":"$str","localvar":"my"},{"name":"$seq","containerName":"write_seq","kind":13,"line":503},{"line":503,"kind":12,"containerName":"write_seq","name":"seq"},{"line":505,"kind":13,"localvar":"my","containerName":"write_seq","definition":"my","name":"$div"},{"localvar":"my","definition":"my","name":"$ns","containerName":"write_seq","line":506,"kind":13},{"containerName":"write_seq","name":"$seq","kind":13,"line":506},{"kind":12,"line":506,"name":"can","containerName":"write_seq"},{"kind":13,"line":506,"containerName":"write_seq","name":"$seq"},{"containerName":"write_seq","name":"namespace","kind":12,"line":506},{"localvar":"my","definition":"my","name":"$len","containerName":"write_seq","line":507,"kind":13},{"name":"$seq","containerName":"write_seq","line":507,"kind":13},{"name":"length","containerName":"write_seq","kind":12,"line":507},{"line":509,"kind":13,"containerName":"write_seq","name":"$seq"},{"kind":12,"line":509,"containerName":"write_seq","name":"can"},{"containerName":"write_seq","name":"$div","line":509,"kind":13},{"kind":13,"line":509,"containerName":"write_seq","name":"$seq"},{"name":"division","containerName":"write_seq","line":509,"kind":12},{"kind":13,"line":510,"containerName":"write_seq","name":"$div"},{"line":514,"kind":13,"containerName":"write_seq","name":"$ns"},{"name":"$div","containerName":"write_seq","line":515,"kind":13},{"line":515,"kind":13,"name":"$ns","containerName":"write_seq"},{"containerName":"write_seq","name":"$ns","line":516,"kind":13},{"kind":13,"line":517,"name":"$ns","containerName":"write_seq"},{"line":519,"kind":13,"containerName":"write_seq","name":"$ns"},{"name":"$self","containerName":"write_seq","kind":13,"line":523},{"name":"warn","containerName":"write_seq","kind":12,"line":523},{"kind":13,"line":523,"name":"$seq","containerName":"write_seq"},{"name":"display_id","containerName":"write_seq","kind":12,"line":523},{"kind":13,"line":524,"name":"$seq","containerName":"write_seq"},{"kind":12,"line":524,"name":"display_id","containerName":"write_seq"},{"localvar":"my","containerName":"write_seq","definition":"my","name":"$temp_line","line":526,"kind":13},{"containerName":"write_seq","name":"$self","kind":13,"line":527},{"containerName":"write_seq","name":"_id_generation_func","line":527,"kind":12},{"containerName":"write_seq","name":"$temp_line","line":528,"kind":13},{"line":528,"kind":13,"name":"$self","containerName":"write_seq"},{"containerName":"write_seq","name":"_id_generation_func","kind":12,"line":528},{"line":528,"kind":13,"name":"$seq","containerName":"write_seq"},{"containerName":"write_seq","name":"$temp_line","line":540,"kind":13},{"line":541,"kind":13,"name":"$seq","containerName":"write_seq"},{"line":541,"kind":12,"name":"display_id","containerName":"write_seq"},{"line":541,"kind":13,"containerName":"write_seq","name":"$div"},{"kind":13,"line":541,"containerName":"write_seq","name":"$len"},{"kind":13,"line":544,"name":"$self","containerName":"write_seq"},{"kind":12,"line":544,"name":"_print","containerName":"write_seq"},{"kind":13,"line":549,"name":"$self","containerName":"write_seq"},{"line":549,"kind":12,"containerName":"write_seq","name":"_ac_generation_func"},{"kind":13,"line":550,"containerName":"write_seq","name":"$temp_line"},{"name":"$self","containerName":"write_seq","line":550,"kind":13},{"containerName":"write_seq","name":"_ac_generation_func","kind":12,"line":550},{"containerName":"write_seq","name":"$seq","line":550,"kind":13},{"name":"$self","containerName":"write_seq","line":551,"kind":13},{"line":551,"kind":12,"containerName":"write_seq","name":"_print"}],"kind":12,"detail":"($self,@seqs)","signature":{"label":"write_seq($self,@seqs)","parameters":[{"label":"$self"},{"label":"@seqs"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":493},"end":{"line":552,"character":9999}},"name":"write_seq"},{"line":553,"kind":13,"containerName":null,"name":"$seq"},{"name":"can","containerName":"main::","kind":12,"line":553},{"kind":13,"line":554,"containerName":null,"definition":"my","name":"$ac_line","localvar":"my"},{"line":554,"kind":13,"name":"$seq","containerName":null},{"containerName":"main::","name":"accession_number","kind":12,"line":554},{"line":555,"kind":13,"name":"$seq","containerName":null},{"name":"can","containerName":"main::","kind":12,"line":555},{"localvar":"my","containerName":null,"definition":"my","name":"$sacc","line":556,"kind":13},{"containerName":null,"name":"$seq","kind":13,"line":556},{"line":556,"kind":12,"name":"get_secondary_accessions","containerName":"main::"},{"name":"$ac_line","containerName":null,"line":557,"kind":13},{"kind":13,"line":557,"containerName":null,"name":"$sacc"},{"kind":13,"line":559,"name":"$ac_line","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":562},{"line":562,"kind":12,"name":"_write_line_swissprot_regex","containerName":"main::"},{"line":562,"kind":13,"name":"$ac_line","containerName":null},{"line":563,"kind":13,"name":"$LINE_LENGTH","containerName":null},{"line":570,"kind":13,"name":"$seq","containerName":null},{"name":"can","containerName":"main::","kind":12,"line":570},{"definition":"my","name":"@dates","containerName":null,"localvar":"my","kind":13,"line":571},{"line":571,"kind":13,"containerName":null,"name":"$seq"},{"kind":12,"line":571,"name":"get_dates","containerName":"main::"},{"localvar":"my","containerName":null,"name":"$ct","definition":"my","line":572,"kind":13},{"kind":13,"line":573,"containerName":null,"definition":"my","name":"$seq_version","localvar":"my"},{"kind":13,"line":573,"containerName":null,"name":"$seq"},{"containerName":"main::","name":"version","kind":12,"line":573},{"line":574,"kind":13,"localvar":"my","name":"$update_version","definition":"my","containerName":null},{"line":574,"kind":13,"containerName":null,"name":"$seq"},{"kind":12,"line":574,"name":"annotation","containerName":"main::"},{"line":574,"kind":12,"name":"get_Annotations","containerName":"main::"},{"name":"$dt","definition":"my","containerName":null,"localvar":"my","kind":13,"line":575},{"containerName":null,"name":"@dates","kind":13,"line":575},{"name":"$self","containerName":null,"line":576,"kind":13},{"name":"_write_line_swissprot_regex","containerName":"main::","line":576,"kind":12},{"name":"$dt","containerName":null,"line":577,"kind":13},{"line":577,"kind":13,"name":"$ns","containerName":null},{"containerName":null,"name":"$LINE_LENGTH","line":578,"kind":13},{"name":"$ct","containerName":null,"line":578,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":579},{"containerName":"main::","name":"_write_line_swissprot_regex","line":579,"kind":12},{"containerName":null,"name":"$dt","line":580,"kind":13},{"kind":13,"line":580,"name":"$update_version","containerName":null},{"containerName":"main::","name":"display_text","line":580,"kind":12},{"kind":13,"line":581,"name":"$LINE_LENGTH","containerName":null},{"line":581,"kind":13,"containerName":null,"name":"$ct"},{"name":"$self","containerName":null,"line":582,"kind":13},{"line":582,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"name":"$dt","containerName":null,"line":583,"kind":13},{"kind":13,"line":584,"containerName":null,"name":"$LINE_LENGTH"},{"line":584,"kind":13,"containerName":null,"name":"$ct"},{"containerName":null,"name":"$ct","line":585,"kind":13},{"line":590,"kind":13,"name":"$self","containerName":null},{"name":"_write_line_swissprot_regex","containerName":"main::","kind":12,"line":590},{"name":"$seq","containerName":null,"line":590,"kind":13},{"name":"desc","containerName":"main::","line":590,"kind":12},{"containerName":null,"name":"$LINE_LENGTH","kind":13,"line":590},{"containerName":null,"definition":"my","name":"$gene","localvar":"my","kind":13,"line":593},{"containerName":null,"name":"@genes","definition":"my","localvar":"my","kind":13,"line":593},{"name":"$seq","containerName":null,"kind":13,"line":593},{"name":"annotation","containerName":"main::","line":593,"kind":12},{"name":"get_Annotations","containerName":"main::","kind":12,"line":593},{"line":595,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@genelines"},{"containerName":null,"definition":"my","name":"$node","localvar":"my","kind":13,"line":596},{"line":596,"kind":13,"containerName":null,"name":"$gene"},{"line":596,"kind":12,"containerName":"main::","name":"findnode"},{"containerName":null,"definition":"my","name":"$geneline","localvar":"my","kind":13,"line":598},{"kind":13,"line":599,"name":"%genedata","definition":"my","containerName":null,"localvar":"my"},{"name":"$node","containerName":null,"line":599,"kind":13},{"containerName":"main::","name":"hash","line":599,"kind":12},{"kind":13,"line":600,"containerName":null,"definition":"my","name":"$tag","localvar":"my"},{"kind":13,"line":600,"name":"@GENE_NAME_ORDER","containerName":null},{"name":"%genedata","containerName":null,"kind":13,"line":601},{"kind":13,"line":601,"containerName":null,"name":"%tag"},{"line":602,"kind":13,"name":"$geneline","containerName":null},{"containerName":null,"name":"%genedata","kind":13,"line":602},{"containerName":null,"name":"$tag","line":602,"kind":13},{"name":"%genedata","containerName":null,"kind":13,"line":603},{"name":"$tag","containerName":null,"kind":13,"line":603},{"containerName":null,"name":"%genedata","line":605,"kind":13},{"containerName":null,"name":"$tag","line":605,"kind":13},{"kind":13,"line":609,"containerName":null,"definition":"my","name":"$tag","localvar":"my"},{"line":609,"kind":13,"name":"%genedata","containerName":null},{"line":610,"kind":13,"name":"$geneline","containerName":null},{"name":"%genedata","containerName":null,"kind":13,"line":610},{"containerName":null,"name":"$tag","line":610,"kind":13},{"kind":13,"line":611,"containerName":null,"name":"%genedata"},{"line":611,"kind":13,"containerName":null,"name":"$tag"},{"line":613,"kind":13,"name":"%genedata","containerName":null},{"kind":13,"line":613,"name":"$tag","containerName":null},{"name":"@genelines","containerName":null,"line":615,"kind":13},{"name":"$self","containerName":null,"line":617,"kind":13},{"containerName":"main::","name":"_print","line":617,"kind":12},{"containerName":null,"name":"@genelines","kind":13,"line":617},{"line":621,"kind":13,"name":"$seq","containerName":null},{"kind":12,"line":621,"name":"can","containerName":"main::"},{"line":621,"kind":13,"localvar":"my","definition":"my","name":"$spec","containerName":null},{"line":621,"kind":13,"name":"$seq","containerName":null},{"kind":12,"line":621,"containerName":"main::","name":"species"},{"localvar":"my","name":"@class","definition":"my","containerName":null,"line":622,"kind":13},{"kind":13,"line":622,"name":"$spec","containerName":null},{"name":"classification","containerName":"main::","line":622,"kind":12},{"containerName":null,"name":"@class","kind":13,"line":623},{"localvar":"my","containerName":null,"name":"$species","definition":"my","line":624,"kind":13},{"name":"$spec","containerName":null,"line":624,"kind":13},{"name":"species","containerName":"main::","line":624,"kind":12},{"localvar":"my","name":"$genus","definition":"my","containerName":null,"line":625,"kind":13},{"name":"$spec","containerName":null,"kind":13,"line":625},{"kind":12,"line":625,"containerName":"main::","name":"genus"},{"kind":13,"line":626,"containerName":null,"definition":"my","name":"$OS","localvar":"my"},{"containerName":null,"name":"$spec","line":626,"kind":13},{"containerName":"main::","name":"scientific_name","line":626,"kind":12},{"name":"@class","containerName":null,"line":627,"kind":13},{"kind":13,"line":628,"name":"$OS","containerName":null},{"name":"$species","containerName":null,"line":628,"kind":13},{"containerName":null,"name":"$OS","kind":13,"line":629},{"name":"$spec","containerName":null,"line":629,"kind":13},{"name":"sub_species","containerName":"main::","line":629,"kind":12},{"containerName":null,"name":"$spec","line":629,"kind":13},{"line":629,"kind":12,"containerName":"main::","name":"sub_species"},{"kind":13,"line":631,"containerName":null,"name":"$spec"},{"containerName":"main::","name":"variant","kind":12,"line":631},{"kind":13,"line":631,"containerName":null,"name":"$spec"},{"containerName":"main::","name":"common_name","kind":12,"line":631},{"kind":13,"line":632,"containerName":null,"name":"$OS"},{"line":634,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":634,"name":"_print","containerName":"main::"},{"kind":13,"line":635,"name":"$OC","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":635,"containerName":null,"name":"@class"},{"name":"$self","containerName":null,"kind":13,"line":636},{"name":"_write_line_swissprot_regex","containerName":"main::","kind":12,"line":636},{"containerName":null,"name":"$OC","line":636,"kind":13},{"line":636,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"name":"$spec","containerName":null,"kind":13,"line":637},{"kind":12,"line":637,"containerName":"main::","name":"organelle"},{"name":"$self","containerName":null,"line":638,"kind":13},{"containerName":"main::","name":"_write_line_swissprot_regex","line":638,"kind":12},{"line":638,"kind":13,"containerName":null,"name":"$spec"},{"kind":12,"line":638,"containerName":"main::","name":"organelle"},{"containerName":null,"name":"$LINE_LENGTH","line":638,"kind":13},{"line":640,"kind":13,"name":"$spec","containerName":null},{"name":"ncbi_taxid","containerName":"main::","line":640,"kind":12},{"line":641,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":641,"containerName":"main::","name":"_print"},{"line":641,"kind":13,"name":"$spec","containerName":null},{"containerName":"main::","name":"ncbi_taxid","line":641,"kind":12},{"line":646,"kind":13,"localvar":"my","containerName":null,"name":"$t","definition":"my"},{"localvar":"my","definition":"my","name":"$ref","containerName":null,"line":647,"kind":13},{"containerName":null,"name":"$seq","line":647,"kind":13},{"kind":12,"line":647,"containerName":"main::","name":"annotation"},{"kind":12,"line":647,"containerName":"main::","name":"get_Annotations"},{"kind":13,"line":648,"name":"$self","containerName":null},{"kind":12,"line":648,"containerName":"main::","name":"_print"},{"containerName":null,"name":"$ref","line":652,"kind":13},{"name":"rp","containerName":"main::","kind":12,"line":652},{"containerName":null,"name":"$self","kind":13,"line":653},{"line":653,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"name":"$ref","containerName":null,"kind":13,"line":653},{"name":"rp","containerName":"main::","line":653,"kind":12},{"containerName":null,"name":"$LINE_LENGTH","kind":13,"line":654},{"containerName":null,"name":"$ref","kind":13,"line":656},{"kind":12,"line":656,"name":"comment","containerName":"main::"},{"containerName":null,"name":"$self","line":657,"kind":13},{"containerName":"main::","name":"_write_line_swissprot_regex","kind":12,"line":657},{"kind":13,"line":657,"containerName":null,"name":"$ref"},{"name":"comment","containerName":"main::","kind":12,"line":657},{"kind":13,"line":658,"name":"$LINE_LENGTH","containerName":null},{"kind":13,"line":660,"containerName":null,"name":"$ref"},{"name":"medline","containerName":"main::","line":660,"kind":12},{"name":"$ref","containerName":null,"kind":13,"line":660},{"line":660,"kind":12,"name":"pubmed","containerName":"main::"},{"containerName":null,"name":"$ref","kind":13,"line":660},{"name":"doi","containerName":"main::","line":660,"kind":12},{"name":"$line","definition":"my","containerName":null,"localvar":"my","kind":13,"line":664},{"containerName":null,"name":"$line","line":665,"kind":13},{"containerName":null,"name":"$ref","kind":13,"line":665},{"containerName":"main::","name":"medline","kind":12,"line":665},{"containerName":null,"name":"$ref","line":665,"kind":13},{"kind":12,"line":665,"containerName":"main::","name":"medline"},{"name":"$line","containerName":null,"line":666,"kind":13},{"kind":13,"line":666,"containerName":null,"name":"$ref"},{"name":"pubmed","containerName":"main::","line":666,"kind":12},{"line":666,"kind":13,"containerName":null,"name":"$ref"},{"line":666,"kind":12,"containerName":"main::","name":"pubmed"},{"line":667,"kind":13,"name":"$line","containerName":null},{"containerName":null,"name":"$ref","line":667,"kind":13},{"name":"doi","containerName":"main::","line":667,"kind":12},{"kind":13,"line":667,"containerName":null,"name":"$ref"},{"line":667,"kind":12,"containerName":"main::","name":"doi"},{"kind":13,"line":668,"containerName":null,"name":"$line"},{"line":670,"kind":13,"name":"$self","containerName":null},{"line":670,"kind":12,"name":"_write_line_swissprot_regex","containerName":"main::"},{"kind":13,"line":671,"containerName":null,"name":"$line"},{"name":"$LINE_LENGTH","containerName":null,"line":672,"kind":13},{"localvar":"my","name":"$author","definition":"my","containerName":null,"line":675,"kind":13},{"name":"$ref","containerName":null,"line":675,"kind":13},{"containerName":"main::","name":"authors","kind":12,"line":675},{"line":675,"kind":13,"containerName":null,"name":"$ref"},{"line":675,"kind":12,"containerName":"main::","name":"authors"},{"kind":13,"line":676,"name":"$title","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$ref","line":676,"kind":13},{"line":676,"kind":12,"containerName":"main::","name":"title"},{"name":"$ref","containerName":null,"kind":13,"line":676},{"kind":12,"line":676,"name":"title","containerName":"main::"},{"line":677,"kind":13,"localvar":"my","containerName":null,"name":"$rg","definition":"my"},{"line":677,"kind":13,"name":"$ref","containerName":null},{"name":"rg","containerName":"main::","kind":12,"line":677},{"name":"$ref","containerName":null,"line":677,"kind":13},{"line":677,"kind":12,"containerName":"main::","name":"rg"},{"line":678,"kind":13,"containerName":null,"name":"$author"},{"containerName":null,"name":"$self","line":680,"kind":13},{"containerName":"main::","name":"_write_line_swissprot_regex","line":680,"kind":12},{"kind":13,"line":680,"containerName":null,"name":"$rg"},{"line":680,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"containerName":null,"name":"$rg","kind":13,"line":680},{"name":"$self","containerName":null,"kind":13,"line":681},{"line":681,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"name":"$author","containerName":null,"kind":13,"line":681},{"line":681,"kind":13,"containerName":null,"name":"$LINE_LENGTH"},{"line":681,"kind":13,"containerName":null,"name":"$author"},{"kind":13,"line":682,"name":"$self","containerName":null},{"kind":12,"line":682,"name":"_write_line_swissprot_regex","containerName":"main::"},{"line":682,"kind":13,"name":"$title","containerName":null},{"name":"$LINE_LENGTH","containerName":null,"line":682,"kind":13},{"kind":13,"line":682,"containerName":null,"name":"$title"},{"containerName":null,"name":"$self","kind":13,"line":683},{"name":"_write_line_swissprot_regex","containerName":"main::","kind":12,"line":683},{"kind":13,"line":683,"name":"$ref","containerName":null},{"line":683,"kind":12,"containerName":"main::","name":"location"},{"name":"$LINE_LENGTH","containerName":null,"kind":13,"line":683},{"kind":13,"line":684,"containerName":null,"name":"$t"},{"kind":13,"line":689,"containerName":null,"definition":"my","name":"$comment","localvar":"my"},{"containerName":null,"name":"$seq","line":689,"kind":13},{"kind":12,"line":689,"containerName":"main::","name":"annotation"},{"line":689,"kind":12,"containerName":"main::","name":"get_Annotations"},{"kind":13,"line":690,"containerName":null,"name":"$cline","definition":"my","localvar":"my"},{"kind":13,"line":690,"name":"$comment","containerName":null},{"containerName":"main::","name":"text","line":690,"kind":12},{"containerName":null,"name":"%cline","line":691,"kind":13},{"kind":13,"line":692,"name":"$self","containerName":null},{"name":"_print","containerName":"main::","kind":12,"line":692},{"containerName":null,"name":"$cline","kind":13,"line":692},{"name":"$cline","containerName":null,"line":693,"kind":13},{"line":693,"kind":13,"name":"$cline","containerName":null},{"line":695,"kind":13,"name":"$self","containerName":null},{"name":"_print","containerName":"main::","kind":12,"line":695},{"containerName":null,"name":"$cline","kind":13,"line":695},{"kind":13,"line":701,"definition":"my","name":"$dblink","containerName":null,"localvar":"my"},{"containerName":null,"name":"$seq","kind":13,"line":701},{"line":701,"kind":12,"containerName":"main::","name":"annotation"},{"line":701,"kind":12,"containerName":"main::","name":"get_Annotations"},{"line":702,"kind":13,"localvar":"my","definition":"my","name":"$primary_id","containerName":null},{"name":"$dblink","containerName":null,"kind":13,"line":702},{"kind":12,"line":702,"containerName":"main::","name":"primary_id"},{"line":704,"kind":13,"name":"$dblink","containerName":null},{"kind":12,"line":704,"name":"comment","containerName":"main::"},{"name":"$dblink","containerName":null,"line":704,"kind":13},{"kind":12,"line":704,"containerName":"main::","name":"comment"},{"containerName":null,"name":"$self","line":705,"kind":13},{"name":"_print","containerName":"main::","line":705,"kind":12},{"line":705,"kind":13,"name":"$dblink","containerName":null},{"containerName":"main::","name":"database","line":705,"kind":12},{"name":"$primary_id","containerName":null,"kind":13,"line":705},{"name":"$dblink","containerName":null,"kind":13,"line":706},{"name":"optional_id","containerName":"main::","line":706,"kind":12},{"name":"$dblink","containerName":null,"line":706,"kind":13},{"containerName":"main::","name":"comment","line":706,"kind":12},{"name":"$dblink","containerName":null,"kind":13,"line":707},{"kind":12,"line":707,"name":"optional_id","containerName":"main::"},{"containerName":null,"name":"$self","line":708,"kind":13},{"kind":12,"line":708,"containerName":"main::","name":"_print"},{"containerName":null,"name":"$dblink","line":708,"kind":13},{"line":708,"kind":12,"containerName":"main::","name":"database"},{"name":"$primary_id","containerName":null,"line":709,"kind":13},{"line":710,"kind":13,"name":"$dblink","containerName":null},{"kind":12,"line":710,"containerName":"main::","name":"optional_id"},{"containerName":null,"name":"$self","line":712,"kind":13},{"containerName":"main::","name":"_print","kind":12,"line":712},{"kind":13,"line":712,"containerName":null,"name":"$dblink"},{"kind":12,"line":712,"name":"database","containerName":"main::"},{"line":713,"kind":13,"containerName":null,"name":"$primary_id"},{"line":719,"kind":13,"localvar":"my","name":"$evidence","definition":"my","containerName":null},{"line":719,"kind":13,"containerName":null,"name":"$seq"},{"kind":12,"line":719,"name":"annotation","containerName":"main::"},{"containerName":"main::","name":"get_Annotations","line":719,"kind":12},{"line":720,"kind":13,"name":"$self","containerName":null},{"line":720,"kind":12,"containerName":"main::","name":"_print"},{"kind":13,"line":720,"containerName":null,"name":"$evidence"},{"kind":12,"line":720,"name":"value","containerName":"main::"},{"localvar":"my","name":"$kw","definition":"my","containerName":null,"line":725,"kind":13},{"containerName":null,"name":"$func","definition":"my","localvar":"my","kind":13,"line":726},{"name":"$self","containerName":null,"line":726,"kind":13},{"name":"_kw_generation_func","containerName":"main::","kind":12,"line":726},{"kind":13,"line":727,"name":"$kw","containerName":null},{"containerName":null,"name":"$func","kind":13,"line":727},{"kind":13,"line":727,"containerName":null,"name":"$seq"},{"line":728,"kind":13,"containerName":null,"name":"$seq"},{"containerName":"main::","name":"can","kind":12,"line":728},{"kind":13,"line":729,"containerName":null,"name":"$kw"},{"line":729,"kind":13,"containerName":null,"name":"$seq"},{"containerName":"main::","name":"keywords","line":729,"kind":12},{"containerName":null,"name":"%kw","line":730,"kind":13},{"kind":13,"line":731,"containerName":null,"name":"$kw"},{"kind":13,"line":731,"name":"$kw","containerName":null},{"line":733,"kind":13,"containerName":null,"name":"$kw"},{"containerName":null,"name":"$kw","line":733,"kind":13},{"name":"$kw","containerName":null,"line":733,"kind":13},{"line":735,"kind":13,"containerName":null,"name":"$kw"},{"line":736,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_write_line_swissprot_regex","kind":12,"line":736},{"name":"$kw","containerName":null,"kind":13,"line":737},{"name":"$LINE_LENGTH","containerName":null,"line":737,"kind":13},{"line":738,"kind":13,"name":"$kw","containerName":null},{"definition":"my","name":"@feats","containerName":null,"localvar":"my","kind":13,"line":742},{"kind":13,"line":742,"containerName":null,"name":"$seq"},{"kind":12,"line":742,"name":"can","containerName":"main::"},{"containerName":null,"name":"$seq","line":742,"kind":13},{"containerName":"main::","name":"top_SeqFeatures","line":742,"kind":12},{"line":743,"kind":13,"containerName":null,"name":"@feats"},{"line":744,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":744,"containerName":"main::","name":"_post_sort"},{"kind":13,"line":748,"containerName":null,"definition":"my","name":"$post_sort_func","localvar":"my"},{"line":748,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_post_sort","kind":12,"line":748},{"name":"@fth","definition":"my","containerName":null,"localvar":"my","kind":13,"line":749},{"name":"$sf","definition":"my","containerName":null,"localvar":"my","kind":13,"line":751},{"line":751,"kind":13,"containerName":null,"name":"@feats"},{"containerName":null,"name":"@fth","kind":13,"line":752},{"containerName":"SeqIO::FTHelper::from_SeqFeature","name":"Bio","line":752,"kind":12},{"name":"$sf","containerName":null,"line":752,"kind":13},{"line":752,"kind":13,"name":"$seq","containerName":null},{"name":"@fth","containerName":null,"kind":13,"line":754},{"line":754,"kind":12,"name":"post_sort_func"},{"containerName":null,"name":"$a","kind":13,"line":754},{"kind":13,"line":754,"name":"$b","containerName":null},{"kind":13,"line":754,"name":"@fth","containerName":null},{"line":756,"kind":13,"localvar":"my","containerName":null,"name":"$fth","definition":"my"},{"kind":13,"line":756,"name":"@fth","containerName":null},{"name":"$self","containerName":null,"line":757,"kind":13},{"kind":12,"line":757,"containerName":"main::","name":"_print_swissprot_FTHelper"},{"line":757,"kind":13,"containerName":null,"name":"%fth"},{"line":763,"kind":13,"localvar":"my","containerName":null,"name":"$sf","definition":"my"},{"line":763,"kind":13,"containerName":null,"name":"@feats"},{"localvar":"my","definition":"my","name":"@fth","containerName":null,"line":764,"kind":13},{"name":"Bio","containerName":"SeqIO::FTHelper::from_SeqFeature","kind":12,"line":764},{"containerName":null,"name":"$sf","line":764,"kind":13},{"containerName":null,"name":"$seq","line":764,"kind":13},{"line":765,"kind":13,"localvar":"my","containerName":null,"name":"$fth","definition":"my"},{"containerName":null,"name":"@fth","line":765,"kind":13},{"containerName":null,"name":"$fth","kind":13,"line":766},{"containerName":"main::","name":"isa","kind":12,"line":766},{"kind":13,"line":767,"containerName":null,"name":"$sf"},{"name":"throw","containerName":"main::","line":767,"kind":12},{"kind":13,"line":769,"name":"$self","containerName":null},{"line":769,"kind":12,"containerName":"main::","name":"_print_swissprot_FTHelper"},{"kind":13,"line":769,"name":"$fth","containerName":null},{"containerName":null,"name":"$self","line":774,"kind":13},{"kind":12,"line":774,"containerName":"main::","name":"_show_dna"},{"localvar":"my","containerName":null,"name":"$mw","definition":"my","line":781,"kind":13},{"containerName":"Tools::SeqStats","name":"Bio","kind":12,"line":781},{"kind":12,"line":781,"containerName":"main::","name":"get_mol_wt"},{"line":781,"kind":13,"name":"$seq","containerName":null},{"name":"primary_seq","containerName":"main::","kind":12,"line":781},{"localvar":"my","definition":"my","name":"$crc64","containerName":null,"line":784,"kind":13},{"line":784,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":784,"name":"_crc64","containerName":"main::"},{"kind":13,"line":784,"name":"$str","containerName":null},{"containerName":null,"name":"$self","line":785,"kind":13},{"kind":12,"line":785,"name":"_print","containerName":"main::"},{"containerName":null,"name":"$len","kind":13,"line":786},{"name":"$mw","containerName":null,"line":786,"kind":13},{"line":786,"kind":13,"name":"$crc64","containerName":null},{"containerName":null,"name":"$self","line":787,"kind":13},{"containerName":"main::","name":"_print","kind":12,"line":787},{"line":788,"kind":13,"localvar":"my","definition":"my","name":"$linepos","containerName":null},{"line":789,"kind":13,"name":"$i","containerName":null},{"name":"$i","containerName":null,"line":789,"kind":13},{"name":"$str","containerName":null,"kind":13,"line":789},{"name":"%i","containerName":null,"line":789,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":790},{"containerName":"main::","name":"_print","line":790,"kind":12},{"line":790,"kind":13,"name":"$str","containerName":null},{"containerName":null,"name":"$i","kind":13,"line":790},{"line":791,"kind":13,"containerName":null,"name":"$linepos"},{"line":792,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"%60","kind":13,"line":792},{"name":"$i","containerName":null,"line":792,"kind":13},{"name":"%str","containerName":null,"kind":13,"line":792},{"name":"$self","containerName":null,"line":793,"kind":13},{"name":"_print","containerName":"main::","line":793,"kind":12},{"kind":13,"line":796,"name":"$self","containerName":null},{"name":"_print","containerName":"main::","line":796,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":798},{"containerName":"main::","name":"flush","line":798,"kind":12},{"line":798,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_flush_on_write","line":798,"kind":12},{"line":798,"kind":13,"name":"$self","containerName":null},{"line":798,"kind":12,"name":"_fh","containerName":"main::"},{"line":817,"children":[{"definition":"my","name":"$poly","containerName":"_generateCRCTable","localvar":"my","kind":13,"line":820},{"localvar":"my","name":"$self","definition":"my","containerName":"_generateCRCTable","line":821,"kind":13},{"name":"$self","containerName":"_generateCRCTable","kind":13,"line":823},{"name":"$i","definition":"my","containerName":"_generateCRCTable","localvar":"my","kind":13,"line":824},{"definition":"my","name":"$crc","containerName":"_generateCRCTable","localvar":"my","kind":13,"line":825},{"containerName":"_generateCRCTable","name":"$i","line":825,"kind":13},{"localvar":"my","definition":"my","name":"$j","containerName":"_generateCRCTable","line":826,"kind":13},{"containerName":"_generateCRCTable","name":"$j","kind":13,"line":826},{"line":826,"kind":13,"name":"$j","containerName":"_generateCRCTable"},{"kind":13,"line":827,"containerName":"_generateCRCTable","name":"$crc"},{"containerName":"_generateCRCTable","name":"$crc","line":828,"kind":13},{"kind":13,"line":828,"containerName":"_generateCRCTable","name":"$crc"},{"line":828,"kind":13,"containerName":"_generateCRCTable","name":"$poly"},{"line":830,"kind":13,"containerName":"_generateCRCTable","name":"$crc"},{"line":833,"kind":13,"name":"$self","containerName":"_generateCRCTable"},{"name":"$i","containerName":"_generateCRCTable","line":833,"kind":13},{"line":833,"kind":13,"containerName":"_generateCRCTable","name":"$crc"}],"kind":12,"range":{"start":{"character":0,"line":817},"end":{"line":834,"character":9999}},"containerName":"main::","definition":"sub","name":"_generateCRCTable"},{"kind":12,"children":[{"containerName":"_crc32","definition":"my","name":"$self","localvar":"my","kind":13,"line":851},{"kind":13,"line":851,"containerName":"_crc32","name":"$str"},{"line":853,"kind":13,"name":"$self","containerName":"_crc32"},{"name":"throw","containerName":"_crc32","line":853,"kind":12},{"line":854,"kind":13,"containerName":"_crc32","name":"$str"},{"kind":13,"line":856,"containerName":"_crc32","name":"$self"},{"kind":12,"line":856,"name":"_generateCRCTable","containerName":"_crc32"},{"kind":13,"line":856,"name":"$self","containerName":"_crc32"},{"containerName":"_crc32","name":"$len","definition":"my","localvar":"my","kind":13,"line":858},{"localvar":"my","containerName":"_crc32","definition":"my","name":"$crc","line":860,"kind":13},{"localvar":"my","definition":"my","name":"$i","containerName":"_crc32","line":861,"kind":13},{"kind":13,"line":861,"name":"$i","containerName":"_crc32"},{"kind":13,"line":861,"name":"$len","containerName":"_crc32"},{"line":861,"kind":13,"name":"$i","containerName":"_crc32"},{"kind":13,"line":863,"containerName":"_crc32","definition":"my","name":"$int","localvar":"my"},{"line":863,"kind":13,"name":"$i","containerName":"_crc32"},{"line":864,"kind":13,"containerName":"_crc32","name":"$crc"},{"containerName":"_crc32","name":"$crc","kind":13,"line":864},{"name":"$self","containerName":"_crc32","line":865,"kind":13},{"kind":13,"line":865,"name":"$crc","containerName":"_crc32"},{"containerName":"_crc32","name":"$int","line":865,"kind":13}],"line":850,"definition":"sub","containerName":"main::","signature":{"label":"_crc32($self,$str)","documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$str"}]},"detail":"($self,$str)","name":"_crc32","range":{"end":{"character":9999,"line":866},"start":{"line":850,"character":0}}},{"name":"str","kind":12,"line":858},{"line":863,"kind":12,"name":"str"},{"containerName":null,"name":"$crc","line":867,"kind":13},{"range":{"end":{"line":920,"character":9999},"start":{"character":0,"line":882}},"name":"_crc64","line":882,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_crc64","line":883,"kind":13},{"kind":13,"line":883,"name":"$sequence","containerName":"_crc64"},{"kind":13,"line":884,"containerName":"_crc64","name":"$POLY64REVh","definition":"my","localvar":"my"},{"definition":"my","name":"@CRCTableh","containerName":"_crc64","localvar":"my","kind":13,"line":885},{"line":886,"kind":13,"localvar":"my","containerName":"_crc64","definition":"my","name":"@CRCTablel"},{"line":887,"kind":13,"localvar":"my","containerName":"_crc64","definition":"my","name":"$initialized"},{"line":889,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"_crc64"},{"line":891,"kind":13,"localvar":"my","containerName":"_crc64","name":"$crcl","definition":"my"},{"line":892,"kind":13,"localvar":"my","name":"$crch","definition":"my","containerName":"_crc64"},{"line":893,"kind":13,"name":"$initialized","containerName":"_crc64"},{"containerName":"_crc64","name":"$initialized","line":894,"kind":13},{"localvar":"my","containerName":"_crc64","definition":"my","name":"$i","line":895,"kind":13},{"line":895,"kind":13,"name":"$i","containerName":"_crc64"},{"containerName":"_crc64","name":"$i","kind":13,"line":895},{"localvar":"my","name":"$partl","definition":"my","containerName":"_crc64","line":896,"kind":13},{"kind":13,"line":896,"name":"$i","containerName":"_crc64"},{"containerName":"_crc64","name":"$parth","definition":"my","localvar":"my","kind":13,"line":897},{"localvar":"my","containerName":"_crc64","definition":"my","name":"$j","line":898,"kind":13},{"name":"$j","containerName":"_crc64","line":898,"kind":13},{"containerName":"_crc64","name":"$j","kind":13,"line":898},{"name":"$rflag","definition":"my","containerName":"_crc64","localvar":"my","kind":13,"line":899},{"containerName":"_crc64","name":"$partl","kind":13,"line":899},{"kind":13,"line":900,"containerName":"_crc64","name":"$partl"},{"name":"$partl","containerName":"_crc64","kind":13,"line":901},{"kind":13,"line":901,"name":"$parth","containerName":"_crc64"},{"name":"$parth","containerName":"_crc64","kind":13,"line":902},{"name":"$parth","containerName":"_crc64","kind":13,"line":903},{"line":903,"kind":13,"name":"$POLY64REVh","containerName":"_crc64"},{"line":903,"kind":13,"containerName":"_crc64","name":"$rflag"},{"line":905,"kind":13,"containerName":"_crc64","name":"$CRCTableh"},{"line":905,"kind":13,"containerName":"_crc64","name":"$i"},{"containerName":"_crc64","name":"$parth","line":905,"kind":13},{"line":906,"kind":13,"containerName":"_crc64","name":"$CRCTablel"},{"line":906,"kind":13,"containerName":"_crc64","name":"$i"},{"containerName":"_crc64","name":"$partl","kind":13,"line":906},{"name":"$seq","containerName":"_crc64","kind":13,"line":910},{"localvar":"my","name":"$shr","definition":"my","containerName":"_crc64","line":911,"kind":13},{"name":"$crch","containerName":"_crc64","kind":13,"line":911},{"kind":13,"line":912,"containerName":"_crc64","name":"$temp1h","definition":"my","localvar":"my"},{"containerName":"_crc64","name":"$crch","line":912,"kind":13},{"line":913,"kind":13,"localvar":"my","containerName":"_crc64","name":"$temp1l","definition":"my"},{"containerName":"_crc64","name":"$crcl","kind":13,"line":913},{"name":"$shr","containerName":"_crc64","kind":13,"line":913},{"containerName":"_crc64","definition":"my","name":"$tableindex","localvar":"my","kind":13,"line":914},{"name":"$crcl","containerName":"_crc64","kind":13,"line":914},{"name":"$crch","containerName":"_crc64","line":915,"kind":13},{"kind":13,"line":915,"containerName":"_crc64","name":"$temp1h"},{"line":915,"kind":13,"containerName":"_crc64","name":"$CRCTableh"},{"kind":13,"line":915,"name":"$tableindex","containerName":"_crc64"},{"line":916,"kind":13,"containerName":"_crc64","name":"$crcl"},{"line":916,"kind":13,"containerName":"_crc64","name":"$temp1l"},{"name":"$CRCTablel","containerName":"_crc64","kind":13,"line":916},{"line":916,"kind":13,"name":"$tableindex","containerName":"_crc64"},{"containerName":"_crc64","name":"$crc64","definition":"my","localvar":"my","kind":13,"line":918},{"kind":13,"line":918,"name":"$crch","containerName":"_crc64"},{"containerName":"_crc64","name":"$crcl","line":918,"kind":13},{"kind":13,"line":919,"containerName":"_crc64","name":"$crc64"}],"kind":12,"detail":"($self,$sequence)","signature":{"parameters":[{"label":"$self"},{"label":"$sequence"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"_crc64($self,$sequence)"},"containerName":"main::","definition":"sub"},{"name":"sequence","line":889,"kind":12},{"children":[{"line":935,"kind":13,"localvar":"my","containerName":"_print_swissprot_FTHelper","definition":"my","name":"$self"},{"line":935,"kind":13,"name":"$fth","containerName":"_print_swissprot_FTHelper"},{"kind":13,"line":935,"containerName":"_print_swissprot_FTHelper","name":"$always_quote"},{"name":"$always_quote","containerName":"_print_swissprot_FTHelper","line":936,"kind":13},{"kind":13,"line":937,"containerName":"_print_swissprot_FTHelper","name":"$start","definition":"my","localvar":"my"},{"containerName":"_print_swissprot_FTHelper","name":"$end","line":937,"kind":13},{"name":"$fth","containerName":"_print_swissprot_FTHelper","line":939,"kind":13},{"kind":13,"line":939,"name":"$fth","containerName":"_print_swissprot_FTHelper"},{"name":"isa","containerName":"_print_swissprot_FTHelper","line":939,"kind":12},{"name":"$fth","containerName":"_print_swissprot_FTHelper","line":940,"kind":13},{"name":"warn","containerName":"_print_swissprot_FTHelper","line":940,"kind":12},{"definition":"my","name":"$desc","containerName":"_print_swissprot_FTHelper","localvar":"my","kind":13,"line":943},{"localvar":"my","containerName":"_print_swissprot_FTHelper","name":"$tag","definition":"my","line":945,"kind":13},{"kind":13,"line":946,"name":"$fth","containerName":"_print_swissprot_FTHelper"},{"name":"field","containerName":"_print_swissprot_FTHelper","line":946,"kind":12},{"name":"$tag","containerName":"_print_swissprot_FTHelper","line":946,"kind":13},{"name":"$desc","containerName":"_print_swissprot_FTHelper","kind":13,"line":947},{"containerName":"_print_swissprot_FTHelper","name":"$fth","kind":13,"line":947},{"containerName":"_print_swissprot_FTHelper","name":"field","line":947,"kind":12},{"kind":13,"line":947,"containerName":"_print_swissprot_FTHelper","name":"$tag"}],"line":934,"kind":12,"signature":{"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$fth"},{"label":"$always_quote"}],"label":"_print_swissprot_FTHelper($self,$fth,$always_quote)"},"detail":"($self,$fth,$always_quote)","definition":"sub","containerName":"main::","range":{"end":{"line":950,"character":9999},"start":{"character":0,"line":934}},"name":"_print_swissprot_FTHelper"},{"name":"$desc","containerName":null,"line":951,"kind":13},{"containerName":null,"name":"$ftid","definition":"my","localvar":"my","kind":13,"line":953},{"name":"$fth","containerName":null,"kind":13,"line":954},{"kind":12,"line":954,"name":"field","containerName":"main::"},{"containerName":null,"name":"$ftid","line":955,"kind":13},{"kind":13,"line":955,"containerName":null,"name":"$fth"},{"kind":12,"line":955,"name":"field","containerName":"main::"},{"line":958,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$key"},{"kind":13,"line":958,"name":"$fth","containerName":null},{"kind":12,"line":958,"name":"key","containerName":"main::"},{"localvar":"my","definition":"my","name":"$loc","containerName":null,"line":959,"kind":13},{"name":"$fth","containerName":null,"line":959,"kind":13},{"containerName":"main::","name":"loc","line":959,"kind":12},{"kind":13,"line":960,"name":"%loc","containerName":null},{"kind":13,"line":961,"name":"$start","containerName":null},{"name":"$end","containerName":null,"kind":13,"line":962},{"containerName":null,"name":"%loc","line":966,"kind":13},{"localvar":"my","containerName":null,"name":"@y","definition":"my","line":967,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"%m","line":968,"kind":13},{"line":969,"kind":13,"containerName":null,"name":"$m"},{"name":"@y","containerName":null,"line":970,"kind":13},{"kind":13,"line":970,"containerName":null,"name":"$m"},{"name":"$x","definition":"my","containerName":null,"localvar":"my","kind":13,"line":972},{"line":972,"kind":13,"name":"@y","containerName":null},{"kind":13,"line":973,"containerName":null,"name":"$self"},{"line":973,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"line":975,"kind":13,"name":"$key","containerName":null},{"containerName":null,"name":"$x","line":976,"kind":13},{"line":976,"kind":13,"containerName":null,"name":"$x"},{"containerName":null,"name":"$desc","line":978,"kind":13},{"name":"%LINE_LENGTH","containerName":null,"kind":13,"line":978},{"kind":13,"line":982,"containerName":null,"name":"$start"},{"line":982,"kind":13,"containerName":null,"name":"$end"},{"line":982,"kind":13,"containerName":null,"name":"$fth"},{"line":982,"kind":12,"name":"loc","containerName":"main::"},{"kind":13,"line":984,"containerName":null,"name":"%desc"},{"kind":13,"line":985,"containerName":null,"name":"$self"},{"kind":12,"line":985,"name":"_write_line_swissprot_regex","containerName":"main::"},{"containerName":null,"name":"$key","kind":13,"line":986},{"kind":13,"line":987,"containerName":null,"name":"$start"},{"containerName":null,"name":"$end","line":987,"kind":13},{"kind":13,"line":989,"containerName":null,"name":"$desc"},{"kind":13,"line":989,"containerName":null,"name":"%LINE_LENGTH"},{"name":"$self","containerName":null,"kind":13,"line":991},{"containerName":"main::","name":"_write_line_swissprot_regex","kind":12,"line":991},{"containerName":null,"name":"$key","kind":13,"line":992},{"kind":13,"line":993,"name":"$start","containerName":null},{"containerName":null,"name":"$end","line":993,"kind":13},{"kind":13,"line":995,"containerName":null,"name":"$LINE_LENGTH"},{"containerName":null,"name":"%ftid","line":999,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":1000},{"line":1000,"kind":12,"containerName":"main::","name":"_write_line_swissprot_regex"},{"name":"$LINE_LENGTH","containerName":null,"line":1002,"kind":13},{"containerName":"main::","definition":"sub","detail":"($self,$line)","signature":{"parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :","label":"_read_swissprot_References($self,$line)"},"kind":12,"line":1021,"children":[{"localvar":"my","containerName":"_read_swissprot_References","name":"$self","definition":"my","line":1022,"kind":13},{"kind":13,"line":1022,"name":"$line","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"$b1","definition":"my","localvar":"my","kind":13,"line":1023},{"kind":13,"line":1023,"name":"$b2","containerName":"_read_swissprot_References"},{"name":"$rp","containerName":"_read_swissprot_References","kind":13,"line":1023},{"containerName":"_read_swissprot_References","name":"$rg","kind":13,"line":1023},{"name":"$title","containerName":"_read_swissprot_References","line":1023,"kind":13},{"line":1023,"kind":13,"containerName":"_read_swissprot_References","name":"$loc"},{"name":"$au","containerName":"_read_swissprot_References","kind":13,"line":1023},{"line":1023,"kind":13,"name":"$med","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"$com","line":1023,"kind":13},{"line":1023,"kind":13,"name":"$pubmed","containerName":"_read_swissprot_References"},{"line":1023,"kind":13,"name":"$doi","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"@refs","definition":"my","localvar":"my","kind":13,"line":1024},{"name":"$line","containerName":"_read_swissprot_References","line":1025,"kind":13},{"containerName":"_read_swissprot_References","name":"$rp","line":1028,"kind":13},{"line":1029,"kind":13,"containerName":"_read_swissprot_References","name":"$rg"},{"name":"$rg","containerName":"_read_swissprot_References","kind":13,"line":1029},{"name":"$au","containerName":"_read_swissprot_References","kind":13,"line":1030},{"containerName":"_read_swissprot_References","name":"$au","kind":13,"line":1031},{"name":"$au","containerName":"_read_swissprot_References","kind":13,"line":1033},{"name":"$rg","containerName":"_read_swissprot_References","line":1033,"kind":13},{"kind":13,"line":1035,"containerName":"_read_swissprot_References","name":"$title"},{"name":"$title","containerName":"_read_swissprot_References","line":1035,"kind":13},{"name":"@refs","containerName":"_read_swissprot_References","kind":13,"line":1036},{"line":1037,"kind":12,"name":"new","containerName":"_read_swissprot_References"},{"kind":13,"line":1037,"name":"$title","containerName":"_read_swissprot_References"},{"line":1038,"kind":13,"containerName":"_read_swissprot_References","name":"$b1"},{"containerName":"_read_swissprot_References","name":"$b2","line":1039,"kind":13},{"name":"$au","containerName":"_read_swissprot_References","kind":13,"line":1040},{"kind":13,"line":1041,"name":"$loc","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"$med","line":1042,"kind":13},{"line":1043,"kind":13,"name":"$pubmed","containerName":"_read_swissprot_References"},{"line":1044,"kind":13,"name":"$doi","containerName":"_read_swissprot_References"},{"kind":13,"line":1045,"containerName":"_read_swissprot_References","name":"$com"},{"name":"$rp","containerName":"_read_swissprot_References","kind":13,"line":1046},{"kind":13,"line":1047,"containerName":"_read_swissprot_References","name":"$rg"},{"kind":13,"line":1051,"containerName":"_read_swissprot_References","name":"$rp"},{"kind":13,"line":1054,"name":"$self","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"_pushback","kind":12,"line":1054},{"name":"$b1","containerName":"_read_swissprot_References","kind":13,"line":1058},{"kind":13,"line":1058,"name":"$b2","containerName":"_read_swissprot_References"},{"line":1058,"kind":13,"containerName":"_read_swissprot_References","name":"$rg"},{"line":1058,"kind":13,"containerName":"_read_swissprot_References","name":"$med"},{"containerName":"_read_swissprot_References","name":"$com","line":1058,"kind":13},{"containerName":"_read_swissprot_References","name":"$pubmed","kind":13,"line":1058},{"kind":13,"line":1058,"name":"$doi","containerName":"_read_swissprot_References"},{"name":"$title","containerName":"_read_swissprot_References","kind":13,"line":1059},{"containerName":"_read_swissprot_References","name":"$loc","kind":13,"line":1059},{"kind":13,"line":1059,"containerName":"_read_swissprot_References","name":"$au"},{"kind":13,"line":1061,"name":"$rp","containerName":"_read_swissprot_References"},{"line":1062,"kind":13,"containerName":"_read_swissprot_References","name":"$b1"},{"kind":13,"line":1063,"name":"$b2","containerName":"_read_swissprot_References"},{"line":1065,"kind":13,"containerName":"_read_swissprot_References","name":"$rp"},{"kind":13,"line":1066,"name":"$rp","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"$rp","kind":13,"line":1068},{"localvar":"my","containerName":"_read_swissprot_References","name":"$line","definition":"my","line":1071,"kind":13},{"name":"$med","containerName":"_read_swissprot_References","line":1072,"kind":13},{"kind":13,"line":1072,"containerName":"_read_swissprot_References","name":"$line"},{"kind":13,"line":1073,"name":"$pubmed","containerName":"_read_swissprot_References"},{"containerName":"_read_swissprot_References","name":"$line","line":1073,"kind":13},{"kind":13,"line":1074,"name":"$doi","containerName":"_read_swissprot_References"},{"line":1074,"kind":13,"containerName":"_read_swissprot_References","name":"$line"},{"containerName":"_read_swissprot_References","name":"$au","kind":13,"line":1076},{"kind":13,"line":1076,"containerName":"_read_swissprot_References","name":"$au"},{"containerName":"_read_swissprot_References","name":"$rg","line":1078,"kind":13},{"name":"$rg","containerName":"_read_swissprot_References","kind":13,"line":1078},{"name":"$title","containerName":"_read_swissprot_References","line":1080,"kind":13},{"line":1081,"kind":13,"localvar":"my","name":"$tline","definition":"my","containerName":"_read_swissprot_References"},{"line":1082,"kind":13,"containerName":"_read_swissprot_References","name":"$title"},{"name":"$title","containerName":"_read_swissprot_References","line":1082,"kind":13},{"kind":13,"line":1082,"name":"$tline","containerName":"_read_swissprot_References"},{"name":"$title","containerName":"_read_swissprot_References","kind":13,"line":1084},{"line":1087,"kind":13,"containerName":"_read_swissprot_References","name":"$loc"},{"name":"$loc","containerName":"_read_swissprot_References","kind":13,"line":1087},{"containerName":"_read_swissprot_References","name":"$com","kind":13,"line":1089},{"kind":13,"line":1089,"name":"$com","containerName":"_read_swissprot_References"},{"kind":13,"line":1091,"name":"$self","containerName":"_read_swissprot_References"},{"line":1091,"kind":12,"name":"_readline","containerName":"_read_swissprot_References"},{"name":"@refs","containerName":"_read_swissprot_References","kind":13,"line":1093}],"name":"_read_swissprot_References","range":{"end":{"character":9999,"line":1094},"start":{"line":1021,"character":0}}},{"kind":12,"line":1036,"name":"Bio","containerName":"Annotation::Reference"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :","label":"_read_swissprot_Species($self,$line)"},"detail":"($self,$line)","kind":12,"children":[{"containerName":"_read_swissprot_Species","definition":"my","name":"$self","localvar":"my","kind":13,"line":1112},{"line":1112,"kind":13,"name":"$line","containerName":"_read_swissprot_Species"},{"line":1113,"kind":13,"localvar":"my","definition":"my","name":"$org","containerName":"_read_swissprot_Species"},{"name":"$line","containerName":"_read_swissprot_Species","kind":13,"line":1114},{"line":1116,"kind":13,"localvar":"my","name":"$sub_species","definition":"my","containerName":"_read_swissprot_Species"},{"name":"$species","containerName":"_read_swissprot_Species","kind":13,"line":1116},{"line":1116,"kind":13,"name":"$genus","containerName":"_read_swissprot_Species"},{"name":"$common","containerName":"_read_swissprot_Species","kind":13,"line":1116},{"containerName":"_read_swissprot_Species","name":"$variant","line":1116,"kind":13},{"containerName":"_read_swissprot_Species","name":"$ncbi_taxid","line":1116,"kind":13},{"name":"$sci_name","containerName":"_read_swissprot_Species","line":1116,"kind":13},{"containerName":"_read_swissprot_Species","name":"$class_lines","kind":13,"line":1116},{"name":"$descr","containerName":"_read_swissprot_Species","line":1116,"kind":13},{"definition":"my","name":"$osline","containerName":"_read_swissprot_Species","localvar":"my","kind":13,"line":1117},{"name":"$do_genus_check","definition":"my","containerName":"_read_swissprot_Species","localvar":"my","kind":13,"line":1118},{"containerName":"_read_swissprot_Species","name":"$sci_name","kind":13,"line":1123},{"name":"$osline","containerName":"_read_swissprot_Species","line":1124,"kind":13},{"name":"$osline","containerName":"_read_swissprot_Species","line":1124,"kind":13},{"kind":13,"line":1125,"name":"$osline","containerName":"_read_swissprot_Species"},{"name":"$osline","containerName":"_read_swissprot_Species","kind":13,"line":1126},{"name":"$osline","containerName":"_read_swissprot_Species","kind":13,"line":1133},{"kind":13,"line":1136,"name":"$sci_name","containerName":"_read_swissprot_Species"},{"kind":13,"line":1136,"containerName":"_read_swissprot_Species","name":"$osline"},{"kind":13,"line":1137,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"containerName":"_read_swissprot_Species","name":"$descr","kind":13,"line":1138},{"containerName":"_read_swissprot_Species","name":"$do_genus_check","kind":13,"line":1139},{"containerName":"_read_swissprot_Species","name":"$sci_name","kind":13,"line":1141},{"name":"$descr","containerName":"_read_swissprot_Species","kind":13,"line":1141},{"containerName":"_read_swissprot_Species","name":"$osline","kind":13,"line":1141},{"containerName":"_read_swissprot_Species","name":"$sci_name","kind":13,"line":1143},{"name":"$descr","containerName":"_read_swissprot_Species","kind":13,"line":1145},{"line":1146,"kind":13,"localvar":"my","containerName":"_read_swissprot_Species","name":"$item","definition":"my"},{"name":"$variant","containerName":"_read_swissprot_Species","line":1149,"kind":13},{"kind":13,"line":1150,"name":"$item","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$item","kind":13,"line":1151},{"name":"$variant","containerName":"_read_swissprot_Species","line":1152,"kind":13},{"kind":13,"line":1152,"containerName":"_read_swissprot_Species","name":"$item"},{"kind":13,"line":1153,"containerName":"_read_swissprot_Species","name":"$item"},{"kind":13,"line":1154,"containerName":"_read_swissprot_Species","name":"$sub_species"},{"containerName":"_read_swissprot_Species","name":"$sub_species","kind":13,"line":1155},{"containerName":"_read_swissprot_Species","name":"$item","line":1155,"kind":13},{"name":"$variant","containerName":"_read_swissprot_Species","line":1156,"kind":13},{"containerName":"_read_swissprot_Species","name":"$variant","kind":13,"line":1157},{"containerName":"_read_swissprot_Species","name":"$item","kind":13,"line":1157},{"name":"$common","containerName":"_read_swissprot_Species","kind":13,"line":1159},{"name":"$common","containerName":"_read_swissprot_Species","kind":13,"line":1161},{"kind":13,"line":1161,"name":"$item","containerName":"_read_swissprot_Species"},{"line":1162,"kind":13,"name":"$common","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$common","kind":13,"line":1163},{"containerName":"_read_swissprot_Species","name":"$common","line":1164,"kind":13},{"line":1170,"kind":13,"containerName":"_read_swissprot_Species","name":"$class_lines"},{"kind":13,"line":1172,"name":"$org","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$ncbi_taxid","kind":13,"line":1173},{"kind":13,"line":1174,"containerName":"_read_swissprot_Species","name":"$taxstring","definition":"my","localvar":"my"},{"kind":13,"line":1176,"name":"$taxstring","containerName":"_read_swissprot_Species"},{"kind":13,"line":1177,"containerName":"_read_swissprot_Species","name":"$ncbi_taxid"},{"line":1179,"kind":13,"containerName":"_read_swissprot_Species","name":"$self"},{"line":1179,"kind":12,"containerName":"_read_swissprot_Species","name":"throw"},{"kind":13,"line":1182,"containerName":"_read_swissprot_Species","name":"$self"},{"containerName":"_read_swissprot_Species","name":"_readline","kind":12,"line":1182},{"line":1184,"kind":13,"containerName":"_read_swissprot_Species","name":"$self"},{"line":1184,"kind":12,"containerName":"_read_swissprot_Species","name":"_pushback"},{"line":1186,"kind":13,"name":"$sci_name","containerName":"_read_swissprot_Species"},{"kind":13,"line":1189,"name":"$sci_name","containerName":"_read_swissprot_Species"},{"line":1189,"kind":13,"name":"@Unknown_names","containerName":"_read_swissprot_Species"},{"name":"$class_lines","containerName":"_read_swissprot_Species","kind":13,"line":1195},{"line":1196,"kind":13,"localvar":"my","containerName":"_read_swissprot_Species","name":"@class","definition":"my"},{"name":"$class_lines","containerName":"_read_swissprot_Species","kind":13,"line":1196},{"line":1198,"kind":13,"containerName":"_read_swissprot_Species","name":"$class"},{"name":"@virusnames","definition":"my","containerName":"_read_swissprot_Species","localvar":"my","kind":13,"line":1200},{"line":1200,"kind":13,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"line":1201,"kind":13,"containerName":"_read_swissprot_Species","name":"$species"},{"name":"@virusnames","containerName":"_read_swissprot_Species","kind":13,"line":1201},{"kind":13,"line":1201,"containerName":"_read_swissprot_Species","name":"@virusnames"},{"containerName":"_read_swissprot_Species","name":"$genus","line":1202,"kind":13},{"kind":13,"line":1202,"name":"@virusnames","containerName":"_read_swissprot_Species"},{"line":1203,"kind":13,"name":"$sub_species","containerName":"_read_swissprot_Species"},{"line":1203,"kind":13,"name":"$descr","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$do_genus_check","line":1204,"kind":13},{"kind":13,"line":1206,"containerName":"_read_swissprot_Species","definition":"my","name":"$possible_genus","localvar":"my"},{"containerName":"_read_swissprot_Species","name":"$class","line":1206,"kind":13},{"name":"$possible_genus","containerName":"_read_swissprot_Species","line":1207,"kind":13},{"name":"$class","containerName":"_read_swissprot_Species","kind":13,"line":1207},{"kind":13,"line":1208,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"line":1209,"kind":13,"containerName":"_read_swissprot_Species","name":"$genus"},{"kind":13,"line":1210,"name":"$species","containerName":"_read_swissprot_Species"},{"kind":13,"line":1210,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"name":"$species","containerName":"_read_swissprot_Species","line":1212,"kind":13},{"line":1212,"kind":13,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"kind":13,"line":1216,"containerName":"_read_swissprot_Species","name":"$species"},{"line":1216,"kind":13,"containerName":"_read_swissprot_Species","name":"$species"},{"line":1217,"kind":13,"name":"$species","containerName":"_read_swissprot_Species"},{"kind":13,"line":1217,"name":"$sub_species","containerName":"_read_swissprot_Species"},{"line":1217,"kind":13,"containerName":"_read_swissprot_Species","name":"$species"},{"kind":13,"line":1222,"containerName":"_read_swissprot_Species","name":"$class"},{"line":1222,"kind":13,"containerName":"_read_swissprot_Species","name":"$sci_name"},{"name":"@class","containerName":"_read_swissprot_Species","kind":13,"line":1223},{"containerName":"_read_swissprot_Species","name":"$sci_name","line":1223,"kind":13},{"name":"@class","containerName":"_read_swissprot_Species","kind":13,"line":1225},{"containerName":"_read_swissprot_Species","name":"@class","line":1225,"kind":13},{"definition":"my","name":"$taxon","containerName":"_read_swissprot_Species","localvar":"my","kind":13,"line":1227},{"name":"new","containerName":"_read_swissprot_Species","line":1227,"kind":12},{"containerName":"_read_swissprot_Species","name":"$taxon","kind":13,"line":1228},{"line":1228,"kind":12,"name":"scientific_name","containerName":"_read_swissprot_Species"},{"line":1228,"kind":13,"name":"$sci_name","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$taxon","line":1229,"kind":13},{"kind":12,"line":1229,"name":"classification","containerName":"_read_swissprot_Species"},{"kind":13,"line":1229,"name":"@class","containerName":"_read_swissprot_Species"},{"line":1230,"kind":13,"containerName":"_read_swissprot_Species","name":"$taxon"},{"name":"common_name","containerName":"_read_swissprot_Species","kind":12,"line":1230},{"line":1230,"kind":13,"name":"$common","containerName":"_read_swissprot_Species"},{"line":1230,"kind":13,"containerName":"_read_swissprot_Species","name":"$common"},{"line":1231,"kind":13,"name":"$taxon","containerName":"_read_swissprot_Species"},{"name":"sub_species","containerName":"_read_swissprot_Species","kind":12,"line":1231},{"line":1231,"kind":13,"name":"$sub_species","containerName":"_read_swissprot_Species"},{"name":"$sub_species","containerName":"_read_swissprot_Species","kind":13,"line":1231},{"line":1232,"kind":13,"containerName":"_read_swissprot_Species","name":"$taxon"},{"line":1232,"kind":12,"containerName":"_read_swissprot_Species","name":"organelle"},{"containerName":"_read_swissprot_Species","name":"$org","kind":13,"line":1232},{"name":"$org","containerName":"_read_swissprot_Species","kind":13,"line":1232},{"containerName":"_read_swissprot_Species","name":"$taxon","kind":13,"line":1233},{"name":"ncbi_taxid","containerName":"_read_swissprot_Species","line":1233,"kind":12},{"name":"$ncbi_taxid","containerName":"_read_swissprot_Species","kind":13,"line":1233},{"containerName":"_read_swissprot_Species","name":"$ncbi_taxid","line":1233,"kind":13},{"name":"$taxon","containerName":"_read_swissprot_Species","kind":13,"line":1234},{"kind":12,"line":1234,"name":"variant","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$variant","kind":13,"line":1234},{"kind":13,"line":1234,"name":"$variant","containerName":"_read_swissprot_Species"},{"containerName":"_read_swissprot_Species","name":"$taxon","line":1237,"kind":13}],"line":1111,"name":"_read_swissprot_Species","range":{"end":{"character":9999,"line":1238},"start":{"line":1111,"character":0}}},{"containerName":"Species","name":"Bio","line":1227,"kind":12},{"line":1266,"children":[{"line":1267,"kind":13,"localvar":"my","containerName":"_read_FTHelper_swissprot","definition":"my","name":"$self"},{"line":1267,"kind":13,"name":"$line","containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","name":"$line","kind":13,"line":1273},{"definition":"my","name":"$key","containerName":"_read_FTHelper_swissprot","localvar":"my","kind":13,"line":1274},{"name":"$loc","containerName":"_read_FTHelper_swissprot","line":1275,"kind":13},{"line":1276,"kind":13,"name":"$desc","containerName":"_read_FTHelper_swissprot"},{"kind":13,"line":1277,"containerName":"_read_FTHelper_swissprot","name":"$ftid"},{"line":1280,"kind":13,"name":"$key","containerName":"_read_FTHelper_swissprot"},{"line":1281,"kind":13,"localvar":"my","name":"$loc1","definition":"my","containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","name":"$loc2","definition":"my","localvar":"my","kind":13,"line":1282},{"kind":13,"line":1283,"containerName":"_read_FTHelper_swissprot","name":"$loc"},{"kind":13,"line":1285,"name":"$desc","containerName":"_read_FTHelper_swissprot"},{"line":1286,"kind":13,"name":"$desc","containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","name":"$desc","kind":13,"line":1288},{"containerName":"_read_FTHelper_swissprot","name":"$self","kind":13,"line":1292},{"containerName":"_read_FTHelper_swissprot","name":"_readline","line":1292,"kind":12},{"kind":13,"line":1293,"containerName":"_read_FTHelper_swissprot","definition":"my","name":"$continuation_line","localvar":"my"},{"containerName":"_read_FTHelper_swissprot","name":"$continuation_line","kind":13,"line":1294},{"kind":13,"line":1295,"containerName":"_read_FTHelper_swissprot","name":"$ftid"},{"kind":13,"line":1297,"containerName":"_read_FTHelper_swissprot","name":"$desc"},{"name":"$desc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1298},{"name":"$desc","containerName":"_read_FTHelper_swissprot","line":1300,"kind":13},{"line":1300,"kind":13,"name":"$continuation_line","containerName":"_read_FTHelper_swissprot"},{"line":1302,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$desc"},{"kind":13,"line":1304,"containerName":"_read_FTHelper_swissprot","name":"$self"},{"kind":12,"line":1304,"name":"_pushback","containerName":"_read_FTHelper_swissprot"},{"kind":13,"line":1305,"containerName":"_read_FTHelper_swissprot","name":"$key"},{"containerName":"_read_FTHelper_swissprot","name":"$self","line":1307,"kind":13},{"line":1307,"kind":12,"containerName":"_read_FTHelper_swissprot","name":"warn"},{"kind":13,"line":1312,"name":"$out","definition":"my","containerName":"_read_FTHelper_swissprot","localvar":"my"},{"kind":12,"line":1312,"name":"new","containerName":"_read_FTHelper_swissprot"},{"line":1312,"kind":13,"containerName":"_read_FTHelper_swissprot","name":"$self"},{"containerName":"_read_FTHelper_swissprot","name":"verbose","kind":12,"line":1312},{"name":"$out","containerName":"_read_FTHelper_swissprot","line":1313,"kind":13},{"line":1313,"kind":12,"name":"key","containerName":"_read_FTHelper_swissprot"},{"line":1313,"kind":13,"name":"$key","containerName":"_read_FTHelper_swissprot"},{"name":"$out","containerName":"_read_FTHelper_swissprot","line":1314,"kind":13},{"name":"loc","containerName":"_read_FTHelper_swissprot","line":1314,"kind":12},{"name":"$loc","containerName":"_read_FTHelper_swissprot","kind":13,"line":1314},{"kind":13,"line":1317,"containerName":"_read_FTHelper_swissprot","name":"$desc"},{"kind":13,"line":1317,"name":"$desc","containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","name":"$desc","line":1318,"kind":13},{"line":1319,"kind":13,"name":"$out","containerName":"_read_FTHelper_swissprot"},{"kind":12,"line":1319,"name":"field","containerName":"_read_FTHelper_swissprot"},{"containerName":"_read_FTHelper_swissprot","name":"$desc","kind":13,"line":1319}],"kind":12,"detail":"($self,$line)","signature":{"label":"_read_FTHelper_swissprot($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":1320},"start":{"character":0,"line":1266}},"name":"_read_FTHelper_swissprot"},{"line":1312,"kind":12,"containerName":"SeqIO::FTHelper","name":"Bio"},{"name":"%ftid","containerName":null,"line":1322,"kind":13},{"kind":13,"line":1323,"name":"$out","containerName":null},{"containerName":"main::","name":"field","line":1323,"kind":12},{"line":1323,"kind":13,"containerName":null,"name":"$ftid"},{"containerName":null,"name":"$out","line":1325,"kind":13},{"line":1341,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_write_line_swissprot","line":1342,"kind":13},{"name":"$pre1","containerName":"_write_line_swissprot","line":1342,"kind":13},{"containerName":"_write_line_swissprot","name":"$pre2","kind":13,"line":1342},{"line":1342,"kind":13,"containerName":"_write_line_swissprot","name":"$line"},{"containerName":"_write_line_swissprot","name":"$length","kind":13,"line":1342},{"name":"$length","containerName":"_write_line_swissprot","kind":13,"line":1344},{"line":1344,"kind":13,"containerName":"_write_line_swissprot","name":"$self"},{"kind":12,"line":1344,"name":"throw","containerName":"_write_line_swissprot"},{"name":"$subl","definition":"my","containerName":"_write_line_swissprot","localvar":"my","kind":13,"line":1345},{"containerName":"_write_line_swissprot","name":"$length","kind":13,"line":1345},{"line":1345,"kind":13,"name":"$pre2","containerName":"_write_line_swissprot"},{"name":"$linel","definition":"my","containerName":"_write_line_swissprot","localvar":"my","kind":13,"line":1346},{"kind":13,"line":1346,"containerName":"_write_line_swissprot","name":"$line"},{"localvar":"my","containerName":"_write_line_swissprot","definition":"my","name":"$i","line":1347,"kind":13},{"localvar":"my","containerName":"_write_line_swissprot","definition":"my","name":"$sub","line":1349,"kind":13},{"kind":13,"line":1349,"containerName":"_write_line_swissprot","name":"$line"},{"kind":13,"line":1349,"name":"$length","containerName":"_write_line_swissprot"},{"kind":13,"line":1349,"containerName":"_write_line_swissprot","name":"$pre1"},{"kind":13,"line":1351,"containerName":"_write_line_swissprot","name":"$self"},{"containerName":"_write_line_swissprot","name":"_print","kind":12,"line":1351},{"name":"$i","containerName":"_write_line_swissprot","line":1353,"kind":13},{"kind":13,"line":1353,"containerName":"_write_line_swissprot","name":"$length"},{"containerName":"_write_line_swissprot","name":"$pre1","line":1353,"kind":13},{"name":"$i","containerName":"_write_line_swissprot","line":1353,"kind":13},{"line":1353,"kind":13,"name":"$linel","containerName":"_write_line_swissprot"},{"containerName":"_write_line_swissprot","name":"$sub","kind":13,"line":1354},{"containerName":"_write_line_swissprot","name":"$line","line":1354,"kind":13},{"containerName":"_write_line_swissprot","name":"$i","kind":13,"line":1354},{"containerName":"_write_line_swissprot","name":"$subl","kind":13,"line":1354},{"line":1355,"kind":13,"containerName":"_write_line_swissprot","name":"$self"},{"kind":12,"line":1355,"containerName":"_write_line_swissprot","name":"_print"},{"containerName":"_write_line_swissprot","name":"$i","kind":13,"line":1356},{"containerName":"_write_line_swissprot","name":"$subl","kind":13,"line":1356}],"kind":12,"detail":"($self,$pre1,$pre2,$line,$length)","signature":{"label":"_write_line_swissprot($self,$pre1,$pre2,$line,$length)","parameters":[{"label":"$self"},{"label":"$pre1"},{"label":"$pre2"},{"label":"$line"},{"label":"$length"}],"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :\n\n\n\nsub _read_FTHelper_swissprot {\n    my ($self,$line ) = @_;\n    # initial version implemented by HL 05/10/2000\n    # FIXME this may not be perfect, so please review\n    # lots of cleaning up by JES 2004/07/01, still may not be perfect =)\n    # FTId now sepated from description as a qualifier\n\n    local $_ = $line;\n    my ($key,                   # The key of the feature\n        $loc,                   # The location line from the feature\n        $desc,                  # The descriptive text\n        $ftid,                  # feature Id is like a qualifier but there can be only one of them\n       );\n    if ( m/^FT\\s{3}(\\w+)\\s+([\\d\\?\\<]+)\\s+([\\d\\?\\>]+)\\s*(.*)$/ox) {\n        $key = $1;\n        my $loc1 = $2;\n        my $loc2 = $3;\n        $loc = \"$loc1..$loc2\";\n        if ($4 && (length($4) > 0)) {\n            $desc = $4;\n            chomp($desc);\n        } else {\n            $desc = \"\";\n        }\n    }\n\n    while ( defined($_ = $self->_readline) && /^FT\\s{20,}(\\S.*)$/ ) {\n        my $continuation_line = $1;\n        if ( $continuation_line =~ /.FTId=(.*)\\./ ) {\n            $ftid=$1;\n        }\n        elsif ( $desc) {\n            $desc .= \" $continuation_line\";\n        } else {\n            $desc = $continuation_line;\n        }\n        chomp $desc;\n    }\n    $self->_pushback($_);\n    unless( $key ) {\n        # No feature key. What's this?\n        $self->warn(\"No feature key in putative feature table line: $line\");\n        return;\n    }\n\n    # Make the new FTHelper object\n    my $out = Bio::SeqIO::FTHelper->new(-verbose => $self->verbose());\n    $out->key($key);\n    $out->loc($loc);\n\n    # store the description if there is one\n    if ( $desc && length($desc) ) {\n        $desc =~ s/\\.$//;\n        push(@{$out->field->{\"description\"}}, $desc);\n    }\n    # Store the qualifier i.e. FTId\n    if ( $ftid ) {\n        push(@{$out->field->{\"FTId\"}}, $ftid);\n    }\n    return $out;\n}\n\n\n=head2 _write_line_swissprot\n\n Title   : _write_line_swissprot\n Usage   :\n Function: internal function\n Example :\n Returns :\n Args    :"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1341},"end":{"character":9999,"line":1359}},"name":"_write_line_swissprot"},{"name":"_write_line_swissprot_regex","range":{"end":{"character":9999,"line":1405},"start":{"line":1376,"character":0}},"kind":12,"children":[{"line":1377,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_write_line_swissprot_regex"},{"name":"$pre1","containerName":"_write_line_swissprot_regex","line":1377,"kind":13},{"name":"$pre2","containerName":"_write_line_swissprot_regex","kind":13,"line":1377},{"line":1377,"kind":13,"name":"$line","containerName":"_write_line_swissprot_regex"},{"line":1377,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$regex"},{"containerName":"_write_line_swissprot_regex","name":"$length","kind":13,"line":1377},{"name":"$length","containerName":"_write_line_swissprot_regex","kind":13,"line":1381},{"line":1381,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$self"},{"name":"throw","containerName":"_write_line_swissprot_regex","line":1381,"kind":12},{"kind":13,"line":1383,"name":"$pre1","containerName":"_write_line_swissprot_regex"},{"line":1383,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$pre2"},{"kind":13,"line":1384,"name":"$self","containerName":"_write_line_swissprot_regex"},{"line":1384,"kind":12,"containerName":"_write_line_swissprot_regex","name":"warn"},{"containerName":"_write_line_swissprot_regex","name":"$pre1","line":1384,"kind":13},{"line":1384,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$pre2"},{"name":"$self","containerName":"_write_line_swissprot_regex","kind":13,"line":1385},{"kind":12,"line":1385,"containerName":"_write_line_swissprot_regex","name":"throw"},{"definition":"my","name":"$subl","containerName":"_write_line_swissprot_regex","localvar":"my","kind":13,"line":1388},{"name":"$length","containerName":"_write_line_swissprot_regex","line":1388,"kind":13},{"name":"$pre1","containerName":"_write_line_swissprot_regex","line":1388,"kind":13},{"containerName":"_write_line_swissprot_regex","definition":"my","name":"$first_line","localvar":"my","kind":13,"line":1390},{"containerName":"_write_line_swissprot_regex","name":"$line","line":1391,"kind":13},{"kind":13,"line":1392,"name":"$s","definition":"my","containerName":"_write_line_swissprot_regex","localvar":"my"},{"line":1393,"kind":13,"name":"$s","containerName":"_write_line_swissprot_regex"},{"kind":13,"line":1394,"name":"$pre1","containerName":"_write_line_swissprot_regex"},{"containerName":"_write_line_swissprot_regex","name":"$pre1","kind":13,"line":1394},{"name":"$s","containerName":"_write_line_swissprot_regex","line":1396,"kind":13},{"containerName":"_write_line_swissprot_regex","name":"$s","kind":13,"line":1396},{"containerName":"_write_line_swissprot_regex","name":"$first_line","kind":13,"line":1397},{"name":"$self","containerName":"_write_line_swissprot_regex","line":1398,"kind":13},{"containerName":"_write_line_swissprot_regex","name":"_print","line":1398,"kind":12},{"line":1399,"kind":13,"containerName":"_write_line_swissprot_regex","name":"$first_line"},{"containerName":"_write_line_swissprot_regex","name":"$self","line":1401,"kind":13},{"kind":12,"line":1401,"name":"_print","containerName":"_write_line_swissprot_regex"}],"line":1376,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: swiss.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqIO::swiss\n#\n# Copyright Elia Stupka\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::swiss - Swissprot sequence input/output stream\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system:\n\n    use Bio::SeqIO;\n\n    $stream = Bio::SeqIO->new(-file => $filename,\n                              -format => 'swiss');\n\n    while ( my $seq = $stream->next_seq() ) {\n       # do something with $seq\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from Swiss-Pprot flat\nfile databases.\n\nThere is a lot of flexibility here about how to dump things which needs\nto be documented.\n\n=head2 GN (Gene name) line management details\n\nA Uniprot/Swiss-Prot entry holds information on one protein\nsequence. If that sequence is identical across genes and species, they\nare all merged into one entry. This creates complex needs for several\nannotation fields in swiss-prot format.\n\nThe latest syntax for GN line is described in the user manual:\n\n  http://www.expasy.ch/sprot/userman.html#GN_line\n\nEach of the possibly multiple genes in an entry can have Name,\nSynonyms (only if there is a name), OrderedLocusNames (names from\ngenomic sequences) and ORFNames (temporary or cosmid names). \"Name\"\nhere really means \"symbol\". This complexity is now dealt with the\nfollowing way:\n\nA new Bio::AnnotationI class was created in order to store the\ndata in tag-value pairs.  This class (Bio::Annotation::TagTree)\nis stored in the Bio::Annotation::Collection object and is\naccessed like all other annotations. The tag name is 'gene_name'.\n\nThere is a single Bio::Annotation::TagTree per sequence record, which\ncorresponds to the original class that stored this data\n(Bio::Annotation::StructuredValue).  Depending on how we progress\nthis may change to represent each group of gene names.\n\nFor now, to access the gene name tree annotation, one uses the below method:\n\n   my ($gene) = $seq->annotation->get_Annotations('gene_name');\n\nIf you are only interested in displaying the values, value() returns a\nstring with similar formatting.\n\nThere are several ways to get directly at the information you want if you\nknow the element (tag) for the data.  For gene names all data is stored with\nthe element-tag pairs:\n\n  \"element1=tag1, tag2, tag3; element2=tag4, tag5;\"\n\nThis normally means the element will be 'Name', 'Synonyms', etc. and the\ngene names the values.  Using findval(), you can do the following:\n\n  # grab a flattened list of all gene names\n  my @names = $ann->findval('Name');\n\n  # or iterated through the nodes and grab the name for each group\n  for my $node ($ann->findnode('gene_name')) {\n     my @names = $node->findval('Name');\n  }\n\nThe current method for parsing gene name data (and reconstructing gene name\noutput) is very generic. This is somewhat preemptive if, for instance, UniProt\ndecides to update and add another element name to the current ones using the\nsame formatting layout. Under those circumstances, one can iterate through the\ntag tree in a safe way and retrieve all node data like so.\n\n  # retrieve the gene name nodes (groups like names, synonyms, etc).\n  for my $ann ($seq->annotation->get_Annotations('gene_name')) {\n\n      # each gene name group\n      for my $node ($ann->findnode('gene_name')) {\n          print \"Gene name:\\n\";\n\n          # each gene name node (tag => value pair)\n          for my $n ($node->children) {\n              print \"\\t\".$n->element.\": \".$n->children.\"\\n\";\n          }\n      }\n  }\n\nFor more uses see Bio::Annotation::TagTree.\n\nSince Uniprot/Swiss-Prot format have been around for quite some time, the\nparser is also able to read in the older GN line syntax where genes\nare separated by AND and various symbols by OR. The first symbol is\ntaken to be the 'Name' and the remaining ones are stored as 'Synonyms'.\n\n=head2 Optional functions\n\n=over 3\n\n* _show_dna()\n\n(output only) shows the dna or not\n\n* _post_sort()\n\n(output only) provides a sorting func which is applied to the FTHelpers\nbefore printing\n\n* _id_generation_func()\n\nThis is function which is called as\n\n   print \"ID   \", $func($seq), \"\\n\";\n\nTo generate the ID line. If it is not there, it generates a sensible ID\nline using a number of tools.\n\nIf you want to output annotations in Swissprot format they need to be\nstored in a Bio::Annotation::Collection object which is accessible\nthrough the Bio::SeqI interface method L<annotation()|annotation>.\n\nThe following are the names of the keys which are polled from a\nL<Bio::Annotation::Collection> object.\n\n reference   - Should contain Bio::Annotation::Reference objects\n comment     - Should contain Bio::Annotation::Comment objects\n dblink      - Should contain Bio::Annotation::DBLink objects\n gene_name   - Should contain Bio::Annotation::SimpleValue object\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions,\npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Elia Stupka\n\nEmail elia@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::swiss;\nuse vars qw(@Unknown_names @Unknown_genus);\nuse strict;\nuse Bio::SeqIO::FTHelper;\nuse Bio::SeqFeature::Generic;\nuse Bio::Species;\nuse Bio::Tools::SeqStats;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::Comment;\nuse Bio::Annotation::Reference;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::TagTree;\n\nuse base qw(Bio::SeqIO);\n\nour $LINE_LENGTH = 76;\n\n# this is for doing species name parsing\n@Unknown_names=('other', 'unidentified',\n                'unknown organism', 'not specified',\n                'not shown', 'Unspecified', 'Unknown',\n                'None', 'unclassified', 'unidentified organism',\n                'not supplied'\n               );\n# dictionary of synonyms for taxid 32644\n# all above can be part of valid species name\n@Unknown_genus = qw(unknown unclassified uncultured unidentified);\n\n# if there are any other gene name tags, they are added to the end\nour @GENE_NAME_ORDER = qw(Name Synonyms OrderedLocusNames ORFNames);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    # hash for functions for decoding keys.\n    $self->{'_func_ftunit_hash'} = {};\n    # sets this to one by default. People can change it\n    $self->_show_dna(1);\n    if ( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                                (-verbose => $self->verbose(),\n                                 -type => 'Bio::Seq::RichSeq'));\n    }\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\nsub next_seq {\n    my ($self,@args) = @_;\n    my ($pseq,$c,$line,$name,$desc,$acc,$seqc,$mol,$div, $sptr,$seq_div,\n        $date,$comment,@date_arr);\n    my $genename = \"\";\n    my ($annotation, %params, @features) = ( Bio::Annotation::Collection->new());\n\n    local $_;\n\n    1 while defined($_ = $self->_readline) && /^\\s+$/;\n    return unless defined $_ && /^ID\\s/;\n\n    # fixed to allow _DIVISION to be optional for bug #946\n    # see bug report for more information\n    #\n    # 9/6/06 Note: Swiss/TrEMBL sequences have no division acc. to UniProt\n    # release notes; this is fixed to simplify the regex parsing\n    # STANDARD (SwissProt) and PRELIMINARY (TrEMBL) added to namespace()\n    unless(  m{^\n               ID              \\s+     #\n               (\\S+)           \\s+     #  $1  entryname\n               ([^\\s;]+);      \\s+     #  $2  DataClass\n               (?:PRT;)?       \\s+     #  Molecule Type (optional)\n               [0-9]+[ ]AA     \\.      #  Sequencelength (capture?)\n               $\n           }ox ) {\n            # I couldn't find any new current UniProt sequences\n            # that matched this format:\n            # || m/^ID\\s+(\\S+)\\s+(_([^\\s_]+))? /ox ) {\n        $self->throw(\"swissprot stream with no ID. Not swissprot in my book\");\n    }\n    ($name, $seq_div) = ($1, $2);\n    $params{'-namespace'} =\n        ($seq_div eq 'Reviewed'   || $seq_div eq 'STANDARD')     ? 'Swiss-Prot' :\n        ($seq_div eq 'Unreviewed' || $seq_div eq 'PRELIMINARY')  ? 'TrEMBL'     :\n         $seq_div;\n    # we shouldn't be setting the division, but for now...\n    my ($junk, $division) = split q(_), $name;\n    $params{'-division'} = $division;\n    $params{'-alphabet'} = 'protein';\n    # this is important to have the id for display in e.g. FTHelper, otherwise\n    # you won't know which entry caused an error\n    $params{'-display_id'} = $name;\n\n    BEFORE_FEATURE_TABLE :\n          while ( defined($_ = $self->_readline) ) {\n              # Exit at start of Feature table and at the sequence at the\n              # latest HL 05/11/2000\n              last if( /^(FT|SQ)/ );\n\n              # Description line(s)\n              if (/^DE\\s+(\\S.*\\S)/) {\n                  $desc .= $desc ? \" $1\" : $1;\n              }\n              #Gene name\n              elsif (/^GN\\s+(.*)/) {\n                  $genename .= \" \" if $genename;\n                  $genename .= $1;\n              }\n              #accession number(s)\n              elsif ( /^AC\\s+(.+)/) {\n                  my @accs = split(/[; ]+/, $1); # allow space in addition\n                  $params{'-accession_number'} = shift @accs\n                      unless defined $params{'-accession_number'};\n                  push @{$params{'-secondary_accessions'}}, @accs;\n              }\n              #date and sequence version\n              elsif ( /^DT\\s+(.*)/ ) {\n                  my $line = $1;\n                  my ($date, $version) = split(' ', $line, 2);\n                  $date =~ tr/,//d; # remove comma if new version\n                  if ($version =~ /\\(Rel\\. (\\d+), Last sequence update\\)/ || # old\n                      /sequence version (\\d+)/) { #new\n                      my $update = Bio::Annotation::SimpleValue->new\n                          (-tagname    => 'seq_update',\n                           -value      => $1\n                          );\n                      $annotation->add_Annotation($update);\n                  } elsif ($version =~ /\\(Rel\\. (\\d+), Last annotation update\\)/ || #old\n                           /entry version (\\d+)/) { #new\n                      $params{'-version'} = $1;\n                  }\n                  push @{$params{'-dates'}}, $date;\n              }\n              # Evidence level\n              elsif ( /^PE\\s+(.*)/ ) {\n                  my $line = $1;\n                  $line =~ s/;\\s*//; # trim trailing semicolon and any spaces at the end of the line\n                  my $evidence = Bio::Annotation::SimpleValue->new\n                      (-tagname   => 'evidence',\n                       -value     => $line\n                      );\n                  $annotation->add_Annotation($evidence);\n              }\n              # Organism name and phylogenetic information\n              elsif (/^O[SCG]/) {\n                  my $species = $self->_read_swissprot_Species($_);\n                  $params{'-species'}= $species;\n                  # now we are one line ahead -- so continue without reading the next\n                  # line   HL 05/11/2000\n              }\n              # References\n              elsif (/^R/) {\n                  my $refs = $self->_read_swissprot_References($_);\n                  foreach my $r (@$refs) {\n                      $annotation->add_Annotation('reference',$r);\n                  }\n              }\n              # Comments\n              elsif (/^CC\\s{3}(.*)/) {\n                  $comment .= $1;\n                  $comment .= \"\\n\";\n                  while (defined ($_ = $self->_readline) && /^CC\\s{3}(.*)/ ) {\n                      $comment .= $1 . \"\\n\";\n                  }\n\n                  # note: don't try to process comments here -- they may contain\n                  # structure. LP 07/30/2000\n\n                  my $commobj = Bio::Annotation::Comment->new(-tagname => 'comment',\n                                                              -text    => $comment);\n                  $annotation->add_Annotation('comment',$commobj);\n                  $comment = \"\";\n                  $self->_pushback($_);\n              }\n              #DBLinks\n              # old regexp\n              # /^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+(\\S+)[\\;\\.](.*)$/) {\n              # new regexp from Andreas Kahari  bug #1584\n              elsif (/^DR\\s+(\\S+)\\;\\s+(\\S+)\\;\\s+([^;]+)[\\;\\.](.*)$/) {\n                  my ($database,$primaryid,$optional,$comment) = ($1,$2,$3,$4);\n\n                  # drop leading and training spaces and trailing .\n                  $comment =~ s/\\.\\s*$//;\n                  $comment =~ s/^\\s+//;\n\n                  my $dblinkobj =  Bio::Annotation::DBLink->new\n                      (-database    => $database,\n                       -primary_id  => $primaryid,\n                       -optional_id => $optional,\n                       -comment     => $comment,\n                       -tagname     => 'dblink',\n                      );\n\n                  $annotation->add_Annotation('dblink',$dblinkobj);\n              }\n              #keywords\n              elsif ( /^KW\\s+(.*)$/ ) {\n                  my @kw = split(/\\s*\\;\\s*/,$1);\n                  defined $kw[-1] && $kw[-1] =~ s/\\.$//;\n                  push @{$params{'-keywords'}}, @kw;\n              }\n          }\n    # process and parse the gene name line if there was one (note: we\n    # can't do this above b/c GN may be multi-line and we can't\n    # unequivocally determine whether we've seen the last GN line in\n    # the new format)\n    if ($genename) {\n        my @stags;\n        if ($genename =~ /\\w=\\w/) {\n            # new format (e.g., Name=RCHY1; Synonyms=ZNF363, CHIMP)\n            for my $n (split(m{\\s+and\\s+},$genename)) {\n                my @genenames;\n                for my $section (split(m{\\s*;\\s*},$n)) {\n                    my ($tag, $rest) = split(\"=\",$section);\n                    $rest ||= '';\n                    for my $val (split(m{\\s*,\\s*},$rest)) {\n                        push @genenames, [$tag => $val];\n                    }\n                }\n                push @stags, ['gene_name' => \\@genenames];\n            }\n        } else {\n            # old format\n            for my $section (split(/ AND /, $genename)) {\n                my @genenames;\n                $section =~ s/[\\(\\)\\.]//g;\n                my @names = split(m{\\s+OR\\s+}, $section);\n                push @genenames, ['Name' => shift @names];\n                push @genenames, map {['Synonyms' => $_]} @names;\n                push @stags, ['gene_name' => \\@genenames]            \n            }\n        } #use Data::Dumper; print Dumper $gn, $genename;# exit;\n        my $gn = Bio::Annotation::TagTree->new(-tagname => 'gene_name',\n                                               -value => ['gene_names' => \\@stags]);\n        $annotation->add_Annotation('gene_name', $gn);\n    }\n\n    FEATURE_TABLE :\n          # if there is no feature table, or if we've got beyond, exit loop or don't\n          # even enter    HL 05/11/2000\n          while (defined $_ && /^FT/ ) {\n              my $ftunit = $self->_read_FTHelper_swissprot($_);\n\n              # process ftunit\n              # when parsing of the line fails we get undef returned\n              if ($ftunit) {\n                  push(@features,\n                       $ftunit->_generic_seqfeature($self->location_factory(),\n                                                    $params{'-seqid'}, \"SwissProt\"));\n              } else {\n                  $self->warn(\"failed to parse feature table line for seq \" .\n                              $params{'-display_id'}. \"\\n$_\");\n              }\n              $_ = $self->_readline;\n          }\n    while ( defined($_) && ! /^SQ/ ) {\n        $_ = $self->_readline;\n    }\n    $seqc = \"\";\n    while ( defined ($_ = $self->_readline) ) {\n        last if m{^//};\n        s/[^A-Za-z]//g;\n        $seqc .= uc($_);\n    }\n\n    my $seq=  $self->sequence_factory->create\n        (-verbose  => $self->verbose,\n         %params,\n         -seq      => $seqc,\n         -desc     => $desc,\n         -features => \\@features,\n         -annotation => $annotation,\n        );\n\n    # The annotation doesn't get added by the contructor\n    $seq->annotation($annotation);\n\n    return $seq;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object (must be seq) to the stream\n Returns : 1 for success and 0 for error\n Args    : array of 1 to n Bio::SeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seqs) = @_;\n    foreach my $seq ( @seqs ) {\n        $self->throw(\"Attempting to write with no seq!\") unless defined $seq;\n\n        if ( ! ref $seq || ! $seq->isa('Bio::SeqI') ) {\n            $self->warn(\" $seq is not a SeqI compliant module. Attempting to dump, but may fail!\");\n        }\n\n        my $i;\n        my $str = $seq->seq;\n\n        my $div;\n        my $ns = ($seq->can('namespace')) && $seq->namespace();\n        my $len = $seq->length();\n\n        if ( !$seq->can('division') || ! defined ($div = $seq->division()) ) {\n            $div = 'UNK';\n        }\n\n        # namespace dictates database, takes precedent over division. Sorry!\n        if (defined($ns)) {\n            $div = ($ns eq 'Swiss-Prot') ? 'Reviewed'    :\n                ($ns eq 'TrEMBL')     ? 'Unreviewed' :\n                    $ns;\n        } else {\n            $ns = 'Swiss-Prot';\n            # division not reset; acts as fallback\n        }\n\n        $self->warn(\"No whitespace allowed in SWISS-PROT display id [\". $seq->display_id. \"]\")\n            if $seq->display_id =~ /\\s/;\n\n        my $temp_line;\n        if ( $self->_id_generation_func ) {\n            $temp_line = &{$self->_id_generation_func}($seq);\n        } else {\n            #$temp_line = sprintf (\"%10s     STANDARD;      %3s;   %d AA.\",\n            #            $seq->primary_id().\"_\".$div,$mol,$len);\n            # Reconstructing the ID relies heavily upon the input source having\n            # been in a format that is parsed as this routine expects it -- that is,\n            # by this module itself. This is bad, I think, and immediately breaks\n            # if e.g. the Bio::DB::GenPept module is used as input.\n            # Hence, switch to display_id(); _every_ sequence is supposed to have\n            # this. HL 2000/09/03\n            # Changed to reflect ID line changes in UniProt\n            # Oct 2006 - removal of molecule type - see bug 2134\n            $temp_line = sprintf (\"%-24s%-12s%9d AA.\",\n                                  $seq->display_id(), $div.';', $len);\n        }\n\n        $self->_print( \"ID   $temp_line\\n\");\n\n        # if there, write the accession line\n        local($^W) = 0;         # supressing warnings about uninitialized fields\n\n        if ( $self->_ac_generation_func ) {\n            $temp_line = &{$self->_ac_generation_func}($seq);\n            $self->_print( \"AC   $temp_line\\n\");\n        }\n        elsif ($seq->can('accession_number') ) {\n            my $ac_line = $seq->accession_number;\n            if ($seq->can('get_secondary_accessions') ) {\n                foreach my $sacc ($seq->get_secondary_accessions) {\n                    $ac_line .= \"; \". $sacc;;\n                }\n                $ac_line .= \";\";\n            }\n\n            $self->_write_line_swissprot_regex(\"AC   \",\"AC   \",$ac_line,\n                                               \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n        }\n        # otherwise - cannot print <sigh>\n\n\n        # Date lines and sequence versions (changed 6/15/2006)\n        # This is rebuilt from scratch using the current SwissProt/UniProt format\n        if ( $seq->can('get_dates') ) {\n            my @dates =  $seq->get_dates();\n            my $ct = 1;\n            my $seq_version = $seq->version;\n            my ($update_version) = $seq->annotation->get_Annotations(\"seq_update\");\n            foreach my $dt (@dates) {\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.', integrated into UniProtKB/'.$ns.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 1;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", sequence version \".$update_version->display_text.'.',\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 2;\n                $self->_write_line_swissprot_regex(\"DT   \",\"DT   \",\n                                                   $dt.\", entry version $seq_version.\",\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $ct == 3;\n                $ct++;\n            }\n        }\n\n        #Definition lines\n        $self->_write_line_swissprot_regex(\"DE   \",\"DE   \",$seq->desc(),\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n        #Gene name; print out new format\n        foreach my $gene ( my @genes = $seq->annotation->get_Annotations('gene_name') ) {\n            # gene is a Bio::Annotation::TagTree;\n            my @genelines;\n            for my $node ($gene->findnode('gene_name')) {\n                # check for Name and Synonym first, then the rest get tagged on\n                my $geneline = \"GN   \";\n                my %genedata = $node->hash;\n                for my $tag (@GENE_NAME_ORDER) {\n                    if (exists $genedata{$tag}) {\n                        $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                            \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                            \"$tag=$genedata{$tag}; \";\n                        delete $genedata{$tag};\n                    }\n                }\n                # add rest\n                for my $tag (sort keys %genedata) {\n                    $geneline .= (ref $genedata{$tag} eq 'ARRAY') ?\n                        \"$tag=\".join(', ',@{$genedata{$tag}}).\"; \" :\n                        \"$tag=$genedata{$tag}; \";\n                    delete $genedata{$tag};\n                }\n                push @genelines, \"$geneline\\n\";\n            }\n            $self->_print(join(\"GN   and\\n\",@genelines));\n        }\n\n        # Organism lines\n        if ($seq->can('species') && (my $spec = $seq->species)) {\n            my @class = $spec->classification();\n            shift(@class);\n            my $species = $spec->species;\n            my $genus = $spec->genus;\n            my $OS = $spec->scientific_name;\n            if ($class[-1] =~ /viruses/i) {\n                $OS = $species;\n                $OS .=  \" \". $spec->sub_species if $spec->sub_species;\n            }\n            foreach (($spec->variant, $spec->common_name)) {\n                $OS .= \" ($_)\" if $_;\n            }\n            $self->_print( \"OS   $OS.\\n\");\n            my $OC = join('; ', reverse(@class)) .'.';\n            $self->_write_line_swissprot_regex(\"OC   \",\"OC   \",$OC,\"\\; \\|\\$\",$LINE_LENGTH);\n            if ($spec->organelle) {\n                $self->_write_line_swissprot_regex(\"OG   \",\"OG   \",$spec->organelle,\"\\; \\|\\$\",$LINE_LENGTH);\n            }\n            if ($spec->ncbi_taxid) {\n                $self->_print(\"OX   NCBI_TaxID=\".$spec->ncbi_taxid.\";\\n\");\n            }\n        }\n\n        # Reference lines\n        my $t = 1;\n        foreach my $ref ( $seq->annotation->get_Annotations('reference') ) {\n            $self->_print( \"RN   [$t]\\n\");\n            # changed by lorenz 08/03/00\n            # j.gilbert and h.lapp agreed that the rp line in swissprot seems\n            # more like a comment than a parseable value, so print it as is\n            if ($ref->rp) {\n                $self->_write_line_swissprot_regex(\"RP   \",\"RP   \",$ref->rp,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->comment) {\n                $self->_write_line_swissprot_regex(\"RC   \",\"RC   \",$ref->comment,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            }\n            if ($ref->medline or $ref->pubmed or $ref->doi) {\n                # new RX format in swissprot LP 09/17/00\n                # RX line can now have a DOI, Heikki 13 Feb 2008\n\n                my $line;\n                $line .= \"MEDLINE=\". $ref->medline. '; ' if $ref->medline;\n                $line .= \"PubMed=\". $ref->pubmed. '; ' if $ref->pubmed;\n                $line .= \"DOI=\". $ref->doi. '; ' if $ref->doi;\n                chop $line;\n\n                $self->_write_line_swissprot_regex(\"RX   \",\"RX   \",\n                                                   $line,\n                                                   \"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n\n            }\n            my $author = $ref->authors .';' if($ref->authors);\n            my $title = $ref->title .';' if( $ref->title);\n            my $rg = $ref->rg . ';' if $ref->rg;\n            $author =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n\n            $self->_write_line_swissprot_regex(\"RG   \",\"RG   \",$rg,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $rg;\n            $self->_write_line_swissprot_regex(\"RA   \",\"RA   \",$author,\"\\\\s\\+\\|\\$\",$LINE_LENGTH) if $author;\n            $self->_write_line_swissprot_regex(\"RT   \",\"RT   \",$title,'[\\s\\-]+|$',$LINE_LENGTH) if $title;\n            $self->_write_line_swissprot_regex(\"RL   \",\"RL   \",$ref->location,\"\\\\s\\+\\|\\$\",$LINE_LENGTH);\n            $t++;\n        }\n\n        # Comment lines\n\n        foreach my $comment ( $seq->annotation->get_Annotations('comment') ) {\n            foreach my $cline (split (\"\\n\", $comment->text)) {\n                while (length $cline > 74) {\n                    $self->_print(\"CC   \",(substr $cline,0,74),\"\\n\");\n                    $cline = substr $cline,74;\n                }\n                $self->_print(\"CC   \",$cline,\"\\n\");\n            }\n        }\n\n        # Database xref lines\n\n        foreach my $dblink ( $seq->annotation->get_Annotations('dblink') ) {\n            my ($primary_id) = $dblink->primary_id;\n\t\n            if (defined($dblink->comment) && ($dblink->comment) ) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",$primary_id,\"; \",\n                              $dblink->optional_id,\"; \",$dblink->comment,\".\\n\");\n            } elsif ($dblink->optional_id) {\n                $self->_print(\"DR   \",$dblink->database,\"; \",\n                              $primary_id,\"; \",\n                              $dblink->optional_id,\".\\n\");\n            } else {\n                $self->_print(\"DR   \",$dblink->database,\n                              \"; \",$primary_id,\"; \",\"-.\\n\");\n            }\n        }\n\n        # Evidence lines\n\n        foreach my $evidence ( $seq->annotation->get_Annotations('evidence') ) {\n            $self->_print(\"PE   \",$evidence->value,\";\\n\");\n        }\n\n        # if there, write the kw line\n        {\n            my $kw;\n            if ( my $func = $self->_kw_generation_func ) {\n                $kw = &{$func}($seq);\n            } elsif ( $seq->can('keywords') ) {\n                $kw = $seq->keywords;\n                if ( ref($kw) =~ /ARRAY/i ) {\n                    $kw = join(\"; \", @$kw);\n                }\n                $kw .= '.' if $kw and $kw !~ /\\.$/ ;\n            }\n            $kw =~ s/([\\w\\.]) (\\w)/$1#$2/g;  # add word wrap protection char '#'\n            $self->_write_line_swissprot_regex(\"KW   \",\"KW   \",\n                                               $kw, \"\\\\s\\+\\|\\$\",$LINE_LENGTH)\n                if $kw;\n        }\n\n        #Check if there is seqfeatures before printing the FT line\n        my @feats = $seq->can('top_SeqFeatures') ? $seq->top_SeqFeatures : ();\n        if ($feats[0]) {\n            if ( defined $self->_post_sort ) {\n\n                # we need to read things into an array. Process. Sort them. Print 'em\n\n                my $post_sort_func = $self->_post_sort();\n                my @fth;\n\n                foreach my $sf ( @feats ) {\n                    push(@fth,Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq));\n                }\n                @fth = sort { &$post_sort_func($a,$b) } @fth;\n\n                foreach my $fth ( @fth ) {\n                    $self->_print_swissprot_FTHelper($fth);\n                }\n            } else {\n                # not post sorted. And so we can print as we get them.\n                # lower memory load...\n\n                foreach my $sf ( @feats ) {\n                    my @fth = Bio::SeqIO::FTHelper::from_SeqFeature($sf,$seq);\n                    foreach my $fth ( @fth ) {\n                        if ( ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n                            $sf->throw(\"Cannot process FTHelper... $fth\");\n                        }\n                        $self->_print_swissprot_FTHelper($fth);\n                    }\n                }\n            }\n\n            if ( $self->_show_dna() == 0 ) {\n                return;\n            }\n        }\n        # finished printing features.\n\n        # molecular weight\n        my $mw = ${Bio::Tools::SeqStats->get_mol_wt($seq->primary_seq)}[0];\n        # checksum\n        # was crc32 checksum, changed it to crc64\n        my $crc64 = $self->_crc64(\\$str);\n        $self->_print( sprintf(\"SQ   SEQUENCE  %4d AA;  %d MW;  %16s CRC64;\\n\",\n                               $len,$mw,$crc64));\n        $self->_print( \"    \");\n        my $linepos;\n        for ($i = 0; $i < length($str); $i += 10) {\n            $self->_print( \" \", substr($str,$i,10));\n            $linepos += 11;\n            if ( ($i+10)%60 == 0 && (($i+10) < length($str))) {\n                $self->_print( \"\\n    \");\n            }\n        }\n        $self->_print( \"\\n//\\n\");\n\n        $self->flush if $self->_flush_on_write && defined $self->_fh;\n        return 1;\n    }\n}\n\n# Thanks to James Gilbert for the following two. LP 08/01/2000\n\n=head2 _generateCRCTable\n\n Title   : _generateCRCTable\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _generateCRCTable {\n  # 10001000001010010010001110000100\n  # 32\n    my $poly = 0xEDB88320;\n    my ($self) = shift;\n\n    $self->{'_crcTable'} = [];\n    foreach my $i (0..255) {\n        my $crc = $i;\n        for (my $j=8; $j > 0; $j--) {\n            if ($crc & 1) {\n                $crc = ($crc >> 1) ^ $poly;\n            } else {\n                $crc >>= 1;\n            }\n        }\n        ${$self->{'_crcTable'}}[$i] = $crc;\n    }\n}\n\n\n=head2 _crc32\n\n Title   : _crc32\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc32 {\n    my( $self, $str ) = @_;\n\n    $self->throw(\"Argument to crc32() must be ref to scalar\")\n        unless ref($str) eq 'SCALAR';\n\n    $self->_generateCRCTable() unless exists $self->{'_crcTable'};\n\n    my $len = length($$str);\n\n    my $crc = 0xFFFFFFFF;\n    for (my $i = 0; $i < $len; $i++) {\n        # Get upper case value of each letter\n        my $int = ord uc substr $$str, $i, 1;\n        $crc = (($crc >> 8) & 0x00FFFFFF) ^\n            ${$self->{'_crcTable'}}[ ($crc ^ $int) & 0xFF ];\n    }\n    return $crc;\n}\n\n=head2 _crc64\n\n Title   : _crc64\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _crc64{\n    my ($self, $sequence) = @_;\n    my $POLY64REVh = 0xd8000000;\n    my @CRCTableh = 256;\n    my @CRCTablel = 256;\n    my $initialized;\n\n    my $seq = $$sequence;\n\n    my $crcl = 0;\n    my $crch = 0;\n    if (!$initialized) {\n        $initialized = 1;\n        for (my $i=0; $i<256; $i++) {\n            my $partl = $i;\n            my $parth = 0;\n            for (my $j=0; $j<8; $j++) {\n                my $rflag = $partl & 1;\n                $partl >>= 1;\n                $partl |= (1 << 31) if $parth & 1;\n                $parth >>= 1;\n                $parth ^= $POLY64REVh if $rflag;\n            }\n            $CRCTableh[$i] = $parth;\n            $CRCTablel[$i] = $partl;\n        }\n    }\n\n    foreach (split '', $seq) {\n        my $shr = ($crch & 0xFF) << 24;\n        my $temp1h = $crch >> 8;\n        my $temp1l = ($crcl >> 8) | $shr;\n        my $tableindex = ($crcl ^ (unpack \"C\", $_)) & 0xFF;\n        $crch = $temp1h ^ $CRCTableh[$tableindex];\n        $crcl = $temp1l ^ $CRCTablel[$tableindex];\n    }\n    my $crc64 = sprintf(\"%08X%08X\", $crch, $crcl);\n    return $crc64;\n}\n\n=head2 _print_swissprot_FTHelper\n\n Title   : _print_swissprot_FTHelper\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub _print_swissprot_FTHelper {\n    my ($self,$fth,$always_quote) = @_;\n    $always_quote ||= 0;\n    my ($start,$end) = ('?', '?');\n\n    if ( ! ref $fth || ! $fth->isa('Bio::SeqIO::FTHelper') ) {\n        $fth->warn(\"$fth is not a FTHelper class. \".\n                   \"Attempting to print, but there could be tears!\");\n    }\n    my $desc = \"\";\n\n    for my $tag ( qw(description gene note product) ) {\n        if ( exists $fth->field->{$tag} ) {\n            $desc = @{$fth->field->{$tag}}[0].\".\";\n            last;\n        }\n    }\n    $desc =~ s/\\.$//;\n\n    my $ftid = \"\";\n    if ( exists $fth->field->{'FTId'} ) {\n        $ftid = @{$fth->field->{'FTId'}}[0]. '.';\n    }\n\n    my $key =substr($fth->key,0,8);\n    my $loc = $fth->loc;\n    if ( $loc =~ /(\\?|\\d+|\\>\\d+|<\\d+)?\\.\\.(\\?|\\d+|<\\d+|>\\d+)?/ ) {\n        $start = $1 if defined $1;\n        $end = $2 if defined $2;\n\n        # to_FTString only returns one value when start == end, #JB955\n        # so if no match is found, assume it is both start and end #JB955\n    } elsif ( $loc =~ /join\\((\\d+)((?:,\\d+)+)?\\)/) {\n        my @y = ($1);\n        if ( defined( my $m = $2) ) {\n            $m =~ s/^\\,//;\n            push @y, split(/,/,$m);\n        }\n        for my $x ( @y ) {\n            $self->_write_line_swissprot_regex(\n                                               sprintf(\"FT   %-8s %6s %6s       \",\n                                                       $key,\n                                                       $x ,$x),\n                                               \"FT                                \",\n                                               $desc.'.','\\s+|$',$LINE_LENGTH);\n        }\n        return;\n    } else {\n        $start = $end = $fth->loc;\n    }\n    if ($desc) {\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s       \",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                                \",\n                                           $desc. '.', '\\s+|$', $LINE_LENGTH);\n    } else {                    #HELIX and STRAND do not have descriptions\n        $self->_write_line_swissprot_regex(sprintf(\"FT   %-8s %6s %6s\",\n                                                   $key,\n                                                   $start ,$end),\n                                           \"FT                         \",\n                                           ' ', '\\s+|$', $LINE_LENGTH);\n    }\n\n\n    if ($ftid) {\n        $self->_write_line_swissprot_regex(\"FT                                \",\n                                           \"FT                                \",\n                                           \"/FTId=$ftid\",'.|$',$LINE_LENGTH);\n\n    }\n\n}\n#'\n\n=head2 _read_swissprot_References\n\n Title   : _read_swissprot_References\n Usage   :\n Function: Reads references from swissprot format. Internal function really\n Example :\n Returns :\n Args    :\n\n\n\nsub _read_swissprot_References{\n    my ($self,$line) = @_;\n    my ($b1, $b2, $rp, $rg, $title, $loc, $au, $med, $com, $pubmed, $doi);\n    my @refs;\n    local $_ = $line;\n    while ( defined $_ ) {\n        if ( /^[^R]/ || /^RN/ ) {\n            if ( $rp ) {\n                $rg =~ s/;\\s*$//g if defined($rg);\n                if (defined($au)) {\n                    $au =~ s/;\\s*$//;\n                } else {\n                    $au = $rg;\n                }\n                $title =~ s/;\\s*$//g if defined($title);\n                push @refs, Bio::Annotation::Reference->new\n                    (-title   => $title,\n                     -start   => $b1,\n                     -end     => $b2,\n                     -authors => $au,\n                     -location=> $loc,\n                     -medline => $med,\n                     -pubmed  => $pubmed,\n                     -doi     => $doi,\n                     -comment => $com,\n                     -rp      => $rp,\n                     -rg      => $rg,\n                     -tagname => 'reference',\n                    );\n                # reset state for the next reference\n                $rp = '';\n            }\n            if (index($_,'R') != 0) {\n                $self->_pushback($_); # want this line to go back on the list\n                last;           # may be the safest exit point HL 05/11/2000\n            }\n            # don't forget to reset the state for the next reference\n            $b1 = $b2 = $rg = $med = $com = $pubmed = $doi = undef;\n            $title = $loc = $au = undef;\n        } elsif ( /^RP\\s{3}(.+? OF (\\d+)-(\\d+).*)/) {\n            $rp  .= $1;\n            $b1   = $2;\n            $b2   = $3;\n        } elsif ( /^RP\\s{3}(.*)/) {\n            if ($rp) {\n                $rp .= \" \".$1;\n            } else {\n                $rp = $1;\n            }\n        } elsif (/^RX\\s{3}(.*)/) { # each reference can have only one RX line\n            my $line = $1;\n            $med = $1 if $line =~ /MEDLINE=(\\d+);/;\n            $pubmed = $1 if $line =~ /PubMed=(\\d+);/;\n            $doi = $1 if $line =~ /DOI=(.+);/;\n        } elsif ( /^RA\\s{3}(.*)/ ) {\n            $au .= $au ? \" $1\" : $1;\n        } elsif ( /^RG\\s{3}(.*)/ ) {\n            $rg .= $rg ? \" $1\" : $1;\n        } elsif ( /^RT\\s{3}(.*)/ ) {\n            if ($title) {\n                my $tline = $1;\n                $title .= ($title =~ /[\\w;,:\\?!]$/) ? \" $tline\" : $tline;\n            } else {\n                $title = $1;\n            }\n        } elsif (/^RL\\s{3}(.*)/ ) {\n            $loc .= $loc ? \" $1\" : $1;\n        } elsif ( /^RC\\s{3}(.*)/ ) {\n            $com .= $com ? \" $1\" : $1;\n        }\n        $_ = $self->_readline;\n    }\n    return \\@refs;\n}\n\n\n=head2 _read_swissprot_Species\n\n Title   : _read_swissprot_Species\n Usage   :\n Function: Reads the swissprot Organism species and classification\n           lines.\n             Able to deal with unconventional species names.\n Example : OS Unknown prokaryotic organism\n             $genus = undef ; $species = Unknown prokaryotic organism\n Returns : A Bio::Species object\n Args    :\n\n\nsub _read_swissprot_Species {\n    my( $self,$line ) = @_;\n    my $org;\n    local $_ = $line;\n\n    my( $sub_species, $species, $genus, $common, $variant, $ncbi_taxid, $sci_name, $class_lines, $descr );\n    my $osline = \"\";\n    my $do_genus_check = 1;\n    while ( defined $_ ) {\n        last unless /^O[SCGX]/;\n        # believe it or not, but OS may come multiple times -- at this time\n        # we can't capture multiple species\n        if (/^OS\\s+(\\S.+)/ && (! defined($sci_name))) {\n            $osline .= \" \" if $osline;\n            $osline .= $1;\n            if ($osline =~ s/(,|, and|\\.)$//) {\n                # OS lines are usually like:\n                # Homo sapiens (human)\n                # where we have $sci_name followed by $descr (common name) in\n                # brackets, but we can also have:\n                # Venerupis (Ruditapes) philippinarum\n                # where we have brackets but they don't indicate a $descr\n                if ($osline =~ /[^\\(\\)]+\\(.+\\)[^\\(\\)]+$/) {\n                    #*** Danger! no idea if this will pick up some syntaxes for\n                    #    common names as well)\n                    $sci_name = $osline;\n                    $sci_name =~ s/\\.$//;\n                    $descr = '';\n                    $do_genus_check = 0;\n                } else {\n                    ($sci_name, $descr) = $osline =~ /(\\S[^\\(]+)(.*)/;\n                }\n                $sci_name =~ s/\\s+$//;\n\n                while ($descr =~ /\\(([^\\)]+)\\)/g) {\n                    my $item = $1;\n                    # strain etc may not necessarily come first (yes, swissprot\n                    # is messy)\n                    if ((! defined($variant)) &&\n                        (($item =~ /(^|[^\\(\\w])([Ss]train|isolate|serogroup|serotype|subtype|clone)\\b/) ||\n                         ($item =~ /^(biovar|pv\\.|type\\s+)/))) {\n                        $variant = $item;\n                    } elsif ($item =~ s/^subsp\\.\\s+//) {\n                        if (! $sub_species) {\n                            $sub_species = $item;\n                        } elsif (! $variant) {\n                            $variant = $item;\n                        }\n                    } elsif (! defined($common)) {\n                        # we're only interested in the first common name\n                        $common = $item;\n                        if ((index($common, '(') >= 0) &&\n                            (index($common, ')') < 0)) {\n                            $common .= ')';\n                        }\n                    }\n                }\n            }\n        } elsif (s/^OC\\s+(\\S.+)$//) {\n            $class_lines .= $1;\n        } elsif (/^OG\\s+(.*)/) {\n            $org = $1;\n        } elsif (/^OX\\s+(.*)/ && (! defined($ncbi_taxid))) {\n            my $taxstring = $1;\n            # we only keep the first one and ignore all others\n            if ($taxstring =~ /NCBI_TaxID=([\\w\\d]+)/) {\n                $ncbi_taxid = $1;\n            } else {\n                $self->throw(\"$taxstring doesn't look like NCBI_TaxID\");\n            }\n        }\n        $_ = $self->_readline;\n    }\n    $self->_pushback($_);       # pushback the last line because we need it\n\n    $sci_name || return;\n\n    # if the organism belongs to taxid 32644 then no Bio::Species object.\n    return if grep { $_ eq $sci_name } @Unknown_names;\n\n    # Convert data in classification lines into classification array.\n    # Remove trailing . then split on ';' or '.;' so that classification that is 2\n    # or more words will still get matched, use map() to remove trailing/leading/intervening\n    # spaces\n    $class_lines=~s/\\.\\s*$//;\n    my @class = map { s/^\\s+//; s/\\s+$//; s/\\s{2,}/ /g; $_; } split /[;\\.]*;/, $class_lines;\n\n    if ($class[0] =~ /viruses/i) {\n        # viruses have different OS/OC syntax\n        my @virusnames = split(/\\s+/, $sci_name);\n        $species = (@virusnames > 1) ? pop(@virusnames) : '';\n        $genus = join(\" \", @virusnames);\n        $sub_species = $descr;\n    } elsif ($do_genus_check) {\n        # do we have a genus?\n        my $possible_genus = $class[-1];\n        $possible_genus .= \"|$class[-2]\" if $class[-2];\n        if ($sci_name =~ /^($possible_genus)/) {\n            $genus = $1;\n            ($species) = $sci_name =~ /^$genus\\s+(.+)/;\n        } else {\n            $species = $sci_name;\n        }\n        # is this organism of rank species or is it lower?\n        # (doesn't catch everything, but at least the guess isn't dangerous)\n        if ($species && $species =~ /subsp\\.|var\\./) {\n            ($species, $sub_species) = $species =~ /(.+)\\s+((?:subsp\\.|var\\.).+)/;\n        }\n    }\n\n    # Bio::Species array needs array in Species -> Kingdom direction\n    unless ($class[-1] eq $sci_name) {\n        push(@class, $sci_name);\n    }\n    @class = reverse @class;\n\n    my $taxon = Bio::Species->new();\n    $taxon->scientific_name($sci_name);\n    $taxon->classification(@class);\n    $taxon->common_name($common) if $common;\n    $taxon->sub_species($sub_species) if $sub_species;\n    $taxon->organelle($org) if $org;\n    $taxon->ncbi_taxid($ncbi_taxid) if $ncbi_taxid;\n    $taxon->variant($variant) if $variant;\n\n    # done\n    return $taxon;\n}\n\n=head2 _filehandle\n\n Title   : _filehandle\n Usage   : $obj->_filehandle($newval)\n Function:\n Example :\n Returns : value of _filehandle\n Args    : newvalue (optional)\n\n\n\n# inherited from SeqIO.pm ! HL 05/11/2000\n\n=head2 _read_FTHelper_swissprot\n\n Title   : _read_FTHelper_swissprot\n Usage   : _read_FTHelper_swissprot(\\$buffer)\n Function: reads the next FT key line\n Example :\n Returns : Bio::SeqIO::FTHelper object\n Args    :\n\n\n\nsub _read_FTHelper_swissprot {\n    my ($self,$line ) = @_;\n    # initial version implemented by HL 05/10/2000\n    # FIXME this may not be perfect, so please review\n    # lots of cleaning up by JES 2004/07/01, still may not be perfect =)\n    # FTId now sepated from description as a qualifier\n\n    local $_ = $line;\n    my ($key,                   # The key of the feature\n        $loc,                   # The location line from the feature\n        $desc,                  # The descriptive text\n        $ftid,                  # feature Id is like a qualifier but there can be only one of them\n       );\n    if ( m/^FT\\s{3}(\\w+)\\s+([\\d\\?\\<]+)\\s+([\\d\\?\\>]+)\\s*(.*)$/ox) {\n        $key = $1;\n        my $loc1 = $2;\n        my $loc2 = $3;\n        $loc = \"$loc1..$loc2\";\n        if ($4 && (length($4) > 0)) {\n            $desc = $4;\n            chomp($desc);\n        } else {\n            $desc = \"\";\n        }\n    }\n\n    while ( defined($_ = $self->_readline) && /^FT\\s{20,}(\\S.*)$/ ) {\n        my $continuation_line = $1;\n        if ( $continuation_line =~ /.FTId=(.*)\\./ ) {\n            $ftid=$1;\n        }\n        elsif ( $desc) {\n            $desc .= \" $continuation_line\";\n        } else {\n            $desc = $continuation_line;\n        }\n        chomp $desc;\n    }\n    $self->_pushback($_);\n    unless( $key ) {\n        # No feature key. What's this?\n        $self->warn(\"No feature key in putative feature table line: $line\");\n        return;\n    }\n\n    # Make the new FTHelper object\n    my $out = Bio::SeqIO::FTHelper->new(-verbose => $self->verbose());\n    $out->key($key);\n    $out->loc($loc);\n\n    # store the description if there is one\n    if ( $desc && length($desc) ) {\n        $desc =~ s/\\.$//;\n        push(@{$out->field->{\"description\"}}, $desc);\n    }\n    # Store the qualifier i.e. FTId\n    if ( $ftid ) {\n        push(@{$out->field->{\"FTId\"}}, $ftid);\n    }\n    return $out;\n}\n\n\n=head2 _write_line_swissprot\n\n Title   : _write_line_swissprot\n Usage   :\n Function: internal function\n Example :\n Returns :\n Args    :\n\n\n\nsub _write_line_swissprot{\n    my ($self,$pre1,$pre2,$line,$length) = @_;\n\n    $length || $self->throw( \"Miscalled write_line_swissprot without length. Programming error!\");\n    my $subl = $length - length $pre2;\n    my $linel = length $line;\n    my $i;\n\n    my $sub = substr($line,0,$length - length $pre1);\n\n    $self->_print( \"$pre1$sub\\n\");\n\n    for ($i= ($length - length $pre1);$i < $linel;) {\n        $sub = substr($line,$i,($subl));\n        $self->_print( \"$pre2$sub\\n\");\n        $i += $subl;\n    }\n\n}\n\n=head2 _write_line_swissprot_regex\n\n Title   : _write_line_swissprot_regex\n Usage   :\n Function: internal function for writing lines of specified\n           length, with different first and the next line\n           left hand headers and split at specific points in the\n           text\n Example :\n Returns : nothing\n Args    : file handle, first header, second header, text-line, regex for line breaks, total line length","parameters":[{"label":"$self"},{"label":"$pre1"},{"label":"$pre2"},{"label":"$line"},{"label":"$regex"},{"label":"$length"}],"label":"_write_line_swissprot_regex($self,$pre1,$pre2,$line,$regex,$length)"},"detail":"($self,$pre1,$pre2,$line,$regex,$length)"},{"kind":12,"line":1418,"children":[{"name":"$obj","definition":"my","containerName":"_post_sort","localvar":"my","kind":13,"line":1419},{"localvar":"my","definition":"my","name":"$value","containerName":"_post_sort","line":1421,"kind":13},{"containerName":"_post_sort","name":"$obj","line":1422,"kind":13},{"containerName":"_post_sort","name":"$value","line":1422,"kind":13},{"name":"$obj","containerName":"_post_sort","kind":13,"line":1424}],"containerName":"main::","name":"_post_sort","definition":"sub","range":{"end":{"character":9999,"line":1426},"start":{"line":1418,"character":0}}},{"name":"_show_dna","definition":"sub","containerName":"main::","range":{"end":{"line":1447,"character":9999},"start":{"character":0,"line":1439}},"kind":12,"children":[{"kind":13,"line":1440,"containerName":"_show_dna","name":"$obj","definition":"my","localvar":"my"},{"localvar":"my","name":"$value","definition":"my","containerName":"_show_dna","line":1442,"kind":13},{"containerName":"_show_dna","name":"$obj","kind":13,"line":1443},{"kind":13,"line":1443,"name":"$value","containerName":"_show_dna"},{"containerName":"_show_dna","name":"$obj","line":1445,"kind":13}],"line":1439},{"line":1460,"children":[{"line":1461,"kind":13,"localvar":"my","containerName":"_id_generation_func","definition":"my","name":"$obj"},{"kind":13,"line":1463,"containerName":"_id_generation_func","name":"$value","definition":"my","localvar":"my"},{"name":"$obj","containerName":"_id_generation_func","kind":13,"line":1464},{"line":1464,"kind":13,"containerName":"_id_generation_func","name":"$value"},{"kind":13,"line":1466,"name":"$obj","containerName":"_id_generation_func"}],"kind":12,"range":{"start":{"character":0,"line":1460},"end":{"line":1468,"character":9999}},"containerName":"main::","name":"_id_generation_func","definition":"sub"},{"kind":12,"children":[{"localvar":"my","containerName":"_ac_generation_func","name":"$obj","definition":"my","line":1482,"kind":13},{"containerName":"_ac_generation_func","name":"$value","definition":"my","localvar":"my","kind":13,"line":1484},{"containerName":"_ac_generation_func","name":"$obj","kind":13,"line":1485},{"kind":13,"line":1485,"name":"$value","containerName":"_ac_generation_func"},{"name":"$obj","containerName":"_ac_generation_func","kind":13,"line":1487}],"line":1481,"definition":"sub","name":"_ac_generation_func","containerName":"main::","range":{"end":{"character":9999,"line":1489},"start":{"character":0,"line":1481}}},{"line":1502,"children":[{"kind":13,"line":1503,"containerName":"_sv_generation_func","definition":"my","name":"$obj","localvar":"my"},{"localvar":"my","name":"$value","definition":"my","containerName":"_sv_generation_func","line":1505,"kind":13},{"name":"$obj","containerName":"_sv_generation_func","line":1506,"kind":13},{"name":"$value","containerName":"_sv_generation_func","kind":13,"line":1506},{"line":1508,"kind":13,"containerName":"_sv_generation_func","name":"$obj"}],"kind":12,"range":{"start":{"line":1502,"character":0},"end":{"line":1510,"character":9999}},"containerName":"main::","name":"_sv_generation_func","definition":"sub"},{"range":{"start":{"character":0,"line":1523},"end":{"character":9999,"line":1531}},"name":"_kw_generation_func","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_kw_generation_func","name":"$obj","definition":"my","line":1524,"kind":13},{"localvar":"my","containerName":"_kw_generation_func","definition":"my","name":"$value","line":1526,"kind":13},{"kind":13,"line":1527,"containerName":"_kw_generation_func","name":"$obj"},{"name":"$value","containerName":"_kw_generation_func","kind":13,"line":1527},{"containerName":"_kw_generation_func","name":"$obj","kind":13,"line":1529}],"line":1523,"kind":12}]}