{"vars":[{"name":"base","containerName":"","kind":2,"line":95},{"range":{"start":{"character":0,"line":97},"end":{"line":109,"character":9999}},"name":"_initialize","line":97,"children":[{"localvar":"my","containerName":"_initialize","name":"$self","definition":"my","line":98,"kind":13},{"line":98,"kind":13,"containerName":"_initialize","name":"@args"},{"name":"$self","containerName":"_initialize","kind":13,"line":99},{"containerName":"_initialize","name":"@args","kind":13,"line":99},{"kind":13,"line":100,"definition":"my","name":"$variant","containerName":"_initialize","localvar":"my"},{"name":"$self","containerName":"_initialize","line":100,"kind":13},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":100},{"name":"@args","containerName":"_initialize","line":100,"kind":13},{"kind":13,"line":101,"containerName":"_initialize","name":"$variant"},{"line":102,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"variant","containerName":"_initialize","kind":12,"line":102},{"name":"$variant","containerName":"_initialize","kind":13,"line":102},{"kind":13,"line":103,"name":"$self","containerName":"_initialize"},{"line":103,"kind":12,"containerName":"_initialize","name":"sequence_factory"},{"kind":13,"line":104,"name":"$self","containerName":"_initialize"},{"line":104,"kind":12,"name":"sequence_factory","containerName":"_initialize"},{"containerName":"_initialize","name":"new","line":105,"kind":12},{"containerName":"_initialize","name":"$self","line":105,"kind":13},{"kind":12,"line":105,"name":"verbose","containerName":"_initialize"},{"line":108,"kind":13,"name":"$self","containerName":"_initialize"},{"line":108,"kind":12,"containerName":"_initialize","name":"variant"}],"kind":12,"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"_initialize","line":99,"kind":12},{"containerName":"Seq::SeqFactory","name":"Bio","line":104,"kind":12},{"kind":12,"children":[{"line":123,"kind":13,"localvar":"my","containerName":"next_seq","name":"$self","definition":"my"},{"kind":13,"line":123,"name":"@args","containerName":"next_seq"},{"kind":13,"line":128,"name":"$self","containerName":"next_seq"},{"line":129,"kind":13,"localvar":"my","containerName":"next_seq","definition":"my","name":"$nextline"},{"name":"$self","containerName":"next_seq","kind":13,"line":129},{"containerName":"next_seq","name":"_readline","line":129,"kind":12},{"containerName":"next_seq","name":"$nextline","line":130,"kind":13},{"localvar":"my","containerName":"next_seq","name":"$sequence","definition":"my","line":132,"kind":13},{"kind":13,"line":132,"name":"$nextline","containerName":"next_seq"},{"name":"$sequence","containerName":"next_seq","kind":13,"line":133},{"line":134,"kind":13,"containerName":"next_seq","name":"$sequence"},{"line":135,"kind":13,"containerName":"next_seq","name":"$self"},{"line":135,"kind":12,"containerName":"next_seq","name":"sequence_factory"},{"kind":12,"line":135,"containerName":"next_seq","name":"create"},{"name":"$sequence","containerName":"next_seq","line":135,"kind":13},{"kind":13,"line":135,"containerName":"next_seq","name":"$sequence"}],"line":122,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::raw\n# AUTHOR  : Ewan Birney <birney@ebi.ac.uk>\n# CREATED : Feb 16 1999\n# REVISION: $Id: raw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Ewan Birney. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::Fasta module with\n# the necessary minor tweaks necessary to get it to read\n# and write raw formatted sequences made by\n# chris dagdigian <dag@sonsorol.org>\n#\n# October 18, 1999  Largely rewritten by Lincoln Stein\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::raw - raw sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from raw flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\n  Ewan Birney   E<lt>birney@ebi.ac.ukE<gt>\n  Lincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\n  Jason Stajich E<lt>jason@bioperl.org<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::raw;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($variant) = $self->_rearrange([qw(VARIANT)], @args);\n    $variant ||= 'multiple';\n    $self->variant($variant);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                    (-verbose => $self->verbose(),\n                     -type => 'Bio::Seq'));\n    }\n    $self->variant;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_seq($self,@args)"},"detail":"($self,@args)","name":"next_seq","range":{"start":{"character":0,"line":122},"end":{"character":9999,"line":136}}},{"name":"record_separator","line":128,"kind":12},{"children":[{"line":150,"kind":13,"localvar":"my","containerName":"write_seq","name":"$self","definition":"my"},{"containerName":"write_seq","name":"@seq","line":150,"kind":13},{"containerName":"write_seq","definition":"my","name":"$seq","localvar":"my","kind":13,"line":151},{"containerName":"write_seq","name":"@seq","line":151,"kind":13},{"kind":13,"line":152,"containerName":"write_seq","name":"$self"},{"line":152,"kind":12,"containerName":"write_seq","name":"throw"},{"kind":13,"line":153,"name":"$seq","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":153},{"line":153,"kind":13,"containerName":"write_seq","name":"$seq"},{"line":153,"kind":12,"containerName":"write_seq","name":"isa"},{"line":154,"kind":13,"name":"$self","containerName":"write_seq"},{"line":154,"kind":12,"name":"_print","containerName":"write_seq"},{"name":"$seq","containerName":"write_seq","kind":13,"line":154},{"name":"seq","containerName":"write_seq","kind":12,"line":154},{"containerName":"write_seq","name":"$self","line":156,"kind":13},{"kind":12,"line":156,"name":"flush","containerName":"write_seq"},{"kind":13,"line":156,"name":"$self","containerName":"write_seq"},{"line":156,"kind":12,"name":"_flush_on_write","containerName":"write_seq"},{"name":"$self","containerName":"write_seq","kind":13,"line":156},{"containerName":"write_seq","name":"_fh","line":156,"kind":12}],"line":149,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::raw\n# AUTHOR  : Ewan Birney <birney@ebi.ac.uk>\n# CREATED : Feb 16 1999\n# REVISION: $Id: raw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Ewan Birney. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::Fasta module with\n# the necessary minor tweaks necessary to get it to read\n# and write raw formatted sequences made by\n# chris dagdigian <dag@sonsorol.org>\n#\n# October 18, 1999  Largely rewritten by Lincoln Stein\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::raw - raw sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from raw flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\n  Ewan Birney   E<lt>birney@ebi.ac.ukE<gt>\n  Lincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\n  Jason Stajich E<lt>jason@bioperl.org<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::raw;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($variant) = $self->_rearrange([qw(VARIANT)], @args);\n    $variant ||= 'multiple';\n    $self->variant($variant);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                    (-verbose => $self->verbose(),\n                     -type => 'Bio::Seq'));\n    }\n    $self->variant;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\n\nsub next_seq{\n    my ($self,@args) = @_;\n    ## When its 1 sequence per line with no formatting at all,\n    ## grabbing it should be easy :)\n \n    ## adding an option to assume the file is one sequence\n    local $/ = $self->{record_separator};\n    my $nextline = $self->_readline();\n    return unless defined $nextline;\n \n    my $sequence = uc($nextline);\n    $sequence =~ s/\\W//g;\n    return unless $sequence;\n    return $self->sequence_factory->create(-seq => $sequence) if $sequence;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects","label":"write_seq($self,@seq)"},"detail":"($self,@seq)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":158},"start":{"character":0,"line":149}},"name":"write_seq"},{"detail":"($self,@seq)","signature":{"parameters":[{"label":"$self"},{"label":"@seq"}],"documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::raw\n# AUTHOR  : Ewan Birney <birney@ebi.ac.uk>\n# CREATED : Feb 16 1999\n# REVISION: $Id: raw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Ewan Birney. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::Fasta module with\n# the necessary minor tweaks necessary to get it to read\n# and write raw formatted sequences made by\n# chris dagdigian <dag@sonsorol.org>\n#\n# October 18, 1999  Largely rewritten by Lincoln Stein\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::raw - raw sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from raw flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\n  Ewan Birney   E<lt>birney@ebi.ac.ukE<gt>\n  Lincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\n  Jason Stajich E<lt>jason@bioperl.org<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::raw;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($variant) = $self->_rearrange([qw(VARIANT)], @args);\n    $variant ||= 'multiple';\n    $self->variant($variant);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                    (-verbose => $self->verbose(),\n                     -type => 'Bio::Seq'));\n    }\n    $self->variant;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\n\nsub next_seq{\n    my ($self,@args) = @_;\n    ## When its 1 sequence per line with no formatting at all,\n    ## grabbing it should be easy :)\n \n    ## adding an option to assume the file is one sequence\n    local $/ = $self->{record_separator};\n    my $nextline = $self->_readline();\n    return unless defined $nextline;\n \n    my $sequence = uc($nextline);\n    $sequence =~ s/\\W//g;\n    return unless $sequence;\n    return $self->sequence_factory->create(-seq => $sequence) if $sequence;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    foreach my $seq (@seq) {\n        $self->throw(\"Must provide a valid Bio::PrimarySeqI object\")\n            unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n        $self->_print($seq->seq, \"\\n\") or return;\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 write_qual\n\n Title   : write_qual\n Usage   : $stream->write_qual($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq::Quality object","label":"write_qual($self,@seq)"},"containerName":"main::","definition":"sub","line":171,"children":[{"name":"$self","definition":"my","containerName":"write_qual","localvar":"my","kind":13,"line":172},{"containerName":"write_qual","name":"@seq","kind":13,"line":172},{"line":173,"kind":13,"localvar":"my","name":"@qual","definition":"my","containerName":"write_qual"},{"kind":13,"line":174,"containerName":"write_qual","name":"@seq"},{"containerName":"write_qual","name":"isa","line":175,"kind":12},{"kind":13,"line":179,"containerName":"write_qual","name":"@qual"},{"name":"qual","containerName":"write_qual","line":179,"kind":12},{"name":"@qual","containerName":"write_qual","kind":13,"line":180},{"kind":13,"line":181,"name":"$qual","containerName":"write_qual"},{"line":183,"kind":13,"name":"$self","containerName":"write_qual"},{"kind":12,"line":183,"name":"_print","containerName":"write_qual"},{"name":"@qual","containerName":"write_qual","kind":13,"line":183}],"kind":12,"range":{"start":{"line":171,"character":0},"end":{"character":9999,"line":184}},"name":"write_qual"},{"kind":12,"children":[{"line":206,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"variant"},{"name":"$var","containerName":"variant","line":206,"kind":13},{"containerName":"variant","name":"$var","line":207,"kind":13},{"line":207,"kind":13,"containerName":"variant","name":"$self"},{"line":208,"kind":13,"containerName":"variant","name":"$var"},{"containerName":"variant","name":"$var","line":209,"kind":13},{"line":209,"kind":13,"containerName":"variant","name":"$var"},{"containerName":"variant","name":"$self","kind":13,"line":210},{"containerName":"variant","name":"throw","kind":12,"line":210},{"name":"$var","containerName":"variant","line":211,"kind":13},{"containerName":"variant","name":"$var","line":211,"kind":13},{"name":"$self","containerName":"variant","line":212,"kind":13},{"line":212,"kind":13,"name":"$var","containerName":"variant"},{"kind":13,"line":213,"name":"$self","containerName":"variant"},{"kind":13,"line":213,"name":"$var","containerName":"variant"},{"kind":13,"line":215,"name":"$self","containerName":"variant"}],"line":205,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$var"}],"documentation":"1;\n#-----------------------------------------------------------------------------\n# PACKAGE : Bio::SeqIO::raw\n# AUTHOR  : Ewan Birney <birney@ebi.ac.uk>\n# CREATED : Feb 16 1999\n# REVISION: $Id: raw.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Copyright (c) 1997-9 bioperl, Ewan Birney. All Rights Reserved.\n#           This module is free software; you can redistribute it and/or\n#           modify it under the same terms as Perl itself.\n#\n# _History_\n#\n# Ewan Birney <birney@ebi.ac.uk> developed the SeqIO\n# schema and the first prototype modules.\n#\n# This code is based on his Bio::SeqIO::Fasta module with\n# the necessary minor tweaks necessary to get it to read\n# and write raw formatted sequences made by\n# chris dagdigian <dag@sonsorol.org>\n#\n# October 18, 1999  Largely rewritten by Lincoln Stein\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqIO::raw - raw sequence file input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::SeqIO> class.\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to and from raw flat\nfile databases.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS\n\n  Ewan Birney   E<lt>birney@ebi.ac.ukE<gt>\n  Lincoln Stein E<lt>lstein@cshl.orgE<gt>\n\n=head1 CONTRIBUTORS\n\n  Jason Stajich E<lt>jason@bioperl.org<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqIO::raw;\nuse strict;\n\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::SeqIO);\n\nsub _initialize {\n    my($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($variant) = $self->_rearrange([qw(VARIANT)], @args);\n    $variant ||= 'multiple';\n    $self->variant($variant);\n    if( ! defined $self->sequence_factory ) {\n        $self->sequence_factory(Bio::Seq::SeqFactory->new\n                    (-verbose => $self->verbose(),\n                     -type => 'Bio::Seq'));\n    }\n    $self->variant;\n}\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : $seq = $stream->next_seq()\n Function: returns the next sequence in the stream\n Returns : Bio::Seq object\n Args    :\n\n\n\nsub next_seq{\n    my ($self,@args) = @_;\n    ## When its 1 sequence per line with no formatting at all,\n    ## grabbing it should be easy :)\n \n    ## adding an option to assume the file is one sequence\n    local $/ = $self->{record_separator};\n    my $nextline = $self->_readline();\n    return unless defined $nextline;\n \n    my $sequence = uc($nextline);\n    $sequence =~ s/\\W//g;\n    return unless $sequence;\n    return $self->sequence_factory->create(-seq => $sequence) if $sequence;\n}\n\n=head2 write_seq\n\n Title   : write_seq\n Usage   : $stream->write_seq($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Array of Bio::PrimarySeqI objects\n\n\n\nsub write_seq {\n    my ($self,@seq) = @_;\n    foreach my $seq (@seq) {\n        $self->throw(\"Must provide a valid Bio::PrimarySeqI object\")\n            unless defined $seq && ref($seq) && $seq->isa('Bio::PrimarySeqI');\n        $self->_print($seq->seq, \"\\n\") or return;\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 write_qual\n\n Title   : write_qual\n Usage   : $stream->write_qual($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq::Quality object\n\n\n\nsub write_qual {\n    my ($self,@seq) = @_;\n    my @qual = ();\n    foreach (@seq) {\n        unless ($_->isa(\"Bio::Seq::Quality\")){\n           warn(\"You cannot write raw qualities without supplying a Bio::Seq::Quality object! You passed a \", ref($_), \"\\n\");\n           next;\n        }\n        @qual = @{$_->qual};\n        if(scalar(@qual) == 0) {\n           $qual[0] = \"\\n\";\n        }\n        $self->_print (join \" \", @qual,\"\\n\") or return;\n    }\n    return 1;\n}\n\n=head2 variant\n\n Title   : variant\n Usage   : $format  = $obj->variant();\n Function: Get and set method for the sequence variant.  For raw sequence, this\n           indicates whether to treat the input as multiple sequences (the\n           default) or as a single sequence.\n\n           Current values accepted are:\n\n            'single'    single sequence\n            'multiple'  multiple sequences (default)\n Returns : string\n Args    : new value, string","label":"variant($self,$var)"},"detail":"($self,$var)","name":"variant","range":{"start":{"character":0,"line":205},"end":{"character":9999,"line":216}}},{"name":"variant","line":207,"kind":12},{"kind":12,"line":212,"name":"record_separator"},{"name":"variant","kind":12,"line":213},{"line":215,"kind":12,"name":"variant"},{"range":{"end":{"character":9999,"line":222},"start":{"character":0,"line":220}},"containerName":"main::","definition":"sub","name":"_separator","line":220,"children":[],"kind":12},{"kind":12,"line":221,"name":"record_separator"}],"version":5}