{"vars":[{"kind":2,"line":632,"name":"base","containerName":""},{"name":"new","range":{"start":{"line":656,"character":0},"end":{"line":671,"character":9999}},"kind":12,"line":656,"children":[{"line":657,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","name":"@args","line":657,"kind":13},{"line":658,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"containerName":"new","name":"$class","line":658,"kind":13},{"kind":13,"line":658,"containerName":"new","name":"@args"},{"localvar":"my","name":"$seq","definition":"my","containerName":"new","line":660,"kind":13},{"line":660,"kind":13,"containerName":"new","name":"$group_tag"},{"name":"$trust_grouptag","containerName":"new","kind":13,"line":660},{"name":"$self","containerName":"new","kind":13,"line":661},{"name":"_rearrange","containerName":"new","line":661,"kind":12},{"line":665,"kind":13,"containerName":"new","name":"@args"},{"name":"$seq","containerName":"new","kind":13,"line":667},{"name":"$self","containerName":"new","line":667,"kind":13},{"name":"seq","containerName":"new","kind":12,"line":667},{"line":667,"kind":13,"name":"$seq","containerName":"new"},{"name":"$group_tag","containerName":"new","kind":13,"line":668},{"containerName":"new","name":"$self","line":668,"kind":13},{"kind":12,"line":668,"containerName":"new","name":"group_tag"},{"line":668,"kind":13,"containerName":"new","name":"$group_tag"},{"containerName":"new","name":"$self","line":670,"kind":13}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"containerName":"new","name":"SUPER","kind":12,"line":658},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"end":{"line":686,"character":9999},"start":{"line":673,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"line":674},{"line":675,"kind":13,"name":"$self","containerName":"DESTROY"},{"name":"$self","containerName":"DESTROY","line":676,"kind":13},{"localvar":"my","definition":"my","name":"@probs","containerName":"DESTROY","line":677,"kind":13},{"kind":13,"line":677,"containerName":"DESTROY","name":"$self"},{"containerName":"DESTROY","name":"get_problems","line":677,"kind":12},{"line":678,"kind":13,"name":"$self","containerName":"DESTROY"},{"kind":13,"line":679,"containerName":"DESTROY","name":"@probs"},{"containerName":"DESTROY","name":"$self","kind":13,"line":680},{"line":680,"kind":12,"containerName":"DESTROY","name":"warn"}],"line":673},{"name":"_reported_problems","line":675,"kind":12},{"line":676,"kind":12,"name":"_ignore_problems"},{"name":"_problems_reported","kind":12,"line":678},{"kind":12,"children":[{"line":705,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"seq"},{"line":707,"kind":13,"name":"$self","containerName":"seq"},{"kind":13,"line":708,"containerName":"seq","name":"$self"}],"line":704,"name":"seq","definition":"sub","containerName":"main::","range":{"end":{"line":709,"character":9999},"start":{"character":0,"line":704}}},{"range":{"end":{"line":749,"character":9999},"start":{"character":0,"line":744}},"containerName":"main::","name":"group_tag","definition":"sub","line":744,"children":[{"kind":13,"line":745,"name":"$self","definition":"my","containerName":"group_tag","localvar":"my"},{"name":"$self","containerName":"group_tag","kind":13,"line":747},{"line":748,"kind":13,"containerName":"group_tag","name":"$self"}],"kind":12},{"line":766,"children":[{"name":"$self","definition":"my","containerName":"partonomy","localvar":"my","kind":13,"line":767},{"kind":13,"line":769,"containerName":"partonomy","name":"$self"},{"name":"$self","containerName":"partonomy","line":770,"kind":13},{"line":771,"kind":13,"containerName":"partonomy","name":"$self"},{"containerName":"partonomy","name":"$self","kind":13,"line":771},{"line":771,"kind":12,"name":"_default_partonomy","containerName":"partonomy"},{"line":773,"kind":13,"containerName":"partonomy","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":774},"start":{"character":0,"line":766}},"containerName":"main::","definition":"sub","name":"partonomy"},{"children":[],"line":776,"kind":12,"range":{"start":{"character":0,"line":776},"end":{"character":9999,"line":793}},"definition":"sub","name":"_default_partonomy","containerName":"main::"},{"name":"mRNA","kind":12,"line":778},{"kind":12,"line":779,"name":"tRNA"},{"name":"rRNA","line":780,"kind":12},{"kind":12,"line":781,"name":"scRNA"},{"kind":12,"line":782,"name":"snRNA"},{"kind":12,"line":783,"name":"snoRNA"},{"kind":12,"line":784,"name":"misc_RNA"},{"kind":12,"line":785,"name":"CDS"},{"kind":12,"line":786,"name":"exon"},{"kind":12,"line":787,"name":"intron"},{"line":789,"kind":12,"name":"pseudoexon"},{"line":790,"kind":12,"name":"pseudointron"},{"kind":12,"line":791,"name":"pseudotranscript"},{"containerName":"main::","name":"structure_type","definition":"sub","range":{"end":{"character":9999,"line":870},"start":{"line":865,"character":0}},"kind":12,"line":865,"children":[{"containerName":"structure_type","definition":"my","name":"$self","localvar":"my","kind":13,"line":866},{"containerName":"structure_type","name":"$self","line":868,"kind":13},{"line":869,"kind":13,"name":"$self","containerName":"structure_type"}]},{"range":{"start":{"line":893,"character":0},"end":{"line":896,"character":9999}},"name":"get_problems","definition":"sub","containerName":"main::","children":[{"containerName":"get_problems","name":"$self","definition":"my","localvar":"my","kind":13,"line":894},{"kind":13,"line":896,"name":"$self","containerName":"get_problems"}],"line":893,"kind":12},{"line":896,"kind":13,"containerName":null,"name":"%self"},{"line":912,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"clear_problems","line":913,"kind":13},{"containerName":"clear_problems","name":"@args","line":913,"kind":13},{"kind":13,"line":914,"containerName":"clear_problems","name":"$self"}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :","label":"clear_problems($self,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":912},"end":{"line":916,"character":9999}},"name":"clear_problems"},{"kind":12,"line":921,"children":[{"containerName":"add_problem","name":"$self","definition":"my","localvar":"my","kind":13,"line":922},{"containerName":"add_problem","name":"$self","line":924,"kind":13},{"name":"$self","containerName":"add_problem","kind":13,"line":924},{"kind":13,"line":925,"name":"$self","containerName":"add_problem"},{"line":925,"kind":12,"name":"verbose","containerName":"add_problem"},{"kind":13,"line":928,"name":"$self","containerName":"add_problem"}],"containerName":"main::","definition":"sub","name":"add_problem","range":{"end":{"character":9999,"line":928},"start":{"line":921,"character":0}}},{"kind":12,"line":933,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"problem","line":934,"kind":13},{"containerName":"problem","name":"$severity","definition":"my","localvar":"my","kind":13,"line":935},{"kind":13,"line":935,"name":"$desc","containerName":"problem"},{"line":935,"kind":13,"name":"@sfs","containerName":"problem"},{"containerName":"problem","name":"@sfs","kind":13,"line":936},{"localvar":"my","name":"$sf","definition":"my","containerName":"problem","line":937,"kind":13},{"containerName":"problem","name":"@sfs","line":937,"kind":13},{"containerName":"problem","name":"$desc","line":938,"kind":13},{"line":941,"kind":13,"name":"$sf","containerName":"problem"},{"kind":12,"line":941,"name":"primary_tag","containerName":"problem"},{"line":943,"kind":13,"containerName":"problem","name":"$sf"},{"containerName":"problem","name":"has_tag","kind":12,"line":943},{"containerName":"problem","name":"$sf","line":944,"kind":13},{"kind":12,"line":944,"containerName":"problem","name":"get_tag_values"},{"localvar":"my","name":"$thresh","definition":"my","containerName":"problem","line":948,"kind":13},{"line":948,"kind":13,"name":"$self","containerName":"problem"},{"containerName":"problem","name":"error_threshold","kind":12,"line":948},{"line":949,"kind":13,"name":"$severity","containerName":"problem"},{"containerName":"problem","name":"$thresh","kind":13,"line":949},{"kind":13,"line":950,"containerName":"problem","name":"$self"},{"containerName":"problem","name":"$self","kind":13,"line":951},{"containerName":"problem","name":"throw","kind":12,"line":951},{"containerName":"problem","name":"$self","line":953,"kind":13},{"name":"add_problem","containerName":"problem","line":953,"kind":12},{"containerName":"problem","name":"$severity","kind":13,"line":953},{"name":"$desc","containerName":"problem","line":953,"kind":13}],"containerName":"main::","definition":"sub","detail":"($severity,$desc,@sfs)","signature":{"label":"problem($severity,$desc,@sfs)","documentation":" PRIVATE\n see get_problems","parameters":[{"label":"$severity"},{"label":"$desc"},{"label":"@sfs"}]},"name":"problem","range":{"start":{"line":933,"character":0},"end":{"line":955,"character":9999}}},{"name":"_problems_reported","kind":12,"line":950},{"definition":"sub","containerName":"main::","signature":{"label":"report_problems($self,$fh)","parameters":[{"label":"$self"},{"label":"$fh"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)"},"detail":"($self,$fh)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"report_problems","localvar":"my","kind":13,"line":970},{"kind":13,"line":970,"name":"$fh","containerName":"report_problems"},{"name":"$fh","containerName":"report_problems","line":972,"kind":13},{"name":"$fh","containerName":"report_problems","line":973,"kind":13},{"kind":13,"line":975,"containerName":"report_problems","definition":"my","name":"$problem","localvar":"my"},{"kind":13,"line":975,"containerName":"report_problems","name":"$self"},{"line":975,"kind":12,"name":"get_problems","containerName":"report_problems"},{"localvar":"my","containerName":"report_problems","name":"$sev","definition":"my","line":976,"kind":13},{"line":976,"kind":13,"containerName":"report_problems","name":"$desc"},{"containerName":"report_problems","name":"$fh","kind":13,"line":977},{"containerName":"report_problems","name":"$self","line":979,"kind":13}],"line":969,"name":"report_problems","range":{"end":{"character":9999,"line":981},"start":{"character":0,"line":969}}},{"line":979,"kind":12,"name":"_problems_reported"},{"kind":12,"line":1003,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"ignore_problems","line":1004,"kind":13},{"kind":13,"line":1005,"name":"$self","containerName":"ignore_problems"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"ignore_problems($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed."},"name":"ignore_problems","range":{"end":{"line":1007,"character":9999},"start":{"character":0,"line":1003}}},{"kind":12,"line":1005,"name":"_ignore_problems"},{"containerName":"main::","definition":"sub","name":"error_threshold","range":{"end":{"line":1035,"character":9999},"start":{"character":0,"line":1030}},"kind":12,"line":1030,"children":[{"line":1031,"kind":13,"localvar":"my","containerName":"error_threshold","name":"$self","definition":"my"},{"kind":13,"line":1033,"containerName":"error_threshold","name":"$self"},{"line":1034,"kind":13,"name":"$self","containerName":"error_threshold"}]},{"definition":"sub","containerName":"main::","signature":{"documentation":" PRIVATE\n\n given a type (eg mRNA), will return the container type (eg gene)","parameters":[{"label":"$self"},{"label":"$type"}],"label":"get_container_type($self,$type)"},"detail":"($self,$type)","kind":12,"children":[{"line":1043,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_container_type"},{"name":"$type","containerName":"get_container_type","kind":13,"line":1043},{"containerName":"get_container_type","name":"@roots","definition":"my","localvar":"my","kind":13,"line":1044},{"kind":13,"line":1044,"containerName":"get_container_type","name":"$self"},{"line":1044,"kind":12,"containerName":"get_container_type","name":"_get_partonomy_roots"},{"line":1045,"kind":13,"name":"$type","containerName":"get_container_type"},{"line":1045,"kind":13,"containerName":"get_container_type","name":"@roots"},{"kind":13,"line":1049,"definition":"my","name":"$ch","containerName":"get_container_type","localvar":"my"},{"kind":13,"line":1049,"containerName":"get_container_type","name":"$self"},{"name":"partonomy","containerName":"get_container_type","line":1049,"kind":12},{"line":1050,"kind":13,"localvar":"my","containerName":"get_container_type","name":"$ctype","definition":"my"},{"containerName":"get_container_type","name":"$ch","kind":13,"line":1050},{"line":1050,"kind":13,"containerName":"get_container_type","name":"$type"},{"name":"$ctype","containerName":"get_container_type","line":1051,"kind":13},{"name":"$ctype","containerName":"get_container_type","line":1053,"kind":13},{"line":1053,"kind":13,"name":"$ch","containerName":"get_container_type"},{"containerName":"get_container_type","name":"$ctype","kind":13,"line":1055}],"line":1042,"name":"get_container_type","range":{"start":{"character":0,"line":1042},"end":{"line":1056,"character":9999}}},{"kind":12,"line":1059,"children":[{"localvar":"my","containerName":"_get_partonomy_roots","name":"$self","definition":"my","line":1060,"kind":13},{"definition":"my","name":"$ch","containerName":"_get_partonomy_roots","localvar":"my","kind":13,"line":1061},{"line":1061,"kind":13,"name":"$self","containerName":"_get_partonomy_roots"},{"containerName":"_get_partonomy_roots","name":"partonomy","kind":12,"line":1061},{"localvar":"my","name":"@parents","definition":"my","containerName":"_get_partonomy_roots","line":1062,"kind":13},{"name":"$ch","containerName":"_get_partonomy_roots","line":1062,"kind":13},{"kind":13,"line":1064,"name":"$ch","containerName":"_get_partonomy_roots"},{"kind":13,"line":1064,"containerName":"_get_partonomy_roots","name":"@parents"}],"containerName":"main::","name":"_get_partonomy_roots","definition":"sub","range":{"end":{"line":1065,"character":9999},"start":{"line":1059,"character":0}}},{"range":{"start":{"line":1107,"character":0},"end":{"line":1635,"character":9999}},"name":"unflatten_seq","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'","parameters":[{"label":"$self"},{"label":"@args"}],"label":"unflatten_seq($self,@args)"},"containerName":"main::","definition":"sub","line":1107,"children":[{"localvar":"my","containerName":"unflatten_seq","name":"$self","definition":"my","line":1108,"kind":13},{"kind":13,"line":1108,"name":"@args","containerName":"unflatten_seq"},{"kind":13,"line":1110,"definition":"my","name":"$seq","containerName":"unflatten_seq","localvar":"my"},{"name":"$resolver_method","containerName":"unflatten_seq","line":1110,"kind":13},{"line":1110,"kind":13,"containerName":"unflatten_seq","name":"$group_tag"},{"kind":13,"line":1110,"name":"$partonomy","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$structure_type","kind":13,"line":1111},{"name":"$resolver_tag","containerName":"unflatten_seq","line":1111,"kind":13},{"containerName":"unflatten_seq","name":"$use_magic","line":1111,"kind":13},{"containerName":"unflatten_seq","name":"$self","line":1112,"kind":13},{"kind":12,"line":1112,"name":"_rearrange","containerName":"unflatten_seq"},{"kind":13,"line":1120,"name":"@args","containerName":"unflatten_seq"},{"name":"$seq","containerName":"unflatten_seq","kind":13,"line":1123},{"line":1123,"kind":13,"containerName":"unflatten_seq","name":"$seq"},{"containerName":"unflatten_seq","name":"$self","line":1123,"kind":13},{"name":"seq","containerName":"unflatten_seq","kind":12,"line":1123},{"name":"$partonomy","containerName":"unflatten_seq","kind":13,"line":1127},{"line":1128,"kind":13,"containerName":"unflatten_seq","name":"$structure_type"},{"name":"$self","containerName":"unflatten_seq","kind":13,"line":1129},{"line":1129,"kind":12,"containerName":"unflatten_seq","name":"throw"},{"line":1134,"kind":13,"localvar":"my","containerName":"unflatten_seq","name":"$old_partonomy","definition":"my"},{"line":1134,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"line":1134,"kind":12,"name":"partonomy","containerName":"unflatten_seq"},{"name":"$self","containerName":"unflatten_seq","line":1135,"kind":13},{"containerName":"unflatten_seq","name":"partonomy","line":1135,"kind":12},{"containerName":"unflatten_seq","name":"$partonomy","line":1135,"kind":13},{"kind":13,"line":1135,"containerName":"unflatten_seq","name":"$partonomy"},{"line":1138,"kind":13,"localvar":"my","name":"$old_structure_type","definition":"my","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$self","line":1138,"kind":13},{"line":1138,"kind":12,"name":"structure_type","containerName":"unflatten_seq"},{"name":"$self","containerName":"unflatten_seq","kind":13,"line":1139},{"name":"structure_type","containerName":"unflatten_seq","kind":12,"line":1139},{"kind":13,"line":1139,"name":"$structure_type","containerName":"unflatten_seq"},{"line":1139,"kind":13,"name":"$structure_type","containerName":"unflatten_seq"},{"localvar":"my","containerName":"unflatten_seq","name":"@flat_seq_features","definition":"my","line":1143,"kind":13},{"containerName":"unflatten_seq","name":"$seq","kind":13,"line":1143},{"line":1143,"kind":12,"containerName":"unflatten_seq","name":"get_SeqFeatures"},{"localvar":"my","containerName":"unflatten_seq","name":"@all_seq_features","definition":"my","line":1144,"kind":13},{"containerName":"unflatten_seq","name":"$seq","line":1144,"kind":13},{"containerName":"unflatten_seq","name":"get_all_SeqFeatures","line":1144,"kind":12},{"containerName":"unflatten_seq","name":"@all_seq_features","kind":13,"line":1147},{"kind":13,"line":1147,"containerName":"unflatten_seq","name":"@flat_seq_features"},{"name":"$self","containerName":"unflatten_seq","line":1148,"kind":13},{"line":1148,"kind":12,"name":"throw","containerName":"unflatten_seq"},{"name":"@all_seq_features","containerName":"unflatten_seq","line":1150,"kind":13},{"kind":13,"line":1150,"containerName":"unflatten_seq","name":"@flat_seq_features"},{"containerName":"unflatten_seq","name":"$self","kind":13,"line":1151},{"containerName":"unflatten_seq","name":"throw","line":1151,"kind":12},{"containerName":"unflatten_seq","name":"$group_tag","line":1156,"kind":13},{"line":1156,"kind":13,"containerName":"unflatten_seq","name":"$group_tag"},{"name":"$self","containerName":"unflatten_seq","kind":13,"line":1156},{"line":1156,"kind":12,"containerName":"unflatten_seq","name":"group_tag"},{"name":"$use_magic","containerName":"unflatten_seq","line":1157,"kind":13},{"line":1159,"kind":13,"localvar":"my","definition":"my","name":"@sfs_with_locus_tag","containerName":"unflatten_seq"},{"kind":12,"line":1160,"name":"has_tag","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@flat_seq_features","kind":13,"line":1160},{"containerName":"unflatten_seq","definition":"my","name":"@sfs_with_gene_tag","localvar":"my","kind":13,"line":1161},{"line":1162,"kind":12,"containerName":"unflatten_seq","name":"has_tag"},{"line":1162,"kind":13,"name":"@flat_seq_features","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","definition":"my","name":"@sfs_with_product_tag","localvar":"my","kind":13,"line":1163},{"name":"has_tag","containerName":"unflatten_seq","kind":12,"line":1164},{"name":"@flat_seq_features","containerName":"unflatten_seq","line":1164,"kind":13},{"containerName":"unflatten_seq","name":"@sfs_with_locus_tag","kind":13,"line":1170},{"containerName":"unflatten_seq","name":"$group_tag","kind":13,"line":1173},{"containerName":"unflatten_seq","name":"$group_tag","line":1173,"kind":13},{"containerName":"unflatten_seq","name":"$self","kind":13,"line":1174},{"name":"throw","containerName":"unflatten_seq","line":1174,"kind":12},{"name":"$group_tag","containerName":"unflatten_seq","line":1183,"kind":13},{"containerName":"unflatten_seq","name":"$self","kind":13,"line":1184},{"line":1184,"kind":12,"name":"verbose","containerName":"unflatten_seq"},{"name":"@sfs_with_locus_tag","containerName":"unflatten_seq","line":1192,"kind":13},{"containerName":"unflatten_seq","name":"@sfs_with_gene_tag","line":1193,"kind":13},{"name":"@sfs_with_product_tag","containerName":"unflatten_seq","line":1194,"kind":13},{"containerName":"unflatten_seq","name":"$group_tag","line":1195,"kind":13},{"kind":13,"line":1196,"containerName":"unflatten_seq","name":"$group_tag"},{"containerName":"unflatten_seq","name":"$self","line":1197,"kind":13},{"containerName":"unflatten_seq","name":"verbose","line":1197,"kind":12},{"name":"$group_tag","containerName":"unflatten_seq","kind":13,"line":1203},{"line":1204,"kind":13,"containerName":"unflatten_seq","name":"$group_tag"},{"line":1224,"kind":13,"localvar":"my","name":"@groups","definition":"my","containerName":"unflatten_seq"},{"localvar":"my","definition":"my","name":"%group_by_tag","containerName":"unflatten_seq","line":1238,"kind":13},{"localvar":"my","containerName":"unflatten_seq","name":"$sf","definition":"my","line":1242,"kind":13},{"containerName":"unflatten_seq","name":"@flat_seq_features","line":1242,"kind":13},{"containerName":"unflatten_seq","name":"$sf","line":1243,"kind":13},{"name":"has_tag","containerName":"unflatten_seq","kind":12,"line":1243},{"name":"$group_tag","containerName":"unflatten_seq","line":1243,"kind":13},{"line":1247,"kind":13,"name":"@groups","containerName":"unflatten_seq"},{"name":"$sf","containerName":"unflatten_seq","line":1247,"kind":13},{"kind":13,"line":1251,"name":"@group_tagvals","definition":"my","containerName":"unflatten_seq","localvar":"my"},{"containerName":"unflatten_seq","name":"$sf","kind":13,"line":1251},{"containerName":"unflatten_seq","name":"get_tag_values","kind":12,"line":1251},{"kind":13,"line":1251,"name":"$group_tag","containerName":"unflatten_seq"},{"kind":13,"line":1252,"name":"@group_tagvals","containerName":"unflatten_seq"},{"line":1255,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"kind":12,"line":1255,"containerName":"unflatten_seq","name":"problem"},{"name":"$sf","containerName":"unflatten_seq","line":1257,"kind":13},{"line":1260,"kind":13,"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"$gtv"},{"kind":13,"line":1260,"name":"@group_tagvals","containerName":"unflatten_seq"},{"name":"$gtv","containerName":"unflatten_seq","line":1261,"kind":13},{"line":1261,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"line":1261,"kind":12,"containerName":"unflatten_seq","name":"throw"},{"containerName":"unflatten_seq","definition":"my","name":"$group","localvar":"my","kind":13,"line":1264},{"kind":13,"line":1264,"containerName":"unflatten_seq","name":"$group_by_tag"},{"containerName":"unflatten_seq","name":"$gtv","kind":13,"line":1264},{"line":1265,"kind":13,"name":"$group","containerName":"unflatten_seq"},{"kind":13,"line":1268,"name":"$group","containerName":"unflatten_seq"},{"kind":13,"line":1268,"containerName":"unflatten_seq","name":"$sf"},{"name":"$group","containerName":"unflatten_seq","kind":13,"line":1272},{"kind":13,"line":1272,"name":"$sf","containerName":"unflatten_seq"},{"name":"$group_by_tag","containerName":"unflatten_seq","kind":13,"line":1273},{"line":1273,"kind":13,"containerName":"unflatten_seq","name":"$gtv"},{"containerName":"unflatten_seq","name":"$group","line":1273,"kind":13},{"name":"@groups","containerName":"unflatten_seq","kind":13,"line":1274},{"name":"$group","containerName":"unflatten_seq","kind":13,"line":1274},{"containerName":"unflatten_seq","name":"@groups","line":1286,"kind":13},{"containerName":"unflatten_seq","name":"$self","line":1286,"kind":13},{"kind":12,"line":1286,"containerName":"unflatten_seq","name":"_split_group_if_disconnected"},{"line":1286,"kind":13,"containerName":"unflatten_seq","name":"@groups"},{"line":1293,"kind":13,"localvar":"my","containerName":"unflatten_seq","name":"$group","definition":"my"},{"kind":13,"line":1293,"containerName":"unflatten_seq","name":"@groups"},{"kind":13,"line":1294,"name":"$self","containerName":"unflatten_seq"},{"line":1294,"kind":12,"name":"_remove_duplicates_from_group","containerName":"unflatten_seq"},{"name":"$group","containerName":"unflatten_seq","kind":13,"line":1294},{"line":1303,"kind":13,"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"$sf"},{"name":"@all_seq_features","containerName":"unflatten_seq","line":1303,"kind":13},{"line":1304,"kind":13,"containerName":"unflatten_seq","name":"$sf"},{"containerName":"unflatten_seq","name":"has_tag","line":1304,"kind":12},{"kind":13,"line":1305,"definition":"my","name":"$type","containerName":"unflatten_seq","localvar":"my"},{"name":"$sf","containerName":"unflatten_seq","kind":13,"line":1305},{"containerName":"unflatten_seq","name":"primary_tag","line":1305,"kind":12},{"name":"$type","containerName":"unflatten_seq","kind":13,"line":1308},{"containerName":"unflatten_seq","name":"$type","line":1308,"kind":13},{"line":1310,"kind":13,"containerName":"unflatten_seq","name":"$sf"},{"name":"primary_tag","containerName":"unflatten_seq","kind":12,"line":1310},{"line":1313,"kind":13,"name":"$sf","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"primary_tag","line":1313,"kind":12},{"localvar":"my","name":"$need_to_infer_exons","definition":"my","containerName":"unflatten_seq","line":1323,"kind":13},{"kind":13,"line":1324,"containerName":"unflatten_seq","definition":"my","name":"$need_to_infer_mRNAs","localvar":"my"},{"line":1325,"kind":13,"localvar":"my","containerName":"unflatten_seq","name":"@removed_exons","definition":"my"},{"containerName":"unflatten_seq","name":"$use_magic","line":1326,"kind":13},{"containerName":"unflatten_seq","name":"$structure_type","kind":13,"line":1327},{"kind":13,"line":1328,"name":"$self","containerName":"unflatten_seq"},{"name":"throw","containerName":"unflatten_seq","kind":12,"line":1328},{"line":1330,"kind":13,"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"$n_introns"},{"containerName":"unflatten_seq","name":"primary_tag","line":1331,"kind":12},{"name":"@flat_seq_features","containerName":"unflatten_seq","line":1331,"kind":13},{"localvar":"my","containerName":"unflatten_seq","name":"$n_exons","definition":"my","line":1332,"kind":13},{"name":"primary_tag","containerName":"unflatten_seq","line":1333,"kind":12},{"containerName":"unflatten_seq","name":"@flat_seq_features","line":1333,"kind":13},{"line":1334,"kind":13,"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"$n_mrnas"},{"kind":12,"line":1335,"name":"primary_tag","containerName":"unflatten_seq"},{"kind":13,"line":1335,"containerName":"unflatten_seq","name":"@flat_seq_features"},{"line":1336,"kind":13,"localvar":"my","definition":"my","name":"$n_mrnas_attached_to_gene","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"primary_tag","line":1337,"kind":12},{"name":"has_tag","containerName":"unflatten_seq","line":1338,"kind":12},{"kind":13,"line":1338,"containerName":"unflatten_seq","name":"$group_tag"},{"line":1338,"kind":13,"name":"@flat_seq_features","containerName":"unflatten_seq"},{"definition":"my","name":"$n_cdss","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1339},{"kind":12,"line":1340,"containerName":"unflatten_seq","name":"primary_tag"},{"line":1340,"kind":13,"containerName":"unflatten_seq","name":"@flat_seq_features"},{"containerName":"unflatten_seq","name":"$n_rnas","definition":"my","localvar":"my","kind":13,"line":1341},{"kind":12,"line":1342,"name":"primary_tag","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@flat_seq_features","kind":13,"line":1342},{"containerName":"unflatten_seq","name":"$n_cdss","line":1344,"kind":13},{"containerName":"unflatten_seq","name":"$n_mrnas","kind":13,"line":1350},{"line":1353,"kind":13,"containerName":"unflatten_seq","name":"$structure_type"},{"containerName":"unflatten_seq","name":"$need_to_infer_mRNAs","line":1354,"kind":13},{"kind":13,"line":1356,"containerName":"unflatten_seq","name":"$n_mrnas_attached_to_gene"},{"line":1368,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"verbose","line":1368,"kind":12},{"definition":"my","name":"@floating_mrnas","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1369},{"name":"primary_tag","containerName":"unflatten_seq","line":1370,"kind":12},{"containerName":"unflatten_seq","name":"has_tag","kind":12,"line":1371},{"line":1371,"kind":13,"containerName":"unflatten_seq","name":"$group_tag"},{"kind":13,"line":1371,"name":"@flat_seq_features","containerName":"unflatten_seq"},{"localvar":"my","containerName":"unflatten_seq","name":"$mrna","definition":"my","line":1373,"kind":13},{"kind":13,"line":1373,"containerName":"unflatten_seq","name":"@floating_mrnas"},{"kind":13,"line":1374,"name":"$self","containerName":"unflatten_seq"},{"name":"_write_sf_detail","containerName":"unflatten_seq","kind":12,"line":1374},{"line":1374,"kind":13,"containerName":"unflatten_seq","name":"$mrna"},{"kind":13,"line":1379,"containerName":"unflatten_seq","name":"@flat_seq_features"},{"containerName":"unflatten_seq","name":"primary_tag","kind":12,"line":1380},{"name":"$structure_type","containerName":"unflatten_seq","kind":13,"line":1389},{"name":"$need_to_infer_mRNAs","containerName":"unflatten_seq","kind":13,"line":1390},{"name":"$need_to_infer_exons","containerName":"unflatten_seq","kind":13,"line":1396},{"name":"$n_rnas","containerName":"unflatten_seq","kind":13,"line":1400},{"name":"$need_to_infer_exons","containerName":"unflatten_seq","line":1401,"kind":13},{"name":"$need_to_infer_exons","containerName":"unflatten_seq","kind":13,"line":1405},{"kind":13,"line":1409,"containerName":"unflatten_seq","definition":"my","name":"$group","localvar":"my"},{"name":"@groups","containerName":"unflatten_seq","line":1409,"kind":13},{"containerName":"unflatten_seq","name":"$group","kind":13,"line":1410},{"localvar":"my","containerName":"unflatten_seq","name":"$type","definition":"my","line":1412,"kind":13},{"line":1412,"kind":12,"containerName":"unflatten_seq","name":"primary_tag"},{"containerName":"unflatten_seq","name":"$type","kind":13,"line":1413},{"name":"@removed_exons","containerName":"unflatten_seq","kind":13,"line":1416},{"kind":13,"line":1418,"containerName":"unflatten_seq","name":"$type"},{"containerName":"unflatten_seq","name":"$type","kind":13,"line":1418},{"line":1419,"kind":13,"name":"$group","containerName":"unflatten_seq"},{"kind":13,"line":1422,"containerName":"unflatten_seq","name":"@groups"},{"kind":13,"line":1422,"containerName":"unflatten_seq","name":"$_"},{"kind":13,"line":1422,"name":"@groups","containerName":"unflatten_seq"},{"kind":13,"line":1428,"name":"$_","containerName":"unflatten_seq"},{"line":1428,"kind":13,"containerName":"unflatten_seq","name":"@groups"},{"line":1429,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"line":1429,"kind":12,"containerName":"unflatten_seq","name":"throw"},{"kind":13,"line":1433,"name":"$self","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"verbose","kind":12,"line":1433},{"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"$group","line":1435,"kind":13},{"name":"@groups","containerName":"unflatten_seq","line":1435,"kind":13},{"containerName":"unflatten_seq","name":"$self","line":1436,"kind":13},{"line":1436,"kind":12,"name":"_write_group","containerName":"unflatten_seq"},{"kind":13,"line":1436,"name":"$group","containerName":"unflatten_seq"},{"line":1436,"kind":13,"name":"$group_tag","containerName":"unflatten_seq"},{"kind":13,"line":1447,"name":"$structure_type","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$structure_type","line":1448,"kind":13},{"name":"$self","containerName":"unflatten_seq","line":1449,"kind":13},{"kind":12,"line":1449,"name":"partonomy","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$self","kind":13,"line":1457},{"name":"throw","containerName":"unflatten_seq","kind":12,"line":1457},{"kind":13,"line":1462,"containerName":"unflatten_seq","name":"$use_magic"},{"containerName":"unflatten_seq","definition":"my","name":"$sf","localvar":"my","kind":13,"line":1463},{"line":1463,"kind":13,"name":"@all_seq_features","containerName":"unflatten_seq"},{"kind":13,"line":1464,"name":"$sf","containerName":"unflatten_seq"},{"kind":12,"line":1464,"name":"has_tag","containerName":"unflatten_seq"},{"name":"$resolver_tag","containerName":"unflatten_seq","kind":13,"line":1465},{"containerName":"unflatten_seq","name":"$use_magic","line":1470,"kind":13},{"containerName":"unflatten_seq","name":"$group","definition":"my","localvar":"my","kind":13,"line":1475},{"containerName":"unflatten_seq","name":"@groups","kind":13,"line":1475},{"localvar":"my","containerName":"unflatten_seq","name":"@sfs","definition":"my","line":1476,"kind":13},{"name":"$group","containerName":"unflatten_seq","line":1476,"kind":13},{"name":"@sfs","containerName":"unflatten_seq","line":1477,"kind":13},{"kind":13,"line":1478,"name":"$sf","definition":"my","containerName":"unflatten_seq","localvar":"my"},{"line":1478,"kind":13,"containerName":"unflatten_seq","name":"@sfs"},{"containerName":"unflatten_seq","definition":"my","name":"$type","localvar":"my","kind":13,"line":1479},{"kind":13,"line":1479,"containerName":"unflatten_seq","name":"$sf"},{"name":"primary_tag","containerName":"unflatten_seq","line":1479,"kind":12},{"name":"$type","containerName":"unflatten_seq","kind":13,"line":1480},{"definition":"my","name":"$container_type","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1481},{"line":1481,"kind":13,"containerName":"unflatten_seq","name":"$self"},{"kind":12,"line":1481,"containerName":"unflatten_seq","name":"get_container_type"},{"kind":13,"line":1481,"name":"$type","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$container_type","kind":13,"line":1482},{"containerName":"unflatten_seq","name":"$self","kind":13,"line":1483},{"kind":12,"line":1483,"name":"partonomy","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$type","kind":13,"line":1483},{"name":"@top_sfs","definition":"my","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1502},{"kind":13,"line":1502,"name":"$self","containerName":"unflatten_seq"},{"kind":12,"line":1502,"containerName":"unflatten_seq","name":"unflatten_groups"},{"line":1502,"kind":13,"containerName":"unflatten_seq","name":"@groups"},{"containerName":"unflatten_seq","name":"$resolver_method","line":1503,"kind":13},{"containerName":"unflatten_seq","name":"$resolver_tag","kind":13,"line":1504},{"kind":13,"line":1507,"containerName":"unflatten_seq","name":"$self"},{"kind":12,"line":1507,"containerName":"unflatten_seq","name":"partonomy"},{"containerName":"unflatten_seq","name":"$old_partonomy","kind":13,"line":1507},{"name":"$self","containerName":"unflatten_seq","kind":13,"line":1510},{"line":1510,"kind":12,"name":"structure_type","containerName":"unflatten_seq"},{"kind":13,"line":1510,"name":"$old_structure_type","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"$seq","line":1514,"kind":13},{"containerName":"unflatten_seq","name":"remove_SeqFeatures","kind":12,"line":1514},{"containerName":"unflatten_seq","name":"$seq","kind":13,"line":1515},{"kind":12,"line":1515,"name":"add_SeqFeature","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@top_sfs","kind":13,"line":1515},{"name":"$need_to_infer_mRNAs","containerName":"unflatten_seq","kind":13,"line":1524},{"name":"$self","containerName":"unflatten_seq","line":1525,"kind":13},{"name":"verbose","containerName":"unflatten_seq","line":1525,"kind":12},{"name":"$self","containerName":"unflatten_seq","line":1528,"kind":13},{"containerName":"unflatten_seq","name":"infer_mRNA_from_CDS","kind":12,"line":1528},{"name":"$seq","containerName":"unflatten_seq","kind":13,"line":1528},{"kind":13,"line":1532,"name":"$need_to_infer_exons","containerName":"unflatten_seq"},{"localvar":"my","containerName":"unflatten_seq","name":"$sf","definition":"my","line":1535,"kind":13},{"kind":13,"line":1535,"name":"@top_sfs","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","definition":"my","name":"@sub_sfs","localvar":"my","kind":13,"line":1536},{"line":1536,"kind":13,"containerName":"unflatten_seq","name":"$sf"},{"containerName":"unflatten_seq","name":"$sf","kind":13,"line":1536},{"line":1536,"kind":12,"name":"get_all_SeqFeatures","containerName":"unflatten_seq"},{"name":"$self","containerName":"unflatten_seq","kind":13,"line":1537},{"containerName":"unflatten_seq","name":"feature_from_splitloc","line":1537,"kind":12},{"kind":13,"line":1537,"containerName":"unflatten_seq","name":"@sub_sfs"},{"name":"@removed_exons","containerName":"unflatten_seq","kind":13,"line":1552},{"containerName":"unflatten_seq","definition":"my","name":"@allfeats","localvar":"my","kind":13,"line":1553},{"line":1553,"kind":13,"name":"$seq","containerName":"unflatten_seq"},{"kind":12,"line":1553,"containerName":"unflatten_seq","name":"get_all_SeqFeatures"},{"definition":"my","name":"@mrnas","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1556},{"kind":12,"line":1556,"name":"primary_tag","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@allfeats","line":1556,"kind":13},{"containerName":"unflatten_seq","name":"@exons","definition":"my","localvar":"my","kind":13,"line":1557},{"containerName":"unflatten_seq","name":"primary_tag","line":1558,"kind":12},{"line":1559,"kind":12,"name":"get_SeqFeatures","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@mrnas","line":1559,"kind":13},{"containerName":"unflatten_seq","definition":"my","name":"%exon_h","localvar":"my","kind":13,"line":1561},{"name":"$exon_h","containerName":"unflatten_seq","line":1565,"kind":13},{"kind":13,"line":1565,"containerName":"unflatten_seq","name":"$self"},{"containerName":"unflatten_seq","name":"_locstr","kind":12,"line":1565},{"containerName":"unflatten_seq","name":"@exons","line":1565,"kind":13},{"name":"@problems","definition":"my","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1566},{"name":"$problem","definition":"my","containerName":"unflatten_seq","localvar":"my","kind":13,"line":1569},{"localvar":"my","name":"$n_exons","definition":"my","containerName":"unflatten_seq","line":1570,"kind":13},{"kind":13,"line":1570,"name":"$n_removed_exons","containerName":"unflatten_seq"},{"line":1571,"kind":13,"name":"%exon_h","containerName":"unflatten_seq"},{"kind":13,"line":1571,"containerName":"unflatten_seq","name":"@removed_exons"},{"line":1572,"kind":13,"localvar":"my","name":"$removed_exon","definition":"my","containerName":"unflatten_seq"},{"kind":13,"line":1572,"name":"@removed_exons","containerName":"unflatten_seq"},{"kind":13,"line":1573,"containerName":"unflatten_seq","definition":"my","name":"$locstr","localvar":"my"},{"kind":13,"line":1573,"containerName":"unflatten_seq","name":"$self"},{"line":1573,"kind":12,"name":"_locstr","containerName":"unflatten_seq"},{"kind":13,"line":1573,"containerName":"unflatten_seq","name":"$removed_exon"},{"line":1574,"kind":13,"localvar":"my","name":"$inferred_exons","definition":"my","containerName":"unflatten_seq"},{"name":"$exon_h","containerName":"unflatten_seq","kind":13,"line":1574},{"name":"$locstr","containerName":"unflatten_seq","kind":13,"line":1574},{"containerName":"unflatten_seq","name":"$exon_h","line":1575,"kind":13},{"name":"$locstr","containerName":"unflatten_seq","line":1575,"kind":13},{"name":"$inferred_exons","containerName":"unflatten_seq","kind":13,"line":1576},{"localvar":"my","containerName":"unflatten_seq","name":"%exons_done","definition":"my","line":1577,"kind":13},{"kind":13,"line":1578,"containerName":"unflatten_seq","name":"$exon","definition":"my","localvar":"my"},{"kind":13,"line":1578,"containerName":"unflatten_seq","name":"$inferred_exons"},{"containerName":"unflatten_seq","name":"$exons_done","line":1581,"kind":13},{"line":1581,"kind":13,"containerName":"unflatten_seq","name":"$exon"},{"line":1582,"kind":13,"containerName":"unflatten_seq","name":"$exons_done"},{"containerName":"unflatten_seq","name":"$exon","line":1582,"kind":13},{"kind":13,"line":1586,"containerName":"unflatten_seq","definition":"my","name":"$tag","localvar":"my"},{"line":1586,"kind":13,"name":"$removed_exon","containerName":"unflatten_seq"},{"name":"get_all_tags","containerName":"unflatten_seq","line":1586,"kind":12},{"line":1587,"kind":13,"localvar":"my","name":"@vals","definition":"my","containerName":"unflatten_seq"},{"line":1587,"kind":13,"name":"$removed_exon","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"get_tag_values","line":1587,"kind":12},{"name":"$tag","containerName":"unflatten_seq","kind":13,"line":1587},{"line":1588,"kind":13,"name":"$exon","containerName":"unflatten_seq"},{"line":1588,"kind":12,"name":"can","containerName":"unflatten_seq"},{"line":1593,"kind":13,"containerName":"unflatten_seq","name":"$self"},{"name":"throw","containerName":"unflatten_seq","kind":12,"line":1593},{"line":1596,"kind":13,"containerName":"unflatten_seq","name":"$exon"},{"kind":12,"line":1596,"containerName":"unflatten_seq","name":"add_tag_value"},{"kind":13,"line":1596,"name":"$tag","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"@vals","kind":13,"line":1596},{"kind":13,"line":1602,"name":"@problems","containerName":"unflatten_seq"},{"name":"%exon_h","containerName":"unflatten_seq","line":1611,"kind":13},{"line":1613,"kind":13,"containerName":"unflatten_seq","name":"@problems"},{"kind":13,"line":1617,"name":"%exon_h","containerName":"unflatten_seq"},{"kind":13,"line":1621,"name":"@problems","containerName":"unflatten_seq"},{"localvar":"my","name":"$thresh","definition":"my","containerName":"unflatten_seq","line":1622,"kind":13},{"line":1622,"kind":13,"name":"$self","containerName":"unflatten_seq"},{"containerName":"unflatten_seq","name":"error_threshold","kind":12,"line":1622},{"localvar":"my","containerName":"unflatten_seq","definition":"my","name":"@bad_problems","line":1623,"kind":13},{"name":"$thresh","containerName":"unflatten_seq","line":1623,"kind":13},{"containerName":"unflatten_seq","name":"@problems","kind":13,"line":1623},{"line":1624,"kind":13,"containerName":"unflatten_seq","name":"@bad_problems"},{"name":"$self","containerName":"unflatten_seq","line":1626,"kind":13},{"name":"_write_hier","containerName":"unflatten_seq","line":1626,"kind":12},{"kind":13,"line":1626,"containerName":"unflatten_seq","name":"@top_sfs"},{"kind":13,"line":1628,"name":"$self","containerName":"unflatten_seq"},{"line":1629,"kind":13,"containerName":"unflatten_seq","name":"$self"},{"kind":12,"line":1629,"containerName":"unflatten_seq","name":"throw"},{"containerName":"unflatten_seq","name":"@bad_problems","kind":13,"line":1630},{"containerName":"unflatten_seq","name":"$self","line":1632,"kind":13},{"containerName":"unflatten_seq","name":"problem","kind":12,"line":1632},{"containerName":"unflatten_seq","name":"$_","kind":13,"line":1632},{"name":"@problems","containerName":"unflatten_seq","kind":13,"line":1632}],"kind":12},{"name":"CDS","line":1450,"kind":12},{"kind":12,"line":1451,"name":"exon"},{"line":1452,"kind":12,"name":"intron"},{"kind":12,"line":1628,"name":"_problems_reported"},{"line":1642,"kind":13,"containerName":null,"name":"$seq"},{"name":"get_SeqFeatures","containerName":"main::","line":1642,"kind":12},{"definition":"sub","name":"_split_group_if_disconnected","containerName":"main::","range":{"end":{"character":9999,"line":1689},"start":{"line":1655,"character":0}},"kind":12,"children":[{"localvar":"my","containerName":"_split_group_if_disconnected","definition":"my","name":"$self","line":1656,"kind":13},{"definition":"my","name":"$group","containerName":"_split_group_if_disconnected","localvar":"my","kind":13,"line":1657},{"localvar":"my","containerName":"_split_group_if_disconnected","definition":"my","name":"@sfs","line":1658,"kind":13},{"line":1658,"kind":13,"containerName":"_split_group_if_disconnected","name":"$group"},{"line":1659,"kind":13,"localvar":"my","name":"@ranges","definition":"my","containerName":"_split_group_if_disconnected"},{"line":1660,"kind":12,"name":"disconnected_ranges","containerName":"_split_group_if_disconnected"},{"kind":13,"line":1660,"containerName":"_split_group_if_disconnected","name":"@sfs"},{"localvar":"my","containerName":"_split_group_if_disconnected","name":"@groups","definition":"my","line":1661,"kind":13},{"containerName":"_split_group_if_disconnected","name":"@ranges","line":1662,"kind":13},{"line":1663,"kind":13,"containerName":"_split_group_if_disconnected","name":"$self"},{"name":"throw","containerName":"_split_group_if_disconnected","line":1663,"kind":12},{"containerName":"_split_group_if_disconnected","name":"@ranges","kind":13,"line":1665},{"name":"@groups","containerName":"_split_group_if_disconnected","kind":13,"line":1667},{"containerName":"_split_group_if_disconnected","name":"$group","line":1667,"kind":13},{"line":1672,"kind":13,"containerName":"_split_group_if_disconnected","name":"$self"},{"kind":12,"line":1672,"containerName":"_split_group_if_disconnected","name":"verbose"},{"line":1674,"kind":13,"name":"$self","containerName":"_split_group_if_disconnected"},{"kind":12,"line":1674,"name":"_write_group","containerName":"_split_group_if_disconnected"},{"line":1674,"kind":13,"containerName":"_split_group_if_disconnected","name":"$group"},{"kind":13,"line":1674,"name":"$self","containerName":"_split_group_if_disconnected"},{"kind":12,"line":1674,"name":"group_tag","containerName":"_split_group_if_disconnected"},{"containerName":"_split_group_if_disconnected","name":"@groups","line":1676,"kind":13},{"name":"$range","definition":"my","containerName":"_split_group_if_disconnected","localvar":"my","kind":13,"line":1678},{"name":"intersection","containerName":"_split_group_if_disconnected","kind":12,"line":1680},{"name":"$range","containerName":"_split_group_if_disconnected","kind":13,"line":1680},{"kind":13,"line":1681,"containerName":"_split_group_if_disconnected","name":"@sfs"},{"containerName":"_split_group_if_disconnected","name":"@ranges","kind":13,"line":1682},{"kind":13,"line":1683,"containerName":"_split_group_if_disconnected","name":"$self"},{"containerName":"_split_group_if_disconnected","name":"verbose","kind":12,"line":1683},{"name":"$self","containerName":"_split_group_if_disconnected","line":1685,"kind":13},{"kind":12,"line":1685,"containerName":"_split_group_if_disconnected","name":"_write_group"},{"kind":13,"line":1685,"containerName":"_split_group_if_disconnected","name":"$self"},{"name":"group_tag","containerName":"_split_group_if_disconnected","kind":12,"line":1685},{"line":1685,"kind":13,"containerName":"_split_group_if_disconnected","name":"@groups"},{"kind":13,"line":1688,"containerName":"_split_group_if_disconnected","name":"@groups"}],"line":1655},{"kind":12,"line":1660,"containerName":"Range","name":"Bio"},{"definition":"sub","name":"_remove_duplicates_from_group","containerName":"main::","range":{"end":{"character":9999,"line":1756},"start":{"character":0,"line":1691}},"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_remove_duplicates_from_group","line":1692,"kind":13},{"localvar":"my","name":"$group","definition":"my","containerName":"_remove_duplicates_from_group","line":1693,"kind":13},{"kind":13,"line":1702,"containerName":"_remove_duplicates_from_group","definition":"my","name":"@genes","localvar":"my"},{"containerName":"_remove_duplicates_from_group","name":"primary_tag","kind":12,"line":1702},{"kind":13,"line":1702,"name":"$group","containerName":"_remove_duplicates_from_group"},{"kind":13,"line":1703,"containerName":"_remove_duplicates_from_group","name":"@genes"},{"containerName":"_remove_duplicates_from_group","name":"$self","kind":13,"line":1723},{"kind":12,"line":1723,"name":"verbose","containerName":"_remove_duplicates_from_group"},{"line":1727,"kind":13,"containerName":"_remove_duplicates_from_group","name":"@genes"},{"line":1729,"kind":13,"localvar":"my","containerName":"_remove_duplicates_from_group","definition":"my","name":"$loc"},{"line":1729,"kind":12,"name":"location","containerName":"_remove_duplicates_from_group"},{"kind":13,"line":1730,"name":"$loc","containerName":"_remove_duplicates_from_group"},{"line":1730,"kind":12,"containerName":"_remove_duplicates_from_group","name":"isa"},{"localvar":"my","name":"@locs","definition":"my","containerName":"_remove_duplicates_from_group","line":1731,"kind":13},{"line":1731,"kind":13,"name":"$loc","containerName":"_remove_duplicates_from_group"},{"kind":12,"line":1731,"containerName":"_remove_duplicates_from_group","name":"each_Location"},{"line":1732,"kind":13,"name":"@locs","containerName":"_remove_duplicates_from_group"},{"kind":13,"line":1742,"name":"@genes","containerName":"_remove_duplicates_from_group"},{"name":"@genes","containerName":"_remove_duplicates_from_group","line":1744,"kind":13},{"containerName":"_remove_duplicates_from_group","name":"@genes","kind":13,"line":1746},{"kind":13,"line":1746,"name":"$genes","containerName":"_remove_duplicates_from_group"},{"line":1748,"kind":13,"containerName":"_remove_duplicates_from_group","name":"@genes"},{"kind":13,"line":1749,"name":"@genes","containerName":"_remove_duplicates_from_group"},{"containerName":"_remove_duplicates_from_group","name":"$self","kind":13,"line":1749},{"name":"throw","containerName":"_remove_duplicates_from_group","line":1749,"kind":12},{"containerName":"_remove_duplicates_from_group","name":"$group","line":1750,"kind":13},{"line":1751,"kind":13,"name":"$genes","containerName":"_remove_duplicates_from_group"},{"kind":12,"line":1751,"containerName":"_remove_duplicates_from_group","name":"primary_tag"},{"line":1751,"kind":13,"name":"$group","containerName":"_remove_duplicates_from_group"}],"line":1691},{"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'\n\n\n\n\nsub unflatten_seq{\n   my ($self,@args) = @_;\n\n    my($seq, $resolver_method, $group_tag, $partonomy, \n       $structure_type, $resolver_tag, $use_magic) =\n\t$self->_rearrange([qw(SEQ\n                              RESOLVER_METHOD\n                              GROUP_TAG\n                              PARTONOMY\n\t\t\t      STRUCTURE_TYPE\n\t\t\t      RESOLVER_TAG\n\t\t\t      USE_MAGIC\n\t\t\t     )],\n                          @args);\n\n   # seq we want to unflatten\n   $seq = $seq || $self->seq;\n\n\n   # prevent bad argument combinations\n   if ($partonomy &&\n       defined($structure_type)) {\n       $self->throw(\"You cannot set both -partonomy and -structure_type\\n\".\n\t\t    \"(the former is implied by the latter)\");\n   }\n\n   # remember the current value of partonomy, to reset later\n   my $old_partonomy = $self->partonomy;\n   $self->partonomy($partonomy) if defined $partonomy;\n\n   # remember old structure_type\n   my $old_structure_type = $self->structure_type;\n   $self->structure_type($structure_type) if defined $structure_type;\n\n   # if we are sourcing our data from genbank, all the\n   # features should be flat (eq no sub_SeqFeatures)\n   my @flat_seq_features = $seq->get_SeqFeatures;\n   my @all_seq_features = $seq->get_all_SeqFeatures;\n\n   # sanity checks\n   if (@all_seq_features > @flat_seq_features) {\n       $self->throw(\"It looks as if this sequence has already been unflattened\");\n   }\n   if (@all_seq_features < @flat_seq_features) {\n       $self->throw(\"ASSERTION ERROR: something is seriously wrong with your features\");\n   }\n\n   # tag for ungrouping; usually /gene or /locus_tag\n   #     for example:        /gene=\"foo\"\n   $group_tag = $group_tag || $self->group_tag;\n   if ($use_magic) {\n       # use magic to guess the group tag\n       my @sfs_with_locus_tag =\n\t grep {$_->has_tag(\"locus_tag\")} @flat_seq_features;\n       my @sfs_with_gene_tag =\n\t grep {$_->has_tag(\"gene\")} @flat_seq_features;\n       my @sfs_with_product_tag =\n\t grep {$_->has_tag(\"product\")} @flat_seq_features;\n\t \n#        if ($group_tag && $self->{'trust_grouptag'}) { # dgg suggestion\n# \n#         }\n#        elsif\n       if (@sfs_with_locus_tag) {\n        # dgg note: would like to -use_magic with -group_tag = 'gene' for ensembl genomes\n        # where ensembl gene FT have both /locus_tag and /gene, but mRNA, CDS have /gene only\n\t   if ($group_tag && $group_tag ne 'locus_tag') {\n\t       $self->throw(\"You have explicitly set group_tag to be '$group_tag'\\n\".\n\t\t\t    \"However, I detect that some features use /locus_tag\\n\".\n\t\t\t    \"I believe that this is the correct group_tag to use\\n\".\n\t\t\t    \"You can resolve this by either NOT setting -group_tag\\n\".\n\t\t\t    \"OR you can unset -use_magic to regain control\");\n\t   }\n\n\t   # use /locus_tag instead of /gene tag for grouping\n\t   # see GenBank entry AE003677 (version 3) for an example\n\t   $group_tag = 'locus_tag';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n       }\n\n       # on rare occasions, records will have no /gene or /locus_tag\n       # but it WILL have /product tags. These serve the same purpose\n       # for grouping. For an example, see AY763288 (also in t/data)\n       if (@sfs_with_locus_tag==0 &&\n           @sfs_with_gene_tag==0 &&\n           @sfs_with_product_tag>0 &&\n           !$group_tag) {\n\t   $group_tag = 'product';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n           \n       }\n   }\n   if (!$group_tag) {\n       $group_tag = 'gene';\n   }\n\n   # ------------------------------\n   # GROUP FEATURES using $group_tag\n   #     collect features into unstructured groups\n   # ------------------------------\n\n   # -------------\n   # we want to generate a list of groups;\n   # each group is a list of SeqFeatures; this\n   # group probably (but not necessarily)\n   # corresponds to a gene model.\n   #\n   # this array will look something like this:\n   # ([$f1], [$f2, $f3, $f4], ...., [$f97, $f98, $f99])\n   #\n   # there are also 'singleton' groups, with one member.\n   # for instance, the 'source' feature is in a singleton group;\n   # the same with others such as 'misc_feature'\n   my @groups = ();\n   # -------------\n\n   # --------------------\n   # we hope that the genbank record allows us to group by some grouping\n   # tag.\n   # for instance, most of the time a gene model can be grouped using\n   # the gene tag - that is where you see\n   #                    /gene=\"foo\"\n   # in a genbank record\n   # --------------------\n   \n   # keep an index of groups by their\n   # grouping tag\n   my %group_by_tag = ();\n   \n\n   # iterate through all features, putting them into groups\n   foreach my $sf (@flat_seq_features) {\n       if (!$sf->has_tag($group_tag)) {\n\t   # SINGLETON\n           # this is an ungroupable feature;\n           # add it to a group of its own\n           push(@groups, [$sf]);\n       }\n       else {\n\t   # NON-SINGLETON\n           my @group_tagvals = $sf->get_tag_values($group_tag);\n           if (@group_tagvals > 1) {\n\t       # sanity check:\n               # currently something can only belong to one group\n               $self->problem(2,\n\t\t\t      \">1 value for /$group_tag: @group_tagvals\\n\".\n\t\t\t      \"At this time this module is not equipped to handle this adequately\", $sf);\n           }\n\t   # get value of group tag\n           my $gtv = shift @group_tagvals;\n           $gtv || $self->throw(\"Empty /$group_tag vals not allowed!\");\n\n           # is this a new group?\n           my $group = $group_by_tag{$gtv};\n           if ($group) {\n               # this group has been encountered before - add current\n               # sf to the end of the group\n               push(@$group, $sf);\n           }\n           else {\n               # new group; add to index and create new group\n               $group = [$sf];  # currently one member; probably more to come\n               $group_by_tag{$gtv} = $group;\n               push(@groups, $group);\n           }\n       }\n   }\n   \n   # as well as having the same group_tag, a group should be spatially\n   # connected. if not, then the group should be split into subgroups.\n   # this turns out to be necessary in the case of multicopy genes.\n   # the standard way to represent these is as spatially disconnected\n   # gene models (usually a 'gene' feature and some kind of RNA feature)\n   # with the same group tag; the code below will split these into \n   # seperate groups, one per copy.\n   @groups = map { $self->_split_group_if_disconnected($_) } @groups;\n\n   # remove any duplicates; most of the time the method below has\n   # no effect. there are some unusual genbank records for which\n   # duplicate removal is necessary. see the comments in the\n   # _remove_duplicates_from_group() method if you want to know\n   # the ugly details\n   foreach my $group (@groups) {\n       $self->_remove_duplicates_from_group($group);\n   }\n\n   # -\n\n   # PSEUDOGENES, PSEUDOEXONS AND PSEUDOINTRONS\n   # these are indicated with the /pseudo tag\n   # these are mapped to a different type; they should NOT\n   # be treated as normal genes\n   foreach my $sf (@all_seq_features) {\n       if ($sf->has_tag('pseudo')) {\n           my $type = $sf->primary_tag;\n           # SO type is typically the same as the normal\n           # type but preceeded by \"pseudo\"\n           if ($type eq 'misc_RNA' || $type eq 'mRNA') { \n            # dgg: see TypeMapper; both pseudo mRNA,misc_RNA should be pseudogenic_transcript\n               $sf->primary_tag(\"pseudotranscript\");\n           }\n           else {\n               $sf->primary_tag(\"pseudo$type\");\n           }\n       }\n   }\n   # now some of the post-processing that follows which applies to\n   # genes will NOT be applied to pseudogenes; this is deliberate\n   # for example, gene models are normalised to be gene-transcript-exon\n   # for pseudogenes we leave them as pseudogene-pseudoexon\n\n   # --- MAGIC ---\n   my $need_to_infer_exons = 0;\n   my $need_to_infer_mRNAs = 0;\n   my @removed_exons = ();\n   if ($use_magic) {\n       if (defined($structure_type)) {\n\t   $self->throw(\"Can't combine use_magic AND setting structure_type\");\n       }\n       my $n_introns =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_exons =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_mrnas =\n\t scalar(grep {$_->primary_tag eq 'mRNA'} @flat_seq_features);\n       my $n_mrnas_attached_to_gene =\n\t scalar(grep {$_->primary_tag eq 'mRNA' &&\n\t\t\t$_->has_tag($group_tag)} @flat_seq_features);\n       my $n_cdss =\n\t scalar(grep {$_->primary_tag eq 'CDS'} @flat_seq_features);\n       my $n_rnas =\n\t scalar(grep {$_->primary_tag =~ /RNA/} @flat_seq_features);  \n       # Are there any CDS features in the record?\n       if ($n_cdss > 0) {\n           # YES\n           \n\t   # - a pc gene model should contain at the least a CDS\n\n           # Are there any mRNA features in the record?\n\t   if ($n_mrnas == 0) {\n               # NO mRNAs:\n\t       # looks like structure_type == 1\n\t       $structure_type = 1;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   elsif ($n_mrnas_attached_to_gene == 0) {\n               # $n_mrnas > 0\n               # $n_mrnas_attached_to_gene = 0\n               #\n               # The entries _do_ contain mRNA features,\n               # but none of them are part of a group/gene, i.e. they\n               # are 'floating'\n\n\t       # this is an annoying weird file that has some floating\n\t       # mRNA features; \n\t       # eg ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/\n               \n               if ($self->verbose) {\n                   my @floating_mrnas =\n                     grep {$_->primary_tag eq 'mRNA' &&\n                             !$_->has_tag($group_tag)} @flat_seq_features;\n                   printf STDERR \"Unattached mRNAs:\\n\";\n                   foreach my $mrna (@floating_mrnas) {\n                       $self->_write_sf_detail($mrna);\n                   }\n                   printf STDERR \"Don't know how to deal with these; filter at source?\\n\";\n               }\n\n\t       foreach (@flat_seq_features) {\n\t\t   if ($_->primary_tag eq 'mRNA') {\n\t\t       # what should we do??\n\t\t       \n\t\t       # I think for pombe we just have to filter\n\t\t       # out bogus mRNAs prior to starting\n\t\t   }\n\t       }\n\n\t       # looks like structure_type == 2\n\t       $structure_type = 2;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   else {\n\t   }\n\n\t   # we always infer exons in magic mode\n\t   $need_to_infer_exons = 1;\n       }\n       else {\n\t   # this doesn't seem to be any kind of protein coding gene model\n\t   if ( $n_rnas > 0 ) {\n\t       $need_to_infer_exons = 1;\n\t   }\n       }\n\n       if ($need_to_infer_exons) {\n\t   # remove exons and introns from group -\n\t   # we will infer exons later, and we\n\t   # can always infer introns from exons\n\t   foreach my $group (@groups) {\n\t       @$group = \n\t\t grep {\n\t\t     my $type = $_->primary_tag();\n\t\t     if ($type eq 'exon') {\n\t\t\t # keep track of all removed exons,\n\t\t\t # so we can do a sanity check later\n\t\t\t push(@removed_exons, $_);\n\t\t     }\n\t\t     $type ne 'exon' && $type ne 'intron'\n\t\t } @$group;\n\t   }\n\t   # get rid of any groups that have zero members\n\t   @groups = grep {scalar(@$_)} @groups;\n       }\n   }\n   # --- END OF MAGIC ---\n   \n   # LOGICAL ASSERTION\n   if (grep {!scalar(@$_)} @groups) {\n       $self->throw(\"ASSERTION ERROR: empty group\");\n   }\n\n   # LOGGING\n   if ($self->verbose > 0) {\n       printf STDERR \"GROUPS:\\n\";\n       foreach my $group (@groups) {\n\t   $self->_write_group($group, $group_tag);\n       }\n   }\n   # -\n\n   # --------- FINISHED GROUPING -------------\n\n\n   # TYPE CONTAINMENT HIERARCHY (aka partonomy)\n   # set the containment hierarchy if desired\n   # see docs for structure_type() method\n   if ($structure_type) {\n       if ($structure_type == 1) {\n\t   $self->partonomy(\n                            {CDS => 'gene',\n                             exon => 'CDS',\n                             intron => 'CDS',\n                            }\n                           );\n       }\n       else {\n\t   $self->throw(\"structure_type $structure_type is currently unknown\");\n       }\n   }\n\n   # see if we have an obvious resolver_tag\n   if ($use_magic) {\n       foreach my $sf (@all_seq_features) {\n\t   if ($sf->has_tag('derived_from')) {\n\t       $resolver_tag = 'derived_from';\n\t   }\n       }\n   }\n\n   if ($use_magic) {\n       # point all feature types without a container type to the root type.\n       #\n       # for example, if we have an unanticipated feature_type, say\n       # 'aberration', this should by default point to the parent 'gene'\n       foreach my $group (@groups) {\n\t   my @sfs = @$group;\n\t   if (@sfs > 1) {\n\t       foreach my $sf (@sfs) {\n\t\t   my $type = $sf->primary_tag;\n\t\t   next if $type eq 'gene';\n\t\t   my $container_type = $self->get_container_type($type);\n\t\t   if (!$container_type) {\n\t\t       $self->partonomy->{$type} = 'gene';\n\t\t   }\n\t       }\n\t   }\n       }\n   }\n\n   # we have done the first part of the unflattening.\n   # we now have a list of groups; each group is a list of seqfeatures.\n   # the actual group itself is flat; we may want to unflatten this further;\n   # for instance, a gene model can contain multiple mRNAs and CDSs. We may want\n   # to link the correct mRNA to the correct CDS via the bioperl sub_SeqFeature tree.\n   #\n   # what we would end up with would be\n   #  gene1\n   #    mRNA-a\n   #      CDS-a\n   #    mRNA-b\n   #      CDS-b\n   my @top_sfs = $self->unflatten_groups(-groups=>\\@groups,\n                                         -resolver_method=>$resolver_method,\n\t\t\t\t\t -resolver_tag=>$resolver_tag);\n   \n   # restore settings\n   $self->partonomy($old_partonomy);\n\n   # restore settings\n   $self->structure_type($old_structure_type);\n\n   # modify the original Seq object - the top seqfeatures are now\n   # the top features from each group\n   $seq->remove_SeqFeatures;\n   $seq->add_SeqFeature(@top_sfs);\n\n   # --------- FINISHED UNFLATTENING -------------\n\n   # lets see if there are any post-unflattening tasks we need to do\n\n   \n\n   # INFERRING mRNAs\n   if ($need_to_infer_mRNAs) {\n       if ($self->verbose > 0) {\n\t   printf STDERR \"** INFERRING mRNA from CDS\\n\";\n       }\n       $self->infer_mRNA_from_CDS(-seq=>$seq);\n   }\n\n   # INFERRING exons\n   if ($need_to_infer_exons) {\n\n       # infer exons, one group/gene at a time\n       foreach my $sf (@top_sfs) {\n\t   my @sub_sfs = ($sf, $sf->get_all_SeqFeatures);\n\t   $self->feature_from_splitloc(-features=>\\@sub_sfs);\n       }\n\n       # some exons are stated explicitly; ie there is an \"exon\" feature\n       # most exons are inferred; ie there is a \"mRNA\" feature with\n       # split locations\n       #\n       # if there were exons explicitly stated in the entry, we need to\n       # do two things:\n       #\n       # make sure these exons are consistent with the inferred exons\n       #  (you never know)\n       #\n       # transfer annotation (tag-vals) from the explicit exon to the\n       # new inferred exon\n       if (@removed_exons) {\n\t   my @allfeats = $seq->get_all_SeqFeatures;\n\n\t   # find all the inferred exons that are children of mRNA\n\t   my @mrnas =  grep {$_->primary_tag eq 'mRNA'} @allfeats;\n\t   my @exons =  \n\t     grep {$_->primary_tag eq 'exon'}\n\t       map {$_->get_SeqFeatures} @mrnas;\n\n\t   my %exon_h = (); \t   # index of exons by location;\n\n\t   # there CAN be >1 exon at a location; we can represent these redundantly\n\t   # (ie as a tree, not a graph)\n\t   push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n\t   my @problems = ();      # list of problems;\n\t                           # each problem is a \n\t                           # [$severity, $description] pair\n\t   my $problem = '';\n\t   my ($n_exons, $n_removed_exons) =\n\t     (scalar(keys %exon_h), scalar(@removed_exons));\n\t   foreach my $removed_exon (@removed_exons) {\n\t       my $locstr = $self->_locstr($removed_exon);\n\t       my $inferred_exons = $exon_h{$locstr};\n\t       delete $exon_h{$locstr};\n\t       if ($inferred_exons) {\n\t\t   my %exons_done = ();\n\t\t   foreach my $exon (@$inferred_exons) {\n\n\t\t       # make sure we don't move stuff twice\n\t\t       next if $exons_done{$exon};\n\t\t       $exons_done{$exon} = 1;\n\n\t\t       # we need to tranfer any tag-values from the explicit\n\t\t       # exon to the implicit exon\n\t\t       foreach my $tag ($removed_exon->get_all_tags) {\n\t\t\t   my @vals = $removed_exon->get_tag_values($tag);\n\t\t\t   if (!$exon->can(\"add_tag_value\")) {\n\t\t\t       # I'm puzzled as to what should be done here;\n\t\t\t       # SeqFeatureIs are not necessarily mutable,\n\t\t\t       # but we know that in practice the implementing\n\t\t\t       # class is mutable\n\t\t\t       $self->throw(\"The SeqFeature object does not \".\n\t\t\t\t\t    \"implement add_tag_value()\");\n\t\t\t   }\n\t\t\t   $exon->add_tag_value($tag, @vals);\n\t\t       }\n\t\t   }\n\t       } \n               else {\n                   # no exons inferred at $locstr\n\t\t   push(@problems,\n\t\t\t[1, \n\t\t\t \"there is a conflict with exons; there was an explicitly \".\n\t\t\t \"stated exon with location $locstr, yet I cannot generate \".\n\t\t\t \"this exon from the supplied mRNA locations\\n\"]);\n\t       }\n\t   }\n\t   # do we have any inferred exons left over, that were not\n\t   # covered in the explicit exons?\n\t   if (keys %exon_h) {\n\t       # TODO - we ignore this problem for now\n\t       push(@problems,\n\t\t    [1,\n\t\t     sprintf(\"There are some inferred exons that are not in the \".\n\t\t\t     \"explicit exon list; they are the exons at locations:\\n\".\n\t\t\t     join(\"\\n\", keys %exon_h).\"\\n\")]);\n\t   }\n\n\t   # report any problems\n\t   if (@problems) {\n\t       my $thresh = $self->error_threshold;\n\t       my @bad_problems = grep {$_->[0] > $thresh} @problems;\n\t       if (@bad_problems) {\n\t\t   printf STDERR \"PROBLEM:\\n\";\n\t\t   $self->_write_hier(\\@top_sfs);\n\t\t   # TODO - allow more fine grained control over this\n\t\t   $self->{_problems_reported} = 1;\n\t\t   $self->throw(join(\"\\n\",\n\t\t\t\t     map {\"@$_\"} @bad_problems));\n\t       }\n\t       $self->problem(@$_) foreach @problems;\n\t   }\n       }\n   }    \n   # --- end of inferring exons --\n\n   # return new top level features; this can also \n   # be retrieved via\n   #   $seq->get_SeqFeatures();\n#   return @top_sfs;\n   return $seq->get_SeqFeatures;\n}\n\n# _split_group_if_disconnected([@sfs])\n#\n# as well as having the same group_tag, a group should be spatially\n# connected. if not, then the group should be split into subgroups.\n# this turns out to be necessary in the case of multicopy genes.\n# the standard way to represent these is as spatially disconnected\n# gene models (usually a 'gene' feature and some kind of RNA feature)\n# with the same group tag; the code below will split these into \n# seperate groups, one per copy.\n\nsub _split_group_if_disconnected {\n    my $self = shift;\n    my $group = shift;\n    my @sfs = @$group;\n    my @ranges =\n      Bio::Range->disconnected_ranges(@sfs);\n    my @groups;\n    if (@ranges == 0) {\n\t$self->throw(\"ASSERTION ERROR\");\n    }\n    elsif (@ranges == 1) {\n\t# no need to split the group\n\t@groups = ($group);\n    }\n    else {\n\t# @ranges > 1\n\t# split the group into disconnected ranges\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"GROUP PRE-SPLIT:\\n\";\n\t    $self->_write_group($group, $self->group_tag);\n\t}\n\t@groups =\n\t  map {\n\t      my $range = $_;\n\t      [grep {\n\t\t  $_->intersection($range);\n\t      } @sfs]\n\t  } @ranges;\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"SPLIT GROUPS:\\n\";\n\t    $self->_write_group($_, $self->group_tag) foreach @groups;\t    \n\t}\n    }\n    return @groups;\n}\n\nsub _remove_duplicates_from_group {\n    my $self = shift;\n    my $group = shift;\n\n    # ::: WEIRD BOUNDARY CASE CODE :::\n    # for some reason, there are some gb records with two gene\n    # features for one gene; for example, see ATF14F8.gbk\n    # in the t/data directory\n    #\n    # in this case, we get rid of one of the genes\n\n    my @genes = grep {$_->primary_tag eq 'gene'} @$group;\n    if (@genes > 1) {\n\t# OK, if we look at ATF14F8.gbk we see that some genes\n\t# just exist as a single location, some exist as a multisplit location;\n\t#\n\t# eg\n\n\t#     gene            16790..26395\n\t#                     /gene=\"F14F8_60\"\n\t#     ...\n\t#     gene            complement(join(16790..19855,20136..20912,21378..21497,\n\t#                     21654..21876,22204..22400,22527..23158,23335..23448,\n\t#                     23538..23938,24175..24536,24604..24715,24889..24984,\n\t#                     25114..25171,25257..25329,25544..25589,25900..26018,\n\t#                     26300..26395))\n\t#                     /gene=\"F14F8_60\"\n\n\t# the former is the 'standard' way of representing the gene in genbank;\n\t# the latter is redundant with the CDS entry. So we shall get rid of\n\t# the latter with the following filter\n\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"REMOVING DUPLICATES:\\n\";\n\t}\n\n\t@genes =\n\t  grep {\n\t      my $loc = $_->location;\n\t      if ($loc->isa(\"Bio::Location::SplitLocationI\")) {\n\t\t  my @locs = $loc->each_Location;\t\t  \n\t\t  if (@locs > 1) {\n\t\t      0;\n\t\t  }\n\t\t  else {\n\t\t      1;\n\t\t  }\n\t      }\n\t      else {\n\t\t  1;\n\t      }\n\t  } @genes;\n\n\tif (@genes > 1) {\n\t    # OK, that didn't work. Our only resort is to just pick one at random\n\t    @genes = ($genes[0]);\n\t}\n\tif (@genes) {\n\t    @genes == 1 || $self->throw(\"ASSERTION ERROR\");\n\t    @$group =\n\t      ($genes[0], grep {$_->primary_tag ne 'gene'} @$group);\n\t}\n    }\n    # its a dirty job but someone's gotta do it\n    return;\n}\n\n\n=head2 unflatten_groups\n\n Title   : unflatten_groups\n Usage   :\n Function: iterates over groups, calling unflatten_group() [see below]\n Example :\n Returns : list of Bio::SeqFeatureI objects that are holders\n Args    : see below\n\nArguments\n\n  -groups:          list of list references; inner list is of Bio::SeqFeatureI objects\n                    e.g.  ( [$sf1], [$sf2, $sf3, $sf4], [$sf5, ...], ...)\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.","label":"unflatten_groups($self,@args)"},"kind":12,"line":1786,"children":[{"line":1787,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"unflatten_groups"},{"name":"@args","containerName":"unflatten_groups","kind":13,"line":1787},{"line":1788,"kind":13,"localvar":"my","containerName":"unflatten_groups","definition":"my","name":"$groups"},{"containerName":"unflatten_groups","name":"$resolver_method","line":1788,"kind":13},{"line":1788,"kind":13,"name":"$resolver_tag","containerName":"unflatten_groups"},{"containerName":"unflatten_groups","name":"$self","line":1789,"kind":13},{"name":"_rearrange","containerName":"unflatten_groups","line":1789,"kind":12},{"kind":13,"line":1793,"containerName":"unflatten_groups","name":"@args"},{"line":1798,"kind":13,"name":"$self","containerName":"unflatten_groups"},{"containerName":"unflatten_groups","name":"unflatten_group","kind":12,"line":1798},{"name":"$resolver_method","containerName":"unflatten_groups","kind":13,"line":1799},{"line":1800,"kind":13,"containerName":"unflatten_groups","name":"$resolver_tag"},{"containerName":"unflatten_groups","name":"$groups","kind":13,"line":1801}],"name":"unflatten_groups","range":{"end":{"character":9999,"line":1802},"start":{"line":1786,"character":0}}},{"name":"unflatten_group","range":{"end":{"line":1937,"character":9999},"start":{"line":1830,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"unflatten_group($self,@args)","documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'\n\n\n\n\nsub unflatten_seq{\n   my ($self,@args) = @_;\n\n    my($seq, $resolver_method, $group_tag, $partonomy, \n       $structure_type, $resolver_tag, $use_magic) =\n\t$self->_rearrange([qw(SEQ\n                              RESOLVER_METHOD\n                              GROUP_TAG\n                              PARTONOMY\n\t\t\t      STRUCTURE_TYPE\n\t\t\t      RESOLVER_TAG\n\t\t\t      USE_MAGIC\n\t\t\t     )],\n                          @args);\n\n   # seq we want to unflatten\n   $seq = $seq || $self->seq;\n\n\n   # prevent bad argument combinations\n   if ($partonomy &&\n       defined($structure_type)) {\n       $self->throw(\"You cannot set both -partonomy and -structure_type\\n\".\n\t\t    \"(the former is implied by the latter)\");\n   }\n\n   # remember the current value of partonomy, to reset later\n   my $old_partonomy = $self->partonomy;\n   $self->partonomy($partonomy) if defined $partonomy;\n\n   # remember old structure_type\n   my $old_structure_type = $self->structure_type;\n   $self->structure_type($structure_type) if defined $structure_type;\n\n   # if we are sourcing our data from genbank, all the\n   # features should be flat (eq no sub_SeqFeatures)\n   my @flat_seq_features = $seq->get_SeqFeatures;\n   my @all_seq_features = $seq->get_all_SeqFeatures;\n\n   # sanity checks\n   if (@all_seq_features > @flat_seq_features) {\n       $self->throw(\"It looks as if this sequence has already been unflattened\");\n   }\n   if (@all_seq_features < @flat_seq_features) {\n       $self->throw(\"ASSERTION ERROR: something is seriously wrong with your features\");\n   }\n\n   # tag for ungrouping; usually /gene or /locus_tag\n   #     for example:        /gene=\"foo\"\n   $group_tag = $group_tag || $self->group_tag;\n   if ($use_magic) {\n       # use magic to guess the group tag\n       my @sfs_with_locus_tag =\n\t grep {$_->has_tag(\"locus_tag\")} @flat_seq_features;\n       my @sfs_with_gene_tag =\n\t grep {$_->has_tag(\"gene\")} @flat_seq_features;\n       my @sfs_with_product_tag =\n\t grep {$_->has_tag(\"product\")} @flat_seq_features;\n\t \n#        if ($group_tag && $self->{'trust_grouptag'}) { # dgg suggestion\n# \n#         }\n#        elsif\n       if (@sfs_with_locus_tag) {\n        # dgg note: would like to -use_magic with -group_tag = 'gene' for ensembl genomes\n        # where ensembl gene FT have both /locus_tag and /gene, but mRNA, CDS have /gene only\n\t   if ($group_tag && $group_tag ne 'locus_tag') {\n\t       $self->throw(\"You have explicitly set group_tag to be '$group_tag'\\n\".\n\t\t\t    \"However, I detect that some features use /locus_tag\\n\".\n\t\t\t    \"I believe that this is the correct group_tag to use\\n\".\n\t\t\t    \"You can resolve this by either NOT setting -group_tag\\n\".\n\t\t\t    \"OR you can unset -use_magic to regain control\");\n\t   }\n\n\t   # use /locus_tag instead of /gene tag for grouping\n\t   # see GenBank entry AE003677 (version 3) for an example\n\t   $group_tag = 'locus_tag';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n       }\n\n       # on rare occasions, records will have no /gene or /locus_tag\n       # but it WILL have /product tags. These serve the same purpose\n       # for grouping. For an example, see AY763288 (also in t/data)\n       if (@sfs_with_locus_tag==0 &&\n           @sfs_with_gene_tag==0 &&\n           @sfs_with_product_tag>0 &&\n           !$group_tag) {\n\t   $group_tag = 'product';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n           \n       }\n   }\n   if (!$group_tag) {\n       $group_tag = 'gene';\n   }\n\n   # ------------------------------\n   # GROUP FEATURES using $group_tag\n   #     collect features into unstructured groups\n   # ------------------------------\n\n   # -------------\n   # we want to generate a list of groups;\n   # each group is a list of SeqFeatures; this\n   # group probably (but not necessarily)\n   # corresponds to a gene model.\n   #\n   # this array will look something like this:\n   # ([$f1], [$f2, $f3, $f4], ...., [$f97, $f98, $f99])\n   #\n   # there are also 'singleton' groups, with one member.\n   # for instance, the 'source' feature is in a singleton group;\n   # the same with others such as 'misc_feature'\n   my @groups = ();\n   # -------------\n\n   # --------------------\n   # we hope that the genbank record allows us to group by some grouping\n   # tag.\n   # for instance, most of the time a gene model can be grouped using\n   # the gene tag - that is where you see\n   #                    /gene=\"foo\"\n   # in a genbank record\n   # --------------------\n   \n   # keep an index of groups by their\n   # grouping tag\n   my %group_by_tag = ();\n   \n\n   # iterate through all features, putting them into groups\n   foreach my $sf (@flat_seq_features) {\n       if (!$sf->has_tag($group_tag)) {\n\t   # SINGLETON\n           # this is an ungroupable feature;\n           # add it to a group of its own\n           push(@groups, [$sf]);\n       }\n       else {\n\t   # NON-SINGLETON\n           my @group_tagvals = $sf->get_tag_values($group_tag);\n           if (@group_tagvals > 1) {\n\t       # sanity check:\n               # currently something can only belong to one group\n               $self->problem(2,\n\t\t\t      \">1 value for /$group_tag: @group_tagvals\\n\".\n\t\t\t      \"At this time this module is not equipped to handle this adequately\", $sf);\n           }\n\t   # get value of group tag\n           my $gtv = shift @group_tagvals;\n           $gtv || $self->throw(\"Empty /$group_tag vals not allowed!\");\n\n           # is this a new group?\n           my $group = $group_by_tag{$gtv};\n           if ($group) {\n               # this group has been encountered before - add current\n               # sf to the end of the group\n               push(@$group, $sf);\n           }\n           else {\n               # new group; add to index and create new group\n               $group = [$sf];  # currently one member; probably more to come\n               $group_by_tag{$gtv} = $group;\n               push(@groups, $group);\n           }\n       }\n   }\n   \n   # as well as having the same group_tag, a group should be spatially\n   # connected. if not, then the group should be split into subgroups.\n   # this turns out to be necessary in the case of multicopy genes.\n   # the standard way to represent these is as spatially disconnected\n   # gene models (usually a 'gene' feature and some kind of RNA feature)\n   # with the same group tag; the code below will split these into \n   # seperate groups, one per copy.\n   @groups = map { $self->_split_group_if_disconnected($_) } @groups;\n\n   # remove any duplicates; most of the time the method below has\n   # no effect. there are some unusual genbank records for which\n   # duplicate removal is necessary. see the comments in the\n   # _remove_duplicates_from_group() method if you want to know\n   # the ugly details\n   foreach my $group (@groups) {\n       $self->_remove_duplicates_from_group($group);\n   }\n\n   # -\n\n   # PSEUDOGENES, PSEUDOEXONS AND PSEUDOINTRONS\n   # these are indicated with the /pseudo tag\n   # these are mapped to a different type; they should NOT\n   # be treated as normal genes\n   foreach my $sf (@all_seq_features) {\n       if ($sf->has_tag('pseudo')) {\n           my $type = $sf->primary_tag;\n           # SO type is typically the same as the normal\n           # type but preceeded by \"pseudo\"\n           if ($type eq 'misc_RNA' || $type eq 'mRNA') { \n            # dgg: see TypeMapper; both pseudo mRNA,misc_RNA should be pseudogenic_transcript\n               $sf->primary_tag(\"pseudotranscript\");\n           }\n           else {\n               $sf->primary_tag(\"pseudo$type\");\n           }\n       }\n   }\n   # now some of the post-processing that follows which applies to\n   # genes will NOT be applied to pseudogenes; this is deliberate\n   # for example, gene models are normalised to be gene-transcript-exon\n   # for pseudogenes we leave them as pseudogene-pseudoexon\n\n   # --- MAGIC ---\n   my $need_to_infer_exons = 0;\n   my $need_to_infer_mRNAs = 0;\n   my @removed_exons = ();\n   if ($use_magic) {\n       if (defined($structure_type)) {\n\t   $self->throw(\"Can't combine use_magic AND setting structure_type\");\n       }\n       my $n_introns =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_exons =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_mrnas =\n\t scalar(grep {$_->primary_tag eq 'mRNA'} @flat_seq_features);\n       my $n_mrnas_attached_to_gene =\n\t scalar(grep {$_->primary_tag eq 'mRNA' &&\n\t\t\t$_->has_tag($group_tag)} @flat_seq_features);\n       my $n_cdss =\n\t scalar(grep {$_->primary_tag eq 'CDS'} @flat_seq_features);\n       my $n_rnas =\n\t scalar(grep {$_->primary_tag =~ /RNA/} @flat_seq_features);  \n       # Are there any CDS features in the record?\n       if ($n_cdss > 0) {\n           # YES\n           \n\t   # - a pc gene model should contain at the least a CDS\n\n           # Are there any mRNA features in the record?\n\t   if ($n_mrnas == 0) {\n               # NO mRNAs:\n\t       # looks like structure_type == 1\n\t       $structure_type = 1;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   elsif ($n_mrnas_attached_to_gene == 0) {\n               # $n_mrnas > 0\n               # $n_mrnas_attached_to_gene = 0\n               #\n               # The entries _do_ contain mRNA features,\n               # but none of them are part of a group/gene, i.e. they\n               # are 'floating'\n\n\t       # this is an annoying weird file that has some floating\n\t       # mRNA features; \n\t       # eg ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/\n               \n               if ($self->verbose) {\n                   my @floating_mrnas =\n                     grep {$_->primary_tag eq 'mRNA' &&\n                             !$_->has_tag($group_tag)} @flat_seq_features;\n                   printf STDERR \"Unattached mRNAs:\\n\";\n                   foreach my $mrna (@floating_mrnas) {\n                       $self->_write_sf_detail($mrna);\n                   }\n                   printf STDERR \"Don't know how to deal with these; filter at source?\\n\";\n               }\n\n\t       foreach (@flat_seq_features) {\n\t\t   if ($_->primary_tag eq 'mRNA') {\n\t\t       # what should we do??\n\t\t       \n\t\t       # I think for pombe we just have to filter\n\t\t       # out bogus mRNAs prior to starting\n\t\t   }\n\t       }\n\n\t       # looks like structure_type == 2\n\t       $structure_type = 2;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   else {\n\t   }\n\n\t   # we always infer exons in magic mode\n\t   $need_to_infer_exons = 1;\n       }\n       else {\n\t   # this doesn't seem to be any kind of protein coding gene model\n\t   if ( $n_rnas > 0 ) {\n\t       $need_to_infer_exons = 1;\n\t   }\n       }\n\n       if ($need_to_infer_exons) {\n\t   # remove exons and introns from group -\n\t   # we will infer exons later, and we\n\t   # can always infer introns from exons\n\t   foreach my $group (@groups) {\n\t       @$group = \n\t\t grep {\n\t\t     my $type = $_->primary_tag();\n\t\t     if ($type eq 'exon') {\n\t\t\t # keep track of all removed exons,\n\t\t\t # so we can do a sanity check later\n\t\t\t push(@removed_exons, $_);\n\t\t     }\n\t\t     $type ne 'exon' && $type ne 'intron'\n\t\t } @$group;\n\t   }\n\t   # get rid of any groups that have zero members\n\t   @groups = grep {scalar(@$_)} @groups;\n       }\n   }\n   # --- END OF MAGIC ---\n   \n   # LOGICAL ASSERTION\n   if (grep {!scalar(@$_)} @groups) {\n       $self->throw(\"ASSERTION ERROR: empty group\");\n   }\n\n   # LOGGING\n   if ($self->verbose > 0) {\n       printf STDERR \"GROUPS:\\n\";\n       foreach my $group (@groups) {\n\t   $self->_write_group($group, $group_tag);\n       }\n   }\n   # -\n\n   # --------- FINISHED GROUPING -------------\n\n\n   # TYPE CONTAINMENT HIERARCHY (aka partonomy)\n   # set the containment hierarchy if desired\n   # see docs for structure_type() method\n   if ($structure_type) {\n       if ($structure_type == 1) {\n\t   $self->partonomy(\n                            {CDS => 'gene',\n                             exon => 'CDS',\n                             intron => 'CDS',\n                            }\n                           );\n       }\n       else {\n\t   $self->throw(\"structure_type $structure_type is currently unknown\");\n       }\n   }\n\n   # see if we have an obvious resolver_tag\n   if ($use_magic) {\n       foreach my $sf (@all_seq_features) {\n\t   if ($sf->has_tag('derived_from')) {\n\t       $resolver_tag = 'derived_from';\n\t   }\n       }\n   }\n\n   if ($use_magic) {\n       # point all feature types without a container type to the root type.\n       #\n       # for example, if we have an unanticipated feature_type, say\n       # 'aberration', this should by default point to the parent 'gene'\n       foreach my $group (@groups) {\n\t   my @sfs = @$group;\n\t   if (@sfs > 1) {\n\t       foreach my $sf (@sfs) {\n\t\t   my $type = $sf->primary_tag;\n\t\t   next if $type eq 'gene';\n\t\t   my $container_type = $self->get_container_type($type);\n\t\t   if (!$container_type) {\n\t\t       $self->partonomy->{$type} = 'gene';\n\t\t   }\n\t       }\n\t   }\n       }\n   }\n\n   # we have done the first part of the unflattening.\n   # we now have a list of groups; each group is a list of seqfeatures.\n   # the actual group itself is flat; we may want to unflatten this further;\n   # for instance, a gene model can contain multiple mRNAs and CDSs. We may want\n   # to link the correct mRNA to the correct CDS via the bioperl sub_SeqFeature tree.\n   #\n   # what we would end up with would be\n   #  gene1\n   #    mRNA-a\n   #      CDS-a\n   #    mRNA-b\n   #      CDS-b\n   my @top_sfs = $self->unflatten_groups(-groups=>\\@groups,\n                                         -resolver_method=>$resolver_method,\n\t\t\t\t\t -resolver_tag=>$resolver_tag);\n   \n   # restore settings\n   $self->partonomy($old_partonomy);\n\n   # restore settings\n   $self->structure_type($old_structure_type);\n\n   # modify the original Seq object - the top seqfeatures are now\n   # the top features from each group\n   $seq->remove_SeqFeatures;\n   $seq->add_SeqFeature(@top_sfs);\n\n   # --------- FINISHED UNFLATTENING -------------\n\n   # lets see if there are any post-unflattening tasks we need to do\n\n   \n\n   # INFERRING mRNAs\n   if ($need_to_infer_mRNAs) {\n       if ($self->verbose > 0) {\n\t   printf STDERR \"** INFERRING mRNA from CDS\\n\";\n       }\n       $self->infer_mRNA_from_CDS(-seq=>$seq);\n   }\n\n   # INFERRING exons\n   if ($need_to_infer_exons) {\n\n       # infer exons, one group/gene at a time\n       foreach my $sf (@top_sfs) {\n\t   my @sub_sfs = ($sf, $sf->get_all_SeqFeatures);\n\t   $self->feature_from_splitloc(-features=>\\@sub_sfs);\n       }\n\n       # some exons are stated explicitly; ie there is an \"exon\" feature\n       # most exons are inferred; ie there is a \"mRNA\" feature with\n       # split locations\n       #\n       # if there were exons explicitly stated in the entry, we need to\n       # do two things:\n       #\n       # make sure these exons are consistent with the inferred exons\n       #  (you never know)\n       #\n       # transfer annotation (tag-vals) from the explicit exon to the\n       # new inferred exon\n       if (@removed_exons) {\n\t   my @allfeats = $seq->get_all_SeqFeatures;\n\n\t   # find all the inferred exons that are children of mRNA\n\t   my @mrnas =  grep {$_->primary_tag eq 'mRNA'} @allfeats;\n\t   my @exons =  \n\t     grep {$_->primary_tag eq 'exon'}\n\t       map {$_->get_SeqFeatures} @mrnas;\n\n\t   my %exon_h = (); \t   # index of exons by location;\n\n\t   # there CAN be >1 exon at a location; we can represent these redundantly\n\t   # (ie as a tree, not a graph)\n\t   push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n\t   my @problems = ();      # list of problems;\n\t                           # each problem is a \n\t                           # [$severity, $description] pair\n\t   my $problem = '';\n\t   my ($n_exons, $n_removed_exons) =\n\t     (scalar(keys %exon_h), scalar(@removed_exons));\n\t   foreach my $removed_exon (@removed_exons) {\n\t       my $locstr = $self->_locstr($removed_exon);\n\t       my $inferred_exons = $exon_h{$locstr};\n\t       delete $exon_h{$locstr};\n\t       if ($inferred_exons) {\n\t\t   my %exons_done = ();\n\t\t   foreach my $exon (@$inferred_exons) {\n\n\t\t       # make sure we don't move stuff twice\n\t\t       next if $exons_done{$exon};\n\t\t       $exons_done{$exon} = 1;\n\n\t\t       # we need to tranfer any tag-values from the explicit\n\t\t       # exon to the implicit exon\n\t\t       foreach my $tag ($removed_exon->get_all_tags) {\n\t\t\t   my @vals = $removed_exon->get_tag_values($tag);\n\t\t\t   if (!$exon->can(\"add_tag_value\")) {\n\t\t\t       # I'm puzzled as to what should be done here;\n\t\t\t       # SeqFeatureIs are not necessarily mutable,\n\t\t\t       # but we know that in practice the implementing\n\t\t\t       # class is mutable\n\t\t\t       $self->throw(\"The SeqFeature object does not \".\n\t\t\t\t\t    \"implement add_tag_value()\");\n\t\t\t   }\n\t\t\t   $exon->add_tag_value($tag, @vals);\n\t\t       }\n\t\t   }\n\t       } \n               else {\n                   # no exons inferred at $locstr\n\t\t   push(@problems,\n\t\t\t[1, \n\t\t\t \"there is a conflict with exons; there was an explicitly \".\n\t\t\t \"stated exon with location $locstr, yet I cannot generate \".\n\t\t\t \"this exon from the supplied mRNA locations\\n\"]);\n\t       }\n\t   }\n\t   # do we have any inferred exons left over, that were not\n\t   # covered in the explicit exons?\n\t   if (keys %exon_h) {\n\t       # TODO - we ignore this problem for now\n\t       push(@problems,\n\t\t    [1,\n\t\t     sprintf(\"There are some inferred exons that are not in the \".\n\t\t\t     \"explicit exon list; they are the exons at locations:\\n\".\n\t\t\t     join(\"\\n\", keys %exon_h).\"\\n\")]);\n\t   }\n\n\t   # report any problems\n\t   if (@problems) {\n\t       my $thresh = $self->error_threshold;\n\t       my @bad_problems = grep {$_->[0] > $thresh} @problems;\n\t       if (@bad_problems) {\n\t\t   printf STDERR \"PROBLEM:\\n\";\n\t\t   $self->_write_hier(\\@top_sfs);\n\t\t   # TODO - allow more fine grained control over this\n\t\t   $self->{_problems_reported} = 1;\n\t\t   $self->throw(join(\"\\n\",\n\t\t\t\t     map {\"@$_\"} @bad_problems));\n\t       }\n\t       $self->problem(@$_) foreach @problems;\n\t   }\n       }\n   }    \n   # --- end of inferring exons --\n\n   # return new top level features; this can also \n   # be retrieved via\n   #   $seq->get_SeqFeatures();\n#   return @top_sfs;\n   return $seq->get_SeqFeatures;\n}\n\n# _split_group_if_disconnected([@sfs])\n#\n# as well as having the same group_tag, a group should be spatially\n# connected. if not, then the group should be split into subgroups.\n# this turns out to be necessary in the case of multicopy genes.\n# the standard way to represent these is as spatially disconnected\n# gene models (usually a 'gene' feature and some kind of RNA feature)\n# with the same group tag; the code below will split these into \n# seperate groups, one per copy.\n\nsub _split_group_if_disconnected {\n    my $self = shift;\n    my $group = shift;\n    my @sfs = @$group;\n    my @ranges =\n      Bio::Range->disconnected_ranges(@sfs);\n    my @groups;\n    if (@ranges == 0) {\n\t$self->throw(\"ASSERTION ERROR\");\n    }\n    elsif (@ranges == 1) {\n\t# no need to split the group\n\t@groups = ($group);\n    }\n    else {\n\t# @ranges > 1\n\t# split the group into disconnected ranges\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"GROUP PRE-SPLIT:\\n\";\n\t    $self->_write_group($group, $self->group_tag);\n\t}\n\t@groups =\n\t  map {\n\t      my $range = $_;\n\t      [grep {\n\t\t  $_->intersection($range);\n\t      } @sfs]\n\t  } @ranges;\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"SPLIT GROUPS:\\n\";\n\t    $self->_write_group($_, $self->group_tag) foreach @groups;\t    \n\t}\n    }\n    return @groups;\n}\n\nsub _remove_duplicates_from_group {\n    my $self = shift;\n    my $group = shift;\n\n    # ::: WEIRD BOUNDARY CASE CODE :::\n    # for some reason, there are some gb records with two gene\n    # features for one gene; for example, see ATF14F8.gbk\n    # in the t/data directory\n    #\n    # in this case, we get rid of one of the genes\n\n    my @genes = grep {$_->primary_tag eq 'gene'} @$group;\n    if (@genes > 1) {\n\t# OK, if we look at ATF14F8.gbk we see that some genes\n\t# just exist as a single location, some exist as a multisplit location;\n\t#\n\t# eg\n\n\t#     gene            16790..26395\n\t#                     /gene=\"F14F8_60\"\n\t#     ...\n\t#     gene            complement(join(16790..19855,20136..20912,21378..21497,\n\t#                     21654..21876,22204..22400,22527..23158,23335..23448,\n\t#                     23538..23938,24175..24536,24604..24715,24889..24984,\n\t#                     25114..25171,25257..25329,25544..25589,25900..26018,\n\t#                     26300..26395))\n\t#                     /gene=\"F14F8_60\"\n\n\t# the former is the 'standard' way of representing the gene in genbank;\n\t# the latter is redundant with the CDS entry. So we shall get rid of\n\t# the latter with the following filter\n\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"REMOVING DUPLICATES:\\n\";\n\t}\n\n\t@genes =\n\t  grep {\n\t      my $loc = $_->location;\n\t      if ($loc->isa(\"Bio::Location::SplitLocationI\")) {\n\t\t  my @locs = $loc->each_Location;\t\t  \n\t\t  if (@locs > 1) {\n\t\t      0;\n\t\t  }\n\t\t  else {\n\t\t      1;\n\t\t  }\n\t      }\n\t      else {\n\t\t  1;\n\t      }\n\t  } @genes;\n\n\tif (@genes > 1) {\n\t    # OK, that didn't work. Our only resort is to just pick one at random\n\t    @genes = ($genes[0]);\n\t}\n\tif (@genes) {\n\t    @genes == 1 || $self->throw(\"ASSERTION ERROR\");\n\t    @$group =\n\t      ($genes[0], grep {$_->primary_tag ne 'gene'} @$group);\n\t}\n    }\n    # its a dirty job but someone's gotta do it\n    return;\n}\n\n\n=head2 unflatten_groups\n\n Title   : unflatten_groups\n Usage   :\n Function: iterates over groups, calling unflatten_group() [see below]\n Example :\n Returns : list of Bio::SeqFeatureI objects that are holders\n Args    : see below\n\nArguments\n\n  -groups:          list of list references; inner list is of Bio::SeqFeatureI objects\n                    e.g.  ( [$sf1], [$sf2, $sf3, $sf4], [$sf5, ...], ...)\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_groups{\n   my ($self,@args) = @_;\n   my($groups, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUPS\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   # this is just a simple wrapper for unflatten_group()\n   return \n     map {\n         $self->unflatten_group(-group=>$_,\n                                -resolver_method=>$resolver_method,\n\t\t\t\t-resolver_tag=>$resolver_tag)\n     } @$groups;\n}\n\n=head2 unflatten_group\n\n Title   : unflatten_group\n Usage   :\n Function: nests a group of features into a feature containment hierarchy\n Example :\n Returns : Bio::SeqFeatureI objects that holds other features\n Args    : see below\n\nArguments\n\n  -group:           reference to list of Bio::SeqFeatureI objects\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":1830,"children":[{"line":1831,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"unflatten_group"},{"line":1831,"kind":13,"name":"@args","containerName":"unflatten_group"},{"localvar":"my","name":"$group","definition":"my","containerName":"unflatten_group","line":1833,"kind":13},{"name":"$resolver_method","containerName":"unflatten_group","kind":13,"line":1833},{"containerName":"unflatten_group","name":"$resolver_tag","kind":13,"line":1833},{"line":1834,"kind":13,"name":"$self","containerName":"unflatten_group"},{"line":1834,"kind":12,"containerName":"unflatten_group","name":"_rearrange"},{"name":"@args","containerName":"unflatten_group","kind":13,"line":1838},{"name":"$self","containerName":"unflatten_group","line":1840,"kind":13},{"line":1840,"kind":12,"containerName":"unflatten_group","name":"verbose"},{"kind":13,"line":1842,"name":"$self","containerName":"unflatten_group"},{"containerName":"unflatten_group","name":"_write_group","kind":12,"line":1842},{"line":1842,"kind":13,"containerName":"unflatten_group","name":"$group"},{"name":"$self","containerName":"unflatten_group","line":1842,"kind":13},{"containerName":"unflatten_group","name":"group_tag","line":1842,"kind":12},{"containerName":"unflatten_group","definition":"my","name":"@sfs","localvar":"my","kind":13,"line":1845},{"containerName":"unflatten_group","name":"$group","line":1845,"kind":13},{"kind":13,"line":1848,"containerName":"unflatten_group","name":"$sfs"},{"line":1848,"kind":13,"containerName":"unflatten_group","name":"@sfs"},{"line":1850,"kind":13,"localvar":"my","definition":"my","name":"$partonomy","containerName":"unflatten_group"},{"kind":13,"line":1850,"containerName":"unflatten_group","name":"$self"},{"kind":12,"line":1850,"containerName":"unflatten_group","signature":{"parameters":[{"label":"$self"},{"label":"$sf"},{"label":"@possible_container_sfs"}],"documentation":"","label":"partonomy($self,$sf,@possible_container_sfs)"},"detail":"($self,$sf,@possible_container_sfs)","name":"partonomy","range":{"start":{}}},{"line":1855,"kind":13,"name":"$resolver_method","containerName":"unflatten_group"},{"line":1855,"kind":13,"name":"$resolver_method","containerName":"unflatten_group"},{"kind":13,"line":1870,"name":"$resolver_tag","containerName":"unflatten_group"},{"line":1871,"kind":13,"localvar":"my","containerName":"unflatten_group","name":"$backup_resolver_method","definition":"my"},{"name":"$resolver_method","containerName":"unflatten_group","kind":13,"line":1871},{"containerName":"unflatten_group","name":"$sub","definition":"my","localvar":"my","kind":13,"line":1873},{"localvar":"my","containerName":"unflatten_group","definition":"my","name":"$self","line":1875,"kind":13},{"name":"$sf","containerName":"unflatten_group","line":1875,"kind":13},{"name":"@possible_container_sfs","containerName":"unflatten_group","kind":13,"line":1875},{"kind":13,"line":1876,"name":"@container_sfs","definition":"my","containerName":"unflatten_group","localvar":"my"},{"kind":13,"line":1877,"name":"$sf","containerName":"unflatten_group"},{"kind":12,"line":1877,"name":"has_tag","containerName":"unflatten_group"},{"containerName":"unflatten_group","name":"$resolver_tag","line":1877,"kind":13},{"localvar":"my","definition":"my","name":"$resolver_tagval","containerName":"unflatten_group","line":1878,"kind":13},{"name":"$sf","containerName":"unflatten_group","kind":13,"line":1878},{"name":"get_tag_values","containerName":"unflatten_group","kind":12,"line":1878},{"kind":13,"line":1878,"containerName":"unflatten_group","name":"$resolver_tag"},{"line":1882,"kind":13,"containerName":"unflatten_group","name":"@container_sfs"},{"kind":13,"line":1884,"name":"$match","definition":"my","containerName":"unflatten_group","localvar":"my"},{"line":1885,"kind":13,"containerName":"unflatten_group","name":"$self"},{"containerName":"unflatten_group","name":"_write_sf","kind":12,"line":1885},{"line":1885,"kind":13,"containerName":"unflatten_group","name":"$self"},{"containerName":"unflatten_group","name":"verbose","kind":12,"line":1885},{"kind":13,"line":1886,"name":"$tag","definition":"my","containerName":"unflatten_group","localvar":"my"},{"line":1887,"kind":12,"name":"has_tag","containerName":"unflatten_group"},{"containerName":"unflatten_group","name":"$tag","line":1887,"kind":13},{"containerName":"unflatten_group","name":"@vals","definition":"my","localvar":"my","kind":13,"line":1888},{"name":"get_tag_values","containerName":"unflatten_group","line":1889,"kind":12},{"name":"$tag","containerName":"unflatten_group","kind":13,"line":1889},{"name":"$resolver_tagval","containerName":"unflatten_group","kind":13,"line":1890},{"kind":13,"line":1890,"name":"@vals","containerName":"unflatten_group"},{"line":1891,"kind":13,"name":"$match","containerName":"unflatten_group"},{"line":1896,"kind":13,"containerName":"unflatten_group","name":"$match"},{"containerName":"unflatten_group","name":"@possible_container_sfs","line":1897,"kind":13},{"line":1900,"kind":13,"containerName":"unflatten_group","name":"$backup_resolver_method"},{"line":1900,"kind":13,"containerName":"unflatten_group","name":"$sf"},{"kind":13,"line":1900,"containerName":"unflatten_group","name":"@possible_container_sfs"},{"line":1902,"kind":13,"containerName":"unflatten_group","name":"@container_sfs"},{"name":"$resolver_method","containerName":"unflatten_group","line":1904,"kind":13},{"kind":13,"line":1904,"name":"$sub","containerName":"unflatten_group"},{"containerName":"unflatten_group","name":"$self","kind":13,"line":1908},{"containerName":"unflatten_group","name":"throw","line":1908,"kind":12},{"name":"$resolver_tag","containerName":"unflatten_group","line":1908,"kind":13},{"line":1919,"kind":13,"localvar":"my","name":"@top_sfs","definition":"my","containerName":"unflatten_group"},{"line":1921,"kind":13,"containerName":"unflatten_group","name":"$self"},{"containerName":"unflatten_group","name":"get_container_type","kind":12,"line":1921},{"line":1921,"kind":12,"containerName":"unflatten_group","name":"primary_tag"},{"kind":13,"line":1922,"name":"@sfs","containerName":"unflatten_group"},{"line":1925,"kind":13,"name":"@top_sfs","containerName":"unflatten_group"},{"kind":13,"line":1926,"containerName":"unflatten_group","name":"$self"},{"kind":12,"line":1926,"containerName":"unflatten_group","name":"_write_group"},{"name":"$group","containerName":"unflatten_group","line":1926,"kind":13},{"kind":13,"line":1926,"name":"$self","containerName":"unflatten_group"},{"line":1926,"kind":12,"name":"group_tag","containerName":"unflatten_group"},{"name":"$self","containerName":"unflatten_group","line":1928,"kind":13},{"line":1928,"kind":12,"containerName":"unflatten_group","name":"_write_sf"},{"kind":13,"line":1928,"containerName":"unflatten_group","name":"@top_sfs"},{"kind":13,"line":1929,"containerName":"unflatten_group","name":"$self"},{"line":1929,"kind":12,"containerName":"unflatten_group","name":"throw"},{"kind":13,"line":1931,"containerName":"unflatten_group","definition":"my","name":"$top_sf","localvar":"my"},{"name":"$top_sfs","containerName":"unflatten_group","line":1931,"kind":13},{"name":"%sfs_by_type","definition":"my","containerName":"unflatten_group","localvar":"my","kind":13,"line":1934},{"kind":13,"line":1935,"name":"$sf","definition":"my","containerName":"unflatten_group","localvar":"my"},{"line":1935,"kind":13,"containerName":"unflatten_group","name":"@sfs"},{"line":1936,"kind":13,"name":"$sfs_by_type","containerName":"unflatten_group"},{"name":"$sf","containerName":"unflatten_group","kind":13,"line":1936},{"kind":12,"line":1936,"containerName":"unflatten_group","name":"primary_tag"},{"kind":13,"line":1936,"name":"$sf","containerName":"unflatten_group"}]},{"name":"_resolve_container_for_sf","line":1855,"kind":12},{"definition":"my","name":"%container","containerName":null,"localvar":"my","kind":13,"line":1943},{"containerName":null,"definition":"my","name":"%unresolved","localvar":"my","kind":13,"line":1966},{"localvar":"my","containerName":null,"definition":"my","name":"%idxsf","line":1972,"kind":13},{"kind":13,"line":1972,"name":"@sfs","containerName":null},{"line":1974,"kind":13,"localvar":"my","containerName":null,"name":"$sf","definition":"my"},{"line":1974,"kind":13,"containerName":null,"name":"@sfs"},{"localvar":"my","definition":"my","name":"$type","containerName":null,"line":1975,"kind":13},{"name":"$sf","containerName":null,"kind":13,"line":1975},{"line":1975,"kind":12,"name":"primary_tag","containerName":"main::"},{"containerName":null,"name":"$container_type","definition":"my","localvar":"my","kind":13,"line":1978},{"kind":13,"line":1979,"name":"$self","containerName":null},{"kind":12,"line":1979,"name":"get_container_type","containerName":"main::"},{"name":"$type","containerName":null,"line":1979,"kind":13},{"name":"%container_type","containerName":null,"kind":13,"line":1980},{"definition":"my","name":"@possible_container_sfs","containerName":null,"localvar":"my","kind":13,"line":1982},{"kind":13,"line":1983,"containerName":null,"name":"%sfs_by_type"},{"kind":13,"line":1983,"name":"@container_type","containerName":null},{"line":1988,"kind":13,"name":"@possible_container_sfs","containerName":null},{"name":"@possible_container_sfs","containerName":null,"line":1992,"kind":13},{"kind":13,"line":1999,"name":"%container","containerName":null},{"line":1999,"kind":13,"name":"$sf","containerName":null},{"containerName":null,"name":"@possible_container_sfs","kind":13,"line":1999},{"name":"$self","containerName":null,"kind":13,"line":2004},{"containerName":"main::","name":"throw","line":2004,"kind":12},{"line":2004,"kind":13,"containerName":null,"name":"@possible_container_sfs"},{"name":"$sf","containerName":null,"kind":13,"line":2013},{"containerName":"main::","name":"primary_tag","kind":12,"line":2013},{"line":2014,"kind":13,"containerName":null,"name":"$self"},{"name":"problem","containerName":"main::","kind":12,"line":2014},{"name":"$sf","containerName":null,"kind":13,"line":2018},{"name":"$self","containerName":null,"line":2022,"kind":13},{"name":"throw","containerName":"main::","kind":12,"line":2022},{"line":2023,"kind":13,"containerName":null,"name":"$resolver_method"},{"kind":13,"line":2033,"definition":"my","name":"%container_sfh","containerName":null,"localvar":"my"},{"name":"$resolver_method","containerName":null,"kind":13,"line":2034},{"line":2034,"kind":13,"name":"$self","containerName":null},{"kind":13,"line":2034,"containerName":null,"name":"$sf"},{"containerName":null,"name":"@possible_container_sfs","line":2034,"kind":13},{"line":2035,"kind":13,"name":"%container_sfh","containerName":null},{"kind":13,"line":2036,"name":"$self","containerName":null},{"name":"problem","containerName":"main::","line":2036,"kind":12},{"containerName":null,"name":"$sf","line":2040,"kind":13},{"kind":13,"line":2042,"name":"%container","containerName":null},{"containerName":null,"name":"$sf","line":2042,"kind":13},{"containerName":null,"name":"$top_sf","kind":13,"line":2042},{"localvar":"my","definition":"my","name":"$jsf","containerName":null,"line":2049,"kind":13},{"name":"%container_sfh","containerName":null,"kind":13,"line":2049},{"kind":13,"line":2053,"name":"%unresolved","containerName":null},{"containerName":null,"name":"@sf","kind":13,"line":2053},{"kind":13,"line":2054,"containerName":null,"name":"%idxsf"},{"line":2054,"kind":13,"name":"$jsf","containerName":null},{"line":2054,"kind":13,"name":"%container_sfh","containerName":null},{"name":"%jsf","containerName":null,"line":2054,"kind":13},{"kind":13,"line":2074,"containerName":null,"name":"%unresolved"},{"localvar":"my","containerName":null,"definition":"my","name":"%childh","line":2075,"kind":13},{"containerName":null,"name":"%unresolved","kind":13,"line":2075},{"line":2076,"kind":13,"localvar":"my","name":"%parenth","definition":"my","containerName":null},{"line":2076,"kind":13,"name":"$_","containerName":null},{"containerName":null,"name":"%unresolved","line":2076,"kind":13},{"kind":13,"line":2077,"containerName":null,"name":"$self"},{"name":"verbose","containerName":"main::","line":2077,"kind":12},{"line":2079,"kind":13,"name":"%childh","containerName":null},{"name":"%parenth","containerName":null,"line":2079,"kind":13},{"kind":13,"line":2099,"name":"$self","containerName":null},{"name":"verbose","containerName":"main::","kind":12,"line":2099},{"name":"%unresolved","containerName":null,"kind":13,"line":2099},{"containerName":null,"name":"$childsf","definition":"my","localvar":"my","kind":13,"line":2101},{"name":"%unresolved","containerName":null,"line":2101,"kind":13},{"localvar":"my","definition":"my","name":"@poss","containerName":null,"line":2102,"kind":13},{"containerName":null,"name":"%unresolved","line":2102,"kind":13},{"name":"$childsf","containerName":null,"kind":13,"line":2102},{"line":2103,"kind":13,"localvar":"my","name":"$p","definition":"my","containerName":null},{"containerName":null,"name":"@poss","line":2103,"kind":13},{"line":2104,"kind":13,"localvar":"my","definition":"my","name":"$parentsf","containerName":null},{"containerName":null,"name":"@p","line":2104,"kind":13},{"name":"$childsf","containerName":null,"line":2105,"kind":13},{"line":2105,"kind":13,"name":"%idxsf","containerName":null},{"kind":13,"line":2105,"name":"$childsf","containerName":null},{"kind":13,"line":2106,"name":"@clabels","definition":"my","containerName":null,"localvar":"my"},{"line":2106,"kind":13,"containerName":null,"name":"$childsf"},{"line":2106,"kind":12,"containerName":"main::","name":"get_tagset_values"},{"containerName":null,"name":"@plabels","definition":"my","localvar":"my","kind":13,"line":2107},{"kind":13,"line":2107,"name":"$parentsf","containerName":null},{"kind":12,"line":2107,"containerName":"main::","name":"get_tagset_values"},{"containerName":null,"name":"@poss","kind":13,"line":2110},{"localvar":"my","name":"$unresolved_problem_reported","definition":"my","containerName":null,"line":2123,"kind":13},{"containerName":null,"name":"%unresolved","line":2124,"kind":13},{"definition":"my","name":"$new_pairs","containerName":null,"localvar":"my","kind":13,"line":2125},{"kind":13,"line":2126,"containerName":null,"name":"$self"},{"line":2126,"kind":12,"name":"find_best_matches","containerName":"main::"},{"line":2126,"kind":13,"containerName":null,"name":"%unresolved"},{"line":2127,"kind":13,"name":"%new_pairs","containerName":null},{"line":2128,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$g"},{"containerName":null,"name":"@sfs","line":2128,"kind":13},{"kind":12,"line":2128,"containerName":"main::","name":"get_tagset_values"},{"containerName":null,"name":"$self","line":2128,"kind":13},{"line":2128,"kind":12,"name":"group_tag","containerName":"main::"},{"containerName":null,"name":"$self","kind":13,"line":2129},{"line":2129,"kind":12,"name":"problem","containerName":"main::"},{"name":"@new_pairs","containerName":null,"line":2131,"kind":13},{"line":2132,"kind":13,"containerName":null,"name":"$unresolved_problem_reported"},{"kind":13,"line":2134,"containerName":null,"name":"$pair","definition":"my","localvar":"my"},{"kind":13,"line":2134,"name":"%new_pairs","containerName":null},{"line":2135,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"verbose","line":2135,"kind":12},{"kind":13,"line":2138,"containerName":null,"name":"%container"},{"containerName":null,"name":"@pair","kind":13,"line":2138},{"line":2138,"kind":13,"name":"@pair","containerName":null},{"containerName":null,"name":"%unresolved","kind":13,"line":2139},{"kind":13,"line":2139,"containerName":null,"name":"@pair"},{"containerName":null,"name":"%unresolved","kind":13,"line":2144},{"name":"$self","containerName":null,"line":2145,"kind":13},{"line":2145,"kind":12,"containerName":"main::","name":"throw"},{"containerName":null,"name":"$unresolved_problem_reported","line":2146,"kind":13},{"line":2151,"kind":13,"localvar":"my","name":"@top","definition":"my","containerName":null},{"localvar":"my","name":"$sf","definition":"my","containerName":null,"line":2152,"kind":13},{"line":2152,"kind":13,"name":"@sfs","containerName":null},{"name":"$container_sf","definition":"my","containerName":null,"localvar":"my","kind":13,"line":2153},{"name":"%container","containerName":null,"kind":13,"line":2153},{"containerName":null,"name":"$sf","kind":13,"line":2153},{"containerName":null,"name":"%container_sf","line":2154,"kind":13},{"line":2158,"kind":13,"containerName":null,"name":"$container_sf"},{"kind":12,"line":2158,"name":"contains","containerName":"main::"},{"line":2158,"kind":13,"containerName":null,"name":"%sf"},{"containerName":null,"name":"$container_sf","line":2160,"kind":13},{"name":"add_SeqFeature","containerName":"main::","line":2160,"kind":12},{"containerName":null,"name":"%sf","line":2160,"kind":13},{"containerName":null,"name":"$self","line":2169,"kind":13},{"containerName":"main::","name":"problem","kind":12,"line":2169},{"name":"$container_sf","containerName":null,"kind":13,"line":2173},{"containerName":null,"name":"$sf","kind":13,"line":2174},{"line":2175,"kind":13,"containerName":null,"name":"$container_sf"},{"kind":12,"line":2175,"containerName":"main::","name":"add_SeqFeature"},{"line":2175,"kind":13,"containerName":null,"name":"%sf"},{"containerName":null,"name":"@top","line":2179,"kind":13},{"line":2179,"kind":13,"name":"$sf","containerName":null},{"containerName":null,"name":"@top","kind":13,"line":2182},{"kind":12,"line":2214,"children":[{"kind":13,"line":2215,"containerName":"find_best_matches","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":2216,"name":"$matrix","definition":"my","containerName":"find_best_matches","localvar":"my"},{"localvar":"my","containerName":"find_best_matches","definition":"my","name":"$pairs","line":2217,"kind":13},{"containerName":"find_best_matches","definition":"my","name":"$verbose","localvar":"my","kind":13,"line":2219},{"line":2219,"kind":13,"containerName":"find_best_matches","name":"$self"},{"name":"verbose","containerName":"find_best_matches","kind":12,"line":2219},{"name":"$verbose","containerName":"find_best_matches","kind":13,"line":2221},{"containerName":"find_best_matches","name":"$pairs","line":2222,"kind":13},{"localvar":"my","containerName":"find_best_matches","name":"%selected_children","definition":"my","line":2225,"kind":13},{"containerName":"find_best_matches","name":"$pairs","kind":13,"line":2225},{"definition":"my","name":"%selected_parents","containerName":"find_best_matches","localvar":"my","kind":13,"line":2226},{"kind":13,"line":2226,"name":"$pairs","containerName":"find_best_matches"},{"line":2230,"kind":13,"localvar":"my","name":"%unresolved_parents","definition":"my","containerName":"find_best_matches"},{"line":2231,"kind":13,"localvar":"my","containerName":"find_best_matches","definition":"my","name":"%unresolved"},{"kind":13,"line":2233,"name":"$verbose","containerName":"find_best_matches"},{"kind":13,"line":2234,"name":"$matrix","containerName":"find_best_matches"},{"line":2236,"kind":13,"name":"$selected_children","containerName":"find_best_matches"},{"localvar":"my","name":"@parents","definition":"my","containerName":"find_best_matches","line":2240,"kind":13},{"kind":13,"line":2242,"containerName":"find_best_matches","name":"$selected_parents"},{"kind":13,"line":2243,"name":"$matrix","containerName":"find_best_matches"},{"name":"$unresolved_parents","containerName":"find_best_matches","line":2244,"kind":13},{"line":2244,"kind":13,"name":"@parents","containerName":"find_best_matches"},{"kind":13,"line":2246,"containerName":"find_best_matches","name":"@parents"}],"containerName":"main::","name":"find_best_matches","definition":"sub","range":{"end":{"line":2247,"character":9999},"start":{"line":2214,"character":0}}},{"name":"$matrix","containerName":null,"kind":13,"line":2248},{"line":2250,"kind":13,"localvar":"my","containerName":null,"name":"@I","definition":"my"},{"line":2250,"kind":13,"containerName":null,"name":"%unresolved"},{"containerName":null,"name":"$pairs","line":2252,"kind":13},{"containerName":null,"name":"%unresolved_parents","kind":13,"line":2252},{"kind":13,"line":2256,"name":"$pairs","containerName":null},{"containerName":null,"name":"@I","line":2256,"kind":13},{"kind":13,"line":2261,"name":"@I","containerName":null},{"containerName":null,"name":"%unresolved","line":2263,"kind":13},{"name":"$a","containerName":null,"kind":13,"line":2263},{"line":2265,"kind":13,"name":"%unresolved","containerName":null},{"line":2265,"kind":13,"name":"$b","containerName":null},{"line":2266,"kind":13,"name":"@I","containerName":null},{"definition":"my","name":"$csf","containerName":null,"localvar":"my","kind":13,"line":2268},{"containerName":null,"name":"@I","line":2268,"kind":13},{"containerName":null,"definition":"my","name":"@J","localvar":"my","kind":13,"line":2270},{"containerName":null,"name":"%unresolved","line":2270,"kind":13},{"name":"$csf","containerName":null,"line":2270,"kind":13},{"name":"@J","containerName":null,"kind":13,"line":2273},{"containerName":null,"name":"@b","line":2275,"kind":13},{"line":2275,"kind":13,"name":"@a","containerName":null},{"name":"@J","containerName":null,"line":2276,"kind":13},{"localvar":"my","definition":"my","name":"$successful_pairs","containerName":null,"line":2281,"kind":13},{"containerName":null,"name":"$j","definition":"my","localvar":"my","kind":13,"line":2282},{"containerName":null,"name":"@J","kind":13,"line":2282},{"containerName":null,"name":"$psf","definition":"my","localvar":"my","kind":13,"line":2283},{"containerName":null,"name":"$score","kind":13,"line":2283},{"containerName":null,"name":"$j","line":2283,"kind":13},{"containerName":null,"definition":"my","name":"$bad","localvar":"my","kind":13,"line":2286},{"localvar":"my","name":"$sf","definition":"my","containerName":null,"line":2287,"kind":13},{"containerName":null,"name":"@I","kind":13,"line":2287},{"containerName":null,"name":"$psf","kind":13,"line":2288},{"line":2288,"kind":13,"name":"%unresolved","containerName":null},{"line":2288,"kind":13,"containerName":null,"name":"%sf"},{"line":2290,"kind":13,"name":"$bad","containerName":null},{"name":"%bad","containerName":null,"line":2294,"kind":13},{"localvar":"my","name":"@pair","definition":"my","containerName":null,"line":2295,"kind":13},{"kind":13,"line":2295,"name":"$csf","containerName":null},{"containerName":null,"name":"$psf","kind":13,"line":2295},{"line":2296,"kind":13,"localvar":"my","containerName":null,"name":"@new_pairs","definition":"my"},{"containerName":null,"name":"$pairs","kind":13,"line":2296},{"name":"$pair","containerName":null,"kind":13,"line":2296},{"name":"$set","definition":"my","containerName":null,"localvar":"my","kind":13,"line":2297},{"line":2297,"kind":13,"name":"$self","containerName":null},{"name":"find_best_matches","containerName":"main::","kind":12,"line":2297},{"containerName":null,"name":"$matrix","line":2297,"kind":13},{"kind":13,"line":2297,"name":"$new_pairs","containerName":null},{"line":2298,"kind":13,"name":"%set","containerName":null},{"name":"$successful_pairs","containerName":null,"kind":13,"line":2299},{"containerName":null,"name":"$set","line":2299,"kind":13},{"containerName":null,"name":"$successful_pairs","kind":13,"line":2305},{"line":2305,"kind":13,"name":"$successful_pairs","containerName":null},{"line":2315,"children":[{"containerName":"_write_group","definition":"my","name":"$self","localvar":"my","kind":13,"line":2316},{"line":2317,"kind":13,"localvar":"my","containerName":"_write_group","name":"$group","definition":"my"},{"localvar":"my","name":"$group_tag","definition":"my","containerName":"_write_group","line":2318,"kind":13},{"localvar":"my","name":"$f","definition":"my","containerName":"_write_group","line":2320,"kind":13},{"line":2320,"kind":13,"containerName":"_write_group","name":"$group"},{"kind":13,"line":2321,"name":"$label","definition":"my","containerName":"_write_group","localvar":"my"},{"kind":13,"line":2322,"name":"$f","containerName":"_write_group"},{"line":2322,"kind":12,"containerName":"_write_group","name":"has_tag"},{"containerName":"_write_group","name":"$group_tag","kind":13,"line":2322},{"name":"$label","containerName":"_write_group","kind":13,"line":2323},{"containerName":"_write_group","name":"$f","line":2323,"kind":13},{"kind":12,"line":2323,"containerName":"_write_group","name":"get_tag_values"},{"name":"$group_tag","containerName":"_write_group","line":2323,"kind":13},{"name":"$self","containerName":"_write_group","line":2325,"kind":13},{"name":"verbose","containerName":"_write_group","line":2325,"kind":12},{"containerName":"_write_group","name":"$label","kind":13,"line":2327},{"kind":12,"line":2329,"containerName":"_write_group","name":"primary_tag"},{"line":2329,"kind":13,"name":"$group","containerName":"_write_group"}],"kind":12,"range":{"end":{"line":2332,"character":9999},"start":{"character":0,"line":2315}},"containerName":"main::","definition":"sub","name":"_write_group"},{"range":{"start":{"line":2334,"character":0},"end":{"character":9999,"line":2339}},"name":"_write_sf","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_write_sf","line":2335,"kind":13},{"containerName":"_write_sf","definition":"my","name":"$sf","localvar":"my","kind":13,"line":2336},{"kind":13,"line":2337,"containerName":"_write_sf","name":"$sf"},{"containerName":"_write_sf","name":"primary_tag","line":2337,"kind":12}],"line":2334,"kind":12},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_write_sf_detail","line":2342,"kind":13},{"kind":13,"line":2343,"name":"$sf","definition":"my","containerName":"_write_sf_detail","localvar":"my"},{"line":2344,"kind":13,"name":"$sf","containerName":"_write_sf_detail"},{"containerName":"_write_sf_detail","name":"primary_tag","kind":12,"line":2344},{"line":2345,"kind":13,"localvar":"my","name":"@locs","definition":"my","containerName":"_write_sf_detail"},{"line":2345,"kind":13,"name":"$sf","containerName":"_write_sf_detail"},{"containerName":"_write_sf_detail","name":"location","kind":12,"line":2345},{"line":2345,"kind":12,"name":"each_Location","containerName":"_write_sf_detail"},{"containerName":"_write_sf_detail","name":"start","line":2346,"kind":12},{"line":2346,"kind":12,"name":"end","containerName":"_write_sf_detail"},{"line":2346,"kind":12,"containerName":"_write_sf_detail","name":"strand"},{"line":2346,"kind":13,"containerName":"_write_sf_detail","name":"@locs"}],"line":2341,"kind":12,"range":{"start":{"character":0,"line":2341},"end":{"line":2348,"character":9999}},"name":"_write_sf_detail","definition":"sub","containerName":"main::"},{"kind":12,"line":2350,"children":[{"line":2351,"kind":13,"localvar":"my","containerName":"_write_hier","definition":"my","name":"$self"},{"definition":"my","name":"@sfs","containerName":"_write_hier","localvar":"my","kind":13,"line":2352}],"containerName":"main::","definition":"sub","name":"_write_hier","range":{"start":{"line":2350,"character":0},"end":{"line":2352,"character":9999}}},{"name":"shift","line":2352,"kind":12},{"localvar":"my","containerName":null,"name":"$indent","definition":"my","line":2353,"kind":13},{"line":2354,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"verbose","kind":12,"line":2354},{"line":2355,"kind":13,"localvar":"my","name":"$sf","definition":"my","containerName":null},{"kind":13,"line":2355,"name":"@sfs","containerName":null},{"localvar":"my","name":"$label","definition":"my","containerName":null,"line":2356,"kind":13},{"name":"$sf","containerName":null,"kind":13,"line":2357},{"name":"has_tag","containerName":"main::","kind":12,"line":2357},{"name":"$label","containerName":null,"line":2358,"kind":13},{"containerName":null,"name":"$sf","line":2358,"kind":13},{"kind":12,"line":2358,"name":"get_tag_values","containerName":"main::"},{"name":"$indent","containerName":null,"kind":13,"line":2360},{"kind":13,"line":2360,"name":"$sf","containerName":null},{"line":2360,"kind":12,"name":"primary_tag","containerName":"main::"},{"line":2361,"kind":13,"localvar":"my","definition":"my","name":"@sub_sfs","containerName":null},{"line":2361,"kind":13,"name":"$sf","containerName":null},{"name":"sub_SeqFeature","containerName":"main::","kind":12,"line":2361},{"containerName":null,"name":"$self","line":2362,"kind":13},{"kind":12,"line":2362,"name":"_write_hier","containerName":"main::"},{"kind":13,"line":2362,"name":"@sub_sfs","containerName":null},{"name":"$indent","containerName":null,"line":2362,"kind":13},{"name":"_resolve_container_for_sf","range":{"end":{"character":9999,"line":2408},"start":{"character":0,"line":2373}},"containerName":"main::","definition":"sub","detail":"($self,$sf,@possible_container_sfs)","signature":{"label":"_resolve_container_for_sf($self,$sf,@possible_container_sfs)","documentation":" returns all possible containers for an SF based\n on splice site coordinates; splice site coords\n must be contained","parameters":[{"label":"$self"},{"label":"$sf"},{"label":"@possible_container_sfs"}]},"kind":12,"line":2373,"children":[{"kind":13,"line":2374,"definition":"my","name":"$self","containerName":"_resolve_container_for_sf","localvar":"my"},{"containerName":"_resolve_container_for_sf","name":"$sf","kind":13,"line":2374},{"line":2374,"kind":13,"name":"@possible_container_sfs","containerName":"_resolve_container_for_sf"},{"line":2376,"kind":13,"localvar":"my","containerName":"_resolve_container_for_sf","definition":"my","name":"@coords"},{"kind":13,"line":2376,"containerName":"_resolve_container_for_sf","name":"$self"},{"name":"_get_splice_coords_for_sf","containerName":"_resolve_container_for_sf","line":2376,"kind":12},{"containerName":"_resolve_container_for_sf","name":"$sf","line":2376,"kind":13},{"line":2377,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"_resolve_container_for_sf"},{"line":2377,"kind":13,"containerName":"_resolve_container_for_sf","name":"$sf"},{"name":"start","containerName":"_resolve_container_for_sf","kind":12,"line":2377},{"definition":"my","name":"$end","containerName":"_resolve_container_for_sf","localvar":"my","kind":13,"line":2378},{"line":2378,"kind":13,"name":"$sf","containerName":"_resolve_container_for_sf"},{"containerName":"_resolve_container_for_sf","name":"end","kind":12,"line":2378},{"line":2379,"kind":13,"localvar":"my","name":"$splice_uniq_str","definition":"my","containerName":"_resolve_container_for_sf"},{"containerName":"_resolve_container_for_sf","name":"@sf_score_pairs","definition":"my","localvar":"my","kind":13,"line":2381},{"kind":13,"line":2384,"name":"@possible_container_sfs","containerName":"_resolve_container_for_sf"},{"line":2385,"kind":13,"localvar":"my","containerName":"_resolve_container_for_sf","name":"@container_coords","definition":"my"},{"containerName":"_resolve_container_for_sf","name":"$self","kind":13,"line":2385},{"containerName":"_resolve_container_for_sf","name":"_get_splice_coords_for_sf","line":2385,"kind":12},{"containerName":"_resolve_container_for_sf","name":"$inside","definition":"my","localvar":"my","kind":13,"line":2386},{"containerName":"_resolve_container_for_sf","name":"$splice_uniq_str","line":2387,"kind":13},{"kind":13,"line":2388,"containerName":"_resolve_container_for_sf","name":"$splice_uniq_str"},{"name":"$inside","containerName":"_resolve_container_for_sf","kind":13,"line":2389},{"kind":12,"line":2391,"containerName":"_resolve_container_for_sf","name":"start"},{"containerName":"_resolve_container_for_sf","name":"$start","kind":13,"line":2391},{"name":"end","containerName":"_resolve_container_for_sf","kind":12,"line":2391},{"line":2391,"kind":13,"containerName":"_resolve_container_for_sf","name":"$end"},{"name":"$inside","containerName":"_resolve_container_for_sf","kind":13,"line":2392},{"kind":13,"line":2395,"name":"$self","containerName":"_resolve_container_for_sf"},{"kind":12,"line":2395,"name":"verbose","containerName":"_resolve_container_for_sf"},{"kind":13,"line":2398,"name":"$inside","containerName":"_resolve_container_for_sf"},{"definition":"my","name":"$score","containerName":"_resolve_container_for_sf","localvar":"my","kind":13,"line":2400},{"name":"@coords","containerName":"_resolve_container_for_sf","line":2401,"kind":13},{"kind":13,"line":2401,"containerName":"_resolve_container_for_sf","name":"@container_coords"},{"kind":13,"line":2402,"name":"@sf_score_pairs","containerName":"_resolve_container_for_sf"},{"containerName":"_resolve_container_for_sf","name":"$score","kind":13,"line":2403},{"kind":13,"line":2407,"name":"@sf_score_pairs","containerName":"_resolve_container_for_sf"}]},{"kind":12,"line":2410,"children":[{"containerName":"_get_splice_coords_for_sf","name":"$self","definition":"my","localvar":"my","kind":13,"line":2411},{"localvar":"my","name":"$sf","definition":"my","containerName":"_get_splice_coords_for_sf","line":2412,"kind":13},{"localvar":"my","name":"@locs","definition":"my","containerName":"_get_splice_coords_for_sf","line":2414,"kind":13},{"containerName":"_get_splice_coords_for_sf","name":"$sf","kind":13,"line":2414},{"line":2414,"kind":12,"name":"location","containerName":"_get_splice_coords_for_sf"},{"kind":13,"line":2415,"containerName":"_get_splice_coords_for_sf","name":"$sf"},{"line":2415,"kind":12,"containerName":"_get_splice_coords_for_sf","name":"location"},{"line":2415,"kind":12,"containerName":"_get_splice_coords_for_sf","name":"isa"},{"containerName":"_get_splice_coords_for_sf","name":"@locs","line":2416,"kind":13},{"name":"$sf","containerName":"_get_splice_coords_for_sf","kind":13,"line":2416},{"containerName":"_get_splice_coords_for_sf","name":"location","line":2416,"kind":12},{"kind":12,"line":2416,"containerName":"_get_splice_coords_for_sf","name":"each_Location"},{"containerName":"_get_splice_coords_for_sf","definition":"my","name":"@coords","localvar":"my","kind":13,"line":2426},{"kind":12,"line":2426,"containerName":"_get_splice_coords_for_sf","name":"start"},{"line":2426,"kind":12,"name":"end","containerName":"_get_splice_coords_for_sf"},{"name":"@locs","containerName":"_get_splice_coords_for_sf","line":2426,"kind":13},{"name":"@coords","containerName":"_get_splice_coords_for_sf","kind":13,"line":2429},{"line":2430,"kind":13,"containerName":"_get_splice_coords_for_sf","name":"@coords"},{"name":"@coords","containerName":"_get_splice_coords_for_sf","kind":13,"line":2431}],"containerName":"main::","name":"_get_splice_coords_for_sf","definition":"sub","range":{"end":{"character":9999,"line":2432},"start":{"line":2410,"character":0}}},{"line":2454,"children":[{"line":2455,"kind":13,"localvar":"my","containerName":"feature_from_splitloc","name":"$self","definition":"my"},{"name":"@args","containerName":"feature_from_splitloc","kind":13,"line":2455},{"localvar":"my","containerName":"feature_from_splitloc","name":"$sf","definition":"my","line":2457,"kind":13},{"kind":13,"line":2457,"containerName":"feature_from_splitloc","name":"$seq"},{"name":"$sfs","containerName":"feature_from_splitloc","kind":13,"line":2457},{"line":2458,"kind":13,"containerName":"feature_from_splitloc","name":"$self"},{"containerName":"feature_from_splitloc","name":"_rearrange","line":2458,"kind":12},{"name":"@args","containerName":"feature_from_splitloc","kind":13,"line":2462},{"localvar":"my","containerName":"feature_from_splitloc","name":"@sfs","definition":"my","line":2463,"kind":13},{"containerName":"feature_from_splitloc","name":"$sfs","kind":13,"line":2463}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'\n\n\n\n\nsub unflatten_seq{\n   my ($self,@args) = @_;\n\n    my($seq, $resolver_method, $group_tag, $partonomy, \n       $structure_type, $resolver_tag, $use_magic) =\n\t$self->_rearrange([qw(SEQ\n                              RESOLVER_METHOD\n                              GROUP_TAG\n                              PARTONOMY\n\t\t\t      STRUCTURE_TYPE\n\t\t\t      RESOLVER_TAG\n\t\t\t      USE_MAGIC\n\t\t\t     )],\n                          @args);\n\n   # seq we want to unflatten\n   $seq = $seq || $self->seq;\n\n\n   # prevent bad argument combinations\n   if ($partonomy &&\n       defined($structure_type)) {\n       $self->throw(\"You cannot set both -partonomy and -structure_type\\n\".\n\t\t    \"(the former is implied by the latter)\");\n   }\n\n   # remember the current value of partonomy, to reset later\n   my $old_partonomy = $self->partonomy;\n   $self->partonomy($partonomy) if defined $partonomy;\n\n   # remember old structure_type\n   my $old_structure_type = $self->structure_type;\n   $self->structure_type($structure_type) if defined $structure_type;\n\n   # if we are sourcing our data from genbank, all the\n   # features should be flat (eq no sub_SeqFeatures)\n   my @flat_seq_features = $seq->get_SeqFeatures;\n   my @all_seq_features = $seq->get_all_SeqFeatures;\n\n   # sanity checks\n   if (@all_seq_features > @flat_seq_features) {\n       $self->throw(\"It looks as if this sequence has already been unflattened\");\n   }\n   if (@all_seq_features < @flat_seq_features) {\n       $self->throw(\"ASSERTION ERROR: something is seriously wrong with your features\");\n   }\n\n   # tag for ungrouping; usually /gene or /locus_tag\n   #     for example:        /gene=\"foo\"\n   $group_tag = $group_tag || $self->group_tag;\n   if ($use_magic) {\n       # use magic to guess the group tag\n       my @sfs_with_locus_tag =\n\t grep {$_->has_tag(\"locus_tag\")} @flat_seq_features;\n       my @sfs_with_gene_tag =\n\t grep {$_->has_tag(\"gene\")} @flat_seq_features;\n       my @sfs_with_product_tag =\n\t grep {$_->has_tag(\"product\")} @flat_seq_features;\n\t \n#        if ($group_tag && $self->{'trust_grouptag'}) { # dgg suggestion\n# \n#         }\n#        elsif\n       if (@sfs_with_locus_tag) {\n        # dgg note: would like to -use_magic with -group_tag = 'gene' for ensembl genomes\n        # where ensembl gene FT have both /locus_tag and /gene, but mRNA, CDS have /gene only\n\t   if ($group_tag && $group_tag ne 'locus_tag') {\n\t       $self->throw(\"You have explicitly set group_tag to be '$group_tag'\\n\".\n\t\t\t    \"However, I detect that some features use /locus_tag\\n\".\n\t\t\t    \"I believe that this is the correct group_tag to use\\n\".\n\t\t\t    \"You can resolve this by either NOT setting -group_tag\\n\".\n\t\t\t    \"OR you can unset -use_magic to regain control\");\n\t   }\n\n\t   # use /locus_tag instead of /gene tag for grouping\n\t   # see GenBank entry AE003677 (version 3) for an example\n\t   $group_tag = 'locus_tag';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n       }\n\n       # on rare occasions, records will have no /gene or /locus_tag\n       # but it WILL have /product tags. These serve the same purpose\n       # for grouping. For an example, see AY763288 (also in t/data)\n       if (@sfs_with_locus_tag==0 &&\n           @sfs_with_gene_tag==0 &&\n           @sfs_with_product_tag>0 &&\n           !$group_tag) {\n\t   $group_tag = 'product';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n           \n       }\n   }\n   if (!$group_tag) {\n       $group_tag = 'gene';\n   }\n\n   # ------------------------------\n   # GROUP FEATURES using $group_tag\n   #     collect features into unstructured groups\n   # ------------------------------\n\n   # -------------\n   # we want to generate a list of groups;\n   # each group is a list of SeqFeatures; this\n   # group probably (but not necessarily)\n   # corresponds to a gene model.\n   #\n   # this array will look something like this:\n   # ([$f1], [$f2, $f3, $f4], ...., [$f97, $f98, $f99])\n   #\n   # there are also 'singleton' groups, with one member.\n   # for instance, the 'source' feature is in a singleton group;\n   # the same with others such as 'misc_feature'\n   my @groups = ();\n   # -------------\n\n   # --------------------\n   # we hope that the genbank record allows us to group by some grouping\n   # tag.\n   # for instance, most of the time a gene model can be grouped using\n   # the gene tag - that is where you see\n   #                    /gene=\"foo\"\n   # in a genbank record\n   # --------------------\n   \n   # keep an index of groups by their\n   # grouping tag\n   my %group_by_tag = ();\n   \n\n   # iterate through all features, putting them into groups\n   foreach my $sf (@flat_seq_features) {\n       if (!$sf->has_tag($group_tag)) {\n\t   # SINGLETON\n           # this is an ungroupable feature;\n           # add it to a group of its own\n           push(@groups, [$sf]);\n       }\n       else {\n\t   # NON-SINGLETON\n           my @group_tagvals = $sf->get_tag_values($group_tag);\n           if (@group_tagvals > 1) {\n\t       # sanity check:\n               # currently something can only belong to one group\n               $self->problem(2,\n\t\t\t      \">1 value for /$group_tag: @group_tagvals\\n\".\n\t\t\t      \"At this time this module is not equipped to handle this adequately\", $sf);\n           }\n\t   # get value of group tag\n           my $gtv = shift @group_tagvals;\n           $gtv || $self->throw(\"Empty /$group_tag vals not allowed!\");\n\n           # is this a new group?\n           my $group = $group_by_tag{$gtv};\n           if ($group) {\n               # this group has been encountered before - add current\n               # sf to the end of the group\n               push(@$group, $sf);\n           }\n           else {\n               # new group; add to index and create new group\n               $group = [$sf];  # currently one member; probably more to come\n               $group_by_tag{$gtv} = $group;\n               push(@groups, $group);\n           }\n       }\n   }\n   \n   # as well as having the same group_tag, a group should be spatially\n   # connected. if not, then the group should be split into subgroups.\n   # this turns out to be necessary in the case of multicopy genes.\n   # the standard way to represent these is as spatially disconnected\n   # gene models (usually a 'gene' feature and some kind of RNA feature)\n   # with the same group tag; the code below will split these into \n   # seperate groups, one per copy.\n   @groups = map { $self->_split_group_if_disconnected($_) } @groups;\n\n   # remove any duplicates; most of the time the method below has\n   # no effect. there are some unusual genbank records for which\n   # duplicate removal is necessary. see the comments in the\n   # _remove_duplicates_from_group() method if you want to know\n   # the ugly details\n   foreach my $group (@groups) {\n       $self->_remove_duplicates_from_group($group);\n   }\n\n   # -\n\n   # PSEUDOGENES, PSEUDOEXONS AND PSEUDOINTRONS\n   # these are indicated with the /pseudo tag\n   # these are mapped to a different type; they should NOT\n   # be treated as normal genes\n   foreach my $sf (@all_seq_features) {\n       if ($sf->has_tag('pseudo')) {\n           my $type = $sf->primary_tag;\n           # SO type is typically the same as the normal\n           # type but preceeded by \"pseudo\"\n           if ($type eq 'misc_RNA' || $type eq 'mRNA') { \n            # dgg: see TypeMapper; both pseudo mRNA,misc_RNA should be pseudogenic_transcript\n               $sf->primary_tag(\"pseudotranscript\");\n           }\n           else {\n               $sf->primary_tag(\"pseudo$type\");\n           }\n       }\n   }\n   # now some of the post-processing that follows which applies to\n   # genes will NOT be applied to pseudogenes; this is deliberate\n   # for example, gene models are normalised to be gene-transcript-exon\n   # for pseudogenes we leave them as pseudogene-pseudoexon\n\n   # --- MAGIC ---\n   my $need_to_infer_exons = 0;\n   my $need_to_infer_mRNAs = 0;\n   my @removed_exons = ();\n   if ($use_magic) {\n       if (defined($structure_type)) {\n\t   $self->throw(\"Can't combine use_magic AND setting structure_type\");\n       }\n       my $n_introns =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_exons =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_mrnas =\n\t scalar(grep {$_->primary_tag eq 'mRNA'} @flat_seq_features);\n       my $n_mrnas_attached_to_gene =\n\t scalar(grep {$_->primary_tag eq 'mRNA' &&\n\t\t\t$_->has_tag($group_tag)} @flat_seq_features);\n       my $n_cdss =\n\t scalar(grep {$_->primary_tag eq 'CDS'} @flat_seq_features);\n       my $n_rnas =\n\t scalar(grep {$_->primary_tag =~ /RNA/} @flat_seq_features);  \n       # Are there any CDS features in the record?\n       if ($n_cdss > 0) {\n           # YES\n           \n\t   # - a pc gene model should contain at the least a CDS\n\n           # Are there any mRNA features in the record?\n\t   if ($n_mrnas == 0) {\n               # NO mRNAs:\n\t       # looks like structure_type == 1\n\t       $structure_type = 1;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   elsif ($n_mrnas_attached_to_gene == 0) {\n               # $n_mrnas > 0\n               # $n_mrnas_attached_to_gene = 0\n               #\n               # The entries _do_ contain mRNA features,\n               # but none of them are part of a group/gene, i.e. they\n               # are 'floating'\n\n\t       # this is an annoying weird file that has some floating\n\t       # mRNA features; \n\t       # eg ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/\n               \n               if ($self->verbose) {\n                   my @floating_mrnas =\n                     grep {$_->primary_tag eq 'mRNA' &&\n                             !$_->has_tag($group_tag)} @flat_seq_features;\n                   printf STDERR \"Unattached mRNAs:\\n\";\n                   foreach my $mrna (@floating_mrnas) {\n                       $self->_write_sf_detail($mrna);\n                   }\n                   printf STDERR \"Don't know how to deal with these; filter at source?\\n\";\n               }\n\n\t       foreach (@flat_seq_features) {\n\t\t   if ($_->primary_tag eq 'mRNA') {\n\t\t       # what should we do??\n\t\t       \n\t\t       # I think for pombe we just have to filter\n\t\t       # out bogus mRNAs prior to starting\n\t\t   }\n\t       }\n\n\t       # looks like structure_type == 2\n\t       $structure_type = 2;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   else {\n\t   }\n\n\t   # we always infer exons in magic mode\n\t   $need_to_infer_exons = 1;\n       }\n       else {\n\t   # this doesn't seem to be any kind of protein coding gene model\n\t   if ( $n_rnas > 0 ) {\n\t       $need_to_infer_exons = 1;\n\t   }\n       }\n\n       if ($need_to_infer_exons) {\n\t   # remove exons and introns from group -\n\t   # we will infer exons later, and we\n\t   # can always infer introns from exons\n\t   foreach my $group (@groups) {\n\t       @$group = \n\t\t grep {\n\t\t     my $type = $_->primary_tag();\n\t\t     if ($type eq 'exon') {\n\t\t\t # keep track of all removed exons,\n\t\t\t # so we can do a sanity check later\n\t\t\t push(@removed_exons, $_);\n\t\t     }\n\t\t     $type ne 'exon' && $type ne 'intron'\n\t\t } @$group;\n\t   }\n\t   # get rid of any groups that have zero members\n\t   @groups = grep {scalar(@$_)} @groups;\n       }\n   }\n   # --- END OF MAGIC ---\n   \n   # LOGICAL ASSERTION\n   if (grep {!scalar(@$_)} @groups) {\n       $self->throw(\"ASSERTION ERROR: empty group\");\n   }\n\n   # LOGGING\n   if ($self->verbose > 0) {\n       printf STDERR \"GROUPS:\\n\";\n       foreach my $group (@groups) {\n\t   $self->_write_group($group, $group_tag);\n       }\n   }\n   # -\n\n   # --------- FINISHED GROUPING -------------\n\n\n   # TYPE CONTAINMENT HIERARCHY (aka partonomy)\n   # set the containment hierarchy if desired\n   # see docs for structure_type() method\n   if ($structure_type) {\n       if ($structure_type == 1) {\n\t   $self->partonomy(\n                            {CDS => 'gene',\n                             exon => 'CDS',\n                             intron => 'CDS',\n                            }\n                           );\n       }\n       else {\n\t   $self->throw(\"structure_type $structure_type is currently unknown\");\n       }\n   }\n\n   # see if we have an obvious resolver_tag\n   if ($use_magic) {\n       foreach my $sf (@all_seq_features) {\n\t   if ($sf->has_tag('derived_from')) {\n\t       $resolver_tag = 'derived_from';\n\t   }\n       }\n   }\n\n   if ($use_magic) {\n       # point all feature types without a container type to the root type.\n       #\n       # for example, if we have an unanticipated feature_type, say\n       # 'aberration', this should by default point to the parent 'gene'\n       foreach my $group (@groups) {\n\t   my @sfs = @$group;\n\t   if (@sfs > 1) {\n\t       foreach my $sf (@sfs) {\n\t\t   my $type = $sf->primary_tag;\n\t\t   next if $type eq 'gene';\n\t\t   my $container_type = $self->get_container_type($type);\n\t\t   if (!$container_type) {\n\t\t       $self->partonomy->{$type} = 'gene';\n\t\t   }\n\t       }\n\t   }\n       }\n   }\n\n   # we have done the first part of the unflattening.\n   # we now have a list of groups; each group is a list of seqfeatures.\n   # the actual group itself is flat; we may want to unflatten this further;\n   # for instance, a gene model can contain multiple mRNAs and CDSs. We may want\n   # to link the correct mRNA to the correct CDS via the bioperl sub_SeqFeature tree.\n   #\n   # what we would end up with would be\n   #  gene1\n   #    mRNA-a\n   #      CDS-a\n   #    mRNA-b\n   #      CDS-b\n   my @top_sfs = $self->unflatten_groups(-groups=>\\@groups,\n                                         -resolver_method=>$resolver_method,\n\t\t\t\t\t -resolver_tag=>$resolver_tag);\n   \n   # restore settings\n   $self->partonomy($old_partonomy);\n\n   # restore settings\n   $self->structure_type($old_structure_type);\n\n   # modify the original Seq object - the top seqfeatures are now\n   # the top features from each group\n   $seq->remove_SeqFeatures;\n   $seq->add_SeqFeature(@top_sfs);\n\n   # --------- FINISHED UNFLATTENING -------------\n\n   # lets see if there are any post-unflattening tasks we need to do\n\n   \n\n   # INFERRING mRNAs\n   if ($need_to_infer_mRNAs) {\n       if ($self->verbose > 0) {\n\t   printf STDERR \"** INFERRING mRNA from CDS\\n\";\n       }\n       $self->infer_mRNA_from_CDS(-seq=>$seq);\n   }\n\n   # INFERRING exons\n   if ($need_to_infer_exons) {\n\n       # infer exons, one group/gene at a time\n       foreach my $sf (@top_sfs) {\n\t   my @sub_sfs = ($sf, $sf->get_all_SeqFeatures);\n\t   $self->feature_from_splitloc(-features=>\\@sub_sfs);\n       }\n\n       # some exons are stated explicitly; ie there is an \"exon\" feature\n       # most exons are inferred; ie there is a \"mRNA\" feature with\n       # split locations\n       #\n       # if there were exons explicitly stated in the entry, we need to\n       # do two things:\n       #\n       # make sure these exons are consistent with the inferred exons\n       #  (you never know)\n       #\n       # transfer annotation (tag-vals) from the explicit exon to the\n       # new inferred exon\n       if (@removed_exons) {\n\t   my @allfeats = $seq->get_all_SeqFeatures;\n\n\t   # find all the inferred exons that are children of mRNA\n\t   my @mrnas =  grep {$_->primary_tag eq 'mRNA'} @allfeats;\n\t   my @exons =  \n\t     grep {$_->primary_tag eq 'exon'}\n\t       map {$_->get_SeqFeatures} @mrnas;\n\n\t   my %exon_h = (); \t   # index of exons by location;\n\n\t   # there CAN be >1 exon at a location; we can represent these redundantly\n\t   # (ie as a tree, not a graph)\n\t   push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n\t   my @problems = ();      # list of problems;\n\t                           # each problem is a \n\t                           # [$severity, $description] pair\n\t   my $problem = '';\n\t   my ($n_exons, $n_removed_exons) =\n\t     (scalar(keys %exon_h), scalar(@removed_exons));\n\t   foreach my $removed_exon (@removed_exons) {\n\t       my $locstr = $self->_locstr($removed_exon);\n\t       my $inferred_exons = $exon_h{$locstr};\n\t       delete $exon_h{$locstr};\n\t       if ($inferred_exons) {\n\t\t   my %exons_done = ();\n\t\t   foreach my $exon (@$inferred_exons) {\n\n\t\t       # make sure we don't move stuff twice\n\t\t       next if $exons_done{$exon};\n\t\t       $exons_done{$exon} = 1;\n\n\t\t       # we need to tranfer any tag-values from the explicit\n\t\t       # exon to the implicit exon\n\t\t       foreach my $tag ($removed_exon->get_all_tags) {\n\t\t\t   my @vals = $removed_exon->get_tag_values($tag);\n\t\t\t   if (!$exon->can(\"add_tag_value\")) {\n\t\t\t       # I'm puzzled as to what should be done here;\n\t\t\t       # SeqFeatureIs are not necessarily mutable,\n\t\t\t       # but we know that in practice the implementing\n\t\t\t       # class is mutable\n\t\t\t       $self->throw(\"The SeqFeature object does not \".\n\t\t\t\t\t    \"implement add_tag_value()\");\n\t\t\t   }\n\t\t\t   $exon->add_tag_value($tag, @vals);\n\t\t       }\n\t\t   }\n\t       } \n               else {\n                   # no exons inferred at $locstr\n\t\t   push(@problems,\n\t\t\t[1, \n\t\t\t \"there is a conflict with exons; there was an explicitly \".\n\t\t\t \"stated exon with location $locstr, yet I cannot generate \".\n\t\t\t \"this exon from the supplied mRNA locations\\n\"]);\n\t       }\n\t   }\n\t   # do we have any inferred exons left over, that were not\n\t   # covered in the explicit exons?\n\t   if (keys %exon_h) {\n\t       # TODO - we ignore this problem for now\n\t       push(@problems,\n\t\t    [1,\n\t\t     sprintf(\"There are some inferred exons that are not in the \".\n\t\t\t     \"explicit exon list; they are the exons at locations:\\n\".\n\t\t\t     join(\"\\n\", keys %exon_h).\"\\n\")]);\n\t   }\n\n\t   # report any problems\n\t   if (@problems) {\n\t       my $thresh = $self->error_threshold;\n\t       my @bad_problems = grep {$_->[0] > $thresh} @problems;\n\t       if (@bad_problems) {\n\t\t   printf STDERR \"PROBLEM:\\n\";\n\t\t   $self->_write_hier(\\@top_sfs);\n\t\t   # TODO - allow more fine grained control over this\n\t\t   $self->{_problems_reported} = 1;\n\t\t   $self->throw(join(\"\\n\",\n\t\t\t\t     map {\"@$_\"} @bad_problems));\n\t       }\n\t       $self->problem(@$_) foreach @problems;\n\t   }\n       }\n   }    \n   # --- end of inferring exons --\n\n   # return new top level features; this can also \n   # be retrieved via\n   #   $seq->get_SeqFeatures();\n#   return @top_sfs;\n   return $seq->get_SeqFeatures;\n}\n\n# _split_group_if_disconnected([@sfs])\n#\n# as well as having the same group_tag, a group should be spatially\n# connected. if not, then the group should be split into subgroups.\n# this turns out to be necessary in the case of multicopy genes.\n# the standard way to represent these is as spatially disconnected\n# gene models (usually a 'gene' feature and some kind of RNA feature)\n# with the same group tag; the code below will split these into \n# seperate groups, one per copy.\n\nsub _split_group_if_disconnected {\n    my $self = shift;\n    my $group = shift;\n    my @sfs = @$group;\n    my @ranges =\n      Bio::Range->disconnected_ranges(@sfs);\n    my @groups;\n    if (@ranges == 0) {\n\t$self->throw(\"ASSERTION ERROR\");\n    }\n    elsif (@ranges == 1) {\n\t# no need to split the group\n\t@groups = ($group);\n    }\n    else {\n\t# @ranges > 1\n\t# split the group into disconnected ranges\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"GROUP PRE-SPLIT:\\n\";\n\t    $self->_write_group($group, $self->group_tag);\n\t}\n\t@groups =\n\t  map {\n\t      my $range = $_;\n\t      [grep {\n\t\t  $_->intersection($range);\n\t      } @sfs]\n\t  } @ranges;\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"SPLIT GROUPS:\\n\";\n\t    $self->_write_group($_, $self->group_tag) foreach @groups;\t    \n\t}\n    }\n    return @groups;\n}\n\nsub _remove_duplicates_from_group {\n    my $self = shift;\n    my $group = shift;\n\n    # ::: WEIRD BOUNDARY CASE CODE :::\n    # for some reason, there are some gb records with two gene\n    # features for one gene; for example, see ATF14F8.gbk\n    # in the t/data directory\n    #\n    # in this case, we get rid of one of the genes\n\n    my @genes = grep {$_->primary_tag eq 'gene'} @$group;\n    if (@genes > 1) {\n\t# OK, if we look at ATF14F8.gbk we see that some genes\n\t# just exist as a single location, some exist as a multisplit location;\n\t#\n\t# eg\n\n\t#     gene            16790..26395\n\t#                     /gene=\"F14F8_60\"\n\t#     ...\n\t#     gene            complement(join(16790..19855,20136..20912,21378..21497,\n\t#                     21654..21876,22204..22400,22527..23158,23335..23448,\n\t#                     23538..23938,24175..24536,24604..24715,24889..24984,\n\t#                     25114..25171,25257..25329,25544..25589,25900..26018,\n\t#                     26300..26395))\n\t#                     /gene=\"F14F8_60\"\n\n\t# the former is the 'standard' way of representing the gene in genbank;\n\t# the latter is redundant with the CDS entry. So we shall get rid of\n\t# the latter with the following filter\n\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"REMOVING DUPLICATES:\\n\";\n\t}\n\n\t@genes =\n\t  grep {\n\t      my $loc = $_->location;\n\t      if ($loc->isa(\"Bio::Location::SplitLocationI\")) {\n\t\t  my @locs = $loc->each_Location;\t\t  \n\t\t  if (@locs > 1) {\n\t\t      0;\n\t\t  }\n\t\t  else {\n\t\t      1;\n\t\t  }\n\t      }\n\t      else {\n\t\t  1;\n\t      }\n\t  } @genes;\n\n\tif (@genes > 1) {\n\t    # OK, that didn't work. Our only resort is to just pick one at random\n\t    @genes = ($genes[0]);\n\t}\n\tif (@genes) {\n\t    @genes == 1 || $self->throw(\"ASSERTION ERROR\");\n\t    @$group =\n\t      ($genes[0], grep {$_->primary_tag ne 'gene'} @$group);\n\t}\n    }\n    # its a dirty job but someone's gotta do it\n    return;\n}\n\n\n=head2 unflatten_groups\n\n Title   : unflatten_groups\n Usage   :\n Function: iterates over groups, calling unflatten_group() [see below]\n Example :\n Returns : list of Bio::SeqFeatureI objects that are holders\n Args    : see below\n\nArguments\n\n  -groups:          list of list references; inner list is of Bio::SeqFeatureI objects\n                    e.g.  ( [$sf1], [$sf2, $sf3, $sf4], [$sf5, ...], ...)\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_groups{\n   my ($self,@args) = @_;\n   my($groups, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUPS\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   # this is just a simple wrapper for unflatten_group()\n   return \n     map {\n         $self->unflatten_group(-group=>$_,\n                                -resolver_method=>$resolver_method,\n\t\t\t\t-resolver_tag=>$resolver_tag)\n     } @$groups;\n}\n\n=head2 unflatten_group\n\n Title   : unflatten_group\n Usage   :\n Function: nests a group of features into a feature containment hierarchy\n Example :\n Returns : Bio::SeqFeatureI objects that holds other features\n Args    : see below\n\nArguments\n\n  -group:           reference to list of Bio::SeqFeatureI objects\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_group{\n   my ($self,@args) = @_;\n\n   my($group, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUP\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   if ($self->verbose > 0) {\n       printf STDERR \"UNFLATTENING GROUP:\\n\";\n       $self->_write_group($group, $self->group_tag);\n   }\n\n   my @sfs = @$group;\n\n   # we can safely ignore singletons (e.g. [source])\n   return $sfs[0] if @sfs == 1;\n\n   my $partonomy = $self->partonomy;\n\n   # $resolver_method is a reference to a SUB that will resolve\n   # ambiguous parent/child containment; for example, determining\n   # which mRNAs go with which CDSs\n   $resolver_method = $resolver_method || \\&_resolve_container_for_sf;\n\n   # TAG BASED RESOLVING OF HIERARCHIES\n   #\n   # if the user specifies $resolver_tag, then we use this tag\n   # to pair up ambiguous parents and children;\n   #\n   # for example, the CDS feature may have a resolver tag of /derives_from\n   # which is a 'foreign key' into the /label tag of the mRNA feature\n   #\n   # this kind of tag-based resolution is possible for a certain subset\n   # of genbank records\n   #\n   # if no resolver tag is specified, we revert to the normal\n   # resolver_method\n   if ($resolver_tag) {\n       my $backup_resolver_method = $resolver_method;\n       # closure: $resolver_tag is remembered by this sub\n       my $sub = \n\t sub {\n\t     my ($self, $sf, @possible_container_sfs) = @_;\n\t     my @container_sfs = ();\n\t     if ($sf->has_tag($resolver_tag)) {\n\t\t my ($resolver_tagval) = $sf->get_tag_values($resolver_tag);\n\t\t # if a feature has a resolver_tag (e.g. /derives_from)\n\t\t # this specifies the /product, /symbol or /label for the\n\t\t # parent feature\n\t\t @container_sfs = \n\t\t   grep {\n\t\t       my $match = 0;\n\t\t       $self->_write_sf($_) if $self->verbose > 0;\n\t\t       foreach my $tag (qw(product symbol label)) {\n\t\t\t   if ($_->has_tag($tag)) {\n\t\t\t       my @vals =\n\t\t\t\t $_->get_tag_values($tag);\n\t\t\t       if (grep {$_ eq $resolver_tagval} @vals) {\n\t\t\t\t   $match = 1;\n\t\t\t\t   last;\n\t\t\t       }\n\t\t\t   }   \n\t\t       }\n\t\t       $match;\n\t\t   } @possible_container_sfs;\n\t     } \n\t     else {\n\t\t return $backup_resolver_method->($sf, @possible_container_sfs);\n\t     }\n\t     return map {$_=>0} @container_sfs;\n\t };\n       $resolver_method = $sub;\n   }\n   else {\n       # CONDITION: $resolver_tag is NOT set\n       $self->throw(\"assertion error\") if $resolver_tag;\n   }\n   # we have now set $resolver_method to a subroutine for\n   # disambiguatimng parent/child relationships. we will\n   # now build the whole containment hierarchy for this group\n\n\n   # FIND TOP/ROOT SEQFEATURES\n   #\n   # find all the features for which there is no\n   # containing feature type (eg genes)\n   my @top_sfs =\n     grep { \n         !$self->get_container_type($_->primary_tag);\n     } @sfs;\n\n   # CONDITION: there must be at most one root\n   if (@top_sfs > 1) {\n       $self->_write_group($group, $self->group_tag);\n       printf STDERR \"TOP SFS:\\n\";\n       $self->_write_sf($_) foreach @top_sfs;\n       $self->throw(\"multiple top-sfs in group\");\n   }\n   my $top_sf = $top_sfs[0];\n\n   # CREATE INDEX OF SEQFEATURES BY TYPE\n   my %sfs_by_type = ();\n   foreach my $sf (@sfs) {\n       push(@{$sfs_by_type{$sf->primary_tag}}, $sf);\n   }\n\n   # containment index; keyed by child; lookup parent\n   # note: this index uses the stringified object reference of\n   # the object as a surrogate lookup key\n\n   my %container = ();   # child -> parent\n\n   # ALGORITHM: build containment graph\n   #\n   # find all possible containers for each SF;\n   # for instance, for a CDS, the possible containers are all\n   # the mRNAs in the same group. For a mRNA, the possible\n   # containers are any SFs of type 'gene' (should only be 1).\n   # (these container-type mappings can be overridden)\n   #\n   # contention is resolved by checking coordinates of splice sites\n   # (this is the default, but can be overridden)\n   #\n   # most of the time, there is no problem identifying a unique\n   # parent for every child; this can be ambiguous when constructing\n   # CDS to mRNA relationships with lots of alternate splicing\n   #\n   # a hash of child->parent relationships is constructed (%container)\n   # any mappings that need further resolution (eg CDS to mRNA) are\n   # placed in %unresolved\n\n   # %unresolved index\n   # (keyed by stringified object reference of child seqfeature)\n   my %unresolved = ();    # child -> [parent,score] to be resolved\n                           \n   # index of seqfeatures by their stringified object reference;\n   # this is essentially a way of 'reviving' an object from its stringified\n   # reference\n   # (see NOTE ON USING OBJECTS AS KEYS IN HASHES, below)\n   my %idxsf = map {$_=>$_} @sfs;\n\n   foreach my $sf (@sfs) {\n       my $type = $sf->primary_tag;\n\n       # container type (e.g. the container type for CDS is usually mRNA)\n       my $container_type = \n         $self->get_container_type($type);\n       if ($container_type) {\n\n           my @possible_container_sfs =\n             @{$sfs_by_type{$container_type} || []};\n           # we now have a list of possible containers\n           # (eg for a CDS in an alternately spliced gene, this\n           #  would be a list of all the mRNAs for this gene)\n\n\t   if (!@possible_container_sfs) {\n\t       # root of hierarchy\n\t   }\n\t   else {\n\t       if (@possible_container_sfs == 1) {\n                   # this is the easy situation, whereby the containment\n                   # hierarchy is unambiguous. this will probably be the\n                   # case if the genbank record has no alternate splicing\n                   # within it\n\n\t\t   # ONE OPTION ONLY - resolved!\n\t\t   $container{$sf} = $possible_container_sfs[0];\n\n\t       }\n\t       else {\n\t\t   # MULTIPLE CONTAINER CHOICES\n\t\t   $self->throw(\"ASSERTION ERROR\") unless @possible_container_sfs > 1;\n\n                   # push this onto the %unresolved graph, and deal with it\n                   # later\n\n                   # for now we hardcode things such that the only type \n                   # with ambiguous parents is a CDS; if this is violated,\n                   # it has a weak problem class of '1' so the API user\n                   # can easily set things to ignore these\n\t\t   if ($sf->primary_tag ne 'CDS') {\n\t\t       $self->problem(1,\n\t\t\t\t      \"multiple container choice for non-CDS; \".\n\t\t\t\t      \"CDS to mRNA should be the only \".\n\t\t\t\t      \"relationships requiring resolving\",\n\t\t\t\t      $sf);\n\t\t   }\n\n                   # previously we set the SUB $resolver_method\n                   $self->throw(\"ASSERTION ERROR\")\n                     unless $resolver_method;\n\n                   # $resolver_method will assign scores to\n                   # parent/child combinations; later on we\n                   # will use these scores to find the optimal\n                   # parent/child pairings\n\n                   # the default $resolver_method uses splice sites to\n                   # score possible parent/child matches\n\n\t\t   my %container_sfh =\n\t\t     $resolver_method->($self, $sf, @possible_container_sfs);\n                   if (!%container_sfh) {\n                       $self->problem(2,\n                                      \"no containers possible for SeqFeature of \".\n                                      \"type: $type; this SF is being placed at \".\n                                      \"root level\",\n                                      $sf);\n                       # RESOLVED! (sort of - placed at root/gene level)\n                       $container{$sf} = $top_sf;\n\n                       # this sort of thing happens if the record is\n                       # badly messed up and there is absolutely no indication\n                       # of where to put the CDS. Perhaps we should just\n                       # place it with a random mRNA?\n                   }\n\t\t   foreach my $jsf (keys %container_sfh) {\n\n                       # add [score, parent] pairs to the %unresolved\n                       # lookup table/graph\n\t\t       push(@{$unresolved{$sf}}, \n\t\t\t    [$idxsf{$jsf}, $container_sfh{$jsf} || 0]);\n\t\t   }\n\t       }\n\t   }\n       }\n       else {\n           # CONDITION:\n           # not container type for $sf->primary_tag\n           \n           # CONDITION:\n\t   # $sf must be a root/top node (eg gene)\n       }\n   }\n\n   if (0) {\n\n       # CODE CURRENTLY DISABLED\n\n       # we require a 1:1 mapping between mRNAs and CDSs;\n       # create artificial duplicates if we can't do this...\n       if (%unresolved) {\n           my %childh = map {$_=>1} keys %unresolved;\n           my %parenth = map {$_->[0]=>1} map {@$_} values %unresolved;\n           if ($self->verbose > 0) {\n               printf STDERR \"MATCHING %d CHILDREN TO %d PARENTS\\n\",\n                 scalar(keys %childh), scalar(keys %parenth);\n           }\n           # 99.99% of the time in genbank genomic record of structure type 0, we\n           # see one CDS for every mRNA; one exception is the S Pombe\n           # genome, which is all CDS, bar a few spurious mRNAs; we have to\n           # filter out the spurious mRNAs in this case\n           #\n           # another strange case is in the mouse genome, NT_078847.1\n           # for Pcdh13 you will notice there is 4 mRNAs and 5 CDSs.\n           # most unusual! \n           # I'm at a loss for a really clever thing to do here. I think the\n           # best thing is to create duplicate features to preserve the 1:1 mapping\n           #       my $suffix_id = 1;\n           #       while (keys %childh > keys %parenth) {\n           #           \n           #       }\n       }\n   }\n\n   # DEBUGGING CODE\n   if ($self->verbose > 0 && scalar(keys %unresolved)) {\n       printf STDERR \"UNRESOLVED PAIRS:\\n\";\n       foreach my $childsf (keys %unresolved) {\n\t   my @poss = @{$unresolved{$childsf}};\n\t   foreach my $p (@poss) {\n\t       my $parentsf = $p->[0];\n\t       $childsf = $idxsf{$childsf};\n               my @clabels = ($childsf->get_tagset_values(qw(protein_id label product)), \"?\");\n               my @plabels = ($parentsf->get_tagset_values(qw(transcript_id label product)), \"?\");\n\t       printf STDERR\n                      (\"  PAIR: $clabels[0] => $plabels[0]  (of %d)\\n\", \n                       scalar(@poss));\n\t   }\n       }\n   } # -- end of verbose\n\n   # Now we have to fully resolve the containment hierarchy; remember,\n   # the graph %container has the fully resolved child->parent links;\n   #\n   # the graph %unresolved is keyed by children missing parents; we\n   # need to put all these orphans in the %container graph\n   #\n   # we do this using the scores in %unresolved, with the\n   # find_best_matches() algorithm\n   my $unresolved_problem_reported = 0;\n   if (%unresolved) {\n       my $new_pairs =\n\t $self->find_best_matches(\\%unresolved, []);\n       if (!$new_pairs) {\n           my ($g) = $sfs[0]->get_tagset_values($self->group_tag || 'gene');\n\t   $self->problem(2,\n\t\t\t  \"Could not resolve hierarchy for $g\");\n           $new_pairs = [];\n           $unresolved_problem_reported = 1;\n       }\n       foreach my $pair (@$new_pairs) {\n\t   if ($self->verbose > 0) {\n\t       printf STDERR \"  resolved pair @$pair\\n\";\n\t   }\n\t   $container{$pair->[0]} = $pair->[1];\n           delete $unresolved{$pair->[0]};\n       }\n   }\n\n   # CONDITION: containment hierarchy resolved\n   if (%unresolved) {\n       $self->throw(\"UNRESOLVED: %unresolved\")\n         unless $unresolved_problem_reported;\n   }\n\n   # make nested SeqFeature hierarchy from @containment_pairs\n   # ie put child SeqFeatures into parent SeqFeatures\n   my @top = ();\n   foreach my $sf (@sfs) {\n       my $container_sf = $container{$sf};\n       if ($container_sf) {\n           # make $sf nested inside $container_sf\n\n           # first check if the container spatially contains the containee\n           if ($container_sf->contains($sf)) {\n               # add containee\n\t       $container_sf->add_SeqFeature($sf);\n           }\n           else {\n               # weird case - the container does NOT spatially\n               # contain the containee;\n               # we expand and throw a warning\n               #\n               # for an example of this see ZFP91-CNTF dicistronic gene\n               # in NCBI chrom 11 build 34.3\n\t       $self->problem(1,\n\t\t\t      \"Container feature does not spatially contain \".\n                              \"subfeature. Perhaps this is a dicistronic gene? \".\n                              \"I am expanding the parent feature\",\n\t\t\t      $container_sf,\n\t\t\t      $sf);\n\t       $container_sf->add_SeqFeature($sf, 'EXPAND');\n           }\n       }\n       else {\n           push(@top, $sf);\n       }\n   }\n   return @top;\n} # -- end of unflatten_group\n\n# -------\n# A NOTE ON USING OBJECTS AS KEYS IN HASHES (stringified objects)\n#\n# Often we with to use seqfeatures as keys in a hashtable; because seqfeatures\n# in bioperl have no unique ID, we use a surrogate ID in the form of the\n# stringified object references - this is just what you get if you say\n#\n#  print \"$sf\\n\";\n#\n# this is guaranteed to be unique (within a particular perl execution)\n#\n# often we want to 'revive' the objects used as keys in a hash - once the\n# objects are used as keys, remember it is the *strings* used as keys and\n# not the object itself, so the object needs to be revived using another\n# hashtable that looks like this\n#\n#    %sfidx = map { $_ => $_ } @sfs\n#\n# -------\n\n\n# recursively finds the best set of pairings from a matrix of possible pairings\n#\n# tries to make sure nothing is unpaired\n#\n# given a matrix of POSSIBLE matches\n#  (matrix expressed as hash/lookup; keyed by child object; val = [parent, score]\n#\n# \nsub find_best_matches {\n    my $self = shift;\n    my $matrix = shift;\n    my $pairs = shift;        # [child,parent] pairs already selected\n\n    my $verbose = $self->verbose;\n    #################################print \"I\";\n    if ($verbose > 0) {\n\tprintf STDERR \"find_best_matches: (/%d)\\n\", scalar(@$pairs);\n    }\n\n    my %selected_children = map {($_->[0]=>1)} @$pairs;\n    my %selected_parents = map {($_->[1]=>1)} @$pairs;\n    \n    # make a copy of the matrix with the portions still to be\n    # resolved\n    my %unresolved_parents = ();\n    my %unresolved =\n      map {\n          if ($verbose > 0) {\n              printf STDERR \"  $_ : %s\\n\", join(\"; \", map {\"[@$_]\"} @{$matrix->{$_}});\n          }\n\t  if ($selected_children{$_}) {\n\t      ();\n\t  }\n\t  else {\n\t      my @parents =\n\t\tgrep {\n\t\t    !$selected_parents{$_->[0]}\n\t\t} @{$matrix->{$_}};\n              $unresolved_parents{$_} = 1 foreach @parents;\n              # new parents\n\t      ($_ => [@parents]);\n\t  }\n      } keys %$matrix;\n    \n    my @I = keys %unresolved;\n\n    return $pairs if !scalar(keys %unresolved_parents);\n    # NECESSARY CONDITION:\n    # all possible parents have a child match\n\n    return $pairs if !scalar(@I);\n    # NECESSARY CONDITION:\n    # all possible children have a parent match\n\n    # give those with fewest choices highest priority\n    @I = sort {\n\t# n possible parents\n\tscalar(@{$unresolved{$a}}) \n\t  <=>\n\t    scalar(@{$unresolved{$b}}) ;\n    } @I;\n    \n    my $csf = shift @I;\n\n    my @J = @{$unresolved{$csf}};  # array of [parent, score]\n\n    # sort by score, highest first\n    @J =\n      sort {\n\t  $b->[1] <=> $a->[1]\n      } @J;\n\n    # select pair(s) from remaining matrix of possible pairs\n    # by iterating through possible parents\n\n    my $successful_pairs;\n    foreach my $j (@J) {\n\tmy ($psf, $score) = @$j;\n\t# would selecting $csf, $psf as a pair\n\t# remove all choices from another?\n\tmy $bad = 0;\n\tforeach my $sf (@I) {\n\t    if (!grep {$_->[0] ne $psf} @{$unresolved{$sf}}) {\n\t\t# $psf was the only parent choice for $sf\n\t\t$bad = 1;\n\t\tlast;\n\t    }\n\t}\n\tif (!$bad) {\n\t    my $pair = [$csf, $psf];\n\t    my $new_pairs = [@$pairs, $pair];\n\t    my $set = $self->find_best_matches($matrix, $new_pairs);\n\t    if ($set) {\n\t\t$successful_pairs = $set;\n\t\tlast;\n\t    }\n\t}\n    }\n    # success\n    return $successful_pairs if $successful_pairs;\n    # fail\n    return 0;\n}\n\n# ----------------------------------------------\n# writes a group to stdout\n#\n# mostly for logging/debugging\n# ----------------------------------------------\nsub _write_group {\n    my $self = shift;\n    my $group = shift;\n    my $group_tag = shift || 'gene';\n\n    my $f = $group->[0];\n    my $label = '?';\n    if ($f->has_tag($group_tag)) {\n\t($label) = $f->get_tag_values($group_tag);\n    }\n    if( $self->verbose > 0 ) { \n\tprintf STDERR (\"  GROUP [%s]:%s\\n\",\n\t       $label,\n\t       join(' ',\n\t\t    map { $_->primary_tag } @$group));\n    }\n\n}\n\nsub _write_sf {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    return;\n}\n\nsub _write_sf_detail {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    my @locs = $sf->location->each_Location;\n    printf STDERR \"  %s,%s [%s]\\n\", $_->start, $_->end, $_->strand foreach @locs;\n    return;\n}\n\nsub _write_hier {\n    my $self = shift;\n    my @sfs = @{shift || []};\n    my $indent = shift || 0;\n    if( $self->verbose > 0 ) {\n\tforeach my $sf (@sfs) {\n\t    my $label = '?';\n\t    if ($sf->has_tag('product')) {\n\t\t($label) = $sf->get_tag_values('product');\n\t    }\n\t    printf STDERR \"%s%s $label\\n\", '  ' x $indent, $sf->primary_tag;\n\t    my @sub_sfs = $sf->sub_SeqFeature;\n\t    $self->_write_hier(\\@sub_sfs, $indent+1);\n\t}\n    }\n}\n\n# -----------------------------------------------\n#\n# returns all possible containers for an SF based\n# on splice site coordinates; splice site coords\n# must be contained\n# -----------------------------------------------\nsub _resolve_container_for_sf{\n   my ($self, $sf, @possible_container_sfs) = @_;\n\n   my @coords = $self->_get_splice_coords_for_sf($sf);\n   my $start = $sf->start;\n   my $end = $sf->end;\n   my $splice_uniq_str = \"@coords\";\n   \n   my @sf_score_pairs = ();\n   # a CDS is contained by a mRNA if the locations of the splice\n   # coordinates are identical\n   foreach (@possible_container_sfs) {\n       my @container_coords = $self->_get_splice_coords_for_sf($_);\n       my $inside = \n\t !$splice_uniq_str || \n\t   index(\"@container_coords\", $splice_uniq_str) > -1;\n       if ($inside) {\n           # the container cannot be smaller than the thing contained\n           if ($_->start > $start || $_->end < $end) {\n               $inside = 0;\n           }\n       }\n       if ($self->verbose > 0) {\n\t   printf STDERR \"    Checking containment:[$inside] (@container_coords) IN ($splice_uniq_str)\\n\";\n       }\n       if ($inside) {\n\t   # SCORE: matching (ss-scoords+2)/(n-container-ss-coords+2)\n\t   my $score =\n\t     (scalar(@coords)+2)/(scalar(@container_coords)+2);\n\t   push(@sf_score_pairs,\n\t\t$_=>$score);\n       }\n   }\n   # return array ( $sf1=>$score1, $sf2=>$score2, ...)\n   return @sf_score_pairs;\n}\n\nsub _get_splice_coords_for_sf {\n    my $self = shift;\n    my $sf = shift;\n\n   my @locs = $sf->location;\n   if ($sf->location->isa(\"Bio::Location::SplitLocationI\")) {\n       @locs = $sf->location->each_Location;\n   }\n\n   # get an ordered list of (start, end) positions\n\n#   my @coords =\n#     map {\n#         $_->strand > 0 ? ($_->start, $_->end) : ($_->end, $_->start)\n#     } @locs;\n\n    my @coords = map {($_->start, $_->end)} @locs;\n\n   # remove first and last leaving only splice sites\n   pop @coords;\n   shift @coords;\n    return @coords;\n}\n\n=head2 feature_from_splitloc\n\n Title   : feature_from_splitloc\n Usage   : $unflattener->feature_from_splitloc(-features=>$sfs);\n Function:\n Example :\n Returns : \n Args    : see below\n\nAt this time all this method does is generate exons for mRNA or other RNA features\n\nArguments:\n\n  -feature:    a Bio::SeqFeatureI object (that conforms to Bio::FeatureHolderI)\n  -seq:        a Bio::SeqI object that contains Bio::SeqFeatureI objects\n  -features:   an arrayref of Bio::SeqFeatureI object","label":"feature_from_splitloc($self,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"line":2454,"character":0},"end":{"line":2463,"character":9999}},"name":"feature_from_splitloc"},{"containerName":null,"name":"@sfs","line":2464,"kind":13},{"name":"$sf","containerName":null,"kind":13,"line":2464},{"containerName":null,"name":"$sf","kind":13,"line":2464},{"name":"%seq","containerName":null,"line":2465,"kind":13},{"containerName":null,"name":"$seq","kind":13,"line":2466},{"name":"isa","containerName":"main::","line":2466,"kind":12},{"line":2466,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"throw","kind":12,"line":2466},{"line":2467,"kind":13,"name":"@sfs","containerName":null},{"kind":13,"line":2467,"containerName":null,"name":"$seq"},{"line":2467,"kind":12,"name":"get_all_SeqFeatures","containerName":"main::"},{"kind":13,"line":2469,"containerName":null,"name":"@exons","definition":"my","localvar":"my"},{"kind":12,"line":2469,"containerName":"main::","name":"primary_tag"},{"kind":13,"line":2469,"name":"@sfs","containerName":null},{"containerName":null,"name":"@exons","line":2470,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":2471},{"line":2471,"kind":12,"name":"problem","containerName":"main::"},{"line":2476,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%loc_h"},{"line":2479,"kind":13,"localvar":"my","containerName":null,"name":"$sf","definition":"my"},{"line":2479,"kind":13,"name":"@sfs","containerName":null},{"line":2481,"kind":13,"name":"$sf","containerName":null},{"name":"isa","containerName":"main::","line":2481,"kind":12},{"name":"$self","containerName":null,"line":2481,"kind":13},{"name":"throw","containerName":"main::","line":2481,"kind":12},{"containerName":null,"name":"$sf","kind":13,"line":2482},{"containerName":"main::","name":"isa","kind":12,"line":2482},{"kind":13,"line":2482,"containerName":null,"name":"$self"},{"kind":12,"line":2482,"name":"throw","containerName":"main::"},{"containerName":null,"definition":"my","name":"$type","localvar":"my","kind":13,"line":2484},{"containerName":null,"name":"$sf","line":2484,"kind":13},{"containerName":"main::","name":"primary_tag","line":2484,"kind":12},{"containerName":null,"name":"$type","line":2485,"kind":13},{"kind":13,"line":2485,"name":"$type","containerName":null},{"line":2489,"kind":13,"localvar":"my","name":"@locs","definition":"my","containerName":null},{"name":"$sf","containerName":null,"line":2489,"kind":13},{"containerName":"main::","name":"location","line":2489,"kind":12},{"kind":13,"line":2491,"name":"$sf","containerName":null},{"line":2491,"kind":12,"name":"location","containerName":"main::"},{"containerName":"main::","name":"isa","line":2491,"kind":12},{"line":2492,"kind":13,"containerName":null,"name":"@locs"},{"containerName":null,"name":"$sf","line":2492,"kind":13},{"line":2492,"kind":12,"name":"location","containerName":"main::"},{"containerName":"main::","name":"each_Location","kind":12,"line":2492},{"kind":13,"line":2495,"containerName":null,"name":"@locs"},{"name":"Dumper","kind":12,"line":2497},{"kind":13,"line":2497,"name":"$sf","containerName":null},{"line":2498,"kind":13,"name":"$self","containerName":null},{"containerName":"Data","name":"Dumper","kind":2,"line":2498},{"containerName":"main::","name":"throw","line":2498,"kind":12},{"localvar":"my","definition":"my","name":"@subsfs","containerName":null,"line":2502,"kind":13},{"kind":13,"line":2504,"containerName":null,"name":"$subsf","definition":"my","localvar":"my"},{"line":2504,"kind":12,"name":"Bio","containerName":"SeqFeature::Generic"},{"name":"new","containerName":"main::","kind":12,"line":2504},{"line":2507,"kind":13,"name":"$subsf","containerName":null},{"containerName":"main::","name":"seq_id","line":2507,"kind":12},{"containerName":null,"name":"$sf","kind":13,"line":2507},{"containerName":"main::","name":"seq_id","line":2507,"kind":12},{"line":2507,"kind":13,"name":"$sf","containerName":null},{"kind":12,"line":2507,"name":"seq_id","containerName":"main::"},{"kind":13,"line":2508,"containerName":null,"name":"$subsf"},{"kind":12,"line":2508,"containerName":"main::","name":"source_tag"},{"kind":13,"line":2508,"name":"$sf","containerName":null},{"kind":12,"line":2508,"name":"source_tag","containerName":"main::"},{"containerName":null,"name":"$sf","line":2508,"kind":13},{"kind":12,"line":2508,"name":"source_tag","containerName":"main::"},{"containerName":null,"definition":"my","name":"$tag","localvar":"my","kind":13,"line":2513},{"line":2513,"kind":13,"name":"$sf","containerName":null},{"kind":12,"line":2513,"name":"get_all_tags","containerName":"main::"},{"kind":13,"line":2514,"definition":"my","name":"@vals","containerName":null,"localvar":"my"},{"kind":13,"line":2514,"containerName":null,"name":"$sf"},{"kind":12,"line":2514,"containerName":"main::","name":"get_tag_values"},{"kind":13,"line":2514,"containerName":null,"name":"$tag"},{"line":2515,"kind":13,"name":"$subsf","containerName":null},{"containerName":"main::","name":"add_tag_value","kind":12,"line":2515},{"kind":13,"line":2515,"containerName":null,"name":"$tag"},{"name":"@vals","containerName":null,"line":2515,"kind":13},{"localvar":"my","name":"$locstr","definition":"my","containerName":null,"line":2518,"kind":13},{"name":"$self","containerName":null,"line":2518,"kind":13},{"line":2518,"kind":12,"containerName":"main::","name":"_locstr"},{"line":2518,"kind":13,"containerName":null,"name":"$subsf"},{"name":"%loc_h","containerName":null,"kind":13,"line":2521},{"name":"%locstr","containerName":null,"line":2521,"kind":13},{"name":"$subsf","containerName":null,"line":2522,"kind":13},{"containerName":null,"name":"%loc_h","kind":13,"line":2522},{"containerName":null,"name":"%locstr","kind":13,"line":2522},{"kind":13,"line":2525,"containerName":null,"name":"%loc_h"},{"line":2525,"kind":13,"name":"$locstr","containerName":null},{"name":"$subsf","containerName":null,"kind":13,"line":2525},{"line":2527,"kind":13,"containerName":null,"name":"$subsf"},{"name":"@locs","containerName":null,"kind":13,"line":2528},{"name":"$self","containerName":null,"kind":13,"line":2531},{"containerName":"main::","name":"_check_order_is_consistent","line":2531,"kind":12},{"kind":13,"line":2531,"containerName":null,"name":"$sf"},{"kind":12,"line":2531,"containerName":"main::","name":"location"},{"kind":12,"line":2531,"containerName":"main::","name":"strand"},{"name":"@subsfs","containerName":null,"kind":13,"line":2531},{"line":2534,"kind":13,"name":"$sf","containerName":null},{"containerName":"main::","name":"location","line":2534,"kind":12},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":2534},{"name":"new","containerName":"main::","kind":12,"line":2534},{"name":"$sf","containerName":null,"line":2537,"kind":13},{"containerName":"main::","name":"add_SeqFeature","line":2537,"kind":12},{"name":"@subsfs","containerName":null,"line":2537,"kind":13},{"line":2540,"kind":13,"containerName":null,"name":"$sf"},{"line":2540,"kind":12,"containerName":"main::","name":"location"},{"name":"strand","containerName":"main::","kind":12,"line":2540},{"name":"$sf","containerName":null,"line":2543,"kind":13},{"kind":12,"line":2543,"name":"location","containerName":"main::"},{"containerName":"main::","name":"strand","line":2543,"kind":12},{"containerName":null,"name":"@subsfs","line":2543,"kind":13},{"kind":12,"line":2543,"name":"location","containerName":"main::"},{"line":2543,"kind":12,"containerName":"main::","name":"strand"},{"kind":12,"line":2604,"children":[{"definition":"my","name":"$self","containerName":"infer_mRNA_from_CDS","localvar":"my","kind":13,"line":2605},{"line":2605,"kind":13,"name":"@args","containerName":"infer_mRNA_from_CDS"},{"localvar":"my","name":"$sf","definition":"my","containerName":"infer_mRNA_from_CDS","line":2607,"kind":13},{"name":"$seq","containerName":"infer_mRNA_from_CDS","kind":13,"line":2607},{"name":"$self","containerName":"infer_mRNA_from_CDS","line":2608,"kind":13},{"containerName":"infer_mRNA_from_CDS","name":"_rearrange","kind":12,"line":2608},{"kind":13,"line":2611,"name":"@args","containerName":"infer_mRNA_from_CDS"},{"kind":13,"line":2612,"containerName":"infer_mRNA_from_CDS","name":"@sfs","definition":"my","localvar":"my"},{"name":"$sf","containerName":"infer_mRNA_from_CDS","line":2612,"kind":13},{"line":2613,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$seq"},{"name":"$seq","containerName":"infer_mRNA_from_CDS","kind":13,"line":2614},{"line":2614,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"isa"},{"line":2614,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$self"},{"containerName":"infer_mRNA_from_CDS","name":"throw","line":2614,"kind":12},{"line":2615,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"@sfs"},{"line":2615,"kind":13,"name":"$seq","containerName":"infer_mRNA_from_CDS"},{"kind":12,"line":2615,"name":"get_all_SeqFeatures","containerName":"infer_mRNA_from_CDS"},{"containerName":"infer_mRNA_from_CDS","definition":"my","name":"$sf","localvar":"my","kind":13,"line":2618},{"line":2618,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"@sfs"},{"name":"$sf","containerName":"infer_mRNA_from_CDS","line":2620,"kind":13},{"name":"isa","containerName":"infer_mRNA_from_CDS","line":2620,"kind":12},{"name":"$self","containerName":"infer_mRNA_from_CDS","kind":13,"line":2620},{"name":"throw","containerName":"infer_mRNA_from_CDS","kind":12,"line":2620},{"containerName":"infer_mRNA_from_CDS","name":"$sf","line":2621,"kind":13},{"line":2621,"kind":12,"name":"isa","containerName":"infer_mRNA_from_CDS"},{"line":2621,"kind":13,"name":"$self","containerName":"infer_mRNA_from_CDS"},{"line":2621,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"throw"},{"line":2622,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$self"},{"name":"verbose","containerName":"infer_mRNA_from_CDS","line":2622,"kind":12},{"line":2623,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$sf"},{"containerName":"infer_mRNA_from_CDS","name":"primary_tag","line":2623,"kind":12},{"line":2626,"kind":13,"name":"$sf","containerName":"infer_mRNA_from_CDS"},{"name":"primary_tag","containerName":"infer_mRNA_from_CDS","line":2626,"kind":12},{"line":2627,"kind":13,"name":"$self","containerName":"infer_mRNA_from_CDS"},{"kind":12,"line":2627,"containerName":"infer_mRNA_from_CDS","name":"problem"},{"definition":"my","name":"@cdsl","containerName":"infer_mRNA_from_CDS","localvar":"my","kind":13,"line":2631},{"kind":12,"line":2631,"name":"primary_tag","containerName":"infer_mRNA_from_CDS"},{"kind":13,"line":2631,"containerName":"infer_mRNA_from_CDS","name":"$sf"},{"kind":12,"line":2631,"containerName":"infer_mRNA_from_CDS","name":"get_SeqFeatures"},{"kind":13,"line":2632,"containerName":"infer_mRNA_from_CDS","name":"@cdsl"},{"name":"@children","definition":"my","containerName":"infer_mRNA_from_CDS","localvar":"my","kind":13,"line":2633},{"line":2633,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"primary_tag"},{"containerName":"infer_mRNA_from_CDS","name":"$sf","line":2633,"kind":13},{"name":"get_SeqFeatures","containerName":"infer_mRNA_from_CDS","kind":12,"line":2633},{"definition":"my","name":"@mrnas","containerName":"infer_mRNA_from_CDS","localvar":"my","kind":13,"line":2634},{"localvar":"my","containerName":"infer_mRNA_from_CDS","name":"$cds","definition":"my","line":2635,"kind":13},{"containerName":"infer_mRNA_from_CDS","name":"@cdsl","kind":13,"line":2635},{"name":"$self","containerName":"infer_mRNA_from_CDS","line":2637,"kind":13},{"kind":12,"line":2637,"name":"verbose","containerName":"infer_mRNA_from_CDS"},{"kind":13,"line":2640,"name":"$self","containerName":"infer_mRNA_from_CDS"},{"name":"_check_order_is_consistent","containerName":"infer_mRNA_from_CDS","kind":12,"line":2640},{"containerName":"infer_mRNA_from_CDS","name":"$cds","line":2640,"kind":13},{"name":"location","containerName":"infer_mRNA_from_CDS","line":2640,"kind":12},{"containerName":"infer_mRNA_from_CDS","name":"strand","line":2640,"kind":12},{"name":"$cds","containerName":"infer_mRNA_from_CDS","line":2640,"kind":13},{"containerName":"infer_mRNA_from_CDS","name":"location","line":2640,"kind":12},{"name":"each_Location","containerName":"infer_mRNA_from_CDS","line":2640,"kind":12},{"kind":13,"line":2642,"containerName":"infer_mRNA_from_CDS","name":"$loc","definition":"my","localvar":"my"},{"line":2642,"kind":12,"name":"new","containerName":"infer_mRNA_from_CDS"},{"line":2643,"kind":13,"localvar":"my","name":"$cdsexonloc","definition":"my","containerName":"infer_mRNA_from_CDS"},{"name":"$cds","containerName":"infer_mRNA_from_CDS","line":2643,"kind":13},{"line":2643,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"location"},{"containerName":"infer_mRNA_from_CDS","name":"each_Location","line":2643,"kind":12},{"line":2644,"kind":13,"localvar":"my","containerName":"infer_mRNA_from_CDS","definition":"my","name":"$subloc"},{"containerName":"infer_mRNA_from_CDS","name":"new","kind":12,"line":2645},{"kind":13,"line":2645,"containerName":"infer_mRNA_from_CDS","name":"$cdsexonloc"},{"kind":12,"line":2645,"containerName":"infer_mRNA_from_CDS","name":"start"},{"containerName":"infer_mRNA_from_CDS","name":"$cdsexonloc","line":2646,"kind":13},{"name":"end","containerName":"infer_mRNA_from_CDS","kind":12,"line":2646},{"containerName":"infer_mRNA_from_CDS","name":"$cdsexonloc","line":2647,"kind":13},{"kind":12,"line":2647,"name":"strand","containerName":"infer_mRNA_from_CDS"},{"containerName":"infer_mRNA_from_CDS","name":"$loc","kind":13,"line":2648},{"name":"add_sub_Location","containerName":"infer_mRNA_from_CDS","line":2648,"kind":12},{"kind":13,"line":2648,"name":"$subloc","containerName":"infer_mRNA_from_CDS"},{"line":2651,"kind":13,"localvar":"my","name":"$mrna","definition":"my","containerName":"infer_mRNA_from_CDS"},{"name":"new","containerName":"infer_mRNA_from_CDS","line":2652,"kind":12},{"kind":13,"line":2652,"containerName":"infer_mRNA_from_CDS","name":"$loc"},{"kind":13,"line":2656,"containerName":"infer_mRNA_from_CDS","name":"$mrna"},{"name":"seq_id","containerName":"infer_mRNA_from_CDS","kind":12,"line":2656},{"name":"$cds","containerName":"infer_mRNA_from_CDS","kind":13,"line":2656},{"kind":12,"line":2656,"name":"seq_id","containerName":"infer_mRNA_from_CDS"},{"line":2656,"kind":13,"name":"$cds","containerName":"infer_mRNA_from_CDS"},{"line":2656,"kind":12,"name":"seq_id","containerName":"infer_mRNA_from_CDS"},{"name":"$mrna","containerName":"infer_mRNA_from_CDS","kind":13,"line":2657},{"containerName":"infer_mRNA_from_CDS","name":"source_tag","line":2657,"kind":12},{"line":2657,"kind":13,"name":"$cds","containerName":"infer_mRNA_from_CDS"},{"name":"source_tag","containerName":"infer_mRNA_from_CDS","line":2657,"kind":12},{"name":"$cds","containerName":"infer_mRNA_from_CDS","kind":13,"line":2657},{"line":2657,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"source_tag"},{"line":2659,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$self"},{"kind":12,"line":2659,"name":"_check_order_is_consistent","containerName":"infer_mRNA_from_CDS"},{"containerName":"infer_mRNA_from_CDS","name":"$mrna","kind":13,"line":2659},{"containerName":"infer_mRNA_from_CDS","name":"location","line":2659,"kind":12},{"name":"strand","containerName":"infer_mRNA_from_CDS","line":2659,"kind":12},{"name":"$mrna","containerName":"infer_mRNA_from_CDS","line":2659,"kind":13},{"line":2659,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"location"},{"containerName":"infer_mRNA_from_CDS","name":"each_Location","line":2659,"kind":12},{"line":2663,"kind":13,"name":"$mrna","containerName":"infer_mRNA_from_CDS"},{"kind":12,"line":2663,"containerName":"infer_mRNA_from_CDS","name":"add_SeqFeature"},{"containerName":"infer_mRNA_from_CDS","name":"$cds","kind":13,"line":2663},{"name":"$subsf","definition":"my","containerName":"infer_mRNA_from_CDS","localvar":"my","kind":13,"line":2666},{"kind":13,"line":2666,"name":"$cds","containerName":"infer_mRNA_from_CDS"},{"name":"get_SeqFeatures","containerName":"infer_mRNA_from_CDS","kind":12,"line":2666},{"line":2667,"kind":13,"name":"$mrna","containerName":"infer_mRNA_from_CDS"},{"line":2667,"kind":12,"containerName":"infer_mRNA_from_CDS","name":"add_SeqFeature"},{"line":2667,"kind":13,"containerName":"infer_mRNA_from_CDS","name":"$subsf"},{"containerName":"infer_mRNA_from_CDS","name":"$cds","line":2669,"kind":13},{"containerName":"infer_mRNA_from_CDS","name":"remove_SeqFeatures","line":2669,"kind":12},{"containerName":"infer_mRNA_from_CDS","name":"@mrnas","line":2670,"kind":13},{"kind":13,"line":2670,"name":"$mrna","containerName":"infer_mRNA_from_CDS"},{"containerName":"infer_mRNA_from_CDS","name":"$sf","line":2673,"kind":13},{"name":"remove_SeqFeatures","containerName":"infer_mRNA_from_CDS","kind":12,"line":2673},{"name":"$sf","containerName":"infer_mRNA_from_CDS","line":2674,"kind":13},{"line":2674,"kind":12,"name":"add_SeqFeature","containerName":"infer_mRNA_from_CDS"},{"line":2674,"kind":13,"name":"@mrnas","containerName":"infer_mRNA_from_CDS"},{"kind":13,"line":2674,"containerName":"infer_mRNA_from_CDS","name":"@children"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"infer_mRNA_from_CDS($self,@args)","documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'\n\n\n\n\nsub unflatten_seq{\n   my ($self,@args) = @_;\n\n    my($seq, $resolver_method, $group_tag, $partonomy, \n       $structure_type, $resolver_tag, $use_magic) =\n\t$self->_rearrange([qw(SEQ\n                              RESOLVER_METHOD\n                              GROUP_TAG\n                              PARTONOMY\n\t\t\t      STRUCTURE_TYPE\n\t\t\t      RESOLVER_TAG\n\t\t\t      USE_MAGIC\n\t\t\t     )],\n                          @args);\n\n   # seq we want to unflatten\n   $seq = $seq || $self->seq;\n\n\n   # prevent bad argument combinations\n   if ($partonomy &&\n       defined($structure_type)) {\n       $self->throw(\"You cannot set both -partonomy and -structure_type\\n\".\n\t\t    \"(the former is implied by the latter)\");\n   }\n\n   # remember the current value of partonomy, to reset later\n   my $old_partonomy = $self->partonomy;\n   $self->partonomy($partonomy) if defined $partonomy;\n\n   # remember old structure_type\n   my $old_structure_type = $self->structure_type;\n   $self->structure_type($structure_type) if defined $structure_type;\n\n   # if we are sourcing our data from genbank, all the\n   # features should be flat (eq no sub_SeqFeatures)\n   my @flat_seq_features = $seq->get_SeqFeatures;\n   my @all_seq_features = $seq->get_all_SeqFeatures;\n\n   # sanity checks\n   if (@all_seq_features > @flat_seq_features) {\n       $self->throw(\"It looks as if this sequence has already been unflattened\");\n   }\n   if (@all_seq_features < @flat_seq_features) {\n       $self->throw(\"ASSERTION ERROR: something is seriously wrong with your features\");\n   }\n\n   # tag for ungrouping; usually /gene or /locus_tag\n   #     for example:        /gene=\"foo\"\n   $group_tag = $group_tag || $self->group_tag;\n   if ($use_magic) {\n       # use magic to guess the group tag\n       my @sfs_with_locus_tag =\n\t grep {$_->has_tag(\"locus_tag\")} @flat_seq_features;\n       my @sfs_with_gene_tag =\n\t grep {$_->has_tag(\"gene\")} @flat_seq_features;\n       my @sfs_with_product_tag =\n\t grep {$_->has_tag(\"product\")} @flat_seq_features;\n\t \n#        if ($group_tag && $self->{'trust_grouptag'}) { # dgg suggestion\n# \n#         }\n#        elsif\n       if (@sfs_with_locus_tag) {\n        # dgg note: would like to -use_magic with -group_tag = 'gene' for ensembl genomes\n        # where ensembl gene FT have both /locus_tag and /gene, but mRNA, CDS have /gene only\n\t   if ($group_tag && $group_tag ne 'locus_tag') {\n\t       $self->throw(\"You have explicitly set group_tag to be '$group_tag'\\n\".\n\t\t\t    \"However, I detect that some features use /locus_tag\\n\".\n\t\t\t    \"I believe that this is the correct group_tag to use\\n\".\n\t\t\t    \"You can resolve this by either NOT setting -group_tag\\n\".\n\t\t\t    \"OR you can unset -use_magic to regain control\");\n\t   }\n\n\t   # use /locus_tag instead of /gene tag for grouping\n\t   # see GenBank entry AE003677 (version 3) for an example\n\t   $group_tag = 'locus_tag';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n       }\n\n       # on rare occasions, records will have no /gene or /locus_tag\n       # but it WILL have /product tags. These serve the same purpose\n       # for grouping. For an example, see AY763288 (also in t/data)\n       if (@sfs_with_locus_tag==0 &&\n           @sfs_with_gene_tag==0 &&\n           @sfs_with_product_tag>0 &&\n           !$group_tag) {\n\t   $group_tag = 'product';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n           \n       }\n   }\n   if (!$group_tag) {\n       $group_tag = 'gene';\n   }\n\n   # ------------------------------\n   # GROUP FEATURES using $group_tag\n   #     collect features into unstructured groups\n   # ------------------------------\n\n   # -------------\n   # we want to generate a list of groups;\n   # each group is a list of SeqFeatures; this\n   # group probably (but not necessarily)\n   # corresponds to a gene model.\n   #\n   # this array will look something like this:\n   # ([$f1], [$f2, $f3, $f4], ...., [$f97, $f98, $f99])\n   #\n   # there are also 'singleton' groups, with one member.\n   # for instance, the 'source' feature is in a singleton group;\n   # the same with others such as 'misc_feature'\n   my @groups = ();\n   # -------------\n\n   # --------------------\n   # we hope that the genbank record allows us to group by some grouping\n   # tag.\n   # for instance, most of the time a gene model can be grouped using\n   # the gene tag - that is where you see\n   #                    /gene=\"foo\"\n   # in a genbank record\n   # --------------------\n   \n   # keep an index of groups by their\n   # grouping tag\n   my %group_by_tag = ();\n   \n\n   # iterate through all features, putting them into groups\n   foreach my $sf (@flat_seq_features) {\n       if (!$sf->has_tag($group_tag)) {\n\t   # SINGLETON\n           # this is an ungroupable feature;\n           # add it to a group of its own\n           push(@groups, [$sf]);\n       }\n       else {\n\t   # NON-SINGLETON\n           my @group_tagvals = $sf->get_tag_values($group_tag);\n           if (@group_tagvals > 1) {\n\t       # sanity check:\n               # currently something can only belong to one group\n               $self->problem(2,\n\t\t\t      \">1 value for /$group_tag: @group_tagvals\\n\".\n\t\t\t      \"At this time this module is not equipped to handle this adequately\", $sf);\n           }\n\t   # get value of group tag\n           my $gtv = shift @group_tagvals;\n           $gtv || $self->throw(\"Empty /$group_tag vals not allowed!\");\n\n           # is this a new group?\n           my $group = $group_by_tag{$gtv};\n           if ($group) {\n               # this group has been encountered before - add current\n               # sf to the end of the group\n               push(@$group, $sf);\n           }\n           else {\n               # new group; add to index and create new group\n               $group = [$sf];  # currently one member; probably more to come\n               $group_by_tag{$gtv} = $group;\n               push(@groups, $group);\n           }\n       }\n   }\n   \n   # as well as having the same group_tag, a group should be spatially\n   # connected. if not, then the group should be split into subgroups.\n   # this turns out to be necessary in the case of multicopy genes.\n   # the standard way to represent these is as spatially disconnected\n   # gene models (usually a 'gene' feature and some kind of RNA feature)\n   # with the same group tag; the code below will split these into \n   # seperate groups, one per copy.\n   @groups = map { $self->_split_group_if_disconnected($_) } @groups;\n\n   # remove any duplicates; most of the time the method below has\n   # no effect. there are some unusual genbank records for which\n   # duplicate removal is necessary. see the comments in the\n   # _remove_duplicates_from_group() method if you want to know\n   # the ugly details\n   foreach my $group (@groups) {\n       $self->_remove_duplicates_from_group($group);\n   }\n\n   # -\n\n   # PSEUDOGENES, PSEUDOEXONS AND PSEUDOINTRONS\n   # these are indicated with the /pseudo tag\n   # these are mapped to a different type; they should NOT\n   # be treated as normal genes\n   foreach my $sf (@all_seq_features) {\n       if ($sf->has_tag('pseudo')) {\n           my $type = $sf->primary_tag;\n           # SO type is typically the same as the normal\n           # type but preceeded by \"pseudo\"\n           if ($type eq 'misc_RNA' || $type eq 'mRNA') { \n            # dgg: see TypeMapper; both pseudo mRNA,misc_RNA should be pseudogenic_transcript\n               $sf->primary_tag(\"pseudotranscript\");\n           }\n           else {\n               $sf->primary_tag(\"pseudo$type\");\n           }\n       }\n   }\n   # now some of the post-processing that follows which applies to\n   # genes will NOT be applied to pseudogenes; this is deliberate\n   # for example, gene models are normalised to be gene-transcript-exon\n   # for pseudogenes we leave them as pseudogene-pseudoexon\n\n   # --- MAGIC ---\n   my $need_to_infer_exons = 0;\n   my $need_to_infer_mRNAs = 0;\n   my @removed_exons = ();\n   if ($use_magic) {\n       if (defined($structure_type)) {\n\t   $self->throw(\"Can't combine use_magic AND setting structure_type\");\n       }\n       my $n_introns =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_exons =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_mrnas =\n\t scalar(grep {$_->primary_tag eq 'mRNA'} @flat_seq_features);\n       my $n_mrnas_attached_to_gene =\n\t scalar(grep {$_->primary_tag eq 'mRNA' &&\n\t\t\t$_->has_tag($group_tag)} @flat_seq_features);\n       my $n_cdss =\n\t scalar(grep {$_->primary_tag eq 'CDS'} @flat_seq_features);\n       my $n_rnas =\n\t scalar(grep {$_->primary_tag =~ /RNA/} @flat_seq_features);  \n       # Are there any CDS features in the record?\n       if ($n_cdss > 0) {\n           # YES\n           \n\t   # - a pc gene model should contain at the least a CDS\n\n           # Are there any mRNA features in the record?\n\t   if ($n_mrnas == 0) {\n               # NO mRNAs:\n\t       # looks like structure_type == 1\n\t       $structure_type = 1;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   elsif ($n_mrnas_attached_to_gene == 0) {\n               # $n_mrnas > 0\n               # $n_mrnas_attached_to_gene = 0\n               #\n               # The entries _do_ contain mRNA features,\n               # but none of them are part of a group/gene, i.e. they\n               # are 'floating'\n\n\t       # this is an annoying weird file that has some floating\n\t       # mRNA features; \n\t       # eg ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/\n               \n               if ($self->verbose) {\n                   my @floating_mrnas =\n                     grep {$_->primary_tag eq 'mRNA' &&\n                             !$_->has_tag($group_tag)} @flat_seq_features;\n                   printf STDERR \"Unattached mRNAs:\\n\";\n                   foreach my $mrna (@floating_mrnas) {\n                       $self->_write_sf_detail($mrna);\n                   }\n                   printf STDERR \"Don't know how to deal with these; filter at source?\\n\";\n               }\n\n\t       foreach (@flat_seq_features) {\n\t\t   if ($_->primary_tag eq 'mRNA') {\n\t\t       # what should we do??\n\t\t       \n\t\t       # I think for pombe we just have to filter\n\t\t       # out bogus mRNAs prior to starting\n\t\t   }\n\t       }\n\n\t       # looks like structure_type == 2\n\t       $structure_type = 2;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   else {\n\t   }\n\n\t   # we always infer exons in magic mode\n\t   $need_to_infer_exons = 1;\n       }\n       else {\n\t   # this doesn't seem to be any kind of protein coding gene model\n\t   if ( $n_rnas > 0 ) {\n\t       $need_to_infer_exons = 1;\n\t   }\n       }\n\n       if ($need_to_infer_exons) {\n\t   # remove exons and introns from group -\n\t   # we will infer exons later, and we\n\t   # can always infer introns from exons\n\t   foreach my $group (@groups) {\n\t       @$group = \n\t\t grep {\n\t\t     my $type = $_->primary_tag();\n\t\t     if ($type eq 'exon') {\n\t\t\t # keep track of all removed exons,\n\t\t\t # so we can do a sanity check later\n\t\t\t push(@removed_exons, $_);\n\t\t     }\n\t\t     $type ne 'exon' && $type ne 'intron'\n\t\t } @$group;\n\t   }\n\t   # get rid of any groups that have zero members\n\t   @groups = grep {scalar(@$_)} @groups;\n       }\n   }\n   # --- END OF MAGIC ---\n   \n   # LOGICAL ASSERTION\n   if (grep {!scalar(@$_)} @groups) {\n       $self->throw(\"ASSERTION ERROR: empty group\");\n   }\n\n   # LOGGING\n   if ($self->verbose > 0) {\n       printf STDERR \"GROUPS:\\n\";\n       foreach my $group (@groups) {\n\t   $self->_write_group($group, $group_tag);\n       }\n   }\n   # -\n\n   # --------- FINISHED GROUPING -------------\n\n\n   # TYPE CONTAINMENT HIERARCHY (aka partonomy)\n   # set the containment hierarchy if desired\n   # see docs for structure_type() method\n   if ($structure_type) {\n       if ($structure_type == 1) {\n\t   $self->partonomy(\n                            {CDS => 'gene',\n                             exon => 'CDS',\n                             intron => 'CDS',\n                            }\n                           );\n       }\n       else {\n\t   $self->throw(\"structure_type $structure_type is currently unknown\");\n       }\n   }\n\n   # see if we have an obvious resolver_tag\n   if ($use_magic) {\n       foreach my $sf (@all_seq_features) {\n\t   if ($sf->has_tag('derived_from')) {\n\t       $resolver_tag = 'derived_from';\n\t   }\n       }\n   }\n\n   if ($use_magic) {\n       # point all feature types without a container type to the root type.\n       #\n       # for example, if we have an unanticipated feature_type, say\n       # 'aberration', this should by default point to the parent 'gene'\n       foreach my $group (@groups) {\n\t   my @sfs = @$group;\n\t   if (@sfs > 1) {\n\t       foreach my $sf (@sfs) {\n\t\t   my $type = $sf->primary_tag;\n\t\t   next if $type eq 'gene';\n\t\t   my $container_type = $self->get_container_type($type);\n\t\t   if (!$container_type) {\n\t\t       $self->partonomy->{$type} = 'gene';\n\t\t   }\n\t       }\n\t   }\n       }\n   }\n\n   # we have done the first part of the unflattening.\n   # we now have a list of groups; each group is a list of seqfeatures.\n   # the actual group itself is flat; we may want to unflatten this further;\n   # for instance, a gene model can contain multiple mRNAs and CDSs. We may want\n   # to link the correct mRNA to the correct CDS via the bioperl sub_SeqFeature tree.\n   #\n   # what we would end up with would be\n   #  gene1\n   #    mRNA-a\n   #      CDS-a\n   #    mRNA-b\n   #      CDS-b\n   my @top_sfs = $self->unflatten_groups(-groups=>\\@groups,\n                                         -resolver_method=>$resolver_method,\n\t\t\t\t\t -resolver_tag=>$resolver_tag);\n   \n   # restore settings\n   $self->partonomy($old_partonomy);\n\n   # restore settings\n   $self->structure_type($old_structure_type);\n\n   # modify the original Seq object - the top seqfeatures are now\n   # the top features from each group\n   $seq->remove_SeqFeatures;\n   $seq->add_SeqFeature(@top_sfs);\n\n   # --------- FINISHED UNFLATTENING -------------\n\n   # lets see if there are any post-unflattening tasks we need to do\n\n   \n\n   # INFERRING mRNAs\n   if ($need_to_infer_mRNAs) {\n       if ($self->verbose > 0) {\n\t   printf STDERR \"** INFERRING mRNA from CDS\\n\";\n       }\n       $self->infer_mRNA_from_CDS(-seq=>$seq);\n   }\n\n   # INFERRING exons\n   if ($need_to_infer_exons) {\n\n       # infer exons, one group/gene at a time\n       foreach my $sf (@top_sfs) {\n\t   my @sub_sfs = ($sf, $sf->get_all_SeqFeatures);\n\t   $self->feature_from_splitloc(-features=>\\@sub_sfs);\n       }\n\n       # some exons are stated explicitly; ie there is an \"exon\" feature\n       # most exons are inferred; ie there is a \"mRNA\" feature with\n       # split locations\n       #\n       # if there were exons explicitly stated in the entry, we need to\n       # do two things:\n       #\n       # make sure these exons are consistent with the inferred exons\n       #  (you never know)\n       #\n       # transfer annotation (tag-vals) from the explicit exon to the\n       # new inferred exon\n       if (@removed_exons) {\n\t   my @allfeats = $seq->get_all_SeqFeatures;\n\n\t   # find all the inferred exons that are children of mRNA\n\t   my @mrnas =  grep {$_->primary_tag eq 'mRNA'} @allfeats;\n\t   my @exons =  \n\t     grep {$_->primary_tag eq 'exon'}\n\t       map {$_->get_SeqFeatures} @mrnas;\n\n\t   my %exon_h = (); \t   # index of exons by location;\n\n\t   # there CAN be >1 exon at a location; we can represent these redundantly\n\t   # (ie as a tree, not a graph)\n\t   push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n\t   my @problems = ();      # list of problems;\n\t                           # each problem is a \n\t                           # [$severity, $description] pair\n\t   my $problem = '';\n\t   my ($n_exons, $n_removed_exons) =\n\t     (scalar(keys %exon_h), scalar(@removed_exons));\n\t   foreach my $removed_exon (@removed_exons) {\n\t       my $locstr = $self->_locstr($removed_exon);\n\t       my $inferred_exons = $exon_h{$locstr};\n\t       delete $exon_h{$locstr};\n\t       if ($inferred_exons) {\n\t\t   my %exons_done = ();\n\t\t   foreach my $exon (@$inferred_exons) {\n\n\t\t       # make sure we don't move stuff twice\n\t\t       next if $exons_done{$exon};\n\t\t       $exons_done{$exon} = 1;\n\n\t\t       # we need to tranfer any tag-values from the explicit\n\t\t       # exon to the implicit exon\n\t\t       foreach my $tag ($removed_exon->get_all_tags) {\n\t\t\t   my @vals = $removed_exon->get_tag_values($tag);\n\t\t\t   if (!$exon->can(\"add_tag_value\")) {\n\t\t\t       # I'm puzzled as to what should be done here;\n\t\t\t       # SeqFeatureIs are not necessarily mutable,\n\t\t\t       # but we know that in practice the implementing\n\t\t\t       # class is mutable\n\t\t\t       $self->throw(\"The SeqFeature object does not \".\n\t\t\t\t\t    \"implement add_tag_value()\");\n\t\t\t   }\n\t\t\t   $exon->add_tag_value($tag, @vals);\n\t\t       }\n\t\t   }\n\t       } \n               else {\n                   # no exons inferred at $locstr\n\t\t   push(@problems,\n\t\t\t[1, \n\t\t\t \"there is a conflict with exons; there was an explicitly \".\n\t\t\t \"stated exon with location $locstr, yet I cannot generate \".\n\t\t\t \"this exon from the supplied mRNA locations\\n\"]);\n\t       }\n\t   }\n\t   # do we have any inferred exons left over, that were not\n\t   # covered in the explicit exons?\n\t   if (keys %exon_h) {\n\t       # TODO - we ignore this problem for now\n\t       push(@problems,\n\t\t    [1,\n\t\t     sprintf(\"There are some inferred exons that are not in the \".\n\t\t\t     \"explicit exon list; they are the exons at locations:\\n\".\n\t\t\t     join(\"\\n\", keys %exon_h).\"\\n\")]);\n\t   }\n\n\t   # report any problems\n\t   if (@problems) {\n\t       my $thresh = $self->error_threshold;\n\t       my @bad_problems = grep {$_->[0] > $thresh} @problems;\n\t       if (@bad_problems) {\n\t\t   printf STDERR \"PROBLEM:\\n\";\n\t\t   $self->_write_hier(\\@top_sfs);\n\t\t   # TODO - allow more fine grained control over this\n\t\t   $self->{_problems_reported} = 1;\n\t\t   $self->throw(join(\"\\n\",\n\t\t\t\t     map {\"@$_\"} @bad_problems));\n\t       }\n\t       $self->problem(@$_) foreach @problems;\n\t   }\n       }\n   }    \n   # --- end of inferring exons --\n\n   # return new top level features; this can also \n   # be retrieved via\n   #   $seq->get_SeqFeatures();\n#   return @top_sfs;\n   return $seq->get_SeqFeatures;\n}\n\n# _split_group_if_disconnected([@sfs])\n#\n# as well as having the same group_tag, a group should be spatially\n# connected. if not, then the group should be split into subgroups.\n# this turns out to be necessary in the case of multicopy genes.\n# the standard way to represent these is as spatially disconnected\n# gene models (usually a 'gene' feature and some kind of RNA feature)\n# with the same group tag; the code below will split these into \n# seperate groups, one per copy.\n\nsub _split_group_if_disconnected {\n    my $self = shift;\n    my $group = shift;\n    my @sfs = @$group;\n    my @ranges =\n      Bio::Range->disconnected_ranges(@sfs);\n    my @groups;\n    if (@ranges == 0) {\n\t$self->throw(\"ASSERTION ERROR\");\n    }\n    elsif (@ranges == 1) {\n\t# no need to split the group\n\t@groups = ($group);\n    }\n    else {\n\t# @ranges > 1\n\t# split the group into disconnected ranges\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"GROUP PRE-SPLIT:\\n\";\n\t    $self->_write_group($group, $self->group_tag);\n\t}\n\t@groups =\n\t  map {\n\t      my $range = $_;\n\t      [grep {\n\t\t  $_->intersection($range);\n\t      } @sfs]\n\t  } @ranges;\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"SPLIT GROUPS:\\n\";\n\t    $self->_write_group($_, $self->group_tag) foreach @groups;\t    \n\t}\n    }\n    return @groups;\n}\n\nsub _remove_duplicates_from_group {\n    my $self = shift;\n    my $group = shift;\n\n    # ::: WEIRD BOUNDARY CASE CODE :::\n    # for some reason, there are some gb records with two gene\n    # features for one gene; for example, see ATF14F8.gbk\n    # in the t/data directory\n    #\n    # in this case, we get rid of one of the genes\n\n    my @genes = grep {$_->primary_tag eq 'gene'} @$group;\n    if (@genes > 1) {\n\t# OK, if we look at ATF14F8.gbk we see that some genes\n\t# just exist as a single location, some exist as a multisplit location;\n\t#\n\t# eg\n\n\t#     gene            16790..26395\n\t#                     /gene=\"F14F8_60\"\n\t#     ...\n\t#     gene            complement(join(16790..19855,20136..20912,21378..21497,\n\t#                     21654..21876,22204..22400,22527..23158,23335..23448,\n\t#                     23538..23938,24175..24536,24604..24715,24889..24984,\n\t#                     25114..25171,25257..25329,25544..25589,25900..26018,\n\t#                     26300..26395))\n\t#                     /gene=\"F14F8_60\"\n\n\t# the former is the 'standard' way of representing the gene in genbank;\n\t# the latter is redundant with the CDS entry. So we shall get rid of\n\t# the latter with the following filter\n\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"REMOVING DUPLICATES:\\n\";\n\t}\n\n\t@genes =\n\t  grep {\n\t      my $loc = $_->location;\n\t      if ($loc->isa(\"Bio::Location::SplitLocationI\")) {\n\t\t  my @locs = $loc->each_Location;\t\t  \n\t\t  if (@locs > 1) {\n\t\t      0;\n\t\t  }\n\t\t  else {\n\t\t      1;\n\t\t  }\n\t      }\n\t      else {\n\t\t  1;\n\t      }\n\t  } @genes;\n\n\tif (@genes > 1) {\n\t    # OK, that didn't work. Our only resort is to just pick one at random\n\t    @genes = ($genes[0]);\n\t}\n\tif (@genes) {\n\t    @genes == 1 || $self->throw(\"ASSERTION ERROR\");\n\t    @$group =\n\t      ($genes[0], grep {$_->primary_tag ne 'gene'} @$group);\n\t}\n    }\n    # its a dirty job but someone's gotta do it\n    return;\n}\n\n\n=head2 unflatten_groups\n\n Title   : unflatten_groups\n Usage   :\n Function: iterates over groups, calling unflatten_group() [see below]\n Example :\n Returns : list of Bio::SeqFeatureI objects that are holders\n Args    : see below\n\nArguments\n\n  -groups:          list of list references; inner list is of Bio::SeqFeatureI objects\n                    e.g.  ( [$sf1], [$sf2, $sf3, $sf4], [$sf5, ...], ...)\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_groups{\n   my ($self,@args) = @_;\n   my($groups, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUPS\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   # this is just a simple wrapper for unflatten_group()\n   return \n     map {\n         $self->unflatten_group(-group=>$_,\n                                -resolver_method=>$resolver_method,\n\t\t\t\t-resolver_tag=>$resolver_tag)\n     } @$groups;\n}\n\n=head2 unflatten_group\n\n Title   : unflatten_group\n Usage   :\n Function: nests a group of features into a feature containment hierarchy\n Example :\n Returns : Bio::SeqFeatureI objects that holds other features\n Args    : see below\n\nArguments\n\n  -group:           reference to list of Bio::SeqFeatureI objects\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_group{\n   my ($self,@args) = @_;\n\n   my($group, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUP\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   if ($self->verbose > 0) {\n       printf STDERR \"UNFLATTENING GROUP:\\n\";\n       $self->_write_group($group, $self->group_tag);\n   }\n\n   my @sfs = @$group;\n\n   # we can safely ignore singletons (e.g. [source])\n   return $sfs[0] if @sfs == 1;\n\n   my $partonomy = $self->partonomy;\n\n   # $resolver_method is a reference to a SUB that will resolve\n   # ambiguous parent/child containment; for example, determining\n   # which mRNAs go with which CDSs\n   $resolver_method = $resolver_method || \\&_resolve_container_for_sf;\n\n   # TAG BASED RESOLVING OF HIERARCHIES\n   #\n   # if the user specifies $resolver_tag, then we use this tag\n   # to pair up ambiguous parents and children;\n   #\n   # for example, the CDS feature may have a resolver tag of /derives_from\n   # which is a 'foreign key' into the /label tag of the mRNA feature\n   #\n   # this kind of tag-based resolution is possible for a certain subset\n   # of genbank records\n   #\n   # if no resolver tag is specified, we revert to the normal\n   # resolver_method\n   if ($resolver_tag) {\n       my $backup_resolver_method = $resolver_method;\n       # closure: $resolver_tag is remembered by this sub\n       my $sub = \n\t sub {\n\t     my ($self, $sf, @possible_container_sfs) = @_;\n\t     my @container_sfs = ();\n\t     if ($sf->has_tag($resolver_tag)) {\n\t\t my ($resolver_tagval) = $sf->get_tag_values($resolver_tag);\n\t\t # if a feature has a resolver_tag (e.g. /derives_from)\n\t\t # this specifies the /product, /symbol or /label for the\n\t\t # parent feature\n\t\t @container_sfs = \n\t\t   grep {\n\t\t       my $match = 0;\n\t\t       $self->_write_sf($_) if $self->verbose > 0;\n\t\t       foreach my $tag (qw(product symbol label)) {\n\t\t\t   if ($_->has_tag($tag)) {\n\t\t\t       my @vals =\n\t\t\t\t $_->get_tag_values($tag);\n\t\t\t       if (grep {$_ eq $resolver_tagval} @vals) {\n\t\t\t\t   $match = 1;\n\t\t\t\t   last;\n\t\t\t       }\n\t\t\t   }   \n\t\t       }\n\t\t       $match;\n\t\t   } @possible_container_sfs;\n\t     } \n\t     else {\n\t\t return $backup_resolver_method->($sf, @possible_container_sfs);\n\t     }\n\t     return map {$_=>0} @container_sfs;\n\t };\n       $resolver_method = $sub;\n   }\n   else {\n       # CONDITION: $resolver_tag is NOT set\n       $self->throw(\"assertion error\") if $resolver_tag;\n   }\n   # we have now set $resolver_method to a subroutine for\n   # disambiguatimng parent/child relationships. we will\n   # now build the whole containment hierarchy for this group\n\n\n   # FIND TOP/ROOT SEQFEATURES\n   #\n   # find all the features for which there is no\n   # containing feature type (eg genes)\n   my @top_sfs =\n     grep { \n         !$self->get_container_type($_->primary_tag);\n     } @sfs;\n\n   # CONDITION: there must be at most one root\n   if (@top_sfs > 1) {\n       $self->_write_group($group, $self->group_tag);\n       printf STDERR \"TOP SFS:\\n\";\n       $self->_write_sf($_) foreach @top_sfs;\n       $self->throw(\"multiple top-sfs in group\");\n   }\n   my $top_sf = $top_sfs[0];\n\n   # CREATE INDEX OF SEQFEATURES BY TYPE\n   my %sfs_by_type = ();\n   foreach my $sf (@sfs) {\n       push(@{$sfs_by_type{$sf->primary_tag}}, $sf);\n   }\n\n   # containment index; keyed by child; lookup parent\n   # note: this index uses the stringified object reference of\n   # the object as a surrogate lookup key\n\n   my %container = ();   # child -> parent\n\n   # ALGORITHM: build containment graph\n   #\n   # find all possible containers for each SF;\n   # for instance, for a CDS, the possible containers are all\n   # the mRNAs in the same group. For a mRNA, the possible\n   # containers are any SFs of type 'gene' (should only be 1).\n   # (these container-type mappings can be overridden)\n   #\n   # contention is resolved by checking coordinates of splice sites\n   # (this is the default, but can be overridden)\n   #\n   # most of the time, there is no problem identifying a unique\n   # parent for every child; this can be ambiguous when constructing\n   # CDS to mRNA relationships with lots of alternate splicing\n   #\n   # a hash of child->parent relationships is constructed (%container)\n   # any mappings that need further resolution (eg CDS to mRNA) are\n   # placed in %unresolved\n\n   # %unresolved index\n   # (keyed by stringified object reference of child seqfeature)\n   my %unresolved = ();    # child -> [parent,score] to be resolved\n                           \n   # index of seqfeatures by their stringified object reference;\n   # this is essentially a way of 'reviving' an object from its stringified\n   # reference\n   # (see NOTE ON USING OBJECTS AS KEYS IN HASHES, below)\n   my %idxsf = map {$_=>$_} @sfs;\n\n   foreach my $sf (@sfs) {\n       my $type = $sf->primary_tag;\n\n       # container type (e.g. the container type for CDS is usually mRNA)\n       my $container_type = \n         $self->get_container_type($type);\n       if ($container_type) {\n\n           my @possible_container_sfs =\n             @{$sfs_by_type{$container_type} || []};\n           # we now have a list of possible containers\n           # (eg for a CDS in an alternately spliced gene, this\n           #  would be a list of all the mRNAs for this gene)\n\n\t   if (!@possible_container_sfs) {\n\t       # root of hierarchy\n\t   }\n\t   else {\n\t       if (@possible_container_sfs == 1) {\n                   # this is the easy situation, whereby the containment\n                   # hierarchy is unambiguous. this will probably be the\n                   # case if the genbank record has no alternate splicing\n                   # within it\n\n\t\t   # ONE OPTION ONLY - resolved!\n\t\t   $container{$sf} = $possible_container_sfs[0];\n\n\t       }\n\t       else {\n\t\t   # MULTIPLE CONTAINER CHOICES\n\t\t   $self->throw(\"ASSERTION ERROR\") unless @possible_container_sfs > 1;\n\n                   # push this onto the %unresolved graph, and deal with it\n                   # later\n\n                   # for now we hardcode things such that the only type \n                   # with ambiguous parents is a CDS; if this is violated,\n                   # it has a weak problem class of '1' so the API user\n                   # can easily set things to ignore these\n\t\t   if ($sf->primary_tag ne 'CDS') {\n\t\t       $self->problem(1,\n\t\t\t\t      \"multiple container choice for non-CDS; \".\n\t\t\t\t      \"CDS to mRNA should be the only \".\n\t\t\t\t      \"relationships requiring resolving\",\n\t\t\t\t      $sf);\n\t\t   }\n\n                   # previously we set the SUB $resolver_method\n                   $self->throw(\"ASSERTION ERROR\")\n                     unless $resolver_method;\n\n                   # $resolver_method will assign scores to\n                   # parent/child combinations; later on we\n                   # will use these scores to find the optimal\n                   # parent/child pairings\n\n                   # the default $resolver_method uses splice sites to\n                   # score possible parent/child matches\n\n\t\t   my %container_sfh =\n\t\t     $resolver_method->($self, $sf, @possible_container_sfs);\n                   if (!%container_sfh) {\n                       $self->problem(2,\n                                      \"no containers possible for SeqFeature of \".\n                                      \"type: $type; this SF is being placed at \".\n                                      \"root level\",\n                                      $sf);\n                       # RESOLVED! (sort of - placed at root/gene level)\n                       $container{$sf} = $top_sf;\n\n                       # this sort of thing happens if the record is\n                       # badly messed up and there is absolutely no indication\n                       # of where to put the CDS. Perhaps we should just\n                       # place it with a random mRNA?\n                   }\n\t\t   foreach my $jsf (keys %container_sfh) {\n\n                       # add [score, parent] pairs to the %unresolved\n                       # lookup table/graph\n\t\t       push(@{$unresolved{$sf}}, \n\t\t\t    [$idxsf{$jsf}, $container_sfh{$jsf} || 0]);\n\t\t   }\n\t       }\n\t   }\n       }\n       else {\n           # CONDITION:\n           # not container type for $sf->primary_tag\n           \n           # CONDITION:\n\t   # $sf must be a root/top node (eg gene)\n       }\n   }\n\n   if (0) {\n\n       # CODE CURRENTLY DISABLED\n\n       # we require a 1:1 mapping between mRNAs and CDSs;\n       # create artificial duplicates if we can't do this...\n       if (%unresolved) {\n           my %childh = map {$_=>1} keys %unresolved;\n           my %parenth = map {$_->[0]=>1} map {@$_} values %unresolved;\n           if ($self->verbose > 0) {\n               printf STDERR \"MATCHING %d CHILDREN TO %d PARENTS\\n\",\n                 scalar(keys %childh), scalar(keys %parenth);\n           }\n           # 99.99% of the time in genbank genomic record of structure type 0, we\n           # see one CDS for every mRNA; one exception is the S Pombe\n           # genome, which is all CDS, bar a few spurious mRNAs; we have to\n           # filter out the spurious mRNAs in this case\n           #\n           # another strange case is in the mouse genome, NT_078847.1\n           # for Pcdh13 you will notice there is 4 mRNAs and 5 CDSs.\n           # most unusual! \n           # I'm at a loss for a really clever thing to do here. I think the\n           # best thing is to create duplicate features to preserve the 1:1 mapping\n           #       my $suffix_id = 1;\n           #       while (keys %childh > keys %parenth) {\n           #           \n           #       }\n       }\n   }\n\n   # DEBUGGING CODE\n   if ($self->verbose > 0 && scalar(keys %unresolved)) {\n       printf STDERR \"UNRESOLVED PAIRS:\\n\";\n       foreach my $childsf (keys %unresolved) {\n\t   my @poss = @{$unresolved{$childsf}};\n\t   foreach my $p (@poss) {\n\t       my $parentsf = $p->[0];\n\t       $childsf = $idxsf{$childsf};\n               my @clabels = ($childsf->get_tagset_values(qw(protein_id label product)), \"?\");\n               my @plabels = ($parentsf->get_tagset_values(qw(transcript_id label product)), \"?\");\n\t       printf STDERR\n                      (\"  PAIR: $clabels[0] => $plabels[0]  (of %d)\\n\", \n                       scalar(@poss));\n\t   }\n       }\n   } # -- end of verbose\n\n   # Now we have to fully resolve the containment hierarchy; remember,\n   # the graph %container has the fully resolved child->parent links;\n   #\n   # the graph %unresolved is keyed by children missing parents; we\n   # need to put all these orphans in the %container graph\n   #\n   # we do this using the scores in %unresolved, with the\n   # find_best_matches() algorithm\n   my $unresolved_problem_reported = 0;\n   if (%unresolved) {\n       my $new_pairs =\n\t $self->find_best_matches(\\%unresolved, []);\n       if (!$new_pairs) {\n           my ($g) = $sfs[0]->get_tagset_values($self->group_tag || 'gene');\n\t   $self->problem(2,\n\t\t\t  \"Could not resolve hierarchy for $g\");\n           $new_pairs = [];\n           $unresolved_problem_reported = 1;\n       }\n       foreach my $pair (@$new_pairs) {\n\t   if ($self->verbose > 0) {\n\t       printf STDERR \"  resolved pair @$pair\\n\";\n\t   }\n\t   $container{$pair->[0]} = $pair->[1];\n           delete $unresolved{$pair->[0]};\n       }\n   }\n\n   # CONDITION: containment hierarchy resolved\n   if (%unresolved) {\n       $self->throw(\"UNRESOLVED: %unresolved\")\n         unless $unresolved_problem_reported;\n   }\n\n   # make nested SeqFeature hierarchy from @containment_pairs\n   # ie put child SeqFeatures into parent SeqFeatures\n   my @top = ();\n   foreach my $sf (@sfs) {\n       my $container_sf = $container{$sf};\n       if ($container_sf) {\n           # make $sf nested inside $container_sf\n\n           # first check if the container spatially contains the containee\n           if ($container_sf->contains($sf)) {\n               # add containee\n\t       $container_sf->add_SeqFeature($sf);\n           }\n           else {\n               # weird case - the container does NOT spatially\n               # contain the containee;\n               # we expand and throw a warning\n               #\n               # for an example of this see ZFP91-CNTF dicistronic gene\n               # in NCBI chrom 11 build 34.3\n\t       $self->problem(1,\n\t\t\t      \"Container feature does not spatially contain \".\n                              \"subfeature. Perhaps this is a dicistronic gene? \".\n                              \"I am expanding the parent feature\",\n\t\t\t      $container_sf,\n\t\t\t      $sf);\n\t       $container_sf->add_SeqFeature($sf, 'EXPAND');\n           }\n       }\n       else {\n           push(@top, $sf);\n       }\n   }\n   return @top;\n} # -- end of unflatten_group\n\n# -------\n# A NOTE ON USING OBJECTS AS KEYS IN HASHES (stringified objects)\n#\n# Often we with to use seqfeatures as keys in a hashtable; because seqfeatures\n# in bioperl have no unique ID, we use a surrogate ID in the form of the\n# stringified object references - this is just what you get if you say\n#\n#  print \"$sf\\n\";\n#\n# this is guaranteed to be unique (within a particular perl execution)\n#\n# often we want to 'revive' the objects used as keys in a hash - once the\n# objects are used as keys, remember it is the *strings* used as keys and\n# not the object itself, so the object needs to be revived using another\n# hashtable that looks like this\n#\n#    %sfidx = map { $_ => $_ } @sfs\n#\n# -------\n\n\n# recursively finds the best set of pairings from a matrix of possible pairings\n#\n# tries to make sure nothing is unpaired\n#\n# given a matrix of POSSIBLE matches\n#  (matrix expressed as hash/lookup; keyed by child object; val = [parent, score]\n#\n# \nsub find_best_matches {\n    my $self = shift;\n    my $matrix = shift;\n    my $pairs = shift;        # [child,parent] pairs already selected\n\n    my $verbose = $self->verbose;\n    #################################print \"I\";\n    if ($verbose > 0) {\n\tprintf STDERR \"find_best_matches: (/%d)\\n\", scalar(@$pairs);\n    }\n\n    my %selected_children = map {($_->[0]=>1)} @$pairs;\n    my %selected_parents = map {($_->[1]=>1)} @$pairs;\n    \n    # make a copy of the matrix with the portions still to be\n    # resolved\n    my %unresolved_parents = ();\n    my %unresolved =\n      map {\n          if ($verbose > 0) {\n              printf STDERR \"  $_ : %s\\n\", join(\"; \", map {\"[@$_]\"} @{$matrix->{$_}});\n          }\n\t  if ($selected_children{$_}) {\n\t      ();\n\t  }\n\t  else {\n\t      my @parents =\n\t\tgrep {\n\t\t    !$selected_parents{$_->[0]}\n\t\t} @{$matrix->{$_}};\n              $unresolved_parents{$_} = 1 foreach @parents;\n              # new parents\n\t      ($_ => [@parents]);\n\t  }\n      } keys %$matrix;\n    \n    my @I = keys %unresolved;\n\n    return $pairs if !scalar(keys %unresolved_parents);\n    # NECESSARY CONDITION:\n    # all possible parents have a child match\n\n    return $pairs if !scalar(@I);\n    # NECESSARY CONDITION:\n    # all possible children have a parent match\n\n    # give those with fewest choices highest priority\n    @I = sort {\n\t# n possible parents\n\tscalar(@{$unresolved{$a}}) \n\t  <=>\n\t    scalar(@{$unresolved{$b}}) ;\n    } @I;\n    \n    my $csf = shift @I;\n\n    my @J = @{$unresolved{$csf}};  # array of [parent, score]\n\n    # sort by score, highest first\n    @J =\n      sort {\n\t  $b->[1] <=> $a->[1]\n      } @J;\n\n    # select pair(s) from remaining matrix of possible pairs\n    # by iterating through possible parents\n\n    my $successful_pairs;\n    foreach my $j (@J) {\n\tmy ($psf, $score) = @$j;\n\t# would selecting $csf, $psf as a pair\n\t# remove all choices from another?\n\tmy $bad = 0;\n\tforeach my $sf (@I) {\n\t    if (!grep {$_->[0] ne $psf} @{$unresolved{$sf}}) {\n\t\t# $psf was the only parent choice for $sf\n\t\t$bad = 1;\n\t\tlast;\n\t    }\n\t}\n\tif (!$bad) {\n\t    my $pair = [$csf, $psf];\n\t    my $new_pairs = [@$pairs, $pair];\n\t    my $set = $self->find_best_matches($matrix, $new_pairs);\n\t    if ($set) {\n\t\t$successful_pairs = $set;\n\t\tlast;\n\t    }\n\t}\n    }\n    # success\n    return $successful_pairs if $successful_pairs;\n    # fail\n    return 0;\n}\n\n# ----------------------------------------------\n# writes a group to stdout\n#\n# mostly for logging/debugging\n# ----------------------------------------------\nsub _write_group {\n    my $self = shift;\n    my $group = shift;\n    my $group_tag = shift || 'gene';\n\n    my $f = $group->[0];\n    my $label = '?';\n    if ($f->has_tag($group_tag)) {\n\t($label) = $f->get_tag_values($group_tag);\n    }\n    if( $self->verbose > 0 ) { \n\tprintf STDERR (\"  GROUP [%s]:%s\\n\",\n\t       $label,\n\t       join(' ',\n\t\t    map { $_->primary_tag } @$group));\n    }\n\n}\n\nsub _write_sf {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    return;\n}\n\nsub _write_sf_detail {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    my @locs = $sf->location->each_Location;\n    printf STDERR \"  %s,%s [%s]\\n\", $_->start, $_->end, $_->strand foreach @locs;\n    return;\n}\n\nsub _write_hier {\n    my $self = shift;\n    my @sfs = @{shift || []};\n    my $indent = shift || 0;\n    if( $self->verbose > 0 ) {\n\tforeach my $sf (@sfs) {\n\t    my $label = '?';\n\t    if ($sf->has_tag('product')) {\n\t\t($label) = $sf->get_tag_values('product');\n\t    }\n\t    printf STDERR \"%s%s $label\\n\", '  ' x $indent, $sf->primary_tag;\n\t    my @sub_sfs = $sf->sub_SeqFeature;\n\t    $self->_write_hier(\\@sub_sfs, $indent+1);\n\t}\n    }\n}\n\n# -----------------------------------------------\n#\n# returns all possible containers for an SF based\n# on splice site coordinates; splice site coords\n# must be contained\n# -----------------------------------------------\nsub _resolve_container_for_sf{\n   my ($self, $sf, @possible_container_sfs) = @_;\n\n   my @coords = $self->_get_splice_coords_for_sf($sf);\n   my $start = $sf->start;\n   my $end = $sf->end;\n   my $splice_uniq_str = \"@coords\";\n   \n   my @sf_score_pairs = ();\n   # a CDS is contained by a mRNA if the locations of the splice\n   # coordinates are identical\n   foreach (@possible_container_sfs) {\n       my @container_coords = $self->_get_splice_coords_for_sf($_);\n       my $inside = \n\t !$splice_uniq_str || \n\t   index(\"@container_coords\", $splice_uniq_str) > -1;\n       if ($inside) {\n           # the container cannot be smaller than the thing contained\n           if ($_->start > $start || $_->end < $end) {\n               $inside = 0;\n           }\n       }\n       if ($self->verbose > 0) {\n\t   printf STDERR \"    Checking containment:[$inside] (@container_coords) IN ($splice_uniq_str)\\n\";\n       }\n       if ($inside) {\n\t   # SCORE: matching (ss-scoords+2)/(n-container-ss-coords+2)\n\t   my $score =\n\t     (scalar(@coords)+2)/(scalar(@container_coords)+2);\n\t   push(@sf_score_pairs,\n\t\t$_=>$score);\n       }\n   }\n   # return array ( $sf1=>$score1, $sf2=>$score2, ...)\n   return @sf_score_pairs;\n}\n\nsub _get_splice_coords_for_sf {\n    my $self = shift;\n    my $sf = shift;\n\n   my @locs = $sf->location;\n   if ($sf->location->isa(\"Bio::Location::SplitLocationI\")) {\n       @locs = $sf->location->each_Location;\n   }\n\n   # get an ordered list of (start, end) positions\n\n#   my @coords =\n#     map {\n#         $_->strand > 0 ? ($_->start, $_->end) : ($_->end, $_->start)\n#     } @locs;\n\n    my @coords = map {($_->start, $_->end)} @locs;\n\n   # remove first and last leaving only splice sites\n   pop @coords;\n   shift @coords;\n    return @coords;\n}\n\n=head2 feature_from_splitloc\n\n Title   : feature_from_splitloc\n Usage   : $unflattener->feature_from_splitloc(-features=>$sfs);\n Function:\n Example :\n Returns : \n Args    : see below\n\nAt this time all this method does is generate exons for mRNA or other RNA features\n\nArguments:\n\n  -feature:    a Bio::SeqFeatureI object (that conforms to Bio::FeatureHolderI)\n  -seq:        a Bio::SeqI object that contains Bio::SeqFeatureI objects\n  -features:   an arrayref of Bio::SeqFeatureI object\n\n\n\nsub feature_from_splitloc{\n   my ($self,@args) = @_;\n\n   my($sf, $seq, $sfs) =\n     $self->_rearrange([qw(FEATURE\n                           SEQ\n\t\t\t   FEATURES\n                          )],\n                          @args);\n   my @sfs = (@{$sfs || []});\n   push(@sfs, $sf) if $sf;\n   if ($seq) {\n       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n       @sfs = $seq->get_all_SeqFeatures;\n   }\n   my @exons = grep {$_->primary_tag eq 'exon'} @sfs;\n   if (@exons) {\n       $self->problem(2,\n\t\t      \"There are already exons, so I will not infer exons\");\n   }\n\n   # index of features by type+location\n   my %loc_h = ();\n\n   # infer for every feature\n   foreach my $sf (@sfs) {\n\n       $sf->isa(\"Bio::SeqFeatureI\") || $self->throw(\"$sf NOT A SeqFeatureI\");\n       $sf->isa(\"Bio::FeatureHolderI\") || $self->throw(\"$sf NOT A FeatureHolderI\");\n\n       my $type = $sf->primary_tag;\n       next unless $type eq 'mRNA' or $type =~ /RNA/;\n\n       # an mRNA from genbank will have a discontinuous location,\n       # with each sub-location being equivalent to an exon\n       my @locs = $sf->location;\n\n       if ($sf->location->isa(\"Bio::Location::SplitLocationI\")) {\n           @locs = $sf->location->each_Location;\n       }\n\n       if (!@locs) {\n           use Data::Dumper;\n           print Dumper $sf;\n\t   $self->throw(\"ASSERTION ERROR: sf has no location objects\");\n       }\n\n       # make exons from locations\n       my @subsfs =\n         map {\n             my $subsf = Bio::SeqFeature::Generic->new(-location=>$_,\n                                                       -primary_tag=>'exon');\n             ## Provide seq_id to new feature:\n             $subsf->seq_id($sf->seq_id) if $sf->seq_id;\n             $subsf->source_tag($sf->source_tag) if $sf->source_tag;\n             ## Transfer /locus_tag and /gene tag values to inferred\n             ## features.  TODO: Perhaps? this should not be done\n             ## indiscriminantly but rather by virtue of the setting\n             ## of group_tag.\n             foreach my $tag (grep /gene|locus_tag/, $sf->get_all_tags) {\n                 my @vals = $sf->get_tag_values($tag);\n                 $subsf->add_tag_value($tag, @vals);\n             }\n\n\t     my $locstr = 'exon::'.$self->_locstr($subsf);\n\n\t     # re-use feature if type and location the same\n\t     if ($loc_h{$locstr}) {\n\t\t $subsf = $loc_h{$locstr};\n\t     }\n\t     else {\n\t\t $loc_h{$locstr} = $subsf;\n\t     }\n             $subsf;\n         } @locs;\n       \n       # PARANOID CHECK\n       $self->_check_order_is_consistent($sf->location->strand,@subsfs);\n       #----\n\n       $sf->location(Bio::Location::Simple->new());\n\n       # we allow the exons to define the boundaries of the transcript\n       $sf->add_SeqFeature($_, 'EXPAND') foreach @subsfs;\n\n\n       if (!$sf->location->strand) {\n\t   # correct weird bioperl bug in previous versions;\n\t   # strand was not being set correctly\n\t   $sf->location->strand($subsfs[0]->location->strand);\n       }\n\n       \n   }\n   return;\n}\n\n#sub merge_features_with_same_loc {\n#   my ($self,@args) = @_;\n\n#   my($sfs, $seq) =\n#     $self->_rearrange([qw(FEATURES\n#                           SEQ\n#                          )],\n#                          @args);\n#   my @sfs = (@$sfs);\n#   if ($seq) {\n#       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n#       @sfs = $seq->get_all_SeqFeatures;\n#   }\n\n   \n#   my %loc_h = ();\n#   foreach my $sf (@sfs) {\n#       my $type = $sf->primary_tag;\n#       my $locstr = $self->_locstr($sf);\n##       $loc_h{$type.$locstr}\n#       push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n#   }\n#}\n\n=head2 infer_mRNA_from_CDS\n\n Title   : infer_mRNA_from_CDS\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\ngiven a \"type 1\" containment hierarchy\n\n  gene\n    CDS\n      exon\n\nthis will infer the uniform \"type 0\" containment hierarchy\n\n  gene\n    mRNA\n      CDS\n      exon\n\nall the children of the CDS will be moved to the mRNA\n\na \"type 2\" containment hierarchy is mixed type \"0\" and \"1\" (for\nexample, see ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/)","parameters":[{"label":"$self"},{"label":"@args"}]},"name":"infer_mRNA_from_CDS","range":{"end":{"line":2680,"character":9999},"start":{"line":2604,"character":0}}},{"kind":12,"line":2642,"containerName":"Location::Split","name":"Bio"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":2645},{"name":"Bio","containerName":"SeqFeature::Generic","kind":12,"line":2652},{"line":2702,"children":[{"kind":13,"line":2703,"containerName":"remove_types","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":2703,"name":"@args","containerName":"remove_types"},{"kind":13,"line":2705,"containerName":"remove_types","definition":"my","name":"$seq","localvar":"my"},{"line":2705,"kind":13,"name":"$types","containerName":"remove_types"},{"containerName":"remove_types","name":"$self","kind":13,"line":2706},{"name":"_rearrange","containerName":"remove_types","line":2706,"kind":12},{"kind":13,"line":2711,"name":"@args","containerName":"remove_types"},{"name":"$seq","containerName":"remove_types","kind":13,"line":2712},{"kind":12,"line":2712,"containerName":"remove_types","name":"isa"},{"kind":13,"line":2712,"name":"$self","containerName":"remove_types"},{"name":"throw","containerName":"remove_types","kind":12,"line":2712},{"containerName":"remove_types","name":"@sfs","definition":"my","localvar":"my","kind":13,"line":2713},{"containerName":"remove_types","name":"$seq","line":2713,"kind":13},{"name":"get_all_SeqFeatures","containerName":"remove_types","kind":12,"line":2713},{"kind":13,"line":2714,"containerName":"remove_types","definition":"my","name":"%rh","localvar":"my"},{"containerName":"remove_types","name":"$types","kind":13,"line":2714},{"containerName":"remove_types","name":"@sfs","kind":13,"line":2715},{"name":"$rh","containerName":"remove_types","kind":13,"line":2715},{"name":"primary_tag","containerName":"remove_types","line":2715,"kind":12},{"kind":13,"line":2715,"name":"@sfs","containerName":"remove_types"},{"line":2716,"kind":13,"containerName":"remove_types","name":"$seq"},{"name":"remove_SeqFeatures","containerName":"remove_types","kind":12,"line":2716},{"name":"$seq","containerName":"remove_types","kind":13,"line":2717},{"line":2717,"kind":12,"name":"add_SeqFeature","containerName":"remove_types"},{"kind":13,"line":2717,"containerName":"remove_types","name":"@sfs"}],"kind":12,"detail":"($self,@args)","signature":{"label":"remove_types($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Unflattener.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::Unflattener\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::Unflattener - turns flat list of genbank-sourced features into a nested SeqFeatureI hierarchy\n\n=head1 SYNOPSIS\n\n  # standard / generic use - unflatten a genbank record\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::Unflattener;\n\n  # generate an Unflattener object\n  $unflattener = Bio::SeqFeature::Tools::Unflattener->new;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  my $out =\n    Bio::SeqIO->new(-format=>'asciitree');\n  while ($seq = $seqio->next_seq()) {\n\n    # get top level unflattended SeqFeatureI objects\n    $unflattener->unflatten_seq(-seq=>$seq,\n                                -use_magic=>1);\n    $out->write_seq($seq);\n\n    @top_sfs = $seq->get_SeqFeatures;\n    foreach my $sf (@top_sfs) {\n\t# do something with top-level features (eg genes)\n    }\n  }\n\n\n=head1 DESCRIPTION\n\nMost GenBank entries for annotated genomic DNA contain a B<flat> list\nof features. These features can be parsed into an equivalent flat list\nof L<Bio::SeqFeatureI> objects using the standard L<Bio::SeqIO>\nclasses. However, it is often desirable to B<unflatten> this list into\nsomething resembling actual B<gene models>, in which genes, mRNAs and CDSs\nare B<nested> according to the nature of the gene model.\n\nThe BioPerl object model allows us to store these kind of associations\nbetween SeqFeatures in B<containment hierarchies> -- any SeqFeatureI\nobject can contain nested SeqFeatureI objects. The\nBio::SeqFeature::Tools::Unflattener object facilitates construction of\nthese hierarchies from the underlying GenBank flat-feature-list\nrepresentation.\n\nFor example, if you were to look at a typical GenBank DNA entry, say,\nB<AE003644>, you would see a flat list of features:\n\n  source\n\n  gene CG4491\n  mRNA CG4491-RA\n  CDS CG4491-PA\n\n  gene tRNA-Pro\n  tRNA tRNA-Pro\n\n  gene CG32954\n  mRNA CG32954-RA\n  mRNA CG32954-RC\n  mRNA CG32954-RB\n  CDS CG32954-PA\n  CDS CG32954-PB\n  CDS CG32954-PC\n\nThese features have sequence locations, but it is not immediately\nclear how to write code such that each mRNA is linked to the\nappropriate CDS (other than relying on IDs which is very bad)\n\nWe would like to convert the above list into the B<containment\nhierarchy>, shown below:\n\n  source\n  gene\n    mRNA CG4491-RA\n      CDS CG4491-PA\n      exon\n      exon\n  gene\n    tRNA tRNA-Pro\n      exon\n  gene\n    mRNA CG32954-RA\n      CDS CG32954-PA\n      exon\n      exon\n    mRNA CG32954-RC\n      CDS CG32954-PC\n      exon\n      exon\n    mRNA CG32954-RB\n      CDS CG32954-PB\n      exon\n      exon\n\nWhere each feature is nested underneath its container. Note that exons\nhave been automatically inferred (even for tRNA genes).\n\nWe do this using a call on a L<Bio::SeqFeature::Tools::Unflattener>\nobject\n\n  @sfs = $unflattener->unflatten_seq(-seq=>$seq);\n\nThis would return a list of the B<top level> (i.e. container)\nSeqFeatureI objects - in this case, genes. Other top level features\nare possible; for instance, the B<source> feature which is always\npresent, and other features such as B<variation> or B<misc_feature>\ntypes.\n\nThe containment hierarchy can be accessed using the get_SeqFeature()\ncall on any feature object - see L<Bio::SeqFeature::FeatureHolderI>.\nThe following code will traverse the containment hierarchy for a\nfeature:\n\n  sub traverse {\n    $sf = shift;   #  $sf isa Bio::SeqfeatureI\n\n    # ...do something with $sf!\n\n    # depth first traversal of containment tree\n    @contained_sfs = $sf->get_SeqFeatures;\n    traverse($_) foreach @contained_sfs;\n  }\n\nOnce you have built the hierarchy, you can do neat stuff like turn the\nfeatures into 'rich' feature objects (eg\nL<Bio::SeqFeature::Gene::GeneStructure>) or convert to a suitable\nformat such as GFF3 or chadoxml (after mapping to the Sequence\nOntology); this step is not described here.\n\n=head1 USING MAGIC\n\nDue to the quixotic nature of how features are stored in\nGenBank/EMBL/DDBJ, there is no guarantee that the default behaviour of\nthis module will produce perfect results. Sometimes it is hard or\nimpossible to build a correct containment hierarchy if the information\nprovided is simply too lossy, as is often the case. If you care deeply\nabout your data, you should always manually inspect the resulting\ncontainment hierarchy; you may have to customise the algorithm for\nbuilding the hierarchy, or even manually tweak the resulting\nhierarchy. This is explained in more detail further on in the document.\n\nHowever, if you are satisfied with the default behaviour, then you do\nnot need to read any further. Just make sure you set the parameter\nB<use_magic> - this will invoke incantations which will magically\nproduce good results no matter what the idiosyncracies of the\nparticular GenBank record in question.\n\nFor example\n\n  $unflattener->unflatten_seq(-seq=>$seq,\n                              -use_magic=>1);\n\nThe success of this depends on the phase of the moon at the time the\nentry was submitted to GenBank. Note that the magical recipe is being\nconstantly improved, so the results of invoking magic may vary\ndepending on the bioperl release.\n\nIf you are skeptical of magic, or you wish to exact fine grained\ncontrol over how the entry is unflattened, or you simply wish to\nunderstand more about how this crazy stuff works, then read on!\n\n=head1 PROBLEMATIC DATA AND INCONSISTENCIES\n\nOccasionally the Unflattener will have problems with certain\nrecords. For example, the record may contain inconsistent data - maybe\nthere is an B<exon> entry that has no corresponding B<mRNA> location. \n\nThe default behaviour is to throw an exception reporting the problem,\nif the problem is relatively serious - for example, inconsistent data.\n\nYou can exert more fine grained control over this - perhaps you want\nthe Unflattener to do the best it can, and report any problems. This\ncan be done - refer to the methods.\n\n  error_threshold()\n\n  get_problems()\n\n  report_problems()\n\n  ignore_problems()\n\n=head1 ALGORITHM\n\nThis is the default algorithm; you should be able to override any part\nof it to customise.\n\nThe core of the algorithm is in two parts\n\n\n* Partitioning the flat feature list into groups\n\n* Resolving the feature containment hierarchy for each group\n\n\nThere are other optional steps after the completion of these two\nsteps, such as B<inferring exons>; we now describe in more detail what\nis going on.\n\n=head2 Partitioning into groups\n\nFirst of all the flat feature list is partitioned into B<group>s.\n\nThe default way of doing this is to use the B<gene> attribute; if we\nlook at two features from GenBank accession AE003644.3:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nBoth these features share the same /gene tag which is \"noc\", so they\ncorrespond to the same gene model (the CDS feature is not shown, but\nthis also has a tag-value /gene=\"noc\").\n\nNot all groups need to correspond to gene models, but this is the most\ncommon use case; later on we shall describe how to customise the\ngrouping.\n\nSometimes other tags have to be used; for instance, if you look at the\nentire record for AE003644.3 you will see you actually need the use the\n/locus_tag attribute. This attribute is actually B<not present> in\nmost records!\n\nYou can override this:\n\n  $collection->unflatten_seq(-seq=>$seq, -group_tag=>'locus_tag');\n\nAlternatively, if you B<-use_magic>, the object will try and make a\nguess as to what the correct group_tag should be.\n\nAt the end of this step, we should have a list of groups - there is no\nstructure within a group; the group just serves to partition the flat\nfeatures. For the example data above, we would have the following groups.\n\n  [ source ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA CDS ]\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\n=head3 Multicopy Genes\n\nMulticopy genes are usually rRNAs or tRNAs that are duplicated across\nthe genome. Because they are functionally equivalent, and usually have\nthe same sequence, they usually have the same group_tag (ie gene\nsymbol); they often have a /note tag giving copy number. This means\nthey will end up in the same group. This is undesirable, because they\nare spatially disconnected.\n\nThere is another step, which involves splitting spatially disconnected\ngroups into distinct groups\n\nthis would turn this\n\n [gene-rrn3 rRNA-rrn3 gene-rrn3 rRNA-rrn3]\n\ninto this\n\n [gene-rrn3 rRNA-rrn3] [gene-rrn3 rRNA-rrn3]\n\nbased on the coordinates\n\n=head3 What next?\n\nThe next step is to add some structure to each group, by making\nB<containment hierarchies>, trees that represent how the features\ninterrelate\n\n=head2 Resolving the containment hierarchy\n\nAfter the grouping is done, we end up with a list of groups which\nprobably contain features of type 'gene', 'mRNA', 'CDS' and so on.\n\nSingleton groups (eg the 'source' feature) are ignored at this stage.\n\nEach group is itself flat; we need to add an extra level of\norganisation. Usually this is because different spliceforms\n(represented by the 'mRNA' feature) can give rise to different\nprotein products (indicated by the 'CDS' feature). We want to correctly\nassociate mRNAs to CDSs.\n\nWe want to go from a group like this:\n\n  [ gene mRNA mRNA mRNA CDS CDS CDS ]\n\nto a containment hierarchy like this:\n\n  gene\n    mRNA\n      CDS\n    mRNA\n      CDS\n    mRNA\n      CDS\n\nIn which each CDS is nested underneath the correct corresponding mRNA.\n\nFor entries that contain no alternate splicing, this is simple; we\nknow that the group\n\n  [ gene mRNA CDS ]\n\nMust resolve to the tree\n\n  gene\n    mRNA\n      CDS\n\nHow can we do this in entries with alternate splicing? The bad\nnews is that there is no guaranteed way of doing this correctly for\nany GenBank entry. Occasionally the submission will have been done in\nsuch a way as to reconstruct the containment hierarchy. However, this\nis not consistent across databank entries, so no generic solution can\nbe provided by this object. This module does provide the framework\nwithin which you can customise a solution for the particular dataset\nyou are interested in - see later.\n\nThe good news is that there is an inference we can do that should\nproduce pretty good results the vast majority of the time. It uses\nsplice coordinate data - this is the default behaviour of this module,\nand is described in detail below.\n\n=head2 Using splice site coordinates to infer containment\n\nIf an mRNA is to be the container for a CDS, then the splice site\ncoordinates (or intron coordinates, depending on how you look at it)\nof the CDS must fit inside the splice site coordinates of the mRNA.\n\nAmbiguities can still arise, but the results produced should still be\nreasonable and consistent at the sequence level. Look at this fake\nexample:\n\n  mRNA    XXX---XX--XXXXXX--XXXX         join(1..3,7..8,11..16,19..23)\n  mRNA    XXX-------XXXXXX--XXXX         join(1..3,11..16,19..23)\n  CDS                 XXXX--XX           join(13..16,19..20)\n  CDS                 XXXX--XX           join(13..16,19..20)\n\n[obviously the positions have been scaled down]\n\nWe cannot unambiguously match mRNA with CDS based on splice sites,\nsince both CDS share the splice site locations 16^17 and\n18^19. However, the consequences of making a wrong match are probably\nnot very severe. Any annotation data attached to the first CDS is\nprobably identical to the seconds CDS, other than identifiers.\n\nThe default behaviour of this module is to make an arbitrary call\nwhere it is ambiguous (the mapping will always be bijective; i.e. one\nmRNA -E<gt> one CDS).\n\n[TODO: NOTE: not tested on EMBL data, which may not be bijective; ie two\nmRNAs can share the same CDS??]\n\nThis completes the building of the containment hierarchy; other\noptional step follow\n\n=head1 POST-GROUPING STEPS\n\n=head2 Inferring exons from mRNAs\n\nThis step always occurs if B<-use_magic> is invoked.\n\nIn a typical GenBank entry, the exons are B<implicit>. That is they\ncan be inferred from the mRNA location.\n\nFor example:\n\n     mRNA            join(20111..20584,20887..23268)\n\nThis tells us that this particular transcript has two exons. In\nbioperl, the mRNA feature will have a 'split location'.\n\nIf we call\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\nThis will generate the necessary exon features, and nest them under\nthe appropriate mRNAs. Note that the mRNAs will no longer have split\nlocations - they will have simple locations spanning the extent of the\nexons. This is intentional, to avoid redundancy.\n\nOccasionally a GenBank entry will have both implicit exons (from the\nmRNA location) B<and> explicit exon features.\n\nIn this case, exons will still be transferred. Tag-value data from the\nexplicit exon will be transfered to the implicit exon. If exons are\nshared between mRNAs these will be represented by different\nobjects. Any inconsistencies between implicit and explicit will be\nreported.\n\n=head3 tRNAs and other noncoding RNAs\n\nexons will also be generated from these features\n\n=head2 Inferring mRNAs from CDS\n\nSome GenBank entries represent gene models using features of type\ngene, mRNA and CDS; some entries just use gene and CDS.\n\nIf we only have gene and CDS, then the containment hierarchies will\nlook like this:\n\n  gene\n    CDS\n\nIf we want the containment hierarchies to be uniform, like this\n\n  gene\n    mRNA\n      CDS\n\nThen we must create an mRNA feature. This will have identical\ncoordinates to the CDS. The assumption is that there is either no\nuntranslated region, or it is unknown.\n\nTo do this, we can call\n\n   $unflattener->infer_mRNA_from_CDS(-seq=>$seq);\n\nThis is taken care of automatically, if B<-use_magic> is invoked.\n\n=head1 ADVANCED\n\n=head2 Customising the grouping of features\n\nThe default behaviour is suited mostly to building models of protein\ncoding genes and noncoding genes from genbank genomic DNA submissions.\n\nYou can change the tag used to partition the feature by passing in a\ndifferent group_tag argument - see the unflatten_seq() method\n\nOther behaviour may be desirable. For example, even though SNPs\n(features of type 'variation' in GenBank) are not actually part of the\ngene model, it may be desirable to group SNPs that overlap or are\nnearby gene models.\n\nIt should certainly be possible to extend this module to do\nthis. However, I have yet to code this part!!! If anyone would find\nthis useful let me know.\n\nIn the meantime, you could write your own grouping subroutine, and\nfeed the results into unflatten_groups() [see the method documentation\nbelow]\n\n=head2 Customising the resolution of the containment hierarchy\n\nOnce the flat list of features has been partitioned into groups, the\nmethod unflatten_group() is called on each group to build a tree.\n\nThe algorithm for doing this is described above; ambiguities are\nresolved by using splice coordinates. As discussed, this can be\nambiguous.\n\nSome submissions may contain information in tags/attributes that hint\nas to the mapping that needs to be made between the features.\n\nFor example, with the Drosophila Melanogaster release 3 submission, we\nsee that CDS features in alternately spliced mRNAs have a form like\nthis:\n\n     CDS             join(145588..145686,145752..146156,146227..146493)\n                     /locus_tag=\"CG32954\"\n                     /note=\"CG32954 gene product from transcript CG32954-RA\"\n                                                 ^^^^^^^^^^^^^^^^^^^^^^^^^^^\n                     /codon_start=1\n                     /product=\"CG32954-PA\"\n                     /protein_id=\"AAF53403.1\"\n                     /db_xref=\"GI:7298167\"\n                     /db_xref=\"FLYBASE:FBgn0052954\"\n                     /translation=\"MSFTLTNKNVIFVAGLGGIGLDTSKELLKRDLKNLVILDRIENP...\"\n\nHere the /note tag provides the clue we need to link CDS to mRNA\n(highlighted with ^^^^). We just need to find the mRNA with the tag\n\n  /product=\"CG32954-RA\"\n\nI have no idea how consistent this practice is across submissions; it\nis consistent for the fruitfly genome submission.\n\nWe can customise the behaviour of unflatten_group() by providing our\nown resolver method. This obviously requires a bit of extra\nprogramming, but there is no way to get around this.\n\nHere is an example of how to pass in your own resolver; this example\nbasically checks the parent (container) /product tag to see if it\nmatches the required string in the child (contained) /note tag.\n\n       $unflattener->unflatten_seq(-seq=>$seq,\n                                 -group_tag=>'locus_tag',\n                                 -resolver_method=>sub {\n                                     my $self = shift;\n                                     my ($sf, @candidate_container_sfs) = @_;\n                                     if ($sf->has_tag('note')) {\n                                         my @notes = $sf->get_tag_values('note');\n                                         my @trnames = map {/from transcript\\s+(.*)/;\n                                                            $1} @notes;\n                                         @trnames = grep {$_} @trnames;\n                                         my $trname;\n                                         if (@trnames == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@trnames == 1) {\n                                             $trname = $trnames[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS: @trnames\");\n                                         }\n                                         my @container_sfs =\n                                           grep {\n                                               my ($product) =\n                                                 $_->has_tag('product') ?\n                                                   $_->get_tag_values('product') :\n                                                     ('');\n                                               $product eq $trname;\n                                           } @candidate_container_sfs;\n                                         if (@container_sfs == 0) {\n                                             $self->throw(\"UNRESOLVABLE\");\n                                         }\n                                         elsif (@container_sfs == 1) {\n                                             # we got it!\n                                             return $container_sfs[0];\n                                         }\n                                         else {\n                                             $self->throw(\"AMBIGUOUS\");\n                                         }\n                                     }\n                                 });\n\nthe resolver method is only called when there is more than one spliceform.\n\n=head2 Parsing mRNA records\n\nSome of the entries in sequence databanks are for mRNA sequences as\nwell as genomic DNA. We may want to build models from these too.\n\nNOT YET DONE - IN PROGRESS!!!\n\nOpen question - what would these look like?\n\nIdeally we would like a way of combining a mRNA record with the\ncorresponding SeFeature entry from the appropriate genomic DNA\nrecord. This could be problemmatic in some cases - for example, the\nmRNA sequences may not match 100% (due to differences in strain,\nassembly problems, sequencing problems, etc). What then...?\n\n=head1 SEE ALSO\n\nFeature table description\n\n  http://www.ebi.ac.uk/embl/Documentation/FT_definitions/feature_table.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::Unflattener;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Location::Simple;\nuse Bio::SeqFeature::Generic;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::Unflattener->new();\n           $unflattener->unflatten_seq(-seq=>$seq);\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::Unflattener\n Args    : see below\n\nArguments\n\n  -seq       : A L<Bio::SeqI> object (optional)\n               the sequence to unflatten; this can also be passed in\n               when we call unflatten_seq()\n\n  -group_tag : a string representing the /tag used to partition flat features\n               (see discussion above)\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq, $group_tag, $trust_grouptag) =\n\t$self->_rearrange([qw(SEQ\n                              GROUP_TAG\n                              TRUST_GROUPTAG\n\t\t\t     )],\n                          @args);\n\n    $seq  && $self->seq($seq);\n    $group_tag  && $self->group_tag($group_tag);\n    # $self->{'trust_grouptag'}= $trust_grouptag if($trust_grouptag); #dgg suggestion\n    return $self; # success - we hope!\n}\n\nsub DESTROY {\n    my $self = shift;\n    return if $self->{_reported_problems};\n    return if $self->{_ignore_problems};\n    my @probs = $self->get_problems;\n    if (!$self->{_problems_reported} &&\n\tscalar(@probs)) {\n\t$self->warn(\n\t    \"WARNING: There are UNREPORTED PROBLEMS.\\n\".\n\t    \"You may wish to use the method report_problems(), \\n\",\n\t    \"or ignore_problems() on the Unflattener object\\n\");\n    }\n    return;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $unflattener->seq($newval)\n Function: \n Example : \n Returns : value of seq (a Bio::SeqI)\n Args    : on set, new value (a Bio::SeqI, optional)\n\nThe Bio::SeqI object should hold a flat list of Bio::SeqFeatureI\nobjects; this is the list that will be unflattened.\n\nThe sequence object can also be set when we call unflatten_seq()\n\n\nsub seq{\n    my $self = shift;\n\n    return $self->{'seq'} = shift if @_;\n    return $self->{'seq'};\n}\n\n=head2 group_tag\n\n Title   : group_tag\n Usage   : $unflattener->group_tag($newval)\n Function: \n Example : \n Returns : value of group_tag (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nThis is the tag that will be used to collect elements from the flat\nfeature list into groups; for instance, if we look at two typical\nGenBank features:\n\n     gene            20111..23268\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /note=\"last curated on Thu Dec 13 16:51:32 PST 2001\"\n                     /map=\"35B2-35B2\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n     mRNA            join(20111..20584,20887..23268)\n                     /gene=\"noc\"\n                     /locus_tag=\"CG4491\"\n                     /product=\"CG4491-RA\"\n                     /db_xref=\"FLYBASE:FBgn0005771\"\n\nWe can see that these comprise the same gene model because they share\nthe same /gene attribute; we want to collect these together in groups.\n\nSetting group_tag is optional. The default is to use 'gene'. In the\nexample above, we could also use /locus_tag\n\n\nsub group_tag{\n    my $self = shift;\n\n    return $self->{'group_tag'} = shift if @_;\n    return $self->{'group_tag'};\n}\n\n=head2 partonomy\n\n Title   : partonomy\n Usage   : $unflattener->partonomy({mRNA=>'gene', CDS=>'mRNA')\n Function: \n Example : \n Returns : value of partonomy (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\nA hash representing the containment structure that the seq_feature\nnesting should conform to; each key represents the contained (child)\ntype; each value represents the container (parent) type.\n\n\nsub partonomy{\n    my $self = shift;\n\n    return $self->{'partonomy'} = shift if @_;\n    if (!$self->{'partonomy'}) {\n\t$self->{'partonomy'} = $self->_default_partonomy;\n    }\n    return $self->{'partonomy'};\n}\n\nsub _default_partonomy{\n    return {\n            mRNA => 'gene',\n            tRNA => 'gene',\n            rRNA => 'gene',\n            scRNA => 'gene',\n            snRNA => 'gene',\n            snoRNA => 'gene',\n            misc_RNA => 'gene',\n            CDS => 'mRNA',\n\t    exon => 'mRNA',\n\t    intron => 'mRNA',\n\n            pseudoexon => 'pseudogene',\n            pseudointron => 'pseudogene',\n            pseudotranscript => 'pseudogene',\n           };\n}\n\n=head2 structure_type\n\n Title   : structure_type\n Usage   : $unflattener->structure_type($newval)\n Function: \n Example : \n Returns : value of structure_type (a scalar)\n Args    : on set, new value (an int or undef, optional)\n\nGenBank entries conform to different flavours, or B<structure\ntypes>. Some have mRNAs, some do not.\n\nRight now there are only two base structure types defined. If you set\nthe structure type, then appropriate unflattening action will be\ntaken.  The presence or absence of explicit exons does not affect the\nstructure type.\n\nIf you invoke B<-use_magic> then this will be set automatically, based\non the content of the record.\n\n\n* Type 0 (DEFAULT)\n\ntypically contains\n\n  source\n  gene\n  mRNA\n  CDS\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    mRNA\n    CDS\n      exon\n\nexons and introns are implicit from the mRNA 'join' location\n\nto get exons from the mRNAs, you will need this call (see below)\n\n  $unflattener->feature_from_splitloc(-seq=>$seq);\n\n* Type 1\n\ntypically contains\n\n  source\n  gene\n  CDS\n  exon [optional]\n  intron [optional]\n\nthere are no mRNA features\n\nwith this structure type, we want the seq_features to be nested like this\n\n  gene\n    CDS\n      exon\n      intron\n\nexon and intron may or may not be present; they may be implicit from\nthe CDS 'join' location\n\n\n\nsub structure_type{\n    my $self = shift;\n\n    return $self->{'structure_type'} = shift if @_;\n    return $self->{'structure_type'};\n}\n\n=head2 get_problems\n\n Title   : get_problems\n Usage   : @probs = get_problems()\n Function: Get the list of problem(s) for this object.\n Example :\n Returns : An array of [severity, description] pairs\n Args    :\n\nIn the course of unflattening a record, problems may occur. Some of\nthese problems are non-fatal, and can be ignored.\n\nProblems are represented as arrayrefs containing a pair [severity,\ndescription]\n\nseverity is a number, the higher, the more severe the problem\n\nthe description is a text string\n\n\nsub get_problems{\n    my $self = shift;\n\n    return @{$self->{'_problems'}} if exists($self->{'_problems'});\n    return ();\n}\n\n=head2 clear_problems\n\n Title   : clear_problems\n Usage   :\n Function: resets the problem list to empty\n Example :\n Returns : \n Args    :\n\n\n\nsub clear_problems{\n   my ($self,@args) = @_;\n   $self->{'_problems'} = [];\n   return;\n}\n\n\n# PRIVATE\n# see get_problems\nsub add_problem{\n    my $self = shift;\n\n    $self->{'_problems'} = [] unless exists($self->{'_problems'});\n    if ($self->verbose > 0) {\n        warn( \"PROBLEM: $_\\n\") foreach @_;\n    }\n    push(@{$self->{'_problems'}}, @_);\n}\n\n# PRIVATE\n# see get_problems\nsub problem {\n    my $self = shift;\n    my ($severity, $desc, @sfs) = @_;\n    if (@sfs) {\n\tforeach my $sf (@sfs) {\n\t    $desc .=\n\t      sprintf(\"\\nSF [$sf]: %s\\n\",\n\t\t      join('; ',\n                           $sf->primary_tag,\n\t\t\t   map {\n\t\t\t       $sf->has_tag($_) ?\n\t\t\t\t $sf->get_tag_values($_) : ()\n\t\t\t     } qw(gene product label)));\n\t}\n    }\n    my $thresh = $self->error_threshold;\n    if ($severity > $thresh) {\n\t$self->{_problems_reported} = 1;\n\t$self->throw(\"PROBLEM, SEVERITY==$severity\\n$desc\");\n    }\n    $self->add_problem([$severity, $desc]);\n    return;\n}\n\n=head2 report_problems\n\n Title   : report_problems\n Usage   : $unflattener->report_problems(\\*STDERR);\n Function:\n Example :\n Returns : \n Args    : FileHandle (defaults to STDERR)\n\n\n\nsub report_problems{\n   my ($self, $fh) = @_;\n\n   if (!$fh) {\n       $fh = \\*STDERR;\n   }\n   foreach my $problem ($self->get_problems) {\n       my ($sev, $desc) = @$problem;\n       printf $fh \"PROBLEM, SEVERITY==$sev\\n$desc\\n\";\n   }\n   $self->{_problems_reported} = 1;\n   return;\n}\n\n=head2 ignore_problems\n\n Title   : ignore_problems\n Usage   : $obj->ignore_problems();\n Function:\n Example :\n Returns : \n Args    :\n\nUnflattener is very particular about problems it finds along the\nway. If you have set the error_threshold such that less severe\nproblems do not cause exceptions, Unflattener still expects you to\nreport_problems() at the end, so that the user of the module is aware\nof any inconsistencies or problems with the data. In fact, a warning\nwill be produced if there are unreported problems. To silence, this\nwarning, call the ignore_problems() method before the Unflattener\nobject is destroyed.\n\n\nsub ignore_problems{\n   my ($self) = @_;\n   $self->{_ignore_problems} = 1;\n   return;\n}\n\n\n=head2 error_threshold\n\n Title   : error_threshold\n Usage   : $obj->error_threshold($severity)\n Function: \n Example : \n Returns : value of error_threshold (a scalar)\n Args    : on set, new value (an integer)\n\nSets the threshold above which errors cause this module to throw an\nexception. The default is 0; all problems with a severity E<gt> 0 will\ncause an exception.\n\nIf you raise the threshold to 1, then the unflattening process will be\nmore lax; problems of severity==1 are generally non-fatal, but may\nindicate that the results should be inspected, for example, to make\nsure there is no data loss.\n\n\nsub error_threshold{\n    my $self = shift;\n\n    return $self->{'error_threshold'} = shift if @_;\n    return $self->{'error_threshold'} || 0;\n}\n\n\n\n# PRIVATE\n#\n# given a type (eg mRNA), will return the container type (eg gene)\nsub get_container_type{\n   my ($self,$type) = @_;\n   my @roots = $self->_get_partonomy_roots;\n   if (grep {$_ eq $type} @roots) {\n       # it is a root - no parents/containers\n       return;\n   }\n   my $ch = $self->partonomy;\n   my $ctype = $ch->{$type};\n   if (!$ctype) {\n       # asterix acts as a wild card\n       $ctype = $ch->{'*'};\n   }\n   return $ctype;\n}\n\n# get root node of partonomy hierarchy (usually gene)\nsub _get_partonomy_roots {\n    my $self = shift;\n    my $ch = $self->partonomy;\n    my @parents = values %$ch;\n    # find parents that do not have parents themselves\n    return grep {!$ch->{$_}} @parents;\n}\n\n\n\n=head2 unflatten_seq\n\n Title   : unflatten_seq\n Usage   : @sfs = $unflattener->unflatten_seq($seq);\n Function: turns a flat list of features into a list of holder features\n Example :\n Returns : list of Bio::SeqFeatureI objects\n Args    : see below\n\npartitions a list of features then arranges them in a nested tree; see\nabove for full explanation.\n\nnote - the Bio::SeqI object passed in will be modified\n\nArguments\n\n  -seq   :          a Bio::SeqI object; must contain Bio::SeqFeatureI objects\n                    (this is optional if seq has already been set)\n\n  -use_magic:       if TRUE (ie non-zero) then magic will be invoked;\n                    see discussion above.\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - if nothing is supplied, a default\n                    subroutine will be used (see below)\n\n  -group_tag:       a string\n                    [ see the group_tag() method ]\n                    this overrides the default group_tag which is 'gene'\n\n\n\n\nsub unflatten_seq{\n   my ($self,@args) = @_;\n\n    my($seq, $resolver_method, $group_tag, $partonomy, \n       $structure_type, $resolver_tag, $use_magic) =\n\t$self->_rearrange([qw(SEQ\n                              RESOLVER_METHOD\n                              GROUP_TAG\n                              PARTONOMY\n\t\t\t      STRUCTURE_TYPE\n\t\t\t      RESOLVER_TAG\n\t\t\t      USE_MAGIC\n\t\t\t     )],\n                          @args);\n\n   # seq we want to unflatten\n   $seq = $seq || $self->seq;\n\n\n   # prevent bad argument combinations\n   if ($partonomy &&\n       defined($structure_type)) {\n       $self->throw(\"You cannot set both -partonomy and -structure_type\\n\".\n\t\t    \"(the former is implied by the latter)\");\n   }\n\n   # remember the current value of partonomy, to reset later\n   my $old_partonomy = $self->partonomy;\n   $self->partonomy($partonomy) if defined $partonomy;\n\n   # remember old structure_type\n   my $old_structure_type = $self->structure_type;\n   $self->structure_type($structure_type) if defined $structure_type;\n\n   # if we are sourcing our data from genbank, all the\n   # features should be flat (eq no sub_SeqFeatures)\n   my @flat_seq_features = $seq->get_SeqFeatures;\n   my @all_seq_features = $seq->get_all_SeqFeatures;\n\n   # sanity checks\n   if (@all_seq_features > @flat_seq_features) {\n       $self->throw(\"It looks as if this sequence has already been unflattened\");\n   }\n   if (@all_seq_features < @flat_seq_features) {\n       $self->throw(\"ASSERTION ERROR: something is seriously wrong with your features\");\n   }\n\n   # tag for ungrouping; usually /gene or /locus_tag\n   #     for example:        /gene=\"foo\"\n   $group_tag = $group_tag || $self->group_tag;\n   if ($use_magic) {\n       # use magic to guess the group tag\n       my @sfs_with_locus_tag =\n\t grep {$_->has_tag(\"locus_tag\")} @flat_seq_features;\n       my @sfs_with_gene_tag =\n\t grep {$_->has_tag(\"gene\")} @flat_seq_features;\n       my @sfs_with_product_tag =\n\t grep {$_->has_tag(\"product\")} @flat_seq_features;\n\t \n#        if ($group_tag && $self->{'trust_grouptag'}) { # dgg suggestion\n# \n#         }\n#        elsif\n       if (@sfs_with_locus_tag) {\n        # dgg note: would like to -use_magic with -group_tag = 'gene' for ensembl genomes\n        # where ensembl gene FT have both /locus_tag and /gene, but mRNA, CDS have /gene only\n\t   if ($group_tag && $group_tag ne 'locus_tag') {\n\t       $self->throw(\"You have explicitly set group_tag to be '$group_tag'\\n\".\n\t\t\t    \"However, I detect that some features use /locus_tag\\n\".\n\t\t\t    \"I believe that this is the correct group_tag to use\\n\".\n\t\t\t    \"You can resolve this by either NOT setting -group_tag\\n\".\n\t\t\t    \"OR you can unset -use_magic to regain control\");\n\t   }\n\n\t   # use /locus_tag instead of /gene tag for grouping\n\t   # see GenBank entry AE003677 (version 3) for an example\n\t   $group_tag = 'locus_tag';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n       }\n\n       # on rare occasions, records will have no /gene or /locus_tag\n       # but it WILL have /product tags. These serve the same purpose\n       # for grouping. For an example, see AY763288 (also in t/data)\n       if (@sfs_with_locus_tag==0 &&\n           @sfs_with_gene_tag==0 &&\n           @sfs_with_product_tag>0 &&\n           !$group_tag) {\n\t   $group_tag = 'product';\n           if ($self->verbose > 0) {\n               warn \"Set group tag to: $group_tag\\n\";\n           }\n           \n       }\n   }\n   if (!$group_tag) {\n       $group_tag = 'gene';\n   }\n\n   # ------------------------------\n   # GROUP FEATURES using $group_tag\n   #     collect features into unstructured groups\n   # ------------------------------\n\n   # -------------\n   # we want to generate a list of groups;\n   # each group is a list of SeqFeatures; this\n   # group probably (but not necessarily)\n   # corresponds to a gene model.\n   #\n   # this array will look something like this:\n   # ([$f1], [$f2, $f3, $f4], ...., [$f97, $f98, $f99])\n   #\n   # there are also 'singleton' groups, with one member.\n   # for instance, the 'source' feature is in a singleton group;\n   # the same with others such as 'misc_feature'\n   my @groups = ();\n   # -------------\n\n   # --------------------\n   # we hope that the genbank record allows us to group by some grouping\n   # tag.\n   # for instance, most of the time a gene model can be grouped using\n   # the gene tag - that is where you see\n   #                    /gene=\"foo\"\n   # in a genbank record\n   # --------------------\n   \n   # keep an index of groups by their\n   # grouping tag\n   my %group_by_tag = ();\n   \n\n   # iterate through all features, putting them into groups\n   foreach my $sf (@flat_seq_features) {\n       if (!$sf->has_tag($group_tag)) {\n\t   # SINGLETON\n           # this is an ungroupable feature;\n           # add it to a group of its own\n           push(@groups, [$sf]);\n       }\n       else {\n\t   # NON-SINGLETON\n           my @group_tagvals = $sf->get_tag_values($group_tag);\n           if (@group_tagvals > 1) {\n\t       # sanity check:\n               # currently something can only belong to one group\n               $self->problem(2,\n\t\t\t      \">1 value for /$group_tag: @group_tagvals\\n\".\n\t\t\t      \"At this time this module is not equipped to handle this adequately\", $sf);\n           }\n\t   # get value of group tag\n           my $gtv = shift @group_tagvals;\n           $gtv || $self->throw(\"Empty /$group_tag vals not allowed!\");\n\n           # is this a new group?\n           my $group = $group_by_tag{$gtv};\n           if ($group) {\n               # this group has been encountered before - add current\n               # sf to the end of the group\n               push(@$group, $sf);\n           }\n           else {\n               # new group; add to index and create new group\n               $group = [$sf];  # currently one member; probably more to come\n               $group_by_tag{$gtv} = $group;\n               push(@groups, $group);\n           }\n       }\n   }\n   \n   # as well as having the same group_tag, a group should be spatially\n   # connected. if not, then the group should be split into subgroups.\n   # this turns out to be necessary in the case of multicopy genes.\n   # the standard way to represent these is as spatially disconnected\n   # gene models (usually a 'gene' feature and some kind of RNA feature)\n   # with the same group tag; the code below will split these into \n   # seperate groups, one per copy.\n   @groups = map { $self->_split_group_if_disconnected($_) } @groups;\n\n   # remove any duplicates; most of the time the method below has\n   # no effect. there are some unusual genbank records for which\n   # duplicate removal is necessary. see the comments in the\n   # _remove_duplicates_from_group() method if you want to know\n   # the ugly details\n   foreach my $group (@groups) {\n       $self->_remove_duplicates_from_group($group);\n   }\n\n   # -\n\n   # PSEUDOGENES, PSEUDOEXONS AND PSEUDOINTRONS\n   # these are indicated with the /pseudo tag\n   # these are mapped to a different type; they should NOT\n   # be treated as normal genes\n   foreach my $sf (@all_seq_features) {\n       if ($sf->has_tag('pseudo')) {\n           my $type = $sf->primary_tag;\n           # SO type is typically the same as the normal\n           # type but preceeded by \"pseudo\"\n           if ($type eq 'misc_RNA' || $type eq 'mRNA') { \n            # dgg: see TypeMapper; both pseudo mRNA,misc_RNA should be pseudogenic_transcript\n               $sf->primary_tag(\"pseudotranscript\");\n           }\n           else {\n               $sf->primary_tag(\"pseudo$type\");\n           }\n       }\n   }\n   # now some of the post-processing that follows which applies to\n   # genes will NOT be applied to pseudogenes; this is deliberate\n   # for example, gene models are normalised to be gene-transcript-exon\n   # for pseudogenes we leave them as pseudogene-pseudoexon\n\n   # --- MAGIC ---\n   my $need_to_infer_exons = 0;\n   my $need_to_infer_mRNAs = 0;\n   my @removed_exons = ();\n   if ($use_magic) {\n       if (defined($structure_type)) {\n\t   $self->throw(\"Can't combine use_magic AND setting structure_type\");\n       }\n       my $n_introns =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_exons =\n\t scalar(grep {$_->primary_tag eq 'exon'} @flat_seq_features);\n       my $n_mrnas =\n\t scalar(grep {$_->primary_tag eq 'mRNA'} @flat_seq_features);\n       my $n_mrnas_attached_to_gene =\n\t scalar(grep {$_->primary_tag eq 'mRNA' &&\n\t\t\t$_->has_tag($group_tag)} @flat_seq_features);\n       my $n_cdss =\n\t scalar(grep {$_->primary_tag eq 'CDS'} @flat_seq_features);\n       my $n_rnas =\n\t scalar(grep {$_->primary_tag =~ /RNA/} @flat_seq_features);  \n       # Are there any CDS features in the record?\n       if ($n_cdss > 0) {\n           # YES\n           \n\t   # - a pc gene model should contain at the least a CDS\n\n           # Are there any mRNA features in the record?\n\t   if ($n_mrnas == 0) {\n               # NO mRNAs:\n\t       # looks like structure_type == 1\n\t       $structure_type = 1;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   elsif ($n_mrnas_attached_to_gene == 0) {\n               # $n_mrnas > 0\n               # $n_mrnas_attached_to_gene = 0\n               #\n               # The entries _do_ contain mRNA features,\n               # but none of them are part of a group/gene, i.e. they\n               # are 'floating'\n\n\t       # this is an annoying weird file that has some floating\n\t       # mRNA features; \n\t       # eg ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/\n               \n               if ($self->verbose) {\n                   my @floating_mrnas =\n                     grep {$_->primary_tag eq 'mRNA' &&\n                             !$_->has_tag($group_tag)} @flat_seq_features;\n                   printf STDERR \"Unattached mRNAs:\\n\";\n                   foreach my $mrna (@floating_mrnas) {\n                       $self->_write_sf_detail($mrna);\n                   }\n                   printf STDERR \"Don't know how to deal with these; filter at source?\\n\";\n               }\n\n\t       foreach (@flat_seq_features) {\n\t\t   if ($_->primary_tag eq 'mRNA') {\n\t\t       # what should we do??\n\t\t       \n\t\t       # I think for pombe we just have to filter\n\t\t       # out bogus mRNAs prior to starting\n\t\t   }\n\t       }\n\n\t       # looks like structure_type == 2\n\t       $structure_type = 2;\n\t       $need_to_infer_mRNAs = 1;\n\t   }\n\t   else {\n\t   }\n\n\t   # we always infer exons in magic mode\n\t   $need_to_infer_exons = 1;\n       }\n       else {\n\t   # this doesn't seem to be any kind of protein coding gene model\n\t   if ( $n_rnas > 0 ) {\n\t       $need_to_infer_exons = 1;\n\t   }\n       }\n\n       if ($need_to_infer_exons) {\n\t   # remove exons and introns from group -\n\t   # we will infer exons later, and we\n\t   # can always infer introns from exons\n\t   foreach my $group (@groups) {\n\t       @$group = \n\t\t grep {\n\t\t     my $type = $_->primary_tag();\n\t\t     if ($type eq 'exon') {\n\t\t\t # keep track of all removed exons,\n\t\t\t # so we can do a sanity check later\n\t\t\t push(@removed_exons, $_);\n\t\t     }\n\t\t     $type ne 'exon' && $type ne 'intron'\n\t\t } @$group;\n\t   }\n\t   # get rid of any groups that have zero members\n\t   @groups = grep {scalar(@$_)} @groups;\n       }\n   }\n   # --- END OF MAGIC ---\n   \n   # LOGICAL ASSERTION\n   if (grep {!scalar(@$_)} @groups) {\n       $self->throw(\"ASSERTION ERROR: empty group\");\n   }\n\n   # LOGGING\n   if ($self->verbose > 0) {\n       printf STDERR \"GROUPS:\\n\";\n       foreach my $group (@groups) {\n\t   $self->_write_group($group, $group_tag);\n       }\n   }\n   # -\n\n   # --------- FINISHED GROUPING -------------\n\n\n   # TYPE CONTAINMENT HIERARCHY (aka partonomy)\n   # set the containment hierarchy if desired\n   # see docs for structure_type() method\n   if ($structure_type) {\n       if ($structure_type == 1) {\n\t   $self->partonomy(\n                            {CDS => 'gene',\n                             exon => 'CDS',\n                             intron => 'CDS',\n                            }\n                           );\n       }\n       else {\n\t   $self->throw(\"structure_type $structure_type is currently unknown\");\n       }\n   }\n\n   # see if we have an obvious resolver_tag\n   if ($use_magic) {\n       foreach my $sf (@all_seq_features) {\n\t   if ($sf->has_tag('derived_from')) {\n\t       $resolver_tag = 'derived_from';\n\t   }\n       }\n   }\n\n   if ($use_magic) {\n       # point all feature types without a container type to the root type.\n       #\n       # for example, if we have an unanticipated feature_type, say\n       # 'aberration', this should by default point to the parent 'gene'\n       foreach my $group (@groups) {\n\t   my @sfs = @$group;\n\t   if (@sfs > 1) {\n\t       foreach my $sf (@sfs) {\n\t\t   my $type = $sf->primary_tag;\n\t\t   next if $type eq 'gene';\n\t\t   my $container_type = $self->get_container_type($type);\n\t\t   if (!$container_type) {\n\t\t       $self->partonomy->{$type} = 'gene';\n\t\t   }\n\t       }\n\t   }\n       }\n   }\n\n   # we have done the first part of the unflattening.\n   # we now have a list of groups; each group is a list of seqfeatures.\n   # the actual group itself is flat; we may want to unflatten this further;\n   # for instance, a gene model can contain multiple mRNAs and CDSs. We may want\n   # to link the correct mRNA to the correct CDS via the bioperl sub_SeqFeature tree.\n   #\n   # what we would end up with would be\n   #  gene1\n   #    mRNA-a\n   #      CDS-a\n   #    mRNA-b\n   #      CDS-b\n   my @top_sfs = $self->unflatten_groups(-groups=>\\@groups,\n                                         -resolver_method=>$resolver_method,\n\t\t\t\t\t -resolver_tag=>$resolver_tag);\n   \n   # restore settings\n   $self->partonomy($old_partonomy);\n\n   # restore settings\n   $self->structure_type($old_structure_type);\n\n   # modify the original Seq object - the top seqfeatures are now\n   # the top features from each group\n   $seq->remove_SeqFeatures;\n   $seq->add_SeqFeature(@top_sfs);\n\n   # --------- FINISHED UNFLATTENING -------------\n\n   # lets see if there are any post-unflattening tasks we need to do\n\n   \n\n   # INFERRING mRNAs\n   if ($need_to_infer_mRNAs) {\n       if ($self->verbose > 0) {\n\t   printf STDERR \"** INFERRING mRNA from CDS\\n\";\n       }\n       $self->infer_mRNA_from_CDS(-seq=>$seq);\n   }\n\n   # INFERRING exons\n   if ($need_to_infer_exons) {\n\n       # infer exons, one group/gene at a time\n       foreach my $sf (@top_sfs) {\n\t   my @sub_sfs = ($sf, $sf->get_all_SeqFeatures);\n\t   $self->feature_from_splitloc(-features=>\\@sub_sfs);\n       }\n\n       # some exons are stated explicitly; ie there is an \"exon\" feature\n       # most exons are inferred; ie there is a \"mRNA\" feature with\n       # split locations\n       #\n       # if there were exons explicitly stated in the entry, we need to\n       # do two things:\n       #\n       # make sure these exons are consistent with the inferred exons\n       #  (you never know)\n       #\n       # transfer annotation (tag-vals) from the explicit exon to the\n       # new inferred exon\n       if (@removed_exons) {\n\t   my @allfeats = $seq->get_all_SeqFeatures;\n\n\t   # find all the inferred exons that are children of mRNA\n\t   my @mrnas =  grep {$_->primary_tag eq 'mRNA'} @allfeats;\n\t   my @exons =  \n\t     grep {$_->primary_tag eq 'exon'}\n\t       map {$_->get_SeqFeatures} @mrnas;\n\n\t   my %exon_h = (); \t   # index of exons by location;\n\n\t   # there CAN be >1 exon at a location; we can represent these redundantly\n\t   # (ie as a tree, not a graph)\n\t   push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n\t   my @problems = ();      # list of problems;\n\t                           # each problem is a \n\t                           # [$severity, $description] pair\n\t   my $problem = '';\n\t   my ($n_exons, $n_removed_exons) =\n\t     (scalar(keys %exon_h), scalar(@removed_exons));\n\t   foreach my $removed_exon (@removed_exons) {\n\t       my $locstr = $self->_locstr($removed_exon);\n\t       my $inferred_exons = $exon_h{$locstr};\n\t       delete $exon_h{$locstr};\n\t       if ($inferred_exons) {\n\t\t   my %exons_done = ();\n\t\t   foreach my $exon (@$inferred_exons) {\n\n\t\t       # make sure we don't move stuff twice\n\t\t       next if $exons_done{$exon};\n\t\t       $exons_done{$exon} = 1;\n\n\t\t       # we need to tranfer any tag-values from the explicit\n\t\t       # exon to the implicit exon\n\t\t       foreach my $tag ($removed_exon->get_all_tags) {\n\t\t\t   my @vals = $removed_exon->get_tag_values($tag);\n\t\t\t   if (!$exon->can(\"add_tag_value\")) {\n\t\t\t       # I'm puzzled as to what should be done here;\n\t\t\t       # SeqFeatureIs are not necessarily mutable,\n\t\t\t       # but we know that in practice the implementing\n\t\t\t       # class is mutable\n\t\t\t       $self->throw(\"The SeqFeature object does not \".\n\t\t\t\t\t    \"implement add_tag_value()\");\n\t\t\t   }\n\t\t\t   $exon->add_tag_value($tag, @vals);\n\t\t       }\n\t\t   }\n\t       } \n               else {\n                   # no exons inferred at $locstr\n\t\t   push(@problems,\n\t\t\t[1, \n\t\t\t \"there is a conflict with exons; there was an explicitly \".\n\t\t\t \"stated exon with location $locstr, yet I cannot generate \".\n\t\t\t \"this exon from the supplied mRNA locations\\n\"]);\n\t       }\n\t   }\n\t   # do we have any inferred exons left over, that were not\n\t   # covered in the explicit exons?\n\t   if (keys %exon_h) {\n\t       # TODO - we ignore this problem for now\n\t       push(@problems,\n\t\t    [1,\n\t\t     sprintf(\"There are some inferred exons that are not in the \".\n\t\t\t     \"explicit exon list; they are the exons at locations:\\n\".\n\t\t\t     join(\"\\n\", keys %exon_h).\"\\n\")]);\n\t   }\n\n\t   # report any problems\n\t   if (@problems) {\n\t       my $thresh = $self->error_threshold;\n\t       my @bad_problems = grep {$_->[0] > $thresh} @problems;\n\t       if (@bad_problems) {\n\t\t   printf STDERR \"PROBLEM:\\n\";\n\t\t   $self->_write_hier(\\@top_sfs);\n\t\t   # TODO - allow more fine grained control over this\n\t\t   $self->{_problems_reported} = 1;\n\t\t   $self->throw(join(\"\\n\",\n\t\t\t\t     map {\"@$_\"} @bad_problems));\n\t       }\n\t       $self->problem(@$_) foreach @problems;\n\t   }\n       }\n   }    \n   # --- end of inferring exons --\n\n   # return new top level features; this can also \n   # be retrieved via\n   #   $seq->get_SeqFeatures();\n#   return @top_sfs;\n   return $seq->get_SeqFeatures;\n}\n\n# _split_group_if_disconnected([@sfs])\n#\n# as well as having the same group_tag, a group should be spatially\n# connected. if not, then the group should be split into subgroups.\n# this turns out to be necessary in the case of multicopy genes.\n# the standard way to represent these is as spatially disconnected\n# gene models (usually a 'gene' feature and some kind of RNA feature)\n# with the same group tag; the code below will split these into \n# seperate groups, one per copy.\n\nsub _split_group_if_disconnected {\n    my $self = shift;\n    my $group = shift;\n    my @sfs = @$group;\n    my @ranges =\n      Bio::Range->disconnected_ranges(@sfs);\n    my @groups;\n    if (@ranges == 0) {\n\t$self->throw(\"ASSERTION ERROR\");\n    }\n    elsif (@ranges == 1) {\n\t# no need to split the group\n\t@groups = ($group);\n    }\n    else {\n\t# @ranges > 1\n\t# split the group into disconnected ranges\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"GROUP PRE-SPLIT:\\n\";\n\t    $self->_write_group($group, $self->group_tag);\n\t}\n\t@groups =\n\t  map {\n\t      my $range = $_;\n\t      [grep {\n\t\t  $_->intersection($range);\n\t      } @sfs]\n\t  } @ranges;\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"SPLIT GROUPS:\\n\";\n\t    $self->_write_group($_, $self->group_tag) foreach @groups;\t    \n\t}\n    }\n    return @groups;\n}\n\nsub _remove_duplicates_from_group {\n    my $self = shift;\n    my $group = shift;\n\n    # ::: WEIRD BOUNDARY CASE CODE :::\n    # for some reason, there are some gb records with two gene\n    # features for one gene; for example, see ATF14F8.gbk\n    # in the t/data directory\n    #\n    # in this case, we get rid of one of the genes\n\n    my @genes = grep {$_->primary_tag eq 'gene'} @$group;\n    if (@genes > 1) {\n\t# OK, if we look at ATF14F8.gbk we see that some genes\n\t# just exist as a single location, some exist as a multisplit location;\n\t#\n\t# eg\n\n\t#     gene            16790..26395\n\t#                     /gene=\"F14F8_60\"\n\t#     ...\n\t#     gene            complement(join(16790..19855,20136..20912,21378..21497,\n\t#                     21654..21876,22204..22400,22527..23158,23335..23448,\n\t#                     23538..23938,24175..24536,24604..24715,24889..24984,\n\t#                     25114..25171,25257..25329,25544..25589,25900..26018,\n\t#                     26300..26395))\n\t#                     /gene=\"F14F8_60\"\n\n\t# the former is the 'standard' way of representing the gene in genbank;\n\t# the latter is redundant with the CDS entry. So we shall get rid of\n\t# the latter with the following filter\n\n\tif ($self->verbose > 0) {\n\t    printf STDERR \"REMOVING DUPLICATES:\\n\";\n\t}\n\n\t@genes =\n\t  grep {\n\t      my $loc = $_->location;\n\t      if ($loc->isa(\"Bio::Location::SplitLocationI\")) {\n\t\t  my @locs = $loc->each_Location;\t\t  \n\t\t  if (@locs > 1) {\n\t\t      0;\n\t\t  }\n\t\t  else {\n\t\t      1;\n\t\t  }\n\t      }\n\t      else {\n\t\t  1;\n\t      }\n\t  } @genes;\n\n\tif (@genes > 1) {\n\t    # OK, that didn't work. Our only resort is to just pick one at random\n\t    @genes = ($genes[0]);\n\t}\n\tif (@genes) {\n\t    @genes == 1 || $self->throw(\"ASSERTION ERROR\");\n\t    @$group =\n\t      ($genes[0], grep {$_->primary_tag ne 'gene'} @$group);\n\t}\n    }\n    # its a dirty job but someone's gotta do it\n    return;\n}\n\n\n=head2 unflatten_groups\n\n Title   : unflatten_groups\n Usage   :\n Function: iterates over groups, calling unflatten_group() [see below]\n Example :\n Returns : list of Bio::SeqFeatureI objects that are holders\n Args    : see below\n\nArguments\n\n  -groups:          list of list references; inner list is of Bio::SeqFeatureI objects\n                    e.g.  ( [$sf1], [$sf2, $sf3, $sf4], [$sf5, ...], ...)\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups.\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_groups{\n   my ($self,@args) = @_;\n   my($groups, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUPS\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   # this is just a simple wrapper for unflatten_group()\n   return \n     map {\n         $self->unflatten_group(-group=>$_,\n                                -resolver_method=>$resolver_method,\n\t\t\t\t-resolver_tag=>$resolver_tag)\n     } @$groups;\n}\n\n=head2 unflatten_group\n\n Title   : unflatten_group\n Usage   :\n Function: nests a group of features into a feature containment hierarchy\n Example :\n Returns : Bio::SeqFeatureI objects that holds other features\n Args    : see below\n\nArguments\n\n  -group:           reference to list of Bio::SeqFeatureI objects\n\n  -resolver_method: a CODE reference\n                    see the documentation above for an example of\n                    a subroutine that can be used to resolve hierarchies\n                    within groups\n\n                    this is optional - a default subroutine will be used\n\n\nNOTE: You should not need to call this method, unless you want fine\ngrained control over how the unflattening process.\n\n\nsub unflatten_group{\n   my ($self,@args) = @_;\n\n   my($group, $resolver_method, $resolver_tag) =\n     $self->_rearrange([qw(GROUP\n                           RESOLVER_METHOD\n\t\t\t   RESOLVER_TAG\n                          )],\n                          @args);\n\n   if ($self->verbose > 0) {\n       printf STDERR \"UNFLATTENING GROUP:\\n\";\n       $self->_write_group($group, $self->group_tag);\n   }\n\n   my @sfs = @$group;\n\n   # we can safely ignore singletons (e.g. [source])\n   return $sfs[0] if @sfs == 1;\n\n   my $partonomy = $self->partonomy;\n\n   # $resolver_method is a reference to a SUB that will resolve\n   # ambiguous parent/child containment; for example, determining\n   # which mRNAs go with which CDSs\n   $resolver_method = $resolver_method || \\&_resolve_container_for_sf;\n\n   # TAG BASED RESOLVING OF HIERARCHIES\n   #\n   # if the user specifies $resolver_tag, then we use this tag\n   # to pair up ambiguous parents and children;\n   #\n   # for example, the CDS feature may have a resolver tag of /derives_from\n   # which is a 'foreign key' into the /label tag of the mRNA feature\n   #\n   # this kind of tag-based resolution is possible for a certain subset\n   # of genbank records\n   #\n   # if no resolver tag is specified, we revert to the normal\n   # resolver_method\n   if ($resolver_tag) {\n       my $backup_resolver_method = $resolver_method;\n       # closure: $resolver_tag is remembered by this sub\n       my $sub = \n\t sub {\n\t     my ($self, $sf, @possible_container_sfs) = @_;\n\t     my @container_sfs = ();\n\t     if ($sf->has_tag($resolver_tag)) {\n\t\t my ($resolver_tagval) = $sf->get_tag_values($resolver_tag);\n\t\t # if a feature has a resolver_tag (e.g. /derives_from)\n\t\t # this specifies the /product, /symbol or /label for the\n\t\t # parent feature\n\t\t @container_sfs = \n\t\t   grep {\n\t\t       my $match = 0;\n\t\t       $self->_write_sf($_) if $self->verbose > 0;\n\t\t       foreach my $tag (qw(product symbol label)) {\n\t\t\t   if ($_->has_tag($tag)) {\n\t\t\t       my @vals =\n\t\t\t\t $_->get_tag_values($tag);\n\t\t\t       if (grep {$_ eq $resolver_tagval} @vals) {\n\t\t\t\t   $match = 1;\n\t\t\t\t   last;\n\t\t\t       }\n\t\t\t   }   \n\t\t       }\n\t\t       $match;\n\t\t   } @possible_container_sfs;\n\t     } \n\t     else {\n\t\t return $backup_resolver_method->($sf, @possible_container_sfs);\n\t     }\n\t     return map {$_=>0} @container_sfs;\n\t };\n       $resolver_method = $sub;\n   }\n   else {\n       # CONDITION: $resolver_tag is NOT set\n       $self->throw(\"assertion error\") if $resolver_tag;\n   }\n   # we have now set $resolver_method to a subroutine for\n   # disambiguatimng parent/child relationships. we will\n   # now build the whole containment hierarchy for this group\n\n\n   # FIND TOP/ROOT SEQFEATURES\n   #\n   # find all the features for which there is no\n   # containing feature type (eg genes)\n   my @top_sfs =\n     grep { \n         !$self->get_container_type($_->primary_tag);\n     } @sfs;\n\n   # CONDITION: there must be at most one root\n   if (@top_sfs > 1) {\n       $self->_write_group($group, $self->group_tag);\n       printf STDERR \"TOP SFS:\\n\";\n       $self->_write_sf($_) foreach @top_sfs;\n       $self->throw(\"multiple top-sfs in group\");\n   }\n   my $top_sf = $top_sfs[0];\n\n   # CREATE INDEX OF SEQFEATURES BY TYPE\n   my %sfs_by_type = ();\n   foreach my $sf (@sfs) {\n       push(@{$sfs_by_type{$sf->primary_tag}}, $sf);\n   }\n\n   # containment index; keyed by child; lookup parent\n   # note: this index uses the stringified object reference of\n   # the object as a surrogate lookup key\n\n   my %container = ();   # child -> parent\n\n   # ALGORITHM: build containment graph\n   #\n   # find all possible containers for each SF;\n   # for instance, for a CDS, the possible containers are all\n   # the mRNAs in the same group. For a mRNA, the possible\n   # containers are any SFs of type 'gene' (should only be 1).\n   # (these container-type mappings can be overridden)\n   #\n   # contention is resolved by checking coordinates of splice sites\n   # (this is the default, but can be overridden)\n   #\n   # most of the time, there is no problem identifying a unique\n   # parent for every child; this can be ambiguous when constructing\n   # CDS to mRNA relationships with lots of alternate splicing\n   #\n   # a hash of child->parent relationships is constructed (%container)\n   # any mappings that need further resolution (eg CDS to mRNA) are\n   # placed in %unresolved\n\n   # %unresolved index\n   # (keyed by stringified object reference of child seqfeature)\n   my %unresolved = ();    # child -> [parent,score] to be resolved\n                           \n   # index of seqfeatures by their stringified object reference;\n   # this is essentially a way of 'reviving' an object from its stringified\n   # reference\n   # (see NOTE ON USING OBJECTS AS KEYS IN HASHES, below)\n   my %idxsf = map {$_=>$_} @sfs;\n\n   foreach my $sf (@sfs) {\n       my $type = $sf->primary_tag;\n\n       # container type (e.g. the container type for CDS is usually mRNA)\n       my $container_type = \n         $self->get_container_type($type);\n       if ($container_type) {\n\n           my @possible_container_sfs =\n             @{$sfs_by_type{$container_type} || []};\n           # we now have a list of possible containers\n           # (eg for a CDS in an alternately spliced gene, this\n           #  would be a list of all the mRNAs for this gene)\n\n\t   if (!@possible_container_sfs) {\n\t       # root of hierarchy\n\t   }\n\t   else {\n\t       if (@possible_container_sfs == 1) {\n                   # this is the easy situation, whereby the containment\n                   # hierarchy is unambiguous. this will probably be the\n                   # case if the genbank record has no alternate splicing\n                   # within it\n\n\t\t   # ONE OPTION ONLY - resolved!\n\t\t   $container{$sf} = $possible_container_sfs[0];\n\n\t       }\n\t       else {\n\t\t   # MULTIPLE CONTAINER CHOICES\n\t\t   $self->throw(\"ASSERTION ERROR\") unless @possible_container_sfs > 1;\n\n                   # push this onto the %unresolved graph, and deal with it\n                   # later\n\n                   # for now we hardcode things such that the only type \n                   # with ambiguous parents is a CDS; if this is violated,\n                   # it has a weak problem class of '1' so the API user\n                   # can easily set things to ignore these\n\t\t   if ($sf->primary_tag ne 'CDS') {\n\t\t       $self->problem(1,\n\t\t\t\t      \"multiple container choice for non-CDS; \".\n\t\t\t\t      \"CDS to mRNA should be the only \".\n\t\t\t\t      \"relationships requiring resolving\",\n\t\t\t\t      $sf);\n\t\t   }\n\n                   # previously we set the SUB $resolver_method\n                   $self->throw(\"ASSERTION ERROR\")\n                     unless $resolver_method;\n\n                   # $resolver_method will assign scores to\n                   # parent/child combinations; later on we\n                   # will use these scores to find the optimal\n                   # parent/child pairings\n\n                   # the default $resolver_method uses splice sites to\n                   # score possible parent/child matches\n\n\t\t   my %container_sfh =\n\t\t     $resolver_method->($self, $sf, @possible_container_sfs);\n                   if (!%container_sfh) {\n                       $self->problem(2,\n                                      \"no containers possible for SeqFeature of \".\n                                      \"type: $type; this SF is being placed at \".\n                                      \"root level\",\n                                      $sf);\n                       # RESOLVED! (sort of - placed at root/gene level)\n                       $container{$sf} = $top_sf;\n\n                       # this sort of thing happens if the record is\n                       # badly messed up and there is absolutely no indication\n                       # of where to put the CDS. Perhaps we should just\n                       # place it with a random mRNA?\n                   }\n\t\t   foreach my $jsf (keys %container_sfh) {\n\n                       # add [score, parent] pairs to the %unresolved\n                       # lookup table/graph\n\t\t       push(@{$unresolved{$sf}}, \n\t\t\t    [$idxsf{$jsf}, $container_sfh{$jsf} || 0]);\n\t\t   }\n\t       }\n\t   }\n       }\n       else {\n           # CONDITION:\n           # not container type for $sf->primary_tag\n           \n           # CONDITION:\n\t   # $sf must be a root/top node (eg gene)\n       }\n   }\n\n   if (0) {\n\n       # CODE CURRENTLY DISABLED\n\n       # we require a 1:1 mapping between mRNAs and CDSs;\n       # create artificial duplicates if we can't do this...\n       if (%unresolved) {\n           my %childh = map {$_=>1} keys %unresolved;\n           my %parenth = map {$_->[0]=>1} map {@$_} values %unresolved;\n           if ($self->verbose > 0) {\n               printf STDERR \"MATCHING %d CHILDREN TO %d PARENTS\\n\",\n                 scalar(keys %childh), scalar(keys %parenth);\n           }\n           # 99.99% of the time in genbank genomic record of structure type 0, we\n           # see one CDS for every mRNA; one exception is the S Pombe\n           # genome, which is all CDS, bar a few spurious mRNAs; we have to\n           # filter out the spurious mRNAs in this case\n           #\n           # another strange case is in the mouse genome, NT_078847.1\n           # for Pcdh13 you will notice there is 4 mRNAs and 5 CDSs.\n           # most unusual! \n           # I'm at a loss for a really clever thing to do here. I think the\n           # best thing is to create duplicate features to preserve the 1:1 mapping\n           #       my $suffix_id = 1;\n           #       while (keys %childh > keys %parenth) {\n           #           \n           #       }\n       }\n   }\n\n   # DEBUGGING CODE\n   if ($self->verbose > 0 && scalar(keys %unresolved)) {\n       printf STDERR \"UNRESOLVED PAIRS:\\n\";\n       foreach my $childsf (keys %unresolved) {\n\t   my @poss = @{$unresolved{$childsf}};\n\t   foreach my $p (@poss) {\n\t       my $parentsf = $p->[0];\n\t       $childsf = $idxsf{$childsf};\n               my @clabels = ($childsf->get_tagset_values(qw(protein_id label product)), \"?\");\n               my @plabels = ($parentsf->get_tagset_values(qw(transcript_id label product)), \"?\");\n\t       printf STDERR\n                      (\"  PAIR: $clabels[0] => $plabels[0]  (of %d)\\n\", \n                       scalar(@poss));\n\t   }\n       }\n   } # -- end of verbose\n\n   # Now we have to fully resolve the containment hierarchy; remember,\n   # the graph %container has the fully resolved child->parent links;\n   #\n   # the graph %unresolved is keyed by children missing parents; we\n   # need to put all these orphans in the %container graph\n   #\n   # we do this using the scores in %unresolved, with the\n   # find_best_matches() algorithm\n   my $unresolved_problem_reported = 0;\n   if (%unresolved) {\n       my $new_pairs =\n\t $self->find_best_matches(\\%unresolved, []);\n       if (!$new_pairs) {\n           my ($g) = $sfs[0]->get_tagset_values($self->group_tag || 'gene');\n\t   $self->problem(2,\n\t\t\t  \"Could not resolve hierarchy for $g\");\n           $new_pairs = [];\n           $unresolved_problem_reported = 1;\n       }\n       foreach my $pair (@$new_pairs) {\n\t   if ($self->verbose > 0) {\n\t       printf STDERR \"  resolved pair @$pair\\n\";\n\t   }\n\t   $container{$pair->[0]} = $pair->[1];\n           delete $unresolved{$pair->[0]};\n       }\n   }\n\n   # CONDITION: containment hierarchy resolved\n   if (%unresolved) {\n       $self->throw(\"UNRESOLVED: %unresolved\")\n         unless $unresolved_problem_reported;\n   }\n\n   # make nested SeqFeature hierarchy from @containment_pairs\n   # ie put child SeqFeatures into parent SeqFeatures\n   my @top = ();\n   foreach my $sf (@sfs) {\n       my $container_sf = $container{$sf};\n       if ($container_sf) {\n           # make $sf nested inside $container_sf\n\n           # first check if the container spatially contains the containee\n           if ($container_sf->contains($sf)) {\n               # add containee\n\t       $container_sf->add_SeqFeature($sf);\n           }\n           else {\n               # weird case - the container does NOT spatially\n               # contain the containee;\n               # we expand and throw a warning\n               #\n               # for an example of this see ZFP91-CNTF dicistronic gene\n               # in NCBI chrom 11 build 34.3\n\t       $self->problem(1,\n\t\t\t      \"Container feature does not spatially contain \".\n                              \"subfeature. Perhaps this is a dicistronic gene? \".\n                              \"I am expanding the parent feature\",\n\t\t\t      $container_sf,\n\t\t\t      $sf);\n\t       $container_sf->add_SeqFeature($sf, 'EXPAND');\n           }\n       }\n       else {\n           push(@top, $sf);\n       }\n   }\n   return @top;\n} # -- end of unflatten_group\n\n# -------\n# A NOTE ON USING OBJECTS AS KEYS IN HASHES (stringified objects)\n#\n# Often we with to use seqfeatures as keys in a hashtable; because seqfeatures\n# in bioperl have no unique ID, we use a surrogate ID in the form of the\n# stringified object references - this is just what you get if you say\n#\n#  print \"$sf\\n\";\n#\n# this is guaranteed to be unique (within a particular perl execution)\n#\n# often we want to 'revive' the objects used as keys in a hash - once the\n# objects are used as keys, remember it is the *strings* used as keys and\n# not the object itself, so the object needs to be revived using another\n# hashtable that looks like this\n#\n#    %sfidx = map { $_ => $_ } @sfs\n#\n# -------\n\n\n# recursively finds the best set of pairings from a matrix of possible pairings\n#\n# tries to make sure nothing is unpaired\n#\n# given a matrix of POSSIBLE matches\n#  (matrix expressed as hash/lookup; keyed by child object; val = [parent, score]\n#\n# \nsub find_best_matches {\n    my $self = shift;\n    my $matrix = shift;\n    my $pairs = shift;        # [child,parent] pairs already selected\n\n    my $verbose = $self->verbose;\n    #################################print \"I\";\n    if ($verbose > 0) {\n\tprintf STDERR \"find_best_matches: (/%d)\\n\", scalar(@$pairs);\n    }\n\n    my %selected_children = map {($_->[0]=>1)} @$pairs;\n    my %selected_parents = map {($_->[1]=>1)} @$pairs;\n    \n    # make a copy of the matrix with the portions still to be\n    # resolved\n    my %unresolved_parents = ();\n    my %unresolved =\n      map {\n          if ($verbose > 0) {\n              printf STDERR \"  $_ : %s\\n\", join(\"; \", map {\"[@$_]\"} @{$matrix->{$_}});\n          }\n\t  if ($selected_children{$_}) {\n\t      ();\n\t  }\n\t  else {\n\t      my @parents =\n\t\tgrep {\n\t\t    !$selected_parents{$_->[0]}\n\t\t} @{$matrix->{$_}};\n              $unresolved_parents{$_} = 1 foreach @parents;\n              # new parents\n\t      ($_ => [@parents]);\n\t  }\n      } keys %$matrix;\n    \n    my @I = keys %unresolved;\n\n    return $pairs if !scalar(keys %unresolved_parents);\n    # NECESSARY CONDITION:\n    # all possible parents have a child match\n\n    return $pairs if !scalar(@I);\n    # NECESSARY CONDITION:\n    # all possible children have a parent match\n\n    # give those with fewest choices highest priority\n    @I = sort {\n\t# n possible parents\n\tscalar(@{$unresolved{$a}}) \n\t  <=>\n\t    scalar(@{$unresolved{$b}}) ;\n    } @I;\n    \n    my $csf = shift @I;\n\n    my @J = @{$unresolved{$csf}};  # array of [parent, score]\n\n    # sort by score, highest first\n    @J =\n      sort {\n\t  $b->[1] <=> $a->[1]\n      } @J;\n\n    # select pair(s) from remaining matrix of possible pairs\n    # by iterating through possible parents\n\n    my $successful_pairs;\n    foreach my $j (@J) {\n\tmy ($psf, $score) = @$j;\n\t# would selecting $csf, $psf as a pair\n\t# remove all choices from another?\n\tmy $bad = 0;\n\tforeach my $sf (@I) {\n\t    if (!grep {$_->[0] ne $psf} @{$unresolved{$sf}}) {\n\t\t# $psf was the only parent choice for $sf\n\t\t$bad = 1;\n\t\tlast;\n\t    }\n\t}\n\tif (!$bad) {\n\t    my $pair = [$csf, $psf];\n\t    my $new_pairs = [@$pairs, $pair];\n\t    my $set = $self->find_best_matches($matrix, $new_pairs);\n\t    if ($set) {\n\t\t$successful_pairs = $set;\n\t\tlast;\n\t    }\n\t}\n    }\n    # success\n    return $successful_pairs if $successful_pairs;\n    # fail\n    return 0;\n}\n\n# ----------------------------------------------\n# writes a group to stdout\n#\n# mostly for logging/debugging\n# ----------------------------------------------\nsub _write_group {\n    my $self = shift;\n    my $group = shift;\n    my $group_tag = shift || 'gene';\n\n    my $f = $group->[0];\n    my $label = '?';\n    if ($f->has_tag($group_tag)) {\n\t($label) = $f->get_tag_values($group_tag);\n    }\n    if( $self->verbose > 0 ) { \n\tprintf STDERR (\"  GROUP [%s]:%s\\n\",\n\t       $label,\n\t       join(' ',\n\t\t    map { $_->primary_tag } @$group));\n    }\n\n}\n\nsub _write_sf {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    return;\n}\n\nsub _write_sf_detail {\n    my $self = shift;\n    my $sf = shift;\n    printf STDERR \"TYPE:%s\\n\", $sf->primary_tag;\n    my @locs = $sf->location->each_Location;\n    printf STDERR \"  %s,%s [%s]\\n\", $_->start, $_->end, $_->strand foreach @locs;\n    return;\n}\n\nsub _write_hier {\n    my $self = shift;\n    my @sfs = @{shift || []};\n    my $indent = shift || 0;\n    if( $self->verbose > 0 ) {\n\tforeach my $sf (@sfs) {\n\t    my $label = '?';\n\t    if ($sf->has_tag('product')) {\n\t\t($label) = $sf->get_tag_values('product');\n\t    }\n\t    printf STDERR \"%s%s $label\\n\", '  ' x $indent, $sf->primary_tag;\n\t    my @sub_sfs = $sf->sub_SeqFeature;\n\t    $self->_write_hier(\\@sub_sfs, $indent+1);\n\t}\n    }\n}\n\n# -----------------------------------------------\n#\n# returns all possible containers for an SF based\n# on splice site coordinates; splice site coords\n# must be contained\n# -----------------------------------------------\nsub _resolve_container_for_sf{\n   my ($self, $sf, @possible_container_sfs) = @_;\n\n   my @coords = $self->_get_splice_coords_for_sf($sf);\n   my $start = $sf->start;\n   my $end = $sf->end;\n   my $splice_uniq_str = \"@coords\";\n   \n   my @sf_score_pairs = ();\n   # a CDS is contained by a mRNA if the locations of the splice\n   # coordinates are identical\n   foreach (@possible_container_sfs) {\n       my @container_coords = $self->_get_splice_coords_for_sf($_);\n       my $inside = \n\t !$splice_uniq_str || \n\t   index(\"@container_coords\", $splice_uniq_str) > -1;\n       if ($inside) {\n           # the container cannot be smaller than the thing contained\n           if ($_->start > $start || $_->end < $end) {\n               $inside = 0;\n           }\n       }\n       if ($self->verbose > 0) {\n\t   printf STDERR \"    Checking containment:[$inside] (@container_coords) IN ($splice_uniq_str)\\n\";\n       }\n       if ($inside) {\n\t   # SCORE: matching (ss-scoords+2)/(n-container-ss-coords+2)\n\t   my $score =\n\t     (scalar(@coords)+2)/(scalar(@container_coords)+2);\n\t   push(@sf_score_pairs,\n\t\t$_=>$score);\n       }\n   }\n   # return array ( $sf1=>$score1, $sf2=>$score2, ...)\n   return @sf_score_pairs;\n}\n\nsub _get_splice_coords_for_sf {\n    my $self = shift;\n    my $sf = shift;\n\n   my @locs = $sf->location;\n   if ($sf->location->isa(\"Bio::Location::SplitLocationI\")) {\n       @locs = $sf->location->each_Location;\n   }\n\n   # get an ordered list of (start, end) positions\n\n#   my @coords =\n#     map {\n#         $_->strand > 0 ? ($_->start, $_->end) : ($_->end, $_->start)\n#     } @locs;\n\n    my @coords = map {($_->start, $_->end)} @locs;\n\n   # remove first and last leaving only splice sites\n   pop @coords;\n   shift @coords;\n    return @coords;\n}\n\n=head2 feature_from_splitloc\n\n Title   : feature_from_splitloc\n Usage   : $unflattener->feature_from_splitloc(-features=>$sfs);\n Function:\n Example :\n Returns : \n Args    : see below\n\nAt this time all this method does is generate exons for mRNA or other RNA features\n\nArguments:\n\n  -feature:    a Bio::SeqFeatureI object (that conforms to Bio::FeatureHolderI)\n  -seq:        a Bio::SeqI object that contains Bio::SeqFeatureI objects\n  -features:   an arrayref of Bio::SeqFeatureI object\n\n\n\nsub feature_from_splitloc{\n   my ($self,@args) = @_;\n\n   my($sf, $seq, $sfs) =\n     $self->_rearrange([qw(FEATURE\n                           SEQ\n\t\t\t   FEATURES\n                          )],\n                          @args);\n   my @sfs = (@{$sfs || []});\n   push(@sfs, $sf) if $sf;\n   if ($seq) {\n       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n       @sfs = $seq->get_all_SeqFeatures;\n   }\n   my @exons = grep {$_->primary_tag eq 'exon'} @sfs;\n   if (@exons) {\n       $self->problem(2,\n\t\t      \"There are already exons, so I will not infer exons\");\n   }\n\n   # index of features by type+location\n   my %loc_h = ();\n\n   # infer for every feature\n   foreach my $sf (@sfs) {\n\n       $sf->isa(\"Bio::SeqFeatureI\") || $self->throw(\"$sf NOT A SeqFeatureI\");\n       $sf->isa(\"Bio::FeatureHolderI\") || $self->throw(\"$sf NOT A FeatureHolderI\");\n\n       my $type = $sf->primary_tag;\n       next unless $type eq 'mRNA' or $type =~ /RNA/;\n\n       # an mRNA from genbank will have a discontinuous location,\n       # with each sub-location being equivalent to an exon\n       my @locs = $sf->location;\n\n       if ($sf->location->isa(\"Bio::Location::SplitLocationI\")) {\n           @locs = $sf->location->each_Location;\n       }\n\n       if (!@locs) {\n           use Data::Dumper;\n           print Dumper $sf;\n\t   $self->throw(\"ASSERTION ERROR: sf has no location objects\");\n       }\n\n       # make exons from locations\n       my @subsfs =\n         map {\n             my $subsf = Bio::SeqFeature::Generic->new(-location=>$_,\n                                                       -primary_tag=>'exon');\n             ## Provide seq_id to new feature:\n             $subsf->seq_id($sf->seq_id) if $sf->seq_id;\n             $subsf->source_tag($sf->source_tag) if $sf->source_tag;\n             ## Transfer /locus_tag and /gene tag values to inferred\n             ## features.  TODO: Perhaps? this should not be done\n             ## indiscriminantly but rather by virtue of the setting\n             ## of group_tag.\n             foreach my $tag (grep /gene|locus_tag/, $sf->get_all_tags) {\n                 my @vals = $sf->get_tag_values($tag);\n                 $subsf->add_tag_value($tag, @vals);\n             }\n\n\t     my $locstr = 'exon::'.$self->_locstr($subsf);\n\n\t     # re-use feature if type and location the same\n\t     if ($loc_h{$locstr}) {\n\t\t $subsf = $loc_h{$locstr};\n\t     }\n\t     else {\n\t\t $loc_h{$locstr} = $subsf;\n\t     }\n             $subsf;\n         } @locs;\n       \n       # PARANOID CHECK\n       $self->_check_order_is_consistent($sf->location->strand,@subsfs);\n       #----\n\n       $sf->location(Bio::Location::Simple->new());\n\n       # we allow the exons to define the boundaries of the transcript\n       $sf->add_SeqFeature($_, 'EXPAND') foreach @subsfs;\n\n\n       if (!$sf->location->strand) {\n\t   # correct weird bioperl bug in previous versions;\n\t   # strand was not being set correctly\n\t   $sf->location->strand($subsfs[0]->location->strand);\n       }\n\n       \n   }\n   return;\n}\n\n#sub merge_features_with_same_loc {\n#   my ($self,@args) = @_;\n\n#   my($sfs, $seq) =\n#     $self->_rearrange([qw(FEATURES\n#                           SEQ\n#                          )],\n#                          @args);\n#   my @sfs = (@$sfs);\n#   if ($seq) {\n#       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n#       @sfs = $seq->get_all_SeqFeatures;\n#   }\n\n   \n#   my %loc_h = ();\n#   foreach my $sf (@sfs) {\n#       my $type = $sf->primary_tag;\n#       my $locstr = $self->_locstr($sf);\n##       $loc_h{$type.$locstr}\n#       push(@{$exon_h{$self->_locstr($_)}}, $_) foreach @exons;\n#   }\n#}\n\n=head2 infer_mRNA_from_CDS\n\n Title   : infer_mRNA_from_CDS\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\ngiven a \"type 1\" containment hierarchy\n\n  gene\n    CDS\n      exon\n\nthis will infer the uniform \"type 0\" containment hierarchy\n\n  gene\n    mRNA\n      CDS\n      exon\n\nall the children of the CDS will be moved to the mRNA\n\na \"type 2\" containment hierarchy is mixed type \"0\" and \"1\" (for\nexample, see ftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/)\n\n\nsub infer_mRNA_from_CDS{\n   my ($self,@args) = @_;\n\n   my($sf, $seq) =\n     $self->_rearrange([qw(FEATURE\n                           SEQ\n                          )],\n                          @args);\n   my @sfs = ($sf);\n   if ($seq) {\n       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n       @sfs = $seq->get_all_SeqFeatures;\n   }\n\n   foreach my $sf (@sfs) {\n\n       $sf->isa(\"Bio::SeqFeatureI\") || $self->throw(\"$sf NOT A SeqFeatureI\");\n       $sf->isa(\"Bio::FeatureHolderI\") || $self->throw(\"$sf NOT A FeatureHolderI\");\n       if ($self->verbose > 0) {\n           printf STDERR \"    Checking $sf %s\\n\", $sf->primary_tag;\n       }\n       \n       if ($sf->primary_tag eq 'mRNA') {\n\t   $self->problem(2,\n\t\t\t  \"Inferring mRNAs when there are already mRNAs present\");\n       }\n\n       my @cdsl = grep {$_->primary_tag eq 'CDS' } $sf->get_SeqFeatures;\n       if (@cdsl) {\n\t   my @children = grep {$_->primary_tag ne 'CDS'} $sf->get_SeqFeatures;\n\t   my @mrnas = ();\n\t   foreach my $cds (@cdsl) {\n\t       \n               if ($self->verbose > 0) {\n                   print \"    Inferring mRNA from CDS $cds\\n\";\n               }\n               $self->_check_order_is_consistent($cds->location->strand,$cds->location->each_Location);\n               \n\t       my $loc = Bio::Location::Split->new;\n\t       foreach my $cdsexonloc ($cds->location->each_Location) {\n\t\t   my $subloc =\n\t\t     Bio::Location::Simple->new(-start=>$cdsexonloc->start,\n\t\t\t\t\t\t-end=>$cdsexonloc->end,\n\t\t\t\t\t\t-strand=>$cdsexonloc->strand);\n\t\t   $loc->add_sub_Location($subloc);\n\t       }\n\t       # share the same location\n\t       my $mrna =\n\t\t Bio::SeqFeature::Generic->new(-location=>$loc,\n\t\t\t\t\t       -primary_tag=>'mRNA');\n\t       \n               ## Provide seq_id to new feature:\n               $mrna->seq_id($cds->seq_id) if $cds->seq_id;\n               $mrna->source_tag($cds->source_tag) if $cds->source_tag;\n\n               $self->_check_order_is_consistent($mrna->location->strand,$mrna->location->each_Location);\n\n               # make the mRNA hold the CDS; no EXPAND option,\n               # the CDS cannot be wider than the mRNA\n\t       $mrna->add_SeqFeature($cds);\n\n\t       # mRNA steals children of CDS\n\t       foreach my $subsf ($cds->get_SeqFeatures) {\n\t\t   $mrna->add_SeqFeature($subsf);\n\t       }\n\t       $cds->remove_SeqFeatures;\n\t       push(@mrnas, $mrna);\n\t   }\n\t   # change gene/CDS to gene/mRNA\n\t   $sf->remove_SeqFeatures;\n\t   $sf->add_SeqFeature($_) foreach (@mrnas, @children);\n       }\n   }\n   return;\n   \n\n}\n\n=head2 remove_types\n\n Title   : remove_types\n Usage   : $unf->remove_types(-seq=>$seq, -types=>[\"mRNA\"]);\n Function:\n Example :\n Returns : \n Args    :\n\nremoves features of a set type\n\nuseful for pre-filtering a genbank record; eg to get rid of STSs\n\nalso, there is no way to unflatten\nftp.ncbi.nih.gov/genomes/Schizosaccharomyces_pombe/ UNLESS the bogus\nmRNAs in these records are removed (or changed to a different type) -\nthey just confuse things too much"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":2719},"start":{"character":0,"line":2702}},"name":"remove_types"},{"kind":12,"line":2739,"children":[{"line":2740,"kind":13,"localvar":"my","containerName":"_check_order_is_consistent","definition":"my","name":"$self"},{"definition":"my","name":"$parent_strand","containerName":"_check_order_is_consistent","localvar":"my","kind":13,"line":2742},{"localvar":"my","name":"@ranges","definition":"my","containerName":"_check_order_is_consistent","line":2743,"kind":13},{"name":"@ranges","containerName":"_check_order_is_consistent","kind":13,"line":2744},{"line":2745,"kind":13,"localvar":"my","name":"$rangestr","definition":"my","containerName":"_check_order_is_consistent"},{"containerName":"_check_order_is_consistent","name":"start","kind":12,"line":2746},{"containerName":"_check_order_is_consistent","name":"end","line":2746,"kind":12},{"name":"@ranges","containerName":"_check_order_is_consistent","line":2746,"kind":13},{"localvar":"my","containerName":"_check_order_is_consistent","name":"$strand","definition":"my","line":2747,"kind":13},{"name":"$ranges","containerName":"_check_order_is_consistent","line":2747,"kind":13},{"containerName":"_check_order_is_consistent","name":"strand","kind":12,"line":2747},{"localvar":"my","name":"$i","definition":"my","containerName":"_check_order_is_consistent","line":2748,"kind":13},{"kind":13,"line":2748,"name":"$i","containerName":"_check_order_is_consistent"},{"name":"@ranges","containerName":"_check_order_is_consistent","kind":13,"line":2748},{"name":"$i","containerName":"_check_order_is_consistent","kind":13,"line":2748},{"name":"$ranges","containerName":"_check_order_is_consistent","kind":13,"line":2749},{"kind":13,"line":2749,"containerName":"_check_order_is_consistent","name":"$i"},{"kind":12,"line":2749,"containerName":"_check_order_is_consistent","name":"strand"},{"line":2749,"kind":13,"containerName":"_check_order_is_consistent","name":"$strand"},{"name":"$self","containerName":"_check_order_is_consistent","line":2750,"kind":13},{"line":2750,"kind":12,"name":"problem","containerName":"_check_order_is_consistent"},{"localvar":"my","containerName":"_check_order_is_consistent","definition":"my","name":"$pass","line":2758,"kind":13},{"localvar":"my","name":"$i","definition":"my","containerName":"_check_order_is_consistent","line":2759,"kind":13},{"kind":13,"line":2759,"name":"$i","containerName":"_check_order_is_consistent"},{"line":2759,"kind":13,"containerName":"_check_order_is_consistent","name":"@ranges"},{"name":"$i","containerName":"_check_order_is_consistent","line":2759,"kind":13},{"line":2760,"kind":13,"localvar":"my","containerName":"_check_order_is_consistent","name":"$rangeP","definition":"my"},{"name":"$ranges","containerName":"_check_order_is_consistent","line":2760,"kind":13},{"containerName":"_check_order_is_consistent","name":"$i","kind":13,"line":2760},{"line":2761,"kind":13,"localvar":"my","containerName":"_check_order_is_consistent","definition":"my","name":"$range"},{"name":"$ranges","containerName":"_check_order_is_consistent","kind":13,"line":2761},{"name":"$i","containerName":"_check_order_is_consistent","kind":13,"line":2761},{"kind":13,"line":2762,"name":"$rangeP","containerName":"_check_order_is_consistent"},{"line":2762,"kind":12,"name":"start","containerName":"_check_order_is_consistent"},{"containerName":"_check_order_is_consistent","name":"$range","kind":13,"line":2762},{"containerName":"_check_order_is_consistent","name":"end","kind":12,"line":2762},{"name":"$pass","containerName":"_check_order_is_consistent","kind":13,"line":2764},{"line":2765,"kind":13,"name":"$self","containerName":"_check_order_is_consistent"},{"kind":12,"line":2765,"containerName":"_check_order_is_consistent","name":"problem"},{"containerName":"_check_order_is_consistent","name":"$pass","kind":13,"line":2770},{"kind":13,"line":2775,"name":"$i","definition":"my","containerName":"_check_order_is_consistent","localvar":"my"},{"line":2775,"kind":13,"containerName":"_check_order_is_consistent","name":"$i"},{"kind":13,"line":2775,"containerName":"_check_order_is_consistent","name":"@ranges"},{"line":2775,"kind":13,"containerName":"_check_order_is_consistent","name":"$i"},{"localvar":"my","name":"$rangeP","definition":"my","containerName":"_check_order_is_consistent","line":2776,"kind":13},{"containerName":"_check_order_is_consistent","name":"$ranges","kind":13,"line":2776},{"name":"$i","containerName":"_check_order_is_consistent","kind":13,"line":2776},{"containerName":"_check_order_is_consistent","name":"$range","definition":"my","localvar":"my","kind":13,"line":2777},{"kind":13,"line":2777,"name":"$ranges","containerName":"_check_order_is_consistent"},{"kind":13,"line":2777,"name":"$i","containerName":"_check_order_is_consistent"},{"containerName":"_check_order_is_consistent","name":"$rangeP","kind":13,"line":2778},{"line":2778,"kind":12,"name":"end","containerName":"_check_order_is_consistent"},{"line":2778,"kind":13,"containerName":"_check_order_is_consistent","name":"$range"},{"containerName":"_check_order_is_consistent","name":"start","line":2778,"kind":12},{"name":"$self","containerName":"_check_order_is_consistent","kind":13,"line":2779},{"name":"problem","containerName":"_check_order_is_consistent","line":2779,"kind":12}],"containerName":"main::","name":"_check_order_is_consistent","definition":"sub","range":{"start":{"line":2739,"character":0},"end":{"line":2785,"character":9999}}},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_locstr","localvar":"my","kind":13,"line":2791},{"containerName":"_locstr","name":"$sf","definition":"my","localvar":"my","kind":13,"line":2792},{"containerName":"_locstr","name":"$sf","kind":13,"line":2794},{"line":2794,"kind":12,"name":"start","containerName":"_locstr"},{"name":"$sf","containerName":"_locstr","kind":13,"line":2794},{"containerName":"_locstr","name":"end","line":2794,"kind":12}],"line":2790,"definition":"sub","name":"_locstr","containerName":"main::","range":{"end":{"line":2795,"character":9999},"start":{"line":2790,"character":0}}},{"definition":"sub","name":"iterate_containment_tree","containerName":"main::","range":{"end":{"character":9999,"line":2804},"start":{"line":2797,"character":0}},"kind":12,"children":[{"kind":13,"line":2798,"definition":"my","name":"$self","containerName":"iterate_containment_tree","localvar":"my"},{"line":2799,"kind":13,"localvar":"my","name":"$feature_holder","definition":"my","containerName":"iterate_containment_tree"},{"kind":13,"line":2800,"containerName":"iterate_containment_tree","definition":"my","name":"$sub","localvar":"my"},{"containerName":"iterate_containment_tree","name":"$sub","line":2801,"kind":13},{"line":2801,"kind":13,"name":"$feature_holder","containerName":"iterate_containment_tree"},{"localvar":"my","containerName":"iterate_containment_tree","name":"@sfs","definition":"my","line":2802,"kind":13},{"line":2802,"kind":13,"name":"$feature_holder","containerName":"iterate_containment_tree"},{"name":"get_SeqFeatures","containerName":"iterate_containment_tree","kind":12,"line":2802},{"name":"$self","containerName":"iterate_containment_tree","line":2803,"kind":13},{"line":2803,"kind":12,"name":"iterate_containment_tree","containerName":"iterate_containment_tree"},{"name":"@sfs","containerName":"iterate_containment_tree","line":2803,"kind":13}],"line":2797},{"kind":12,"line":2806,"children":[{"kind":13,"line":2807,"name":"$matrix","definition":"my","containerName":"find_best_pairs","localvar":"my"},{"kind":13,"line":2808,"containerName":"find_best_pairs","definition":"my","name":"$size","localvar":"my"},{"kind":13,"line":2809,"containerName":"find_best_pairs","name":"$i","definition":"my","localvar":"my"},{"localvar":"my","containerName":"find_best_pairs","definition":"my","name":"$j","line":2811,"kind":13},{"name":"$j","containerName":"find_best_pairs","line":2811,"kind":13},{"name":"$size","containerName":"find_best_pairs","line":2811,"kind":13},{"name":"$j","containerName":"find_best_pairs","kind":13,"line":2811},{"kind":13,"line":2812,"definition":"my","name":"$score","containerName":"find_best_pairs","localvar":"my"},{"name":"$matrix","containerName":"find_best_pairs","line":2812,"kind":13},{"kind":13,"line":2812,"name":"$i","containerName":"find_best_pairs"},{"kind":13,"line":2812,"containerName":"find_best_pairs","name":"$j"},{"name":"$score","containerName":"find_best_pairs","kind":13,"line":2813}],"containerName":"main::","definition":"sub","name":"find_best_pairs","range":{"end":{"character":9999,"line":2819},"start":{"line":2806,"character":0}}}],"version":5}