{"vars":[{"line":102,"kind":2,"containerName":"","name":"base"},{"range":{"start":{"line":116,"character":0},"end":{"line":127,"character":9999}},"name":"new","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":116,"children":[{"kind":13,"line":117,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"kind":13,"line":117,"containerName":"new","name":"@args"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":118},{"kind":13,"line":118,"containerName":"new","name":"$class"},{"kind":13,"line":118,"name":"@args","containerName":"new"},{"containerName":"new","definition":"my","name":"$typemap","localvar":"my","kind":13,"line":120},{"containerName":"new","name":"$self","line":121,"kind":13},{"line":121,"kind":12,"name":"_rearrange","containerName":"new"},{"kind":13,"line":123,"name":"@args","containerName":"new"},{"containerName":"new","name":"$typemap","line":125,"kind":13},{"kind":13,"line":125,"containerName":"new","name":"$self"},{"line":125,"kind":12,"name":"typemap","containerName":"new"},{"containerName":"new","name":"$typemap","line":125,"kind":13},{"kind":13,"line":126,"name":"$self","containerName":"new"}],"kind":12},{"name":"SUPER","containerName":"new","kind":12,"line":118},{"range":{"end":{"line":146,"character":9999},"start":{"character":0,"line":141}},"containerName":"main::","name":"typemap","definition":"sub","line":141,"children":[{"kind":13,"line":142,"definition":"my","name":"$self","containerName":"typemap","localvar":"my"},{"name":"$self","containerName":"typemap","line":144,"kind":13},{"name":"$self","containerName":"typemap","line":145,"kind":13}],"kind":12},{"name":"map_types","range":{"start":{"line":161,"character":0},"end":{"line":204,"character":9999}},"kind":12,"line":161,"children":[{"kind":13,"line":162,"name":"$self","definition":"my","containerName":"map_types","localvar":"my"},{"line":162,"kind":13,"name":"@args","containerName":"map_types"},{"localvar":"my","containerName":"map_types","name":"$sf","definition":"my","line":164,"kind":13},{"containerName":"map_types","name":"$seq","line":164,"kind":13},{"line":164,"kind":13,"containerName":"map_types","name":"$type_map"},{"line":164,"kind":13,"containerName":"map_types","name":"$undefmap"},{"containerName":"map_types","name":"$self","line":165,"kind":13},{"name":"_rearrange","containerName":"map_types","line":165,"kind":12},{"containerName":"map_types","name":"@args","kind":13,"line":170},{"kind":13,"line":171,"name":"$sf","containerName":"map_types"},{"kind":13,"line":171,"name":"$seq","containerName":"map_types"},{"containerName":"map_types","name":"$self","kind":13,"line":172},{"containerName":"map_types","name":"throw","line":172,"kind":12},{"localvar":"my","definition":"my","name":"@sfs","containerName":"map_types","line":175,"kind":13},{"name":"$sf","containerName":"map_types","kind":13,"line":175},{"containerName":"map_types","name":"$seq","kind":13,"line":176},{"name":"$seq","containerName":"map_types","line":177,"kind":13},{"containerName":"map_types","name":"isa","line":177,"kind":12},{"name":"$self","containerName":"map_types","kind":13,"line":177},{"line":177,"kind":12,"containerName":"map_types","name":"throw"},{"line":178,"kind":13,"containerName":"map_types","name":"@sfs"},{"kind":13,"line":178,"name":"$seq","containerName":"map_types"},{"containerName":"map_types","name":"get_all_SeqFeatures","kind":12,"line":178},{"containerName":"map_types","name":"$type_map","kind":13,"line":180},{"containerName":"map_types","name":"$type_map","line":180,"kind":13},{"containerName":"map_types","name":"$self","kind":13,"line":180},{"line":180,"kind":12,"containerName":"map_types","name":"typemap"},{"kind":13,"line":181,"containerName":"map_types","definition":"my","name":"$sf","localvar":"my"},{"containerName":"map_types","name":"@sfs","kind":13,"line":181},{"containerName":"map_types","name":"$sf","line":183,"kind":13},{"name":"isa","containerName":"map_types","line":183,"kind":12},{"name":"$self","containerName":"map_types","kind":13,"line":183},{"line":183,"kind":12,"containerName":"map_types","name":"throw"},{"kind":13,"line":184,"containerName":"map_types","name":"$sf"},{"name":"isa","containerName":"map_types","kind":12,"line":184},{"name":"$self","containerName":"map_types","line":184,"kind":13},{"name":"throw","containerName":"map_types","line":184,"kind":12},{"name":"$type","definition":"my","containerName":"map_types","localvar":"my","kind":13,"line":186},{"containerName":"map_types","name":"$sf","kind":13,"line":186},{"line":186,"kind":12,"containerName":"map_types","name":"primary_tag"},{"line":187,"kind":13,"localvar":"my","containerName":"map_types","definition":"my","name":"$mtype"},{"kind":13,"line":187,"containerName":"map_types","name":"$type_map"},{"line":187,"kind":13,"name":"$type","containerName":"map_types"},{"kind":13,"line":188,"name":"$mtype","containerName":"map_types"},{"name":"$mtype","containerName":"map_types","kind":13,"line":189},{"line":190,"kind":13,"name":"$mtype","containerName":"map_types"},{"line":191,"kind":13,"containerName":"map_types","name":"$mtype"},{"line":191,"kind":13,"name":"$mtype","containerName":"map_types"},{"containerName":"map_types","name":"$sf","kind":13,"line":191},{"line":194,"kind":13,"containerName":"map_types","name":"$self"},{"containerName":"map_types","name":"throw","line":194,"kind":12},{"kind":13,"line":197,"containerName":"map_types","name":"$undefmap"},{"name":"$mtype","containerName":"map_types","line":197,"kind":13},{"line":198,"kind":13,"containerName":"map_types","name":"$mtype"},{"line":198,"kind":13,"containerName":"map_types","name":"$undefmap"},{"line":200,"kind":13,"containerName":"map_types","name":"$sf"},{"containerName":"map_types","name":"primary_tag","kind":12,"line":200},{"name":"$mtype","containerName":"map_types","kind":13,"line":200}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($typemap) =\n\t$self->_rearrange([qw(TYPEMAP\n\t\t\t     )],\n                          @args);\n\n    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 typemap\n\n Title   : typemap\n Usage   : $obj->typemap($newval)\n Function: \n Example : \n Returns : value of typemap (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub typemap{\n    my $self = shift;\n\n    return $self->{'typemap'} = shift if @_;\n    return $self->{'typemap'};\n}\n\n=head2 map_types\n\n Title   : map_types\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n dgg: added -undefined => \"region\" option to produce all valid SO mappings.","label":"map_types($self,@args)"}},{"line":235,"children":[],"kind":12,"range":{"start":{"character":0,"line":235},"end":{"line":328,"character":9999}},"containerName":"main::","name":"FT_SO_map","definition":"sub"},{"line":319,"kind":12,"name":"misc_RNA"},{"line":322,"kind":12,"name":"source"},{"kind":12,"line":324,"name":"rep_origin"},{"kind":12,"line":326,"name":"Protein"},{"name":"map_types_to_SO","range":{"start":{"character":0,"line":330},"end":{"line":335,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"map_types_to_SO","localvar":"my","kind":13,"line":331},{"name":"@args","containerName":"map_types_to_SO","kind":13,"line":331},{"containerName":"map_types_to_SO","name":"@args","line":333,"kind":13},{"line":333,"kind":13,"containerName":"map_types_to_SO","name":"$self"},{"name":"FT_SO_map","containerName":"map_types_to_SO","kind":12,"line":333},{"name":"$self","containerName":"map_types_to_SO","kind":13,"line":334},{"kind":12,"line":334,"name":"map_types","containerName":"map_types_to_SO"},{"line":334,"kind":13,"name":"@args","containerName":"map_types_to_SO"}],"line":330,"definition":"sub","containerName":"main::","signature":{"label":"map_types_to_SO($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$child"}],"documentation":"1;\n# $Id: TypeMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::SeqFeature::Tools::TypeMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Mungall <cjm@fruitfly.org>\n#\n# Copyright Chris Mungall\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Tools::TypeMapper - maps $seq_feature-E<gt>primary_tag\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::SeqFeature::Tools::TypeMapper;\n\n  # first fetch a genbank SeqI object\n  $seqio =\n    Bio::SeqIO->new(-file=>'AE003644.gbk',\n                    -format=>'GenBank');\n  $seq = $seqio->next_seq();\n\n  $tm = Bio::SeqFeature::Tools::TypeMapper->new;\n\n  # map all the types in the sequence\n  $tm->map_types(-seq=>$seq,\n\t\t {CDS=>'ORF',\n\t\t  variation=>sub {\n\t\t      my $f = shift;\n\t\t      $f->length > 1 ?\n\t\t\t'variation' : 'SNP'\n\t\t  },\n\t\t });\n\n   # alternatively, use the hardcoded SO mapping\n   $tm->map_types_to_SO(-seq=>$seq);\n\n=head1 DESCRIPTION\n\nThis class implements an object for mapping between types; for\nexample, the types in a genbank feature table, and the types specified\nin the Sequence Ontology.\n\nYou can specify your own mapping, either as a simple hash index, or by\nproviding your own subroutines.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                         - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Mungall\n\nEmail:  cjm@fruitfly.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::SeqFeature::Tools::TypeMapper;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $unflattener = Bio::SeqFeature::Tools::TypeMapper->new();\n Function: constructor\n Example : \n Returns : a new Bio::SeqFeature::Tools::TypeMapper\n Args    : see below\n\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($typemap) =\n\t$self->_rearrange([qw(TYPEMAP\n\t\t\t     )],\n                          @args);\n\n    $typemap  && $self->typemap($typemap);\n    return $self; # success - we hope!\n}\n\n=head2 typemap\n\n Title   : typemap\n Usage   : $obj->typemap($newval)\n Function: \n Example : \n Returns : value of typemap (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub typemap{\n    my $self = shift;\n\n    return $self->{'typemap'} = shift if @_;\n    return $self->{'typemap'};\n}\n\n=head2 map_types\n\n Title   : map_types\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n dgg: added -undefined => \"region\" option to produce all valid SO mappings.\n\n\nsub map_types{\n   my ($self,@args) = @_;\n\n   my($sf, $seq, $type_map, $undefmap) =\n     $self->_rearrange([qw(FEATURE\n                           SEQ\n\t\t\t   TYPE_MAP\n\t\t\t   UNDEFINED\n                          )],\n                          @args);\n   if (!$sf && !$seq) {\n       $self->throw(\"you need to pass in either -feature or -seq\");\n   }\n\n   my @sfs = ($sf);\n   if ($seq) {\n       $seq->isa(\"Bio::SeqI\") || $self->throw(\"$seq NOT A SeqI\");\n       @sfs = $seq->get_all_SeqFeatures;\n   }\n   $type_map = $type_map || $self->typemap; # dgg: was type_map;\n   foreach my $sf (@sfs) {\n\n       $sf->isa(\"Bio::SeqFeatureI\") || $self->throw(\"$sf NOT A SeqFeatureI\");\n       $sf->isa(\"Bio::FeatureHolderI\") || $self->throw(\"$sf NOT A FeatureHolderI\");\n\n       my $type = $sf->primary_tag;\n       my $mtype = $type_map->{$type};\n       if ($mtype) {\n\t   if (ref($mtype)) {\n\t       if (ref($mtype) eq 'CODE') {\n\t\t   $mtype = $mtype->($sf);\n\t       }\n\t       else {\n\t\t   $self->throw('must be scalar or CODE ref');\n\t       }\n\t   }\n\t   elsif ($undefmap && $mtype eq 'undefined') { # dgg\n\t      $mtype= $undefmap;\n\t      }\n\t   $sf->primary_tag($mtype);\n       }\n   }\n   return;\n}\n\n=head2 map_types_to_SO\n\n Title   : map_types_to_SO\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\nhardcodes the genbank to SO mapping\n\nBased on revision 1.22 of SO\n\nPlease see the actual code for the mappings\n\nTaken from\n\nL<http://sequenceontology.org/resources/mapping/FT_SO.txt>\n\ndgg: separated out FT_SO_map for caller changes. Update with:\n\n  open(FTSO,\"curl -s http://sequenceontology.org/resources/mapping/FT_SO.txt|\");\n  while(<FTSO>){\n    chomp; ($ft,$so,$sid,$ftdef,$sodef)= split\"\\t\";\n    print \"     '$ft' => '$so',\\n\" if($ft && $so && $ftdef);             \n  }\n\n\nsub FT_SO_map  {\n  # $self= shift;\n  # note : some of the FT_SO mappings are commented out and overriden...\n  return {\n     \"FT term\" => \"SO term\",\n     \"-\" => \"located_sequence_feature\",\n     \"-10_signal\" => \"minus_10_signal\",\n     \"-35_signal\" => \"minus_35_signal\",\n     \"3'UTR\" => \"three_prime_UTR\",\n     \"3'clip\" => \"three_prime_clip\",\n     \"5'UTR\" => \"five_prime_UTR\",\n     \"5'clip\" => \"five_prime_clip\",\n     \"CAAT_signal\" => \"CAAT_signal\",\n     \"CDS\" => \"CDS\",\n     \"C_region\" => \"undefined\",\n     \"D-loop\" => \"D_loop\",\n     \"D_segment\" => \"D_gene\",\n     \"GC_signal\" => \"GC_rich_region\",\n     \"J_segment\" => \"undefined\",\n     \"LTR\" => \"long_terminal_repeat\",\n     \"N_region\" => \"undefined\",\n     \"RBS\" => \"ribosome_entry_site\",\n     \"STS\" => \"STS\",\n     \"S_region\" => \"undefined\",\n     \"TATA_signal\" => \"TATA_box\",\n     \"V_region\" => \"undefined\",\n     \"V_segment\" => \"undefined\",\n     \"attenuator\" => \"attenuator\",\n     \"conflict\" => \"undefined\",\n     \"enhancer\" => \"enhancer\",\n     \"exon\" => \"exon\",\n     \"gap\" => \"gap\",\n     \"gene\" => \"gene\",\n     \"iDNA\" => \"iDNA\",\n     \"intron\" => \"intron\",\n     \"mRNA\" => \"mRNA\",\n     \"mat_peptide\" => \"mature_protein_region\",\n     \"mature_peptide\" => \"mature_protein_region\",\n#                     \"misc_RNA\" => \"transcript\",\n     \"misc_binding\" => \"binding_site\",\n     \"misc_difference\" => \"sequence_difference\",\n     \"misc_feature\" => \"region\",\n     \"misc_recomb\" => \"recombination_feature\",\n     \"misc_signal\" => \"regulatory_region\",\n     \"misc_structure\" => \"sequence_secondary_structure\",\n     \"modified_base\" => \"modified_base_site\",\n     \"old_sequence\" => \"undefined\",\n     \"operon\" => \"operon\",\n     \"oriT\" => \"origin_of_transfer\",\n     \"polyA_signal\" => \"polyA_signal_sequence\",\n     \"polyA_site\" => \"polyA_site\",\n     \"precursor_RNA\" => \"primary_transcript\",\n     \"prim_transcript\" => \"primary_transcript\",\n     \"primer_bind\" => \"primer_binding_site\",\n     \"promoter\" => \"promoter\",\n     \"protein_bind\" => \"protein_binding_site\",\n     \"rRNA\" => \"rRNA\",\n     \"repeat_region\" => \"repeat_region\",\n     \"repeat_unit\" => \"repeat_unit\",\n     \"satellite\" => \"satellite_DNA\",\n     \"scRNA\" => \"scRNA\",\n     \"sig_peptide\" => \"signal_peptide\",\n     \"snRNA\" => \"snRNA\",\n     \"snoRNA\" => \"snoRNA\",\n#                     \"source\" => \"databank_entry\",\n     \"stem_loop\" => \"stem_loop\",\n     \"tRNA\" => \"tRNA\",\n     \"terminator\" => \"terminator\",\n     \"transit_peptide\" => \"transit_peptide\",\n     \"unsure\" => \"undefined\",\n     \"variation\" => \"sequence_variant\",\n\n      \"pseudomRNA\" => \"pseudogenic_transcript\", ## has parent = pseudogene ; dgg\n      \"pseudotranscript\" => \"pseudogenic_transcript\", ## from Unflattener misc_RNA ; dgg\n      \"pseudoexon\" => \"pseudogenic_exon\",\n      \"pseudoCDS\"  => \"pseudogenic_exon\",\n      \"pseudomisc_feature\" => \"pseudogenic_region\",\n      \"pseudointron\" => \"pseudogenic_region\",\n      \n      ## \"undefined\" => \"region\",\n\n      # this is the most generic form for RNAs;\n      # we always represent the processed form of\n      # the transcript\n      misc_RNA=>'processed_transcript',\n      \n      # not sure about this one...\n      source=>'contig',\n      \n      rep_origin=>'origin_of_replication',\n      \n      Protein=>'protein',\n      };\n}\n\nsub map_types_to_SO{\n   my ($self,@args) = @_;\n\n   push(@args, (-type_map=> $self->FT_SO_map() ) );\n   return $self->map_types(@args);\n}\n\n=head2 get_relationship_type_by_parent_child\n\n Title   : get_relationship_type_by_parent_child\n Usage   : $type = $tm->get_relationship_type_by_parent_child($parent_sf, $child_sf);\n Usage   : $type = $tm->get_relationship_type_by_parent_child('mRNA', 'protein');\n Function: given two features where the parent contains the child,\n           will determine what the relationship between them in\n Example :\n Returns : \n Args    : parent SeqFeature, child SeqFeature OR\n           parent type string, child type string OR\n\nbioperl Seq::FeatureHolderI hierarchies are equivalent to unlabeled\ngraphs (where parent nodes are the containers, and child nodes are the\nfeatures being contained). For example, a feature of type mRNA can\ncontain features of type exon.\n\nSome external representations (eg chadoxml or chaosxml) require that\nthe edges in the feature relationship graph are labeled. For example,\nthe type between mRNA and exon would be B<part_of>. Although it\nstretches the bioperl notion of containment, we could have a CDS\ncontained by an mRNA (for example, the\nL<Bio::SeqFeature::Tools::Unflattener> module takes genbank records\nand makes these kind of links. The relationship here would be\nB<produced_by>\n\nIn chado speak, the child is the B<subject> feature and the parent is\nthe B<object> feature","label":"get_relationship_type_by_parent_child($self,$parent,$child)"},"detail":"($self,$parent,$child)","definition":"sub","containerName":"main::","children":[{"line":369,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_relationship_type_by_parent_child"},{"kind":13,"line":369,"name":"$parent","containerName":"get_relationship_type_by_parent_child"},{"line":369,"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$child"},{"kind":13,"line":370,"containerName":"get_relationship_type_by_parent_child","name":"$parent"},{"name":"$parent","containerName":"get_relationship_type_by_parent_child","line":370,"kind":13},{"line":370,"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$parent"},{"name":"primary_tag","containerName":"get_relationship_type_by_parent_child","line":370,"kind":12},{"name":"$parent","containerName":"get_relationship_type_by_parent_child","kind":13,"line":370},{"kind":13,"line":371,"containerName":"get_relationship_type_by_parent_child","name":"$child"},{"kind":13,"line":371,"containerName":"get_relationship_type_by_parent_child","name":"$child"},{"name":"$child","containerName":"get_relationship_type_by_parent_child","kind":13,"line":371},{"kind":12,"line":371,"name":"primary_tag","containerName":"get_relationship_type_by_parent_child"},{"containerName":"get_relationship_type_by_parent_child","name":"$child","kind":13,"line":371},{"localvar":"my","definition":"my","name":"$type","containerName":"get_relationship_type_by_parent_child","line":373,"kind":13},{"name":"$child","containerName":"get_relationship_type_by_parent_child","line":377,"kind":13},{"kind":13,"line":378,"containerName":"get_relationship_type_by_parent_child","name":"$type"},{"line":380,"kind":13,"containerName":"get_relationship_type_by_parent_child","name":"$child"},{"kind":13,"line":381,"name":"$type","containerName":"get_relationship_type_by_parent_child"},{"line":383,"kind":13,"name":"$type","containerName":"get_relationship_type_by_parent_child"}],"line":368,"kind":12,"range":{"end":{"character":9999,"line":384},"start":{"line":368,"character":0}},"name":"get_relationship_type_by_parent_child"}],"version":5}