{"vars":[{"line":78,"kind":2,"containerName":"","name":"base"},{"kind":12,"children":[{"kind":13,"line":97,"containerName":"promoters","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"promoters","line":98,"kind":13},{"line":98,"kind":12,"name":"throw_not_implemented","containerName":"promoters"}],"line":96,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : ","parameters":[{"label":"$self"}],"label":"promoters($self)"},"detail":"($self)","name":"promoters","range":{"start":{"line":96,"character":0},"end":{"line":99,"character":9999}}},{"range":{"end":{"line":123,"character":9999},"start":{"line":120,"character":0}},"name":"exons","children":[{"line":121,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"exons"},{"kind":13,"line":121,"name":"$type","containerName":"exons"},{"kind":13,"line":122,"containerName":"exons","name":"$self"},{"kind":12,"line":122,"name":"throw_not_implemented","containerName":"exons"}],"line":120,"kind":12,"signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.","parameters":[{"label":"$self"},{"label":"$type"}],"label":"exons($self,$type)"},"detail":"($self,$type)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":137,"character":0},"end":{"line":140,"character":9999}},"name":"introns","detail":"($self)","signature":{"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : ","parameters":[{"label":"$self"}],"label":"introns($self)"},"containerName":"main::","definition":"sub","line":137,"children":[{"kind":13,"line":138,"containerName":"introns","name":"$self","definition":"my","localvar":"my"},{"line":139,"kind":13,"name":"$self","containerName":"introns"},{"line":139,"kind":12,"containerName":"introns","name":"throw_not_implemented"}],"kind":12},{"range":{"end":{"line":156,"character":9999},"start":{"character":0,"line":153}},"name":"poly_A_site","children":[{"localvar":"my","containerName":"poly_A_site","name":"$self","definition":"my","line":154,"kind":13},{"name":"$self","containerName":"poly_A_site","kind":13,"line":155},{"line":155,"kind":12,"name":"throw_not_implemented","containerName":"poly_A_site"}],"line":153,"kind":12,"signature":{"label":"poly_A_site($self)","documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : ","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":176}},"name":"utrs","line":173,"children":[{"name":"$self","definition":"my","containerName":"utrs","localvar":"my","kind":13,"line":174},{"kind":13,"line":175,"containerName":"utrs","name":"$self"},{"kind":12,"line":175,"containerName":"utrs","name":"throw_not_implemented"}],"kind":12,"detail":"($self)","signature":{"label":"utrs($self)","documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : ","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"name":"mrna","range":{"end":{"character":9999,"line":193},"start":{"line":190,"character":0}},"kind":12,"children":[{"line":191,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"mrna"},{"name":"$self","containerName":"mrna","kind":13,"line":192},{"line":192,"kind":12,"containerName":"mrna","name":"throw_not_implemented"}],"line":190,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","label":"mrna($self)"},"detail":"($self)"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"cds","line":209,"kind":13},{"line":210,"kind":13,"name":"$self","containerName":"cds"},{"line":210,"kind":12,"name":"throw_not_implemented","containerName":"cds"}],"line":208,"kind":12,"signature":{"label":"cds($self)","documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub mrna {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $transcript->cds();\n Function: Get the CDS (coding sequence) of the transcript as a sequence\n           object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":208},"end":{"line":211,"character":9999}},"name":"cds"},{"kind":12,"line":225,"children":[{"localvar":"my","containerName":"protein","definition":"my","name":"$self","line":226,"kind":13},{"name":"$self","containerName":"protein","kind":13,"line":227},{"name":"throw_not_implemented","containerName":"protein","kind":12,"line":227}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"protein($self)","documentation":"1;\n# $Id: TranscriptI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::TranscriptI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::TranscriptI - Interface for a feature representing a\n         transcript of exons, promoter(s), UTR, and a poly-adenylation site.\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nA feature representing a transcript.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::TranscriptI;\nuse strict;\n\nuse Carp;\n\nuse base qw(Bio::SeqFeatureI);\n\n=head2 promoters\n\n Title   : promoters()\n Usage   : @proms = $transcript->promoters();\n Function: Get the promoter features of this transcript.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           promoter regions or sites.\n Args    : \n\n\nsub promoters {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $transcript->exons();\n           @inital = $transcript->exons('Initial');\n Function: Get the individual exons this transcript comprises of, or all exons\n           of a specified type.\n\n           Refer to the documentation of the class that produced this \n           transcript object for information about the possible types.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : An optional string specifying the type of the exon.\n\n\nsub exons {\n    my ($self, $type) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $transcript->introns();\n Function: Get all introns this transcript comprises of.\n Returns : An array of Bio::SeqFeatureI implementing objects representing the\n           introns.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 poly_A_site\n\n Title   : poly_A_site()\n Usage   : $polyAsite = $transcript->poly_A_site();\n Function: Get the poly-adenylation site of this transcript.\n Returns : A Bio::SeqFeatureI implementing object.\n Args    : \n\n\n\nsub poly_A_site {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $transcript->utrs();\n Function: Get the UTR regions this transcript comprises of.\n\n           See Bio::SeqFeature::Gene::ExonI for properties of the\n           returned objects.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n Args    : \n\n\n\nsub utrs {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 mrna\n\n Title   : mrna()\n Usage   : $mrna = $transcript->mrna();\n Function: Get the mRNA of the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub mrna {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 cds\n\n Title   : cds()\n Usage   : $cds = $transcript->cds();\n Function: Get the CDS (coding sequence) of the transcript as a sequence\n           object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : \n\n\n\nsub cds {\n    my ($self) = @_;\n    $self->throw_not_implemented();\n}\n\n=head2 protein\n\n Title   : protein()\n Usage   : $protein = $transcript->protein();\n Function: Get the protein encoded by the transcript as a sequence object.\n\n Returns : A Bio::PrimarySeqI implementing object.\n Args    : ","parameters":[{"label":"$self"}]},"name":"protein","range":{"start":{"line":225,"character":0},"end":{"character":9999,"line":228}}},{"containerName":"main::","name":"parent","definition":"sub","range":{"end":{"character":9999,"line":255},"start":{"line":241,"character":0}},"kind":12,"line":241,"children":[{"localvar":"my","containerName":"parent","name":"$self","definition":"my","line":242,"kind":13},{"kind":13,"line":244,"containerName":"parent","definition":"my","name":"$value","localvar":"my"},{"line":247,"kind":13,"name":"$value","containerName":"parent"},{"line":248,"kind":13,"name":"$value","containerName":"parent"},{"kind":12,"line":248,"containerName":"parent","name":"isa"},{"kind":13,"line":249,"name":"$self","containerName":"parent"},{"containerName":"parent","name":"$value","line":249,"kind":13},{"containerName":"parent","name":"$self","kind":13,"line":251},{"name":"throw","containerName":"parent","line":251,"kind":12},{"containerName":"parent","name":"$self","kind":13,"line":254}]}],"version":5}