{"version":5,"vars":[{"kind":2,"line":76,"containerName":"","name":"vars"},{"containerName":"","name":"strict","kind":2,"line":81},{"line":82,"kind":13,"containerName":null,"name":"$Bio"},{"containerName":"Gene::GeneStructure::WeakRefs","name":"SeqFeature","kind":12,"line":82},{"kind":13,"line":83,"containerName":null,"name":"$Bio"},{"line":83,"kind":12,"containerName":"Gene::GeneStructure::WeakRefs","name":"SeqFeature"},{"name":"base","containerName":"","kind":2,"line":87},{"name":"new","range":{"end":{"character":9999,"line":102},"start":{"line":90,"character":0}},"kind":12,"children":[{"kind":13,"line":91,"definition":"my","name":"$caller","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":91},{"line":92,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"name":"$caller","containerName":"new","line":92,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":92},{"name":"$self","containerName":"new","kind":13,"line":93},{"name":"_register_for_cleanup","containerName":"new","kind":12,"line":93},{"kind":13,"line":94,"containerName":"new","definition":"my","name":"$primary","localvar":"my"},{"line":95,"kind":13,"containerName":"new","name":"$self"},{"line":95,"kind":12,"name":"_rearrange","containerName":"new"},{"line":96,"kind":13,"name":"@args","containerName":"new"},{"name":"$primary","containerName":"new","kind":13,"line":98},{"line":98,"kind":13,"containerName":"new","name":"$primary"},{"kind":13,"line":99,"containerName":"new","name":"$self"},{"line":99,"kind":12,"containerName":"new","name":"primary_tag"},{"kind":13,"line":99,"name":"$primary","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":100},{"kind":12,"line":100,"containerName":"new","name":"strand"},{"line":100,"kind":13,"containerName":"new","name":"$self"},{"line":100,"kind":12,"containerName":"new","name":"strand"},{"containerName":"new","name":"$self","line":101,"kind":13}],"line":90,"definition":"sub","containerName":"main::","signature":{"label":"new($caller,@args)","documentation":"","parameters":[{"label":"$caller"},{"label":"@args"}]},"detail":"($caller,@args)"},{"line":92,"kind":12,"containerName":"new","name":"SUPER"},{"line":93,"kind":12,"name":"gene_cleanup"},{"range":{"start":{"character":0,"line":117},"end":{"line":118,"character":9999}},"name":"transcripts","definition":"sub","containerName":"main::","children":[],"line":117,"kind":12},{"name":"shift","line":118,"kind":12},{"kind":12,"line":132,"children":[{"containerName":"add_transcript","name":"$self","definition":"my","localvar":"my","kind":13,"line":133},{"line":133,"kind":13,"containerName":"add_transcript","name":"$fea"},{"containerName":"add_transcript","name":"$fea","kind":13,"line":135},{"name":"$fea","containerName":"add_transcript","kind":13,"line":135},{"kind":12,"line":135,"containerName":"add_transcript","name":"isa"},{"name":"$self","containerName":"add_transcript","kind":13,"line":136},{"line":136,"kind":12,"name":"throw","containerName":"add_transcript"},{"line":138,"kind":13,"name":"$self","containerName":"add_transcript"},{"kind":13,"line":139,"name":"$self","containerName":"add_transcript"},{"containerName":"add_transcript","name":"$self","line":141,"kind":13},{"containerName":"add_transcript","name":"_expand_region","kind":12,"line":141},{"containerName":"add_transcript","name":"$fea","kind":13,"line":141},{"containerName":"add_transcript","name":"$Bio","line":142,"kind":13},{"containerName":"add_transcript","name":"$fea","line":143,"kind":13},{"containerName":"add_transcript","name":"parent","kind":12,"line":143},{"line":143,"kind":13,"name":"$self","containerName":"add_transcript"},{"containerName":"add_transcript","name":"$fea","line":145,"kind":13},{"containerName":"add_transcript","name":"parent","kind":12,"line":145},{"kind":13,"line":145,"containerName":"add_transcript","name":"$self"},{"containerName":"add_transcript","name":"$self","kind":13,"line":147}],"containerName":"main::","definition":"sub","detail":"($self,$fea)","signature":{"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.","parameters":[{"label":"$self"},{"label":"$fea"}],"label":"add_transcript($self,$fea)"},"name":"add_transcript","range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":132}}},{"containerName":"Gene::GeneStructure::WeakRefs","name":"SeqFeature","line":142,"kind":12},{"kind":12,"line":143,"name":"weaken"},{"kind":13,"line":147,"name":"$fea","containerName":null},{"line":161,"children":[{"name":"$self","definition":"my","containerName":"flush_transcripts","localvar":"my","kind":13,"line":162},{"containerName":"flush_transcripts","name":"$self","kind":13,"line":163},{"kind":13,"line":164,"definition":"my","name":"$t","containerName":"flush_transcripts","localvar":"my"},{"name":"$self","containerName":"flush_transcripts","kind":13,"line":164},{"kind":13,"line":165,"containerName":"flush_transcripts","name":"$t"},{"kind":12,"line":165,"name":"parent","containerName":"flush_transcripts"},{"name":"$t","containerName":"flush_transcripts","line":166,"kind":13},{"line":168,"kind":13,"containerName":"flush_transcripts","name":"$self"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :","label":"flush_transcripts($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":161},"end":{"line":169,"character":9999}},"name":"flush_transcripts"},{"name":"defined","line":164,"kind":12},{"kind":12,"line":184,"children":[{"localvar":"my","containerName":"add_transcript_as_features","name":"$self","definition":"my","line":185,"kind":13},{"kind":13,"line":185,"containerName":"add_transcript_as_features","name":"@features"},{"line":186,"kind":13,"localvar":"my","name":"$transcript","definition":"my","containerName":"add_transcript_as_features"},{"line":186,"kind":12,"containerName":"add_transcript_as_features","name":"new"},{"kind":13,"line":187,"definition":"my","name":"$fea","containerName":"add_transcript_as_features","localvar":"my"},{"containerName":"add_transcript_as_features","name":"@features","line":187,"kind":13},{"line":188,"kind":13,"name":"$fea","containerName":"add_transcript_as_features"},{"line":188,"kind":12,"containerName":"add_transcript_as_features","name":"primary_tag"},{"line":189,"kind":13,"containerName":"add_transcript_as_features","name":"$transcript"},{"name":"add_utr","containerName":"add_transcript_as_features","kind":12,"line":189},{"kind":13,"line":189,"containerName":"add_transcript_as_features","name":"$fea"},{"line":190,"kind":13,"name":"$fea","containerName":"add_transcript_as_features"},{"kind":12,"line":190,"containerName":"add_transcript_as_features","name":"primary_tag"},{"containerName":"add_transcript_as_features","name":"$transcript","kind":13,"line":191},{"containerName":"add_transcript_as_features","name":"add_promoter","kind":12,"line":191},{"name":"$fea","containerName":"add_transcript_as_features","kind":13,"line":191},{"containerName":"add_transcript_as_features","name":"$fea","line":192,"kind":13},{"line":192,"kind":12,"containerName":"add_transcript_as_features","name":"primary_tag"},{"name":"$transcript","containerName":"add_transcript_as_features","line":193,"kind":13},{"name":"poly_A_site","containerName":"add_transcript_as_features","line":193,"kind":12},{"containerName":"add_transcript_as_features","name":"$fea","kind":13,"line":193},{"line":195,"kind":13,"containerName":"add_transcript_as_features","name":"$transcript"},{"kind":12,"line":195,"name":"add_exon","containerName":"add_transcript_as_features"},{"name":"$fea","containerName":"add_transcript_as_features","kind":13,"line":195},{"line":198,"kind":13,"containerName":"add_transcript_as_features","name":"$self"},{"containerName":"add_transcript_as_features","name":"add_transcript","line":198,"kind":12},{"name":"$transcript","containerName":"add_transcript_as_features","kind":13,"line":198}],"containerName":"main::","definition":"sub","detail":"($self,@features)","signature":{"label":"add_transcript_as_features($self,@features)","parameters":[{"label":"$self"},{"label":"@features"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects"},"name":"add_transcript_as_features","range":{"start":{"line":184,"character":0},"end":{"line":199,"character":9999}}},{"kind":12,"line":186,"containerName":"SeqFeature::Gene::Transcript","name":"Bio"},{"children":[{"containerName":"promoters","definition":"my","name":"$self","localvar":"my","kind":13,"line":221},{"localvar":"my","containerName":"promoters","name":"@transcripts","definition":"my","line":222,"kind":13},{"line":222,"kind":13,"containerName":"promoters","name":"$self"},{"name":"transcripts","containerName":"promoters","kind":12,"line":222},{"kind":13,"line":223,"name":"@feas","definition":"my","containerName":"promoters","localvar":"my"},{"line":225,"kind":13,"localvar":"my","containerName":"promoters","name":"$tr","definition":"my"},{"kind":13,"line":225,"name":"@transcripts","containerName":"promoters"},{"line":226,"kind":13,"containerName":"promoters","name":"@feas"},{"line":226,"kind":13,"containerName":"promoters","name":"$tr"},{"kind":12,"line":226,"containerName":"promoters","name":"promoters"},{"kind":13,"line":228,"name":"@feas","containerName":"promoters"}],"line":220,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : ","label":"promoters($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":229},"start":{"line":220,"character":0}},"name":"promoters"},{"definition":"sub","containerName":"main::","signature":{"label":"exons($self,@args)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"exons","definition":"my","name":"$self","line":255,"kind":13},{"containerName":"exons","name":"@args","kind":13,"line":255},{"localvar":"my","containerName":"exons","definition":"my","name":"@transcripts","line":256,"kind":13},{"name":"$self","containerName":"exons","kind":13,"line":256},{"name":"transcripts","containerName":"exons","line":256,"kind":12},{"kind":13,"line":257,"containerName":"exons","name":"@feas","definition":"my","localvar":"my"},{"localvar":"my","containerName":"exons","name":"$tr","definition":"my","line":259,"kind":13},{"containerName":"exons","name":"@transcripts","line":259,"kind":13},{"containerName":"exons","name":"@feas","line":260,"kind":13},{"containerName":"exons","name":"$tr","line":260,"kind":13},{"name":"exons","containerName":"exons","kind":12,"line":260},{"name":"@args","containerName":"exons","kind":13,"line":260},{"line":262,"kind":13,"containerName":"exons","name":"@feas"}],"line":254,"name":"exons","range":{"end":{"character":9999,"line":263},"start":{"character":0,"line":254}}},{"range":{"start":{"line":283,"character":0},"end":{"character":9999,"line":292}},"name":"introns","children":[{"containerName":"introns","name":"$self","definition":"my","localvar":"my","kind":13,"line":284},{"line":285,"kind":13,"localvar":"my","containerName":"introns","definition":"my","name":"@transcripts"},{"containerName":"introns","name":"$self","kind":13,"line":285},{"containerName":"introns","name":"transcripts","kind":12,"line":285},{"localvar":"my","name":"@feas","definition":"my","containerName":"introns","line":286,"kind":13},{"kind":13,"line":288,"definition":"my","name":"$tr","containerName":"introns","localvar":"my"},{"containerName":"introns","name":"@transcripts","kind":13,"line":288},{"line":289,"kind":13,"name":"@feas","containerName":"introns"},{"line":289,"kind":13,"name":"$tr","containerName":"introns"},{"kind":12,"line":289,"name":"introns","containerName":"introns"},{"kind":13,"line":291,"containerName":"introns","name":"@feas"}],"line":283,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : ","label":"introns($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"poly_A_sites","range":{"start":{"character":0,"line":309},"end":{"line":318,"character":9999}},"kind":12,"children":[{"kind":13,"line":310,"definition":"my","name":"$self","containerName":"poly_A_sites","localvar":"my"},{"kind":13,"line":311,"containerName":"poly_A_sites","definition":"my","name":"@transcripts","localvar":"my"},{"name":"$self","containerName":"poly_A_sites","kind":13,"line":311},{"containerName":"poly_A_sites","name":"transcripts","line":311,"kind":12},{"kind":13,"line":312,"containerName":"poly_A_sites","name":"@feas","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$tr","containerName":"poly_A_sites","line":314,"kind":13},{"kind":13,"line":314,"containerName":"poly_A_sites","name":"@transcripts"},{"line":315,"kind":13,"name":"@feas","containerName":"poly_A_sites"},{"line":315,"kind":13,"name":"$tr","containerName":"poly_A_sites"},{"name":"poly_A_site","containerName":"poly_A_sites","kind":12,"line":315},{"line":317,"kind":13,"name":"@feas","containerName":"poly_A_sites"}],"line":309,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : ","parameters":[{"label":"$self"}],"label":"poly_A_sites($self)"},"detail":"($self)"},{"definition":"sub","containerName":"main::","signature":{"label":"utrs($self,@args)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"line":344,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"utrs"},{"line":344,"kind":13,"containerName":"utrs","name":"@args"},{"name":"@transcripts","definition":"my","containerName":"utrs","localvar":"my","kind":13,"line":345},{"containerName":"utrs","name":"$self","line":345,"kind":13},{"line":345,"kind":12,"containerName":"utrs","name":"transcripts"},{"line":346,"kind":13,"localvar":"my","containerName":"utrs","definition":"my","name":"@feas"},{"line":348,"kind":13,"localvar":"my","containerName":"utrs","definition":"my","name":"$tr"},{"line":348,"kind":13,"containerName":"utrs","name":"@transcripts"},{"line":349,"kind":13,"name":"@feas","containerName":"utrs"},{"containerName":"utrs","name":"$tr","kind":13,"line":349},{"name":"utrs","containerName":"utrs","line":349,"kind":12},{"kind":13,"line":349,"name":"@args","containerName":"utrs"},{"containerName":"utrs","name":"@feas","kind":13,"line":351}],"line":343,"name":"utrs","range":{"start":{"line":343,"character":0},"end":{"character":9999,"line":352}}},{"line":369,"children":[{"kind":13,"line":370,"containerName":"sub_SeqFeature","definition":"my","name":"$self","localvar":"my"},{"name":"@feas","definition":"my","containerName":"sub_SeqFeature","localvar":"my","kind":13,"line":371},{"line":374,"kind":13,"name":"@feas","containerName":"sub_SeqFeature"},{"kind":13,"line":374,"name":"$self","containerName":"sub_SeqFeature"},{"containerName":"sub_SeqFeature","name":"@feas","line":375,"kind":13},{"containerName":"sub_SeqFeature","name":"$self","line":375,"kind":13},{"name":"transcripts","containerName":"sub_SeqFeature","kind":12,"line":375},{"line":376,"kind":13,"name":"@feas","containerName":"sub_SeqFeature"}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self,@args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->utrs(@args));\n    }\n    return @feas;\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $gene->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the transcripts.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none","label":"sub_SeqFeature($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":369},"end":{"line":377,"character":9999}},"name":"sub_SeqFeature"},{"name":"SUPER","containerName":"sub_SeqFeature","kind":12,"line":374},{"line":400,"children":[{"kind":13,"line":401,"name":"$self","definition":"my","containerName":"flush_sub_SeqFeature","localvar":"my"},{"kind":13,"line":401,"name":"$fea_only","containerName":"flush_sub_SeqFeature"},{"line":403,"kind":13,"containerName":"flush_sub_SeqFeature","name":"$self"},{"name":"$fea_only","containerName":"flush_sub_SeqFeature","kind":13,"line":404},{"line":405,"kind":13,"name":"$self","containerName":"flush_sub_SeqFeature"},{"name":"flush_transcripts","containerName":"flush_sub_SeqFeature","line":405,"kind":12}],"kind":12,"detail":"($self,$fea_only)","signature":{"label":"flush_sub_SeqFeature($self,$fea_only)","documentation":"1;\n# $Id: GeneStructure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Gene::GeneStructure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Gene::GeneStructure - A feature representing an arbitrarily complex structure of a gene\n\n=head1 SYNOPSIS\n\n  # See documentation of methods.\n\n=head1 DESCRIPTION\n\nA feature representing a gene structure. As of now, a gene structure\nreally is only a collection of transcripts. See\nL<Bio::SeqFeature::Gene::TranscriptI> (interface) and\nL<Bio::SeqFeature::Gene::Transcript> (implementation) for the features\nof such objects.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\n the bugs and their resolution. Bug reports can be submitted via the\n web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp-at-gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Gene::GeneStructure;\nuse vars qw($WeakRefs);\nuse strict;\n\nBEGIN {\n    eval \"use Scalar::Util qw(weaken);\";\n    if ($@) {\n\t$Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 0;  \n    } else { $Bio::SeqFeature::Gene::GeneStructure::WeakRefs = 1; }\n}\n\n\nuse base qw(Bio::SeqFeature::Generic Bio::SeqFeature::Gene::GeneStructureI);\n\n\nsub new {\n    my ($caller, @args) = @_;\n    my $self = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&gene_cleanup);\n    my ($primary) =\n\t$self->_rearrange([qw(PRIMARY\n\t\t\t      )],@args);\n    \n    $primary = 'genestructure' unless $primary;\n    $self->primary_tag($primary);\n    $self->strand(0) if(! defined($self->strand()));\n    return $self;\n}\n\n=head2 transcripts\n\n Title   : transcripts\n Usage   : @transcripts = $gene->transcripts();\n Function: Get the transcripts of this gene structure. Many gene structures\n           will have only one transcript.\n\n Returns : An array of Bio::SeqFeature::Gene::TranscriptI implementing objects.\n Args    : \n\n\n\nsub transcripts {\n    return @{shift->{'_transcripts'} || []};\n}\n\n=head2 add_transcript\n\n Title   : add_transcript()\n Usage   : $gene->add_transcript($transcript);\n Function: Add a transcript to this gene structure.\n Returns : \n Args    : A Bio::SeqFeature::Gene::TranscriptI implementing object.\n\n\n\nsub add_transcript {\n    my ($self, $fea) = @_;\n\n    if(!$fea || ! $fea->isa('Bio::SeqFeature::Gene::TranscriptI') ) {\n\t$self->throw(\"$fea does not implement Bio::SeqFeature::Gene::TranscriptI\");\n    }\n    unless( exists $self->{'_transcripts'}  ) {\n\t$self->{'_transcripts'} = [];\n    }\n    $self->_expand_region($fea);\n    if( $Bio::SeqFeature::Gene::GeneStructure::WeakRefs ) {\n\t$fea->parent(weaken $self);\n    } else {\n\t$fea->parent($self);\n    }\n    push(@{$self->{'_transcripts'}}, $fea);\n}\n\n=head2 flush_transcripts\n\n Title   : flush_transcripts()\n Usage   : $gene->flush_transcripts();\n Function: Remove all transcripts from this gene structure.\n Returns : \n Args    :\n\n\n\nsub flush_transcripts {\n    my ($self) = @_;    \n    if( defined $self->{'_transcripts'} ) {\n\tforeach my $t ( grep {defined} @{$self->{'_transcripts'} || []} ) {\n\t    $t->parent(undef); # remove bkwds pointers\n\t    $t = undef;\n\t}\n\tdelete($self->{'_transcripts'});\t\n    }\n}\n\n=head2 add_transcript_as_features\n\n Title   : add_transcript_as_features\n Usage   : $gene->add_transcript_as_features(@featurelist);\n Function: take a list of Bio::SeqFeatureI objects and turn them into a\n           Bio::SeqFeature::Gene::Transcript object.  Add that transcript to the gene.\n Returns : nothing\n Args    : a list of Bio::SeqFeatureI compliant objects\n\n\n\nsub add_transcript_as_features {\n    my ($self,@features) = @_;\n    my $transcript=Bio::SeqFeature::Gene::Transcript->new;\n    foreach my $fea (@features) {\n\tif ($fea->primary_tag =~ /utr/i) { #UTR / utr/ 3' utr / utr5 etc.\n\t    $transcript->add_utr($fea);\n\t} elsif ($fea->primary_tag =~ /promot/i) { #allow for spelling differences\n\t    $transcript->add_promoter($fea);\n\t} elsif ($fea->primary_tag =~ /poly.*A/i) { #polyA, POLY_A, etc.\n\t    $transcript->poly_A_site($fea);\n\t} else {\t\t#assume the rest are exons\n\t    $transcript->add_exon($fea);\n\t}\n    }\n    $self->add_transcript($transcript);\n}\n\n\n=head2 promoters\n\n Title   : promoters\n Usage   : @prom_sites = $gene->promoters();\n Function: Get the promoter features of this gene structure.\n\n           This method basically merges the promoters returned by transcripts.\n\n           Note that OO-modeling of regulatory elements is not stable yet.\n           This means that this method might change or even disappear in a\n           future release. Be aware of this if you use it.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub promoters {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->promoters());\n    }\n    return @feas;\n}\n\n\n=head2 exons\n\n Title   : exons()\n Usage   : @exons = $gene->exons();\n           @inital_exons = $gene->exons('Initial');\n Function: Get all exon features or all exons of a specified type of this gene\n           structure.\n\n           Exon type is treated as a case-insensitive regular expression and \n           optional. For consistency, use only the following types: \n           initial, internal, terminal, utr, utr5prime, and utr3prime. \n           A special and virtual type is 'coding', which refers to all types\n           except utr.\n\n           This method basically merges the exons returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects.\n Args    : An optional string specifying the type of exon.\n\n\n\nsub exons {\n    my ($self, @args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->exons(@args));\n    }\n    return @feas;\n}\n\n=head2 introns\n\n Title   : introns()\n Usage   : @introns = $gene->introns();\n Function: Get all introns of this gene structure.\n\n           Note that this class currently generates these features on-the-fly,\n           that is, it simply treats all regions between exons as introns.\n           It assumes that the exons in the transcripts do not overlap.\n\n           This method basically merges the introns returned by transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub introns {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->introns());\n    }\n    return @feas;\n}\n\n=head2 poly_A_sites\n\n Title   : poly_A_sites()\n Usage   : @polyAsites = $gene->poly_A_sites();\n Function: Get the poly-adenylation sites of this gene structure.\n\n           This method basically merges the poly-adenylation sites returned by\n           transcripts.\n\n Returns : An array of Bio::SeqFeatureI implementing objects.\n Args    : \n\n\n\nsub poly_A_sites {\n    my ($self) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->poly_A_site());\n    }\n    return @feas;\n}\n\n=head2 utrs\n\n Title   : utrs()\n Usage   : @utr_sites = $gene->utrs('3prime');\n           @utr_sites = $gene->utrs('5prime');\n           @utr_sites = $gene->utrs();\n Function: Get the features representing untranslated regions (UTR) of this\n           gene structure.\n\n           You may provide an argument specifying the type of UTR. Currently\n           the following types are recognized: 5prime 3prime for UTR on the\n           5' and 3' end of the CDS, respectively.\n\n           This method basically merges the UTRs returned by transcripts.\n\n Returns : An array of Bio::SeqFeature::Gene::ExonI implementing objects\n           representing the UTR regions or sites.\n Args    : Optionally, either 3prime, or 5prime for the the type of UTR\n           feature.\n\n\n\nsub utrs {\n    my ($self,@args) = @_;\n    my @transcripts = $self->transcripts();\n    my @feas = ();\n\n    foreach my $tr (@transcripts) {\n\tpush(@feas, $tr->utrs(@args));\n    }\n    return @feas;\n}\n\n=head2 sub_SeqFeature\n\n Title   : sub_SeqFeature\n Usage   : @feats = $gene->sub_SeqFeature();\n Function: Returns an array of all subfeatures.\n\n           This method is defined in Bio::SeqFeatureI. We override this here\n           to include the transcripts.\n\n Returns : An array Bio::SeqFeatureI implementing objects.\n Args    : none\n\n\n\nsub sub_SeqFeature {\n    my ($self) = @_;   \n    my @feas = ();\n\n    # get what the parent already has\n    @feas = $self->SUPER::sub_SeqFeature();\n    push(@feas, $self->transcripts());\n    return @feas;\n}\n\n=head2 flush_sub_SeqFeature\n\n Title   : flush_sub_SeqFeature\n Usage   : $gene->flush_sub_SeqFeature();\n           $gene->flush_sub_SeqFeature(1);\n Function: Removes all subfeatures.\n\n           This method is overridden from Bio::SeqFeature::Generic to flush\n           all additional subfeatures, i.e., transcripts, which is\n           almost certainly not what you want. To remove only features added\n           through $gene->add_sub_SeqFeature($feature) pass any\n           argument evaluating to TRUE.\n\n Example :\n Returns : none\n Args    : Optionally, an argument evaluating to TRUE will suppress flushing\n           of all gene structure-specific subfeatures (transcripts).","parameters":[{"label":"$self"},{"label":"$fea_only"}]},"containerName":"main::","definition":"sub","range":{"end":{"line":407,"character":9999},"start":{"line":400,"character":0}},"name":"flush_sub_SeqFeature"},{"kind":12,"line":403,"containerName":"flush_sub_SeqFeature","name":"SUPER"},{"kind":12,"children":[{"localvar":"my","containerName":"gene_cleanup","name":"$self","definition":"my","line":410,"kind":13},{"kind":13,"line":411,"containerName":"gene_cleanup","name":"$self"},{"name":"flush_transcripts","containerName":"gene_cleanup","kind":12,"line":411}],"line":409,"name":"gene_cleanup","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":412},"start":{"character":0,"line":409}}}]}