{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":91},{"definition":"sub","containerName":"main::","signature":{"label":"add_sequence_as_string($self)","documentation":"1;\n# $Id: LargeSeqI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Seq::LargeSeqI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeSeqI - Interface class for sequences that cache their\nresidues in a temporary file\n\n=head1 SYNOPSIS\n\n #\n\n=head1 DESCRIPTION\n\nThe interface class defines a group of sequence classes that do not\nkeep their sequence information in memory but store it in a file. This\nmakes it possible to work with very large files even with limited RAM.\n\nThe most important consequence of file caching for sequences is that\nyou do not want to inspect the sequence unless absolutely\nnecessary. These sequences typically override the length() method not\nto check the sequence.\n\nThe seq() method is not resetable, if you want to add to the end of the\nsequence you have to use add_sequence_as_string(), for any other sequence chnages you'll\nhave to create a new object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Seq::LargeSeqI;\nuse strict;\n\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing  object.\n           This allows one to build up a large sequence without\n           storing entire object in memory.\n Returns : Current length of sequence\n Args    : string to append","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"localvar":"my","containerName":"add_sequence_as_string","definition":"my","name":"$self","line":107,"kind":13},{"containerName":"add_sequence_as_string","name":"$self","kind":13,"line":108},{"containerName":"add_sequence_as_string","name":"throw_not_implemented","kind":12,"line":108}],"line":106,"name":"add_sequence_as_string","range":{"end":{"line":109,"character":9999},"start":{"line":106,"character":0}}}]}