{"vars":[{"line":95,"kind":2,"name":"vars","containerName":""},{"kind":2,"line":99,"containerName":"","name":"base"},{"range":{"start":{"line":113,"character":0},"end":{"line":137,"character":9999}},"name":"new","detail":"($class,%params)","signature":{"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :","parameters":[{"label":"$class"},{"label":"%params"}],"label":"new($class,%params)"},"containerName":"main::","definition":"sub","line":113,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":114},{"line":114,"kind":13,"containerName":"new","name":"%params"},{"localvar":"my","containerName":"new","definition":"my","name":"$seq","line":119,"kind":13},{"line":119,"kind":13,"name":"$params","containerName":"new"},{"line":119,"kind":13,"name":"$params","containerName":"new"},{"kind":13,"line":120,"name":"$seq","containerName":"new"},{"name":"$params","containerName":"new","line":121,"kind":13},{"containerName":"new","name":"$params","line":122,"kind":13},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":124,"kind":13},{"kind":13,"line":124,"name":"$class","containerName":"new"},{"kind":13,"line":124,"containerName":"new","name":"%params"},{"kind":13,"line":125,"containerName":"new","name":"$mapping","definition":"my","localvar":"my"},{"containerName":"new","name":"$params","line":125,"kind":13},{"name":"$params","containerName":"new","kind":13,"line":125},{"line":126,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":126,"name":"mapping","containerName":"new"},{"containerName":"new","name":"$mapping","line":126,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":127},{"containerName":"new","name":"_initialize_io","kind":12,"line":127},{"containerName":"new","name":"%params","line":127,"kind":13},{"line":128,"kind":13,"localvar":"my","definition":"my","name":"$tempdir","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":128},{"containerName":"new","name":"tempdir","kind":12,"line":128},{"definition":"my","name":"$tfh","containerName":"new","localvar":"my","kind":13,"line":129},{"containerName":"new","name":"$file","line":129,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":129},{"containerName":"new","name":"tempfile","kind":12,"line":129},{"line":129,"kind":13,"name":"$tempdir","containerName":"new"},{"containerName":"new","name":"$tfh","line":131,"kind":13},{"kind":13,"line":131,"containerName":"new","name":"$self"},{"name":"_fh","containerName":"new","kind":12,"line":131},{"name":"$tfh","containerName":"new","line":131,"kind":13},{"kind":13,"line":132,"name":"$file","containerName":"new"},{"kind":13,"line":132,"containerName":"new","name":"$self"},{"kind":12,"line":132,"containerName":"new","name":"_filename"},{"kind":13,"line":132,"containerName":"new","name":"$file"},{"containerName":"new","name":"$self","kind":13,"line":133},{"name":"length","containerName":"new","kind":12,"line":133},{"containerName":"new","name":"$seq","line":134,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":134},{"kind":12,"line":134,"name":"seq","containerName":"new"},{"name":"$seq","containerName":"new","line":134,"kind":13},{"kind":13,"line":136,"containerName":"new","name":"$self"}],"kind":12},{"name":"SUPER","containerName":"new","line":124,"kind":12},{"name":"CLEANUP","line":128,"kind":12},{"kind":12,"line":129,"name":"DIR"},{"kind":12,"children":[{"containerName":"length","definition":"my","name":"$obj","localvar":"my","kind":13,"line":153},{"kind":13,"line":153,"containerName":"length","name":"$value"},{"line":154,"kind":13,"name":"$value","containerName":"length"},{"containerName":"length","name":"$obj","line":155,"kind":13},{"kind":13,"line":155,"containerName":"length","name":"$value"},{"name":"$obj","containerName":"length","kind":13,"line":158},{"name":"$obj","containerName":"length","line":158,"kind":13}],"line":152,"definition":"sub","containerName":"main::","signature":{"label":"length($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"detail":"($obj,$value)","name":"length","range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":159}}},{"range":{"end":{"line":183,"character":9999},"start":{"line":173,"character":0}},"name":"seq","signature":{"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$data"}],"label":"seq($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":174,"definition":"my","name":"$self","containerName":"seq","localvar":"my"},{"containerName":"seq","name":"$data","line":174,"kind":13},{"line":175,"kind":13,"name":"$data","containerName":"seq"},{"name":"$self","containerName":"seq","line":176,"kind":13},{"name":"length","containerName":"seq","kind":12,"line":176},{"containerName":"seq","name":"$self","line":177,"kind":13},{"name":"add_sequence_as_string","containerName":"seq","line":177,"kind":12},{"line":177,"kind":13,"name":"$data","containerName":"seq"},{"kind":13,"line":179,"containerName":"seq","name":"$self"},{"containerName":"seq","name":"warn","line":179,"kind":12},{"kind":13,"line":182,"containerName":"seq","name":"$self"},{"kind":12,"line":182,"containerName":"seq","name":"subseq"},{"name":"$self","containerName":"seq","line":182,"kind":13},{"line":182,"kind":12,"name":"length","containerName":"seq"}],"line":173,"kind":12},{"name":"subseq","range":{"end":{"line":263,"character":9999},"start":{"character":0,"line":198}},"containerName":"main::","definition":"sub","detail":"($self,$start,$end)","signature":{"parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"subseq($self,$start,$end)"},"kind":12,"line":198,"children":[{"localvar":"my","containerName":"subseq","name":"$self","definition":"my","line":199,"kind":13},{"kind":13,"line":199,"containerName":"subseq","name":"$start"},{"kind":13,"line":199,"name":"$end","containerName":"subseq"},{"containerName":"subseq","name":"$string","definition":"my","localvar":"my","kind":13,"line":200},{"name":"$fh","definition":"my","containerName":"subseq","localvar":"my","kind":13,"line":201},{"name":"$self","containerName":"subseq","kind":13,"line":201},{"containerName":"subseq","name":"_fh","line":201,"kind":12},{"name":"$start","containerName":"subseq","kind":13,"line":203},{"line":203,"kind":13,"name":"$start","containerName":"subseq"},{"line":203,"kind":12,"name":"isa","containerName":"subseq"},{"kind":13,"line":204,"definition":"my","name":"$loc","containerName":"subseq","localvar":"my"},{"name":"$start","containerName":"subseq","kind":13,"line":204},{"line":205,"kind":13,"name":"$loc","containerName":"subseq"},{"kind":12,"line":205,"containerName":"subseq","name":"length"},{"name":"$self","containerName":"subseq","line":206,"kind":13},{"containerName":"subseq","name":"warn","kind":12,"line":206},{"containerName":"subseq","name":"$loc","line":208,"kind":13},{"containerName":"subseq","name":"end","kind":12,"line":208},{"kind":13,"line":208,"containerName":"subseq","name":"$loc"},{"line":208,"kind":12,"name":"start","containerName":"subseq"},{"kind":13,"line":210,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"warn","line":210,"kind":12},{"localvar":"my","definition":"my","name":"$seq","containerName":"subseq","line":212,"kind":13},{"kind":13,"line":213,"name":"$loc","containerName":"subseq"},{"line":213,"kind":12,"name":"isa","containerName":"subseq"},{"localvar":"my","name":"$subloc","definition":"my","containerName":"subseq","line":214,"kind":13},{"kind":13,"line":214,"name":"$loc","containerName":"subseq"},{"line":214,"kind":12,"name":"sub_Location","containerName":"subseq"},{"containerName":"subseq","name":"$fh","kind":13,"line":215},{"line":215,"kind":13,"containerName":"subseq","name":"$subloc"},{"line":215,"kind":12,"containerName":"subseq","name":"start"},{"kind":13,"line":216,"containerName":"subseq","name":"$self"},{"name":"throw","containerName":"subseq","kind":12,"line":216},{"kind":13,"line":218,"containerName":"subseq","name":"$ret","definition":"my","localvar":"my"},{"line":218,"kind":13,"name":"$fh","containerName":"subseq"},{"line":218,"kind":13,"containerName":"subseq","name":"$string"},{"name":"$subloc","containerName":"subseq","line":218,"kind":13},{"containerName":"subseq","name":"length","kind":12,"line":218},{"line":219,"kind":13,"containerName":"subseq","name":"$ret"},{"line":220,"kind":13,"containerName":"subseq","name":"$self"},{"name":"throw","containerName":"subseq","kind":12,"line":220},{"containerName":"subseq","name":"$subloc","kind":13,"line":222},{"kind":12,"line":222,"containerName":"subseq","name":"strand"},{"line":224,"kind":13,"name":"$string","containerName":"subseq"},{"name":"new","containerName":"subseq","kind":12,"line":224},{"line":224,"kind":13,"name":"$string","containerName":"subseq"},{"containerName":"subseq","name":"revcom","line":224,"kind":12},{"line":224,"kind":12,"name":"seq","containerName":"subseq"},{"containerName":"subseq","name":"$seq","kind":13,"line":226},{"containerName":"subseq","name":"$string","kind":13,"line":226},{"containerName":"subseq","name":"$fh","line":229,"kind":13},{"line":229,"kind":13,"containerName":"subseq","name":"$loc"},{"containerName":"subseq","name":"start","kind":12,"line":229},{"line":230,"kind":13,"name":"$self","containerName":"subseq"},{"kind":12,"line":230,"containerName":"subseq","name":"throw"},{"line":230,"kind":13,"name":"$loc","containerName":"subseq"},{"name":"start","containerName":"subseq","kind":12,"line":230},{"line":231,"kind":13,"containerName":"subseq","name":"$loc"},{"containerName":"subseq","name":"end","line":231,"kind":12},{"kind":13,"line":233,"containerName":"subseq","name":"$ret","definition":"my","localvar":"my"},{"containerName":"subseq","name":"$fh","line":233,"kind":13},{"line":233,"kind":13,"name":"$string","containerName":"subseq"},{"name":"$loc","containerName":"subseq","line":233,"kind":13},{"containerName":"subseq","name":"length","line":233,"kind":12},{"line":234,"kind":13,"containerName":"subseq","name":"$ret"},{"name":"$self","containerName":"subseq","kind":13,"line":235},{"containerName":"subseq","name":"throw","line":235,"kind":12},{"name":"$loc","containerName":"subseq","kind":13,"line":235},{"kind":12,"line":235,"name":"start","containerName":"subseq"},{"name":"$loc","containerName":"subseq","kind":13,"line":236},{"kind":12,"line":236,"name":"end","containerName":"subseq"},{"kind":13,"line":238,"containerName":"subseq","name":"$seq"},{"line":238,"kind":13,"containerName":"subseq","name":"$string"},{"name":"$loc","containerName":"subseq","kind":13,"line":240},{"line":240,"kind":12,"containerName":"subseq","name":"strand"},{"line":241,"kind":13,"name":"$loc","containerName":"subseq"},{"kind":12,"line":241,"name":"strand","containerName":"subseq"},{"name":"$seq","containerName":"subseq","kind":13,"line":243},{"kind":12,"line":243,"containerName":"subseq","name":"new"},{"name":"$seq","containerName":"subseq","kind":13,"line":243},{"name":"revcom","containerName":"subseq","line":243,"kind":12},{"name":"seq","containerName":"subseq","kind":12,"line":243},{"line":245,"kind":13,"name":"$seq","containerName":"subseq"},{"containerName":"subseq","name":"$start","kind":13,"line":247},{"line":247,"kind":13,"containerName":"subseq","name":"$end"},{"line":247,"kind":13,"containerName":"subseq","name":"$self"},{"containerName":"subseq","name":"length","kind":12,"line":247},{"containerName":"subseq","name":"$self","kind":13,"line":248},{"containerName":"subseq","name":"throw","kind":12,"line":248},{"name":"$self","containerName":"subseq","line":249,"kind":13},{"line":249,"kind":12,"name":"length","containerName":"subseq"},{"line":251,"kind":13,"name":"$end","containerName":"subseq"},{"line":251,"kind":13,"name":"$start","containerName":"subseq"},{"containerName":"subseq","name":"$self","kind":13,"line":252},{"containerName":"subseq","name":"throw","kind":12,"line":252},{"line":255,"kind":13,"containerName":"subseq","name":"$fh"},{"name":"$start","containerName":"subseq","kind":13,"line":255},{"line":256,"kind":13,"containerName":"subseq","name":"$self"},{"name":"throw","containerName":"subseq","kind":12,"line":256},{"line":258,"kind":13,"localvar":"my","containerName":"subseq","definition":"my","name":"$ret"},{"name":"$fh","containerName":"subseq","line":258,"kind":13},{"name":"$string","containerName":"subseq","line":258,"kind":13},{"containerName":"subseq","name":"$end","line":258,"kind":13},{"kind":13,"line":258,"containerName":"subseq","name":"$start"},{"containerName":"subseq","name":"$ret","line":259,"kind":13},{"kind":13,"line":260,"containerName":"subseq","name":"$self"},{"kind":12,"line":260,"containerName":"subseq","name":"throw"},{"kind":13,"line":262,"name":"$string","containerName":"subseq"}]},{"containerName":"Seq::LargePrimarySeq","name":"Bio","kind":12,"line":224},{"name":"Bio","containerName":"Seq::LargePrimarySeq","kind":12,"line":243},{"range":{"end":{"line":287,"character":9999},"start":{"character":0,"line":278}},"name":"add_sequence_as_string","children":[{"line":279,"kind":13,"localvar":"my","containerName":"add_sequence_as_string","name":"$self","definition":"my"},{"name":"$str","containerName":"add_sequence_as_string","line":279,"kind":13},{"localvar":"my","containerName":"add_sequence_as_string","definition":"my","name":"$len","line":280,"kind":13},{"containerName":"add_sequence_as_string","name":"$self","line":280,"kind":13},{"kind":12,"line":280,"containerName":"add_sequence_as_string","name":"length"},{"containerName":"add_sequence_as_string","name":"$str","kind":13,"line":280},{"containerName":"add_sequence_as_string","name":"$fh","definition":"my","localvar":"my","kind":13,"line":281},{"kind":13,"line":281,"containerName":"add_sequence_as_string","name":"$self"},{"name":"_fh","containerName":"add_sequence_as_string","line":281,"kind":12},{"kind":13,"line":282,"name":"$fh","containerName":"add_sequence_as_string"},{"name":"$self","containerName":"add_sequence_as_string","kind":13,"line":283},{"line":283,"kind":12,"containerName":"add_sequence_as_string","name":"throw"},{"kind":13,"line":285,"name":"$self","containerName":"add_sequence_as_string"},{"line":285,"kind":12,"name":"_print","containerName":"add_sequence_as_string"},{"kind":13,"line":285,"name":"$str","containerName":"add_sequence_as_string"},{"line":286,"kind":13,"containerName":"add_sequence_as_string","name":"$self"},{"kind":12,"line":286,"name":"length","containerName":"add_sequence_as_string"},{"name":"$len","containerName":"add_sequence_as_string","line":286,"kind":13}],"line":278,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append","label":"add_sequence_as_string($self,$str)"},"detail":"($self,$str)","definition":"sub","containerName":"main::"},{"name":"CORE","containerName":"length","kind":12,"line":280},{"name":"_filename","range":{"start":{"character":0,"line":302},"end":{"line":309,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_filename($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function:\n Example :\n Returns : value of _filename\n Args    : newvalue (optional)"},"detail":"($obj,$value)","kind":12,"children":[{"kind":13,"line":303,"containerName":"_filename","definition":"my","name":"$obj","localvar":"my"},{"containerName":"_filename","name":"$value","line":303,"kind":13},{"containerName":"_filename","name":"$value","kind":13,"line":304},{"kind":13,"line":305,"name":"$obj","containerName":"_filename"},{"kind":13,"line":305,"containerName":"_filename","name":"$value"},{"name":"$obj","containerName":"_filename","line":307,"kind":13}],"line":302},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"alphabet($self,$value)","documentation":"1;\n# BioPerl module for Bio::Seq::LargeLocatableSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Albert Vilella\n#\n#\tbased on the Bio::LargePrimarySeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n#       and the Bio::LocatableSeq module\n#       by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Albert Vilella\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Seq::LargeLocatableSeq - LocatableSeq object that stores sequence as\nfiles in the tempdir\n\n=head1 SYNOPSIS\n\n  # normal primary seq usage\n    use Bio::Seq::LargeLocatableSeq;\n    my $seq = Bio::Seq::LargeLocatableSeq->new(-seq => \"CAGT-GGT\",\n\t\t\t\t              -id  => \"seq1\",\n\t\t\t\t              -start => 1,\n\t\t\t\t              -end   => 7);\n\n=head1 DESCRIPTION\n\nBio::Seq::LargeLocatableSeq - object with start/end points on it that\ncan be projected into a MSA or have coordinates relative to another\nseq.\n\nThis object, unlike Bio::LocatableSeq, stores a sequence as a series\nof files in a temporary directory. The aim is to allow someone the\nability to store very large sequences (eg, E<gt> 100MBases) in a file\nsystem without running out of memory (eg, on a 64 MB real memory\nmachine!).\n\nOf course, to actually make use of this functionality, the programs\nwhich use this object B<must> not call $primary_seq-E<gt>seq otherwise\nthe entire sequence will come out into memory and probably crash your\nmachine. However, calls like $primary_seq-E<gt>subseq(10,100) will cause\nonly 90 characters to be brought into real memory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Albert Vilella\n\nEmail avilella-AT-gmail-DOT-com\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Seq::LargeLocatableSeq;\nuse vars qw($AUTOLOAD);\nuse strict;\n\n\nuse base qw(Bio::Seq::LargePrimarySeq Bio::LocatableSeq Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Seq::LargeLocatableSeq->new();\n Function: Builds a new Bio::Seq::LargeLocatableSeq object\n Returns : an instance of Bio::Seq::LargeLocatableSeq\n Args    :\n\n\n\nsub new {\n    my ($class, %params) = @_;\n\n    # don't let PrimarySeq set seq until we have\n    # opened filehandle\n\n    my $seq = $params{'-seq'} || $params{'-SEQ'};\n    if($seq ) {\n\tdelete $params{'-seq'};\n\tdelete $params{'-SEQ'};\n    }\n    my $self = $class->SUPER::new(%params);\n    my $mapping = exists $params{'-mapping'} ? $params{'-mapping'} : [1,1];\n    $self->mapping($mapping);\n    $self->_initialize_io(%params);\n    my $tempdir = $self->tempdir( CLEANUP => 1);\n    my ($tfh,$file) = $self->tempfile( DIR => $tempdir );\n\n    $tfh     && $self->_fh($tfh);\n    $file    && $self->_filename($file);\n    $self->length(0);\n    $seq && $self->seq($seq);\n\n    return $self;\n}\n\n\n=head2 length\n\n Title   : length\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub length {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'length'} = $value;\n    }\n\n    return (defined $obj->{'length'}) ? $obj->{'length'} : 0;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub seq {\n   my ($self, $data) = @_;\n   if( defined $data ) {\n       if( $self->length() == 0) {\n\t   $self->add_sequence_as_string($data);\n       } else {\n\t   $self->warn(\"Trying to reset the seq string, cannot do this with a LargeLocatableSeq - must allocate a new object\");\n       }\n   }\n   return $self->subseq(1,$self->length);\n}\n\n\n=head2 subseq\n\n Title   : subseq\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub subseq{\n   my ($self,$start,$end) = @_;\n   my $string;\n   my $fh = $self->_fh();\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       if( $loc->length == 0 ) {\n\t   $self->warn(\"Expect location lengths to be > 0\");\n\t   return '';\n       } elsif( $loc->end < $loc->start ) {\n\t   # what about circular seqs\n\t   $self->warn(\"Expect location start to come before location end\");\n       }\n       my $seq = '';\n       if( $loc->isa('Bio::Location::SplitLocationI') ) {\n\t   foreach my $subloc ( $loc->sub_Location ) {\n\t       if(! seek($fh,$subloc->start() - 1,0)) {\n\t\t   $self->throw(\"Unable to seek on file $start:$end $!\");\n\t       }\n\t       my $ret = read($fh, $string, $subloc->length());\n\t       if( !defined $ret ) {\n\t\t   $self->throw(\"Unable to read $start:$end $!\");\n\t       }\n\t       if( $subloc->strand < 0 ) {\n# \t\t   $string = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t\t   $string = Bio::Seq::LargePrimarySeq->new(-seq => $string)->revcom()->seq();\n\t       }\n\t       $seq .= $string;\t\t\n\t   }\n       } else {\n\t   if(! seek($fh,$loc->start()-1,0)) {\n\t       $self->throw(\"Unable to seek on file \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   my $ret = read($fh, $string, $loc->length());\n\t   if( !defined $ret ) {\n\t       $self->throw(\"Unable to read \".$loc->start.\":\".\n\t\t\t    $loc->end .\" $!\");\n\t   }\n\t   $seq = $string;\n       }\n       if( defined $loc->strand &&\n\t   $loc->strand < 0 ) {\n# \t   $seq = Bio::PrimarySeq->new(-seq => $string)->revcom()->seq();\n\t   $seq = Bio::Seq::LargePrimarySeq->new(-seq => $seq)->revcom()->seq();\n       }\n       return $seq;\n   }\n   if( $start <= 0 || $end > $self->length ) {\n       $self->throw(\"Attempting to get a subseq out of range $start:$end vs \".\n\t\t    $self->length);\n   }\n   if( $end < $start ) {\n       $self->throw(\"Attempting to subseq with end ($end) less than start ($start). To revcom use the revcom function with trunc\");\n   }\n\n   if(! seek($fh,$start-1,0)) {\n       $self->throw(\"Unable to seek on file $start:$end $!\");\n   }\n   my $ret = read($fh, $string, $end-$start+1);\n   if( !defined $ret ) {\n       $self->throw(\"Unable to read $start:$end $!\");\n   }\n   return $string;\n}\n\n\n=head2 add_sequence_as_string\n\n Title   : add_sequence_as_string\n Usage   : $seq->add_sequence_as_string(\"CATGAT\");\n Function: Appends additional residues to an existing LargeLocatableSeq object.\n           This allows one to build up a large sequence without storing\n           entire object in memory.\n Returns : Current length of sequence\n Args    : string to append\n\n\nsub add_sequence_as_string{\n   my ($self,$str) = @_;\n   my $len = $self->length + CORE::length($str);\n   my $fh = $self->_fh();\n   if(! seek($fh,0,2)) {\n       $self->throw(\"Unable to seek end of file: $!\");\n   }\n   $self->_print($str);\n   $self->length($len);\n}\n\n\n=head2 _filename\n\n Title   : _filename\n Usage   : $obj->_filename($newval)\n Function:\n Example :\n Returns : value of _filename\n Args    : newvalue (optional)\n\n\n\nsub _filename{\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'_filename'} = $value;\n    }\n    return $obj->{'_filename'};\n\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : $obj->alphabet($newval)\n Function:\n Example :\n Returns : value of alphabet\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":324,"children":[{"containerName":"alphabet","name":"$self","definition":"my","localvar":"my","kind":13,"line":325},{"line":325,"kind":13,"containerName":"alphabet","name":"$value"},{"kind":13,"line":326,"name":"$value","containerName":"alphabet"},{"name":"$self","containerName":"alphabet","kind":13,"line":327},{"name":"$value","containerName":"alphabet","line":327,"kind":13},{"containerName":"alphabet","name":"$self","line":329,"kind":13}],"name":"alphabet","range":{"start":{"line":324,"character":0},"end":{"character":9999,"line":331}}},{"containerName":"alphabet","name":"SUPER","kind":12,"line":327},{"kind":12,"line":329,"containerName":"alphabet","name":"SUPER"},{"range":{"start":{"character":0,"line":333},"end":{"character":9999,"line":340}},"name":"DESTROY","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"DESTROY","line":334,"kind":13},{"containerName":"DESTROY","definition":"my","name":"$fh","localvar":"my","kind":13,"line":335},{"kind":13,"line":335,"name":"$self","containerName":"DESTROY"},{"line":335,"kind":12,"name":"_fh","containerName":"DESTROY"},{"line":336,"kind":13,"name":"$fh","containerName":"DESTROY"},{"containerName":"DESTROY","name":"$fh","line":336,"kind":13},{"line":338,"kind":13,"containerName":"DESTROY","name":"$self"},{"name":"_filename","containerName":"DESTROY","kind":12,"line":338},{"line":338,"kind":13,"containerName":"DESTROY","name":"$self"},{"line":338,"kind":12,"containerName":"DESTROY","name":"_filename"},{"line":338,"kind":13,"name":"$self","containerName":"DESTROY"},{"kind":12,"line":338,"name":"_filename","containerName":"DESTROY"},{"line":339,"kind":13,"containerName":"DESTROY","name":"$self"}],"line":333,"kind":12},{"kind":12,"line":339,"name":"SUPER","containerName":"DESTROY"}],"version":5}