{"version":5,"vars":[{"line":78,"kind":2,"name":"vars","containerName":""},{"line":83,"kind":2,"containerName":"","name":"base"},{"line":85,"kind":13,"containerName":null,"name":"%MODEMAP"},{"containerName":null,"name":"%MAPPING","line":89,"kind":13},{"name":"$DEFAULT_WRITER_CLASS","containerName":null,"line":119,"kind":13},{"children":[{"localvar":"my","containerName":"_initialize","definition":"my","name":"$self","line":137,"kind":13},{"kind":13,"line":137,"containerName":"_initialize","name":"@args"},{"line":138,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$wisetype"},{"line":138,"kind":13,"name":"$file","containerName":"_initialize"},{"line":138,"kind":13,"containerName":"_initialize","name":"$fh"},{"kind":13,"line":139,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":139},{"name":"@args","containerName":"_initialize","line":139,"kind":13},{"name":"@newargs","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":140},{"kind":13,"line":141,"name":"@args","containerName":"_initialize"},{"line":142,"kind":13,"localvar":"my","containerName":"_initialize","name":"$a","definition":"my"},{"kind":13,"line":142,"name":"@args","containerName":"_initialize"},{"kind":13,"line":143,"containerName":"_initialize","name":"$a"},{"kind":13,"line":144,"containerName":"_initialize","name":"@args"},{"name":"@newargs","containerName":"_initialize","kind":13,"line":147},{"containerName":"_initialize","name":"$a","line":147,"kind":13},{"containerName":"_initialize","name":"@args","line":147,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":149},{"kind":13,"line":149,"containerName":"_initialize","name":"@newargs"},{"kind":13,"line":153,"name":"$self","containerName":"_initialize"},{"line":153,"kind":13,"name":"$self","containerName":"_initialize"},{"line":153,"kind":12,"containerName":"_initialize","name":"_eventHandler"},{"containerName":"_initialize","name":"$self","line":155,"kind":13},{"name":"wisetype","containerName":"_initialize","kind":12,"line":155},{"name":"$wisetype","containerName":"_initialize","line":155,"kind":13},{"localvar":"my","definition":"my","name":"@ioargs","containerName":"_initialize","line":156,"kind":13},{"line":157,"kind":13,"containerName":"_initialize","name":"$fh"},{"kind":13,"line":158,"name":"@ioargs","containerName":"_initialize"},{"line":158,"kind":13,"containerName":"_initialize","name":"$fh"},{"name":"$file","containerName":"_initialize","line":159,"kind":13},{"kind":13,"line":160,"name":"@ioargs","containerName":"_initialize"},{"containerName":"_initialize","name":"$file","kind":13,"line":160},{"line":163,"kind":13,"name":"$wisetype","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","kind":13,"line":164},{"containerName":"_initialize","name":"wise","line":164,"kind":12},{"line":164,"kind":12,"name":"new","containerName":"_initialize"},{"line":164,"kind":13,"containerName":"_initialize","name":"@ioargs"},{"containerName":"_initialize","name":"$wisetype","line":165,"kind":13},{"line":166,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"wise","kind":12,"line":166},{"line":166,"kind":12,"containerName":"_initialize","name":"new"},{"name":"@ioargs","containerName":"_initialize","line":166,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":168},{"kind":12,"line":168,"containerName":"_initialize","name":"throw"},{"name":"$self","containerName":"_initialize","kind":13,"line":168},{"name":"$self","containerName":"_initialize","kind":13,"line":170}],"line":136,"kind":12,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":136},"end":{"character":9999,"line":171}},"name":"_initialize"},{"containerName":"Bio::Tools::Genewise::Bio::Tools","name":"Genomewise","kind":2,"line":137},{"line":149,"kind":12,"name":"SUPER","containerName":"_initialize"},{"containerName":"Tools::Genewise","name":"Bio","kind":12,"line":164},{"containerName":"Tools::Genomewise","name":"Bio","line":166,"kind":12},{"name":"next_result","range":{"end":{"character":9999,"line":253},"start":{"line":184,"character":0}},"kind":12,"line":184,"children":[{"definition":"my","name":"$self","containerName":"next_result","localvar":"my","kind":13,"line":185},{"line":189,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":189,"containerName":"next_result","name":"wise"},{"localvar":"my","containerName":"next_result","name":"$prediction","definition":"my","line":190,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":190},{"containerName":"next_result","name":"wise","kind":12,"line":190},{"name":"next_prediction","containerName":"next_result","line":190,"kind":12},{"name":"$prediction","containerName":"next_result","line":191,"kind":13},{"kind":13,"line":192,"name":"$self","containerName":"next_result"},{"line":192,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"wisetype","kind":12,"line":192},{"name":"$self","containerName":"next_result","kind":13,"line":193},{"line":193,"kind":12,"containerName":"next_result","name":"start_element"},{"kind":13,"line":194,"name":"$self","containerName":"next_result"},{"name":"element","containerName":"next_result","line":194,"kind":12},{"name":"$self","containerName":"next_result","line":195,"kind":13},{"line":195,"kind":12,"name":"wisetype","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":196,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":196},{"name":"$self","containerName":"next_result","kind":13,"line":197},{"containerName":"next_result","name":"wise","kind":12,"line":197},{"line":197,"kind":12,"name":"_prot_id","containerName":"next_result"},{"name":"@transcripts","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":198},{"kind":13,"line":198,"containerName":"next_result","name":"$prediction"},{"line":198,"kind":12,"containerName":"next_result","name":"transcripts"},{"line":200,"kind":13,"localvar":"my","name":"$transcript","definition":"my","containerName":"next_result"},{"kind":13,"line":200,"containerName":"next_result","name":"@transcripts"},{"line":201,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"@exons"},{"line":201,"kind":13,"containerName":"next_result","name":"$transcript"},{"line":201,"kind":12,"containerName":"next_result","name":"exons"},{"line":202,"kind":13,"localvar":"my","definition":"my","name":"$protid","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":203},{"kind":12,"line":203,"containerName":"next_result","name":"start_element"},{"line":205,"kind":13,"name":"$exons","containerName":"next_result"},{"containerName":"next_result","name":"has_tag","line":205,"kind":12},{"localvar":"my","name":"$supporting_feature","definition":"my","containerName":"next_result","line":206,"kind":13},{"line":206,"kind":13,"name":"$exons","containerName":"next_result"},{"kind":12,"line":206,"containerName":"next_result","name":"get_tag_values"},{"name":"$protid","containerName":"next_result","kind":13,"line":207},{"line":207,"kind":13,"containerName":"next_result","name":"$supporting_feature"},{"line":207,"kind":12,"name":"feature2","containerName":"next_result"},{"line":207,"kind":12,"containerName":"next_result","name":"seq_id"},{"name":"$self","containerName":"next_result","line":208,"kind":13},{"kind":12,"line":208,"name":"element","containerName":"next_result"},{"kind":13,"line":209,"name":"$self","containerName":"next_result"},{"kind":12,"line":209,"name":"wise","containerName":"next_result"},{"kind":12,"line":209,"name":"_target_id","containerName":"next_result"},{"kind":13,"line":211,"containerName":"next_result","name":"$self"},{"kind":12,"line":211,"containerName":"next_result","name":"element"},{"kind":13,"line":212,"name":"$self","containerName":"next_result"},{"kind":12,"line":212,"name":"wise","containerName":"next_result"},{"line":212,"kind":12,"containerName":"next_result","name":"_score"},{"definition":"my","name":"$exon","containerName":"next_result","localvar":"my","kind":13,"line":213},{"kind":13,"line":213,"containerName":"next_result","name":"@exons"},{"line":214,"kind":13,"name":"$self","containerName":"next_result"},{"name":"start_element","containerName":"next_result","kind":12,"line":214},{"containerName":"next_result","name":"$exon","line":215,"kind":13},{"name":"strand","containerName":"next_result","kind":12,"line":215},{"name":"$self","containerName":"next_result","kind":13,"line":216},{"containerName":"next_result","name":"element","kind":12,"line":216},{"line":217,"kind":13,"containerName":"next_result","name":"$exon"},{"name":"end","containerName":"next_result","line":217,"kind":12},{"containerName":"next_result","name":"$self","line":218,"kind":13},{"kind":12,"line":218,"containerName":"next_result","name":"element"},{"line":219,"kind":13,"containerName":"next_result","name":"$exon"},{"line":219,"kind":12,"name":"start","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":221},{"kind":12,"line":221,"containerName":"next_result","name":"element"},{"name":"$exon","containerName":"next_result","line":222,"kind":13},{"kind":12,"line":222,"containerName":"next_result","name":"start"},{"name":"$self","containerName":"next_result","kind":13,"line":223},{"line":223,"kind":12,"containerName":"next_result","name":"element"},{"line":224,"kind":13,"name":"$exon","containerName":"next_result"},{"line":224,"kind":12,"name":"end","containerName":"next_result"},{"kind":13,"line":226,"containerName":"next_result","name":"$self"},{"line":226,"kind":12,"name":"element","containerName":"next_result"},{"line":227,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":227,"name":"wise","containerName":"next_result"},{"containerName":"next_result","name":"_score","line":227,"kind":12},{"name":"$exon","containerName":"next_result","kind":13,"line":228},{"kind":12,"line":228,"name":"has_tag","containerName":"next_result"},{"name":"$sf","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":229},{"containerName":"next_result","name":"$exon","kind":13,"line":229},{"kind":12,"line":229,"containerName":"next_result","name":"get_tag_values"},{"kind":13,"line":230,"name":"$protein","definition":"my","containerName":"next_result","localvar":"my"},{"name":"$sf","containerName":"next_result","kind":13,"line":230},{"line":230,"kind":12,"containerName":"next_result","name":"feature2"},{"containerName":"next_result","name":"$protein","line":231,"kind":13},{"kind":12,"line":231,"containerName":"next_result","name":"strand"},{"containerName":"next_result","name":"$self","line":232,"kind":13},{"containerName":"next_result","name":"element","line":232,"kind":12},{"line":233,"kind":13,"name":"$protein","containerName":"next_result"},{"containerName":"next_result","name":"end","kind":12,"line":233},{"containerName":"next_result","name":"$self","line":234,"kind":13},{"name":"element","containerName":"next_result","line":234,"kind":12},{"containerName":"next_result","name":"$protein","kind":13,"line":235},{"containerName":"next_result","name":"start","line":235,"kind":12},{"line":237,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":237,"name":"element","containerName":"next_result"},{"kind":13,"line":238,"name":"$protein","containerName":"next_result"},{"kind":12,"line":238,"containerName":"next_result","name":"start"},{"containerName":"next_result","name":"$self","kind":13,"line":239},{"containerName":"next_result","name":"element","line":239,"kind":12},{"line":240,"kind":13,"containerName":"next_result","name":"$protein"},{"name":"end","containerName":"next_result","kind":12,"line":240},{"line":243,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":243,"name":"element","containerName":"next_result"},{"kind":13,"line":245,"containerName":"next_result","name":"$self"},{"kind":12,"line":245,"name":"element","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":247,"kind":13},{"containerName":"next_result","name":"end_element","kind":12,"line":247},{"containerName":"next_result","name":"$self","line":249,"kind":13},{"line":249,"kind":12,"containerName":"next_result","name":"end_element"},{"kind":13,"line":251,"name":"$self","containerName":"next_result"},{"name":"end_element","containerName":"next_result","line":251,"kind":12},{"containerName":"next_result","name":"$self","line":252,"kind":13},{"line":252,"kind":12,"name":"end_document","containerName":"next_result"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_result($self)","documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}]}},{"kind":12,"line":266,"children":[{"containerName":"start_element","name":"$self","definition":"my","localvar":"my","kind":13,"line":267},{"line":267,"kind":13,"containerName":"start_element","name":"$data"},{"line":269,"kind":13,"localvar":"my","name":"$nm","definition":"my","containerName":"start_element"},{"line":269,"kind":13,"name":"$data","containerName":"start_element"},{"line":270,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"start_element"},{"line":270,"kind":13,"name":"$MODEMAP","containerName":"start_element"},{"line":270,"kind":13,"containerName":"start_element","name":"$nm"},{"line":272,"kind":13,"name":"$type","containerName":"start_element"},{"name":"$self","containerName":"start_element","line":273,"kind":13},{"containerName":"start_element","name":"_eventHandler","line":273,"kind":12},{"name":"will_handle","containerName":"start_element","kind":12,"line":273},{"kind":13,"line":273,"name":"$type","containerName":"start_element"},{"line":274,"kind":13,"localvar":"my","containerName":"start_element","definition":"my","name":"$func"},{"name":"$type","containerName":"start_element","kind":13,"line":274},{"line":275,"kind":13,"containerName":"start_element","name":"$self"},{"line":275,"kind":12,"name":"_eventHandler","containerName":"start_element"},{"containerName":"start_element","name":"$func","line":275,"kind":13},{"containerName":"start_element","name":"$data","line":275,"kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":277},{"line":277,"kind":13,"name":"$type","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":279,"kind":13},{"kind":13,"line":280,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"$self","line":281,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","label":"start_element($self,$data)"},"name":"start_element","range":{"end":{"character":9999,"line":283},"start":{"line":266,"character":0}}},{"kind":12,"children":[{"containerName":"end_element","name":"$self","definition":"my","localvar":"my","kind":13,"line":299},{"line":299,"kind":13,"name":"$data","containerName":"end_element"},{"kind":13,"line":300,"containerName":"end_element","definition":"my","name":"$nm","localvar":"my"},{"name":"$data","containerName":"end_element","line":300,"kind":13},{"localvar":"my","name":"$type","definition":"my","containerName":"end_element","line":301,"kind":13},{"name":"$MODEMAP","containerName":"end_element","kind":13,"line":301},{"kind":13,"line":301,"containerName":"end_element","name":"$nm"},{"localvar":"my","name":"$rc","definition":"my","containerName":"end_element","line":302,"kind":13},{"line":304,"kind":13,"containerName":"end_element","name":"$type"},{"name":"$MODEMAP","containerName":"end_element","kind":13,"line":304},{"containerName":"end_element","name":"$nm","kind":13,"line":304},{"containerName":"end_element","name":"$self","kind":13,"line":305},{"kind":12,"line":305,"name":"_eventHandler","containerName":"end_element"},{"containerName":"end_element","name":"will_handle","kind":12,"line":305},{"containerName":"end_element","name":"$type","kind":13,"line":305},{"kind":13,"line":306,"containerName":"end_element","name":"$func","definition":"my","localvar":"my"},{"line":306,"kind":13,"name":"$type","containerName":"end_element"},{"kind":13,"line":307,"containerName":"end_element","name":"$rc"},{"containerName":"end_element","name":"$self","kind":13,"line":307},{"name":"_eventHandler","containerName":"end_element","kind":12,"line":307},{"line":307,"kind":13,"containerName":"end_element","name":"$func"},{"name":"$self","containerName":"end_element","line":307,"kind":13},{"kind":13,"line":308,"name":"$self","containerName":"end_element"},{"kind":13,"line":310,"name":"$self","containerName":"end_element"}],"line":298,"definition":"sub","containerName":"main::","signature":{"label":"end_element($self,$data)","documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","name":"end_element","range":{"end":{"line":312,"character":9999},"start":{"character":0,"line":298}}},{"kind":13,"line":312,"containerName":null,"name":"%MAPPING"},{"name":"%nm","containerName":null,"line":312,"kind":13},{"line":314,"kind":13,"name":"%MAPPING","containerName":null},{"line":314,"kind":13,"name":"%nm","containerName":null},{"containerName":null,"definition":"my","name":"$key","localvar":"my","kind":13,"line":315},{"kind":13,"line":315,"containerName":null,"name":"%MAPPING"},{"kind":13,"line":315,"containerName":null,"name":"@nm"},{"name":"%self","containerName":null,"kind":13,"line":316},{"line":316,"kind":13,"name":"%key","containerName":null},{"line":316,"kind":13,"containerName":null,"name":"%MAPPING"},{"name":"%nm","containerName":null,"line":316,"kind":13},{"name":"$key","containerName":null,"line":316,"kind":13},{"kind":13,"line":316,"name":"%self","containerName":null},{"line":318,"kind":13,"containerName":null,"name":"%self"},{"line":318,"kind":13,"name":"%MAPPING","containerName":null},{"containerName":null,"name":"$nm","kind":13,"line":318},{"kind":13,"line":318,"name":"%self","containerName":null},{"line":321,"kind":13,"name":"$self","containerName":null},{"name":"debug","containerName":"main::","kind":12,"line":321},{"name":"%self","containerName":null,"kind":13,"line":323},{"name":"%self","containerName":null,"line":325,"kind":13},{"name":"$rc","containerName":null,"line":325,"kind":13},{"name":"$type","containerName":null,"kind":13,"line":325},{"kind":13,"line":325,"containerName":null,"name":"$type"},{"containerName":null,"name":"$rc","kind":13,"line":326},{"kind":12,"line":340,"children":[{"line":341,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"element"},{"kind":13,"line":341,"containerName":"element","name":"$data"},{"containerName":"element","name":"$self","line":342,"kind":13},{"kind":12,"line":342,"containerName":"element","name":"start_element"},{"line":342,"kind":13,"containerName":"element","name":"$data"},{"kind":13,"line":343,"name":"$self","containerName":"element"},{"kind":12,"line":343,"containerName":"element","name":"characters"},{"line":343,"kind":13,"name":"$data","containerName":"element"},{"name":"$self","containerName":"element","kind":13,"line":344},{"name":"end_element","containerName":"element","line":344,"kind":12},{"kind":13,"line":344,"name":"$data","containerName":"element"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'"},"name":"element","range":{"start":{"line":340,"character":0},"end":{"line":345,"character":9999}}},{"detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"containerName":"main::","definition":"sub","line":358,"children":[{"containerName":"characters","name":"$self","definition":"my","localvar":"my","kind":13,"line":359},{"kind":13,"line":359,"name":"$data","containerName":"characters"},{"containerName":"characters","name":"$data","line":361,"kind":13},{"containerName":"characters","name":"$data","kind":13,"line":361},{"containerName":"characters","name":"$self","line":363,"kind":13},{"name":"$data","containerName":"characters","kind":13,"line":363}],"kind":12,"range":{"end":{"line":364,"character":9999},"start":{"character":0,"line":358}},"name":"characters"},{"definition":"sub","containerName":"main::","signature":{"label":"within_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name"},"detail":"($self,$name)","kind":12,"children":[{"containerName":"within_element","definition":"my","name":"$self","localvar":"my","kind":13,"line":380},{"containerName":"within_element","name":"$name","line":380,"kind":13},{"name":"$name","containerName":"within_element","kind":13,"line":381},{"name":"$self","containerName":"within_element","kind":13,"line":382},{"line":383,"kind":13,"containerName":"within_element","name":"$self"}],"line":379,"name":"within_element","range":{"end":{"character":9999,"line":383},"start":{"line":379,"character":0}}},{"name":"%self","containerName":null,"line":384,"kind":13},{"name":"%name","containerName":null,"kind":13,"line":385},{"detail":"($self,$name)","signature":{"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"containerName":"main::","definition":"sub","line":406,"children":[{"containerName":"in_element","name":"$self","definition":"my","localvar":"my","kind":13,"line":407},{"line":407,"kind":13,"name":"$name","containerName":"in_element"},{"containerName":"in_element","name":"$self","line":408,"kind":13},{"line":409,"kind":13,"name":"$self","containerName":"in_element"},{"name":"$name","containerName":"in_element","line":409,"kind":13}],"kind":12,"range":{"start":{"line":406,"character":0},"end":{"character":9999,"line":410}},"name":"in_element"},{"name":"start_document","range":{"end":{"line":430,"character":9999},"start":{"character":0,"line":423}},"definition":"sub","containerName":"main::","signature":{"label":"start_document($self)","documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"start_document","localvar":"my","kind":13,"line":424},{"line":425,"kind":13,"containerName":"start_document","name":"$self"},{"kind":13,"line":426,"containerName":"start_document","name":"$self"},{"line":427,"kind":13,"name":"$self","containerName":"start_document"},{"kind":13,"line":428,"containerName":"start_document","name":"$self"},{"containerName":"start_document","name":"$self","line":429,"kind":13}],"line":423},{"detail":"($self,@args)","signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: wise.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::wise\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::wise - Parsing of wise output as alignments\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file    => 'file.genewise', \n                                 -format  => 'wise',\n                                 -wisetype=> 'genewise');\n\n  while( my $result = $parser->next_result ) {}\n\n=head1 DESCRIPTION\n\nThis object parsers Wise output using Bio::Tools::Genewise or\nBio::Tools::Genomewise as a helper.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::wise;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::SearchIO);\n\n%MODEMAP = ('WiseOutput' => 'result',\n\t    'Hit'             => 'hit',\n\t    'Hsp'             => 'hsp'\n    );\n%MAPPING =\n    (\n     'Hsp_query-from'=>  'HSP-query_start',\n     'Hsp_query-to'  =>  'HSP-query_end',\n     'Hsp_hit-from'  =>  'HSP-hit_start',\n     'Hsp_hit-to'    =>  'HSP-hit_end',\n     'Hsp_qseq'      =>  'HSP-query_seq',\n     'Hsp_hseq'      =>  'HSP-hit_seq',\n     'Hsp_midline'   =>  'HSP-homology_seq',\n     'Hsp_score'     =>  'HSP-score',\n     'Hsp_qlength'   =>  'HSP-query_length',\n     'Hsp_hlength'   =>  'HSP-hit_length',\n     'Hsp_align-len' =>  'HSP-hsp_length',\n     'Hsp_positive'   => 'HSP-conserved',\n     'Hsp_identity'   => 'HSP-identical',\n     #'Hsp_gaps'       => 'HSP-hsp_gaps',\n     #'Hsp_hitgaps'    => 'HSP-hit_gaps',\n     #'Hsp_querygaps'  => 'HSP-query_gaps',\n     \n     'Hit_id'        => 'HIT-name',\n#    'Hit_desc'      => 'HIT-description',\n#    'Hit_len'       => 'HIT-length',\n     'Hit_score'     => 'HIT-score',\n\n     'WiseOutput_program'   => 'RESULT-algorithm_name',\n     'WiseOutput_query-def' => 'RESULT-query_name',\n     'WiseOutput_query-desc'=> 'RESULT-query_description',\n     'WiseOutput_query-len' => 'RESULT-query_length',\n    );\n\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n\nuse Bio::Tools::Genewise;\nuse Bio::Tools::Genomewise;\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::wise->new();\n Function: Builds a new Bio::SearchIO::wise object \n Returns : an instance of Bio::SearchIO::wise\n Args    : -wise => a Bio::Tools::Genewise or Bio::Tools::Genomewise object\n\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    my ( $wisetype, $file,$fh ) =\n\t$self->_rearrange([qw(WISETYPE FILE FH)], @args);\n    my @newargs;\n    while( @args ) {\n\tmy $a = shift @args;\n\tif( $a =~ /FILE|FH/i ) {\n\t    shift @args;\n\t    next;\n\t}\n\tpush @newargs, $a, shift @args;\n    }\n    $self->SUPER::_initialize(@newargs);\n\n    # Optimization: caching the EventHandler \n    # since it's use a lot during the parse.\n    $self->{'_handler_cache'} = $self->_eventHandler;\n\n    $self->wisetype($wisetype);\n    my @ioargs;\n    if( $fh ) { \n\tpush @ioargs, ('-fh' => $fh);\n    } elsif( $file ) {\n\tpush @ioargs, ('-file' => $file);\n    }\n\n    if( $wisetype =~ /genewise/i ) {\n\t$self->wise(Bio::Tools::Genewise->new(@ioargs));\n    } elsif( $wisetype =~ /genomewise/i ) {\n\t$self->wise(Bio::Tools::Genomewise->new(@ioargs));\n    } else { \n\t$self->throw(\"Must supply a -wisetype to \".ref($self).\" which is one of 'genomewise' 'genewise'\\n\");\n    }\n    return $self;\n}\n\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   local $/ = \"\\n\";\n   local $_;\n\n   return unless $self->wise;\n   my $prediction = $self->wise->next_prediction;\n   return unless $prediction;\n   $self->{'_reporttype'} = uc $self->wisetype;\n   $self->start_element({'Name' => 'WiseOutput'});\n   $self->element({'Name' => 'WiseOutput_program',\n\t\t   'Data' => $self->wisetype});\n   $self->element({'Name' => 'WiseOutput_query-def',\n\t\t   'Data' => $self->wise->_prot_id});\n   my @transcripts = $prediction->transcripts;\n\n   foreach my $transcript ( @transcripts ) {\n       my @exons =  $transcript->exons;\n       my $protid;\n       $self->start_element({'Name' => 'Hit'});\n       \n       if( $exons[0]->has_tag('supporting_feature') ) {\n\t   my ($supporting_feature) = $exons[0]->get_tag_values('supporting_feature');\n\t   $protid = $supporting_feature->feature2->seq_id;\n\t   $self->element({'Name' => 'Hit_id',\n\t\t\t   'Data' => $self->wise->_target_id});       \n       } \n       $self->element({'Name' => 'Hit_score',\n\t\t       'Data' => $self->wise->_score});\n       foreach my $exon ( @exons ) {\n\t   $self->start_element({'Name' => 'Hsp'});\n\t   if( $exon->strand < 0 ) { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->end});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->start});\n\t   } else { \n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $exon->start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $exon->end});\n\t   }\n\t   $self->element({'Name' => 'Hsp_score',\n\t\t\t   'Data' => $self->wise->_score});\n\t   if( $exon->has_tag('supporting_feature') ) {\n\t       my ($sf) = $exon->get_tag_values('supporting_feature');\n\t       my $protein = $sf->feature2;\n\t       if( $protein->strand < 0 ) {\n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->end});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->start});\n\t       } else { \n\t\t   $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t\t   'Data' => $protein->start});\n\t\t   $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t\t   'Data' => $protein->end});\n\t       }\n\t   }\n\t   $self->element({'Name' => 'Hsp_identity',\n\t\t\t   'Data' => 0});\n\t   $self->element({'Name' => 'Hsp_positive',\n\t\t\t   'Data' => 0});\n\t   $self->end_element({'Name' => 'Hsp'});\n       }\n       $self->end_element({'Name' => 'Hit'});\n   }\n   $self->end_element({'Name' => 'WiseOutput'});\n   return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n   # we currently don't care about attributes\n   my $nm = $data->{'Name'};\n   my $type = $MODEMAP{$nm};\n\n   if( $type ) {\n       if( $self->_eventHandler->will_handle($type) ) {\n\t   my $func = sprintf(\"start_%s\",lc $type);\n\t   $self->_eventHandler->$func($data->{'Attributes'});\n       }\n       unshift @{$self->{'_elements'}}, $type;\n\n       if($type eq 'result') {\n\t   $self->{'_values'} = {};\n\t   $self->{'_result'}= undef;\n       }\n   }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if( $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->debug( \"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n\n   return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/ );\n\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_elements'} = [];\n    $self->{'_reporttype'} = 'exonerate';\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"containerName":"main::","definition":"sub","line":444,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_document","line":445,"kind":13},{"kind":13,"line":445,"name":"@args","containerName":"end_document"},{"line":446,"kind":13,"name":"$self","containerName":"end_document"}],"kind":12,"range":{"start":{"line":444,"character":0},"end":{"character":9999,"line":447}},"name":"end_document"},{"range":{"start":{"line":450,"character":0},"end":{"character":9999,"line":458}},"name":"write_result","detail":"($self,$blast,@args)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$blast"},{"label":"@args"}],"label":"write_result($self,$blast,@args)"},"containerName":"main::","definition":"sub","line":450,"children":[{"name":"$self","definition":"my","containerName":"write_result","localvar":"my","kind":13,"line":451},{"containerName":"write_result","name":"$blast","line":451,"kind":13},{"kind":13,"line":451,"name":"@args","containerName":"write_result"},{"containerName":"write_result","name":"$self","kind":13,"line":453},{"name":"writer","containerName":"write_result","line":453,"kind":12},{"line":454,"kind":13,"name":"$self","containerName":"write_result"},{"name":"warn","containerName":"write_result","kind":12,"line":454},{"kind":13,"line":455,"name":"$self","containerName":"write_result"},{"line":455,"kind":12,"name":"writer","containerName":"write_result"},{"line":455,"kind":13,"containerName":"write_result","name":"$DEFAULT_WRITER_CLASS"},{"containerName":"write_result","name":"new","kind":12,"line":455},{"name":"$self","containerName":"write_result","line":457,"kind":13},{"line":457,"kind":13,"name":"$blast","containerName":"write_result"},{"line":457,"kind":13,"name":"@args","containerName":"write_result"}],"kind":12},{"line":457,"kind":12,"containerName":"write_result","name":"SUPER"},{"line":460,"children":[{"localvar":"my","containerName":"result_count","definition":"my","name":"$self","line":461,"kind":13},{"line":462,"kind":13,"containerName":"result_count","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":460},"end":{"line":463,"character":9999}},"containerName":"main::","definition":"sub","name":"result_count"},{"line":465,"children":[{"containerName":"report_count","name":"result_count","line":465,"kind":12}],"kind":12,"range":{"start":{"line":465,"character":0},"end":{"line":465,"character":9999}},"containerName":"main::","definition":"sub","name":"report_count"},{"line":479,"children":[{"localvar":"my","containerName":"wise","definition":"my","name":"$self","line":480,"kind":13},{"line":481,"kind":13,"name":"$self","containerName":"wise"},{"name":"$self","containerName":"wise","line":482,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":479},"end":{"character":9999,"line":483}},"containerName":"main::","definition":"sub","name":"wise"},{"children":[{"line":497,"kind":13,"localvar":"my","containerName":"wisetype","definition":"my","name":"$self"},{"line":499,"kind":13,"name":"$self","containerName":"wisetype"},{"line":500,"kind":13,"name":"$self","containerName":"wisetype"}],"line":496,"kind":12,"range":{"end":{"line":501,"character":9999},"start":{"line":496,"character":0}},"definition":"sub","name":"wisetype","containerName":"main::"}]}