{"version":5,"vars":[{"name":"base","containerName":"","line":75,"kind":2},{"kind":13,"line":77,"containerName":null,"definition":"my","name":"%MODEMAP","localvar":"my"},{"line":83,"kind":13,"localvar":"my","definition":"my","name":"%MAPPING","containerName":null},{"containerName":null,"definition":"my","name":"@VALID_SYMBOLS","localvar":"my","kind":13,"line":125},{"localvar":"my","name":"%STRUCTURE_SYMBOLS","definition":"my","containerName":null,"line":126,"kind":13},{"name":"$DEFAULT_VERSION","definition":"my","containerName":null,"localvar":"my","kind":13,"line":134},{"kind":12,"children":[{"line":155,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$self"},{"name":"@args","containerName":"_initialize","line":155,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":156},{"name":"@args","containerName":"_initialize","kind":13,"line":156},{"definition":"my","name":"$version","containerName":"_initialize","localvar":"my","kind":13,"line":157},{"name":"$model","containerName":"_initialize","line":157,"kind":13},{"line":157,"kind":13,"name":"$database","containerName":"_initialize"},{"line":157,"kind":13,"name":"$maxcutoff","containerName":"_initialize"},{"kind":13,"line":157,"name":"$mincutoff","containerName":"_initialize"},{"containerName":"_initialize","name":"$seqdistance","line":157,"kind":13},{"line":158,"kind":13,"containerName":"_initialize","name":"$accession"},{"line":158,"kind":13,"containerName":"_initialize","name":"$symbols"},{"name":"$self","containerName":"_initialize","kind":13,"line":159},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":159},{"name":"@args","containerName":"_initialize","line":160,"kind":13},{"localvar":"my","containerName":"_initialize","name":"$handler","definition":"my","line":161,"kind":13},{"name":"$self","containerName":"_initialize","line":161,"kind":13},{"kind":12,"line":161,"containerName":"_initialize","name":"_eventHandler"},{"line":162,"kind":13,"containerName":"_initialize","name":"$handler"},{"name":"register_factory","containerName":"_initialize","line":162,"kind":12},{"containerName":"_initialize","name":"new","kind":12,"line":164},{"line":167,"kind":13,"name":"$self","containerName":"_initialize"},{"line":168,"kind":12,"name":"verbose","containerName":"_initialize"},{"name":"$handler","containerName":"_initialize","kind":13,"line":171},{"line":171,"kind":12,"containerName":"_initialize","name":"register_factory"},{"kind":12,"line":173,"name":"new","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":176,"kind":13},{"line":177,"kind":12,"name":"verbose","containerName":"_initialize"},{"containerName":"_initialize","name":"$handler","line":180,"kind":13},{"kind":12,"line":180,"containerName":"_initialize","name":"register_factory"},{"containerName":"_initialize","name":"new","kind":12,"line":182},{"kind":13,"line":185,"containerName":"_initialize","name":"$self"},{"kind":12,"line":186,"name":"verbose","containerName":"_initialize"},{"line":188,"kind":13,"containerName":"_initialize","name":"$model"},{"containerName":"_initialize","name":"$self","line":188,"kind":13},{"kind":12,"line":188,"containerName":"_initialize","name":"model"},{"kind":13,"line":188,"name":"$model","containerName":"_initialize"},{"containerName":"_initialize","name":"$database","kind":13,"line":189},{"name":"$self","containerName":"_initialize","line":189,"kind":13},{"line":189,"kind":12,"name":"database","containerName":"_initialize"},{"containerName":"_initialize","name":"$database","line":189,"kind":13},{"name":"$accession","containerName":"_initialize","line":190,"kind":13},{"line":190,"kind":13,"name":"$self","containerName":"_initialize"},{"line":190,"kind":12,"containerName":"_initialize","name":"query_accession"},{"kind":13,"line":190,"name":"$accession","containerName":"_initialize"},{"kind":13,"line":191,"name":"$version","containerName":"_initialize"},{"name":"$DEFAULT_VERSION","containerName":"_initialize","kind":13,"line":191},{"kind":13,"line":192,"containerName":"_initialize","name":"$self"},{"line":192,"kind":12,"containerName":"_initialize","name":"algorithm_version"},{"line":192,"kind":13,"name":"$version","containerName":"_initialize"},{"line":193,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":12,"line":193,"name":"throw","containerName":"_initialize"},{"line":194,"kind":13,"containerName":"_initialize","name":"$mincutoff"},{"name":"$maxcutoff","containerName":"_initialize","kind":13,"line":194},{"line":195,"kind":13,"name":"$mincutoff","containerName":"_initialize"},{"kind":13,"line":195,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"hsp_minscore","line":195,"kind":12},{"kind":13,"line":195,"containerName":"_initialize","name":"$mincutoff"},{"containerName":"_initialize","name":"$maxcutoff","kind":13,"line":196},{"name":"$self","containerName":"_initialize","kind":13,"line":196},{"kind":12,"line":196,"name":"hsp_maxscore","containerName":"_initialize"},{"name":"$maxcutoff","containerName":"_initialize","line":196,"kind":13},{"name":"$symbols","containerName":"_initialize","line":197,"kind":13},{"containerName":"_initialize","name":"%STRUCTURE_SYMBOLS","line":197,"kind":13},{"line":198,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"structure_symbols","kind":12,"line":198},{"name":"$symbols","containerName":"_initialize","kind":13,"line":198}],"line":154,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"detail":"($self,@args)","name":"_initialize","range":{"end":{"line":199,"character":9999},"start":{"line":154,"character":0}}},{"name":"SUPER","containerName":"_initialize","line":156,"kind":12},{"line":164,"kind":12,"name":"Bio","containerName":"Factory::ObjectFactory"},{"line":173,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"containerName":"Factory::ObjectFactory","name":"Bio","line":182,"kind":12},{"range":{"end":{"line":375,"character":9999},"start":{"character":0,"line":211}},"name":"next_result","line":211,"children":[{"kind":13,"line":212,"definition":"my","name":"$self","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$seentop","definition":"my","localvar":"my","kind":13,"line":213},{"line":216,"kind":13,"localvar":"my","containerName":"next_result","name":"$rm","definition":"my"},{"name":"$d","containerName":"next_result","line":216,"kind":13},{"name":"$descriptor","containerName":"next_result","line":216,"kind":13},{"line":216,"kind":13,"name":"$file","containerName":"next_result"},{"name":"$oktobuild","containerName":"next_result","kind":13,"line":216},{"localvar":"my","definition":"my","name":"$hitid","containerName":"next_result","line":217,"kind":13},{"kind":13,"line":217,"name":"$hitdesc","containerName":"next_result"},{"name":"$hspid","containerName":"next_result","kind":13,"line":217},{"containerName":"next_result","name":"$lastid","line":217,"kind":13},{"kind":13,"line":217,"name":"$lastscore","containerName":"next_result"},{"kind":13,"line":218,"containerName":"next_result","definition":"my","name":"$sprintf","localvar":"my"},{"line":221,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$accession"},{"kind":13,"line":221,"containerName":"next_result","name":"$db"},{"line":221,"kind":13,"containerName":"next_result","name":"$model"},{"name":"$self","containerName":"next_result","line":222,"kind":13},{"kind":12,"line":222,"containerName":"next_result","name":"query_accession"},{"line":222,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":222,"containerName":"next_result","name":"database"},{"line":222,"kind":13,"name":"$self","containerName":"next_result"},{"line":222,"kind":12,"name":"model","containerName":"next_result"},{"containerName":"next_result","name":"$hsp_min","definition":"my","localvar":"my","kind":13,"line":224},{"line":224,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":224,"name":"hsp_minscore","containerName":"next_result"},{"localvar":"my","definition":"my","name":"$hsp_max","containerName":"next_result","line":225,"kind":13},{"kind":13,"line":225,"name":"$self","containerName":"next_result"},{"kind":12,"line":225,"name":"hsp_maxscore","containerName":"next_result"},{"kind":13,"line":226,"name":"$version","definition":"my","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$self","kind":13,"line":226},{"name":"algorithm_version","containerName":"next_result","kind":12,"line":226},{"kind":13,"line":227,"definition":"my","name":"$laststart","containerName":"next_result","localvar":"my"},{"kind":13,"line":229,"name":"$verbose","definition":"my","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$self","kind":13,"line":229},{"line":229,"kind":12,"containerName":"next_result","name":"verbose"},{"kind":13,"line":230,"containerName":"next_result","name":"$self"},{"kind":12,"line":230,"containerName":"next_result","name":"start_document"},{"line":232,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$line"},{"kind":13,"line":232,"name":"$self","containerName":"next_result"},{"name":"_readline","containerName":"next_result","kind":12,"line":232},{"name":"$line","containerName":"next_result","kind":13,"line":234},{"containerName":"next_result","name":"$line","line":235,"kind":13},{"kind":13,"line":236,"containerName":"next_result","name":"$line"},{"containerName":"next_result","name":"$seentop","line":237,"kind":13},{"kind":13,"line":238,"containerName":"next_result","name":"$self"},{"kind":12,"line":238,"containerName":"next_result","name":"_pushback"},{"name":"$line","containerName":"next_result","kind":13,"line":238},{"line":241,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"line":241,"name":"start_element","containerName":"next_result"},{"line":242,"kind":13,"name":"$self","containerName":"next_result"},{"name":"element_hash","containerName":"next_result","line":242,"kind":12},{"containerName":"next_result","name":"$version","line":244,"kind":13},{"line":245,"kind":13,"name":"$accession","containerName":"next_result"},{"name":"$db","containerName":"next_result","kind":13,"line":247},{"kind":13,"line":248,"containerName":"next_result","name":"$seentop"},{"line":250,"kind":13,"containerName":"next_result","name":"$line"},{"line":251,"kind":13,"containerName":"next_result","name":"$rm"},{"name":"$d","containerName":"next_result","kind":13,"line":251},{"line":251,"kind":13,"containerName":"next_result","name":"$descriptor"},{"name":"$line","containerName":"next_result","line":251,"kind":13},{"containerName":"next_result","name":"$descriptor","line":253,"kind":13},{"line":254,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"$descriptor","line":254,"kind":13},{"name":"$self","containerName":"next_result","line":255,"kind":13},{"name":"element","containerName":"next_result","line":255,"kind":12},{"containerName":"next_result","name":"$descriptor","kind":13,"line":257},{"containerName":"next_result","name":"$line","kind":13,"line":259},{"line":260,"kind":13,"containerName":"next_result","name":"$rm"},{"containerName":"next_result","name":"$d","line":260,"kind":13},{"name":"$file","containerName":"next_result","kind":13,"line":260},{"name":"$line","containerName":"next_result","kind":13,"line":260},{"line":262,"kind":13,"name":"$file","containerName":"next_result"},{"line":263,"kind":13,"name":"$self","containerName":"next_result"},{"line":263,"kind":12,"containerName":"next_result","name":"element"},{"name":"$file","containerName":"next_result","kind":13,"line":265},{"containerName":"next_result","name":"$self","line":268,"kind":13},{"name":"debug","containerName":"next_result","line":268,"kind":12},{"name":"$line","containerName":"next_result","kind":13,"line":270},{"kind":13,"line":271,"containerName":"next_result","name":"$line"},{"kind":13,"line":272,"containerName":"next_result","name":"$hitid"},{"containerName":"next_result","name":"$hitdesc","line":272,"kind":13},{"containerName":"next_result","name":"$line","kind":13,"line":272},{"kind":13,"line":274,"containerName":"next_result","name":"$self"},{"kind":12,"line":274,"containerName":"next_result","name":"within_element"},{"line":274,"kind":13,"name":"$hitid","containerName":"next_result"},{"name":"$lastid","containerName":"next_result","kind":13,"line":274},{"name":"$self","containerName":"next_result","line":275,"kind":13},{"containerName":"next_result","name":"element","kind":12,"line":275},{"containerName":"next_result","name":"$lastscore","line":277,"kind":13},{"name":"$lastscore","containerName":"next_result","kind":13,"line":278},{"line":279,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":279,"name":"end_element","containerName":"next_result"},{"kind":13,"line":280,"name":"$self","containerName":"next_result"},{"kind":12,"line":280,"containerName":"next_result","name":"start_element"},{"containerName":"next_result","name":"$self","line":281,"kind":13},{"kind":12,"line":281,"containerName":"next_result","name":"within_element"},{"containerName":"next_result","name":"$self","line":282,"kind":13},{"containerName":"next_result","name":"start_element","line":282,"kind":12},{"localvar":"my","containerName":"next_result","name":"$gi","definition":"my","line":284,"kind":13},{"containerName":"next_result","name":"$acc","line":284,"kind":13},{"kind":13,"line":284,"containerName":"next_result","name":"$ver"},{"name":"$self","containerName":"next_result","line":284,"kind":13},{"containerName":"next_result","name":"_get_seq_identifiers","line":284,"kind":12},{"kind":13,"line":284,"containerName":"next_result","name":"$hitid"},{"line":286,"kind":13,"name":"$self","containerName":"next_result"},{"line":286,"kind":12,"name":"element_hash","containerName":"next_result"},{"line":287,"kind":13,"name":"$hitid","containerName":"next_result"},{"kind":13,"line":288,"name":"$gi","containerName":"next_result"},{"name":"$ver","containerName":"next_result","line":289,"kind":13},{"line":290,"kind":13,"name":"$acc","containerName":"next_result"},{"containerName":"next_result","name":"$acc","line":290,"kind":13},{"containerName":"next_result","name":"$hitid","kind":13,"line":290},{"kind":13,"line":291,"containerName":"next_result","name":"$hitdesc"},{"kind":13,"line":293,"containerName":"next_result","name":"$lastid"},{"line":293,"kind":13,"containerName":"next_result","name":"$hitid"},{"kind":13,"line":294,"name":"$line","containerName":"next_result"},{"containerName":"next_result","name":"$line","kind":13,"line":295},{"line":296,"kind":13,"localvar":"my","name":"$hspid","definition":"my","containerName":"next_result"},{"line":297,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$score"},{"kind":13,"line":297,"containerName":"next_result","name":"$strand"},{"name":"$start","containerName":"next_result","line":297,"kind":13},{"kind":13,"line":297,"containerName":"next_result","name":"$length"},{"kind":13,"line":297,"name":"$seq","containerName":"next_result"},{"line":298,"kind":13,"containerName":"next_result","name":"$score"},{"containerName":"next_result","name":"$hitid","line":300,"kind":13},{"line":300,"kind":13,"name":"$hspid","containerName":"next_result"},{"line":301,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"throw","kind":12,"line":301},{"kind":13,"line":304,"containerName":"next_result","name":"$sprintf"},{"name":"$score","containerName":"next_result","kind":13,"line":305},{"line":306,"kind":13,"containerName":"next_result","name":"$hsp_min"},{"name":"$hsp_max","containerName":"next_result","line":306,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":307},{"kind":12,"line":307,"containerName":"next_result","name":"warn"},{"containerName":"next_result","name":"$sprintf","line":310,"kind":13},{"line":310,"kind":13,"name":"$oktobuild","containerName":"next_result"},{"name":"$sprintf","containerName":"next_result","kind":13,"line":312},{"line":316,"kind":13,"name":"$sprintf","containerName":"next_result"},{"line":317,"kind":13,"containerName":"next_result","name":"$hsp_min"},{"name":"$score","containerName":"next_result","kind":13,"line":317},{"line":317,"kind":13,"name":"$hsp_min","containerName":"next_result"},{"containerName":"next_result","name":"$hsp_max","line":318,"kind":13},{"name":"$score","containerName":"next_result","kind":13,"line":318},{"name":"$hsp_max","containerName":"next_result","kind":13,"line":318},{"line":320,"kind":13,"name":"$oktobuild","containerName":"next_result"},{"line":322,"kind":13,"name":"$oktobuild","containerName":"next_result"},{"name":"$hsp_min","containerName":"next_result","kind":13,"line":325},{"name":"$score","containerName":"next_result","kind":13,"line":325},{"containerName":"next_result","name":"$hsp_min","kind":13,"line":325},{"line":326,"kind":13,"containerName":"next_result","name":"$lastscore"},{"line":326,"kind":13,"containerName":"next_result","name":"$score"},{"kind":13,"line":326,"containerName":"next_result","name":"$lastscore"},{"containerName":"next_result","name":"$score","kind":13,"line":326},{"line":326,"kind":13,"name":"$lastscore","containerName":"next_result"},{"name":"$hsp_max","containerName":"next_result","line":327,"kind":13},{"line":327,"kind":13,"containerName":"next_result","name":"$score"},{"containerName":"next_result","name":"$hsp_max","line":327,"kind":13},{"line":328,"kind":13,"name":"$lastscore","containerName":"next_result"},{"containerName":"next_result","name":"$score","line":328,"kind":13},{"kind":13,"line":328,"name":"$lastscore","containerName":"next_result"},{"line":328,"kind":13,"containerName":"next_result","name":"$score"},{"line":328,"kind":13,"containerName":"next_result","name":"$lastscore"},{"containerName":"next_result","name":"$oktobuild","kind":13,"line":334},{"localvar":"my","containerName":"next_result","definition":"my","name":"$end","line":335,"kind":13},{"line":337,"kind":13,"name":"$strand","containerName":"next_result"},{"line":338,"kind":13,"name":"$end","containerName":"next_result"},{"containerName":"next_result","name":"$start","kind":13,"line":338},{"containerName":"next_result","name":"$length","kind":13,"line":338},{"line":340,"kind":13,"name":"$end","containerName":"next_result"},{"line":340,"kind":13,"name":"$start","containerName":"next_result"},{"name":"$length","containerName":"next_result","kind":13,"line":340},{"kind":13,"line":343,"containerName":"next_result","definition":"my","name":"$rna","localvar":"my"},{"name":"$meta","containerName":"next_result","kind":13,"line":343},{"containerName":"next_result","name":"$self","line":343,"kind":13},{"kind":12,"line":343,"name":"_motif2meta","containerName":"next_result"},{"kind":13,"line":343,"containerName":"next_result","name":"$seq"},{"containerName":"next_result","name":"$descriptor","line":343,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":345},{"line":345,"kind":12,"name":"start_element","containerName":"next_result"},{"line":346,"kind":13,"localvar":"my","name":"$rnalen","definition":"my","containerName":"next_result"},{"kind":13,"line":346,"name":"$rna","containerName":"next_result"},{"kind":13,"line":347,"containerName":"next_result","name":"$self"},{"line":347,"kind":12,"containerName":"next_result","name":"element_hash"},{"containerName":"next_result","name":"$rna","kind":13,"line":349},{"containerName":"next_result","name":"$rna","line":351,"kind":13},{"name":"$start","containerName":"next_result","kind":13,"line":352},{"containerName":"next_result","name":"$end","kind":13,"line":353},{"name":"$meta","containerName":"next_result","kind":13,"line":354},{"containerName":"next_result","name":"$rna","kind":13,"line":355},{"containerName":"next_result","name":"$sprintf","kind":13,"line":356},{"containerName":"next_result","name":"$score","line":356,"kind":13},{"line":357,"kind":13,"containerName":"next_result","name":"$sprintf"},{"kind":13,"line":357,"name":"$score","containerName":"next_result"},{"line":359,"kind":13,"name":"$self","containerName":"next_result"},{"line":359,"kind":12,"containerName":"next_result","name":"end_element"},{"name":"$oktobuild","containerName":"next_result","line":360,"kind":13},{"containerName":"next_result","name":"$sprintf","kind":13,"line":360},{"containerName":"next_result","name":"$self","line":364,"kind":13},{"kind":12,"line":364,"containerName":"next_result","name":"within_element"},{"line":365,"kind":13,"containerName":"next_result","name":"$self"},{"line":365,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$lastscore","line":367,"kind":13},{"kind":13,"line":368,"name":"$lastscore","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":369,"kind":13},{"name":"end_element","containerName":"next_result","kind":12,"line":369},{"kind":13,"line":371,"containerName":"next_result","name":"$seentop"},{"line":372,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":372,"containerName":"next_result","name":"end_element"},{"line":374,"kind":13,"containerName":"next_result","name":"$self"},{"name":"end_document","containerName":"next_result","line":374,"kind":12}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"next_result($self)"},"containerName":"main::","definition":"sub"},{"name":"PARSER","line":231,"kind":12},{"name":"PARSER","line":239,"kind":12},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start_element","line":389,"kind":13},{"name":"$data","containerName":"start_element","kind":13,"line":389},{"name":"$nm","definition":"my","containerName":"start_element","localvar":"my","kind":13,"line":392},{"name":"$data","containerName":"start_element","line":392,"kind":13},{"containerName":"start_element","definition":"my","name":"$type","localvar":"my","kind":13,"line":393},{"name":"$MODEMAP","containerName":"start_element","line":393,"kind":13},{"kind":13,"line":393,"containerName":"start_element","name":"$nm"},{"containerName":"start_element","name":"$type","line":394,"kind":13},{"containerName":"start_element","name":"$self","kind":13,"line":395},{"name":"_eventHandler","containerName":"start_element","line":395,"kind":12},{"line":395,"kind":12,"name":"will_handle","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":395,"kind":13},{"line":396,"kind":13,"localvar":"my","name":"$func","definition":"my","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":396,"kind":13},{"name":"$self","containerName":"start_element","line":397,"kind":13},{"line":397,"kind":12,"name":"_eventHandler","containerName":"start_element"},{"containerName":"start_element","name":"$func","line":397,"kind":13},{"line":397,"kind":13,"containerName":"start_element","name":"$data"},{"name":"$self","containerName":"start_element","kind":13,"line":399},{"kind":13,"line":399,"name":"$type","containerName":"start_element"}],"line":388,"kind":12,"signature":{"label":"start_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"detail":"($self,$data)","definition":"sub","containerName":"main::","range":{"start":{"line":388,"character":0},"end":{"line":400,"character":9999}},"name":"start_element"},{"kind":13,"line":402,"name":"$type","containerName":null},{"line":402,"kind":13,"containerName":null,"name":"%type"},{"kind":13,"line":404,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","line":405,"kind":13},{"kind":12,"line":420,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_element","line":421,"kind":13},{"containerName":"end_element","name":"$data","line":421,"kind":13},{"line":422,"kind":13,"localvar":"my","containerName":"end_element","definition":"my","name":"$nm"},{"line":422,"kind":13,"containerName":"end_element","name":"$data"},{"kind":13,"line":423,"definition":"my","name":"$type","containerName":"end_element","localvar":"my"},{"name":"$MODEMAP","containerName":"end_element","line":423,"kind":13},{"kind":13,"line":423,"name":"$nm","containerName":"end_element"},{"kind":13,"line":424,"definition":"my","name":"$rc","containerName":"end_element","localvar":"my"},{"name":"$type","containerName":"end_element","kind":13,"line":426},{"name":"$self","containerName":"end_element","kind":13,"line":427},{"name":"_eventHandler","containerName":"end_element","kind":12,"line":427},{"kind":12,"line":427,"name":"will_handle","containerName":"end_element"},{"containerName":"end_element","name":"$type","kind":13,"line":427},{"line":428,"kind":13,"localvar":"my","containerName":"end_element","name":"$func","definition":"my"},{"kind":13,"line":428,"containerName":"end_element","name":"$type"},{"line":429,"kind":13,"containerName":"end_element","name":"$rc"},{"kind":13,"line":429,"containerName":"end_element","name":"$self"},{"containerName":"end_element","name":"_eventHandler","kind":12,"line":429},{"line":429,"kind":13,"name":"$func","containerName":"end_element"},{"kind":13,"line":429,"containerName":"end_element","name":"$self"},{"name":"$self","containerName":"end_element","kind":13,"line":430},{"kind":13,"line":432,"definition":"my","name":"$lastelem","containerName":"end_element","localvar":"my"},{"name":"$self","containerName":"end_element","line":432,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"end_element($self,$data)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}]},"name":"end_element","range":{"end":{"character":9999,"line":433},"start":{"character":0,"line":420}}},{"containerName":null,"name":"%MAPPING","line":434,"kind":13},{"name":"%nm","containerName":null,"line":434,"kind":13},{"kind":13,"line":435,"name":"%MAPPING","containerName":null},{"line":435,"kind":13,"containerName":null,"name":"%nm"},{"line":436,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":null},{"kind":13,"line":436,"name":"%MAPPING","containerName":null},{"line":436,"kind":13,"containerName":null,"name":"@nm"},{"containerName":null,"name":"%self","line":437,"kind":13},{"line":437,"kind":13,"containerName":null,"name":"%key"},{"containerName":null,"name":"%MAPPING","line":437,"kind":13},{"line":437,"kind":13,"name":"%nm","containerName":null},{"kind":13,"line":437,"containerName":null,"name":"$key"},{"name":"%self","containerName":null,"kind":13,"line":438},{"containerName":null,"name":"%self","kind":13,"line":441},{"containerName":null,"name":"%MAPPING","line":441,"kind":13},{"containerName":null,"name":"$nm","line":441,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":441},{"line":445,"kind":13,"containerName":null,"name":"$self"},{"line":445,"kind":12,"containerName":"main::","name":"debug"},{"name":"%self","containerName":null,"line":447,"kind":13},{"name":"%self","containerName":null,"line":449,"kind":13},{"containerName":null,"name":"$rc","line":449,"kind":13},{"name":"$type","containerName":null,"kind":13,"line":449},{"containerName":null,"name":"$type","line":449,"kind":13},{"line":450,"kind":13,"containerName":null,"name":"$rc"},{"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"kind":12,"line":464,"children":[{"containerName":"element","name":"$self","definition":"my","localvar":"my","kind":13,"line":465},{"containerName":"element","name":"$data","line":465,"kind":13},{"line":467,"kind":13,"containerName":"element","name":"$self"},{"kind":12,"line":467,"name":"characters","containerName":"element"},{"name":"$data","containerName":"element","kind":13,"line":467},{"name":"$self","containerName":"element","kind":13,"line":468},{"line":468,"kind":12,"name":"end_element","containerName":"element"},{"containerName":"element","name":"$data","kind":13,"line":468}],"name":"element","range":{"start":{"character":0,"line":464},"end":{"line":469,"character":9999}}},{"range":{"end":{"line":488,"character":9999},"start":{"character":0,"line":485}},"name":"element_hash","detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element_hash($self,$data)"},"containerName":"main::","definition":"sub","line":485,"children":[{"kind":13,"line":486,"containerName":"element_hash","definition":"my","name":"$self","localvar":"my"},{"name":"$data","containerName":"element_hash","kind":13,"line":486},{"name":"$self","containerName":"element_hash","line":487,"kind":13},{"kind":12,"line":487,"name":"throw","containerName":"element_hash"},{"containerName":"element_hash","name":"$data","kind":13,"line":487},{"name":"$data","containerName":"element_hash","line":487,"kind":13},{"containerName":"element_hash","definition":"my","name":"$nm","localvar":"my","kind":13,"line":488},{"line":488,"kind":13,"containerName":"element_hash","name":"$data"}],"kind":12},{"line":489,"kind":13,"name":"%data","containerName":null},{"containerName":null,"name":"$nm","line":489,"kind":13},{"containerName":null,"name":"%data","kind":13,"line":489},{"containerName":null,"name":"$nm","kind":13,"line":489},{"line":490,"kind":13,"name":"%MAPPING","containerName":null},{"line":490,"kind":13,"containerName":null,"name":"%nm"},{"containerName":null,"name":"%MAPPING","line":491,"kind":13},{"name":"%nm","containerName":null,"kind":13,"line":491},{"line":492,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":null},{"kind":13,"line":492,"name":"%MAPPING","containerName":null},{"line":492,"kind":13,"containerName":null,"name":"@nm"},{"containerName":null,"name":"%self","kind":13,"line":493},{"name":"%key","containerName":null,"line":493,"kind":13},{"name":"%MAPPING","containerName":null,"kind":13,"line":493},{"line":493,"kind":13,"name":"%nm","containerName":null},{"line":493,"kind":13,"containerName":null,"name":"$key"},{"containerName":null,"name":"%data","line":494,"kind":13},{"kind":13,"line":494,"containerName":null,"name":"%nm"},{"name":"%self","containerName":null,"kind":13,"line":497},{"name":"%MAPPING","containerName":null,"kind":13,"line":497},{"kind":13,"line":497,"name":"$nm","containerName":null},{"line":497,"kind":13,"containerName":null,"name":"%data"},{"name":"$nm","containerName":null,"kind":13,"line":497},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"characters","localvar":"my","kind":13,"line":515},{"containerName":"characters","name":"$data","line":515,"kind":13},{"kind":13,"line":516,"name":"$data","containerName":"characters"},{"kind":13,"line":516,"name":"$data","containerName":"characters"},{"name":"$self","containerName":"characters","line":517,"kind":13},{"line":517,"kind":13,"name":"$data","containerName":"characters"}],"line":514,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"detail":"($self,$data)","name":"characters","range":{"end":{"line":518,"character":9999},"start":{"character":0,"line":514}}},{"name":"within_element","range":{"end":{"line":537,"character":9999},"start":{"line":532,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"within_element($self,$name)"},"detail":"($self,$name)","kind":12,"children":[{"kind":13,"line":533,"containerName":"within_element","name":"$self","definition":"my","localvar":"my"},{"containerName":"within_element","name":"$name","kind":13,"line":533},{"kind":13,"line":536,"name":"$name","containerName":"within_element"},{"containerName":"within_element","name":"$self","kind":13,"line":536},{"line":537,"kind":13,"containerName":"within_element","name":"$self"}],"line":532},{"line":538,"kind":13,"containerName":null,"name":"%self"},{"name":"$name","containerName":null,"line":539,"kind":13},{"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}],"label":"in_element($self,$name)"},"kind":12,"line":556,"children":[{"localvar":"my","containerName":"in_element","definition":"my","name":"$self","line":557,"kind":13},{"name":"$name","containerName":"in_element","kind":13,"line":557},{"containerName":"in_element","name":"$self","kind":13,"line":558},{"name":"$self","containerName":"in_element","line":559,"kind":13},{"containerName":"in_element","name":"$name","kind":13,"line":559}],"name":"in_element","range":{"start":{"character":0,"line":556},"end":{"line":560,"character":9999}}},{"detail":"($self)","signature":{"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"containerName":"main::","definition":"sub","line":572,"children":[{"containerName":"start_document","name":"$self","definition":"my","localvar":"my","kind":13,"line":573},{"name":"$self","containerName":"start_document","kind":13,"line":574},{"kind":13,"line":575,"name":"$self","containerName":"start_document"},{"kind":13,"line":576,"name":"$self","containerName":"start_document"},{"name":"$self","containerName":"start_document","kind":13,"line":577}],"kind":12,"range":{"start":{"line":572,"character":0},"end":{"character":9999,"line":578}},"name":"start_document"},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_document","line":591,"kind":13},{"containerName":"end_document","name":"$self","line":592,"kind":13}],"line":590,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","label":"end_document($self)"},"detail":"($self)","name":"end_document","range":{"start":{"character":0,"line":590},"end":{"line":593,"character":9999}}},{"range":{"end":{"character":9999,"line":608},"start":{"character":0,"line":605}},"name":"result_count","definition":"sub","containerName":"main::","children":[{"line":606,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"result_count"},{"line":607,"kind":13,"containerName":"result_count","name":"$self"}],"line":605,"kind":12},{"line":622,"children":[{"line":623,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"descriptor"},{"name":"$self","containerName":"descriptor","line":624,"kind":13},{"name":"$self","containerName":"descriptor","line":625,"kind":13}],"kind":12,"range":{"end":{"line":626,"character":9999},"start":{"line":622,"character":0}},"containerName":"main::","definition":"sub","name":"descriptor"},{"range":{"end":{"line":640,"character":9999},"start":{"character":0,"line":640}},"containerName":"main::","name":"model","definition":"sub","line":640,"children":[{"name":"descriptor","containerName":"model","kind":12,"line":640}],"kind":12},{"range":{"start":{"character":0,"line":653},"end":{"line":657,"character":9999}},"definition":"sub","name":"database","containerName":"main::","children":[{"kind":13,"line":654,"definition":"my","name":"$self","containerName":"database","localvar":"my"},{"kind":13,"line":655,"containerName":"database","name":"$self"},{"name":"$self","containerName":"database","kind":13,"line":656}],"line":653,"kind":12},{"range":{"start":{"line":670,"character":0},"end":{"line":674,"character":9999}},"name":"query_accession","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"query_accession","name":"$self","definition":"my","line":671,"kind":13},{"line":672,"kind":13,"containerName":"query_accession","name":"$self"},{"line":673,"kind":13,"containerName":"query_accession","name":"$self"}],"line":670,"kind":12},{"range":{"end":{"line":690,"character":9999},"start":{"character":0,"line":686}},"name":"algorithm_version","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"algorithm_version","definition":"my","name":"$self","line":687,"kind":13},{"containerName":"algorithm_version","name":"$self","kind":13,"line":688},{"kind":13,"line":689,"name":"$self","containerName":"algorithm_version"}],"line":686,"kind":12},{"range":{"end":{"character":9999,"line":709},"start":{"line":703,"character":0}},"name":"hsp_minscore","definition":"sub","containerName":"main::","children":[{"kind":13,"line":704,"name":"$self","definition":"my","containerName":"hsp_minscore","localvar":"my"},{"kind":13,"line":704,"containerName":"hsp_minscore","name":"$score"},{"line":705,"kind":13,"containerName":"hsp_minscore","name":"$self"},{"line":705,"kind":12,"containerName":"hsp_minscore","name":"throw"},{"name":"$score","containerName":"hsp_minscore","kind":13,"line":706},{"line":706,"kind":13,"name":"$score","containerName":"hsp_minscore"},{"name":"$self","containerName":"hsp_minscore","kind":13,"line":707},{"kind":13,"line":708,"containerName":"hsp_minscore","name":"$self"}],"line":703,"kind":12},{"kind":12,"line":722,"children":[{"line":723,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"hsp_maxscore"},{"line":723,"kind":13,"containerName":"hsp_maxscore","name":"$score"},{"name":"$self","containerName":"hsp_maxscore","line":724,"kind":13},{"kind":12,"line":724,"containerName":"hsp_maxscore","name":"throw"},{"name":"$score","containerName":"hsp_maxscore","line":725,"kind":13},{"line":725,"kind":13,"name":"$score","containerName":"hsp_maxscore"},{"name":"$self","containerName":"hsp_maxscore","kind":13,"line":726},{"kind":13,"line":727,"containerName":"hsp_maxscore","name":"$self"}],"containerName":"main::","name":"hsp_maxscore","definition":"sub","range":{"end":{"character":9999,"line":728},"start":{"line":722,"character":0}}},{"name":"structure_symbols","range":{"start":{"line":744,"character":0},"end":{"line":757,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"structure_symbols","definition":"my","name":"$self","line":745,"kind":13},{"kind":13,"line":745,"name":"$delim","containerName":"structure_symbols"},{"name":"$delim","containerName":"structure_symbols","kind":13,"line":746},{"name":"$delim","containerName":"structure_symbols","line":747,"kind":13},{"localvar":"my","definition":"my","name":"%data","containerName":"structure_symbols","line":748,"kind":13},{"containerName":"structure_symbols","name":"$delim","line":748,"kind":13},{"kind":13,"line":749,"containerName":"structure_symbols","name":"$d","definition":"my","localvar":"my"},{"kind":13,"line":749,"name":"@VALID_SYMBOLS","containerName":"structure_symbols"},{"kind":13,"line":750,"containerName":"structure_symbols","name":"$data"},{"name":"$d","containerName":"structure_symbols","line":750,"kind":13},{"containerName":"structure_symbols","name":"$self","kind":13,"line":751},{"name":"$d","containerName":"structure_symbols","kind":13,"line":751},{"kind":13,"line":751,"name":"$data","containerName":"structure_symbols"},{"name":"$d","containerName":"structure_symbols","kind":13,"line":751},{"name":"$self","containerName":"structure_symbols","kind":13,"line":755},{"line":755,"kind":12,"name":"throw","containerName":"structure_symbols"}],"line":744,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$delim"}],"documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 descriptor\n\n Title   : descriptor\n Usage   : my $descr = $parser->descriptor();\n Function: Get/Set descriptor name.  Some versions of RNAMotif do not add the\n           descriptor name to the output.  This also overrides any name found\n           while parsing.\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub descriptor {\n    my $self = shift;\n    return $self->{'_descriptor'} = shift if @_;\n    return $self->{'_descriptor'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n Note    : this is a synonym for descriptor()\n\n\nsub model { shift->descriptor(@_) }\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; RNAMotif currently does not output\n           the accession number\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $ver = $parser->algorithm_version();\n Function: Get/Set algorithm version (not defined in RNAMotif output)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub algorithm_version {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_maxscore()\n\n\nsub hsp_minscore {\n    my ($self, $score) = shift;\n    $self->throw('Minscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 hsp_maxscore\n\n Title   : hsp_maxscore\n Usage   : my $cutoff = $parser->hsp_maxscore();\n Function: Get/Set max score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_minscore()\n\n\nsub hsp_maxscore {\n    my ($self, $score) = shift;\n    $self->throw('Maxscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_maxscore'} = shift if @_;\n    return $self->{'_hsp_maxscore'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     . (single-strand)\n                     ? (unknown) \n Args    : Hash ref of substitute delimiters, using above keys.","label":"structure_symbols($self,$delim)"},"detail":"($self,$delim)"},{"line":758,"kind":13,"name":"%self","containerName":null},{"range":{"start":{"line":778,"character":0},"end":{"line":799,"character":9999}},"name":"_motif2meta","signature":{"label":"_motif2meta($self,$str,$descriptor)","documentation":"1;\n# $Id: rnamotif.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::rnamotif\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::rnamotif - SearchIO-based RNAMotif parser\n\n=head1 SYNOPSIS\n\n  # do not call this module directly. Use Bio::SearchIO.\n\n=head1 DESCRIPTION\n\nThis is a highly experimental SearchIO-based parser for output from the rnamotif\nprogram (one of the programs in the RNAMotif suite). It currently parses only\nraw rnamotif output for RNAMotif versions 3.0 and above; older versions may work\nbut will not be supported. rmfmt output will not be supported at this time.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::rnamotif;\nuse strict;\n\nuse base qw(Bio::SearchIO);\n\nmy %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nmy %MAPPING = ( \n        # commented out tags have not been assigned\n        \n        'Hsp_score'        => 'HSP-score',\n        'Hsp_custom-data'  => 'HSP-custom_score',\n        \n        # rnamotif has no evalue\n        \n        # descriptor has no start, end; same as hit start, end\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end',\n        \n        # descriptor has no start, end\n        \n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        \n        # build this from scratch, simple WUSS-format\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_stranded'    => 'HSP-stranded',        \n        \n        # not supported for RNAMotif\n\n        'Hit_id'        => 'HIT-name',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_def'       => 'HIT-description',\n        'Hit_score'     => 'HIT-score', # best HSP score\n \n        'RNAMotif_program'  => 'RESULT-algorithm_name', # get/set \n        'RNAMotif_version'  => 'RESULT-algorithm_version', # get/set \n        'RNAMotif_query-def'=> 'RESULT-query_name', # get/set\n        # No length (query is a descriptor)\n        'RNAMotif_query-acc'=> 'RESULT-query_accession', # get/set \n        'RNAMotif_querydesc'=> 'RESULT-query_description', # get/set\n        'RNAMotif_db'       => 'RESULT-database_name',  # get/set \n\t     );\n\n# use structure_delimiters to set custom delimiters\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => '.',\n                   'unknown'        => '?'\n                    # may add more for quartets, triplets\n                  );\n\nmy $DEFAULT_VERSION = '3.0.3';\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO->new();\n Function: Builds a new Bio::SearchIO::rnamotif object \n Returns : Bio::SearchIO::rnamotif parser\n Args    : -fh/-file     => RNAMotif filename\n           -format       => 'rnamotif'\n           -model        => query model (or descriptor, in this case)\n           -database     => database name (default undef)\n           -query_acc    => query accession (default undef)\n           -hsp_minscore => minimum HSP score cutoff\n           -hsp_maxscore => maximum HSP score cutoff\n           -symbols      => hash ref of structure symbols to use\n                            (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($version, $model, $database, $maxcutoff, $mincutoff, $seqdistance,\n        $accession, $symbols) =\n       $self->_rearrange([qw(VERSION MODEL DATABASE HSP_MAXSCORE \n                          HSP_MINSCORE SEQ_DISTANCE QUERY_ACC SYMBOLS)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose => $self->verbose\n        )\n    );\n    $model      && $self->model($model);\n    $database   && $self->database($database);\n    $accession  && $self->query_accession($accession);\n    $version ||= $DEFAULT_VERSION;\n    $self->algorithm_version($version);\n    $self->throw(\"Cannot define both a minimal and maximal cutoff\")\n           if (defined($mincutoff) && defined($maxcutoff));\n    defined($mincutoff)   && $self->hsp_minscore($mincutoff);\n    defined($maxcutoff)   && $self->hsp_maxscore($maxcutoff);\n    $symbols  ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my $seentop = 0;\n    local $/ = \"\\n\";\n    local $_;\n    my ($rm, $d, $descriptor, $file, $oktobuild);\n    my ($hitid, $hitdesc, $hspid, $lastid, $lastscore);\n    my $sprintf;\n    \n    # user-determined Result data\n    my ($accession, $db, $model) =\n       ($self->query_accession, $self->database, $self->model);\n    # HSP building options\n    my $hsp_min = $self->hsp_minscore;\n    my $hsp_max = $self->hsp_maxscore;\n    my $version = $self->algorithm_version;\n    my $laststart;\n    \n    my $verbose = $self->verbose;    # cache for speed?\n    $self->start_document();\n    PARSER:\n    while ( defined( my $line = $self->_readline ) ) {\n        # start of report\n        next if $line =~ m{^\\s+$};\n        if (index($line,'#RM') == 0) {\n            if (index($line,'#RM scored') == 0 ) {\n                if ($seentop) {\n                    $self->_pushback($line);\n                    last PARSER;\n                }\n                $self->start_element({'Name' => 'Result'});\n                $self->element_hash({\n                    'RNAMotif_program'      => 'rnamotif',\n                    'RNAMotif_version'      => $version,\n                    'RNAMotif_query-acc'    => $accession,\n                    'RNAMotif_db'           => $db\n                    });                \n                $seentop = 1;\n                #$self->debug(\"Start result\\n\");\n            } elsif (index($line,'#RM descr') == 0) {\n                ($rm, $d, $descriptor) = split ' ', $line, 3;\n                # toss $rm, $d; keep $descr\n                chomp $descriptor;\n                $self->{'_descriptor'} = $descriptor;\n                $self->element(\n                               {'Name' => 'RNAMotif_querydesc',\n                                'Data' => $descriptor}\n                              );\n            } elsif(index($line,'#RM dfile') == 0) {\n                ($rm, $d, $file) = split ' ', $line, 3;\n                # toss $rm, $d; keep $file\n                chomp $file;\n                $self->element(\n                               {'Name' => 'RNAMotif_query-def',\n                                'Data' => $file}\n                              );\n            } else {\n                $self->debug(\"Unrecognized line: $line\");\n            }\n        } elsif ($line =~ s{^>}{}) {\n            chomp $line;\n            ($hitid, $hitdesc) = split ' ',$line,2;\n            \n            if ($self->within_element('hit') && ($hitid ne $lastid)) {\n                $self->element(\n                       {'Name' => 'Hit_score',\n                        'Data' => $lastscore}\n                      ) if $lastscore;\n                $self->end_element({'Name' => 'Hit'});\n                $self->start_element({'Name' => 'Hit'});\n            } elsif (!$self->within_element('hit')) {\n                $self->start_element({'Name' => 'Hit'});\n            }\n            my ($gi, $acc, $ver) = $self->_get_seq_identifiers($hitid);\n            \n            $self->element_hash({\n                'Hit_id'        => $hitid,\n                'Hit_gi'        => $gi,\n                'Hit_accession' => $ver ? \"$acc.$ver\" :\n                                    $acc ? $acc : $hitid,\n                'Hit_def'       => $hitdesc}\n              );\n            $lastid = $hitid;\n        } elsif ($line =~ m{^(\\S+)\\s+(.+?)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s(.*)$}xm) {\n            chomp $line;\n            my $hspid = $1;\n            my ($score, $strand, $start, $length , $seq) = ($2, $3, $4, $5, $6);\n            $score *= 1;  # implicitly cast any odd '0.000' to float\n            # sanity check ids\n            unless ($hitid eq $hspid) {\n                $self->throw(\"IDs do not match!\");\n            }\n            # check score for possible sprintf data, mark as such, cache result\n            if (!defined($sprintf)) {\n                if ($score =~ m{[^0-9.-]+}gxms) {\n                    if (defined $hsp_min || defined $hsp_max ) {\n                        $self->warn(\"HSP data likely contains custom score; \".\n                                    \"ignoring min/maxscore\");\n                    }\n                    $sprintf = $oktobuild = 1;\n                } else {\n                    $sprintf = 0;\n                }\n            }\n            \n            if (!$sprintf) {\n                if (($hsp_min && $score <= $hsp_min) \n                          || ($hsp_max && ($score >= $hsp_max)) ) {\n                    # do not build HSP\n                    $oktobuild = 0;\n                } else {\n                    $oktobuild = 1;\n                    \n                    # store best hit score based on the hsp min/maxscore only\n                    if (defined $hsp_min && $score > $hsp_min) {\n                        $lastscore = $score if !$lastscore || $score > $lastscore;\n                    } elsif (defined $hsp_max && $score < $hsp_max) {\n                        $lastscore = $score if !$lastscore || $score < $lastscore;\n                    } \n                }\n            }\n            \n            # build HSP\n            if ($oktobuild) {\n                my $end;\n                # calculate start/end\n                if( $strand==0 ) {\n                    $end = $start + $length -1;\n                } else {\n                    $end = $start - $length + 1;\n                }\n                \n                my ($rna, $meta) = $self->_motif2meta($seq, $descriptor);\n                \n                $self->start_element({'Name' => 'Hsp'});\n                my $rnalen = $rna =~ tr{ATGCatgc}{ATGCatgc};\n                $self->element_hash({\n                        'Hsp_stranded'      => 'HIT', \n                        'Hsp_hseq'          => $rna,\n                        'Hsp_query-from'    => 1,\n                        'Hsp_query-to'      =>length($rna),\n                        'Hsp_hit-from'      => $start,\n                        'Hsp_hit-to'        => $end,\n                        'Hsp_structure'     => $meta,\n                        'Hsp_align-len'     => length($rna),\n                        'Hsp_score'         => $sprintf ? undef : $score,\n                        'Hsp_custom-data'   => $sprintf ? $score : undef,\n                        });\n                $self->end_element({'Name' => 'Hsp'});\n                $oktobuild = 0 if (!$sprintf);\n            }\n        }\n    }\n    if ($self->within_element('hit')) {\n        $self->element(\n               {'Name' => 'Hit_score',\n                'Data' => $lastscore}\n              ) if $lastscore;\n        $self->end_element( { 'Name' => 'Hit' } );\n    }\n    if ($seentop) {\n        $self->end_element( { 'Name' => 'Result' } );\n    }\n    return $self->end_document();\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 descriptor\n\n Title   : descriptor\n Usage   : my $descr = $parser->descriptor();\n Function: Get/Set descriptor name.  Some versions of RNAMotif do not add the\n           descriptor name to the output.  This also overrides any name found\n           while parsing.\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub descriptor {\n    my $self = shift;\n    return $self->{'_descriptor'} = shift if @_;\n    return $self->{'_descriptor'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n Note    : this is a synonym for descriptor()\n\n\nsub model { shift->descriptor(@_) }\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; RNAMotif currently does not output\n           the accession number\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 algorithm_version\n\n Title   : algorithm_version\n Usage   : my $ver = $parser->algorithm_version();\n Function: Get/Set algorithm version (not defined in RNAMotif output)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub algorithm_version {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_maxscore()\n\n\nsub hsp_minscore {\n    my ($self, $score) = shift;\n    $self->throw('Minscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 hsp_maxscore\n\n Title   : hsp_maxscore\n Usage   : my $cutoff = $parser->hsp_maxscore();\n Function: Get/Set max score cutoff (for generating Hits/HSPs).\n Returns : score (number)\n Args    : [optional] score (number)\n Note    : Cannot be set along with hsp_minscore()\n\n\nsub hsp_maxscore {\n    my ($self, $score) = shift;\n    $self->throw('Maxscore not set to a number') if\n        ($score && $score !~ m{[0-9.]+});\n    return $self->{'_hsp_maxscore'} = shift if @_;\n    return $self->{'_hsp_maxscore'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     . (single-strand)\n                     ? (unknown) \n Args    : Hash ref of substitute delimiters, using above keys.\n\n\nsub structure_symbols {\n    my ($self, $delim) = @_;\n    if ($delim) {\n        if (ref($delim) =~ m{HASH}) {\n            my %data = %{ $delim };\n            for my $d (@VALID_SYMBOLS) {\n                if ( exists $data{$d} ) {\n                    $self->{'_delimiter'}->{$d} = $data{$d};\n                }\n            }\n        } else {\n            $self->throw(\"Args to helix_delimiters() should be in a hash reference\");\n        }\n    }\n    return $self->{'_delimiter'};\n}\n\n#Private methods\n\n=head2 _motif2meta\n\n Title   : _motif2meta\n Usage   : my ($rna, $meta) = $parser->_motif2meta($str, $descr);\n Function: Creates meta string from sequence and descriptor\n Returns : array of sequence, meta strings\n Args    : Array of string data and descriptor data\n\n Note: This is currently a quick and simple way of making simple\n RNA structures (stem-loops, helices, etc) from RNAMotif descriptor\n data in the output file.  It does not currently work with pseudoknots,\n triplets, G-quartets, or other more complex RNA structural motifs.","parameters":[{"label":"$self"},{"label":"$str"},{"label":"$descriptor"}]},"detail":"($self,$str,$descriptor)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_motif2meta","line":779,"kind":13},{"kind":13,"line":779,"containerName":"_motif2meta","name":"$str"},{"containerName":"_motif2meta","name":"$descriptor","line":779,"kind":13},{"localvar":"my","containerName":"_motif2meta","definition":"my","name":"$rna","line":780,"kind":13},{"line":780,"kind":13,"containerName":"_motif2meta","name":"$meta"},{"kind":13,"line":781,"containerName":"_motif2meta","name":"@desc_el","definition":"my","localvar":"my"},{"name":"$descriptor","containerName":"_motif2meta","kind":13,"line":781},{"definition":"my","name":"@seq_el","containerName":"_motif2meta","localvar":"my","kind":13,"line":782},{"name":"$str","containerName":"_motif2meta","line":782,"kind":13},{"localvar":"my","name":"$symbol","definition":"my","containerName":"_motif2meta","line":783,"kind":13},{"name":"$self","containerName":"_motif2meta","kind":13,"line":783},{"line":783,"kind":12,"containerName":"_motif2meta","name":"structure_symbols"},{"kind":13,"line":785,"name":"$self","containerName":"_motif2meta"},{"kind":12,"line":785,"containerName":"_motif2meta","name":"throw"},{"line":787,"kind":13,"containerName":"_motif2meta","name":"@desc_el"},{"line":788,"kind":13,"localvar":"my","containerName":"_motif2meta","name":"$struct","definition":"my"},{"kind":13,"line":789,"name":"$seq","definition":"my","containerName":"_motif2meta","localvar":"my"},{"name":"$motif","containerName":"_motif2meta","line":789,"kind":13},{"kind":13,"line":789,"containerName":"_motif2meta","name":"@seq_el"},{"line":789,"kind":13,"containerName":"_motif2meta","name":"@desc_el"},{"containerName":"_motif2meta","name":"$struct","line":790,"kind":13},{"kind":13,"line":790,"name":"$motif","containerName":"_motif2meta"},{"name":"$symbol","containerName":"_motif2meta","kind":13,"line":790},{"containerName":"_motif2meta","name":"$motif","kind":13,"line":791},{"line":791,"kind":13,"name":"$symbol","containerName":"_motif2meta"},{"kind":13,"line":792,"containerName":"_motif2meta","name":"$motif"},{"kind":13,"line":792,"containerName":"_motif2meta","name":"$symbol"},{"name":"$motif","containerName":"_motif2meta","kind":13,"line":793},{"name":"$symbol","containerName":"_motif2meta","line":793,"kind":13},{"name":"$symbol","containerName":"_motif2meta","kind":13,"line":794},{"line":795,"kind":13,"containerName":"_motif2meta","name":"$meta"},{"name":"$struct","containerName":"_motif2meta","line":795,"kind":13},{"name":"$seq","containerName":"_motif2meta","line":795,"kind":13},{"containerName":"_motif2meta","name":"$rna","kind":13,"line":796},{"name":"$seq","containerName":"_motif2meta","kind":13,"line":796},{"name":"$rna","containerName":"_motif2meta","kind":13,"line":798},{"kind":13,"line":798,"containerName":"_motif2meta","name":"$meta"}],"line":778,"kind":12},{"line":784,"kind":12,"name":"desc_el"},{"kind":12,"line":784,"name":"seq_el"}]}