{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":80},{"line":87,"kind":13,"containerName":null,"name":"$DefaultProgramName"},{"kind":2,"line":87,"containerName":"strict::Bio::Search::HSP::HSPFactory::Bio::Search::Hit::HitFactory::Bio::Search::Result","name":"ResultFactory"},{"line":88,"kind":13,"name":"$DEFAULT_WRITER_CLASS","containerName":null},{"name":"%MODEMAP","containerName":null,"line":91,"kind":13},{"line":98,"kind":13,"name":"%MAPPING","containerName":null},{"containerName":"","name":"base","kind":2,"line":137},{"name":"_initialize","range":{"start":{"line":150,"character":0},"end":{"line":174,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :"},"kind":12,"line":150,"children":[{"kind":13,"line":151,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"name":"@args","containerName":"_initialize","kind":13,"line":151},{"line":152,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"@args","line":152,"kind":13},{"kind":13,"line":153,"containerName":"_initialize","definition":"my","name":"$pname","localvar":"my"},{"kind":13,"line":153,"containerName":"_initialize","name":"$self"},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":153},{"line":153,"kind":13,"name":"@args","containerName":"_initialize"},{"kind":13,"line":154,"name":"$self","containerName":"_initialize"},{"name":"program_name","containerName":"_initialize","line":154,"kind":12},{"kind":13,"line":154,"containerName":"_initialize","name":"$pname"},{"line":154,"kind":13,"containerName":"_initialize","name":"$DefaultProgramName"},{"kind":13,"line":155,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_eventHandler","kind":12,"line":155},{"kind":12,"line":155,"containerName":"_initialize","name":"register_factory"},{"kind":12,"line":157,"containerName":"_initialize","name":"new"},{"containerName":"_initialize","name":"$self","line":162,"kind":13},{"containerName":"_initialize","name":"_eventHandler","line":162,"kind":12},{"kind":12,"line":162,"containerName":"_initialize","name":"register_factory"},{"kind":12,"line":164,"name":"new","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":168,"kind":13},{"name":"_eventHandler","containerName":"_initialize","kind":12,"line":168},{"name":"register_factory","containerName":"_initialize","kind":12,"line":168},{"name":"new","containerName":"_initialize","line":170,"kind":12}]},{"line":152,"kind":12,"name":"SUPER","containerName":"_initialize"},{"kind":12,"line":157,"containerName":"Search::Result::ResultFactory","name":"Bio"},{"kind":12,"line":164,"containerName":"Search::Hit::HitFactory","name":"Bio"},{"kind":12,"line":170,"name":"Bio","containerName":"Search::HSP::HSPFactory"},{"range":{"end":{"line":428,"character":9999},"start":{"line":186,"character":0}},"name":"next_result","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none","label":"next_result($self)"},"containerName":"main::","definition":"sub","line":186,"children":[{"definition":"my","name":"$self","containerName":"next_result","localvar":"my","kind":13,"line":187},{"line":188,"kind":13,"localvar":"my","containerName":"next_result","name":"$lastquery","definition":"my"},{"name":"$lasthit","containerName":"next_result","line":188,"kind":13},{"name":"$self","containerName":"next_result","line":193,"kind":13},{"line":193,"kind":12,"containerName":"next_result","name":"_readline"},{"containerName":"next_result","name":"$self","kind":13,"line":194},{"containerName":"next_result","name":"_pushback","line":194,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":197},{"line":197,"kind":12,"containerName":"next_result","name":"_readline"},{"kind":13,"line":198,"definition":"my","name":"$matches","containerName":"next_result","localvar":"my"},{"line":199,"kind":13,"name":"$mismatches","containerName":"next_result"},{"name":"$rep_matches","containerName":"next_result","kind":13,"line":199},{"containerName":"next_result","name":"$n_count","kind":13,"line":199},{"containerName":"next_result","name":"$q_num_insert","kind":13,"line":200},{"kind":13,"line":200,"containerName":"next_result","name":"$q_base_insert"},{"kind":13,"line":200,"name":"$t_num_insert","containerName":"next_result"},{"name":"$t_base_insert","containerName":"next_result","kind":13,"line":200},{"containerName":"next_result","name":"$strand","line":201,"kind":13},{"kind":13,"line":201,"name":"$q_name","containerName":"next_result"},{"kind":13,"line":201,"name":"$q_length","containerName":"next_result"},{"kind":13,"line":201,"containerName":"next_result","name":"$q_start"},{"name":"$q_end","containerName":"next_result","kind":13,"line":202},{"name":"$t_name","containerName":"next_result","kind":13,"line":202},{"name":"$t_length","containerName":"next_result","kind":13,"line":202},{"line":202,"kind":13,"name":"$t_start","containerName":"next_result"},{"kind":13,"line":203,"containerName":"next_result","name":"$t_end"},{"line":203,"kind":13,"name":"$block_count","containerName":"next_result"},{"name":"$block_sizes","containerName":"next_result","kind":13,"line":203},{"name":"$q_starts","containerName":"next_result","line":203,"kind":13},{"containerName":"next_result","name":"$t_starts","line":205,"kind":13},{"line":207,"kind":13,"name":"$q_length","containerName":"next_result"},{"kind":13,"line":207,"name":"$self","containerName":"next_result"},{"kind":12,"line":207,"name":"throw","containerName":"next_result"},{"name":"$score","definition":"my","containerName":"next_result","localvar":"my","kind":13,"line":208},{"line":208,"kind":13,"name":"$matches","containerName":"next_result"},{"kind":13,"line":208,"containerName":"next_result","name":"$mismatches"},{"line":208,"kind":13,"name":"$rep_matches","containerName":"next_result"},{"kind":13,"line":208,"containerName":"next_result","name":"$q_length"},{"localvar":"my","containerName":"next_result","name":"$match_total","definition":"my","line":211,"kind":13},{"line":211,"kind":13,"containerName":"next_result","name":"$matches"},{"containerName":"next_result","name":"$mismatches","line":211,"kind":13},{"containerName":"next_result","name":"$rep_matches","line":211,"kind":13},{"line":212,"kind":13,"containerName":"next_result","name":"$match_total"},{"kind":13,"line":213,"containerName":"next_result","name":"$self"},{"line":213,"kind":12,"name":"throw","containerName":"next_result"},{"kind":13,"line":214,"definition":"my","name":"$percent_id","containerName":"next_result","localvar":"my"},{"kind":13,"line":214,"name":"$matches","containerName":"next_result"},{"kind":13,"line":214,"containerName":"next_result","name":"$rep_matches"},{"containerName":"next_result","name":"$match_total","kind":13,"line":214},{"kind":13,"line":218,"containerName":"next_result","name":"$lastquery"},{"kind":13,"line":218,"name":"$lastquery","containerName":"next_result"},{"line":218,"kind":13,"containerName":"next_result","name":"$q_name"},{"name":"$self","containerName":"next_result","kind":13,"line":220},{"containerName":"next_result","name":"end_element","line":220,"kind":12},{"name":"$self","containerName":"next_result","kind":13,"line":221},{"kind":12,"line":221,"containerName":"next_result","name":"end_element"},{"containerName":"next_result","name":"$self","line":222,"kind":13},{"line":222,"kind":12,"containerName":"next_result","name":"_pushback"},{"containerName":"next_result","name":"$self","line":223,"kind":13},{"name":"end_document","containerName":"next_result","line":223,"kind":12},{"line":225,"kind":13,"containerName":"next_result","name":"$lastquery"},{"kind":13,"line":226,"containerName":"next_result","name":"$self"},{"line":227,"kind":13,"name":"$self","containerName":"next_result"},{"line":227,"kind":12,"name":"start_element","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":228,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":228},{"kind":13,"line":231,"name":"$self","containerName":"next_result"},{"line":232,"kind":12,"containerName":"next_result","name":"program_name"},{"name":"$self","containerName":"next_result","line":234,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":234},{"kind":13,"line":238,"name":"$q_name","containerName":"next_result"},{"containerName":"next_result","name":"$self","kind":13,"line":240},{"kind":12,"line":240,"containerName":"next_result","name":"element"},{"kind":13,"line":244,"name":"$q_length","containerName":"next_result"},{"line":246,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"start_element","line":246,"kind":12},{"containerName":"next_result","name":"$self","kind":13,"line":247},{"kind":12,"line":247,"name":"element","containerName":"next_result"},{"name":"$t_name","containerName":"next_result","kind":13,"line":251},{"containerName":"next_result","name":"$self","line":253,"kind":13},{"containerName":"next_result","name":"element","line":253,"kind":12},{"containerName":"next_result","name":"$t_length","line":257,"kind":13},{"line":259,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":259},{"name":"$score","containerName":"next_result","line":263,"kind":13},{"name":"$lasthit","containerName":"next_result","kind":13,"line":266},{"containerName":"next_result","name":"$t_name","kind":13,"line":266},{"kind":13,"line":267,"name":"$self","containerName":"next_result"},{"name":"end_element","containerName":"next_result","line":267,"kind":12},{"line":268,"kind":13,"containerName":"next_result","name":"$self"},{"line":268,"kind":12,"containerName":"next_result","name":"start_element"},{"name":"$self","containerName":"next_result","kind":13,"line":269},{"line":269,"kind":12,"name":"element","containerName":"next_result"},{"containerName":"next_result","name":"$t_name","kind":13,"line":273},{"line":275,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","line":275,"kind":12},{"line":279,"kind":13,"name":"$t_length","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":281,"kind":13},{"name":"element","containerName":"next_result","kind":12,"line":281},{"name":"$score","containerName":"next_result","kind":13,"line":285},{"kind":13,"line":289,"containerName":"next_result","name":"$identical","definition":"my","localvar":"my"},{"name":"$matches","containerName":"next_result","kind":13,"line":289},{"line":289,"kind":13,"name":"$rep_matches","containerName":"next_result"},{"kind":13,"line":290,"containerName":"next_result","name":"$self"},{"line":290,"kind":12,"name":"start_element","containerName":"next_result"},{"kind":13,"line":291,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":291,"kind":12},{"containerName":"next_result","name":"$score","kind":13,"line":295},{"name":"$self","containerName":"next_result","kind":13,"line":297},{"kind":12,"line":297,"containerName":"next_result","name":"element"},{"line":301,"kind":13,"name":"$identical","containerName":"next_result"},{"line":303,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":303,"name":"element","containerName":"next_result"},{"line":307,"kind":13,"containerName":"next_result","name":"$identical"},{"name":"$self","containerName":"next_result","line":309,"kind":13},{"line":309,"kind":12,"containerName":"next_result","name":"element"},{"name":"$mismatches","containerName":"next_result","line":313,"kind":13},{"line":315,"kind":13,"containerName":"next_result","name":"$self"},{"line":315,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$q_base_insert","line":318,"kind":13},{"kind":13,"line":319,"name":"$t_base_insert","containerName":"next_result"},{"name":"$self","containerName":"next_result","kind":13,"line":323},{"containerName":"next_result","name":"element","kind":12,"line":323},{"kind":13,"line":327,"containerName":"next_result","name":"$t_base_insert"},{"line":329,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","line":329,"kind":12},{"name":"$q_base_insert","containerName":"next_result","kind":13,"line":333},{"line":335,"kind":13,"name":"$strand","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":336,"kind":13},{"line":336,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"$q_start","kind":13,"line":339},{"line":342,"kind":13,"containerName":"next_result","name":"$self"},{"name":"element","containerName":"next_result","kind":12,"line":342},{"name":"$q_end","containerName":"next_result","line":346,"kind":13},{"containerName":"next_result","name":"$self","line":350,"kind":13},{"containerName":"next_result","name":"element","line":350,"kind":12},{"containerName":"next_result","name":"$q_start","kind":13,"line":353},{"line":356,"kind":13,"containerName":"next_result","name":"$self"},{"containerName":"next_result","name":"element","kind":12,"line":356},{"kind":13,"line":360,"name":"$q_end","containerName":"next_result"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$hsplen","line":363,"kind":13},{"name":"$q_base_insert","containerName":"next_result","line":364,"kind":13},{"kind":13,"line":365,"containerName":"next_result","name":"$t_base_insert"},{"line":366,"kind":13,"name":"$t_end","containerName":"next_result"},{"kind":13,"line":366,"containerName":"next_result","name":"$t_start"},{"containerName":"next_result","name":"$q_end","line":367,"kind":13},{"name":"$q_start","containerName":"next_result","line":367,"kind":13},{"kind":13,"line":368,"name":"$self","containerName":"next_result"},{"line":368,"kind":12,"containerName":"next_result","name":"element"},{"line":371,"kind":13,"name":"$t_start","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":374,"kind":13},{"kind":12,"line":374,"name":"element","containerName":"next_result"},{"name":"$t_end","containerName":"next_result","kind":13,"line":378},{"line":380,"kind":13,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"element","kind":12,"line":380},{"line":384,"kind":13,"containerName":"next_result","name":"$hsplen"},{"line":388,"kind":13,"containerName":"next_result","name":"$block_sizes"},{"kind":13,"line":389,"name":"$q_starts","containerName":"next_result"},{"line":390,"kind":13,"containerName":"next_result","name":"$t_starts"},{"kind":13,"line":391,"containerName":"next_result","name":"@blocksizes","definition":"my","localvar":"my"},{"kind":13,"line":391,"containerName":"next_result","name":"$block_sizes"},{"line":392,"kind":13,"localvar":"my","definition":"my","name":"@qstarts","containerName":"next_result"},{"name":"$q_starts","containerName":"next_result","line":392,"kind":13},{"kind":13,"line":394,"name":"@tstarts","definition":"my","containerName":"next_result","localvar":"my"},{"containerName":"next_result","name":"$t_starts","line":394,"kind":13},{"definition":"my","name":"@qgapblocks","containerName":"next_result","localvar":"my","kind":13,"line":396},{"line":396,"kind":13,"name":"@hgapblocks","containerName":"next_result"},{"line":398,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":"next_result"},{"containerName":"next_result","name":"$i","line":398,"kind":13},{"kind":13,"line":398,"containerName":"next_result","name":"$block_count"},{"kind":13,"line":398,"containerName":"next_result","name":"$i"},{"containerName":"next_result","name":"$strand","line":399,"kind":13},{"line":400,"kind":13,"name":"@qgapblocks","containerName":"next_result"},{"line":400,"kind":13,"containerName":"next_result","name":"$qstarts"},{"containerName":"next_result","name":"$i","kind":13,"line":400},{"name":"$blocksizes","containerName":"next_result","kind":13,"line":400},{"kind":13,"line":400,"containerName":"next_result","name":"$i"},{"containerName":"next_result","name":"@qgapblocks","line":403,"kind":13},{"containerName":"next_result","name":"$q_length","line":403,"kind":13},{"kind":13,"line":403,"name":"$qstarts","containerName":"next_result"},{"name":"$i","containerName":"next_result","line":403,"kind":13},{"name":"$blocksizes","containerName":"next_result","line":403,"kind":13},{"containerName":"next_result","name":"$i","line":403,"kind":13},{"containerName":"next_result","name":"@hgapblocks","line":405,"kind":13},{"kind":13,"line":405,"name":"$tstarts","containerName":"next_result"},{"containerName":"next_result","name":"$i","kind":13,"line":405},{"kind":13,"line":405,"containerName":"next_result","name":"$blocksizes"},{"line":405,"kind":13,"containerName":"next_result","name":"$i"},{"containerName":"next_result","name":"$self","line":407,"kind":13},{"name":"element","containerName":"next_result","line":407,"kind":12},{"kind":13,"line":411,"name":"@qgapblocks","containerName":"next_result"},{"containerName":"next_result","name":"$self","line":413,"kind":13},{"line":413,"kind":12,"containerName":"next_result","name":"element"},{"containerName":"next_result","name":"@hgapblocks","kind":13,"line":417},{"kind":13,"line":419,"name":"$self","containerName":"next_result"},{"kind":12,"line":419,"name":"end_element","containerName":"next_result"},{"line":420,"kind":13,"name":"$lastquery","containerName":"next_result"},{"containerName":"next_result","name":"$q_name","kind":13,"line":420},{"name":"$lasthit","containerName":"next_result","line":421,"kind":13},{"line":421,"kind":13,"containerName":"next_result","name":"$t_name"},{"kind":13,"line":423,"containerName":"next_result","name":"$lasthit"},{"containerName":"next_result","name":"$lastquery","kind":13,"line":423},{"line":424,"kind":13,"name":"$self","containerName":"next_result"},{"kind":12,"line":424,"name":"end_element","containerName":"next_result"},{"line":425,"kind":13,"name":"$self","containerName":"next_result"},{"line":425,"kind":12,"name":"end_element","containerName":"next_result"},{"line":426,"kind":13,"name":"$self","containerName":"next_result"},{"name":"end_document","containerName":"next_result","kind":12,"line":426}],"kind":12},{"name":"start_element","range":{"end":{"character":9999,"line":453},"start":{"line":441,"character":0}},"kind":12,"line":441,"children":[{"localvar":"my","containerName":"start_element","name":"$self","definition":"my","line":442,"kind":13},{"name":"$data","containerName":"start_element","line":442,"kind":13},{"kind":13,"line":445,"name":"$nm","definition":"my","containerName":"start_element","localvar":"my"},{"name":"$data","containerName":"start_element","line":445,"kind":13},{"name":"$type","definition":"my","containerName":"start_element","localvar":"my","kind":13,"line":446},{"kind":13,"line":446,"name":"$MODEMAP","containerName":"start_element"},{"line":446,"kind":13,"containerName":"start_element","name":"$nm"},{"containerName":"start_element","name":"$self","line":447,"kind":13},{"line":447,"kind":12,"name":"_mode","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":447,"kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":448},{"line":448,"kind":12,"containerName":"start_element","name":"_eventHandler"},{"kind":12,"line":448,"name":"will_handle","containerName":"start_element"},{"line":448,"kind":13,"containerName":"start_element","name":"$type"},{"localvar":"my","name":"$func","definition":"my","containerName":"start_element","line":449,"kind":13},{"name":"$type","containerName":"start_element","line":449,"kind":13},{"line":450,"kind":13,"name":"$self","containerName":"start_element"},{"kind":12,"line":450,"name":"_eventHandler","containerName":"start_element"},{"kind":13,"line":450,"name":"$func","containerName":"start_element"},{"name":"$data","containerName":"start_element","kind":13,"line":450},{"line":452,"kind":13,"name":"$self","containerName":"start_element"},{"name":"$type","containerName":"start_element","line":452,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"label":"start_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"}},{"line":454,"kind":13,"name":"%nm","containerName":null},{"kind":13,"line":455,"name":"%self","containerName":null},{"kind":13,"line":456,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"line":457,"kind":13},{"name":"end_element","range":{"start":{"line":473,"character":0},"end":{"character":9999,"line":489}},"kind":12,"line":473,"children":[{"definition":"my","name":"$self","containerName":"end_element","localvar":"my","kind":13,"line":474},{"name":"$data","containerName":"end_element","kind":13,"line":474},{"line":475,"kind":13,"localvar":"my","name":"$nm","definition":"my","containerName":"end_element"},{"name":"$data","containerName":"end_element","kind":13,"line":475},{"name":"$rc","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":476},{"line":481,"kind":13,"localvar":"my","containerName":"end_element","definition":"my","name":"$type"},{"line":481,"kind":13,"containerName":"end_element","name":"$MODEMAP"},{"name":"$nm","containerName":"end_element","kind":13,"line":481},{"containerName":"end_element","name":"$self","line":482,"kind":13},{"line":482,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"line":482,"kind":12,"name":"will_handle","containerName":"end_element"},{"name":"$type","containerName":"end_element","kind":13,"line":482},{"kind":13,"line":483,"definition":"my","name":"$func","containerName":"end_element","localvar":"my"},{"kind":13,"line":483,"name":"$type","containerName":"end_element"},{"kind":13,"line":484,"name":"$rc","containerName":"end_element"},{"containerName":"end_element","name":"$self","line":484,"kind":13},{"kind":12,"line":484,"containerName":"end_element","name":"_eventHandler"},{"line":484,"kind":13,"name":"$func","containerName":"end_element"},{"name":"$self","containerName":"end_element","kind":13,"line":484},{"line":485,"kind":13,"name":"$self","containerName":"end_element"},{"kind":13,"line":487,"containerName":"end_element","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"}},{"containerName":null,"name":"%MAPPING","kind":13,"line":490},{"kind":13,"line":490,"name":"%nm","containerName":null},{"line":491,"kind":13,"name":"%MAPPING","containerName":null},{"line":491,"kind":13,"containerName":null,"name":"%nm"},{"localvar":"my","definition":"my","name":"$key","containerName":null,"line":492,"kind":13},{"containerName":null,"name":"%MAPPING","line":492,"kind":13},{"containerName":null,"name":"@nm","line":492,"kind":13},{"containerName":null,"name":"%self","line":493,"kind":13},{"name":"%key","containerName":null,"line":493,"kind":13},{"line":493,"kind":13,"name":"%MAPPING","containerName":null},{"kind":13,"line":493,"name":"%nm","containerName":null},{"kind":13,"line":493,"name":"$key","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":494},{"name":"%self","containerName":null,"kind":13,"line":497},{"name":"%MAPPING","containerName":null,"kind":13,"line":497},{"name":"$nm","containerName":null,"line":497,"kind":13},{"line":497,"kind":13,"name":"%self","containerName":null},{"containerName":null,"name":"$self","line":501,"kind":13},{"line":501,"kind":12,"name":"warn","containerName":"main::"},{"line":504,"kind":13,"name":"%self","containerName":null},{"line":506,"kind":13,"containerName":null,"name":"%self"},{"name":"$rc","containerName":null,"kind":13,"line":507},{"kind":13,"line":508,"containerName":null,"name":"$nm"},{"name":"%MODEMAP","containerName":null,"kind":13,"line":508},{"name":"$nm","containerName":null,"kind":13,"line":508},{"name":"%MODEMAP","containerName":null,"line":509,"kind":13},{"kind":13,"line":509,"name":"$nm","containerName":null},{"containerName":null,"name":"$rc","kind":13,"line":510},{"range":{"start":{"line":525,"character":0},"end":{"character":9999,"line":530}},"name":"element","line":525,"children":[{"kind":13,"line":526,"containerName":"element","name":"$self","definition":"my","localvar":"my"},{"containerName":"element","name":"$data","kind":13,"line":526},{"containerName":"element","name":"$self","kind":13,"line":527},{"line":527,"kind":12,"name":"start_element","containerName":"element"},{"line":527,"kind":13,"containerName":"element","name":"$data"},{"name":"$self","containerName":"element","line":528,"kind":13},{"containerName":"element","name":"characters","line":528,"kind":12},{"line":528,"kind":13,"containerName":"element","name":"$data"},{"kind":13,"line":529,"containerName":"element","name":"$self"},{"kind":12,"line":529,"containerName":"element","name":"end_element"},{"line":529,"kind":13,"name":"$data","containerName":"element"}],"kind":12,"detail":"($self,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","label":"element($self,$data)"},"containerName":"main::","definition":"sub"},{"name":"characters","range":{"end":{"character":9999,"line":559},"start":{"line":543,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"characters($self,$data)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","kind":12,"children":[{"line":544,"kind":13,"localvar":"my","containerName":"characters","definition":"my","name":"$self"},{"name":"$data","containerName":"characters","kind":13,"line":544},{"line":546,"kind":13,"name":"$data","containerName":"characters"},{"kind":13,"line":547,"containerName":"characters","name":"$data"},{"kind":13,"line":548,"containerName":"characters","name":"$data"},{"name":"$self","containerName":"characters","kind":13,"line":551},{"line":551,"kind":12,"containerName":"characters","name":"in_element"},{"kind":13,"line":552,"containerName":"characters","name":"$data"},{"kind":13,"line":555,"name":"$self","containerName":"characters"},{"line":555,"kind":13,"containerName":"characters","name":"$data"},{"kind":13,"line":555,"containerName":"characters","name":"$data"},{"name":"$self","containerName":"characters","line":558,"kind":13},{"containerName":"characters","name":"$data","line":558,"kind":13}],"line":543},{"kind":12,"line":573,"children":[{"containerName":"_mode","definition":"my","name":"$self","localvar":"my","kind":13,"line":574},{"containerName":"_mode","name":"$value","kind":13,"line":574},{"containerName":"_mode","name":"$value","line":575,"kind":13},{"name":"$self","containerName":"_mode","line":576,"kind":13},{"line":576,"kind":13,"containerName":"_mode","name":"$value"},{"name":"$self","containerName":"_mode","kind":13,"line":578}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"_mode($self,$value)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"_mode","range":{"end":{"line":579,"character":9999},"start":{"line":573,"character":0}}},{"signature":{"label":"within_element($self,$name)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]},"detail":"($self,$name)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"within_element","localvar":"my","kind":13,"line":595},{"line":595,"kind":13,"name":"$name","containerName":"within_element"},{"name":"$name","containerName":"within_element","line":597,"kind":13},{"containerName":"within_element","name":"$self","kind":13,"line":597},{"line":598,"kind":13,"containerName":"within_element","name":"$self"}],"line":594,"kind":12,"range":{"end":{"character":9999,"line":598},"start":{"character":0,"line":594}},"name":"within_element"},{"name":"%self","containerName":null,"line":599,"kind":13},{"line":600,"kind":13,"name":"%name","containerName":null},{"kind":12,"children":[{"kind":13,"line":621,"name":"$self","definition":"my","containerName":"in_element","localvar":"my"},{"kind":13,"line":621,"containerName":"in_element","name":"$name"},{"line":622,"kind":13,"name":"$self","containerName":"in_element"},{"name":"$self","containerName":"in_element","kind":13,"line":623},{"line":623,"kind":13,"name":"$name","containerName":"in_element"}],"line":620,"definition":"sub","containerName":"main::","signature":{"label":"in_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name "},"detail":"($self,$name)","name":"in_element","range":{"start":{"character":0,"line":620},"end":{"line":624,"character":9999}}},{"range":{"end":{"line":644,"character":9999},"start":{"line":637,"character":0}},"name":"start_document","line":637,"children":[{"kind":13,"line":638,"containerName":"start_document","definition":"my","name":"$self","localvar":"my"},{"containerName":"start_document","name":"$self","line":639,"kind":13},{"name":"$self","containerName":"start_document","kind":13,"line":640},{"kind":13,"line":641,"containerName":"start_document","name":"$self"},{"line":642,"kind":13,"name":"$self","containerName":"start_document"},{"containerName":"start_document","name":"$self","kind":13,"line":643}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","label":"start_document($self)"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":660},"start":{"line":657,"character":0}},"name":"end_document","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"end_document","line":658,"kind":13},{"containerName":"end_document","name":"@args","kind":13,"line":658},{"line":659,"kind":13,"containerName":"end_document","name":"$self"}],"line":657,"kind":12,"signature":{"label":"end_document($self,@args)","documentation":"1;\n# $Id: psl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::psl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::psl - A parser for PSL output (UCSC)\n\n=head1 SYNOPSIS\n\n  use Bio::SearchIO;\n  my $parser = Bio::SearchIO->new(-file   => 'file.psl',\n                                 -format => 'psl');\n  while( my $result = $parser->next_result ) {\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO driver for PSL format.\nPSL format is documented here:\nhttp://genome.ucsc.edu/goldenPath/help/customTrack.html#PSL\n\nBy default it assumes PSL output came from BLAT you can override that\nby specifying -program_name =E<gt> 'BLASTZ' when initializing the\nSearchIO object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::psl;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_WRITER_CLASS $DefaultProgramName);\n\nuse strict;\nuse Bio::Search::HSP::HSPFactory;\nuse Bio::Search::Hit::HitFactory;\nuse Bio::Search::Result::ResultFactory;\n\n$DefaultProgramName   = 'BLAT';\n$DEFAULT_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n\n# mapping of terms to Bioperl hash keys\n%MODEMAP = (\n    'PSLOutput' => 'result',\n    'Result'    => 'result',\n    'Hit'       => 'hit',\n    'Hsp'       => 'hsp'\n);\n\n%MAPPING = (\n    'Hsp_bit-score'   => 'HSP-bits',\n    'Hsp_score'       => 'HSP-score',\n    'Hsp_evalue'      => 'HSP-evalue',\n    'Hsp_query-from'  => 'HSP-query_start',\n    'Hsp_query-to'    => 'HSP-query_end',\n    'Hsp_hit-from'    => 'HSP-hit_start',\n    'Hsp_hit-to'      => 'HSP-hit_end',\n    'Hsp_positive'    => 'HSP-conserved',\n    'Hsp_identity'    => 'HSP-identical',\n    'Hsp_mismatches'  => 'HSP-mismatches',\n    'Hsp_qgapblocks'  => 'HSP-query_gapblocks',\n    'Hsp_hgapblocks'  => 'HSP-hit_gapblocks',\n    'Hsp_gaps'        => 'HSP-hsp_gaps',\n    'Hsp_hitgaps'     => 'HSP-hit_gaps',\n    'Hsp_querygaps'   => 'HSP-query_gaps',\n    'Hsp_align-len'   => 'HSP-hsp_length',\n    'Hsp_query-frame' => 'HSP-query_frame',\n    'Hsp_hit-frame'   => 'HSP-hit_frame',\n\n    'Hit_id'        => 'HIT-name',\n    'Hit_len'       => 'HIT-length',\n    'Hit_accession' => 'HIT-accession',\n    'Hit_def'       => 'HIT-description',\n    'Hit_signif'    => 'HIT-significance',\n    'Hit_score'     => 'HIT-score',\n    'Hit_bits'      => 'HIT-bits',\n\n    'PSLOutput_program'   => 'RESULT-algorithm_name',\n    'PSLOutput_version'   => 'RESULT-algorithm_version',\n    'PSLOutput_query-def' => 'RESULT-query_name',\n    'PSLOutput_query-len' => 'RESULT-query_length',\n    'PSLOutput_query-acc' => 'RESULT-query_accession',\n    'PSLOutput_querydesc' => 'RESULT-query_description',\n    'PSLOutput_db'        => 'RESULT-database_name',\n    'PSLOutput_db-len'    => 'RESULT-database_entries',\n    'PSLOutput_db-let'    => 'RESULT-database_letters',\n);\n\nuse base qw(Bio::SearchIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::psl->new();\n Function: Builds a new Bio::SearchIO::psl object \n Returns : an instance of Bio::SearchIO::psl\n Args    :\n\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($pname) = $self->_rearrange( [qw(PROGRAM_NAME)], @args );\n    $self->program_name( $pname || $DefaultProgramName );\n    $self->_eventHandler->register_factory(\n        'result',\n        Bio::Search::Result::ResultFactory->new(\n            -type => 'Bio::Search::Result::GenericResult'\n        )\n    );\n\n    $self->_eventHandler->register_factory(\n        'hit',\n        Bio::Search::Hit::HitFactory->new(\n            -type => 'Bio::Search::Hit::GenericHit'\n        )\n    );\n    $self->_eventHandler->register_factory(\n        'hsp',\n        Bio::Search::HSP::HSPFactory->new(\n            -type => 'Bio::Search::HSP::PSLHSP'\n        )\n    );\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $result = $parser->next_result\n Function: Parse the next result from the data stream\n Returns : L<Bio::Search::Result::ResultI> or undef if no more results\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    my ( $lastquery, $lasthit );\n    local $/ = \"\\n\";\n    local $_;\n\n    # skip over any header lines\n    while( defined($_ = $self->_readline) and ! /^\\d+\\s+\\d+\\s+/ ) {}\n    $self->_pushback($_);\n\n    # now start the main parsing loop\n    while ( defined( $_ = $self->_readline ) ) {\n        my (\n            $matches,      $mismatches,    $rep_matches,  $n_count,\n            $q_num_insert, $q_base_insert, $t_num_insert, $t_base_insert,\n            $strand,       $q_name,        $q_length,     $q_start,\n            $q_end,        $t_name,        $t_length,     $t_start,\n            $t_end,        $block_count,   $block_sizes,  $q_starts,\n            $t_starts\n        ) = split;\n\n        $q_length > 0 or $self->throw(\"parse error, invalid query length '$q_length'\");\n        my $score = sprintf( \"%.2f\",  100 * ( $matches + $mismatches + $rep_matches ) / $q_length );\n\n        # this is overall percent identity...\n        my $match_total  = $matches + $mismatches + $rep_matches;\n        $match_total > 0\n            or $self->throw(\"parse error, matches + mismatches + rep_matches must be > 0!\");\n        my $percent_id = sprintf(\"%.2f\", 100 * ( $matches + $rep_matches ) / $match_total );\n\n        # Remember Jim's code is 0 based\n        if ( defined $lastquery\n            && $lastquery ne $q_name )\n        {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->end_element( { 'Name' => 'PSLOutput' } );\n            $self->_pushback($_);\n            return $self->end_document;\n        }\n        elsif ( !defined $lastquery ) {\n            $self->{'_result_count'}++;\n            $self->start_element( { 'Name' => 'PSLOutput' } );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_program',\n                    'Data' => $self->program_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-def',\n                    'Data' => $q_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'PSLOutput_query-len',\n                    'Data' => $q_length\n                }\n            );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n        elsif ( $lasthit ne $t_name ) {\n            $self->end_element( { 'Name' => 'Hit' } );\n            $self->start_element( { 'Name' => 'Hit' } );\n            $self->element(\n                {\n                    'Name' => 'Hit_id',\n                    'Data' => $t_name\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_len',\n                    'Data' => $t_length\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hit_score',\n                    'Data' => $score\n                }\n            );\n        }\n\n        my $identical = $matches + $rep_matches;\n        $self->start_element( { 'Name' => 'Hsp' } );\n        $self->element(\n            {\n                'Name' => 'Hsp_score',\n                'Data' => $score\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_identity',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_positive',\n                'Data' => $identical\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_mismatches',\n                'Data' => $mismatches\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_gaps',\n                'Data' => $q_base_insert + $t_base_insert\n            }\n        );\n\n        # query gaps are the number of target inserts and vice-versa\n        $self->element(\n            {\n                'Name' => 'Hsp_querygaps',\n                'Data' => $t_base_insert\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hitgaps',\n                'Data' => $q_base_insert\n            }\n        );\n        if ( $strand eq '+' ) {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_end\n                }\n            );\n        }\n        else {\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-to',\n                    'Data' => $q_start + 1\n                }\n            );\n            $self->element(\n                {\n                    'Name' => 'Hsp_query-from',\n                    'Data' => $q_end\n                }\n            );\n        }\n        my $hsplen =\n          $q_base_insert +\n          $t_base_insert +\n          abs( $t_end - $t_start ) +\n          abs( $q_end - $q_start );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-from',\n                'Data' => $t_start + 1\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hit-to',\n                'Data' => $t_end\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_align-len',\n                'Data' => $hsplen\n            }\n        );\n\n        # cleanup trailing commas in some output\n        $block_sizes =~ s/\\,$//;\n        $q_starts    =~ s/\\,$//;\n        $t_starts    =~ s/\\,$//;\n        my @blocksizes = split( /,/, $block_sizes );    # block sizes\n        my @qstarts = split( /,/, $q_starts ); # starting position of each block\n                                               # in query\n        my @tstarts = split( /,/, $t_starts ); # starting position of each block\n                                               # in target\n        my ( @qgapblocks, @hgapblocks );\n\n        for ( my $i = 0 ; $i < $block_count ; $i++ ) {\n            if ( $strand eq '+' ) {\n                push @qgapblocks, [ $qstarts[$i] + 1, $blocksizes[$i] ];\n            }\n            else {\n                push @qgapblocks, [ $q_length - $qstarts[$i], $blocksizes[$i] ];\n            }\n            push @hgapblocks, [ $tstarts[$i] + 1, $blocksizes[$i] ];\n        }\n        $self->element(\n            {\n                'Name' => 'Hsp_qgapblocks',\n                'Data' => \\@qgapblocks\n            }\n        );\n        $self->element(\n            {\n                'Name' => 'Hsp_hgapblocks',\n                'Data' => \\@hgapblocks\n            }\n        );\n        $self->end_element( { 'Name' => 'Hsp' } );\n        $lastquery = $q_name;\n        $lasthit   = $t_name;\n    }\n    if ( defined $lasthit || defined $lastquery ) {\n        $self->end_element( { 'Name' => 'Hit' } );\n        $self->end_element( { 'Name' => 'Result' } );\n        return $self->end_document;\n    }\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n    if ( my $type = $MODEMAP{$nm} ) {\n        $self->_mode($type);\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'start_'.lc $type;\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( $nm eq 'PSLOutput' ) {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n        $self->{'_mode'}   = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : return value from the associated end_$type event handler\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    # Hsp are sort of weird, in that they end when another\n    # object begins so have to detect this in end_element for now\n\n    if ( my $type = $MODEMAP{$nm} ) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = 'end_'.lc $type;\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        shift @{ $self->{'_elements'} };\n\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->warn(\n            __PACKAGE__ . \"::end_element: unknown nm '$nm', ignoring\\n\" );\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'}    = $rc\n      if ( defined $nm\n        && defined $MODEMAP{$nm}\n        && $MODEMAP{$nm} eq 'result' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    $self->start_element($data);\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n\n    return unless ( defined $data->{'Data'} );\n    if ( $data->{'Data'} =~ /^\\s+$/ ) {\n        return unless $data->{'Name'} =~ /Hsp\\_(midline|qseq|hseq)/;\n    }\n\n    if (   $self->in_element('hsp')\n        && $data->{'Name'} =~ /Hsp\\_(qseq|hseq|midline)/ )\n    {\n\n        $self->{'_last_hspdata'}->{ $data->{'Name'} } .= $data->{'Data'};\n    }\n\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function: \n Example : \n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if (!defined $name && !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        if ( $_ eq $name ) {\n            return 1;\n        }\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_mode'}     = '';\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"name":"result_count","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":673},"end":{"line":676,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"result_count","line":674,"kind":13},{"name":"$self","containerName":"result_count","line":675,"kind":13}],"line":673},{"range":{"start":{"line":678,"character":0},"end":{"character":9999,"line":678}},"containerName":"main::","definition":"sub","name":"report_count","line":678,"children":[{"kind":12,"line":678,"containerName":"report_count","name":"result_count"}],"kind":12},{"children":[{"name":"$self","definition":"my","containerName":"program_name","localvar":"my","kind":13,"line":692},{"kind":13,"line":694,"containerName":"program_name","name":"$self"},{"name":"$self","containerName":"program_name","kind":13,"line":695},{"line":695,"kind":13,"name":"$DefaultProgramName","containerName":"program_name"}],"line":691,"kind":12,"range":{"start":{"character":0,"line":691},"end":{"character":9999,"line":696}},"definition":"sub","name":"program_name","containerName":"main::"}]}