{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":93},{"kind":13,"line":95,"containerName":"main::","definition":"our","name":"%MODEMAP"},{"kind":13,"line":101,"definition":"our","name":"%MAPPING","containerName":"main::"},{"kind":13,"line":141,"name":"$MINSCORE","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","definition":"my","name":"$DEFAULT_ALGORITHM","containerName":null,"line":142,"kind":13},{"line":143,"kind":13,"localvar":"my","definition":"my","name":"$DEFAULT_VERSION","containerName":null},{"line":145,"kind":13,"localvar":"my","definition":"my","name":"@VALID_SYMBOLS","containerName":null},{"kind":13,"line":146,"definition":"my","name":"%STRUCTURE_SYMBOLS","containerName":null,"localvar":"my"},{"name":"_initialize","range":{"start":{"line":173,"character":0},"end":{"character":9999,"line":229}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)","parameters":[{"label":"$self"},{"label":"@args"}]},"kind":12,"line":173,"children":[{"line":174,"kind":13,"localvar":"my","containerName":"_initialize","name":"$self","definition":"my"},{"line":174,"kind":13,"name":"@args","containerName":"_initialize"},{"kind":13,"line":175,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"@args","line":175,"kind":13},{"kind":13,"line":176,"containerName":"_initialize","definition":"my","name":"$model","localvar":"my"},{"kind":13,"line":176,"name":"$database","containerName":"_initialize"},{"line":176,"kind":13,"name":"$convert","containerName":"_initialize"},{"line":176,"kind":13,"name":"$symbols","containerName":"_initialize"},{"containerName":"_initialize","name":"$cutoff","kind":13,"line":176},{"kind":13,"line":177,"containerName":"_initialize","name":"$desc"},{"containerName":"_initialize","name":"$accession","line":177,"kind":13},{"containerName":"_initialize","name":"$algorithm","kind":13,"line":177},{"name":"$version","containerName":"_initialize","line":177,"kind":13},{"containerName":"_initialize","name":"$self","line":178,"kind":13},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":178},{"line":186,"kind":13,"containerName":"_initialize","name":"@args"},{"localvar":"my","containerName":"_initialize","name":"$handler","definition":"my","line":187,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":187},{"line":187,"kind":12,"containerName":"_initialize","name":"_eventHandler"},{"line":188,"kind":13,"containerName":"_initialize","name":"$handler"},{"line":188,"kind":12,"containerName":"_initialize","name":"register_factory"},{"kind":12,"line":190,"name":"new","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":193,"kind":13},{"containerName":"_initialize","name":"verbose","line":194,"kind":12},{"kind":13,"line":197,"name":"$handler","containerName":"_initialize"},{"line":197,"kind":12,"name":"register_factory","containerName":"_initialize"},{"kind":12,"line":199,"containerName":"_initialize","name":"new"},{"line":202,"kind":13,"name":"$self","containerName":"_initialize"},{"line":203,"kind":12,"containerName":"_initialize","name":"verbose"},{"kind":13,"line":206,"name":"$handler","containerName":"_initialize"},{"containerName":"_initialize","name":"register_factory","line":206,"kind":12},{"line":208,"kind":12,"name":"new","containerName":"_initialize"},{"line":211,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"verbose","kind":12,"line":212},{"containerName":"_initialize","name":"$model","line":215,"kind":13},{"line":215,"kind":13,"name":"$self","containerName":"_initialize"},{"line":215,"kind":12,"containerName":"_initialize","name":"model"},{"containerName":"_initialize","name":"$model","line":215,"kind":13},{"containerName":"_initialize","name":"$database","kind":13,"line":216},{"kind":13,"line":216,"containerName":"_initialize","name":"$self"},{"name":"database","containerName":"_initialize","line":216,"kind":12},{"line":216,"kind":13,"name":"$database","containerName":"_initialize"},{"containerName":"_initialize","name":"$accession","kind":13,"line":217},{"name":"$self","containerName":"_initialize","kind":13,"line":217},{"line":217,"kind":12,"name":"query_accession","containerName":"_initialize"},{"containerName":"_initialize","name":"$accession","line":217,"kind":13},{"containerName":"_initialize","name":"$convert","kind":13,"line":218},{"line":218,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"convert_meta","kind":12,"line":218},{"line":218,"kind":13,"name":"$convert","containerName":"_initialize"},{"line":219,"kind":13,"name":"$desc","containerName":"_initialize"},{"line":219,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"query_description","kind":12,"line":219},{"kind":13,"line":219,"containerName":"_initialize","name":"$desc"},{"name":"$version","containerName":"_initialize","line":221,"kind":13},{"kind":13,"line":221,"containerName":"_initialize","name":"$DEFAULT_VERSION"},{"kind":13,"line":222,"name":"$self","containerName":"_initialize"},{"line":222,"kind":12,"containerName":"_initialize","name":"version"},{"containerName":"_initialize","name":"$version","line":222,"kind":13},{"line":223,"kind":13,"name":"$symbols","containerName":"_initialize"},{"name":"%STRUCTURE_SYMBOLS","containerName":"_initialize","kind":13,"line":223},{"name":"$self","containerName":"_initialize","line":224,"kind":13},{"kind":12,"line":224,"name":"structure_symbols","containerName":"_initialize"},{"containerName":"_initialize","name":"$symbols","kind":13,"line":224},{"name":"$cutoff","containerName":"_initialize","kind":13,"line":225},{"containerName":"_initialize","name":"$MINSCORE","line":225,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":226},{"kind":12,"line":226,"name":"hsp_minscore","containerName":"_initialize"},{"name":"$cutoff","containerName":"_initialize","line":226,"kind":13},{"line":227,"kind":13,"containerName":"_initialize","name":"$algorithm"},{"name":"$DEFAULT_ALGORITHM","containerName":"_initialize","line":227,"kind":13},{"line":228,"kind":13,"name":"$self","containerName":"_initialize"},{"line":228,"kind":12,"containerName":"_initialize","name":"algorithm"},{"kind":13,"line":228,"name":"$algorithm","containerName":"_initialize"}]},{"name":"SUPER","containerName":"_initialize","line":175,"kind":12},{"containerName":"Factory::ObjectFactory","name":"Bio","line":190,"kind":12},{"name":"Bio","containerName":"Factory::ObjectFactory","kind":12,"line":199},{"containerName":"Factory::ObjectFactory","name":"Bio","line":208,"kind":12},{"name":"next_result","range":{"start":{"character":0,"line":241},"end":{"character":9999,"line":269}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"}],"label":"next_result($self)"},"kind":12,"line":241,"children":[{"line":242,"kind":13,"localvar":"my","containerName":"next_result","name":"$self","definition":"my"},{"kind":13,"line":243,"name":"$self","containerName":"next_result"},{"localvar":"my","containerName":"next_result","definition":"my","name":"$line","line":244,"kind":13},{"line":245,"kind":13,"containerName":"next_result","name":"$line"},{"containerName":"next_result","name":"$self","line":245,"kind":13},{"containerName":"next_result","name":"_readline","kind":12,"line":245},{"name":"$line","containerName":"next_result","kind":13,"line":247},{"name":"$line","containerName":"next_result","kind":13,"line":249},{"containerName":"next_result","name":"$self","kind":13,"line":250},{"name":"$line","containerName":"next_result","line":251,"kind":13},{"line":252,"kind":13,"name":"$self","containerName":"next_result"},{"kind":13,"line":254,"containerName":"next_result","name":"$self"},{"kind":13,"line":258,"containerName":"next_result","name":"$self"},{"line":258,"kind":12,"name":"_pushback","containerName":"next_result"},{"name":"$line","containerName":"next_result","line":258,"kind":13},{"name":"$self","containerName":"next_result","kind":13,"line":266},{"name":"$self","containerName":"next_result","kind":13,"line":266},{"containerName":"next_result","name":"_parse_latest","line":266,"kind":12},{"kind":13,"line":267,"name":"$self","containerName":"next_result"},{"name":"$self","containerName":"next_result","line":267,"kind":13},{"name":"_parse_pre","containerName":"next_result","kind":12,"line":267},{"name":"$self","containerName":"next_result","kind":13,"line":268},{"kind":12,"line":268,"containerName":"next_result","name":"_parse_old"}]},{"name":"start_element","range":{"end":{"character":9999,"line":294},"start":{"line":282,"character":0}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"start_element","localvar":"my","kind":13,"line":283},{"line":283,"kind":13,"containerName":"start_element","name":"$data"},{"line":286,"kind":13,"localvar":"my","name":"$nm","definition":"my","containerName":"start_element"},{"name":"$data","containerName":"start_element","kind":13,"line":286},{"kind":13,"line":287,"definition":"my","name":"$type","containerName":"start_element","localvar":"my"},{"kind":13,"line":287,"name":"$MODEMAP","containerName":"start_element"},{"kind":13,"line":287,"name":"$nm","containerName":"start_element"},{"name":"$type","containerName":"start_element","line":288,"kind":13},{"kind":13,"line":289,"containerName":"start_element","name":"$self"},{"containerName":"start_element","name":"_eventHandler","line":289,"kind":12},{"kind":12,"line":289,"containerName":"start_element","name":"will_handle"},{"line":289,"kind":13,"name":"$type","containerName":"start_element"},{"line":290,"kind":13,"localvar":"my","containerName":"start_element","name":"$func","definition":"my"},{"name":"$type","containerName":"start_element","kind":13,"line":290},{"kind":13,"line":291,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"_eventHandler","line":291,"kind":12},{"name":"$func","containerName":"start_element","kind":13,"line":291},{"line":291,"kind":13,"name":"$data","containerName":"start_element"},{"line":293,"kind":13,"containerName":"start_element","name":"$self"},{"containerName":"start_element","name":"$type","kind":13,"line":293}],"line":282,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"},"detail":"($self,$data)"},{"containerName":null,"name":"$type","kind":13,"line":296},{"kind":13,"line":296,"name":"%type","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":298},{"line":299,"kind":13,"name":"%self","containerName":null},{"name":"end_element","range":{"start":{"line":313,"character":0},"end":{"character":9999,"line":326}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"end_element($self,$data)"},"detail":"($self,$data)","kind":12,"children":[{"localvar":"my","containerName":"end_element","definition":"my","name":"$self","line":314,"kind":13},{"name":"$data","containerName":"end_element","kind":13,"line":314},{"containerName":"end_element","definition":"my","name":"$nm","localvar":"my","kind":13,"line":315},{"line":315,"kind":13,"containerName":"end_element","name":"$data"},{"kind":13,"line":316,"name":"$type","definition":"my","containerName":"end_element","localvar":"my"},{"containerName":"end_element","name":"$MODEMAP","line":316,"kind":13},{"containerName":"end_element","name":"$nm","kind":13,"line":316},{"localvar":"my","definition":"my","name":"$rc","containerName":"end_element","line":317,"kind":13},{"name":"$type","containerName":"end_element","line":319,"kind":13},{"kind":13,"line":320,"containerName":"end_element","name":"$self"},{"kind":12,"line":320,"name":"_eventHandler","containerName":"end_element"},{"name":"will_handle","containerName":"end_element","line":320,"kind":12},{"kind":13,"line":320,"containerName":"end_element","name":"$type"},{"localvar":"my","name":"$func","definition":"my","containerName":"end_element","line":321,"kind":13},{"name":"$type","containerName":"end_element","kind":13,"line":321},{"name":"$rc","containerName":"end_element","line":322,"kind":13},{"kind":13,"line":322,"containerName":"end_element","name":"$self"},{"name":"_eventHandler","containerName":"end_element","kind":12,"line":322},{"name":"$func","containerName":"end_element","kind":13,"line":322},{"name":"$self","containerName":"end_element","kind":13,"line":322},{"kind":13,"line":323,"containerName":"end_element","name":"$self"},{"line":325,"kind":13,"localvar":"my","definition":"my","name":"$lastelem","containerName":"end_element"},{"line":325,"kind":13,"name":"$self","containerName":"end_element"}],"line":313},{"name":"%MAPPING","containerName":null,"line":327,"kind":13},{"line":327,"kind":13,"name":"%nm","containerName":null},{"name":"%MAPPING","containerName":null,"line":328,"kind":13},{"containerName":null,"name":"%nm","line":328,"kind":13},{"line":329,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$key"},{"name":"%MAPPING","containerName":null,"line":329,"kind":13},{"line":329,"kind":13,"containerName":null,"name":"@nm"},{"name":"%self","containerName":null,"kind":13,"line":330},{"name":"%key","containerName":null,"kind":13,"line":330},{"containerName":null,"name":"%MAPPING","line":330,"kind":13},{"containerName":null,"name":"%nm","line":330,"kind":13},{"containerName":null,"name":"$key","kind":13,"line":330},{"name":"%self","containerName":null,"kind":13,"line":331},{"kind":13,"line":334,"name":"%self","containerName":null},{"line":334,"kind":13,"name":"%MAPPING","containerName":null},{"containerName":null,"name":"$nm","kind":13,"line":334},{"line":334,"kind":13,"name":"%self","containerName":null},{"kind":13,"line":338,"containerName":null,"name":"$self"},{"containerName":"main::","name":"debug","kind":12,"line":338},{"line":340,"kind":13,"name":"%self","containerName":null},{"line":342,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":342,"containerName":null,"name":"$rc"},{"containerName":null,"name":"$type","kind":13,"line":342},{"kind":13,"line":342,"containerName":null,"name":"$type"},{"name":"$rc","containerName":null,"line":343,"kind":13},{"signature":{"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"element","definition":"my","name":"$self","line":357,"kind":13},{"containerName":"element","name":"$data","line":357,"kind":13},{"line":359,"kind":13,"containerName":"element","name":"$self"},{"containerName":"element","name":"characters","kind":12,"line":359},{"name":"$data","containerName":"element","kind":13,"line":359},{"name":"$self","containerName":"element","kind":13,"line":360},{"containerName":"element","name":"end_element","line":360,"kind":12},{"line":360,"kind":13,"name":"$data","containerName":"element"}],"line":356,"kind":12,"range":{"start":{"line":356,"character":0},"end":{"character":9999,"line":361}},"name":"element"},{"range":{"start":{"line":376,"character":0},"end":{"line":379,"character":9999}},"name":"element_hash","signature":{"parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value","label":"element_hash($self,$data)"},"detail":"($self,$data)","definition":"sub","containerName":"main::","children":[{"line":377,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"element_hash"},{"containerName":"element_hash","name":"$data","kind":13,"line":377},{"name":"$self","containerName":"element_hash","line":378,"kind":13},{"containerName":"element_hash","name":"throw","kind":12,"line":378},{"containerName":"element_hash","name":"$data","line":378,"kind":13},{"kind":13,"line":378,"containerName":"element_hash","name":"$data"},{"kind":13,"line":379,"name":"$nm","definition":"my","containerName":"element_hash","localvar":"my"},{"containerName":"element_hash","name":"$data","kind":13,"line":379}],"line":376,"kind":12},{"line":380,"kind":13,"name":"%data","containerName":null},{"line":380,"kind":13,"name":"$nm","containerName":null},{"name":"%data","containerName":null,"line":380,"kind":13},{"kind":13,"line":380,"containerName":null,"name":"$nm"},{"containerName":null,"name":"%MAPPING","kind":13,"line":381},{"containerName":null,"name":"%nm","kind":13,"line":381},{"name":"%MAPPING","containerName":null,"kind":13,"line":382},{"kind":13,"line":382,"name":"%nm","containerName":null},{"line":383,"kind":13,"localvar":"my","definition":"my","name":"$key","containerName":null},{"containerName":null,"name":"%MAPPING","kind":13,"line":383},{"kind":13,"line":383,"containerName":null,"name":"@nm"},{"name":"%self","containerName":null,"kind":13,"line":384},{"containerName":null,"name":"%key","line":384,"kind":13},{"containerName":null,"name":"%MAPPING","kind":13,"line":384},{"name":"%nm","containerName":null,"line":384,"kind":13},{"line":384,"kind":13,"name":"$key","containerName":null},{"containerName":null,"name":"%data","kind":13,"line":385},{"line":385,"kind":13,"containerName":null,"name":"%nm"},{"kind":13,"line":388,"containerName":null,"name":"%self"},{"containerName":null,"name":"%MAPPING","kind":13,"line":388},{"containerName":null,"name":"$nm","line":388,"kind":13},{"kind":13,"line":388,"name":"%data","containerName":null},{"containerName":null,"name":"$nm","kind":13,"line":388},{"children":[{"name":"$self","definition":"my","containerName":"characters","localvar":"my","kind":13,"line":406},{"containerName":"characters","name":"$data","kind":13,"line":406},{"name":"$data","containerName":"characters","kind":13,"line":407},{"line":407,"kind":13,"containerName":"characters","name":"$data"},{"name":"$self","containerName":"characters","kind":13,"line":408},{"name":"$data","containerName":"characters","line":408,"kind":13}],"line":405,"kind":12,"signature":{"label":"characters($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string"},"detail":"($self,$data)","definition":"sub","containerName":"main::","range":{"end":{"line":409,"character":9999},"start":{"character":0,"line":405}},"name":"characters"},{"name":"within_element","range":{"start":{"line":423,"character":0},"end":{"character":9999,"line":428}},"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name ","label":"within_element($self,$name)"},"kind":12,"line":423,"children":[{"kind":13,"line":424,"definition":"my","name":"$self","containerName":"within_element","localvar":"my"},{"name":"$name","containerName":"within_element","line":424,"kind":13},{"containerName":"within_element","name":"$name","kind":13,"line":427},{"line":427,"kind":13,"containerName":"within_element","name":"$self"},{"name":"$self","containerName":"within_element","kind":13,"line":428}]},{"line":429,"kind":13,"name":"%self","containerName":null},{"line":430,"kind":13,"containerName":null,"name":"$name"},{"name":"in_element","range":{"start":{"character":0,"line":447},"end":{"line":451,"character":9999}},"kind":12,"line":447,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"in_element","line":448,"kind":13},{"line":448,"kind":13,"containerName":"in_element","name":"$name"},{"containerName":"in_element","name":"$self","kind":13,"line":449},{"name":"$self","containerName":"in_element","line":450,"kind":13},{"kind":13,"line":450,"containerName":"in_element","name":"$name"}],"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name ","parameters":[{"label":"$self"},{"label":"$name"}]}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"start_document($self)","documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":463,"children":[{"localvar":"my","containerName":"start_document","definition":"my","name":"$self","line":464,"kind":13},{"name":"$self","containerName":"start_document","kind":13,"line":465},{"line":466,"kind":13,"containerName":"start_document","name":"$self"},{"name":"$self","containerName":"start_document","kind":13,"line":467},{"containerName":"start_document","name":"$self","kind":13,"line":468}],"name":"start_document","range":{"start":{"line":463,"character":0},"end":{"character":9999,"line":469}}},{"signature":{"label":"end_document($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":482,"containerName":"end_document","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"end_document","kind":13,"line":483}],"line":481,"kind":12,"range":{"end":{"character":9999,"line":484},"start":{"character":0,"line":481}},"name":"end_document"},{"range":{"start":{"line":496,"character":0},"end":{"line":499,"character":9999}},"containerName":"main::","definition":"sub","name":"result_count","line":496,"children":[{"containerName":"result_count","definition":"my","name":"$self","localvar":"my","kind":13,"line":497},{"name":"$self","containerName":"result_count","kind":13,"line":498}],"kind":12},{"range":{"end":{"character":9999,"line":516},"start":{"character":0,"line":512}},"definition":"sub","name":"model","containerName":"main::","children":[{"localvar":"my","containerName":"model","definition":"my","name":"$self","line":513,"kind":13},{"line":514,"kind":13,"name":"$self","containerName":"model"},{"name":"$self","containerName":"model","line":515,"kind":13}],"line":512,"kind":12},{"children":[{"localvar":"my","containerName":"database","definition":"my","name":"$self","line":530,"kind":13},{"containerName":"database","name":"$self","line":531,"kind":13},{"containerName":"database","name":"$self","line":532,"kind":13}],"line":529,"kind":12,"range":{"start":{"character":0,"line":529},"end":{"character":9999,"line":533}},"definition":"sub","name":"database","containerName":"main::"},{"children":[{"kind":13,"line":547,"containerName":"algorithm","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":548,"name":"$self","containerName":"algorithm"},{"line":549,"kind":13,"name":"$self","containerName":"algorithm"}],"line":546,"kind":12,"range":{"end":{"character":9999,"line":550},"start":{"character":0,"line":546}},"name":"algorithm","definition":"sub","containerName":"main::"},{"name":"query_accession","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":563},"end":{"line":567,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"query_accession","localvar":"my","kind":13,"line":564},{"containerName":"query_accession","name":"$self","kind":13,"line":565},{"name":"$self","containerName":"query_accession","line":566,"kind":13}],"line":563},{"range":{"start":{"character":0,"line":580},"end":{"line":584,"character":9999}},"definition":"sub","name":"query_description","containerName":"main::","children":[{"containerName":"query_description","definition":"my","name":"$self","localvar":"my","kind":13,"line":581},{"name":"$self","containerName":"query_description","line":582,"kind":13},{"line":583,"kind":13,"containerName":"query_description","name":"$self"}],"line":580,"kind":12},{"range":{"start":{"character":0,"line":596},"end":{"line":600,"character":9999}},"containerName":"main::","definition":"sub","name":"hsp_minscore","line":596,"children":[{"line":597,"kind":13,"localvar":"my","containerName":"hsp_minscore","name":"$self","definition":"my"},{"name":"$self","containerName":"hsp_minscore","line":598,"kind":13},{"line":599,"kind":13,"name":"$self","containerName":"hsp_minscore"}],"kind":12},{"name":"convert_meta","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":617},"start":{"character":0,"line":613}},"kind":12,"children":[{"localvar":"my","containerName":"convert_meta","name":"$self","definition":"my","line":614,"kind":13},{"containerName":"convert_meta","name":"$self","line":615,"kind":13},{"line":616,"kind":13,"name":"$self","containerName":"convert_meta"}],"line":613},{"kind":12,"children":[{"line":630,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"version"},{"line":631,"kind":13,"name":"$self","containerName":"version"},{"kind":13,"line":632,"name":"$self","containerName":"version"}],"line":629,"name":"version","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":629},"end":{"character":9999,"line":633}}},{"name":"structure_symbols","range":{"end":{"line":663,"character":9999},"start":{"character":0,"line":650}},"kind":12,"children":[{"kind":13,"line":651,"name":"$self","definition":"my","containerName":"structure_symbols","localvar":"my"},{"name":"$delim","containerName":"structure_symbols","line":651,"kind":13},{"containerName":"structure_symbols","name":"$delim","line":652,"kind":13},{"line":653,"kind":13,"containerName":"structure_symbols","name":"$delim"},{"kind":13,"line":654,"name":"%data","definition":"my","containerName":"structure_symbols","localvar":"my"},{"kind":13,"line":654,"containerName":"structure_symbols","name":"$delim"},{"containerName":"structure_symbols","definition":"my","name":"$d","localvar":"my","kind":13,"line":655},{"name":"@VALID_SYMBOLS","containerName":"structure_symbols","line":655,"kind":13},{"containerName":"structure_symbols","name":"$data","line":656,"kind":13},{"name":"$d","containerName":"structure_symbols","line":656,"kind":13},{"name":"$self","containerName":"structure_symbols","kind":13,"line":657},{"name":"$d","containerName":"structure_symbols","line":657,"kind":13},{"kind":13,"line":657,"name":"$data","containerName":"structure_symbols"},{"line":657,"kind":13,"containerName":"structure_symbols","name":"$d"},{"name":"$self","containerName":"structure_symbols","line":661,"kind":13},{"line":661,"kind":12,"name":"throw","containerName":"structure_symbols"}],"line":650,"definition":"sub","containerName":"main::","signature":{"label":"structure_symbols($self,$delim)","documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub model {\n    my $self = shift;\n    return $self->{'_model'} = shift if @_;\n    return $self->{'_model'};\n}\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $algorithm = $parser->algorithm();\n Function: Get/Set algorithm; current versions of Infernal do not output\n           the algorithm name\n Returns : String (algorithm name)\n Args    : [optional] String (algorithm name)\n\n\nsub algorithm {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; Infernal currently does not output\n           the accession number (Rfam accession #)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : my $acc = $parser->query_description();\n Function: Get/Set query (model) description; Infernal currently does not output\n           the Rfam description\n Returns : String (description)\n Args    : [optional] String (description)\n\n\nsub query_description {\n    my $self = shift;\n    return $self->{'_query_description'} = shift if @_;\n    return $self->{'_query_description'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min bit score cutoff (for generating Hits/HSPs)\n Returns : score (number)\n Args    : [optional] score (number)\n\n\nsub hsp_minscore {\n    my $self = shift;\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 convert_meta\n\n Title   : convert_meta\n Usage   : $parser->convert_meta(1);\n Function: Get/Set boolean flag for converting Infernal WUSS format\n           to a simple bracketed format (simple WUSS by default) \n Returns : boolean flag (TRUE or FALSE)\n Args    : [optional] boolean (eval's to TRUE or FALSE)\n\n\nsub convert_meta {\n    my $self = shift;\n    return $self->{'_convert_meta'} = shift if @_;\n    return $self->{'_convert_meta'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $parser->version();\n Function: Set the Infernal cmsearch version\n Returns : version\n Args    : [optional] version\n\n\nsub version {\n    my $self = shift;\n    return $self->{'_version'} = shift if @_;\n    return $self->{'_version'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     : (single-strand)\n                     ? (unknown)\n                     . (gap)\n Args    : Hash ref of substitute delimiters, using above keys.","parameters":[{"label":"$self"},{"label":"$delim"}]},"detail":"($self,$delim)"},{"name":"%self","containerName":null,"kind":13,"line":664},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"simple_meta","line":682,"kind":13},{"line":682,"kind":13,"name":"$str","containerName":"simple_meta"},{"kind":13,"line":683,"containerName":"simple_meta","name":"$self"},{"containerName":"simple_meta","name":"throw","line":683,"kind":12},{"kind":13,"line":683,"name":"$str","containerName":"simple_meta"},{"containerName":"simple_meta","name":"$structs","definition":"my","localvar":"my","kind":13,"line":684},{"containerName":"simple_meta","name":"$self","kind":13,"line":684},{"name":"structure_symbols","containerName":"simple_meta","kind":12,"line":684},{"definition":"my","name":"$ls","containerName":"simple_meta","localvar":"my","kind":13,"line":685},{"line":685,"kind":13,"name":"$rs","containerName":"simple_meta"},{"containerName":"simple_meta","name":"$ss","line":685,"kind":13},{"line":685,"kind":13,"containerName":"simple_meta","name":"$unk"},{"kind":13,"line":685,"containerName":"simple_meta","name":"$gap"},{"containerName":"simple_meta","name":"$structs","kind":13,"line":685},{"name":"$structs","containerName":"simple_meta","line":685,"kind":13},{"kind":13,"line":686,"name":"$structs","containerName":"simple_meta"},{"name":"$structs","containerName":"simple_meta","kind":13,"line":686},{"containerName":"simple_meta","name":"$structs","kind":13,"line":687},{"line":688,"kind":13,"name":"$str","containerName":"simple_meta"},{"kind":13,"line":689,"name":"$str","containerName":"simple_meta"},{"line":690,"kind":13,"name":"$str","containerName":"simple_meta"},{"containerName":"simple_meta","name":"$str","line":691,"kind":13},{"line":693,"kind":13,"containerName":"simple_meta","name":"$str"}],"line":681,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$str"}],"documentation":"1;\n# $Id: infernal.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::infernal\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields-at-uiuc-dot-edu>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::infernal - SearchIO-based Infernal parser\n\n=head1 SYNOPSIS\n\n  my $parser = Bio::SearchIO->new(-format => 'infernal',\n                                  -file => 'purine.inf');\n  while( my $result = $parser->next_result ) {\n        # general result info, such as model used, Infernal version\n        while( my $hit = $result->next_hit ) {\n            while( my $hsp = $hit->next_hsp ) {\n                # ...\n            }\n        }\n  }\n\n=head1 DESCRIPTION\n\nThis is a SearchIO-based parser for Infernal output from the cmsearch program.\nIt currently parses cmsearch output for Infernal versions 0.7-1.0; older\nversions may work but will not be supported.\n\nAs the first stable version has been released (and output has stabilized) it is\nhighly recommended that users upgrade to using the latest Infernal release.\nSupport for the older pre-v.1 developer releases will be dropped for future core\n1.6 releases. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields-at-uiuc-dot-edu\n\n=head1 CONTRIBUTORS\n\n  Jeffrey Barrick, Michigan State University\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::infernal;\nuse strict;\n\nuse Data::Dumper;\nuse base qw(Bio::SearchIO);\n\nour %MODEMAP = (\n\t    'Result'             => 'result',\n\t    'Hit'                => 'hit',\n\t    'Hsp'                => 'hsp'\n\t    );\n\nour %MAPPING = ( \n        'Hsp_bit-score'   => 'HSP-bits',\n        'Hsp_score'       => 'HSP-score',\n        'Hsp_evalue'      => 'HSP-evalue', # evalues only in v0.81, optional\n        'Hsp_pvalue'      => 'HSP-pvalue', # pvalues only in v0.81, optional\n        'Hsp_query-from'  => 'HSP-query_start',\n        'Hsp_query-to'    => 'HSP-query_end',\n        'Hsp_hit-from'    => 'HSP-hit_start', \n        'Hsp_hit-to'      => 'HSP-hit_end', \n        'Hsp_gaps'        => 'HSP-hsp_gaps', \n        'Hsp_hitgaps'     => 'HSP-hit_gaps',\n        'Hsp_querygaps'   => 'HSP-query_gaps',\n        'Hsp_qseq'        => 'HSP-query_seq',\n        'Hsp_hseq'        => 'HSP-hit_seq',\n        'Hsp_midline'     => 'HSP-homology_seq',\n        'Hsp_structure'   => 'HSP-meta',\n        'Hsp_align-len'   => 'HSP-hsp_length',\n        'Hsp_stranded'    => 'HSP-stranded',\n        \n        'Hit_id'        => 'HIT-name',\n        'Hit_len'       => 'HIT-length',\n        'Hit_gi'        => 'HIT-ncbi_gi',\n        'Hit_accession' => 'HIT-accession',\n        'Hit_def'       => 'HIT-description',\n        'Hit_signif'    => 'HIT-significance', # evalues only in v0.81, optional\n        'Hit_p'         => 'HIT-p',            # pvalues in 1.0, optional\n        'Hit_score'     => 'HIT-score', # best HSP bit score\n        'Hit_bits'      => 'HIT-bits', # best HSP bit score\n \n        'Infernal_program'  => 'RESULT-algorithm_name', # get/set \n        'Infernal_version'  => 'RESULT-algorithm_version', # get/set \n        'Infernal_query-def'=> 'RESULT-query_name', # get/set \n        'Infernal_query-len'=> 'RESULT-query_length', \n        'Infernal_query-acc'=> 'RESULT-query_accession', # get/set \n        'Infernal_querydesc'=> 'RESULT-query_description', # get/set\n        'Infernal_db'       => 'RESULT-database_name',  # get/set \n        'Infernal_db-len'   => 'RESULT-database_entries', # none yet\n        'Infernal_db-let'   => 'RESULT-database_letters', # none yet\n\t     );\n\nmy $MINSCORE = 0;\nmy $DEFAULT_ALGORITHM = 'cmsearch';\nmy $DEFAULT_VERSION = '1.0';\n\nmy @VALID_SYMBOLS = qw(5-prime 3-prime single-strand unknown gap);\nmy %STRUCTURE_SYMBOLS = (\n                   '5-prime'        => '<',\n                   '3-prime'        => '>',\n                   'single-strand'  => ':',\n                   'unknown'        => '?',\n                   'gap'            => '.'\n                   );\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::infernal->new();\n Function: Builds a new Bio::SearchIO::infernal object \n Returns : Bio::SearchIO::infernal\n Args    : -fh/-file      => cmsearch (infernal) filename\n           -format        => 'infernal'\n           -model         => query model (Rfam ID) (default undef)\n           -database      => database name (default undef)\n           -query_acc     => query accession, eg. Rfam accession RF####\n           -query_desc    => query description, eg. Rfam description\n           -hsp_minscore  => minimum HSP score cutoff\n           -convert_meta  => boolean, set to convert meta string to simple WUSS format\n           -symbols       => hash ref of structure symbols to use\n                             (default symbols in %STRUCTURE_SYMBOLS hash)\n\n\nsub _initialize {\n    my ( $self, @args ) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($model, $database, $convert, $symbols, $cutoff,\n        $desc, $accession, $algorithm, $version) =\n        $self->_rearrange([qw(MODEL\n                          DATABASE\n                          CONVERT_META\n                          SYMBOLS\n                          HSP_MINSCORE\n                          QUERY_DESC\n                          QUERY_ACC\n                          ALGORITHM\n                          VERSION)],@args);\n    my $handler = $self->_eventHandler;\n    $handler->register_factory(\n        'result',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Result::GenericResult',\n            -interface => 'Bio::Search::Result::ResultI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hit',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::Hit::ModelHit',\n            -interface => 'Bio::Search::Hit::HitI',\n            -verbose   => $self->verbose\n        )\n    );\n\n    $handler->register_factory(\n        'hsp',\n        Bio::Factory::ObjectFactory->new(\n            -type      => 'Bio::Search::HSP::ModelHSP',\n            -interface => 'Bio::Search::HSP::HSPI',\n            -verbose   => $self->verbose\n        )\n    );\n\t\n    defined $model     && $self->model($model);\n    defined $database  && $self->database($database);\n    defined $accession && $self->query_accession($accession);\n    defined $convert   && $self->convert_meta($convert);\n    defined $desc      && $self->query_description($desc);\n    \n    $version ||= $DEFAULT_VERSION;\n    $self->version($version);\n    $symbols ||= \\%STRUCTURE_SYMBOLS;\n    $self->structure_symbols($symbols);\n    $cutoff ||= $MINSCORE;\n    $self->hsp_minscore($cutoff);\n    $algorithm ||= $DEFAULT_ALGORITHM;\n    $self->algorithm($algorithm);\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    unless (exists $self->{'_handlerset'}) {\n        my $line;\n        while ($line = $self->_readline) {\n            # advance to first line\n            next if $line =~ m{^\\s*$};\n            # newer output starts with model name\n            if ($line =~ m{^\\#\\s+cmsearch\\s}) {\n                $self->{'_handlerset'} = 'latest';\n\t\t\t} elsif ($line =~ m{^CM\\s\\d+:}) {\n                $self->{'_handlerset'} = 'pre-1.0';\n            } else {\n                $self->{'_handlerset'} ='old';\n            }\n            last;\n        }\n        $self->_pushback($line);\n\t\t#if ($self->{'_handlerset'} ne '1.0') {\n\t\t#\t$self->deprecated(\n\t\t#\t-message => \"Parsing of Infernal pre-1.0 release is deprecated;\\n\".\n\t\t#\t\t\"upgrading to Infernal 1.0 or above is highly recommended\",\n\t\t#\t-version => 1.007);\n\t\t#}\n    }\n    return ($self->{'_handlerset'} eq 'latest')  ? $self->_parse_latest :\n\t\t   ($self->{'_handlerset'} eq 'pre-1.0') ? $self->_parse_pre :\n\t\t\t$self->_parse_old;\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element {\n    my ( $self, $data ) = @_;\n\n    # we currently don't care about attributes\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"start_%s\", lc $type );\n            $self->_eventHandler->$func( $data->{'Attributes'} );\n        }\n        unshift @{ $self->{'_elements'} }, $type;\n    }\n    if ( defined $type\n        && $type eq 'result' )\n    {\n        $self->{'_values'} = {};\n        $self->{'_result'} = undef;\n    }\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys, 'Data' and 'Name'\n\n\nsub end_element {\n    my ( $self, $data ) = @_;\n    my $nm   = $data->{'Name'};\n    my $type = $MODEMAP{$nm};\n    my $rc;\n\n    if ($type) {\n        if ( $self->_eventHandler->will_handle($type) ) {\n            my $func = sprintf( \"end_%s\", lc $type );\n            $rc = $self->_eventHandler->$func( $self->{'_reporttype'},\n                $self->{'_values'} );\n        }\n        my $lastelem = shift @{ $self->{'_elements'} };\n    }\n    elsif ( $MAPPING{$nm} ) {\n        if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n            my $key = ( keys %{ $MAPPING{$nm} } )[0];\n            $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n              $self->{'_last_data'};\n        }\n        else {\n            $self->{'_values'}->{ $MAPPING{$nm} } = $self->{'_last_data'};\n        }\n    }\n    else {\n        $self->debug(\"unknown nm $nm, ignoring\\n\");\n    }\n    $self->{'_last_data'} = '';    # remove read data if we are at\n                                   # end of an element\n    $self->{'_result'} = $rc if ( defined $type && $type eq 'result' );\n    return $rc;\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convenience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\nsub element {\n    my ( $self, $data ) = @_;\n    # simple data calls (%MAPPING) do not need start_element\n    $self->characters($data);\n    $self->end_element($data);\n}\n\n=head2 element_hash\n\n Title   : element\n Usage   : $eventhandler->element_hash({'Hsp_hit-from' => $start,\n                                        'Hsp_hit-to'   => $end,\n                                        'Hsp_score'    => $lastscore});\n Function: Convenience method that takes multiple simple data elements and\n           maps to appropriate parameters\n Returns : none\n Args    : Hash ref with the mapped key (in %MAPPING) and value\n\n\nsub element_hash {\n    my ($self, $data) = @_;\n    $self->throw(\"Must provide data hash ref\") if !$data || !ref($data);\n    for my $nm (sort keys %{$data}) {\n        next if $data->{$nm} && $data->{$nm} =~ m{^\\s*$}o;\n        if ( $MAPPING{$nm} ) {\n            if ( ref( $MAPPING{$nm} ) =~ /hash/i ) {\n                my $key = ( keys %{ $MAPPING{$nm} } )[0];\n                $self->{'_values'}->{$key}->{ $MAPPING{$nm}->{$key} } =\n                  $data->{$nm};\n            }\n            else {\n                $self->{'_values'}->{ $MAPPING{$nm} } = $data->{$nm};\n            }\n        }\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters {\n    my ( $self, $data ) = @_;\n    return unless ( defined $data->{'Data'} && $data->{'Data'} !~ /^\\s+$/o );\n    $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name \n\n\nsub within_element {\n    my ( $self, $name ) = @_;\n    return 0\n      if ( !defined $name\n        || !defined $self->{'_elements'}\n        || scalar @{ $self->{'_elements'} } == 0 );\n    foreach ( @{ $self->{'_elements'} } ) {\n        return 1 if ( $_ eq $name );\n    }\n    return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'within' because 'in' only \n           tests its immediate parent.\n Returns : boolean\n Args    : string element name \n\n\nsub in_element {\n    my ( $self, $name ) = @_;\n    return 0 if !defined $self->{'_elements'}->[0];\n    return ( $self->{'_elements'}->[0] eq $name );\n}\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handle a start document event\n Returns : none\n Args    : none\n\n\nsub start_document {\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'}   = {};\n    $self->{'_result'}   = undef;\n    $self->{'_elements'} = [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document {\n    my ($self) = @_;\n    return $self->{'_result'};\n}\n\n=head2 result_count\n\n Title   : result_count\n Usage   : my $count = $searchio->result_count\n Function: Returns the number of results we have processed\n Returns : integer\n Args    : none\n\n\nsub result_count {\n    my $self = shift;\n    return $self->{'_result_count'};\n}\n\n=head2 model\n\n Title   : model\n Usage   : my $model = $parser->model();\n Function: Get/Set model; Infernal currently does not output\n           the model name (Rfam ID)\n Returns : String (name of model)\n Args    : [optional] String (name of model)\n\n\nsub model {\n    my $self = shift;\n    return $self->{'_model'} = shift if @_;\n    return $self->{'_model'};\n}\n\n=head2 database\n\n Title   : database\n Usage   : my $database = $parser->database();\n Function: Get/Set database; Infernal currently does not output\n           the database name\n Returns : String (database name)\n Args    : [optional] String (database name)\n\n\nsub database {\n    my $self = shift;\n    return $self->{'_database'} = shift if @_;\n    return $self->{'_database'};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $algorithm = $parser->algorithm();\n Function: Get/Set algorithm; current versions of Infernal do not output\n           the algorithm name\n Returns : String (algorithm name)\n Args    : [optional] String (algorithm name)\n\n\nsub algorithm {\n    my $self = shift;\n    return $self->{'_algorithm'} = shift if @_;\n    return $self->{'_algorithm'};\n}\n\n=head2 query_accession\n\n Title   : query_accession\n Usage   : my $acc = $parser->query_accession();\n Function: Get/Set query (model) accession; Infernal currently does not output\n           the accession number (Rfam accession #)\n Returns : String (accession)\n Args    : [optional] String (accession)\n\n\nsub query_accession {\n    my $self = shift;\n    return $self->{'_query_accession'} = shift if @_;\n    return $self->{'_query_accession'};\n}\n\n=head2 query_description\n\n Title   : query_description\n Usage   : my $acc = $parser->query_description();\n Function: Get/Set query (model) description; Infernal currently does not output\n           the Rfam description\n Returns : String (description)\n Args    : [optional] String (description)\n\n\nsub query_description {\n    my $self = shift;\n    return $self->{'_query_description'} = shift if @_;\n    return $self->{'_query_description'};\n}\n\n=head2 hsp_minscore\n\n Title   : hsp_minscore\n Usage   : my $cutoff = $parser->hsp_minscore();\n Function: Get/Set min bit score cutoff (for generating Hits/HSPs)\n Returns : score (number)\n Args    : [optional] score (number)\n\n\nsub hsp_minscore {\n    my $self = shift;\n    return $self->{'_hsp_minscore'} = shift if @_;\n    return $self->{'_hsp_minscore'};\n}\n\n=head2 convert_meta\n\n Title   : convert_meta\n Usage   : $parser->convert_meta(1);\n Function: Get/Set boolean flag for converting Infernal WUSS format\n           to a simple bracketed format (simple WUSS by default) \n Returns : boolean flag (TRUE or FALSE)\n Args    : [optional] boolean (eval's to TRUE or FALSE)\n\n\nsub convert_meta {\n    my $self = shift;\n    return $self->{'_convert_meta'} = shift if @_;\n    return $self->{'_convert_meta'};\n}\n\n=head2 version\n\n Title   : version\n Usage   : $parser->version();\n Function: Set the Infernal cmsearch version\n Returns : version\n Args    : [optional] version\n\n\nsub version {\n    my $self = shift;\n    return $self->{'_version'} = shift if @_;\n    return $self->{'_version'};\n}\n\n=head2 structure_symbols\n\n Title   : structure_symbols\n Usage   : my $hashref = $parser->structure_symbols();\n Function: Get/Set RNA structure symbols\n Returns : Hash ref of delimiters (5' stem, 3' stem, single-strand, etc)\n         : default = < (5-prime)\n                     > (3-prime)\n                     : (single-strand)\n                     ? (unknown)\n                     . (gap)\n Args    : Hash ref of substitute delimiters, using above keys.\n\n\nsub structure_symbols {\n    my ($self, $delim) = @_;\n    if ($delim) {\n        if (ref($delim) =~ m{HASH}) {\n            my %data = %{ $delim };\n            for my $d (@VALID_SYMBOLS) {\n                if ( exists $data{$d} ) {\n                    $self->{'_delimiter'}->{$d} = $data{$d};\n                }\n            }\n        } else {\n            $self->throw(\"Args to helix_delimiters() should be in a hash reference\");\n        }\n    }\n    return $self->{'_delimiter'};\n}\n\n=head2 simple_meta\n\n Title   : simple_meta\n Usage   : my $string = $parser->simple_meta($str);\n Function: converts more complex WUSS meta format into simple bracket format\n           using symbols defined in structure_symbols()\n Returns : converted string\n Args    : [required] string to convert\n Note    : This is a very simple conversion method to get simple bracketed\n           format from Infernal data.  If the convert_meta() flag is set,\n           this is the method used to convert the strings.","label":"simple_meta($self,$str)"},"detail":"($self,$str)","name":"simple_meta","range":{"end":{"character":9999,"line":694},"start":{"character":0,"line":681}}},{"range":{"start":{"line":701,"character":0},"end":{"line":895,"character":9999}},"name":"_parse_latest","children":[{"line":702,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_parse_latest"},{"localvar":"my","name":"$seentop","definition":"my","containerName":"_parse_latest","line":703,"kind":13},{"containerName":"_parse_latest","name":"$accession","definition":"my","localvar":"my","kind":13,"line":705},{"line":705,"kind":13,"containerName":"_parse_latest","name":"$description"},{"line":705,"kind":13,"name":"$self","containerName":"_parse_latest"},{"name":"query_accession","containerName":"_parse_latest","kind":12,"line":705},{"containerName":"_parse_latest","name":"$self","kind":13,"line":705},{"kind":12,"line":705,"containerName":"_parse_latest","name":"query_description"},{"containerName":"_parse_latest","name":"$maxscore","definition":"my","localvar":"my","kind":13,"line":706},{"containerName":"_parse_latest","name":"$mineval","line":706,"kind":13},{"line":706,"kind":13,"name":"$minpval","containerName":"_parse_latest"},{"kind":13,"line":707,"containerName":"_parse_latest","name":"$self"},{"line":707,"kind":12,"name":"start_document","containerName":"_parse_latest"},{"line":708,"kind":13,"localvar":"my","name":"$lasthit","definition":"my","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$lastscore","kind":13,"line":708},{"containerName":"_parse_latest","name":"$lasteval","kind":13,"line":708},{"kind":13,"line":708,"name":"$lastpval","containerName":"_parse_latest"},{"line":708,"kind":13,"containerName":"_parse_latest","name":"$laststart"},{"line":708,"kind":13,"containerName":"_parse_latest","name":"$lastend"},{"line":710,"kind":13,"localvar":"my","name":"$line","definition":"my","containerName":"_parse_latest"},{"name":"$self","containerName":"_parse_latest","kind":13,"line":710},{"line":710,"kind":12,"name":"_readline","containerName":"_parse_latest"},{"name":"$line","containerName":"_parse_latest","line":711,"kind":13},{"line":713,"kind":13,"name":"$line","containerName":"_parse_latest"},{"name":"$seentop","containerName":"_parse_latest","kind":13,"line":714},{"containerName":"_parse_latest","name":"$self","kind":13,"line":715},{"kind":12,"line":715,"name":"start_element","containerName":"_parse_latest"},{"kind":13,"line":716,"name":"$self","containerName":"_parse_latest"},{"name":"element_hash","containerName":"_parse_latest","kind":12,"line":716},{"line":720,"kind":13,"containerName":"_parse_latest","name":"$line"},{"name":"$self","containerName":"_parse_latest","line":721,"kind":13},{"containerName":"_parse_latest","name":"element_hash","kind":12,"line":721},{"kind":13,"line":725,"containerName":"_parse_latest","name":"$line"},{"kind":13,"line":726,"containerName":"_parse_latest","name":"$self"},{"name":"element_hash","containerName":"_parse_latest","kind":12,"line":726},{"name":"$line","containerName":"_parse_latest","kind":13,"line":730},{"containerName":"_parse_latest","name":"$self","kind":13,"line":732},{"containerName":"_parse_latest","name":"element_hash","line":732,"kind":12},{"containerName":"_parse_latest","name":"$line","line":736,"kind":13},{"line":740,"kind":13,"containerName":"_parse_latest","name":"$self"},{"kind":12,"line":740,"containerName":"_parse_latest","name":"element_hash"},{"name":"$accession","containerName":"_parse_latest","kind":13,"line":742},{"kind":13,"line":744,"name":"$description","containerName":"_parse_latest"},{"line":746,"kind":13,"name":"$line","containerName":"_parse_latest"},{"line":748,"kind":13,"containerName":"_parse_latest","name":"$self"},{"line":748,"kind":12,"containerName":"_parse_latest","name":"in_element"},{"name":"$self","containerName":"_parse_latest","kind":13,"line":749},{"kind":12,"line":749,"name":"element_hash","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$maxscore","line":749,"kind":13},{"containerName":"_parse_latest","name":"$maxscore","line":750,"kind":13},{"kind":13,"line":751,"name":"$maxscore","containerName":"_parse_latest"},{"name":"$minpval","containerName":"_parse_latest","kind":13,"line":751},{"name":"$mineval","containerName":"_parse_latest","kind":13,"line":751},{"name":"$self","containerName":"_parse_latest","kind":13,"line":752},{"line":752,"kind":12,"name":"end_element","containerName":"_parse_latest"},{"line":754,"kind":13,"name":"$lasthit","containerName":"_parse_latest"},{"kind":13,"line":756,"name":"$line","containerName":"_parse_latest"},{"kind":13,"line":762,"containerName":"_parse_latest","name":"$laststart"},{"containerName":"_parse_latest","name":"$lastend","line":762,"kind":13},{"line":764,"kind":13,"containerName":"_parse_latest","name":"$line"},{"line":771,"kind":13,"containerName":"_parse_latest","name":"$lastscore"},{"name":"$lasteval","containerName":"_parse_latest","kind":13,"line":771},{"kind":13,"line":771,"name":"$lastpval","containerName":"_parse_latest"},{"name":"$maxscore","containerName":"_parse_latest","line":773,"kind":13},{"kind":13,"line":773,"containerName":"_parse_latest","name":"$lastscore"},{"name":"$lasteval","containerName":"_parse_latest","kind":13,"line":774},{"line":774,"kind":13,"name":"$lastpval","containerName":"_parse_latest"},{"name":"$mineval","containerName":"_parse_latest","kind":13,"line":775},{"kind":13,"line":775,"containerName":"_parse_latest","name":"$lasteval"},{"line":776,"kind":13,"name":"$minpval","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$lastpval","kind":13,"line":776},{"line":777,"kind":13,"containerName":"_parse_latest","name":"$mineval"},{"line":777,"kind":13,"containerName":"_parse_latest","name":"$mineval"},{"kind":13,"line":777,"name":"$lasteval","containerName":"_parse_latest"},{"line":777,"kind":13,"name":"$lasteval","containerName":"_parse_latest"},{"kind":13,"line":778,"containerName":"_parse_latest","name":"$mineval"},{"line":779,"kind":13,"name":"$minpval","containerName":"_parse_latest"},{"line":779,"kind":13,"name":"$minpval","containerName":"_parse_latest"},{"kind":13,"line":779,"name":"$lastpval","containerName":"_parse_latest"},{"name":"$lastpval","containerName":"_parse_latest","kind":13,"line":779},{"name":"$minpval","containerName":"_parse_latest","line":780,"kind":13},{"line":782,"kind":13,"name":"$maxscore","containerName":"_parse_latest"},{"line":782,"kind":13,"containerName":"_parse_latest","name":"$maxscore"},{"containerName":"_parse_latest","name":"$lastscore","line":782,"kind":13},{"kind":13,"line":782,"name":"$lastscore","containerName":"_parse_latest"},{"kind":13,"line":783,"containerName":"_parse_latest","name":"$maxscore"},{"line":784,"kind":13,"containerName":"_parse_latest","name":"$self"},{"containerName":"_parse_latest","name":"within_element","kind":12,"line":784},{"localvar":"my","containerName":"_parse_latest","definition":"my","name":"$gi","line":785,"kind":13},{"containerName":"_parse_latest","name":"$acc","line":785,"kind":13},{"kind":13,"line":785,"containerName":"_parse_latest","name":"$ver"},{"kind":13,"line":785,"containerName":"_parse_latest","name":"$self"},{"name":"_get_seq_identifiers","containerName":"_parse_latest","kind":12,"line":785},{"line":785,"kind":13,"containerName":"_parse_latest","name":"$lasthit"},{"containerName":"_parse_latest","name":"$self","line":786,"kind":13},{"name":"start_element","containerName":"_parse_latest","line":786,"kind":12},{"name":"$self","containerName":"_parse_latest","line":787,"kind":13},{"kind":12,"line":787,"name":"element_hash","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$lasthit","line":788,"kind":13},{"kind":13,"line":789,"containerName":"_parse_latest","name":"$ver"},{"name":"$acc","containerName":"_parse_latest","kind":13,"line":790},{"line":790,"kind":13,"containerName":"_parse_latest","name":"$acc"},{"name":"$lasthit","containerName":"_parse_latest","kind":13,"line":790},{"containerName":"_parse_latest","name":"$gi","line":792,"kind":13},{"kind":13,"line":794,"containerName":"_parse_latest","name":"$self"},{"containerName":"_parse_latest","name":"in_element","line":794,"kind":12},{"containerName":"_parse_latest","name":"$self","kind":13,"line":795},{"line":795,"kind":12,"containerName":"_parse_latest","name":"start_element"},{"containerName":"_parse_latest","name":"$line","kind":13,"line":799},{"line":800,"kind":13,"containerName":"_parse_latest","name":"$self"},{"containerName":"_parse_latest","name":"_pushback","kind":12,"line":800},{"name":"$line","containerName":"_parse_latest","line":800,"kind":13},{"localvar":"my","name":"$offset","definition":"my","containerName":"_parse_latest","line":803,"kind":13},{"containerName":"_parse_latest","definition":"my","name":"$ct","localvar":"my","kind":13,"line":804},{"kind":13,"line":804,"name":"$strln","containerName":"_parse_latest"},{"kind":13,"line":805,"containerName":"_parse_latest","name":"$hsp","definition":"my","localvar":"my"},{"line":807,"kind":13,"localvar":"my","containerName":"_parse_latest","definition":"my","name":"%hsp_key"},{"name":"$line","containerName":"_parse_latest","line":812,"kind":13},{"line":812,"kind":13,"containerName":"_parse_latest","name":"$self"},{"line":812,"kind":12,"name":"_readline","containerName":"_parse_latest"},{"name":"$line","containerName":"_parse_latest","line":813,"kind":13},{"containerName":"_parse_latest","name":"$line","line":814,"kind":13},{"line":821,"kind":13,"containerName":"_parse_latest","name":"$line"},{"name":"$self","containerName":"_parse_latest","line":822,"kind":13},{"line":822,"kind":12,"name":"_pushback","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$line","kind":13,"line":822},{"definition":"my","name":"$iterator","containerName":"_parse_latest","localvar":"my","kind":13,"line":826},{"kind":13,"line":826,"name":"$ct","containerName":"_parse_latest"},{"name":"$strln","containerName":"_parse_latest","line":828,"kind":13},{"containerName":"_parse_latest","name":"$line","kind":13,"line":828},{"kind":13,"line":828,"containerName":"_parse_latest","name":"$iterator"},{"localvar":"my","containerName":"_parse_latest","definition":"my","name":"$data","line":831,"kind":13},{"kind":13,"line":831,"name":"$line","containerName":"_parse_latest"},{"name":"$offset","containerName":"_parse_latest","line":831,"kind":13},{"name":"$strln","containerName":"_parse_latest","line":831,"kind":13},{"name":"$offset","containerName":"_parse_latest","line":831,"kind":13},{"containerName":"_parse_latest","name":"$hsp","kind":13,"line":832},{"name":"$hsp_key","containerName":"_parse_latest","line":832,"kind":13},{"containerName":"_parse_latest","name":"$iterator","kind":13,"line":832},{"line":832,"kind":13,"containerName":"_parse_latest","name":"$data"},{"containerName":"_parse_latest","name":"$ct","line":834,"kind":13},{"containerName":"_parse_latest","name":"$self","kind":13,"line":840},{"line":840,"kind":12,"name":"in_element","containerName":"_parse_latest"},{"localvar":"my","containerName":"_parse_latest","name":"$strlen","definition":"my","line":846,"kind":13},{"kind":13,"line":849,"name":"$hsp","containerName":"_parse_latest"},{"kind":13,"line":850,"name":"$strlen","containerName":"_parse_latest"},{"kind":13,"line":853,"containerName":"_parse_latest","name":"$strlen"},{"containerName":"_parse_latest","name":"$hsp","line":853,"kind":13},{"kind":13,"line":855,"definition":"my","name":"$metastr","containerName":"_parse_latest","localvar":"my"},{"kind":13,"line":855,"containerName":"_parse_latest","name":"$self"},{"line":855,"kind":12,"name":"convert_meta","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$self","line":855,"kind":13},{"name":"simple_meta","containerName":"_parse_latest","line":855,"kind":12},{"containerName":"_parse_latest","name":"$hsp","kind":13,"line":855},{"kind":13,"line":856,"containerName":"_parse_latest","name":"$hsp"},{"line":857,"kind":13,"containerName":"_parse_latest","name":"$self"},{"kind":12,"line":857,"name":"element_hash","containerName":"_parse_latest"},{"name":"$hsp","containerName":"_parse_latest","kind":13,"line":859},{"name":"$hsp","containerName":"_parse_latest","line":860,"kind":13},{"line":861,"kind":13,"containerName":"_parse_latest","name":"$hsp"},{"line":862,"kind":13,"containerName":"_parse_latest","name":"$metastr"},{"containerName":"_parse_latest","name":"$strlen","line":864,"kind":13},{"name":"$strlen","containerName":"_parse_latest","kind":13,"line":865},{"kind":13,"line":866,"name":"$laststart","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$lastend","kind":13,"line":867},{"containerName":"_parse_latest","name":"$lastscore","kind":13,"line":868},{"containerName":"_parse_latest","name":"$lastscore","line":869,"kind":13},{"containerName":"_parse_latest","name":"$self","kind":13,"line":871},{"kind":12,"line":871,"containerName":"_parse_latest","name":"element_hash"},{"line":872,"kind":13,"name":"$lasteval","containerName":"_parse_latest"},{"kind":13,"line":873,"containerName":"_parse_latest","name":"$lastpval"},{"name":"$lasteval","containerName":"_parse_latest","line":874,"kind":13},{"line":874,"kind":13,"name":"$lastpval","containerName":"_parse_latest"},{"kind":13,"line":875,"name":"$self","containerName":"_parse_latest"},{"name":"end_element","containerName":"_parse_latest","line":875,"kind":12},{"containerName":"_parse_latest","name":"$line","line":878,"kind":13},{"containerName":"_parse_latest","name":"$self","kind":13,"line":879},{"line":879,"kind":12,"name":"within_element","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$seentop","line":879,"kind":13},{"line":880,"kind":13,"containerName":"_parse_latest","name":"$self"},{"name":"in_element","containerName":"_parse_latest","kind":12,"line":880},{"line":881,"kind":13,"name":"$self","containerName":"_parse_latest"},{"name":"element_hash","containerName":"_parse_latest","kind":12,"line":881},{"containerName":"_parse_latest","name":"$maxscore","kind":13,"line":881},{"name":"$maxscore","containerName":"_parse_latest","kind":13,"line":882},{"line":884,"kind":13,"containerName":"_parse_latest","name":"$self"},{"containerName":"_parse_latest","name":"element_hash","line":884,"kind":12},{"kind":13,"line":884,"containerName":"_parse_latest","name":"$mineval"},{"line":884,"kind":13,"name":"$mineval","containerName":"_parse_latest"},{"name":"$self","containerName":"_parse_latest","line":885,"kind":13},{"name":"element_hash","containerName":"_parse_latest","kind":12,"line":885},{"name":"$minpval","containerName":"_parse_latest","kind":13,"line":885},{"containerName":"_parse_latest","name":"$minpval","kind":13,"line":885},{"containerName":"_parse_latest","name":"$self","kind":13,"line":886},{"line":886,"kind":12,"name":"end_element","containerName":"_parse_latest"},{"line":892,"kind":13,"name":"$self","containerName":"_parse_latest"},{"name":"within_element","containerName":"_parse_latest","line":892,"kind":12},{"name":"$self","containerName":"_parse_latest","line":892,"kind":13},{"kind":12,"line":892,"name":"end_element","containerName":"_parse_latest"},{"containerName":"_parse_latest","name":"$self","kind":13,"line":893},{"name":"end_element","containerName":"_parse_latest","kind":12,"line":893},{"name":"$seentop","containerName":"_parse_latest","kind":13,"line":893},{"containerName":"_parse_latest","name":"$self","line":894,"kind":13},{"name":"end_document","containerName":"_parse_latest","kind":12,"line":894}],"line":701,"kind":12,"signature":{"documentation":"# private methods\n this is a hack which guesses the format and sets the handler for parsing in\n an instance; it'll be taken out when infernal 1.0 is released","parameters":[{"label":"$self"}],"label":"_parse_latest($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"PARSER","kind":12,"line":709},{"line":806,"kind":12,"name":"HSP"},{"name":"HSP","line":811,"kind":12},{"line":823,"kind":12,"name":"HSP"},{"kind":12,"line":888,"name":"PARSER"},{"name":"_parse_pre","range":{"end":{"line":1066,"character":9999},"start":{"line":898,"character":0}},"kind":12,"line":898,"children":[{"containerName":"_parse_pre","name":"$self","definition":"my","localvar":"my","kind":13,"line":899},{"kind":13,"line":900,"containerName":"_parse_pre","definition":"my","name":"$seentop","localvar":"my"},{"line":902,"kind":13,"localvar":"my","containerName":"_parse_pre","name":"$accession","definition":"my"},{"kind":13,"line":902,"containerName":"_parse_pre","name":"$db"},{"name":"$algorithm","containerName":"_parse_pre","line":902,"kind":13},{"line":902,"kind":13,"name":"$description","containerName":"_parse_pre"},{"name":"$version","containerName":"_parse_pre","line":902,"kind":13},{"name":"$self","containerName":"_parse_pre","line":903,"kind":13},{"line":903,"kind":12,"containerName":"_parse_pre","name":"query_accession"},{"name":"$self","containerName":"_parse_pre","line":903,"kind":13},{"line":903,"kind":12,"containerName":"_parse_pre","name":"database"},{"kind":13,"line":903,"containerName":"_parse_pre","name":"$self"},{"line":903,"kind":12,"name":"algorithm","containerName":"_parse_pre"},{"kind":13,"line":904,"name":"$self","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"query_description","kind":12,"line":904},{"localvar":"my","containerName":"_parse_pre","definition":"my","name":"$maxscore","line":905,"kind":13},{"name":"$mineval","containerName":"_parse_pre","line":905,"kind":13},{"line":905,"kind":13,"name":"$minpval","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"$self","kind":13,"line":906},{"name":"start_document","containerName":"_parse_pre","line":906,"kind":12},{"line":907,"kind":13,"localvar":"my","containerName":"_parse_pre","definition":"my","name":"$lasthit"},{"line":907,"kind":13,"name":"$lastscore","containerName":"_parse_pre"},{"name":"$lasteval","containerName":"_parse_pre","line":907,"kind":13},{"containerName":"_parse_pre","name":"$lastpval","line":907,"kind":13},{"kind":13,"line":907,"containerName":"_parse_pre","name":"$laststart"},{"line":907,"kind":13,"containerName":"_parse_pre","name":"$lastend"},{"kind":13,"line":909,"name":"$line","definition":"my","containerName":"_parse_pre","localvar":"my"},{"line":909,"kind":13,"containerName":"_parse_pre","name":"$self"},{"containerName":"_parse_pre","name":"_readline","kind":12,"line":909},{"name":"$line","containerName":"_parse_pre","kind":13,"line":910},{"containerName":"_parse_pre","name":"$line","kind":13,"line":912},{"line":914,"kind":13,"name":"$self","containerName":"_parse_pre"},{"kind":12,"line":914,"name":"within_element","containerName":"_parse_pre"},{"kind":13,"line":915,"containerName":"_parse_pre","name":"$seentop"},{"kind":13,"line":916,"containerName":"_parse_pre","name":"$self"},{"line":916,"kind":12,"containerName":"_parse_pre","name":"start_element"},{"name":"$self","containerName":"_parse_pre","line":917,"kind":13},{"containerName":"_parse_pre","name":"element_hash","line":917,"kind":12},{"containerName":"_parse_pre","name":"$algorithm","kind":13,"line":918},{"kind":13,"line":920,"containerName":"_parse_pre","name":"$accession"},{"kind":13,"line":921,"name":"$description","containerName":"_parse_pre"},{"line":923,"kind":13,"containerName":"_parse_pre","name":"$db"},{"line":925,"kind":13,"name":"$line","containerName":"_parse_pre"},{"line":927,"kind":13,"containerName":"_parse_pre","name":"$self"},{"containerName":"_parse_pre","name":"in_element","line":927,"kind":12},{"name":"$self","containerName":"_parse_pre","line":928,"kind":13},{"containerName":"_parse_pre","name":"element_hash","line":928,"kind":12},{"kind":13,"line":928,"name":"$maxscore","containerName":"_parse_pre"},{"line":929,"kind":13,"containerName":"_parse_pre","name":"$maxscore"},{"containerName":"_parse_pre","name":"$maxscore","kind":13,"line":930},{"kind":13,"line":930,"containerName":"_parse_pre","name":"$minpval"},{"kind":13,"line":930,"name":"$mineval","containerName":"_parse_pre"},{"line":931,"kind":13,"name":"$self","containerName":"_parse_pre"},{"name":"end_element","containerName":"_parse_pre","kind":12,"line":931},{"kind":13,"line":933,"name":"$lasthit","containerName":"_parse_pre"},{"name":"$line","containerName":"_parse_pre","line":935,"kind":13},{"line":941,"kind":13,"name":"$laststart","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"$lastend","line":941,"kind":13},{"name":"$line","containerName":"_parse_pre","kind":13,"line":943},{"containerName":"_parse_pre","name":"$lastscore","kind":13,"line":950},{"kind":13,"line":950,"containerName":"_parse_pre","name":"$lasteval"},{"containerName":"_parse_pre","name":"$lastpval","kind":13,"line":950},{"line":952,"kind":13,"containerName":"_parse_pre","name":"$maxscore"},{"kind":13,"line":952,"containerName":"_parse_pre","name":"$lastscore"},{"containerName":"_parse_pre","name":"$lasteval","line":953,"kind":13},{"kind":13,"line":953,"name":"$lastpval","containerName":"_parse_pre"},{"name":"$mineval","containerName":"_parse_pre","kind":13,"line":954},{"name":"$lasteval","containerName":"_parse_pre","kind":13,"line":954},{"name":"$minpval","containerName":"_parse_pre","kind":13,"line":955},{"kind":13,"line":955,"name":"$lastpval","containerName":"_parse_pre"},{"line":956,"kind":13,"containerName":"_parse_pre","name":"$mineval"},{"line":956,"kind":13,"containerName":"_parse_pre","name":"$mineval"},{"kind":13,"line":956,"containerName":"_parse_pre","name":"$lasteval"},{"containerName":"_parse_pre","name":"$lasteval","kind":13,"line":956},{"kind":13,"line":957,"name":"$mineval","containerName":"_parse_pre"},{"kind":13,"line":958,"containerName":"_parse_pre","name":"$minpval"},{"kind":13,"line":958,"name":"$minpval","containerName":"_parse_pre"},{"name":"$lastpval","containerName":"_parse_pre","kind":13,"line":958},{"containerName":"_parse_pre","name":"$lastpval","line":958,"kind":13},{"name":"$minpval","containerName":"_parse_pre","kind":13,"line":959},{"line":961,"kind":13,"name":"$maxscore","containerName":"_parse_pre"},{"line":961,"kind":13,"name":"$maxscore","containerName":"_parse_pre"},{"name":"$lastscore","containerName":"_parse_pre","line":961,"kind":13},{"containerName":"_parse_pre","name":"$lastscore","line":961,"kind":13},{"name":"$maxscore","containerName":"_parse_pre","line":962,"kind":13},{"containerName":"_parse_pre","name":"$self","line":963,"kind":13},{"line":963,"kind":12,"name":"within_element","containerName":"_parse_pre"},{"kind":13,"line":964,"definition":"my","name":"$gi","containerName":"_parse_pre","localvar":"my"},{"line":964,"kind":13,"containerName":"_parse_pre","name":"$acc"},{"kind":13,"line":964,"containerName":"_parse_pre","name":"$ver"},{"containerName":"_parse_pre","name":"$self","kind":13,"line":964},{"name":"_get_seq_identifiers","containerName":"_parse_pre","line":964,"kind":12},{"kind":13,"line":964,"containerName":"_parse_pre","name":"$lasthit"},{"kind":13,"line":965,"name":"$self","containerName":"_parse_pre"},{"line":965,"kind":12,"containerName":"_parse_pre","name":"start_element"},{"containerName":"_parse_pre","name":"$self","kind":13,"line":966},{"name":"element_hash","containerName":"_parse_pre","kind":12,"line":966},{"containerName":"_parse_pre","name":"$lasthit","line":967,"kind":13},{"name":"$ver","containerName":"_parse_pre","line":968,"kind":13},{"line":969,"kind":13,"name":"$acc","containerName":"_parse_pre"},{"kind":13,"line":969,"name":"$acc","containerName":"_parse_pre"},{"line":969,"kind":13,"name":"$lasthit","containerName":"_parse_pre"},{"name":"$gi","containerName":"_parse_pre","line":971,"kind":13},{"kind":13,"line":973,"containerName":"_parse_pre","name":"$self"},{"line":973,"kind":12,"containerName":"_parse_pre","name":"in_element"},{"name":"$self","containerName":"_parse_pre","kind":13,"line":974},{"name":"start_element","containerName":"_parse_pre","line":974,"kind":12},{"name":"$line","containerName":"_parse_pre","kind":13,"line":978},{"line":979,"kind":13,"name":"$self","containerName":"_parse_pre"},{"line":979,"kind":12,"containerName":"_parse_pre","name":"_pushback"},{"kind":13,"line":979,"name":"$line","containerName":"_parse_pre"},{"line":982,"kind":13,"localvar":"my","containerName":"_parse_pre","definition":"my","name":"$offset"},{"name":"$ct","definition":"my","containerName":"_parse_pre","localvar":"my","kind":13,"line":983},{"line":983,"kind":13,"name":"$strln","containerName":"_parse_pre"},{"line":984,"kind":13,"localvar":"my","containerName":"_parse_pre","name":"$hsp","definition":"my"},{"containerName":"_parse_pre","definition":"my","name":"%hsp_key","localvar":"my","kind":13,"line":986},{"kind":13,"line":991,"name":"$line","containerName":"_parse_pre"},{"kind":13,"line":991,"containerName":"_parse_pre","name":"$self"},{"containerName":"_parse_pre","name":"_readline","line":991,"kind":12},{"line":992,"kind":13,"name":"$line","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"$line","line":993,"kind":13},{"name":"$line","containerName":"_parse_pre","line":1000,"kind":13},{"name":"$self","containerName":"_parse_pre","kind":13,"line":1001},{"line":1001,"kind":12,"containerName":"_parse_pre","name":"_pushback"},{"name":"$line","containerName":"_parse_pre","line":1001,"kind":13},{"kind":13,"line":1005,"name":"$iterator","definition":"my","containerName":"_parse_pre","localvar":"my"},{"containerName":"_parse_pre","name":"$ct","line":1005,"kind":13},{"kind":13,"line":1005,"containerName":"_parse_pre","name":"%4"},{"containerName":"_parse_pre","name":"$strln","line":1007,"kind":13},{"kind":13,"line":1007,"containerName":"_parse_pre","name":"$line"},{"line":1007,"kind":13,"containerName":"_parse_pre","name":"$iterator"},{"name":"$data","definition":"my","containerName":"_parse_pre","localvar":"my","kind":13,"line":1010},{"containerName":"_parse_pre","name":"$line","line":1010,"kind":13},{"line":1010,"kind":13,"name":"$offset","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"$strln","kind":13,"line":1010},{"kind":13,"line":1010,"containerName":"_parse_pre","name":"$offset"},{"line":1011,"kind":13,"containerName":"_parse_pre","name":"$hsp"},{"kind":13,"line":1011,"containerName":"_parse_pre","name":"$hsp_key"},{"line":1011,"kind":13,"containerName":"_parse_pre","name":"$iterator"},{"line":1011,"kind":13,"containerName":"_parse_pre","name":"$data"},{"name":"$ct","containerName":"_parse_pre","kind":13,"line":1013},{"containerName":"_parse_pre","name":"$self","line":1019,"kind":13},{"line":1019,"kind":12,"name":"in_element","containerName":"_parse_pre"},{"line":1020,"kind":13,"localvar":"my","containerName":"_parse_pre","name":"$strlen","definition":"my"},{"name":"$hsp","containerName":"_parse_pre","line":1020,"kind":13},{"localvar":"my","definition":"my","name":"$metastr","containerName":"_parse_pre","line":1022,"kind":13},{"containerName":"_parse_pre","name":"$metastr","line":1023,"kind":13},{"name":"$self","containerName":"_parse_pre","kind":13,"line":1023},{"line":1023,"kind":12,"containerName":"_parse_pre","name":"convert_meta"},{"kind":13,"line":1023,"name":"$self","containerName":"_parse_pre"},{"containerName":"_parse_pre","name":"simple_meta","kind":12,"line":1023},{"kind":13,"line":1023,"containerName":"_parse_pre","name":"$hsp"},{"kind":13,"line":1024,"name":"$hsp","containerName":"_parse_pre"},{"name":"$self","containerName":"_parse_pre","kind":13,"line":1025},{"kind":12,"line":1025,"name":"element_hash","containerName":"_parse_pre"},{"name":"$hsp","containerName":"_parse_pre","kind":13,"line":1027},{"name":"$hsp","containerName":"_parse_pre","kind":13,"line":1028},{"containerName":"_parse_pre","name":"$hsp","line":1029,"kind":13},{"kind":13,"line":1030,"containerName":"_parse_pre","name":"$metastr"},{"containerName":"_parse_pre","name":"$strlen","line":1032,"kind":13},{"name":"$strlen","containerName":"_parse_pre","kind":13,"line":1033},{"name":"$laststart","containerName":"_parse_pre","kind":13,"line":1034},{"kind":13,"line":1035,"name":"$lastend","containerName":"_parse_pre"},{"kind":13,"line":1036,"containerName":"_parse_pre","name":"$lastscore"},{"name":"$lastscore","containerName":"_parse_pre","kind":13,"line":1037},{"name":"$self","containerName":"_parse_pre","kind":13,"line":1039},{"containerName":"_parse_pre","name":"element_hash","kind":12,"line":1039},{"kind":13,"line":1040,"containerName":"_parse_pre","name":"$lasteval"},{"name":"$lastpval","containerName":"_parse_pre","kind":13,"line":1041},{"name":"$lasteval","containerName":"_parse_pre","line":1042,"kind":13},{"line":1042,"kind":13,"name":"$lastpval","containerName":"_parse_pre"},{"name":"$self","containerName":"_parse_pre","line":1043,"kind":13},{"line":1043,"kind":12,"containerName":"_parse_pre","name":"end_element"},{"name":"$line","containerName":"_parse_pre","kind":13,"line":1046},{"line":1047,"kind":13,"name":"$self","containerName":"_parse_pre"},{"line":1047,"kind":12,"containerName":"_parse_pre","name":"within_element"},{"line":1047,"kind":13,"containerName":"_parse_pre","name":"$seentop"},{"kind":13,"line":1048,"containerName":"_parse_pre","name":"$self"},{"name":"element","containerName":"_parse_pre","line":1048,"kind":12},{"line":1050,"kind":13,"containerName":"_parse_pre","name":"$version"},{"name":"$self","containerName":"_parse_pre","line":1052,"kind":13},{"line":1052,"kind":12,"name":"in_element","containerName":"_parse_pre"},{"line":1053,"kind":13,"containerName":"_parse_pre","name":"$self"},{"kind":12,"line":1053,"name":"element_hash","containerName":"_parse_pre"},{"name":"$maxscore","containerName":"_parse_pre","kind":13,"line":1053},{"name":"$maxscore","containerName":"_parse_pre","line":1054,"kind":13},{"containerName":"_parse_pre","name":"$self","kind":13,"line":1056},{"containerName":"_parse_pre","name":"element_hash","line":1056,"kind":12},{"name":"$mineval","containerName":"_parse_pre","kind":13,"line":1056},{"name":"$mineval","containerName":"_parse_pre","kind":13,"line":1056},{"line":1057,"kind":13,"name":"$self","containerName":"_parse_pre"},{"line":1057,"kind":12,"containerName":"_parse_pre","name":"end_element"},{"name":"$self","containerName":"_parse_pre","kind":13,"line":1063},{"line":1063,"kind":12,"name":"within_element","containerName":"_parse_pre"},{"kind":13,"line":1063,"name":"$self","containerName":"_parse_pre"},{"line":1063,"kind":12,"name":"end_element","containerName":"_parse_pre"},{"line":1064,"kind":13,"containerName":"_parse_pre","name":"$self"},{"line":1064,"kind":12,"containerName":"_parse_pre","name":"end_element"},{"name":"$seentop","containerName":"_parse_pre","line":1064,"kind":13},{"name":"$self","containerName":"_parse_pre","line":1065,"kind":13},{"kind":12,"line":1065,"name":"end_document","containerName":"_parse_pre"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"_parse_pre($self)","documentation":" cmsearch 0.81 (pre-1.0)","parameters":[{"label":"$self"}]}},{"name":"PARSER","line":908,"kind":12},{"line":985,"kind":12,"name":"HSP"},{"kind":12,"line":990,"name":"HSP"},{"kind":12,"line":1002,"name":"HSP"},{"line":1059,"kind":12,"name":"PARSER"},{"range":{"start":{"character":0,"line":1069},"end":{"character":9999,"line":1203}},"name":"_parse_old","children":[{"localvar":"my","containerName":"_parse_old","definition":"my","name":"$self","line":1070,"kind":13},{"kind":13,"line":1071,"definition":"my","name":"$seentop","containerName":"_parse_old","localvar":"my"},{"localvar":"my","name":"$accession","definition":"my","containerName":"_parse_old","line":1073,"kind":13},{"containerName":"_parse_old","name":"$db","line":1073,"kind":13},{"name":"$algorithm","containerName":"_parse_old","line":1073,"kind":13},{"containerName":"_parse_old","name":"$model","line":1073,"kind":13},{"line":1073,"kind":13,"name":"$description","containerName":"_parse_old"},{"line":1073,"kind":13,"containerName":"_parse_old","name":"$version"},{"kind":13,"line":1074,"containerName":"_parse_old","name":"$self"},{"name":"query_accession","containerName":"_parse_old","kind":12,"line":1074},{"name":"$self","containerName":"_parse_old","kind":13,"line":1074},{"name":"database","containerName":"_parse_old","kind":12,"line":1074},{"containerName":"_parse_old","name":"$self","kind":13,"line":1074},{"kind":12,"line":1074,"name":"algorithm","containerName":"_parse_old"},{"containerName":"_parse_old","name":"$self","kind":13,"line":1075},{"name":"model","containerName":"_parse_old","line":1075,"kind":12},{"name":"$self","containerName":"_parse_old","kind":13,"line":1075},{"name":"query_description","containerName":"_parse_old","line":1075,"kind":12},{"name":"$self","containerName":"_parse_old","line":1075,"kind":13},{"containerName":"_parse_old","name":"version","line":1075,"kind":12},{"kind":13,"line":1076,"containerName":"_parse_old","name":"$maxscore","definition":"my","localvar":"my"},{"line":1077,"kind":13,"localvar":"my","name":"$cutoff","definition":"my","containerName":"_parse_old"},{"line":1077,"kind":13,"name":"$self","containerName":"_parse_old"},{"kind":12,"line":1077,"containerName":"_parse_old","name":"hsp_minscore"},{"kind":13,"line":1078,"containerName":"_parse_old","name":"$self"},{"containerName":"_parse_old","name":"start_document","line":1078,"kind":12},{"definition":"my","name":"$line","containerName":"_parse_old","localvar":"my","kind":13,"line":1080},{"kind":13,"line":1081,"containerName":"_parse_old","definition":"my","name":"$lasthit","localvar":"my"},{"containerName":"_parse_old","name":"$lastscore","line":1081,"kind":13},{"line":1081,"kind":13,"containerName":"_parse_old","name":"$laststart"},{"containerName":"_parse_old","name":"$lastend","kind":13,"line":1081},{"containerName":"_parse_old","definition":"my","name":"$hitline","localvar":"my","kind":13,"line":1082},{"kind":13,"line":1084,"containerName":"_parse_old","name":"$line"},{"kind":13,"line":1084,"containerName":"_parse_old","name":"$self"},{"line":1084,"kind":12,"name":"_readline","containerName":"_parse_old"},{"name":"$line","containerName":"_parse_old","line":1085,"kind":13},{"line":1087,"kind":13,"name":"$line","containerName":"_parse_old"},{"kind":13,"line":1089,"name":"$line","containerName":"_parse_old"},{"name":"$self","containerName":"_parse_old","kind":13,"line":1090},{"line":1090,"kind":12,"name":"within_element","containerName":"_parse_old"},{"kind":13,"line":1091,"name":"$seentop","containerName":"_parse_old"},{"line":1092,"kind":13,"name":"$self","containerName":"_parse_old"},{"line":1092,"kind":12,"containerName":"_parse_old","name":"start_element"},{"containerName":"_parse_old","name":"$self","kind":13,"line":1093},{"line":1093,"kind":12,"containerName":"_parse_old","name":"element_hash"},{"name":"$algorithm","containerName":"_parse_old","kind":13,"line":1094},{"line":1095,"kind":13,"containerName":"_parse_old","name":"$model"},{"kind":13,"line":1096,"containerName":"_parse_old","name":"$accession"},{"kind":13,"line":1097,"containerName":"_parse_old","name":"$description"},{"line":1099,"kind":13,"name":"$db","containerName":"_parse_old"},{"line":1101,"kind":13,"containerName":"_parse_old","name":"$self"},{"containerName":"_parse_old","name":"in_element","kind":12,"line":1101},{"containerName":"_parse_old","name":"$self","line":1102,"kind":13},{"containerName":"_parse_old","name":"element_hash","line":1102,"kind":12},{"kind":13,"line":1102,"containerName":"_parse_old","name":"$maxscore"},{"containerName":"_parse_old","name":"$maxscore","kind":13,"line":1103},{"kind":13,"line":1104,"name":"$maxscore","containerName":"_parse_old"},{"containerName":"_parse_old","name":"$self","line":1105,"kind":13},{"kind":12,"line":1105,"name":"end_element","containerName":"_parse_old"},{"name":"$lasthit","containerName":"_parse_old","kind":13,"line":1107},{"line":1108,"kind":13,"containerName":"_parse_old","name":"$line"},{"containerName":"_parse_old","name":"$laststart","kind":13,"line":1109},{"kind":13,"line":1109,"containerName":"_parse_old","name":"$lastend"},{"containerName":"_parse_old","name":"$lastscore","line":1109,"kind":13},{"containerName":"_parse_old","name":"$maxscore","kind":13,"line":1110},{"kind":13,"line":1110,"containerName":"_parse_old","name":"$lastscore"},{"kind":13,"line":1110,"containerName":"_parse_old","name":"$maxscore"},{"kind":13,"line":1111,"name":"$lastscore","containerName":"_parse_old"},{"line":1111,"kind":13,"name":"$cutoff","containerName":"_parse_old"},{"containerName":"_parse_old","name":"$self","line":1112,"kind":13},{"line":1112,"kind":12,"containerName":"_parse_old","name":"within_element"},{"name":"$gi","definition":"my","containerName":"_parse_old","localvar":"my","kind":13,"line":1113},{"kind":13,"line":1113,"name":"$acc","containerName":"_parse_old"},{"containerName":"_parse_old","name":"$ver","line":1113,"kind":13},{"name":"$self","containerName":"_parse_old","kind":13,"line":1113},{"name":"_get_seq_identifiers","containerName":"_parse_old","line":1113,"kind":12},{"kind":13,"line":1113,"containerName":"_parse_old","name":"$lasthit"},{"kind":13,"line":1114,"containerName":"_parse_old","name":"$self"},{"line":1114,"kind":12,"containerName":"_parse_old","name":"start_element"},{"kind":13,"line":1115,"name":"$self","containerName":"_parse_old"},{"line":1115,"kind":12,"name":"element_hash","containerName":"_parse_old"},{"kind":13,"line":1116,"name":"$lasthit","containerName":"_parse_old"},{"containerName":"_parse_old","name":"$ver","line":1117,"kind":13},{"line":1118,"kind":13,"name":"$acc","containerName":"_parse_old"},{"line":1118,"kind":13,"containerName":"_parse_old","name":"$acc"},{"containerName":"_parse_old","name":"$lasthit","line":1118,"kind":13},{"line":1120,"kind":13,"containerName":"_parse_old","name":"$gi"},{"kind":13,"line":1123,"containerName":"_parse_old","name":"$self"},{"line":1123,"kind":12,"name":"in_element","containerName":"_parse_old"},{"name":"$self","containerName":"_parse_old","kind":13,"line":1124},{"containerName":"_parse_old","name":"start_element","line":1124,"kind":12},{"kind":13,"line":1126,"containerName":"_parse_old","name":"$maxscore"},{"name":"$maxscore","containerName":"_parse_old","kind":13,"line":1126},{"line":1126,"kind":13,"containerName":"_parse_old","name":"$lastscore"},{"containerName":"_parse_old","name":"$lastscore","line":1126,"kind":13},{"line":1127,"kind":13,"containerName":"_parse_old","name":"$maxscore"},{"line":1129,"kind":13,"name":"$line","containerName":"_parse_old"},{"line":1130,"kind":13,"name":"$self","containerName":"_parse_old"},{"line":1130,"kind":12,"containerName":"_parse_old","name":"_pushback"},{"name":"$line","containerName":"_parse_old","kind":13,"line":1130},{"line":1132,"kind":13,"localvar":"my","containerName":"_parse_old","name":"$offset","definition":"my"},{"line":1133,"kind":13,"localvar":"my","definition":"my","name":"$ct","containerName":"_parse_old"},{"line":1133,"kind":13,"containerName":"_parse_old","name":"$strln"},{"line":1134,"kind":13,"localvar":"my","definition":"my","name":"$hsp","containerName":"_parse_old"},{"localvar":"my","containerName":"_parse_old","definition":"my","name":"%hsp_key","line":1136,"kind":13},{"kind":13,"line":1141,"containerName":"_parse_old","name":"$line"},{"kind":13,"line":1141,"name":"$self","containerName":"_parse_old"},{"kind":12,"line":1141,"name":"_readline","containerName":"_parse_old"},{"line":1142,"kind":13,"name":"$line","containerName":"_parse_old"},{"name":"$line","containerName":"_parse_old","line":1143,"kind":13},{"kind":13,"line":1145,"containerName":"_parse_old","name":"$line"},{"containerName":"_parse_old","name":"$line","line":1145,"kind":13},{"kind":13,"line":1146,"name":"$self","containerName":"_parse_old"},{"name":"_pushback","containerName":"_parse_old","line":1146,"kind":12},{"line":1146,"kind":13,"containerName":"_parse_old","name":"$line"},{"kind":13,"line":1150,"definition":"my","name":"$iterator","containerName":"_parse_old","localvar":"my"},{"kind":13,"line":1150,"containerName":"_parse_old","name":"$ct"},{"name":"%4","containerName":"_parse_old","line":1150,"kind":13},{"kind":13,"line":1152,"containerName":"_parse_old","name":"$strln"},{"kind":13,"line":1152,"containerName":"_parse_old","name":"$line"},{"kind":13,"line":1152,"name":"$iterator","containerName":"_parse_old"},{"name":"$data","definition":"my","containerName":"_parse_old","localvar":"my","kind":13,"line":1155},{"kind":13,"line":1155,"containerName":"_parse_old","name":"$line"},{"line":1155,"kind":13,"containerName":"_parse_old","name":"$offset"},{"line":1155,"kind":13,"name":"$strln","containerName":"_parse_old"},{"kind":13,"line":1155,"name":"$offset","containerName":"_parse_old"},{"name":"$hsp","containerName":"_parse_old","line":1156,"kind":13},{"containerName":"_parse_old","name":"$hsp_key","line":1156,"kind":13},{"name":"$iterator","containerName":"_parse_old","kind":13,"line":1156},{"line":1156,"kind":13,"name":"$data","containerName":"_parse_old"},{"name":"$ct","containerName":"_parse_old","line":1157,"kind":13},{"name":"$self","containerName":"_parse_old","line":1162,"kind":13},{"line":1162,"kind":12,"name":"in_element","containerName":"_parse_old"},{"kind":13,"line":1163,"containerName":"_parse_old","definition":"my","name":"$strlen","localvar":"my"},{"line":1163,"kind":13,"name":"$hsp","containerName":"_parse_old"},{"localvar":"my","name":"$metastr","definition":"my","containerName":"_parse_old","line":1165,"kind":13},{"containerName":"_parse_old","name":"$metastr","kind":13,"line":1167},{"line":1167,"kind":13,"containerName":"_parse_old","name":"$self"},{"line":1167,"kind":12,"name":"convert_meta","containerName":"_parse_old"},{"line":1167,"kind":13,"containerName":"_parse_old","name":"$self"},{"containerName":"_parse_old","name":"simple_meta","kind":12,"line":1167},{"containerName":"_parse_old","name":"$hsp","kind":13,"line":1167},{"name":"$hsp","containerName":"_parse_old","kind":13,"line":1168},{"containerName":"_parse_old","name":"$self","line":1169,"kind":13},{"line":1169,"kind":12,"containerName":"_parse_old","name":"element_hash"},{"containerName":"_parse_old","name":"$hsp","kind":13,"line":1171},{"kind":13,"line":1172,"name":"$hsp","containerName":"_parse_old"},{"name":"$hsp","containerName":"_parse_old","kind":13,"line":1173},{"kind":13,"line":1174,"containerName":"_parse_old","name":"$metastr"},{"kind":13,"line":1176,"containerName":"_parse_old","name":"$strlen"},{"containerName":"_parse_old","name":"$strlen","kind":13,"line":1177},{"name":"$laststart","containerName":"_parse_old","line":1178,"kind":13},{"containerName":"_parse_old","name":"$lastend","kind":13,"line":1179},{"name":"$lastscore","containerName":"_parse_old","line":1180,"kind":13},{"line":1182,"kind":13,"containerName":"_parse_old","name":"$lastscore"},{"containerName":"_parse_old","name":"$self","kind":13,"line":1183},{"kind":12,"line":1183,"name":"end_element","containerName":"_parse_old"},{"line":1185,"kind":13,"name":"$line","containerName":"_parse_old"},{"kind":13,"line":1185,"name":"$line","containerName":"_parse_old"},{"name":"$self","containerName":"_parse_old","kind":13,"line":1186},{"line":1186,"kind":12,"containerName":"_parse_old","name":"within_element"},{"name":"$seentop","containerName":"_parse_old","kind":13,"line":1186},{"line":1187,"kind":13,"containerName":"_parse_old","name":"$self"},{"kind":12,"line":1187,"containerName":"_parse_old","name":"element"},{"name":"$version","containerName":"_parse_old","kind":13,"line":1189},{"kind":13,"line":1191,"name":"$self","containerName":"_parse_old"},{"containerName":"_parse_old","name":"in_element","line":1191,"kind":12},{"containerName":"_parse_old","name":"$self","kind":13,"line":1192},{"containerName":"_parse_old","name":"element_hash","kind":12,"line":1192},{"name":"$maxscore","containerName":"_parse_old","kind":13,"line":1192},{"name":"$maxscore","containerName":"_parse_old","line":1193,"kind":13},{"name":"$self","containerName":"_parse_old","line":1194,"kind":13},{"containerName":"_parse_old","name":"end_element","line":1194,"kind":12},{"kind":13,"line":1200,"containerName":"_parse_old","name":"$self"},{"kind":12,"line":1200,"name":"within_element","containerName":"_parse_old"},{"name":"$self","containerName":"_parse_old","line":1200,"kind":13},{"containerName":"_parse_old","name":"end_element","kind":12,"line":1200},{"containerName":"_parse_old","name":"$self","line":1201,"kind":13},{"line":1201,"kind":12,"containerName":"_parse_old","name":"end_element"},{"line":1201,"kind":13,"name":"$seentop","containerName":"_parse_old"},{"kind":13,"line":1202,"name":"$self","containerName":"_parse_old"},{"line":1202,"kind":12,"containerName":"_parse_old","name":"end_document"}],"line":1069,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":" cmsearch 0.72 and below; will likely be dropped when Infernal 1.0 is released","label":"_parse_old($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"PARSER","line":1083,"kind":12},{"name":"HSP","kind":12,"line":1135},{"line":1140,"kind":12,"name":"HSP"},{"name":"HSP","kind":12,"line":1147},{"line":1196,"kind":12,"name":"PARSER"}]}