{"vars":[{"containerName":"","name":"base","line":88,"kind":2},{"range":{"end":{"line":154,"character":9999},"start":{"line":111,"character":0}},"name":"_initialize","detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: hmmer_pull.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::hmmer_pull\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::hmmer_pull - A parser for HMMER output\n\n=head1 SYNOPSIS\n\n    # do not use this class directly it is available through Bio::SearchIO\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                               -file   => 't/data/hmmpfam.bigout');\n    while (my $result = $in->next_result) {\n        # this is a Bio::Search::Result::HmmpfamResult object\n        print $result->query_name(), \" for HMM \", $result->hmm_name(), \"\\n\";\n        while (my $hit = $result->next_hit) {\n            print $hit->name(), \"\\n\";\n            while (my $hsp = $hit->next_hsp) {\n                print \"length is \", $hsp->length(), \"\\n\";\n            }\n        }\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a pull-parser for HMMER output. It is fast since it\nonly does work on request (hence 'pull').\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::SearchIO::hmmer_pull;\n\nuse strict;\n\n\nuse base qw(Bio::SearchIO Bio::PullParserI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::hmmer_pull->new();\n Function: Builds a new Bio::SearchIO::hmmer_pull object \n Returns : Bio::SearchIO::hmmer_pull\n Args    : -fh/-file => HMMER output filename\n           -format   => 'hmmer_pull'\n           -evalue   => float or scientific notation number to be used\n                        as an evalue cutoff for hits\n           -score    => integer or scientific notation number to be used\n                        as a score value cutoff for hits\n           -hsps     => integer minimum number of hsps (domains) a hit must have\n           -piped_behaviour => 'temp_file'|'memory'|'sequential_read'\n\n           -piped_behaviour defines what the parser should do if the input is\n            an unseekable filehandle (eg. piped input), see\n            Bio::PullParserI::chunk for details. Default is 'sequential_read'."},"containerName":"main::","definition":"sub","line":111,"children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":112},{"kind":13,"line":112,"containerName":"_initialize","name":"@args"},{"definition":"my","name":"$writer","containerName":"_initialize","localvar":"my","kind":13,"line":116},{"name":"$file","containerName":"_initialize","kind":13,"line":116},{"containerName":"_initialize","name":"$fh","line":116,"kind":13},{"kind":13,"line":116,"containerName":"_initialize","name":"$piped_behaviour"},{"name":"$evalue","containerName":"_initialize","line":116,"kind":13},{"name":"$score","containerName":"_initialize","line":116,"kind":13},{"line":116,"kind":13,"name":"$hsps","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":117},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":117},{"kind":13,"line":122,"containerName":"_initialize","name":"@args"},{"kind":13,"line":123,"name":"$self","containerName":"_initialize"},{"line":123,"kind":12,"name":"writer","containerName":"_initialize"},{"line":123,"kind":13,"name":"$writer","containerName":"_initialize"},{"name":"$writer","containerName":"_initialize","kind":13,"line":123},{"line":125,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_fields","line":125,"kind":12},{"line":141,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_fields","kind":12,"line":141},{"line":141,"kind":13,"containerName":"_initialize","name":"$evalue"},{"name":"$evalue","containerName":"_initialize","line":141,"kind":13},{"name":"$self","containerName":"_initialize","kind":13,"line":142},{"containerName":"_initialize","name":"_fields","kind":12,"line":142},{"kind":13,"line":142,"name":"$score","containerName":"_initialize"},{"name":"$score","containerName":"_initialize","line":142,"kind":13},{"name":"$self","containerName":"_initialize","line":143,"kind":13},{"line":143,"kind":12,"name":"_fields","containerName":"_initialize"},{"name":"$hsps","containerName":"_initialize","line":143,"kind":13},{"name":"$hsps","containerName":"_initialize","line":143,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":145},{"kind":12,"line":145,"containerName":"_initialize","name":"_dependencies"},{"name":"$self","containerName":"_initialize","line":152,"kind":13},{"line":152,"kind":12,"containerName":"_initialize","name":"chunk"},{"line":152,"kind":13,"name":"$file","containerName":"_initialize"},{"line":152,"kind":13,"containerName":"_initialize","name":"$fh"},{"line":152,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":152,"containerName":"_initialize","name":"throw"},{"name":"$piped_behaviour","containerName":"_initialize","line":153,"kind":13}],"kind":12},{"kind":12,"line":125,"name":"header"},{"name":"algorithm","line":126,"kind":12},{"name":"algorithm_version","line":127,"kind":12},{"kind":12,"line":128,"name":"algorithm_reference"},{"kind":12,"line":129,"name":"hmm_file"},{"kind":12,"line":130,"name":"hmm_name"},{"name":"sequence_file","kind":12,"line":131},{"name":"sequence_database","line":132,"kind":12},{"name":"database_name","kind":12,"line":133},{"name":"database_letters","kind":12,"line":134},{"name":"database_entries","line":135,"kind":12},{"name":"next_result","kind":12,"line":136},{"name":"evalue_cutoff","line":137,"kind":12},{"line":138,"kind":12,"name":"score_cutoff"},{"name":"hsps_cutoff","kind":12,"line":139},{"kind":12,"line":141,"name":"evalue_cutoff"},{"line":142,"kind":12,"name":"score_cutoff"},{"name":"hsps_cutoff","line":143,"kind":12},{"line":145,"kind":12,"name":"algorithm"},{"name":"algorithm_version","kind":12,"line":146},{"line":147,"kind":12,"name":"hmm_file"},{"name":"hmm_name","line":148,"kind":12},{"name":"sequence_file","kind":12,"line":149},{"name":"sequence_database","line":150,"kind":12},{"definition":"sub","name":"_discover_header","containerName":"main::","range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":156}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_discover_header","localvar":"my","kind":13,"line":157},{"line":158,"kind":13,"name":"$self","containerName":"_discover_header"},{"name":"_chunk_seek","containerName":"_discover_header","kind":12,"line":158},{"kind":13,"line":159,"containerName":"_discover_header","name":"$header","definition":"my","localvar":"my"},{"containerName":"_discover_header","name":"$self","kind":13,"line":159},{"name":"_get_chunk_by_nol","containerName":"_discover_header","line":159,"kind":12},{"containerName":"_discover_header","name":"$self","line":160,"kind":13},{"containerName":"_discover_header","name":"$self","line":160,"kind":13},{"containerName":"_discover_header","name":"_chunk_tell","line":160,"kind":12},{"kind":13,"line":162,"containerName":"_discover_header","definition":"my","name":"$algo","localvar":"my"},{"containerName":"_discover_header","name":"$header","kind":13,"line":162},{"containerName":"_discover_header","name":"$self","kind":13,"line":163},{"containerName":"_discover_header","name":"_fields","kind":12,"line":163},{"kind":13,"line":163,"containerName":"_discover_header","name":"$algo"},{"line":165,"kind":13,"containerName":"_discover_header","name":"$self"},{"name":"_fields","containerName":"_discover_header","line":165,"kind":12},{"line":165,"kind":13,"containerName":"_discover_header","name":"$header"},{"line":167,"kind":13,"name":"$self","containerName":"_discover_header"},{"containerName":"_discover_header","name":"_fields","line":167,"kind":12},{"containerName":"_discover_header","name":"$header","line":167,"kind":13},{"containerName":"_discover_header","name":"$self","line":168,"kind":13},{"containerName":"_discover_header","name":"_fields","kind":12,"line":168},{"line":168,"kind":13,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","line":168,"kind":12},{"name":"$self","containerName":"_discover_header","kind":13,"line":170},{"line":170,"kind":12,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":170,"containerName":"_discover_header","name":"$header"},{"kind":13,"line":171,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","kind":12,"line":171},{"line":171,"kind":13,"name":"$self","containerName":"_discover_header"},{"kind":12,"line":171,"containerName":"_discover_header","name":"_fields"},{"kind":13,"line":173,"name":"$self","containerName":"_discover_header"},{"containerName":"_discover_header","name":"_fields","line":173,"kind":12}],"line":156},{"kind":12,"line":160,"name":"_after_header"},{"name":"algorithm","line":163,"kind":12},{"line":165,"kind":12,"name":"algorithm_version"},{"kind":12,"line":167,"name":"hmm_file"},{"line":168,"kind":12,"name":"hmm_name"},{"line":168,"kind":12,"name":"hmm_file"},{"name":"sequence_file","kind":12,"line":170},{"name":"sequence_database","line":171,"kind":12},{"name":"sequence_file","line":171,"kind":12},{"kind":12,"line":173,"name":"header"},{"range":{"start":{"line":176,"character":0},"end":{"line":186,"character":9999}},"containerName":"main::","definition":"sub","name":"_discover_database_name","line":176,"children":[{"line":177,"kind":13,"localvar":"my","containerName":"_discover_database_name","name":"$self","definition":"my"},{"kind":13,"line":178,"containerName":"_discover_database_name","definition":"my","name":"$type","localvar":"my"},{"containerName":"_discover_database_name","name":"$self","kind":13,"line":178},{"kind":12,"line":178,"containerName":"_discover_database_name","name":"get_field"},{"kind":13,"line":180,"containerName":"_discover_database_name","name":"$type"},{"line":181,"kind":13,"name":"$self","containerName":"_discover_database_name"},{"name":"_fields","containerName":"_discover_database_name","line":181,"kind":12},{"line":181,"kind":13,"containerName":"_discover_database_name","name":"$self"},{"name":"get_field","containerName":"_discover_database_name","line":181,"kind":12},{"line":183,"kind":13,"name":"$type","containerName":"_discover_database_name"},{"name":"$self","containerName":"_discover_database_name","kind":13,"line":184},{"containerName":"_discover_database_name","name":"_fields","kind":12,"line":184},{"containerName":"_discover_database_name","name":"$self","kind":13,"line":184},{"kind":12,"line":184,"containerName":"_discover_database_name","name":"get_field"}],"kind":12},{"name":"database_name","kind":12,"line":181},{"line":184,"kind":12,"name":"database_name"},{"definition":"sub","name":"_discover_next_result","containerName":"main::","range":{"start":{"line":188,"character":0},"end":{"line":221,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_discover_next_result","localvar":"my","kind":13,"line":189},{"localvar":"my","name":"$type","definition":"my","containerName":"_discover_next_result","line":190,"kind":13},{"containerName":"_discover_next_result","name":"$self","line":190,"kind":13},{"containerName":"_discover_next_result","name":"get_field","kind":12,"line":190},{"kind":13,"line":192,"name":"$type","containerName":"_discover_next_result"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":195},{"containerName":"_discover_next_result","name":"_sequential","line":195,"kind":12},{"kind":13,"line":196,"containerName":"_discover_next_result","name":"$self"},{"kind":12,"line":196,"containerName":"_discover_next_result","name":"_chunk_seek"},{"name":"$self","containerName":"_discover_next_result","line":196,"kind":13},{"line":196,"kind":13,"containerName":"_discover_next_result","name":"$self"},{"containerName":"_discover_next_result","definition":"my","name":"$start","localvar":"my","kind":13,"line":198},{"containerName":"_discover_next_result","name":"$end","line":198,"kind":13},{"kind":13,"line":198,"containerName":"_discover_next_result","name":"$self"},{"line":198,"kind":12,"name":"_find_chunk_by_end","containerName":"_discover_next_result"},{"line":199,"kind":13,"containerName":"_discover_next_result","name":"$start"},{"name":"$end","containerName":"_discover_next_result","kind":13,"line":199},{"containerName":"_discover_next_result","name":"$self","line":200,"kind":13},{"line":200,"kind":12,"containerName":"_discover_next_result","name":"_fields"},{"line":200,"kind":12,"containerName":"_discover_next_result","name":"new"},{"line":200,"kind":13,"name":"$self","containerName":"_discover_next_result"},{"containerName":"_discover_next_result","name":"chunk","kind":12,"line":200},{"containerName":"_discover_next_result","name":"$start","kind":13,"line":200},{"line":200,"kind":13,"containerName":"_discover_next_result","name":"$end"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":201},{"containerName":"_discover_next_result","name":"$self","kind":13,"line":203},{"containerName":"_discover_next_result","name":"$end","kind":13,"line":203},{"line":209,"kind":13,"localvar":"my","definition":"my","name":"$chunk","containerName":"_discover_next_result"},{"kind":13,"line":209,"containerName":"_discover_next_result","name":"$self"},{"containerName":"_discover_next_result","name":"_get_chunk_by_end","kind":12,"line":209},{"containerName":"_discover_next_result","name":"$chunk","kind":13,"line":210},{"containerName":"_discover_next_result","name":"$self","line":211,"kind":13},{"containerName":"_discover_next_result","name":"_fields","kind":12,"line":211},{"line":211,"kind":12,"name":"new","containerName":"_discover_next_result"},{"kind":13,"line":211,"containerName":"_discover_next_result","name":"$chunk"},{"name":"$self","containerName":"_discover_next_result","kind":13,"line":212},{"line":215,"kind":13,"name":"$type","containerName":"_discover_next_result"},{"kind":13,"line":216,"containerName":"_discover_next_result","name":"$self"},{"name":"throw","containerName":"_discover_next_result","kind":12,"line":216},{"kind":13,"line":219,"name":"$self","containerName":"_discover_next_result"},{"kind":12,"line":219,"containerName":"_discover_next_result","name":"throw"}],"line":188},{"kind":2,"line":195,"name":"HmmpfamResult","containerName":"Bio::Search::Result"},{"kind":12,"line":196,"name":"_end_of_previous_result"},{"kind":12,"line":196,"name":"_after_header"},{"line":200,"kind":12,"name":"next_result"},{"name":"Bio","containerName":"Search::Result::HmmpfamResult","kind":12,"line":200},{"line":203,"kind":12,"name":"_end_of_previous_result"},{"name":"next_result","kind":12,"line":211},{"line":211,"kind":12,"containerName":"Search::Result::HmmpfamResult","name":"Bio"},{"kind":12,"children":[{"line":234,"kind":13,"localvar":"my","containerName":"next_result","definition":"my","name":"$self"},{"localvar":"my","name":"$result","definition":"my","containerName":"next_result","line":235,"kind":13},{"name":"$self","containerName":"next_result","line":235,"kind":13},{"line":235,"kind":12,"containerName":"next_result","name":"get_field"},{"containerName":"next_result","name":"$self","line":237,"kind":13},{"line":237,"kind":12,"containerName":"next_result","name":"_fields"},{"kind":13,"line":239,"name":"$self","containerName":"next_result"},{"containerName":"next_result","name":"$result","line":240,"kind":13}],"line":233,"name":"next_result","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":241},"start":{"character":0,"line":233}}},{"line":237,"kind":12,"name":"next_result"},{"definition":"sub","name":"result_count","containerName":"main::","range":{"start":{"line":253,"character":0},"end":{"line":256,"character":9999}},"kind":12,"children":[{"kind":13,"line":254,"definition":"my","name":"$self","containerName":"result_count","localvar":"my"},{"kind":13,"line":255,"containerName":"result_count","name":"$self"}],"line":253},{"name":"rewind","definition":"sub","containerName":"main::","range":{"start":{"line":275,"character":0},"end":{"character":9999,"line":281}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"rewind","localvar":"my","kind":13,"line":276},{"containerName":"rewind","name":"$self","line":277,"kind":13},{"name":"_sequential","containerName":"rewind","line":277,"kind":12},{"containerName":"rewind","name":"$self","kind":13,"line":278},{"containerName":"rewind","name":"warn","kind":12,"line":278},{"line":280,"kind":13,"containerName":"rewind","name":"$self"}],"line":275},{"name":"_end_of_previous_result","line":280,"kind":12}],"version":5}