{"vars":[{"name":"base","containerName":"","kind":2,"line":83},{"kind":13,"line":85,"definition":"my","name":"%MODEMAP","containerName":null,"localvar":"my"},{"localvar":"my","name":"%MAPPING","definition":"my","containerName":null,"line":95,"kind":13},{"line":157,"kind":13,"localvar":"my","containerName":null,"name":"%IGNOREDTAGS","definition":"my"},{"signature":{"documentation":"1;\n# $Id: BlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::BlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::BlastHandler - XML Handler for NCBI Blast XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST XML parsing. Currently it passes elements off\nto the event handler, which is ultimately responsible for Bio::Search object\ngeneration.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::BlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n                'Iteration'   => 'result',\n                'Hit'         => 'hit',\n                'Hsp'         => 'hsp'\n);\n\n# major post 2.2.12 BLAST XML changes\n# 1) moved XML Handler to it's own class\n# 2) reconfigure blastxml to deal with old and new BLAST XML output\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',                \n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n                \n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n                \n                # if these tags are present, they will overwrite the\n                # above with more current data (i.e. multiquery hits)\n                'Iteration_query-def'   => 'RESULT-query_description',\n                'Iteration_query-len'   => 'RESULT-query_length',       \n                'Iteration_query-ID'    => 'runid',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,     \n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"start_document","name":"$self","definition":"my","localvar":"my","kind":13,"line":187},{"line":188,"kind":13,"name":"$self","containerName":"start_document"},{"containerName":"start_document","name":"$self","line":189,"kind":13},{"name":"$self","containerName":"start_document","line":190,"kind":13}],"line":186,"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"line":186,"character":0}},"name":"start_document"},{"range":{"end":{"character":9999,"line":211},"start":{"character":0,"line":203}},"name":"end_document","line":203,"children":[{"line":204,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"end_document"},{"name":"@args","containerName":"end_document","kind":13,"line":204},{"kind":13,"line":207,"name":"$self","containerName":"end_document"},{"containerName":"end_document","name":"$self","line":210,"kind":13}],"kind":12,"detail":"($self,@args)","signature":{"label":"end_document($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: BlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::BlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::BlastHandler - XML Handler for NCBI Blast XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST XML parsing. Currently it passes elements off\nto the event handler, which is ultimately responsible for Bio::Search object\ngeneration.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::BlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n                'Iteration'   => 'result',\n                'Hit'         => 'hit',\n                'Hsp'         => 'hsp'\n);\n\n# major post 2.2.12 BLAST XML changes\n# 1) moved XML Handler to it's own class\n# 2) reconfigure blastxml to deal with old and new BLAST XML output\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',                \n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n                \n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n                \n                # if these tags are present, they will overwrite the\n                # above with more current data (i.e. multiquery hits)\n                'Iteration_query-def'   => 'RESULT-query_description',\n                'Iteration_query-len'   => 'RESULT-query_length',       \n                'Iteration_query-ID'    => 'runid',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,     \n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":234},"start":{"line":223,"character":0}},"name":"start_element","children":[{"kind":13,"line":224,"name":"$self","definition":"my","containerName":"start_element","localvar":"my"},{"line":224,"kind":13,"name":"$data","containerName":"start_element"},{"kind":13,"line":226,"containerName":"start_element","definition":"my","name":"$nm","localvar":"my"},{"containerName":"start_element","name":"$data","line":226,"kind":13},{"kind":13,"line":228,"name":"$type","definition":"my","containerName":"start_element","localvar":"my"},{"kind":13,"line":228,"name":"$MODEMAP","containerName":"start_element"},{"containerName":"start_element","name":"$nm","kind":13,"line":228},{"line":229,"kind":13,"name":"$self","containerName":"start_element"},{"name":"eventHandler","containerName":"start_element","line":229,"kind":12},{"kind":12,"line":229,"name":"will_handle","containerName":"start_element"},{"containerName":"start_element","name":"$type","line":229,"kind":13},{"kind":13,"line":230,"definition":"my","name":"$func","containerName":"start_element","localvar":"my"},{"line":230,"kind":13,"containerName":"start_element","name":"$type"},{"line":231,"kind":13,"name":"$self","containerName":"start_element"},{"line":231,"kind":12,"name":"eventHandler","containerName":"start_element"},{"name":"$func","containerName":"start_element","kind":13,"line":231},{"line":231,"kind":13,"name":"$data","containerName":"start_element"}],"line":223,"kind":12,"signature":{"label":"start_element($self,$data)","documentation":"1;\n# $Id: BlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::BlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::BlastHandler - XML Handler for NCBI Blast XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST XML parsing. Currently it passes elements off\nto the event handler, which is ultimately responsible for Bio::Search object\ngeneration.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::BlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n                'Iteration'   => 'result',\n                'Hit'         => 'hit',\n                'Hsp'         => 'hsp'\n);\n\n# major post 2.2.12 BLAST XML changes\n# 1) moved XML Handler to it's own class\n# 2) reconfigure blastxml to deal with old and new BLAST XML output\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',                \n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n                \n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n                \n                # if these tags are present, they will overwrite the\n                # above with more current data (i.e. multiquery hits)\n                'Iteration_query-def'   => 'RESULT-query_description',\n                'Iteration_query-len'   => 'RESULT-query_length',       \n                'Iteration_query-ID'    => 'runid',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,     \n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data","parameters":[{"label":"$self"},{"label":"$data"}]},"detail":"($self,$data)","definition":"sub","containerName":"main::"},{"line":246,"children":[{"line":247,"kind":13,"localvar":"my","containerName":"end_element","name":"$self","definition":"my"},{"kind":13,"line":247,"name":"$data","containerName":"end_element"},{"kind":13,"line":249,"containerName":"end_element","definition":"my","name":"$nm","localvar":"my"},{"name":"$data","containerName":"end_element","kind":13,"line":249},{"name":"$rc","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":250},{"line":251,"kind":13,"name":"$nm","containerName":"end_element"},{"kind":13,"line":252,"name":"$self","containerName":"end_element"},{"containerName":"end_element","name":"$self","kind":13,"line":253},{"line":255,"kind":13,"name":"$nm","containerName":"end_element"},{"containerName":"end_element","name":"$self","kind":13,"line":257},{"name":"$self","containerName":"end_element","line":257,"kind":13},{"name":"$self","containerName":"end_element","kind":13,"line":258}],"kind":12,"detail":"($self,$data)","signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: BlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::BlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::BlastHandler - XML Handler for NCBI Blast XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST XML parsing. Currently it passes elements off\nto the event handler, which is ultimately responsible for Bio::Search object\ngeneration.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::BlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n                'Iteration'   => 'result',\n                'Hit'         => 'hit',\n                'Hsp'         => 'hsp'\n);\n\n# major post 2.2.12 BLAST XML changes\n# 1) moved XML Handler to it's own class\n# 2) reconfigure blastxml to deal with old and new BLAST XML output\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',                \n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n                \n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n                \n                # if these tags are present, they will overwrite the\n                # above with more current data (i.e. multiquery hits)\n                'Iteration_query-def'   => 'RESULT-query_description',\n                'Iteration_query-len'   => 'RESULT-query_length',       \n                'Iteration_query-ID'    => 'runid',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,     \n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data\n\n\nsub start_element{\n    my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"start_%s\",lc $type);\n            $self->eventHandler->$func($data->{'Attributes'});\n        }                                                    \n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $parser->end_element($data)\n Function: Signals finishing an element\n Returns : Bio::Search object dpending on what type of element\n Args    : hash ref for data"},"containerName":"main::","definition":"sub","range":{"start":{"line":246,"character":0},"end":{"line":259,"character":9999}},"name":"end_element"},{"localvar":"my","containerName":null,"definition":"my","name":"$type","line":260,"kind":13},{"line":260,"kind":13,"containerName":null,"name":"%MODEMAP"},{"kind":13,"line":260,"containerName":null,"name":"%nm"},{"line":261,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":261,"containerName":"main::","name":"eventHandler"},{"line":261,"kind":12,"containerName":"main::","name":"will_handle"},{"line":261,"kind":13,"name":"%type","containerName":null},{"name":"$func","definition":"my","containerName":null,"localvar":"my","kind":13,"line":262},{"name":"$type","containerName":null,"kind":13,"line":262},{"name":"$rc","containerName":null,"line":263,"kind":13},{"kind":13,"line":263,"name":"$self","containerName":null},{"containerName":"main::","name":"eventHandler","kind":12,"line":263},{"name":"$func","containerName":null,"kind":13,"line":263},{"line":263,"kind":13,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":264},{"containerName":null,"name":"%MAPPING","kind":13,"line":267},{"line":267,"kind":13,"containerName":null,"name":"%nm"},{"name":"%MAPPING","containerName":null,"kind":13,"line":268},{"kind":13,"line":268,"name":"%nm","containerName":null},{"line":269,"kind":13,"localvar":"my","name":"$key","definition":"my","containerName":null},{"containerName":null,"name":"%MAPPING","kind":13,"line":269},{"kind":13,"line":269,"name":"@nm","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":270},{"containerName":null,"name":"%key","kind":13,"line":270},{"kind":13,"line":270,"containerName":null,"name":"%MAPPING"},{"line":270,"kind":13,"name":"%nm","containerName":null},{"name":"$key","containerName":null,"kind":13,"line":270},{"containerName":null,"name":"%self","kind":13,"line":270},{"name":"%self","containerName":null,"kind":13,"line":272},{"kind":13,"line":272,"name":"%MAPPING","containerName":null},{"name":"$nm","containerName":null,"line":272,"kind":13},{"line":272,"kind":13,"containerName":null,"name":"%self"},{"line":275,"kind":13,"containerName":null,"name":"%IGNOREDTAGS"},{"name":"%nm","containerName":null,"line":275,"kind":13},{"containerName":null,"name":"$self","line":279,"kind":13},{"name":"debug","containerName":"main::","line":279,"kind":12},{"line":281,"kind":13,"name":"%self","containerName":null},{"name":"%self","containerName":null,"line":285,"kind":13},{"containerName":null,"name":"$rc","kind":13,"line":285},{"line":285,"kind":13,"name":"$nm","containerName":null},{"line":287,"kind":13,"containerName":null,"name":"%nm"},{"containerName":null,"name":"%self","kind":13,"line":288},{"line":303,"children":[{"localvar":"my","containerName":"characters","name":"$self","definition":"my","line":304,"kind":13},{"containerName":"characters","name":"$data","line":304,"kind":13},{"name":"$data","containerName":"characters","kind":13,"line":305},{"name":"$data","containerName":"characters","kind":13,"line":305},{"line":306,"kind":13,"containerName":"characters","name":"$self"},{"line":306,"kind":13,"containerName":"characters","name":"$data"}],"kind":12,"detail":"($self,$data)","signature":{"documentation":"1;\n# $Id: BlastHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::XML::BlastHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich, Chris Fields\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::XML::BlastHandler - XML Handler for NCBI Blast XML parsing.\n\n=head1 SYNOPSIS\n\n  # This is not to be used directly.\n\n=head1 DESCRIPTION\n\nThis is the XML handler for BLAST XML parsing. Currently it passes elements off\nto the event handler, which is ultimately responsible for Bio::Search object\ngeneration.\n\nThis was recently split off from the original code for Bio::SearchIO::blastxml\nprimarily for maintenance purposes.\n\n=head1 DEPENDENCIES\n\nIn addition to parts of the Bio:: hierarchy, this module uses:\n\n XML::SAX::Base\n\nwhich comes with the XML::SAX distribution.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich, Chris Fields\n\nEmail jason-at-bioperl.org\nEmail cjfields-at-uiuc dot edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::SearchIO::XML::BlastHandler;\nuse base qw(Bio::Root::Root XML::SAX::Base);\n\nmy %MODEMAP = (\n                'Iteration'   => 'result',\n                'Hit'         => 'hit',\n                'Hsp'         => 'hsp'\n);\n\n# major post 2.2.12 BLAST XML changes\n# 1) moved XML Handler to it's own class\n# 2) reconfigure blastxml to deal with old and new BLAST XML output\n\nmy %MAPPING = (\n                # Result-specific fields\n                'BlastOutput_program'   => 'RESULT-algorithm_name',\n                'BlastOutput_version'   => 'RESULT-algorithm_version',\n                'BlastOutput_db'        => 'RESULT-database_name',\n                'BlastOutput_reference' => 'RESULT-program_reference',\n                'BlastOutput_query-def' => 'RESULT-query_description',\n                'BlastOutput_query-len' => 'RESULT-query_length',\n                'BlastOutput_query-ID'  => 'runid',                \n                'Parameters_matrix'     => { 'RESULT-parameters' => 'matrix'},\n                'Parameters_expect'     => { 'RESULT-parameters' => 'expect'},\n                'Parameters_include'    => { 'RESULT-parameters' => 'include'},\n                'Parameters_sc-match'   => { 'RESULT-parameters' => 'match'},\n                'Parameters_sc-mismatch' => { 'RESULT-parameters' => 'mismatch'},\n                'Parameters_gap-open'   => { 'RESULT-parameters' => 'gapopen'},\n                'Parameters_gap-extend' => { 'RESULT-parameters' => 'gapext'},\n                'Parameters_filter'     => {'RESULT-parameters' => 'filter'},\n                'Statistics_db-num'     => 'RESULT-database_entries',\n                'Statistics_db-len'     => 'RESULT-database_letters',\n                'Statistics_hsp-len'    => { 'RESULT-statistics' => 'hsplength'},\n                'Statistics_eff-space'  => { 'RESULT-statistics' => 'effectivespace'},\n                'Statistics_kappa'      => { 'RESULT-statistics' => 'kappa' },\n                'Statistics_lambda'     => { 'RESULT-statistics' => 'lambda' },\n                'Statistics_entropy'    => { 'RESULT-statistics' => 'entropy'},\n                \n                # HSP specific fields\n                'Hsp_bit-score'  => 'HSP-bits',\n                'Hsp_score'      => 'HSP-score',\n                'Hsp_evalue'     => 'HSP-evalue',\n                'Hsp_query-from' => 'HSP-query_start',\n                'Hsp_query-to'   => 'HSP-query_end',\n                'Hsp_hit-from'   => 'HSP-hit_start',\n                'Hsp_hit-to'     => 'HSP-hit_end',\n                'Hsp_positive'   => 'HSP-conserved',\n                'Hsp_identity'   => 'HSP-identical',\n                'Hsp_gaps'       => 'HSP-gaps',\n                'Hsp_hitgaps'    => 'HSP-hit_gaps',\n                'Hsp_querygaps'  => 'HSP-query_gaps',\n                'Hsp_qseq'       => 'HSP-query_seq',\n                'Hsp_hseq'       => 'HSP-hit_seq',\n                'Hsp_midline'    => 'HSP-homology_seq',\n                'Hsp_align-len'  => 'HSP-hsp_length',\n                'Hsp_query-frame'=> 'HSP-query_frame',\n                'Hsp_hit-frame'  => 'HSP-hit_frame',\n\n                # Hit specific fields\n                'Hit_id'               => 'HIT-name',\n                'Hit_len'              => 'HIT-length',\n                'Hit_accession'        => 'HIT-accession',\n                'Hit_def'              => 'HIT-description',\n                'Hit_num'              => 'HIT-order',\n                'Iteration_iter-num'   => 'HIT-iteration',\n                'Iteration_stat'       => 'HIT-iteration_statistic',\n                \n                # if these tags are present, they will overwrite the\n                # above with more current data (i.e. multiquery hits)\n                'Iteration_query-def'   => 'RESULT-query_description',\n                'Iteration_query-len'   => 'RESULT-query_length',       \n                'Iteration_query-ID'    => 'runid',\n               );\n\n# these XML tags are ignored for now\nmy %IGNOREDTAGS = (\n                'Hsp_num'              => 1,#'HSP-order',\n                'Hsp_pattern-from'     => 1,#'patternend',\n                'Hsp_pattern-to'       => 1,#'patternstart',\n                'Hsp_density'          => 1,#'hspdensity',\n                'Iteration_message'    => 1,\n                'Hit_hsps'             => 1,\n                'BlastOutput_param'    => 1,\n                'Iteration_hits'       => 1,\n                'Statistics'           => 1,\n                'Parameters'           => 1,\n                'BlastOutput'          => 1,\n                'BlastOutput_iterations' => 1,     \n                   );\n\n=head2 SAX methods\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $parser->start_document;\n Function: SAX method to indicate starting to parse a new document\n Returns : none\n Args    : none\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= [];\n}\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $parser->end_document;\n Function: SAX method to indicate finishing parsing a new document\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub end_document{\n   my ($self,@args) = @_;\n   \n   # reset data carried throughout parse\n   $self->{'_resultdata'} = undef;\n   \n   # pass back ref to results queue; caller must reset handler results queue\n   return $self->{'_result'};\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $parser->start_element($data)\n Function: SAX method to indicate starting a new element\n Returns : none\n Args    : hash ref for data\n\n\nsub start_element{\n    my ($self,$data) = @_;\n    # we currently don't care about attributes\n    my $nm = $data->{'Name'};\n\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"start_%s\",lc $type);\n            $self->eventHandler->$func($data->{'Attributes'});\n        }                                                    \n    }\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   : $parser->end_element($data)\n Function: Signals finishing an element\n Returns : Bio::Search object dpending on what type of element\n Args    : hash ref for data\n\n\nsub end_element{\n    my ($self,$data) = @_;\n\n    my $nm = $data->{'Name'};\n    my $rc;\n    if($nm eq 'BlastOutput_program' &&\n       $self->{'_last_data'} =~ /(t?blast[npx])/i ) {\n        $self->{'_type'} = uc $1; \n    }\n    if ($nm eq 'Iteration') {\n        map {\n            $self->{'_values'}->{$_} = $self->{'_resultdata'}->{$_};\n            } keys %{ $self->{'_resultdata'} };\n    }\n    if( my $type = $MODEMAP{$nm} ) {\n        if( $self->eventHandler->will_handle($type) ) {\n            my $func = sprintf(\"end_%s\",lc $type);\n            $rc = $self->eventHandler->$func($self->{'_type'},\n                                              $self->{'_values'});\n        }\n    }\n    elsif( exists $MAPPING{$nm} ) { \n        if ( ref($MAPPING{$nm}) =~ /hash/i ) {\n            my $key = (keys %{$MAPPING{$nm}})[0];\n            $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n        } else {\n            $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n        }\n    }\n    elsif( exists $IGNOREDTAGS{$nm} ){\n        # ignores these elements for now\n    }\n    else {      \n        $self->debug(\"ignoring unrecognized element type $nm\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at \n                                # end of an element\n                                \n    # add to ResultI array\n    $self->{'_result'} = $rc if( $nm eq 'Iteration' );\n    # reset values for each Result round\n    if ($nm eq 'Iteration') {\n        $self->{'_values'} = {};\n    }\n}\n\n=head2 characters\n\n Title   : characters\n Usage   : $parser->characters($data)\n Function: Signals new characters to be processed\n Returns : characters read\n Args    : hash ref with the key 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"},"containerName":"main::","definition":"sub","range":{"start":{"line":303,"character":0},"end":{"line":307,"character":9999}},"name":"characters"},{"containerName":"main::","definition":"sub","name":"eventHandler","range":{"end":{"line":313,"character":9999},"start":{"line":309,"character":0}},"kind":12,"line":309,"children":[{"line":310,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"eventHandler"},{"kind":13,"line":311,"containerName":"eventHandler","name":"$self"},{"kind":13,"line":312,"name":"$self","containerName":"eventHandler"}]}],"version":5}