{"version":5,"vars":[{"name":"vars","containerName":"","line":78,"kind":2},{"line":83,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"start":{"character":0,"line":99},"end":{"line":121,"character":9999}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information"},"kind":12,"line":99,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":100,"kind":13},{"line":100,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":101,"kind":13},{"kind":13,"line":101,"name":"$class","containerName":"new"},{"kind":13,"line":101,"name":"@args","containerName":"new"},{"kind":13,"line":102,"name":"$hspF","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$hitF","line":102,"kind":13},{"line":102,"kind":13,"name":"$resultF","containerName":"new"},{"line":102,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","kind":12,"line":102},{"line":104,"kind":13,"containerName":"new","name":"@args"},{"line":105,"kind":13,"name":"$self","containerName":"new"},{"line":105,"kind":12,"containerName":"new","name":"register_factory"},{"line":105,"kind":13,"containerName":"new","name":"$hspF"},{"kind":12,"line":106,"containerName":"new","name":"new"},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":110,"containerName":"new","name":"register_factory"},{"kind":13,"line":110,"containerName":"new","name":"$hitF"},{"kind":12,"line":111,"containerName":"new","name":"new"},{"name":"$self","containerName":"new","kind":13,"line":115},{"containerName":"new","name":"register_factory","line":115,"kind":12},{"containerName":"new","name":"$resultF","kind":13,"line":115},{"kind":12,"line":116,"containerName":"new","name":"new"},{"kind":13,"line":120,"containerName":"new","name":"$self"}]},{"name":"SUPER","containerName":"new","line":101,"kind":12},{"containerName":"Factory::ObjectFactory","name":"Bio","line":106,"kind":12},{"line":111,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"line":116,"kind":12,"containerName":"Factory::ObjectFactory","name":"Bio"},{"name":"will_handle","range":{"end":{"line":140,"character":9999},"start":{"character":0,"line":136}},"kind":12,"children":[{"containerName":"will_handle","definition":"my","name":"$self","localvar":"my","kind":13,"line":137},{"name":"$type","containerName":"will_handle","kind":13,"line":137},{"name":"$type","containerName":"will_handle","kind":13,"line":139},{"containerName":"will_handle","name":"$type","line":139,"kind":13},{"name":"$type","containerName":"will_handle","line":139,"kind":13}],"line":136,"definition":"sub","containerName":"main::","signature":{"label":"will_handle($self,$type)","documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name","parameters":[{"label":"$self"},{"label":"$type"}]},"detail":"($self,$type)"},{"definition":"sub","containerName":"main::","signature":{"label":"start_result($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report"},"detail":"($self,$type)","kind":12,"children":[{"localvar":"my","containerName":"start_result","definition":"my","name":"$self","line":157,"kind":13},{"name":"$type","containerName":"start_result","line":157,"kind":13},{"containerName":"start_result","name":"$self","line":158,"kind":13},{"name":"$type","containerName":"start_result","line":158,"kind":13},{"name":"$self","containerName":"start_result","line":159,"kind":13},{"containerName":"start_result","name":"$self","kind":13,"line":160},{"line":161,"kind":13,"containerName":"start_result","name":"$self"}],"line":156,"name":"start_result","range":{"end":{"line":163,"character":9999},"start":{"character":0,"line":156}}},{"range":{"end":{"line":201,"character":9999},"start":{"line":178,"character":0}},"name":"end_result","line":178,"children":[{"line":179,"kind":13,"localvar":"my","containerName":"end_result","name":"$self","definition":"my"},{"line":179,"kind":13,"containerName":"end_result","name":"$type"},{"containerName":"end_result","name":"$data","kind":13,"line":179},{"kind":13,"line":181,"containerName":"end_result","name":"$data"},{"name":"$data","containerName":"end_result","kind":13,"line":182},{"line":184,"kind":13,"containerName":"end_result","name":"$data"},{"containerName":"end_result","name":"$data","kind":13,"line":185},{"line":185,"kind":13,"name":"$data","containerName":"end_result"},{"kind":13,"line":187,"name":"$data","containerName":"end_result"},{"containerName":"end_result","name":"$data","kind":13,"line":188},{"line":189,"kind":13,"containerName":"end_result","name":"$data"},{"definition":"my","name":"@a","containerName":"end_result","localvar":"my","kind":13,"line":192},{"name":"$data","containerName":"end_result","kind":13,"line":192},{"kind":13,"line":193,"containerName":"end_result","name":"$acc","definition":"my","localvar":"my"},{"kind":13,"line":193,"containerName":"end_result","name":"@a"},{"containerName":"end_result","name":"$acc","line":195,"kind":13},{"containerName":"end_result","name":"@a","kind":13,"line":195},{"containerName":"end_result","name":"$acc","kind":13,"line":195},{"line":195,"kind":13,"name":"$acc","containerName":"end_result"},{"kind":13,"line":196,"name":"$data","containerName":"end_result"},{"line":196,"kind":13,"name":"$acc","containerName":"end_result"},{"line":198,"kind":13,"containerName":"end_result","name":"$data"},{"line":200,"kind":13,"localvar":"my","containerName":"end_result","definition":"my","name":"%args"},{"kind":13,"line":200,"containerName":"end_result","definition":"my","name":"$v","localvar":"my"},{"kind":13,"line":200,"containerName":"end_result","name":"$data"},{"line":200,"kind":13,"containerName":"end_result","name":"$v"},{"name":"$data","containerName":"end_result","line":201,"kind":13}],"kind":12,"detail":"($self,$type,$data)","signature":{"label":"end_result($self,$type,$data)","documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n this is overridden by IteratedSearchResultEventBuilder\n so keep that in mind when debugging","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}]},"containerName":"main::","definition":"sub"},{"containerName":null,"name":"%args","line":203,"kind":13},{"line":203,"kind":13,"containerName":null,"name":"%args"},{"name":"%data","containerName":null,"kind":13,"line":204},{"name":"$type","containerName":null,"line":204,"kind":13},{"containerName":null,"name":"%args","kind":13,"line":205},{"kind":13,"line":205,"containerName":null,"name":"%self"},{"line":206,"kind":13,"localvar":"my","containerName":null,"name":"$result","definition":"my"},{"line":206,"kind":13,"name":"$self","containerName":null},{"line":206,"kind":12,"containerName":"main::","name":"factory"},{"name":"create_object","containerName":"main::","kind":12,"line":206},{"containerName":null,"name":"%args","line":206,"kind":13},{"name":"$result","containerName":null,"line":207,"kind":13},{"containerName":"main::","name":"hit_factory","line":207,"kind":12},{"kind":13,"line":207,"name":"$self","containerName":null},{"line":207,"kind":12,"containerName":"main::","name":"factory"},{"line":208,"kind":13,"name":"%self","containerName":null},{"name":"$result","containerName":null,"line":209,"kind":13},{"range":{"end":{"character":9999,"line":226},"start":{"line":223,"character":0}},"name":"start_hsp","line":223,"children":[{"kind":13,"line":224,"containerName":"start_hsp","definition":"my","name":"$self","localvar":"my"},{"line":224,"kind":13,"containerName":"start_hsp","name":"@args"}],"kind":12,"detail":"($self,@args)","signature":{"label":"start_hsp($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"label":"end_hsp($self,$type,$data)","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref"},"detail":"($self,$type,$data)","kind":12,"children":[{"line":240,"kind":13,"localvar":"my","containerName":"end_hsp","name":"$self","definition":"my"},{"containerName":"end_hsp","name":"$type","kind":13,"line":240},{"containerName":"end_hsp","name":"$data","line":240,"kind":13},{"line":242,"kind":13,"name":"$data","containerName":"end_hsp"},{"containerName":"end_hsp","name":"$data","kind":13,"line":243},{"containerName":"end_hsp","name":"$data","kind":13,"line":245},{"containerName":"end_hsp","name":"$data","line":246,"kind":13},{"containerName":"end_hsp","name":"$data","kind":13,"line":246},{"name":"$data","containerName":"end_hsp","kind":13,"line":248},{"containerName":"end_hsp","name":"$data","kind":13,"line":249},{"line":250,"kind":13,"containerName":"end_hsp","name":"$data"},{"line":253,"kind":13,"localvar":"my","containerName":"end_hsp","definition":"my","name":"@a"},{"line":253,"kind":13,"name":"$data","containerName":"end_hsp"},{"kind":13,"line":254,"definition":"my","name":"$acc","containerName":"end_hsp","localvar":"my"},{"containerName":"end_hsp","name":"@a","kind":13,"line":254},{"containerName":"end_hsp","name":"$acc","kind":13,"line":256},{"containerName":"end_hsp","name":"@a","line":256,"kind":13},{"kind":13,"line":256,"name":"$acc","containerName":"end_hsp"},{"kind":13,"line":256,"name":"$acc","containerName":"end_hsp"},{"line":257,"kind":13,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","name":"$acc","kind":13,"line":257},{"name":"$data","containerName":"end_hsp","line":259,"kind":13},{"name":"$data","containerName":"end_hsp","kind":13,"line":267},{"name":"$data","containerName":"end_hsp","kind":13,"line":268},{"name":"$data","containerName":"end_hsp","kind":13,"line":269},{"line":269,"kind":13,"containerName":"end_hsp","name":"$data"},{"line":270,"kind":13,"name":"$data","containerName":"end_hsp"},{"name":"$data","containerName":"end_hsp","kind":13,"line":271},{"line":271,"kind":13,"name":"$data","containerName":"end_hsp"},{"containerName":"end_hsp","name":"$data","kind":13,"line":275},{"name":"$data","containerName":"end_hsp","line":276,"kind":13},{"containerName":"end_hsp","name":"$data","kind":13,"line":276},{"containerName":"end_hsp","name":"$data","line":277,"kind":13},{"containerName":"end_hsp","name":"$data","kind":13,"line":279},{"name":"$data","containerName":"end_hsp","kind":13,"line":280},{"containerName":"end_hsp","name":"$data","kind":13,"line":280},{"line":281,"kind":13,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","name":"$data","kind":13,"line":281},{"name":"$data","containerName":"end_hsp","line":282,"kind":13},{"kind":13,"line":282,"name":"$data","containerName":"end_hsp"},{"line":283,"kind":13,"containerName":"end_hsp","name":"$data"},{"line":283,"kind":13,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","name":"$data","line":287,"kind":13},{"containerName":"end_hsp","name":"$data","kind":13,"line":288},{"kind":13,"line":288,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","name":"$data","kind":13,"line":289},{"containerName":"end_hsp","name":"$data","kind":13,"line":291},{"name":"$data","containerName":"end_hsp","kind":13,"line":292},{"containerName":"end_hsp","name":"$data","line":294,"kind":13},{"line":294,"kind":13,"containerName":"end_hsp","name":"$data"},{"name":"$data","containerName":"end_hsp","kind":13,"line":295},{"kind":13,"line":295,"name":"$data","containerName":"end_hsp"},{"containerName":"end_hsp","name":"$data","kind":13,"line":296},{"containerName":"end_hsp","name":"$data","line":296,"kind":13},{"line":297,"kind":13,"name":"$data","containerName":"end_hsp"},{"containerName":"end_hsp","name":"$data","line":297,"kind":13},{"line":299,"kind":13,"name":"$data","containerName":"end_hsp"},{"kind":13,"line":299,"containerName":"end_hsp","name":"$data"},{"containerName":"end_hsp","name":"%args","definition":"my","localvar":"my","kind":13,"line":301},{"kind":13,"line":301,"containerName":"end_hsp","definition":"my","name":"$v","localvar":"my"},{"line":301,"kind":13,"containerName":"end_hsp","name":"$data"},{"kind":13,"line":301,"name":"$v","containerName":"end_hsp"},{"name":"$data","containerName":"end_hsp","line":302,"kind":13}],"line":239,"name":"end_hsp","range":{"end":{"line":302,"character":9999},"start":{"character":0,"line":239}}},{"line":304,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"line":304,"containerName":null,"name":"%args"},{"line":305,"kind":13,"name":"%data","containerName":null},{"line":305,"kind":13,"name":"$type","containerName":null},{"name":"%args","containerName":null,"line":307,"kind":13},{"line":307,"kind":13,"name":"%data","containerName":null},{"kind":13,"line":308,"name":"%args","containerName":null},{"kind":13,"line":308,"containerName":null,"name":"%data"},{"localvar":"my","containerName":null,"definition":"my","name":"$rank","line":309,"kind":13},{"kind":13,"line":309,"name":"%self","containerName":null},{"name":"%args","containerName":null,"kind":13,"line":310},{"name":"$rank","containerName":null,"kind":13,"line":310},{"containerName":null,"name":"%args","kind":13,"line":312},{"name":"%data","containerName":null,"kind":13,"line":312},{"name":"%args","containerName":null,"line":313,"kind":13},{"name":"%data","containerName":null,"kind":13,"line":313},{"localvar":"my","definition":"my","name":"$bits","containerName":null,"line":315,"kind":13},{"kind":13,"line":315,"name":"%args","containerName":null},{"line":316,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$hsp"},{"line":316,"kind":13,"containerName":null,"name":"%args"},{"name":"%self","containerName":null,"line":317,"kind":13},{"containerName":null,"name":"$hsp","line":317,"kind":13},{"name":"$hsp","containerName":null,"kind":13,"line":319},{"kind":12,"line":334,"children":[{"definition":"my","name":"$self","containerName":"start_hit","localvar":"my","kind":13,"line":335},{"name":"$type","containerName":"start_hit","line":335,"kind":13},{"kind":13,"line":336,"name":"$self","containerName":"start_hit"}],"containerName":"main::","definition":"sub","detail":"($self,$type)","signature":{"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref","parameters":[{"label":"$self"},{"label":"$type"}],"label":"start_hit($self,$type)"},"name":"start_hit","range":{"start":{"line":334,"character":0},"end":{"line":338,"character":9999}}},{"name":"end_hit","range":{"start":{"line":352,"character":0},"end":{"character":9999,"line":354}},"containerName":"main::","definition":"sub","detail":"($self,$type,$data)","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$data"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref","label":"end_hit($self,$type,$data)"},"kind":12,"line":352,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"end_hit","line":353,"kind":13},{"kind":13,"line":353,"name":"$type","containerName":"end_hit"},{"name":"$data","containerName":"end_hit","kind":13,"line":353},{"line":354,"kind":13,"localvar":"my","containerName":"end_hit","name":"%args","definition":"my"},{"localvar":"my","definition":"my","name":"$v","containerName":"end_hit","line":354,"kind":13},{"line":354,"kind":13,"containerName":"end_hit","name":"$data"},{"kind":13,"line":354,"name":"$v","containerName":"end_hit"},{"line":354,"kind":13,"containerName":"end_hit","name":"$data"}]},{"containerName":null,"name":"%args","line":358,"kind":13},{"name":"%args","containerName":null,"kind":13,"line":358},{"line":359,"kind":13,"name":"%args","containerName":null},{"containerName":null,"name":"%args","line":359,"kind":13},{"containerName":null,"name":"%args","line":359,"kind":13},{"kind":13,"line":361,"containerName":null,"name":"%args"},{"containerName":null,"name":"%args","kind":13,"line":361},{"name":"%data","containerName":null,"kind":13,"line":362},{"line":362,"kind":13,"containerName":null,"name":"$type"},{"containerName":null,"name":"%args","line":363,"kind":13},{"line":363,"kind":13,"name":"%self","containerName":null},{"line":364,"kind":13,"containerName":null,"name":"%args"},{"kind":13,"line":364,"containerName":null,"name":"%data"},{"line":365,"kind":13,"name":"%args","containerName":null},{"kind":13,"line":365,"containerName":null,"name":"%self"},{"name":"%args","containerName":null,"line":366,"kind":13},{"line":367,"kind":13,"name":"%args","containerName":null},{"line":368,"kind":13,"name":"%args","containerName":null},{"name":"%args","containerName":null,"kind":13,"line":370},{"name":"%args","containerName":null,"kind":13,"line":370},{"kind":13,"line":370,"containerName":null,"name":"%args"},{"localvar":"my","definition":"my","name":"$hit","containerName":null,"line":373,"kind":13},{"line":373,"kind":13,"containerName":null,"name":"%args"},{"name":"%hit","containerName":null,"kind":13,"line":374},{"containerName":null,"name":"$self","line":374,"kind":13},{"kind":12,"line":374,"name":"factory","containerName":"main::"},{"line":375,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":375,"name":"_add_hit","containerName":"main::"},{"line":375,"kind":13,"containerName":null,"name":"$hit"},{"name":"%self","containerName":null,"kind":13,"line":376},{"line":377,"kind":13,"name":"$hit","containerName":null},{"range":{"end":{"character":9999,"line":383},"start":{"line":381,"character":0}},"name":"_add_hit","children":[{"kind":13,"line":382,"name":"$self","definition":"my","containerName":"_add_hit","localvar":"my"},{"kind":13,"line":382,"containerName":"_add_hit","name":"$hit"},{"kind":13,"line":383,"containerName":"_add_hit","name":"$self"}],"line":381,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$hit"}],"documentation":" TODO: Optionally impose hit filtering here","label":"_add_hit($self,$hit)"},"detail":"($self,$hit)","definition":"sub","containerName":"main::"},{"name":"$hit","containerName":null,"line":383,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":384},{"name":"%self","containerName":null,"line":384,"kind":13},{"name":"register_factory","range":{"end":{"character":9999,"line":411},"start":{"line":404,"character":0}},"kind":12,"children":[{"containerName":"register_factory","name":"$self","definition":"my","localvar":"my","kind":13,"line":405},{"line":405,"kind":13,"containerName":"register_factory","name":"$type"},{"containerName":"register_factory","name":"$f","kind":13,"line":405},{"containerName":"register_factory","name":"$f","kind":13,"line":406},{"containerName":"register_factory","name":"$f","kind":13,"line":406},{"name":"$f","containerName":"register_factory","line":407,"kind":13},{"line":407,"kind":12,"name":"isa","containerName":"register_factory"},{"name":"$self","containerName":"register_factory","kind":13,"line":408},{"line":408,"kind":12,"name":"throw","containerName":"register_factory"},{"kind":13,"line":408,"containerName":"register_factory","name":"$f"},{"line":410,"kind":13,"name":"$self","containerName":"register_factory"},{"kind":13,"line":410,"containerName":"register_factory","name":"$type"},{"line":410,"kind":13,"containerName":"register_factory","name":"$f"}],"line":404,"definition":"sub","containerName":"main::","signature":{"label":"register_factory($self,$type,$f)","documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n\n    # I hate special cases, but this is here because NCBI BLAST XML\n    # doesn't play nice and is undergoing mutation -jason\n    if(exists $args{'-name'} && $args{'-name'} =~ /BL_ORD_ID/ ) {\n        ($args{'-name'}, $args{'-description'}) = split(/\\s+/,$args{'-description'},2);\n    }\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hsps'}      = $self->{'_hsps'};\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    $args{'-rank'}      = $self->{'_hitcount'} + 1;\n    unless( defined $args{'-significance'} ) {\n        if( defined $args{'-hsps'} && \n            $args{'-hsps'}->[0] ) {\n            # use pvalue if present (WU-BLAST), otherwise evalue (NCBI BLAST)\n            $args{'-significance'} = $args{'-hsps'}->[0]->{'-pvalue'} || $args{'-hsps'}->[0]->{'-evalue'};\n        }\n    }\n    my $hit = \\%args;\n    $hit->{'-hsp_factory'} = $self->factory('hsp');\n    $self->_add_hit($hit);\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n# TODO: Optionally impose hit filtering here\nsub _add_hit {\n    my ($self, $hit) = @_;\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hitcount'} = scalar @{$self->{'_hits'}};\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$f"}]},"detail":"($self,$type,$f)"},{"name":"factory","range":{"end":{"character":9999,"line":432},"start":{"line":427,"character":0}},"kind":12,"children":[{"line":428,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"factory"},{"kind":13,"line":428,"containerName":"factory","name":"$type"},{"line":429,"kind":13,"containerName":"factory","name":"$self"},{"containerName":"factory","name":"$type","kind":13,"line":429},{"name":"$self","containerName":"factory","line":430,"kind":13},{"containerName":"factory","name":"throw","kind":12,"line":430}],"line":427,"definition":"sub","containerName":"main::","signature":{"label":"factory($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: SearchResultEventBuilder.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::SearchResultEventBuilder\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::SearchResultEventBuilder - Event Handler for SearchIO events.\n\n=head1 SYNOPSIS\n\n# Do not use this object directly, this object is part of the SearchIO\n# event based parsing system.\n\n=head1 DESCRIPTION\n\nThis object handles Search Events generated by the SearchIO classes\nand build appropriate Bio::Search::* objects from them.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::SearchResultEventBuilder;\nuse vars qw(%KNOWNEVENTS);\nuse strict;\n\nuse Bio::Factory::ObjectFactory;\n\nuse base qw(Bio::Root::Root Bio::SearchIO::EventHandlerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::SearchResultEventBuilder->new();\n Function: Builds a new Bio::SearchIO::SearchResultEventBuilder object \n Returns : Bio::SearchIO::SearchResultEventBuilder\n Args    : -hsp_factory    => Bio::Factory::ObjectFactoryI\n           -hit_factory    => Bio::Factory::ObjectFactoryI\n           -result_factory => Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub new { \n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($hspF,$hitF,$resultF) = $self->_rearrange([qw(HSP_FACTORY\n                                                      HIT_FACTORY\n                                                      RESULT_FACTORY)],@args);\n    $self->register_factory('hsp', $hspF || \n                            Bio::Factory::ObjectFactory->new(\n                                     -type      => 'Bio::Search::HSP::GenericHSP',\n                                     -interface => 'Bio::Search::HSP::HSPI'));\n\n    $self->register_factory('hit', $hitF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Hit::GenericHit',\n                                      -interface => 'Bio::Search::Hit::HitI'));\n\n    $self->register_factory('result', $resultF ||\n                            Bio::Factory::ObjectFactory->new(\n                                      -type      => 'Bio::Search::Result::GenericResult',\n                                      -interface => 'Bio::Search::Result::ResultI'));\n\n    return $self;\n}\n\n# new comes from the superclass\n\n=head2 will_handle\n\n Title   : will_handle\n Usage   : if( $handler->will_handle($event_type) ) { ... }\n Function: Tests if this event builder knows how to process a specific event\n Returns : boolean\n Args    : event type name\n\n\n\nsub will_handle{\n   my ($self,$type) = @_;\n   # these are the events we recognize\n   return ( $type eq 'hsp' || $type eq 'hit' || $type eq 'result' );\n}\n\n=head2 SAX methods\n\n\n=head2 start_result\n\n Title   : start_result\n Usage   : $handler->start_result($resulttype)\n Function: Begins a result event cycle\n Returns : none \n Args    : Type of Report\n\n\nsub start_result {\n   my ($self,$type) = @_;\n   $self->{'_resulttype'} = $type;\n   $self->{'_hits'} = [];   \n   $self->{'_hsps'} = [];\n   $self->{'_hitcount'} = 0;\n   return;\n}\n\n=head2 end_result\n\n Title   : end_result\n Usage   : my @results = $parser->end_result\n Function: Finishes a result handler cycle \n Returns : A Bio::Search::Result::ResultI\n Args    : none\n\n\n# this is overridden by IteratedSearchResultEventBuilder\n# so keep that in mind when debugging\n\nsub end_result {\n    my ($self,$type,$data) = @_;    \n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n    my %args = map { my $v = $data->{$_}; s/RESULT//; ($_ => $v); } \n               grep { /^RESULT/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hits'}      =  $self->{'_hits'};\n    my $result = $self->factory('result')->create_object(%args);\n    $result->hit_factory($self->factory('hit'));\n    $self->{'_hits'} = [];\n    return $result;\n}\n\n=head2 start_hsp\n\n Title   : start_hsp\n Usage   : $handler->start_hsp($name,$data)\n Function: Begins processing a HSP event\n Returns : none\n Args    : type of element \n           associated data (hashref)\n\n\nsub start_hsp {\n    my ($self,@args) = @_;\n    return;\n}\n\n=head2 end_hsp\n\n Title   : end_hsp\n Usage   : $handler->end_hsp()\n Function: Finish processing a HSP event\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub end_hsp {\n    my ($self,$type,$data) = @_;\n\n    if( defined $data->{'runid'} &&\n        $data->{'runid'} !~ /^\\s+$/ ) {        \n\n        if( $data->{'runid'} !~ /^lcl\\|/) { \n            $data->{\"RESULT-query_name\"}= $data->{'runid'};\n        } else { \n            ($data->{\"RESULT-query_name\"},\n\t     $data->{\"RESULT-query_description\"}) = \n\t\t split(/\\s+/,$data->{\"RESULT-query_description\"},2);\n        }\n        \n        if( my @a = split(/\\|/,$data->{'RESULT-query_name'}) ) {\n            my $acc = pop @a ; # this is for accession |1234|gb|AAABB1.1|AAABB1\n            # this is for |123|gb|ABC1.1|\n            $acc = pop @a if( ! defined $acc || $acc =~ /^\\s+$/);\n            $data->{\"RESULT-query_accession\"}= $acc;\n        }\n        delete $data->{'runid'};\n    }\n\n    # this code is to deal with the fact that Blast XML data\n    # always has start < end and one has to infer strandedness\n    # from the frame which is a problem for the Search::HSP object\n    # which expect to be able to infer strand from the order of \n    # of the begin/end of the query and hit coordinates\n    if( defined $data->{'HSP-query_frame'} && # this is here to protect from undefs\n        (( $data->{'HSP-query_frame'} < 0 && \n           $data->{'HSP-query_start'} < $data->{'HSP-query_end'} ) ||       \n         $data->{'HSP-query_frame'} > 0 && \n         ( $data->{'HSP-query_start'} > $data->{'HSP-query_end'} ) ) \n        )\n    { \n        # swap\n        ($data->{'HSP-query_start'},\n         $data->{'HSP-query_end'}) = ($data->{'HSP-query_end'},\n                                      $data->{'HSP-query_start'});\n    } \n    if( defined $data->{'HSP-hit_frame'} && # this is here to protect from undefs\n        ((defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} < 0 && \n          $data->{'HSP-hit_start'} < $data->{'HSP-hit_end'} ) ||       \n         defined $data->{'HSP-hit_frame'} && $data->{'HSP-hit_frame'} > 0 && \n         ( $data->{'HSP-hit_start'} > $data->{'HSP-hit_end'} ) )\n        ) \n    { \n        # swap\n        ($data->{'HSP-hit_start'},\n         $data->{'HSP-hit_end'}) = ($data->{'HSP-hit_end'},\n                                    $data->{'HSP-hit_start'});\n    }\n    $data->{'HSP-query_frame'} ||= 0;\n    $data->{'HSP-hit_frame'} ||= 0;\n    # handle Blast 2.1.2 which did not support data member: hsp_align-len\n    $data->{'HSP-query_length'} ||= $data->{'RESULT-query_length'};\n    $data->{'HSP-query_length'} ||= length ($data->{'HSP-query_seq'} || '');\n    $data->{'HSP-hit_length'}   ||= $data->{'HIT-length'};\n    $data->{'HSP-hit_length'}   ||= length ($data->{'HSP-hit_seq'} || '');\n    \n    $data->{'HSP-hsp_length'}   ||= length ($data->{'HSP-homology_seq'} || '');\n    \n    my %args = map { my $v = $data->{$_}; s/HSP//; ($_ => $v) } \n               grep { /^HSP/ } keys %{$data};\n    \n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    # copy this over from result\n    $args{'-query_name'} = $data->{'RESULT-query_name'};\n    $args{'-hit_name'} = $data->{'HIT-name'};\n    my ($rank) = scalar @{$self->{'_hsps'} || []} + 1;\n    $args{'-rank'} = $rank;\n    \n    $args{'-hit_desc'} = $data->{'HIT-description'};\n    $args{'-query_desc'} = $data->{'RESULT-query_description'};\n    \n    my $bits = $args{'-bits'};\n    my $hsp = \\%args;\n    push @{$self->{'_hsps'}}, $hsp;\n    \n    return $hsp;\n}\n\n\n=head2 start_hit\n\n Title   : start_hit\n Usage   : $handler->start_hit()\n Function: Starts a Hit event cycle\n Returns : none\n Args    : type of event and associated hashref\n\n\n\nsub start_hit{\n    my ($self,$type) = @_;\n    $self->{'_hsps'} = [];\n    return;\n}\n\n\n=head2 end_hit\n\n Title   : end_hit\n Usage   : $handler->end_hit()\n Function: Ends a Hit event cycle\n Returns : Bio::Search::Hit::HitI object\n Args    : type of event and associated hashref\n\n\n\nsub end_hit{\n    my ($self,$type,$data) = @_;   \n    my %args = map { my $v = $data->{$_}; s/HIT//; ($_ => $v); } grep { /^HIT/ } keys %{$data};\n\n    # I hate special cases, but this is here because NCBI BLAST XML\n    # doesn't play nice and is undergoing mutation -jason\n    if(exists $args{'-name'} && $args{'-name'} =~ /BL_ORD_ID/ ) {\n        ($args{'-name'}, $args{'-description'}) = split(/\\s+/,$args{'-description'},2);\n    }\n    $args{'-algorithm'} =  uc( $args{'-algorithm_name'} || \n                               $data->{'RESULT-algorithm_name'} || $type);\n    $args{'-hsps'}      = $self->{'_hsps'};\n    $args{'-query_len'} =  $data->{'RESULT-query_length'};\n    $args{'-rank'}      = $self->{'_hitcount'} + 1;\n    unless( defined $args{'-significance'} ) {\n        if( defined $args{'-hsps'} && \n            $args{'-hsps'}->[0] ) {\n            # use pvalue if present (WU-BLAST), otherwise evalue (NCBI BLAST)\n            $args{'-significance'} = $args{'-hsps'}->[0]->{'-pvalue'} || $args{'-hsps'}->[0]->{'-evalue'};\n        }\n    }\n    my $hit = \\%args;\n    $hit->{'-hsp_factory'} = $self->factory('hsp');\n    $self->_add_hit($hit);\n    $self->{'_hsps'} = [];\n    return $hit;\n}\n\n# TODO: Optionally impose hit filtering here\nsub _add_hit {\n    my ($self, $hit) = @_;\n    push @{$self->{'_hits'}}, $hit;\n    $self->{'_hitcount'} = scalar @{$self->{'_hits'}};\n}\n\n=head2 Factory methods\n\n\n=head2 register_factory\n\n Title   : register_factory\n Usage   : $handler->register_factory('TYPE',$factory);\n Function: Register a specific factory for a object type class\n Returns : none\n Args    : string representing the class and\n           Bio::Factory::ObjectFactoryI\n\nSee L<Bio::Factory::ObjectFactoryI> for more information\n\n\nsub register_factory{\n   my ($self, $type,$f) = @_;\n   if( ! defined $f || ! ref($f) || \n       ! $f->isa('Bio::Factory::ObjectFactoryI') ) { \n       $self->throw(\"Cannot set factory to value $f\".ref($f).\"\\n\");\n   }\n   $self->{'_factories'}->{lc($type)} = $f;\n}\n\n\n=head2 factory\n\n Title   : factory\n Usage   : my $f = $handler->factory('TYPE');\n Function: Retrieves the associated factory for requested 'TYPE'\n Returns : a Bio::Factory::ObjectFactoryI \n Throws  : Bio::Root::BadParameter if none registered for the supplied type\n Args    : name of factory class to retrieve\n\nSee L<Bio::Factory::ObjectFactoryI> for more information"},"detail":"($self,$type)"},{"range":{"start":{"character":0,"line":440},"end":{"character":9999,"line":444}},"definition":"sub","name":"inclusion_threshold","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"inclusion_threshold","line":441,"kind":13},{"containerName":"inclusion_threshold","name":"$self","line":442,"kind":13},{"containerName":"inclusion_threshold","name":"$self","line":443,"kind":13}],"line":440,"kind":12}]}