{"vars":[{"kind":2,"line":147,"name":"base","containerName":""},{"name":"new","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":166},"end":{"line":201,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"new","definition":"my","name":"$class","line":167,"kind":13},{"definition":"my","name":"@args","containerName":"new","localvar":"my","kind":13,"line":168},{"line":169,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"line":169,"kind":13,"containerName":"new","name":"$class"},{"line":169,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":170,"containerName":"new","definition":"my","name":"$hit","localvar":"my"},{"kind":13,"line":170,"name":"$filter","containerName":"new"},{"containerName":"new","name":"$self","line":170,"kind":13},{"containerName":"new","name":"_rearrange","line":170,"kind":12},{"kind":13,"line":170,"name":"@args","containerName":"new"},{"line":172,"kind":13,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":172},{"containerName":"new","name":"$hit","line":172,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":173},{"name":"throw","containerName":"new","kind":12,"line":173},{"line":173,"kind":13,"containerName":"new","name":"$hit"},{"containerName":"new","name":"$hit","line":173,"kind":13},{"kind":12,"line":173,"name":"isa","containerName":"new"},{"line":174,"kind":13,"name":"$self","containerName":"new"},{"line":174,"kind":13,"containerName":"new","name":"$hit"},{"kind":13,"line":175,"containerName":"new","name":"$self"},{"kind":12,"line":175,"containerName":"new","name":"_set_attributes"},{"containerName":"new","name":"$self","kind":13,"line":176},{"containerName":"new","name":"$hit","line":176,"kind":13},{"line":176,"kind":12,"containerName":"new","name":"algorithm"},{"line":178,"kind":13,"localvar":"my","name":"@hsps","definition":"my","containerName":"new"},{"name":"$hit","containerName":"new","kind":13,"line":178},{"kind":12,"line":178,"containerName":"new","name":"hsps"},{"containerName":"new","name":"$filter","line":180,"kind":13},{"kind":13,"line":181,"name":"$filter","containerName":"new"},{"name":"@hsps","containerName":"new","line":182,"kind":13},{"kind":13,"line":182,"containerName":"new","name":"$filter"},{"containerName":"new","name":"@hsps","line":182,"kind":13},{"kind":13,"line":185,"containerName":"new","name":"$self"},{"kind":12,"line":185,"name":"warn","containerName":"new"},{"kind":13,"line":190,"containerName":"new","definition":"my","name":"$t","localvar":"my"},{"localvar":"my","definition":"my","name":"%contexts","containerName":"new","line":191,"kind":13},{"localvar":"my","containerName":"new","name":"$i","definition":"my","line":192,"kind":13},{"line":193,"kind":13,"localvar":"my","name":"$ctxt","definition":"my","containerName":"new"},{"kind":13,"line":193,"containerName":"new","name":"$self"},{"name":"_context","containerName":"new","line":193,"kind":12},{"line":194,"kind":13,"containerName":"new","name":"$t"},{"line":195,"kind":13,"name":"$hsps","containerName":"new"},{"name":"$i","containerName":"new","kind":13,"line":195},{"kind":12,"line":195,"containerName":"new","name":"strand"},{"line":195,"kind":13,"name":"$t","containerName":"new"},{"containerName":"new","name":"$hsps","line":196,"kind":13},{"line":196,"kind":13,"containerName":"new","name":"$i"},{"kind":12,"line":196,"name":"frame","containerName":"new"},{"name":"$t","containerName":"new","kind":13,"line":196},{"name":"$contexts","containerName":"new","kind":13,"line":197},{"name":"$ctxt","containerName":"new","line":197,"kind":13},{"line":198,"kind":13,"containerName":"new","name":"$contexts"},{"line":198,"kind":13,"name":"$ctxt","containerName":"new"},{"line":198,"kind":13,"name":"$i","containerName":"new"},{"line":200,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"%contexts","kind":13,"line":200}],"line":166},{"containerName":"new","name":"SUPER","kind":12,"line":169},{"name":"hit","line":174,"kind":12},{"kind":12,"line":192,"name":"hsps"},{"name":"$self","containerName":null,"line":203,"kind":13},{"containerName":"main::","name":"warn","line":203,"kind":12},{"line":203,"kind":13,"containerName":null,"name":"@hsps"},{"kind":13,"line":204,"containerName":null,"name":"$self"},{"containerName":"main::","name":"hsps","line":204,"kind":12},{"name":"@hsps","containerName":null,"line":204,"kind":13},{"containerName":null,"name":"$self","line":205,"kind":13},{"signature":{"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'","parameters":[{"label":"$type"},{"label":"$context"}],"label":"next_tiling($type,$context)"},"detail":"($type,$context)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"next_tiling","localvar":"my","kind":13,"line":227},{"containerName":"next_tiling","name":"$type","definition":"my","localvar":"my","kind":13,"line":228},{"name":"$context","containerName":"next_tiling","line":228,"kind":13},{"kind":13,"line":229,"name":"$self","containerName":"next_tiling"},{"line":229,"kind":12,"name":"_check_type_arg","containerName":"next_tiling"},{"name":"$type","containerName":"next_tiling","kind":13,"line":229},{"name":"$self","containerName":"next_tiling","line":230,"kind":13},{"kind":12,"line":230,"containerName":"next_tiling","name":"_check_context_arg"},{"line":230,"kind":13,"name":"$type","containerName":"next_tiling"},{"kind":13,"line":230,"name":"$context","containerName":"next_tiling"},{"line":231,"kind":13,"name":"$self","containerName":"next_tiling"},{"containerName":"next_tiling","name":"_tiling_iterator","line":231,"kind":12},{"line":231,"kind":13,"name":"$type","containerName":"next_tiling"},{"kind":13,"line":231,"name":"$context","containerName":"next_tiling"}],"line":226,"kind":12,"range":{"start":{"line":226,"character":0},"end":{"line":232,"character":9999}},"name":"next_tiling"},{"range":{"start":{"character":0,"line":246},"end":{"line":252,"character":9999}},"name":"rewind_tilings","children":[{"kind":13,"line":247,"containerName":"rewind_tilings","name":"$self","definition":"my","localvar":"my"},{"name":"$type","definition":"my","containerName":"rewind_tilings","localvar":"my","kind":13,"line":248},{"containerName":"rewind_tilings","name":"$context","kind":13,"line":248},{"line":249,"kind":13,"containerName":"rewind_tilings","name":"$self"},{"kind":12,"line":249,"name":"_check_type_arg","containerName":"rewind_tilings"},{"name":"$type","containerName":"rewind_tilings","line":249,"kind":13},{"containerName":"rewind_tilings","name":"$self","line":250,"kind":13},{"line":250,"kind":12,"containerName":"rewind_tilings","name":"_check_context_arg"},{"containerName":"rewind_tilings","name":"$type","kind":13,"line":250},{"containerName":"rewind_tilings","name":"$context","kind":13,"line":250},{"containerName":"rewind_tilings","name":"$self","kind":13,"line":251},{"containerName":"rewind_tilings","name":"_tiling_iterator","line":251,"kind":12},{"name":"$type","containerName":"rewind_tilings","kind":13,"line":251},{"containerName":"rewind_tilings","name":"$context","kind":13,"line":251}],"line":246,"kind":12,"signature":{"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'","parameters":[{"label":"$type"},{"label":"$context"}],"label":"rewind_tilings($type,$context)"},"detail":"($type,$context)","definition":"sub","containerName":"main::"},{"kind":12,"line":272,"children":[{"containerName":"identities","name":"$self","definition":"my","localvar":"my","kind":13,"line":273},{"line":274,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"identities"},{"containerName":"identities","name":"$action","kind":13,"line":274},{"kind":13,"line":274,"name":"$context","containerName":"identities"},{"name":"$self","containerName":"identities","line":275,"kind":13},{"kind":12,"line":275,"name":"_check_type_arg","containerName":"identities"},{"line":275,"kind":13,"containerName":"identities","name":"$type"},{"name":"$self","containerName":"identities","line":276,"kind":13},{"line":276,"kind":12,"name":"_check_action_arg","containerName":"identities"},{"name":"$action","containerName":"identities","line":276,"kind":13},{"containerName":"identities","name":"$self","line":277,"kind":13},{"containerName":"identities","name":"_check_context_arg","kind":12,"line":277},{"line":277,"kind":13,"name":"$type","containerName":"identities"},{"kind":13,"line":277,"containerName":"identities","name":"$context"},{"kind":13,"line":278,"containerName":"identities","name":"$self"},{"name":"$self","containerName":"identities","line":279,"kind":13},{"line":279,"kind":12,"name":"_calc_stats","containerName":"identities"},{"line":279,"kind":13,"containerName":"identities","name":"$type"},{"containerName":"identities","name":"$action","kind":13,"line":279},{"name":"$context","containerName":"identities","line":279,"kind":13},{"line":281,"kind":13,"name":"$self","containerName":"identities"}],"containerName":"main::","definition":"sub","detail":"($type,$action,$context)","signature":{"label":"identities($type,$action,$context)","parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only"},"name":"identities","range":{"end":{"character":9999,"line":282},"start":{"character":0,"line":272}}},{"range":{"start":{"character":0,"line":300},"end":{"line":310,"character":9999}},"name":"conserved","children":[{"line":301,"kind":13,"localvar":"my","containerName":"conserved","definition":"my","name":"$self"},{"kind":13,"line":302,"containerName":"conserved","definition":"my","name":"$type","localvar":"my"},{"containerName":"conserved","name":"$action","line":302,"kind":13},{"containerName":"conserved","name":"$context","line":302,"kind":13},{"kind":13,"line":303,"name":"$self","containerName":"conserved"},{"kind":12,"line":303,"containerName":"conserved","name":"_check_type_arg"},{"containerName":"conserved","name":"$type","line":303,"kind":13},{"line":304,"kind":13,"containerName":"conserved","name":"$self"},{"line":304,"kind":12,"containerName":"conserved","name":"_check_action_arg"},{"name":"$action","containerName":"conserved","kind":13,"line":304},{"line":305,"kind":13,"name":"$self","containerName":"conserved"},{"containerName":"conserved","name":"_check_context_arg","kind":12,"line":305},{"kind":13,"line":305,"name":"$type","containerName":"conserved"},{"name":"$context","containerName":"conserved","kind":13,"line":305},{"name":"$self","containerName":"conserved","line":306,"kind":13},{"containerName":"conserved","name":"$self","kind":13,"line":307},{"name":"_calc_stats","containerName":"conserved","kind":12,"line":307},{"name":"$type","containerName":"conserved","kind":13,"line":307},{"name":"$action","containerName":"conserved","line":307,"kind":13},{"line":307,"kind":13,"name":"$context","containerName":"conserved"},{"containerName":"conserved","name":"$self","line":309,"kind":13}],"line":300,"kind":12,"signature":{"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only ","parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"label":"conserved($type,$action,$context)"},"detail":"($type,$action,$context)","definition":"sub","containerName":"main::"},{"line":329,"children":[{"definition":"my","name":"$self","containerName":"length","localvar":"my","kind":13,"line":330},{"line":331,"kind":13,"localvar":"my","containerName":"length","name":"$type","definition":"my"},{"line":331,"kind":13,"name":"$action","containerName":"length"},{"kind":13,"line":331,"name":"$context","containerName":"length"},{"kind":13,"line":332,"containerName":"length","name":"$self"},{"kind":12,"line":332,"name":"_check_type_arg","containerName":"length"},{"name":"$type","containerName":"length","line":332,"kind":13},{"name":"$self","containerName":"length","line":333,"kind":13},{"line":333,"kind":12,"containerName":"length","name":"_check_action_arg"},{"containerName":"length","name":"$action","kind":13,"line":333},{"name":"$self","containerName":"length","line":334,"kind":13},{"name":"_check_context_arg","containerName":"length","line":334,"kind":12},{"containerName":"length","name":"$type","line":334,"kind":13},{"containerName":"length","name":"$context","kind":13,"line":334},{"name":"$self","containerName":"length","kind":13,"line":335},{"containerName":"length","name":"$self","kind":13,"line":336},{"name":"_calc_stats","containerName":"length","line":336,"kind":12},{"containerName":"length","name":"$type","line":336,"kind":13},{"name":"$action","containerName":"length","kind":13,"line":336},{"containerName":"length","name":"$context","kind":13,"line":336},{"kind":13,"line":338,"name":"$self","containerName":"length"}],"kind":12,"detail":"($type,$action,$context)","signature":{"label":"length($type,$action,$context)","parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only "},"containerName":"main::","definition":"sub","range":{"start":{"line":329,"character":0},"end":{"character":9999,"line":339}},"name":"length"},{"children":[{"kind":13,"line":365,"name":"$self","definition":"my","containerName":"frac","localvar":"my"},{"line":366,"kind":13,"localvar":"my","definition":"my","name":"@args","containerName":"frac"},{"localvar":"my","containerName":"frac","name":"$type","definition":"my","line":367,"kind":13},{"kind":13,"line":367,"containerName":"frac","name":"$denom"},{"name":"$action","containerName":"frac","kind":13,"line":367},{"line":367,"kind":13,"containerName":"frac","name":"$context"},{"kind":13,"line":367,"name":"$method","containerName":"frac"},{"kind":13,"line":367,"name":"$self","containerName":"frac"},{"containerName":"frac","name":"_rearrange","line":367,"kind":12},{"containerName":"frac","name":"@args","kind":13,"line":367},{"line":368,"kind":13,"containerName":"frac","name":"$self"},{"kind":12,"line":368,"containerName":"frac","name":"_check_type_arg"},{"kind":13,"line":368,"containerName":"frac","name":"$type"},{"containerName":"frac","name":"$self","kind":13,"line":369},{"kind":12,"line":369,"containerName":"frac","name":"_check_action_arg"},{"kind":13,"line":369,"name":"$action","containerName":"frac"},{"containerName":"frac","name":"$self","line":370,"kind":13},{"containerName":"frac","name":"_check_context_arg","kind":12,"line":370},{"kind":13,"line":370,"containerName":"frac","name":"$type"},{"line":370,"kind":13,"containerName":"frac","name":"$context"},{"name":"$method","containerName":"frac","kind":13,"line":371},{"kind":13,"line":372,"containerName":"frac","name":"$self"},{"containerName":"frac","name":"throw","kind":12,"line":372},{"containerName":"frac","name":"$denom","line":374,"kind":13},{"kind":13,"line":376,"name":"$self","containerName":"frac"},{"containerName":"frac","name":"throw","kind":12,"line":376},{"line":378,"kind":13,"localvar":"my","containerName":"frac","name":"$key","definition":"my"},{"kind":13,"line":379,"definition":"my","name":"$stat","containerName":"frac","localvar":"my"},{"containerName":"frac","name":"$method","line":380,"kind":13},{"kind":13,"line":382,"containerName":"frac","name":"$stat"},{"kind":13,"line":382,"name":"$self","containerName":"frac"},{"kind":12,"line":382,"name":"identities","containerName":"frac"},{"line":382,"kind":13,"name":"$type","containerName":"frac"},{"containerName":"frac","name":"$action","line":382,"kind":13},{"containerName":"frac","name":"$context","kind":13,"line":382},{"line":386,"kind":13,"containerName":"frac","name":"$stat"},{"containerName":"frac","name":"$self","line":386,"kind":13},{"kind":12,"line":386,"containerName":"frac","name":"conserved"},{"name":"$type","containerName":"frac","line":386,"kind":13},{"kind":13,"line":386,"name":"$action","containerName":"frac"},{"kind":13,"line":386,"name":"$context","containerName":"frac"},{"line":390,"kind":13,"containerName":"frac","name":"$self"},{"containerName":"frac","name":"throw","kind":12,"line":390},{"kind":13,"line":393,"name":"$self","containerName":"frac"},{"name":"$key","containerName":"frac","line":393,"kind":13},{"line":394,"kind":13,"name":"$denom","containerName":"frac"},{"line":396,"kind":13,"containerName":"frac","name":"$self"},{"kind":13,"line":396,"containerName":"frac","name":"$key"},{"name":"$stat","containerName":"frac","kind":13,"line":397},{"name":"$self","containerName":"frac","line":397,"kind":13},{"name":"_reported_length","containerName":"frac","line":397,"kind":12},{"containerName":"frac","name":"$type","kind":13,"line":397},{"name":"$self","containerName":"frac","line":401,"kind":13},{"name":"$key","containerName":"frac","line":401,"kind":13},{"name":"$stat","containerName":"frac","kind":13,"line":402},{"containerName":"frac","name":"$self","kind":13,"line":402},{"containerName":"frac","name":"length","kind":12,"line":402},{"containerName":"frac","name":"$type","line":402,"kind":13},{"line":402,"kind":13,"name":"$action","containerName":"frac"},{"containerName":"frac","name":"$context","line":402,"kind":13},{"kind":13,"line":406,"containerName":"frac","name":"$self"},{"containerName":"frac","name":"throw","kind":12,"line":406},{"containerName":"frac","name":"$self","line":410,"kind":13},{"containerName":"frac","name":"$key","kind":13,"line":410}],"line":364,"kind":12,"range":{"start":{"line":364,"character":0},"end":{"line":411,"character":9999}},"name":"frac","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":440},"start":{"character":0,"line":435}},"definition":"sub","name":"frac_identical","containerName":"main::","children":[{"kind":13,"line":436,"containerName":"frac_identical","name":"$self","definition":"my","localvar":"my"},{"name":"@args","definition":"my","containerName":"frac_identical","localvar":"my","kind":13,"line":437},{"line":438,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$denom","line":438,"kind":13},{"name":"$action","containerName":"frac_identical","kind":13,"line":438},{"name":"$context","containerName":"frac_identical","kind":13,"line":438},{"kind":13,"line":438,"name":"$self","containerName":"frac_identical"},{"name":"_rearrange","containerName":"frac_identical","kind":12,"line":438},{"kind":13,"line":438,"name":"@args","containerName":"frac_identical"},{"line":439,"kind":13,"containerName":"frac_identical","name":"$self"},{"kind":12,"line":439,"containerName":"frac_identical","name":"frac"},{"kind":13,"line":439,"containerName":"frac_identical","name":"$type"},{"kind":13,"line":439,"containerName":"frac_identical","name":"$denom"},{"line":439,"kind":13,"containerName":"frac_identical","name":"$action"},{"name":"$context","containerName":"frac_identical","kind":13,"line":439}],"line":435,"kind":12},{"line":464,"children":[{"line":465,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"frac_conserved"},{"localvar":"my","containerName":"frac_conserved","definition":"my","name":"@args","line":466,"kind":13},{"localvar":"my","name":"$type","definition":"my","containerName":"frac_conserved","line":467,"kind":13},{"line":467,"kind":13,"containerName":"frac_conserved","name":"$denom"},{"containerName":"frac_conserved","name":"$action","line":467,"kind":13},{"kind":13,"line":467,"name":"$context","containerName":"frac_conserved"},{"kind":13,"line":467,"containerName":"frac_conserved","name":"$self"},{"name":"_rearrange","containerName":"frac_conserved","line":467,"kind":12},{"line":467,"kind":13,"name":"@args","containerName":"frac_conserved"},{"name":"$self","containerName":"frac_conserved","kind":13,"line":468},{"containerName":"frac_conserved","name":"frac","kind":12,"line":468},{"containerName":"frac_conserved","name":"$type","kind":13,"line":468},{"containerName":"frac_conserved","name":"$denom","kind":13,"line":468},{"line":468,"kind":13,"containerName":"frac_conserved","name":"$action"},{"line":468,"kind":13,"name":"$context","containerName":"frac_conserved"}],"kind":12,"range":{"end":{"character":9999,"line":469},"start":{"line":464,"character":0}},"containerName":"main::","name":"frac_conserved","definition":"sub"},{"signature":{"label":"frac_aligned($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":489,"name":"$self","definition":"my","containerName":"frac_aligned","localvar":"my"},{"name":"@args","containerName":"frac_aligned","line":489,"kind":13},{"line":490,"kind":13,"localvar":"my","definition":"my","name":"$type","containerName":"frac_aligned"},{"containerName":"frac_aligned","name":"$action","line":490,"kind":13},{"line":490,"kind":13,"containerName":"frac_aligned","name":"$context"},{"line":490,"kind":13,"containerName":"frac_aligned","name":"$self"},{"containerName":"frac_aligned","name":"_rearrange","kind":12,"line":490},{"line":490,"kind":13,"name":"@args","containerName":"frac_aligned"},{"line":491,"kind":13,"containerName":"frac_aligned","name":"$self"},{"kind":12,"line":491,"containerName":"frac_aligned","name":"_check_type_arg"},{"kind":13,"line":491,"containerName":"frac_aligned","name":"$type"},{"line":492,"kind":13,"name":"$self","containerName":"frac_aligned"},{"containerName":"frac_aligned","name":"_check_action_arg","line":492,"kind":12},{"line":492,"kind":13,"name":"$action","containerName":"frac_aligned"},{"line":493,"kind":13,"containerName":"frac_aligned","name":"$self"},{"line":493,"kind":12,"containerName":"frac_aligned","name":"_check_context_arg"},{"containerName":"frac_aligned","name":"$type","kind":13,"line":493},{"kind":13,"line":493,"name":"$context","containerName":"frac_aligned"},{"kind":13,"line":494,"containerName":"frac_aligned","name":"$self"},{"containerName":"frac_aligned","name":"$self","kind":13,"line":495},{"name":"$self","containerName":"frac_aligned","kind":13,"line":495},{"line":495,"kind":12,"containerName":"frac_aligned","name":"num_aligned"},{"containerName":"frac_aligned","name":"$type","line":495,"kind":13},{"line":495,"kind":13,"containerName":"frac_aligned","name":"$action"},{"name":"$context","containerName":"frac_aligned","kind":13,"line":495},{"name":"$self","containerName":"frac_aligned","kind":13,"line":495},{"line":495,"kind":12,"containerName":"frac_aligned","name":"_reported_length"},{"kind":13,"line":495,"name":"$type","containerName":"frac_aligned"},{"name":"$self","containerName":"frac_aligned","kind":13,"line":497}],"line":488,"kind":12,"range":{"start":{"line":488,"character":0},"end":{"line":498,"character":9999}},"name":"frac_aligned"},{"children":[{"kind":12,"line":500,"containerName":"frac_aligned_query","name":"frac_aligned"}],"line":500,"kind":12,"range":{"end":{"line":500,"character":9999},"start":{"character":0,"line":500}},"definition":"sub","name":"frac_aligned_query","containerName":"main::"},{"children":[{"kind":12,"line":501,"containerName":"frac_aligned_hit","name":"frac_aligned"}],"line":501,"kind":12,"range":{"start":{"line":501,"character":0},"end":{"line":501,"character":9999}},"definition":"sub","name":"frac_aligned_hit","containerName":"main::"},{"kind":12,"children":[{"kind":12,"line":521,"name":"length","containerName":"num_aligned"}],"line":521,"definition":"sub","name":"num_aligned","containerName":"main::","range":{"end":{"line":521,"character":9999},"start":{"line":521,"character":0}}},{"name":"num_unaligned","range":{"end":{"line":550,"character":9999},"start":{"character":0,"line":539}},"definition":"sub","containerName":"main::","signature":{"label":"num_unaligned($type,$action,$context)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"","parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}]},"detail":"($type,$action,$context)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"num_unaligned","line":540,"kind":13},{"name":"$type","definition":"my","containerName":"num_unaligned","localvar":"my","kind":13,"line":541},{"kind":13,"line":541,"containerName":"num_unaligned","name":"$action"},{"containerName":"num_unaligned","name":"$context","kind":13,"line":541},{"kind":13,"line":542,"definition":"my","name":"$ret","containerName":"num_unaligned","localvar":"my"},{"name":"$self","containerName":"num_unaligned","line":543,"kind":13},{"containerName":"num_unaligned","name":"_check_type_arg","line":543,"kind":12},{"containerName":"num_unaligned","name":"$type","kind":13,"line":543},{"line":544,"kind":13,"containerName":"num_unaligned","name":"$self"},{"containerName":"num_unaligned","name":"_check_action_arg","line":544,"kind":12},{"kind":13,"line":544,"name":"$action","containerName":"num_unaligned"},{"name":"$self","containerName":"num_unaligned","kind":13,"line":545},{"name":"_check_context_arg","containerName":"num_unaligned","kind":12,"line":545},{"containerName":"num_unaligned","name":"$type","line":545,"kind":13},{"containerName":"num_unaligned","name":"$context","line":545,"kind":13},{"kind":13,"line":546,"name":"$self","containerName":"num_unaligned"},{"containerName":"num_unaligned","name":"$self","line":547,"kind":13},{"containerName":"num_unaligned","name":"$self","kind":13,"line":547},{"kind":12,"line":547,"name":"_reported_length","containerName":"num_unaligned"},{"name":"$type","containerName":"num_unaligned","kind":13,"line":547},{"kind":13,"line":547,"name":"$self","containerName":"num_unaligned"},{"containerName":"num_unaligned","name":"num_aligned","line":547,"kind":12},{"line":547,"kind":13,"name":"$type","containerName":"num_unaligned"},{"kind":13,"line":547,"name":"$action","containerName":"num_unaligned"},{"line":547,"kind":13,"name":"$context","containerName":"num_unaligned"},{"name":"$self","containerName":"num_unaligned","kind":13,"line":549}],"line":539},{"kind":12,"line":565,"children":[{"definition":"my","name":"$self","containerName":"range","localvar":"my","kind":13,"line":566},{"containerName":"range","name":"$type","line":566,"kind":13},{"line":566,"kind":13,"containerName":"range","name":"$context"},{"line":567,"kind":13,"containerName":"range","name":"$self"},{"kind":12,"line":567,"containerName":"range","name":"_check_type_arg"},{"kind":13,"line":567,"containerName":"range","name":"$type"},{"line":568,"kind":13,"containerName":"range","name":"$self"},{"name":"_check_context_arg","containerName":"range","line":568,"kind":12},{"name":"$type","containerName":"range","kind":13,"line":568},{"name":"$context","containerName":"range","kind":13,"line":568},{"line":569,"kind":13,"localvar":"my","containerName":"range","name":"@a","definition":"my"},{"kind":13,"line":569,"containerName":"range","name":"$self"},{"name":"_contig_intersection","containerName":"range","line":569,"kind":12},{"containerName":"range","name":"$type","line":569,"kind":13},{"name":"$context","containerName":"range","kind":13,"line":569},{"name":"$a","containerName":"range","kind":13,"line":570},{"containerName":"range","name":"$a","kind":13,"line":570}],"containerName":"main::","definition":"sub","detail":"($self,$type,$context)","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string","label":"range($self,$type,$context)"},"name":"range","range":{"start":{"line":565,"character":0},"end":{"character":9999,"line":571}}},{"children":[{"definition":"my","name":"$self","containerName":"coverage_map","localvar":"my","kind":13,"line":593},{"localvar":"my","containerName":"coverage_map","name":"$type","definition":"my","line":594,"kind":13},{"kind":13,"line":594,"name":"$context","containerName":"coverage_map"},{"name":"$self","containerName":"coverage_map","line":595,"kind":13},{"name":"_check_type_arg","containerName":"coverage_map","kind":12,"line":595},{"line":595,"kind":13,"containerName":"coverage_map","name":"$type"},{"kind":13,"line":596,"name":"$self","containerName":"coverage_map"},{"containerName":"coverage_map","name":"_check_context_arg","kind":12,"line":596},{"line":596,"kind":13,"name":"$type","containerName":"coverage_map"},{"line":596,"kind":13,"containerName":"coverage_map","name":"$context"},{"kind":13,"line":598,"name":"$self","containerName":"coverage_map"},{"kind":13,"line":601,"name":"$self","containerName":"coverage_map"},{"name":"_calc_coverage_map","containerName":"coverage_map","line":601,"kind":12},{"containerName":"coverage_map","name":"$type","line":601,"kind":13},{"containerName":"coverage_map","name":"$context","kind":13,"line":601},{"name":"$self","containerName":"coverage_map","line":604,"kind":13},{"line":605,"kind":13,"containerName":"coverage_map","name":"$self"},{"kind":12,"line":605,"containerName":"coverage_map","name":"warn"},{"containerName":"coverage_map","name":"$self","kind":13,"line":608}],"line":592,"kind":12,"signature":{"label":"coverage_map($type,$context)","documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter ","parameters":[{"label":"$type"},{"label":"$context"}]},"detail":"($type,$context)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":608},"start":{"line":592,"character":0}},"name":"coverage_map"},{"name":"coverage_map_as_text","range":{"end":{"character":9999,"line":646},"start":{"line":627,"character":0}},"kind":12,"children":[{"kind":13,"line":628,"definition":"my","name":"$self","containerName":"coverage_map_as_text","localvar":"my"},{"containerName":"coverage_map_as_text","definition":"my","name":"$type","localvar":"my","kind":13,"line":629},{"name":"$context","containerName":"coverage_map_as_text","kind":13,"line":629},{"line":629,"kind":13,"name":"$legend_q","containerName":"coverage_map_as_text"},{"containerName":"coverage_map_as_text","name":"$self","line":630,"kind":13},{"containerName":"coverage_map_as_text","name":"_check_type_arg","line":630,"kind":12},{"kind":13,"line":630,"name":"$type","containerName":"coverage_map_as_text"},{"kind":13,"line":631,"name":"$self","containerName":"coverage_map_as_text"},{"name":"_check_context_arg","containerName":"coverage_map_as_text","kind":12,"line":631},{"line":631,"kind":13,"containerName":"coverage_map_as_text","name":"$type"},{"kind":13,"line":631,"name":"$context","containerName":"coverage_map_as_text"},{"line":633,"kind":13,"localvar":"my","containerName":"coverage_map_as_text","name":"@map","definition":"my"},{"name":"$self","containerName":"coverage_map_as_text","kind":13,"line":633},{"containerName":"coverage_map_as_text","name":"coverage_map","line":633,"kind":12},{"containerName":"coverage_map_as_text","name":"$type","line":633,"kind":13},{"name":"$context","containerName":"coverage_map_as_text","line":633,"kind":13},{"kind":13,"line":634,"definition":"my","name":"@ret","containerName":"coverage_map_as_text","localvar":"my"},{"localvar":"my","containerName":"coverage_map_as_text","definition":"my","name":"@hsps","line":635,"kind":13},{"name":"$self","containerName":"coverage_map_as_text","kind":13,"line":635},{"kind":12,"line":635,"containerName":"coverage_map_as_text","name":"hit"},{"kind":12,"line":635,"containerName":"coverage_map_as_text","name":"hsps"},{"line":636,"kind":13,"localvar":"my","definition":"my","name":"%hsps_i","containerName":"coverage_map_as_text"},{"containerName":"coverage_map_as_text","name":"%hsps_i","line":638,"kind":13},{"line":639,"kind":13,"name":"@hsps_i","containerName":"coverage_map_as_text"},{"kind":13,"line":639,"containerName":"coverage_map_as_text","name":"@hsps"},{"name":"@mx","definition":"my","containerName":"coverage_map_as_text","localvar":"my","kind":13,"line":640},{"kind":13,"line":642,"containerName":"coverage_map_as_text","definition":"my","name":"@hspx","localvar":"my"},{"kind":13,"line":642,"containerName":"coverage_map_as_text","name":"@hsps"},{"containerName":"coverage_map_as_text","definition":"my","name":"@these_hsps","localvar":"my","kind":13,"line":643},{"kind":13,"line":643,"containerName":"coverage_map_as_text","name":"$map"},{"containerName":"coverage_map_as_text","name":"@hspx","line":644,"kind":13},{"line":644,"kind":13,"name":"@hsps_i","containerName":"coverage_map_as_text"},{"name":"@these_hsps","containerName":"coverage_map_as_text","line":644,"kind":13},{"name":"@these_hsps","containerName":"coverage_map_as_text","kind":13,"line":644},{"containerName":"coverage_map_as_text","name":"$mx","line":645,"kind":13},{"line":645,"kind":13,"name":"@hspx","containerName":"coverage_map_as_text"}],"line":627,"definition":"sub","containerName":"main::","signature":{"label":"coverage_map_as_text($type,$context,$legend_q)","parameters":[{"label":"$type"},{"label":"$context"},{"label":"$legend_q"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);"},"detail":"($type,$context,$legend_q)"},{"line":638,"kind":12,"name":"Tie","containerName":"RefHash"},{"name":"hsps","kind":12,"line":639},{"line":641,"kind":12,"name":"map"},{"line":647,"kind":13,"name":"%hsps_i","containerName":null},{"containerName":null,"name":"@ret","line":649,"kind":13},{"kind":13,"line":650,"name":"@ret","containerName":null},{"name":"map","kind":12,"line":650},{"localvar":"my","containerName":null,"name":"$h","definition":"my","line":651,"kind":13},{"name":"hsps","line":651,"kind":12},{"kind":13,"line":652,"name":"@ret","containerName":null},{"line":652,"kind":13,"containerName":null,"name":"%h"},{"line":652,"kind":13,"containerName":null,"name":"@mx"},{"name":"$h","containerName":null,"kind":13,"line":652},{"name":"map","kind":12,"line":652},{"containerName":null,"name":"%legend_q","kind":13,"line":654},{"kind":13,"line":655,"name":"@ret","containerName":null},{"kind":12,"line":656,"name":"map"},{"containerName":null,"name":"@ret","line":657,"kind":13},{"kind":13,"line":657,"name":"@map","containerName":null},{"line":659,"kind":13,"containerName":null,"name":"@ret"},{"line":660,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@ints"},{"line":660,"kind":12,"name":"get_intervals_from_hsps"},{"name":"$type","containerName":null,"line":660,"kind":13},{"kind":13,"line":660,"containerName":null,"name":"@hsps"},{"name":"hsps","kind":12,"line":661},{"containerName":null,"name":"@ret","line":662,"kind":13},{"line":662,"kind":13,"containerName":null,"name":"@ints"},{"containerName":null,"name":"@ret","kind":13,"line":665},{"range":{"start":{"line":680,"character":0},"end":{"line":684,"character":9999}},"definition":"sub","name":"hit","containerName":"main::","children":[{"localvar":"my","containerName":"hit","name":"$self","definition":"my","line":681,"kind":13},{"containerName":"hit","name":"$self","line":682,"kind":13},{"containerName":"hit","name":"warn","kind":12,"line":682},{"containerName":"hit","name":"$self","line":683,"kind":13}],"line":680,"kind":12},{"line":697,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hsps","line":698,"kind":13},{"kind":13,"line":699,"name":"$self","containerName":"hsps"},{"name":"$self","containerName":"hsps","kind":13,"line":700}],"kind":12,"range":{"start":{"character":0,"line":697},"end":{"line":700,"character":9999}},"containerName":"main::","name":"hsps","definition":"sub"},{"name":"contexts","range":{"end":{"line":723,"character":9999},"start":{"line":719,"character":0}},"kind":12,"line":719,"children":[{"line":720,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"contexts"},{"localvar":"my","containerName":"contexts","definition":"my","name":"$type","line":721,"kind":13},{"name":"$context","containerName":"contexts","kind":13,"line":721},{"line":722,"kind":13,"containerName":"contexts","name":"$self"},{"containerName":"contexts","name":"_check_type_arg","kind":12,"line":722},{"name":"$type","containerName":"contexts","line":722,"kind":13},{"kind":13,"line":723,"containerName":"contexts","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($type,$context)","signature":{"label":"contexts($type,$context)","parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string"}},{"line":723,"kind":13,"containerName":null,"name":"$context"},{"name":"%self","containerName":null,"kind":13,"line":724},{"containerName":null,"name":"$context","line":724,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":725},{"kind":13,"line":725,"containerName":null,"name":"$context"},{"range":{"end":{"line":745,"character":9999},"start":{"character":0,"line":740}},"containerName":"main::","definition":"sub","name":"mapping","line":740,"children":[{"kind":13,"line":741,"containerName":"mapping","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":742,"containerName":"mapping","definition":"my","name":"$type","localvar":"my"},{"line":743,"kind":13,"containerName":"mapping","name":"$self"},{"containerName":"mapping","name":"_check_type_arg","kind":12,"line":743},{"containerName":"mapping","name":"$type","kind":13,"line":743},{"containerName":"mapping","name":"$self","kind":13,"line":744}],"kind":12},{"kind":12,"line":759,"children":[{"containerName":"default_context","name":"$self","definition":"my","localvar":"my","kind":13,"line":760},{"kind":13,"line":761,"definition":"my","name":"$type","containerName":"default_context","localvar":"my"},{"containerName":"default_context","name":"$self","kind":13,"line":762},{"line":762,"kind":12,"name":"_check_type_arg","containerName":"default_context"},{"line":762,"kind":13,"containerName":"default_context","name":"$type"},{"containerName":"default_context","name":"$self","kind":13,"line":763}],"containerName":"main::","definition":"sub","name":"default_context","range":{"end":{"line":764,"character":9999},"start":{"line":759,"character":0}}},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"algorithm","localvar":"my","kind":13,"line":779},{"containerName":"algorithm","name":"$self","line":780,"kind":13},{"name":"warn","containerName":"algorithm","kind":12,"line":780},{"line":781,"kind":13,"containerName":"algorithm","name":"$self"}],"line":778,"definition":"sub","name":"algorithm","containerName":"main::","range":{"end":{"character":9999,"line":782},"start":{"line":778,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($type)","signature":{"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit","parameters":[{"label":"$type"}],"label":"_calc_coverage_map($type)"},"kind":12,"line":815,"children":[{"kind":13,"line":816,"definition":"my","name":"$self","containerName":"_calc_coverage_map","localvar":"my"},{"localvar":"my","name":"$type","definition":"my","containerName":"_calc_coverage_map","line":817,"kind":13},{"line":818,"kind":13,"name":"$self","containerName":"_calc_coverage_map"},{"kind":12,"line":818,"name":"_check_type_arg","containerName":"_calc_coverage_map"},{"line":818,"kind":13,"name":"$type","containerName":"_calc_coverage_map"},{"kind":13,"line":822,"containerName":"_calc_coverage_map","name":"$self"},{"kind":13,"line":823,"name":"$self","containerName":"_calc_coverage_map"},{"name":"warn","containerName":"_calc_coverage_map","kind":12,"line":823},{"localvar":"my","name":"@map","definition":"my","containerName":"_calc_coverage_map","line":827,"kind":13},{"line":827,"kind":13,"containerName":"_calc_coverage_map","name":"@hsps"},{"kind":13,"line":827,"name":"%filters","containerName":"_calc_coverage_map"},{"name":"@intervals","containerName":"_calc_coverage_map","kind":13,"line":827},{"localvar":"my","name":"$c","definition":"my","containerName":"_calc_coverage_map","line":831,"kind":13},{"containerName":"_calc_coverage_map","name":"$self","line":831,"kind":13},{"containerName":"_calc_coverage_map","name":"mapping","line":831,"kind":12},{"containerName":"_calc_coverage_map","name":"$type","line":831,"kind":13},{"containerName":"_calc_coverage_map","definition":"my","name":"$context","localvar":"my","kind":13,"line":834},{"containerName":"_calc_coverage_map","name":"$self","kind":13,"line":834},{"containerName":"_calc_coverage_map","name":"contexts","line":834,"kind":12},{"line":834,"kind":13,"containerName":"_calc_coverage_map","name":"$type"},{"kind":13,"line":835,"containerName":"_calc_coverage_map","name":"@map"},{"name":"@hsps","containerName":"_calc_coverage_map","kind":13,"line":836},{"line":836,"kind":13,"containerName":"_calc_coverage_map","name":"$self"},{"containerName":"_calc_coverage_map","name":"hsps","line":836,"kind":12},{"name":"$self","containerName":"_calc_coverage_map","kind":13,"line":836},{"line":836,"kind":12,"containerName":"_calc_coverage_map","name":"contexts"},{"kind":13,"line":836,"name":"$type","containerName":"_calc_coverage_map"},{"line":836,"kind":13,"name":"$context","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","name":"@intervals","kind":13,"line":837},{"kind":13,"line":837,"containerName":"_calc_coverage_map","name":"$type"},{"line":837,"kind":13,"name":"@hsps","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","definition":"my","name":"$f","localvar":"my","kind":13,"line":839},{"containerName":"_calc_coverage_map","name":"$intervals","kind":13,"line":839},{"line":839,"kind":13,"name":"$c","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","name":"@intervals","line":842,"kind":13},{"kind":13,"line":843,"name":"$f","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","name":"$c","kind":13,"line":843},{"line":843,"kind":13,"containerName":"_calc_coverage_map","name":"$c"},{"name":"$f","containerName":"_calc_coverage_map","kind":13,"line":844},{"line":844,"kind":13,"name":"$c","containerName":"_calc_coverage_map"},{"kind":13,"line":849,"containerName":"_calc_coverage_map","definition":"my","name":"@dj_set","localvar":"my"},{"line":849,"kind":13,"containerName":"_calc_coverage_map","name":"@intervals"},{"localvar":"my","containerName":"_calc_coverage_map","name":"$i","definition":"my","line":854,"kind":13},{"kind":13,"line":855,"definition":"my","name":"@decomp","containerName":"_calc_coverage_map","localvar":"my"},{"localvar":"my","containerName":"_calc_coverage_map","definition":"my","name":"$dj_elt","line":856,"kind":13},{"containerName":"_calc_coverage_map","name":"@dj_set","line":856,"kind":13},{"definition":"my","name":"$covering","containerName":"_calc_coverage_map","localvar":"my","kind":13,"line":857},{"kind":13,"line":857,"containerName":"_calc_coverage_map","name":"$indices"},{"kind":13,"line":857,"containerName":"_calc_coverage_map","name":"$dj_elt"},{"name":"@covering_hsps","definition":"my","containerName":"_calc_coverage_map","localvar":"my","kind":13,"line":858},{"name":"@hsps","containerName":"_calc_coverage_map","kind":13,"line":858},{"name":"$indices","containerName":"_calc_coverage_map","line":858,"kind":13},{"localvar":"my","containerName":"_calc_coverage_map","name":"@coverers","definition":"my","line":859,"kind":13},{"kind":13,"line":859,"name":"@intervals","containerName":"_calc_coverage_map"},{"line":859,"kind":13,"containerName":"_calc_coverage_map","name":"$indices"},{"containerName":"_calc_coverage_map","name":"@decomp","kind":13,"line":860},{"containerName":"_calc_coverage_map","name":"@coverers","line":860,"kind":13},{"name":"@decomp","containerName":"_calc_coverage_map","line":861,"kind":13},{"containerName":"_calc_coverage_map","definition":"my","name":"$component","localvar":"my","kind":13,"line":862},{"kind":13,"line":862,"containerName":"_calc_coverage_map","name":"$container_indices"},{"line":863,"kind":13,"name":"@map","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","name":"$component","kind":13,"line":863},{"kind":13,"line":864,"name":"@covering_hsps","containerName":"_calc_coverage_map"},{"name":"$container_indices","containerName":"_calc_coverage_map","line":864,"kind":13},{"name":"@map","containerName":"_calc_coverage_map","kind":13,"line":871},{"containerName":"_calc_coverage_map","name":"$c","line":872,"kind":13},{"kind":13,"line":872,"containerName":"_calc_coverage_map","name":"$c"},{"name":"$f","containerName":"_calc_coverage_map","line":872,"kind":13},{"containerName":"_calc_coverage_map","name":"$c","line":873,"kind":13},{"name":"$f","containerName":"_calc_coverage_map","kind":13,"line":873},{"name":"@dj_set","containerName":"_calc_coverage_map","line":875,"kind":13},{"line":876,"kind":13,"containerName":"_calc_coverage_map","name":"$c"},{"name":"$c","containerName":"_calc_coverage_map","kind":13,"line":876},{"containerName":"_calc_coverage_map","name":"$f","kind":13,"line":876},{"containerName":"_calc_coverage_map","name":"$c","line":877,"kind":13},{"kind":13,"line":877,"name":"$f","containerName":"_calc_coverage_map"},{"containerName":"_calc_coverage_map","name":"@map","line":881,"kind":13},{"line":881,"kind":13,"containerName":"_calc_coverage_map","name":"$a"},{"line":881,"kind":13,"containerName":"_calc_coverage_map","name":"$b"},{"containerName":"_calc_coverage_map","name":"@map","line":881,"kind":13},{"kind":13,"line":882,"name":"$self","containerName":"_calc_coverage_map"},{"name":"@map","containerName":"_calc_coverage_map","line":882,"kind":13},{"kind":13,"line":884,"name":"$self","containerName":"_calc_coverage_map"},{"name":"@dj_set","containerName":"_calc_coverage_map","kind":13,"line":884}],"name":"_calc_coverage_map","range":{"end":{"line":885,"character":9999},"start":{"character":0,"line":815}}},{"kind":12,"line":837,"name":"get_intervals_from_hsps"},{"line":849,"kind":12,"name":"interval_tiling"},{"name":"decompose_interval","line":860,"kind":12},{"range":{"end":{"character":9999,"line":1006},"start":{"line":927,"character":0}},"name":"_calc_stats","signature":{"parameters":[{"label":"$type"},{"label":"$action"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  ","label":"_calc_stats($type,$action,$context)"},"detail":"($type,$action,$context)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":928,"containerName":"_calc_stats","definition":"my","name":"$self","localvar":"my"},{"line":929,"kind":13,"localvar":"my","name":"$type","definition":"my","containerName":"_calc_stats"},{"name":"$action","containerName":"_calc_stats","kind":13,"line":929},{"line":929,"kind":13,"name":"$context","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$self","line":931,"kind":13},{"line":931,"kind":12,"name":"_check_type_arg","containerName":"_calc_stats"},{"line":931,"kind":13,"name":"$type","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$self","line":932,"kind":13},{"line":932,"kind":12,"containerName":"_calc_stats","name":"_check_action_arg"},{"line":932,"kind":13,"containerName":"_calc_stats","name":"$action"},{"line":933,"kind":13,"containerName":"_calc_stats","name":"$self"},{"line":933,"kind":12,"name":"_check_context_arg","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$type","kind":13,"line":933},{"containerName":"_calc_stats","name":"$context","kind":13,"line":933},{"localvar":"my","name":"$ident","definition":"my","containerName":"_calc_stats","line":934,"kind":13},{"kind":13,"line":934,"name":"$cons","containerName":"_calc_stats"},{"name":"$length","containerName":"_calc_stats","line":934,"kind":13},{"line":940,"kind":13,"name":"$action","containerName":"_calc_stats"},{"kind":13,"line":941,"definition":"my","name":"@hsps","containerName":"_calc_stats","localvar":"my"},{"name":"$self","containerName":"_calc_stats","kind":13,"line":941},{"kind":12,"line":941,"name":"hit","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"hsps","line":941,"kind":12},{"kind":13,"line":942,"containerName":"_calc_stats","name":"@hsps"},{"name":"@hsps","containerName":"_calc_stats","line":942,"kind":13},{"kind":13,"line":942,"name":"$self","containerName":"_calc_stats"},{"line":942,"kind":12,"containerName":"_calc_stats","name":"contexts"},{"kind":13,"line":942,"containerName":"_calc_stats","name":"$type"},{"line":942,"kind":13,"name":"$context","containerName":"_calc_stats"},{"containerName":"_calc_stats","definition":"my","name":"@wt","localvar":"my","kind":13,"line":944},{"kind":12,"line":944,"containerName":"_calc_stats","name":"length"},{"containerName":"_calc_stats","name":"$type","kind":13,"line":944},{"kind":13,"line":944,"containerName":"_calc_stats","name":"@hsps"},{"kind":13,"line":945,"definition":"my","name":"$sum","containerName":"_calc_stats","localvar":"my"},{"containerName":"_calc_stats","name":"@wt","line":945,"kind":13},{"containerName":"_calc_stats","name":"$sum","line":946,"kind":13},{"line":946,"kind":13,"name":"@wt","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"@hsps","line":947,"kind":13},{"kind":13,"line":948,"name":"$wt","definition":"my","containerName":"_calc_stats","localvar":"my"},{"containerName":"_calc_stats","name":"@wt","line":948,"kind":13},{"name":"$ident","containerName":"_calc_stats","line":949,"kind":13},{"containerName":"_calc_stats","name":"$wt","kind":13,"line":949},{"line":949,"kind":12,"containerName":"_calc_stats","name":"matches_MT"},{"line":949,"kind":13,"name":"$type","containerName":"_calc_stats"},{"kind":13,"line":950,"name":"$cons","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$wt","line":950,"kind":13},{"line":950,"kind":12,"name":"matches_MT","containerName":"_calc_stats"},{"kind":13,"line":950,"name":"$type","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$length","kind":13,"line":951},{"containerName":"_calc_stats","name":"$wt","kind":13,"line":951},{"containerName":"_calc_stats","name":"length","kind":12,"line":951},{"name":"$type","containerName":"_calc_stats","kind":13,"line":951},{"kind":13,"line":960,"name":"$action","containerName":"_calc_stats"},{"line":961,"kind":13,"containerName":"_calc_stats","name":"$self"},{"line":961,"kind":12,"name":"coverage_map","containerName":"_calc_stats"},{"kind":13,"line":961,"name":"$type","containerName":"_calc_stats"},{"kind":13,"line":961,"containerName":"_calc_stats","name":"$context"},{"kind":13,"line":962,"name":"$intvl","definition":"my","containerName":"_calc_stats","localvar":"my"},{"line":962,"kind":13,"name":"$hsps","containerName":"_calc_stats"},{"localvar":"my","name":"$len","definition":"my","containerName":"_calc_stats","line":963,"kind":13},{"line":964,"kind":13,"localvar":"my","definition":"my","name":"$ncover","containerName":"_calc_stats"},{"line":964,"kind":13,"name":"$action","containerName":"_calc_stats"},{"kind":13,"line":965,"definition":"my","name":"$acc_i","containerName":"_calc_stats","localvar":"my"},{"containerName":"_calc_stats","name":"$acc_c","kind":13,"line":965},{"line":966,"kind":13,"localvar":"my","definition":"my","name":"$hsp","containerName":"_calc_stats"},{"line":967,"kind":13,"containerName":"_calc_stats","name":"$action"},{"localvar":"my","name":"$inc_i","definition":"my","containerName":"_calc_stats","line":969,"kind":13},{"line":969,"kind":13,"name":"$inc_c","containerName":"_calc_stats"},{"line":969,"kind":13,"name":"$hsp","containerName":"_calc_stats"},{"name":"matches_MT","containerName":"_calc_stats","kind":12,"line":969},{"containerName":"_calc_stats","name":"$type","kind":13,"line":970},{"localvar":"my","definition":"my","name":"$frac","containerName":"_calc_stats","line":973,"kind":13},{"kind":13,"line":973,"containerName":"_calc_stats","name":"$len"},{"kind":13,"line":973,"containerName":"_calc_stats","name":"$hsp"},{"containerName":"_calc_stats","name":"length","line":973,"kind":12},{"containerName":"_calc_stats","name":"$type","kind":13,"line":973},{"containerName":"_calc_stats","name":"$acc_i","line":974,"kind":13},{"name":"$inc_i","containerName":"_calc_stats","line":974,"kind":13},{"line":974,"kind":13,"name":"$frac","containerName":"_calc_stats"},{"kind":13,"line":975,"containerName":"_calc_stats","name":"$acc_c"},{"kind":13,"line":975,"name":"$inc_c","containerName":"_calc_stats"},{"kind":13,"line":975,"containerName":"_calc_stats","name":"$frac"},{"definition":"my","name":"$inc_i","containerName":"_calc_stats","localvar":"my","kind":13,"line":979},{"line":979,"kind":13,"name":"$inc_c","containerName":"_calc_stats"},{"kind":13,"line":979,"containerName":"_calc_stats","name":"$hsp"},{"line":979,"kind":12,"containerName":"_calc_stats","name":"matches_MT"},{"kind":13,"line":980,"containerName":"_calc_stats","name":"$type"},{"line":985,"kind":13,"name":"$acc_i","containerName":"_calc_stats"},{"line":985,"kind":13,"containerName":"_calc_stats","name":"$acc_i"},{"line":985,"kind":13,"name":"$inc_i","containerName":"_calc_stats"},{"name":"$acc_i","containerName":"_calc_stats","kind":13,"line":985},{"name":"$inc_i","containerName":"_calc_stats","line":985,"kind":13},{"line":986,"kind":13,"name":"$acc_c","containerName":"_calc_stats"},{"containerName":"_calc_stats","name":"$acc_c","line":986,"kind":13},{"kind":13,"line":986,"name":"$inc_c","containerName":"_calc_stats"},{"line":986,"kind":13,"containerName":"_calc_stats","name":"$acc_c"},{"name":"$inc_c","containerName":"_calc_stats","kind":13,"line":986},{"kind":13,"line":990,"containerName":"_calc_stats","definition":"my","name":"$inc_i","localvar":"my"},{"line":990,"kind":13,"containerName":"_calc_stats","name":"$inc_c"},{"line":990,"kind":13,"name":"$hsp","containerName":"_calc_stats"},{"name":"matches_MT","containerName":"_calc_stats","kind":12,"line":990},{"name":"$type","containerName":"_calc_stats","line":991,"kind":13},{"name":"$acc_i","containerName":"_calc_stats","line":996,"kind":13},{"line":996,"kind":13,"containerName":"_calc_stats","name":"$inc_i"},{"name":"$acc_c","containerName":"_calc_stats","kind":13,"line":997},{"name":"$inc_c","containerName":"_calc_stats","line":997,"kind":13},{"line":1002,"kind":13,"name":"$ident","containerName":"_calc_stats"},{"kind":13,"line":1002,"containerName":"_calc_stats","name":"$acc_i"},{"containerName":"_calc_stats","name":"$ncover","kind":13,"line":1002},{"line":1003,"kind":13,"name":"$cons","containerName":"_calc_stats"},{"line":1003,"kind":13,"name":"$acc_c","containerName":"_calc_stats"},{"kind":13,"line":1003,"containerName":"_calc_stats","name":"$ncover"},{"line":1004,"kind":13,"containerName":"_calc_stats","name":"$length"},{"kind":13,"line":1004,"containerName":"_calc_stats","name":"$len"}],"line":927,"kind":12},{"line":963,"kind":12,"name":"intvl"},{"name":"intvl","kind":12,"line":963},{"name":"intvl","kind":12,"line":982},{"name":"intvl","kind":12,"line":983},{"line":993,"kind":12,"name":"intvl"},{"line":994,"kind":12,"name":"intvl"},{"containerName":null,"name":"%self","kind":13,"line":1008},{"kind":13,"line":1008,"containerName":null,"name":"$ident"},{"containerName":null,"name":"%self","kind":13,"line":1009},{"kind":13,"line":1009,"containerName":null,"name":"$cons"},{"kind":13,"line":1010,"containerName":null,"name":"%self"},{"name":"$length","containerName":null,"kind":13,"line":1010},{"name":"_make_tiling_iterator","range":{"end":{"line":1095,"character":9999},"start":{"character":0,"line":1044}},"containerName":"main::","definition":"sub","detail":"($type,$context)","signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  \n\n\nsub _calc_stats {\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    # need to check args here, in case method is called internally.\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    my ($ident, $cons, $length) = (0,0,0);\n\n    # fast : avoid coverage map altogether, get a pretty damn\n    # good estimate with a weighted average of reported hsp\n    # statistics\n\n    ($action eq 'fast') && do {\n\tmy @hsps = $self->hit->hsps;\n\t@hsps = @hsps[$self->contexts($type, $context)];\n\t# weights for averages\n\tmy @wt = map {$_->length($type)} @hsps;\n\tmy $sum = eval( join('+',@wt) );\n\t$_ /= $sum for (@wt);\n\tfor (@hsps) { \n\t    my $wt = shift @wt;\n\t    $ident  += $wt*$_->matches_MT($type,'identities');\n\t    $cons   += $wt*$_->matches_MT($type,'conserved');\n\t    $length += $wt*$_->length($type);\n\t}\n    };\n\n    # or, do tiling\n\n    # calculate identities/conserved sites in tiling\n    # estimate based on the fraction of the component interval covered\n    # and ident/cons reported by the HSPs\n    ($action ne 'fast') && do {\n\tforeach ($self->coverage_map($type, $context)) {\n\t    my ($intvl, $hsps) = @{$_};\n\t    my $len = ($$intvl[1]-$$intvl[0]+1);\n\t    my $ncover = ($action eq 'max') ? 1 : scalar @$hsps;\n\t    my ($acc_i, $acc_c) = (0,0);\n\t    foreach my $hsp (@$hsps) {\n\t\tfor ($action) {\n\t\t    ($_ eq 'est') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    );\n\t\t\tmy $frac = $len/$hsp->length($type);\n\t\t\t$acc_i += $inc_i * $frac;\n\t\t\t$acc_c += $inc_c * $frac;\n\t\t\tlast;\n\t\t    };\n\t\t    ($_ eq 'max') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    -start => $$intvl[0], \n\t\t\t    -end   => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i = ($acc_i > $inc_i) ? $acc_i : $inc_i;\n\t\t\t$acc_c = ($acc_c > $inc_c) ? $acc_c : $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t    (!$_ || ($_ eq 'exact')) && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type, \n\t\t\t    -action => 'searchutils',\n\t\t\t    -start  => $$intvl[0], \n\t\t\t    -end    => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i += $inc_i;\n\t\t\t$acc_c += $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t}\n\t    }\n\t    $ident += ($acc_i/$ncover);\n\t    $cons  += ($acc_c/$ncover);\n\t    $length += $len;\n\t}\n    };\n    \n    $self->{\"identities_${type}_${action}_${context}\"} = $ident;\n    $self->{\"conserved_${type}_${action}_${context}\"} = $cons;\n    $self->{\"length_${type}_${action}_${context}\"} = $length;\n    \n    return 1;\n}\n\n=head2 Tiling Helper Methods\n\n\n# coverage_map is of the form\n# ( [ $interval, \\@containing_hsps ], ... )\n\n# so, for each interval, pick one of the containing hsps,\n# and return the union of all the picks.\n\n# use the combinatorial generating iterator, with \n# the urns containing the @containing_hsps for each\n# interval\n\n=head2 _make_tiling_iterator\n\n Title   : _make_tiling_iterator\n Usage   : $self->_make_tiling_iterator($type)\n Function: Create an iterator code ref that will step through all \n           minimal combinations of HSPs that produce complete coverage\n           of the $type ('hit', 'subject', 'query') sequence, \n           and set the correct iterator property of the invocant\n Example :\n Returns : True on success\n Args    : scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'","label":"_make_tiling_iterator($type,$context)"},"kind":12,"line":1044,"children":[{"line":1046,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_make_tiling_iterator"},{"definition":"my","name":"$type","containerName":"_make_tiling_iterator","localvar":"my","kind":13,"line":1047},{"containerName":"_make_tiling_iterator","name":"$context","kind":13,"line":1047},{"kind":13,"line":1048,"containerName":"_make_tiling_iterator","name":"$self"},{"line":1048,"kind":12,"containerName":"_make_tiling_iterator","name":"_check_type_arg"},{"kind":13,"line":1048,"name":"$type","containerName":"_make_tiling_iterator"},{"kind":13,"line":1049,"name":"$self","containerName":"_make_tiling_iterator"},{"line":1049,"kind":12,"name":"_check_context_arg","containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","name":"$type","line":1049,"kind":13},{"name":"$context","containerName":"_make_tiling_iterator","kind":13,"line":1049},{"kind":13,"line":1052,"definition":"my","name":"@urns","containerName":"_make_tiling_iterator","localvar":"my"},{"line":1052,"kind":13,"containerName":"_make_tiling_iterator","name":"$self"},{"kind":12,"line":1052,"name":"coverage_map","containerName":"_make_tiling_iterator"},{"name":"$type","containerName":"_make_tiling_iterator","line":1052,"kind":13},{"containerName":"_make_tiling_iterator","name":"$context","line":1052,"kind":13},{"kind":13,"line":1054,"containerName":"_make_tiling_iterator","definition":"my","name":"$FINISHED","localvar":"my"},{"definition":"my","name":"$iter","containerName":"_make_tiling_iterator","localvar":"my","kind":13,"line":1055},{"containerName":"_make_tiling_iterator","name":"$rewind","definition":"my","localvar":"my","kind":13,"line":1057},{"containerName":"_make_tiling_iterator","name":"@urns","kind":13,"line":1059},{"line":1060,"kind":13,"name":"$FINISHED","containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","name":"$FINISHED","line":1064,"kind":13},{"containerName":"_make_tiling_iterator","definition":"my","name":"$finished_incrementing","localvar":"my","kind":13,"line":1066},{"kind":13,"line":1068,"name":"@ret","definition":"my","containerName":"_make_tiling_iterator","localvar":"my"},{"localvar":"my","containerName":"_make_tiling_iterator","definition":"my","name":"$urn","line":1070,"kind":13},{"containerName":"_make_tiling_iterator","name":"@urns","kind":13,"line":1070},{"definition":"my","name":"$n","containerName":"_make_tiling_iterator","localvar":"my","kind":13,"line":1071},{"line":1071,"kind":13,"name":"$hsps","containerName":"_make_tiling_iterator"},{"kind":13,"line":1071,"name":"$urn","containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","name":"@ret","kind":13,"line":1072},{"containerName":"_make_tiling_iterator","name":"$n","line":1072,"kind":13},{"kind":13,"line":1073,"name":"$finished_incrementing","containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","name":"$n","line":1074,"kind":13},{"line":1074,"kind":13,"containerName":"_make_tiling_iterator","name":"$hsps"},{"kind":13,"line":1075,"name":"$finished_incrementing","containerName":"_make_tiling_iterator"},{"kind":13,"line":1080,"name":"$FINISHED","containerName":"_make_tiling_iterator"},{"kind":13,"line":1080,"containerName":"_make_tiling_iterator","name":"$finished_incrementing"},{"line":1085,"kind":13,"localvar":"my","containerName":"_make_tiling_iterator","name":"%order","definition":"my"},{"line":1085,"kind":13,"name":"%uniq","containerName":"_make_tiling_iterator"},{"containerName":"_make_tiling_iterator","name":"@order","kind":13,"line":1086},{"kind":13,"line":1086,"containerName":"_make_tiling_iterator","name":"@ret"},{"containerName":"_make_tiling_iterator","name":"$uniq","kind":13,"line":1087},{"name":"$order","containerName":"_make_tiling_iterator","line":1087,"kind":13},{"name":"rank","containerName":"_make_tiling_iterator","kind":12,"line":1087},{"kind":13,"line":1088,"containerName":"_make_tiling_iterator","name":"@ret"},{"name":"@order","containerName":"_make_tiling_iterator","kind":13,"line":1088},{"name":"$a","containerName":"_make_tiling_iterator","kind":13,"line":1088},{"name":"$b","containerName":"_make_tiling_iterator","kind":13,"line":1088},{"kind":13,"line":1088,"name":"%uniq","containerName":"_make_tiling_iterator"},{"name":"@ret","containerName":"_make_tiling_iterator","line":1090,"kind":13},{"line":1093,"kind":13,"name":"$self","containerName":"_make_tiling_iterator"},{"line":1093,"kind":13,"containerName":"_make_tiling_iterator","name":"$iter"}]},{"name":"urn","line":1074,"kind":12},{"line":1075,"kind":12,"name":"urn"},{"line":1086,"kind":12,"name":"ret"},{"name":"ret","line":1087,"kind":12},{"name":"_tiling_iterator","range":{"end":{"line":1122,"character":9999},"start":{"line":1112,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"# $Id: MapTiling.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Tiling::MapTiling\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org>\n#\n# Cared for by Mark A. Jensen <maj@fortinbras.us>\n#\n# Copyright Mark A. Jensen\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Tiling::MapTiling - An implementation of an HSP tiling\nalgorithm, with methods to obtain frequently-requested statistics\n\n=head1 SYNOPSIS\n\n # get a BLAST $hit from somewhere, then\n $tiling = Bio::Search::Tiling::MapTiling->new($hit);\n\n # stats\n $numID = $tiling->identities();\n $numCons = $tiling->conserved();\n $query_length = $tiling->length('query');\n $subject_length = $tiling->length('subject'); # or...\n $subject_length = $tiling->length('hit');\n\n # get a visual on the coverage map\n print $tiling->coverage_map_as_text('query',$context,'LEGEND');\n\n # tilings\n $context = $tiling->_context( -type => 'subject', -strand=> 1, -frame=>1);\n @covering_hsps_for_subject = $tiling->next_tiling('subject',$context);\n $context = $tiling->_context( -type => 'query', -strand=> -1, -frame=>0);\n @covering_hsps_for_query   = $tiling->next_tiling('query', $context);\n\n=head1 DESCRIPTION\n\nFrequently, users want to use a set of high-scoring pairs (HSPs)\nobtained from a BLAST or other search to assess the overall level of\nidentity, conservation, or coverage represented by matches between a\nsubject and a query sequence. Because a set of HSPs frequently\ndescribes multiple overlapping sequence fragments, a simple summation of\nstatistics over the HSPs will generally overestimate those\nstatistics. To obtain an accurate estimate of global hit statistics, a\n'tiling' of HSPs onto either the subject or the query sequence must be\nperformed, in order to properly correct for this. \n\nThis module will execute a tiling algorithm on a given hit based on an\ninterval decomposition I'm calling the \"coverage map\". Internal object\nmethods compute the various statistics, which are then stored in\nappropriately-named public object attributes. See\nL<Bio::Search::Tiling::MapTileUtils> for more info on the algorithm. \n\n=head2 STRAND/FRAME CONTEXTS\n\nIn BLASTX, TBLASTN, and TBLASTX reports, strand and frame information\nare reported for the query, subject, or query and subject,\nrespectively, for each HSP. Tilings for these sequence types are only\nmeaningful when they include HSPs in the same strand and frame, or \n\"context\". So, in these situations, the context must be specified\nin the method calls or the methods will throw. \n\nContexts are specified as strings: C<[ 'all' | [m|p][_|0|1|2] ]>, where\nC<all> = all HSPs (will throw if context must be specified), C<m> = minus\nstrand, C<p> = plus strand, and C<_> = no frame info, C<0,1,2> = respective\n(absolute) frame. The L</_make_context_key> method will convert a (strand,\nframe) specification to a context string, e.g.:\n\n    $context = $self->_context(-type=>'query', -strand=>-1, -frame=>-2);\n\nreturns C<m2>.\n\nThe contexts present among the HSPs in a hit are identified and stored\nfor convenience upon object construction. These are accessed off the\nobject with the L</contexts> method. If contexts don't apply for the\ngiven report, this returns C<('all')>. \n\n=head1 DESIGN NOTE\n\nThe major calculations are made just-in-time, and then memoized. So,\nfor example, for a given MapTiling object, a coverage map would\nusually be calculated only once (for the query), and at most twice (if\nthe subject perspective is also desired), and then only when a\nstatistic is first accessed. Afterward, the map and/or any statistic\nis read from storage. So feel free to call the statistic methods\nfrequently if it suits you.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support\n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and\nreponsive experts will be able look at the problem and quickly\naddress it. Please include a thorough description of the problem\nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Mark A. Jensen\n\nEmail maj -at- fortinbras -dot- us\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Tiling::MapTiling;\nuse strict;\nuse warnings;\n\n# Object preamble - inherits from Bio::Root::Root\n#use lib '../../..';\n\nuse Bio::Root::Root;\nuse Bio::Search::Tiling::TilingI;\nuse Bio::Search::Tiling::MapTileUtils;\n\n# use base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\nuse base qw(Bio::Root::Root Bio::Search::Tiling::TilingI);\n\n=head1 CONSTRUCTOR\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::Search::Tiling::GenericTiling();\n Function: Builds a new Bio::Search::Tiling::GenericTiling object \n Returns : an instance of Bio::Search::Tiling::GenericTiling\n Args    : -hit    => $a_Bio_Search_Hit_HitI_object\n           general filter function:\n           -hsp_filter => sub { my $this_hsp = shift; \n                                ...;\n                                return 1 if $wanted;\n                                return 0; }\n\n\nsub new {\n    my $class = shift;\n    my @args = @_;\n    my $self = $class->SUPER::new(@args);\n    my($hit, $filter) = $self->_rearrange( [qw( HIT HSP_FILTER)],@args );\n\n    $self->throw(\"HitI object required\") unless $hit;\n    $self->throw(\"Argument must be HitI object\") unless ( ref $hit && $hit->isa('Bio::Search::Hit::HitI') );\n    $self->{hit} = $hit;\n    $self->_set_attributes();\n    $self->{\"_algorithm\"} = $hit->algorithm;\n\n    my @hsps = $hit->hsps;\n    # apply filter function if requested\n    if ( defined $filter ) {\n\tif ( ref($filter) eq 'CODE' ) {\n\t    @hsps = map { $filter->($_) ? $_ : () } @hsps;\n\t}\n\telse {\n\t    $self->warn(\"-filter is not a coderef; ignoring\");\n\t}\n    }\n    \n    # identify available contexts\n    for my $t qw( query hit ) {\n\tmy %contexts;\n\tfor my $i (0..$#hsps) {\n\t    my $ctxt = $self->_context(\n\t\t-type => $t,\n\t\t-strand => $hsps[$i]->strand($t),\n\t\t-frame  => $hsps[$i]->frame($t));\n\t    $contexts{$ctxt} ||= [];\n\t    push @{$contexts{$ctxt}}, $i;\n\t}\n\t$self->{\"_contexts_${t}\"} = \\%contexts;\n    }\n\n    $self->warn(\"No HSPs present in hit after filtering\") unless (@hsps);\n    $self->hsps(\\@hsps);\n    return $self;\n}\n\n# a tiling is based on the set of hsps contained in a single hit.\n# check all the boundaries - zero hsps, one hsp, all disjoint hsps\n\n=head1 TILING ITERATORS\n\n=head2 next_tiling\n\n Title   : next_tiling\n Usage   : @hsps = $self->next_tiling($type);\n Function: Obtain a tiling: a minimal set of HSPs covering the $type\n           ('hit', 'subject', 'query') sequence\n Example :\n Returns : an array of HSPI objects\n Args    : scalar $type: one of 'hit', 'subject', 'query', with\n           'subject' an alias for 'hit'\n\n\nsub next_tiling{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->();\n}\n\n=head2 rewind_tilings\n\n Title   : rewind_tilings\n Usage   : $self->rewind_tilings($type)\n Function: Reset the next_tilings($type) iterator\n Example :\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub rewind_tilings{\n    my $self = shift;\n    my ($type,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    return $self->_tiling_iterator($type, $context)->('REWIND');\n}\n\n=head1 STATISTICS\n\n=head2 identities\n\n Title   : identities\n Usage   : $tiling->identities($type, $action, $context)\n Function: Retrieve the calculated number of identities for the invocant\n Example : \n Returns : value of identities (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only\n\n\nsub identities{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"identities_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"identities_${type}_${action}_${context}\"};\n}\n\n=head2 conserved\n\n Title   : conserved\n Usage   : $tiling->conserved($type, $action)\n Function: Retrieve the calculated number of conserved sites for the invocant\n Example : \n Returns : value of conserved (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub conserved{\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"conserved_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"conserved_${type}_${action}_${context}\"};\n}\n\n=head2 length\n\n Title   : length\n Usage   : $tiling->length($type, $action, $context)\n Function: Retrieve the total length of aligned residues for \n           the seq $type\n Example : \n Returns : value of length (a scalar)\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $action: one of 'exact', 'est', 'fast', 'max'\n           default is 'exact'\n           option scalar $context: strand/frame context string\n Note    : getter only \n\n\nsub length{\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"length_${type}_${action}_${context}\"}) {\n\t$self->_calc_stats($type, $action, $context);\n    }\n    return $self->{\"length_${type}_${action}_${context}\"};\n}\n\n=head2 frac\n\n Title   : frac\n Usage   : $tiling->frac($type, $denom, $action, $context, $method)\n Function: Return the fraction of sequence length consisting\n           of desired kinds of pairs (given by $method), \n           with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n           -method => one of 'identical', 'conserved'\n Note    : $denom == 'aligned', return desired_stat/num_aligned\n           $denom == 'total', return desired_stat/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n\n\nsub frac {\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context, $method) = $self->_rearrange([qw(TYPE DENOM ACTION CONTEXT METHOD)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    unless ($method and grep(/^$method$/, qw( identical conserved ))) {\n\t$self->throw(\"-method must specified; one of ('identical', 'conserved')\");\n    }\n    $denom ||= 'total';\n    unless (grep /^$denom/, qw( total aligned )) {\n\t$self->throw(\"Denominator selection must be one of ('total', 'aligned'), not '$denom'\");\n    }\n    my $key = \"frac_${method}_${type}_${denom}_${action}_${context}\";\n    my $stat;\n    for ($method) {\n\t$_ eq 'identical' && do {\n\t    $stat = $self->identities($type, $action, $context);\n\t    last;\n\t};\n\t$_ eq 'conserved' && do {\n\t    $stat = $self->conserved($type, $action, $context);\n\t    last;\n\t};\n\tdo {\n\t    $self->throw(\"What are YOU doing here?\");\n\t};\n    }\n    if (!defined $self->{$key}) {\n\tfor ($denom) {\n\t    /total/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->_reported_length($type); # need fudge fac??\n\t\tlast;\n\t    };\n\t    /aligned/ && do {\n\t\t$self->{$key} =\n\t\t    $stat/$self->length($type,$action,$context);\n\t\tlast;\n\t    };\n\t    do {\n\t\t$self->throw(\"What are YOU doing here?\");\n\t    };\n\t}\n    }\n    return $self->{$key};\n}\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : $tiling->frac_identical($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of identical pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_identical{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action,$context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -method=>'identical', -context=>$context);\n}\n\n=head2 frac_conserved\n\n Title   : frac_conserved\n Usage   : $tiling->frac_conserved($type, $denom, $action, $context)\n Function: Return the fraction of sequence length consisting\n           of conserved pairs, with respect to $denom\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -denom => one of 'total', 'aligned'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : $denom == 'aligned', return conserved/num_aligned\n           $denom == 'total', return conserved/_reported_length\n             (i.e., length of the original input sequences)\n Note    : In keeping with the spirit of Bio::Search::HSP::HSPI, \n           reported lengths of translated dna are reduced by \n           a factor of 3, to provide fractions relative to \n           amino acid coordinates. \n Note    : This an alias that calls frac()\n\n\nsub frac_conserved{\n    my $self = shift;\n    my @args = @_;\n    my ($type, $denom, $action, $context) = $self->_rearrange( [qw[ TYPE DENOM ACTION CONTEXT]],@args );\n    $self->frac( -type=>$type, -denom=>$denom, -action=>$action, -context=>$context, -method=>'conserved');\n}\n\n=head2 frac_aligned\n\n Title   : frac_aligned\n Aliases : frac_aligned_query - frac_aligned(-type=>'query',...)\n           frac_aligned_hit   - frac_aligned(-type=>'hit',...)\n Usage   : $tiling->frac_aligned(-type=>$type,\n                                 -action=>$action,\n                                 -context=>$context)\n Function: Return the fraction of input sequence length\n           that was aligned by the algorithm\n Returns : scalar float\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n\n\nsub frac_aligned{\n    my ($self, @args) = @_;\n    my ($type, $action, $context) = $self->_rearrange([qw(TYPE ACTION CONTEXT)],@args);\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!$self->{\"frac_aligned_${type}_${action}_${context}\"}) {\n\t$self->{\"frac_aligned_${type}_${action}_${context}\"} = $self->num_aligned($type,$action,$context)/$self->_reported_length($type);\n    }\n    return $self->{\"frac_aligned_${type}_${action}_${context}\"};\n}\n\nsub frac_aligned_query { shift->frac_aligned(-type=>'query', @_) }\nsub frac_aligned_hit { shift->frac_aligned(-type=>'hit', @_) }\n    \n\n=head2 num_aligned\n\n Title   : num_aligned\n Usage   : $tiling->num_aligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were aligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n Note    : Aliases length()\n\n\nsub num_aligned { shift->length( @_ ) };\n\n=head2 num_unaligned\n\n Title   : num_unaligned\n Usage   : $tiling->num_unaligned(-type=>$type)\n Function: Return the number of residues of sequence $type\n           that were left unaligned by the algorithm\n Returns : scalar int\n Args    : -type => one of 'hit', 'subject', 'query'\n           -action => one of 'exact', 'est', 'fast', 'max'\n           -context => strand/frame context string\n Note    : Since this is calculated from reported coordinates,\n           not symbol string counts, it is already in terms of\n           \"logical length\"\n\n\nsub num_unaligned {\n    my $self = shift;\n    my ($type,$action,$context) = @_;\n    my $ret;\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    if (!defined $self->{\"num_unaligned_${type}_${action}_${context}\"}) {\n\t$self->{\"num_unaligned_${type}_${action}_${context}\"} = $self->_reported_length($type)-$self->num_aligned($type,$action,$context);\n    }\n    return $self->{\"num_unaligned_${type}_${action}_${context}\"};\n}\n\t\n\n=head2 range\n\n Title   : range\n Usage   : $tiling->range(-type=>$type)\n Function: Returns the extent of the longest tiling\n           as ($min_coord, $max_coord)\n Returns : array of two scalar integers\n Args    : -type => one of 'hit', 'subject', 'query'\n           -context => strand/frame context string\n\n\nsub range {\n    my ($self, $type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n    my @a = $self->_contig_intersection($type,$context);\n    return ($a[0][0], $a[-1][1]);\n}\n\n\n\n=head1 ACCESSORS\n\n=head2 coverage_map\n\n Title   : coverage_map\n Usage   : $map = $tiling->coverage_map($type)\n Function: Property to contain the coverage map calculated\n           by _calc_coverage_map() - see that for \n           details\n Example : \n Returns : value of coverage_map_$type as an array\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n Note    : getter \n\n\nsub coverage_map{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t# following calculates coverage maps in all strands/frames\n\t# if necessary\n\t$self->_calc_coverage_map($type, $context);\n    }\n    # if undef is returned, then there were no hsps for given strand/frame\n    if (!defined $self->{\"coverage_map_${type}_${context}\"}) {\n\t$self->warn(\"No HSPS present for type '$type' in context '$context' for this hit\");\n\treturn undef;\n    }\n    return @{$self->{\"coverage_map_${type}_${context}\"}};\n}\n\n=head2 coverage_map_as_text\n\n Title   : coverage_map_as_text\n Usage   : $tiling->coverage_map_as_text($type, $legend_flag)\n Function: Format a text-graphic representation of the\n           coverage map\n Returns : an array of scalar strings, suitable for printing\n Args    : $type: one of 'query', 'hit', 'subject'\n           $context: strand/frame context string\n           $legend_flag: boolean; add a legend indicating\n            the actual interval coordinates for each component\n            interval and hsp (in the $type sequence context)\n Example : print $tiling->coverage_map_as_text('query',1);\n\n\nsub coverage_map_as_text{\n    my $self = shift;\n    my ($type, $context, $legend_q) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    my @map = $self->coverage_map($type, $context);\n    my @ret;\n    my @hsps = $self->hit->hsps;\n    my %hsps_i;\n    require Tie::RefHash;\n    tie %hsps_i, 'Tie::RefHash';\n    @hsps_i{@hsps} = (0..$#hsps);\n    my @mx;\n    foreach (0..$#map) {\n\tmy @hspx = ('') x @hsps;\n\tmy @these_hsps = @{$map[$_]->[1]};\n\t@hspx[@hsps_i{@these_hsps}] = ('*') x @these_hsps;\n\t$mx[$_] = \\@hspx;\n    }\n    untie %hsps_i;\n\n    push @ret, \"\\tIntvl\\n\";\n    push @ret, \"HSPS\\t\", join (\"\\t\", (0..$#map)), \"\\n\";\n    foreach my $h (0..$#hsps) {\n\tpush @ret, join(\"\\t\", $h, map { $mx[$_][$h] } (0..$#map)  ),\"\\n\";\n    }\n    if ($legend_q) {\n\tpush @ret, \"Interval legend\\n\";\n\tforeach (0..$#map) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$map[$_][0]});\n\t}\n\tpush @ret, \"HSP legend\\n\";\n\tmy @ints = get_intervals_from_hsps($type,@hsps);\n\tforeach (0..$#hsps) {\n\t    push @ret, sprintf(\"%d\\t[%d, %d]\\n\", $_, @{$ints[$_]});\n\t}\n    }\n    return @ret;\n}\n\n=head2 hit\n\n Title   : hit\n Usage   : $tiling->hit\n Function: \n Example : \n Returns : The HitI object associated with the invocant\n Args    : none\n Note    : getter only \n\n\nsub hit{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{'hit'};\n}\n\n=head2 hsps\n\n Title   : hsps\n Usage   : $tiling->hsps()\n Function: Container for the HSP objects associated with invocant\n Example : \n Returns : an array of hsps associated with the hit\n Args    : on set, new value (an arrayref or undef, optional)\n\n\nsub hsps{\n    my $self = shift;\n    return $self->{'hsps'} = shift if @_;\n    return @{$self->{'hsps'}};\n}\n\n=head2 contexts\n\n Title   : contexts\n Usage   : @contexts = $tiling->context($type) or\n           @indices = $tiling->context($type, $context)\n Function: Retrieve the set of available contexts in the hit,\n           or the indices of hsps having the given context\n           (integer indices for the array returned by $self->hsps)\n Returns : array of scalar context strings or \n           array of scalar positive integers\n           undef if no hsps in given context\n Args    : $type: one of 'query', 'hit', 'subject'\n           optional $context: context string\n\n\nsub contexts{\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    return keys %{$self->{\"_contexts_$type\"}} unless defined $context;\n    return undef unless $self->{\"_contexts_$type\"}{$context};\n    return @{$self->{\"_contexts_$type\"}{$context}};\n}\n\n=head2 mapping\n\n Title   : mapping\n Usage   : $tiling->mapping($type)\n Function: Retrieve the mapping coefficient for the sequence type\n           based on the underlying algorithm\n Returns : scalar integer (mapping coefficient)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub mapping{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_mapping_${type}\"};\n}\n\n=head2 default_context\n\n Title   : default_context\n Usage   : $tiling->default_context($type)\n Function: Retrieve the default strand/frame context string\n           for the sequence type based on the underlying algorithm\n Returns : scalar string (context string)\n Args    : $type: one of 'query', 'hit', 'subject'\n Note    : getter only (set in constructor)\n\n\nsub default_context{\n    my $self = shift;\n    my $type = shift;\n    $self->_check_type_arg(\\$type);\n    return $self->{\"_def_context_${type}\"};\n}\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $tiling->algorithm\n Function: Retrieve the algorithm name associated with the \n           invocant's hit object\n Returns : scalar string \n Args    : none\n Note    : getter only (set in constructor)\n\n\nsub algorithm{\n    my $self = shift;\n    $self->warn(\"Getter only\") if @_;\n    return $self->{\"_algorithm\"};\n}\n\n=head1 \"PRIVATE\" METHODS\n\n=head2 Calculators\n\nSee L<Bio::Search::Tiling::MapTileUtils> for lower level\ncalculation methods.\n\n=head2 _calc_coverage_map\n\n Title   : _calc_coverage_map\n Usage   : $tiling->_calc_coverage_map($type)\n Function: Calculates the coverage map for the object's associated\n           hit from the perspective of the desired $type (see Args:) \n           and sets the coverage_map() property\n Returns : True on success\n Args    : optional scalar $type: one of 'hit'|'subject'|'query'\n           default is 'query'\n Note    : The \"coverage map\" is an array with the following format:\n           ( [ $component_interval => [ @containing_hsps ] ], ... ),\n           where $component_interval is a closed interval (see \n           DESCRIPTION) of the form [$a0, $a1] with $a0 <= $a1, and\n           @containing_hsps is an array of all HspI objects in the hit \n           which completely contain the $component_interval.\n           The set of $component_interval's is a disjoint decomposition\n           of the minimum set of minimal intervals that completely\n           cover the hit's HSPs (from the perspective of the $type)\n Note    : This calculates the map for all strand/frame contexts available\n           in the hit\n\n\nsub _calc_coverage_map {\n    my $self = shift;\n    my ($type) = @_;\n    $self->_check_type_arg(\\$type);\n\n    # obtain the [start, end] intervals for all hsps in the hit (relative\n    # to the type)\n    unless ($self->{'hsps'}) {\n\t$self->warn(\"No HSPs for this hit\");\n\treturn;\n    }\n\n    my (@map, @hsps, %filters, @intervals);\n    \n\n    # conversion here?\n    my $c = $self->mapping($type);\n    \n    # create the possible maps \n    for my $context ($self->contexts($type)) {\n\t@map = ();\n\t@hsps = ($self->hsps)[$self->contexts($type, $context)];\n\t@intervals = get_intervals_from_hsps( $type, @hsps );\n\t# the \"frame\"\n\tmy $f = ($intervals[0]->[0] - 1) % $c;\n\n\t# convert interval endpoints...\n\tfor (@intervals) {\n\t    $$_[0] = ($$_[0] - $f + $c - 1)/$c;\n\t    $$_[1]  = ($$_[1] - $f)/$c;\n\t}\n\t\n\t# determine the minimal set of disjoint intervals that cover the\n\t# set of hsp intervals\n\tmy @dj_set = interval_tiling(\\@intervals);\n\n\t# decompose each disjoint interval into another set of disjoint \n\t# intervals, each of which is completely contained within the\n\t# original hsp intervals with which it overlaps\n\tmy $i=0;\n\tmy @decomp;\n\tfor my $dj_elt (@dj_set) {\n\t    my ($covering, $indices) = @$dj_elt;\n\t    my @covering_hsps = @hsps[@$indices];\n\t    my @coverers = @intervals[@$indices];\n\t    @decomp = decompose_interval( \\@coverers );\n\t    for (@decomp) {\n\t\tmy ($component, $container_indices) = @{$_};\n\t\tpush @map, [ $component, \n\t\t\t     [@covering_hsps[@$container_indices]] ];\n\t    }\n\t    1;\n\t}\n    \n\t# unconvert the components:\n#####\n\tforeach (@map) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\n\tforeach (@dj_set) {\n\t    $$_[0][0] = $c*$$_[0][0] - $c + 1 + $f;\n\t    $$_[0][1] = $c*$$_[0][1] + $f;\n\t}\t    \n\n\t# sort the map on the interval left-ends\n\t@map = sort { $a->[0][0]<=>$b->[0][0] } @map;\n\t$self->{\"coverage_map_${type}_${context}\"} = [@map];\n\t# set the _contig_intersection attribute here (side effect)\n\t$self->{\"_contig_intersection_${type}_${context}\"} = [map { $$_[0] } @dj_set];\n    }\n\n    return 1; # success\n}\n\n=head2 _calc_stats\n\n Title   : _calc_stats\n Usage   : $tiling->_calc_stats($type, $action, $context)\n Function: Calculates [estimated] tiling statistics (identities, conserved sites\n           length) and sets the public accessors\n Returns : True on success\n Args    : scalar $type: one of 'hit', 'subject', 'query'\n           default is 'query'\n           optional scalar $action: requests calculation method\n            currently one of 'exact', 'est', 'fast', 'max'\n           option scalar $context: strand/frame context string\n Note    : Action: The statistics are calculated by summing quantities\n           over the disjoint component intervals, taking into account\n           coverage of those intervals by multiple HSPs. The action\n           tells the algorithm how to obtain those quantities--\n           'exact' will use Bio::Search::HSP::HSPI::matches\n            to count the appropriate segment of the homology string;\n           'est' will estimate the statistics by multiplying the \n            fraction of the HSP overlapped by the component interval\n            (see MapTileUtils) by the BLAST-reported identities/postives\n            (this may be convenient for BLAST summary report formats)\n           * Both exact and est take the average over the number of HSPs\n             that overlap the component interval.\n           'max' uses the exact method to calculate the statistics, \n            and returns only the maximum identites/positives over \n            overlapping HSP for the component interval. No averaging\n            is involved here.\n           'fast' doesn't involve tiling at all (hence the name),\n            but it seems like a very good estimate, and uses only\n            reported values, and so does not require sequence data. It\n            calculates an average of reported identities, conserved\n            sites, and lengths, over unmodified hsps in the hit,\n            weighted by the length of the hsps.  \n\n\nsub _calc_stats {\n    my $self = shift;\n    my ($type, $action, $context) = @_;\n    # need to check args here, in case method is called internally.\n    $self->_check_type_arg(\\$type);\n    $self->_check_action_arg(\\$action);\n    $self->_check_context_arg($type, \\$context);\n    my ($ident, $cons, $length) = (0,0,0);\n\n    # fast : avoid coverage map altogether, get a pretty damn\n    # good estimate with a weighted average of reported hsp\n    # statistics\n\n    ($action eq 'fast') && do {\n\tmy @hsps = $self->hit->hsps;\n\t@hsps = @hsps[$self->contexts($type, $context)];\n\t# weights for averages\n\tmy @wt = map {$_->length($type)} @hsps;\n\tmy $sum = eval( join('+',@wt) );\n\t$_ /= $sum for (@wt);\n\tfor (@hsps) { \n\t    my $wt = shift @wt;\n\t    $ident  += $wt*$_->matches_MT($type,'identities');\n\t    $cons   += $wt*$_->matches_MT($type,'conserved');\n\t    $length += $wt*$_->length($type);\n\t}\n    };\n\n    # or, do tiling\n\n    # calculate identities/conserved sites in tiling\n    # estimate based on the fraction of the component interval covered\n    # and ident/cons reported by the HSPs\n    ($action ne 'fast') && do {\n\tforeach ($self->coverage_map($type, $context)) {\n\t    my ($intvl, $hsps) = @{$_};\n\t    my $len = ($$intvl[1]-$$intvl[0]+1);\n\t    my $ncover = ($action eq 'max') ? 1 : scalar @$hsps;\n\t    my ($acc_i, $acc_c) = (0,0);\n\t    foreach my $hsp (@$hsps) {\n\t\tfor ($action) {\n\t\t    ($_ eq 'est') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    );\n\t\t\tmy $frac = $len/$hsp->length($type);\n\t\t\t$acc_i += $inc_i * $frac;\n\t\t\t$acc_c += $inc_c * $frac;\n\t\t\tlast;\n\t\t    };\n\t\t    ($_ eq 'max') && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type,\n\t\t\t    -action => 'searchutils',\n\t\t\t    -start => $$intvl[0], \n\t\t\t    -end   => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i = ($acc_i > $inc_i) ? $acc_i : $inc_i;\n\t\t\t$acc_c = ($acc_c > $inc_c) ? $acc_c : $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t    (!$_ || ($_ eq 'exact')) && do {\n\t\t\tmy ($inc_i, $inc_c) = $hsp->matches_MT(\n\t\t\t    -type   => $type, \n\t\t\t    -action => 'searchutils',\n\t\t\t    -start  => $$intvl[0], \n\t\t\t    -end    => $$intvl[1]\n\t\t\t    );\n\t\t\t$acc_i += $inc_i;\n\t\t\t$acc_c += $inc_c;\n\t\t\tlast;\n\t\t    };\n\t\t}\n\t    }\n\t    $ident += ($acc_i/$ncover);\n\t    $cons  += ($acc_c/$ncover);\n\t    $length += $len;\n\t}\n    };\n    \n    $self->{\"identities_${type}_${action}_${context}\"} = $ident;\n    $self->{\"conserved_${type}_${action}_${context}\"} = $cons;\n    $self->{\"length_${type}_${action}_${context}\"} = $length;\n    \n    return 1;\n}\n\n=head2 Tiling Helper Methods\n\n\n# coverage_map is of the form\n# ( [ $interval, \\@containing_hsps ], ... )\n\n# so, for each interval, pick one of the containing hsps,\n# and return the union of all the picks.\n\n# use the combinatorial generating iterator, with \n# the urns containing the @containing_hsps for each\n# interval\n\n=head2 _make_tiling_iterator\n\n Title   : _make_tiling_iterator\n Usage   : $self->_make_tiling_iterator($type)\n Function: Create an iterator code ref that will step through all \n           minimal combinations of HSPs that produce complete coverage\n           of the $type ('hit', 'subject', 'query') sequence, \n           and set the correct iterator property of the invocant\n Example :\n Returns : True on success\n Args    : scalar $type, one of 'hit', 'subject', 'query';\n           default is 'query'\n\n\nsub _make_tiling_iterator {\n    ### create the urns\n    my $self = shift;\n    my ($type, $context) = @_;\n    $self->_check_type_arg(\\$type);\n    $self->_check_context_arg($type, \\$context);\n\n    # initialize the urns\n    my @urns = map { [0,  $$_[1]] } $self->coverage_map($type, $context);\n\n    my $FINISHED = 0;\n    my $iter = sub {\n\t# rewind?\n\tif (my $rewind = shift) {\n\t    # reinitialize urn indices\n\t    $$_[0] = 0 for (@urns);\n\t    $FINISHED = 0;\n\t    return 1;\n\t}\t    \n\t# check if done...\n        return if $FINISHED;\n\n        my $finished_incrementing = 0;\n\t# @ret is the collector of urn choices\n\tmy @ret;\n\n\tfor my $urn (@urns) {\n\t    my ($n, $hsps) = @$urn;\n\t    push @ret, $$hsps[$n];\n\t    unless ($finished_incrementing) {\n\t\tif ($n == $#$hsps) { $$urn[0] = 0; }\n\t\telse { ($$urn[0])++; $finished_incrementing = 1 }\n\t    }\n\t}\n\n\t# backstop...\n        $FINISHED = 1 unless $finished_incrementing;\n\t# uniquify @ret\n\t# $hsp->rank is a unique identifier for an hsp in a hit.\n\t# preserve order in @ret\n\t\n\tmy (%order, %uniq);\n\t@order{(0..$#ret)} = @ret;\n\t$uniq{$order{$_}->rank} = $_ for (0..$#ret);\n\t@ret = @order{ sort {$a<=>$b} values %uniq };\n\n        return @ret;\n    };\n\n    $self->{\"_tiling_iterator_${type}_${context}\"} = $iter;\n    return 1;\n}\n\n=head2 _tiling_iterator\n\n Title   : _tiling_iterator\n Usage   : $tiling->_tiling_iterator($type,$context)\n Function: Retrieve the tiling iterator coderef for the requested \n           $type ('hit', 'subject', 'query')\n Example : \n Returns : coderef to the desired iterator\n Args    : scalar $type, one of 'hit', 'subject', 'query'\n           default is 'query'\n           option scalar $context: strand/frame context string\n Note    : getter only","label":"_tiling_iterator($type,$context)"},"detail":"($type,$context)","kind":12,"children":[{"localvar":"my","containerName":"_tiling_iterator","name":"$self","definition":"my","line":1113,"kind":13},{"kind":13,"line":1114,"definition":"my","name":"$type","containerName":"_tiling_iterator","localvar":"my"},{"name":"$context","containerName":"_tiling_iterator","line":1114,"kind":13},{"name":"$self","containerName":"_tiling_iterator","kind":13,"line":1115},{"kind":12,"line":1115,"containerName":"_tiling_iterator","name":"_check_type_arg"},{"name":"$type","containerName":"_tiling_iterator","line":1115,"kind":13},{"name":"$self","containerName":"_tiling_iterator","kind":13,"line":1116},{"containerName":"_tiling_iterator","name":"_check_context_arg","kind":12,"line":1116},{"containerName":"_tiling_iterator","name":"$type","line":1116,"kind":13},{"kind":13,"line":1116,"name":"$context","containerName":"_tiling_iterator"},{"name":"$self","containerName":"_tiling_iterator","kind":13,"line":1118},{"containerName":"_tiling_iterator","name":"$self","line":1119,"kind":13},{"containerName":"_tiling_iterator","name":"_make_tiling_iterator","line":1119,"kind":12},{"line":1119,"kind":13,"name":"$type","containerName":"_tiling_iterator"},{"line":1119,"kind":13,"containerName":"_tiling_iterator","name":"$context"},{"line":1121,"kind":13,"containerName":"_tiling_iterator","name":"$self"}],"line":1112},{"children":[{"definition":"my","name":"$self","containerName":"_check_type_arg","localvar":"my","kind":13,"line":1131},{"localvar":"my","definition":"my","name":"$typeref","containerName":"_check_type_arg","line":1132,"kind":13},{"name":"$self","containerName":"_check_type_arg","line":1134,"kind":13},{"kind":12,"line":1134,"containerName":"_check_type_arg","name":"throw"}],"line":1130,"kind":12,"range":{"end":{"line":1137,"character":9999},"start":{"character":0,"line":1130}},"definition":"sub","name":"_check_type_arg","containerName":"main::"},{"line":1133,"kind":12,"name":"typeref"},{"name":"typeref","kind":12,"line":1135},{"line":1135,"kind":12,"name":"typeref"},{"children":[{"name":"$self","definition":"my","containerName":"_check_action_arg","localvar":"my","kind":13,"line":1140},{"kind":13,"line":1141,"definition":"my","name":"$actionref","containerName":"_check_action_arg","localvar":"my"},{"containerName":"_check_action_arg","name":"$self","kind":13,"line":1143},{"kind":12,"line":1143,"name":"_has_sequence_data","containerName":"_check_action_arg"},{"name":"$self","containerName":"_check_action_arg","line":1146,"kind":13},{"containerName":"_check_action_arg","name":"throw","kind":12,"line":1146},{"kind":13,"line":1147,"containerName":"_check_action_arg","name":"$self"},{"containerName":"_check_action_arg","name":"_has_sequence_data","kind":12,"line":1147},{"name":"$self","containerName":"_check_action_arg","kind":13,"line":1148},{"name":"warn","containerName":"_check_action_arg","kind":12,"line":1148}],"line":1139,"kind":12,"range":{"end":{"line":1153,"character":9999},"start":{"character":0,"line":1139}},"name":"_check_action_arg","definition":"sub","containerName":"main::"},{"kind":12,"line":1142,"name":"actionref"},{"name":"actionref","line":1143,"kind":12},{"kind":12,"line":1147,"name":"actionref"},{"line":1149,"kind":12,"name":"actionref"},{"range":{"end":{"character":9999,"line":1169},"start":{"line":1155,"character":0}},"name":"_check_context_arg","children":[{"localvar":"my","containerName":"_check_context_arg","definition":"my","name":"$self","line":1156,"kind":13},{"name":"$type","definition":"my","containerName":"_check_context_arg","localvar":"my","kind":13,"line":1157},{"line":1157,"kind":13,"containerName":"_check_context_arg","name":"$contextref"},{"line":1159,"kind":13,"containerName":"_check_context_arg","name":"$self"},{"name":"throw","containerName":"_check_context_arg","line":1159,"kind":12},{"name":"$self","containerName":"_check_context_arg","kind":13,"line":1159},{"name":"algorithm","containerName":"_check_context_arg","kind":12,"line":1159},{"name":"$self","containerName":"_check_context_arg","line":1159,"kind":13},{"line":1159,"kind":12,"name":"mapping","containerName":"_check_context_arg"},{"containerName":"_check_context_arg","name":"$type","line":1159,"kind":13},{"name":"$self","containerName":"_check_context_arg","kind":13,"line":1161},{"containerName":"_check_context_arg","name":"default_context","line":1161,"kind":12},{"kind":13,"line":1161,"containerName":"_check_context_arg","name":"$type"},{"kind":13,"line":1165,"containerName":"_check_context_arg","name":"$self"},{"name":"throw","containerName":"_check_context_arg","line":1165,"kind":12}],"line":1155,"kind":12,"signature":{"label":"_check_context_arg($type,$contextref)","parameters":[{"label":"$type"},{"label":"$contextref"}],"documentation":""},"detail":"($type,$contextref)","definition":"sub","containerName":"main::"},{"line":1158,"kind":12,"name":"contextref"},{"name":"contextref","line":1161,"kind":12},{"name":"contextref","line":1164,"kind":12},{"kind":12,"line":1164,"name":"contextref"},{"name":"contextref","line":1166,"kind":12},{"kind":12,"line":1186,"children":[{"containerName":"_make_context_key","definition":"my","name":"$self","localvar":"my","kind":13,"line":1187},{"kind":13,"line":1188,"containerName":"_make_context_key","definition":"my","name":"@args","localvar":"my"},{"localvar":"my","name":"$type","definition":"my","containerName":"_make_context_key","line":1189,"kind":13},{"containerName":"_make_context_key","name":"$strand","line":1189,"kind":13},{"containerName":"_make_context_key","name":"$frame","line":1189,"kind":13},{"containerName":"_make_context_key","name":"$self","kind":13,"line":1189},{"name":"_rearrange","containerName":"_make_context_key","kind":12,"line":1189},{"line":1189,"kind":13,"name":"@args","containerName":"_make_context_key"},{"kind":13,"line":1190,"containerName":"_make_context_key","name":"$type"},{"name":"$strand","containerName":"_make_context_key","line":1191,"kind":13},{"line":1191,"kind":13,"containerName":"_make_context_key","name":"$frame"},{"containerName":"_make_context_key","name":"$strand","line":1192,"kind":13},{"containerName":"_make_context_key","name":"$self","line":1192,"kind":13},{"line":1192,"kind":12,"name":"_has_strand","containerName":"_make_context_key"},{"containerName":"_make_context_key","name":"$type","line":1192,"kind":13},{"kind":13,"line":1193,"name":"$frame","containerName":"_make_context_key"},{"kind":13,"line":1193,"name":"$self","containerName":"_make_context_key"},{"kind":12,"line":1193,"containerName":"_make_context_key","name":"_has_frame"},{"line":1193,"kind":13,"name":"$type","containerName":"_make_context_key"},{"line":1194,"kind":13,"name":"$strand","containerName":"_make_context_key"},{"name":"$frame","containerName":"_make_context_key","kind":13,"line":1194},{"containerName":"_make_context_key","name":"$strand","line":1197,"kind":13},{"containerName":"_make_context_key","name":"$frame","line":1201,"kind":13},{"line":1201,"kind":13,"name":"$self","containerName":"_make_context_key"},{"kind":12,"line":1201,"name":"_has_frame","containerName":"_make_context_key"},{"name":"$type","containerName":"_make_context_key","line":1201,"kind":13},{"line":1202,"kind":13,"containerName":"_make_context_key","name":"$self"},{"kind":12,"line":1202,"name":"warn","containerName":"_make_context_key"},{"line":1203,"kind":13,"containerName":"_make_context_key","name":"$frame"}],"containerName":"main::","name":"_make_context_key","definition":"sub","range":{"start":{"line":1186,"character":0},"end":{"character":9999,"line":1209}}},{"children":[{"line":1226,"kind":12,"name":"_make_context_key","containerName":"_context"}],"line":1226,"kind":12,"range":{"end":{"line":1226,"character":9999},"start":{"character":0,"line":1226}},"definition":"sub","name":"_context","containerName":"main::"},{"name":"_has_sequence_data","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1239},"end":{"character":9999,"line":1243}},"kind":12,"children":[{"kind":13,"line":1240,"containerName":"_has_sequence_data","name":"$self","definition":"my","localvar":"my"},{"containerName":"_has_sequence_data","name":"$self","kind":13,"line":1241},{"line":1241,"kind":12,"containerName":"_has_sequence_data","name":"throw"},{"name":"$self","containerName":"_has_sequence_data","kind":13,"line":1241},{"name":"hit","containerName":"_has_sequence_data","line":1241,"kind":12},{"containerName":"_has_sequence_data","name":"$self","kind":13,"line":1242},{"containerName":"_has_sequence_data","name":"hit","kind":12,"line":1242},{"name":"hsps","containerName":"_has_sequence_data","kind":12,"line":1242},{"name":"seq_str","containerName":"_has_sequence_data","line":1242,"kind":12}],"line":1239},{"kind":12,"children":[{"definition":"my","name":"$self","containerName":"_has_logical_length","localvar":"my","kind":13,"line":1250},{"localvar":"my","definition":"my","name":"$type","containerName":"_has_logical_length","line":1251,"kind":13},{"name":"$self","containerName":"_has_logical_length","line":1252,"kind":13},{"kind":12,"line":1252,"name":"_check_type_arg","containerName":"_has_logical_length"},{"name":"$type","containerName":"_has_logical_length","kind":13,"line":1252},{"name":"$self","containerName":"_has_logical_length","line":1254,"kind":13},{"name":"throw","containerName":"_has_logical_length","kind":12,"line":1254},{"line":1254,"kind":13,"containerName":"_has_logical_length","name":"$self"},{"line":1254,"kind":12,"containerName":"_has_logical_length","name":"mapping"},{"containerName":"_has_logical_length","name":"$type","line":1254,"kind":13},{"line":1255,"kind":13,"containerName":"_has_logical_length","name":"$self"},{"kind":12,"line":1255,"name":"mapping","containerName":"_has_logical_length"},{"line":1255,"kind":13,"containerName":"_has_logical_length","name":"$type"}],"line":1249,"name":"_has_logical_length","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":1249},"end":{"line":1256,"character":9999}}},{"definition":"sub","name":"_has_strand","containerName":"main::","range":{"start":{"character":0,"line":1262},"end":{"line":1267,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_has_strand","line":1263,"kind":13},{"kind":13,"line":1264,"definition":"my","name":"$type","containerName":"_has_strand","localvar":"my"},{"containerName":"_has_strand","name":"$self","line":1265,"kind":13},{"containerName":"_has_strand","name":"_check_type_arg","line":1265,"kind":12},{"line":1265,"kind":13,"name":"$type","containerName":"_has_strand"},{"containerName":"_has_strand","name":"$self","line":1266,"kind":13}],"line":1262},{"kind":12,"children":[{"line":1274,"kind":13,"localvar":"my","containerName":"_has_frame","name":"$self","definition":"my"},{"localvar":"my","name":"$type","definition":"my","containerName":"_has_frame","line":1275,"kind":13},{"kind":13,"line":1276,"containerName":"_has_frame","name":"$self"},{"containerName":"_has_frame","name":"_check_type_arg","line":1276,"kind":12},{"name":"$type","containerName":"_has_frame","line":1276,"kind":13},{"line":1277,"kind":13,"containerName":"_has_frame","name":"$self"}],"line":1273,"name":"_has_frame","definition":"sub","containerName":"main::","range":{"end":{"line":1278,"character":9999},"start":{"line":1273,"character":0}}},{"kind":12,"children":[{"containerName":"_contig_intersection","definition":"my","name":"$self","localvar":"my","kind":13,"line":1296},{"localvar":"my","name":"$type","definition":"my","containerName":"_contig_intersection","line":1297,"kind":13},{"kind":13,"line":1297,"containerName":"_contig_intersection","name":"$context"},{"containerName":"_contig_intersection","name":"$self","line":1298,"kind":13},{"kind":12,"line":1298,"containerName":"_contig_intersection","name":"_check_type_arg"},{"kind":13,"line":1298,"containerName":"_contig_intersection","name":"$type"},{"containerName":"_contig_intersection","name":"$self","line":1299,"kind":13},{"kind":12,"line":1299,"name":"_check_context_arg","containerName":"_contig_intersection"},{"kind":13,"line":1299,"containerName":"_contig_intersection","name":"$type"},{"line":1299,"kind":13,"containerName":"_contig_intersection","name":"$context"},{"containerName":"_contig_intersection","name":"$self","line":1300,"kind":13},{"kind":13,"line":1301,"name":"$self","containerName":"_contig_intersection"},{"containerName":"_contig_intersection","name":"_calc_coverage_map","line":1301,"kind":12},{"name":"$type","containerName":"_contig_intersection","kind":13,"line":1301},{"line":1303,"kind":13,"containerName":"_contig_intersection","name":"$self"}],"line":1295,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$type"},{"label":"$context"}],"documentation":"","label":"_contig_intersection($type,$context)"},"detail":"($type,$context)","name":"_contig_intersection","range":{"start":{"character":0,"line":1295},"end":{"character":9999,"line":1303}}},{"kind":12,"children":[{"line":1326,"kind":13,"localvar":"my","containerName":"_reported_length","name":"$self","definition":"my"},{"kind":13,"line":1327,"containerName":"_reported_length","definition":"my","name":"$type","localvar":"my"},{"kind":13,"line":1328,"name":"$self","containerName":"_reported_length"},{"kind":12,"line":1328,"name":"_check_type_arg","containerName":"_reported_length"},{"line":1328,"kind":13,"containerName":"_reported_length","name":"$type"},{"kind":13,"line":1329,"name":"$key","definition":"my","containerName":"_reported_length","localvar":"my"},{"line":1329,"kind":13,"name":"$type","containerName":"_reported_length"},{"name":"$self","containerName":"_reported_length","kind":13,"line":1330},{"line":1330,"kind":12,"name":"hsps","containerName":"_reported_length"},{"line":1330,"kind":13,"name":"$key","containerName":"_reported_length"}],"line":1325,"definition":"sub","name":"_reported_length","containerName":"main::","range":{"start":{"character":0,"line":1325},"end":{"line":1331,"character":9999}}}],"version":5}