{"vars":[{"containerName":"","name":"base","line":84,"kind":2},{"name":"new","range":{"end":{"line":125,"character":9999},"start":{"line":105,"character":0}},"kind":12,"children":[{"line":106,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":106},{"line":107,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","line":107,"kind":13},{"line":107,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":109,"name":"$self","containerName":"new"},{"name":"_setup","containerName":"new","line":109,"kind":12},{"kind":13,"line":109,"containerName":"new","name":"@args"},{"kind":13,"line":111,"containerName":"new","definition":"my","name":"$field","localvar":"my"},{"line":112,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":112,"name":"_fields","containerName":"new"},{"line":112,"kind":13,"containerName":"new","name":"$field"},{"name":"$self","containerName":"new","line":115,"kind":13},{"kind":12,"line":115,"containerName":"new","name":"_dependencies"},{"containerName":"new","name":"$self","line":124,"kind":13}],"line":105,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HmmpfamResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HmmpfamResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HmmpfamResult - A parser and result object for hmmpfam\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam result output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::HmmpfamResult;\n\nuse strict;\n\nuse Bio::Search::Hit::HmmpfamHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)"},"detail":"($class,@args)"},{"kind":12,"line":107,"containerName":"new","name":"SUPER"},{"kind":12,"line":115,"name":"query_name"},{"line":116,"kind":12,"name":"query_accession"},{"name":"query_description","line":117,"kind":12},{"name":"hit_table","line":118,"kind":12},{"name":"num_hits","line":119,"kind":12},{"name":"no_hits_found","kind":12,"line":120},{"name":"hsp_table","kind":12,"line":121},{"kind":12,"line":122,"name":"next_alignment"},{"kind":12,"line":131,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_discover_header","line":132,"kind":13},{"containerName":"_discover_header","name":"$self","kind":13,"line":133},{"line":133,"kind":12,"containerName":"_discover_header","name":"_chunk_seek"},{"line":134,"kind":13,"localvar":"my","name":"$header","definition":"my","containerName":"_discover_header"},{"name":"$self","containerName":"_discover_header","line":134,"kind":13},{"kind":12,"line":134,"containerName":"_discover_header","name":"_get_chunk_by_end"},{"name":"$self","containerName":"_discover_header","line":135,"kind":13},{"kind":13,"line":135,"containerName":"_discover_header","name":"$self"},{"name":"_chunk_tell","containerName":"_discover_header","kind":12,"line":135},{"name":"$header","containerName":"_discover_header","line":137,"kind":13},{"name":"$self","containerName":"_discover_header","kind":13,"line":137},{"containerName":"_discover_header","name":"throw","kind":12,"line":137},{"kind":13,"line":139,"containerName":"_discover_header","name":"$self"},{"name":"_fields","containerName":"_discover_header","kind":12,"line":139},{"containerName":"_discover_header","name":"$header","line":139,"kind":13},{"line":140,"kind":13,"name":"$self","containerName":"_discover_header"},{"name":"_fields","containerName":"_discover_header","line":140,"kind":12},{"name":"$header","containerName":"_discover_header","line":140,"kind":13},{"containerName":"_discover_header","name":"$self","line":141,"kind":13},{"line":141,"kind":12,"containerName":"_discover_header","name":"_fields"},{"name":"$header","containerName":"_discover_header","kind":13,"line":141},{"kind":13,"line":142,"containerName":"_discover_header","name":"$self"},{"containerName":"_discover_header","name":"_fields","kind":12,"line":142},{"containerName":"_discover_header","name":"$self","line":143,"kind":13},{"name":"_fields","containerName":"_discover_header","kind":12,"line":143},{"name":"$self","containerName":"_discover_header","kind":13,"line":145},{"kind":12,"line":145,"name":"_fields","containerName":"_discover_header"}],"containerName":"main::","definition":"sub","name":"_discover_header","range":{"end":{"line":146,"character":9999},"start":{"character":0,"line":131}}},{"name":"_after_header","line":135,"kind":12},{"line":139,"kind":12,"name":"query_name"},{"kind":12,"line":140,"name":"query_accession"},{"line":141,"kind":12,"name":"query_description"},{"line":142,"kind":12,"name":"query_accession"},{"kind":12,"line":143,"name":"query_description"},{"kind":12,"line":145,"name":"header"},{"definition":"sub","name":"_discover_hit_table","containerName":"main::","range":{"end":{"line":177,"character":9999},"start":{"character":0,"line":148}},"kind":12,"children":[{"line":149,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_discover_hit_table"},{"kind":13,"line":151,"containerName":"_discover_hit_table","name":"$self"},{"kind":12,"line":151,"containerName":"_discover_hit_table","name":"_chunk_seek"},{"name":"$self","containerName":"_discover_hit_table","line":151,"kind":13},{"localvar":"my","containerName":"_discover_hit_table","definition":"my","name":"$table","line":152,"kind":13},{"name":"$self","containerName":"_discover_hit_table","line":152,"kind":13},{"line":152,"kind":12,"name":"_get_chunk_by_end","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$self","line":153,"kind":13},{"name":"$self","containerName":"_discover_hit_table","line":153,"kind":13},{"containerName":"_discover_hit_table","name":"_chunk_tell","line":153,"kind":12},{"localvar":"my","definition":"my","name":"$evalue_cutoff","containerName":"_discover_hit_table","line":155,"kind":13},{"containerName":"_discover_hit_table","name":"$self","line":155,"kind":13},{"line":155,"kind":12,"containerName":"_discover_hit_table","name":"get_field"},{"name":"$evalue_cutoff","containerName":"_discover_hit_table","kind":13,"line":156},{"name":"$evalue_cutoff","containerName":"_discover_hit_table","line":156,"kind":13},{"kind":13,"line":157,"containerName":"_discover_hit_table","definition":"my","name":"$score_cutoff","localvar":"my"},{"name":"$self","containerName":"_discover_hit_table","line":157,"kind":13},{"kind":12,"line":157,"name":"get_field","containerName":"_discover_hit_table"},{"line":158,"kind":13,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"line":158,"kind":13,"name":"$score_cutoff","containerName":"_discover_hit_table"},{"localvar":"my","name":"$hsps_cutoff","definition":"my","containerName":"_discover_hit_table","line":159,"kind":13},{"containerName":"_discover_hit_table","name":"$self","line":159,"kind":13},{"name":"get_field","containerName":"_discover_hit_table","kind":12,"line":159},{"name":"$hsps_cutoff","containerName":"_discover_hit_table","line":160,"kind":13},{"name":"$hsps_cutoff","containerName":"_discover_hit_table","line":160,"kind":13},{"kind":13,"line":162,"name":"@table","definition":"my","containerName":"_discover_hit_table","localvar":"my"},{"kind":13,"line":163,"containerName":"_discover_hit_table","name":"$no_hit","definition":"my","localvar":"my"},{"kind":13,"line":164,"name":"$table","containerName":"_discover_hit_table"},{"line":165,"kind":13,"containerName":"_discover_hit_table","name":"$no_hit"},{"localvar":"my","containerName":"_discover_hit_table","name":"$evalue","definition":"my","line":166,"kind":13},{"line":167,"kind":13,"name":"$evalue_cutoff","containerName":"_discover_hit_table"},{"line":167,"kind":13,"name":"$evalue","containerName":"_discover_hit_table"},{"kind":13,"line":167,"containerName":"_discover_hit_table","name":"$evalue_cutoff"},{"line":168,"kind":13,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"kind":13,"line":168,"containerName":"_discover_hit_table","name":"$score_cutoff"},{"line":169,"kind":13,"name":"$hsps_cutoff","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$hsps_cutoff","line":169,"kind":13},{"containerName":"_discover_hit_table","name":"@table","kind":13,"line":170},{"line":170,"kind":13,"name":"$evalue","containerName":"_discover_hit_table"},{"containerName":"_discover_hit_table","name":"$self","kind":13,"line":172},{"name":"_fields","containerName":"_discover_hit_table","line":172,"kind":12},{"name":"@table","containerName":"_discover_hit_table","kind":13,"line":172},{"kind":13,"line":173,"name":"$self","containerName":"_discover_hit_table"},{"kind":13,"line":173,"name":"@table","containerName":"_discover_hit_table"},{"line":175,"kind":13,"name":"$self","containerName":"_discover_hit_table"},{"line":175,"kind":12,"containerName":"_discover_hit_table","name":"_fields"},{"kind":13,"line":175,"name":"$no_hit","containerName":"_discover_hit_table"},{"name":"$self","containerName":"_discover_hit_table","line":176,"kind":13},{"line":176,"kind":12,"containerName":"_discover_hit_table","name":"_fields"},{"line":176,"kind":13,"containerName":"_discover_hit_table","name":"@table"}],"line":148},{"line":151,"kind":12,"name":"_after_header"},{"kind":12,"line":153,"name":"_after_hit_table"},{"line":172,"kind":12,"name":"hit_table"},{"line":173,"kind":12,"name":"_next_hit_index"},{"line":175,"kind":12,"name":"no_hits_found"},{"line":176,"kind":12,"name":"num_hits"},{"range":{"end":{"character":9999,"line":197},"start":{"line":179,"character":0}},"name":"_discover_hsp_table","definition":"sub","containerName":"main::","children":[{"kind":13,"line":180,"containerName":"_discover_hsp_table","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"_discover_hsp_table","line":182,"kind":13},{"name":"_chunk_seek","containerName":"_discover_hsp_table","kind":12,"line":182},{"containerName":"_discover_hsp_table","name":"$self","line":182,"kind":13},{"localvar":"my","name":"$table","definition":"my","containerName":"_discover_hsp_table","line":183,"kind":13},{"line":183,"kind":13,"name":"$self","containerName":"_discover_hsp_table"},{"kind":12,"line":183,"name":"_get_chunk_by_end","containerName":"_discover_hsp_table"},{"line":184,"kind":13,"containerName":"_discover_hsp_table","name":"$table"},{"line":184,"kind":13,"containerName":"_discover_hsp_table","name":"$self"},{"kind":12,"line":184,"name":"_get_chunk_by_end","containerName":"_discover_hsp_table"},{"containerName":"_discover_hsp_table","name":"$self","line":185,"kind":13},{"line":185,"kind":13,"name":"$self","containerName":"_discover_hsp_table"},{"containerName":"_discover_hsp_table","name":"_chunk_tell","line":185,"kind":12},{"line":187,"kind":13,"localvar":"my","containerName":"_discover_hsp_table","definition":"my","name":"%table"},{"name":"$table","containerName":"_discover_hsp_table","line":190,"kind":13},{"kind":13,"line":192,"containerName":"_discover_hsp_table","name":"$evalue","definition":"my","localvar":"my"},{"containerName":"_discover_hsp_table","name":"$table","line":193,"kind":13},{"name":"$evalue","containerName":"_discover_hsp_table","line":193,"kind":13},{"containerName":"_discover_hsp_table","name":"$table","kind":13,"line":195}],"line":179,"kind":12},{"name":"_after_hit_table","kind":12,"line":182},{"kind":12,"line":185,"name":"_after_hsp_table"},{"name":"hsp_data","kind":12,"line":193},{"kind":12,"line":195,"name":"hit_length"},{"line":198,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_fields","line":198,"kind":12},{"line":198,"kind":12,"name":"hsp_table"},{"containerName":null,"name":"%table","kind":13,"line":198},{"kind":12,"children":[{"localvar":"my","containerName":"_discover_alignments","name":"$self","definition":"my","line":202,"kind":13},{"kind":13,"line":203,"name":"$self","containerName":"_discover_alignments"},{"name":"_fields","containerName":"_discover_alignments","line":203,"kind":12}],"line":201,"name":"_discover_alignments","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":204},"start":{"line":201,"character":0}}},{"name":"alignments","kind":12,"line":203},{"range":{"end":{"character":9999,"line":249},"start":{"line":206,"character":0}},"name":"_next_alignment","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_next_alignment","definition":"my","name":"$self","line":207,"kind":13},{"containerName":"_next_alignment","name":"$self","line":208,"kind":13},{"name":"$aligns","definition":"my","containerName":"_next_alignment","localvar":"my","kind":13,"line":210},{"containerName":"_next_alignment","name":"$self","kind":13,"line":210},{"line":210,"kind":12,"containerName":"_next_alignment","name":"_fields"},{"line":212,"kind":13,"name":"$self","containerName":"_next_alignment"},{"line":213,"kind":13,"containerName":"_next_alignment","name":"$self"},{"containerName":"_next_alignment","name":"_chunk_seek","kind":12,"line":213},{"line":213,"kind":13,"name":"$self","containerName":"_next_alignment"},{"kind":13,"line":214,"containerName":"_next_alignment","name":"$chunk","definition":"my","localvar":"my"},{"line":214,"kind":13,"name":"$self","containerName":"_next_alignment"},{"line":214,"kind":12,"containerName":"_next_alignment","name":"_get_chunk_by_end"},{"kind":13,"line":215,"containerName":"_next_alignment","name":"$chunk"},{"containerName":"_next_alignment","name":"$self","line":216,"kind":13},{"name":"$self","containerName":"_next_alignment","line":220,"kind":13},{"name":"$self","containerName":"_next_alignment","kind":13,"line":220},{"name":"_chunk_tell","containerName":"_next_alignment","line":220,"kind":12},{"kind":13,"line":221,"containerName":"_next_alignment","name":"$self"},{"containerName":"_next_alignment","name":"$chunk","kind":13,"line":221},{"kind":13,"line":222,"name":"$self","containerName":"_next_alignment"},{"containerName":"_next_alignment","name":"_next_alignment","kind":12,"line":222},{"name":"$self","containerName":"_next_alignment","line":225,"kind":13},{"line":225,"kind":12,"name":"_chunk_seek","containerName":"_next_alignment"},{"containerName":"_next_alignment","name":"$self","line":225,"kind":13},{"kind":13,"line":226,"definition":"my","name":"$chunk","containerName":"_next_alignment","localvar":"my"},{"name":"$self","containerName":"_next_alignment","kind":13,"line":226},{"containerName":"_next_alignment","name":"_get_chunk_by_end","line":226,"kind":12},{"name":"$chunk","containerName":"_next_alignment","line":227,"kind":13},{"name":"$self","containerName":"_next_alignment","kind":13,"line":228},{"containerName":"_next_alignment","name":"_chunk_seek","kind":12,"line":228},{"kind":13,"line":228,"name":"$self","containerName":"_next_alignment"},{"name":"$chunk","containerName":"_next_alignment","kind":13,"line":229},{"containerName":"_next_alignment","name":"$self","kind":13,"line":229},{"name":"_get_chunk_by_end","containerName":"_next_alignment","kind":12,"line":229},{"name":"$chunk","containerName":"_next_alignment","kind":13,"line":231},{"line":232,"kind":13,"name":"$self","containerName":"_next_alignment"},{"kind":13,"line":237,"containerName":"_next_alignment","name":"$self"},{"name":"$self","containerName":"_next_alignment","line":237,"kind":13},{"containerName":"_next_alignment","name":"_chunk_tell","line":237,"kind":12},{"line":239,"kind":13,"name":"$self","containerName":"_next_alignment"},{"containerName":"_next_alignment","name":"$chunk","line":240,"kind":13},{"name":"$self","containerName":"_next_alignment","line":240,"kind":13},{"line":240,"kind":13,"name":"$chunk","containerName":"_next_alignment"},{"containerName":"_next_alignment","name":"$chunk","kind":13,"line":243},{"containerName":"_next_alignment","name":"$self","kind":13,"line":244},{"definition":"my","name":"$name","containerName":"_next_alignment","localvar":"my","kind":13,"line":246},{"containerName":"_next_alignment","name":"$domain","kind":13,"line":246},{"kind":13,"line":246,"containerName":"_next_alignment","name":"$chunk"},{"line":247,"kind":13,"containerName":"_next_alignment","name":"$aligns"},{"kind":13,"line":247,"name":"$name","containerName":"_next_alignment"},{"kind":13,"line":247,"name":"$domain","containerName":"_next_alignment"},{"line":247,"kind":13,"containerName":"_next_alignment","name":"$chunk"}],"line":206,"kind":12},{"kind":12,"line":208,"name":"_no_more_alignments"},{"name":"alignments","line":210,"kind":12},{"kind":12,"line":212,"name":"_after_previous_alignment"},{"line":213,"kind":12,"name":"_after_hsp_table"},{"name":"_no_more_alignments","line":216,"kind":12},{"name":"_after_previous_alignment","line":220,"kind":12},{"line":221,"kind":12,"name":"_next_alignment_start_text"},{"name":"_after_previous_alignment","kind":12,"line":225},{"kind":12,"line":228,"name":"_after_previous_alignment"},{"name":"_no_more_alignments","kind":12,"line":232},{"kind":12,"line":237,"name":"_after_previous_alignment"},{"kind":12,"line":239,"name":"_next_alignment_start_text"},{"kind":12,"line":240,"name":"_next_alignment_start_text"},{"kind":12,"line":244,"name":"_next_alignment_start_text"},{"containerName":"main::","name":"_discover_next_hit","definition":"sub","range":{"start":{"character":0,"line":251},"end":{"character":9999,"line":253}},"kind":12,"line":251,"children":[{"kind":13,"line":252,"name":"$self","definition":"my","containerName":"_discover_next_hit","localvar":"my"},{"line":253,"kind":13,"localvar":"my","name":"@hit_table","definition":"my","containerName":"_discover_next_hit"},{"containerName":"_discover_next_hit","name":"$self","line":253,"kind":13},{"line":253,"kind":12,"containerName":"_discover_next_hit","name":"get_field"}]},{"line":254,"kind":13,"containerName":null,"name":"%self"},{"name":"_next_hit_index","kind":12,"line":254},{"localvar":"my","containerName":null,"name":"@hit_data","definition":"my","line":257,"kind":13},{"line":257,"kind":13,"containerName":null,"name":"@hit_table"},{"containerName":null,"name":"%self","kind":13,"line":257},{"line":257,"kind":12,"name":"_next_hit_index"},{"kind":13,"line":257,"name":"%self","containerName":null},{"name":"_next_hit_index","line":257,"kind":12},{"line":259,"kind":13,"name":"$self","containerName":null},{"line":259,"kind":12,"name":"_fields","containerName":"main::"},{"name":"next_hit","kind":12,"line":259},{"name":"Bio","containerName":"Search::Hit::HmmpfamHit","kind":12,"line":259},{"containerName":"main::","name":"new","kind":12,"line":259},{"containerName":null,"name":"$self","kind":13,"line":259},{"containerName":null,"name":"@hit_data","line":260,"kind":13},{"containerName":null,"name":"%self","line":262,"kind":13},{"name":"_next_hit_index","line":262,"kind":12},{"name":"hit_table","line":262,"kind":12},{"name":"%self","containerName":null,"kind":13,"line":263},{"kind":12,"line":263,"name":"_next_hit_index"},{"containerName":"main::","name":"next_hit","definition":"sub","range":{"start":{"line":278,"character":0},"end":{"character":9999,"line":283}},"kind":12,"line":278,"children":[{"localvar":"my","containerName":"next_hit","name":"$self","definition":"my","line":279,"kind":13},{"line":280,"kind":13,"localvar":"my","containerName":"next_hit","definition":"my","name":"$hit"},{"containerName":"next_hit","name":"$self","kind":13,"line":280},{"kind":12,"line":280,"containerName":"next_hit","name":"get_field"},{"containerName":"next_hit","name":"$self","line":281,"kind":13},{"kind":12,"line":281,"containerName":"next_hit","name":"_fields"},{"line":282,"kind":13,"name":"$hit","containerName":"next_hit"}]},{"line":281,"kind":12,"name":"next_hit"},{"kind":12,"line":309,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"hits","line":310,"kind":13},{"kind":13,"line":311,"definition":"my","name":"$old","containerName":"hits","localvar":"my"},{"line":311,"kind":13,"containerName":"hits","name":"$self"},{"containerName":"hits","name":"$self","line":312,"kind":13},{"containerName":"hits","name":"rewind","line":312,"kind":12},{"localvar":"my","containerName":"hits","definition":"my","name":"@hits","line":313,"kind":13},{"kind":13,"line":314,"containerName":"hits","definition":"my","name":"$hit","localvar":"my"},{"kind":13,"line":314,"name":"$self","containerName":"hits"},{"containerName":"hits","name":"next_hit","kind":12,"line":314},{"containerName":"hits","name":"@hits","line":315,"kind":13},{"kind":13,"line":315,"name":"$hit","containerName":"hits"},{"name":"$self","containerName":"hits","line":317,"kind":13},{"name":"@hits","containerName":"hits","line":317,"kind":13},{"kind":13,"line":317,"containerName":"hits","name":"$old"},{"containerName":"hits","name":"@hits","line":318,"kind":13}],"containerName":"main::","name":"hits","definition":"sub","range":{"end":{"line":319,"character":9999},"start":{"line":309,"character":0}}},{"line":311,"kind":12,"name":"_next_hit_index"},{"name":"_next_hit_index","line":317,"kind":12},{"range":{"start":{"line":360,"character":0},"end":{"line":367,"character":9999}},"name":"sort_hits","detail":"($self,$code_ref)","signature":{"label":"sort_hits($self,$code_ref)","documentation":"1;\n# $Id: HmmpfamResult.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Result::HmmpfamResult\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Result::HmmpfamResult - A parser and result object for hmmpfam\n                                     results\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\tprint $result->query_name, \" \", $result->algorithm, \" \", $result->num_hits(), \" hits\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam result output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Result::HmmpfamResult;\n\nuse strict;\n\nuse Bio::Search::Hit::HmmpfamHit;\n\nuse base qw(Bio::Root::Root Bio::Search::Result::PullResultI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::Result::hmmpfam->new();\n Function: Builds a new Bio::SearchIO::Result::hmmpfam object \n Returns : Bio::SearchIO::Result::hmmpfam\n Args    : -chunk  => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent => Bio::PullParserI object (required if no -chunk)\n           -parameters => hash ref of search parameters (key => value), optional\n           -statistics => hash ref of search statistics (key => value), optional\n\n\t\t   where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           result, and $start and $end define the tell() position within the\n           filehandle that the result data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tforeach my $field (qw( header hit_table hsp_table alignments next_model models query_length )) {\n\t\t$self->_fields->{$field} = undef;\n\t}\n\t\n\t$self->_dependencies( { ( query_name => 'header',\n                              query_accession => 'header',\n                              query_description => 'header',\n                              hit_table => 'header',\n\t\t\t\t\t\t\t  num_hits => 'hit_table',\n\t\t\t\t\t\t\t  no_hits_found => 'hit_table',\n                              hsp_table => 'hit_table',\n                              next_alignment => 'hsp_table' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all ResultI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"all domains):\\n\");\n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n\t$header || $self->throw(\"Could not find hmmer header, is file really hmmer format?\");\n\t\n\t($self->_fields->{query_name}) = $header =~ /^Query(?:\\s+sequence)?:\\s+(\\S+)/m;\n\t($self->_fields->{query_accession}) = $header =~ /^Accession:\\s+(\\S+)/m;\n\t($self->_fields->{query_description}) = $header =~ /^Description:\\s+(\\S.+)/m;\n\t$self->_fields->{query_accession} ||= '';\n\t$self->_fields->{query_description} ||= '';\n\t\n\t$self->_fields->{header} = 1; # stop this method being called again\n}\n\nsub _discover_hit_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_header});\n\tmy $table = $self->_get_chunk_by_end(\"for domains:\\n\");\n\t$self->{_after_hit_table} = $self->_chunk_tell;\n\t\n\tmy $evalue_cutoff = $self->get_field('evalue_cutoff');\n\tundef $evalue_cutoff if $evalue_cutoff eq '[unset]';\n\tmy $score_cutoff = $self->get_field('score_cutoff');\n\tundef $score_cutoff if $score_cutoff eq '[unset]';\n\tmy $hsps_cutoff = $self->get_field('hsps_cutoff');\n\tundef $hsps_cutoff if $hsps_cutoff eq '[unset]';\n\t\n\tmy @table;\n\tmy $no_hit = 1;\n\twhile ($table =~ /^(\\S+)\\s+(\\S.+?)?\\s+(\\S+)\\s+(\\S+)\\s+(\\d+)\\n/gm) {\n\t\t$no_hit = 0;\n\t\tmy $evalue = abs($4); # consistency for tests under Windows\n\t\tnext if ($evalue_cutoff && $evalue > $evalue_cutoff);\n\t\tnext if ($score_cutoff && $3 < $score_cutoff);\n\t\tnext if ($hsps_cutoff && $5 < $hsps_cutoff);\n\t\tpush(@table, [$1, $2, $3, $evalue, $5]);\n\t}\n\t$self->_fields->{hit_table} = \\@table;\n\t$self->{_next_hit_index} = @table > 0 ? 0 : -1;\n\t\n\t$self->_fields->{no_hits_found} = $no_hit;\n\t$self->_fields->{num_hits} = @table;\n}\n\nsub _discover_hsp_table {\n\tmy $self = shift;\n\t\n\t$self->_chunk_seek($self->{_after_hit_table});\n\tmy $table = $self->_get_chunk_by_end(\"top-scoring domains:\\n\");\n\t$table ||= $self->_get_chunk_by_end(\"//\\n\"); # A0 reports\n\t$self->{_after_hsp_table} = $self->_chunk_tell;\n\t\n\tmy %table;\n\t# can't save this regex work for the hsp object because the hit object needs\n\t# its length, so may as well just do all the work here\n\twhile ($table =~ /^(\\S+)\\s+(\\d+)\\/\\d+\\s+(\\d+)\\s+(\\d+)\\s+\\S\\S\\s+(\\d+)\\s+(\\d+)\\s+\\S(\\S)\\s+(\\S+)\\s+(\\S+)/gm) {\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\tmy $evalue = abs($9); # consistency for tests under Windows\n\t\tpush(@{$table{$1}->{hsp_data}}, [$2, $3, $4, $5, $6, $8, $evalue]);\n\t\tif ($7 eq ']') {\n\t\t\t$table{$1}->{hit_length} = $6;\n\t\t}\n\t}\n\t$self->_fields->{hsp_table} = \\%table;\n}\n\nsub _discover_alignments {\n\tmy $self = shift;\n\t$self->_fields->{alignments} = { };\n}\n\nsub _next_alignment {\n\tmy $self = shift;;\n\treturn if $self->{_no_more_alignments};\n\t\n\tmy $aligns = $self->_fields->{alignments};\n\t\n\tunless (defined $self->{_after_previous_alignment}) {\n\t\t$self->_chunk_seek($self->{_after_hsp_table});\n\t\tmy $chunk = $self->_get_chunk_by_end(\": domain\");\n\t\tunless ($chunk) {\n\t\t\t$self->{_no_more_alignments} = 1;\n\t\t\treturn;\n\t\t}\n\t\t\n\t\t$self->{_after_previous_alignment} = $self->_chunk_tell;\n\t\t$self->{_next_alignment_start_text} = $chunk;\n\t\treturn $self->_next_alignment;\n\t}\n\t\n\t$self->_chunk_seek($self->{_after_previous_alignment});\n\tmy $chunk = $self->_get_chunk_by_end(\": domain\");\n\tunless ($chunk) {\n\t\t$self->_chunk_seek($self->{_after_previous_alignment});\n\t\t$chunk = $self->_get_chunk_by_end(\"//\");\n\t\t\n\t\tunless ($chunk) {\n\t\t\t$self->{_no_more_alignments} = 1;\n\t\t\treturn;\n\t\t}\n\t}\n\t\n\t$self->{_after_previous_alignment} = $self->_chunk_tell;\n\t\n\tif (defined $self->{_next_alignment_start_text}) {\n\t\t$chunk = $self->{_next_alignment_start_text}.$chunk;\n\t}\n\t\n\t$chunk =~ s/(\\S+: domain)$//;\n\t$self->{_next_alignment_start_text} = $1;\n\t\n\tmy ($name, $domain) = $chunk =~ /^(\\S+): domain (\\d+)/;\n\t$aligns->{$name.'~~~~'.$domain} = $chunk;\n\treturn 1;\n}\n\nsub _discover_next_hit {\n\tmy $self = shift;\n\tmy @hit_table = @{$self->get_field('hit_table')};\n\treturn if $self->{_next_hit_index} == -1;\n\t\n\t#[name description score significance num_hsps rank]\n\tmy @hit_data = (@{$hit_table[$self->{_next_hit_index}++]}, $self->{_next_hit_index});\n\t\n\t$self->_fields->{next_hit} = Bio::Search::Hit::HmmpfamHit->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hit_data => \\@hit_data);\n\t\n\tif ($self->{_next_hit_index} > $#hit_table) {\n\t\t$self->{_next_hit_index} = -1;\n\t}\n}\n\n=head2 next_hit\n\n Title   : next_hit\n Usage   : while( $hit = $result->next_hit()) { ... }\n Function: Returns the next available Hit object, representing potential\n           matches between the query and various entities from the database.\n Returns : a Bio::Search::Hit::HitI object or undef if there are no more.\n Args    : none\n\n\nsub next_hit {\n\tmy $self = shift;\n    my $hit = $self->get_field('next_hit');\n\tundef $self->_fields->{next_hit};\n\treturn $hit;\n}\n\n=head2 next_model\n\n Title   : next_model\n Usage   : my $domain = $result->next_model\n Function: Returns the next domain - this is an alias for next_hit()\n Returns : L<Bio::Search::Hit::HitI> object\n Args    : none\n\n\n*next_model = \\&next_hit;\n\n=head2 hits\n\n Title   : hits\n Usage   : my @hits = $result->hits\n Function: Returns the HitI objects contained within this Result\n Returns : Array of Bio::Search::Hit::HitI objects\n Args    : none\n\nSee Also: L<Bio::Search::Hit::HitI>\n\n\nsub hits {\n\tmy $self = shift;\n\tmy $old = $self->{_next_hit_index} || 0;\n\t$self->rewind;\n\tmy @hits;\n\twhile (defined(my $hit = $self->next_hit)) {\n\t\tpush(@hits, $hit);\n\t}\n\t$self->{_next_hit_index} = @hits > 0 ? $old : -1;\n\treturn @hits;\n}\n\n=head2 models\n\n Title   : models\n Usage   : my @domains = $result->models;\n Function: Returns the list of HMM models seen - this is an alias for hits()\n Returns : Array of L<Bio::Search::Hit::HitI> objects\n Args    : none\n\n\n*models = \\&hits;\n\n=head2 sort_hits\n\n Title\t\t: sort_hits\n Usage\t\t: $result->sort_hits('<score')\n Function\t: Sorts the hits so that they come out in the desired order when\n              hits() or next_hit() is called.\n Returns\t: n/a\n Args\t\t: A coderef for the sort function. See the documentation on the Perl\n              sort() function for guidelines on writing sort functions.\n\t\t\t  You will be sorting array references, not HitI objects. The\n\t\t\t  references contain name as element 0, description as element 1,\n\t\t\t  score as element 2, significance as element 3 and number of hsps\n\t\t\t  as element 4.\n\t\t\t  By default the sort order is ascending significance value (ie.\n\t\t\t  most significant hits first).\n Note\t\t: To access the special variables $a and $b used by the Perl sort()\n              function the user function must access\n\t\t\t  Bio::Search::Result::HmmpfamResult namespace. \n              For example, use : \n              $result->sort_hits(\n\t\t\t\tsub{$Bio::Search::Result::HmmpfamResult::a->[2]\n\t\t\t\t                         <=> \n\t\t\t\t\t$Bio::Search::Result::HmmpfamResult::b->[2]});\n              NOT $result->sort_hits($a->[2] <=> $b->[2]);","parameters":[{"label":"$self"},{"label":"$code_ref"}]},"containerName":"main::","definition":"sub","line":360,"children":[{"localvar":"my","containerName":"sort_hits","name":"$self","definition":"my","line":361,"kind":13},{"name":"$code_ref","containerName":"sort_hits","line":361,"kind":13},{"line":362,"kind":13,"containerName":"sort_hits","name":"$code_ref"},{"kind":13,"line":362,"name":"$a","containerName":"sort_hits"},{"kind":13,"line":362,"containerName":"sort_hits","name":"$b"},{"containerName":"sort_hits","definition":"my","name":"$table_ref","localvar":"my","kind":13,"line":366},{"containerName":"sort_hits","name":"$self","kind":13,"line":366},{"line":366,"kind":12,"name":"get_field","containerName":"sort_hits"},{"kind":13,"line":367,"name":"$table_ref","containerName":"sort_hits"}],"kind":12},{"line":369,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@sorted"},{"kind":13,"line":369,"name":"$code_ref","containerName":null},{"line":369,"kind":13,"name":"$table_ref","containerName":null},{"kind":13,"line":370,"containerName":null,"name":"@sorted"},{"line":370,"kind":13,"containerName":null,"name":"$table_ref"},{"name":"$self","containerName":null,"kind":13,"line":370},{"name":"throw","containerName":"main::","line":370,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":371},{"kind":12,"line":371,"containerName":"main::","name":"_fields"},{"name":"hit_table","line":371,"kind":12},{"name":"@sorted","containerName":null,"line":371,"kind":13},{"kind":12,"line":385,"children":[{"containerName":"rewind","definition":"my","name":"$self","localvar":"my","kind":13,"line":386},{"name":"$self","containerName":"rewind","line":387,"kind":13},{"kind":12,"line":387,"name":"_fields","containerName":"rewind"},{"containerName":"rewind","name":"$self","line":388,"kind":13},{"containerName":"rewind","name":"get_field","line":388,"kind":12},{"containerName":"rewind","name":"$self","kind":13,"line":390},{"kind":13,"line":390,"name":"$self","containerName":"rewind"},{"kind":12,"line":390,"containerName":"rewind","name":"_fields"}],"containerName":"main::","name":"rewind","definition":"sub","range":{"start":{"line":385,"character":0},"end":{"line":390,"character":9999}}},{"name":"hit_table","line":387,"kind":12},{"name":"_next_hit_index","line":390,"kind":12},{"kind":12,"line":390,"name":"hit_table"}],"version":5}