{"vars":[{"line":96,"kind":2,"containerName":"","name":"base"},{"children":[{"kind":13,"line":325,"name":"$self","definition":"my","containerName":"overlap","localvar":"my"},{"line":326,"kind":13,"containerName":"overlap","name":"$self"},{"name":"$self","containerName":"overlap","kind":13,"line":327},{"name":"$self","containerName":"overlap","kind":13,"line":327}],"line":324,"kind":12,"range":{"start":{"line":324,"character":0},"end":{"character":9999,"line":328}},"name":"overlap","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"n","definition":"sub","range":{"start":{"line":352,"character":0},"end":{"character":9999,"line":370}},"kind":12,"line":352,"children":[{"containerName":"n","definition":"my","name":"$self","localvar":"my","kind":13,"line":353},{"containerName":"n","name":"$n","definition":"my","localvar":"my","kind":13,"line":359},{"name":"$self","containerName":"n","line":360,"kind":13},{"line":361,"kind":13,"name":"$self","containerName":"n"},{"kind":12,"line":361,"name":"hsp","containerName":"n"},{"line":362,"kind":13,"containerName":"n","name":"$n"},{"containerName":"n","name":"$self","line":362,"kind":13},{"containerName":"n","name":"hsp","line":362,"kind":12},{"line":362,"kind":12,"name":"n","containerName":"n"},{"kind":13,"line":365,"name":"$n","containerName":"n"},{"name":"$self","containerName":"n","kind":13,"line":365},{"name":"$n","containerName":"n","line":367,"kind":13},{"line":367,"kind":13,"containerName":"n","name":"$self"},{"containerName":"n","name":"num_hsps","line":367,"kind":12},{"name":"$n","containerName":"n","line":369,"kind":13}]},{"signature":{"label":"hsp($self,$option)","parameters":[{"label":"$self"},{"label":"$option"}],"documentation":"1;\n# $Id: ModelHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::ModelHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::ModelHit - A model-based implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::ModelHit;\n    my $hit = Bio::Search::Hit::ModelHit->new(-algorithm => 'rnamotif');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'infernal', -file => 'trap.inf');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database search using models or\ndescriptors instead of sequences, such as Infernal, HMMER, RNAMotif, etc.\n\nUnless you're writing a parser, you won't ever need to create a ModelHit or\nany other HitI-implementing object. If you use the SearchIO system, HitI objects\nare created automatically from a SearchIO stream which returns\nBio::Search::Hit::HitI objects.\n\nNote that several HitI-based methods have been overridden from ModelHit due to\ntheir unreliability when dealing with queries that aren't sequence-based. It may\nbe possible to reimplement these at a later point, but for the time being they\nwill throw warnings and return w/o results.\n\nFor documentation on what you can do with ModelHit (and other HitI objects),\nplease see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::ModelHit;\n\nuse strict;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head1 HitI methods implemented in parent class Bio::Search::Hit::ModelHit\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::ModelHit->new();\n Function: Builds a new Bio::Search::Hit::ModelHit object \n Returns : Bio::Search::Hit::ModelHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP \n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()"},"detail":"($self,$option)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"hsp","localvar":"my","kind":13,"line":418},{"name":"$option","containerName":"hsp","line":418,"kind":13},{"line":419,"kind":13,"containerName":"hsp","name":"$option"},{"name":"$self","containerName":"hsp","line":421,"kind":13},{"line":422,"kind":13,"name":"$self","containerName":"hsp"},{"containerName":"hsp","name":"throw","kind":12,"line":422},{"containerName":"hsp","definition":"my","name":"@hsps","localvar":"my","kind":13,"line":425},{"kind":13,"line":425,"name":"$self","containerName":"hsp"},{"line":425,"kind":12,"containerName":"hsp","name":"hsps"},{"name":"$hsps","containerName":"hsp","line":427,"kind":13},{"line":427,"kind":13,"name":"$option","containerName":"hsp"},{"containerName":"hsp","name":"$hsps","kind":13,"line":428},{"kind":13,"line":428,"containerName":"hsp","name":"$option"},{"containerName":"hsp","name":"$self","line":430,"kind":13},{"kind":12,"line":430,"name":"throw","containerName":"hsp"}],"line":417,"kind":12,"range":{"start":{"character":0,"line":417},"end":{"character":9999,"line":432}},"name":"hsp"},{"line":428,"kind":12,"name":"hsps"},{"kind":12,"children":[{"containerName":"rank","definition":"my","name":"$self","localvar":"my","kind":13,"line":447},{"name":"$self","containerName":"rank","line":448,"kind":13},{"containerName":"rank","name":"$self","line":449,"kind":13}],"line":446,"name":"rank","definition":"sub","containerName":"main::","range":{"start":{"line":446,"character":0},"end":{"character":9999,"line":450}}},{"line":462,"children":[{"kind":13,"line":463,"containerName":"locus","name":"$self","definition":"my","localvar":"my"},{"containerName":"locus","name":"$value","kind":13,"line":463},{"kind":13,"line":464,"name":"$previous","definition":"my","containerName":"locus","localvar":"my"},{"name":"$self","containerName":"locus","line":464,"kind":13},{"name":"$value","containerName":"locus","kind":13,"line":465},{"kind":13,"line":465,"name":"$previous","containerName":"locus"},{"kind":13,"line":466,"name":"$value","containerName":"locus"},{"containerName":"locus","name":"$self","kind":13,"line":467},{"kind":13,"line":468,"name":"$value","containerName":"locus"},{"line":468,"kind":13,"containerName":"locus","name":"$previous"},{"containerName":"locus","name":"$value","line":470,"kind":13},{"line":470,"kind":13,"name":"$previous","containerName":"locus"},{"line":473,"kind":13,"containerName":"locus","name":"$self"},{"line":473,"kind":13,"containerName":"locus","name":"$value"},{"kind":13,"line":475,"name":"$previous","containerName":"locus"}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: ModelHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::ModelHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::ModelHit - A model-based implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::ModelHit;\n    my $hit = Bio::Search::Hit::ModelHit->new(-algorithm => 'rnamotif');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'infernal', -file => 'trap.inf');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database search using models or\ndescriptors instead of sequences, such as Infernal, HMMER, RNAMotif, etc.\n\nUnless you're writing a parser, you won't ever need to create a ModelHit or\nany other HitI-implementing object. If you use the SearchIO system, HitI objects\nare created automatically from a SearchIO stream which returns\nBio::Search::Hit::HitI objects.\n\nNote that several HitI-based methods have been overridden from ModelHit due to\ntheir unreliability when dealing with queries that aren't sequence-based. It may\nbe possible to reimplement these at a later point, but for the time being they\nwill throw warnings and return w/o results.\n\nFor documentation on what you can do with ModelHit (and other HitI objects),\nplease see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::ModelHit;\n\nuse strict;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head1 HitI methods implemented in parent class Bio::Search::Hit::ModelHit\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::ModelHit->new();\n Function: Builds a new Bio::Search::Hit::ModelHit object \n Returns : Bio::Search::Hit::ModelHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP \n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"locus($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":476},"start":{"character":0,"line":462}},"name":"locus"},{"line":490,"children":[{"kind":13,"line":491,"containerName":"each_accession_number","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"each_accession_number","kind":13,"line":491},{"containerName":"each_accession_number","name":"$desc","definition":"my","localvar":"my","kind":13,"line":492},{"line":492,"kind":13,"containerName":"each_accession_number","name":"$self"},{"kind":13,"line":494,"name":"@accnums","definition":"my","containerName":"each_accession_number","localvar":"my"},{"kind":13,"line":495,"name":"@accnums","containerName":"each_accession_number"},{"line":495,"kind":13,"name":"$self","containerName":"each_accession_number"},{"kind":13,"line":496,"containerName":"each_accession_number","name":"$desc"},{"kind":13,"line":497,"containerName":"each_accession_number","name":"$desc"},{"kind":13,"line":498,"name":"$id","definition":"my","containerName":"each_accession_number","localvar":"my"},{"kind":13,"line":499,"containerName":"each_accession_number","definition":"my","name":"$acc","localvar":"my"},{"line":499,"kind":13,"name":"$version","containerName":"each_accession_number"},{"kind":13,"line":500,"containerName":"each_accession_number","name":"$id"},{"kind":13,"line":501,"name":"$acc","containerName":"each_accession_number"},{"line":501,"kind":13,"containerName":"each_accession_number","name":"$version"},{"line":502,"kind":13,"name":"$id","containerName":"each_accession_number"},{"kind":13,"line":503,"name":"$acc","containerName":"each_accession_number"},{"kind":13,"line":503,"name":"$version","containerName":"each_accession_number"},{"name":"$id","containerName":"each_accession_number","line":504,"kind":13},{"line":505,"kind":13,"containerName":"each_accession_number","name":"$acc"},{"line":505,"kind":13,"name":"$id","containerName":"each_accession_number"},{"name":"$id","containerName":"each_accession_number","kind":13,"line":506},{"line":507,"kind":13,"name":"$acc","containerName":"each_accession_number"},{"kind":13,"line":507,"containerName":"each_accession_number","name":"$version"},{"kind":13,"line":524,"containerName":"each_accession_number","name":"$acc"},{"containerName":"each_accession_number","name":"$id","line":524,"kind":13},{"containerName":"each_accession_number","name":"@accnums","kind":13,"line":526},{"containerName":"each_accession_number","name":"$acc","kind":13,"line":526},{"containerName":"each_accession_number","name":"@accnums","kind":13,"line":529}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: ModelHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::ModelHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::ModelHit - A model-based implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::ModelHit;\n    my $hit = Bio::Search::Hit::ModelHit->new(-algorithm => 'rnamotif');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'infernal', -file => 'trap.inf');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database search using models or\ndescriptors instead of sequences, such as Infernal, HMMER, RNAMotif, etc.\n\nUnless you're writing a parser, you won't ever need to create a ModelHit or\nany other HitI-implementing object. If you use the SearchIO system, HitI objects\nare created automatically from a SearchIO stream which returns\nBio::Search::Hit::HitI objects.\n\nNote that several HitI-based methods have been overridden from ModelHit due to\ntheir unreliability when dealing with queries that aren't sequence-based. It may\nbe possible to reimplement these at a later point, but for the time being they\nwill throw warnings and return w/o results.\n\nFor documentation on what you can do with ModelHit (and other HitI objects),\nplease see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::ModelHit;\n\nuse strict;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head1 HitI methods implemented in parent class Bio::Search::Hit::ModelHit\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::ModelHit->new();\n Function: Builds a new Bio::Search::Hit::ModelHit object \n Returns : Bio::Search::Hit::ModelHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP \n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"each_accession_number($self,$value)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":530},"start":{"character":0,"line":490}},"name":"each_accession_number"},{"definition":"sub","name":"query_length","containerName":"main::","range":{"start":{"character":0,"line":549},"end":{"character":9999,"line":554}},"kind":12,"children":[{"kind":13,"line":550,"definition":"my","name":"$self","containerName":"query_length","localvar":"my"},{"name":"$self","containerName":"query_length","line":552,"kind":13},{"line":553,"kind":13,"name":"$self","containerName":"query_length"}],"line":549},{"range":{"end":{"line":575,"character":9999},"start":{"line":567,"character":0}},"name":"ncbi_gi","line":567,"children":[{"localvar":"my","containerName":"ncbi_gi","name":"$self","definition":"my","line":568,"kind":13},{"name":"$value","containerName":"ncbi_gi","line":568,"kind":13},{"kind":13,"line":569,"containerName":"ncbi_gi","definition":"my","name":"$previous","localvar":"my"},{"name":"$self","containerName":"ncbi_gi","kind":13,"line":569},{"name":"$value","containerName":"ncbi_gi","line":570,"kind":13},{"line":570,"kind":13,"containerName":"ncbi_gi","name":"$previous"},{"name":"$value","containerName":"ncbi_gi","line":571,"kind":13},{"name":"$previous","containerName":"ncbi_gi","line":571,"kind":13},{"kind":13,"line":571,"containerName":"ncbi_gi","name":"$value"},{"kind":13,"line":572,"containerName":"ncbi_gi","name":"$self"},{"name":"$value","containerName":"ncbi_gi","kind":13,"line":572},{"containerName":"ncbi_gi","name":"$previous","kind":13,"line":574}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ModelHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::ModelHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields <cjfields at bioperl dot org>\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::ModelHit - A model-based implementation of the Bio::Search::Hit::HitI interface\n\n=head1 SYNOPSIS\n\n    use Bio::Search::Hit::ModelHit;\n    my $hit = Bio::Search::Hit::ModelHit->new(-algorithm => 'rnamotif');\n\n    # typically one gets HitI objects from a SearchIO stream via a ResultI\n    use Bio::SearchIO;\n    my $parser = Bio::SearchIO->new(-format => 'infernal', -file => 'trap.inf');\n\n    my $result = $parser->next_result;\n    my $hit    = $result->next_hit;\n\n=head1 DESCRIPTION\n\nThis object handles the hit data from a database search using models or\ndescriptors instead of sequences, such as Infernal, HMMER, RNAMotif, etc.\n\nUnless you're writing a parser, you won't ever need to create a ModelHit or\nany other HitI-implementing object. If you use the SearchIO system, HitI objects\nare created automatically from a SearchIO stream which returns\nBio::Search::Hit::HitI objects.\n\nNote that several HitI-based methods have been overridden from ModelHit due to\ntheir unreliability when dealing with queries that aren't sequence-based. It may\nbe possible to reimplement these at a later point, but for the time being they\nwill throw warnings and return w/o results.\n\nFor documentation on what you can do with ModelHit (and other HitI objects),\nplease see the API documentation in\nL<Bio::Search::Hit::HitI|Bio::Search::Hit::HitI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::ModelHit;\n\nuse strict;\n\nuse base qw(Bio::Search::Hit::GenericHit);\n\n=head1 HitI methods implemented in parent class Bio::Search::Hit::ModelHit\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::ModelHit->new();\n Function: Builds a new Bio::Search::Hit::ModelHit object \n Returns : Bio::Search::Hit::ModelHit\n Args    : -name         => Name of Hit (required)\n           -description  => Description (optional)\n           -accession    => Accession number (optional)\n           -ncbi_gi      => NCBI GI UID (optional)\n           -length       => Length of the Hit (optional)\n           -score        => Raw Score for the Hit (optional)\n           -bits         => Bit Score for the Hit (optional)\n           -significance => Significance value for the Hit (optional)\n           -algorithm    => Algorithm used (BLASTP, FASTX, etc...)\n           -hsps         => Array ref of HSPs for this Hit. \n           -found_again  => boolean, true if hit appears in a \n                            \"previously found\" section of a PSI-Blast report.\n           -hsp_factory  => Bio::Factory::ObjectFactoryI able to create HSPI\n                            objects.\n\n\n=head2 add_hsp\n\n Title   : add_hsp\n Usage   : $hit->add_hsp($hsp)\n Function: Add a HSP to the collection of HSPs for a Hit\n Returns : number of HSPs in the Hit\n Args    : Bio::Search::HSP::HSPI object, OR hash ref containing data suitable\n           for creating a HSPI object (&hsp_factory must be set to get it back)\n\n\n=head2 hsp_factory\n\n Title   : hsp_factory\n Usage   : $hit->hsp_factory($hsp_factory)\n Function: Get/set the factory used to build HSPI objects if necessary.\n Returns : Bio::Factory::ObjectFactoryI\n Args    : Bio::Factory::ObjectFactoryI\n\n\n=head2 Bio::Search::Hit::HitI methods\n\nImplementation of Bio::Search::Hit::HitI methods\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : [optional] scalar string to set the name\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : [optional] scalar string to set the descrition\n\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : [optional] integer to set the length\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : [optional] scalar string to set the algorithm\n\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : [optional] scalar value to set the raw score\n\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : [optional] scalar value to set the significance\n\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or undef if bit score is not set\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : Bio::Search::HSP::HSPI object or null if finished\n Args     : none\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of Bio::Search::HSP::BlastHSP.pm objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer or '-' if HSPs have not been callected\n Argument  : n/a\n\nSee Also   : L<hsps()|hsps>\n\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           Since this is an in-memory implementation\n Returns : none\n Args    : none\n\n\n=head2 ambiguous_aln\n\n Usage     : $ambig_code = $hit_object->ambiguous_aln();\n Purpose   : Sets/Gets ambiguity code data member.\n Example   : (see usage)\n Returns   : String = 'q', 's', 'qs', '-'\n           :   'q'  = query sequence contains overlapping sub-sequences \n           :          while sbjct does not.\n           :   's'  = sbjct sequence contains overlapping sub-sequences \n           :          while query does not.\n           :   'qs' = query and sbjct sequence contains overlapping sub-sequences\n           :          relative to each other.\n           :   '-'  = query and sbjct sequence do not contains multiple domains \n           :          relative to each other OR both contain the same distribution\n           :          of similar domains.\n Argument  : n/a\n Throws    : n/a\n Comment   : Note: \"sbjct\" is synonymous with \"hit\"\n\n\n=head2 overlap\n\nSee documentation in L<Bio::Search::Hit::HitI::overlap()|Bio::Search::Hit::HitI>\n\n\nsub overlap {\n    my $self = shift; \n    if(@_) { $self->{'_overlap'} = shift; }\n    defined $self->{'_overlap'} ? $self->{'_overlap'} : 0;\n}\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set.\n Comments  : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\nsub n {\n    my $self = shift; \n\n    # The check for $self->{'_n'} is a remnant from the 'query' mode days\n    # in which the sbjct object would collect data from the description \n    # line only.\n\n    my ($n);\n    if(not defined($self->{'_n'})) {\n\tif( $self->hsp ) {\n\t    $n = $self->hsp->n;\n\t}\n    } else {\n        $n = $self->{'_n'}; \n    } \n    $n ||= $self->num_hsps;\n\n    return $n;\n}\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP \n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::SearchUtils::get_exponent()|Bio::Search::SearchUtils>\n\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a Bio::Search::HSP::BlastHSP.pm object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my( $self, $option ) = @_;\n    $option ||= 'best';\n    \n    if (not ref $self->{'_hsps'}) {\n        $self->throw(\"Can't get HSPs: data not collected.\");\n    }\n\n    my @hsps = $self->hsps;\n    \n    return $hsps[0]      if $option =~ /best|first|1/i;\n    return $hsps[$#hsps] if $option =~ /worst|last/i;\n\n    $self->throw(\"Can't get HSP for: $option\\n\" .\n                 \"Valid arguments: 'best', 'worst'\");\n}\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank {\n    my $self = shift;\n    return $self->{'_rank'} = shift if @_;\n    return $self->{'_rank'} || 1;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $locus = $hit->locus();\n Function: Retrieve the locus (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,$value) = @_;\n    my $previous = $self->{'_locus'};\n    if( defined $value || ! defined $previous ) { \n      unless (defined $value) {\n        if ($self->{'_name'} =~/(gb|emb|dbj|ref)\\|(.*)\\|(.*)/) {\n                  $value = $previous = $3;\n                } else {\n          $value = $previous = '';\n        }\n      }\n          $self->{'_locus'} = $value;\n    } \n        return $previous;\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : @each_accession_number = $hit->each_accession_number();\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none\n\n\nsub each_accession_number {\n    my ($self,$value) = @_;\n    my $desc = $self->{'_description'};\n    #put primary accnum on the list\n    my @accnums;\n    push (@accnums,$self->{'_accession'});\n    if( defined $desc )  { \n      while ($desc =~ /(\\b\\S+\\|\\S*\\|\\S*\\s?)/g) {\n        my $id = $1;\n        my ($acc, $version);\n\tif ($id =~ /(gb|emb|dbj|sp|pdb|bbs|ref|tp[gde])\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $2; \n\t} elsif ($id =~ /(pir|prf|pat|gnl)\\|(.*)\\|(.*)/) {\n\t    ($acc, $version) = split /\\./, $3;  \n\t} elsif( $id =~ /(gim|gi|bbm|bbs|lcl)\\|(\\d*)/) {\n\t    $acc = $id;\n\t} elsif( $id =~ /(oth)\\|(.*)\\|(.*)\\|(.*)/ ) { # discontinued...\n\t    ($acc,$version) = ($2);\n\t} else {\n                     #punt, not matching the db's at ftp://ftp.ncbi.nih.gov/blast/db/README\n                     #Database Name                     Identifier Syntax\n          #============================      ========================\n          #GenBank                           gb|accession|locus\n          #EMBL Data Library                 emb|accession|locus\n          #DDBJ, DNA Database of Japan       dbj|accession|locus\n          #NBRF PIR                          pir||entry\n          #Protein Research Foundation       prf||name\n          #SWISS-PROT                        sp|accession|entry name\n          #Brookhaven Protein Data Bank      pdb|entry|chain\n          #Patents                           pat|country|number \n          #GenInfo Backbone Id               bbs|number \n          #General database identifier           gnl|database|identifier\n          #NCBI Reference Sequence           ref|accession|locus\n          #Local Sequence identifier         lcl|identifier\n              $acc=$id;\n            }\n            push(@accnums, $acc);\n          }\n    }  \n    return @accnums;\n}\n\n=head2 tiled_hsps\n\nSee documentation in L<Bio::Search::SearchUtils::tile_hsps()|Bio::Search::SearchUtils>\n\n\n=head2 query_length\n\n Title   : query_length\n Usage   : $obj->query_length($newval)\n Function: Get/Set the query_length\n Returns : value of query_length (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub query_length {\n    my $self = shift;\n\n    return $self->{'_query_length'} = shift if @_;\n    return $self->{'_query_length'};\n}\n\n=head2 ncbi_gi\n\n Title   : ncbi_gi\n Usage   : $acc = $hit->ncbi_gi();\n Function: Retrieve the NCBI Unique ID (aka the GI #),\n           if available, for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"ncbi_gi($self,$value)"},"containerName":"main::","definition":"sub"},{"children":[{"kind":13,"line":587,"name":"$self","definition":"my","containerName":"length_aln","localvar":"my"},{"line":588,"kind":13,"name":"$self","containerName":"length_aln"},{"name":"warn","containerName":"length_aln","kind":12,"line":588}],"line":586,"kind":12,"range":{"end":{"character":9999,"line":590},"start":{"line":586,"character":0}},"definition":"sub","name":"length_aln","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"gaps","range":{"start":{"line":596,"character":0},"end":{"line":600,"character":9999}},"kind":12,"line":596,"children":[{"kind":13,"line":597,"containerName":"gaps","definition":"my","name":"$self","localvar":"my"},{"line":598,"kind":13,"name":"$self","containerName":"gaps"},{"containerName":"gaps","name":"warn","line":598,"kind":12}]},{"containerName":"main::","name":"matches","definition":"sub","range":{"end":{"line":610,"character":9999},"start":{"character":0,"line":606}},"kind":12,"line":606,"children":[{"line":607,"kind":13,"localvar":"my","containerName":"matches","definition":"my","name":"$self"},{"name":"$self","containerName":"matches","kind":13,"line":608},{"name":"warn","containerName":"matches","kind":12,"line":608}]},{"containerName":"main::","definition":"sub","name":"start","range":{"start":{"character":0,"line":616},"end":{"character":9999,"line":620}},"kind":12,"line":616,"children":[{"kind":13,"line":617,"definition":"my","name":"$self","containerName":"start","localvar":"my"},{"name":"$self","containerName":"start","kind":13,"line":618},{"containerName":"start","name":"warn","line":618,"kind":12}]},{"kind":12,"children":[{"line":628,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"end"},{"line":629,"kind":13,"name":"$self","containerName":"end"},{"kind":12,"line":629,"name":"warn","containerName":"end"}],"line":627,"definition":"sub","name":"end","containerName":"main::","range":{"start":{"character":0,"line":627},"end":{"character":9999,"line":631}}},{"containerName":"main::","name":"range","definition":"sub","range":{"start":{"line":637,"character":0},"end":{"line":641,"character":9999}},"kind":12,"line":637,"children":[{"line":638,"kind":13,"localvar":"my","containerName":"range","name":"$self","definition":"my"},{"kind":13,"line":639,"containerName":"range","name":"$self"},{"containerName":"range","name":"warn","kind":12,"line":639}]},{"line":647,"children":[{"line":648,"kind":13,"localvar":"my","containerName":"frac_identical","definition":"my","name":"$self"},{"kind":13,"line":649,"name":"$self","containerName":"frac_identical"},{"kind":12,"line":649,"name":"warn","containerName":"frac_identical"}],"kind":12,"range":{"start":{"character":0,"line":647},"end":{"line":651,"character":9999}},"containerName":"main::","definition":"sub","name":"frac_identical"},{"range":{"end":{"character":9999,"line":661},"start":{"character":0,"line":657}},"containerName":"main::","name":"frac_conserved","definition":"sub","line":657,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"frac_conserved","line":658,"kind":13},{"containerName":"frac_conserved","name":"$self","line":659,"kind":13},{"kind":12,"line":659,"name":"warn","containerName":"frac_conserved"}],"kind":12},{"range":{"end":{"line":671,"character":9999},"start":{"character":0,"line":667}},"containerName":"main::","name":"frac_aligned_query","definition":"sub","line":667,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"frac_aligned_query","line":668,"kind":13},{"name":"$self","containerName":"frac_aligned_query","line":669,"kind":13},{"kind":12,"line":669,"name":"warn","containerName":"frac_aligned_query"}],"kind":12},{"range":{"start":{"line":677,"character":0},"end":{"line":681,"character":9999}},"containerName":"main::","name":"frac_aligned_hit","definition":"sub","line":677,"children":[{"kind":13,"line":678,"containerName":"frac_aligned_hit","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":679,"name":"$self","containerName":"frac_aligned_hit"},{"name":"warn","containerName":"frac_aligned_hit","kind":12,"line":679}],"kind":12},{"name":"num_unaligned_hit","kind":12,"line":687},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"num_unaligned_hit","line":690,"kind":13},{"name":"$self","containerName":"num_unaligned_hit","line":691,"kind":13},{"line":691,"kind":12,"name":"warn","containerName":"num_unaligned_hit"}],"line":689,"kind":12,"range":{"start":{"character":0,"line":689},"end":{"line":693,"character":9999}},"definition":"sub","name":"num_unaligned_hit","containerName":"main::"},{"range":{"start":{"character":0,"line":699},"end":{"character":9999,"line":703}},"containerName":"main::","name":"num_unaligned_query","definition":"sub","line":699,"children":[{"kind":13,"line":700,"containerName":"num_unaligned_query","definition":"my","name":"$self","localvar":"my"},{"line":701,"kind":13,"containerName":"num_unaligned_query","name":"$self"},{"containerName":"num_unaligned_query","name":"warn","kind":12,"line":701}],"kind":12},{"children":[{"name":"$self","definition":"my","containerName":"seq_inds","localvar":"my","kind":13,"line":710},{"kind":13,"line":711,"containerName":"seq_inds","name":"$self"},{"kind":12,"line":711,"containerName":"seq_inds","name":"warn"}],"line":709,"kind":12,"range":{"end":{"character":9999,"line":713},"start":{"character":0,"line":709}},"name":"seq_inds","definition":"sub","containerName":"main::"},{"range":{"start":{"line":719,"character":0},"end":{"character":9999,"line":723}},"containerName":"main::","definition":"sub","name":"strand","line":719,"children":[{"line":720,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"strand"},{"line":721,"kind":13,"name":"$self","containerName":"strand"},{"line":721,"kind":12,"containerName":"strand","name":"warn"}],"kind":12},{"kind":12,"line":729,"children":[{"localvar":"my","containerName":"frame","name":"$self","definition":"my","line":730,"kind":13},{"containerName":"frame","name":"$self","kind":13,"line":731},{"kind":12,"line":731,"containerName":"frame","name":"warn"}],"containerName":"main::","definition":"sub","name":"frame","range":{"start":{"line":729,"character":0},"end":{"line":733,"character":9999}}},{"children":[{"containerName":"logical_length","name":"$self","definition":"my","localvar":"my","kind":13,"line":740},{"name":"$self","containerName":"logical_length","line":741,"kind":13},{"name":"warn","containerName":"logical_length","line":741,"kind":12}],"line":739,"kind":12,"range":{"start":{"character":0,"line":739},"end":{"character":9999,"line":743}},"name":"logical_length","definition":"sub","containerName":"main::"}],"version":5}