{"vars":[{"kind":2,"line":115,"name":"base","containerName":""},{"name":"name","range":{"start":{"character":0,"line":130},"end":{"character":9999,"line":133}},"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.","label":"name($self,@args)"},"kind":12,"line":130,"children":[{"line":131,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"name"},{"containerName":"name","name":"@args","line":131,"kind":13},{"containerName":"name","name":"$self","kind":13,"line":132},{"line":132,"kind":12,"name":"throw_not_implemented","containerName":"name"}]},{"range":{"start":{"character":0,"line":145},"end":{"line":148,"character":9999}},"name":"description","line":145,"children":[{"localvar":"my","containerName":"description","name":"$self","definition":"my","line":146,"kind":13},{"name":"@args","containerName":"description","kind":13,"line":146},{"name":"$self","containerName":"description","line":147,"kind":13},{"containerName":"description","name":"throw_not_implemented","line":147,"kind":12}],"kind":12,"detail":"($self,@args)","signature":{"label":"description($self,@args)","documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub"},{"line":161,"children":[{"kind":13,"line":162,"definition":"my","name":"$self","containerName":"accession","localvar":"my"},{"kind":13,"line":162,"containerName":"accession","name":"@args"},{"kind":13,"line":163,"name":"$self","containerName":"accession"},{"containerName":"accession","name":"throw_not_implemented","line":163,"kind":12}],"kind":12,"detail":"($self,@args)","signature":{"label":"accession($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none"},"containerName":"main::","definition":"sub","range":{"end":{"line":164,"character":9999},"start":{"character":0,"line":161}},"name":"accession"},{"kind":12,"line":176,"children":[{"line":177,"kind":13,"localvar":"my","containerName":"locus","name":"$self","definition":"my"},{"containerName":"locus","name":"@args","line":177,"kind":13},{"line":178,"kind":13,"containerName":"locus","name":"$self"},{"containerName":"locus","name":"throw_not_implemented","kind":12,"line":178}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none","label":"locus($self,@args)"},"name":"locus","range":{"end":{"line":179,"character":9999},"start":{"line":176,"character":0}}},{"line":191,"children":[{"line":192,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"length"},{"containerName":"length","name":"@args","line":192,"kind":13},{"containerName":"length","name":"$self","kind":13,"line":193},{"line":193,"kind":12,"name":"throw_not_implemented","containerName":"length"}],"kind":12,"detail":"($self,@args)","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"length($self,@args)"},"containerName":"main::","definition":"sub","range":{"start":{"line":191,"character":0},"end":{"character":9999,"line":194}},"name":"length"},{"range":{"end":{"line":214,"character":9999},"start":{"character":0,"line":211}},"name":"algorithm","children":[{"localvar":"my","containerName":"algorithm","definition":"my","name":"$self","line":212,"kind":13},{"kind":13,"line":212,"containerName":"algorithm","name":"@args"},{"kind":13,"line":213,"containerName":"algorithm","name":"$self"},{"kind":12,"line":213,"containerName":"algorithm","name":"throw_not_implemented"}],"line":211,"kind":12,"signature":{"label":"algorithm($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"children":[{"line":229,"kind":12,"name":"throw_not_implemented","containerName":"raw_score"}],"line":228,"kind":12,"range":{"end":{"character":9999,"line":230},"start":{"line":228,"character":0}},"name":"raw_score","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"score","definition":"sub","range":{"end":{"line":238,"character":9999},"start":{"line":238,"character":0}},"kind":12,"line":238,"children":[{"kind":12,"line":238,"name":"raw_score","containerName":"score"}]},{"containerName":"main::","definition":"sub","name":"significance","range":{"start":{"character":0,"line":253},"end":{"character":9999,"line":255}},"kind":12,"line":253,"children":[{"kind":12,"line":254,"containerName":"significance","name":"throw_not_implemented"}]},{"definition":"sub","name":"bits","containerName":"main::","range":{"start":{"character":0,"line":271},"end":{"line":274,"character":9999}},"kind":12,"children":[{"name":"throw_not_implemented","containerName":"bits","line":273,"kind":12}],"line":271},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none","label":"next_hsp($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":288,"containerName":"next_hsp","definition":"my","name":"$self","localvar":"my"},{"name":"@args","containerName":"next_hsp","kind":13,"line":288},{"containerName":"next_hsp","name":"$self","line":289,"kind":13},{"containerName":"next_hsp","name":"throw_not_implemented","kind":12,"line":289}],"line":287,"name":"next_hsp","range":{"start":{"line":287,"character":0},"end":{"line":290,"character":9999}}},{"range":{"start":{"character":0,"line":311},"end":{"character":9999,"line":316}},"name":"hsps","definition":"sub","containerName":"main::","children":[{"line":313,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"hsps"},{"line":315,"kind":13,"name":"$self","containerName":"hsps"},{"kind":12,"line":315,"containerName":"hsps","name":"throw_not_implemented"}],"line":311,"kind":12},{"range":{"end":{"character":9999,"line":337},"start":{"character":0,"line":334}},"name":"num_hsps","definition":"sub","containerName":"main::","children":[{"name":"throw_not_implemented","containerName":"num_hsps","line":336,"kind":12}],"line":334,"kind":12},{"range":{"start":{"line":366,"character":0},"end":{"line":389,"character":9999}},"name":"seq_inds","signature":{"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"label":"seq_inds($self,$seqType,$class,$collapse)"},"detail":"($self,$seqType,$class,$collapse)","definition":"sub","containerName":"main::","children":[{"containerName":"seq_inds","definition":"my","name":"$self","localvar":"my","kind":13,"line":368},{"kind":13,"line":368,"name":"$seqType","containerName":"seq_inds"},{"name":"$class","containerName":"seq_inds","kind":13,"line":368},{"containerName":"seq_inds","name":"$collapse","kind":13,"line":368},{"line":370,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$class","line":371,"kind":13},{"name":"$collapse","containerName":"seq_inds","kind":13,"line":372},{"line":374,"kind":13,"name":"$seqType","containerName":"seq_inds"},{"kind":13,"line":374,"name":"$seqType","containerName":"seq_inds"},{"kind":13,"line":376,"name":"@inds","definition":"my","containerName":"seq_inds","localvar":"my"},{"line":376,"kind":13,"name":"$hsp","containerName":"seq_inds"},{"kind":13,"line":377,"name":"$hsp","containerName":"seq_inds"},{"line":377,"kind":13,"containerName":"seq_inds","name":"$self"},{"kind":12,"line":377,"name":"hsps","containerName":"seq_inds"},{"line":379,"kind":13,"name":"@inds","containerName":"seq_inds"},{"name":"$hsp","containerName":"seq_inds","line":379,"kind":13},{"kind":12,"line":379,"containerName":"seq_inds","name":"seq_inds"},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":379},{"containerName":"seq_inds","name":"$class","kind":13,"line":379},{"containerName":"seq_inds","name":"@inds","line":383,"kind":13},{"line":384,"kind":13,"localvar":"my","definition":"my","name":"%tmp","containerName":"seq_inds"},{"line":384,"kind":13,"name":"@inds","containerName":"seq_inds"},{"kind":13,"line":385,"name":"@inds","containerName":"seq_inds"},{"name":"$a","containerName":"seq_inds","kind":13,"line":385},{"name":"$b","containerName":"seq_inds","line":385,"kind":13},{"name":"%tmp","containerName":"seq_inds","kind":13,"line":385},{"kind":13,"line":388,"name":"$collapse","containerName":"seq_inds"},{"containerName":"seq_inds","name":"@inds","line":388,"kind":13},{"containerName":"seq_inds","name":"@inds","line":388,"kind":13}],"line":366,"kind":12},{"containerName":"Search::BlastUtils::collapse_nums","name":"Bio","line":388,"kind":12},{"range":{"end":{"character":9999,"line":405},"start":{"character":0,"line":402}},"name":"rewind","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none","label":"rewind($self)"},"containerName":"main::","definition":"sub","line":402,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"rewind","line":403,"kind":13},{"name":"$self","containerName":"rewind","kind":13,"line":404},{"kind":12,"line":404,"name":"throw_not_implemented","containerName":"rewind"}],"kind":12},{"kind":12,"line":427,"children":[{"line":427,"kind":12,"containerName":"overlap","name":"throw_not_implemented"}],"containerName":"main::","name":"overlap","definition":"sub","range":{"start":{"character":0,"line":427},"end":{"line":427,"character":9999}}},{"line":453,"children":[{"name":"throw_not_implemented","containerName":"n","line":453,"kind":12}],"kind":12,"range":{"end":{"line":453,"character":9999},"start":{"line":453,"character":0}},"containerName":"main::","name":"n","definition":"sub"},{"line":483,"children":[{"containerName":"p","name":"throw_not_implemented","line":483,"kind":12}],"kind":12,"range":{"end":{"line":483,"character":9999},"start":{"line":483,"character":0}},"containerName":"main::","definition":"sub","name":"p"},{"kind":12,"line":505,"children":[{"line":505,"kind":12,"name":"throw_not_implemented","containerName":"hsp"}],"containerName":"main::","name":"hsp","definition":"sub","range":{"end":{"line":505,"character":9999},"start":{"character":0,"line":505}}},{"kind":12,"children":[{"containerName":"logical_length","name":"throw_not_implemented","kind":12,"line":529}],"line":529,"name":"logical_length","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":529},"end":{"line":529,"character":9999}}},{"kind":12,"line":544,"children":[{"containerName":"rank","name":"$self","definition":"my","localvar":"my","kind":13,"line":545},{"kind":13,"line":545,"name":"$value","containerName":"rank"},{"line":546,"kind":13,"containerName":"rank","name":"$self"},{"line":546,"kind":12,"name":"throw_not_implemented","containerName":"rank"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"rank($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by L<Bio::Search::BlastUtils::_adjust_contigs()>.\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap { shift->throw_not_implemented }\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n { shift->throw_not_implemented }\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p { shift->throw_not_implemented() }\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp { shift->throw_not_implemented }\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length { shift->throw_not_implemented() }\n\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)"},"name":"rank","range":{"start":{"character":0,"line":544},"end":{"line":547,"character":9999}}},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n#-----------------------------------------------------------------\n# $Id: HitI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module Bio::Search::Hit::HitI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Steve Chervitz <sac@bioperl.org>\n#\n# Originally created by Aaron Mackey <amackey@virginia.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-----------------------------------------------------------------\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HitI - Interface for a hit in a similarity search result\n\n=head1 SYNOPSIS\n\n# Bio::Search::Hit::HitI objects should not be instantiated since this\n# module defines a pure interface.\n\n# Given an object that implements the Bio::Search::Hit::HitI  interface,\n# you can do the following things with it:\n\n    # Get a HitI object from a SearchIO stream:\n    use Bio::SeachIO;\n    my $searchio = Bio::SearchIO->new(-format => 'blast', -file => 'result.bls');\n    my $result = $searchio->next_result;\n    my $hit    = $result->next_hit;\n\n    $hit_name = $hit->name();\n\n    $desc = $hit->description();\n\n    $len = $hit->length\n\n    $alg = $hit->algorithm();\n\n    $score = $hit->raw_score();\n\n    $significance = $hit->significance();\n\n    $rank = $hit->rank(); # the Nth hit for a specific query\n\n    while( $hsp = $obj->next_hsp()) { ... } # process in iterator fashion\n\n    for my $hsp ( $obj->hsps()()) { ... } # process in list fashion\n\n=head1 DESCRIPTION\n\n    Bio::Search::Hit::* objects are data structures that contain information\nabout specific hits obtained during a library search.  Some information will\nbe algorithm-specific, but others will be generally defined.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Aaron Mackey, Steve Chervitz\n\nEmail amackey@virginia.edu  (original author)\nEmail sac@bioperl.org\n\n=head1 COPYRIGHT\n\nCopyright (c) 1999-2001 Aaron Mackey, Steve Chervitz. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HitI;\n\n\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n\n=head2 name\n\n Title   : name\n Usage   : $hit_name = $hit->name();\n Function: returns the name of the Hit sequence\n Returns : a scalar string\n Args    : none\n\nThe B<name> of a hit is unique within a Result or within an Iteration.\n\n\nsub name {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 description\n\n Title   : description\n Usage   : $desc = $hit->description();\n Function: Retrieve the description for the hit\n Returns : a scalar string\n Args    : none\n\n\nsub description {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 accession\n\n Title   : accession\n Usage   : $acc = $hit->accession();\n Function: Retrieve the accession (if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub accession {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 locus\n\n Title   : locus\n Usage   : $acc = $hit->locus();\n Function: Retrieve the locus(if available) for the hit\n Returns : a scalar string (empty string if not set)\n Args    : none\n\n\nsub locus {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $hit->length\n Function: Returns the length of the hit \n Returns : integer\n Args    : none\n\n\nsub length {\n   my ($self,@args) = @_;\n   $self->throw_not_implemented;\n}\n\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : $alg = $hit->algorithm();\n Function: Gets the algorithm specification that was used to obtain the hit\n           For BLAST, the algorithm denotes what type of sequence was aligned \n           against what (BLASTN: dna-dna, BLASTP prt-prt, BLASTX translated \n           dna-prt, TBLASTN prt-translated dna, TBLASTX translated \n           dna-translated dna).\n Returns : a scalar string \n Args    : none\n\n\nsub algorithm {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n=head2 raw_score\n\n Title   : raw_score\n Usage   : $score = $hit->raw_score();\n Function: Gets the \"raw score\" generated by the algorithm.  What\n           this score is exactly will vary from algorithm to algorithm,\n           returning undef if unavailable.\n Returns : a scalar value\n Args    : none\n\n\nsub raw_score {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 score\n\nEquivalent to L<raw_score()|raw_score>\n\n\nsub score { shift->raw_score(@_); }\n\n=head2 significance\n\n Title   : significance\n Usage   : $significance = $hit->significance();\n Function: Used to obtain the E or P value of a hit, i.e. the probability that\n           this particular hit was obtained purely by random chance.  If\n           information is not available (nor calculatable from other\n           information sources), return undef.\n Returns : a scalar value or undef if unavailable\n Args    : none\n\n\nsub significance {\n    $_[0]->throw_not_implemented;\n}\n\n=head2 bits\n\n Usage     : $hit_object->bits();\n Purpose   : Gets the bit score of the best HSP for the current hit.\n Example   : $bits = $hit_object->bits();\n Returns   : Integer or double for FASTA reports\n Argument  : n/a\n Comments  : For BLAST1, the non-bit score is listed in the summary line.\n\nSee Also   : L<score()|score>\n\n\n#---------\nsub bits { \n#---------\n    $_[0]->throw_not_implemented();\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my ($self,@args) = @_;\n    $self->throw_not_implemented;\n}\n\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n           : Get the numbers of HSPs for the current hit.\n Example   : @hsps = $hit_object->hsps();\n           : $num  = $hit_object->hsps();  # alternatively, use num_hsps()\n Returns   : Array context : list of L<Bio::Search::HSP::BlastHSP> objects.\n           : Scalar context: integer (number of HSPs).\n           :                 (Equivalent to num_hsps()).\n Argument  : n/a. Relies on wantarray\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsp()|hsp>, L<num_hsps()|num_hsps>\n\n\n#---------\nsub hsps {\n#---------\n    my $self = shift;\n\n    $self->throw_not_implemented();\n}\n\n\n\n=head2 num_hsps\n\n Usage     : $hit_object->num_hsps();\n Purpose   : Get the number of HSPs for the present Blast hit.\n Example   : $nhsps = $hit_object->num_hsps();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if the HSPs have not been collected.\n\nSee Also   : L<hsps()|hsps>\n\n\n#-------------\nsub num_hsps {\n#-------------\n    shift->throw_not_implemented();\n}\n\n\n=head2 seq_inds\n\n Usage     : $hit->seq_inds( seq_type, class, collapse );\n Purpose   : Get a list of residue positions (indices) across all HSPs\n           : for identical or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hit->seq_inds('query', 'identical');\n           : @h_ind = $hit->seq_inds('hit', 'conserved');\n           : @h_ind = $hit->seq_inds('hit', 'conserved', 1);\n Returns   : Array of integers \n           : May include ranges if collapse is non-zero.\n Argument  : [0] seq_type  = 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :                 ('sbjct' is synonymous with 'hit')\n           : [1] class     = 'identical' or 'conserved' (default = 'identical')\n           :              (can be shortened to 'id' or 'cons')\n           :              (actually, anything not 'id' will evaluate to 'conserved').\n           : [2] collapse  = boolean, if non-zero, consecutive positions are merged\n           :             using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n           :             collapses to \"1-5 7 9-11\". This is useful for \n           :             consolidating long lists. Default = no collapse.\n Throws    : n/a.\n\nSee Also   : L<Bio::Search::HSP::HSPI::seq_inds()|Bio::Search::HSP::HSPI>\n\n\n#-------------\nsub seq_inds {\n#-------------\n    my ($self, $seqType, $class, $collapse) = @_;\n\n    $seqType  ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n\n    $seqType = 'sbjct' if $seqType eq 'hit';\n\n    my (@inds, $hsp);    \n    foreach $hsp ($self->hsps) {\n        # This will merge data for all HSPs together.\n        push @inds, $hsp->seq_inds($seqType, $class);\n    }\n    \n    # Need to remove duplicates and sort the merged positions.\n    if(@inds) {\n        my %tmp = map { $_, 1 } @inds;\n        @inds = sort {$a <=> $b} keys %tmp;\n    }\n\n    $collapse ?  &Bio::Search::BlastUtils::collapse_nums(@inds) : @inds; \n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $hit->rewind;\n Function: Allow one to reset the HSP iterator to the beginning\n           if possible\n Returns : none\n Args    : none\n\n\nsub rewind{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n\n=head2 overlap\n\n Usage     : $hit_object->overlap( [integer] );\n Purpose   : Gets/Sets the allowable amount overlap between different HSP sequences.\n Example   : $hit_object->overlap(5);\n           : $overlap = $hit_object->overlap;\n Returns   : Integer.\n Argument  : integer.\n Throws    : n/a\n Status    : Experimental\n Comments  : Any two HSPs whose sequences overlap by less than or equal\n           : to the overlap() number of resides will be considered separate HSPs\n           : and will not get tiled by L<Bio::Search::BlastUtils::_adjust_contigs()>.\n\nSee Also   : L<Bio::Search::BlastUtils::_adjust_contigs()|Bio::Search::BlastUtils>, L<BUGS | BUGS>\n\n\n#-------------\nsub overlap { shift->throw_not_implemented }\n\n\n=head2 n\n\n Usage     : $hit_object->n();\n Purpose   : Gets the N number for the current Blast hit.\n           : This is the number of HSPs in the set which was ascribed\n           : the lowest P-value (listed on the description line).\n           : This number is not the same as the total number of HSPs.\n           : To get the total number of HSPs, use num_hsps().\n Example   : $n = $hit_object->n();\n Returns   : Integer\n Argument  : n/a\n Throws    : Exception if HSPs have not been set (BLAST2 reports).\n Comments  : Note that the N parameter is not reported in gapped BLAST2.\n           : Calling n() on such reports will result in a call to num_hsps().\n           : The num_hsps() method will count the actual number of\n           : HSPs in the alignment listing, which may exceed N in\n           : some cases.\n\nSee Also   : L<num_hsps()|num_hsps>\n\n\n#-----\nsub n { shift->throw_not_implemented }\n\n=head2 p\n\n Usage     : $hit_object->p( [format] );\n Purpose   : Get the P-value for the best HSP of the given BLAST hit.\n           : (Note that P-values are not provided with NCBI Blast2 reports).\n Example   : $p =  $sbjct->p;\n           : $p =  $sbjct->p('exp');  # get exponent only.\n           : ($num, $exp) =  $sbjct->p('parts');  # split sci notation into parts\n Returns   : Float or scientific notation number (the raw P-value, DEFAULT).\n           : Integer if format == 'exp' (the magnitude of the base 10 exponent).\n           : 2-element list (float, int) if format == 'parts' and P-value\n           :                is in scientific notation (See Comments).\n Argument  : format: string of 'raw' | 'exp' | 'parts'\n           :    'raw' returns value given in report. Default. (1.2e-34)\n           :    'exp' returns exponent value only (34)\n           :    'parts' returns the decimal and exponent as a \n           :            2-element list (1.2, -34) (See Comments).\n Throws    : Warns if no P-value is defined. Uses expect instead.\n Comments  : Using the 'parts' argument is not recommended since it will not\n           : work as expected if the P-value is not in scientific notation.\n           : That is, floats are not converted into sci notation before\n           : splitting into parts.\n\nSee Also   : L<expect()|expect>, L<signif()|signif>, L<Bio::Search::BlastUtils::get_exponent()|Bio::Search::BlastUtils>\n\n\n#--------\nsub p { shift->throw_not_implemented() }\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best' or 'first' = highest scoring HSP.\n           :   'worst' or 'last' = lowest scoring HSP.\n Throws    : Exception if the HSPs have not been collected.\n           : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\n#----------\nsub hsp { shift->throw_not_implemented }\n\n=head2 logical_length\n\n Usage     : $hit_object->logical_length( [seq_type] );\n           : (mostly intended for internal use).\n Purpose   : Get the logical length of the hit sequence.\n           : If the Blast is a TBLASTN or TBLASTX, the returned length \n           : is the length of the would-be amino acid sequence (length/3).\n           : For all other BLAST flavors, this function is the same as length().\n Example   : $len    = $hit_object->logical_length();\n Returns   : Integer \n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query')\n             ('sbjct' is synonymous with 'hit')\n Throws    : n/a\n Comments  : This is important for functions like frac_aligned_query()\n           : which need to operate in amino acid coordinate space when dealing\n           : with [T]BLAST[NX] type reports.\n\nSee Also   : L<length()|length>, L<frac_aligned_query()|frac_aligned_query>, L<frac_aligned_hit()|frac_aligned_hit>\n\n\n#--------------------\nsub logical_length { shift->throw_not_implemented() }\n\n\n=head2 rank\n\n Title   : rank\n Usage   : $obj->rank($newval)\n Function: Get/Set the rank of this Hit in the Query search list\n           i.e. this is the Nth hit for a specific query\n Returns : value of rank\n Args    : newvalue (optional)\n\n\n\nsub rank{\n   my ($self,$value) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 each_accession_number\n\n Title   : each_accession_number\n Usage   : $obj->each_accession_number\n Function: Get each accession number listed in the description of the hit.\n           If there are no alternatives, then only the primary accession will \n           be given\n Returns : list of all accession numbers in the description\n Args    : none","label":"each_accession_number($self,$value)"},"kind":12,"line":562,"children":[{"line":563,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"each_accession_number"},{"kind":13,"line":563,"containerName":"each_accession_number","name":"$value"},{"containerName":"each_accession_number","name":"$self","kind":13,"line":564},{"containerName":"each_accession_number","name":"throw_not_implemented","kind":12,"line":564}],"name":"each_accession_number","range":{"start":{"character":0,"line":562},"end":{"character":9999,"line":565}}},{"kind":12,"line":583,"children":[{"containerName":"tiled_hsps","name":"throw_not_implemented","line":583,"kind":12}],"containerName":"main::","definition":"sub","name":"tiled_hsps","range":{"start":{"line":583,"character":0},"end":{"character":9999,"line":583}}},{"name":"strand","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":627},"start":{"line":627,"character":0}},"kind":12,"children":[{"containerName":"strand","name":"throw_not_implemented","kind":12,"line":627}],"line":627},{"children":[{"kind":12,"line":649,"containerName":"frame","name":"throw_not_implemented"}],"line":649,"kind":12,"range":{"end":{"character":9999,"line":649},"start":{"line":649,"character":0}},"name":"frame","definition":"sub","containerName":"main::"},{"kind":12,"children":[{"containerName":"matches","name":"throw_not_implemented","kind":12,"line":683}],"line":683,"name":"matches","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":683},"start":{"line":683,"character":0}}},{"kind":12,"line":687,"children":[{"kind":12,"line":687,"containerName":"hit_description","name":"description"}],"containerName":"main::","definition":"sub","name":"hit_description","range":{"start":{"line":687,"character":0},"end":{"character":9999,"line":687}}},{"line":689,"children":[{"kind":12,"line":689,"name":"length","containerName":"hit_length"}],"kind":12,"range":{"start":{"character":0,"line":689},"end":{"character":9999,"line":689}},"containerName":"main::","name":"hit_length","definition":"sub"},{"name":"sort_hsps","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":712},"end":{"character":9999,"line":712}},"kind":12,"children":[{"containerName":"sort_hsps","name":"throw_not_implemented","kind":12,"line":712}],"line":712},{"definition":"sub","name":"_default_sort_hsps","containerName":"main::","range":{"start":{"character":0,"line":725},"end":{"character":9999,"line":728}},"kind":12,"children":[{"name":"$Bio","containerName":"_default_sort_hsps","kind":13,"line":726},{"containerName":"_default_sort_hsps","name":"evalue","kind":12,"line":726},{"line":727,"kind":13,"name":"$Bio","containerName":"_default_sort_hsps"},{"name":"evalue","containerName":"_default_sort_hsps","line":727,"kind":12}],"line":725},{"name":"Search","containerName":"Hit::HitI::a","kind":12,"line":726},{"line":727,"kind":12,"containerName":"Hit::HitI::a","name":"Search"}],"version":5}