{"vars":[{"containerName":"","name":"base","kind":2,"line":79},{"range":{"start":{"line":91,"character":0},"end":{"line":130,"character":9999}},"name":"new","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA"},"containerName":"main::","definition":"sub","line":91,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":92},{"line":92,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$len","containerName":"new","line":95,"kind":13},{"line":95,"kind":13,"name":"$qs","containerName":"new"},{"line":95,"kind":13,"name":"$hs","containerName":"new"},{"containerName":"new","name":"_rearrange","kind":12,"line":95},{"kind":13,"line":97,"containerName":"new","name":"@args"},{"line":98,"kind":13,"containerName":"new","name":"$len"},{"containerName":"new","name":"$qs","kind":13,"line":98},{"containerName":"new","name":"warn","line":99,"kind":12},{"kind":13,"line":100,"name":"$len","containerName":"new"},{"name":"$qs","containerName":"new","kind":13,"line":100},{"line":102,"kind":13,"localvar":"my","definition":"my","name":"$homol_seq","containerName":"new"},{"line":102,"kind":13,"name":"$gapct","containerName":"new"},{"name":"$identical","containerName":"new","line":102,"kind":13},{"line":104,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":"new"},{"name":"$i","containerName":"new","line":104,"kind":13},{"name":"$len","containerName":"new","line":104,"kind":13},{"line":104,"kind":13,"containerName":"new","name":"$i"},{"line":105,"kind":13,"localvar":"my","containerName":"new","name":"$q","definition":"my"},{"containerName":"new","name":"$qs","kind":13,"line":105},{"kind":13,"line":105,"name":"$i","containerName":"new"},{"definition":"my","name":"$h","containerName":"new","localvar":"my","kind":13,"line":106},{"kind":13,"line":106,"containerName":"new","name":"$hs"},{"kind":13,"line":106,"containerName":"new","name":"$i"},{"name":"$q","containerName":"new","kind":13,"line":107},{"kind":13,"line":107,"containerName":"new","name":"$h"},{"name":"$homol_seq","containerName":"new","line":108,"kind":13},{"containerName":"new","name":"$gapct","kind":13,"line":109},{"name":"$q","containerName":"new","kind":13,"line":110},{"kind":13,"line":110,"name":"$h","containerName":"new"},{"kind":13,"line":111,"containerName":"new","name":"$homol_seq"},{"kind":13,"line":112,"name":"$identical","containerName":"new"},{"containerName":"new","name":"$homol_seq","line":114,"kind":13},{"kind":13,"line":117,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":117,"name":"$class","containerName":"new"},{"containerName":"new","name":"$identical","line":117,"kind":13},{"kind":13,"line":118,"name":"$identical","containerName":"new"},{"containerName":"new","name":"$gapct","kind":13,"line":119},{"name":"$homol_seq","containerName":"new","kind":13,"line":120},{"name":"@args","containerName":"new","line":121,"kind":13},{"line":123,"kind":13,"localvar":"my","definition":"my","name":"$hmmst","containerName":"new"},{"name":"$self","containerName":"new","line":123,"kind":13},{"containerName":"new","name":"_rearrange","line":123,"kind":12},{"kind":13,"line":123,"name":"@args","containerName":"new"},{"containerName":"new","name":"$hmmst","kind":13,"line":124},{"containerName":"new","name":"$self","kind":13,"line":124},{"line":124,"kind":12,"name":"hmmstate_string","containerName":"new"},{"kind":13,"line":124,"containerName":"new","name":"$hmmst"},{"containerName":"new","name":"$self","kind":13,"line":126},{"kind":12,"line":126,"name":"add_tag_value","containerName":"new"},{"kind":13,"line":126,"containerName":"new","name":"$self"},{"containerName":"new","name":"hit","line":126,"kind":12},{"name":"seq_id","containerName":"new","line":126,"kind":12},{"line":127,"kind":13,"containerName":"new","name":"$self"},{"name":"hit","containerName":"new","line":127,"kind":12},{"name":"start","containerName":"new","line":127,"kind":12},{"kind":13,"line":127,"name":"$self","containerName":"new"},{"name":"hit","containerName":"new","kind":12,"line":127},{"kind":12,"line":127,"name":"end","containerName":"new"},{"containerName":"new","name":"$self","line":129,"kind":13}],"kind":12},{"kind":12,"line":95,"name":"Bio","containerName":"Root::RootI"},{"name":"Bio","containerName":"Root::RootI","kind":12,"line":99},{"name":"SUPER","containerName":"new","kind":12,"line":117},{"range":{"end":{"character":9999,"line":149},"start":{"line":143,"character":0}},"name":"hmmstate_string","signature":{"label":"hmmstate_string($self,$val)","parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA\n\n\nsub new {\n  my($class,@args) = @_;\n\n  # gotta do some preprocessing before we send the arguments to the superclass\n  my ($len,$qs,$hs) = Bio::Root::RootI->_rearrange([qw(HSP_LENGTH\n\t\t\t\t\t\t       QUERY_SEQ \n\t\t\t\t\t\t       HIT_SEQ)],@args);  \n  if( $len != length($qs) ) {\n    Bio::Root::RootI->warn(\"HSP_LENGTH must equal length of query_seq string, using value from QUERY_SEQ\\n\");\n      $len = length($qs);\n  }\n  my( $homol_seq,$gapct,$identical) = ('',0,0);\n  \n  for(my $i=0;$i<$len;$i++) {\n      my $q = substr($qs,$i,1);\n      my $h = substr($hs,$i,1);\n      if( $q eq '-' || $h eq '-' ) {\n\t  $homol_seq .= ' ';\n\t  $gapct ++;\n      } elsif( $q eq $h ) { \n\t  $homol_seq .= '|';\n\t  $identical++;\n      } else { \n\t  $homol_seq .= ' ';\n      }\n  }\n  my $self = $class->SUPER::new('-conserved' => $identical,\n\t\t\t\t'-identical' => $identical,\n\t\t\t\t'-gaps'      => $gapct,\n\t\t\t\t'-homology_seq' => $homol_seq,\n\t\t\t\t@args);\n    \n  my ($hmmst) = $self->_rearrange([qw(HMMSTATE_SEQ)],@args);\n  defined $hmmst && $self->hmmstate_string($hmmst);\n  \n  $self->add_tag_value('Target' , join(\" \",\"Sequence:\".$self->hit->seq_id, \n\t\t\t\t       $self->hit->start, $self->hit->end));\n\n  return $self;\n}\n\n=head2 hmmstate_string\n\n Title   : hmmstate_string\n Usage   : my $hmmseq = $wabahsp->hmmstate_string();\n Function: Get/Set the WABA HMM stateseq\n Returns : string\n Args    : [optional] string"},"detail":"($self,$val)","definition":"sub","containerName":"main::","children":[{"line":144,"kind":13,"localvar":"my","containerName":"hmmstate_string","definition":"my","name":"$self"},{"containerName":"hmmstate_string","name":"$val","kind":13,"line":144},{"containerName":"hmmstate_string","name":"$val","line":145,"kind":13},{"kind":13,"line":146,"containerName":"hmmstate_string","name":"$self"},{"name":"$val","containerName":"hmmstate_string","line":146,"kind":13},{"line":148,"kind":13,"name":"$self","containerName":"hmmstate_string"}],"line":143,"kind":12},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: WABAHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::WABAHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::WABAHSP - HSP object suitable for describing WABA alignments\n\n=head1 SYNOPSIS\n\n# use this object as you would a GenericHSP\n# a few other methods have been added including state\n\n=head1 DESCRIPTION\n\nThis object implements a few of the extra methods such as\nhmmstate_string which returns the HMM state representation for the\nWABA alignment.  We also must implement a method to calculate\nhomology_string since it is not returned by the algorithm in the\nmachine readable format.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::WABAHSP;\nuse strict;\nuse Bio::Root::RootI;\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::WABAHSP->new();\n Function: Builds a new Bio::Search::HSP::WABAHSP object \n Returns : Bio::Search::HSP::WABAHSP\n Args    : -hmmstate_seq => the string representing the state output from WABA\n\n\nsub new {\n  my($class,@args) = @_;\n\n  # gotta do some preprocessing before we send the arguments to the superclass\n  my ($len,$qs,$hs) = Bio::Root::RootI->_rearrange([qw(HSP_LENGTH\n\t\t\t\t\t\t       QUERY_SEQ \n\t\t\t\t\t\t       HIT_SEQ)],@args);  \n  if( $len != length($qs) ) {\n    Bio::Root::RootI->warn(\"HSP_LENGTH must equal length of query_seq string, using value from QUERY_SEQ\\n\");\n      $len = length($qs);\n  }\n  my( $homol_seq,$gapct,$identical) = ('',0,0);\n  \n  for(my $i=0;$i<$len;$i++) {\n      my $q = substr($qs,$i,1);\n      my $h = substr($hs,$i,1);\n      if( $q eq '-' || $h eq '-' ) {\n\t  $homol_seq .= ' ';\n\t  $gapct ++;\n      } elsif( $q eq $h ) { \n\t  $homol_seq .= '|';\n\t  $identical++;\n      } else { \n\t  $homol_seq .= ' ';\n      }\n  }\n  my $self = $class->SUPER::new('-conserved' => $identical,\n\t\t\t\t'-identical' => $identical,\n\t\t\t\t'-gaps'      => $gapct,\n\t\t\t\t'-homology_seq' => $homol_seq,\n\t\t\t\t@args);\n    \n  my ($hmmst) = $self->_rearrange([qw(HMMSTATE_SEQ)],@args);\n  defined $hmmst && $self->hmmstate_string($hmmst);\n  \n  $self->add_tag_value('Target' , join(\" \",\"Sequence:\".$self->hit->seq_id, \n\t\t\t\t       $self->hit->start, $self->hit->end));\n\n  return $self;\n}\n\n=head2 hmmstate_string\n\n Title   : hmmstate_string\n Usage   : my $hmmseq = $wabahsp->hmmstate_string();\n Function: Get/Set the WABA HMM stateseq\n Returns : string\n Args    : [optional] string\n\n\n\nsub hmmstate_string{\n   my ($self,$val) = @_;\n   if( defined $val ) { \n       $self->{'_hmmstate_string'} = $val;\n   }\n   return $self->{'_hmmstate_string'};\n}\n\n=head2 homology_string\n\n Title   : homolgy_string\n Usage   : my $homology_str = $hsp->homology_string();\n Function: Homology string must be calculated for a WABA HSP so we can do\n           so here and cache the result so it is only done once\n Returns : string\n Args    : none","label":"homology_string($self)"},"containerName":"main::","definition":"sub","line":163,"children":[{"localvar":"my","containerName":"homology_string","definition":"my","name":"$self","line":164,"kind":13}],"kind":12,"range":{"start":{"line":163,"character":0},"end":{"character":9999,"line":166}},"name":"homology_string"}],"version":5}