{"version":5,"vars":[{"line":128,"kind":2,"name":"base","containerName":""},{"range":{"end":{"character":9999,"line":190},"start":{"line":141,"character":0}},"name":"_setup","children":[{"kind":13,"line":142,"containerName":"_setup","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":142,"containerName":"_setup","name":"@args"},{"kind":13,"line":145,"name":"$self","containerName":"_setup"},{"containerName":"_setup","name":"_fields","kind":12,"line":145},{"containerName":"_setup","name":"$parent","definition":"my","localvar":"my","kind":13,"line":173},{"kind":13,"line":173,"containerName":"_setup","name":"$chunk"},{"name":"$hsp_data","containerName":"_setup","line":173,"kind":13},{"containerName":"_setup","name":"$self","line":173,"kind":13},{"kind":12,"line":173,"containerName":"_setup","name":"_rearrange"},{"name":"@args","containerName":"_setup","kind":13,"line":175},{"containerName":"_setup","name":"$self","kind":13,"line":177},{"line":177,"kind":12,"containerName":"_setup","name":"throw"},{"line":177,"kind":13,"name":"$parent","containerName":"_setup"},{"name":"$chunk","containerName":"_setup","line":177,"kind":13},{"line":179,"kind":13,"containerName":"_setup","name":"$self"},{"containerName":"_setup","name":"parent","kind":12,"line":179},{"name":"$parent","containerName":"_setup","kind":13,"line":179},{"containerName":"_setup","name":"$parent","line":179,"kind":13},{"line":181,"kind":13,"name":"$chunk","containerName":"_setup"},{"line":182,"kind":13,"localvar":"my","containerName":"_setup","definition":"my","name":"$io"},{"kind":13,"line":182,"name":"$start","containerName":"_setup"},{"containerName":"_setup","name":"$end","line":182,"kind":13},{"containerName":"_setup","name":"$chunk","kind":13,"line":183},{"line":184,"kind":13,"name":"$io","containerName":"_setup"},{"kind":13,"line":184,"name":"$start","containerName":"_setup"},{"containerName":"_setup","name":"$end","line":184,"kind":13},{"containerName":"_setup","name":"$chunk","line":184,"kind":13},{"containerName":"_setup","name":"$io","line":187,"kind":13},{"name":"$chunk","containerName":"_setup","line":187,"kind":13},{"kind":13,"line":189,"containerName":"_setup","name":"$self"},{"line":189,"kind":12,"name":"chunk","containerName":"_setup"},{"line":189,"kind":13,"name":"$io","containerName":"_setup"},{"name":"$start","containerName":"_setup","line":189,"kind":13},{"name":"$end","containerName":"_setup","line":189,"kind":13}],"line":141,"kind":12,"signature":{"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_setup($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":145,"kind":12,"name":"hsp_length"},{"name":"identical","kind":12,"line":146},{"line":147,"kind":12,"name":"percent_identity"},{"name":"conserved","kind":12,"line":148},{"name":"hsp_gaps","line":149,"kind":12},{"kind":12,"line":150,"name":"query_gaps"},{"name":"hit_gaps","kind":12,"line":151},{"name":"evalue","line":152,"kind":12},{"kind":12,"line":153,"name":"pvalue"},{"name":"score","line":154,"kind":12},{"line":155,"kind":12,"name":"query_start"},{"line":156,"kind":12,"name":"query_end"},{"name":"query_string","kind":12,"line":157},{"name":"hit_start","kind":12,"line":158},{"name":"hit_end","kind":12,"line":159},{"name":"hit_string","line":160,"kind":12},{"line":161,"kind":12,"name":"homology_string"},{"line":162,"kind":12,"name":"rank"},{"name":"seq_inds","kind":12,"line":163},{"name":"hit_identical_inds","line":164,"kind":12},{"name":"hit_conserved_inds","kind":12,"line":165},{"kind":12,"line":166,"name":"hit_nomatch_inds"},{"line":167,"kind":12,"name":"hit_gap_inds"},{"name":"query_identical_inds","kind":12,"line":168},{"kind":12,"line":169,"name":"query_conserved_inds"},{"name":"query_nomatch_inds","line":170,"kind":12},{"name":"query_gap_inds","kind":12,"line":171},{"line":192,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":192,"name":"_raw_hsp_data","containerName":"main::"},{"name":"$hsp_data","containerName":null,"line":192,"kind":13},{"kind":13,"line":192,"name":"$hsp_data","containerName":null},{"containerName":null,"name":"$self","line":194,"kind":13},{"range":{"end":{"character":9999,"line":203},"start":{"line":197,"character":0}},"containerName":"main::","definition":"sub","name":"_raw_hsp_data","line":197,"children":[{"containerName":"_raw_hsp_data","name":"$self","definition":"my","localvar":"my","kind":13,"line":198},{"line":200,"kind":13,"containerName":"_raw_hsp_data","name":"$self"},{"name":"$self","containerName":"_raw_hsp_data","kind":13,"line":202}],"kind":12},{"kind":12,"line":200,"name":"_raw_hsp_data"},{"kind":12,"line":202,"name":"_raw_hsp_data"},{"children":[{"containerName":"algorithm","name":"get_field","kind":12,"line":222}],"line":221,"kind":12,"range":{"start":{"line":221,"character":0},"end":{"line":223,"character":9999}},"name":"algorithm","definition":"sub","containerName":"main::"},{"range":{"end":{"line":237,"character":9999},"start":{"character":0,"line":235}},"name":"pvalue","definition":"sub","containerName":"main::","children":[{"kind":12,"line":236,"name":"get_field","containerName":"pvalue"}],"line":235,"kind":12},{"kind":12,"line":249,"children":[{"containerName":"evalue","name":"get_field","line":250,"kind":12}],"containerName":"main::","name":"evalue","definition":"sub","range":{"end":{"line":251,"character":9999},"start":{"character":0,"line":249}}},{"name":"frac_identical","range":{"start":{"character":0,"line":268},"end":{"character":9999,"line":277}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' ","parameters":[{"label":"$self"},{"label":"$type"}],"label":"frac_identical($self,$type)"},"detail":"($self,$type)","kind":12,"children":[{"containerName":"frac_identical","definition":"my","name":"$self","localvar":"my","kind":13,"line":269},{"name":"$type","containerName":"frac_identical","line":269,"kind":13},{"name":"$type","containerName":"frac_identical","line":271,"kind":13},{"containerName":"frac_identical","name":"$type","kind":13,"line":271},{"line":271,"kind":13,"name":"$type","containerName":"frac_identical"},{"line":272,"kind":13,"name":"$type","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$type","line":272,"kind":13},{"kind":13,"line":272,"containerName":"frac_identical","name":"$type"},{"name":"$type","containerName":"frac_identical","line":273,"kind":13},{"line":273,"kind":13,"name":"$type","containerName":"frac_identical"},{"line":273,"kind":13,"name":"$type","containerName":"frac_identical"},{"containerName":"frac_identical","name":"$type","kind":13,"line":273},{"localvar":"my","containerName":"frac_identical","name":"$ratio","definition":"my","line":275,"kind":13},{"name":"$self","containerName":"frac_identical","line":275,"kind":13},{"line":275,"kind":12,"containerName":"frac_identical","name":"num_identical"},{"containerName":"frac_identical","name":"$type","line":275,"kind":13},{"containerName":"frac_identical","name":"$self","line":275,"kind":13},{"containerName":"frac_identical","name":"length","line":275,"kind":12},{"containerName":"frac_identical","name":"$type","kind":13,"line":275},{"line":276,"kind":13,"containerName":"frac_identical","name":"$ratio"}],"line":268},{"line":294,"children":[{"kind":13,"line":295,"containerName":"frac_conserved","definition":"my","name":"$self","localvar":"my"},{"containerName":"frac_conserved","name":"$type","kind":13,"line":295},{"name":"$type","containerName":"frac_conserved","kind":13,"line":297},{"line":297,"kind":13,"name":"$type","containerName":"frac_conserved"},{"line":297,"kind":13,"containerName":"frac_conserved","name":"$type"},{"kind":13,"line":298,"name":"$type","containerName":"frac_conserved"},{"containerName":"frac_conserved","name":"$type","line":298,"kind":13},{"containerName":"frac_conserved","name":"$type","kind":13,"line":298},{"line":299,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":299,"kind":13,"name":"$type","containerName":"frac_conserved"},{"line":299,"kind":13,"containerName":"frac_conserved","name":"$type"},{"line":299,"kind":13,"name":"$type","containerName":"frac_conserved"},{"line":301,"kind":13,"localvar":"my","definition":"my","name":"$ratio","containerName":"frac_conserved"},{"kind":13,"line":301,"containerName":"frac_conserved","name":"$self"},{"containerName":"frac_conserved","name":"num_conserved","line":301,"kind":12},{"kind":13,"line":301,"name":"$type","containerName":"frac_conserved"},{"name":"$self","containerName":"frac_conserved","kind":13,"line":301},{"kind":12,"line":301,"containerName":"frac_conserved","name":"length"},{"line":301,"kind":13,"name":"$type","containerName":"frac_conserved"},{"line":302,"kind":13,"name":"$ratio","containerName":"frac_conserved"}],"kind":12,"detail":"($self,$type)","signature":{"label":"frac_conserved($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' "},"containerName":"main::","definition":"sub","range":{"end":{"line":303,"character":9999},"start":{"character":0,"line":294}},"name":"frac_conserved"},{"line":315,"children":[{"line":316,"kind":13,"localvar":"my","containerName":"num_identical","name":"$self","definition":"my"},{"name":"$self","containerName":"num_identical","line":317,"kind":13},{"containerName":"num_identical","name":"seq_inds","line":317,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":318},"start":{"line":315,"character":0}},"containerName":"main::","name":"num_identical","definition":"sub"},{"kind":12,"line":330,"children":[{"localvar":"my","containerName":"num_conserved","name":"$self","definition":"my","line":331,"kind":13},{"name":"$self","containerName":"num_conserved","line":332,"kind":13},{"containerName":"num_conserved","name":"seq_inds","kind":12,"line":332}],"containerName":"main::","definition":"sub","name":"num_conserved","range":{"end":{"character":9999,"line":333},"start":{"character":0,"line":330}}},{"range":{"start":{"character":0,"line":345},"end":{"character":9999,"line":355}},"name":"gaps","children":[{"line":346,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"gaps"},{"containerName":"gaps","name":"$type","kind":13,"line":346},{"name":"$type","containerName":"gaps","kind":13,"line":347},{"name":"$type","containerName":"gaps","line":347,"kind":13},{"kind":13,"line":347,"name":"$type","containerName":"gaps"},{"kind":13,"line":348,"name":"$type","containerName":"gaps"},{"kind":13,"line":348,"name":"$type","containerName":"gaps"},{"line":348,"kind":13,"containerName":"gaps","name":"$type"},{"name":"$type","containerName":"gaps","kind":13,"line":348},{"line":349,"kind":13,"name":"$type","containerName":"gaps"},{"kind":13,"line":349,"containerName":"gaps","name":"$type"},{"name":"$type","containerName":"gaps","line":351,"kind":13},{"containerName":"gaps","name":"$self","kind":13,"line":352},{"line":352,"kind":12,"containerName":"gaps","name":"seq_inds"},{"name":"$self","containerName":"gaps","kind":13,"line":352},{"line":352,"kind":12,"name":"seq_inds","containerName":"gaps"},{"line":354,"kind":13,"name":"$self","containerName":"gaps"},{"kind":12,"line":354,"containerName":"gaps","name":"seq_inds"},{"kind":13,"line":354,"containerName":"gaps","name":"$type"}],"line":345,"kind":12,"signature":{"label":"gaps($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' "},"detail":"($self,$type)","definition":"sub","containerName":"main::"},{"line":367,"children":[{"containerName":"query_string","name":"get_field","line":368,"kind":12}],"kind":12,"range":{"end":{"line":369,"character":9999},"start":{"character":0,"line":367}},"containerName":"main::","name":"query_string","definition":"sub"},{"children":[{"containerName":"hit_string","name":"get_field","kind":12,"line":382}],"line":381,"kind":12,"range":{"end":{"character":9999,"line":383},"start":{"line":381,"character":0}},"name":"hit_string","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"homology_string","range":{"start":{"line":398,"character":0},"end":{"character":9999,"line":400}},"kind":12,"line":398,"children":[{"name":"get_field","containerName":"homology_string","line":399,"kind":12}]},{"range":{"start":{"character":0,"line":418},"end":{"character":9999,"line":432}},"name":"length","signature":{"label":"length($self,$type)","documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none","parameters":[{"label":"$self"},{"label":"$type"}]},"detail":"($self,$type)","definition":"sub","containerName":"main::","children":[{"line":419,"kind":13,"localvar":"my","containerName":"length","definition":"my","name":"$self"},{"line":419,"kind":13,"containerName":"length","name":"$type"},{"line":420,"kind":13,"containerName":"length","name":"$type"},{"name":"$type","containerName":"length","line":420,"kind":13},{"name":"$type","containerName":"length","kind":13,"line":421},{"line":421,"kind":13,"name":"$type","containerName":"length"},{"line":423,"kind":13,"name":"$type","containerName":"length"},{"name":"$self","containerName":"length","line":424,"kind":13},{"containerName":"length","name":"query","kind":12,"line":424},{"line":424,"kind":12,"containerName":"length","name":"length"},{"containerName":"length","name":"$type","kind":13,"line":426},{"name":"$self","containerName":"length","line":427,"kind":13},{"line":427,"kind":12,"containerName":"length","name":"hit"},{"containerName":"length","name":"length","line":427,"kind":12},{"kind":13,"line":430,"containerName":"length","name":"$self"},{"line":430,"kind":12,"containerName":"length","name":"hit"},{"line":430,"kind":12,"containerName":"length","name":"length"},{"line":430,"kind":13,"name":"$self","containerName":"length"},{"line":430,"kind":12,"containerName":"length","name":"gaps"}],"line":418,"kind":12},{"kind":12,"children":[{"containerName":"hsp_length","name":"length","kind":12,"line":445}],"line":444,"definition":"sub","name":"hsp_length","containerName":"main::","range":{"start":{"character":0,"line":444},"end":{"character":9999,"line":446}}},{"name":"percent_identity","range":{"end":{"line":461,"character":9999},"start":{"character":0,"line":458}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none","parameters":[{"label":"$self"}],"label":"percent_identity($self)"},"kind":12,"line":458,"children":[{"line":459,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"percent_identity"},{"kind":13,"line":460,"name":"$self","containerName":"percent_identity"},{"containerName":"percent_identity","name":"frac_identical","line":460,"kind":12}]},{"kind":12,"line":473,"children":[{"name":"$self","definition":"my","containerName":"get_aln","localvar":"my","kind":13,"line":474},{"kind":13,"line":478,"containerName":"get_aln","name":"$aln","definition":"my","localvar":"my"},{"name":"new","containerName":"get_aln","line":478,"kind":12},{"kind":13,"line":479,"definition":"my","name":"$hs","containerName":"get_aln","localvar":"my"},{"kind":13,"line":479,"containerName":"get_aln","name":"$self"},{"kind":12,"line":479,"name":"seq","containerName":"get_aln"},{"localvar":"my","definition":"my","name":"$qs","containerName":"get_aln","line":480,"kind":13},{"line":480,"kind":13,"name":"$self","containerName":"get_aln"},{"containerName":"get_aln","name":"seq","kind":12,"line":480},{"kind":13,"line":481,"name":"$hs","containerName":"get_aln"},{"line":481,"kind":13,"name":"$qs","containerName":"get_aln"},{"line":482,"kind":13,"name":"$aln","containerName":"get_aln"},{"name":"add_seq","containerName":"get_aln","line":482,"kind":12},{"line":482,"kind":13,"name":"$hs","containerName":"get_aln"},{"name":"$aln","containerName":"get_aln","kind":13,"line":483},{"name":"add_seq","containerName":"get_aln","line":483,"kind":12},{"name":"$qs","containerName":"get_aln","kind":13,"line":483},{"name":"$aln","containerName":"get_aln","line":484,"kind":13}],"containerName":"main::","definition":"sub","name":"get_aln","range":{"start":{"character":0,"line":473},"end":{"character":9999,"line":487}}},{"line":478,"kind":12,"name":"Bio","containerName":"LocatableSeq::Bio::SimpleAlign"},{"name":"Bio","containerName":"SimpleAlign","line":478,"kind":12},{"kind":12,"line":518,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"seq_inds","line":519,"kind":13},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":519},{"line":519,"kind":13,"name":"$class","containerName":"seq_inds"},{"name":"$collapse","containerName":"seq_inds","line":519,"kind":13},{"kind":13,"line":521,"name":"$seqType","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$class","kind":13,"line":522},{"containerName":"seq_inds","name":"$collapse","line":523,"kind":13},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":524},{"line":524,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"containerName":"seq_inds","name":"$class","line":525,"kind":13},{"line":525,"kind":13,"containerName":"seq_inds","name":"$class"},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":526},{"line":526,"kind":13,"containerName":"seq_inds","name":"$seqType"},{"localvar":"my","containerName":"seq_inds","name":"$t","definition":"my","line":528,"kind":13},{"kind":13,"line":528,"name":"$seqType","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$t","kind":13,"line":529},{"name":"$seqType","containerName":"seq_inds","line":530,"kind":13},{"line":532,"kind":13,"name":"$t","containerName":"seq_inds"},{"name":"$t","containerName":"seq_inds","line":532,"kind":13},{"name":"$seqType","containerName":"seq_inds","kind":13,"line":533},{"kind":13,"line":536,"name":"$self","containerName":"seq_inds"},{"containerName":"seq_inds","name":"warn","kind":12,"line":536},{"containerName":"seq_inds","name":"$seqType","kind":13,"line":537},{"containerName":"seq_inds","name":"$t","kind":13,"line":540},{"containerName":"seq_inds","name":"$class","kind":13,"line":540},{"kind":13,"line":541,"name":"$t","containerName":"seq_inds"},{"containerName":"seq_inds","name":"$class","kind":13,"line":542},{"name":"$class","containerName":"seq_inds","line":543,"kind":13},{"name":"$class","containerName":"seq_inds","kind":13,"line":546},{"kind":13,"line":549,"name":"$t","containerName":"seq_inds"},{"kind":13,"line":550,"containerName":"seq_inds","name":"$class"},{"kind":13,"line":552,"name":"$t","containerName":"seq_inds"},{"name":"$class","containerName":"seq_inds","kind":13,"line":553},{"containerName":"seq_inds","name":"$t","line":555,"kind":13},{"containerName":"seq_inds","name":"$class","kind":13,"line":556},{"line":559,"kind":13,"containerName":"seq_inds","name":"$self"},{"line":559,"kind":12,"containerName":"seq_inds","name":"warn"},{"kind":13,"line":560,"containerName":"seq_inds","name":"$class"},{"containerName":"seq_inds","name":"$seqType","line":563,"kind":13},{"kind":13,"line":564,"containerName":"seq_inds","name":"$class"},{"localvar":"my","name":"@ary","definition":"my","containerName":"seq_inds","line":566,"kind":13},{"kind":13,"line":567,"containerName":"seq_inds","name":"$class"},{"name":"%tmp","definition":"my","containerName":"seq_inds","localvar":"my","kind":13,"line":568},{"kind":13,"line":568,"containerName":"seq_inds","name":"$self"},{"containerName":"seq_inds","name":"get_field","kind":12,"line":568},{"kind":13,"line":568,"containerName":"seq_inds","name":"$seqType"},{"name":"$self","containerName":"seq_inds","kind":13,"line":569},{"line":569,"kind":12,"containerName":"seq_inds","name":"get_field"},{"kind":13,"line":569,"name":"$seqType","containerName":"seq_inds"}],"containerName":"main::","definition":"sub","detail":"($self,$seqType,$class,$collapse)","signature":{"label":"seq_inds($self,$seqType,$class,$collapse)","parameters":[{"label":"$self"},{"label":"$seqType"},{"label":"$class"},{"label":"$collapse"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>"},"name":"seq_inds","range":{"end":{"character":9999,"line":569},"start":{"character":0,"line":518}}},{"line":570,"kind":13,"containerName":null,"name":"@ary"},{"containerName":null,"name":"$a","line":570,"kind":13},{"name":"$b","containerName":null,"line":570,"kind":13},{"line":570,"kind":13,"containerName":null,"name":"%tmp"},{"containerName":null,"name":"@ary","kind":13,"line":573},{"name":"$self","containerName":null,"line":573,"kind":13},{"line":573,"kind":12,"containerName":"main::","name":"get_field"},{"kind":13,"line":573,"containerName":null,"name":"$seqType"},{"kind":13,"line":573,"containerName":null,"name":"$class"},{"containerName":null,"name":"$collapse","line":576,"kind":13},{"kind":12,"line":576,"name":"Bio","containerName":"Search::SearchUtils::collapse_nums"},{"line":576,"kind":13,"name":"@ary","containerName":null},{"name":"@ary","containerName":null,"kind":13,"line":576},{"line":612,"children":[{"containerName":"significance","name":"get_field","line":613,"kind":12}],"kind":12,"range":{"start":{"line":612,"character":0},"end":{"character":9999,"line":614}},"containerName":"main::","definition":"sub","name":"significance"},{"kind":12,"children":[{"name":"get_field","containerName":"score","kind":12,"line":627}],"line":626,"definition":"sub","name":"score","containerName":"main::","range":{"end":{"line":628,"character":9999},"start":{"line":626,"character":0}}},{"containerName":"main::","name":"bits","definition":"sub","range":{"start":{"line":640,"character":0},"end":{"line":642,"character":9999}},"kind":12,"line":640,"children":[{"name":"get_field","containerName":"bits","line":641,"kind":12}]},{"line":658,"children":[{"line":659,"kind":13,"localvar":"my","containerName":"strand","definition":"my","name":"$self"},{"localvar":"my","name":"$val","definition":"my","containerName":"strand","line":660,"kind":13},{"line":661,"kind":13,"containerName":"strand","name":"$val"},{"kind":13,"line":661,"containerName":"strand","name":"$val"},{"containerName":"strand","name":"$val","kind":13,"line":662},{"kind":13,"line":664,"name":"$val","containerName":"strand"},{"containerName":"strand","name":"$self","line":665,"kind":13},{"containerName":"strand","name":"query","line":665,"kind":12},{"containerName":"strand","name":"strand","kind":12,"line":665},{"kind":13,"line":667,"name":"$val","containerName":"strand"},{"name":"$self","containerName":"strand","kind":13,"line":668},{"line":668,"kind":12,"name":"hit","containerName":"strand"},{"name":"strand","containerName":"strand","kind":12,"line":668},{"kind":13,"line":670,"containerName":"strand","name":"$val"},{"name":"$self","containerName":"strand","line":671,"kind":13},{"kind":12,"line":671,"containerName":"strand","name":"query"},{"kind":12,"line":671,"containerName":"strand","name":"strand"},{"kind":13,"line":671,"name":"$self","containerName":"strand"},{"line":671,"kind":12,"name":"hit","containerName":"strand"},{"line":671,"kind":12,"containerName":"strand","name":"strand"},{"containerName":"strand","name":"$self","kind":13,"line":674},{"containerName":"strand","name":"warn","kind":12,"line":674}],"kind":12,"range":{"end":{"character":9999,"line":677},"start":{"character":0,"line":658}},"containerName":"main::","definition":"sub","name":"strand"},{"kind":12,"line":691,"children":[{"line":692,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"start"},{"definition":"my","name":"$val","containerName":"start","localvar":"my","kind":13,"line":693},{"line":694,"kind":13,"name":"$val","containerName":"start"},{"containerName":"start","name":"$val","line":694,"kind":13},{"containerName":"start","name":"$val","kind":13,"line":695},{"name":"$val","containerName":"start","line":697,"kind":13},{"containerName":"start","name":"$self","line":698,"kind":13},{"kind":12,"line":698,"containerName":"start","name":"query"},{"kind":12,"line":698,"name":"start","containerName":"start"},{"line":700,"kind":13,"name":"$val","containerName":"start"},{"line":701,"kind":13,"containerName":"start","name":"$self"},{"line":701,"kind":12,"containerName":"start","name":"hit"},{"containerName":"start","name":"start","line":701,"kind":12},{"name":"$val","containerName":"start","line":703,"kind":13},{"line":704,"kind":13,"name":"$self","containerName":"start"},{"name":"query","containerName":"start","kind":12,"line":704},{"name":"start","containerName":"start","kind":12,"line":704},{"kind":13,"line":704,"containerName":"start","name":"$self"},{"containerName":"start","name":"hit","line":704,"kind":12},{"line":704,"kind":12,"name":"start","containerName":"start"},{"name":"$self","containerName":"start","kind":13,"line":707},{"name":"warn","containerName":"start","kind":12,"line":707}],"containerName":"main::","name":"start","definition":"sub","range":{"start":{"line":691,"character":0},"end":{"character":9999,"line":710}}},{"range":{"start":{"line":724,"character":0},"end":{"line":743,"character":9999}},"definition":"sub","name":"end","containerName":"main::","children":[{"containerName":"end","definition":"my","name":"$self","localvar":"my","kind":13,"line":725},{"name":"$val","definition":"my","containerName":"end","localvar":"my","kind":13,"line":726},{"line":727,"kind":13,"containerName":"end","name":"$val"},{"containerName":"end","name":"$val","line":727,"kind":13},{"name":"$val","containerName":"end","kind":13,"line":728},{"containerName":"end","name":"$val","kind":13,"line":730},{"line":731,"kind":13,"name":"$self","containerName":"end"},{"containerName":"end","name":"query","kind":12,"line":731},{"line":731,"kind":12,"containerName":"end","name":"end"},{"containerName":"end","name":"$val","line":733,"kind":13},{"name":"$self","containerName":"end","kind":13,"line":734},{"name":"hit","containerName":"end","line":734,"kind":12},{"containerName":"end","name":"end","line":734,"kind":12},{"kind":13,"line":736,"containerName":"end","name":"$val"},{"line":737,"kind":13,"name":"$self","containerName":"end"},{"line":737,"kind":12,"containerName":"end","name":"query"},{"containerName":"end","name":"end","kind":12,"line":737},{"kind":13,"line":737,"containerName":"end","name":"$self"},{"line":737,"kind":12,"name":"hit","containerName":"end"},{"containerName":"end","name":"end","kind":12,"line":737},{"kind":13,"line":740,"name":"$self","containerName":"end"},{"containerName":"end","name":"warn","kind":12,"line":740}],"line":724,"kind":12},{"range":{"end":{"line":776,"character":9999},"start":{"character":0,"line":757}},"name":"seq","line":757,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"seq","line":758,"kind":13},{"name":"$seqType","containerName":"seq","kind":13,"line":758},{"containerName":"seq","name":"$seqType","line":759,"kind":13},{"kind":13,"line":760,"name":"$seqType","containerName":"seq"},{"name":"$seqType","containerName":"seq","kind":13,"line":760},{"line":761,"kind":13,"name":"$seqType","containerName":"seq"},{"line":762,"kind":13,"name":"$self","containerName":"seq"},{"containerName":"seq","name":"throw","kind":12,"line":762},{"definition":"my","name":"$str","containerName":"seq","localvar":"my","kind":13,"line":765},{"containerName":"seq","name":"$self","kind":13,"line":765},{"containerName":"seq","name":"seq_str","line":765,"kind":12},{"containerName":"seq","name":"$seqType","kind":13,"line":765},{"kind":13,"line":767,"containerName":"seq","name":"$id","definition":"my","localvar":"my"},{"kind":13,"line":767,"name":"$seqType","containerName":"seq"},{"containerName":"seq","name":"$self","kind":13,"line":767},{"kind":12,"line":767,"name":"query","containerName":"seq"},{"line":767,"kind":12,"name":"seq_id","containerName":"seq"},{"containerName":"seq","name":"$self","line":767,"kind":13},{"line":767,"kind":12,"containerName":"seq","name":"hit"},{"line":767,"kind":12,"name":"seq_id","containerName":"seq"},{"name":"new","containerName":"seq","kind":12,"line":768},{"name":"$id","containerName":"seq","kind":13,"line":768},{"line":769,"kind":13,"name":"$str","containerName":"seq"},{"containerName":"seq","name":"$self","line":770,"kind":13},{"name":"start","containerName":"seq","kind":12,"line":770},{"name":"$seqType","containerName":"seq","line":770,"kind":13},{"containerName":"seq","name":"$self","kind":13,"line":771},{"containerName":"seq","name":"end","line":771,"kind":12},{"kind":13,"line":771,"name":"$seqType","containerName":"seq"},{"name":"$self","containerName":"seq","line":772,"kind":13},{"containerName":"seq","name":"strand","kind":12,"line":772},{"containerName":"seq","name":"$seqType","kind":13,"line":772},{"line":773,"kind":13,"name":"$id","containerName":"seq"}],"kind":12,"detail":"($self,$seqType)","signature":{"label":"seq($self,$seqType)","documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'","parameters":[{"label":"$self"},{"label":"$seqType"}]},"containerName":"main::","definition":"sub"},{"line":767,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"line":768,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"range":{"start":{"line":796,"character":0},"end":{"line":813,"character":9999}},"name":"seq_str","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"seq_str","localvar":"my","kind":13,"line":797},{"localvar":"my","containerName":"seq_str","name":"$type","definition":"my","line":798,"kind":13},{"name":"$type","containerName":"seq_str","line":800,"kind":13},{"kind":13,"line":801,"containerName":"seq_str","name":"$self"},{"containerName":"seq_str","name":"query_string","line":801,"kind":12},{"line":803,"kind":13,"containerName":"seq_str","name":"$type"},{"line":804,"kind":13,"name":"$self","containerName":"seq_str"},{"name":"hit_string","containerName":"seq_str","kind":12,"line":804},{"kind":13,"line":806,"containerName":"seq_str","name":"$type"},{"name":"$self","containerName":"seq_str","kind":13,"line":807},{"line":807,"kind":12,"containerName":"seq_str","name":"homology_string"},{"kind":13,"line":810,"containerName":"seq_str","name":"$self"},{"containerName":"seq_str","name":"warn","line":810,"kind":12}],"line":796,"kind":12},{"children":[{"line":826,"kind":12,"containerName":"rank","name":"get_field"}],"line":825,"kind":12,"range":{"end":{"line":827,"character":9999},"start":{"character":0,"line":825}},"name":"rank","definition":"sub","containerName":"main::"},{"name":"matches","range":{"start":{"character":0,"line":849},"end":{"line":897,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n\n\nsub seq {\n    my ($self, $seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    if ($seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n\t\n    my $str = $self->seq_str($seqType) || return;\n    require Bio::LocatableSeq;\n    my $id = ($seqType =~ /^q/i) ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L<seq()|seq>, L<seq_inds()|seq_inds>, B<_set_match_seq()>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if ($type =~ /^q/i) {\n        return $self->query_string(@_);\n    }\n    elsif ($type =~ /^(s)|(hi)/i) {\n        return $self->hit_string(@_);\n    }\n    elsif ($type =~ /^(ho)|(ma)/i) {\n        return $self->homology_string(@_);\n    }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)","label":"matches($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"containerName":"matches","name":"$self","definition":"my","localvar":"my","kind":13,"line":850},{"containerName":"matches","name":"@args","kind":13,"line":850},{"kind":13,"line":851,"name":"$seqType","definition":"my","containerName":"matches","localvar":"my"},{"line":851,"kind":13,"name":"$beg","containerName":"matches"},{"containerName":"matches","name":"$end","line":851,"kind":13},{"kind":13,"line":851,"containerName":"matches","name":"$self"},{"containerName":"matches","name":"_rearrange","kind":12,"line":851},{"name":"@args","containerName":"matches","kind":13,"line":851},{"name":"$seqType","containerName":"matches","kind":13,"line":852},{"kind":13,"line":853,"containerName":"matches","name":"$seqType"},{"line":853,"kind":13,"containerName":"matches","name":"$seqType"},{"line":855,"kind":13,"localvar":"my","containerName":"matches","name":"@data","definition":"my"},{"kind":13,"line":856,"containerName":"matches","name":"$beg"},{"containerName":"matches","name":"$end","kind":13,"line":856},{"kind":13,"line":856,"name":"$self","containerName":"matches"},{"line":856,"kind":12,"containerName":"matches","name":"seq_str"},{"containerName":"matches","name":"@data","kind":13,"line":857},{"line":857,"kind":13,"containerName":"matches","name":"$self"},{"containerName":"matches","name":"num_identical","kind":12,"line":857},{"kind":13,"line":857,"containerName":"matches","name":"$self"},{"name":"num_conserved","containerName":"matches","kind":12,"line":857},{"name":"$beg","containerName":"matches","kind":13,"line":860},{"kind":13,"line":861,"name":"$end","containerName":"matches"},{"line":862,"kind":13,"localvar":"my","name":"$start","definition":"my","containerName":"matches"},{"line":862,"kind":13,"name":"$stop","containerName":"matches"},{"name":"$self","containerName":"matches","line":862,"kind":13},{"containerName":"matches","name":"range","kind":12,"line":862},{"name":"$seqType","containerName":"matches","kind":13,"line":862},{"containerName":"matches","name":"$beg","line":864,"kind":13},{"kind":13,"line":865,"name":"$beg","containerName":"matches"},{"kind":13,"line":865,"containerName":"matches","name":"$start"},{"kind":13,"line":866,"name":"$end","containerName":"matches"},{"kind":13,"line":866,"containerName":"matches","name":"$beg"},{"kind":13,"line":866,"containerName":"matches","name":"$end"},{"kind":13,"line":868,"containerName":"matches","name":"$end"},{"name":"$end","containerName":"matches","kind":13,"line":869},{"kind":13,"line":869,"containerName":"matches","name":"$stop"},{"line":870,"kind":13,"containerName":"matches","name":"$beg"},{"kind":13,"line":870,"name":"$end","containerName":"matches"},{"line":870,"kind":13,"containerName":"matches","name":"$beg"},{"line":873,"kind":13,"containerName":"matches","name":"$end"},{"containerName":"matches","name":"$stop","line":873,"kind":13},{"line":874,"kind":13,"containerName":"matches","name":"$end"},{"name":"$stop","containerName":"matches","line":874,"kind":13},{"kind":13,"line":877,"name":"$end","containerName":"matches"},{"kind":13,"line":879,"name":"$beg","containerName":"matches"},{"line":879,"kind":13,"name":"$start","containerName":"matches"},{"line":880,"kind":13,"name":"$beg","containerName":"matches"},{"name":"$start","containerName":"matches","line":880,"kind":13},{"kind":13,"line":883,"name":"$seq","definition":"my","containerName":"matches","localvar":"my"},{"containerName":"matches","name":"$self","kind":13,"line":883},{"name":"seq_str","containerName":"matches","kind":12,"line":883},{"containerName":"matches","name":"$beg","line":883,"kind":13},{"kind":13,"line":883,"name":"$start","containerName":"matches"},{"containerName":"matches","name":"$end","line":883,"kind":13},{"line":883,"kind":13,"containerName":"matches","name":"$beg"},{"kind":13,"line":885,"name":"$seq","containerName":"matches"},{"kind":13,"line":886,"name":"$self","containerName":"matches"},{"containerName":"matches","name":"throw","kind":12,"line":886},{"name":"$seq","containerName":"matches","line":889,"kind":13},{"localvar":"my","containerName":"matches","name":"$len_cons","definition":"my","line":890,"kind":13},{"line":890,"kind":13,"name":"$seq","containerName":"matches"},{"line":891,"kind":13,"containerName":"matches","name":"$seq"},{"containerName":"matches","name":"$len_id","definition":"my","localvar":"my","kind":13,"line":892},{"containerName":"matches","name":"$seq","line":892,"kind":13},{"name":"@data","containerName":"matches","kind":13,"line":893},{"name":"$len_id","containerName":"matches","line":893,"kind":13},{"name":"$len_cons","containerName":"matches","kind":13,"line":893},{"line":896,"kind":13,"containerName":"matches","name":"@data"}],"line":849},{"line":885,"kind":12,"name":"CORE","containerName":"length"},{"line":891,"kind":12,"containerName":"length","name":"CORE"},{"name":"CORE","containerName":"length","line":893,"kind":12},{"containerName":"main::","definition":"sub","name":"n","range":{"start":{"line":913,"character":0},"end":{"line":915,"character":9999}},"kind":12,"line":913,"children":[{"containerName":"n","name":"get_field","line":914,"kind":12}]},{"line":933,"children":[{"containerName":"range","definition":"my","name":"$self","localvar":"my","kind":13,"line":934},{"line":934,"kind":13,"containerName":"range","name":"$seqType"},{"line":935,"kind":13,"name":"$seqType","containerName":"range"},{"kind":13,"line":937,"definition":"my","name":"$start","containerName":"range","localvar":"my"},{"name":"$end","containerName":"range","line":937,"kind":13},{"name":"$seqType","containerName":"range","line":938,"kind":13},{"name":"$start","containerName":"range","line":939,"kind":13},{"kind":13,"line":939,"name":"$self","containerName":"range"},{"containerName":"range","name":"query","line":939,"kind":12},{"kind":12,"line":939,"containerName":"range","name":"start"},{"name":"$end","containerName":"range","kind":13,"line":940},{"line":940,"kind":13,"containerName":"range","name":"$self"},{"name":"query","containerName":"range","line":940,"kind":12},{"kind":12,"line":940,"containerName":"range","name":"end"},{"name":"$start","containerName":"range","kind":13,"line":943},{"line":943,"kind":13,"containerName":"range","name":"$self"},{"kind":12,"line":943,"name":"hit","containerName":"range"},{"kind":12,"line":943,"containerName":"range","name":"start"},{"containerName":"range","name":"$end","line":944,"kind":13},{"line":944,"kind":13,"name":"$self","containerName":"range"},{"line":944,"kind":12,"name":"hit","containerName":"range"},{"line":944,"kind":12,"containerName":"range","name":"end"},{"line":946,"kind":13,"containerName":"range","name":"$start"},{"name":"$end","containerName":"range","line":946,"kind":13}],"kind":12,"detail":"($self,$seqType)","signature":{"parameters":[{"label":"$self"},{"label":"$seqType"}],"documentation":"1;\n# $Id: PullHSPI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::PullHSPI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::PullHSPI - Bio::Search::HSP::HSPI interface for pull parsers.\n\n=head1 SYNOPSIS\n\n  # This is an interface and cannot be instantiated\n\n  # generally we use Bio::SearchIO to build these objects\n  use Bio::SearchIO;\n  my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n                              -file   => 'result.hmmer');\n\n  while (my $result = $in->next_result) {\n      while (my $hit = $result->next_hit) {\n          while (my $hsp = $hit->next_hsp) {\n              $r_type = $hsp->algorithm;\n              $pvalue = $hsp->p();\n              $evalue = $hsp->evalue();\n              $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n              $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n              $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n              $qseq = $hsp->query_string;\n              $hseq = $hsp->hit_string;\n              $homo_string = $hsp->homology_string;\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $len = $hsp->length( ['query'|'hit'|'total'] );\n              $rank = $hsp->rank;\n          }\n      }\n  }\n\n\n=head1 DESCRIPTION\n\nPullHSP is for fast implementations that only do parsing work on the hsp\ndata when you actually request information by calling one of the HSPI\nmethods.\n\nMany methods of HSPI are implemented in a way suitable for inheriting classes\nthat use Bio::PullParserI. It only really makes sense for PullHSP modules to be\ncreated by (and have as a -parent) PullHit modules.\n\nIn addition to the usual -chunk and -parent, -hsp_data is all you should supply\nwhen making a PullHSP object. This will store that data and make it accessible\nvia _raw_hsp_data, which you can access in your subclass. It would be best to\nsimply provide the data as the input -chunk instead, if the raw data is large\nenough.\n\n=head1 SEE ALSO\n\nThis module inherits methods from these other modules:\n\nL<Bio::SeqFeatureI>,\nL<Bio::SeqFeature::FeaturePair>\nL<Bio::SeqFeature::SimilarityPair>\n\nPlease refer to these modules for documentation of the \nmany additional inherited methods.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 COPYRIGHT\n\nCopyright (c) 2006 Sendu Bala. All Rights Reserved.\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::HSP::PullHSPI;\n\n\nuse strict;\n\nuse base qw(Bio::Search::HSP::HSPI Bio::PullParserI);\n\n=head2 _setup\n\n Title   : _setup\n Usage   : $self->_setup(@args)\n Function: Implementers should call this to setup common fields and deal with\n           common arguments to new().\n Returns : n/a\n Args    : @args received in new().\n\n\nsub _setup {\n    my ($self, @args) = @_;\n\t\n\t# fields most subclasses probably will want\n\t$self->_fields( { ( hsp_length => undef,\n                        identical => undef,\n                        percent_identity => undef,\n                        conserved => undef,\n                        hsp_gaps => undef,\n                        query_gaps => undef,\n                        hit_gaps => undef,\n\t\t\t\t\t\tevalue => undef,\n\t\t\t\t\t\tpvalue => undef,\n\t\t\t\t\t\tscore => undef,\n\t\t\t\t\t\tquery_start => undef,\n\t\t\t\t\t\tquery_end => undef,\n\t\t\t\t\t\tquery_string => undef,\n\t\t\t\t\t\thit_start => undef,\n\t\t\t\t\t\thit_end => undef,\n\t\t\t\t\t\thit_string => undef,\n\t\t\t\t\t\thomology_string => undef,\n\t\t\t\t\t\trank => undef,\n                        seq_inds => undef,\n                        hit_identical_inds => undef,\n                        hit_conserved_inds => undef,\n                        hit_nomatch_inds => undef,\n                        hit_gap_inds => undef,\n                        query_identical_inds => undef,\n                        query_conserved_inds => undef,\n                        query_nomatch_inds => undef,\n                        query_gap_inds => undef ) } );\n\t\n\tmy ($parent, $chunk, $hsp_data) = $self->_rearrange([qw(PARENT\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t    CHUNK\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tHSP_DATA)], @args);\n\t\n    $self->throw(\"Need -parent or -chunk to be defined\") unless defined $parent || $chunk;\n    \n\t$self->parent($parent) if $parent;\n    \n    if ($chunk) {\n        my ($io, $start, $end) = (undef, 0, undef);\n        if (ref($chunk) eq 'ARRAY') {\n            ($io, $start, $end) = @{$chunk};\n        }\n        else {\n            $io = $chunk;\n        }\n        $self->chunk($io, -start => $start, -end => $end);\n    }\n    \n\t$self->_raw_hsp_data($hsp_data) if $hsp_data;\n\t\n    return $self;\n}\n\nsub _raw_hsp_data {\n\tmy $self = shift;\n\tif (@_) {\n\t\t$self->{_raw_hsp_data} = shift;\n\t}\n\treturn $self->{_raw_hsp_data};\n}\n\n#\n# Some of these methods are written explitely to avoid HSPI throwing not\n# implemented or the wrong ancestor class being used to answer the method;\n# if it didn't do that then PullParserI AUTOLOAD would have cought them.\n#\n\n=head2 algorithm\n\n Title   : algorithm\n Usage   : my $r_type = $hsp->algorithm\n Function: Obtain the name of the algorithm used to obtain the HSP\n Returns : string (e.g., BLASTP)\n Args    : none\n\n\nsub algorithm {\n\treturn shift->get_field('algorithm');\n}\n\n=head2 pvalue\n\n Title   : pvalue\n Usage   : my $pvalue = $hsp->pvalue();\n Function: Returns the P-value for this HSP or undef \n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub pvalue {\n\treturn shift->get_field('pvalue');\n}\n\n=head2 evalue\n\n Title   : evalue\n Usage   : my $evalue = $hsp->evalue();\n Function: Returns the e-value for this HSP\n Returns : float or exponential (2e-10)\n Args    : none\n\n\nsub evalue {\n\treturn shift->get_field('evalue');\n}\n\n*expect = \\&evalue;\n\n=head2 frac_identical\n\n Title   : frac_identical\n Usage   : my $frac_id = $hsp->frac_identical( ['query'|'hit'|'total'] );\n Function: Returns the fraction of identitical positions for this HSP \n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num identical / length of query seq (without gaps)\n           'hit'   = num identical / length of hit seq (without gaps)\n           'total' = num identical / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_identical {\n\tmy ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_identical($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 frac_conserved\n\n Title    : frac_conserved\n Usage    : my $frac_cons = $hsp->frac_conserved( ['query'|'hit'|'total'] );\n Function : Returns the fraction of conserved positions for this HSP.\n            This is the fraction of symbols in the alignment with a \n            positive score.\n Returns : Float in range 0.0 -> 1.0\n Args    : 'query' = num conserved / length of query seq (without gaps)\n           'hit'   = num conserved / length of hit seq (without gaps)\n           'total' = num conserved / length of alignment (with gaps)\n           default = 'total' \n\n\nsub frac_conserved {\n    my ($self, $type) = @_;\n\t\n\t$type = lc $type if defined $type;\n\t$type = 'hit' if (defined $type && $type =~ /subject|sbjct/);\n\t$type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/);\n\t\n\tmy $ratio = $self->num_conserved($type) / $self->length($type);\n    return sprintf( \"%.4f\", $ratio);\n}\n\n=head2 num_identical\n\n Title   : num_identical\n Usage   : $obj->num_identical($newval)\n Function: returns the number of identical residues in the alignment\n Returns : integer\n Args    : integer (optional)\n\n\nsub num_identical {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'identical'));\n}\n\n=head2 num_conserved\n\n Title   : num_conserved\n Usage   : $obj->num_conserved($newval)\n Function: returns the number of conserved residues in the alignment\n Returns : inetger\n Args    : integer (optional)\n\n\nsub num_conserved {\n    my $self = shift;\n\treturn scalar($self->seq_inds('hit', 'conserved-not-identical'));\n}\n\n=head2 gaps\n\n Title    : gaps\n Usage    : my $gaps = $hsp->gaps( ['query'|'hit'|'total'] );\n Function : Get the number of gap characters in the query, hit, or total alignment.\n Returns  : Integer, number of gap characters or 0 if none\n Args     : 'query', 'hit' or 'total'; default = 'total' \n\n\nsub gaps {\n    my ($self, $type) = @_;\n    $type = lc $type if defined $type;\n    $type = 'total' if (! defined $type || $type eq 'hsp' || $type !~ /query|hit|subject|sbjct|total/); \n    $type = 'hit' if $type =~ /sbjct|subject/;\n\t\n\tif ($type eq 'total') {\n\t\treturn scalar($self->seq_inds('hit', 'gap')) + scalar($self->seq_inds('query', 'gap'));\n\t}\n\treturn scalar($self->seq_inds($type, 'gap'));\n}\n\n=head2 query_string\n\n Title   : query_string\n Usage   : my $qseq = $hsp->query_string;\n Function: Retrieves the query sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub query_string {\n\treturn shift->get_field('query_string');\n}\n\n=head2 hit_string\n\n Title   : hit_string\n Usage   : my $hseq = $hsp->hit_string;\n Function: Retrieves the hit sequence of this HSP as a string\n Returns : string\n Args    : none\n\n\nsub hit_string {\n\treturn shift->get_field('hit_string');\n}\n\n=head2 homology_string\n\n Title   : homology_string\n Usage   : my $homo_string = $hsp->homology_string;\n Function: Retrieves the homology sequence for this HSP as a string.\n         : The homology sequence is the string of symbols in between the \n         : query and hit sequences in the alignment indicating the degree\n         : of conservation (e.g., identical, similar, not similar).\n Returns : string\n Args    : none\n\n\nsub homology_string {\n\treturn shift->get_field('homology_string');\n}\n\n=head2 length\n\n Title    : length\n Usage    : my $len = $hsp->length( ['query'|'hit'|'total'] );\n Function : Returns the length of the query or hit in the alignment (without gaps) \n            or the aggregate length of the HSP (including gaps;\n            this may be greater than either hit or query )\n Returns  : integer\n Args     : 'query' = length of query seq (without gaps)\n            'hit'   = length of hit seq (without gaps)\n            'total' = length of alignment (with gaps)\n            default = 'total' \n Args    : none\n\n\nsub length {\n    my ($self, $type) = @_;\n    $type = 'total' unless defined $type;\n    $type = lc $type;\n\n    if ($type =~ /^q/i) {\n        return $self->query->length;\n    }\n\telsif ($type =~ /^(hit|subject|sbjct)/) {\n        return $self->hit->length;\n    }\n\telse { \n        return $self->hit->length + $self->gaps('hit');\n\t}\n}\n\n=head2 hsp_length\n\n Title   : hsp_length\n Usage   : my $len = $hsp->hsp_length()\n Function: shortcut  length('hsp')\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub hsp_length {\n\treturn shift->length('total');\n}\n\n=head2 percent_identity\n\n Title   : percent_identity\n Usage   : my $percentid = $hsp->percent_identity()\n Function: Returns the calculated percent identity for an HSP\n Returns : floating point between 0 and 100 \n Args    : none\n\n\nsub percent_identity{\n\tmy ($self) = @_;\n\treturn $self->frac_identical('hsp') * 100;   \n}\n\n=head2 get_aln\n\n Title   : get_aln\n Usage   : my $aln = $hsp->get_aln\n Function: Returns a Bio::SimpleAlign representing the HSP alignment\n Returns : Bio::SimpleAlign\n Args    : none\n\n\nsub get_aln {\n\tmy $self = shift;\n\t\n    require Bio::LocatableSeq;\n    require Bio::SimpleAlign;\n    my $aln = Bio::SimpleAlign->new();\n    my $hs = $self->seq('hit');\n    my $qs = $self->seq('query');\n\tif ($hs && $qs) {\n\t\t$aln->add_seq($hs);\n\t\t$aln->add_seq($qs);\n\t\treturn $aln;\n\t}\n\treturn;\n}\n\n=head2 seq_inds\n\n Title   : seq_inds\n Purpose   : Get a list of residue positions (indices) for all identical \n           : or conserved residues in the query or sbjct sequence.\n Example   : @s_ind = $hsp->seq_inds('query', 'identical');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved');\n           : @h_ind = $hsp->seq_inds('hit', 'conserved', 1);\n Returns   : List of integers \n           : May include ranges if collapse is true.\n Argument  : seq_type  = 'query' or 'hit' or 'sbjct'  (default = query)\n              ('sbjct' is synonymous with 'hit') \n             class     = 'identical' or 'conserved' or 'nomatch' or 'gap'\n                          (default = identical)\n                          (can be shortened to 'id' or 'cons')\n\t\t                  Note that 'conserved' includes identical unless you\n\t\t                  use 'conserved-not-identical'\n\n             collapse  = boolean, if true, consecutive positions are merged\n                         using a range notation, e.g., \"1 2 3 4 5 7 9 10 11\" \n                         collapses to \"1-5 7 9-11\". This is useful for \n                         consolidating long lists. Default = no collapse.\n Throws    : n/a.\n Comments  : \n\nSee Also   : L<Bio::Search::BlastUtils::collapse_nums()|Bio::Search::BlastUtils>, L<Bio::Search::Hit::HitI::seq_inds()|Bio::Search::Hit::HitI>\n\n\nsub seq_inds {\n    my ($self, $seqType, $class, $collapse) = @_;\n    \n    $seqType ||= 'query';\n    $class ||= 'identical';\n    $collapse ||= 0;\n    $seqType = lc($seqType);\n    $class = lc($class);\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    \n    my $t = substr($seqType,0,1);\n    if ($t eq 'q') {\n        $seqType = 'query';\n    }\n    elsif ($t eq 's' || $t eq 'h') {\n        $seqType = 'hit';\n    }\n    else { \n        $self->warn(\"unknown seqtype $seqType using 'query'\");\n        $seqType = 'query';\n    }\n    \n    $t = substr($class,0,1);\n    if ($t eq 'c') {\n        if ($class eq 'conserved-not-identical') {\n            $class = 'conserved';\n        }\n        else { \n            $class = 'conservedall';\n        }\n    }\n    elsif ($t eq 'i') {\n        $class = 'identical';\n    }\n    elsif ($t eq 'n') {\n        $class = 'nomatch';\n    }\n    elsif ($t eq 'g') {\n        $class = 'gap';\n    }\n    else { \n        $self->warn(\"unknown sequence class $class using 'identical'\");\n        $class = 'identical';\n    }\n    \n    $seqType .= '_';\n    $class .= '_inds';\n    \n    my @ary;\n    if ($class eq 'conservedall_inds') {\n\t\tmy %tmp = map { $_, 1 } @{$self->get_field($seqType.'conserved_inds')},\n\t\t\t\t\t\t\t\t@{$self->get_field($seqType.'identical_inds')};\n\t\t@ary = sort {$a <=> $b} keys %tmp;\n    }\n    else { \n        @ary = @{$self->get_field($seqType.$class)};\n    }\n    \n    return $collapse ? &Bio::Search::SearchUtils::collapse_nums(@ary) : @ary;\n}\n\n=head2 Inherited from L<Bio::SeqFeature::SimilarityPair>\n\nThese methods come from L<Bio::SeqFeature::SimilarityPair>\n\n=head2 query\n\n Title   : query\n Usage   : my $query = $hsp->query\n Function: Returns a SeqFeature representing the query in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 hit\n\n Title   : hit\n Usage   : my $hit = $hsp->hit\n Function: Returns a SeqFeature representing the hit in the HSP\n Returns : Bio::SeqFeature::Similarity\n Args    : [optional] new value to set\n\n\n=head2 significance\n\n Title   : significance\n Usage   : $evalue = $obj->significance();\n           $obj->significance($evalue);\n Function: Get/Set the significance value (see Bio::SeqFeature::SimilarityPair)\n Returns : significance value (scientific notation string)\n Args    : significance value (sci notation string)\n\n\nsub significance {\n\treturn shift->get_field('evalue');\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score = $hsp->score();\n Function: Returns the score for this HSP or undef \n Returns : numeric           \n Args    : [optional] numeric to set value\n\n\nsub score {\n\treturn shift->get_field('score');\n}\n\n=head2 bits\n\n Title   : bits\n Usage   : my $bits = $hsp->bits();\n Function: Returns the bit value for this HSP or undef \n Returns : numeric\n Args    : none\n\n\nsub bits {\n\treturn shift->get_field('bits');\n}\n\n# override \n\n=head2 strand\n\n Title   : strand\n Usage   : $hsp->strand('query')\n Function: Retrieves the strand for the HSP component requested\n Returns : +1 or -1 (0 if unknown)\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the strand of the subject\n           'query' to retrieve the query strand (default)\n           'list' or 'array' to retreive both query and hit together\n\n\nsub strand {\n    my $self = shift;\n    my $val = shift;\n    $val = 'query' unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) {\n        return $self->query->strand(@_);\n    }\n    elsif ($val =~ /^hi|^s/i) {\n        return $self->hit->strand(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->strand(@_), $self->hit->strand(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 start\n\n Title   : start\n Usage   : $hsp->start('query')\n Function: Retrieves the start for the HSP component requested\n Returns : integer, or list of two integers (query start and subject start) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the start of the subject\n           'query' to retrieve the query start (default)\n\n\nsub start {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->start(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->start(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->start(@_), $self->hit->start(@_) );\n    }\n    else { \n        $self->warn(\"unrecognized component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 end\n\n Title   : end\n Usage   : $hsp->end('query')\n Function: Retrieves the end for the HSP component requested\n Returns : integer, or list of two integers (query end and subject end) in\n           list context\n Args    : 'hit' or 'subject' or 'sbjct' to retrieve the end of the subject\n           'query' to retrieve the query end (default)\n\n\nsub end {\n    my $self = shift;\n    my $val = shift;\n    $val = (wantarray ? 'list' : 'query') unless defined $val;\n    $val =~ s/^\\s+//;\n\n    if ($val =~ /^q/i) { \n        return $self->query->end(@_);\n    }\n    elsif ($val =~ /^(hi|s)/i) {\n        return $self->hit->end(@_);\n    }\n    elsif ($val =~ /^list|array/i) {\n        return ($self->query->end(@_), $self->hit->end(@_) );\n    }\n    else {\n        $self->warn(\"unrecognized end component '$val' requested\\n\");\n    }\n    return 0;\n}\n\n=head2 seq\n\n Usage     : $hsp->seq( [seq_type] );\n Purpose   : Get the query or sbjct sequence as a Bio::Seq.pm object.\n Example   : $seqObj = $hsp->seq('query');\n Returns   : Object reference for a Bio::LocatableSeq object.\n Argument  : seq_type = 'query' or 'hit' or 'sbjct' (default = 'query').\n           : ('sbjct' is synonymous with 'hit') \n           : default is 'query'\n\n\nsub seq {\n    my ($self, $seqType) = @_; \n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n    if ($seqType =~ /^(m|ho)/i ) {\n        $self->throw(\"cannot call seq on the homology match string, it isn't really a sequence, use get_aln to convert the HSP to a Bio::AlignIO and generate a consensus from that.\");\n    }\n\t\n    my $str = $self->seq_str($seqType) || return;\n    require Bio::LocatableSeq;\n    my $id = ($seqType =~ /^q/i) ? $self->query->seq_id : $self->hit->seq_id;\n    return Bio::LocatableSeq->new(  -ID        => $id,\n                                    -SEQ       => $str,\n                                    -START     => $self->start($seqType),\n                                    -END       => $self->end($seqType),\n                                    -STRAND    => $self->strand($seqType),\n                                    -FORCE_NSE => $id ? 0 : 1,\n                                    -DESC      => \"$seqType sequence \" );\n\n}\n\n=head2 seq_str\n\n Usage     : $hsp->seq_str( seq_type );\n Purpose   : Get the full query, sbjct, or 'match' sequence as a string.\n           : The 'match' sequence is the string of symbols in between the \n           : query and sbjct sequences.\n Example   : $str = $hsp->seq_str('query');\n Returns   : String\n Argument  : seq_Type = 'query' or 'hit' or 'sbjct' or 'match'\n           :  ('sbjct' is synonymous with 'hit')\n           : default is 'query'\n Throws    : Exception if the argument does not match an accepted seq_type.\n Comments  : \n\nSee Also   : L<seq()|seq>, L<seq_inds()|seq_inds>, B<_set_match_seq()>\n\n\nsub seq_str {  \n    my $self = shift;\n    my $type = shift || 'query';\n\n    if ($type =~ /^q/i) {\n        return $self->query_string(@_);\n    }\n    elsif ($type =~ /^(s)|(hi)/i) {\n        return $self->hit_string(@_);\n    }\n    elsif ($type =~ /^(ho)|(ma)/i) {\n        return $self->homology_string(@_);\n    }\n    else { \n        $self->warn(\"unknown sequence type $type\");\n    }\n    return '';\n}\n\n=head2 rank\n\n Usage     : $hsp->rank( [string] );\n Purpose   : Get the rank of the HSP within a given Blast hit.\n Example   : $rank = $hsp->rank;\n Returns   : Integer (1..n) corresponding to the order in which the HSP\n             appears in the BLAST report.\n\n\nsub rank {\n    return shift->get_field('rank');\n}\n\n=head2 matches\n\n Usage     : $hsp->matches(-seq   => 'hit'|'query', \n                           -start => $start, \n                           -stop  => $stop);\n Purpose   : Get the total number of identical and conservative matches \n           : in the query or sbjct sequence for the given HSP. Optionally can\n           : report data within a defined interval along the seq.\n Example   : ($id,$cons) = $hsp_object->matches(-seq   => 'hit');\n           : ($id,$cons) = $hsp_object->matches(-seq   => 'query',\n                                                -start => 300,\n                                                -stop  => 400);\n Returns   : 2-element array of integers \n Argument  : (1) seq_type = 'query' or 'hit' or 'sbjct' (default = query)\n           :  ('sbjct' is synonymous with 'hit') \n           : (2) start = Starting coordinate (optional)\n           : (3) stop  = Ending coordinate (optional)\n\n\nsub matches {\n    my ($self, @args) = @_;\n    my($seqType, $beg, $end) = $self->_rearrange([qw(SEQ START STOP)], @args);\n    $seqType ||= 'query';\n    $seqType = 'hit' if $seqType eq 'sbjct';\n\t\n    my @data;\n    if ((!defined $beg && !defined $end) || ! $self->seq_str('match')) {\n        push @data, ($self->num_identical, $self->num_conserved);\n    }\n\telse {\n        $beg ||= 0;\n        $end ||= 0;\n        my ($start, $stop) = $self->range($seqType);\n\t\t\n        if ($beg == 0) {\n\t\t\t$beg = $start;\n\t\t\t$end = $beg+$end;\n\t\t}\n        elsif ($end == 0) {\n\t\t\t$end = $stop;\n\t\t\t$beg = $end-$beg;\n\t\t}\n\t\t\n        if ($end >= $stop) {\n\t\t\t$end = $stop;\n\t\t}\n        else {\n\t\t\t$end += 1;\n\t\t}\n        if ($beg < $start) {\n\t\t\t$beg = $start;\n\t\t}\n        \n        my $seq = substr($self->seq_str('homology'), $beg-$start, ($end-$beg));\n        \n        if (!CORE::length $seq) {\n            $self->throw(\"Undefined sub-sequence ($beg,$end). Valid range = $start - $stop\");\n        }\n        ## Get data for a substring.\n        $seq =~ s/ //g;  # remove space (no info).\n        my $len_cons = CORE::length $seq;\n        $seq =~ s/\\+//g;  # remove '+' characters (conservative substitutions)\n        my $len_id = CORE::length $seq;\n        push @data, ($len_id, $len_cons);\n    }\n\t\n    return @data;\n}\n\n=head2 n\n\n Usage     : $hsp_obj->n()\n Purpose   : Get the N value (num HSPs on which P/Expect is based).\n Returns   : Integer or null string if not defined.\n Argument  : n/a\n Throws    : n/a\n Comments  : The 'N' value is listed in parenthesis with P/Expect value:\n           : e.g., P(3) = 1.2e-30  ---> (N = 3).\n           : Not defined in NCBI Blast2 with gaps.\n           : This typically is equal to the number of HSPs but not always.\n\n\nsub n {\n    return shift->get_field('num_hsps');\n}\n\n=head2 range\n\n Usage     : $hsp->range( [seq_type] );\n Purpose   : Gets the (start, end) coordinates for the query or sbjct sequence\n           : in the HSP alignment.\n Example   : ($query_beg, $query_end) = $hsp->range('query');\n           : ($hit_beg, $hit_end) = $hsp->range('hit');\n Returns   : Two-element array of integers \n Argument  : seq_type = string, 'query' or 'hit' or 'sbjct'  (default = 'query')\n           :  ('sbjct' is synonymous with 'hit') \n Throws    : n/a\n Comments  : This is a convenience method for constructions such as\n             ($hsp->query->start, $hsp->query->end)","label":"range($self,$seqType)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":947},"start":{"character":0,"line":933}},"name":"range"}]}