{"version":5,"vars":[{"containerName":"","name":"base","line":85,"kind":2},{"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FastaHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::FastaHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::FastaHSP - HSP object for FASTA specific data\n\n=head1 SYNOPSIS\n\n  # get a FastaHSP from a SearchIO stream\n  my $in = Bio::SearchIO->new(-format => 'fasta', -file => 'filename.fasta');\n\n  while( my $r = $in->next_result) {\n      while( my $hit = $r->next_result ) {\n           while( my $hsp = $hit->next_hsp ) {\n              print \"smith-waterman score (if available): \", \n                    $hsp->sw_score(),\"\\n\";\n           }\n      }\n  }\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::FastaHSP;\nuse strict;\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::FastaHSP->new();\n Function: Builds a new Bio::Search::HSP::FastaHSP object \n Returns : Bio::Search::HSP::FastaHSP\n Args    : -swscore => smith-waterman score"},"containerName":"main::","definition":"sub","line":97,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":98,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":98},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":100,"kind":13},{"kind":13,"line":100,"containerName":"new","name":"$class"},{"line":100,"kind":13,"containerName":"new","name":"@args"},{"name":"$swscore","definition":"my","containerName":"new","localvar":"my","kind":13,"line":102},{"name":"$self","containerName":"new","kind":13,"line":102},{"line":102,"kind":12,"containerName":"new","name":"_rearrange"},{"line":102,"kind":13,"name":"@args","containerName":"new"},{"name":"$swscore","containerName":"new","line":104,"kind":13},{"line":104,"kind":13,"containerName":"new","name":"$self"},{"line":104,"kind":12,"name":"sw_score","containerName":"new"},{"kind":13,"line":104,"containerName":"new","name":"$swscore"},{"kind":13,"line":106,"containerName":"new","name":"$self"}],"kind":12,"range":{"end":{"character":9999,"line":107},"start":{"line":97,"character":0}},"name":"new"},{"line":100,"kind":12,"name":"SUPER","containerName":"new"},{"definition":"sub","containerName":"main::","signature":{"label":"sw_score($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: FastaHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::FastaHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::FastaHSP - HSP object for FASTA specific data\n\n=head1 SYNOPSIS\n\n  # get a FastaHSP from a SearchIO stream\n  my $in = Bio::SearchIO->new(-format => 'fasta', -file => 'filename.fasta');\n\n  while( my $r = $in->next_result) {\n      while( my $hit = $r->next_result ) {\n           while( my $hsp = $hit->next_hsp ) {\n              print \"smith-waterman score (if available): \", \n                    $hsp->sw_score(),\"\\n\";\n           }\n      }\n  }\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::FastaHSP;\nuse strict;\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::FastaHSP->new();\n Function: Builds a new Bio::Search::HSP::FastaHSP object \n Returns : Bio::Search::HSP::FastaHSP\n Args    : -swscore => smith-waterman score\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  \n  my ($swscore) = $self->_rearrange([qw(SWSCORE)], @args);\n\n  defined $swscore && $self->sw_score($swscore);\n\n  return $self;\n}\n\n\n=head2 sw_score\n\n Title   : sw_score\n Usage   : $obj->sw_score($newval)\n Function: Get/Set Smith-Waterman score\n Returns : value of sw_score\n Args    : newvalue (optional)"},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"sw_score","localvar":"my","kind":13,"line":122},{"line":122,"kind":13,"name":"$value","containerName":"sw_score"},{"kind":13,"line":123,"containerName":"sw_score","name":"$value"},{"line":123,"kind":13,"containerName":"sw_score","name":"$self"},{"containerName":"sw_score","name":"$value","line":124,"kind":13},{"containerName":"sw_score","name":"$value","line":124,"kind":13},{"containerName":"sw_score","name":"$self","line":125,"kind":13},{"kind":13,"line":125,"containerName":"sw_score","name":"$value"},{"kind":13,"line":127,"name":"$self","containerName":"sw_score"}],"line":121,"name":"sw_score","range":{"start":{"line":121,"character":0},"end":{"line":128,"character":9999}}},{"children":[{"line":132,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_aln"},{"localvar":"my","containerName":"get_aln","name":"$aln","definition":"my","line":135,"kind":13},{"line":135,"kind":12,"name":"new","containerName":"get_aln"},{"kind":13,"line":136,"name":"$hs","definition":"my","containerName":"get_aln","localvar":"my"},{"line":136,"kind":13,"containerName":"get_aln","name":"$self"},{"containerName":"get_aln","name":"hit_string","kind":12,"line":136},{"kind":13,"line":137,"name":"$qs","definition":"my","containerName":"get_aln","localvar":"my"},{"name":"$self","containerName":"get_aln","line":137,"kind":13},{"line":137,"kind":12,"containerName":"get_aln","name":"query_string"},{"line":152,"kind":13,"localvar":"my","containerName":"get_aln","name":"$start","definition":"my"},{"containerName":"get_aln","name":"$rest","kind":13,"line":152},{"kind":13,"line":153,"containerName":"get_aln","name":"$self"},{"containerName":"get_aln","name":"homology_string","line":153,"kind":12},{"containerName":"get_aln","name":"$start","line":154,"kind":13},{"kind":13,"line":154,"name":"$rest","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","kind":13,"line":156},{"containerName":"get_aln","name":"debug","kind":12,"line":156},{"containerName":"get_aln","name":"$self","line":157,"kind":13},{"name":"debug","containerName":"get_aln","kind":12,"line":157},{"name":"$hs","containerName":"get_aln","line":159,"kind":13},{"containerName":"get_aln","name":"$hs","line":159,"kind":13},{"name":"$start","containerName":"get_aln","kind":13,"line":159},{"line":159,"kind":13,"name":"$rest","containerName":"get_aln"},{"kind":13,"line":160,"containerName":"get_aln","name":"$qs"},{"name":"$qs","containerName":"get_aln","line":160,"kind":13},{"name":"$start","containerName":"get_aln","kind":13,"line":160},{"containerName":"get_aln","name":"$rest","kind":13,"line":160},{"kind":13,"line":162,"name":"$seqonly","definition":"my","containerName":"get_aln","localvar":"my"},{"containerName":"get_aln","name":"$qs","line":162,"kind":13},{"name":"$seqonly","containerName":"get_aln","kind":13,"line":163},{"name":"$q_nm","definition":"my","containerName":"get_aln","localvar":"my","kind":13,"line":164},{"kind":13,"line":164,"name":"$s_nm","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","kind":13,"line":164},{"name":"query","containerName":"get_aln","line":164,"kind":12},{"kind":12,"line":164,"name":"seq_id","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","kind":13,"line":165},{"line":165,"kind":12,"name":"hit","containerName":"get_aln"},{"line":165,"kind":12,"name":"seq_id","containerName":"get_aln"},{"kind":13,"line":166,"name":"$q_nm","containerName":"get_aln"},{"containerName":"get_aln","name":"$q_nm","kind":13,"line":166},{"line":167,"kind":13,"name":"$q_nm","containerName":"get_aln"},{"name":"$s_nm","containerName":"get_aln","kind":13,"line":169},{"kind":13,"line":169,"name":"$s_nm","containerName":"get_aln"},{"containerName":"get_aln","name":"$s_nm","kind":13,"line":170},{"name":"$self","containerName":"get_aln","line":172,"kind":13},{"containerName":"get_aln","name":"_calculate_seq_positions","line":172,"kind":12},{"localvar":"my","name":"$query","definition":"my","containerName":"get_aln","line":173,"kind":13},{"name":"new","containerName":"get_aln","line":173,"kind":12},{"containerName":"get_aln","name":"$seqonly","line":173,"kind":13},{"containerName":"get_aln","name":"$q_nm","line":174,"kind":13},{"name":"$self","containerName":"get_aln","line":175,"kind":13},{"containerName":"get_aln","name":"query","line":175,"kind":12},{"name":"start","containerName":"get_aln","line":175,"kind":12},{"name":"$self","containerName":"get_aln","line":176,"kind":13},{"containerName":"get_aln","name":"query","line":176,"kind":12},{"containerName":"get_aln","name":"end","line":176,"kind":12},{"line":177,"kind":13,"name":"$self","containerName":"get_aln"},{"containerName":"get_aln","name":"$self","kind":13,"line":178},{"kind":13,"line":179,"containerName":"get_aln","name":"$self"},{"line":180,"kind":13,"containerName":"get_aln","name":"$self"},{"containerName":"get_aln","name":"verbose","line":181,"kind":12},{"containerName":"get_aln","name":"$seqonly","line":182,"kind":13},{"name":"$hs","containerName":"get_aln","line":182,"kind":13},{"name":"$seqonly","containerName":"get_aln","kind":13,"line":183},{"containerName":"get_aln","definition":"my","name":"$hit","localvar":"my","kind":13,"line":184},{"name":"new","containerName":"get_aln","kind":12,"line":184},{"kind":13,"line":184,"name":"$seqonly","containerName":"get_aln"},{"kind":13,"line":185,"name":"$s_nm","containerName":"get_aln"},{"containerName":"get_aln","name":"$self","line":186,"kind":13},{"name":"hit","containerName":"get_aln","kind":12,"line":186},{"containerName":"get_aln","name":"start","line":186,"kind":12},{"line":187,"kind":13,"name":"$self","containerName":"get_aln"},{"containerName":"get_aln","name":"hit","line":187,"kind":12},{"line":187,"kind":12,"name":"end","containerName":"get_aln"},{"kind":13,"line":188,"name":"$self","containerName":"get_aln"},{"name":"$self","containerName":"get_aln","line":189,"kind":13},{"line":190,"kind":13,"containerName":"get_aln","name":"$self"},{"containerName":"get_aln","name":"$self","line":191,"kind":13},{"name":"verbose","containerName":"get_aln","line":192,"kind":12},{"kind":13,"line":193,"name":"$aln","containerName":"get_aln"},{"line":193,"kind":12,"containerName":"get_aln","name":"add_seq"},{"kind":13,"line":193,"containerName":"get_aln","name":"$query"},{"name":"$aln","containerName":"get_aln","line":194,"kind":13},{"kind":12,"line":194,"name":"add_seq","containerName":"get_aln"},{"name":"$hit","containerName":"get_aln","kind":13,"line":194},{"kind":13,"line":195,"name":"$aln","containerName":"get_aln"}],"line":131,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"get_aln($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":196},"start":{"character":0,"line":131}},"name":"get_aln"},{"line":135,"kind":12,"name":"Bio","containerName":"LocatableSeq::Bio::SimpleAlign"},{"name":"Bio","containerName":"SimpleAlign","kind":12,"line":135},{"name":"CORE","containerName":"length","line":154,"kind":12},{"kind":12,"line":154,"containerName":"length","name":"CORE"},{"line":166,"kind":12,"name":"CORE","containerName":"length"},{"containerName":"length","name":"CORE","line":169,"kind":12},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":173},{"name":"seqinds","kind":12,"line":177},{"kind":12,"line":177,"name":"_frameshiftRes_query"},{"line":178,"kind":12,"name":"seqinds"},{"name":"_frameshiftRes_query","line":178,"kind":12},{"name":"_query_mapping","kind":12,"line":179},{"name":"Bio","containerName":"LocatableSeq","line":184,"kind":12},{"line":188,"kind":12,"name":"seqinds"},{"name":"_frameshiftRes_sbjct","line":188,"kind":12},{"name":"seqinds","line":189,"kind":12},{"name":"_frameshiftRes_sbjct","line":189,"kind":12},{"name":"_hit_mapping","kind":12,"line":190}]}