{"version":5,"vars":[{"line":116,"kind":2,"name":"vars","containerName":""},{"line":117,"kind":2,"containerName":"","name":"base"},{"name":"%FORMAT","containerName":null,"kind":13,"line":119},{"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"new","line":149,"kind":13},{"name":"%param","containerName":"new","kind":13,"line":149},{"name":"$format","definition":"my","containerName":"new","localvar":"my","kind":13,"line":150},{"kind":13,"line":152,"name":"@param","containerName":"new"},{"kind":13,"line":152,"name":"%param","containerName":"new"},{"containerName":"new","name":"%param","line":152,"kind":13},{"kind":13,"line":153,"name":"$format","containerName":"new"},{"containerName":"new","name":"$FORMAT","line":153,"kind":13},{"line":153,"kind":13,"name":"$param","containerName":"new"},{"line":153,"kind":13,"name":"$param","containerName":"new"},{"line":154,"kind":13,"name":"$format","containerName":"new"},{"line":154,"kind":13,"name":"$class","containerName":"new"},{"name":"_guess_format","containerName":"new","line":154,"kind":12},{"name":"$param","containerName":"new","line":154,"kind":13},{"line":154,"kind":13,"name":"$ARGV","containerName":"new"},{"line":156,"kind":13,"containerName":"new","name":"$format"},{"kind":13,"line":158,"name":"$class","containerName":"new"},{"kind":12,"line":158,"name":"_load_format_module","containerName":"new"},{"containerName":"new","name":"$format","line":158,"kind":13},{"kind":12,"line":159,"name":"new","containerName":"new"},{"containerName":"new","name":"%param","kind":13,"line":159}],"line":148,"kind":12,"signature":{"label":"new($class,%param)","documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to","parameters":[{"label":"$class"},{"label":"%param"}]},"detail":"($class,%param)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":160},"start":{"line":148,"character":0}},"name":"new"},{"signature":{"label":"_load_format_module($class,$format)","documentation":"","parameters":[{"label":"$class"},{"label":"$format"}]},"detail":"($class,$format)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$class","line":164,"kind":13},{"kind":13,"line":164,"name":"$format","containerName":"_load_format_module"},{"kind":13,"line":165,"definition":"my","name":"$module","containerName":"_load_format_module","localvar":"my"},{"name":"$format","containerName":"_load_format_module","kind":13,"line":165},{"containerName":"_load_format_module","definition":"my","name":"$ok","localvar":"my","kind":13,"line":166},{"kind":13,"line":168,"containerName":"_load_format_module","name":"$ok"},{"kind":13,"line":168,"name":"$class","containerName":"_load_format_module"},{"containerName":"_load_format_module","name":"_load_module","line":168,"kind":12},{"containerName":"_load_format_module","name":"$module","kind":13,"line":168},{"kind":13,"line":179,"name":"$ok","containerName":"_load_format_module"}],"line":163,"kind":12,"range":{"start":{"line":163,"character":0},"end":{"character":9999,"line":180}},"name":"_load_format_module"},{"range":{"end":{"line":195,"character":9999},"start":{"character":0,"line":192}},"name":"read","children":[{"kind":13,"line":193,"containerName":"read","name":"$self","definition":"my","localvar":"my"},{"containerName":"read","name":"$seq","line":193,"kind":13},{"kind":13,"line":194,"containerName":"read","name":"$self"},{"kind":12,"line":194,"name":"throw_not_implemented","containerName":"read"}],"line":192,"kind":12,"signature":{"label":"read($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $FORMAT{$param{'-format'}} if defined $param{'-format'};\n   $format ||= $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'base';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Restriction::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Restriction::IO::\" . $format;\n  my $ok;\n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::EnzymeCollection object\n Args    :"},"detail":"($self,$seq)","definition":"sub","containerName":"main::"},{"name":"next","range":{"end":{"line":200,"character":9999},"start":{"line":197,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$seq)","signature":{"label":"next($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":""},"kind":12,"line":197,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next","line":198,"kind":13},{"name":"$seq","containerName":"next","kind":13,"line":198},{"kind":13,"line":199,"containerName":"next","name":"$self"},{"containerName":"next","name":"throw_not_implemented","line":199,"kind":12}]},{"line":202,"children":[{"containerName":"next_seq","definition":"my","name":"$self","localvar":"my","kind":13,"line":203},{"kind":13,"line":203,"name":"$seq","containerName":"next_seq"},{"containerName":"next_seq","name":"$self","kind":13,"line":204},{"containerName":"next_seq","name":"throw_not_implemented","line":204,"kind":12}],"kind":12,"detail":"($self,$seq)","signature":{"label":"next_seq($self,$seq)","parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"start":{"line":202,"character":0},"end":{"line":205,"character":9999}},"name":"next_seq"},{"kind":12,"line":217,"children":[{"line":218,"kind":13,"localvar":"my","containerName":"write","name":"$self","definition":"my"},{"kind":13,"line":218,"containerName":"write","name":"$seq"},{"name":"$self","containerName":"write","kind":13,"line":219},{"kind":12,"line":219,"containerName":"write","name":"throw"}],"containerName":"main::","definition":"sub","detail":"($self,$seq)","signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Restriction::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# Copyright Rob Edwards\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Restriction::IO - Handler for sequence variation IO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::Restriction::IO;\n\n    $in  = Bio::Restriction::IO->new(-file => \"inputfilename\" ,\n                                     -format => 'withrefm');\n    my $res = $in->read; # a Bio::Restriction::EnzymeCollection\n\n=head1 DESCRIPTION\n\nL<Bio::Restriction::IO> is a handler module for the formats in the\nRestriction IO set, e.g. C<Bio::Restriction::IO::xxx>. It is the\nofficially sanctioned way of getting at the format objects, which most\npeople should use.\n\nThe structure, conventions and most of the code is inherited from\nL<Bio::SeqIO>. The main difference is that instead of using methods\nC<next_seq>, you drop C<_seq> from the method name.\n\nAlso, instead of dealing only with individual L<Bio::Restriction::Enzyme>\nobjects, C<read()> will slurp in all enzymes into a \nL<Bio::Restriction::EnzymeCollection> object.\n\nFor more details, see documentation in L<Bio::SeqIO>.\n\n=head1 TO DO\n\nAt the moment, these can be use mainly to get a custom set if enzymes in\nC<withrefm> or C<itype2> formats into L<Bio::Restriction::Enzyme> or\nL<Bio::Restriction::EnzymeCollection> objects.  Using C<bairoch> format is\nhighly experimental and is not recommmended at this time.\n\nThis class inherits from L<Bio::SeqIO> for convenience sake, though this should\ninherit from L<Bio::Root::Root>.  Get rid of L<Bio::SeqIO> inheritance by\ncopying relevant methods in.\n\nC<write()> methods are currently not implemented for any format except C<base>.\nUsing C<write()> even with C<base> format is not recommended as it does not\nsupport multicut/multisite enzyme output.\n\nShould additional formats be supported (such as XML)?\n\n=head1 SEE ALSO\n\nL<Bio::SeqIO>, \nL<Bio::Restriction::Enzyme>, \nL<Bio::Restriction::EnzymeCollection>\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Restriction::IO;\n\nuse strict;\nuse vars qw(%FORMAT);\nuse base qw(Bio::SeqIO);\n\n%FORMAT = (\n            'itype2'    => 'itype2',\n            '8'         => 'itype2',\n            'withrefm'  => 'withrefm',\n            '31'        => 'withrefm',\n            'base'      => 'base',\n            '0'         => 'base',\n            'bairoch'   => 'bairoch',\n            '19'        => 'bairoch',\n            'macvector' => 'bairoch',\n            'vectorNTI' => 'bairoch',\n            'neo'       => 'prototype',\n            'prototype' => 'prototype'\n);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::Restriction::IO->new(-file => $filename,\n                                               -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::Restriction::IO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n\n\nsub new {\n   my ($class, %param) = @_;\n   my ($format);\n\n   @param{ map { lc $_ } keys %param } = values %param;  # lowercase keys\n   $format = $FORMAT{$param{'-format'}} if defined $param{'-format'};\n   $format ||= $class->_guess_format( $param{-file} || $ARGV[0] )\n             || 'base';\n   $format = \"\\L$format\"; # normalize capitalization to lower case\n\n   return unless $class->_load_format_module($format);\n   return \"Bio::Restriction::IO::$format\"->new(%param);\n}\n\n\nsub _load_format_module {\n  my ($class, $format) = @_;\n  my $module = \"Bio::Restriction::IO::\" . $format;\n  my $ok;\n  eval {\n      $ok = $class->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$class: $format cannot be found\nException $@\nFor more information about the IO system please see the IO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n  }\n  return $ok;\n}\n\n=head2 read\n\n Title   : read\n Usage   : $renzs = $stream->read\n Function: reads all the restrction enzymes from the stream\n Returns : a Bio::Restriction::EnzymeCollection object\n Args    :\n\n\nsub read {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\nsub next {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\nsub next_seq {\n   my ($self, $seq) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write\n\n Title   : write\n Usage   : $stream->write($seq)\n Function: writes the $seq object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Restriction::EnzymeCollection object","label":"write($self,$seq)"},"name":"write","range":{"end":{"line":221,"character":9999},"start":{"line":217,"character":0}}},{"range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":228}},"name":"write_seq","detail":"($self,$seq)","signature":{"label":"write_seq($self,$seq)","documentation":"","parameters":[{"label":"$self"},{"label":"$seq"}]},"containerName":"main::","definition":"sub","line":223,"children":[{"definition":"my","name":"$self","containerName":"write_seq","localvar":"my","kind":13,"line":224},{"kind":13,"line":224,"containerName":"write_seq","name":"$seq"},{"kind":13,"line":225,"containerName":"write_seq","name":"$self"},{"kind":12,"line":225,"containerName":"write_seq","name":"warn"},{"line":227,"kind":13,"containerName":"write_seq","name":"$self"},{"name":"write","containerName":"write_seq","kind":12,"line":227},{"name":"$seq","containerName":"write_seq","line":227,"kind":13}],"kind":12},{"range":{"start":{"character":0,"line":241},"end":{"line":246,"character":9999}},"containerName":"main::","definition":"sub","name":"_guess_format","line":241,"children":[{"kind":13,"line":242,"containerName":"_guess_format","definition":"my","name":"$class","localvar":"my"}],"kind":12}]}