{"vars":[{"kind":2,"line":160,"containerName":"","name":"UNIVERSAL"},{"name":"base","containerName":"","line":164,"kind":2},{"detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: EnzymeCollection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#-------------------------------------------------------------------------------\n#\n# BioPerl module Bio::Restriction::EnzymeCollection\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Rob Edwards <redwards@utmem.edu>\n#\n# You may distribute this module under the same terms as perl itself\n#-------------------------------------------------------------------------------\n\n## POD Documentation:\n\n=head1 NAME\n\nBio::Restriction::EnzymeCollection - Set of restriction endonucleases\n\n=head1 SYNOPSIS\n\n  use Bio::Restriction::EnzymeCollection;\n\n  # Create a collection with the default enzymes.\n  my $default_collection = Bio::Restriction::EnzymeCollection->new();\n\n  # Or create a collection from a REBASE 'withrefm' file obtained from\n  # ftp://ftp.neb.com/pub/rebase/. (See Bio::Restriction::IO for more\n  # information.)\n  my $rebase = Bio::Restriction::IO->new(\n      -file   => 'withrefm.610',\n      -format => 'withrefm' );\n  my $rebase_collection = $rebase->read();\n\n  # Or create an empty collection and set the enzymes later. See\n  # 'CUSTOM COLLECTIONS' below for more information.\n  my $empty_collection =\n    Bio::Restriction::EnzymeCollection->new( -empty => 1 );\n\n  # Get an array of Bio::Restriction::Enzyme objects from the collection.\n  my @enzymes = $default_collection->each_enzyme();\n\n  # Get a Bio::Restriction::Enzyme object for a particular enzyme by name.\n  my $enz = $default_collection->get_enzyme( 'EcoRI' );\n\n  # Get a Bio::Restriction::EnzymeCollection object containing the enzymes\n  # that have the equivalent of 6-bp recognition sequences.\n  my $six_cutters = $default_collection->cutters( 6 );\n\n  # Get a Bio::Restriction::EnzymeCollection object containing the enzymes\n  # that are rare cutters.\n  my $rare_cutters = $default_collection->cutters( -start => 6, -end => 8 );\n\n  # Get a Bio::Restriction::EnzymeCollection object that contains enzymes\n  # that generate blunt ends:\n  my $blunt_cutters = $default_collection->blunt_enzymes();\n\n  # See 'CUSTOM COLLECTIONS' below for an example of creating a\n  # Bio::Restriction::EnzymeCollection object with a specified subset of\n  # enzymes using methods provided by the Bio::RestrictionEnzyme class.\n\n=head1 DESCRIPTION\n\nBio::Restriction::EnzymeCollection represents a collection of\nrestriction enzymes.\n\nIf you create a new collection directly rather than from a REBASE\nfile using L<Bio::Restriction::IO>, it will be populated by a\ndefault set of enzymes with site and cut information\nonly.\n\nUse L<Bio::Restriction::Analysis> to figure out which enzymes are\navailable and where they cut your sequence.\n\n=head1 CUSTOM COLLECTIONS\n\nNote that the underlying L<Bio::Restriction::Enzyme> objects have a rich\nvariety of methods that allow more complicated selections than the methods\nthat are defined by Bio::Restriction::EnzymeCollection.\n\nFor example, the way to create a custom collection of Type II enzymes\nis as follows:\n\n  my $complete_collection =\n      Bio::Restriction::EnzymeCollection->new();\n  my $type_ii_collection  =\n      Bio::Restriction::EnzymeCollection->new( -empty => 1 );\n  $type_ii_collection->enzymes(\n      grep { $_->type() eq 'II' } $complete_collection->each_enzyme() );\n\n=head1 SEE ALSO\n\nL<Bio::Restriction::IO> - read in enzymes from REBASE files\n\nL<Bio::Restriction::Analysis> - figure out what enzymes cut a sequence\n\nL<Bio::Restriction::Enzyme> - define a single restriction enzyme\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists \n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nRob Edwards, redwards@utmem.edu\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho, heikki-at-bioperl-dot-org\n\n=head1 COPYRIGHT\n\nCopyright (c) 2003 Rob Edwards.\n\nSome of this work is Copyright (c) 1997-2002 Steve A. Chervitz. All\nRights Reserved.\n\nThis module is free software; you can redistribute it and/or modify it\nunder the same terms as Perl itself.\n\n=head1 APPENDIX\n\nMethods beginning with a leading underscore are considered private and\nare intended for internal use by this module. They are not considered\npart of the public interface and are described here for documentation\npurposes only.\n\n\n\npackage Bio::Restriction::EnzymeCollection;\nuse strict;\n\nuse Bio::Restriction::Enzyme;\nuse Bio::Restriction::IO;\nuse UNIVERSAL qw(isa);\n\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title     : new\n Function  : Initializes the Restriction::EnzymeCollection object\n Returns   : The Restriction::EnzymeCollection object\n Arguments : optional named parameter -empty\n\nSet parameter -empty to true if you do NOT want the collection be\npopulated by the default set of prototype type II enzymes.\n\nAlternatively, pass an array of enzymes to -enzymes parameter.","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":180,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":181},{"containerName":"new","name":"@args","kind":13,"line":181},{"line":182,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":182},{"name":"@args","containerName":"new","kind":13,"line":182},{"containerName":"new","definition":"my","name":"$empty","localvar":"my","kind":13,"line":184},{"line":184,"kind":13,"name":"$enzymes","containerName":"new"},{"kind":13,"line":185,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":185},{"name":"@args","containerName":"new","line":189,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":191},{"line":192,"kind":13,"name":"$self","containerName":"new"},{"kind":13,"line":194,"name":"$self","containerName":"new"},{"kind":13,"line":194,"name":"$empty","containerName":"new"},{"name":"$enzymes","containerName":"new","kind":13,"line":197},{"line":199,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":199,"name":"throw","containerName":"new"},{"kind":13,"line":199,"containerName":"new","name":"$enzymes"},{"kind":13,"line":200,"containerName":"new","name":"$self"},{"kind":12,"line":200,"name":"enzymes","containerName":"new"},{"name":"$enzymes","containerName":"new","line":200,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":201},{"line":205,"kind":13,"localvar":"my","containerName":"new","name":"$in","definition":"my"},{"kind":12,"line":205,"containerName":"new","name":"new"},{"line":205,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"verbose","line":205,"kind":12},{"line":206,"kind":13,"name":"$in","containerName":"new"},{"line":206,"kind":12,"name":"read","containerName":"new"}],"kind":12,"range":{"end":{"line":208,"character":9999},"start":{"character":0,"line":180}},"name":"new"},{"containerName":"new","name":"SUPER","line":182,"kind":12},{"name":"Bio","containerName":"Restriction::IO","line":205,"kind":12},{"name":"enzymes","range":{"start":{"line":224,"character":0},"end":{"line":241,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,@enzs)","signature":{"parameters":[{"label":"$self"},{"label":"@enzs"}],"documentation":"","label":"enzymes($self,@enzs)"},"kind":12,"line":224,"children":[{"definition":"my","name":"$self","containerName":"enzymes","localvar":"my","kind":13,"line":225},{"name":"@enzs","containerName":"enzymes","line":225,"kind":13},{"kind":13,"line":226,"containerName":"enzymes","definition":"my","name":"$e","localvar":"my"},{"kind":13,"line":226,"name":"@enzs","containerName":"enzymes"},{"kind":13,"line":227,"name":"$e","containerName":"enzymes"},{"name":"$e","containerName":"enzymes","line":230,"kind":13},{"line":230,"kind":12,"containerName":"enzymes","name":"isa"},{"name":"$self","containerName":"enzymes","kind":13,"line":231},{"kind":13,"line":231,"name":"$e","containerName":"enzymes"},{"line":232,"kind":13,"name":"$self","containerName":"enzymes"},{"kind":13,"line":232,"name":"$e","containerName":"enzymes"},{"name":"name","containerName":"enzymes","line":232,"kind":12},{"kind":13,"line":232,"containerName":"enzymes","name":"$e"},{"kind":13,"line":234,"name":"$e","containerName":"enzymes"},{"name":"isa","containerName":"enzymes","line":234,"kind":12},{"line":235,"kind":13,"name":"$self","containerName":"enzymes"},{"kind":12,"line":235,"containerName":"enzymes","name":"enzymes"},{"line":235,"kind":13,"containerName":"enzymes","name":"$e"},{"containerName":"enzymes","name":"each_enzyme","kind":12,"line":235},{"localvar":"my","definition":"my","name":"$r","containerName":"enzymes","line":237,"kind":13},{"kind":13,"line":238,"name":"$self","containerName":"enzymes"},{"kind":12,"line":238,"name":"warn","containerName":"enzymes"},{"kind":13,"line":239,"name":"$e","containerName":"enzymes"}]},{"line":242,"kind":13,"containerName":null,"name":"$self"},{"range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":260}},"name":"each_enzyme","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"each_enzyme","name":"$self","definition":"my","line":259,"kind":13},{"name":"$self","containerName":"each_enzyme","line":260,"kind":13}],"line":258,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$name)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$name"}],"label":"get_enzyme($self,$name)"},"kind":12,"line":272,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_enzyme","line":273,"kind":13},{"containerName":"get_enzyme","name":"$name","line":273,"kind":13},{"kind":13,"line":274,"containerName":"get_enzyme","name":"$self"},{"name":"$name","containerName":"get_enzyme","kind":13,"line":274}],"name":"get_enzyme","range":{"end":{"character":9999,"line":275},"start":{"line":272,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($self,$size)","signature":{"label":"available_list($self,$size)","documentation":"","parameters":[{"label":"$self"},{"label":"$size"}]},"kind":12,"line":290,"children":[{"localvar":"my","containerName":"available_list","name":"$self","definition":"my","line":291,"kind":13},{"line":291,"kind":13,"containerName":"available_list","name":"$size"},{"definition":"my","name":"@keys","containerName":"available_list","localvar":"my","kind":13,"line":292},{"name":"$self","containerName":"available_list","kind":13,"line":292}],"name":"available_list","range":{"start":{"character":0,"line":290},"end":{"line":292,"character":9999}}},{"line":293,"kind":13,"name":"@keys","containerName":null},{"range":{"end":{"character":9999,"line":315},"start":{"character":0,"line":307}},"name":"longest_cutter","children":[{"kind":13,"line":308,"definition":"my","name":"$self","containerName":"longest_cutter","localvar":"my"},{"line":309,"kind":13,"localvar":"my","containerName":"longest_cutter","definition":"my","name":"$longest"},{"localvar":"my","definition":"my","name":"$longest_enz","containerName":"longest_cutter","line":309,"kind":13},{"line":310,"kind":13,"localvar":"my","containerName":"longest_cutter","definition":"my","name":"$enz"},{"line":310,"kind":13,"containerName":"longest_cutter","name":"$self"},{"name":"each_enzyme","containerName":"longest_cutter","line":310,"kind":12},{"line":311,"kind":13,"localvar":"my","name":"$len","definition":"my","containerName":"longest_cutter"},{"name":"$enz","containerName":"longest_cutter","line":311,"kind":13},{"kind":12,"line":311,"containerName":"longest_cutter","name":"recognition_length"},{"kind":13,"line":312,"name":"$len","containerName":"longest_cutter"},{"containerName":"longest_cutter","name":"$longest","line":312,"kind":13},{"containerName":"longest_cutter","name":"$longest","kind":13,"line":312},{"name":"$len","containerName":"longest_cutter","kind":13,"line":312},{"containerName":"longest_cutter","name":"$longest_enz","kind":13,"line":312},{"name":"$enz","containerName":"longest_cutter","line":312,"kind":13},{"containerName":"longest_cutter","name":"$longest_enz","kind":13,"line":314}],"line":307,"kind":12,"signature":{"label":"longest_cutter($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)","definition":"sub","containerName":"main::"},{"line":335,"children":[{"line":336,"kind":13,"localvar":"my","containerName":"blunt_enzymes","name":"$self","definition":"my"},{"localvar":"my","containerName":"blunt_enzymes","definition":"my","name":"$bs","line":337,"kind":13},{"line":337,"kind":12,"name":"new","containerName":"blunt_enzymes"},{"kind":13,"line":338,"name":"$bs","containerName":"blunt_enzymes"},{"kind":12,"line":338,"name":"enzymes","containerName":"blunt_enzymes"},{"name":"overhang","containerName":"blunt_enzymes","kind":12,"line":338},{"kind":13,"line":338,"containerName":"blunt_enzymes","name":"$self"},{"name":"each_enzyme","containerName":"blunt_enzymes","line":338,"kind":12}],"kind":12,"range":{"end":{"character":9999,"line":339},"start":{"character":0,"line":335}},"containerName":"main::","definition":"sub","name":"blunt_enzymes"},{"containerName":"Restriction::EnzymeCollection","name":"Bio","kind":12,"line":337},{"range":{"start":{"character":0,"line":360},"end":{"character":9999,"line":380}},"name":"cutters","definition":"sub","containerName":"main::","children":[{"line":361,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"cutters"},{"name":"$size","definition":"my","containerName":"cutters","localvar":"my","kind":13,"line":366},{"definition":"my","name":"@sizes","containerName":"cutters","localvar":"my","kind":13,"line":367},{"containerName":"cutters","name":"$size","line":368,"kind":13},{"kind":13,"line":368,"containerName":"cutters","name":"@sizes"},{"containerName":"cutters","name":"$size","line":368,"kind":13},{"kind":13,"line":368,"name":"@sizes","containerName":"cutters"},{"containerName":"cutters","name":"$size","line":368,"kind":13},{"localvar":"my","containerName":"cutters","definition":"my","name":"$bs","line":369,"kind":13},{"line":369,"kind":12,"name":"new","containerName":"cutters"},{"name":"$size","definition":"my","containerName":"cutters","localvar":"my","kind":13,"line":370},{"name":"@sizes","containerName":"cutters","kind":13,"line":370},{"name":"$self","containerName":"cutters","line":371,"kind":13},{"line":371,"kind":12,"containerName":"cutters","name":"throw"},{"line":372,"kind":13,"containerName":"cutters","name":"$size"},{"kind":13,"line":373,"definition":"my","name":"$e","containerName":"cutters","localvar":"my"},{"line":373,"kind":13,"containerName":"cutters","name":"$self"},{"containerName":"cutters","name":"each_enzyme","line":373,"kind":12},{"line":375,"kind":13,"containerName":"cutters","name":"$bs"},{"line":375,"kind":12,"containerName":"cutters","name":"enzymes"},{"name":"$e","containerName":"cutters","line":375,"kind":13},{"line":375,"kind":13,"containerName":"cutters","name":"$e"},{"kind":12,"line":375,"containerName":"cutters","name":"cutter"},{"line":375,"kind":13,"name":"$size","containerName":"cutters"},{"containerName":"cutters","name":"$bs","line":378,"kind":13}],"line":360,"kind":12},{"kind":12,"line":369,"containerName":"Restriction::EnzymeCollection","name":"Bio"},{"containerName":null,"definition":"my","name":"$start","localvar":"my","kind":13,"line":382},{"containerName":null,"name":"$end","kind":13,"line":382},{"containerName":null,"name":"$inclusive","line":382,"kind":13},{"name":"$exclusive","containerName":null,"kind":13,"line":382},{"containerName":null,"name":"$self","kind":13,"line":383},{"line":383,"kind":12,"name":"_rearrange","containerName":"main::"},{"kind":13,"line":391,"name":"$self","containerName":null},{"name":"throw","containerName":"main::","kind":12,"line":391},{"containerName":null,"name":"$start","kind":13,"line":392},{"kind":13,"line":393,"name":"$self","containerName":null},{"line":393,"kind":12,"containerName":"main::","name":"throw"},{"line":394,"kind":13,"name":"$end","containerName":null},{"localvar":"my","containerName":null,"name":"$limits","definition":"my","line":396,"kind":13},{"kind":13,"line":397,"containerName":null,"name":"$inclusive"},{"kind":13,"line":397,"containerName":null,"name":"$inclusive"},{"name":"$exclusive","containerName":null,"line":397,"kind":13},{"kind":13,"line":398,"name":"$inclusive","containerName":null},{"kind":13,"line":398,"containerName":null,"name":"$exclusive"},{"name":"$bs","definition":"my","containerName":null,"localvar":"my","kind":13,"line":400},{"containerName":"Restriction::EnzymeCollection","name":"Bio","line":400,"kind":12},{"kind":12,"line":400,"name":"new","containerName":"main::"},{"containerName":null,"name":"%inclusive","kind":13,"line":401},{"line":402,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$e"},{"line":402,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"each_enzyme","line":402,"kind":12},{"name":"$bs","containerName":null,"line":403,"kind":13},{"kind":12,"line":403,"name":"enzymes","containerName":"main::"},{"name":"$e","containerName":null,"line":403,"kind":13},{"containerName":null,"name":"$e","line":403,"kind":13},{"containerName":"main::","name":"cutter","kind":12,"line":403},{"containerName":null,"name":"$start","line":403,"kind":13},{"kind":13,"line":403,"name":"$e","containerName":null},{"line":403,"kind":12,"name":"cutter","containerName":"main::"},{"containerName":null,"name":"%end","kind":13,"line":403},{"line":406,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$e"},{"kind":13,"line":406,"name":"$self","containerName":null},{"containerName":"main::","name":"each_enzyme","line":406,"kind":12},{"name":"$bs","containerName":null,"kind":13,"line":407},{"name":"enzymes","containerName":"main::","line":407,"kind":12},{"kind":13,"line":407,"containerName":null,"name":"$e"},{"name":"$e","containerName":null,"line":407,"kind":13},{"line":407,"kind":12,"containerName":"main::","name":"cutter"},{"name":"$start","containerName":null,"kind":13,"line":407},{"containerName":null,"name":"$e","line":407,"kind":13},{"line":407,"kind":12,"containerName":"main::","name":"cutter"},{"name":"$end","containerName":null,"kind":13,"line":407},{"line":410,"kind":13,"containerName":null,"name":"$bs"}],"version":5}