{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":87},{"containerName":null,"name":"$BlankAlleles","kind":13,"line":90},{"containerName":"","name":"strict","line":90,"kind":2},{"containerName":"","name":"base","kind":2,"line":97},{"range":{"end":{"line":128,"character":9999},"start":{"character":0,"line":111}},"name":"new","line":111,"children":[{"line":112,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":112},{"kind":13,"line":114,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":114,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","line":114,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$marker_name","line":115,"kind":13},{"name":"$ind_id","containerName":"new","kind":13,"line":115},{"containerName":"new","name":"$alleles","kind":13,"line":115},{"containerName":"new","name":"$self","line":115,"kind":13},{"kind":12,"line":115,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","line":117,"kind":13},{"line":118,"kind":13,"containerName":"new","name":"$marker_name"},{"containerName":"new","name":"$self","line":118,"kind":13},{"line":118,"kind":12,"name":"marker_name","containerName":"new"},{"kind":13,"line":118,"containerName":"new","name":"$marker_name"},{"name":"$ind_id","containerName":"new","kind":13,"line":119},{"name":"$self","containerName":"new","kind":13,"line":119},{"kind":12,"line":119,"containerName":"new","name":"individual_id"},{"containerName":"new","name":"$ind_id","line":119,"kind":13},{"kind":13,"line":120,"containerName":"new","name":"$alleles"},{"containerName":"new","name":"$alleles","kind":13,"line":121},{"line":122,"kind":13,"containerName":"new","name":"$self"},{"line":122,"kind":12,"name":"add_Allele","containerName":"new"},{"containerName":"new","name":"$alleles","line":122,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":124},{"containerName":"new","name":"warn","kind":12,"line":124},{"name":"$self","containerName":"new","line":127,"kind":13}],"kind":12,"detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Genotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Genotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Genotype - An implementation of GenotypeI which is just an allele container\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Genotype;\n  my $genotype = Bio::PopGen::Genotype->new(-marker_name   => $name,\n                                           -individual_id => $indid,\n                                           -alleles       => \\@alleles);\n\n=head1 DESCRIPTION\n\nThis object will contain alleles for a given marker for a given\nindividual.\n\nThe class variable BlankAlleles (accessible through\n$Bio::PopGen::Genotype::BlankAlleles = 'somepattern') can be set to a\nregexp pattern for identifying blank alleles which should no be\ncounted (they are effectively missing data).  By default it set to\nmatch white space, '-', 'N' or 'n', and '?' as blank alleles which are\nskipped.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Genotype;\nuse vars qw($BlankAlleles);\nuse strict;\n\n$BlankAlleles = '[\\s\\-Nn\\?]';\n\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::GenotypeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Genotype->new();\n Function: Builds a new Bio::PopGen::Genotype object \n Returns : an instance of Bio::PopGen::Genotype\n Args    : -marker_name   => string representing name of the marker\n           -individual_id => string representing individual id (optional)\n           -alleles       => arrayref with each item in the array being an allele"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"new","kind":12,"line":114},{"line":142,"children":[{"kind":13,"line":143,"containerName":"marker_name","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"marker_name","line":144,"kind":13},{"name":"$self","containerName":"marker_name","line":145,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":146}},"containerName":"main::","name":"marker_name","definition":"sub"},{"line":162,"children":[{"kind":13,"line":163,"name":"$self","definition":"my","containerName":"individual_id","localvar":"my"},{"line":164,"kind":13,"containerName":"individual_id","name":"$self"},{"name":"$self","containerName":"individual_id","line":165,"kind":13}],"kind":12,"range":{"start":{"line":162,"character":0},"end":{"line":166,"character":9999}},"containerName":"main::","name":"individual_id","definition":"sub"},{"kind":12,"children":[{"name":"$self","definition":"my","containerName":"get_Alleles","localvar":"my","kind":13,"line":183},{"containerName":"get_Alleles","name":"$self","line":186,"kind":13}],"line":182,"name":"get_Alleles","definition":"sub","containerName":"main::","range":{"start":{"line":182,"character":0},"end":{"character":9999,"line":187}}},{"kind":13,"line":188,"name":"%self","containerName":null},{"kind":13,"line":189,"name":"%self","containerName":null},{"line":192,"kind":13,"containerName":null,"name":"%self"},{"line":193,"kind":13,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","line":194,"kind":13},{"kind":12,"children":[{"line":213,"kind":13,"localvar":"my","containerName":"add_Allele","name":"$self","definition":"my"},{"kind":13,"line":214,"name":"$self","containerName":"add_Allele"},{"containerName":"add_Allele","name":"$self","kind":13,"line":215}],"line":212,"definition":"sub","name":"add_Allele","containerName":"main::","range":{"start":{"character":0,"line":212},"end":{"character":9999,"line":215}}},{"name":"%self","containerName":null,"kind":13,"line":216},{"children":[{"kind":13,"line":231,"containerName":"reset_Alleles","definition":"my","name":"$self","localvar":"my"},{"line":231,"kind":13,"name":"@args","containerName":"reset_Alleles"},{"line":232,"kind":13,"containerName":"reset_Alleles","name":"$self"},{"containerName":"reset_Alleles","name":"$self","line":233,"kind":13}],"line":230,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Genotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Genotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Genotype - An implementation of GenotypeI which is just an allele container\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Genotype;\n  my $genotype = Bio::PopGen::Genotype->new(-marker_name   => $name,\n                                           -individual_id => $indid,\n                                           -alleles       => \\@alleles);\n\n=head1 DESCRIPTION\n\nThis object will contain alleles for a given marker for a given\nindividual.\n\nThe class variable BlankAlleles (accessible through\n$Bio::PopGen::Genotype::BlankAlleles = 'somepattern') can be set to a\nregexp pattern for identifying blank alleles which should no be\ncounted (they are effectively missing data).  By default it set to\nmatch white space, '-', 'N' or 'n', and '?' as blank alleles which are\nskipped.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Genotype;\nuse vars qw($BlankAlleles);\nuse strict;\n\n$BlankAlleles = '[\\s\\-Nn\\?]';\n\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root Bio::PopGen::GenotypeI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Genotype->new();\n Function: Builds a new Bio::PopGen::Genotype object \n Returns : an instance of Bio::PopGen::Genotype\n Args    : -marker_name   => string representing name of the marker\n           -individual_id => string representing individual id (optional)\n           -alleles       => arrayref with each item in the array being an allele\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($marker_name, $ind_id, $alleles) = $self->_rearrange([qw(MARKER_NAME\n\t\t\t\t\t\t\t       INDIVIDUAL_ID\n\t\t\t\t\t\t\t       ALLELES)],@args);\n  defined $marker_name && $self->marker_name($marker_name);\n  defined $ind_id      && $self->individual_id($ind_id);\n  if( defined $alleles ) {\n      if( ref($alleles) =~ /array/i ) {\n\t  $self->add_Allele(@$alleles);\n      } else { \n\t  $self->warn(\"Could not initialize with -alleles value, it is not an array ref\");\n      }\n  }\n  return $self;\n}\n\n\n=head2 marker_name\n\n Title   : marker_name\n Usage   : my $name = $genotype->marker_name();\n Function: Get the marker name for a genotype result\n Returns : string\n Args    : [optional] marker name value to store\n\n\n\nsub marker_name{\n    my ($self) = shift;\n    return $self->{'_marker_name'} = shift if @_;\n    return $self->{'_marker_name'};\n}\n\n=head2 individual_id\n\n Title   : individual_id\n Usage   : my $indid = $genotype->individual_id();\n Function: Gets the individual id associated with a genotype\n           This is effectively a back reference since we will typically\n           associate a genotype with an individual with an \n           individual HAS-A genotype relationship.\n Returns : unique id string for an individual\n Args    : none\n\n\n\nsub individual_id {\n    my ($self) = shift;\n    return $self->{'_individual_id'} = shift if @_;\n    return $self->{'_individual_id'};\n}\n\n=head2 get_Alleles\n\n Title   : get_Alleles\n Usage   : my @alleles = $genotype->get_Alleles();\n Function: Get the alleles for a given marker and individual\n Returns : array of alleles (strings in this implementation)\n Args    : $showblank - boolean flag to indicate return ALL alleles not \n                        skipping the coded EMPTY alleles\n\n Note    : Uses the class variable $BlankAlleles to test if alleles\n           should be skipped or not.\n\n\nsub get_Alleles{\n    my ($self) = shift;\n    \n     if( @_ && $_[0] ) {\n\treturn @{$self->{'_alleles'} || []};\n    } else {\n\tif( defined $self->{'_cached_noblank'} ) {\n\t    return @{$self->{'_cached_noblank'}} \n\t}\n\t# one liners - woo hoo.\n\t$self->{'_cached_noblank'} = [ grep { ! /^\\s*$BlankAlleles\\s*$/o } \n\t\t\t\t       @{$self->{'_alleles'} || []}];\n\treturn @{$self->{'_cached_noblank'}};\n    }\n}\n\n=head2 add_Allele\n\n Title   : add_Allele\n Usage   : $genotype->add_Allele(@alleles);\n Function: Add alleles to the genotype, at this point there is no\n           verification to insure that haploid individuals only have 1 \n           allele or that diploids only have 2 - we assume that is\n           done by the user creating these objects \n Returns : count of the number of alleles in genotype\n Args    : Array of alleles to store\n\n\n\nsub add_Allele {\n    my ($self) = shift;\n    $self->{'_cached_noblank'} = undef;    \n    push @{$self->{'_alleles'}}, @_;\n    return scalar @{$self->{'_alleles'}};\n}\n\n=head2 reset_Alleles\n\n Title   : reset_Alleles\n Usage   : $genotype->reset_Alleles;\n Function: Resets the stored alleles so the list is empty\n Returns : None\n Args    : None","label":"reset_Alleles($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","range":{"start":{"line":230,"character":0},"end":{"line":235,"character":9999}},"name":"reset_Alleles"}]}