{"version":5,"vars":[{"containerName":"","name":"base","line":63,"kind":2},{"line":87,"children":[{"kind":13,"line":88,"containerName":"new","definition":"my","name":"$pkg","localvar":"my"},{"line":88,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":90,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"containerName":"new","name":"$pkg","line":90,"kind":13},{"containerName":"new","name":"@args","kind":13,"line":90},{"kind":13,"line":92,"name":"$leavesR","definition":"my","containerName":"new","localvar":"my"},{"line":92,"kind":13,"name":"$numleaves","containerName":"new"},{"name":"$numhybrids","containerName":"new","kind":13,"line":92},{"containerName":"new","name":"$self","kind":13,"line":93},{"line":93,"kind":12,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","line":95,"kind":13},{"definition":"my","name":"@leaves","containerName":"new","localvar":"my","kind":13,"line":97},{"containerName":"new","name":"$leavesR","line":98,"kind":13},{"containerName":"new","name":"$numleaves","kind":13,"line":98},{"line":99,"kind":13,"name":"@leaves","containerName":"new"},{"name":"$numleaves","containerName":"new","kind":13,"line":99},{"kind":13,"line":100,"containerName":"new","name":"$leavesR"},{"name":"@leaves","containerName":"new","kind":13,"line":100},{"kind":13,"line":102,"name":"$leavesR","containerName":"new"},{"name":"$self","containerName":"new","line":103,"kind":13},{"line":103,"kind":12,"name":"throw","containerName":"new"},{"line":105,"kind":13,"containerName":"new","name":"@leaves"},{"line":105,"kind":13,"name":"$leavesR","containerName":"new"},{"line":106,"kind":13,"containerName":"new","name":"$self"},{"name":"$leavesR","containerName":"new","line":106,"kind":13},{"containerName":"new","name":"$numleaves","kind":13,"line":108},{"containerName":"new","name":"@leaves","kind":13,"line":108},{"name":"$self","containerName":"new","line":109,"kind":13},{"line":109,"kind":13,"name":"$numleaves","containerName":"new"},{"name":"$numleaves","containerName":"new","kind":13,"line":110},{"containerName":"new","definition":"my","name":"@leavesparent","localvar":"my","kind":13,"line":111},{"kind":13,"line":111,"containerName":"new","name":"@leaves"},{"localvar":"my","definition":"my","name":"$newleaf","containerName":"new","line":112,"kind":13},{"kind":13,"line":112,"containerName":"new","name":"@leavesparent"},{"containerName":"new","name":"$self","kind":13,"line":113},{"name":"$newleaf","containerName":"new","kind":13,"line":113},{"name":"$self","containerName":"new","line":114,"kind":13},{"kind":13,"line":115,"containerName":"new","name":"$pkg"},{"containerName":"new","name":"@leavesparent","line":115,"kind":13},{"name":"$oldnet","definition":"my","containerName":"new","localvar":"my","kind":13,"line":116},{"kind":13,"line":116,"containerName":"new","name":"$self"},{"kind":12,"line":116,"containerName":"new","name":"next_network_new"},{"name":"$self","containerName":"new","line":117,"kind":13},{"name":"$oldnet","containerName":"new","line":117,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"@candidates","line":118,"kind":13},{"name":"$oldnet","containerName":"new","line":118,"kind":13},{"containerName":"new","name":"nodes","kind":12,"line":118},{"name":"$self","containerName":"new","kind":13,"line":119},{"containerName":"new","name":"@candidates","kind":13,"line":119},{"name":"$self","containerName":"new","line":121,"kind":13},{"containerName":"new","name":"$self","line":122,"kind":13},{"line":123,"kind":13,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":124},{"name":"$pkg","containerName":"new","kind":13,"line":124}],"kind":12,"detail":"($pkg,@args)","signature":{"label":"new($pkg,@args)","parameters":[{"label":"$pkg"},{"label":"@args"}],"documentation":"1;\n# $Id: TreeFactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryX - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryX;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\"."},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":87},"end":{"line":125,"character":9999}},"name":"new"},{"line":88,"kind":2,"name":"PhyloNetwork","containerName":"Bio"},{"kind":12,"line":90,"containerName":"new","name":"SUPER"},{"kind":12,"line":106,"name":"leaves"},{"name":"numleaves","line":109,"kind":12},{"kind":12,"line":113,"name":"newleaf"},{"name":"parent","line":114,"kind":12},{"kind":12,"line":116,"name":"parent"},{"name":"oldnet","line":117,"kind":12},{"kind":12,"line":119,"name":"candidates"},{"name":"index","kind":12,"line":121},{"name":"found","kind":12,"line":122},{"name":"thrown","line":123,"kind":12},{"kind":12,"children":[{"line":138,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_network_new"},{"kind":13,"line":140,"containerName":"next_network_new","name":"$n","definition":"my","localvar":"my"},{"line":140,"kind":13,"containerName":"next_network_new","name":"$self"},{"containerName":"next_network_new","name":"$self","kind":13,"line":141},{"line":142,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":143,"kind":13,"localvar":"my","name":"$graph","definition":"my","containerName":"next_network_new"},{"name":"new","containerName":"next_network_new","kind":12,"line":143},{"name":"$graph","containerName":"next_network_new","line":144,"kind":13},{"containerName":"next_network_new","name":"add_edges","line":144,"kind":12},{"name":"$self","containerName":"next_network_new","kind":13,"line":144},{"line":144,"kind":13,"containerName":"next_network_new","name":"$self"},{"definition":"my","name":"$net","containerName":"next_network_new","localvar":"my","kind":13,"line":145},{"line":145,"kind":12,"name":"new","containerName":"next_network_new"},{"name":"$graph","containerName":"next_network_new","kind":13,"line":145},{"line":146,"kind":13,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":147,"name":"$self","containerName":"next_network_new"},{"kind":13,"line":147,"name":"$net","containerName":"next_network_new"},{"name":"$net","containerName":"next_network_new","kind":13,"line":148},{"name":"$self","containerName":"next_network_new","kind":13,"line":155},{"line":155,"kind":13,"containerName":"next_network_new","name":"$self"},{"kind":13,"line":156,"containerName":"next_network_new","definition":"my","name":"$oldnet","localvar":"my"},{"name":"$self","containerName":"next_network_new","line":156,"kind":13},{"containerName":"next_network_new","name":"next_network_new","kind":12,"line":156},{"name":"$oldnet","containerName":"next_network_new","kind":13,"line":157},{"line":160,"kind":13,"name":"$self","containerName":"next_network_new"},{"name":"$oldnet","containerName":"next_network_new","kind":13,"line":160},{"line":161,"kind":13,"localvar":"my","containerName":"next_network_new","name":"@candidates","definition":"my"},{"line":161,"kind":13,"containerName":"next_network_new","name":"$oldnet"},{"kind":12,"line":161,"name":"nodes","containerName":"next_network_new"},{"kind":13,"line":162,"containerName":"next_network_new","name":"$self"},{"name":"@candidates","containerName":"next_network_new","line":162,"kind":13},{"containerName":"next_network_new","name":"$self","kind":13,"line":163},{"line":165,"kind":13,"localvar":"my","definition":"my","name":"$graph","containerName":"next_network_new"},{"name":"$self","containerName":"next_network_new","line":165,"kind":13},{"name":"copy","containerName":"next_network_new","line":165,"kind":12},{"containerName":"next_network_new","name":"$u","definition":"my","localvar":"my","kind":13,"line":166},{"kind":13,"line":166,"name":"$self","containerName":"next_network_new"},{"line":166,"kind":13,"name":"$self","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$w","definition":"my","localvar":"my","kind":13,"line":167},{"kind":13,"line":167,"name":"$graph","containerName":"next_network_new"},{"name":"predecessors","containerName":"next_network_new","kind":12,"line":167},{"kind":13,"line":167,"name":"$u","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$graph","line":168,"kind":13},{"kind":12,"line":168,"containerName":"next_network_new","name":"delete_edge"},{"kind":13,"line":168,"name":"$w","containerName":"next_network_new"},{"name":"$u","containerName":"next_network_new","kind":13,"line":168},{"kind":13,"line":169,"name":"$graph","containerName":"next_network_new"},{"line":169,"kind":12,"name":"add_edge","containerName":"next_network_new"},{"kind":13,"line":169,"name":"$w","containerName":"next_network_new"},{"name":"$graph","containerName":"next_network_new","kind":13,"line":171},{"name":"add_edge","containerName":"next_network_new","kind":12,"line":171},{"containerName":"next_network_new","name":"$u","kind":13,"line":171},{"name":"$graph","containerName":"next_network_new","line":172,"kind":13},{"line":172,"kind":12,"containerName":"next_network_new","name":"add_edge"},{"name":"$self","containerName":"next_network_new","line":172,"kind":13},{"kind":13,"line":173,"containerName":"next_network_new","definition":"my","name":"$net","localvar":"my"},{"name":"new","containerName":"next_network_new","line":173,"kind":12},{"name":"$graph","containerName":"next_network_new","kind":13,"line":173},{"line":174,"kind":13,"containerName":"next_network_new","name":"$self"},{"line":175,"kind":13,"localvar":"my","name":"@found","definition":"my","containerName":"next_network_new"},{"containerName":"next_network_new","name":"$self","line":175,"kind":13}],"line":137,"definition":"sub","containerName":"main::","signature":{"label":"next_network_new($self)","documentation":"1;\n# $Id: TreeFactoryX.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryX\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryX - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryX;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network_new();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n  }\n  $self->{index}=0;\n  $self->{found}=[];\n  $self->{thrown}=0;\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)","name":"next_network_new","range":{"end":{"character":9999,"line":175},"start":{"character":0,"line":137}}},{"name":"numleaves","kind":12,"line":140},{"kind":12,"line":141,"name":"numleaves"},{"line":142,"kind":12,"name":"index"},{"line":143,"kind":12,"containerName":"Directed","name":"Graph"},{"name":"leaves","line":144,"kind":12},{"line":144,"kind":12,"name":"leaves"},{"name":"Bio","containerName":"PhyloNetwork","line":145,"kind":12},{"name":"index","line":146,"kind":12},{"name":"found","line":147,"kind":12},{"name":"index","kind":12,"line":155},{"kind":12,"line":155,"name":"candidates"},{"name":"parent","line":156,"kind":12},{"line":160,"kind":12,"name":"oldnet"},{"name":"candidates","line":162,"kind":12},{"kind":12,"line":163,"name":"index"},{"name":"oldnet","kind":12,"line":165},{"name":"graph","kind":12,"line":165},{"name":"candidates","kind":12,"line":166},{"name":"index","kind":12,"line":166},{"kind":12,"line":172,"name":"newleaf"},{"containerName":"PhyloNetwork","name":"Bio","kind":12,"line":173},{"kind":12,"line":174,"name":"index"},{"line":175,"kind":12,"name":"found"},{"line":176,"kind":13,"name":"@found","containerName":null},{"kind":13,"line":176,"containerName":null,"name":"$net"},{"line":177,"kind":13,"name":"%self","containerName":null},{"name":"found","line":177,"kind":12},{"name":"@found","containerName":null,"line":177,"kind":13},{"containerName":null,"name":"$net","line":178,"kind":13},{"name":"next_network_repeated","range":{"start":{"line":182,"character":0},"end":{"line":185,"character":9999}},"kind":12,"line":182,"children":[{"localvar":"my","containerName":"next_network_repeated","name":"$self","definition":"my","line":183,"kind":13},{"name":"$self","containerName":"next_network_repeated","line":185,"kind":13},{"containerName":"next_network_repeated","name":"$self","kind":13,"line":185}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_network_repeated($self)","parameters":[{"label":"$self"}],"documentation":""}},{"name":"thrown","kind":12,"line":185},{"name":"found","kind":12,"line":185},{"name":"%self","containerName":null,"line":186,"kind":13},{"kind":12,"line":186,"name":"thrown"},{"containerName":null,"name":"%self","kind":13,"line":186},{"kind":12,"line":186,"name":"thrown"},{"kind":13,"line":187,"containerName":null,"name":"%self"},{"line":187,"kind":12,"name":"found"},{"line":187,"kind":13,"containerName":null,"name":"%self"},{"line":187,"kind":12,"name":"thrown"},{"range":{"start":{"line":190,"character":0},"end":{"character":9999,"line":193}},"name":"next_network","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"next_network($self)"},"containerName":"main::","definition":"sub","line":190,"children":[{"line":191,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_network"},{"line":192,"kind":13,"name":"$self","containerName":"next_network"},{"line":192,"kind":12,"name":"next_network_new","containerName":"next_network"}],"kind":12}]}