{"vars":[{"containerName":"","name":"base","kind":2,"line":63},{"name":"new","range":{"end":{"line":127,"character":9999},"start":{"line":87,"character":0}},"containerName":"main::","definition":"sub","detail":"($pkg,@args)","signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: TreeFactoryMulti.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryMulti\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryMulti - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryMulti;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".","parameters":[{"label":"$pkg"},{"label":"@args"}]},"kind":12,"line":87,"children":[{"line":88,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$pkg"},{"line":88,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":90,"name":"$self","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$pkg","line":90,"kind":13},{"containerName":"new","name":"@args","line":90,"kind":13},{"line":92,"kind":13,"localvar":"my","name":"$leavesR","definition":"my","containerName":"new"},{"line":92,"kind":13,"containerName":"new","name":"$numleaves"},{"name":"$numhybrids","containerName":"new","kind":13,"line":92},{"line":93,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":93,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":95},{"containerName":"new","name":"@leaves","definition":"my","localvar":"my","kind":13,"line":97},{"line":98,"kind":13,"containerName":"new","name":"$leavesR"},{"line":98,"kind":13,"name":"$numleaves","containerName":"new"},{"containerName":"new","name":"@leaves","line":99,"kind":13},{"line":99,"kind":13,"containerName":"new","name":"$numleaves"},{"kind":13,"line":100,"name":"$leavesR","containerName":"new"},{"containerName":"new","name":"@leaves","kind":13,"line":100},{"kind":13,"line":102,"name":"$leavesR","containerName":"new"},{"line":103,"kind":13,"containerName":"new","name":"$self"},{"line":103,"kind":12,"name":"throw","containerName":"new"},{"line":105,"kind":13,"containerName":"new","name":"@leaves"},{"kind":13,"line":105,"name":"$leavesR","containerName":"new"},{"containerName":"new","name":"$self","line":106,"kind":13},{"kind":13,"line":106,"name":"$leavesR","containerName":"new"},{"kind":13,"line":108,"name":"$numleaves","containerName":"new"},{"kind":13,"line":108,"containerName":"new","name":"@leaves"},{"kind":13,"line":109,"name":"$self","containerName":"new"},{"name":"$numleaves","containerName":"new","line":109,"kind":13},{"line":110,"kind":13,"containerName":"new","name":"$numleaves"},{"line":111,"kind":13,"localvar":"my","definition":"my","name":"@leavesparent","containerName":"new"},{"line":111,"kind":13,"containerName":"new","name":"@leaves"},{"line":112,"kind":13,"localvar":"my","containerName":"new","name":"$newleaf","definition":"my"},{"containerName":"new","name":"@leavesparent","kind":13,"line":112},{"name":"$self","containerName":"new","line":113,"kind":13},{"containerName":"new","name":"$newleaf","line":113,"kind":13},{"name":"$self","containerName":"new","line":114,"kind":13},{"containerName":"new","name":"$pkg","line":115,"kind":13},{"name":"@leavesparent","containerName":"new","kind":13,"line":115},{"containerName":"new","name":"$oldnet","definition":"my","localvar":"my","kind":13,"line":116},{"containerName":"new","name":"$self","line":116,"kind":13},{"line":116,"kind":12,"containerName":"new","name":"next_network"},{"name":"$self","containerName":"new","line":117,"kind":13},{"line":117,"kind":13,"name":"$oldnet","containerName":"new"},{"kind":13,"line":118,"definition":"my","name":"@candidates","containerName":"new","localvar":"my"},{"line":118,"kind":13,"containerName":"new","name":"$oldnet"},{"line":118,"kind":12,"containerName":"new","name":"nodes"},{"kind":13,"line":119,"name":"$self","containerName":"new"},{"containerName":"new","name":"@candidates","kind":13,"line":119},{"localvar":"my","name":"@candidatesbis","definition":"my","containerName":"new","line":120,"kind":13},{"kind":13,"line":120,"containerName":"new","name":"$oldnet"},{"containerName":"new","name":"internal_nodes","line":120,"kind":12},{"line":121,"kind":13,"containerName":"new","name":"$self"},{"name":"@candidatesbis","containerName":"new","kind":13,"line":121},{"kind":13,"line":122,"name":"$self","containerName":"new"},{"name":"$self","containerName":"new","line":124,"kind":13},{"name":"$self","containerName":"new","line":126,"kind":13},{"containerName":"new","name":"$pkg","kind":13,"line":126}]},{"name":"PhyloNetwork","containerName":"Bio","kind":2,"line":88},{"line":90,"kind":12,"containerName":"new","name":"SUPER"},{"kind":12,"line":106,"name":"leaves"},{"kind":12,"line":109,"name":"numleaves"},{"line":113,"kind":12,"name":"newleaf"},{"name":"parent","line":114,"kind":12},{"name":"parent","kind":12,"line":116},{"kind":12,"line":117,"name":"oldnet"},{"kind":12,"line":119,"name":"candidates"},{"name":"candidatesbis","kind":12,"line":121},{"kind":12,"line":122,"name":"processbis"},{"line":124,"kind":12,"name":"index"},{"line":139,"children":[{"line":140,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"next_network"},{"localvar":"my","containerName":"next_network","definition":"my","name":"$n","line":142,"kind":13},{"name":"$self","containerName":"next_network","kind":13,"line":142},{"name":"$self","containerName":"next_network","kind":13,"line":143},{"line":144,"kind":13,"containerName":"next_network","name":"$self"},{"line":145,"kind":13,"localvar":"my","containerName":"next_network","definition":"my","name":"$graph"},{"containerName":"next_network","name":"new","kind":12,"line":145},{"containerName":"next_network","name":"$graph","line":146,"kind":13},{"line":146,"kind":12,"name":"add_edges","containerName":"next_network"},{"line":146,"kind":13,"name":"$self","containerName":"next_network"},{"kind":13,"line":146,"name":"$self","containerName":"next_network"},{"name":"$net","definition":"my","containerName":"next_network","localvar":"my","kind":13,"line":147},{"containerName":"next_network","name":"new","kind":12,"line":147},{"kind":13,"line":147,"name":"$graph","containerName":"next_network"},{"line":148,"kind":13,"containerName":"next_network","name":"$self"},{"containerName":"next_network","name":"$net","kind":13,"line":149},{"kind":13,"line":156,"containerName":"next_network","name":"$self"},{"containerName":"next_network","name":"$self","kind":13,"line":156},{"containerName":"next_network","name":"$self","kind":13,"line":156},{"localvar":"my","name":"$oldnet","definition":"my","containerName":"next_network","line":158,"kind":13},{"line":158,"kind":13,"name":"$self","containerName":"next_network"},{"name":"next_network","containerName":"next_network","kind":12,"line":158},{"name":"$oldnet","containerName":"next_network","line":159,"kind":13},{"kind":13,"line":162,"containerName":"next_network","name":"$self"},{"line":162,"kind":13,"name":"$oldnet","containerName":"next_network"},{"name":"@candidates","definition":"my","containerName":"next_network","localvar":"my","kind":13,"line":163},{"containerName":"next_network","name":"$oldnet","line":163,"kind":13},{"line":163,"kind":12,"name":"nodes","containerName":"next_network"},{"name":"$self","containerName":"next_network","line":164,"kind":13},{"name":"@candidates","containerName":"next_network","kind":13,"line":164},{"line":165,"kind":13,"localvar":"my","containerName":"next_network","definition":"my","name":"@candidatesbis"},{"line":165,"kind":13,"name":"$oldnet","containerName":"next_network"},{"line":165,"kind":12,"containerName":"next_network","name":"internal_nodes"},{"containerName":"next_network","name":"$self","kind":13,"line":166},{"kind":13,"line":166,"containerName":"next_network","name":"@candidatesbis"},{"kind":13,"line":167,"name":"$self","containerName":"next_network"},{"line":168,"kind":13,"name":"$self","containerName":"next_network"},{"line":169,"kind":13,"localvar":"my","name":"$n1","definition":"my","containerName":"next_network"},{"name":"@candidates","containerName":"next_network","line":169,"kind":13},{"line":170,"kind":13,"localvar":"my","containerName":"next_network","name":"$n2","definition":"my"},{"kind":13,"line":170,"containerName":"next_network","name":"@candidatesbis"},{"line":171,"kind":13,"containerName":"next_network","name":"$oldnet"},{"line":171,"kind":12,"containerName":"next_network","name":"eNewick"},{"name":"$self","containerName":"next_network","line":171,"kind":13},{"kind":13,"line":173,"containerName":"next_network","name":"$self"},{"line":173,"kind":13,"name":"$self","containerName":"next_network"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: TreeFactoryMulti.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactoryMulti\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactoryMulti - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactoryMulti;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n    my @candidatesbis=$oldnet->internal_nodes();\n    $self->{candidatesbis}=\\@candidatesbis;\n    $self->{processbis}=0;\n  }\n  $self->{index}=0;\n\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}],"label":"next_network($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":139},"end":{"character":9999,"line":173}},"name":"next_network"},{"name":"numleaves","line":142,"kind":12},{"name":"numleaves","line":143,"kind":12},{"name":"index","line":144,"kind":12},{"name":"Graph","containerName":"Directed","kind":12,"line":145},{"name":"leaves","kind":12,"line":146},{"name":"leaves","line":146,"kind":12},{"containerName":"PhyloNetwork","name":"Bio","line":147,"kind":12},{"name":"index","line":148,"kind":12},{"line":156,"kind":12,"name":"index"},{"name":"candidatesbis","line":156,"kind":12},{"kind":12,"line":156,"name":"processbis"},{"line":158,"kind":12,"name":"parent"},{"name":"oldnet","kind":12,"line":162},{"kind":12,"line":164,"name":"candidates"},{"kind":12,"line":166,"name":"candidatesbis"},{"kind":12,"line":167,"name":"processbis"},{"line":168,"kind":12,"name":"index"},{"line":171,"kind":12,"name":"numleaves"},{"line":173,"kind":12,"name":"index"},{"name":"candidates","kind":12,"line":173},{"name":"%self","containerName":null,"kind":13,"line":173},{"name":"processbis","line":173,"kind":12},{"kind":13,"line":175,"name":"%self","containerName":null},{"kind":12,"line":175,"name":"processbis"},{"containerName":null,"name":"%self","kind":13,"line":176},{"line":176,"kind":12,"name":"index"},{"kind":13,"line":179,"name":"%self","containerName":null},{"kind":12,"line":179,"name":"processbis"},{"line":180,"kind":13,"localvar":"my","containerName":null,"name":"$graph","definition":"my"},{"kind":13,"line":180,"containerName":null,"name":"%self"},{"name":"oldnet","kind":12,"line":180},{"kind":12,"line":180,"name":"graph"},{"name":"copy","containerName":"main::","line":180,"kind":12},{"line":181,"kind":13,"localvar":"my","containerName":null,"name":"$u","definition":"my"},{"kind":13,"line":181,"name":"%self","containerName":null},{"name":"candidates","kind":12,"line":181},{"kind":13,"line":181,"containerName":null,"name":"%self"},{"name":"index","kind":12,"line":181},{"line":182,"kind":13,"localvar":"my","name":"$w","definition":"my","containerName":null},{"containerName":null,"name":"$graph","line":182,"kind":13},{"containerName":"main::","name":"predecessors","kind":12,"line":182},{"line":182,"kind":13,"name":"%u","containerName":null},{"name":"$graph","containerName":null,"line":183,"kind":13},{"name":"delete_edge","containerName":"main::","line":183,"kind":12},{"name":"$w","containerName":null,"kind":13,"line":183},{"kind":13,"line":183,"containerName":null,"name":"$u"},{"kind":13,"line":184,"containerName":null,"name":"$graph"},{"name":"add_edge","containerName":"main::","kind":12,"line":184},{"kind":13,"line":184,"name":"$w","containerName":null},{"kind":13,"line":186,"name":"$graph","containerName":null},{"line":186,"kind":12,"name":"add_edge","containerName":"main::"},{"line":186,"kind":13,"containerName":null,"name":"$u"},{"containerName":null,"name":"$graph","line":187,"kind":13},{"name":"add_edge","containerName":"main::","line":187,"kind":12},{"line":187,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":187,"name":"newleaf"},{"kind":13,"line":188,"name":"$net","definition":"my","containerName":null,"localvar":"my"},{"name":"Bio","containerName":"PhyloNetwork","line":188,"kind":12},{"line":188,"kind":12,"containerName":"main::","name":"new"},{"line":188,"kind":13,"containerName":null,"name":"$graph"},{"kind":13,"line":189,"containerName":null,"name":"%self"},{"name":"index","line":189,"kind":12},{"name":"%net","containerName":null,"kind":13,"line":190},{"line":192,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$graph"},{"name":"%self","containerName":null,"kind":13,"line":192},{"name":"oldnet","kind":12,"line":192},{"line":192,"kind":12,"name":"graph"},{"line":192,"kind":12,"containerName":"main::","name":"copy"},{"kind":13,"line":193,"containerName":null,"definition":"my","name":"$u","localvar":"my"},{"name":"%self","containerName":null,"line":193,"kind":13},{"name":"candidatesbis","kind":12,"line":193},{"containerName":null,"name":"%self","line":193,"kind":13},{"name":"index","line":193,"kind":12},{"kind":13,"line":195,"name":"$graph","containerName":null},{"name":"add_edge","containerName":"main::","line":195,"kind":12},{"containerName":null,"name":"$u","kind":13,"line":195},{"kind":13,"line":195,"name":"%self","containerName":null},{"name":"newleaf","line":195,"kind":12},{"kind":13,"line":196,"definition":"my","name":"$net","containerName":null,"localvar":"my"},{"kind":12,"line":196,"name":"Bio","containerName":"PhyloNetwork"},{"name":"new","containerName":"main::","line":196,"kind":12},{"line":196,"kind":13,"name":"$graph","containerName":null},{"kind":13,"line":197,"name":"%self","containerName":null},{"name":"index","line":197,"kind":12},{"containerName":null,"name":"$net","kind":13,"line":198}],"version":5}