{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":257},{"line":328,"children":[{"containerName":"new","name":"$pkg","definition":"my","localvar":"my","kind":13,"line":329},{"name":"@args","containerName":"new","line":329,"kind":13},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":330},{"line":330,"kind":13,"containerName":"new","name":"$pkg"},{"kind":13,"line":330,"containerName":"new","name":"@args"},{"line":331,"kind":13,"localvar":"my","name":"$eNewick","definition":"my","containerName":"new"},{"kind":13,"line":331,"name":"$edgesR","containerName":"new"},{"line":331,"kind":13,"containerName":"new","name":"$leavesR"},{"kind":13,"line":331,"containerName":"new","name":"$numleaves"},{"kind":13,"line":331,"containerName":"new","name":"$graph"},{"line":331,"kind":13,"containerName":"new","name":"$tree"},{"containerName":"new","name":"$mudataR","kind":13,"line":331},{"kind":13,"line":332,"name":"$self","containerName":"new"},{"line":332,"kind":12,"name":"_rearrange","containerName":"new"},{"name":"@args","containerName":"new","line":338,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":339},{"containerName":"new","name":"$pkg","kind":13,"line":339},{"name":"$self","containerName":"new","line":341,"kind":13},{"name":"build_from_eNewick","containerName":"new","line":341,"kind":12},{"line":341,"kind":13,"containerName":"new","name":"$eNewick"},{"kind":13,"line":341,"containerName":"new","name":"$eNewick"},{"name":"$self","containerName":"new","line":342,"kind":13},{"line":342,"kind":12,"name":"build_from_edges","containerName":"new"},{"kind":13,"line":342,"name":"$edgesR","containerName":"new"},{"kind":13,"line":342,"containerName":"new","name":"$edgesR"},{"name":"$self","containerName":"new","kind":13,"line":343},{"name":"build_from_graph","containerName":"new","kind":12,"line":343},{"name":"$graph","containerName":"new","kind":13,"line":343},{"line":343,"kind":13,"containerName":"new","name":"$graph"},{"kind":13,"line":344,"containerName":"new","name":"$self"},{"line":344,"kind":12,"name":"build_from_tree","containerName":"new"},{"kind":13,"line":344,"containerName":"new","name":"$tree"},{"name":"$tree","containerName":"new","kind":13,"line":344},{"line":345,"kind":13,"containerName":"new","name":"$leavesR"},{"kind":13,"line":345,"containerName":"new","name":"$numleaves"},{"line":346,"kind":13,"localvar":"my","name":"@leaves","definition":"my","containerName":"new"},{"line":346,"kind":13,"name":"$numleaves","containerName":"new"},{"kind":13,"line":347,"containerName":"new","name":"$leavesR"},{"name":"@leaves","containerName":"new","line":347,"kind":13},{"kind":13,"line":349,"containerName":"new","name":"$self"},{"name":"build_from_mudata","containerName":"new","kind":12,"line":349},{"containerName":"new","name":"$mudataR","line":349,"kind":13},{"line":349,"kind":13,"name":"$leavesR","containerName":"new"},{"name":"$mudataR","containerName":"new","line":350,"kind":13},{"containerName":"new","name":"$leavesR","kind":13,"line":350},{"name":"$self","containerName":"new","kind":13,"line":351}],"kind":12,"detail":"($pkg,@args)","signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").","parameters":[{"label":"$pkg"},{"label":"@args"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":328},"end":{"character":9999,"line":352}},"name":"new"},{"line":329,"kind":2,"name":"Munkres","containerName":"Bio::PhyloNetwork::muVector::Graph::Directed::Bio::TreeIO::Bio::Tree::Node::IO::String::Array::Compare::Algorithm"},{"name":"SUPER","containerName":"new","line":330,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,@edges)","signature":{"parameters":[{"label":"$self"},{"label":"@edges"}],"documentation":" Builders","label":"build_from_edges($self,@edges)"},"kind":12,"line":356,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"build_from_edges","line":357,"kind":13},{"kind":13,"line":357,"containerName":"build_from_edges","name":"@edges"},{"localvar":"my","containerName":"build_from_edges","definition":"my","name":"$graph","line":358,"kind":13},{"containerName":"build_from_edges","name":"new","line":358,"kind":12},{"kind":13,"line":359,"name":"$graph","containerName":"build_from_edges"},{"containerName":"build_from_edges","name":"add_edges","line":359,"kind":12},{"containerName":"build_from_edges","name":"@edges","line":359,"kind":13},{"line":360,"kind":13,"name":"$self","containerName":"build_from_edges"},{"name":"$graph","containerName":"build_from_edges","kind":13,"line":360},{"containerName":"build_from_edges","name":"$self","kind":13,"line":361},{"kind":12,"line":361,"name":"recompute","containerName":"build_from_edges"},{"containerName":"build_from_edges","definition":"my","name":"$labels","localvar":"my","kind":13,"line":362},{"containerName":"build_from_edges","definition":"my","name":"$node","localvar":"my","kind":13,"line":363},{"kind":13,"line":363,"containerName":"build_from_edges","name":"$self"},{"name":"nodes","containerName":"build_from_edges","kind":12,"line":363},{"containerName":"build_from_edges","name":"$labels","kind":13,"line":364},{"containerName":"build_from_edges","name":"$node","kind":13,"line":364},{"line":364,"kind":13,"containerName":"build_from_edges","name":"$node"},{"name":"$self","containerName":"build_from_edges","kind":13,"line":366},{"kind":13,"line":366,"containerName":"build_from_edges","name":"$labels"}],"name":"build_from_edges","range":{"end":{"line":367,"character":9999},"start":{"character":0,"line":356}}},{"line":358,"kind":12,"name":"Graph","containerName":"Directed"},{"name":"graph","line":360,"kind":12},{"name":"labels","line":366,"kind":12},{"range":{"start":{"character":0,"line":369},"end":{"line":379,"character":9999}},"name":"build_from_graph","line":369,"children":[{"kind":13,"line":370,"name":"$self","definition":"my","containerName":"build_from_graph","localvar":"my"},{"kind":13,"line":370,"containerName":"build_from_graph","name":"$graph"},{"line":371,"kind":13,"localvar":"my","containerName":"build_from_graph","definition":"my","name":"$graphcp"},{"containerName":"build_from_graph","name":"$graph","kind":13,"line":371},{"line":371,"kind":12,"name":"copy","containerName":"build_from_graph"},{"name":"$self","containerName":"build_from_graph","line":372,"kind":13},{"kind":13,"line":372,"name":"$graphcp","containerName":"build_from_graph"},{"containerName":"build_from_graph","name":"$self","kind":13,"line":373},{"containerName":"build_from_graph","name":"recompute","kind":12,"line":373},{"containerName":"build_from_graph","name":"$labels","definition":"my","localvar":"my","kind":13,"line":374},{"localvar":"my","containerName":"build_from_graph","definition":"my","name":"$node","line":375,"kind":13},{"name":"$self","containerName":"build_from_graph","kind":13,"line":375},{"kind":12,"line":375,"containerName":"build_from_graph","name":"nodes"},{"containerName":"build_from_graph","name":"$labels","kind":13,"line":376},{"line":376,"kind":13,"name":"$node","containerName":"build_from_graph"},{"containerName":"build_from_graph","name":"$node","line":376,"kind":13},{"containerName":"build_from_graph","name":"$self","line":378,"kind":13},{"kind":13,"line":378,"containerName":"build_from_graph","name":"$labels"}],"kind":12,"detail":"($self,$graph)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$graph"}],"label":"build_from_graph($self,$graph)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":372,"name":"graph"},{"name":"labels","kind":12,"line":378},{"kind":13,"line":381,"containerName":null,"name":"$_eN_index","definition":"my","localvar":"my"},{"detail":"($self,$string)","signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"","label":"build_from_eNewick($self,$string)"},"containerName":"main::","definition":"sub","line":383,"children":[{"line":384,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"build_from_eNewick"},{"containerName":"build_from_eNewick","name":"$string","kind":13,"line":384},{"line":385,"kind":13,"name":"$_eN_index","containerName":"build_from_eNewick"},{"definition":"my","name":"$graph","containerName":"build_from_eNewick","localvar":"my","kind":13,"line":386},{"name":"new","containerName":"build_from_eNewick","kind":12,"line":386},{"definition":"my","name":"$labels","containerName":"build_from_eNewick","localvar":"my","kind":13,"line":387},{"kind":13,"line":388,"definition":"my","name":"@blocks","containerName":"build_from_eNewick","localvar":"my"},{"name":"$string","containerName":"build_from_eNewick","kind":13,"line":388},{"localvar":"my","definition":"my","name":"$block","containerName":"build_from_eNewick","line":389,"kind":13},{"containerName":"build_from_eNewick","name":"@blocks","line":389,"kind":13},{"line":390,"kind":13,"localvar":"my","definition":"my","name":"$rt","containerName":"build_from_eNewick"},{"name":"$str","containerName":"build_from_eNewick","kind":13,"line":390},{"name":"$block","containerName":"build_from_eNewick","kind":13,"line":390},{"localvar":"my","containerName":"build_from_eNewick","definition":"my","name":"$rtlbl","line":391,"kind":13},{"line":391,"kind":13,"containerName":"build_from_eNewick","name":"$rttype"},{"name":"$rtid","containerName":"build_from_eNewick","kind":13,"line":391},{"name":"$rtlng","containerName":"build_from_eNewick","line":391,"kind":13},{"line":391,"kind":13,"name":"$rt","containerName":"build_from_eNewick"},{"kind":13,"line":392,"containerName":"build_from_eNewick","name":"$graph"},{"line":392,"kind":13,"name":"$labels","containerName":"build_from_eNewick"},{"name":"$block","containerName":"build_from_eNewick","kind":13,"line":392},{"name":"$rtid","containerName":"build_from_eNewick","kind":13,"line":392},{"line":393,"kind":13,"name":"$labels","containerName":"build_from_eNewick"},{"line":393,"kind":13,"containerName":"build_from_eNewick","name":"$rtid"},{"line":393,"kind":13,"containerName":"build_from_eNewick","name":"$rtlbl"},{"name":"$self","containerName":"build_from_eNewick","kind":13,"line":395},{"line":395,"kind":13,"containerName":"build_from_eNewick","name":"$graph"},{"containerName":"build_from_eNewick","name":"$self","kind":13,"line":396},{"line":396,"kind":13,"containerName":"build_from_eNewick","name":"$labels"},{"containerName":"build_from_eNewick","name":"$self","kind":13,"line":397},{"kind":12,"line":397,"containerName":"build_from_eNewick","name":"recompute"}],"kind":12,"range":{"end":{"character":9999,"line":398},"start":{"line":383,"character":0}},"name":"build_from_eNewick"},{"kind":12,"line":386,"containerName":"Directed","name":"Graph"},{"name":"get_root_and_subtree","line":390,"kind":12},{"kind":12,"line":391,"name":"get_label_type_id_length"},{"name":"process_block","line":392,"kind":12},{"line":395,"kind":12,"name":"graph"},{"name":"labels","line":396,"kind":12},{"range":{"end":{"line":430,"character":9999},"start":{"line":400,"character":0}},"name":"process_block","line":400,"children":[{"localvar":"my","containerName":"process_block","name":"$graph","definition":"my","line":401,"kind":13},{"line":401,"kind":13,"name":"$labels","containerName":"process_block"},{"kind":13,"line":401,"containerName":"process_block","name":"$block"},{"containerName":"process_block","name":"$rtid","line":401,"kind":13},{"line":402,"kind":13,"localvar":"my","name":"$rt","definition":"my","containerName":"process_block"},{"containerName":"process_block","name":"$str","kind":13,"line":402},{"name":"$block","containerName":"process_block","line":402,"kind":13},{"line":403,"kind":13,"localvar":"my","containerName":"process_block","name":"@substrs","definition":"my"},{"name":"$str","containerName":"process_block","line":403,"kind":13},{"name":"$substr","definition":"my","containerName":"process_block","localvar":"my","kind":13,"line":404},{"kind":13,"line":404,"containerName":"process_block","name":"@substrs"},{"kind":13,"line":405,"containerName":"process_block","name":"$subrt","definition":"my","localvar":"my"},{"name":"$subblock","containerName":"process_block","line":405,"kind":13},{"line":405,"kind":13,"containerName":"process_block","name":"$substr"},{"kind":13,"line":406,"containerName":"process_block","definition":"my","name":"$subrtlbl","localvar":"my"},{"containerName":"process_block","name":"$subrttype","kind":13,"line":406},{"name":"$subrtid","containerName":"process_block","line":406,"kind":13},{"kind":13,"line":406,"name":"$subrtlng","containerName":"process_block"},{"line":407,"kind":13,"containerName":"process_block","name":"$subrt"},{"containerName":"process_block","name":"$subrtlng","line":408,"kind":13},{"name":"$graph","containerName":"process_block","line":409,"kind":13},{"kind":12,"line":409,"containerName":"process_block","name":"add_weighted_edges"},{"containerName":"process_block","name":"$rtid","kind":13,"line":409},{"line":409,"kind":13,"containerName":"process_block","name":"$subrtid"},{"kind":13,"line":409,"containerName":"process_block","name":"$subrtlng"},{"containerName":"process_block","name":"$graph","kind":13,"line":412},{"kind":12,"line":412,"name":"add_edges","containerName":"process_block"},{"containerName":"process_block","name":"$rtid","line":412,"kind":13},{"kind":13,"line":412,"containerName":"process_block","name":"$subrtid"},{"kind":13,"line":414,"name":"$subrttype","containerName":"process_block"},{"kind":13,"line":415,"name":"$graph","containerName":"process_block"},{"line":415,"kind":12,"containerName":"process_block","name":"set_edge_attribute"},{"containerName":"process_block","name":"$rtid","line":415,"kind":13},{"line":415,"kind":13,"containerName":"process_block","name":"$subrtid"},{"line":415,"kind":13,"name":"$subrttype","containerName":"process_block"},{"name":"$subrtlbl","containerName":"process_block","kind":13,"line":417},{"kind":13,"line":419,"name":"$labels","containerName":"process_block"},{"containerName":"process_block","name":"$subrtid","kind":13,"line":419},{"line":419,"kind":13,"name":"$labels","containerName":"process_block"},{"containerName":"process_block","name":"$subrtid","kind":13,"line":419},{"line":420,"kind":13,"containerName":"process_block","name":"$labels"},{"kind":13,"line":420,"containerName":"process_block","name":"$subrtid"},{"name":"$subrtlbl","containerName":"process_block","kind":13,"line":420},{"kind":13,"line":421,"name":"$labels","containerName":"process_block"},{"name":"$subrtid","containerName":"process_block","line":421,"kind":13},{"name":"$subrtlbl","containerName":"process_block","line":421,"kind":13},{"name":"$subrtlbl","containerName":"process_block","line":421,"kind":13},{"line":423,"kind":13,"containerName":"process_block","name":"$labels"},{"line":423,"kind":13,"name":"$subrtid","containerName":"process_block"},{"containerName":"process_block","name":"$subblock","line":426,"kind":13},{"name":"$graph","containerName":"process_block","line":427,"kind":13},{"containerName":"process_block","name":"$labels","line":427,"kind":13},{"kind":13,"line":427,"name":"$subblock","containerName":"process_block"},{"name":"$subrtid","containerName":"process_block","kind":13,"line":427}],"kind":12,"detail":"($graph,$labels,$block,$rtid)","signature":{"label":"process_block($graph,$labels,$block,$rtid)","documentation":"","parameters":[{"label":"$graph"},{"label":"$labels"},{"label":"$block"},{"label":"$rtid"}]},"containerName":"main::","definition":"sub"},{"name":"get_root_and_subtree","line":402,"kind":12},{"name":"my_split","kind":12,"line":403},{"line":405,"kind":12,"name":"get_root_and_subtree"},{"line":407,"kind":12,"name":"get_label_type_id_length"},{"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$block"}],"label":"get_root_and_subtree($block)"},"detail":"($block)","kind":12,"children":[{"line":433,"kind":13,"localvar":"my","name":"$block","definition":"my","containerName":"get_root_and_subtree"},{"localvar":"my","name":"$rt","definition":"my","containerName":"get_root_and_subtree","line":434,"kind":13},{"line":434,"kind":13,"name":"$str","containerName":"get_root_and_subtree"},{"kind":13,"line":436,"name":"$rt","containerName":"get_root_and_subtree"},{"kind":13,"line":436,"name":"$str","containerName":"get_root_and_subtree"},{"line":436,"kind":13,"containerName":"get_root_and_subtree","name":"$block"},{"line":437,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"containerName":"get_root_and_subtree","name":"$block","line":437,"kind":13},{"localvar":"my","containerName":"get_root_and_subtree","name":"$pos","definition":"my","line":439,"kind":13},{"kind":13,"line":439,"name":"$rt","containerName":"get_root_and_subtree"},{"line":440,"kind":13,"name":"$rt","containerName":"get_root_and_subtree"},{"name":"$pos","containerName":"get_root_and_subtree","kind":13,"line":440},{"name":"$pos","containerName":"get_root_and_subtree","line":440,"kind":13},{"containerName":"get_root_and_subtree","name":"$pos","line":441,"kind":13},{"line":443,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"containerName":"get_root_and_subtree","name":"$block","line":443,"kind":13},{"containerName":"get_root_and_subtree","name":"$pos","kind":13,"line":443},{"kind":13,"line":443,"name":"$block","containerName":"get_root_and_subtree"},{"name":"$pos","containerName":"get_root_and_subtree","kind":13,"line":443},{"kind":13,"line":444,"name":"$str","containerName":"get_root_and_subtree"},{"kind":13,"line":444,"name":"$block","containerName":"get_root_and_subtree"},{"line":444,"kind":13,"name":"$pos","containerName":"get_root_and_subtree"},{"name":"$rt","containerName":"get_root_and_subtree","line":446,"kind":13},{"containerName":"get_root_and_subtree","name":"$rt","line":446,"kind":13},{"line":447,"kind":13,"containerName":"get_root_and_subtree","name":"$str"},{"name":"$str","containerName":"get_root_and_subtree","line":447,"kind":13},{"line":448,"kind":13,"containerName":"get_root_and_subtree","name":"$rt"},{"kind":13,"line":448,"name":"$str","containerName":"get_root_and_subtree"}],"line":432,"name":"get_root_and_subtree","range":{"start":{"character":0,"line":432},"end":{"line":449,"character":9999}}},{"name":"trim","line":446,"kind":12},{"name":"trim","line":447,"kind":12},{"kind":12,"line":451,"children":[{"name":"$string","definition":"my","containerName":"get_label_type_id_length","localvar":"my","kind":13,"line":452},{"containerName":"get_label_type_id_length","name":"$string","line":453,"kind":13},{"containerName":"get_label_type_id_length","name":"$string","kind":13,"line":455},{"localvar":"my","containerName":"get_label_type_id_length","definition":"my","name":"$label","line":457,"kind":13},{"containerName":"get_label_type_id_length","name":"$length","kind":13,"line":457},{"kind":13,"line":457,"name":"$string","containerName":"get_label_type_id_length"},{"line":458,"kind":13,"containerName":"get_label_type_id_length","name":"$label"},{"localvar":"my","containerName":"get_label_type_id_length","definition":"my","name":"$id","line":459,"kind":13},{"name":"$label","containerName":"get_label_type_id_length","kind":13,"line":460},{"kind":13,"line":460,"containerName":"get_label_type_id_length","name":"$label"},{"kind":13,"line":462,"name":"$_eN_index","containerName":"get_label_type_id_length"},{"containerName":"get_label_type_id_length","name":"$id","line":463,"kind":13},{"name":"$id","containerName":"get_label_type_id_length","kind":13,"line":465},{"line":465,"kind":13,"name":"$label","containerName":"get_label_type_id_length"},{"kind":13,"line":467,"containerName":"get_label_type_id_length","name":"$label"},{"kind":13,"line":467,"name":"$id","containerName":"get_label_type_id_length"},{"line":467,"kind":13,"containerName":"get_label_type_id_length","name":"$length"},{"line":471,"kind":13,"localvar":"my","name":"$label","definition":"my","containerName":"get_label_type_id_length"},{"containerName":"get_label_type_id_length","name":"$string2","kind":13,"line":471},{"line":471,"kind":13,"name":"$string","containerName":"get_label_type_id_length"},{"definition":"my","name":"$typeid","containerName":"get_label_type_id_length","localvar":"my","kind":13,"line":472},{"name":"$length","containerName":"get_label_type_id_length","line":472,"kind":13},{"line":472,"kind":13,"containerName":"get_label_type_id_length","name":"$string2"},{"definition":"my","name":"$type","containerName":"get_label_type_id_length","localvar":"my","kind":13,"line":473},{"name":"$typeid","containerName":"get_label_type_id_length","line":473,"kind":13},{"name":"$type","containerName":"get_label_type_id_length","kind":13,"line":474},{"containerName":"get_label_type_id_length","definition":"my","name":"$id","localvar":"my","kind":13,"line":475},{"containerName":"get_label_type_id_length","name":"$typeid","line":475,"kind":13},{"line":476,"kind":13,"name":"$id","containerName":"get_label_type_id_length"},{"name":"$label","containerName":"get_label_type_id_length","line":477,"kind":13},{"containerName":"get_label_type_id_length","name":"$type","kind":13,"line":477},{"containerName":"get_label_type_id_length","name":"$id","line":477,"kind":13},{"name":"$length","containerName":"get_label_type_id_length","kind":13,"line":477}],"containerName":"main::","definition":"sub","detail":"($string)","signature":{"label":"get_label_type_id_length($string)","documentation":"","parameters":[{"label":"$string"}]},"name":"get_label_type_id_length","range":{"start":{"character":0,"line":451},"end":{"line":479,"character":9999}}},{"detail":"($string)","signature":{"label":"trim($string)","parameters":[{"label":"$string"}],"documentation":""},"containerName":"main::","definition":"sub","line":481,"children":[{"line":483,"kind":13,"localvar":"my","containerName":"trim","name":"$string","definition":"my"},{"line":484,"kind":13,"containerName":"trim","name":"$string"},{"containerName":"trim","name":"$string","line":485,"kind":13},{"containerName":"trim","name":"$string","kind":13,"line":486}],"kind":12,"range":{"start":{"line":481,"character":0},"end":{"line":487,"character":9999}},"name":"trim"},{"line":489,"children":[{"kind":13,"line":490,"containerName":"my_split","name":"$string","definition":"my","localvar":"my"},{"definition":"my","name":"$temp","containerName":"my_split","localvar":"my","kind":13,"line":491},{"kind":13,"line":492,"containerName":"my_split","definition":"my","name":"@substrings","localvar":"my"},{"localvar":"my","containerName":"my_split","definition":"my","name":"$level","line":493,"kind":13},{"kind":13,"line":494,"containerName":"my_split","name":"$i","definition":"my","localvar":"my"},{"containerName":"my_split","name":"$string","kind":13,"line":494},{"localvar":"my","containerName":"my_split","definition":"my","name":"$char","line":495,"kind":13},{"line":495,"kind":13,"name":"$string","containerName":"my_split"},{"name":"$i","containerName":"my_split","line":495,"kind":13},{"kind":13,"line":496,"name":"$char","containerName":"my_split"},{"containerName":"my_split","name":"$level","line":497,"kind":13},{"line":499,"kind":13,"name":"$char","containerName":"my_split"},{"kind":13,"line":500,"name":"$level","containerName":"my_split"},{"name":"@substrings","containerName":"my_split","line":501,"kind":13},{"containerName":"my_split","name":"$temp","line":501,"kind":13},{"line":502,"kind":13,"containerName":"my_split","name":"$temp"},{"name":"$level","containerName":"my_split","line":504,"kind":13},{"kind":13,"line":506,"containerName":"my_split","name":"$char"},{"line":506,"kind":13,"containerName":"my_split","name":"$level"},{"line":507,"kind":13,"name":"@substrings","containerName":"my_split"},{"kind":13,"line":507,"containerName":"my_split","name":"$temp"},{"containerName":"my_split","name":"$temp","kind":13,"line":508},{"name":"$char","containerName":"my_split","line":509,"kind":13},{"kind":13,"line":511,"containerName":"my_split","name":"$temp"},{"name":"$temp","containerName":"my_split","line":511,"kind":13},{"name":"$char","containerName":"my_split","kind":13,"line":511},{"line":513,"kind":13,"containerName":"my_split","name":"@substrings"}],"kind":12,"detail":"($string)","signature":{"label":"my_split($string)","parameters":[{"label":"$string"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":489},"end":{"line":514,"character":9999}},"name":"my_split"},{"range":{"start":{"line":516,"character":0},"end":{"character":9999,"line":519}},"name":"build_from_mudata","line":516,"children":[{"definition":"my","name":"$self","containerName":"build_from_mudata","localvar":"my","kind":13,"line":517},{"kind":13,"line":517,"containerName":"build_from_mudata","name":"$mus"},{"name":"$leavesR","containerName":"build_from_mudata","kind":13,"line":517},{"localvar":"my","containerName":"build_from_mudata","definition":"my","name":"$graph","line":518,"kind":13},{"containerName":"build_from_mudata","name":"new","kind":12,"line":518},{"kind":13,"line":519,"name":"@nodes","definition":"my","containerName":"build_from_mudata","localvar":"my"},{"name":"$mus","containerName":"build_from_mudata","kind":13,"line":519}],"kind":12,"detail":"($self,$mus,$leavesR)","signature":{"label":"build_from_mudata($self,$mus,$leavesR)","documentation":"","parameters":[{"label":"$self"},{"label":"$mus"},{"label":"$leavesR"}]},"containerName":"main::","definition":"sub"},{"name":"Graph","containerName":"Directed","kind":12,"line":518},{"kind":13,"line":520,"name":"@leaves","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":520,"name":"$leavesR","containerName":null},{"localvar":"my","containerName":null,"name":"%seen","definition":"my","line":522,"kind":13},{"name":"@internal","definition":"my","containerName":null,"localvar":"my","kind":13,"line":523},{"kind":13,"line":525,"name":"@seen","containerName":null},{"containerName":null,"name":"@leaves","kind":13,"line":525},{"kind":13,"line":527,"name":"$node","definition":"my","containerName":null,"localvar":"my"},{"line":527,"kind":13,"name":"@nodes","containerName":null},{"containerName":null,"name":"@internal","kind":13,"line":528},{"name":"$node","containerName":null,"line":528,"kind":13},{"kind":13,"line":528,"containerName":null,"name":"%seen"},{"name":"$node","containerName":null,"kind":13,"line":528},{"name":"@internal","containerName":null,"kind":13,"line":531},{"kind":13,"line":531,"containerName":null,"name":"%mus"},{"name":"$b","containerName":null,"line":531,"kind":13},{"kind":13,"line":531,"containerName":null,"name":"%mus"},{"line":531,"kind":13,"name":"$a","containerName":null},{"kind":13,"line":531,"containerName":null,"name":"@internal"},{"name":"@nodes","containerName":null,"line":532,"kind":13},{"line":532,"kind":13,"containerName":null,"name":"@internal"},{"name":"@leaves","containerName":null,"kind":13,"line":532},{"line":533,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$numnodes"},{"kind":13,"line":533,"name":"@nodes","containerName":null},{"line":534,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":null},{"name":"$i","containerName":null,"line":534,"kind":13},{"kind":13,"line":534,"containerName":null,"name":"$numnodes"},{"containerName":null,"name":"%i","line":534,"kind":13},{"name":"$mu","definition":"my","containerName":null,"localvar":"my","kind":13,"line":535},{"containerName":null,"name":"%mus","kind":13,"line":535},{"containerName":null,"name":"@nodes","line":535,"kind":13},{"name":"$i","containerName":null,"line":535,"kind":13},{"localvar":"my","name":"$j","definition":"my","containerName":null,"line":536,"kind":13},{"name":"$i","containerName":null,"kind":13,"line":536},{"containerName":null,"name":"$mu","kind":13,"line":537},{"line":537,"kind":12,"name":"is_positive","containerName":"main::"},{"name":"$j","containerName":null,"line":537,"kind":13},{"line":537,"kind":13,"name":"%numnodes","containerName":null},{"name":"$mu","containerName":null,"line":538,"kind":13},{"containerName":"main::","name":"geq_poset","kind":12,"line":538},{"name":"%mus","containerName":null,"kind":13,"line":538},{"kind":13,"line":538,"containerName":null,"name":"@nodes"},{"kind":13,"line":538,"name":"%j","containerName":null},{"name":"$graph","containerName":null,"line":539,"kind":13},{"kind":12,"line":539,"name":"add_edges","containerName":"main::"},{"containerName":null,"name":"@nodes","kind":13,"line":539},{"line":539,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"@nodes","kind":13,"line":539},{"name":"$j","containerName":null,"line":539,"kind":13},{"containerName":null,"name":"$mu","kind":13,"line":540},{"kind":13,"line":540,"containerName":null,"name":"$mu"},{"line":540,"kind":13,"name":"%mus","containerName":null},{"kind":13,"line":540,"containerName":null,"name":"@nodes"},{"kind":13,"line":540,"name":"$j","containerName":null},{"line":542,"kind":13,"name":"$j","containerName":null},{"kind":13,"line":545,"name":"$self","containerName":null},{"name":"build_from_graph","containerName":"main::","kind":12,"line":545},{"name":"$graph","containerName":null,"line":545,"kind":13},{"name":"build_from_tree","range":{"end":{"line":593,"character":9999},"start":{"line":580,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":" sub relabel_tree {\n   my ($tree)=@_;\n   my $i=1;\n   my $j=1;\n   my $root=$tree->get_root_node();\n   foreach my $node ($tree->get_nodes()) {\n     if ($node == $root) {\n       $node->{'_id'}=\"r\";\n     }\n     elsif (! $node->is_Leaf) {\n       $node->{'_id'}=\"t$i\";\n       $i++;\n     }\n     else {\n       if ($node->{'_id'} eq \"\") {\n \t$node->{'_id'}=\"l$j\";\n \t$j++;\n       }\n     }\n   }\n   return $tree;\n }\n sub build_subtree {\n   my ($graph,$root)=@_;\n   foreach my $child ($root->each_Descendent) {\n     $graph->add_edge($root->id,$child->id);\n     $graph=build_subtree($graph,$child);\n   }\n   return $graph;\n }","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"build_from_tree($self,$tree)"},"detail":"($self,$tree)","kind":12,"children":[{"kind":13,"line":581,"containerName":"build_from_tree","name":"$self","definition":"my","localvar":"my"},{"line":581,"kind":13,"name":"$tree","containerName":"build_from_tree"},{"line":587,"kind":13,"localvar":"my","containerName":"build_from_tree","definition":"my","name":"$str"},{"definition":"my","name":"$io","containerName":"build_from_tree","localvar":"my","kind":13,"line":588},{"kind":12,"line":588,"name":"new","containerName":"build_from_tree"},{"name":"$str","containerName":"build_from_tree","kind":13,"line":588},{"kind":13,"line":589,"containerName":"build_from_tree","definition":"my","name":"$treeio","localvar":"my"},{"containerName":"build_from_tree","name":"new","kind":12,"line":589},{"kind":13,"line":589,"name":"$io","containerName":"build_from_tree"},{"containerName":"build_from_tree","name":"$treeio","kind":13,"line":590},{"line":590,"kind":12,"containerName":"build_from_tree","name":"write_tree"},{"containerName":"build_from_tree","name":"$tree","line":590,"kind":13},{"containerName":"build_from_tree","name":"$self","line":592,"kind":13},{"containerName":"build_from_tree","name":"build_from_eNewick","kind":12,"line":592},{"containerName":"build_from_tree","name":"$str","line":592,"kind":13}],"line":580},{"kind":12,"line":588,"containerName":"String","name":"IO"},{"containerName":"TreeIO","name":"Bio","line":589,"kind":12},{"range":{"end":{"character":9999,"line":624},"start":{"character":0,"line":595}},"name":"recompute","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"recompute($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"recompute","name":"$self","definition":"my","line":596,"kind":13},{"kind":13,"line":597,"containerName":"recompute","name":"$self"},{"kind":12,"line":597,"containerName":"recompute","name":"throw"},{"name":"$self","containerName":"recompute","line":597,"kind":13},{"line":598,"kind":13,"name":"$self","containerName":"recompute"},{"kind":12,"line":598,"name":"is_dag","containerName":"recompute"},{"line":599,"kind":13,"localvar":"my","definition":"my","name":"@leaves","containerName":"recompute"},{"line":599,"kind":13,"containerName":"recompute","name":"$self"},{"name":"successorless_vertices","containerName":"recompute","kind":12,"line":599},{"kind":13,"line":600,"name":"@leaves","containerName":"recompute"},{"line":600,"kind":13,"containerName":"recompute","name":"@leaves"},{"localvar":"my","containerName":"recompute","definition":"my","name":"$numleaves","line":601,"kind":13},{"containerName":"recompute","name":"@leaves","line":601,"kind":13},{"line":602,"kind":13,"localvar":"my","name":"@roots","definition":"my","containerName":"recompute"},{"name":"$self","containerName":"recompute","line":602,"kind":13},{"kind":12,"line":602,"containerName":"recompute","name":"predecessorless_vertices"},{"containerName":"recompute","definition":"my","name":"$numroots","localvar":"my","kind":13,"line":603},{"name":"@roots","containerName":"recompute","kind":13,"line":603},{"line":605,"kind":13,"localvar":"my","containerName":"recompute","name":"@nodes","definition":"my"},{"kind":13,"line":605,"containerName":"recompute","name":"$self"},{"containerName":"recompute","name":"vertices","kind":12,"line":605},{"containerName":"recompute","name":"@nodes","line":606,"kind":13},{"kind":13,"line":606,"name":"@nodes","containerName":"recompute"},{"line":607,"kind":13,"localvar":"my","name":"$numnodes","definition":"my","containerName":"recompute"},{"containerName":"recompute","name":"@nodes","kind":13,"line":607},{"localvar":"my","containerName":"recompute","definition":"my","name":"$node","line":608,"kind":13},{"name":"@nodes","containerName":"recompute","line":608,"kind":13},{"line":609,"kind":13,"containerName":"recompute","name":"$self"},{"line":609,"kind":13,"name":"$node","containerName":"recompute"},{"name":"$self","containerName":"recompute","line":610,"kind":13},{"kind":13,"line":610,"containerName":"recompute","name":"$node"},{"name":"$self","containerName":"recompute","line":613,"kind":13},{"line":613,"kind":13,"containerName":"recompute","name":"@leaves"},{"name":"$self","containerName":"recompute","line":614,"kind":13},{"kind":13,"line":614,"containerName":"recompute","name":"$numleaves"},{"name":"$self","containerName":"recompute","kind":13,"line":615},{"kind":13,"line":615,"name":"@roots","containerName":"recompute"},{"name":"$self","containerName":"recompute","line":616,"kind":13},{"name":"$numroots","containerName":"recompute","line":616,"kind":13},{"kind":13,"line":617,"containerName":"recompute","name":"$self"},{"name":"@nodes","containerName":"recompute","line":617,"kind":13},{"name":"$self","containerName":"recompute","line":618,"kind":13},{"line":618,"kind":13,"containerName":"recompute","name":"$numnodes"},{"kind":13,"line":619,"name":"$self","containerName":"recompute"},{"line":620,"kind":13,"containerName":"recompute","name":"$self"},{"line":621,"kind":13,"containerName":"recompute","name":"$self"},{"name":"compute_height","containerName":"recompute","kind":12,"line":621},{"name":"$self","containerName":"recompute","line":622,"kind":13},{"containerName":"recompute","name":"compute_mu","kind":12,"line":622},{"name":"$self","containerName":"recompute","line":623,"kind":13}],"line":595,"kind":12},{"name":"graph","line":597,"kind":12},{"name":"graph","line":598,"kind":12},{"name":"graph","line":599,"kind":12},{"line":602,"kind":12,"name":"graph"},{"name":"graph","line":605,"kind":12},{"kind":12,"line":609,"name":"labels"},{"name":"labels","line":610,"kind":12},{"name":"leaves","kind":12,"line":613},{"line":614,"kind":12,"name":"numleaves"},{"name":"roots","kind":12,"line":615},{"kind":12,"line":616,"name":"numroots"},{"line":617,"kind":12,"name":"nodes"},{"name":"numnodes","kind":12,"line":618},{"line":619,"kind":12,"name":"mudata"},{"name":"is_attackable","range":{"end":{"character":9999,"line":640},"start":{"character":0,"line":628}},"kind":12,"line":628,"children":[{"kind":13,"line":629,"containerName":"is_attackable","name":"$self","definition":"my","localvar":"my"},{"name":"$u1","containerName":"is_attackable","kind":13,"line":629},{"line":629,"kind":13,"name":"$v1","containerName":"is_attackable"},{"name":"$u2","containerName":"is_attackable","line":629,"kind":13},{"kind":13,"line":629,"containerName":"is_attackable","name":"$v2"},{"name":"$self","containerName":"is_attackable","kind":13,"line":630},{"kind":12,"line":630,"containerName":"is_attackable","name":"is_hybrid_node"},{"kind":13,"line":630,"containerName":"is_attackable","name":"$v1"},{"line":631,"kind":13,"name":"$self","containerName":"is_attackable"},{"name":"is_hybrid_node","containerName":"is_attackable","line":631,"kind":12},{"kind":13,"line":631,"containerName":"is_attackable","name":"$v2"},{"name":"$self","containerName":"is_attackable","kind":13,"line":632},{"kind":12,"line":632,"containerName":"is_attackable","name":"graph"},{"line":632,"kind":12,"name":"is_reachable","containerName":"is_attackable"},{"kind":13,"line":632,"containerName":"is_attackable","name":"$v2"},{"name":"$u1","containerName":"is_attackable","kind":13,"line":632},{"containerName":"is_attackable","name":"$u1","kind":13,"line":633},{"name":"$u2","containerName":"is_attackable","kind":13,"line":633},{"containerName":"is_attackable","name":"$v1","kind":13,"line":633},{"name":"$v2","containerName":"is_attackable","line":633,"kind":13},{"containerName":"is_attackable","name":"$v2","kind":13,"line":634},{"kind":13,"line":634,"containerName":"is_attackable","name":"$self"},{"name":"is_tree_node","containerName":"is_attackable","line":634,"kind":12},{"line":635,"kind":13,"containerName":"is_attackable","name":"$self"},{"kind":12,"line":635,"containerName":"is_attackable","name":"graph"},{"name":"successors","containerName":"is_attackable","kind":12,"line":635},{"containerName":"is_attackable","name":"$u2","line":635,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$u1,$v1,$u2,$v2)","signature":{"parameters":[{"label":"$self"},{"label":"$u1"},{"label":"$v1"},{"label":"$u2"},{"label":"$v2"}],"documentation":" Hybridizing","label":"is_attackable($self,$u1,$v1,$u2,$v2)"}},{"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$u1"},{"label":"$v1"},{"label":"$u2"},{"label":"$v2"},{"label":"$lbl"}],"label":"do_attack($self,$u1,$v1,$u2,$v2,$lbl)"},"detail":"($self,$u1,$v1,$u2,$v2,$lbl)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"do_attack","localvar":"my","kind":13,"line":643},{"name":"$u1","containerName":"do_attack","kind":13,"line":643},{"kind":13,"line":643,"containerName":"do_attack","name":"$v1"},{"line":643,"kind":13,"containerName":"do_attack","name":"$u2"},{"name":"$v2","containerName":"do_attack","line":643,"kind":13},{"kind":13,"line":643,"name":"$lbl","containerName":"do_attack"},{"line":644,"kind":13,"localvar":"my","name":"$graph","definition":"my","containerName":"do_attack"},{"line":644,"kind":13,"containerName":"do_attack","name":"$self"},{"containerName":"do_attack","name":"$graph","line":645,"kind":13},{"kind":12,"line":645,"containerName":"do_attack","name":"delete_edge"},{"name":"$u1","containerName":"do_attack","kind":13,"line":645},{"containerName":"do_attack","name":"$v1","kind":13,"line":645},{"kind":13,"line":646,"containerName":"do_attack","name":"$graph"},{"line":646,"kind":12,"containerName":"do_attack","name":"delete_edge"},{"containerName":"do_attack","name":"$u2","line":646,"kind":13},{"line":646,"kind":13,"containerName":"do_attack","name":"$v2"},{"containerName":"do_attack","name":"$graph","kind":13,"line":647},{"name":"add_edge","containerName":"do_attack","kind":12,"line":647},{"containerName":"do_attack","name":"$u1","kind":13,"line":647},{"name":"$graph","containerName":"do_attack","line":648,"kind":13},{"kind":12,"line":648,"name":"add_edge","containerName":"do_attack"},{"line":648,"kind":13,"name":"$v1","containerName":"do_attack"},{"kind":13,"line":649,"containerName":"do_attack","name":"$graph"},{"line":649,"kind":12,"containerName":"do_attack","name":"add_edge"},{"containerName":"do_attack","name":"$u2","kind":13,"line":649},{"name":"$graph","containerName":"do_attack","kind":13,"line":650},{"containerName":"do_attack","name":"add_edge","line":650,"kind":12},{"line":650,"kind":13,"containerName":"do_attack","name":"$v2"},{"line":651,"kind":13,"name":"$graph","containerName":"do_attack"},{"name":"add_edge","containerName":"do_attack","kind":12,"line":651},{"kind":13,"line":652,"name":"$self","containerName":"do_attack"},{"kind":12,"line":652,"name":"build_from_graph","containerName":"do_attack"},{"kind":13,"line":652,"name":"$graph","containerName":"do_attack"}],"line":642,"name":"do_attack","range":{"end":{"character":9999,"line":653},"start":{"character":0,"line":642}}},{"name":"graph","line":644,"kind":12},{"range":{"start":{"character":0,"line":658},"end":{"line":662,"character":9999}},"name":"compute_mu","signature":{"documentation":" Computation of mu-data","parameters":[{"label":"$self"}],"label":"compute_mu($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":659,"containerName":"compute_mu","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","containerName":"compute_mu","definition":"my","name":"$graph","line":660,"kind":13},{"line":660,"kind":13,"containerName":"compute_mu","name":"$self"},{"kind":13,"line":661,"containerName":"compute_mu","definition":"my","name":"$mudata","localvar":"my"},{"line":661,"kind":13,"containerName":"compute_mu","name":"$self"},{"containerName":"compute_mu","definition":"my","name":"@leaves","localvar":"my","kind":13,"line":662},{"name":"$self","containerName":"compute_mu","kind":13,"line":662}],"line":658,"kind":12},{"line":660,"kind":12,"name":"graph"},{"name":"mudata","kind":12,"line":661},{"line":662,"kind":12,"name":"leaves"},{"name":"$numleaves","definition":"my","containerName":null,"localvar":"my","kind":13,"line":663},{"kind":13,"line":663,"name":"%self","containerName":null},{"name":"numleaves","kind":12,"line":663},{"line":664,"kind":13,"localvar":"my","containerName":null,"name":"$i","definition":"my"},{"containerName":null,"name":"$i","kind":13,"line":664},{"name":"$numleaves","containerName":null,"kind":13,"line":664},{"containerName":null,"name":"%i","kind":13,"line":664},{"line":665,"kind":13,"localvar":"my","name":"$vec","definition":"my","containerName":null},{"containerName":"PhyloNetwork::muVector","name":"Bio","kind":12,"line":665},{"kind":12,"line":665,"name":"new","containerName":"main::"},{"line":665,"kind":13,"name":"$numleaves","containerName":null},{"line":666,"kind":13,"name":"@vec","containerName":null},{"line":666,"kind":13,"name":"$i","containerName":null},{"line":667,"kind":13,"name":"%mudata","containerName":null},{"containerName":null,"name":"@leaves","kind":13,"line":667},{"containerName":null,"name":"$i","line":667,"kind":13},{"containerName":null,"name":"$vec","line":667,"kind":13},{"localvar":"my","name":"$h","definition":"my","containerName":null,"line":669,"kind":13},{"kind":13,"line":670,"containerName":null,"name":"@nodes","definition":"my","localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":670},{"containerName":null,"name":"$h","line":670,"kind":13},{"name":"%self","containerName":null,"line":670,"kind":13},{"name":"nodes","line":670,"kind":12},{"definition":"my","name":"$u","containerName":null,"localvar":"my","kind":13,"line":672},{"kind":13,"line":672,"name":"@nodes","containerName":null},{"line":673,"kind":13,"localvar":"my","definition":"my","name":"$vec","containerName":null},{"kind":12,"line":673,"name":"Bio","containerName":"PhyloNetwork::muVector"},{"line":673,"kind":12,"containerName":"main::","name":"new"},{"line":673,"kind":13,"containerName":null,"name":"$numleaves"},{"definition":"my","name":"$son","containerName":null,"localvar":"my","kind":13,"line":674},{"kind":13,"line":674,"name":"$graph","containerName":null},{"name":"successors","containerName":"main::","kind":12,"line":674},{"name":"%u","containerName":null,"kind":13,"line":674},{"line":675,"kind":13,"containerName":null,"name":"$vec"},{"kind":13,"line":675,"name":"%mudata","containerName":null},{"name":"$son","containerName":null,"line":675,"kind":13},{"containerName":null,"name":"%mudata","kind":13,"line":677},{"containerName":null,"name":"$u","line":677,"kind":13},{"name":"$vec","containerName":null,"kind":13,"line":677},{"kind":13,"line":679,"containerName":null,"name":"$h"},{"range":{"end":{"character":9999,"line":686},"start":{"character":0,"line":683}},"name":"compute_height","line":683,"children":[{"kind":13,"line":684,"containerName":"compute_height","name":"$self","definition":"my","localvar":"my"},{"line":685,"kind":13,"localvar":"my","definition":"my","name":"$graph","containerName":"compute_height"},{"name":"$self","containerName":"compute_height","kind":13,"line":685},{"localvar":"my","name":"@leaves","definition":"my","containerName":"compute_height","line":686,"kind":13},{"line":686,"kind":13,"containerName":"compute_height","name":"$self"}],"kind":12,"detail":"($self)","signature":{"label":"compute_height($self)","documentation":"","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"kind":12,"line":685,"name":"graph"},{"line":686,"kind":12,"name":"leaves"},{"line":687,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$leaf"},{"name":"@leaves","containerName":null,"line":687,"kind":13},{"name":"%self","containerName":null,"line":688,"kind":13},{"kind":13,"line":688,"containerName":null,"name":"$leaf"},{"line":690,"kind":13,"localvar":"my","containerName":null,"name":"$h","definition":"my"},{"containerName":null,"definition":"my","name":"@nodes","localvar":"my","kind":13,"line":691},{"containerName":null,"name":"%self","line":691,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":691},{"line":691,"kind":13,"name":"$h","containerName":null},{"kind":13,"line":692,"containerName":null,"name":"%self"},{"kind":12,"line":692,"name":"nodes"},{"localvar":"my","containerName":null,"name":"$node","definition":"my","line":694,"kind":13},{"line":694,"kind":13,"containerName":null,"name":"@nodes"},{"kind":13,"line":695,"definition":"my","name":"$parent","containerName":null,"localvar":"my"},{"containerName":null,"name":"$graph","kind":13,"line":695},{"name":"predecessors","containerName":"main::","kind":12,"line":695},{"containerName":null,"name":"%node","kind":13,"line":695},{"kind":13,"line":696,"name":"%self","containerName":null},{"kind":13,"line":696,"name":"$parent","containerName":null},{"containerName":null,"name":"$h","line":696,"kind":13},{"name":"$h","containerName":null,"kind":13,"line":699},{"definition":"sub","containerName":"main::","signature":{"label":"is_leaf($self,$node)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar","parameters":[{"label":"$self"},{"label":"$node"}]},"detail":"($self,$node)","kind":12,"children":[{"line":716,"kind":13,"localvar":"my","containerName":"is_leaf","name":"$self","definition":"my"},{"line":716,"kind":13,"name":"$node","containerName":"is_leaf"},{"line":717,"kind":13,"name":"$self","containerName":"is_leaf"},{"containerName":"is_leaf","name":"out_degree","line":717,"kind":12},{"line":717,"kind":13,"containerName":"is_leaf","name":"$node"}],"line":715,"name":"is_leaf","range":{"start":{"line":715,"character":0},"end":{"line":719,"character":9999}}},{"kind":12,"line":717,"name":"graph"},{"definition":"sub","containerName":"main::","signature":{"label":"is_root($self,$node)","parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar"},"detail":"($self,$node)","kind":12,"children":[{"kind":13,"line":732,"definition":"my","name":"$self","containerName":"is_root","localvar":"my"},{"kind":13,"line":732,"name":"$node","containerName":"is_root"},{"kind":13,"line":733,"containerName":"is_root","name":"$self"},{"containerName":"is_root","name":"in_degree","kind":12,"line":733},{"line":733,"kind":13,"name":"$node","containerName":"is_root"}],"line":731,"name":"is_root","range":{"start":{"line":731,"character":0},"end":{"character":9999,"line":735}}},{"line":733,"kind":12,"name":"graph"},{"detail":"($self,$node)","signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar","label":"is_tree_node($self,$node)"},"containerName":"main::","definition":"sub","line":747,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"is_tree_node","line":748,"kind":13},{"line":748,"kind":13,"containerName":"is_tree_node","name":"$node"},{"kind":13,"line":749,"name":"$self","containerName":"is_tree_node"},{"containerName":"is_tree_node","name":"in_degree","kind":12,"line":749},{"name":"$node","containerName":"is_tree_node","line":749,"kind":13}],"kind":12,"range":{"end":{"line":751,"character":9999},"start":{"line":747,"character":0}},"name":"is_tree_node"},{"name":"graph","line":749,"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$node"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar","label":"is_hybrid_node($self,$node)"},"detail":"($self,$node)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"is_hybrid_node","localvar":"my","kind":13,"line":764},{"name":"$node","containerName":"is_hybrid_node","line":764,"kind":13},{"kind":13,"line":765,"name":"$self","containerName":"is_hybrid_node"},{"containerName":"is_hybrid_node","name":"in_degree","line":765,"kind":12},{"name":"$node","containerName":"is_hybrid_node","kind":13,"line":765}],"line":763,"kind":12,"range":{"end":{"line":767,"character":9999},"start":{"line":763,"character":0}},"name":"is_hybrid_node"},{"name":"graph","line":765,"kind":12},{"range":{"start":{"character":0,"line":769},"end":{"character":9999,"line":781}},"containerName":"main::","definition":"sub","name":"has_tree_child","line":769,"children":[{"line":772,"kind":13,"localvar":"my","definition":"my","name":"$g","containerName":"has_tree_child"},{"localvar":"my","containerName":"has_tree_child","definition":"my","name":"$node","line":773,"kind":13},{"line":774,"kind":13,"localvar":"my","definition":"my","name":"@Sons","containerName":"has_tree_child"},{"containerName":"has_tree_child","name":"$g","line":774,"kind":13},{"name":"successors","containerName":"has_tree_child","kind":12,"line":774},{"containerName":"has_tree_child","name":"$node","line":774,"kind":13},{"definition":"my","name":"$son","containerName":"has_tree_child","localvar":"my","kind":13,"line":775},{"containerName":"has_tree_child","name":"@Sons","line":775,"kind":13},{"containerName":"has_tree_child","name":"$g","line":776,"kind":13},{"containerName":"has_tree_child","name":"in_degree","kind":12,"line":776},{"containerName":"has_tree_child","name":"$son","kind":13,"line":776}],"kind":12},{"children":[{"kind":13,"line":794,"containerName":"is_tree_child","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"is_tree_child","line":795,"kind":13},{"kind":13,"line":796,"containerName":"is_tree_child","name":"$self"},{"kind":13,"line":798,"name":"$self","containerName":"is_tree_child"},{"kind":13,"line":799,"containerName":"is_tree_child","definition":"my","name":"$graph","localvar":"my"},{"name":"$self","containerName":"is_tree_child","line":799,"kind":13},{"containerName":"is_tree_child","name":"$node","definition":"my","localvar":"my","kind":13,"line":800},{"name":"$self","containerName":"is_tree_child","line":800,"kind":13}],"line":793,"kind":12,"signature":{"label":"is_tree_child($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"end":{"line":800,"character":9999},"start":{"line":793,"character":0}},"name":"is_tree_child"},{"name":"is_tree_child","kind":12,"line":795},{"name":"is_tree_child","line":796,"kind":12},{"name":"is_tree_child","kind":12,"line":798},{"name":"graph","line":799,"kind":12},{"line":800,"kind":12,"name":"nodes"},{"kind":13,"line":801,"name":"$graph","containerName":null},{"kind":12,"line":801,"name":"out_degree","containerName":"main::"},{"containerName":null,"name":"$node","kind":13,"line":801},{"name":"$graph","containerName":null,"kind":13,"line":802},{"line":802,"kind":13,"containerName":null,"name":"$node"},{"kind":13,"line":804,"name":"%self","containerName":null},{"name":"is_tree_child","kind":12,"line":804},{"name":"nodes","range":{"end":{"line":822,"character":9999},"start":{"character":0,"line":820}},"kind":12,"children":[{"line":821,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"nodes"},{"containerName":"nodes","name":"$self","kind":13,"line":822}],"line":820,"definition":"sub","containerName":"main::","signature":{"label":"nodes($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)"},{"line":822,"kind":12,"name":"nodes"},{"line":835,"children":[{"containerName":"leaves","name":"$self","definition":"my","localvar":"my","kind":13,"line":836},{"kind":13,"line":837,"containerName":"leaves","name":"$self"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}],"label":"leaves($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":835},"end":{"character":9999,"line":837}},"name":"leaves"},{"name":"leaves","kind":12,"line":837},{"range":{"start":{"character":0,"line":850},"end":{"character":9999,"line":852}},"name":"roots","detail":"($self)","signature":{"label":"roots($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub","line":850,"children":[{"localvar":"my","containerName":"roots","definition":"my","name":"$self","line":851,"kind":13},{"line":852,"kind":13,"name":"$self","containerName":"roots"}],"kind":12},{"kind":12,"line":852,"name":"roots"},{"name":"internal_nodes","range":{"start":{"character":0,"line":865},"end":{"line":868,"character":9999}},"kind":12,"children":[{"kind":13,"line":866,"containerName":"internal_nodes","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"internal_nodes","kind":13,"line":867},{"containerName":"internal_nodes","name":"is_leaf","line":867,"kind":12},{"line":867,"kind":13,"containerName":"internal_nodes","name":"$self"},{"kind":12,"line":867,"containerName":"internal_nodes","name":"nodes"}],"line":865,"definition":"sub","containerName":"main::","signature":{"label":"internal_nodes($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"detail":"($self)"},{"range":{"end":{"line":883,"character":9999},"start":{"line":880,"character":0}},"name":"tree_nodes","children":[{"kind":13,"line":881,"name":"$self","definition":"my","containerName":"tree_nodes","localvar":"my"},{"containerName":"tree_nodes","name":"$self","kind":13,"line":882},{"containerName":"tree_nodes","name":"is_tree_node","kind":12,"line":882},{"name":"$self","containerName":"tree_nodes","line":882,"kind":13},{"kind":12,"line":882,"containerName":"tree_nodes","name":"nodes"}],"line":880,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none","label":"tree_nodes($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none","label":"hybrid_nodes($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"hybrid_nodes","name":"$self","definition":"my","line":896,"kind":13},{"containerName":"hybrid_nodes","name":"$self","line":897,"kind":13},{"kind":12,"line":897,"name":"is_hybrid_node","containerName":"hybrid_nodes"},{"containerName":"hybrid_nodes","name":"$self","line":897,"kind":13},{"containerName":"hybrid_nodes","name":"nodes","line":897,"kind":12}],"line":895,"kind":12,"range":{"end":{"character":9999,"line":898},"start":{"line":895,"character":0}},"name":"hybrid_nodes"},{"name":"graph","range":{"end":{"character":9999,"line":913},"start":{"character":0,"line":910}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"graph($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none"},"kind":12,"line":910,"children":[{"definition":"my","name":"$self","containerName":"graph","localvar":"my","kind":13,"line":911},{"line":912,"kind":13,"name":"$self","containerName":"graph"}]},{"name":"graph","line":912,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.","label":"edges($self)"},"kind":12,"line":928,"children":[{"containerName":"edges","name":"$self","definition":"my","localvar":"my","kind":13,"line":929},{"kind":13,"line":930,"containerName":"edges","name":"$self"},{"kind":12,"line":930,"name":"edges","containerName":"edges"}],"name":"edges","range":{"end":{"character":9999,"line":931},"start":{"character":0,"line":928}}},{"name":"graph","line":930,"kind":12},{"kind":12,"line":944,"children":[{"containerName":"tree_edges","name":"$self","definition":"my","localvar":"my","kind":13,"line":945},{"containerName":"tree_edges","name":"$self","kind":13,"line":946},{"line":946,"kind":12,"containerName":"tree_edges","name":"is_tree_node"},{"name":"$self","containerName":"tree_edges","line":946,"kind":13},{"kind":12,"line":946,"containerName":"tree_edges","name":"edges"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"tree_edges($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none","parameters":[{"label":"$self"}]},"name":"tree_edges","range":{"end":{"line":947,"character":9999},"start":{"line":944,"character":0}}},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none","parameters":[{"label":"$self"}],"label":"hybrid_edges($self)"},"kind":12,"line":960,"children":[{"kind":13,"line":961,"name":"$self","definition":"my","containerName":"hybrid_edges","localvar":"my"},{"name":"$self","containerName":"hybrid_edges","kind":13,"line":962},{"kind":12,"line":962,"containerName":"hybrid_edges","name":"is_hybrid_node"},{"line":962,"kind":13,"name":"$self","containerName":"hybrid_edges"},{"line":962,"kind":12,"containerName":"hybrid_edges","name":"edges"}],"name":"hybrid_edges","range":{"end":{"line":963,"character":9999},"start":{"character":0,"line":960}}},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none","label":"explode($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"explode","definition":"my","name":"$self","line":977,"kind":13},{"kind":13,"line":978,"definition":"my","name":"@trees","containerName":"explode","localvar":"my"},{"name":"$self","containerName":"explode","line":979,"kind":13},{"kind":12,"line":979,"containerName":"explode","name":"explode_rec"},{"line":979,"kind":13,"name":"@trees","containerName":"explode"},{"kind":13,"line":980,"name":"@trees","containerName":"explode"}],"line":976,"kind":12,"range":{"start":{"character":0,"line":976},"end":{"character":9999,"line":981}},"name":"explode"},{"name":"explode_rec","range":{"end":{"character":9999,"line":999},"start":{"character":0,"line":983}},"definition":"sub","containerName":"main::","signature":{"label":"explode_rec($self,$trees)","parameters":[{"label":"$self"},{"label":"$trees"}],"documentation":""},"detail":"($self,$trees)","kind":12,"children":[{"kind":13,"line":984,"containerName":"explode_rec","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":984,"name":"$trees","containerName":"explode_rec"},{"line":985,"kind":13,"localvar":"my","containerName":"explode_rec","name":"@h","definition":"my"},{"containerName":"explode_rec","name":"$self","kind":13,"line":985},{"line":985,"kind":12,"name":"hybrid_nodes","containerName":"explode_rec"},{"kind":13,"line":986,"containerName":"explode_rec","name":"@h"},{"line":987,"kind":13,"localvar":"my","definition":"my","name":"$v","containerName":"explode_rec"},{"line":987,"kind":13,"containerName":"explode_rec","name":"@h"},{"line":988,"kind":13,"localvar":"my","containerName":"explode_rec","name":"$u","definition":"my"},{"name":"$self","containerName":"explode_rec","line":988,"kind":13},{"containerName":"explode_rec","name":"predecessors","kind":12,"line":988},{"kind":13,"line":988,"name":"$v","containerName":"explode_rec"},{"kind":13,"line":989,"name":"$self","containerName":"explode_rec"},{"containerName":"explode_rec","name":"delete_edge","kind":12,"line":989},{"name":"$u","containerName":"explode_rec","kind":13,"line":989},{"containerName":"explode_rec","name":"$v","kind":13,"line":989},{"containerName":"explode_rec","name":"$self","kind":13,"line":990},{"kind":12,"line":990,"containerName":"explode_rec","name":"explode_rec"},{"line":990,"kind":13,"name":"$trees","containerName":"explode_rec"},{"kind":13,"line":991,"containerName":"explode_rec","name":"$self"},{"kind":12,"line":991,"containerName":"explode_rec","name":"add_edge"},{"name":"$u","containerName":"explode_rec","kind":13,"line":991},{"line":991,"kind":13,"name":"$v","containerName":"explode_rec"},{"kind":13,"line":994,"name":"$io","definition":"my","containerName":"explode_rec","localvar":"my"},{"kind":12,"line":994,"name":"new","containerName":"explode_rec"},{"containerName":"explode_rec","name":"$self","line":994,"kind":13},{"line":994,"kind":12,"name":"eNewick","containerName":"explode_rec"},{"containerName":"explode_rec","definition":"my","name":"$treeio","localvar":"my","kind":13,"line":995},{"line":995,"kind":12,"containerName":"explode_rec","name":"new"},{"name":"$io","containerName":"explode_rec","line":995,"kind":13},{"localvar":"my","name":"$tree","definition":"my","containerName":"explode_rec","line":996,"kind":13},{"containerName":"explode_rec","name":"$treeio","line":996,"kind":13},{"name":"next_tree","containerName":"explode_rec","kind":12,"line":996},{"line":997,"kind":13,"containerName":"explode_rec","name":"$tree"},{"name":"contract_linear_paths","containerName":"explode_rec","kind":12,"line":997},{"containerName":"explode_rec","name":"$trees","kind":13,"line":998},{"name":"$tree","containerName":"explode_rec","kind":13,"line":998}],"line":983},{"name":"graph","kind":12,"line":988},{"name":"graph","line":989,"kind":12},{"name":"graph","line":991,"kind":12},{"kind":12,"line":994,"containerName":"String","name":"IO"},{"line":995,"kind":12,"name":"Bio","containerName":"TreeIO"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.","label":"mudata($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"mudata","name":"$self","definition":"my","line":1016,"kind":13},{"containerName":"mudata","name":"$self","kind":13,"line":1017}],"line":1015,"kind":12,"range":{"end":{"line":1017,"character":9999},"start":{"character":0,"line":1015}},"name":"mudata"},{"name":"mudata","line":1017,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$u)","signature":{"label":"mudata_node($self,$u)","documentation":"","parameters":[{"label":"$self"},{"label":"$u"}]},"kind":12,"line":1020,"children":[{"line":1021,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"mudata_node"},{"name":"$u","containerName":"mudata_node","kind":13,"line":1021},{"containerName":"mudata_node","name":"$self","line":1022,"kind":13},{"name":"$u","containerName":"mudata_node","line":1022,"kind":13}],"name":"mudata_node","range":{"start":{"line":1020,"character":0},"end":{"line":1023,"character":9999}}},{"name":"mudata","kind":12,"line":1022},{"range":{"end":{"character":9999,"line":1040},"start":{"line":1038,"character":0}},"name":"heights","line":1038,"children":[{"line":1039,"kind":13,"localvar":"my","containerName":"heights","name":"$self","definition":"my"},{"name":"$self","containerName":"heights","kind":13,"line":1040}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.","parameters":[{"label":"$self"}],"label":"heights($self)"},"containerName":"main::","definition":"sub"},{"name":"height_node","range":{"end":{"line":1046,"character":9999},"start":{"line":1043,"character":0}},"kind":12,"line":1043,"children":[{"kind":13,"line":1044,"containerName":"height_node","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1044,"name":"$u","containerName":"height_node"},{"name":"$self","containerName":"height_node","kind":13,"line":1045},{"containerName":"height_node","name":"$u","line":1045,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$u)","signature":{"label":"height_node($self,$u)","documentation":"","parameters":[{"label":"$self"},{"label":"$u"}]}},{"name":"mu_distance","range":{"start":{"character":0,"line":1059},"end":{"line":1070,"character":9999}},"kind":12,"line":1059,"children":[{"kind":13,"line":1060,"containerName":"mu_distance","definition":"my","name":"$net1","localvar":"my"},{"line":1060,"kind":13,"containerName":"mu_distance","name":"$net2"},{"kind":13,"line":1061,"containerName":"mu_distance","name":"@nodes1","definition":"my","localvar":"my"},{"line":1061,"kind":13,"name":"$net1","containerName":"mu_distance"},{"containerName":"mu_distance","name":"nodes","line":1061,"kind":12},{"line":1062,"kind":13,"localvar":"my","containerName":"mu_distance","definition":"my","name":"@nodes2"},{"line":1062,"kind":13,"containerName":"mu_distance","name":"$net2"},{"line":1062,"kind":12,"containerName":"mu_distance","name":"nodes"},{"line":1063,"kind":13,"localvar":"my","containerName":"mu_distance","name":"$comp","definition":"my"},{"containerName":"mu_distance","name":"new","kind":12,"line":1063},{"name":"$net1","containerName":"mu_distance","line":1064,"kind":13},{"name":"throw","containerName":"mu_distance","kind":12,"line":1064},{"kind":13,"line":1065,"name":"$comp","containerName":"mu_distance"},{"containerName":"mu_distance","name":"compare","line":1065,"kind":12},{"kind":13,"line":1065,"containerName":"mu_distance","name":"$net1"},{"line":1065,"kind":13,"name":"$net2","containerName":"mu_distance"},{"name":"$net1","containerName":"mu_distance","kind":13,"line":1066},{"line":1066,"kind":12,"name":"warn","containerName":"mu_distance"},{"line":1067,"kind":13,"containerName":"mu_distance","name":"$net1"},{"kind":12,"line":1067,"containerName":"mu_distance","name":"is_tree_child"},{"name":"$net2","containerName":"mu_distance","kind":13,"line":1068},{"name":"warn","containerName":"mu_distance","line":1068,"kind":12},{"kind":13,"line":1069,"name":"$net2","containerName":"mu_distance"},{"kind":12,"line":1069,"containerName":"mu_distance","name":"is_tree_child"},{"kind":13,"line":1070,"containerName":"mu_distance","definition":"my","name":"@leaves","localvar":"my"},{"containerName":"mu_distance","name":"$net1","kind":13,"line":1070}],"containerName":"main::","definition":"sub","detail":"($net1,$net2)","signature":{"label":"mu_distance($net1,$net2)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork","parameters":[{"label":"$net1"},{"label":"$net2"}]}},{"name":"Array","containerName":"Compare","kind":12,"line":1063},{"name":"leaves","line":1065,"kind":12},{"name":"leaves","line":1065,"kind":12},{"kind":12,"line":1070,"name":"leaves"},{"kind":13,"line":1071,"definition":"my","name":"%matched1","containerName":null,"localvar":"my"},{"localvar":"my","name":"%matched2","definition":"my","containerName":null,"line":1072,"kind":13},{"name":"OUTER","line":1073,"kind":12},{"localvar":"my","definition":"my","name":"$node1","containerName":null,"line":1073,"kind":13},{"line":1073,"kind":13,"name":"@nodes1","containerName":null},{"localvar":"my","definition":"my","name":"$node2","containerName":null,"line":1074,"kind":13},{"line":1074,"kind":13,"name":"@nodes2","containerName":null},{"containerName":null,"name":"%matched1","kind":13,"line":1076},{"containerName":null,"name":"$node1","kind":13,"line":1076},{"line":1076,"kind":13,"containerName":null,"name":"%matched2"},{"containerName":null,"name":"$node2","kind":13,"line":1076},{"kind":13,"line":1077,"name":"%net1","containerName":null},{"name":"mudata","line":1077,"kind":12},{"line":1077,"kind":13,"name":"$node1","containerName":null},{"containerName":null,"name":"%net2","kind":13,"line":1077},{"line":1077,"kind":12,"name":"mudata"},{"kind":13,"line":1077,"name":"%node2","containerName":null},{"kind":13,"line":1079,"name":"%matched1","containerName":null},{"kind":13,"line":1079,"containerName":null,"name":"$node1"},{"name":"$node2","containerName":null,"kind":13,"line":1079},{"containerName":null,"name":"%matched2","line":1080,"kind":13},{"containerName":null,"name":"$node2","kind":13,"line":1080},{"kind":13,"line":1080,"containerName":null,"name":"$node1"},{"name":"OUTER","line":1081,"kind":12},{"name":"@nodes1","containerName":null,"line":1085,"kind":13},{"kind":13,"line":1085,"containerName":null,"name":"@nodes2"},{"kind":13,"line":1085,"name":"%matched1","containerName":null},{"name":"mu_distance_generalized","range":{"start":{"line":1099,"character":0},"end":{"line":1103,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$net1"},{"label":"$net2"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork","label":"mu_distance_generalized($net1,$net2)"},"detail":"($net1,$net2)","kind":12,"children":[{"name":"$net1","definition":"my","containerName":"mu_distance_generalized","localvar":"my","kind":13,"line":1100},{"name":"$net2","containerName":"mu_distance_generalized","line":1100,"kind":13},{"localvar":"my","containerName":"mu_distance_generalized","name":"$netr1","definition":"my","line":1101,"kind":13},{"containerName":"mu_distance_generalized","name":"$netr2","line":1101,"kind":13},{"kind":13,"line":1101,"containerName":"mu_distance_generalized","name":"$net1"},{"name":"topological_restriction","containerName":"mu_distance_generalized","kind":12,"line":1101},{"kind":13,"line":1101,"name":"$net2","containerName":"mu_distance_generalized"},{"name":"$netr1","containerName":"mu_distance_generalized","line":1102,"kind":13},{"line":1102,"kind":12,"name":"mu_distance","containerName":"mu_distance_generalized"},{"name":"$netr2","containerName":"mu_distance_generalized","line":1102,"kind":13}],"line":1099},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$u"}],"documentation":" mudata_string (code mu_data in a string; useful for isomorphism testing)","label":"mudata_string_node($self,$u)"},"detail":"($self,$u)","kind":12,"children":[{"kind":13,"line":1108,"containerName":"mudata_string_node","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":1108,"name":"$u","containerName":"mudata_string_node"},{"line":1109,"kind":13,"name":"$self","containerName":"mudata_string_node"},{"line":1109,"kind":13,"name":"$u","containerName":"mudata_string_node"},{"containerName":"mudata_string_node","name":"display","kind":12,"line":1109}],"line":1107,"name":"mudata_string_node","range":{"end":{"line":1110,"character":9999},"start":{"line":1107,"character":0}}},{"name":"mudata","kind":12,"line":1109},{"name":"mudata_string","range":{"start":{"character":0,"line":1112},"end":{"line":1124,"character":9999}},"kind":12,"children":[{"line":1113,"kind":13,"localvar":"my","containerName":"mudata_string","definition":"my","name":"$self"},{"containerName":"mudata_string","name":"$self","line":1114,"kind":13},{"containerName":"mudata_string","name":"$self","kind":13,"line":1114},{"kind":13,"line":1115,"name":"@internal","definition":"my","containerName":"mudata_string","localvar":"my"},{"name":"$self","containerName":"mudata_string","kind":13,"line":1115},{"name":"internal_nodes","containerName":"mudata_string","line":1115,"kind":12},{"line":1116,"kind":13,"localvar":"my","name":"$mus","definition":"my","containerName":"mudata_string"},{"kind":13,"line":1116,"name":"$self","containerName":"mudata_string"},{"name":"@internal","containerName":"mudata_string","kind":13,"line":1117},{"line":1117,"kind":13,"name":"$mus","containerName":"mudata_string"},{"containerName":"mudata_string","name":"$b","line":1117,"kind":13},{"name":"$mus","containerName":"mudata_string","kind":13,"line":1117},{"kind":13,"line":1117,"name":"$a","containerName":"mudata_string"},{"kind":13,"line":1117,"name":"@internal","containerName":"mudata_string"},{"definition":"my","name":"$str","containerName":"mudata_string","localvar":"my","kind":13,"line":1118},{"kind":13,"line":1119,"containerName":"mudata_string","name":"$node","definition":"my","localvar":"my"},{"line":1119,"kind":13,"containerName":"mudata_string","name":"@internal"},{"line":1120,"kind":13,"containerName":"mudata_string","name":"$str"},{"kind":13,"line":1120,"name":"$str","containerName":"mudata_string"},{"containerName":"mudata_string","name":"$self","line":1120,"kind":13},{"name":"mudata_string_node","containerName":"mudata_string","kind":12,"line":1120},{"kind":13,"line":1120,"name":"$node","containerName":"mudata_string"},{"kind":13,"line":1122,"name":"$self","containerName":"mudata_string"},{"line":1122,"kind":13,"name":"$str","containerName":"mudata_string"},{"containerName":"mudata_string","name":"$str","kind":13,"line":1123}],"line":1112,"definition":"sub","containerName":"main::","signature":{"label":"mudata_string($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)"},{"name":"mudata_string","line":1114,"kind":12},{"line":1114,"kind":12,"name":"mudata_string"},{"kind":12,"line":1116,"name":"mudata"},{"name":"mudata_string","kind":12,"line":1122},{"children":[{"kind":13,"line":1127,"containerName":"is_mu_isomorphic","name":"$net1","definition":"my","localvar":"my"},{"kind":13,"line":1127,"containerName":"is_mu_isomorphic","name":"$net2"},{"kind":13,"line":1128,"containerName":"is_mu_isomorphic","name":"$net1"},{"containerName":"is_mu_isomorphic","name":"mudata_string","line":1128,"kind":12},{"name":"$net2","containerName":"is_mu_isomorphic","kind":13,"line":1128},{"line":1128,"kind":12,"name":"mudata_string","containerName":"is_mu_isomorphic"}],"line":1126,"kind":12,"signature":{"label":"is_mu_isomorphic($net1,$net2)","parameters":[{"label":"$net1"},{"label":"$net2"}],"documentation":""},"detail":"($net1,$net2)","definition":"sub","containerName":"main::","range":{"end":{"line":1129,"character":9999},"start":{"line":1126,"character":0}},"name":"is_mu_isomorphic"},{"line":1133,"children":[{"containerName":"compute_tripartition_node","definition":"my","name":"$self","localvar":"my","kind":13,"line":1134},{"containerName":"compute_tripartition_node","name":"$u","line":1134,"kind":13},{"name":"$self","containerName":"compute_tripartition_node","line":1135,"kind":13},{"line":1135,"kind":12,"containerName":"compute_tripartition_node","name":"warn"},{"name":"$self","containerName":"compute_tripartition_node","line":1136,"kind":13},{"kind":13,"line":1137,"definition":"my","name":"$root","containerName":"compute_tripartition_node","localvar":"my"},{"line":1137,"kind":13,"name":"$self","containerName":"compute_tripartition_node"},{"localvar":"my","definition":"my","name":"$graph","containerName":"compute_tripartition_node","line":1138,"kind":13},{"name":"$self","containerName":"compute_tripartition_node","line":1138,"kind":13},{"localvar":"my","definition":"my","name":"$graphPruned","containerName":"compute_tripartition_node","line":1139,"kind":13},{"containerName":"compute_tripartition_node","name":"$graph","kind":13,"line":1139},{"kind":12,"line":1139,"name":"copy","containerName":"compute_tripartition_node"},{"line":1140,"kind":13,"name":"$graphPruned","containerName":"compute_tripartition_node"},{"line":1140,"kind":12,"name":"delete_vertex","containerName":"compute_tripartition_node"},{"name":"$u","containerName":"compute_tripartition_node","line":1140,"kind":13},{"kind":13,"line":1141,"containerName":"compute_tripartition_node","definition":"my","name":"$tripartition","localvar":"my"},{"definition":"my","name":"$leaf","containerName":"compute_tripartition_node","localvar":"my","kind":13,"line":1142},{"name":"$self","containerName":"compute_tripartition_node","kind":13,"line":1142}],"kind":12,"detail":"($self,$u)","signature":{"parameters":[{"label":"$self"},{"label":"$u"}],"documentation":" tripartitions","label":"compute_tripartition_node($self,$u)"},"containerName":"main::","definition":"sub","range":{"end":{"line":1142,"character":9999},"start":{"line":1133,"character":0}},"name":"compute_tripartition_node"},{"kind":12,"line":1136,"name":"numroots"},{"line":1137,"kind":12,"name":"roots"},{"name":"graph","kind":12,"line":1138},{"name":"leaves","kind":12,"line":1142},{"containerName":null,"definition":"my","name":"$type","localvar":"my","kind":13,"line":1143},{"line":1144,"kind":13,"containerName":null,"name":"$graph"},{"kind":12,"line":1144,"name":"is_reachable","containerName":"main::"},{"name":"$u","containerName":null,"line":1144,"kind":13},{"name":"%leaf","containerName":null,"line":1144,"kind":13},{"name":"$graphPruned","containerName":null,"kind":13,"line":1145},{"line":1145,"kind":12,"name":"is_reachable","containerName":"main::"},{"name":"$root","containerName":null,"kind":13,"line":1145},{"name":"%leaf","containerName":null,"line":1145,"kind":13},{"line":1145,"kind":13,"containerName":null,"name":"%type"},{"containerName":null,"name":"%type","line":1146,"kind":13},{"line":1148,"kind":13,"containerName":null,"name":"$type"},{"kind":13,"line":1149,"name":"$tripartition","containerName":null},{"name":"$type","containerName":null,"kind":13,"line":1149},{"name":"%self","containerName":null,"kind":13,"line":1151},{"name":"tripartitions","kind":12,"line":1151},{"containerName":null,"name":"$u","kind":13,"line":1151},{"line":1151,"kind":13,"name":"$tripartition","containerName":null},{"range":{"end":{"character":9999,"line":1156},"start":{"line":1154,"character":0}},"name":"compute_tripartitions","detail":"($self)","signature":{"label":"compute_tripartitions($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub","line":1154,"children":[{"line":1155,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"compute_tripartitions"},{"containerName":"compute_tripartitions","definition":"my","name":"$node","localvar":"my","kind":13,"line":1156},{"kind":13,"line":1156,"name":"$self","containerName":"compute_tripartitions"}],"kind":12},{"name":"nodes","line":1156,"kind":12},{"line":1157,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":1157,"containerName":"main::","name":"compute_tripartition_node"},{"containerName":null,"name":"$node","kind":13,"line":1157},{"range":{"start":{"line":1176,"character":0},"end":{"character":9999,"line":1179}},"name":"tripartitions","detail":"($self)","signature":{"label":"tripartitions($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on."},"containerName":"main::","definition":"sub","line":1176,"children":[{"line":1177,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"tripartitions"},{"containerName":"tripartitions","name":"$self","line":1178,"kind":13},{"line":1178,"kind":12,"containerName":"tripartitions","name":"compute_tripartitions"},{"containerName":"tripartitions","name":"$self","line":1178,"kind":13},{"kind":13,"line":1179,"name":"$self","containerName":"tripartitions"}],"kind":12},{"line":1178,"kind":12,"name":"tripartitions"},{"name":"tripartitions","kind":12,"line":1179},{"range":{"start":{"line":1184,"character":0},"end":{"character":9999,"line":1225}},"name":"tripartition_error","children":[{"localvar":"my","containerName":"tripartition_error","name":"$net1","definition":"my","line":1185,"kind":13},{"containerName":"tripartition_error","name":"$net2","kind":13,"line":1185},{"line":1186,"kind":13,"localvar":"my","name":"$comp","definition":"my","containerName":"tripartition_error"},{"kind":12,"line":1186,"containerName":"tripartition_error","name":"new"},{"kind":13,"line":1187,"containerName":"tripartition_error","name":"$net1"},{"line":1187,"kind":12,"name":"throw","containerName":"tripartition_error"},{"containerName":"tripartition_error","name":"$comp","kind":13,"line":1188},{"line":1188,"kind":12,"name":"compare","containerName":"tripartition_error"},{"name":"$net1","containerName":"tripartition_error","kind":13,"line":1188},{"kind":13,"line":1188,"name":"$net2","containerName":"tripartition_error"},{"name":"$net1","containerName":"tripartition_error","line":1189,"kind":13},{"name":"warn","containerName":"tripartition_error","line":1189,"kind":12},{"kind":13,"line":1190,"containerName":"tripartition_error","name":"$net1"},{"name":"is_tree_child","containerName":"tripartition_error","line":1190,"kind":12},{"line":1191,"kind":13,"containerName":"tripartition_error","name":"$net2"},{"name":"warn","containerName":"tripartition_error","line":1191,"kind":12},{"containerName":"tripartition_error","name":"$net2","kind":13,"line":1192},{"line":1192,"kind":12,"name":"is_tree_child","containerName":"tripartition_error"},{"line":1193,"kind":13,"name":"$net1","containerName":"tripartition_error"},{"name":"warn","containerName":"tripartition_error","line":1193,"kind":12},{"containerName":"tripartition_error","name":"$net1","kind":13,"line":1194},{"containerName":"tripartition_error","name":"is_time_consistent","kind":12,"line":1194},{"containerName":"tripartition_error","name":"$net2","line":1195,"kind":13},{"name":"warn","containerName":"tripartition_error","line":1195,"kind":12},{"name":"$net2","containerName":"tripartition_error","line":1196,"kind":13},{"kind":12,"line":1196,"containerName":"tripartition_error","name":"is_time_consistent"},{"containerName":"tripartition_error","name":"$net1","kind":13,"line":1197},{"name":"compute_tripartitions","containerName":"tripartition_error","kind":12,"line":1197},{"line":1197,"kind":13,"name":"$net1","containerName":"tripartition_error"},{"containerName":"tripartition_error","name":"$net2","kind":13,"line":1198},{"containerName":"tripartition_error","name":"compute_tripartitions","line":1198,"kind":12},{"line":1198,"kind":13,"containerName":"tripartition_error","name":"$net2"},{"kind":13,"line":1199,"definition":"my","name":"@edges1","containerName":"tripartition_error","localvar":"my"},{"line":1199,"kind":13,"name":"$net1","containerName":"tripartition_error"},{"kind":12,"line":1199,"containerName":"tripartition_error","name":"edges"},{"kind":13,"line":1200,"definition":"my","name":"@edges2","containerName":"tripartition_error","localvar":"my"},{"line":1200,"kind":13,"name":"$net2","containerName":"tripartition_error"},{"kind":12,"line":1200,"name":"edges","containerName":"tripartition_error"},{"containerName":"tripartition_error","definition":"my","name":"$FN","localvar":"my","kind":13,"line":1201},{"kind":13,"line":1201,"containerName":"tripartition_error","name":"$FP"},{"kind":13,"line":1202,"containerName":"tripartition_error","name":"$edge1","definition":"my","localvar":"my"},{"line":1202,"kind":13,"containerName":"tripartition_error","name":"@edges1"},{"localvar":"my","containerName":"tripartition_error","definition":"my","name":"$matched","line":1203,"kind":13},{"localvar":"my","name":"$edge2","definition":"my","containerName":"tripartition_error","line":1204,"kind":13},{"kind":13,"line":1204,"name":"@edges2","containerName":"tripartition_error"},{"name":"$net1","containerName":"tripartition_error","kind":13,"line":1205},{"line":1205,"kind":13,"name":"$edge1","containerName":"tripartition_error"},{"kind":13,"line":1206,"containerName":"tripartition_error","name":"$net2"},{"line":1206,"kind":13,"containerName":"tripartition_error","name":"$edge2"},{"line":1207,"kind":13,"name":"$matched","containerName":"tripartition_error"},{"line":1211,"kind":13,"containerName":"tripartition_error","name":"$matched"},{"containerName":"tripartition_error","name":"$FN","kind":13,"line":1211},{"line":1213,"kind":13,"localvar":"my","containerName":"tripartition_error","name":"$edge2","definition":"my"},{"line":1213,"kind":13,"name":"@edges2","containerName":"tripartition_error"},{"kind":13,"line":1214,"name":"$matched","definition":"my","containerName":"tripartition_error","localvar":"my"},{"localvar":"my","definition":"my","name":"$edge1","containerName":"tripartition_error","line":1215,"kind":13},{"name":"@edges1","containerName":"tripartition_error","line":1215,"kind":13},{"kind":13,"line":1216,"name":"$net1","containerName":"tripartition_error"},{"containerName":"tripartition_error","name":"$edge1","line":1216,"kind":13},{"containerName":"tripartition_error","name":"$net2","line":1217,"kind":13},{"line":1217,"kind":13,"containerName":"tripartition_error","name":"$edge2"},{"kind":13,"line":1218,"name":"$matched","containerName":"tripartition_error"},{"name":"$matched","containerName":"tripartition_error","kind":13,"line":1222},{"kind":13,"line":1222,"containerName":"tripartition_error","name":"$FP"},{"name":"$FN","containerName":"tripartition_error","kind":13,"line":1224},{"name":"@edges1","containerName":"tripartition_error","line":1224,"kind":13},{"kind":13,"line":1224,"containerName":"tripartition_error","name":"$FP"},{"name":"@edges2","containerName":"tripartition_error","line":1224,"kind":13}],"line":1184,"kind":12,"signature":{"label":"tripartition_error($net1,$net2)","documentation":" to do: change to tri_distance and test for TC and time-cons","parameters":[{"label":"$net1"},{"label":"$net2"}]},"detail":"($net1,$net2)","definition":"sub","containerName":"main::"},{"line":1186,"kind":12,"containerName":"Compare","name":"Array"},{"name":"leaves","line":1188,"kind":12},{"name":"leaves","kind":12,"line":1188},{"kind":12,"line":1197,"name":"tripartitions"},{"kind":12,"line":1198,"name":"tripartitions"},{"name":"graph","kind":12,"line":1199},{"name":"graph","line":1200,"kind":12},{"kind":12,"line":1205,"name":"tripartitions"},{"kind":12,"line":1206,"name":"tripartitions"},{"name":"tripartitions","kind":12,"line":1216},{"line":1217,"kind":12,"name":"tripartitions"},{"range":{"start":{"line":1241,"character":0},"end":{"line":1246,"character":9999}},"name":"is_time_consistent","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none","label":"is_time_consistent($self)"},"containerName":"main::","definition":"sub","line":1241,"children":[{"localvar":"my","containerName":"is_time_consistent","definition":"my","name":"$self","line":1242,"kind":13},{"name":"$self","containerName":"is_time_consistent","line":1243,"kind":13},{"kind":12,"line":1243,"containerName":"is_time_consistent","name":"compute_temporal_representation"},{"name":"$self","containerName":"is_time_consistent","line":1244,"kind":13},{"name":"$self","containerName":"is_time_consistent","line":1245,"kind":13}],"kind":12},{"name":"has_temporal_representation","kind":12,"line":1244},{"name":"has_temporal_representation","line":1245,"kind":12},{"range":{"end":{"character":9999,"line":1263},"start":{"line":1259,"character":0}},"name":"temporal_representation","line":1259,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"temporal_representation","line":1260,"kind":13},{"kind":13,"line":1261,"name":"$self","containerName":"temporal_representation"},{"line":1261,"kind":12,"containerName":"temporal_representation","name":"is_time_consistent"},{"name":"$self","containerName":"temporal_representation","kind":13,"line":1262}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none","parameters":[{"label":"$self"}],"label":"temporal_representation($self)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":1262,"name":"temporal_representation"},{"name":"compute_temporal_representation","range":{"start":{"character":0,"line":1267},"end":{"character":9999,"line":1289}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"compute_temporal_representation($self)"},"kind":12,"line":1267,"children":[{"kind":13,"line":1268,"containerName":"compute_temporal_representation","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":1269,"containerName":"compute_temporal_representation","definition":"my","name":"$quotient","localvar":"my"},{"line":1269,"kind":12,"containerName":"compute_temporal_representation","name":"new"},{"line":1270,"kind":13,"localvar":"my","definition":"my","name":"$classes","containerName":"compute_temporal_representation"},{"line":1270,"kind":13,"name":"$self","containerName":"compute_temporal_representation"},{"name":"%repr","definition":"my","containerName":"compute_temporal_representation","localvar":"my","kind":13,"line":1271},{"containerName":"compute_temporal_representation","name":"$repr","line":1272,"kind":13},{"name":"$classes","containerName":"compute_temporal_representation","kind":13,"line":1272},{"containerName":"compute_temporal_representation","name":"$self","line":1272,"kind":13},{"line":1272,"kind":12,"containerName":"compute_temporal_representation","name":"nodes"},{"line":1273,"kind":13,"localvar":"my","name":"$e","definition":"my","containerName":"compute_temporal_representation"},{"line":1273,"kind":13,"containerName":"compute_temporal_representation","name":"$self"},{"containerName":"compute_temporal_representation","name":"tree_edges","kind":12,"line":1273},{"containerName":"compute_temporal_representation","name":"$quotient","line":1274,"kind":13},{"name":"add_edge","containerName":"compute_temporal_representation","line":1274,"kind":12},{"line":1274,"kind":13,"name":"$repr","containerName":"compute_temporal_representation"},{"containerName":"compute_temporal_representation","name":"$e","kind":13,"line":1274},{"line":1274,"kind":13,"containerName":"compute_temporal_representation","name":"$repr"},{"line":1274,"kind":13,"containerName":"compute_temporal_representation","name":"$e"},{"kind":13,"line":1276,"containerName":"compute_temporal_representation","definition":"my","name":"%temp","localvar":"my"},{"localvar":"my","name":"$depth","definition":"my","containerName":"compute_temporal_representation","line":1277,"kind":13},{"name":"$quotient","containerName":"compute_temporal_representation","kind":13,"line":1278},{"kind":12,"line":1278,"containerName":"compute_temporal_representation","name":"vertices"},{"line":1279,"kind":13,"localvar":"my","definition":"my","name":"@svs","containerName":"compute_temporal_representation"},{"containerName":"compute_temporal_representation","name":"$quotient","kind":13,"line":1279},{"line":1279,"kind":12,"containerName":"compute_temporal_representation","name":"predecessorless_vertices"},{"localvar":"my","definition":"my","name":"$sv","containerName":"compute_temporal_representation","line":1280,"kind":13},{"name":"@svs","containerName":"compute_temporal_representation","kind":13,"line":1280},{"containerName":"compute_temporal_representation","name":"$temp","line":1281,"kind":13},{"name":"$sv","containerName":"compute_temporal_representation","line":1281,"kind":13},{"kind":13,"line":1281,"name":"$depth","containerName":"compute_temporal_representation"},{"line":1283,"kind":13,"name":"$quotient","containerName":"compute_temporal_representation"},{"containerName":"compute_temporal_representation","name":"delete_vertices","kind":12,"line":1283},{"kind":13,"line":1283,"name":"@svs","containerName":"compute_temporal_representation"},{"kind":13,"line":1287,"name":"$depth","containerName":"compute_temporal_representation"},{"kind":13,"line":1289,"name":"$node","definition":"my","containerName":"compute_temporal_representation","localvar":"my"},{"kind":13,"line":1289,"name":"$self","containerName":"compute_temporal_representation"}]},{"line":1269,"kind":12,"containerName":"Directed","name":"Graph"},{"kind":12,"line":1270,"name":"find_classes"},{"name":"nodes","line":1289,"kind":12},{"line":1290,"kind":13,"containerName":null,"name":"%temp"},{"line":1290,"kind":13,"name":"$node","containerName":null},{"line":1290,"kind":13,"name":"%temp","containerName":null},{"kind":13,"line":1290,"name":"%repr","containerName":null},{"kind":13,"line":1290,"containerName":null,"name":"$node"},{"name":"%self","containerName":null,"line":1292,"kind":13},{"name":"temporal_representation","line":1292,"kind":12},{"name":"%temp","containerName":null,"kind":13,"line":1292},{"kind":13,"line":1293,"containerName":null,"name":"%self"},{"name":"has_temporal_representation","kind":12,"line":1293},{"name":"find_classes","range":{"start":{"character":0,"line":1296},"end":{"character":9999,"line":1304}},"kind":12,"children":[{"kind":13,"line":1297,"containerName":"find_classes","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","containerName":"find_classes","name":"$classes","definition":"my","line":1298,"kind":13},{"name":"$classes","containerName":"find_classes","line":1299,"kind":13},{"containerName":"find_classes","name":"$self","kind":13,"line":1299},{"name":"nodes","containerName":"find_classes","kind":12,"line":1299},{"localvar":"my","definition":"my","name":"$e","containerName":"find_classes","line":1300,"kind":13},{"kind":13,"line":1300,"containerName":"find_classes","name":"$self"},{"kind":12,"line":1300,"name":"hybrid_edges","containerName":"find_classes"},{"line":1301,"kind":13,"name":"$classes","containerName":"find_classes"},{"name":"$classes","containerName":"find_classes","kind":13,"line":1301},{"containerName":"find_classes","name":"$e","kind":13,"line":1301},{"line":1301,"kind":13,"name":"$e","containerName":"find_classes"},{"line":1303,"kind":13,"name":"$classes","containerName":"find_classes"}],"line":1296,"definition":"sub","containerName":"main::","signature":{"label":"find_classes($self)","parameters":[{"label":"$self"}],"documentation":""},"detail":"($self)"},{"name":"join_classes","kind":12,"line":1301},{"range":{"start":{"line":1306,"character":0},"end":{"line":1308,"character":9999}},"name":"join_classes","detail":"($classes,$u,$v)","signature":{"documentation":"","parameters":[{"label":"$classes"},{"label":"$u"},{"label":"$v"}],"label":"join_classes($classes,$u,$v)"},"containerName":"main::","definition":"sub","line":1306,"children":[{"line":1307,"kind":13,"localvar":"my","name":"$classes","definition":"my","containerName":"join_classes"},{"name":"$u","containerName":"join_classes","line":1307,"kind":13},{"kind":13,"line":1307,"name":"$v","containerName":"join_classes"},{"line":1308,"kind":13,"localvar":"my","containerName":"join_classes","name":"@clu","definition":"my"},{"kind":13,"line":1308,"containerName":"join_classes","name":"$classes"},{"containerName":"join_classes","name":"$u","kind":13,"line":1308}],"kind":12},{"localvar":"my","containerName":null,"name":"@clv","definition":"my","line":1309,"kind":13},{"containerName":null,"name":"%classes","kind":13,"line":1309},{"kind":13,"line":1309,"containerName":null,"name":"$v"},{"name":"@cljoin","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1310},{"kind":13,"line":1310,"containerName":null,"name":"@clu"},{"kind":13,"line":1310,"containerName":null,"name":"@clv"},{"name":"%classes","containerName":null,"kind":13,"line":1311},{"containerName":null,"name":"@cljoin","line":1311,"kind":13},{"containerName":null,"name":"@cljoin","kind":13,"line":1311},{"kind":13,"line":1312,"name":"$classes","containerName":null},{"range":{"start":{"character":0,"line":1331},"end":{"line":1355,"character":9999}},"name":"contract_elementary","children":[{"name":"$self","definition":"my","containerName":"contract_elementary","localvar":"my","kind":13,"line":1332},{"kind":13,"line":1334,"containerName":"contract_elementary","name":"$contracted","definition":"my","localvar":"my"},{"name":"$self","containerName":"contract_elementary","line":1334,"kind":13},{"containerName":"contract_elementary","name":"graph","line":1334,"kind":12},{"line":1334,"kind":12,"containerName":"contract_elementary","name":"copy"},{"name":"@nodes","definition":"my","containerName":"contract_elementary","localvar":"my","kind":13,"line":1335},{"name":"$self","containerName":"contract_elementary","kind":13,"line":1335},{"line":1335,"kind":12,"containerName":"contract_elementary","name":"nodes"},{"name":"$mus","definition":"my","containerName":"contract_elementary","localvar":"my","kind":13,"line":1336},{"line":1336,"kind":13,"name":"$self","containerName":"contract_elementary"},{"kind":13,"line":1337,"definition":"my","name":"$hs","containerName":"contract_elementary","localvar":"my"},{"name":"$self","containerName":"contract_elementary","kind":13,"line":1337},{"line":1338,"kind":13,"localvar":"my","name":"%blocks","definition":"my","containerName":"contract_elementary"},{"name":"$u","definition":"my","containerName":"contract_elementary","localvar":"my","kind":13,"line":1339},{"kind":13,"line":1339,"name":"@nodes","containerName":"contract_elementary"},{"name":"$blocks","containerName":"contract_elementary","kind":13,"line":1340},{"kind":13,"line":1340,"name":"$u","containerName":"contract_elementary"},{"containerName":"contract_elementary","name":"$u","line":1340,"kind":13},{"localvar":"my","containerName":"contract_elementary","name":"@elementary","definition":"my","line":1342,"kind":13},{"line":1342,"kind":13,"name":"$contracted","containerName":"contract_elementary"},{"line":1342,"kind":12,"containerName":"contract_elementary","name":"out_degree"},{"containerName":"contract_elementary","name":"$self","line":1342,"kind":13},{"name":"tree_nodes","containerName":"contract_elementary","line":1342,"kind":12},{"name":"@elementary","containerName":"contract_elementary","line":1343,"kind":13},{"containerName":"contract_elementary","name":"$mus","kind":13,"line":1343},{"kind":13,"line":1343,"name":"$b","containerName":"contract_elementary"},{"line":1343,"kind":13,"name":"$mus","containerName":"contract_elementary"},{"containerName":"contract_elementary","name":"$a","kind":13,"line":1343},{"containerName":"contract_elementary","name":"$hs","kind":13,"line":1344},{"kind":13,"line":1344,"containerName":"contract_elementary","name":"$b"},{"kind":13,"line":1344,"containerName":"contract_elementary","name":"$hs"},{"containerName":"contract_elementary","name":"$a","line":1344,"kind":13},{"line":1344,"kind":13,"containerName":"contract_elementary","name":"@elementary"},{"containerName":"contract_elementary","name":"$elem","definition":"my","localvar":"my","kind":13,"line":1345},{"kind":13,"line":1345,"name":"@elementary","containerName":"contract_elementary"},{"kind":13,"line":1346,"name":"@children","definition":"my","containerName":"contract_elementary","localvar":"my"},{"containerName":"contract_elementary","name":"$contracted","line":1346,"kind":13},{"containerName":"contract_elementary","name":"successors","kind":12,"line":1346},{"containerName":"contract_elementary","name":"$elem","line":1346,"kind":13},{"name":"$child","definition":"my","containerName":"contract_elementary","localvar":"my","kind":13,"line":1347},{"line":1347,"kind":13,"name":"$children","containerName":"contract_elementary"},{"name":"$contracted","containerName":"contract_elementary","line":1348,"kind":13},{"containerName":"contract_elementary","name":"in_degree","line":1348,"kind":12},{"containerName":"contract_elementary","name":"$elem","kind":13,"line":1348},{"kind":13,"line":1349,"name":"@parents","definition":"my","containerName":"contract_elementary","localvar":"my"},{"kind":13,"line":1349,"containerName":"contract_elementary","name":"$contracted"},{"name":"predecessors","containerName":"contract_elementary","line":1349,"kind":12},{"line":1349,"kind":13,"containerName":"contract_elementary","name":"$elem"},{"line":1350,"kind":13,"localvar":"my","definition":"my","name":"$parent","containerName":"contract_elementary"},{"name":"$parents","containerName":"contract_elementary","line":1350,"kind":13},{"containerName":"contract_elementary","name":"$contracted","kind":13,"line":1351},{"kind":12,"line":1351,"name":"add_edge","containerName":"contract_elementary"},{"containerName":"contract_elementary","name":"$parent","kind":13,"line":1351},{"containerName":"contract_elementary","name":"$child","line":1351,"kind":13},{"line":1353,"kind":13,"containerName":"contract_elementary","name":"$contracted"},{"name":"delete_vertex","containerName":"contract_elementary","line":1353,"kind":12},{"kind":13,"line":1353,"name":"$elem","containerName":"contract_elementary"},{"kind":13,"line":1354,"name":"@blch","definition":"my","containerName":"contract_elementary","localvar":"my"},{"line":1354,"kind":13,"containerName":"contract_elementary","name":"$blocks"},{"containerName":"contract_elementary","name":"$child","kind":13,"line":1354},{"localvar":"my","containerName":"contract_elementary","definition":"my","name":"@blem","line":1355,"kind":13},{"containerName":"contract_elementary","name":"$blocks","line":1355,"kind":13},{"name":"$elem","containerName":"contract_elementary","kind":13,"line":1355}],"line":1331,"kind":12,"signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none","parameters":[{"label":"$self"}],"label":"contract_elementary($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"mudata","line":1336,"kind":12},{"containerName":null,"name":"%blocks","kind":13,"line":1356},{"containerName":null,"name":"@child","line":1356,"kind":13},{"containerName":null,"name":"@blem","kind":13,"line":1356},{"line":1356,"kind":13,"name":"@blch","containerName":null},{"name":"%blocks","containerName":null,"line":1357,"kind":13},{"containerName":null,"name":"$elem","line":1357,"kind":13},{"line":1359,"kind":13,"localvar":"my","definition":"my","name":"$contr","containerName":null},{"containerName":"PhyloNetwork","name":"Bio","kind":12,"line":1359},{"containerName":"main::","name":"new","kind":12,"line":1359},{"line":1359,"kind":13,"containerName":null,"name":"$contracted"},{"name":"$contr","containerName":null,"kind":13,"line":1360},{"containerName":null,"name":"%blocks","line":1360,"kind":13},{"range":{"end":{"line":1393,"character":9999},"start":{"character":0,"line":1380}},"name":"optimal_alignment","detail":"($net1,$net2,%params)","signature":{"label":"optimal_alignment($net1,$net2,%params)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.","parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}]},"containerName":"main::","definition":"sub","line":1380,"children":[{"kind":13,"line":1381,"name":"$net1","definition":"my","containerName":"optimal_alignment","localvar":"my"},{"containerName":"optimal_alignment","name":"$net2","kind":13,"line":1381},{"line":1381,"kind":13,"containerName":"optimal_alignment","name":"%params"},{"definition":"my","name":"$net1cont","containerName":"optimal_alignment","localvar":"my","kind":13,"line":1383},{"name":"$blocks1","containerName":"optimal_alignment","kind":13,"line":1383},{"kind":13,"line":1383,"containerName":"optimal_alignment","name":"$net1"},{"line":1384,"kind":13,"localvar":"my","definition":"my","name":"$net2cont","containerName":"optimal_alignment"},{"name":"$blocks2","containerName":"optimal_alignment","line":1384,"kind":13},{"containerName":"optimal_alignment","name":"$net2","kind":13,"line":1384},{"line":1385,"kind":13,"localvar":"my","containerName":"optimal_alignment","name":"$wc","definition":"my"},{"name":"$alignc","containerName":"optimal_alignment","kind":13,"line":1385},{"containerName":"optimal_alignment","name":"$weightc","kind":13,"line":1385},{"kind":13,"line":1386,"name":"$net1cont","containerName":"optimal_alignment"},{"kind":13,"line":1386,"containerName":"optimal_alignment","name":"$net2cont"},{"name":"%params","containerName":"optimal_alignment","line":1386,"kind":13},{"line":1387,"kind":13,"localvar":"my","containerName":"optimal_alignment","name":"%alignment","definition":"my"},{"kind":13,"line":1388,"definition":"my","name":"$totalweigth","containerName":"optimal_alignment","localvar":"my"},{"kind":13,"line":1389,"name":"%weigths","definition":"my","containerName":"optimal_alignment","localvar":"my"},{"kind":13,"line":1390,"name":"$u1","definition":"my","containerName":"optimal_alignment","localvar":"my"},{"line":1390,"kind":13,"name":"$alignc","containerName":"optimal_alignment"},{"containerName":"optimal_alignment","name":"$u2","definition":"my","localvar":"my","kind":13,"line":1391},{"containerName":"optimal_alignment","name":"$alignc","kind":13,"line":1391},{"containerName":"optimal_alignment","name":"$u1","kind":13,"line":1391},{"containerName":"optimal_alignment","name":"@block1","definition":"my","localvar":"my","kind":13,"line":1392},{"line":1392,"kind":13,"name":"$blocks1","containerName":"optimal_alignment"},{"kind":13,"line":1392,"containerName":"optimal_alignment","name":"$u1"},{"line":1393,"kind":13,"localvar":"my","definition":"my","name":"@block2","containerName":"optimal_alignment"},{"containerName":"optimal_alignment","name":"$blocks2","line":1393,"kind":13},{"name":"$u2","containerName":"optimal_alignment","kind":13,"line":1393}],"kind":12},{"kind":12,"line":1386,"name":"optimal_alignment_noelementary"},{"kind":13,"line":1394,"containerName":null,"name":"@block1"},{"name":"@block2","containerName":null,"kind":13,"line":1394},{"localvar":"my","definition":"my","name":"$u1dc","containerName":null,"line":1395,"kind":13},{"name":"@block1","containerName":null,"kind":13,"line":1395},{"line":1396,"kind":13,"localvar":"my","name":"$u2dc","definition":"my","containerName":null},{"line":1396,"kind":13,"containerName":null,"name":"@block2"},{"name":"%alignment","containerName":null,"kind":13,"line":1397},{"kind":13,"line":1397,"name":"$u1dc","containerName":null},{"kind":13,"line":1397,"containerName":null,"name":"$u2dc"},{"line":1398,"kind":13,"containerName":null,"name":"%weigths"},{"name":"$u1dc","containerName":null,"line":1398,"kind":13},{"name":"%weightc","containerName":null,"kind":13,"line":1398},{"containerName":null,"name":"$u1","kind":13,"line":1398},{"kind":13,"line":1399,"containerName":null,"name":"$totalweigth"},{"line":1399,"kind":13,"containerName":null,"name":"%weigths"},{"containerName":null,"name":"$u1dc","kind":13,"line":1399},{"line":1402,"kind":13,"containerName":null,"name":"$totalweigth"},{"name":"%alignment","containerName":null,"kind":13,"line":1402},{"line":1402,"kind":13,"containerName":null,"name":"%weigths"},{"signature":{"label":"optimal_alignment_noelementary($net1,$net2,%params)","parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}],"documentation":""},"detail":"($net1,$net2,%params)","definition":"sub","containerName":"main::","children":[{"name":"$net1","definition":"my","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"line":1406},{"line":1406,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net2"},{"containerName":"optimal_alignment_noelementary","name":"%params","line":1406,"kind":13},{"localvar":"my","name":"$comp","definition":"my","containerName":"optimal_alignment_noelementary","line":1408,"kind":13},{"line":1408,"kind":12,"containerName":"optimal_alignment_noelementary","name":"new"},{"line":1409,"kind":13,"name":"$net1","containerName":"optimal_alignment_noelementary"},{"line":1409,"kind":12,"name":"throw","containerName":"optimal_alignment_noelementary"},{"containerName":"optimal_alignment_noelementary","name":"$comp","line":1410,"kind":13},{"containerName":"optimal_alignment_noelementary","name":"compare","line":1410,"kind":12},{"line":1410,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$net1"},{"kind":13,"line":1410,"name":"$net2","containerName":"optimal_alignment_noelementary"},{"localvar":"my","definition":"my","name":"$distance","containerName":"optimal_alignment_noelementary","line":1411,"kind":13},{"name":"$params","containerName":"optimal_alignment_noelementary","kind":13,"line":1412},{"name":"$params","containerName":"optimal_alignment_noelementary","line":1412,"kind":13},{"name":"$distance","containerName":"optimal_alignment_noelementary","kind":13,"line":1413},{"line":1415,"kind":13,"name":"$distance","containerName":"optimal_alignment_noelementary"},{"localvar":"my","containerName":"optimal_alignment_noelementary","name":"$numleaves","definition":"my","line":1417,"kind":13},{"line":1417,"kind":13,"name":"$net1","containerName":"optimal_alignment_noelementary"},{"localvar":"my","name":"@nodes1","definition":"my","containerName":"optimal_alignment_noelementary","line":1418,"kind":13},{"name":"$net1","containerName":"optimal_alignment_noelementary","line":1418,"kind":13},{"line":1418,"kind":12,"name":"internal_nodes","containerName":"optimal_alignment_noelementary"},{"localvar":"my","containerName":"optimal_alignment_noelementary","definition":"my","name":"@nodes2","line":1419,"kind":13},{"kind":13,"line":1419,"name":"$net2","containerName":"optimal_alignment_noelementary"},{"kind":12,"line":1419,"name":"internal_nodes","containerName":"optimal_alignment_noelementary"},{"definition":"my","name":"$numnodes1","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"line":1420},{"line":1420,"kind":13,"name":"@nodes1","containerName":"optimal_alignment_noelementary"},{"definition":"my","name":"$numnodes2","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"line":1421},{"line":1421,"kind":13,"containerName":"optimal_alignment_noelementary","name":"@nodes2"},{"definition":"my","name":"@matrix","containerName":"optimal_alignment_noelementary","localvar":"my","kind":13,"line":1422},{"localvar":"my","containerName":"optimal_alignment_noelementary","name":"$i","definition":"my","line":1423,"kind":13},{"kind":13,"line":1423,"containerName":"optimal_alignment_noelementary","name":"$i"},{"name":"$numnodes1","containerName":"optimal_alignment_noelementary","line":1423,"kind":13},{"name":"$i","containerName":"optimal_alignment_noelementary","line":1423,"kind":13},{"kind":13,"line":1424,"containerName":"optimal_alignment_noelementary","definition":"my","name":"@row","localvar":"my"},{"kind":13,"line":1425,"containerName":"optimal_alignment_noelementary","name":"$j","definition":"my","localvar":"my"},{"name":"$j","containerName":"optimal_alignment_noelementary","kind":13,"line":1425},{"name":"$numnodes2","containerName":"optimal_alignment_noelementary","kind":13,"line":1425},{"line":1425,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$j"},{"name":"@row","containerName":"optimal_alignment_noelementary","line":1426,"kind":13},{"containerName":"optimal_alignment_noelementary","name":"$net1","line":1426,"kind":13},{"containerName":"optimal_alignment_noelementary","name":"$nodes1","line":1426,"kind":13},{"line":1426,"kind":13,"containerName":"optimal_alignment_noelementary","name":"$i"},{"containerName":"optimal_alignment_noelementary","name":"$net2","kind":13,"line":1426},{"name":"$nodes2","containerName":"optimal_alignment_noelementary","line":1426,"kind":13},{"name":"$j","containerName":"optimal_alignment_noelementary","kind":13,"line":1426},{"name":"$distance","containerName":"optimal_alignment_noelementary","line":1426,"kind":13},{"name":"@matrix","containerName":"optimal_alignment_noelementary","line":1428,"kind":13},{"containerName":"optimal_alignment_noelementary","name":"@row","line":1428,"kind":13},{"kind":13,"line":1430,"definition":"my","name":"@alignment","containerName":"optimal_alignment_noelementary","localvar":"my"},{"kind":13,"line":1431,"name":"@matrix","containerName":"optimal_alignment_noelementary"},{"line":1431,"kind":13,"name":"@alignment","containerName":"optimal_alignment_noelementary"},{"localvar":"my","definition":"my","name":"%alignmenthash","containerName":"optimal_alignment_noelementary","line":1432,"kind":13},{"kind":13,"line":1433,"containerName":"optimal_alignment_noelementary","name":"%weighthash","definition":"my","localvar":"my"},{"containerName":"optimal_alignment_noelementary","definition":"my","name":"$totalw","localvar":"my","kind":13,"line":1434},{"kind":13,"line":1435,"containerName":"optimal_alignment_noelementary","name":"$leaf","definition":"my","localvar":"my"},{"kind":13,"line":1435,"name":"$net1","containerName":"optimal_alignment_noelementary"}],"line":1405,"kind":12,"range":{"end":{"character":9999,"line":1435},"start":{"character":0,"line":1405}},"name":"optimal_alignment_noelementary"},{"kind":12,"line":1408,"containerName":"Compare","name":"Array"},{"line":1410,"kind":12,"name":"leaves"},{"line":1410,"kind":12,"name":"leaves"},{"line":1417,"kind":12,"name":"numleaves"},{"kind":12,"line":1426,"name":"weight"},{"line":1431,"kind":12,"name":"assign"},{"kind":12,"line":1435,"name":"leaves"},{"name":"%alignmenthash","containerName":null,"kind":13,"line":1436},{"kind":13,"line":1436,"containerName":null,"name":"$leaf"},{"line":1436,"kind":13,"containerName":null,"name":"$leaf"},{"kind":13,"line":1437,"containerName":null,"name":"%weighthash"},{"line":1437,"kind":13,"containerName":null,"name":"$leaf"},{"name":"$i","definition":"my","containerName":null,"localvar":"my","kind":13,"line":1439},{"kind":13,"line":1439,"containerName":null,"name":"$i"},{"name":"$numnodes1","containerName":null,"line":1439,"kind":13},{"containerName":null,"name":"%i","line":1439,"kind":13},{"line":1440,"kind":13,"containerName":null,"name":"@nodes2"},{"line":1440,"kind":13,"name":"@alignment","containerName":null},{"kind":13,"line":1440,"name":"%i","containerName":null},{"name":"%alignmenthash","containerName":null,"kind":13,"line":1441},{"containerName":null,"name":"@nodes1","line":1441,"kind":13},{"line":1441,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":1441,"name":"@nodes2","containerName":null},{"kind":13,"line":1441,"name":"@alignment","containerName":null},{"name":"$i","containerName":null,"kind":13,"line":1441},{"containerName":null,"name":"%weighthash","line":1442,"kind":13},{"containerName":null,"name":"@nodes1","line":1442,"kind":13},{"line":1442,"kind":13,"name":"$i","containerName":null},{"name":"@matrix","containerName":null,"kind":13,"line":1442},{"line":1442,"kind":13,"name":"@i","containerName":null},{"line":1442,"kind":13,"name":"@alignment","containerName":null},{"line":1442,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":1443,"containerName":null,"name":"$totalw"},{"containerName":null,"name":"@matrix","line":1443,"kind":13},{"kind":13,"line":1443,"name":"@i","containerName":null},{"kind":13,"line":1443,"containerName":null,"name":"@alignment"},{"containerName":null,"name":"$i","line":1443,"kind":13},{"name":"$totalw","containerName":null,"kind":13,"line":1446},{"containerName":null,"name":"%alignmenthash","kind":13,"line":1446},{"containerName":null,"name":"%weighthash","kind":13,"line":1446},{"line":1466,"children":[{"kind":13,"line":1467,"definition":"my","name":"$net1","containerName":"optimal_alignment_generalized","localvar":"my"},{"line":1467,"kind":13,"containerName":"optimal_alignment_generalized","name":"$net2"},{"kind":13,"line":1467,"containerName":"optimal_alignment_generalized","name":"%params"},{"containerName":"optimal_alignment_generalized","definition":"my","name":"$netr1","localvar":"my","kind":13,"line":1468},{"kind":13,"line":1468,"name":"$netr2","containerName":"optimal_alignment_generalized"},{"line":1468,"kind":13,"containerName":"optimal_alignment_generalized","name":"$net1"},{"name":"topological_restriction","containerName":"optimal_alignment_generalized","line":1468,"kind":12},{"line":1468,"kind":13,"name":"$net2","containerName":"optimal_alignment_generalized"},{"line":1469,"kind":13,"containerName":"optimal_alignment_generalized","name":"$netr1"},{"name":"optimal_alignment","containerName":"optimal_alignment_generalized","kind":12,"line":1469},{"name":"$netr2","containerName":"optimal_alignment_generalized","kind":13,"line":1469},{"containerName":"optimal_alignment_generalized","name":"%params","kind":13,"line":1469}],"kind":12,"detail":"($net1,$net2,%params)","signature":{"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.","parameters":[{"label":"$net1"},{"label":"$net2"},{"label":"%params"}],"label":"optimal_alignment_generalized($net1,$net2,%params)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":1470},"start":{"character":0,"line":1466}},"name":"optimal_alignment_generalized"},{"range":{"start":{"line":1472,"character":0},"end":{"character":9999,"line":1490}},"name":"weight","detail":"($net1,$v1,$net2,$v2,$distance)","signature":{"parameters":[{"label":"$net1"},{"label":"$v1"},{"label":"$net2"},{"label":"$v2"},{"label":"$distance"}],"documentation":"","label":"weight($net1,$v1,$net2,$v2,$distance)"},"containerName":"main::","definition":"sub","line":1472,"children":[{"name":"$net1","definition":"my","containerName":"weight","localvar":"my","kind":13,"line":1473},{"kind":13,"line":1473,"name":"$v1","containerName":"weight"},{"kind":13,"line":1473,"containerName":"weight","name":"$net2"},{"line":1473,"kind":13,"name":"$v2","containerName":"weight"},{"name":"$distance","containerName":"weight","kind":13,"line":1473},{"localvar":"my","containerName":"weight","name":"$w","definition":"my","line":1474,"kind":13},{"kind":13,"line":1475,"name":"$distance","containerName":"weight"},{"kind":13,"line":1476,"name":"$distance","containerName":"weight"},{"containerName":"weight","name":"$distance","line":1478,"kind":13},{"name":"$w","containerName":"weight","line":1479,"kind":13},{"kind":13,"line":1479,"name":"$net1","containerName":"weight"},{"containerName":"weight","name":"$v1","kind":13,"line":1479},{"containerName":"weight","name":"hamming","kind":12,"line":1479},{"containerName":"weight","name":"$net2","kind":13,"line":1479},{"line":1479,"kind":13,"name":"$v2","containerName":"weight"},{"kind":13,"line":1481,"name":"$w","containerName":"weight"},{"name":"$net1","containerName":"weight","kind":13,"line":1481},{"line":1481,"kind":13,"name":"$v1","containerName":"weight"},{"kind":12,"line":1481,"containerName":"weight","name":"manhattan"},{"line":1481,"kind":13,"name":"$net2","containerName":"weight"},{"kind":13,"line":1481,"containerName":"weight","name":"$v2"},{"kind":13,"line":1483,"name":"$net1","containerName":"weight"},{"name":"is_tree_node","containerName":"weight","kind":12,"line":1483},{"name":"$v1","containerName":"weight","kind":13,"line":1483},{"line":1483,"kind":13,"name":"$net2","containerName":"weight"},{"containerName":"weight","name":"is_hybrid_node","line":1483,"kind":12},{"name":"$v2","containerName":"weight","kind":13,"line":1483},{"containerName":"weight","name":"$net2","kind":13,"line":1484},{"name":"is_tree_node","containerName":"weight","line":1484,"kind":12},{"line":1484,"kind":13,"name":"$v2","containerName":"weight"},{"containerName":"weight","name":"$net1","kind":13,"line":1484},{"containerName":"weight","name":"is_hybrid_node","kind":12,"line":1484},{"kind":13,"line":1484,"name":"$v1","containerName":"weight"},{"line":1487,"kind":13,"name":"$w","containerName":"weight"},{"kind":13,"line":1487,"name":"$net1","containerName":"weight"},{"kind":13,"line":1489,"name":"$w","containerName":"weight"}],"kind":12},{"name":"mudata","line":1479,"kind":12},{"name":"mudata","line":1479,"kind":12},{"kind":12,"line":1481,"name":"mudata"},{"kind":12,"line":1481,"name":"mudata"},{"name":"numleaves","line":1487,"kind":12},{"range":{"end":{"character":9999,"line":1548},"start":{"character":0,"line":1504}},"name":"topological_restriction","children":[{"line":1505,"kind":13,"localvar":"my","definition":"my","name":"$net1","containerName":"topological_restriction"},{"line":1505,"kind":13,"name":"$net2","containerName":"topological_restriction"},{"name":"@leaves1","definition":"my","containerName":"topological_restriction","localvar":"my","kind":13,"line":1507},{"containerName":"topological_restriction","name":"$net1","line":1507,"kind":13},{"line":1507,"kind":12,"name":"leaves","containerName":"topological_restriction"},{"kind":13,"line":1508,"containerName":"topological_restriction","definition":"my","name":"@leaves2","localvar":"my"},{"name":"$net2","containerName":"topological_restriction","line":1508,"kind":13},{"name":"leaves","containerName":"topological_restriction","line":1508,"kind":12},{"localvar":"my","name":"$numleaves1","definition":"my","containerName":"topological_restriction","line":1509,"kind":13},{"line":1509,"kind":13,"name":"@leaves1","containerName":"topological_restriction"},{"definition":"my","name":"$numleaves2","containerName":"topological_restriction","localvar":"my","kind":13,"line":1510},{"kind":13,"line":1510,"containerName":"topological_restriction","name":"@leaves2"},{"name":"%position1","definition":"my","containerName":"topological_restriction","localvar":"my","kind":13,"line":1511},{"line":1512,"kind":13,"localvar":"my","containerName":"topological_restriction","definition":"my","name":"$i"},{"kind":13,"line":1512,"containerName":"topological_restriction","name":"$i"},{"kind":13,"line":1512,"name":"$numleaves1","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$i","line":1512,"kind":13},{"name":"$position1","containerName":"topological_restriction","line":1513,"kind":13},{"name":"$leaves1","containerName":"topological_restriction","line":1513,"kind":13},{"kind":13,"line":1513,"containerName":"topological_restriction","name":"$i"},{"line":1513,"kind":13,"containerName":"topological_restriction","name":"$i"},{"containerName":"topological_restriction","definition":"my","name":"%position2","localvar":"my","kind":13,"line":1515},{"containerName":"topological_restriction","definition":"my","name":"@commonleaves","localvar":"my","kind":13,"line":1516},{"line":1517,"kind":13,"localvar":"my","containerName":"topological_restriction","name":"$j","definition":"my"},{"line":1517,"kind":13,"containerName":"topological_restriction","name":"$j"},{"line":1517,"kind":13,"containerName":"topological_restriction","name":"$numleaves2"},{"kind":13,"line":1517,"name":"$j","containerName":"topological_restriction"},{"line":1518,"kind":13,"containerName":"topological_restriction","name":"$position1"},{"kind":13,"line":1518,"name":"$leaves2","containerName":"topological_restriction"},{"kind":13,"line":1518,"containerName":"topological_restriction","name":"$j"},{"name":"@commonleaves","containerName":"topological_restriction","line":1519,"kind":13},{"kind":13,"line":1519,"name":"$leaves2","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$j","kind":13,"line":1519},{"name":"$position2","containerName":"topological_restriction","line":1520,"kind":13},{"kind":13,"line":1520,"name":"$leaves2","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$j","kind":13,"line":1520},{"containerName":"topological_restriction","name":"$j","line":1520,"kind":13},{"line":1523,"kind":13,"localvar":"my","containerName":"topological_restriction","name":"$graphred1","definition":"my"},{"containerName":"topological_restriction","name":"$net1","kind":13,"line":1523},{"name":"copy","containerName":"topological_restriction","line":1523,"kind":12},{"definition":"my","name":"$graphred2","containerName":"topological_restriction","localvar":"my","kind":13,"line":1524},{"line":1524,"kind":13,"name":"$net2","containerName":"topological_restriction"},{"kind":12,"line":1524,"name":"copy","containerName":"topological_restriction"},{"line":1526,"kind":13,"localvar":"my","definition":"my","name":"$u","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$graphred1","kind":13,"line":1526},{"name":"vertices","containerName":"topological_restriction","line":1526,"kind":12},{"line":1527,"kind":13,"localvar":"my","containerName":"topological_restriction","definition":"my","name":"$mu"},{"kind":13,"line":1527,"name":"$net1","containerName":"topological_restriction"},{"kind":12,"line":1527,"name":"mudata_node","containerName":"topological_restriction"},{"name":"$u","containerName":"topological_restriction","line":1527,"kind":13},{"kind":13,"line":1528,"containerName":"topological_restriction","definition":"my","name":"$leaf","localvar":"my"},{"containerName":"topological_restriction","name":"@commonleaves","line":1528,"kind":13},{"containerName":"topological_restriction","name":"$mu","kind":13,"line":1529},{"line":1529,"kind":13,"containerName":"topological_restriction","name":"$position1"},{"containerName":"topological_restriction","name":"$leaf","line":1529,"kind":13},{"kind":13,"line":1533,"name":"$graphred1","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"delete_vertex","kind":12,"line":1533},{"kind":13,"line":1533,"name":"$u","containerName":"topological_restriction"},{"line":1536,"kind":13,"localvar":"my","containerName":"topological_restriction","definition":"my","name":"$u"},{"name":"$graphred2","containerName":"topological_restriction","kind":13,"line":1536},{"containerName":"topological_restriction","name":"vertices","kind":12,"line":1536},{"line":1537,"kind":13,"localvar":"my","definition":"my","name":"$mu","containerName":"topological_restriction"},{"name":"$net2","containerName":"topological_restriction","line":1537,"kind":13},{"kind":12,"line":1537,"name":"mudata_node","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$u","kind":13,"line":1537},{"name":"$leaf","definition":"my","containerName":"topological_restriction","localvar":"my","kind":13,"line":1538},{"name":"@commonleaves","containerName":"topological_restriction","kind":13,"line":1538},{"line":1539,"kind":13,"containerName":"topological_restriction","name":"$mu"},{"line":1539,"kind":13,"name":"$position2","containerName":"topological_restriction"},{"kind":13,"line":1539,"name":"$leaf","containerName":"topological_restriction"},{"name":"$graphred2","containerName":"topological_restriction","line":1543,"kind":13},{"kind":12,"line":1543,"name":"delete_vertex","containerName":"topological_restriction"},{"kind":13,"line":1543,"name":"$u","containerName":"topological_restriction"},{"containerName":"topological_restriction","name":"$netr1","definition":"my","localvar":"my","kind":13,"line":1545},{"containerName":"topological_restriction","name":"new","kind":12,"line":1545},{"line":1545,"kind":13,"containerName":"topological_restriction","name":"$graphred1"},{"containerName":"topological_restriction","name":"$netr2","definition":"my","localvar":"my","kind":13,"line":1546},{"name":"new","containerName":"topological_restriction","line":1546,"kind":12},{"containerName":"topological_restriction","name":"$graphred2","kind":13,"line":1546},{"name":"$netr1","containerName":"topological_restriction","line":1547,"kind":13},{"kind":13,"line":1547,"containerName":"topological_restriction","name":"$netr2"}],"line":1504,"kind":12,"signature":{"label":"topological_restriction($net1,$net2)","parameters":[{"label":"$net1"},{"label":"$net2"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork"},"detail":"($net1,$net2)","definition":"sub","containerName":"main::"},{"name":"graph","line":1523,"kind":12},{"line":1524,"kind":12,"name":"graph"},{"line":1525,"kind":12,"name":"OUTER1"},{"name":"OUTER1","line":1530,"kind":12},{"kind":12,"line":1535,"name":"OUTER2"},{"name":"OUTER2","kind":12,"line":1540},{"kind":12,"line":1545,"containerName":"PhyloNetwork","name":"Bio"},{"kind":12,"line":1546,"containerName":"PhyloNetwork","name":"Bio"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"eNewick($self)","documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":1563,"children":[{"kind":13,"line":1564,"containerName":"eNewick","definition":"my","name":"$self","localvar":"my"},{"localvar":"my","name":"$str","definition":"my","containerName":"eNewick","line":1565,"kind":13},{"containerName":"eNewick","name":"$seen","definition":"my","localvar":"my","kind":13,"line":1566},{"containerName":"eNewick","definition":"my","name":"$root","localvar":"my","kind":13,"line":1567},{"line":1567,"kind":13,"containerName":"eNewick","name":"$self"},{"containerName":"eNewick","name":"roots","kind":12,"line":1567},{"name":"$str","containerName":"eNewick","kind":13,"line":1568},{"line":1568,"kind":13,"name":"$str","containerName":"eNewick"},{"name":"$self","containerName":"eNewick","line":1568,"kind":13},{"line":1568,"kind":12,"name":"eNewick_aux","containerName":"eNewick"},{"kind":13,"line":1568,"name":"$root","containerName":"eNewick"},{"kind":13,"line":1568,"containerName":"eNewick","name":"$seen"},{"name":"$str","containerName":"eNewick","line":1570,"kind":13}],"name":"eNewick","range":{"end":{"line":1571,"character":9999},"start":{"character":0,"line":1563}}},{"range":{"end":{"line":1592,"character":9999},"start":{"character":0,"line":1573}},"name":"eNewick_aux","line":1573,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"eNewick_aux","line":1574,"kind":13},{"name":"$node","containerName":"eNewick_aux","kind":13,"line":1574},{"name":"$seen","containerName":"eNewick_aux","kind":13,"line":1574},{"line":1574,"kind":13,"name":"$parent","containerName":"eNewick_aux"},{"localvar":"my","containerName":"eNewick_aux","definition":"my","name":"$str","line":1575,"kind":13},{"kind":13,"line":1576,"name":"$self","containerName":"eNewick_aux"},{"kind":12,"line":1576,"name":"is_leaf","containerName":"eNewick_aux"},{"containerName":"eNewick_aux","name":"$node","kind":13,"line":1576},{"line":1577,"kind":13,"containerName":"eNewick_aux","name":"$seen"},{"line":1577,"kind":13,"containerName":"eNewick_aux","name":"$node"},{"containerName":"eNewick_aux","name":"$str","line":1579,"kind":13},{"containerName":"eNewick_aux","name":"$self","line":1579,"kind":13},{"containerName":"eNewick_aux","name":"$parent","line":1579,"kind":13},{"line":1579,"kind":13,"name":"$node","containerName":"eNewick_aux"},{"containerName":"eNewick_aux","name":"$seen","kind":13,"line":1582},{"line":1582,"kind":13,"containerName":"eNewick_aux","name":"$node"},{"localvar":"my","definition":"my","name":"@sons","containerName":"eNewick_aux","line":1583,"kind":13},{"kind":13,"line":1583,"containerName":"eNewick_aux","name":"$self"},{"line":1583,"kind":12,"name":"successors","containerName":"eNewick_aux"},{"name":"$node","containerName":"eNewick_aux","line":1583,"kind":13},{"containerName":"eNewick_aux","name":"$str","line":1584,"kind":13},{"kind":13,"line":1585,"containerName":"eNewick_aux","definition":"my","name":"$son","localvar":"my"},{"line":1585,"kind":13,"containerName":"eNewick_aux","name":"@sons"},{"containerName":"eNewick_aux","name":"$str","kind":13,"line":1586},{"name":"$str","containerName":"eNewick_aux","line":1586,"kind":13},{"kind":13,"line":1586,"name":"$self","containerName":"eNewick_aux"},{"line":1586,"kind":12,"name":"eNewick_aux","containerName":"eNewick_aux"},{"containerName":"eNewick_aux","name":"$son","kind":13,"line":1586},{"containerName":"eNewick_aux","name":"$seen","kind":13,"line":1586},{"name":"$node","containerName":"eNewick_aux","kind":13,"line":1586},{"line":1588,"kind":13,"containerName":"eNewick_aux","name":"$str"},{"kind":13,"line":1589,"name":"$str","containerName":"eNewick_aux"},{"name":"$self","containerName":"eNewick_aux","line":1589,"kind":13},{"line":1589,"kind":13,"containerName":"eNewick_aux","name":"$parent"},{"kind":13,"line":1589,"containerName":"eNewick_aux","name":"$node"},{"line":1591,"kind":13,"name":"$str","containerName":"eNewick_aux"}],"kind":12,"detail":"($self,$node,$seen,$parent)","signature":{"label":"eNewick_aux($self,$node,$seen,$parent)","documentation":"","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$seen"},{"label":"$parent"}]},"containerName":"main::","definition":"sub"},{"name":"make_label","line":1579,"kind":12},{"name":"graph","line":1583,"kind":12},{"name":"make_label","line":1589,"kind":12},{"range":{"end":{"character":9999,"line":1617},"start":{"character":0,"line":1594}},"name":"make_label","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$node"}],"label":"make_label($self,$parent,$node)"},"detail":"($self,$parent,$node)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"make_label","localvar":"my","kind":13,"line":1595},{"containerName":"make_label","name":"$parent","kind":13,"line":1595},{"kind":13,"line":1595,"name":"$node","containerName":"make_label"},{"localvar":"my","containerName":"make_label","definition":"my","name":"$str","line":1596,"kind":13},{"kind":13,"line":1597,"name":"$self","containerName":"make_label"},{"name":"is_hybrid_node","containerName":"make_label","kind":12,"line":1597},{"name":"$node","containerName":"make_label","line":1597,"kind":13},{"kind":13,"line":1598,"name":"$lbl","definition":"my","containerName":"make_label","localvar":"my"},{"name":"$self","containerName":"make_label","kind":13,"line":1598},{"name":"$node","containerName":"make_label","line":1598,"kind":13},{"line":1599,"kind":13,"name":"$lbl","containerName":"make_label"},{"containerName":"make_label","name":"$lbl","line":1600,"kind":13},{"name":"$str","containerName":"make_label","line":1602,"kind":13},{"kind":13,"line":1602,"containerName":"make_label","name":"$lbl"},{"line":1603,"kind":13,"containerName":"make_label","name":"$str"},{"name":"$parent","containerName":"make_label","kind":13,"line":1604},{"name":"$self","containerName":"make_label","line":1605,"kind":13},{"kind":12,"line":1605,"containerName":"make_label","name":"graph"},{"line":1605,"kind":12,"containerName":"make_label","name":"has_edge_attribute"},{"containerName":"make_label","name":"$parent","kind":13,"line":1605},{"name":"$node","containerName":"make_label","kind":13,"line":1605},{"kind":13,"line":1606,"name":"$str","containerName":"make_label"},{"name":"$self","containerName":"make_label","line":1606,"kind":13},{"line":1606,"kind":12,"containerName":"make_label","name":"graph"},{"name":"get_edge_attribute","containerName":"make_label","kind":12,"line":1606},{"containerName":"make_label","name":"$parent","kind":13,"line":1606},{"line":1606,"kind":13,"containerName":"make_label","name":"$node"},{"containerName":"make_label","name":"$str","line":1608,"kind":13},{"kind":13,"line":1608,"name":"$node","containerName":"make_label"},{"containerName":"make_label","name":"$str","line":1610,"kind":13},{"name":"$self","containerName":"make_label","kind":13,"line":1610},{"containerName":"make_label","name":"$node","line":1610,"kind":13},{"line":1612,"kind":13,"containerName":"make_label","name":"$parent"},{"kind":13,"line":1613,"containerName":"make_label","name":"$self"},{"containerName":"make_label","name":"graph","line":1613,"kind":12},{"line":1613,"kind":12,"containerName":"make_label","name":"has_edge_weight"},{"line":1613,"kind":13,"containerName":"make_label","name":"$parent"},{"containerName":"make_label","name":"$node","line":1613,"kind":13},{"containerName":"make_label","name":"$str","kind":13,"line":1614},{"kind":13,"line":1614,"containerName":"make_label","name":"$self"},{"kind":12,"line":1614,"containerName":"make_label","name":"graph"},{"line":1614,"kind":12,"containerName":"make_label","name":"get_edge_weight"},{"kind":13,"line":1614,"containerName":"make_label","name":"$parent"},{"containerName":"make_label","name":"$node","line":1614,"kind":13},{"kind":13,"line":1616,"name":"$str","containerName":"make_label"}],"line":1594,"kind":12},{"name":"labels","kind":12,"line":1598},{"line":1610,"kind":12,"name":"labels"},{"name":"eNewick_full","range":{"end":{"character":9999,"line":1638},"start":{"character":0,"line":1630}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    $str.=$self->{labels}->{$node};\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n=head2 eNewick_full\n\n Title   : eNewick_full\n Usage   : my $str=$net->eNewick_full()\n Function: returns the eNewick representation of $net labeling\n           internal tree nodes\n Returns : string\n Args    : none","label":"eNewick_full($self)"},"kind":12,"line":1630,"children":[{"localvar":"my","containerName":"eNewick_full","definition":"my","name":"$self","line":1631,"kind":13},{"kind":13,"line":1632,"definition":"my","name":"$str","containerName":"eNewick_full","localvar":"my"},{"localvar":"my","definition":"my","name":"$seen","containerName":"eNewick_full","line":1633,"kind":13},{"line":1634,"kind":13,"localvar":"my","definition":"my","name":"$root","containerName":"eNewick_full"},{"containerName":"eNewick_full","name":"$self","kind":13,"line":1634},{"kind":12,"line":1634,"containerName":"eNewick_full","name":"roots"},{"line":1635,"kind":13,"name":"$str","containerName":"eNewick_full"},{"name":"$str","containerName":"eNewick_full","kind":13,"line":1635},{"containerName":"eNewick_full","name":"$self","kind":13,"line":1635},{"kind":12,"line":1635,"containerName":"eNewick_full","name":"eNewick_full_aux"},{"name":"$root","containerName":"eNewick_full","kind":13,"line":1635},{"kind":13,"line":1635,"containerName":"eNewick_full","name":"$seen"},{"line":1637,"kind":13,"containerName":"eNewick_full","name":"$str"}]},{"containerName":"main::","definition":"sub","detail":"($self,$node,$seen,$parent)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$node"},{"label":"$seen"},{"label":"$parent"}],"label":"eNewick_full_aux($self,$node,$seen,$parent)"},"kind":12,"line":1640,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"eNewick_full_aux","line":1641,"kind":13},{"kind":13,"line":1641,"containerName":"eNewick_full_aux","name":"$node"},{"containerName":"eNewick_full_aux","name":"$seen","kind":13,"line":1641},{"containerName":"eNewick_full_aux","name":"$parent","kind":13,"line":1641},{"line":1642,"kind":13,"localvar":"my","containerName":"eNewick_full_aux","definition":"my","name":"$str"},{"containerName":"eNewick_full_aux","name":"$self","kind":13,"line":1643},{"kind":12,"line":1643,"containerName":"eNewick_full_aux","name":"is_leaf"},{"name":"$node","containerName":"eNewick_full_aux","kind":13,"line":1643},{"containerName":"eNewick_full_aux","name":"$seen","kind":13,"line":1644},{"name":"$node","containerName":"eNewick_full_aux","line":1644,"kind":13},{"name":"$str","containerName":"eNewick_full_aux","line":1646,"kind":13},{"line":1646,"kind":13,"name":"$self","containerName":"eNewick_full_aux"},{"name":"$parent","containerName":"eNewick_full_aux","line":1646,"kind":13},{"kind":13,"line":1646,"containerName":"eNewick_full_aux","name":"$node"},{"name":"$seen","containerName":"eNewick_full_aux","line":1649,"kind":13},{"kind":13,"line":1649,"name":"$node","containerName":"eNewick_full_aux"},{"kind":13,"line":1650,"containerName":"eNewick_full_aux","definition":"my","name":"@sons","localvar":"my"},{"containerName":"eNewick_full_aux","name":"$self","line":1650,"kind":13},{"containerName":"eNewick_full_aux","name":"successors","line":1650,"kind":12},{"containerName":"eNewick_full_aux","name":"$node","kind":13,"line":1650},{"containerName":"eNewick_full_aux","name":"$str","line":1651,"kind":13},{"line":1652,"kind":13,"localvar":"my","containerName":"eNewick_full_aux","definition":"my","name":"$son"},{"name":"@sons","containerName":"eNewick_full_aux","kind":13,"line":1652},{"name":"$str","containerName":"eNewick_full_aux","kind":13,"line":1653},{"line":1653,"kind":13,"name":"$str","containerName":"eNewick_full_aux"},{"line":1653,"kind":13,"name":"$self","containerName":"eNewick_full_aux"},{"line":1653,"kind":12,"containerName":"eNewick_full_aux","name":"eNewick_full_aux"},{"name":"$son","containerName":"eNewick_full_aux","line":1653,"kind":13},{"name":"$seen","containerName":"eNewick_full_aux","line":1653,"kind":13},{"containerName":"eNewick_full_aux","name":"$node","line":1653,"kind":13},{"containerName":"eNewick_full_aux","name":"$str","kind":13,"line":1655},{"kind":13,"line":1656,"name":"$str","containerName":"eNewick_full_aux"},{"line":1656,"kind":13,"name":"$self","containerName":"eNewick_full_aux"},{"name":"$parent","containerName":"eNewick_full_aux","line":1656,"kind":13},{"name":"$node","containerName":"eNewick_full_aux","kind":13,"line":1656},{"containerName":"eNewick_full_aux","name":"$str","kind":13,"line":1658}],"name":"eNewick_full_aux","range":{"start":{"character":0,"line":1640},"end":{"line":1659,"character":9999}}},{"kind":12,"line":1646,"name":"make_label_full"},{"kind":12,"line":1650,"name":"graph"},{"name":"make_label_full","line":1656,"kind":12},{"name":"make_label_full","range":{"end":{"line":1689,"character":9999},"start":{"character":0,"line":1661}},"kind":12,"children":[{"localvar":"my","containerName":"make_label_full","definition":"my","name":"$self","line":1662,"kind":13},{"containerName":"make_label_full","name":"$parent","line":1662,"kind":13},{"line":1662,"kind":13,"containerName":"make_label_full","name":"$node"},{"containerName":"make_label_full","name":"$str","definition":"my","localvar":"my","kind":13,"line":1663},{"line":1664,"kind":13,"containerName":"make_label_full","name":"$self"},{"line":1664,"kind":12,"containerName":"make_label_full","name":"is_hybrid_node"},{"line":1664,"kind":13,"name":"$node","containerName":"make_label_full"},{"line":1665,"kind":13,"localvar":"my","containerName":"make_label_full","name":"$lbl","definition":"my"},{"containerName":"make_label_full","name":"$self","kind":13,"line":1665},{"name":"$node","containerName":"make_label_full","kind":13,"line":1665},{"containerName":"make_label_full","name":"$lbl","kind":13,"line":1666},{"line":1667,"kind":13,"name":"$lbl","containerName":"make_label_full"},{"containerName":"make_label_full","name":"$str","kind":13,"line":1669},{"kind":13,"line":1669,"containerName":"make_label_full","name":"$lbl"},{"line":1670,"kind":13,"containerName":"make_label_full","name":"$str"},{"containerName":"make_label_full","name":"$parent","line":1671,"kind":13},{"name":"$self","containerName":"make_label_full","kind":13,"line":1672},{"line":1672,"kind":12,"name":"graph","containerName":"make_label_full"},{"kind":12,"line":1672,"name":"has_edge_attribute","containerName":"make_label_full"},{"name":"$parent","containerName":"make_label_full","kind":13,"line":1672},{"kind":13,"line":1672,"name":"$node","containerName":"make_label_full"},{"name":"$str","containerName":"make_label_full","line":1673,"kind":13},{"name":"$self","containerName":"make_label_full","line":1673,"kind":13},{"kind":12,"line":1673,"name":"graph","containerName":"make_label_full"},{"name":"get_edge_attribute","containerName":"make_label_full","line":1673,"kind":12},{"line":1673,"kind":13,"name":"$parent","containerName":"make_label_full"},{"containerName":"make_label_full","name":"$node","kind":13,"line":1673},{"containerName":"make_label_full","name":"$str","line":1675,"kind":13},{"line":1675,"kind":13,"containerName":"make_label_full","name":"$node"},{"name":"$self","containerName":"make_label_full","line":1677,"kind":13},{"kind":13,"line":1677,"containerName":"make_label_full","name":"$node"},{"kind":13,"line":1677,"name":"$self","containerName":"make_label_full"},{"name":"$node","containerName":"make_label_full","line":1677,"kind":13},{"containerName":"make_label_full","name":"$str","kind":13,"line":1678},{"containerName":"make_label_full","name":"$self","kind":13,"line":1678},{"containerName":"make_label_full","name":"$node","line":1678,"kind":13},{"kind":13,"line":1681,"name":"$str","containerName":"make_label_full"},{"line":1681,"kind":13,"name":"$node","containerName":"make_label_full"},{"line":1684,"kind":13,"name":"$parent","containerName":"make_label_full"},{"kind":13,"line":1685,"containerName":"make_label_full","name":"$self"},{"line":1685,"kind":12,"name":"graph","containerName":"make_label_full"},{"containerName":"make_label_full","name":"has_edge_weight","line":1685,"kind":12},{"name":"$parent","containerName":"make_label_full","line":1685,"kind":13},{"line":1685,"kind":13,"name":"$node","containerName":"make_label_full"},{"line":1686,"kind":13,"containerName":"make_label_full","name":"$str"},{"containerName":"make_label_full","name":"$self","kind":13,"line":1686},{"line":1686,"kind":12,"name":"graph","containerName":"make_label_full"},{"kind":12,"line":1686,"name":"get_edge_weight","containerName":"make_label_full"},{"kind":13,"line":1686,"name":"$parent","containerName":"make_label_full"},{"containerName":"make_label_full","name":"$node","kind":13,"line":1686},{"kind":13,"line":1688,"containerName":"make_label_full","name":"$str"}],"line":1661,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$parent"},{"label":"$node"}],"label":"make_label_full($self,$parent,$node)"},"detail":"($self,$parent,$node)"},{"kind":12,"line":1665,"name":"labels"},{"name":"labels","line":1677,"kind":12},{"kind":12,"line":1677,"name":"labels"},{"name":"labels","kind":12,"line":1678},{"kind":2,"line":1749,"containerName":"","name":"overload"},{"name":"display","line":1749,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"display($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PhyloNetwork.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona, Gabriel Valiente\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork - Module to compute with Phylogenetic Networks\n\n=head1 SYNOPSIS\n\n use Bio::PhyloNetwork;\n\n # Create a PhyloNetwork object from a eNewick string\n my $net1=Bio::PhyloNetwork->new(\n   -eNewick=>'t0:((H1,(H2,l2)),H2); H1:((H3,l1)); H2:((H3,(l3,H1))); H3:(l4);'\n );\n\n # Print all available data\n print $net1;\n\n # Rebuild $net1 from its mu_data\n my %mudata=$net1->mudata();\n my $net2=Bio::PhyloNetwork->new(-mudata=>\\%mudata,-numleaves=>4);\n print $net2;\n print \"d=\".$net1->mu_distance($net2).\"\\n\";\n\n # Get another one and compute distance\n my $net3=Bio::PhyloNetwork->new(\n   -eNewick=>'(l2,((l1,(H1,l4)),H1))r; (l3)H1;'\n );\n print \"d=\".$net1->mu_distance($net3).\"\\n\";\n\n # ...and find an optimal alignment w.r.t. the Manhattan distance (default)\n my ($weight,%alignment)=$net1->optimal_alignment($net3);\n print \"weight:$weight\\n\";\n foreach my $node1 (keys %alignment) {\n   print \"$node1 => \".$alignment{$node1}.\"\\n\";\n }\n # ...or the Hamming distance\n\n my ($weightH,%alignmentH)=$net1->optimal_alignment($net3,-metric=>'Hamming');\n print \"weight:$weightH\\n\";\n foreach my $node1 (keys %alignmentH) {\n   print \"$node1 => \".$alignmentH{$node1}.\"\\n\";\n }\n\n # Test for time consistency of $net1\n if ($net1->is_time_consistent) {\n   print \"net1 is time consistent\\n\"\n }\n else {\n   print \"net1 is not time consistent\\n\"\n }\n\n # create a network from the list of edges\n my $net4=Bio::PhyloNetwork->new(-edges=>\n   [qw(r s r t s u s c t c t v u b u l3 u b v b v l4 b l2 c l1)]);\n\n # Test for time consistency of $net3\n if ($net4->is_time_consistent) {\n   print \"net4 is time consistent\\n\"\n }\n else {\n   print \"net4 is not time consistent\\n\"\n }\n\n # And print all information on net4\n print $net4;\n\n # Compute some tripartitions\n my %triparts=$net1->tripartitions();\n\n # Now these are stored\n print $net1;\n\n # And can compute the tripartition error\n print \"dtr=\".$net1->tripartition_error($net3).\"\\n\";\n\n=head1 DESCRIPTION\n\n=head2 Phylogenetic Networks\n\nThis is a module to work with phylogenetic networks. Phylogenetic networks\nhave been studied over the last years as a richer model of the evolutionary\nhistory of sets of organisms than phylogenetic trees, because they take not\nonly mutation events but also recombination and horizontal gene transfer\nevents into account.\n\nThe natural model for describing the evolutionary\nhistory of a set of sequences under recombination events is a DAG, hence\nthis package relies on the package Graph::Directed to represent the\nunderlying graph of a phylogenetic network. We refer the reader to [CRV1,CRV2]\nfor formal definitions related to phylogenetic networks.\n\n=head2 eNewick description\n\nWith this package, phylogenetic networks can be given by its eNewick\nstring. This description appeared in other packages related to\nphylogenetic networks (see [PhyloNet] and [NetGen]); in fact, these two\npackages use different descriptions. The Bio::PhyloNetwork\npackage allows both of them, but uses the second one in its output.\n\nThe first approach [PhyloNet] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k+1 different\nnodes; let each of the first k copies be a child of one of the u_1,...,u_k\n(one for each) and have no children (hence we will have k extra leaves);\nas for the last copy, let it have no parents and have v_1,...,v_l be its\nchildren. This way we get a forest; each of the trees will be rooted at either\none root of the phylogenetic network or a hybrid node of it; the set of leaves\n(of the whole forest) will be the set of leaves of the original network\ntogether with the set of hybrid nodes (each of them repeated as many times\nas its in-degree). Then, the eNewick representation of the phylogenetic network\nwill be the Newick representation of all the trees in the obtained forest,\neach of them with its root labeled.\n\nThe second approach [NetGen] goes as follows: For each hybrid node H, say with\nparents u_1,u_2,...,u_k and children v_1,v_2,...v_l: split H in k different\nnodes; let the first copy be a child of u_1 and have all v_1,v_2,...v_l as\nits children; let the other copies be child of u_2,...,u_k (one for each)\nand have no children. This way, we get a tree whose set of leaves is the\nset of leaves of the original network together with the set of hybrid nodes\n(possibly repeated). Then the Newick string of the obtained tree (note that\nsome internal nodes will be labeled and some leaves will be repeated) is\nthe eNewick string of the phylogenetic network.\n\nFor example, consider the network depicted below:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   \\ /   3\n       H\n       |\n       2\n\nIf the first approach is taken, we get the forest:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H H   3\n       |  \n       H\n       |\n       2\n\nHence, the eNewick string is '((1,H),(H,3))r; (2)H;'.\n\nAs for the second one, one gets the tree:\n\n       r\n      / \\\n     /   \\\n    U     V\n   / \\   / \\\n  1   H |   3\n        H\n        |\n        2\n\nHence, the eNewick string is '((1,H),((2)H,3))r;'.\n\nNote: when rooting a tree, this package allows the notations\n'(subtree,subtree,...)root' as well as 'root:(subtree,subtree,...)', but\nthe first one is used when writing eNewick strings.\n\n=head2 Tree-child phylogenetic networks\n\nTree-child (TC) phylogenetic networks are a special class of phylogenetic\nnetworks for which a distance, called mu-distance, is defined [CRV2]\nbased on certain data (mu-data) associated to every node.\nMoreover, this distance extends the\nRobinson-Foulds on phylogenetic trees. This package allows testing for a\nphylogenetic network if it is TC and computes mu-distances between networks\nover the same set of leaves.\n\nMoreover, the mu-data allows to define the optimal\n(in some precise sense) alignment between networks\nover the same set of leaves. This package also computes this optimal alignment.\n\n=head2 Tripartitions\n\nAlthough tripartitions (see [CRV1] and the references therein) do not allow\nto define distances, this package outputs tripartitions and computes a weak\nform of the tripartition error.\n\n=head2 Time-consistency\n\nAnother useful property of Phylogenetic Networks that appears in the literature\nis that of time-consistency or real-time hybrids [BSS]. Roughly speaking, a\nnetwork admits a temporal representation if it can be drawn in such a way\nthat tree arcs (those whose end is a tree node) are inclined downwards, while\nhybridization arcs (those whose end is a hybrid node) are horizontal.\nThis package checks for time-consistency and, if so, a temporal representation\nis provided.\n\n=head1 AUTHOR\n\n Gabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n Gabriel Valiente, valiente(at)lsi(dot)upc(dot)edu\n\n=head1 SEE ALSO\n\n\n* [CRV1]\n\nG. Cardona, F. Rossello, G. Valiente. Tripartitions do not always\ndiscriminate phylogenetic networks. arXiv:0707.2376v1 [q-bio.PE]\n\n* [CRV2]\n\nG. Cardona, F. Rossello, G. Valiente. A Distance Measure for\nTree-Child Phylogenetic Networks. Preprint.\n\n* [NetGen]\n\nM.M. Morin, and B.M.E. Moret. NetGen: generating phylogenetic networks\nwith diploid hybrids. Bioinformatics 22 (2006), 1921-1923\n\n* [PhyloNet]\n\nPhyloNet: \"Phylogenetic Networks Toolkit\".\nhttp://bioinfo.cs.rice.edu/phylonet\n\n* [BSS]\n\nM. Baroni, C. Semple, and M. Steel. Hybrids in Real\nTime. Syst. Biol. 55(1):46-56, 2006\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork::muVector;\nuse Graph::Directed;\nuse Bio::TreeIO;\nuse Bio::Tree::Node;\nuse IO::String;\nuse Array::Compare;\nuse Algorithm::Munkres;\n\n# Creator\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = new Bio::PhyloNetwork();\n Function: Creates a new Bio::PhyloNetwork object\n Returns : Bio::PhyloNetwork\n Args    : none\n            OR\n           -eNewick => string\n            OR\n           -graph => Graph::Directed object\n            OR\n           -edges => reference to an array\n            OR\n           -tree => Bio::Tree::Tree object\n            OR\n           -mudata => reference to a hash,\n           -leaves => reference to an array\n            OR\n           -mudata => reference to a hash,\n           -numleaves => integer\n\nReturns a Bio::PhyloNetwork object, created according to the data given:\n\n=over 3\n\n* new()\n\ncreates an empty network.\n\n* new(-eNewick =E<gt> $str)\n\ncreates the network whose\nExtended Newick representation (see description above) is the string $str.\n\n* new(-graph =E<gt> $graph)\n\ncreates the network with underlying\ngraph given by the Graph::Directed object $graph\n\n* new(-tree =E<gt> $tree)\n\ncreates a network as a copy of the\nBio::Tree::Tree object in $tree\n\n* new(-mudata =E<gt> \\%mudata, -leaves =E<gt> \\@leaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in \\@leaves.\n\n* new(-mudata =E<gt> \\%mudata, -numleaves =E<gt> $numleaves)\n\ncreates the network by reconstructing it from its mu-data stored in\n\\%mudata and with set of leaves in (\"l1\"..\"l$numleaves\").\n\n\n\nsub new {\n  my ($pkg,@args)=@_;\n  my $self=$pkg->SUPER::new(@args);\n  my ($eNewick,$edgesR,$leavesR,$numleaves,$graph,$tree,$mudataR)=\n    $self->_rearrange([qw(ENEWICK\n\t\t\t  EDGES\n\t\t\t  LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  GRAPH\n\t\t\t  TREE\n\t\t\t  MUDATA)],@args);\n  bless($self,$pkg);\n\n  $self->build_from_eNewick($eNewick) if defined $eNewick;\n  $self->build_from_edges(@$edgesR) if defined $edgesR;\n  $self->build_from_graph($graph) if defined $graph;\n  $self->build_from_tree($tree) if defined $tree;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    my @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  $self->build_from_mudata($mudataR,$leavesR)\n    if ((defined $mudataR) && (defined $leavesR));\n  return $self;\n}\n\n# Builders\n\nsub build_from_edges {\n  my ($self,@edges)=@_;\n  my $graph=Graph::Directed->new();\n  $graph->add_edges(@edges);\n  $self->{graph}=$graph;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nsub build_from_graph {\n  my ($self,$graph)=@_;\n  my $graphcp=$graph->copy();\n  $self->{graph}=$graphcp;\n  $self->recompute();\n  my $labels={};\n  foreach my $node ($self->nodes()) {\n    $labels->{$node}=$node;\n  }\n  $self->{labels}=$labels;\n}\n\nmy $_eN_index;\n\nsub build_from_eNewick {\n  my ($self,$string)=@_;\n  $_eN_index=0;\n  my $graph=Graph::Directed->new();\n  my $labels={};\n  my @blocks=split(/; */,$string);\n  foreach my $block (@blocks) {\n    my ($rt,$str)=get_root_and_subtree($block);\n    my ($rtlbl,$rttype,$rtid,$rtlng)=get_label_type_id_length($rt);\n    process_block($graph,$labels,$block,$rtid);\n    $labels->{$rtid}=$rtlbl.'';\n  }\n  $self->{graph}=$graph;\n  $self->{labels}=$labels;\n  $self->recompute();\n}\n\nsub process_block {\n  my ($graph,$labels,$block,$rtid)=@_;\n  my ($rt,$str)=get_root_and_subtree($block);\n  my @substrs=my_split($str);\n  foreach my $substr (@substrs) {\n    my ($subrt,$subblock)=get_root_and_subtree($substr);\n    my ($subrtlbl,$subrttype,$subrtid,$subrtlng)=\n      get_label_type_id_length($subrt);\n    if (! $subrtlng eq '') {\n      $graph->add_weighted_edges($rtid,$subrtid,$subrtlng);\n    }\n    else {\n      $graph->add_edges($rtid,$subrtid);\n    }\n    if (! $subrttype eq '') {\n      $graph->set_edge_attribute($rtid,$subrtid,'type',$subrttype);\n    }\n    $subrtlbl.='';\n#    if (! $subrtlbl eq '') {\n    if ((! defined $labels->{$subrtid})||($labels->{$subrtid} eq '')){\n      $labels->{$subrtid}=$subrtlbl;\n    } elsif (( $labels->{$subrtid} ne $subrtlbl )&&($subrtlbl ne '')) {\n      # error\n      die(\"Different labels for the same node (\".$labels->{$subrtid}.\" and $subrtlbl)\");\n    }\n#    }\n    if ($subblock ne \"\") {\n      process_block($graph,$labels,$subblock,$subrtid);\n    }\n  }\n}\n\nsub get_root_and_subtree {\n  my ($block)=@_;\n  my ($rt,$str)=(\"\",\"\");\n#  ($rt,$str)=split(/:|=/,$block);\n  ($rt,$str)=split(/=/,$block);\n  if ($rt eq $block) {\n    # try to look for root label at the end\n    my $pos=length($rt)-1;\n    while ((substr($rt,$pos,1) ne \")\") && ($pos >=0)) {\n      $pos--;\n    }\n    $rt=substr($block,$pos+1,length($block)-$pos);\n    $str=substr($block,0,$pos+1);\n  }\n  $rt=trim($rt);\n  $str=trim($str);\n  return ($rt,$str);\n}\n\nsub get_label_type_id_length {\n  my ($string) = @_;\n  $string.='';\n#  print \"$string\\n\";\n  if (index($string,'#')==-1) {\n    # no hybrid\n    my ($label,$length)=split(':',$string);\n    $label.='';\n    my $id;\n    if ((! defined $label) || ($label eq '')) {\n      # create id\n      $_eN_index++;\n      $id=\"T$_eN_index\";\n    } else {\n      $id=$label;\n    }\n    return ($label,'',$id,$length);\n  }\n  else {\n    # hybrid\n    my ($label,$string2)=split('#',$string);\n    my ($typeid,$length)=split(':',$string2);\n    my $type=$typeid;\n    $type =~ s/\\d//g;\n    my $id=$typeid;\n    $id =~ s/\\D//g;\n    return ($label,$type,'#'.$id,$length);\n  }\n}\n\nsub trim\n{\n  my ($string) = @_;\n  $string =~ s/^\\s+//;\n  $string =~ s/\\s+$//;\n  return $string;\n}\n\nsub my_split {\n  my ( $string ) = @_;\n  my $temp=\"\";\n  my @substrings;\n  my $level=1;\n  for my $i ( 1 .. length( $string ) ) {\n    my $char=substr($string,$i,1);\n    if ($char eq \"(\") {\n      $level++;\n    }\n    if ($char eq \")\") {\n      if ($level==1) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n      }\n      $level--;\n    }\n    if (($char eq \",\") && ($level==1)) {\n      \tpush @substrings, $temp;\n\t$temp=\"\";\n\t$char=\"\";\n    }\n    $temp = $temp.$char;\n  }\n  return @substrings;\n}\n\nsub build_from_mudata {\n  my ($self,$mus,$leavesR)=@_;\n  my $graph=Graph::Directed->new();\n  my @nodes=keys %{$mus};\n  my @leaves=@{$leavesR};\n\n  my %seen;\n  my @internal;\n\n  @seen{@leaves} = ();\n\n  foreach my $node (@nodes) {\n    push(@internal, $node) unless exists $seen{$node};\n  }\n\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  @nodes=(@internal,@leaves);\n  my $numnodes=@nodes;\n  for (my $i=0;$i<$numnodes;$i++) {\n    my $mu=$mus->{$nodes[$i]};\n    my $j=$i+1;\n    while ($mu->is_positive() && $j<$numnodes) {\n      if ($mu->geq_poset($mus->{$nodes[$j]})) {\n\t$graph->add_edges(($nodes[$i],$nodes[$j]));\n\t$mu = $mu - $mus->{$nodes[$j]};\n      }\n      $j++;\n    }\n  }\n  $self->build_from_graph($graph);\n}\n\n# sub relabel_tree {\n#   my ($tree)=@_;\n#   my $i=1;\n#   my $j=1;\n#   my $root=$tree->get_root_node();\n#   foreach my $node ($tree->get_nodes()) {\n#     if ($node == $root) {\n#       $node->{'_id'}=\"r\";\n#     }\n#     elsif (! $node->is_Leaf) {\n#       $node->{'_id'}=\"t$i\";\n#       $i++;\n#     }\n#     else {\n#       if ($node->{'_id'} eq \"\") {\n# \t$node->{'_id'}=\"l$j\";\n# \t$j++;\n#       }\n#     }\n#   }\n#   return $tree;\n# }\n\n# sub build_subtree {\n#   my ($graph,$root)=@_;\n#   foreach my $child ($root->each_Descendent) {\n#     $graph->add_edge($root->id,$child->id);\n#     $graph=build_subtree($graph,$child);\n#   }\n#   return $graph;\n# }\n\nsub build_from_tree {\n  my ($self,$tree)=@_;\n#  relabel_tree($tree);\n#  my $treeroot=$tree->get_root_node;\n#  my $graph=Graph::Directed->new();\n#  $graph=build_subtree($graph,$treeroot);\n#  $self->build_from_graph($graph);\n  my $str;\n  my $io=IO::String->new($str);\n  my $treeio=Bio::TreeIO->new(-format => 'newick', -fh => $io);\n  $treeio->write_tree($tree);\n#  print \"intern: $str\\n\";\n  $self->build_from_eNewick($str);\n}\n\nsub recompute {\n  my ($self)=@_;\n  $self->throw(\"Graph is not DAG:\".$self->{graph})\n    unless $self->{graph}->is_dag();\n  my @leaves=$self->{graph}->successorless_vertices();\n  @leaves=sort @leaves;\n  my $numleaves=@leaves;\n  my @roots=$self->{graph}->predecessorless_vertices();\n  my $numroots=@roots;\n  #$self->throw(\"Graph is not rooted\") unless ($numroots == 1);\n  my @nodes=$self->{graph}->vertices();\n  @nodes=sort @nodes;\n  my $numnodes=@nodes;\n  foreach my $node (@nodes) {\n    if (! defined $self->{labels}->{$node}) {\n      $self->{labels}->{$node}='';\n    }\n  }\n  $self->{leaves}=\\@leaves;\n  $self->{numleaves}=$numleaves;\n  $self->{roots}=\\@roots;\n  $self->{numroots}=$numroots;\n  $self->{nodes}=\\@nodes;\n  $self->{numnodes}=$numnodes;\n  $self->{mudata}={};\n  $self->{h}={};\n  $self->compute_height();\n  $self->compute_mu();\n  return $self;\n}\n\n# Hybridizing\n\nsub is_attackable {\n  my ($self,$u1,$v1,$u2,$v2)=@_;\n  if ( $self->is_hybrid_node($v1) ||\n       $self->is_hybrid_node($v2) ||\n       $self->graph->is_reachable($v2,$u1) ||\n       (($u1 eq $u2)&&($v1 eq $v2)) ||\n       (! scalar grep {($_ ne $v2) && ($self->is_tree_node($_))}\n\t$self->graph->successors($u2)))\n    {\n      return 0;\n    }\n  return 1;\n}\n\nsub do_attack {\n  my ($self,$u1,$v1,$u2,$v2,$lbl)=@_;\n  my $graph=$self->{graph};\n  $graph->delete_edge($u1,$v1);\n  $graph->delete_edge($u2,$v2);\n  $graph->add_edge($u1,\"T$lbl\");\n  $graph->add_edge(\"T$lbl\",$v1);\n  $graph->add_edge($u2,\"#H$lbl\");\n  $graph->add_edge(\"#H$lbl\",$v2);\n  $graph->add_edge(\"T$lbl\",\"#H$lbl\");\n  $self->build_from_graph($graph);\n}\n\n\n# Computation of mu-data\n\nsub compute_mu {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my $mudata=$self->{mudata};\n  my @leaves=@{$self->{leaves}};\n  my $numleaves=$self->{numleaves};\n  for (my $i=0;$i<$numleaves;$i++) {\n    my $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n    $vec->[$i]=1;\n    $mudata->{$leaves[$i]}=$vec;\n  }\n  my $h=1;\n  while (my @nodes=grep {$self->{h}->{$_} == $h} @{$self->{nodes}} )\n    {\n      foreach my $u (@nodes) {\n\tmy $vec=Bio::PhyloNetwork::muVector->new($numleaves);\n\tforeach my $son ($graph->successors($u)) {\n\t  $vec+=$mudata->{$son};\n\t}\n\t$mudata->{$u}=$vec;\n      }\n      $h++;\n    }\n}\n\nsub compute_height {\n  my ($self)=@_;\n  my $graph=$self->{graph};\n  my @leaves=@{$self->{leaves}};\n  foreach my $leaf (@leaves) {\n    $self->{h}->{$leaf}=0;\n  }\n  my $h=0;\n  while (my @nodes=grep {(defined $self->{h}->{$_})&&($self->{h}->{$_} == $h)}\n\t @{$self->{nodes}} )\n    {\n    foreach my $node (@nodes) {\n      foreach my $parent ($graph->predecessors($node)) {\n\t$self->{h}->{$parent}=$h+1;\n      }\n    }\n    $h++;\n  }\n}\n\n# Tests\n\n=head2 is_leaf\n\n Title   : is_leaf\n Usage   : my $b=$net->is_leaf($u)\n Function: tests if $u is a leaf in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_leaf {\n  my ($self,$node)=@_;\n  if ($self->{graph}->out_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_root\n\n Title   : is_root\n Usage   : my $b=$net->is_root($u)\n Function: tests if $u is the root of $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_root {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) == 0) {return 1;}\n  return 0;\n}\n\n=head2 is_tree_node\n\n Title   : is_tree_node\n Usage   : my $b=$net->is_tree_node($u)\n Function: tests if $u is a tree node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_tree_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) <= 1) {return 1;}\n  return 0;\n}\n\n=head2 is_hybrid_node\n\n Title   : is_hybrid_node\n Usage   : my $b=$net->is_hybrid_node($u)\n Function: tests if $u is a hybrid node in $net\n Returns : boolean\n Args    : scalar\n\n\nsub is_hybrid_node {\n  my ($self,$node)=@_;\n  if ($self->{graph}->in_degree($node) > 1) {return 1;}\n  return 0;\n}\n\nsub has_tree_child {\n  # has_tree_child(g,u) returns 1 if u has a tree child in graph g\n  # and 0 otherwise\n  my $g=shift(@_);\n  my $node=shift(@_);\n  my @Sons=$g->successors($node);\n  foreach my $son (@Sons) {\n    if ($g->in_degree($son)==1) {\n      return 1;\n    }\n  }\n  return 0;\n}\n\n=head2 is_tree_child\n\n Title   : is_tree_child\n Usage   : my $b=$net->is_tree_child()\n Function: tests if $net is a Tree-Child phylogenetic network\n Returns : boolean\n Args    : Bio::PhyloNetwork\n\n\nsub is_tree_child {\n  my ($self)=@_;\n  if (defined $self->{is_tree_child}) {\n    return $self->{is_tree_child};\n  }\n  $self->{is_tree_child}=0;\n  my $graph=$self->{graph};\n  foreach my $node (@{$self->{nodes}}) {\n    return 0 unless ($graph->out_degree($node)==0 ||\n\t\t     has_tree_child($graph,$node));\n  }\n  $self->{is_tree_child}=1;\n  return 1;\n}\n\n# Accessors\n\n=head2 nodes\n\n Title   : nodes\n Usage   : my @nodes=$net->nodes()\n Function: returns the set of nodes of $net\n Returns : array\n Args    : none\n\n\nsub nodes {\n  my ($self)=@_;\n  return @{$self->{nodes}};\n}\n\n=head2 leaves\n\n Title   : leaves\n Usage   : my @leaves=$net->leaves()\n Function: returns the set of leaves of $net\n Returns : array\n Args    : none\n\n\nsub leaves {\n  my ($self)=@_;\n  return @{$self->{leaves}};\n}\n\n=head2 roots\n\n Title   : roots\n Usage   : my @roots=$net->roots()\n Function: returns the set of roots of $net\n Returns : array\n Args    : none\n\n\nsub roots {\n  my ($self)=@_;\n  return @{$self->{roots}};\n}\n\n=head2 internal_nodes\n\n Title   : internal_nodes\n Usage   : my @internal_nodes=$net->internal_nodes()\n Function: returns the set of internal nodes of $net\n Returns : array\n Args    : none\n\n\nsub internal_nodes {\n  my ($self)=@_;\n  return grep {! $self->is_leaf($_)} $self->nodes();\n}\n\n=head2 tree_nodes\n\n Title   : tree_nodes\n Usage   : my @tree_nodes=$net->tree_nodes()\n Function: returns the set of tree nodes of $net\n Returns : array\n Args    : none\n\n\nsub tree_nodes {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_)} $self->nodes();\n}\n\n=head2 hybrid_nodes\n\n Title   : hybrid_nodes\n Usage   : my @hybrid_nodes=$net->hybrid_nodes()\n Function: returns the set of hybrid nodes of $net\n Returns : array\n Args    : none\n\n\nsub hybrid_nodes {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_)} $self->nodes();\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : my $graph=$net->graph()\n Function: returns the underlying graph of $net\n Returns : Graph::Directed\n Args    : none\n\n\nsub graph {\n  my ($self)=@_;\n  return $self->{graph};\n}\n\n=head2 edges\n\n Title   : edges\n Usage   : my @edges=$net->edges()\n Function: returns the set of edges of $net\n Returns : array\n Args    : none\n\nEach element in the array is an anonimous array whose first element is the\nhead of the edge and the second one is the tail.\n\n\nsub edges {\n  my ($self)=@_;\n  return $self->{graph}->edges();\n}\n\n=head2 tree_edges\n\n Title   : tree_edges\n Usage   : my @tree_edges=$net->tree_edges()\n Function: returns the set of tree edges of $net\n           (those whose tail is a tree node)\n Returns : array\n Args    : none\n\n\nsub tree_edges {\n  my ($self)=@_;\n  return grep {$self->is_tree_node($_->[1])} $self->edges();\n}\n\n=head2 hybrid_edges\n\n Title   : hybrid_edges\n Usage   : my @hybrid_edges=$net->hybrid_edges()\n Function: returns the set of hybrid edges of $net\n           (those whose tail is a hybrid node)\n Returns : array\n Args    : none\n\n\nsub hybrid_edges {\n  my ($self)=@_;\n  return grep {$self->is_hybrid_node($_->[1])} $self->edges();\n}\n\n=head2 explode\n\n Title   : explode\n Usage   : my @trees=$net->explode()\n Function: returns the representation of $net by a set of\n           Bio::Tree:Tree objects\n Returns : array\n Args    : none\n\n\nsub explode {\n  my ($self)=@_;\n  my @trees;\n  $self->explode_rec(\\@trees);\n  return @trees;\n}\n\nsub explode_rec {\n  my ($self,$trees)=@_;\n  my @h = $self->hybrid_nodes;\n  if (scalar @h) {\n    my $v = shift @h;\n    for my $u ($self->{graph}->predecessors($v)) {\n      $self->{graph}->delete_edge($u,$v);\n      $self->explode_rec($trees);\n      $self->{graph}->add_edge($u,$v);\n    }\n  } else {\n    my $io = IO::String->new($self->eNewick);\n    my $treeio = Bio::TreeIO->new(-format => 'newick', -fh => $io);\n    my $tree = $treeio->next_tree;\n    $tree->contract_linear_paths;\n    push @{$trees}, $tree;\n  }\n}\n\n=head2 mudata\n\n Title   : mudata\n Usage   : my %mudata=$net->mudata()\n Function: returns the representation of $net by its mu-data\n Returns : hash\n Args    : none\n\n$net-E<gt>mudata() returns a hash with keys the nodes of $net and each value is a\nmuVector object holding its mu-vector.\n\n\nsub mudata {\n  my ($self)=@_;\n  return %{$self->{mudata}};\n}\n\nsub mudata_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}{$u};\n}\n\n=head2 heights\n\n Title   : heights\n Usage   : my %heights=$net->heights()\n Function: returns the heights of the nodes of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>heights() returns a hash with keys the nodes of $net and each value\nis its height.\n\n\nsub heights {\n  my ($self)=@_;\n  return %{$self->{h}};\n}\n\nsub height_node {\n  my ($self,$u)=@_;\n  return $self->{h}{$u};\n}\n\n=head2 mu_distance\n\n Title   : mu_distance\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the networks $net1 and $net2 on\n           the same set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance {\n  my ($net1,$net2)=@_;\n  my @nodes1=$net1->nodes;\n  my @nodes2=$net2->nodes;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  my @leaves=@{$net1->{leaves}};\n  my %matched1;\n  my %matched2;\n  OUTER: foreach my $node1 (@nodes1) {\n    foreach my $node2 (@nodes2) {\n      if (\n\t  (! exists $matched1{$node1}) && (! exists $matched2{$node2}) &&\n\t  ($net1->{mudata}{$node1} == $net2->{mudata}{$node2})\n\t ) {\n\t$matched1{$node1}=$node2;\n\t$matched2{$node2}=$node1;\n\tnext OUTER;\n      }\n    }\n  }\n  return (scalar @nodes1)+(scalar @nodes2)-2*(scalar keys %matched1);\n}\n\n=head2 mu_distance_generalized\n\n Title   : mu_distance_generalized\n Usage   : my $dist=$net1->mu_distance($net2)\n Function: Computes the mu-distance between the topological restrictions of\n           networks $net1 and $net2 on its common set of leaves\n Returns : scalar\n Args    : Bio::PhyloNetwork\n\n\nsub mu_distance_generalized {\n  my ($net1,$net2)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->mu_distance($netr2);\n}\n\n# mudata_string (code mu_data in a string; useful for isomorphism testing)\n\nsub mudata_string_node {\n  my ($self,$u)=@_;\n  return $self->{mudata}->{$u}->display();\n}\n\nsub mudata_string {\n  my ($self)=@_;\n  return $self->{mudata_string} if defined $self->{mudata_string};\n  my @internal=$self->internal_nodes;\n  my $mus=$self->{mudata};\n  @internal=sort {$mus->{$b} <=> $mus->{$a} } @internal;\n  my $str=\"\";\n  foreach my $node (@internal) {\n    $str=$str.$self->mudata_string_node($node);\n  }\n  $self->{mudata_string}=$str;\n  return $str;\n}\n\nsub is_mu_isomorphic {\n  my ($net1,$net2)=@_;\n  return ($net1->mudata_string() eq $net2->mudata_string());\n}\n\n# tripartitions\n\nsub compute_tripartition_node {\n  my ($self,$u)=@_;\n  $self->warn(\"Cannot compute tripartitions on unrooted networks. Will assume one at random\")\n    unless ($self->{numroots} == 1);\n  my $root=$self->{roots}->[0];\n  my $graph=$self->{graph};\n  my $graphPruned=$graph->copy();\n  $graphPruned->delete_vertex($u);\n  my $tripartition=\"\";\n  foreach my $leaf (@{$self->{leaves}}) {\n    my $type;\n    if ($graph->is_reachable($u,$leaf)) {\n      if ($graphPruned->is_reachable($root,$leaf)) {$type=\"B\";}\n      else {$type=\"A\";}\n    }\n    else {$type=\"C\";}\n    $tripartition .= $type;\n  }\n  $self->{tripartitions}->{$u}=$tripartition;\n}\n\nsub compute_tripartitions {\n  my ($self)=@_;\n  foreach my $node (@{$self->{nodes}}) {\n    $self->compute_tripartition_node($node);\n  }\n}\n\n=head2 tripartitions\n\n Title   : tripartitions\n Usage   : my %tripartitions=$net->tripartitions()\n Function: returns the set of tripartitions of $net\n Returns : hash\n Args    : none\n\n$net-E<gt>tripartitions() returns a hash with keys the nodes of $net and each value\nis a string representing the tripartition of the leaves induced by the node.\nA string \"BCA...\" associated with a node u (e.g.) means, the first leaf is in\nthe set B(u), the second one in C(u), the third one in A(u), and so on.\n\n\nsub tripartitions {\n  my ($self)=@_;\n  $self->compute_tripartitions() unless defined $self->{tripartitions};\n  return %{$self->{tripartitions}};\n}\n\n# to do: change to tri_distance and test for TC and time-cons\n\nsub tripartition_error {\n  my ($net1,$net2)=@_;\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot compare phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  $net1->warn(\"Not a tree-child phylogenetic network\")\n    unless $net1->is_tree_child();\n  $net2->warn(\"Not a tree-child phylogenetic network\")\n    unless $net2->is_tree_child();\n  $net1->warn(\"Not a time-consistent network\")\n    unless $net1->is_time_consistent();\n  $net2->warn(\"Not a time-consistent network\")\n    unless $net2->is_time_consistent();\n  $net1->compute_tripartitions() unless defined $net1->{tripartitions};\n  $net2->compute_tripartitions() unless defined $net2->{tripartitions};\n  my @edges1=$net1->{graph}->edges();\n  my @edges2=$net2->{graph}->edges();\n  my ($FN,$FP)=(0,0);\n  foreach my $edge1 (@edges1) {\n    my $matched=0;\n    foreach my $edge2 (@edges2) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FN++;}\n  }\n  foreach my $edge2 (@edges2) {\n    my $matched=0;\n    foreach my $edge1 (@edges1) {\n      if ($net1->{tripartitions}->{$edge1->[1]} eq\n\t  $net2->{tripartitions}->{$edge2->[1]}) {\n\t$matched=1;\n\tlast;\n      }\n    }\n    if (! $matched) {$FP++;}\n  }\n  return ($FN/(scalar @edges1)+$FP/(scalar @edges2))/2;\n}\n\n# Time-consistency\n\n# to do: add weak time consistency\n\n=head2 is_time_consistent\n\n Title   : is_time_consistent\n Usage   : my $b=$net->is_time_consistent()\n Function: tests if $net is (strong) time-consistent\n Returns : boolean\n Args    : none\n\n\nsub is_time_consistent {\n  my ($self)=@_;\n  $self->compute_temporal_representation()\n    unless exists $self->{has_temporal_representation};\n  return $self->{has_temporal_representation};\n}\n\n=head2 temporal_representation\n\n Title   : temporal_representation\n Usage   : my %time=$net->temporal_representation()\n Function: returns a hash containing a temporal representation of $net, or 0\n           if $net is not time-consistent\n Returns : hash\n Args    : none\n\n\nsub temporal_representation {\n  my ($self)=@_;\n  if ($self->is_time_consistent) {\n    return %{$self->{temporal_representation}};\n  }\n  return 0;\n}\n\nsub compute_temporal_representation {\n  my ($self)=@_;\n  my $quotient=Graph::Directed->new();\n  my $classes=find_classes($self);\n  my %repr;\n  map {$repr{$_}=$classes->{$_}[0]} $self->nodes();\n  foreach my $e ($self->tree_edges()) {\n    $quotient->add_edge($repr{$e->[0]},$repr{$e->[1]});\n  }\n  my %temp;\n  my $depth=0;\n  while ($quotient->vertices()) {\n    if (my @svs=$quotient->predecessorless_vertices()) {\n      foreach my $sv (@svs) {\n\t$temp{$sv}=$depth;\n      }\n      $quotient->delete_vertices(@svs);\n    } else {\n      return 0;\n    }\n    $depth++;\n  }\n  foreach my $node (@{$self->{nodes}}) {\n    $temp{$node}=$temp{$repr{$node}}\n  }\n  $self->{temporal_representation}=\\%temp;\n  $self->{has_temporal_representation}=1;\n}\n\nsub find_classes {\n  my ($self)=@_;\n  my $classes={};\n  map {$classes->{$_}=[$_]} $self->nodes();\n  foreach my $e ($self->hybrid_edges()) {\n    $classes=join_classes($classes,$e->[0],$e->[1]);\n  }\n  return $classes;\n}\n\nsub join_classes {\n  my ($classes,$u,$v)=@_;\n  my @clu=@{$classes->{$u}};\n  my @clv=@{$classes->{$v}};\n  my @cljoin=(@clu,@clv);\n  map {$classes->{$_}=\\@cljoin} @cljoin;\n  return $classes;\n}\n\n# alignment\n\n=head2 contract_elementary\n\n\n Title   : contract_elementary\n Usage   : my ($contracted,$blocks)=$net->contract_elementary();\n Function: Returns the network $contracted, obtained by contracting elementary\n           paths of $net into edges. The reference $blocks points to a hash\n           where, for each node of $contracted, gives the corresponding nodes\n           of $net that have been deleted.\n Returns : Bio::PhyloNetwork,reference to hash\n Args    : none\n\n\nsub contract_elementary {\n  my ($self)=@_;\n\n  my $contracted=$self->graph->copy();\n  my @nodes=$self->nodes();\n  my $mus=$self->{mudata};\n  my $hs=$self->{h};\n  my %blocks;\n  foreach my $u (@nodes) {\n    $blocks{$u}=[$u];\n  }\n  my @elementary=grep { $contracted->out_degree($_) == 1} $self->tree_nodes();\n  @elementary=sort {$mus->{$b} <=> $mus->{$a} ||\n\t\t\t $hs->{$b} <=> $hs->{$a}} @elementary;\n  foreach my $elem (@elementary) {\n    my @children=$contracted->successors($elem);\n    my $child=$children[0];\n    if ($contracted->in_degree($elem) == 1) {\n      my @parents=$contracted->predecessors($elem);\n      my $parent=$parents[0];\n      $contracted->add_edge($parent,$child);\n    }\n    $contracted->delete_vertex($elem);\n    my @blch=@{$blocks{$child}};\n    my @blem=@{$blocks{$elem}};\n    $blocks{$child}=[@blem,@blch];\n    delete $blocks{$elem};\n  }\n  my $contr=Bio::PhyloNetwork->new(-graph => $contracted);\n  return $contr,\\%blocks;\n}\n\n=head2 optimal_alignment\n\n Title   : optimal_alignment\n Usage   : my ($weight,$alignment,$wgts)=$net->optimal_alignment($net2)\n Function: returns the total weight of an optimal alignment,\n           the alignment itself, and partial weights\n           between the networks $net1 and $net2 on the same set of leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,reference to hash,reference to hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment {\n  my ($net1,$net2,%params)=@_;\n\n  my ($net1cont,$blocks1)=contract_elementary($net1);\n  my ($net2cont,$blocks2)=contract_elementary($net2);\n  my ($wc,$alignc,$weightc)=\n    optimal_alignment_noelementary($net1cont,$net2cont,%params);\n  my %alignment=();\n  my $totalweigth=0;\n  my %weigths=();\n  foreach my $u1 (keys %$alignc) {\n    my $u2=$alignc->{$u1};\n    my @block1=@{$blocks1->{$u1}};\n    my @block2=@{$blocks2->{$u2}};\n    while (@block1 && @block2) {\n      my $u1dc=pop @block1;\n      my $u2dc=pop @block2;\n      $alignment{$u1dc}=$u2dc;\n      $weigths{$u1dc}=$weightc->{$u1};\n      $totalweigth+=$weigths{$u1dc};\n    }\n  }\n  return $totalweigth,\\%alignment,\\%weigths;\n}\n\nsub optimal_alignment_noelementary {\n  my ($net1,$net2,%params)=@_;\n\n  my $comp = Array::Compare->new;\n  $net1->throw(\"Cannot align phylogenetic networks on different set of leaves\")\n    unless $comp->compare($net1->{leaves},$net2->{leaves});\n  my $distance;\n  if ((defined $params{-metric})and ($params{-metric} eq 'Hamming')) {\n    $distance='Hamming';\n  } else {\n    $distance='Manhattan';\n  }\n  my $numleaves=$net1->{numleaves};\n  my @nodes1=$net1->internal_nodes();\n  my @nodes2=$net2->internal_nodes();\n  my $numnodes1=@nodes1;\n  my $numnodes2=@nodes2;\n  my @matrix=();\n  for (my $i=0;$i<$numnodes1;$i++) {\n    my @row=();\n    for (my $j=0;$j<$numnodes2;$j++) {\n      push @row,weight($net1,$nodes1[$i],$net2,$nodes2[$j],$distance);\n    }\n    push @matrix,\\@row;\n  }\n  my @alignment=();\n  assign(\\@matrix,\\@alignment);\n  my %alignmenthash;\n  my %weighthash;\n  my $totalw=0;\n  foreach my $leaf (@{$net1->{leaves}}) {\n    $alignmenthash{$leaf}=$leaf;\n    $weighthash{$leaf}=0;\n  }\n  for (my $i=0;$i<$numnodes1;$i++) {\n    if (defined $nodes2[$alignment[$i]]) {\n      $alignmenthash{$nodes1[$i]}=$nodes2[$alignment[$i]];\n      $weighthash{$nodes1[$i]}=$matrix[$i][$alignment[$i]];\n      $totalw += $matrix[$i][$alignment[$i]];\n    }\n  }\n  return $totalw,\\%alignmenthash,\\%weighthash;\n }\n\n=head2 optimal_alignment_generalized\n\n Title   : optimal_alignment_generalized\n Usage   : my ($weight,%alignment)=$net->optimal_alignment_generalized($net2)\n Function: returns the wieght of an optimal alignment, and the alignment itself,\n           between the topological restriction of the networks $net1 and $net2\n           on the set of common leaves.\n           An optional argument allows to use the Manhattan (default) or the\n           Hamming distance between mu-vectors.\n Returns : scalar,hash\n Args    : Bio::PhyloNetwork,\n           -metric => string (optional)\n\nSupported strings for the -metric parameter are 'Manhattan' or 'Hamming'.\n\n\nsub optimal_alignment_generalized {\n  my ($net1,$net2,%params)=@_;\n  my ($netr1,$netr2)=$net1->topological_restriction($net2);\n  return $netr1->optimal_alignment($netr2,%params);\n}\n\nsub weight {\n  my ($net1,$v1,$net2,$v2,$distance)=@_;\n  my $w;\n  if (! defined $distance) {\n    $distance='Manhattan';\n  }\n  if ($distance eq 'Hamming') {\n    $w=$net1->{mudata}->{$v1}->hamming($net2->{mudata}->{$v2});\n  } else {\n    $w=$net1->{mudata}->{$v1}->manhattan($net2->{mudata}->{$v2});\n  }\n  if (($net1->is_tree_node($v1) && $net2->is_hybrid_node($v2)) ||\n      ($net2->is_tree_node($v2) && $net1->is_hybrid_node($v1))\n     )\n    {\n      $w +=1/(2*$net1->{numleaves});\n    }\n  return $w;\n}\n\n\n=head2 topological_restriction\n\n Title   : topological_restriction\n Usage   : my ($netr1,$netr2)=$net1->topological_restriction($net2)\n Function: returns the topological restriction of $net1 and $net2 on its\n           common set of leaves\n Returns : Bio::PhyloNetwork, Bio::PhyloNetwork\n Args    : Bio::PhyloNetwork\n\n\nsub topological_restriction {\n  my ($net1,$net2)=@_;\n\n  my @leaves1=$net1->leaves();\n  my @leaves2=$net2->leaves();\n  my $numleaves1=scalar @leaves1;\n  my $numleaves2=scalar @leaves2;\n  my %position1;\n  for (my $i=0; $i<$numleaves1; $i++) {\n    $position1{$leaves1[$i]}=$i;\n  }\n  my %position2;\n  my @commonleaves=();\n  for (my $j=0; $j<$numleaves2; $j++) {\n    if (defined $position1{$leaves2[$j]}) {\n      push @commonleaves,$leaves2[$j];\n      $position2{$leaves2[$j]}=$j;\n    }\n  }\n  my $graphred1=$net1->{graph}->copy();\n  my $graphred2=$net2->{graph}->copy();\n OUTER1:\n  foreach my $u ($graphred1->vertices()) {\n    my $mu=$net1->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position1{$leaf}]>0) {\n\tnext OUTER1;\n      }\n    }\n    $graphred1->delete_vertex($u);\n  }\n OUTER2:\n  foreach my $u ($graphred2->vertices()) {\n    my $mu=$net2->mudata_node($u);\n    foreach my $leaf (@commonleaves) {\n      if ($mu->[$position2{$leaf}]>0) {\n\tnext OUTER2;\n      }\n    }\n    $graphred2->delete_vertex($u);\n  }\n  my $netr1=Bio::PhyloNetwork->new(-graph => $graphred1);\n  my $netr2=Bio::PhyloNetwork->new(-graph => $graphred2);\n  return ($netr1,$netr2);\n}\n\n# Functions for eNewick representation\n\n=head2 eNewick\n\n Title   : eNewick\n Usage   : my $str=$net->eNewick()\n Function: returns the eNewick representation of $net without labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    $str.=$self->{labels}->{$node};\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n=head2 eNewick_full\n\n Title   : eNewick_full\n Usage   : my $str=$net->eNewick_full()\n Function: returns the eNewick representation of $net labeling\n           internal tree nodes\n Returns : string\n Args    : none\n\n\nsub eNewick_full {\n  my ($self)=@_;\n  my $str=\"\";\n  my $seen={};\n  foreach my $root ($self->roots()) {\n    $str=$str.$self->eNewick_full_aux($root,$seen,undef).\"; \";\n  }\n  return $str;\n}\n\nsub eNewick_full_aux {\n  my ($self,$node,$seen,$parent)=@_;\n  my $str='';\n  if ($self->is_leaf($node) ||\n      (defined $seen->{$node}) )\n    {\n      $str=make_label_full($self,$parent,$node);\n    }\n  else {\n    $seen->{$node}=1;\n    my @sons=$self->{graph}->successors($node);\n    $str=\"(\";\n    foreach my $son (@sons) {\n      $str=$str.$self->eNewick_full_aux($son,$seen,$node).\",\";\n    }\n    chop($str);\n    $str.=\")\".make_label_full($self,$parent,$node);\n  }\n  return $str;\n}\n\nsub make_label_full {\n  my ($self,$parent,$node)=@_;\n  my $str='';\n  if ($self->is_hybrid_node($node)) {\n    my $lbl=$self->{labels}->{$node};\n    if ($lbl =~ /#/) {\n      $lbl='';\n    }\n    $str.=$lbl; #$self->{labels}->{$node};\n    $str.='#';\n    if ((defined $parent) &&\n\t($self->graph->has_edge_attribute($parent,$node,'type'))) {\n      $str.=$self->graph->get_edge_attribute($parent,$node,'type');\n    }\n    $str.=substr $node,1;\n  } else {\n    if ((defined $self->{labels}->{$node})&&($self->{labels}->{$node} ne '')) {\n      $str.=$self->{labels}->{$node};\n    }\n    else {\n      $str.=$node;\n    }\n  }\n  if ((defined $parent) &&\n      ($self->graph->has_edge_weight($parent,$node))) {\n    $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n  }\n  return $str;\n}\n\n# sub eNewick_full {\n#   my ($self)=@_;\n#   my $str=\"\";\n#   my $seen={};\n#   foreach my $root ($self->roots()) {\n#     $str=$str.$self->eNewick_full_aux($root,$seen,undef).\"; \";\n#   }\n#   return $str;\n# }\n\n# sub eNewick_full_aux {\n#   my ($self,$node,$seen,$parent)=@_;\n#   my $str;\n#   if ($self->is_leaf($node) ||\n#       (defined $seen->{$node}) )\n#     {\n#       if ($self->is_hybrid_node($node)) {\n# \tmy $tag=substr $node,1;\n# \tif ((defined $parent) &&\n# \t    ($self->graph->has_edge_attribute($parent,$node,'type'))) {\n# \t  $str='#'.$self->graph->get_edge_attribute($parent,$node,'type').$tag;\n# \t} else {\n# \t  $str=$node;\n# \t}\n#       } else {\n# \t$str=$node;\n#       }\n#     }\n#   else {\n#     $seen->{$node}=1;\n#     my @sons=$self->{graph}->successors($node);\n#     $str=\"(\";\n#     foreach my $son (@sons) {\n#       $str=$str.$self->eNewick_full_aux($son,$seen,$node).\",\";\n#     }\n#     chop($str);\n#     if ($self->is_hybrid_node($node)) {\n#       my $tag=substr $node,1;\n#       if ((defined $parent) &&\n# \t  ($self->graph->has_edge_attribute($parent,$node,'type'))) {\n# \t$str.=')#'.$self->graph->get_edge_attribute($parent,$node,'type').$tag;\n#       } else {\n# \t$str.=\")$node\";\n#       }\n#     } else {\n#       $str.=\")$node\";\n#     }\n#   }\n#   if ((defined $parent) &&\n#       ($self->graph->has_edge_weight($parent,$node))) {\n#     $str.=\":\".$self->graph->get_edge_weight($parent,$node);\n#   }\n#   return $str;\n# }\n\n\n# displaying data\n\nuse overload '\"\"' => \\&display;\n\n=head2 display\n\n Title   : display\n Usage   : my $str=$net->display()\n Function: returns a string containing all the available information on $net\n Returns : string\n Args    : none"},"detail":"($self)","kind":12,"children":[{"definition":"my","name":"$self","containerName":"display","localvar":"my","kind":13,"line":1762},{"localvar":"my","name":"$str","definition":"my","containerName":"display","line":1763,"kind":13},{"kind":13,"line":1764,"name":"$graph","definition":"my","containerName":"display","localvar":"my"},{"name":"$self","containerName":"display","kind":13,"line":1764},{"containerName":"display","definition":"my","name":"@leaves","localvar":"my","kind":13,"line":1765},{"name":"$self","containerName":"display","line":1765,"kind":13},{"line":1765,"kind":12,"containerName":"display","name":"leaves"},{"localvar":"my","definition":"my","name":"@nodes","containerName":"display","line":1766,"kind":13},{"kind":13,"line":1766,"name":"$self","containerName":"display"}],"line":1761,"name":"display","range":{"end":{"line":1766,"character":9999},"start":{"character":0,"line":1761}}},{"name":"graph","kind":12,"line":1764},{"name":"nodes","kind":12,"line":1766},{"containerName":null,"name":"$str","line":1767,"kind":13},{"name":"$str","containerName":null,"kind":13,"line":1768},{"kind":13,"line":1769,"containerName":null,"name":"$str"},{"kind":13,"line":1770,"containerName":null,"name":"$str"},{"name":"$self","containerName":null,"line":1770,"kind":13},{"containerName":"main::","name":"eNewick","line":1770,"kind":12},{"containerName":null,"name":"$str","kind":13,"line":1771},{"kind":13,"line":1771,"name":"$self","containerName":null},{"line":1771,"kind":12,"containerName":"main::","name":"eNewick_full"},{"line":1772,"kind":13,"containerName":null,"name":"$str"},{"localvar":"my","name":"$node","definition":"my","containerName":null,"line":1773,"kind":13},{"name":"@nodes","containerName":null,"kind":13,"line":1773},{"name":"$str","containerName":null,"kind":13,"line":1774},{"line":1775,"kind":13,"name":"%self","containerName":null},{"line":1775,"kind":12,"name":"labels"},{"name":"%node","containerName":null,"line":1775,"kind":13},{"name":"$str","containerName":null,"line":1776,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":1776},{"kind":12,"line":1776,"name":"labels"},{"containerName":null,"name":"%node","kind":13,"line":1776},{"line":1778,"kind":13,"containerName":null,"name":"$str"},{"kind":13,"line":1780,"containerName":null,"name":"$str"},{"containerName":null,"name":"%self","line":1780,"kind":13},{"containerName":null,"name":"$node","line":1780,"kind":13},{"containerName":null,"name":"%self","line":1780,"kind":13},{"kind":12,"line":1780,"name":"mudata"},{"kind":13,"line":1780,"containerName":null,"name":"$node"},{"kind":13,"line":1782,"name":"%self","containerName":null},{"name":"has_temporal_representation","line":1782,"kind":12},{"kind":13,"line":1783,"containerName":null,"name":"$str"},{"name":"%self","containerName":null,"kind":13,"line":1784},{"kind":12,"line":1784,"name":"has_temporal_representation"},{"localvar":"my","containerName":null,"definition":"my","name":"$node","line":1785,"kind":13},{"name":"@nodes","containerName":null,"kind":13,"line":1785},{"kind":13,"line":1786,"containerName":null,"name":"$str"},{"containerName":null,"name":"$str","kind":13,"line":1787},{"kind":13,"line":1787,"name":"%self","containerName":null},{"name":"temporal_representation","line":1787,"kind":12},{"kind":13,"line":1787,"containerName":null,"name":"%node"},{"containerName":null,"name":"$str","line":1790,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":1793},{"line":1793,"kind":12,"name":"tripartitions"},{"name":"$str","containerName":null,"kind":13,"line":1794},{"containerName":null,"name":"$node","definition":"my","localvar":"my","kind":13,"line":1795},{"line":1795,"kind":13,"name":"@nodes","containerName":null},{"containerName":null,"name":"$str","kind":13,"line":1796},{"kind":13,"line":1797,"name":"$str","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":1797},{"name":"tripartitions","line":1797,"kind":12},{"name":"$node","containerName":null,"kind":13,"line":1797},{"containerName":null,"name":"$str","line":1800,"kind":13}]}