{"version":5,"vars":[{"line":139,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"end":{"line":182,"character":9999},"start":{"line":158,"character":0}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment ","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"line":158,"children":[{"kind":13,"line":160,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"name":"@args","containerName":"new","kind":13,"line":160},{"line":162,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"containerName":"new","name":"$class","line":162,"kind":13},{"kind":13,"line":162,"containerName":"new","name":"@args"},{"definition":"my","name":"$name","containerName":"new","localvar":"my","kind":13,"line":164},{"containerName":"new","name":"$description","line":165,"kind":13},{"name":"$species","containerName":"new","line":166,"kind":13},{"line":167,"kind":13,"containerName":"new","name":"$comment"},{"name":"$self","containerName":"new","kind":13,"line":168},{"name":"_rearrange","containerName":"new","line":168,"kind":12},{"containerName":"new","name":"@args","line":171,"kind":13},{"kind":13,"line":173,"containerName":"new","name":"$self"},{"name":"init","containerName":"new","kind":12,"line":173},{"line":175,"kind":13,"containerName":"new","name":"$name"},{"kind":13,"line":175,"containerName":"new","name":"$self"},{"kind":12,"line":175,"name":"name","containerName":"new"},{"containerName":"new","name":"$name","kind":13,"line":175},{"line":176,"kind":13,"containerName":"new","name":"$description"},{"containerName":"new","name":"$self","kind":13,"line":176},{"containerName":"new","name":"description","kind":12,"line":176},{"kind":13,"line":176,"containerName":"new","name":"$description"},{"name":"$species","containerName":"new","kind":13,"line":177},{"kind":13,"line":177,"containerName":"new","name":"$self"},{"kind":12,"line":177,"containerName":"new","name":"species"},{"line":177,"kind":13,"containerName":"new","name":"$species"},{"kind":13,"line":178,"containerName":"new","name":"$comment"},{"kind":13,"line":178,"containerName":"new","name":"$self"},{"kind":12,"line":178,"containerName":"new","name":"comment"},{"kind":13,"line":178,"name":"$comment","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":180}]},{"kind":12,"line":162,"containerName":"new","name":"SUPER"},{"kind":12,"line":195,"children":[{"line":197,"kind":13,"localvar":"my","containerName":"init","definition":"my","name":"$self"},{"name":"$self","containerName":"init","line":200,"kind":13},{"line":200,"kind":12,"containerName":"init","name":"name"},{"kind":13,"line":201,"name":"$self","containerName":"init"},{"kind":12,"line":201,"name":"description","containerName":"init"},{"kind":13,"line":202,"name":"$species","definition":"my","containerName":"init","localvar":"my"},{"kind":12,"line":202,"name":"new","containerName":"init"},{"name":"$species","containerName":"init","line":203,"kind":13},{"name":"classification","containerName":"init","kind":12,"line":203},{"kind":13,"line":204,"name":"$self","containerName":"init"},{"name":"species","containerName":"init","kind":12,"line":204},{"kind":13,"line":204,"name":"$species","containerName":"init"},{"kind":13,"line":205,"containerName":"init","name":"$self"},{"line":205,"kind":12,"name":"comment","containerName":"init"},{"containerName":"init","name":"$self","line":206,"kind":13},{"line":206,"kind":12,"name":"remove_Correlates","containerName":"init"},{"kind":13,"line":207,"name":"$self","containerName":"init"},{"name":"remove_References","containerName":"init","kind":12,"line":207},{"line":208,"kind":13,"containerName":"init","name":"$self"},{"name":"remove_CytoPositions","containerName":"init","kind":12,"line":208},{"kind":13,"line":209,"containerName":"init","name":"$self"},{"line":209,"kind":12,"name":"remove_gene_symbols","containerName":"init"},{"kind":13,"line":210,"containerName":"init","name":"$self"},{"containerName":"init","name":"remove_Genotypes","line":210,"kind":12},{"line":211,"kind":13,"name":"$self","containerName":"init"},{"containerName":"init","name":"remove_DBLinks","kind":12,"line":211},{"name":"$self","containerName":"init","kind":13,"line":212},{"line":212,"kind":12,"name":"remove_keywords","containerName":"init"},{"line":213,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","name":"remove_Variants","kind":12,"line":213},{"name":"$self","containerName":"init","kind":13,"line":214},{"containerName":"init","name":"remove_Measures","line":214,"kind":12}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :","label":"init($self)"},"name":"init","range":{"end":{"character":9999,"line":216},"start":{"line":195,"character":0}}},{"kind":12,"line":202,"name":"Bio","containerName":"Species"},{"range":{"end":{"character":9999,"line":240},"start":{"line":231,"character":0}},"name":"name","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"name($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"containerName":"name","definition":"my","name":"$self","localvar":"my","kind":13,"line":232},{"name":"$value","containerName":"name","kind":13,"line":232},{"containerName":"name","name":"$value","line":234,"kind":13},{"containerName":"name","name":"$self","line":235,"kind":13},{"kind":13,"line":235,"containerName":"name","name":"$value"},{"name":"$self","containerName":"name","line":238,"kind":13}],"line":231,"kind":12},{"containerName":"main::","name":"description","definition":"sub","range":{"start":{"line":255,"character":0},"end":{"character":9999,"line":259}},"kind":12,"line":255,"children":[{"containerName":"description","definition":"my","name":"$self","localvar":"my","kind":13,"line":256},{"name":"$self","containerName":"description","kind":13,"line":257},{"containerName":"description","name":"$self","line":258,"kind":13}]},{"name":"species","range":{"start":{"character":0,"line":273},"end":{"character":9999,"line":283}},"kind":12,"children":[{"line":274,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"species"},{"containerName":"species","name":"$value","kind":13,"line":274},{"kind":13,"line":276,"containerName":"species","name":"$value"},{"name":"$self","containerName":"species","line":277,"kind":13},{"containerName":"species","name":"_check_ref_type","kind":12,"line":277},{"line":277,"kind":13,"name":"$value","containerName":"species"},{"line":278,"kind":13,"name":"$self","containerName":"species"},{"line":278,"kind":13,"name":"$value","containerName":"species"},{"containerName":"species","name":"$self","line":281,"kind":13}],"line":273,"definition":"sub","containerName":"main::","signature":{"label":"species($self,$value)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"line":297,"children":[{"line":298,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"comment"},{"kind":13,"line":299,"name":"$self","containerName":"comment"},{"kind":13,"line":300,"name":"$self","containerName":"comment"}],"kind":12,"range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":301}},"containerName":"main::","name":"comment","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :","label":"each_gene_symbol($self)"},"kind":12,"line":315,"children":[{"kind":13,"line":316,"name":"$self","definition":"my","containerName":"each_gene_symbol","localvar":"my"},{"kind":13,"line":318,"name":"$self","containerName":"each_gene_symbol"}],"name":"each_gene_symbol","range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":315}}},{"containerName":null,"name":"%self","kind":13,"line":318},{"name":"add_gene_symbols","range":{"start":{"character":0,"line":336},"end":{"character":9999,"line":341}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"add_gene_symbols","localvar":"my","kind":13,"line":337},{"name":"@values","containerName":"add_gene_symbols","kind":13,"line":337},{"name":"@values","containerName":"add_gene_symbols","kind":13,"line":339},{"line":341,"kind":13,"name":"$self","containerName":"add_gene_symbols"}],"line":336,"definition":"sub","containerName":"main::","signature":{"label":"add_gene_symbols($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"detail":"($self,@values)"},{"containerName":null,"name":"@values","kind":13,"line":341},{"line":356,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"remove_gene_symbols","line":357,"kind":13},{"name":"@a","definition":"my","containerName":"remove_gene_symbols","localvar":"my","kind":13,"line":359},{"line":359,"kind":13,"containerName":"remove_gene_symbols","name":"$self"},{"name":"each_gene_symbol","containerName":"remove_gene_symbols","line":359,"kind":12},{"name":"$self","containerName":"remove_gene_symbols","line":360,"kind":13},{"kind":13,"line":361,"name":"@a","containerName":"remove_gene_symbols"}],"kind":12,"detail":"($self)","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_gene_symbols($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":356},"end":{"line":363,"character":9999}},"name":"remove_gene_symbols"},{"kind":12,"children":[{"line":384,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_Variant"},{"name":"$self","containerName":"each_Variant","line":386,"kind":13}],"line":383,"definition":"sub","containerName":"main::","signature":{"label":"each_Variant($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :"},"detail":"($self)","name":"each_Variant","range":{"end":{"line":386,"character":9999},"start":{"line":383,"character":0}}},{"containerName":null,"name":"%self","line":386,"kind":13},{"range":{"end":{"line":412,"character":9999},"start":{"line":403,"character":0}},"name":"add_Variants","detail":"($self,@values)","signature":{"label":"add_Variants($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"containerName":"main::","definition":"sub","line":403,"children":[{"containerName":"add_Variants","name":"$self","definition":"my","localvar":"my","kind":13,"line":404},{"name":"@values","containerName":"add_Variants","line":404,"kind":13},{"name":"@values","containerName":"add_Variants","kind":13,"line":406},{"localvar":"my","name":"$value","definition":"my","containerName":"add_Variants","line":408,"kind":13},{"line":408,"kind":13,"containerName":"add_Variants","name":"@values"},{"containerName":"add_Variants","name":"$self","line":409,"kind":13},{"containerName":"add_Variants","name":"_check_ref_type","line":409,"kind":12},{"containerName":"add_Variants","name":"$value","kind":13,"line":409},{"kind":13,"line":412,"name":"$self","containerName":"add_Variants"}],"kind":12},{"containerName":null,"name":"@values","line":412,"kind":13},{"name":"remove_Variants","range":{"start":{"line":428,"character":0},"end":{"line":435,"character":9999}},"kind":12,"children":[{"definition":"my","name":"$self","containerName":"remove_Variants","localvar":"my","kind":13,"line":429},{"line":431,"kind":13,"localvar":"my","name":"@a","definition":"my","containerName":"remove_Variants"},{"line":431,"kind":13,"name":"$self","containerName":"remove_Variants"},{"containerName":"remove_Variants","name":"each_Variant","kind":12,"line":431},{"line":432,"kind":13,"name":"$self","containerName":"remove_Variants"},{"name":"@a","containerName":"remove_Variants","line":433,"kind":13}],"line":428,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_Variants($self)"},"detail":"($self)"},{"name":"each_Reference","range":{"start":{"character":0,"line":451},"end":{"line":454,"character":9999}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"each_Reference","line":452,"kind":13},{"containerName":"each_Reference","name":"$self","kind":13,"line":454}],"line":451,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Reference($self)"},"detail":"($self)"},{"kind":13,"line":454,"containerName":null,"name":"%self"},{"name":"add_References","range":{"end":{"character":9999,"line":481},"start":{"line":472,"character":0}},"kind":12,"line":472,"children":[{"kind":13,"line":473,"definition":"my","name":"$self","containerName":"add_References","localvar":"my"},{"containerName":"add_References","name":"@values","kind":13,"line":473},{"line":475,"kind":13,"name":"@values","containerName":"add_References"},{"line":477,"kind":13,"localvar":"my","definition":"my","name":"$value","containerName":"add_References"},{"containerName":"add_References","name":"@values","line":477,"kind":13},{"kind":13,"line":478,"containerName":"add_References","name":"$self"},{"containerName":"add_References","name":"_check_ref_type","line":478,"kind":12},{"name":"$value","containerName":"add_References","line":478,"kind":13},{"kind":13,"line":481,"containerName":"add_References","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,@values)","signature":{"label":"add_References($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).","parameters":[{"label":"$self"},{"label":"@values"}]}},{"line":481,"kind":13,"name":"@values","containerName":null},{"range":{"start":{"line":497,"character":0},"end":{"line":504,"character":9999}},"name":"remove_References","line":497,"children":[{"line":498,"kind":13,"localvar":"my","containerName":"remove_References","definition":"my","name":"$self"},{"name":"@a","definition":"my","containerName":"remove_References","localvar":"my","kind":13,"line":500},{"name":"$self","containerName":"remove_References","line":500,"kind":13},{"kind":12,"line":500,"containerName":"remove_References","name":"each_Reference"},{"name":"$self","containerName":"remove_References","line":501,"kind":13},{"line":502,"kind":13,"containerName":"remove_References","name":"@a"}],"kind":12,"detail":"($self)","signature":{"label":"remove_References($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"each_CytoPosition($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :"},"kind":12,"line":520,"children":[{"kind":13,"line":521,"definition":"my","name":"$self","containerName":"each_CytoPosition","localvar":"my"},{"line":523,"kind":13,"name":"$self","containerName":"each_CytoPosition"}],"name":"each_CytoPosition","range":{"start":{"line":520,"character":0},"end":{"line":523,"character":9999}}},{"line":523,"kind":13,"containerName":null,"name":"%self"},{"name":"add_CytoPositions","range":{"end":{"line":550,"character":9999},"start":{"character":0,"line":541}},"containerName":"main::","definition":"sub","detail":"($self,@values)","signature":{"label":"add_CytoPositions($self,@values)","parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s)."},"kind":12,"line":541,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_CytoPositions","line":542,"kind":13},{"name":"@values","containerName":"add_CytoPositions","kind":13,"line":542},{"name":"@values","containerName":"add_CytoPositions","kind":13,"line":544},{"line":546,"kind":13,"localvar":"my","definition":"my","name":"$value","containerName":"add_CytoPositions"},{"line":546,"kind":13,"name":"@values","containerName":"add_CytoPositions"},{"line":547,"kind":13,"name":"$self","containerName":"add_CytoPositions"},{"containerName":"add_CytoPositions","name":"_check_ref_type","line":547,"kind":12},{"containerName":"add_CytoPositions","name":"$value","kind":13,"line":547},{"kind":13,"line":550,"name":"$self","containerName":"add_CytoPositions"}]},{"line":550,"kind":13,"name":"@values","containerName":null},{"definition":"sub","containerName":"main::","signature":{"label":"remove_CytoPositions($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"remove_CytoPositions","line":567,"kind":13},{"containerName":"remove_CytoPositions","definition":"my","name":"@a","localvar":"my","kind":13,"line":569},{"containerName":"remove_CytoPositions","name":"$self","kind":13,"line":569},{"kind":12,"line":569,"containerName":"remove_CytoPositions","name":"each_CytoPosition"},{"line":570,"kind":13,"containerName":"remove_CytoPositions","name":"$self"},{"kind":13,"line":571,"name":"@a","containerName":"remove_CytoPositions"}],"line":566,"name":"remove_CytoPositions","range":{"start":{"character":0,"line":566},"end":{"character":9999,"line":573}}},{"definition":"sub","containerName":"main::","signature":{"label":"each_Correlate($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"kind":13,"line":593,"definition":"my","name":"$self","containerName":"each_Correlate","localvar":"my"},{"kind":13,"line":595,"containerName":"each_Correlate","name":"$self"}],"line":592,"name":"each_Correlate","range":{"end":{"line":595,"character":9999},"start":{"line":592,"character":0}}},{"line":595,"kind":13,"name":"%self","containerName":null},{"detail":"($self,@values)","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_Correlates($self,@values)"},"containerName":"main::","definition":"sub","line":615,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_Correlates","line":616,"kind":13},{"kind":13,"line":616,"containerName":"add_Correlates","name":"@values"},{"kind":13,"line":618,"containerName":"add_Correlates","name":"@values"},{"definition":"my","name":"$value","containerName":"add_Correlates","localvar":"my","kind":13,"line":620},{"name":"@values","containerName":"add_Correlates","kind":13,"line":620},{"containerName":"add_Correlates","name":"$self","line":621,"kind":13},{"kind":12,"line":621,"name":"_check_ref_type","containerName":"add_Correlates"},{"name":"$value","containerName":"add_Correlates","line":621,"kind":13},{"name":"$self","containerName":"add_Correlates","kind":13,"line":624}],"kind":12,"range":{"end":{"line":624,"character":9999},"start":{"line":615,"character":0}},"name":"add_Correlates"},{"kind":13,"line":624,"containerName":null,"name":"@values"},{"children":[{"name":"$self","definition":"my","containerName":"remove_Correlates","localvar":"my","kind":13,"line":641},{"localvar":"my","name":"@a","definition":"my","containerName":"remove_Correlates","line":643,"kind":13},{"kind":13,"line":643,"name":"$self","containerName":"remove_Correlates"},{"name":"each_Correlate","containerName":"remove_Correlates","kind":12,"line":643},{"kind":13,"line":644,"name":"$self","containerName":"remove_Correlates"},{"name":"@a","containerName":"remove_Correlates","kind":13,"line":645}],"line":640,"kind":12,"signature":{"label":"remove_Correlates($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":640},"end":{"line":647,"character":9999}},"name":"remove_Correlates"},{"name":"each_Measure","range":{"end":{"line":668,"character":9999},"start":{"line":665,"character":0}},"kind":12,"children":[{"kind":13,"line":666,"containerName":"each_Measure","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"each_Measure","line":668,"kind":13}],"line":665,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","parameters":[{"label":"$self"}],"label":"each_Measure($self)"},"detail":"($self)"},{"kind":13,"line":668,"containerName":null,"name":"%self"},{"range":{"start":{"character":0,"line":686},"end":{"line":695,"character":9999}},"name":"add_Measures","children":[{"definition":"my","name":"$self","containerName":"add_Measures","localvar":"my","kind":13,"line":687},{"containerName":"add_Measures","name":"@values","kind":13,"line":687},{"containerName":"add_Measures","name":"@values","line":689,"kind":13},{"name":"$value","definition":"my","containerName":"add_Measures","localvar":"my","kind":13,"line":691},{"kind":13,"line":691,"containerName":"add_Measures","name":"@values"},{"kind":13,"line":692,"name":"$self","containerName":"add_Measures"},{"kind":12,"line":692,"containerName":"add_Measures","name":"_check_ref_type"},{"name":"$value","containerName":"add_Measures","kind":13,"line":692},{"kind":13,"line":695,"name":"$self","containerName":"add_Measures"}],"line":686,"kind":12,"signature":{"label":"add_Measures($self,@values)","parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s)."},"detail":"($self,@values)","definition":"sub","containerName":"main::"},{"containerName":null,"name":"@values","line":695,"kind":13},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"remove_Measures($self)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :","parameters":[{"label":"$self"}]},"kind":12,"line":711,"children":[{"line":712,"kind":13,"localvar":"my","containerName":"remove_Measures","name":"$self","definition":"my"},{"containerName":"remove_Measures","definition":"my","name":"@a","localvar":"my","kind":13,"line":714},{"containerName":"remove_Measures","name":"$self","line":714,"kind":13},{"name":"each_Measure","containerName":"remove_Measures","kind":12,"line":714},{"kind":13,"line":715,"containerName":"remove_Measures","name":"$self"},{"kind":13,"line":716,"name":"@a","containerName":"remove_Measures"}],"name":"remove_Measures","range":{"end":{"line":718,"character":9999},"start":{"line":711,"character":0}}},{"signature":{"label":"each_keyword($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"containerName":"each_keyword","definition":"my","name":"$self","localvar":"my","kind":13,"line":735},{"kind":13,"line":737,"name":"$self","containerName":"each_keyword"}],"line":734,"kind":12,"range":{"start":{"line":734,"character":0},"end":{"line":737,"character":9999}},"name":"each_keyword"},{"line":737,"kind":13,"name":"%self","containerName":null},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"add_keywords","line":756,"kind":13},{"kind":13,"line":756,"name":"@values","containerName":"add_keywords"},{"containerName":"add_keywords","name":"@values","line":758,"kind":13},{"name":"$self","containerName":"add_keywords","kind":13,"line":760}],"line":755,"kind":12,"signature":{"label":"add_keywords($self,@values)","parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s)."},"detail":"($self,@values)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":760},"start":{"line":755,"character":0}},"name":"add_keywords"},{"kind":13,"line":760,"containerName":null,"name":"@values"},{"kind":12,"line":776,"children":[{"containerName":"remove_keywords","definition":"my","name":"$self","localvar":"my","kind":13,"line":777},{"name":"@a","definition":"my","containerName":"remove_keywords","localvar":"my","kind":13,"line":779},{"containerName":"remove_keywords","name":"$self","kind":13,"line":779},{"name":"each_keyword","containerName":"remove_keywords","line":779,"kind":12},{"line":780,"kind":13,"name":"$self","containerName":"remove_keywords"},{"line":781,"kind":13,"name":"@a","containerName":"remove_keywords"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"remove_keywords($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :"},"name":"remove_keywords","range":{"start":{"line":776,"character":0},"end":{"line":783,"character":9999}}},{"children":[{"kind":13,"line":800,"containerName":"each_DBLink","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":802,"containerName":"each_DBLink","name":"$self"}],"line":799,"kind":12,"signature":{"label":"each_DBLink($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":799},"end":{"character":9999,"line":802}},"name":"each_DBLink"},{"kind":13,"line":802,"containerName":null,"name":"%self"},{"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_DBLinks","line":821,"kind":13},{"containerName":"add_DBLinks","name":"@values","kind":13,"line":821},{"containerName":"add_DBLinks","name":"@values","kind":13,"line":823},{"line":825,"kind":13,"localvar":"my","name":"$value","definition":"my","containerName":"add_DBLinks"},{"line":825,"kind":13,"containerName":"add_DBLinks","name":"@values"},{"line":826,"kind":13,"name":"$self","containerName":"add_DBLinks"},{"name":"_check_ref_type","containerName":"add_DBLinks","kind":12,"line":826},{"line":826,"kind":13,"name":"$value","containerName":"add_DBLinks"},{"kind":13,"line":829,"containerName":"add_DBLinks","name":"$self"}],"line":820,"definition":"sub","containerName":"main::","signature":{"label":"add_DBLinks($self,@values)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).","parameters":[{"label":"$self"},{"label":"@values"}]},"detail":"($self,@values)","name":"add_DBLinks","range":{"end":{"line":829,"character":9999},"start":{"character":0,"line":820}}},{"kind":13,"line":829,"name":"@values","containerName":null},{"name":"remove_DBLinks","range":{"end":{"line":852,"character":9999},"start":{"line":845,"character":0}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :","label":"remove_DBLinks($self)"},"kind":12,"line":845,"children":[{"kind":13,"line":846,"containerName":"remove_DBLinks","name":"$self","definition":"my","localvar":"my"},{"line":848,"kind":13,"localvar":"my","definition":"my","name":"@a","containerName":"remove_DBLinks"},{"name":"$self","containerName":"remove_DBLinks","kind":13,"line":848},{"line":848,"kind":12,"name":"each_DBLink","containerName":"remove_DBLinks"},{"name":"$self","containerName":"remove_DBLinks","kind":13,"line":849},{"containerName":"remove_DBLinks","name":"@a","kind":13,"line":850}]},{"name":"each_Genotype","range":{"start":{"character":0,"line":871},"end":{"line":874,"character":9999}},"kind":12,"line":871,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"each_Genotype","line":872,"kind":13},{"line":874,"kind":13,"name":"$self","containerName":"each_Genotype"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :","label":"each_Genotype($self)"}},{"line":874,"kind":13,"containerName":null,"name":"%self"},{"name":"add_Genotypes","range":{"start":{"line":892,"character":0},"end":{"character":9999,"line":901}},"kind":12,"children":[{"kind":13,"line":893,"containerName":"add_Genotypes","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":893,"name":"@values","containerName":"add_Genotypes"},{"name":"@values","containerName":"add_Genotypes","kind":13,"line":895},{"containerName":"add_Genotypes","name":"$self","line":901,"kind":13}],"line":892,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".","label":"add_Genotypes($self,@values)"},"detail":"($self,@values)"},{"line":901,"kind":13,"name":"@values","containerName":null},{"name":"remove_Genotypes","range":{"start":{"line":917,"character":0},"end":{"line":924,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    #foreach my $value ( @values ) {  \n    #    $self->_check_ref_type( $value, \"Bio::GenotypeI\" );\n    #}\n        \n    push( @{ $self->{ \"_genotypes\" } }, @values );\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :","parameters":[{"label":"$self"}],"label":"remove_Genotypes($self)"},"kind":12,"line":917,"children":[{"kind":13,"line":918,"definition":"my","name":"$self","containerName":"remove_Genotypes","localvar":"my"},{"containerName":"remove_Genotypes","definition":"my","name":"@a","localvar":"my","kind":13,"line":920},{"containerName":"remove_Genotypes","name":"$self","kind":13,"line":920},{"line":920,"kind":12,"containerName":"remove_Genotypes","name":"each_Genotype"},{"name":"$self","containerName":"remove_Genotypes","kind":13,"line":921},{"line":922,"kind":13,"name":"@a","containerName":"remove_Genotypes"}]},{"signature":{"label":"_check_ref_type($self,$value,$expected_class)","documentation":"1;\n# $Id: Phenotype.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Phenotype\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Phenotype - A class for modeling phenotypes\n\n=head1 SYNOPSIS\n\n  #get Bio::Phenotype::PhenotypeI somehow\n\n  print $phenotype->name(), \"\\n\";\n  print $phenotype->description(), \"\\n\";\n\n  my @keywords = ( \"achondroplasia\", \"dwarfism\" );\n  $phenotype->add_keywords( @keywords ); \n  foreach my $keyword ( $phenotype->each_keyword() ) {\n       print $keyword, \"\\n\";\n  }\n  $phenotype->remove_keywords();\n\n\n  foreach my $gene_symbol ( $phenotype->each_gene_symbol() ) {\n       print $gene_symbol, \"\\n\";\n  }\n\n  foreach my $corr ( $phenotype->each_Correlate() ) {\n       # Do something with $corr\n  }\n\n  foreach my $var ( $phenotype->each_Variant() ) {\n       # Do something with $var (mutation)\n  }\n\n  foreach my $measure ( $phenotype->each_Measure() ) {\n       # Do something with $measure\n  }\n\n\n=head1 DESCRIPTION\n\nThis superclass implements common methods for classes modelling phenotypes.\nBio::Phenotype::OMIM::OMIMentry is an example of an instantiable phenotype\nclass (the design of this interface was partially guided by the need\nto model OMIM entries).\nPlease note. This class provides methods to associate mutations\n(methods \"each_Variant\", ...) and genotypes (methods \"each_Genotype\", ...) \nwith phenotypes. Yet, these aspects might need some future enhancements,\nespecially since there is no \"genotype\" class yet.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::Phenotype;\nuse strict;\n\nuse Bio::Species;\nuse Bio::Variation::VariantI;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::Reference;\nuse Bio::Phenotype::Measure;\nuse Bio::Phenotype::Correlate;\nuse Bio::Map::CytoPosition;\nuse Bio::Range;\n\n\nuse base qw(Bio::Root::Root Bio::Phenotype::PhenotypeI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::Phenotype->new( -name         => \"XY\",\n                                                  -description  => \"This is ...\" );\n Function: Creates a new Phenotype object.\n Returns : A new Phenotype object.\n Args    : -name                           => the name\n           -description                    => the description of this phenotype\n           -species                        => ref to the the species\n           -comment                        => a comment \n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n\n    my ( $name,\n         $description,\n         $species,\n         $comment )\n    = $self->_rearrange( [ qw( NAME\n                               DESCRIPTION\n                               SPECIES \n                               COMMENT ) ], @args );\n\n    $self->init(); \n\n    $name                           && $self->name( $name );\n    $description                    && $self->description( $description );\n    $species                        && $self->species( $species );\n    $comment                        && $self->comment( $comment );\n\n    return $self;\n\n} # new\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n\n    $self->name( \"\" );\n    $self->description( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->comment( \"\" );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n\n} # init\n\n\n=head2 name\n\n Title   : name\n Usage   : $obj->name( \"r1\" );\n           or\n           print $obj->name();\n Function: Set/get for the name or id of this phenotype.\n Returns : A name or id [scalar].\n Args    : A name or id [scalar] (optional).\n\n\nsub name {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_name\" } = $value;\n    }\n\n    return $self->{ \"_name\" };\n\n} # name\n\n\n=head2 description\n\n Title   : description\n Usage   : $obj->description( \"This is ...\" );\n           or\n           print $obj->description();\n Function: Set/get for the description of this phenotype.\n Returns : A description [scalar].\n Args    : A description [scalar] (optional).\n\n\nsub description {\n    my $self = shift;\n    return $self->{ \"_description\" } = shift if(@_);\n    return $self->{ \"_description\" };\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species( $species );\n           or\n           $species = $obj->species();\n Function: Set/get for the species of this phenotype.\n Returns : A species [Bio::Species].\n Args    : A species [Bio::Species] (optional).\n\n\nsub species {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_check_ref_type( $value, \"Bio::Species\" );\n        $self->{ \"_species\" } = $value;\n    }\n\n    return $self->{ \"_species\" };\n\n} # species\n\n=head2 comment\n\n Title   : comment\n Usage   : $obj->comment( \"putative\" );\n           or\n           print $obj->comment();\n Function: Set/get for a comment about this phenotype.\n Returns : A comment [scalar].\n Args    : A comment [scalar] (optional).\n\n\nsub comment {\n    my $self = shift;\n    return $self->{ \"_comment\" } = shift if(@_);\n    return $self->{ \"_comment\" };\n} # comment\n\n\n=head2 each_gene_symbol\n\n Title   : each_gene_symbol()\n Usage   : @gs = $obj->each_gene_symbol();\n Function: Returns a list of gene symbols [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_gene_symbol {\n    my ( $self ) = @_;\n\n    return @{$self->{\"_gene_symbols\"}} if exists($self->{\"_gene_symbols\"});\n    return ();\n} # each_gene_symbol\n\n\n=head2 add_gene_symbols\n\n Title   : add_gene_symbols\n Usage   : $obj->add_gene_symbols( @gs );\n           or\n           $obj->add_gene_symbols( $gs );\n Function: Pushes one or more gene symbols [scalars, most likely Strings]\n           into the list of gene symbols.\n Returns : \n Args    : scalar(s).\n\n\nsub add_gene_symbols {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_gene_symbols\" } }, @values );\n\n} # add_gene_symbols\n\n\n=head2 remove_gene_symbols\n\n Usage   : $obj->remove_gene_symbols();\n Function: Deletes (and returns) the list of gene symbols [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_gene_symbols {\n    my ( $self ) = @_;\n\n    my @a = $self->each_gene_symbol();\n    $self->{ \"_gene_symbols\" } = [];\n    return @a;\n\n} # remove_gene_symbols\n\n\n\n\n=head2 each_Variant\n\n Title   : each_Variant()\n Usage   : @vs = $obj->each_Variant();\n Function: Returns a list of Bio::Variation::VariantI implementing objects\n           associated with this phenotype.\n           This is for representing the actual mutation(s) causing this \n           phenotype.\n           {* The \"variants\" data member and its methods will/might need to be\n           changed/improved in one way or another, CZ 09/06/02 *}\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub each_Variant {\n     my ( $self ) = @_;\n\n     return @{ $self->{ \"_variants\" } } if exists($self->{ \"_variants\" });\n     return ();\n} # each_Variant\n\n\n=head2 add_Variants\n\n Usage   : $obj->add_Variants( @vs );\n           or\n           $obj->add_Variants( $v );\n Function: Pushes one or more Bio::Variation::VariantI implementing objects\n           into the list of Variants.\n Returns : \n Args    : Bio::Variation::VariantI implementing object(s).\n\n\nsub add_Variants {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Variation::VariantI\" );\n    }\n\n    push( @{ $self->{ \"_variants\" } }, @values );\n\n} # add_Variants\n\n\n=head2 remove_Variants\n\n Title   : remove_Variants\n Usage   : $obj->remove_Variants();\n Function: Deletes (and returns) the list of Bio::Variation::VariantI implementing\n           objects associated with this phenotype.\n Returns : A list of Bio::Variation::VariantI implementing objects.\n Args    :\n\n\nsub remove_Variants {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Variant();\n    $self->{ \"_variants\" } = [];\n    return @a;\n\n} # remove_Variants\n\n\n\n\n=head2 each_Reference\n\n Title   : each_Reference()\n Usage   : @refs = $obj->each_Reference();                 \n Function: Returns a list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub each_Reference {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_references\" } } if exists($self->{ \"_references\" });\n    return ();\n} # each_Reference\n\n\n=head2 add_References \n\n Title   : add_References\n Usage   : $obj->add_References( @refs );\n           or\n           $obj->add_References( $ref );                  \n Function: Pushes one or more Bio::Annotation::Reference objects\n           into the list of References.\n Returns : \n Args    : Bio::Annotation::Reference object(s).\n\n\nsub add_References {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::Reference\" );\n    }\n        \n    push( @{ $self->{ \"_references\" } }, @values );\n    \n} # add_References\n\n\n=head2 remove_References\n\n Title   : remove_References()\n Usage   : $obj->remove_References();\n Function: Deletes (and returns) the list of Bio::Annotation::Reference objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::Reference objects.\n Args    :\n\n\nsub remove_References {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_Reference();\n    $self->{ \"_references\" } = [];\n    return @a;\n\n} # remove_References\n\n\n\n\n=head2 each_CytoPosition\n\n Title   : each_CytoPosition()\n Usage   : @cps = $obj->each_CytoPosition();                 \n Function: Returns a list of Bio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub each_CytoPosition {\n    my ( $self ) = @_;\n    \n    return @{$self->{\"_cyto_positions\"}} if exists($self->{\"_cyto_positions\"});\n    return ();\n} # each_CytoPosition\n\n\n=head2 add_CytoPositions\n\n Title   : add_CytoPositions\n Usage   : $obj->add_CytoPositions( @cps );\n           or\n           $obj->add_CytoPositions( $cp );                  \n Function: Pushes one or more Bio::Map::CytoPosition objects\n           into the list of CytoPositions.\n Returns : \n Args    : Bio::Map::CytoPosition object(s).\n\n\nsub add_CytoPositions {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Map::CytoPosition\" );\n    }\n        \n    push( @{ $self->{ \"_cyto_positions\" } }, @values );\n    \n} # add_CytoPositions\n\n\n=head2 remove_CytoPositions\n\n Title   : remove_CytoPositions\n Usage   : $obj->remove_CytoPositions();\n Function: Deletes (and returns) the list o fBio::Map::CytoPosition objects\n           associated with this phenotype.\n Returns : A list of Bio::Map::CytoPosition objects.\n Args    :\n\n\nsub remove_CytoPositions {\n    my ( $self ) = @_;\n     \n    my @a = $self->each_CytoPosition();\n    $self->{ \"_cyto_positions\" } = [];\n    return @a;\n\n} # remove_CytoPositions\n\n\n\n\n=head2 each_Correlate\n\n Title   : each_Correlate()\n Usage   : @corrs = $obj->each_Correlate();                 \n Function: Returns a list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n           (Correlates are correlating phenotypes in different species;\n           inspired by mouse correlates of human phenotypes in the OMIM\n           database.)\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub each_Correlate {\n    my ( $self ) = @_;\n\n    return @{ $self->{ \"_correlates\" } } if exists($self->{ \"_correlates\" });\n    return (); \n} # each_Correlate\n\n\n\n\n=head2 add_Correlates\n\n Title   : add_Correlates\n Usage   : $obj->add_Correlates( @corrs );\n           or\n           $obj->add_Correlates( $corr );                  \n Function: Pushes one or more Bio::Phenotype::Correlate objects\n           into the list of Correlates.\n Returns : \n Args    : Bio::Phenotype::Correlate object(s).\n\n\nsub add_Correlates {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Correlate\" );\n    }\n        \n    push( @{ $self->{ \"_correlates\" } }, @values );\n    \n} # add_Correlates\n\n\n=head2 remove_Correlates\n\n Title   : remove_Correlates\n Usage   : $obj->remove_Correlates();\n Function: Deletes (and returns) the list of Bio::Phenotype::Correlate objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Correlate objects.\n Args    :\n\n\nsub remove_Correlates {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_Correlate();\n    $self->{ \"_correlates\" } = [];\n    return @a;\n\n} # remove_Correlates\n\n\n\n\n=head2 each_Measure\n\n Title   : each_Measure()\n Usage   : @ms = $obj->each_Measure();                 \n Function: Returns a list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n           (Measure is for biochemically defined phenotypes\n           or any other types of measures.)\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub each_Measure {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_measures\" } } if exists($self->{ \"_measures\" });\n    return ();\n} # each_Measure\n\n\n=head2 add_Measures\n\n Title   : add_Measures\n Usage   : $obj->add_Measures( @ms );\n           or\n           $obj->add_Measures( $m );                  \n Function: Pushes one or more Bio::Phenotype::Measure objects\n           into the list of Measures.\n Returns : \n Args    : Bio::Phenotype::Measure object(s).\n\n\nsub add_Measures {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Phenotype::Measure\" );\n    }\n        \n    push( @{ $self->{ \"_measures\" } }, @values );\n    \n} # add_Measures\n\n\n=head2 remove_Measures\n\n Title   : remove_Measures\n Usage   : $obj->remove_Measures();\n Function: Deletes (and returns) the list of Bio::Phenotype::Measure objects\n           associated with this phenotype.\n Returns : A list of Bio::Phenotype::Measure objects.\n Args    :\n\n\nsub remove_Measures {\n    my ( $self ) = @_;\n   \n    my @a = $self->each_Measure();\n    $self->{ \"_measures\" } = [];\n    return @a;\n\n} # remove_Measures\n\n\n\n\n=head2 each_keyword\n\n Title   : each_keyword()\n Usage   : @kws = $obj->each_keyword();                 \n Function: Returns a list of key words [scalars, most likely Strings]\n           associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub each_keyword {\n    my ( $self ) = @_;\n    \n    return @{ $self->{ \"_keywords\" } } if exists($self->{ \"_keywords\" });\n    return ();\n} # each_keyword\n\n\n=head2 add_keywords\n\n Title   : add_keywords\n Usage   : $obj->add_keywords( @kws );\n           or\n           $obj->add_keywords( $kw );                  \n Function: Pushes one or more keywords [scalars, most likely Strings]\n           into the list of key words.\n Returns : \n Args    : scalar(s).\n\n\nsub add_keywords {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    push( @{ $self->{ \"_keywords\" } }, @values );\n    \n} # add_keywords\n\n\n=head2 remove_keywords\n\n Title   : remove_keywords\n Usage   : $obj->remove_keywords();\n Function: Deletes (and returns) the list of key words [scalars,\n           most likely Strings] associated with this phenotype.\n Returns : A list of scalars.\n Args    :\n\n\nsub remove_keywords {\n    my ( $self ) = @_;\n    \n    my @a = $self->each_keyword();\n    $self->{ \"_keywords\" } = [];\n    return @a;\n\n} # remove_keywords\n\n\n\n\n=head2 each_DBLink\n\n Title   : each_DBLink()\n Usage   : @dbls = $obj->each_DBLink();                 \n Function: Returns a list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub each_DBLink {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_db_links\" } } if exists($self->{ \"_db_links\" });\n    return ();   \n}\n\n\n=head2 add_DBLinks\n\n Title   : add_DBLinks\n Usage   : $obj->add_DBLinks( @dbls );\n           or\n           $obj->add_DBLinks( $dbl );                  \n Function: Pushes one or more Bio::Annotation::DBLink objects\n           into the list of DBLinks.\n Returns : \n Args    : Bio::Annotation::DBLink object(s).\n\n\nsub add_DBLinks {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    foreach my $value ( @values ) {  \n        $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n    }\n        \n    push( @{ $self->{ \"_db_links\" } }, @values );\n  \n} # add_DBLinks\n\n\n=head2 remove_DBLinks\n\n Title   : remove_DBLinks\n Usage   : $obj->remove_DBLinks();\n Function: Deletes (and returns) the list of Bio::Annotation::DBLink objects\n           associated with this phenotype.\n Returns : A list of Bio::Annotation::DBLink objects.\n Args    :\n\n\nsub remove_DBLinks {\n    my ( $self ) = @_;\n  \n    my @a = $self->each_DBLink();\n    $self->{ \"_db_links\" } = [];\n    return @a;\n\n} # remove_DBLinks\n\n\n\n\n=head2 each_Genotype\n\n Title   : each_Reference()\n Usage   : @gts = $obj->each_Reference();                 \n Function: Returns a list of \"Genotype\" objects\n           associated with this phenotype.\n           {* the \"genotypes\" data member and its methods certainly will/needs to be\n           changed/improved in one way or another since there is\n           no \"Genotype\" class yet, CZ 09/06/02 *}\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub each_Genotype {\n    my ( $self ) = @_;\n   \n    return @{ $self->{ \"_genotypes\" } } if exists($self->{ \"_genotypes\" });\n    return ();\n} # each_Genotype\n\n\n=head2 add_Genotypes\n\n Title   : add_Genotypes\n Usage   : $obj->add_Genotypes( @gts );\n           or\n           $obj->add_Genotypes( $gt );                  \n Function: Pushes one or more \"Genotypes\"\n           into the list of \"Genotypes\".\n Returns : \n Args    : \"Genotypes(s)\".\n\n\nsub add_Genotypes {\n    my ( $self, @values ) = @_;\n    \n    return unless( @values );\n\n    #foreach my $value ( @values ) {  \n    #    $self->_check_ref_type( $value, \"Bio::GenotypeI\" );\n    #}\n        \n    push( @{ $self->{ \"_genotypes\" } }, @values );\n    \n} # add_Genotypes\n\n\n=head2 remove_Genotypes\n\n Title   : remove_Genotypes\n Usage   : $obj->remove_Genotypes();\n Function: Deletes (and returns) the list of \"Genotype\" objects\n           associated with this phenotype.\n Returns : A list of \"Genotype\" objects.\n Args    :\n\n\nsub remove_Genotypes {\n    my ( $self ) = @_;\n\n    my @a = $self->each_Genotype();\n    $self->{ \"_genotypes\" } = [];\n    return @a;\n\n} # remove_Genotypes\n\n\n=head2 _check_ref_type\n\n Title   : _check_ref_type\n Usage   : $self->_check_ref_type( $value, \"Bio::Annotation::DBLink\" );\n Function: Checks for the correct type.\n Returns : \n Args    : The value to be checked, the expected class.","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}]},"detail":"($self,$value,$expected_class)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_check_ref_type","localvar":"my","kind":13,"line":938},{"line":938,"kind":13,"containerName":"_check_ref_type","name":"$value"},{"name":"$expected_class","containerName":"_check_ref_type","kind":13,"line":938},{"name":"$value","containerName":"_check_ref_type","kind":13,"line":940},{"kind":13,"line":941,"name":"$self","containerName":"_check_ref_type"},{"line":941,"kind":12,"name":"throw","containerName":"_check_ref_type"},{"kind":13,"line":944,"name":"$value","containerName":"_check_ref_type"},{"line":945,"kind":13,"containerName":"_check_ref_type","name":"$self"},{"line":945,"kind":12,"containerName":"_check_ref_type","name":"throw"},{"kind":13,"line":948,"name":"$value","containerName":"_check_ref_type"},{"line":948,"kind":12,"name":"isa","containerName":"_check_ref_type"},{"name":"$expected_class","containerName":"_check_ref_type","line":948,"kind":13},{"kind":13,"line":949,"containerName":"_check_ref_type","name":"$self"},{"line":949,"kind":12,"name":"throw","containerName":"_check_ref_type"},{"name":"$value","containerName":"_check_ref_type","line":949,"kind":13}],"line":937,"kind":12,"range":{"end":{"line":952,"character":9999},"start":{"character":0,"line":937}},"name":"_check_ref_type"}]}