{"vars":[{"kind":2,"line":106,"containerName":"","name":"base"},{"name":"new","range":{"end":{"character":9999,"line":161},"start":{"character":0,"line":132}},"kind":12,"children":[{"kind":13,"line":134,"containerName":"new","name":"$class","definition":"my","localvar":"my"},{"line":134,"kind":13,"name":"@args","containerName":"new"},{"localvar":"my","name":"$self","definition":"my","containerName":"new","line":136,"kind":13},{"kind":13,"line":136,"name":"$class","containerName":"new"},{"kind":13,"line":136,"name":"@args","containerName":"new"},{"localvar":"my","name":"$number","definition":"my","containerName":"new","line":138,"kind":13},{"name":"$title","containerName":"new","line":138,"kind":13},{"name":"$symbol","containerName":"new","line":138,"kind":13},{"containerName":"new","name":"$desc","line":138,"kind":13},{"kind":13,"line":138,"name":"$ori","containerName":"new"},{"name":"$mut","containerName":"new","line":138,"kind":13},{"name":"$pos","containerName":"new","kind":13,"line":138},{"name":"$am","containerName":"new","line":138,"kind":13},{"name":"$self","containerName":"new","line":139,"kind":13},{"name":"_rearrange","containerName":"new","line":139,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":146},{"name":"$self","containerName":"new","line":148,"kind":13},{"containerName":"new","name":"init","kind":12,"line":148},{"kind":13,"line":150,"containerName":"new","name":"$number"},{"name":"$self","containerName":"new","line":150,"kind":13},{"containerName":"new","name":"number","line":150,"kind":12},{"kind":13,"line":150,"name":"$number","containerName":"new"},{"name":"$title","containerName":"new","line":151,"kind":13},{"line":151,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":151,"containerName":"new","name":"title"},{"containerName":"new","name":"$title","kind":13,"line":151},{"kind":13,"line":152,"containerName":"new","name":"$symbol"},{"kind":13,"line":152,"containerName":"new","name":"$self"},{"containerName":"new","name":"symbol","kind":12,"line":152},{"name":"$symbol","containerName":"new","kind":13,"line":152},{"name":"$desc","containerName":"new","kind":13,"line":153},{"line":153,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"description","line":153,"kind":12},{"line":153,"kind":13,"name":"$desc","containerName":"new"},{"containerName":"new","name":"$ori","line":154,"kind":13},{"kind":13,"line":154,"containerName":"new","name":"$self"},{"name":"aa_ori","containerName":"new","line":154,"kind":12},{"containerName":"new","name":"$ori","line":154,"kind":13},{"line":155,"kind":13,"containerName":"new","name":"$mut"},{"containerName":"new","name":"$self","line":155,"kind":13},{"line":155,"kind":12,"name":"aa_mut","containerName":"new"},{"containerName":"new","name":"$mut","kind":13,"line":155},{"containerName":"new","name":"$pos","line":156,"kind":13},{"line":156,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"position","line":156,"kind":12},{"containerName":"new","name":"$pos","kind":13,"line":156},{"containerName":"new","name":"$am","kind":13,"line":157},{"name":"$self","containerName":"new","kind":13,"line":157},{"name":"additional_mutations","containerName":"new","kind":12,"line":157},{"containerName":"new","name":"$am","line":157,"kind":13},{"kind":13,"line":159,"name":"$self","containerName":"new"}],"line":132,"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations"},"detail":"($class,@args)"},{"line":136,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"end":{"line":188,"character":9999},"start":{"character":0,"line":176}},"name":"init","detail":"($self)","signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :"},"containerName":"main::","definition":"sub","line":176,"children":[{"kind":13,"line":177,"containerName":"init","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"init","line":179,"kind":13},{"containerName":"init","name":"number","line":179,"kind":12},{"line":180,"kind":13,"name":"$self","containerName":"init"},{"containerName":"init","name":"title","kind":12,"line":180},{"containerName":"init","name":"$self","line":181,"kind":13},{"line":181,"kind":12,"containerName":"init","name":"symbol"},{"line":182,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","name":"description","line":182,"kind":12},{"line":183,"kind":13,"name":"$self","containerName":"init"},{"name":"aa_ori","containerName":"init","kind":12,"line":183},{"line":184,"kind":13,"containerName":"init","name":"$self"},{"kind":12,"line":184,"containerName":"init","name":"aa_mut"},{"kind":13,"line":185,"name":"$self","containerName":"init"},{"name":"position","containerName":"init","kind":12,"line":185},{"containerName":"init","name":"$self","kind":13,"line":186},{"kind":12,"line":186,"containerName":"init","name":"additional_mutations"}],"kind":12},{"name":"number","range":{"start":{"character":0,"line":206},"end":{"line":215,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"number($self,$value)"},"kind":12,"line":206,"children":[{"definition":"my","name":"$self","containerName":"number","localvar":"my","kind":13,"line":207},{"name":"$value","containerName":"number","line":207,"kind":13},{"kind":13,"line":209,"name":"$value","containerName":"number"},{"name":"$self","containerName":"number","kind":13,"line":210},{"containerName":"number","name":"$value","line":210,"kind":13},{"name":"$self","containerName":"number","kind":13,"line":213}]},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).","label":"title($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":232,"kind":13,"localvar":"my","containerName":"title","definition":"my","name":"$self"},{"name":"$value","containerName":"title","kind":13,"line":232},{"line":234,"kind":13,"containerName":"title","name":"$value"},{"line":235,"kind":13,"containerName":"title","name":"$self"},{"name":"$value","containerName":"title","kind":13,"line":235},{"name":"$self","containerName":"title","kind":13,"line":238}],"line":231,"name":"title","range":{"start":{"line":231,"character":0},"end":{"character":9999,"line":240}}},{"line":257,"children":[{"line":258,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"symbol"},{"line":258,"kind":13,"containerName":"symbol","name":"$value"},{"line":260,"kind":13,"containerName":"symbol","name":"$value"},{"name":"$self","containerName":"symbol","line":261,"kind":13},{"containerName":"symbol","name":"$value","kind":13,"line":261},{"line":264,"kind":13,"name":"$self","containerName":"symbol"}],"kind":12,"detail":"($self,$value)","signature":{"label":"symbol($self,$value)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"start":{"line":257,"character":0},"end":{"character":9999,"line":266}},"name":"symbol"},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"description($self,$value)"},"kind":12,"line":283,"children":[{"kind":13,"line":284,"definition":"my","name":"$self","containerName":"description","localvar":"my"},{"name":"$value","containerName":"description","kind":13,"line":284},{"containerName":"description","name":"$value","line":286,"kind":13},{"line":287,"kind":13,"containerName":"description","name":"$self"},{"kind":13,"line":287,"name":"$value","containerName":"description"},{"name":"$self","containerName":"description","kind":13,"line":290}],"name":"description","range":{"end":{"line":292,"character":9999},"start":{"line":283,"character":0}}},{"name":"aa_ori","range":{"end":{"character":9999,"line":318},"start":{"character":0,"line":309}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"aa_ori($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"localvar":"my","containerName":"aa_ori","definition":"my","name":"$self","line":310,"kind":13},{"containerName":"aa_ori","name":"$value","kind":13,"line":310},{"containerName":"aa_ori","name":"$value","kind":13,"line":312},{"kind":13,"line":313,"containerName":"aa_ori","name":"$self"},{"line":313,"kind":13,"name":"$value","containerName":"aa_ori"},{"kind":13,"line":316,"name":"$self","containerName":"aa_ori"}],"line":309},{"range":{"end":{"character":9999,"line":344},"start":{"line":335,"character":0}},"name":"aa_mut","line":335,"children":[{"kind":13,"line":336,"definition":"my","name":"$self","containerName":"aa_mut","localvar":"my"},{"line":336,"kind":13,"containerName":"aa_mut","name":"$value"},{"name":"$value","containerName":"aa_mut","kind":13,"line":338},{"containerName":"aa_mut","name":"$self","kind":13,"line":339},{"line":339,"kind":13,"containerName":"aa_mut","name":"$value"},{"containerName":"aa_mut","name":"$self","line":342,"kind":13}],"kind":12,"detail":"($self,$value)","signature":{"label":"aa_mut($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional)."},"containerName":"main::","definition":"sub"},{"name":"position","range":{"start":{"character":0,"line":361},"end":{"line":370,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"position($self,$value)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"line":362,"kind":13,"localvar":"my","containerName":"position","name":"$self","definition":"my"},{"kind":13,"line":362,"containerName":"position","name":"$value"},{"kind":13,"line":364,"containerName":"position","name":"$value"},{"kind":13,"line":365,"containerName":"position","name":"$self"},{"name":"$value","containerName":"position","kind":13,"line":365},{"name":"$self","containerName":"position","kind":13,"line":368}],"line":361},{"name":"additional_mutations","range":{"start":{"character":0,"line":387},"end":{"line":396,"character":9999}},"kind":12,"line":387,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"additional_mutations","line":388,"kind":13},{"name":"$value","containerName":"additional_mutations","line":388,"kind":13},{"name":"$value","containerName":"additional_mutations","line":390,"kind":13},{"containerName":"additional_mutations","name":"$self","kind":13,"line":391},{"line":391,"kind":13,"name":"$value","containerName":"additional_mutations"},{"name":"$self","containerName":"additional_mutations","line":394,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).\n\n\nsub position {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_position\" } = $value;\n    }\n\n    return $self->{ \"_position\" };\n\n} # position\n\n\n\n\n=head2 additional_mutations\n\n Title   : additional_mutations\n Usage   : $av->additional_mutations( \"1-BP DEL, 911T\" );\n           or\n           print $av->additional_mutations();\n Function: Set/get for free form description of (additional) mutation(s).\n Returns : description of (additional) mutation(s).\n Args    : description of (additional) mutation(s) (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"additional_mutations($self,$value)"}},{"name":"to_string","range":{"start":{"line":410,"character":0},"end":{"line":434,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"to_string($self)","documentation":"1;\n# $Id: OMIMentryAllelicVariant.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentryAllelicVariant\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentryAllelicVariant - Representation of a allelic\nvariant of the OMIM database\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\n  $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                            -title                => \"ALCOHOL INTOLERANCE\",\n                                                            -symbol               => \"ALDH2*2\",\n                                                            -description          => \"The ALDH2*2-encoded ...\",\n                                                            -aa_ori               => \"GLU\",\n                                                            -aa_mut               => \"LYS\",\n                                                            -position             => 487,\n                                                            -additional_mutations => \"IVS4DS, G-A, +1\" );\n\n=head1 DESCRIPTION\n\nThis class models the allelic variant of the OMIM database.\nThis class is intended to be used together with a OMIM entry class. \n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n=head2 new\n\n Title   : new\n Usage   : $av = Bio::Phenotype::OMIM::OMIMentryAllelicVariant->new( -number               => \".0001\",\n                                                                     -title                => \"ALCOHOL INTOLERANCE\",\n                                                                     -symbol               => \"ALDH2*2\",\n                                                                     -description          => \"The ALDH2*2-encoded ...\",\n                                                                     -aa_ori               => \"GLU\",\n                                                                     -aa_mut               => \"LYS\",\n                                                                     -position             => 487,\n                                                                     -additional_mutations => \"IVS4DS, G-A, +1\" );                      \n Function: Creates a new OMIMentryAllelicVariant object.\n Returns : A new OMIMentryAllelicVariant object.\n Args    : -number               => the OMIM allelic variant number\n           -title                => the title\n           -symbol               => a symbol\n           -description          => a description\n           -aa_ori               => the original amino acid\n           -aa_mut               => the mutated amino acid\n           -position             => the position of the mutation\n           -additional_mutations => free form description of additional mutations\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n  \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $number, $title, $symbol, $desc, $ori, $mut, $pos, $am )\n    = $self->_rearrange( [ qw( NUMBER\n                               TITLE\n                               SYMBOL\n                               DESCRIPTION\n                               AA_ORI\n                               AA_MUT\n                               POSITION\n                               ADDITIONAL_MUTATIONS ) ], @args );\n\n    $self->init(); \n\n    $number && $self->number( $number );\n    $title  && $self->title( $title );\n    $symbol && $self->symbol( $symbol );\n    $desc   && $self->description( $desc );\n    $ori    && $self->aa_ori( $ori );\n    $mut    && $self->aa_mut( $mut );\n    $pos    && $self->position( $pos );\n    $am     && $self->additional_mutations( $am );\n   \n    return $self;\n\n} # new \n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $av->init();   \n Function: Initializes this OMIMentryAllelicVariant to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->number( \"\" );\n    $self->title( \"\" );\n    $self->symbol( \"\" );\n    $self->description( \"\" );\n    $self->aa_ori( \"\" );\n    $self->aa_mut( \"\" );\n    $self->position( \"\" );\n    $self->additional_mutations( \"\" );\n    \n} # init\n\n\n\n\n=head2 number\n\n Title   : number\n Usage   : $av->number( \".0001\" );\n           or\n           print $av->number();\n Function: Set/get for the OMIM allelic variant number of this\n           OMIMentryAllelicVariant.\n Returns : The OMIM allelic variant number.\n Args    : The OMIM allelic variant number (optional).\n\n\nsub number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_number\" } = $value;\n    }\n\n    return $self->{ \"_number\" };\n\n} # number\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $av->title( \"ALCOHOL INTOLERANCE\" );\n           or\n           print $av->title();\n Function: Set/get for the title of this OMIMentryAllelicVariant.\n Returns : The title.\n Args    : The title (optional).\n\n\nsub title {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_title\" } = $value;\n    }\n\n    return $self->{ \"_title\" };\n\n} # title\n\n\n\n\n=head2 symbol\n\n Title   : symbol\n Usage   : $av->symbol( \"ALDH2*2\" );\n           or\n           print $av->symbol();\n Function: Set/get for the symbol of this OMIMentryAllelicVariant.\n Returns : A symbol.\n Args    : A symbol (optional).\n\n\nsub symbol {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_symbol\" } = $value;\n    }\n\n    return $self->{ \"_symbol\" };\n\n} # symbol\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $av->description( \"The ALDH2*2-encoded protein has a change ...\" );\n           or\n           print $av->description();\n Function: Set/get for the description of this OMIMentryAllelicVariant.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n\n    return $self->{ \"_description\" };\n\n} # description\n\n\n\n\n=head2 aa_ori\n\n Title   : aa_ori\n Usage   : $av->aa_ori( \"GLU\" );\n           or\n           print $av->aa_ori();\n Function: Set/get for the original amino acid(s).\n Returns : The original amino acid(s).\n Args    : The original amino acid(s) (optional).\n\n\nsub aa_ori {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_ori\" } = $value;\n    }\n\n    return $self->{ \"_aa_ori\" };\n\n} # aa_ori\n\n\n\n\n=head2 aa_mut\n\n Title   : aa_mut\n Usage   : $av->aa_mut( \"LYS\" );\n           or\n           print $av->aa_mut();\n Function: Set/get for the mutated amino acid(s).\n Returns : The mutated amino acid(s).\n Args    : The mutated amino acid(s) (optional).\n\n\nsub aa_mut {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_aa_mut\" } = $value;\n    }\n\n    return $self->{ \"_aa_mut\" };\n\n} # aa_mut\n\n\n\n\n=head2 position\n\n Title   : position\n Usage   : $av->position( 487 );\n           or\n           print $av->position();\n Function: Set/get for the position of the mutation.\n Returns : The position of the mutation.\n Args    : The position of the mutation (optional).\n\n\nsub position {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_position\" } = $value;\n    }\n\n    return $self->{ \"_position\" };\n\n} # position\n\n\n\n\n=head2 additional_mutations\n\n Title   : additional_mutations\n Usage   : $av->additional_mutations( \"1-BP DEL, 911T\" );\n           or\n           print $av->additional_mutations();\n Function: Set/get for free form description of (additional) mutation(s).\n Returns : description of (additional) mutation(s).\n Args    : description of (additional) mutation(s) (optional).\n\n\nsub additional_mutations {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_additional_mutations\" } = $value;\n    }\n\n    return $self->{ \"_additional_mutations\" };\n\n} # additional_mutations\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $av->to_string();\n Function: To string method for OMIMentryAllelicVariant objects.\n Returns : A string representations of this OMIMentryAllelicVariant.\n Args    :","parameters":[{"label":"$self"}]},"kind":12,"line":410,"children":[{"containerName":"to_string","name":"$self","definition":"my","localvar":"my","kind":13,"line":411},{"definition":"my","name":"$s","containerName":"to_string","localvar":"my","kind":13,"line":413},{"kind":13,"line":415,"containerName":"to_string","name":"$s"},{"line":416,"kind":13,"name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":416},{"kind":12,"line":416,"name":"number","containerName":"to_string"},{"name":"$s","containerName":"to_string","line":417,"kind":13},{"name":"$s","containerName":"to_string","kind":13,"line":418},{"containerName":"to_string","name":"$self","line":418,"kind":13},{"name":"title","containerName":"to_string","line":418,"kind":12},{"kind":13,"line":419,"name":"$s","containerName":"to_string"},{"name":"$s","containerName":"to_string","kind":13,"line":420},{"name":"$self","containerName":"to_string","kind":13,"line":420},{"kind":12,"line":420,"containerName":"to_string","name":"symbol"},{"containerName":"to_string","name":"$s","kind":13,"line":421},{"kind":13,"line":422,"name":"$s","containerName":"to_string"},{"line":422,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"description","kind":12,"line":422},{"name":"$s","containerName":"to_string","line":423,"kind":13},{"name":"$s","containerName":"to_string","kind":13,"line":424},{"line":424,"kind":13,"name":"$self","containerName":"to_string"},{"kind":12,"line":424,"containerName":"to_string","name":"aa_ori"},{"kind":13,"line":425,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","line":426,"kind":13},{"kind":13,"line":426,"containerName":"to_string","name":"$self"},{"line":426,"kind":12,"name":"aa_mut","containerName":"to_string"},{"kind":13,"line":427,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","line":428,"kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":428},{"name":"position","containerName":"to_string","line":428,"kind":12},{"line":429,"kind":13,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$s","kind":13,"line":430},{"line":430,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":430,"containerName":"to_string","name":"additional_mutations"},{"kind":13,"line":432,"containerName":"to_string","name":"$s"}]}],"version":5}