{"version":5,"vars":[{"kind":14,"line":102,"name":"TRUE","definition":1,"containerName":"main::"},{"line":102,"kind":12,"name":"strict","containerName":"Bio::Phenotype::OMIM::MiniMIMentry::Bio::Phenotype::OMIM::OMIMentryAllelicVariant"},{"name":"FALSE","definition":1,"containerName":"main::","line":103,"kind":14},{"containerName":"main::","definition":1,"name":"DEFAULT_MIM_NUMER","kind":14,"line":104},{"kind":2,"line":106,"containerName":"","name":"base"},{"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry","label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":140,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":140},{"kind":13,"line":142,"definition":"my","name":"$self","containerName":"new","localvar":"my"},{"kind":13,"line":142,"name":"$class","containerName":"new"},{"kind":13,"line":142,"name":"@args","containerName":"new"},{"localvar":"my","definition":"my","name":"$mim_number","containerName":"new","line":144,"kind":13},{"name":"$title","containerName":"new","line":145,"kind":13},{"kind":13,"line":146,"containerName":"new","name":"$alternative_titles_and_symbols"},{"name":"$more_than_two_genes","containerName":"new","kind":13,"line":147},{"kind":13,"line":148,"containerName":"new","name":"$is_separate"},{"containerName":"new","name":"$description","kind":13,"line":149},{"line":150,"kind":13,"containerName":"new","name":"$mapping_method"},{"kind":13,"line":151,"name":"$gene_status","containerName":"new"},{"line":152,"kind":13,"name":"$comment","containerName":"new"},{"line":153,"kind":13,"containerName":"new","name":"$species"},{"line":154,"kind":13,"name":"$created","containerName":"new"},{"containerName":"new","name":"$edited","kind":13,"line":155},{"name":"$contributors","containerName":"new","line":156,"kind":13},{"kind":13,"line":157,"name":"$additional_references","containerName":"new"},{"containerName":"new","name":"$clinical_symptoms","kind":13,"line":158},{"containerName":"new","name":"$miniMIM","kind":13,"line":159},{"kind":13,"line":160,"containerName":"new","name":"$self"},{"containerName":"new","name":"_rearrange","line":160,"kind":12},{"name":"@args","containerName":"new","line":175,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":177},{"name":"init","containerName":"new","line":177,"kind":12},{"containerName":"new","name":"$mim_number","kind":13,"line":179},{"containerName":"new","name":"$self","line":179,"kind":13},{"line":179,"kind":12,"name":"MIM_number","containerName":"new"},{"name":"$mim_number","containerName":"new","kind":13,"line":179},{"line":180,"kind":13,"name":"$title","containerName":"new"},{"line":180,"kind":13,"containerName":"new","name":"$self"},{"name":"title","containerName":"new","line":180,"kind":12},{"line":180,"kind":13,"name":"$title","containerName":"new"},{"name":"$alternative_titles_and_symbols","containerName":"new","kind":13,"line":181},{"name":"$self","containerName":"new","line":181,"kind":13},{"name":"alternative_titles_and_symbols","containerName":"new","kind":12,"line":181},{"kind":13,"line":181,"containerName":"new","name":"$alternative_titles_and_symbols"},{"name":"$more_than_two_genes","containerName":"new","kind":13,"line":182},{"line":182,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"more_than_two_genes","kind":12,"line":182},{"line":182,"kind":13,"name":"$more_than_two_genes","containerName":"new"},{"containerName":"new","name":"$is_separate","kind":13,"line":183},{"line":183,"kind":13,"name":"$self","containerName":"new"},{"name":"is_separate","containerName":"new","kind":12,"line":183},{"line":183,"kind":13,"containerName":"new","name":"$is_separate"},{"kind":13,"line":184,"containerName":"new","name":"$description"},{"kind":13,"line":184,"containerName":"new","name":"$self"},{"line":184,"kind":12,"containerName":"new","name":"description"},{"kind":13,"line":184,"containerName":"new","name":"$description"},{"containerName":"new","name":"$mapping_method","kind":13,"line":185},{"name":"$self","containerName":"new","kind":13,"line":185},{"line":185,"kind":12,"containerName":"new","name":"mapping_method"},{"kind":13,"line":185,"containerName":"new","name":"$mapping_method"},{"containerName":"new","name":"$gene_status","line":186,"kind":13},{"containerName":"new","name":"$self","kind":13,"line":186},{"line":186,"kind":12,"name":"gene_status","containerName":"new"},{"containerName":"new","name":"$gene_status","line":186,"kind":13},{"kind":13,"line":187,"containerName":"new","name":"$comment"},{"kind":13,"line":187,"containerName":"new","name":"$self"},{"line":187,"kind":12,"name":"comment","containerName":"new"},{"containerName":"new","name":"$comment","line":187,"kind":13},{"line":188,"kind":13,"name":"$species","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":188},{"kind":12,"line":188,"name":"species","containerName":"new"},{"containerName":"new","name":"$species","kind":13,"line":188},{"name":"$created","containerName":"new","kind":13,"line":189},{"name":"$self","containerName":"new","kind":13,"line":189},{"line":189,"kind":12,"containerName":"new","name":"created"},{"containerName":"new","name":"$created","kind":13,"line":189},{"name":"$edited","containerName":"new","kind":13,"line":190},{"line":190,"kind":13,"name":"$self","containerName":"new"},{"name":"edited","containerName":"new","line":190,"kind":12},{"kind":13,"line":190,"name":"$edited","containerName":"new"},{"kind":13,"line":191,"name":"$contributors","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":191},{"name":"contributors","containerName":"new","line":191,"kind":12},{"name":"$contributors","containerName":"new","kind":13,"line":191},{"line":192,"kind":13,"name":"$additional_references","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":192},{"containerName":"new","name":"additional_references","kind":12,"line":192},{"containerName":"new","name":"$additional_references","line":192,"kind":13},{"name":"$clinical_symptoms","containerName":"new","line":193,"kind":13},{"containerName":"new","name":"$self","line":193,"kind":13},{"containerName":"new","name":"clinical_symptoms_raw","line":193,"kind":12},{"kind":13,"line":193,"name":"$clinical_symptoms","containerName":"new"},{"line":194,"kind":13,"containerName":"new","name":"$miniMIM"},{"kind":13,"line":194,"name":"$self","containerName":"new"},{"line":194,"kind":12,"name":"miniMIM","containerName":"new"},{"line":194,"kind":13,"containerName":"new","name":"$miniMIM"},{"kind":13,"line":196,"containerName":"new","name":"$self"}],"line":138,"kind":12,"range":{"start":{"line":138,"character":0},"end":{"line":198,"character":9999}},"name":"new"},{"kind":12,"line":142,"containerName":"new","name":"SUPER"},{"range":{"end":{"line":245,"character":9999},"start":{"line":212,"character":0}},"name":"init","line":212,"children":[{"kind":13,"line":214,"containerName":"init","definition":"my","name":"$self","localvar":"my"},{"name":"$self","containerName":"init","line":216,"kind":13},{"kind":12,"line":216,"containerName":"init","name":"MIM_number"},{"containerName":"init","name":"$self","line":217,"kind":13},{"containerName":"init","name":"title","kind":12,"line":217},{"kind":13,"line":218,"containerName":"init","name":"$self"},{"name":"alternative_titles_and_symbols","containerName":"init","line":218,"kind":12},{"name":"$self","containerName":"init","kind":13,"line":219},{"containerName":"init","name":"more_than_two_genes","kind":12,"line":219},{"line":220,"kind":13,"containerName":"init","name":"$self"},{"kind":12,"line":220,"containerName":"init","name":"is_separate"},{"name":"$self","containerName":"init","kind":13,"line":221},{"kind":12,"line":221,"name":"description","containerName":"init"},{"kind":13,"line":222,"containerName":"init","name":"$self"},{"name":"mapping_method","containerName":"init","kind":12,"line":222},{"kind":13,"line":223,"containerName":"init","name":"$self"},{"line":223,"kind":12,"name":"gene_status","containerName":"init"},{"line":224,"kind":13,"containerName":"init","name":"$self"},{"kind":12,"line":224,"name":"comment","containerName":"init"},{"containerName":"init","name":"$species","definition":"my","localvar":"my","kind":13,"line":225},{"kind":12,"line":225,"containerName":"init","name":"new"},{"line":226,"kind":13,"containerName":"init","name":"$species"},{"kind":12,"line":226,"name":"classification","containerName":"init"},{"name":"$self","containerName":"init","line":227,"kind":13},{"line":227,"kind":12,"containerName":"init","name":"species"},{"kind":13,"line":227,"containerName":"init","name":"$species"},{"containerName":"init","name":"$self","kind":13,"line":228},{"containerName":"init","name":"created","kind":12,"line":228},{"containerName":"init","name":"$self","line":229,"kind":13},{"name":"edited","containerName":"init","kind":12,"line":229},{"line":230,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","name":"contributors","kind":12,"line":230},{"containerName":"init","name":"$self","kind":13,"line":231},{"kind":12,"line":231,"name":"additional_references","containerName":"init"},{"line":232,"kind":13,"name":"$self","containerName":"init"},{"line":232,"kind":12,"containerName":"init","name":"clinical_symptoms"},{"containerName":"init","name":"$self","line":233,"kind":13},{"line":233,"kind":12,"name":"remove_Correlates","containerName":"init"},{"kind":13,"line":234,"name":"$self","containerName":"init"},{"kind":12,"line":234,"containerName":"init","name":"remove_References"},{"name":"$self","containerName":"init","kind":13,"line":235},{"line":235,"kind":12,"name":"remove_AllelicVariants","containerName":"init"},{"containerName":"init","name":"$self","kind":13,"line":236},{"containerName":"init","name":"remove_CytoPositions","line":236,"kind":12},{"name":"$self","containerName":"init","kind":13,"line":237},{"name":"remove_gene_symbols","containerName":"init","kind":12,"line":237},{"name":"$self","containerName":"init","kind":13,"line":238},{"line":238,"kind":12,"containerName":"init","name":"remove_Genotypes"},{"containerName":"init","name":"$self","kind":13,"line":239},{"line":239,"kind":12,"name":"remove_DBLinks","containerName":"init"},{"name":"$self","containerName":"init","line":240,"kind":13},{"line":240,"kind":12,"name":"remove_keywords","containerName":"init"},{"name":"$self","containerName":"init","kind":13,"line":241},{"containerName":"init","name":"remove_Variants","line":241,"kind":12},{"kind":13,"line":242,"name":"$self","containerName":"init"},{"name":"remove_Measures","containerName":"init","line":242,"kind":12},{"containerName":"init","name":"$self","line":243,"kind":13},{"name":"miniMIM","containerName":"init","kind":12,"line":243},{"kind":12,"line":243,"containerName":"init","name":"new"}],"kind":12,"detail":"($self)","signature":{"label":"init($self)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"containerName":"main::","definition":"sub"},{"line":216,"kind":12,"name":"DEFAULT_MIM_NUMER"},{"line":219,"kind":12,"name":"FALSE"},{"line":220,"kind":12,"name":"FALSE"},{"name":"Bio","containerName":"Species","line":225,"kind":12},{"line":243,"kind":12,"name":"Bio","containerName":"Phenotype::OMIM::MiniMIMentry"},{"kind":12,"line":249,"children":[{"line":251,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"to_string"},{"kind":13,"line":253,"containerName":"to_string","name":"$s","definition":"my","localvar":"my"},{"name":"$s","containerName":"to_string","kind":13,"line":255},{"containerName":"to_string","name":"$s","line":256,"kind":13},{"containerName":"to_string","name":"$self","line":256,"kind":13},{"name":"MIM_number","containerName":"to_string","kind":12,"line":256},{"kind":13,"line":257,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":258},{"kind":13,"line":258,"name":"$self","containerName":"to_string"},{"name":"title","containerName":"to_string","kind":12,"line":258},{"kind":13,"line":259,"containerName":"to_string","name":"$s"},{"line":260,"kind":13,"name":"$s","containerName":"to_string"},{"line":260,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"alternative_titles_and_symbols","kind":12,"line":260},{"line":261,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"line":262,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$self","kind":13,"line":262},{"line":262,"kind":12,"containerName":"to_string","name":"more_than_two_genes"},{"containerName":"to_string","name":"$s","line":263,"kind":13},{"kind":13,"line":264,"containerName":"to_string","name":"$s"},{"containerName":"to_string","name":"$self","kind":13,"line":264},{"name":"is_separate","containerName":"to_string","kind":12,"line":264},{"kind":13,"line":265,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":266},{"name":"$self","containerName":"to_string","kind":13,"line":266},{"kind":12,"line":266,"containerName":"to_string","name":"description"},{"kind":13,"line":267,"name":"$s","containerName":"to_string"},{"containerName":"to_string","name":"$s","kind":13,"line":268},{"line":268,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"species","line":268,"kind":12},{"containerName":"to_string","name":"binomial","line":268,"kind":12},{"kind":13,"line":269,"name":"$s","containerName":"to_string"},{"name":"$s","containerName":"to_string","kind":13,"line":270},{"kind":13,"line":270,"containerName":"to_string","name":"$self"},{"name":"clinical_symptoms","containerName":"to_string","line":270,"kind":12},{"name":"$s","containerName":"to_string","kind":13,"line":271},{"line":272,"kind":13,"name":"$s","containerName":"to_string"},{"kind":13,"line":272,"name":"$self","containerName":"to_string"},{"containerName":"to_string","name":"_array_to_string","kind":12,"line":272},{"line":272,"kind":13,"name":"$self","containerName":"to_string"},{"kind":12,"line":272,"containerName":"to_string","name":"each_AllelicVariant"},{"containerName":"to_string","name":"$s","kind":13,"line":273},{"line":274,"kind":13,"name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":274},{"line":274,"kind":12,"containerName":"to_string","name":"_array_to_string"},{"kind":13,"line":274,"name":"$self","containerName":"to_string"},{"name":"each_CytoPosition","containerName":"to_string","kind":12,"line":274},{"containerName":"to_string","name":"$s","kind":13,"line":275},{"name":"$s","containerName":"to_string","kind":13,"line":276},{"name":"$self","containerName":"to_string","line":276,"kind":13},{"name":"_array_to_string","containerName":"to_string","kind":12,"line":276},{"line":276,"kind":13,"name":"$self","containerName":"to_string"},{"kind":12,"line":276,"name":"each_gene_symbol","containerName":"to_string"},{"kind":13,"line":277,"name":"$s","containerName":"to_string"},{"kind":13,"line":278,"name":"$s","containerName":"to_string"},{"kind":13,"line":278,"containerName":"to_string","name":"$self"},{"name":"_array_to_string","containerName":"to_string","line":278,"kind":12},{"name":"$self","containerName":"to_string","line":278,"kind":13},{"kind":12,"line":278,"name":"each_Correlate","containerName":"to_string"},{"containerName":"to_string","name":"$s","line":279,"kind":13},{"name":"$s","containerName":"to_string","kind":13,"line":280},{"name":"$self","containerName":"to_string","kind":13,"line":280},{"kind":12,"line":280,"containerName":"to_string","name":"_array_to_string"},{"kind":13,"line":280,"containerName":"to_string","name":"$self"},{"line":280,"kind":12,"name":"each_Reference","containerName":"to_string"},{"kind":13,"line":281,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","line":282,"kind":13},{"kind":13,"line":282,"containerName":"to_string","name":"$self"},{"kind":12,"line":282,"containerName":"to_string","name":"additional_references"},{"line":283,"kind":13,"name":"$s","containerName":"to_string"},{"name":"$s","containerName":"to_string","kind":13,"line":284},{"kind":13,"line":284,"containerName":"to_string","name":"$self"},{"name":"mapping_method","containerName":"to_string","kind":12,"line":284},{"kind":13,"line":285,"name":"$s","containerName":"to_string"},{"line":286,"kind":13,"containerName":"to_string","name":"$s"},{"line":286,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"gene_status","line":286,"kind":12},{"containerName":"to_string","name":"$s","kind":13,"line":287},{"containerName":"to_string","name":"$s","line":288,"kind":13},{"name":"$self","containerName":"to_string","line":288,"kind":13},{"name":"created","containerName":"to_string","kind":12,"line":288},{"containerName":"to_string","name":"$s","kind":13,"line":289},{"line":290,"kind":13,"name":"$s","containerName":"to_string"},{"name":"$self","containerName":"to_string","kind":13,"line":290},{"name":"contributors","containerName":"to_string","kind":12,"line":290},{"name":"$s","containerName":"to_string","kind":13,"line":291},{"containerName":"to_string","name":"$s","kind":13,"line":292},{"name":"$self","containerName":"to_string","line":292,"kind":13},{"containerName":"to_string","name":"edited","kind":12,"line":292},{"containerName":"to_string","name":"$s","kind":13,"line":293},{"name":"$s","containerName":"to_string","kind":13,"line":294},{"containerName":"to_string","name":"$self","kind":13,"line":294},{"line":294,"kind":12,"containerName":"to_string","name":"comment"},{"name":"$s","containerName":"to_string","kind":13,"line":295},{"line":296,"kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"line":296,"name":"$self","containerName":"to_string"},{"kind":12,"line":296,"containerName":"to_string","name":"miniMIM"},{"kind":12,"line":296,"name":"to_string","containerName":"to_string"},{"containerName":"to_string","name":"$s","line":297,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"to_string($self)"},"name":"to_string","range":{"end":{"character":9999,"line":300},"start":{"line":249,"character":0}}},{"kind":12,"line":316,"children":[{"localvar":"my","containerName":"MIM_number","name":"$self","definition":"my","line":317,"kind":13},{"line":317,"kind":13,"containerName":"MIM_number","name":"$value"},{"name":"$value","containerName":"MIM_number","kind":13,"line":319},{"kind":13,"line":320,"name":"$value","containerName":"MIM_number"},{"line":321,"kind":13,"containerName":"MIM_number","name":"$value"},{"containerName":"MIM_number","name":"$value","kind":13,"line":321},{"kind":13,"line":322,"containerName":"MIM_number","name":"$self"},{"name":"throw","containerName":"MIM_number","kind":12,"line":322},{"kind":13,"line":325,"containerName":"MIM_number","name":"$self"},{"name":"$value","containerName":"MIM_number","line":325,"kind":13},{"kind":13,"line":328,"name":"$self","containerName":"MIM_number"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).","label":"MIM_number($self,$value)"},"name":"MIM_number","range":{"end":{"character":9999,"line":330},"start":{"line":316,"character":0}}},{"kind":12,"line":321,"name":"DEFAULT_MIM_NUMER"},{"definition":"sub","name":"title","containerName":"main::","range":{"end":{"line":354,"character":9999},"start":{"character":0,"line":349}},"kind":12,"children":[{"line":350,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"title"},{"line":352,"kind":13,"name":"$self","containerName":"title"},{"containerName":"title","name":"name","kind":12,"line":352}],"line":349},{"range":{"start":{"line":373,"character":0},"end":{"line":382,"character":9999}},"name":"alternative_titles_and_symbols","signature":{"label":"alternative_titles_and_symbols($self,$value)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"alternative_titles_and_symbols","name":"$self","definition":"my","line":374,"kind":13},{"line":374,"kind":13,"containerName":"alternative_titles_and_symbols","name":"$value"},{"name":"$value","containerName":"alternative_titles_and_symbols","kind":13,"line":376},{"name":"$self","containerName":"alternative_titles_and_symbols","kind":13,"line":377},{"line":377,"kind":13,"name":"$value","containerName":"alternative_titles_and_symbols"},{"kind":13,"line":380,"name":"$self","containerName":"alternative_titles_and_symbols"}],"line":373,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"more_than_two_genes($self,$value)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":402,"children":[{"line":403,"kind":13,"localvar":"my","containerName":"more_than_two_genes","definition":"my","name":"$self"},{"containerName":"more_than_two_genes","name":"$value","kind":13,"line":403},{"containerName":"more_than_two_genes","name":"$value","kind":13,"line":405},{"name":"$self","containerName":"more_than_two_genes","kind":13,"line":406},{"name":"_is_true_or_false","containerName":"more_than_two_genes","kind":12,"line":406},{"name":"$value","containerName":"more_than_two_genes","line":406,"kind":13},{"name":"$self","containerName":"more_than_two_genes","kind":13,"line":407},{"kind":13,"line":407,"name":"$value","containerName":"more_than_two_genes"},{"name":"$self","containerName":"more_than_two_genes","kind":13,"line":410}],"name":"more_than_two_genes","range":{"end":{"line":412,"character":9999},"start":{"line":402,"character":0}}},{"range":{"end":{"character":9999,"line":446},"start":{"character":0,"line":436}},"name":"is_separate","line":436,"children":[{"containerName":"is_separate","name":"$self","definition":"my","localvar":"my","kind":13,"line":437},{"containerName":"is_separate","name":"$value","kind":13,"line":437},{"containerName":"is_separate","name":"$value","kind":13,"line":439},{"kind":13,"line":440,"name":"$self","containerName":"is_separate"},{"name":"_is_true_or_false","containerName":"is_separate","kind":12,"line":440},{"name":"$value","containerName":"is_separate","kind":13,"line":440},{"containerName":"is_separate","name":"$self","kind":13,"line":441},{"containerName":"is_separate","name":"$value","kind":13,"line":441},{"line":444,"kind":13,"name":"$self","containerName":"is_separate"}],"kind":12,"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).","label":"is_separate($self,$value)"},"containerName":"main::","definition":"sub"},{"range":{"end":{"line":467,"character":9999},"start":{"character":0,"line":463}},"containerName":"main::","name":"mapping_method","definition":"sub","line":463,"children":[{"name":"$self","definition":"my","containerName":"mapping_method","localvar":"my","kind":13,"line":464},{"name":"$self","containerName":"mapping_method","line":465,"kind":13},{"name":"$self","containerName":"mapping_method","line":466,"kind":13}],"kind":12},{"kind":12,"line":490,"children":[{"containerName":"gene_status","definition":"my","name":"$self","localvar":"my","kind":13,"line":491},{"kind":13,"line":491,"containerName":"gene_status","name":"$value"},{"kind":13,"line":493,"containerName":"gene_status","name":"$value"},{"name":"$value","containerName":"gene_status","line":505,"kind":13},{"containerName":"gene_status","name":"$value","kind":13,"line":506},{"containerName":"gene_status","name":"$value","line":507,"kind":13},{"name":"$value","containerName":"gene_status","kind":13,"line":508},{"line":509,"kind":13,"containerName":"gene_status","name":"$value"},{"line":510,"kind":13,"containerName":"gene_status","name":"$value"},{"kind":13,"line":513,"name":"$self","containerName":"gene_status"},{"name":"$value","containerName":"gene_status","kind":13,"line":513},{"line":516,"kind":13,"containerName":"gene_status","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"gene_status($self,$value)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub is_separate {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_is_separate\" } = $value;\n    }\n\n    return $self->{ \"_is_separate\" };\n\n} # is_separate\n\n\n\n\n=head2 mapping_method\n\n Title   : mapping_method\n Usage   : $omim->mapping_method( \"PCR of somatic cell hybrid DNA\" );\n           or\n           print $omim->mapping_method();\n Function: Set/get for the mapping method of this OMIM entry.\n Returns : The mapping method [scalar].\n Args    : The mapping method [scalar] (optional).\n\n\nsub mapping_method {\n    my $self = shift;\n    return $self->{ \"_mapping_method\" } = shift if(@_);\n    return $self->{ \"_mapping_method\" };\n} # mapping_method\n\n=head2 gene_status\n\n Title   : gene_status\n Usage   : $omim->gene_status( \"C\" );\n           or\n           print $omim->gene_status();\n Function: Set/get for the gene status of this OMIM entry.\n           The certainty with which assignment of loci to chromosomes or the linkage\n           between two loci has been established has been graded into the following\n           classes:\n           <L>C = confirmed - observed in at least two laboratories or in several families.\n           <L>P = provisional - based on evidence from one laboratory or one family.\n           <L>I = inconsistent - results of different laboratories disagree.\n           <L>L = limbo - evidence not as strong as that provisional, but included for\n           heuristic reasons. (Same as `tentative'.)\n\n Returns :  [C, P, I, or L].\n Args    :  [C, P, I, or L] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"gene_status","range":{"start":{"character":0,"line":490},"end":{"character":9999,"line":518}}},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"clinical_symptoms","line":532,"kind":13},{"containerName":"clinical_symptoms","name":"$value","line":532,"kind":13},{"line":534,"kind":13,"name":"$value","containerName":"clinical_symptoms"},{"kind":13,"line":535,"name":"$value","containerName":"clinical_symptoms"},{"containerName":"clinical_symptoms","name":"$self","kind":13,"line":536},{"line":536,"kind":12,"containerName":"clinical_symptoms","name":"throw"},{"line":538,"kind":13,"containerName":"clinical_symptoms","name":"$self"},{"kind":13,"line":538,"containerName":"clinical_symptoms","name":"$value"},{"containerName":"clinical_symptoms","name":"$self","kind":13,"line":541}],"line":531,"kind":12,"signature":{"label":"clinical_symptoms($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub is_separate {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_is_separate\" } = $value;\n    }\n\n    return $self->{ \"_is_separate\" };\n\n} # is_separate\n\n\n\n\n=head2 mapping_method\n\n Title   : mapping_method\n Usage   : $omim->mapping_method( \"PCR of somatic cell hybrid DNA\" );\n           or\n           print $omim->mapping_method();\n Function: Set/get for the mapping method of this OMIM entry.\n Returns : The mapping method [scalar].\n Args    : The mapping method [scalar] (optional).\n\n\nsub mapping_method {\n    my $self = shift;\n    return $self->{ \"_mapping_method\" } = shift if(@_);\n    return $self->{ \"_mapping_method\" };\n} # mapping_method\n\n=head2 gene_status\n\n Title   : gene_status\n Usage   : $omim->gene_status( \"C\" );\n           or\n           print $omim->gene_status();\n Function: Set/get for the gene status of this OMIM entry.\n           The certainty with which assignment of loci to chromosomes or the linkage\n           between two loci has been established has been graded into the following\n           classes:\n           <L>C = confirmed - observed in at least two laboratories or in several families.\n           <L>P = provisional - based on evidence from one laboratory or one family.\n           <L>I = inconsistent - results of different laboratories disagree.\n           <L>L = limbo - evidence not as strong as that provisional, but included for\n           heuristic reasons. (Same as `tentative'.)\n\n Returns :  [C, P, I, or L].\n Args    :  [C, P, I, or L] (optional).\n\n\nsub gene_status {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        #unless ( $value eq \"C\"\n        #      || $value eq \"P\"\n        #      || $value eq \"I\"\n        #      || $value eq \"L\"\n        #      || $value eq \"A\"  # !?\n        #      || $value eq \"H\"  # !?\n        #      || $value eq \"U\"  # !?\n        #      || $value eq \"\" ) {\n        #    $self->throw( \"Found [$value]\" \n        #    . \" where [C, P, I, or L] expected\" );\n        #}\n        unless ( $value eq \"C\"\n              || $value eq \"P\"\n              || $value eq \"I\"\n              || $value eq \"L\"\n              || $value eq \"\" ) {\n            $value = \"\";\n        }\n        \n        $self->{ \"_gene_status\" } = $value;\n    }\n\n    return $self->{ \"_gene_status\" };\n\n} # gene_status\n\n\n=head2 clinical_symptoms\n\n Title   : clinical_symptoms\n Usage   : $omim->clinical_symptoms({});\n Function: Set/get for the clinical symptoms of this OMIM entry.\n Returns : [hash reference].\n Args    : [hash reference]. Suggested not to assign alone. Parser will do."},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":531},"end":{"character":9999,"line":543}},"name":"clinical_symptoms"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"clinical_symptoms_raw","line":558,"kind":13},{"line":559,"kind":13,"containerName":"clinical_symptoms_raw","name":"$self"},{"containerName":"clinical_symptoms_raw","name":"$self","kind":13,"line":560}],"line":557,"definition":"sub","name":"clinical_symptoms_raw","containerName":"main::","range":{"start":{"line":557,"character":0},"end":{"character":9999,"line":561}}},{"line":559,"kind":12,"name":"_clinical_symptoms_raw"},{"line":560,"kind":12,"name":"_clinical_symptoms_raw"},{"range":{"end":{"character":9999,"line":583},"start":{"character":0,"line":575}},"name":"add_clinical_symptoms","line":575,"children":[{"kind":13,"line":576,"name":"$self","definition":"my","containerName":"add_clinical_symptoms","localvar":"my"},{"kind":13,"line":576,"name":"$part","containerName":"add_clinical_symptoms"},{"containerName":"add_clinical_symptoms","name":"@symptoms","kind":13,"line":576},{"line":577,"kind":13,"containerName":"add_clinical_symptoms","name":"$part"},{"name":"$self","containerName":"add_clinical_symptoms","line":578,"kind":13},{"containerName":"add_clinical_symptoms","name":"throw","line":578,"kind":12},{"containerName":"add_clinical_symptoms","name":"$self","line":580,"kind":13},{"name":"$self","containerName":"add_clinical_symptoms","line":580,"kind":13},{"kind":13,"line":581,"name":"$self","containerName":"add_clinical_symptoms"},{"name":"$part","containerName":"add_clinical_symptoms","kind":13,"line":581},{"containerName":"add_clinical_symptoms","name":"$self","line":582,"kind":13},{"name":"$part","containerName":"add_clinical_symptoms","kind":13,"line":582},{"name":"$self","containerName":"add_clinical_symptoms","kind":13,"line":583},{"name":"$part","containerName":"add_clinical_symptoms","kind":13,"line":583}],"kind":12,"detail":"($self,$part,@symptoms)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$part"},{"label":"@symptoms"}],"label":"add_clinical_symptoms($self,$part,@symptoms)"},"containerName":"main::","definition":"sub"},{"name":"_clinical_symptoms","line":580,"kind":12},{"name":"_clinical_symptoms","kind":12,"line":580},{"name":"_clinical_symptoms","line":581,"kind":12},{"name":"_clinical_symptoms","kind":12,"line":582},{"name":"_clinical_symptoms","kind":12,"line":583},{"line":583,"kind":13,"name":"@symptoms","containerName":null},{"range":{"end":{"line":600,"character":9999},"start":{"line":596,"character":0}},"name":"query_clinical_symptoms","detail":"($self,$organ)","signature":{"parameters":[{"label":"$self"},{"label":"$organ"}],"documentation":"","label":"query_clinical_symptoms($self,$organ)"},"containerName":"main::","definition":"sub","line":596,"children":[{"localvar":"my","containerName":"query_clinical_symptoms","name":"$self","definition":"my","line":597,"kind":13},{"kind":13,"line":597,"name":"$organ","containerName":"query_clinical_symptoms"},{"kind":13,"line":598,"name":"$symptoms","definition":"my","containerName":"query_clinical_symptoms","localvar":"my"},{"name":"$self","containerName":"query_clinical_symptoms","line":598,"kind":13},{"line":598,"kind":13,"name":"$organ","containerName":"query_clinical_symptoms"},{"line":599,"kind":13,"containerName":"query_clinical_symptoms","name":"$symptoms"}],"kind":12},{"kind":12,"line":598,"name":"_clinical_symptoms"},{"range":{"start":{"character":0,"line":602},"end":{"line":604,"character":9999}},"name":"get_clinical_symptom_organs","children":[{"containerName":"get_clinical_symptom_organs","name":"$self","definition":"my","localvar":"my","kind":13,"line":603},{"kind":13,"line":604,"name":"$self","containerName":"get_clinical_symptom_organs"}],"line":602,"kind":12,"signature":{"label":"get_clinical_symptom_organs($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"_clinical_symptoms","line":604,"kind":12},{"line":619,"children":[{"localvar":"my","containerName":"created","name":"$self","definition":"my","line":620,"kind":13},{"line":621,"kind":13,"name":"$self","containerName":"created"},{"containerName":"created","name":"$self","line":622,"kind":13}],"kind":12,"range":{"start":{"line":619,"character":0},"end":{"character":9999,"line":624}},"containerName":"main::","definition":"sub","name":"created"},{"children":[{"kind":13,"line":642,"definition":"my","name":"$self","containerName":"contributors","localvar":"my"},{"line":643,"kind":13,"name":"$self","containerName":"contributors"},{"kind":13,"line":644,"name":"$self","containerName":"contributors"}],"line":641,"kind":12,"range":{"start":{"line":641,"character":0},"end":{"character":9999,"line":646}},"name":"contributors","definition":"sub","containerName":"main::"},{"kind":12,"line":663,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"edited","line":664,"kind":13},{"containerName":"edited","name":"$self","line":665,"kind":13},{"kind":13,"line":666,"containerName":"edited","name":"$self"}],"containerName":"main::","definition":"sub","name":"edited","range":{"end":{"line":668,"character":9999},"start":{"line":663,"character":0}}},{"kind":12,"children":[{"line":687,"kind":13,"localvar":"my","containerName":"additional_references","definition":"my","name":"$self"},{"containerName":"additional_references","name":"$self","kind":13,"line":688},{"line":689,"kind":13,"containerName":"additional_references","name":"$self"}],"line":686,"name":"additional_references","definition":"sub","containerName":"main::","range":{"end":{"line":691,"character":9999},"start":{"line":686,"character":0}}},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"miniMIM($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":708,"name":"$self","definition":"my","containerName":"miniMIM","localvar":"my"},{"containerName":"miniMIM","name":"$value","kind":13,"line":708},{"kind":13,"line":710,"containerName":"miniMIM","name":"$value"},{"name":"$self","containerName":"miniMIM","kind":13,"line":711},{"kind":12,"line":711,"name":"_check_ref_type","containerName":"miniMIM"},{"name":"$value","containerName":"miniMIM","line":711,"kind":13},{"line":712,"kind":13,"containerName":"miniMIM","name":"$self"},{"name":"$value","containerName":"miniMIM","line":712,"kind":13},{"line":715,"kind":13,"name":"$self","containerName":"miniMIM"}],"line":706,"kind":12,"range":{"start":{"line":706,"character":0},"end":{"character":9999,"line":716}},"name":"miniMIM"},{"definition":"sub","containerName":"main::","signature":{"label":"each_AllelicVariant($self)","documentation":"","parameters":[{"label":"$self"}]},"detail":"($self)","kind":12,"children":[{"line":730,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_AllelicVariant"},{"name":"$self","containerName":"each_AllelicVariant","kind":13,"line":732}],"line":729,"name":"each_AllelicVariant","range":{"start":{"character":0,"line":729},"end":{"character":9999,"line":732}}},{"containerName":null,"name":"%self","line":732,"kind":13},{"kind":12,"line":750,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_AllelicVariants","line":751,"kind":13},{"kind":13,"line":751,"name":"@values","containerName":"add_AllelicVariants"},{"containerName":"add_AllelicVariants","name":"@values","line":753,"kind":13},{"kind":13,"line":755,"containerName":"add_AllelicVariants","definition":"my","name":"$value","localvar":"my"},{"name":"@values","containerName":"add_AllelicVariants","kind":13,"line":755},{"name":"$self","containerName":"add_AllelicVariants","line":756,"kind":13},{"line":756,"kind":12,"name":"_check_ref_type","containerName":"add_AllelicVariants"},{"name":"$value","containerName":"add_AllelicVariants","kind":13,"line":756},{"containerName":"add_AllelicVariants","name":"$self","kind":13,"line":759}],"containerName":"main::","definition":"sub","detail":"($self,@values)","signature":{"label":"add_AllelicVariants($self,@values)","parameters":[{"label":"$self"},{"label":"@values"}],"documentation":""},"name":"add_AllelicVariants","range":{"start":{"character":0,"line":750},"end":{"character":9999,"line":759}}},{"line":759,"kind":13,"containerName":null,"name":"@values"},{"kind":12,"children":[{"kind":13,"line":776,"name":"$self","definition":"my","containerName":"remove_AllelicVariants","localvar":"my"},{"localvar":"my","containerName":"remove_AllelicVariants","name":"@a","definition":"my","line":778,"kind":13},{"kind":13,"line":778,"name":"$self","containerName":"remove_AllelicVariants"},{"kind":12,"line":778,"name":"each_AllelicVariant","containerName":"remove_AllelicVariants"},{"kind":13,"line":779,"name":"$self","containerName":"remove_AllelicVariants"},{"line":780,"kind":13,"name":"@a","containerName":"remove_AllelicVariants"}],"line":775,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"remove_AllelicVariants($self)"},"detail":"($self)","name":"remove_AllelicVariants","range":{"end":{"line":782,"character":9999},"start":{"character":0,"line":775}}},{"range":{"end":{"character":9999,"line":814},"start":{"character":0,"line":789}},"name":"_array_to_string","detail":"($self,@value)","signature":{"label":"_array_to_string($self,@value)","documentation":"","parameters":[{"label":"$self"},{"label":"@value"}]},"containerName":"main::","definition":"sub","line":789,"children":[{"localvar":"my","containerName":"_array_to_string","name":"$self","definition":"my","line":790,"kind":13},{"kind":13,"line":790,"containerName":"_array_to_string","name":"@value"},{"containerName":"_array_to_string","name":"$s","definition":"my","localvar":"my","kind":13,"line":792},{"name":"$i","definition":"my","containerName":"_array_to_string","localvar":"my","kind":13,"line":794},{"name":"$i","containerName":"_array_to_string","line":794,"kind":13},{"containerName":"_array_to_string","name":"@value","kind":13,"line":794},{"kind":13,"line":794,"name":"$i","containerName":"_array_to_string"},{"containerName":"_array_to_string","name":"$value","line":795,"kind":13},{"line":795,"kind":13,"name":"$i","containerName":"_array_to_string"},{"name":"$s","containerName":"_array_to_string","line":796,"kind":13},{"kind":13,"line":796,"name":"$i","containerName":"_array_to_string"},{"containerName":"_array_to_string","name":"$value","kind":13,"line":796},{"line":796,"kind":13,"containerName":"_array_to_string","name":"$i"},{"containerName":"_array_to_string","name":"$value","kind":13,"line":798},{"containerName":"_array_to_string","name":"$i","kind":13,"line":798},{"kind":12,"line":798,"containerName":"_array_to_string","name":"isa"},{"kind":13,"line":799,"name":"$value","containerName":"_array_to_string"},{"containerName":"_array_to_string","name":"$i","kind":13,"line":799},{"kind":12,"line":799,"containerName":"_array_to_string","name":"isa"},{"kind":13,"line":800,"containerName":"_array_to_string","name":"$s"},{"name":"$i","containerName":"_array_to_string","line":800,"kind":13},{"containerName":"_array_to_string","name":"$value","line":800,"kind":13},{"containerName":"_array_to_string","name":"$i","kind":13,"line":800},{"name":"to_string","containerName":"_array_to_string","kind":12,"line":800},{"kind":13,"line":802,"name":"$value","containerName":"_array_to_string"},{"name":"$i","containerName":"_array_to_string","kind":13,"line":802},{"line":802,"kind":12,"name":"isa","containerName":"_array_to_string"},{"kind":13,"line":803,"name":"$s","containerName":"_array_to_string"},{"kind":13,"line":803,"name":"$i","containerName":"_array_to_string"},{"line":803,"kind":13,"name":"$value","containerName":"_array_to_string"},{"containerName":"_array_to_string","name":"$i","line":803,"kind":13},{"kind":12,"line":803,"name":"authors","containerName":"_array_to_string"},{"kind":13,"line":804,"name":"$s","containerName":"_array_to_string"},{"kind":13,"line":804,"containerName":"_array_to_string","name":"$value"},{"name":"$i","containerName":"_array_to_string","kind":13,"line":804},{"line":804,"kind":12,"name":"title","containerName":"_array_to_string"},{"line":805,"kind":13,"containerName":"_array_to_string","name":"$s"},{"kind":13,"line":805,"name":"$value","containerName":"_array_to_string"},{"name":"$i","containerName":"_array_to_string","line":805,"kind":13},{"kind":12,"line":805,"name":"location","containerName":"_array_to_string"},{"line":807,"kind":13,"containerName":"_array_to_string","name":"$value"},{"kind":13,"line":807,"name":"$i","containerName":"_array_to_string"},{"line":807,"kind":12,"name":"isa","containerName":"_array_to_string"},{"kind":13,"line":808,"name":"$s","containerName":"_array_to_string"},{"line":808,"kind":13,"name":"$i","containerName":"_array_to_string"},{"containerName":"_array_to_string","name":"$value","kind":13,"line":808},{"line":808,"kind":13,"name":"$i","containerName":"_array_to_string"},{"name":"value","containerName":"_array_to_string","kind":12,"line":808},{"name":"$s","containerName":"_array_to_string","kind":13,"line":812}],"kind":12},{"range":{"start":{"character":0,"line":821},"end":{"line":827,"character":9999}},"name":"_is_true_or_false","detail":"($self,$value)","signature":{"label":"_is_true_or_false($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":821,"children":[{"line":822,"kind":13,"localvar":"my","containerName":"_is_true_or_false","name":"$self","definition":"my"},{"containerName":"_is_true_or_false","name":"$value","kind":13,"line":822},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":823},{"containerName":"_is_true_or_false","name":"$value","line":823,"kind":13},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":823},{"containerName":"_is_true_or_false","name":"$self","kind":13,"line":824},{"containerName":"_is_true_or_false","name":"throw","line":824,"kind":12},{"containerName":"_is_true_or_false","name":"$value","line":825,"kind":13}],"kind":12},{"line":823,"kind":12,"name":"TRUE"},{"name":"FALSE","kind":12,"line":823},{"name":"TRUE","kind":12,"line":825},{"name":"FALSE","kind":12,"line":825}]}