{"version":5,"vars":[{"containerName":"","name":"vars","line":116,"kind":2},{"name":"GenPept","containerName":"Carp::Bio::SeqIO::Bio::Seq::Bio::Root::Version::Bio::DB::EMBL::Bio::DB::GenBank::Bio::DB::SwissProt::Bio::DB::RefSeq::Bio::DB","line":131,"kind":2},{"kind":13,"line":132,"containerName":null,"name":"%DBOKAY"},{"containerName":null,"name":"$DBOKAY","kind":13,"line":134},{"containerName":"","name":"base","line":138,"kind":2},{"line":140,"kind":13,"name":"@EXPORT","containerName":null},{"kind":13,"line":145,"containerName":null,"name":"@EXPORT_OK"},{"kind":13,"line":145,"containerName":null,"name":"@EXPORT"},{"kind":12,"line":173,"children":[{"localvar":"my","name":"$filename","definition":"my","containerName":"read_sequence","line":174,"kind":13},{"kind":13,"line":174,"containerName":"read_sequence","name":"$format"},{"line":176,"kind":13,"name":"$filename","containerName":"read_sequence"},{"localvar":"my","definition":"my","name":"$seqio","containerName":"read_sequence","line":180,"kind":13},{"containerName":"read_sequence","name":"$format","line":182,"kind":13},{"line":183,"kind":13,"name":"$seqio","containerName":"read_sequence"},{"name":"new","containerName":"read_sequence","line":183,"kind":12},{"containerName":"read_sequence","name":"$filename","line":183,"kind":13},{"kind":13,"line":183,"name":"$format","containerName":"read_sequence"},{"line":185,"kind":13,"name":"$seqio","containerName":"read_sequence"},{"containerName":"read_sequence","name":"new","line":185,"kind":12},{"line":185,"kind":13,"name":"$filename","containerName":"read_sequence"},{"line":188,"kind":13,"localvar":"my","definition":"my","name":"$seq","containerName":"read_sequence"},{"line":188,"kind":13,"containerName":"read_sequence","name":"$seqio"},{"kind":12,"line":188,"name":"next_seq","containerName":"read_sequence"},{"containerName":"read_sequence","name":"$seq","line":190,"kind":13}],"containerName":"main::","definition":"sub","detail":"($filename,$format)","signature":{"label":"read_sequence($filename,$format)","documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.","parameters":[{"label":"$filename"},{"label":"$format"}]},"name":"read_sequence","range":{"end":{"character":9999,"line":191},"start":{"line":173,"character":0}}},{"kind":12,"line":177,"name":"confess"},{"name":"Bio","containerName":"SeqIO","line":183,"kind":12},{"containerName":"SeqIO","name":"Bio","kind":12,"line":185},{"name":"read_all_sequences","range":{"end":{"line":238,"character":9999},"start":{"character":0,"line":216}},"kind":12,"children":[{"line":217,"kind":13,"localvar":"my","definition":"my","name":"$filename","containerName":"read_all_sequences"},{"line":217,"kind":13,"name":"$format","containerName":"read_all_sequences"},{"containerName":"read_all_sequences","name":"$filename","line":219,"kind":13},{"localvar":"my","containerName":"read_all_sequences","definition":"my","name":"$seqio","line":223,"kind":13},{"containerName":"read_all_sequences","name":"$format","line":225,"kind":13},{"kind":13,"line":226,"name":"$seqio","containerName":"read_all_sequences"},{"containerName":"read_all_sequences","name":"new","line":226,"kind":12},{"name":"$filename","containerName":"read_all_sequences","line":226,"kind":13},{"containerName":"read_all_sequences","name":"$format","line":226,"kind":13},{"containerName":"read_all_sequences","name":"$seqio","line":228,"kind":13},{"kind":12,"line":228,"containerName":"read_all_sequences","name":"new"},{"containerName":"read_all_sequences","name":"$filename","kind":13,"line":228},{"kind":13,"line":231,"containerName":"read_all_sequences","name":"@seq_array","definition":"my","localvar":"my"},{"line":233,"kind":13,"localvar":"my","containerName":"read_all_sequences","definition":"my","name":"$seq"},{"line":233,"kind":13,"containerName":"read_all_sequences","name":"$seqio"},{"containerName":"read_all_sequences","name":"next_seq","line":233,"kind":12},{"kind":13,"line":234,"containerName":"read_all_sequences","name":"@seq_array"},{"name":"$seq","containerName":"read_all_sequences","kind":13,"line":234},{"containerName":"read_all_sequences","name":"@seq_array","kind":13,"line":237}],"line":216,"definition":"sub","containerName":"main::","signature":{"label":"read_all_sequences($filename,$format)","parameters":[{"label":"$filename"},{"label":"$format"}],"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information"},"detail":"($filename,$format)"},{"name":"confess","line":220,"kind":12},{"name":"Bio","containerName":"SeqIO","kind":12,"line":226},{"kind":12,"line":228,"name":"Bio","containerName":"SeqIO"},{"name":"write_sequence","range":{"end":{"character":9999,"line":304},"start":{"character":0,"line":258}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$filename"},{"label":"$format"},{"label":"@sequence_objects"}],"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects","label":"write_sequence($filename,$format,@sequence_objects)"},"detail":"($filename,$format,@sequence_objects)","kind":12,"children":[{"line":259,"kind":13,"localvar":"my","name":"$filename","definition":"my","containerName":"write_sequence"},{"kind":13,"line":259,"containerName":"write_sequence","name":"$format"},{"kind":13,"line":259,"name":"@sequence_objects","containerName":"write_sequence"},{"line":261,"kind":13,"name":"@sequence_objects","containerName":"write_sequence"},{"localvar":"my","containerName":"write_sequence","definition":"my","name":"$error","line":265,"kind":13},{"kind":13,"line":266,"containerName":"write_sequence","name":"$seqname","definition":"my","localvar":"my"},{"kind":13,"line":269,"containerName":"write_sequence","name":"$filename"},{"name":"$filename","containerName":"write_sequence","line":269,"kind":13},{"name":"$filename","containerName":"write_sequence","kind":13,"line":270},{"line":270,"kind":13,"containerName":"write_sequence","name":"$filename"},{"line":273,"kind":13,"localvar":"my","containerName":"write_sequence","name":"$seqio","definition":"my"},{"kind":12,"line":273,"name":"new","containerName":"write_sequence"},{"kind":13,"line":273,"name":"$filename","containerName":"write_sequence"},{"containerName":"write_sequence","name":"$format","kind":13,"line":273},{"line":275,"kind":13,"localvar":"my","containerName":"write_sequence","definition":"my","name":"$seq"},{"containerName":"write_sequence","name":"@sequence_objects","kind":13,"line":275},{"line":276,"kind":13,"localvar":"my","definition":"my","name":"$seq_obj","containerName":"write_sequence"},{"name":"$seq","containerName":"write_sequence","kind":13,"line":278},{"kind":13,"line":279,"containerName":"write_sequence","name":"$seq"},{"kind":13,"line":283,"containerName":"write_sequence","name":"$error"},{"name":"$error","containerName":"write_sequence","kind":13,"line":285},{"name":"$seq_obj","containerName":"write_sequence","kind":13,"line":288},{"line":288,"kind":13,"containerName":"write_sequence","name":"$seq"},{"containerName":"write_sequence","name":"$seqname","line":288,"kind":13},{"containerName":"write_sequence","name":"$seqname","line":289,"kind":13},{"containerName":"write_sequence","name":"$seq","kind":13,"line":294},{"name":"isa","containerName":"write_sequence","line":294,"kind":12},{"containerName":"write_sequence","name":"$seq_obj","line":297,"kind":13},{"name":"$seq","containerName":"write_sequence","kind":13,"line":297},{"name":"$seqio","containerName":"write_sequence","line":301,"kind":13},{"line":301,"kind":12,"name":"write_seq","containerName":"write_sequence"},{"containerName":"write_sequence","name":"$seq_obj","line":301,"kind":13}],"line":258},{"name":"confess","line":262,"kind":12},{"name":"Bio","containerName":"SeqIO","kind":12,"line":273},{"name":"carp","line":284,"kind":12},{"name":"new_sequence","line":288,"kind":12},{"line":291,"kind":12,"name":"confess"},{"name":"confess","line":295,"kind":12},{"name":"new_sequence","range":{"start":{"line":320,"character":0},"end":{"character":9999,"line":334}},"containerName":"main::","definition":"sub","detail":"($seq,$name,$accession)","signature":{"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects\n\n\n\nsub write_sequence{\n   my ($filename,$format,@sequence_objects) = @_;\n\n   if( scalar(@sequence_objects) == 0 ) {\n       confess(\"write_sequence(filename,format,sequence_object)\");\n   }\n\n   my $error = 0;\n   my $seqname = \"sequence1\";\n\n   # catch users who haven't passed us a filename we can open\n   if( $filename !~ /^\\>/ && $filename !~ /^|/ ) {\n       $filename = \">\".$filename;\n   }\n\n   my $seqio = Bio::SeqIO->new('-file' => $filename, '-format' => $format);\n\n   foreach my $seq ( @sequence_objects ) {\n       my $seq_obj;\n\n       if( !ref $seq ) {\n\t   if( length $seq > 50 ) {\n\t       # odds are this is a sequence as a string, and someone has not figured out\n\t       # how to make objects. Warn him/her and then make a sequence object\n\t       # from this\n\t       if( $error == 0 ) {\n\t\t   carp(\"WARNING: You have put in a long string into write_sequence.\\nI suspect this means that this is the actual sequence\\nIn the future try the\\n  new_sequence method of this module to make a new sequence object.\\nDoing this for you here\\n\");\n\t\t   $error = 1;\n\t       }\n\n\t       $seq_obj = new_sequence($seq,$seqname);\n\t       $seqname++;\n\t   } else {\n\t       confess(\"You have a non object [$seq] passed to write_sequence. It maybe that you want to use new_sequence to make this string into a sequence object?\");\n\t   }\n       } else {\n\t   if( !$seq->isa(\"Bio::SeqI\") ) {\n\t       confess(\"object [$seq] is not a Bio::Seq object; can't write it out\");\n\t   }\n\t   $seq_obj = $seq;\n       }\n\n       # finally... we get to write out the sequence!\n       $seqio->write_seq($seq_obj);\n   }\n   1;\n}\n\n=head2 new_sequence\n\n Title   : new_sequence\n Usage   : $seq_obj = new_sequence(\"GATTACA\", \"kino-enzyme\");\n\n Function: Construct a sequency object from sequence string\n Returns : A Bio::Seq object\n\n Args    : sequence string\n           name string (optional, default \"no-name-for-sequence\")\n           accession - accession number (optional, no default)","parameters":[{"label":"$seq"},{"label":"$name"},{"label":"$accession"}],"label":"new_sequence($seq,$name,$accession)"},"kind":12,"line":320,"children":[{"line":321,"kind":13,"localvar":"my","name":"$seq","definition":"my","containerName":"new_sequence"},{"containerName":"new_sequence","name":"$name","kind":13,"line":321},{"containerName":"new_sequence","name":"$accession","kind":13,"line":321},{"line":323,"kind":13,"name":"$seq","containerName":"new_sequence"},{"name":"$name","containerName":"new_sequence","line":327,"kind":13},{"localvar":"my","containerName":"new_sequence","definition":"my","name":"$seq_object","line":329,"kind":13},{"name":"new","containerName":"new_sequence","kind":12,"line":329},{"containerName":"new_sequence","name":"$seq","kind":13,"line":329},{"line":329,"kind":13,"containerName":"new_sequence","name":"$name"},{"kind":13,"line":331,"containerName":"new_sequence","name":"$accession"},{"kind":13,"line":331,"name":"$seq_object","containerName":"new_sequence"},{"kind":12,"line":331,"containerName":"new_sequence","name":"accession_number"},{"name":"$accession","containerName":"new_sequence","line":331,"kind":13},{"name":"$seq_object","containerName":"new_sequence","line":333,"kind":13}]},{"name":"confess","kind":12,"line":324},{"name":"Bio","containerName":"Seq","line":329,"kind":12},{"children":[{"line":358,"kind":13,"localvar":"my","containerName":"blast_sequence","name":"$seq","definition":"my"},{"line":358,"kind":13,"containerName":"blast_sequence","name":"$verbose"},{"kind":13,"line":360,"containerName":"blast_sequence","name":"$verbose"},{"kind":13,"line":361,"name":"$verbose","containerName":"blast_sequence"},{"kind":13,"line":364,"name":"$seq","containerName":"blast_sequence"},{"kind":13,"line":365,"containerName":"blast_sequence","name":"$seq"},{"containerName":"blast_sequence","name":"new","line":365,"kind":12},{"containerName":"blast_sequence","name":"$seq","kind":13,"line":365},{"kind":13,"line":366,"name":"$seq","containerName":"blast_sequence"},{"containerName":"blast_sequence","name":"isa","kind":12,"line":366},{"line":372,"kind":13,"localvar":"my","containerName":"blast_sequence","name":"$prog","definition":"my"},{"containerName":"blast_sequence","name":"$e_val","definition":"my","localvar":"my","kind":13,"line":373},{"localvar":"my","name":"@params","definition":"my","containerName":"blast_sequence","line":375,"kind":13},{"containerName":"blast_sequence","name":"$prog","line":375,"kind":13},{"name":"$e_val","containerName":"blast_sequence","kind":13,"line":376},{"localvar":"my","name":"$factory","definition":"my","containerName":"blast_sequence","line":379,"kind":13},{"name":"new","containerName":"blast_sequence","kind":12,"line":379},{"name":"@params","containerName":"blast_sequence","line":379,"kind":13},{"localvar":"my","definition":"my","name":"$r","containerName":"blast_sequence","line":381,"kind":13},{"name":"$factory","containerName":"blast_sequence","kind":13,"line":381},{"name":"submit_blast","containerName":"blast_sequence","kind":12,"line":381},{"name":"$seq","containerName":"blast_sequence","kind":13,"line":381},{"line":382,"kind":13,"name":"$verbose","containerName":"blast_sequence"},{"name":"$seq","containerName":"blast_sequence","line":383,"kind":13},{"containerName":"blast_sequence","name":"id","kind":12,"line":383},{"line":387,"kind":13,"localvar":"my","definition":"my","name":"$result","containerName":"blast_sequence"},{"line":390,"kind":13,"localvar":"my","containerName":"blast_sequence","name":"@rids","definition":"my"},{"containerName":"blast_sequence","name":"$factory","kind":13,"line":390},{"line":390,"kind":12,"containerName":"blast_sequence","name":"each_rid"},{"containerName":"blast_sequence","definition":"my","name":"$rid","localvar":"my","kind":13,"line":391},{"name":"@rids","containerName":"blast_sequence","line":391,"kind":13},{"containerName":"blast_sequence","name":"$rc","definition":"my","localvar":"my","kind":13,"line":392},{"kind":13,"line":392,"containerName":"blast_sequence","name":"$factory"},{"line":392,"kind":12,"containerName":"blast_sequence","name":"retrieve_blast"},{"name":"$rid","containerName":"blast_sequence","kind":13,"line":392},{"containerName":"blast_sequence","name":"$rc","line":393,"kind":13},{"name":"$rc","containerName":"blast_sequence","kind":13,"line":394},{"name":"$factory","containerName":"blast_sequence","line":395,"kind":13},{"containerName":"blast_sequence","name":"remove_rid","kind":12,"line":395},{"name":"$rid","containerName":"blast_sequence","kind":13,"line":395},{"name":"$verbose","containerName":"blast_sequence","kind":13,"line":397},{"kind":13,"line":402,"name":"$result","containerName":"blast_sequence"},{"kind":13,"line":402,"containerName":"blast_sequence","name":"$rc"},{"containerName":"blast_sequence","name":"next_result","kind":12,"line":402},{"kind":13,"line":403,"containerName":"blast_sequence","name":"$factory"},{"line":403,"kind":12,"name":"remove_rid","containerName":"blast_sequence"},{"name":"$rid","containerName":"blast_sequence","line":403,"kind":13},{"kind":13,"line":409,"containerName":"blast_sequence","name":"$verbose"},{"name":"$result","containerName":"blast_sequence","kind":13,"line":412}],"line":357,"kind":12,"range":{"end":{"character":9999,"line":413},"start":{"character":0,"line":357}},"definition":"sub","name":"blast_sequence","containerName":"main::"},{"containerName":"Seq","name":"Bio","line":365,"kind":12},{"line":367,"kind":12,"name":"croak"},{"line":372,"kind":12,"containerName":"Tools::Run::RemoteBlast","name":"Bio"},{"line":379,"kind":12,"containerName":"Tools::Run::RemoteBlast","name":"Bio"},{"kind":12,"line":389,"name":"LOOP"},{"name":"LOOP","kind":12,"line":404},{"range":{"start":{"character":0,"line":431},"end":{"line":442,"character":9999}},"name":"write_blast","detail":"($filename,$blast)","signature":{"label":"write_blast($filename,$blast)","documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects\n\n\n\nsub write_sequence{\n   my ($filename,$format,@sequence_objects) = @_;\n\n   if( scalar(@sequence_objects) == 0 ) {\n       confess(\"write_sequence(filename,format,sequence_object)\");\n   }\n\n   my $error = 0;\n   my $seqname = \"sequence1\";\n\n   # catch users who haven't passed us a filename we can open\n   if( $filename !~ /^\\>/ && $filename !~ /^|/ ) {\n       $filename = \">\".$filename;\n   }\n\n   my $seqio = Bio::SeqIO->new('-file' => $filename, '-format' => $format);\n\n   foreach my $seq ( @sequence_objects ) {\n       my $seq_obj;\n\n       if( !ref $seq ) {\n\t   if( length $seq > 50 ) {\n\t       # odds are this is a sequence as a string, and someone has not figured out\n\t       # how to make objects. Warn him/her and then make a sequence object\n\t       # from this\n\t       if( $error == 0 ) {\n\t\t   carp(\"WARNING: You have put in a long string into write_sequence.\\nI suspect this means that this is the actual sequence\\nIn the future try the\\n  new_sequence method of this module to make a new sequence object.\\nDoing this for you here\\n\");\n\t\t   $error = 1;\n\t       }\n\n\t       $seq_obj = new_sequence($seq,$seqname);\n\t       $seqname++;\n\t   } else {\n\t       confess(\"You have a non object [$seq] passed to write_sequence. It maybe that you want to use new_sequence to make this string into a sequence object?\");\n\t   }\n       } else {\n\t   if( !$seq->isa(\"Bio::SeqI\") ) {\n\t       confess(\"object [$seq] is not a Bio::Seq object; can't write it out\");\n\t   }\n\t   $seq_obj = $seq;\n       }\n\n       # finally... we get to write out the sequence!\n       $seqio->write_seq($seq_obj);\n   }\n   1;\n}\n\n=head2 new_sequence\n\n Title   : new_sequence\n Usage   : $seq_obj = new_sequence(\"GATTACA\", \"kino-enzyme\");\n\n Function: Construct a sequency object from sequence string\n Returns : A Bio::Seq object\n\n Args    : sequence string\n           name string (optional, default \"no-name-for-sequence\")\n           accession - accession number (optional, no default)\n\n\nsub new_sequence{\n   my ($seq,$name,$accession) = @_;\n\n   if( !defined $seq ) {\n       confess(\"new_sequence(sequence_as_string) usage\");\n   }\n\n   $name ||= \"no-name-for-sequence\";\n\n   my $seq_object = Bio::Seq->new( -seq => $seq, -id => $name);\n\n   $accession && $seq_object->accession_number($accession);\n\n   return $seq_object;\n}\n\n=head2 blast_sequence\n\n Title   : blast_sequence\n Usage   : $blast_result = blast_sequence($seq)\n           $blast_result = blast_sequence('MFVEGGTFASEDDDSASAEDE');\n\n Function: If the computer has Internet accessibility, blasts\n           the sequence using the NCBI BLAST server against nrdb.\n\n           It chooses the flavour of BLAST on the basis of the sequence.\n\n           This function uses Bio::Tools::Run::RemoteBlast, which itself\n           use Bio::SearchIO - as soon as you want to know more, check out\n           these modules\n Returns : Bio::Search::Result::GenericResult.pm\n\n Args    : Either a string of protein letters or nucleotides, or a\n           Bio::Seq object\n\n\nsub blast_sequence {\n    my ($seq,$verbose) = shift;\n\n    if( !defined $verbose ) {\n\t$verbose = 1;\n    }\n\n    if( !ref $seq ) {\n\t$seq = Bio::Seq->new( -seq => $seq, -id => 'blast-sequence-temp-id');\n    } elsif ( !$seq->isa('Bio::PrimarySeqI') ) {\n\tcroak(\"[$seq] is an object, but not a Bio::Seq object, cannot be blasted\");\n    }\n\n    require Bio::Tools::Run::RemoteBlast;\n\n    my $prog = 'blastp';\n    my $e_val= '1e-10';\n\n    my @params = ( '-prog' => $prog,\n\t\t   '-expect' => $e_val,\n\t\t   '-readmethod' => 'SearchIO' );\n\n    my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n    my $r = $factory->submit_blast($seq);\n    if( $verbose ) {\n\tprint STDERR \"Submitted Blast for [\".$seq->id.\"] \";\n    }\n    sleep 5;\n\n    my $result;\n\n    LOOP :\n    while( my @rids = $factory->each_rid) {\n\tforeach my $rid ( @rids ) {\n\t    my $rc = $factory->retrieve_blast($rid);\n\t    if( !ref($rc) ) {\n\t\tif( $rc < 0 ) {\n\t\t    $factory->remove_rid($rid);\n\t\t}\n\t\tif( $verbose ) {\n\t\t    print STDERR \".\";\n\t\t}\n\t\tsleep 10;\n\t    } else {\n\t\t$result = $rc->next_result();\n\t\t$factory->remove_rid($rid);\n\t\tlast LOOP;\n\t    }\n\t}\n    }\n\n    if( $verbose ) {\n\tprint STDERR \"\\n\";\n    }\n    return $result;\n}\n\n=head2 write_blast\n\n Title   : write_blast\n Usage   : write_blast($filename,$blast_report);\n\n Function: Writes a BLAST result object (or more formally\n           a SearchIO result object) out to a filename\n           in BLAST-like format\n\n Returns : none\n\n Args    : filename as a string\n           Bio::SearchIO::Results object","parameters":[{"label":"$filename"},{"label":"$blast"}]},"containerName":"main::","definition":"sub","line":431,"children":[{"kind":13,"line":432,"containerName":"write_blast","name":"$filename","definition":"my","localvar":"my"},{"line":432,"kind":13,"name":"$blast","containerName":"write_blast"},{"name":"$filename","containerName":"write_blast","kind":13,"line":434},{"containerName":"write_blast","name":"$filename","line":434,"kind":13},{"name":"$filename","containerName":"write_blast","kind":13,"line":435},{"line":435,"kind":13,"name":"$filename","containerName":"write_blast"},{"kind":13,"line":438,"definition":"my","name":"$output","containerName":"write_blast","localvar":"my"},{"name":"new","containerName":"write_blast","kind":12,"line":438},{"name":"$filename","containerName":"write_blast","line":438,"kind":13},{"line":440,"kind":13,"name":"$output","containerName":"write_blast"},{"containerName":"write_blast","name":"write_result","kind":12,"line":440},{"kind":13,"line":440,"containerName":"write_blast","name":"$blast"}],"kind":12},{"containerName":"SearchIO","name":"Bio","kind":12,"line":438},{"localvar":"my","containerName":null,"definition":"my","name":"$genbank_db","line":466,"kind":13},{"line":467,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$genpept_db"},{"definition":"my","name":"$embl_db","containerName":null,"localvar":"my","kind":13,"line":468},{"kind":13,"line":469,"definition":"my","name":"$swiss_db","containerName":null,"localvar":"my"},{"line":470,"kind":13,"localvar":"my","definition":"my","name":"$refseq_db","containerName":null},{"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$db_type"},{"label":"$identifier"}],"label":"get_sequence($db_type,$identifier)"},"detail":"($db_type,$identifier)","kind":12,"children":[{"localvar":"my","name":"$db_type","definition":"my","containerName":"get_sequence","line":473,"kind":13},{"name":"$identifier","containerName":"get_sequence","kind":13,"line":473},{"line":474,"kind":13,"containerName":"get_sequence","name":"$DBOKAY"},{"line":478,"kind":13,"containerName":"get_sequence","name":"$db_type"},{"line":478,"kind":13,"name":"$db_type","containerName":"get_sequence"},{"containerName":"get_sequence","definition":"my","name":"$db","localvar":"my","kind":13,"line":480},{"kind":13,"line":482,"name":"$db_type","containerName":"get_sequence"},{"kind":13,"line":483,"name":"$genbank_db","containerName":"get_sequence"},{"kind":13,"line":484,"name":"$genbank_db","containerName":"get_sequence"},{"name":"new","containerName":"get_sequence","line":484,"kind":12},{"containerName":"get_sequence","name":"$db","line":486,"kind":13},{"kind":13,"line":486,"containerName":"get_sequence","name":"$genbank_db"},{"name":"$db_type","containerName":"get_sequence","kind":13,"line":488},{"name":"$genpept_db","containerName":"get_sequence","kind":13,"line":489},{"kind":13,"line":490,"containerName":"get_sequence","name":"$genpept_db"},{"name":"new","containerName":"get_sequence","line":490,"kind":12},{"name":"$db","containerName":"get_sequence","line":492,"kind":13},{"line":492,"kind":13,"containerName":"get_sequence","name":"$genpept_db"},{"containerName":"get_sequence","name":"$db_type","line":495,"kind":13},{"kind":13,"line":496,"containerName":"get_sequence","name":"$swiss_db"},{"line":497,"kind":13,"name":"$swiss_db","containerName":"get_sequence"},{"containerName":"get_sequence","name":"new","line":497,"kind":12},{"containerName":"get_sequence","name":"$db","kind":13,"line":499},{"containerName":"get_sequence","name":"$swiss_db","kind":13,"line":499},{"kind":13,"line":502,"containerName":"get_sequence","name":"$db_type"},{"containerName":"get_sequence","name":"$embl_db","line":503,"kind":13},{"containerName":"get_sequence","name":"$embl_db","kind":13,"line":504},{"name":"new","containerName":"get_sequence","kind":12,"line":504},{"containerName":"get_sequence","name":"$db","line":506,"kind":13},{"line":506,"kind":13,"containerName":"get_sequence","name":"$embl_db"},{"name":"$db_type","containerName":"get_sequence","kind":13,"line":509},{"containerName":"get_sequence","name":"$db_type","line":509,"kind":13},{"containerName":"get_sequence","name":"$identifier","kind":13,"line":510},{"name":"$refseq_db","containerName":"get_sequence","line":511,"kind":13},{"line":512,"kind":13,"name":"$refseq_db","containerName":"get_sequence"},{"name":"new","containerName":"get_sequence","kind":12,"line":512},{"name":"$db","containerName":"get_sequence","kind":13,"line":514},{"kind":13,"line":514,"name":"$refseq_db","containerName":"get_sequence"},{"line":517,"kind":13,"localvar":"my","containerName":"get_sequence","definition":"my","name":"$seq"},{"containerName":"get_sequence","name":"$identifier","kind":13,"line":519},{"kind":13,"line":520,"name":"$seq","containerName":"get_sequence"},{"name":"$db","containerName":"get_sequence","line":520,"kind":13},{"kind":12,"line":520,"containerName":"get_sequence","name":"get_Seq_by_acc"},{"name":"$identifier","containerName":"get_sequence","line":520,"kind":13},{"name":"$seq","containerName":"get_sequence","line":522,"kind":13},{"kind":13,"line":522,"containerName":"get_sequence","name":"$db"},{"containerName":"get_sequence","name":"get_Seq_by_id","line":522,"kind":12},{"name":"$identifier","containerName":"get_sequence","kind":13,"line":522},{"kind":13,"line":525,"containerName":"get_sequence","name":"$seq"}],"line":472,"name":"get_sequence","range":{"start":{"line":472,"character":0},"end":{"character":9999,"line":526}}},{"name":"confess","kind":12,"line":475},{"containerName":"DB::GenBank","name":"Bio","line":484,"kind":12},{"name":"Bio","containerName":"DB::GenPept","kind":12,"line":490},{"containerName":"DB::SwissProt","name":"Bio","line":497,"kind":12},{"name":"Bio","containerName":"DB::EMBL","line":504,"kind":12},{"kind":12,"line":512,"name":"Bio","containerName":"DB::RefSeq"},{"kind":12,"line":543,"children":[{"kind":13,"line":544,"name":"$scalar","definition":"my","containerName":"translate","localvar":"my"},{"localvar":"my","containerName":"translate","definition":"my","name":"$obj","line":546,"kind":13},{"containerName":"translate","name":"$scalar","line":548,"kind":13},{"kind":13,"line":549,"name":"$scalar","containerName":"translate"},{"name":"isa","containerName":"translate","kind":12,"line":549},{"line":552,"kind":13,"name":"$obj","containerName":"translate"},{"kind":13,"line":552,"name":"$scalar","containerName":"translate"},{"line":559,"kind":13,"localvar":"my","containerName":"translate","definition":"my","name":"$n"},{"kind":13,"line":559,"name":"$scalar","containerName":"translate"},{"containerName":"translate","name":"$n","line":561,"kind":13},{"containerName":"translate","name":"$scalar","line":561,"kind":13},{"containerName":"translate","name":"$obj","kind":13,"line":565},{"kind":12,"line":565,"name":"new","containerName":"translate"},{"line":565,"kind":13,"containerName":"translate","name":"$scalar"},{"kind":13,"line":568,"containerName":"translate","name":"$obj"},{"kind":12,"line":568,"name":"translate","containerName":"translate"}],"containerName":"main::","definition":"sub","name":"translate","range":{"end":{"character":9999,"line":569},"start":{"line":543,"character":0}}},{"name":"confess","line":550,"kind":12},{"name":"confess","line":562,"kind":12},{"name":"Bio","containerName":"PrimarySeq","kind":12,"line":565},{"range":{"start":{"line":586,"character":0},"end":{"character":9999,"line":592}},"containerName":"main::","name":"translate_as_string","definition":"sub","line":586,"children":[{"line":587,"kind":13,"localvar":"my","containerName":"translate_as_string","name":"$scalar","definition":"my"},{"definition":"my","name":"$obj","containerName":"translate_as_string","localvar":"my","kind":13,"line":589},{"name":"$scalar","containerName":"translate_as_string","line":589,"kind":13},{"containerName":"translate_as_string","name":"$obj","line":591,"kind":13},{"kind":12,"line":591,"name":"seq","containerName":"translate_as_string"}],"kind":12},{"name":"Bio","containerName":"Perl::translate","line":589,"kind":12},{"range":{"start":{"character":0,"line":610},"end":{"line":636,"character":9999}},"containerName":"main::","name":"reverse_complement","definition":"sub","line":610,"children":[{"localvar":"my","definition":"my","name":"$scalar","containerName":"reverse_complement","line":611,"kind":13},{"localvar":"my","containerName":"reverse_complement","name":"$obj","definition":"my","line":613,"kind":13},{"containerName":"reverse_complement","name":"$scalar","line":615,"kind":13},{"containerName":"reverse_complement","name":"$scalar","line":616,"kind":13},{"kind":12,"line":616,"containerName":"reverse_complement","name":"isa"},{"kind":13,"line":619,"containerName":"reverse_complement","name":"$obj"},{"name":"$scalar","containerName":"reverse_complement","kind":13,"line":619},{"line":626,"kind":13,"localvar":"my","name":"$n","definition":"my","containerName":"reverse_complement"},{"line":626,"kind":13,"name":"$scalar","containerName":"reverse_complement"},{"kind":13,"line":628,"name":"$n","containerName":"reverse_complement"},{"name":"$scalar","containerName":"reverse_complement","kind":13,"line":628},{"kind":13,"line":632,"name":"$obj","containerName":"reverse_complement"},{"kind":12,"line":632,"name":"new","containerName":"reverse_complement"},{"line":632,"kind":13,"containerName":"reverse_complement","name":"$scalar"},{"line":635,"kind":13,"name":"$obj","containerName":"reverse_complement"},{"kind":12,"line":635,"name":"revcom","containerName":"reverse_complement"}],"kind":12},{"name":"confess","kind":12,"line":617},{"name":"confess","line":629,"kind":12},{"kind":12,"line":632,"containerName":"PrimarySeq","name":"Bio"},{"range":{"start":{"character":0,"line":655},"end":{"character":9999,"line":657}},"name":"revcom","definition":"sub","containerName":"main::","children":[],"line":655,"kind":12},{"containerName":"Perl::reverse_complement","name":"Bio","line":656,"kind":12},{"range":{"start":{"character":0,"line":674},"end":{"character":9999,"line":680}},"definition":"sub","name":"reverse_complement_as_string","containerName":"main::","children":[{"containerName":"reverse_complement_as_string","name":"$scalar","definition":"my","localvar":"my","kind":13,"line":675},{"kind":13,"line":677,"name":"$obj","definition":"my","containerName":"reverse_complement_as_string","localvar":"my"},{"name":"$scalar","containerName":"reverse_complement_as_string","kind":13,"line":677},{"containerName":"reverse_complement_as_string","name":"$obj","line":679,"kind":13},{"line":679,"kind":12,"containerName":"reverse_complement_as_string","name":"seq"}],"line":674,"kind":12},{"line":677,"kind":12,"containerName":"Perl::reverse_complement","name":"Bio"},{"kind":12,"line":697,"children":[{"localvar":"my","definition":"my","name":"$scalar","containerName":"revcom_as_string","line":698,"kind":13},{"localvar":"my","name":"$obj","definition":"my","containerName":"revcom_as_string","line":700,"kind":13},{"containerName":"revcom_as_string","name":"$scalar","kind":13,"line":700},{"containerName":"revcom_as_string","name":"$obj","kind":13,"line":702},{"containerName":"revcom_as_string","name":"seq","line":702,"kind":12}],"containerName":"main::","definition":"sub","name":"revcom_as_string","range":{"start":{"character":0,"line":697},"end":{"character":9999,"line":703}}},{"kind":12,"line":700,"containerName":"Perl::reverse_complement","name":"Bio"}]}