{"version":5,"vars":[{"line":94,"kind":2,"name":"base","containerName":""},{"line":96,"kind":13,"localvar":"my","containerName":null,"name":"$record_count","definition":"my"},{"line":96,"kind":13,"containerName":null,"name":"$processed_count"},{"line":96,"kind":13,"containerName":null,"name":"$is_a_rel"},{"kind":13,"line":96,"containerName":null,"name":"$contains_rel"},{"kind":13,"line":96,"containerName":null,"name":"$found_in_rel"},{"signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"line":111,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$class"},{"line":111,"kind":13,"containerName":"new","name":"@args"},{"line":112,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"new"},{"line":112,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":112,"containerName":"new","name":"@args"},{"definition":"my","name":"$eng","containerName":"new","localvar":"my","kind":13,"line":114},{"kind":13,"line":114,"containerName":"new","name":"$ont"},{"containerName":"new","name":"$name","line":114,"kind":13},{"line":114,"kind":13,"name":"$fact","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":115},{"name":"_rearrange","containerName":"new","kind":12,"line":115},{"containerName":"new","name":"@args","kind":13,"line":119},{"line":121,"kind":13,"containerName":"new","name":"$ont"},{"name":"$self","containerName":"new","line":122,"kind":13},{"name":"ontology","containerName":"new","kind":12,"line":122},{"name":"$ont","containerName":"new","kind":13,"line":122},{"name":"$name","containerName":"new","line":124,"kind":13},{"line":124,"kind":13,"containerName":"new","name":"$name"},{"line":125,"kind":13,"name":"$self","containerName":"new"},{"line":125,"kind":12,"containerName":"new","name":"ontology"},{"line":125,"kind":12,"containerName":"new","name":"new"},{"line":125,"kind":13,"name":"$name","containerName":"new"},{"line":127,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"ontology_engine","kind":12,"line":127},{"name":"$eng","containerName":"new","kind":13,"line":127},{"containerName":"new","name":"$eng","line":127,"kind":13},{"kind":13,"line":129,"name":"$self","containerName":"new"},{"containerName":"new","name":"term_factory","line":129,"kind":12},{"containerName":"new","name":"$fact","line":129,"kind":13},{"kind":13,"line":129,"name":"$fact","containerName":"new"},{"containerName":"new","name":"$is_a_rel","line":131,"kind":13},{"line":131,"kind":12,"containerName":"new","name":"get_instance"},{"name":"$contains_rel","containerName":"new","kind":13,"line":132},{"kind":12,"line":132,"name":"get_instance","containerName":"new"},{"line":133,"kind":13,"name":"$found_in_rel","containerName":"new"},{"kind":12,"line":133,"name":"get_instance","containerName":"new"},{"line":134,"kind":13,"containerName":"new","name":"$is_a_rel"},{"kind":12,"line":134,"name":"ontology","containerName":"new"},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"kind":12,"line":134,"containerName":"new","name":"ontology"},{"line":135,"kind":13,"containerName":"new","name":"$contains_rel"},{"line":135,"kind":12,"containerName":"new","name":"ontology"},{"name":"$self","containerName":"new","line":135,"kind":13},{"line":135,"kind":12,"containerName":"new","name":"ontology"},{"line":136,"kind":13,"name":"$found_in_rel","containerName":"new"},{"containerName":"new","name":"ontology","kind":12,"line":136},{"name":"$self","containerName":"new","line":136,"kind":13},{"line":136,"kind":12,"containerName":"new","name":"ontology"},{"kind":13,"line":137,"containerName":"new","name":"$self"},{"line":137,"kind":12,"name":"_cite_skip","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":138},{"kind":12,"line":138,"name":"secondary_accessions_map","containerName":"new"},{"line":140,"kind":13,"name":"$self","containerName":"new"}],"line":110,"kind":12,"range":{"start":{"line":110,"character":0},"end":{"character":9999,"line":141}},"name":"new"},{"line":112,"kind":12,"name":"SUPER","containerName":"new"},{"name":"Bio","containerName":"Ontology::Ontology","line":125,"kind":12},{"kind":12,"line":131,"name":"Bio","containerName":"Ontology::RelationshipType"},{"line":132,"kind":12,"containerName":"Ontology::RelationshipType","name":"Bio"},{"name":"Bio","containerName":"Ontology::RelationshipType","kind":12,"line":133},{"definition":"sub","containerName":"main::","signature":{"label":"ontology_engine($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":156,"definition":"my","name":"$self","containerName":"ontology_engine","localvar":"my"},{"line":156,"kind":13,"name":"$value","containerName":"ontology_engine"},{"containerName":"ontology_engine","name":"$value","kind":13,"line":158},{"containerName":"ontology_engine","name":"$self","kind":13,"line":159},{"name":"$self","containerName":"ontology_engine","line":160,"kind":13},{"kind":12,"line":160,"containerName":"ontology_engine","name":"throw"},{"kind":13,"line":162,"containerName":"ontology_engine","name":"$self"},{"line":162,"kind":12,"name":"throw","containerName":"ontology_engine"},{"name":"$value","containerName":"ontology_engine","kind":13,"line":162},{"line":164,"kind":13,"containerName":"ontology_engine","name":"$value"},{"name":"isa","containerName":"ontology_engine","kind":12,"line":164},{"kind":13,"line":165,"name":"$self","containerName":"ontology_engine"},{"name":"$value","containerName":"ontology_engine","kind":13,"line":165},{"name":"$ont","definition":"my","containerName":"ontology_engine","localvar":"my","kind":13,"line":169},{"containerName":"ontology_engine","name":"$self","kind":13,"line":169},{"name":"ontology","containerName":"ontology_engine","kind":12,"line":169},{"name":"$ont","containerName":"ontology_engine","line":170,"kind":13},{"containerName":"ontology_engine","name":"$ont","kind":13,"line":170},{"containerName":"ontology_engine","name":"can","line":170,"kind":12},{"containerName":"ontology_engine","name":"$ont","line":170,"kind":13},{"kind":12,"line":170,"name":"engine","containerName":"ontology_engine"},{"kind":13,"line":171,"name":"$ont","containerName":"ontology_engine"},{"line":171,"kind":12,"containerName":"ontology_engine","name":"engine"},{"containerName":"ontology_engine","name":"$value","line":171,"kind":13},{"name":"$self","containerName":"ontology_engine","line":174,"kind":13},{"name":"debug","containerName":"ontology_engine","kind":12,"line":174},{"kind":13,"line":174,"containerName":"ontology_engine","name":"$self"},{"containerName":"ontology_engine","name":"$value","line":176,"kind":13},{"name":"$value","containerName":"ontology_engine","line":177,"kind":13},{"containerName":"ontology_engine","name":"to_string","kind":12,"line":177},{"line":181,"kind":13,"containerName":"ontology_engine","name":"$self"}],"line":155,"name":"ontology_engine","range":{"end":{"character":9999,"line":182},"start":{"character":0,"line":155}}},{"range":{"start":{"character":0,"line":199},"end":{"line":209,"character":9999}},"name":"ontology","detail":"($self,$ont)","signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.","parameters":[{"label":"$self"},{"label":"$ont"}],"label":"ontology($self,$ont)"},"containerName":"main::","definition":"sub","line":199,"children":[{"kind":13,"line":200,"definition":"my","name":"$self","containerName":"ontology","localvar":"my"},{"line":200,"kind":13,"name":"$ont","containerName":"ontology"},{"line":202,"kind":13,"containerName":"ontology","name":"$ont"},{"kind":13,"line":203,"name":"$self","containerName":"ontology"},{"name":"throw","containerName":"ontology","line":203,"kind":12},{"containerName":"ontology","name":"$ont","kind":13,"line":203},{"name":"$ont","containerName":"ontology","line":205,"kind":13},{"name":"isa","containerName":"ontology","line":205,"kind":12},{"containerName":"ontology","name":"$self","line":206,"kind":13},{"line":206,"kind":13,"name":"$ont","containerName":"ontology"},{"line":208,"kind":13,"containerName":"ontology","name":"$self"}],"kind":12},{"containerName":"main::","definition":"sub","name":"term_factory","range":{"end":{"character":9999,"line":229},"start":{"line":224,"character":0}},"kind":12,"line":224,"children":[{"kind":13,"line":225,"name":"$self","definition":"my","containerName":"term_factory","localvar":"my"},{"name":"$self","containerName":"term_factory","kind":13,"line":227},{"name":"$self","containerName":"term_factory","line":228,"kind":13}]},{"range":{"start":{"line":243,"character":0},"end":{"character":9999,"line":251}},"name":"_cite_skip","line":243,"children":[{"containerName":"_cite_skip","name":"$self","definition":"my","localvar":"my","kind":13,"line":244},{"line":244,"kind":13,"containerName":"_cite_skip","name":"$value"},{"line":246,"kind":13,"containerName":"_cite_skip","name":"$value"},{"line":247,"kind":13,"name":"$self","containerName":"_cite_skip"},{"containerName":"_cite_skip","name":"$value","line":247,"kind":13},{"containerName":"_cite_skip","name":"$self","kind":13,"line":250}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_cite_skip($self,$value)"},"containerName":"main::","definition":"sub"},{"range":{"end":{"character":9999,"line":273},"start":{"line":265,"character":0}},"name":"_hash","detail":"($self,$value)","signature":{"label":"_hash($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":265,"children":[{"definition":"my","name":"$self","containerName":"_hash","localvar":"my","kind":13,"line":266},{"line":266,"kind":13,"name":"$value","containerName":"_hash"},{"name":"$value","containerName":"_hash","kind":13,"line":268},{"name":"$self","containerName":"_hash","kind":13,"line":269},{"name":"$value","containerName":"_hash","kind":13,"line":269},{"line":272,"kind":13,"containerName":"_hash","name":"$self"}],"kind":12},{"name":"_stack","range":{"end":{"character":9999,"line":294},"start":{"line":287,"character":0}},"kind":12,"line":287,"children":[{"line":288,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_stack"},{"containerName":"_stack","name":"$value","kind":13,"line":288},{"containerName":"_stack","name":"$value","kind":13,"line":290},{"line":291,"kind":13,"containerName":"_stack","name":"$self"},{"containerName":"_stack","name":"$value","kind":13,"line":291},{"kind":13,"line":293,"containerName":"_stack","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)","label":"_stack($self,$value)"}},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$_stack"}],"label":"_top($self,$_stack)"},"detail":"($self,$_stack)","kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_top","line":309,"kind":13},{"containerName":"_top","name":"$_stack","line":309,"kind":13},{"line":310,"kind":13,"localvar":"my","definition":"my","name":"@stack","containerName":"_top"},{"line":310,"kind":13,"containerName":"_top","name":"$_stack"}],"line":308,"name":"_top","range":{"start":{"line":308,"character":0},"end":{"line":310,"character":9999}}},{"name":"@stack","containerName":null,"kind":13,"line":312},{"kind":13,"line":312,"containerName":null,"name":"@stack"},{"name":"@stack","containerName":null,"line":312,"kind":13},{"range":{"start":{"line":327,"character":0},"end":{"character":9999,"line":335}},"name":"_term","line":327,"children":[{"line":328,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_term"},{"kind":13,"line":328,"name":"$value","containerName":"_term"},{"kind":13,"line":330,"name":"$value","containerName":"_term"},{"kind":13,"line":331,"name":"$self","containerName":"_term"},{"line":331,"kind":13,"name":"$value","containerName":"_term"},{"line":334,"kind":13,"name":"$self","containerName":"_term"}],"kind":12,"detail":"($self,$value)","signature":{"label":"_term($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"_clear_term($self)"},"kind":12,"line":349,"children":[{"kind":13,"line":350,"containerName":"_clear_term","name":"$self","definition":"my","localvar":"my"},{"containerName":"_clear_term","name":"$self","kind":13,"line":352}],"name":"_clear_term","range":{"end":{"character":9999,"line":353},"start":{"character":0,"line":349}}},{"name":"_names","range":{"start":{"character":0,"line":367},"end":{"character":9999,"line":375}},"kind":12,"line":367,"children":[{"kind":13,"line":368,"name":"$self","definition":"my","containerName":"_names","localvar":"my"},{"line":368,"kind":13,"name":"$value","containerName":"_names"},{"containerName":"_names","name":"$value","kind":13,"line":370},{"containerName":"_names","name":"$self","kind":13,"line":371},{"kind":13,"line":371,"containerName":"_names","name":"$value"},{"kind":13,"line":374,"name":"$self","containerName":"_names"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"_names($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]}},{"signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$ref_id"},{"label":"$rel_type_term"}],"label":"_create_relationship($self,$ref_id,$rel_type_term)"},"detail":"($self,$ref_id,$rel_type_term)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":390,"containerName":"_create_relationship","definition":"my","name":"$self","localvar":"my"},{"line":390,"kind":13,"name":"$ref_id","containerName":"_create_relationship"},{"line":390,"kind":13,"name":"$rel_type_term","containerName":"_create_relationship"},{"containerName":"_create_relationship","name":"$ont","definition":"my","localvar":"my","kind":13,"line":391},{"name":"$self","containerName":"_create_relationship","line":391,"kind":13},{"containerName":"_create_relationship","name":"ontology","kind":12,"line":391},{"containerName":"_create_relationship","name":"$fact","definition":"my","localvar":"my","kind":13,"line":392},{"kind":13,"line":392,"containerName":"_create_relationship","name":"$self"},{"kind":12,"line":392,"name":"term_factory","containerName":"_create_relationship"},{"kind":13,"line":393,"name":"$term_temp","definition":"my","containerName":"_create_relationship","localvar":"my"},{"kind":13,"line":393,"containerName":"_create_relationship","name":"$ont"},{"name":"engine","containerName":"_create_relationship","line":393,"kind":12},{"name":"get_term_by_identifier","containerName":"_create_relationship","kind":12,"line":393},{"line":393,"kind":13,"name":"$ref_id","containerName":"_create_relationship"},{"line":395,"kind":13,"localvar":"my","containerName":"_create_relationship","definition":"my","name":"$rel"},{"line":395,"kind":12,"containerName":"_create_relationship","name":"new"},{"containerName":"_create_relationship","name":"$rel_type_term","kind":13,"line":395},{"containerName":"_create_relationship","name":"$term_temp","line":397,"kind":13},{"containerName":"_create_relationship","name":"$term_temp","kind":13,"line":398},{"containerName":"_create_relationship","name":"$ont","line":398,"kind":13},{"containerName":"_create_relationship","name":"engine","line":398,"kind":12},{"kind":12,"line":398,"name":"add_term","containerName":"_create_relationship"},{"kind":13,"line":398,"containerName":"_create_relationship","name":"$fact"},{"kind":12,"line":398,"containerName":"_create_relationship","name":"create_object"},{"name":"$ref_id","containerName":"_create_relationship","line":398,"kind":13},{"line":398,"kind":13,"name":"$ref_id","containerName":"_create_relationship"},{"line":398,"kind":13,"containerName":"_create_relationship","name":"$ont"},{"kind":13,"line":399,"name":"$ont","containerName":"_create_relationship"},{"line":399,"kind":12,"containerName":"_create_relationship","name":"engine"},{"containerName":"_create_relationship","name":"mark_uninstantiated","kind":12,"line":399},{"name":"$term_temp","containerName":"_create_relationship","line":399,"kind":13},{"containerName":"_create_relationship","definition":"my","name":"$rel_type_name","localvar":"my","kind":13,"line":401},{"line":401,"kind":13,"name":"$self","containerName":"_create_relationship"},{"kind":12,"line":401,"containerName":"_create_relationship","name":"_top"},{"line":401,"kind":13,"containerName":"_create_relationship","name":"$self"},{"line":401,"kind":12,"name":"_names","containerName":"_create_relationship"},{"line":403,"kind":13,"containerName":"_create_relationship","name":"$rel_type_name"},{"line":403,"kind":13,"containerName":"_create_relationship","name":"$rel_type_name"},{"kind":13,"line":404,"name":"$rel","containerName":"_create_relationship"},{"kind":12,"line":404,"name":"object_term","containerName":"_create_relationship"},{"line":404,"kind":13,"containerName":"_create_relationship","name":"$term_temp"},{"line":405,"kind":13,"name":"$rel","containerName":"_create_relationship"},{"containerName":"_create_relationship","name":"subject_term","kind":12,"line":405},{"name":"$self","containerName":"_create_relationship","kind":13,"line":405},{"containerName":"_create_relationship","name":"_term","kind":12,"line":405},{"containerName":"_create_relationship","name":"$rel","kind":13,"line":407},{"containerName":"_create_relationship","name":"object_term","kind":12,"line":407},{"kind":13,"line":407,"containerName":"_create_relationship","name":"$self"},{"containerName":"_create_relationship","name":"_term","line":407,"kind":12},{"name":"$rel","containerName":"_create_relationship","kind":13,"line":408},{"kind":12,"line":408,"name":"subject_term","containerName":"_create_relationship"},{"line":408,"kind":13,"containerName":"_create_relationship","name":"$term_temp"},{"containerName":"_create_relationship","name":"$rel","kind":13,"line":410},{"kind":12,"line":410,"name":"ontology","containerName":"_create_relationship"},{"containerName":"_create_relationship","name":"$ont","kind":13,"line":410},{"line":411,"kind":13,"containerName":"_create_relationship","name":"$ont"},{"name":"add_relationship","containerName":"_create_relationship","kind":12,"line":411},{"name":"$rel","containerName":"_create_relationship","line":411,"kind":13}],"line":389,"kind":12,"range":{"start":{"character":0,"line":389},"end":{"character":9999,"line":412}},"name":"_create_relationship"},{"line":395,"kind":12,"containerName":"Ontology::Relationship","name":"Bio"},{"definition":"sub","containerName":"main::","signature":{"label":"start_element($self,$element)","parameters":[{"label":"$self"},{"label":"$element"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :"},"detail":"($self,$element)","kind":12,"children":[{"line":430,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"start_element"},{"line":430,"kind":13,"containerName":"start_element","name":"$element"},{"localvar":"my","containerName":"start_element","name":"$ont","definition":"my","line":431,"kind":13},{"name":"$self","containerName":"start_element","kind":13,"line":431},{"line":431,"kind":12,"name":"ontology","containerName":"start_element"},{"kind":13,"line":432,"definition":"my","name":"$fact","containerName":"start_element","localvar":"my"},{"name":"$self","containerName":"start_element","line":432,"kind":13},{"kind":12,"line":432,"containerName":"start_element","name":"term_factory"},{"kind":13,"line":434,"containerName":"start_element","name":"$element"},{"name":"$ont","containerName":"start_element","kind":13,"line":435},{"line":435,"kind":12,"name":"add_term","containerName":"start_element"},{"line":435,"kind":13,"name":"$fact","containerName":"start_element"},{"line":435,"kind":12,"containerName":"start_element","name":"create_object"},{"line":437,"kind":13,"containerName":"start_element","name":"$ont"},{"name":"add_term","containerName":"start_element","line":437,"kind":12},{"containerName":"start_element","name":"$fact","line":437,"kind":13},{"kind":12,"line":437,"name":"create_object","containerName":"start_element"},{"kind":13,"line":439,"containerName":"start_element","name":"$ont"},{"containerName":"start_element","name":"add_term","kind":12,"line":439},{"name":"$fact","containerName":"start_element","kind":13,"line":439},{"name":"create_object","containerName":"start_element","kind":12,"line":439},{"name":"$ont","containerName":"start_element","line":441,"kind":13},{"line":441,"kind":12,"containerName":"start_element","name":"add_term"},{"name":"$fact","containerName":"start_element","kind":13,"line":441},{"containerName":"start_element","name":"create_object","line":441,"kind":12},{"name":"$ont","containerName":"start_element","kind":13,"line":443},{"name":"add_term","containerName":"start_element","kind":12,"line":443},{"name":"$fact","containerName":"start_element","line":443,"kind":13},{"line":443,"kind":12,"containerName":"start_element","name":"create_object"},{"name":"$ont","containerName":"start_element","kind":13,"line":445},{"line":445,"kind":12,"name":"add_term","containerName":"start_element"},{"containerName":"start_element","name":"$fact","kind":13,"line":445},{"kind":12,"line":445,"name":"create_object","containerName":"start_element"},{"line":447,"kind":13,"containerName":"start_element","name":"$element"},{"line":448,"kind":13,"localvar":"my","definition":"my","name":"%record_args","containerName":"start_element"},{"line":448,"kind":13,"containerName":"start_element","name":"$element"},{"localvar":"my","name":"$id","definition":"my","containerName":"start_element","line":449,"kind":13},{"name":"$record_args","containerName":"start_element","line":449,"kind":13},{"localvar":"my","name":"$term_temp","definition":"my","containerName":"start_element","line":450,"kind":13},{"name":"$ont","containerName":"start_element","kind":13,"line":450},{"line":450,"kind":12,"name":"engine","containerName":"start_element"},{"line":450,"kind":12,"containerName":"start_element","name":"get_term_by_identifier"},{"name":"$id","containerName":"start_element","kind":13,"line":450},{"containerName":"start_element","name":"$self","kind":13,"line":452},{"containerName":"start_element","name":"_term","line":452,"kind":12},{"name":"$term_temp","containerName":"start_element","kind":13,"line":453},{"containerName":"start_element","name":"$ont","line":454,"kind":13},{"name":"add_term","containerName":"start_element","kind":12,"line":454},{"kind":13,"line":454,"containerName":"start_element","name":"$fact"},{"line":454,"kind":12,"containerName":"start_element","name":"create_object"},{"containerName":"start_element","name":"$id","line":454,"kind":13},{"line":454,"kind":13,"containerName":"start_element","name":"$id"},{"name":"$term_temp","containerName":"start_element","kind":13,"line":456},{"containerName":"start_element","name":"$self","kind":13,"line":458},{"kind":12,"line":458,"name":"_term","containerName":"start_element"},{"kind":12,"line":458,"name":"ontology","containerName":"start_element"},{"containerName":"start_element","name":"$ont","line":458,"kind":13},{"line":459,"kind":13,"name":"$self","containerName":"start_element"},{"name":"_term","containerName":"start_element","kind":12,"line":459},{"line":459,"kind":12,"name":"short_name","containerName":"start_element"},{"line":459,"kind":13,"name":"$record_args","containerName":"start_element"},{"kind":13,"line":460,"containerName":"start_element","name":"$self"},{"kind":12,"line":460,"name":"_term","containerName":"start_element"},{"line":460,"kind":12,"containerName":"start_element","name":"protein_count"},{"name":"$record_args","containerName":"start_element","kind":13,"line":460},{"kind":13,"line":461,"containerName":"start_element","name":"$self"},{"name":"_increment_record_count","containerName":"start_element","line":461,"kind":12},{"kind":13,"line":462,"containerName":"start_element","name":"$self"},{"name":"_stack","containerName":"start_element","kind":12,"line":462},{"kind":13,"line":463,"name":"$self","containerName":"start_element"},{"containerName":"start_element","name":"_names","line":463,"kind":12},{"localvar":"my","definition":"my","name":"$rel","containerName":"start_element","line":468,"kind":13},{"kind":12,"line":468,"name":"new","containerName":"start_element"},{"name":"$is_a_rel","containerName":"start_element","line":468,"kind":13},{"containerName":"start_element","name":"$rel","line":469,"kind":13},{"line":469,"kind":12,"containerName":"start_element","name":"object_term"},{"name":"$ont","containerName":"start_element","kind":13,"line":469},{"name":"engine","containerName":"start_element","kind":12,"line":469},{"name":"get_term_by_identifier","containerName":"start_element","line":469,"kind":12},{"name":"$record_args","containerName":"start_element","line":469,"kind":13},{"line":470,"kind":13,"name":"$rel","containerName":"start_element"},{"kind":12,"line":470,"name":"subject_term","containerName":"start_element"},{"line":470,"kind":13,"name":"$self","containerName":"start_element"},{"line":470,"kind":12,"containerName":"start_element","name":"_term"},{"line":471,"kind":13,"containerName":"start_element","name":"$rel"},{"line":471,"kind":12,"containerName":"start_element","name":"ontology"},{"containerName":"start_element","name":"$ont","line":471,"kind":13},{"name":"$ont","containerName":"start_element","line":472,"kind":13},{"kind":12,"line":472,"name":"add_relationship","containerName":"start_element"},{"name":"$rel","containerName":"start_element","kind":13,"line":472}],"line":429,"name":"start_element","range":{"end":{"line":473,"character":9999},"start":{"character":0,"line":429}}},{"name":"Name","line":434,"kind":12},{"name":"Name","line":447,"kind":12},{"name":"Attributes","line":448,"kind":12},{"kind":12,"line":462,"name":"interpro"},{"name":"Bio","containerName":"Ontology::Relationship","line":468,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":474},{"name":"_stack","containerName":"main::","line":474,"kind":12},{"kind":13,"line":475,"containerName":null,"definition":"my","name":"%hash","localvar":"my"},{"name":"%element","containerName":null,"kind":13,"line":477},{"name":"Attributes","line":477,"kind":12},{"localvar":"my","definition":"my","name":"$key","containerName":null,"line":478,"kind":13},{"kind":13,"line":478,"containerName":null,"name":"%element"},{"name":"Attributes","line":478,"kind":12},{"line":479,"kind":13,"name":"%hash","containerName":null},{"line":479,"kind":13,"name":"$key","containerName":null},{"kind":13,"line":479,"containerName":null,"name":"%element"},{"kind":12,"line":479,"name":"Attributes"},{"containerName":null,"name":"$key","kind":13,"line":479},{"kind":13,"line":482,"name":"$self","containerName":null},{"line":482,"kind":12,"containerName":"main::","name":"_stack"},{"line":482,"kind":13,"containerName":null,"name":"%hash"},{"name":"%element","containerName":null,"line":483,"kind":13},{"name":"Name","line":483,"kind":12},{"line":484,"kind":13,"localvar":"my","definition":"my","name":"$ref_id","containerName":null},{"line":484,"kind":13,"name":"%element","containerName":null},{"name":"Attributes","kind":12,"line":484},{"containerName":null,"name":"$parent","definition":"my","localvar":"my","kind":13,"line":485},{"kind":13,"line":485,"containerName":null,"name":"$self"},{"containerName":"main::","name":"_top","kind":12,"line":485},{"name":"$self","containerName":null,"line":485,"kind":13},{"kind":12,"line":485,"containerName":"main::","name":"_names"},{"line":487,"kind":13,"containerName":null,"name":"$parent"},{"containerName":null,"name":"%parent","line":487,"kind":13},{"containerName":null,"name":"$self","line":488,"kind":13},{"kind":12,"line":488,"name":"_create_relationship","containerName":"main::"},{"name":"$ref_id","containerName":null,"kind":13,"line":488},{"line":488,"kind":13,"containerName":null,"name":"$is_a_rel"},{"containerName":null,"name":"%parent","line":490,"kind":13},{"kind":13,"line":491,"name":"$self","containerName":null},{"name":"_create_relationship","containerName":"main::","line":491,"kind":12},{"line":491,"kind":13,"name":"$ref_id","containerName":null},{"kind":13,"line":491,"containerName":null,"name":"$contains_rel"},{"containerName":null,"name":"%parent","line":493,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":494},{"kind":12,"line":494,"containerName":"main::","name":"_create_relationship"},{"containerName":null,"name":"$ref_id","kind":13,"line":494},{"line":494,"kind":13,"name":"$found_in_rel","containerName":null},{"containerName":null,"name":"%element","kind":13,"line":497},{"name":"Name","kind":12,"line":497},{"containerName":null,"name":"$self","kind":13,"line":498},{"containerName":"main::","name":"_cite_skip","line":498,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":500},{"containerName":"main::","name":"_names","line":500,"kind":12},{"containerName":null,"name":"%element","kind":13,"line":500},{"line":500,"kind":12,"name":"Name"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_char_storage","line":518,"kind":13},{"line":518,"kind":13,"containerName":"_char_storage","name":"$value"},{"line":520,"kind":13,"containerName":"_char_storage","name":"$value"},{"containerName":"_char_storage","name":"$self","line":521,"kind":13},{"kind":13,"line":521,"containerName":"_char_storage","name":"$value"},{"line":524,"kind":13,"containerName":"_char_storage","name":"$self"}],"line":517,"kind":12,"signature":{"label":"_char_storage($self,$value)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"line":525,"character":9999},"start":{"character":0,"line":517}},"name":"_char_storage"},{"kind":12,"children":[{"kind":13,"line":540,"name":"$self","definition":"my","containerName":"characters","localvar":"my"},{"name":"$characters","containerName":"characters","line":540,"kind":13},{"localvar":"my","containerName":"characters","name":"$text","definition":"my","line":541,"kind":13},{"line":541,"kind":13,"name":"$characters","containerName":"characters"},{"name":"$text","containerName":"characters","line":543,"kind":13},{"kind":13,"line":544,"name":"$text","containerName":"characters"},{"kind":13,"line":545,"containerName":"characters","name":"$self"},{"containerName":"characters","name":"$text","kind":13,"line":545}],"line":539,"definition":"sub","containerName":"main::","signature":{"label":"characters($self,$characters)","parameters":[{"label":"$self"},{"label":"$characters"}],"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :"},"detail":"($self,$characters)","name":"characters","range":{"start":{"line":539,"character":0},"end":{"character":9999,"line":547}}},{"name":"Data","kind":12,"line":541},{"kind":12,"line":545,"name":"_char_storage"},{"line":561,"children":[{"kind":13,"line":562,"name":"$self","definition":"my","containerName":"end_element","localvar":"my"},{"name":"$element","containerName":"end_element","kind":13,"line":562},{"name":"$element","containerName":"end_element","kind":13,"line":564},{"name":"$self","containerName":"end_element","line":565,"kind":13},{"kind":12,"line":565,"containerName":"end_element","name":"debug"},{"line":567,"kind":13,"containerName":"end_element","name":"$element"},{"line":568,"kind":13,"containerName":"end_element","name":"$self"},{"line":568,"kind":12,"name":"_clear_term","containerName":"end_element"},{"line":569,"kind":13,"containerName":"end_element","name":"$self"},{"kind":12,"line":569,"name":"_increment_processed_count","containerName":"end_element"},{"name":"$element","containerName":"end_element","line":571,"kind":13},{"kind":13,"line":572,"name":"$self","containerName":"end_element"},{"kind":13,"line":573,"name":"$self","containerName":"end_element"},{"line":573,"kind":12,"containerName":"end_element","name":"_stack"},{"containerName":"end_element","definition":"my","name":"$current_hash","localvar":"my","kind":13,"line":574},{"kind":13,"line":574,"name":"$self","containerName":"end_element"},{"name":"_stack","containerName":"end_element","kind":12,"line":574},{"name":"$parent_hash","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":575},{"line":575,"kind":13,"containerName":"end_element","name":"$self"},{"line":575,"kind":12,"containerName":"end_element","name":"_top"},{"kind":13,"line":575,"containerName":"end_element","name":"$self"},{"line":575,"kind":12,"name":"_stack","containerName":"end_element"},{"name":"$current_hash_key","definition":"my","containerName":"end_element","localvar":"my","kind":13,"line":576},{"name":"$self","containerName":"end_element","line":576,"kind":13},{"containerName":"end_element","name":"_names","kind":12,"line":576},{"name":"$current_hash","containerName":"end_element","kind":13,"line":578}],"kind":12,"detail":"($self,$element)","signature":{"label":"end_element($self,$element)","documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub characters {\n  my ($self, $characters) = @_;\n  my $text = $characters->{Data};\n\n  chomp $text;\n  $text =~ s/^(\\s+)//;\n  $self->{_char_storage} .= $text;\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing end of xml element events. Used internally only.\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$element"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":578},"start":{"line":561,"character":0}},"name":"end_element"},{"name":"Name","kind":12,"line":564},{"name":"Name","line":567,"kind":12},{"name":"Name","line":571,"kind":12},{"name":"_char_storage","kind":12,"line":572},{"name":"$self","containerName":null,"line":578,"kind":13},{"name":"_char_storage","containerName":"main::","kind":12,"line":578},{"name":"%current_hash","containerName":null,"kind":13,"line":579},{"name":"comment","line":579,"kind":12},{"containerName":null,"name":"$self","kind":13,"line":579},{"kind":12,"line":579,"name":"_char_storage","containerName":"main::"},{"kind":13,"line":580,"name":"%parent_hash","containerName":null},{"kind":13,"line":580,"containerName":null,"name":"$current_hash_key"},{"line":581,"kind":13,"containerName":null,"name":"$current_hash"},{"line":582,"kind":13,"containerName":null,"name":"$self"},{"line":582,"kind":12,"name":"_char_storage","containerName":"main::"},{"kind":13,"line":583,"name":"%parent_hash","containerName":null},{"kind":13,"line":583,"containerName":null,"name":"%current_hash_key"},{"name":"$self","containerName":null,"line":583,"kind":13},{"line":583,"kind":12,"containerName":"main::","name":"_char_storage"},{"containerName":null,"name":"%current_hash","kind":13,"line":585},{"kind":13,"line":586,"containerName":null,"name":"%parent_hash"},{"kind":13,"line":586,"containerName":null,"name":"$current_hash_key"},{"containerName":null,"name":"$current_hash","line":586,"kind":13},{"line":588,"kind":13,"name":"%element","containerName":null},{"line":588,"kind":12,"name":"Name"},{"definition":"my","name":"@refs","containerName":null,"localvar":"my","kind":13,"line":589},{"definition":"my","name":"$pub_record","containerName":null,"localvar":"my","kind":13,"line":591},{"name":"%current_hash","containerName":null,"kind":13,"line":591},{"kind":12,"line":591,"name":"publication"},{"kind":13,"line":592,"containerName":null,"definition":"my","name":"$ref","localvar":"my"},{"kind":12,"line":592,"name":"Bio","containerName":"Annotation::Reference"},{"containerName":"main::","name":"new","kind":12,"line":592},{"kind":13,"line":593,"definition":"my","name":"$loc","containerName":null,"localvar":"my"},{"kind":13,"line":593,"name":"%pub_record","containerName":null},{"line":593,"kind":12,"name":"location"},{"name":"$ref","containerName":null,"kind":13,"line":595},{"kind":12,"line":595,"containerName":"main::","name":"location"},{"kind":13,"line":595,"containerName":null,"name":"%pub_record"},{"name":"journal","line":595,"kind":12},{"kind":12,"line":595,"name":"accumulated_text_12345"},{"name":"%loc","containerName":null,"line":595,"kind":13},{"name":"firstpage","kind":12,"line":595},{"kind":13,"line":595,"containerName":null,"name":"%loc"},{"kind":12,"line":595,"name":"lastpage"},{"containerName":null,"name":"%loc","kind":13,"line":595},{"kind":12,"line":595,"name":"volume"},{"name":"%pub_record","containerName":null,"kind":13,"line":595},{"name":"year","line":595,"kind":12},{"kind":12,"line":595,"name":"accumulated_text_12345"},{"containerName":null,"name":"$ref","kind":13,"line":596},{"line":596,"kind":12,"containerName":"main::","name":"title"},{"containerName":null,"name":"%pub_record","line":596,"kind":13},{"line":596,"kind":12,"name":"title"},{"kind":12,"line":596,"name":"accumulated_text_12345"},{"line":597,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$ttt"},{"name":"%pub_record","containerName":null,"kind":13,"line":597},{"name":"author_list","kind":12,"line":597},{"containerName":null,"name":"$ref","line":599,"kind":13},{"kind":12,"line":599,"name":"authors","containerName":"main::"},{"line":599,"kind":13,"name":"%ttt","containerName":null},{"name":"accumulated_text_12345","kind":12,"line":599},{"containerName":null,"name":"$ref","line":600,"kind":13},{"containerName":"main::","name":"medline","kind":12,"line":600},{"kind":13,"line":600,"name":"%ttt","containerName":null},{"line":600,"kind":12,"name":"dbkey"},{"line":601,"kind":13,"name":"%ttt","containerName":null},{"name":"db","line":601,"kind":12},{"containerName":null,"name":"%ttt","line":601,"kind":13},{"name":"db","line":601,"kind":12},{"containerName":null,"name":"@refs","kind":13,"line":602},{"name":"$ref","containerName":null,"kind":13,"line":602},{"containerName":null,"name":"$self","line":604,"kind":13},{"name":"_term","containerName":"main::","line":604,"kind":12},{"name":"add_reference","containerName":"main::","line":604,"kind":12},{"containerName":null,"name":"@refs","line":604,"kind":13},{"name":"%element","containerName":null,"line":606,"kind":13},{"kind":12,"line":606,"name":"Name"},{"line":607,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":607,"name":"_term","containerName":"main::"},{"kind":12,"line":607,"containerName":"main::","name":"name"},{"containerName":null,"name":"$self","line":607,"kind":13},{"line":607,"kind":12,"name":"_char_storage","containerName":"main::"},{"name":"%element","containerName":null,"line":609,"kind":13},{"line":609,"kind":12,"name":"Name"},{"kind":13,"line":610,"containerName":null,"name":"$self"},{"kind":12,"line":610,"containerName":"main::","name":"_term"},{"kind":12,"line":610,"name":"definition","containerName":"main::"},{"name":"$self","containerName":null,"kind":13,"line":610},{"name":"_char_storage","containerName":"main::","line":610,"kind":12},{"kind":13,"line":611,"name":"$self","containerName":null},{"name":"_cite_skip","containerName":"main::","kind":12,"line":611},{"containerName":null,"name":"%element","kind":13,"line":613},{"name":"Name","kind":12,"line":613},{"kind":13,"line":614,"containerName":null,"name":"@refs","definition":"my","localvar":"my"},{"kind":13,"line":616,"definition":"my","name":"$db_xref","containerName":null,"localvar":"my"},{"kind":13,"line":616,"name":"%current_hash","containerName":null},{"name":"db_xref","line":616,"kind":12},{"containerName":null,"name":"@refs","line":617,"kind":13},{"line":617,"kind":12,"name":"Bio","containerName":"Annotation::DBLink"},{"containerName":"main::","name":"new","kind":12,"line":617},{"kind":13,"line":617,"name":"%db_xref","containerName":null},{"name":"db","line":617,"kind":12},{"line":618,"kind":13,"containerName":null,"name":"%db_xref"},{"line":618,"kind":12,"name":"dbkey"},{"containerName":null,"name":"$self","line":621,"kind":13},{"name":"_term","containerName":"main::","line":621,"kind":12},{"containerName":"main::","name":"add_member","kind":12,"line":621},{"containerName":null,"name":"@refs","kind":13,"line":621},{"containerName":null,"name":"%element","line":623,"kind":13},{"name":"Name","line":623,"kind":12},{"kind":13,"line":624,"containerName":null,"name":"@refs","definition":"my","localvar":"my"},{"containerName":null,"definition":"my","name":"$sec_ac","localvar":"my","kind":13,"line":626},{"line":626,"kind":13,"containerName":null,"name":"%current_hash"},{"kind":12,"line":626,"name":"sec_ac"},{"line":627,"kind":13,"name":"@refs","containerName":null},{"name":"%sec_ac","containerName":null,"line":627,"kind":13},{"kind":12,"line":627,"name":"sec_ac"},{"containerName":null,"name":"$self","kind":13,"line":629},{"containerName":"main::","name":"_term","line":629,"kind":12},{"name":"add_secondary_id","containerName":"main::","line":629,"kind":12},{"containerName":null,"name":"@refs","line":629,"kind":13},{"containerName":null,"name":"$self","kind":13,"line":630},{"line":630,"kind":12,"name":"secondary_accessions_map","containerName":"main::"},{"kind":13,"line":630,"name":"$self","containerName":null},{"containerName":"main::","name":"_term","line":630,"kind":12},{"name":"identifier","containerName":"main::","line":630,"kind":12},{"containerName":null,"name":"@refs","kind":13,"line":630},{"containerName":null,"name":"%element","line":632,"kind":13},{"kind":12,"line":632,"name":"Name"},{"line":633,"kind":13,"localvar":"my","containerName":null,"name":"@refs","definition":"my"},{"containerName":null,"definition":"my","name":"$example","localvar":"my","kind":13,"line":635},{"containerName":null,"name":"%current_hash","line":635,"kind":13},{"name":"example","kind":12,"line":635},{"kind":13,"line":636,"name":"@refs","containerName":null},{"kind":12,"line":636,"name":"Bio","containerName":"Annotation::DBLink"},{"line":636,"kind":12,"name":"new","containerName":"main::"},{"name":"%example","containerName":null,"kind":13,"line":636},{"line":636,"kind":12,"name":"db_xref"},{"kind":12,"line":636,"name":"db"},{"name":"%example","containerName":null,"line":637,"kind":13},{"name":"db_xref","kind":12,"line":637},{"kind":12,"line":637,"name":"dbkey"},{"line":638,"kind":13,"name":"%example","containerName":null},{"name":"comment","line":638,"kind":12},{"name":"$self","containerName":null,"line":641,"kind":13},{"kind":12,"line":641,"name":"_term","containerName":"main::"},{"line":641,"kind":12,"containerName":"main::","name":"add_example"},{"kind":13,"line":641,"name":"@refs","containerName":null},{"name":"%element","containerName":null,"kind":13,"line":643},{"kind":12,"line":643,"name":"Name"},{"line":644,"kind":13,"localvar":"my","containerName":null,"name":"@refs","definition":"my"},{"localvar":"my","definition":"my","name":"$db_xref","containerName":null,"line":646,"kind":13},{"name":"%current_hash","containerName":null,"line":646,"kind":13},{"line":646,"kind":12,"name":"db_xref"},{"containerName":null,"name":"@refs","line":647,"kind":13},{"kind":12,"line":647,"name":"Bio","containerName":"Annotation::DBLink"},{"line":647,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":647,"containerName":null,"name":"%db_xref"},{"kind":12,"line":647,"name":"db"},{"name":"%db_xref","containerName":null,"kind":13,"line":648},{"name":"dbkey","kind":12,"line":648},{"name":"$self","containerName":null,"line":651,"kind":13},{"line":651,"kind":12,"containerName":"main::","name":"_term"},{"kind":12,"line":651,"containerName":"main::","name":"add_external_document"},{"name":"@refs","containerName":null,"kind":13,"line":651},{"containerName":null,"name":"%element","line":653,"kind":13},{"name":"Name","kind":12,"line":653},{"localvar":"my","containerName":null,"name":"@refs","definition":"my","line":654,"kind":13},{"localvar":"my","name":"$classification","definition":"my","containerName":null,"line":656,"kind":13},{"name":"%current_hash","containerName":null,"kind":13,"line":656},{"name":"classification","kind":12,"line":656},{"kind":13,"line":657,"containerName":null,"name":"@refs"},{"kind":12,"line":657,"containerName":"Annotation::DBLink","name":"Bio"},{"kind":12,"line":657,"containerName":"main::","name":"new"},{"containerName":null,"name":"%classification","line":657,"kind":13},{"kind":12,"line":657,"name":"class_type"},{"name":"%classification","containerName":null,"line":658,"kind":13},{"kind":12,"line":658,"name":"id"},{"containerName":null,"name":"$self","line":661,"kind":13},{"name":"_term","containerName":"main::","kind":12,"line":661},{"containerName":"main::","name":"class_list","line":661,"kind":12},{"name":"@refs","containerName":null,"kind":13,"line":661},{"line":663,"kind":13,"name":"%element","containerName":null},{"kind":12,"line":663,"name":"Name"},{"localvar":"my","containerName":null,"definition":"my","name":"@refs","line":664,"kind":13},{"kind":13,"line":666,"definition":"my","name":"$del_ref","containerName":null,"localvar":"my"},{"line":666,"kind":13,"containerName":null,"name":"%current_hash"},{"name":"del_ref","kind":12,"line":666},{"definition":"my","name":"$term","containerName":null,"localvar":"my","kind":13,"line":667},{"containerName":null,"name":"$self","line":667,"kind":13},{"line":667,"kind":12,"containerName":"main::","name":"ontology_engine"},{"containerName":"main::","name":"get_term_by_identifier","kind":12,"line":667},{"kind":13,"line":667,"containerName":null,"name":"%del_ref"},{"name":"id","line":667,"kind":12},{"containerName":null,"name":"$term","kind":13,"line":669},{"kind":12,"line":669,"name":"is_obsolete","containerName":"main::"},{"name":"$term","containerName":null,"line":669,"kind":13},{"line":673,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"_char_storage","line":673,"kind":12},{"kind":13,"line":673,"containerName":null,"name":"$self"},{"name":"_cite_skip","containerName":"main::","line":673,"kind":12},{"range":{"start":{"line":691,"character":0},"end":{"line":699,"character":9999}},"name":"secondary_accessions_map","signature":{"documentation":"1;\n# $Id: InterProHandler.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for InterProHandler\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Peter Dimitrov <dimitrov@gnf.org>\n#\n# Copyright Peter Dimitrov\n# (c) Peter Dimitrov, dimitrov@gnf.org, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO::Handlers::InterProHandler - XML handler class for InterProParser\n\n=head1 SYNOPSIS\n\n # do not use directly - used and instantiated by InterProParser\n\n=head1 DESCRIPTION\n\nHandles xml events generated by InterProParser when parsing InterPro\nXML files.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Dimitrov\n\nEmail dimitrov@gnf.org\n\n=head1 CONTRIBUTORS\n\nJuguang Xiao, juguang@tll.org.sg\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO::Handlers::InterProHandler;\nuse strict;\nuse Carp;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::RelationshipType;\nuse Bio::Ontology::SimpleOntologyEngine;\nuse Bio::Annotation::Reference;\nuse Data::Dumper;\n\nuse base qw(Bio::Root::Root);\n\nmy ($record_count, $processed_count, $is_a_rel, $contains_rel, $found_in_rel);\n\n=head2 new\n\n Title   : new\n Usage   : $h = Bio::OntologyIO::Handlers::InterProHandler->new;\n Function: Initializes global variables\n Example :\n Returns : an InterProHandler object\n Args    :\n\n\n\nsub new{\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n\n  my ($eng,$ont,$name,$fact) =\n      $self->_rearrange([qw(ENGINE\n\t\t\t    ONTOLOGY\n\t\t\t    ONTOLOGY_NAME\n\t\t\t    TERM_FACTORY)\n\t\t\t ],@args);\n\n  if(defined($ont)) {\n      $self->ontology($ont);\n  } else {\n      $name = \"InterPro\" unless $name;\n      $self->ontology(Bio::Ontology::Ontology->new(-name => $name));\n  }\n  $self->ontology_engine($eng) if $eng;\n\n  $self->term_factory($fact) if $fact;\n\n  $is_a_rel = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n  $contains_rel = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n  $found_in_rel = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n  $is_a_rel->ontology($self->ontology());\n  $contains_rel->ontology($self->ontology());\n  $found_in_rel->ontology($self->ontology());\n  $self->_cite_skip(0);\n  $self->secondary_accessions_map( {} );\n\n  return $self;\n}\n\n=head2 ontology_engine\n\n Title   : ontology_engine\n Usage   : $obj->ontology_engine($newval)\n Function: Get/set ontology engine. Can be initialized only once.\n Example : \n Returns : value of ontology_engine (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub ontology_engine{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    if ( defined $self->{'ontology_engine'}) {\n      $self->throw(\"ontology_engine already defined\");\n    } else {\n      $self->throw(ref($value).\" does not implement \".\n\t\t   \"Bio::Ontology::OntologyEngineI. Bummer.\")\n\t  unless $value->isa(\"Bio::Ontology::OntologyEngineI\");\n      $self->{'ontology_engine'} = $value;\n\n      # don't forget to set this as the engine of the ontology, otherwise\n      # those two might not point to the same object\n      my $ont = $self->ontology();\n      if($ont && $ont->can(\"engine\") && (!$ont->engine())) {\n\t  $ont->engine($value);\n      }\n\n      $self->debug(ref($self) .\n\t\t   \"::ontology_engine: registering ontology engine (\".\n\t\t   ref($value).\"):\\n\".\n\t\t   $value->to_string.\"\\n\");\n    }\n  }\n\n  return $self->{'ontology_engine'};\n}\n\n=head2 ontology\n\n Title   : ontology\n Usage   :\n Function: Get the ontology to add the InterPro terms to.\n\n           The value is determined automatically once ontology_engine\n           has been set and if it hasn't been set before.\n\n Example :\n Returns : A L<Bio::Ontology::OntologyI> implementing object.\n Args    : On set, a L<Bio::Ontology::OntologyI> implementing object.\n\n\nsub ontology{\n    my ($self,$ont) = @_;\n\n    if(defined($ont)) {\n\t$self->throw(ref($ont).\" does not implement Bio::Ontology::OntologyI\".\n\t\t     \". Bummer.\")\n\t    unless $ont->isa(\"Bio::Ontology::OntologyI\");\n\t$self->{'_ontology'} = $ont;\n    } \n    return $self->{'_ontology'};\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term object factory \n Example : \n Returns : value of term_factory (a Bio::Factory::ObjectFactory instance)\n Args    : on set, new value (a Bio::Factory::ObjectFactory instance\n           or undef, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head2 _cite_skip\n\n Title   : _cite_skip\n Usage   : $obj->_cite_skip($newval)\n Function: \n Example : \n Returns : value of _cite_skip (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _cite_skip{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_cite_skip'} = $value;\n  }\n\n  return $self->{'_cite_skip'};\n}\n\n=head2 _hash\n\n Title   : _hash\n Usage   : $obj->_hash($newval)\n Function: \n Example : \n Returns : value of _hash (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _hash{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_hash'} = $value;\n  }\n\n  return $self->{'_hash'};\n}\n\n=head2 _stack\n\n Title   : _stack\n Usage   : $obj->_stack($newval)\n Function: \n Example : \n Returns : value of _stack (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _stack{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_stack'} = $value;\n  }\n  return $self->{'_stack'};\n}\n\n=head2 _top\n\n Title   : _top\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub _top{\n  my ($self, $_stack) = @_;\n  my @stack = @{$_stack};\n\n  return (@stack >= 1) ? $stack[@stack - 1] : undef;\n}\n\n=head2 _term\n\n Title   : _term\n Usage   : $obj->_term($newval)\n Function: Get/set method for the term currently processed.\n Example : \n Returns : value of term (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _term{\n  my ($self, $value) = @_;\n\n  if(defined $value) {\n    $self->{'_term'} = $value;\n  }\n\n  return $self->{'_term'};\n}\n\n=head2 _clear_term\n\n Title   : _clear_term\n Usage   :\n Function: Removes the current term from the handler\n Example :\n Returns :\n Args    :\n\n\n\nsub _clear_term{\n  my ($self) = @_;\n\n  delete $self->{'_term'};\n}\n\n=head2 _names\n\n Title   : _names\n Usage   : $obj->_names($newval)\n Function: \n Example : \n Returns : value of _names (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _names{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_names'} = $value;\n  }\n\n  return $self->{'_names'};\n}\n\n=head2 _create_relationship\n\n Title   : _create_relationship\n Usage   :\n Function: Helper function. Adds relationships to one of the relationship stores.\n Example :\n Returns : \n Args    :\n\n\n\nsub _create_relationship{\n  my ($self, $ref_id, $rel_type_term) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n  my $term_temp = ($ont->engine->get_term_by_identifier($ref_id))[0];\n\n  my $rel = Bio::Ontology::Relationship->new( -predicate_term => $rel_type_term );\n\t\n  if (!defined $term_temp) {\n    $term_temp = $ont->engine->add_term( $fact->create_object( -InterPro_id => $ref_id , -name=>$ref_id, -ontology=>$ont) );\n    $ont->engine->mark_uninstantiated($term_temp);\n  }\n  my $rel_type_name = $self->_top($self->_names);\n\n  if ($rel_type_name eq 'parent_list' || $rel_type_name eq 'found_in') {\n    $rel->object_term( $term_temp );\n    $rel->subject_term( $self->_term );\n  } else {\n    $rel->object_term( $self->_term );\n    $rel->subject_term( $term_temp );\n  }\n  $rel->ontology($ont);\n  $ont->add_relationship($rel);\n}\n\n=head2 start_element\n\n Title   : start_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and\n           has to be overridden for processing start of xml element\n           events. Used internally only.\n\n Example :\n Returns : \n Args    :\n\n\n\nsub start_element {\n  my ($self, $element) = @_;\n  my $ont = $self->ontology();\n  my $fact = $self->term_factory();\n\n  if ($element->{Name} eq 'interprodb') {\n    $ont->add_term($fact->create_object(-identifier => \"Active_site\",\n\t\t\t\t\t-name => \"Active Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Binding_site\",\n\t\t\t\t\t-name => \"Binding Site\") );\n    $ont->add_term($fact->create_object(-identifier => \"Family\",\n\t\t\t\t\t-name => \"Family\") );\n    $ont->add_term($fact->create_object(-identifier => \"Domain\",\n\t\t\t\t\t-name => \"Domain\") );\n    $ont->add_term($fact->create_object(-identifier => \"Repeat\",\n\t\t\t\t\t-name => \"Repeat\") );\n    $ont->add_term($fact->create_object(-identifier => \"PTM\",\n\t\t\t\t -name => \"post-translational modification\"));\n  } elsif ($element->{Name} eq 'interpro') {\n    my %record_args = %{$element->{Attributes}};\n    my $id = $record_args{\"id\"};\n    my $term_temp = ($ont->engine->get_term_by_identifier($id))[0];\n\n    $self->_term(\n\t\t (!defined $term_temp)\n\t\t ? $ont->add_term( $fact->create_object(-InterPro_id => $id, -name=>$id) )\n\t\t : $term_temp\n\t\t);\n\n    $self->_term->ontology( $ont );\n    $self->_term->short_name( $record_args{\"short_name\"} );\n    $self->_term->protein_count( $record_args{\"protein_count\"} );\n    $self->_increment_record_count();\n    $self->_stack([{ interpro => undef }]);\n    $self->_names([\"interpro\"]);\n\n    ## Adding a relationship between the newly created InterPro term\n    ## and the term describing its type\n\n    my $rel = Bio::Ontology::Relationship->new( -predicate_term => $is_a_rel );\n    $rel->object_term( ($ont->engine->get_term_by_identifier($record_args{\"type\"}))[0] );\n    $rel->subject_term( $self->_term );\n    $rel->ontology($ont);\n    $ont->add_relationship($rel);\n  }\n  elsif (defined $self->_stack) {\n    my %hash = ();\n\n    if (keys %{$element->{Attributes}} > 0) {\n      foreach my $key (keys %{$element->{Attributes}}) {\n\t$hash{$key} = $element->{Attributes}->{$key};\n      }\n    }\n    push @{$self->_stack}, \\%hash;\n    if ($element->{Name} eq 'rel_ref') {\n      my $ref_id = $element->{Attributes}->{\"ipr_ref\"};\n      my $parent = $self->_top($self->_names);\n\n      if ($parent eq 'parent_list' || $parent eq 'child_list') {\n\t$self->_create_relationship($ref_id, $is_a_rel);\n      }\n      if ($parent eq 'contains' ) {\n\t$self->_create_relationship($ref_id, $contains_rel);\n      }\n      if ($parent eq 'found_in' ) {\n\t$self->_create_relationship($ref_id, $found_in_rel);\n      }\n    }\n    elsif ($element->{Name} eq 'abstract') {\n      $self->_cite_skip(1);\n    }\n    push @{$self->_names}, $element->{Name};\n  }\n\n}\n\n=head2 _char_storage\n\n Title   : _char_storage\n Usage   : $obj->_char_storage($newval)\n Function: \n Example : \n Returns : value of _char_storage (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub _char_storage{\n  my ($self, $value) = @_;\n\n  if( defined $value) {\n    $self->{'_char_storage'} = $value;\n  }\n\n  return $self->{'_char_storage'};\n}\n\n=head2 characters\n\n Title   : characters\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing xml characters events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub characters {\n  my ($self, $characters) = @_;\n  my $text = $characters->{Data};\n\n  chomp $text;\n  $text =~ s/^(\\s+)//;\n  $self->{_char_storage} .= $text;\n\n}\n\n=head2 end_element\n\n Title   : end_element\n Usage   :\n Function: This is a method that is derived from XML::SAX::Base and has to be overridden for processing end of xml element events. Used internally only.\n Example :\n Returns : \n Args    :\n\n\n\nsub end_element {\n  my ($self, $element) = @_;\n\n  if ($element->{Name} eq 'interprodb') {\n    $self->debug(\"Interpro DB Parser Finished: $record_count read, $processed_count processed\\n\");\n  }\n  elsif ($element->{Name} eq 'interpro') {\n    $self->_clear_term;\n    $self->_increment_processed_count();\n  }\n  elsif ($element->{Name} ne 'cite') {\n    $self->{_char_storage} =~ s/<\\/?p>//g;\n    if ((defined $self->_stack)) {\n      my $current_hash = pop @{$self->_stack};\n      my $parent_hash = $self->_top($self->_stack);\n      my $current_hash_key = pop @{$self->_names};\n\n      if (keys %{$current_hash} > 0 && $self->_char_storage ne \"\") {\n\t$current_hash->{comment} = $self->_char_storage;\n\tpush @{ $parent_hash->{$current_hash_key} }, $current_hash\n      }\n      elsif ($self->_char_storage ne \"\"){\n\tpush @{ $parent_hash->{$current_hash_key} }, { 'accumulated_text_12345' => $self->_char_storage };\n      }\n      elsif (keys %{$current_hash} > 0) {\n\tpush @{ $parent_hash->{$current_hash_key} }, $current_hash;\n      }\n      if ($element->{Name} eq 'pub_list') {\n\tmy @refs = ();\n\n\tforeach my $pub_record ( @{ $current_hash->{publication} } ) {\n\t  my $ref = Bio::Annotation::Reference->new;\n\t  my $loc = $pub_record->{location}->[0];\n\n\t  $ref->location( $pub_record->{journal}->[0]->{accumulated_text_12345}.\", \".$loc->{firstpage}.\"-\".$loc->{lastpage}.\", \".$loc->{volume}.\", \".$pub_record->{year}->[0]->{accumulated_text_12345});\n\t  $ref->title( $pub_record->{title}->[0]->{accumulated_text_12345} );\n\t  my $ttt = $pub_record->{author_list}->[0];\n\n\t  $ref->authors( $ttt->{accumulated_text_12345} );\n\t  $ref->medline( scalar($ttt->{dbkey}) )\n\t      if exists($ttt->{db}) && $ttt->{db} eq \"MEDLINE\";\n\t  push @refs, $ref;\n\t}\n \t$self->_term->add_reference(@refs);\n      }\n      elsif ($element->{Name} eq 'name') {\n \t$self->_term->name( $self->_char_storage );\n      }\n      elsif ($element->{Name} eq 'abstract') {\n\t$self->_term->definition( $self->_char_storage );\n\t$self->_cite_skip(0);\n      }\n      elsif ($element->{Name} eq 'member_list') {\n\tmy @refs = ();\n\n\tforeach my $db_xref ( @{ $current_hash->{db_xref} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $db_xref->{db},\n\t\t\t\t\t\t    -primary_id => $db_xref->{dbkey}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_member(@refs);\n      }\n      elsif ($element->{Name} eq 'sec_list') {\n\tmy @refs = ();\n\n\tforeach my $sec_ac ( @{ $current_hash->{sec_ac} } ) {\n\t  push @refs, $sec_ac->{sec_ac};\n\t}\n \t$self->_term->add_secondary_id(@refs);\n\t$self->secondary_accessions_map->{$self->_term->identifier} = \\@refs;\n      }\n      elsif ($element->{Name} eq 'example_list') {\n\tmy @refs = ();\n\n\tforeach my $example ( @{ $current_hash->{example} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $example->{db_xref}->[0]->{db},\n\t\t\t\t\t\t    -primary_id => $example->{db_xref}->[0]->{dbkey},\n\t\t\t\t\t\t    -comment => $example->{comment}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_example(@refs);\n      }\n      elsif ($element->{Name} eq 'external_doc_list') {\n\tmy @refs = ();\n\n\tforeach my $db_xref ( @{ $current_hash->{db_xref} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $db_xref->{db},\n\t\t\t\t\t\t    -primary_id => $db_xref->{dbkey}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->add_external_document(@refs);\n      }\n      elsif ($element->{Name} eq 'class_list') {\n\tmy @refs = ();\n\n\tforeach my $classification ( @{ $current_hash->{classification} } ) {\n\t  push @refs, Bio::Annotation::DBLink->new( -database => $classification->{class_type},\n\t\t\t\t\t\t    -primary_id => $classification->{id}\n\t\t\t\t\t\t  );\n\t}\n \t$self->_term->class_list(\\@refs);\n      }\n      elsif ($element->{Name} eq 'deleted_entries') {\n\tmy @refs = ();\n\n\tforeach my $del_ref ( @{ $current_hash->{del_ref} } ) {\n\t  my $term = ($self->ontology_engine->get_term_by_identifier( $del_ref->{id} ))[0];\n\n\t  $term->is_obsolete(1) if defined $term;\n\t}\n      }\n    }\n    $self->_char_storage( '' ) if !$self->_cite_skip;\n  }\n}\n\n=head2 secondary_accessions_map\n\n Title   : secondary_accessions_map\n Usage   : $obj->secondary_accessions_map($newval)\n Function: \n Example : $map = $interpro_handler->secondary_accessions_map();\n Returns : Reference to a hash that maps InterPro identifier to an\n  array reference of secondary accessions following the InterPro\n xml schema.\n Args    : Empty hash reference","parameters":[{"label":"$self"},{"label":"$value"}],"label":"secondary_accessions_map($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":692,"definition":"my","name":"$self","containerName":"secondary_accessions_map","localvar":"my"},{"line":692,"kind":13,"name":"$value","containerName":"secondary_accessions_map"},{"name":"$value","containerName":"secondary_accessions_map","kind":13,"line":694},{"kind":13,"line":695,"name":"$self","containerName":"secondary_accessions_map"},{"containerName":"secondary_accessions_map","name":"$value","line":695,"kind":13},{"name":"$self","containerName":"secondary_accessions_map","line":698,"kind":13}],"line":691,"kind":12},{"range":{"end":{"character":9999,"line":715},"start":{"character":0,"line":713}},"containerName":"main::","name":"_increment_record_count","definition":"sub","line":713,"children":[{"kind":13,"line":714,"name":"$record_count","containerName":"_increment_record_count"}],"kind":12},{"kind":12,"line":729,"children":[{"name":"$processed_count","containerName":"_increment_processed_count","line":730,"kind":13},{"line":731,"kind":13,"name":"$processed_count","containerName":"_increment_processed_count"},{"line":731,"kind":13,"containerName":"_increment_processed_count","name":"$processed_count"}],"containerName":"main::","definition":"sub","name":"_increment_processed_count","range":{"start":{"line":729,"character":0},"end":{"line":732,"character":9999}}}]}