{"version":5,"vars":[{"containerName":"","name":"base","kind":2,"line":103},{"localvar":"my","containerName":null,"name":"%format_driver_map","definition":"my","line":108,"kind":13},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: OntologyIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO - Parser factory for Ontology formats\n\n=head1 SYNOPSIS\n\n    use Bio::OntologyIO;\n\n    my $parser = Bio::OntologyIO->new(-format => \"go\",\n                                      -file=> $file);\n\n    while(my $ont = $parser->next_ontology()) {\n         print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is the parser factory for different ontology sources and\nformats. Conceptually, it is very similar to L<Bio::SeqIO>, but the\ndifference is that the chunk of data returned as an object is an\nentire ontology.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n#\n# Maps from format name to driver suitable for the format.\n#\nmy %format_driver_map = (\n                         \"go\"          => \"goflat\",\n                         \"so\"          => \"soflat\",\n                         \"interpro\"    => \"InterProParser\",\n                         \"interprosax\" => \"Handlers::InterPro_BioSQL_Handler\",\n                         \"evoc\"        => \"simplehierarchy\",\n                         \"obo\"        => \"obo\"\n                         );\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::OntologyIO->new(-format => 'go', @args);\n Function: Returns a stream of ontologies opened on the specified input\n           for the specified format.\n Returns : An ontology parser (an instance of Bio::OntologyIO) initialized\n           for the specified format.\n Args    : Named parameters. Common parameters are\n\n              -format    - the format of the input; the following are\n                           presently supported:\n                  goflat: DAG-Edit Gene Ontology flat files\n                  go    : synonymous to goflat\n                  soflat: DAG-Edit Sequence Ontology flat files\n                  so    : synonymous to soflat\n                  simplehierarchy: text format with one term per line\n                          and indentation giving the hierarchy\n                  evoc  : synonymous to simplehierarchy\n                  interpro: InterPro XML\n                  interprosax: InterPro XML - this is actually not a\n                          Bio::OntologyIO compliant parser; instead it\n                          persists terms as they are encountered.\n                          L<Bio::OntologyIO::Handlers::InterPro_BioSQL_Handler>\n                  obo   : OBO format style from Gene Ontology Consortium\n              -file      - the file holding the data\n              -fh        - the stream providing the data (-file and -fh are\n                          mutually exclusive)\n              -ontology_name - the name of the ontology\n              -engine    - the L<Bio::Ontology::OntologyEngineI> object\n                          to be reused (will be created otherwise); note\n                          that every L<Bio::Ontology::OntologyI> will\n                          qualify as well since that one inherits from the\n                          former.\n              -term_factory - the ontology term factory to use. Provide a\n                          value only if you know what you are doing.\n\n           DAG-Edit flat file parsers will usually also accept the\n           following parameters.\n\n              -defs_file - the name of the file holding the term\n                          definitions\n              -files     - an array ref holding the file names (for GO,\n                          there will usually be 3 files: component.ontology,\n                          function.ontology, process.ontology)\n\n           Other parameters are specific to the parsers.","label":"new($caller,@args)"},"detail":"($caller,@args)","kind":12,"children":[{"containerName":"new","definition":"my","name":"$caller","localvar":"my","kind":13,"line":168},{"name":"@args","containerName":"new","kind":13,"line":168},{"containerName":"new","definition":"my","name":"$class","localvar":"my","kind":13,"line":169},{"containerName":"new","name":"$caller","kind":13,"line":169},{"containerName":"new","name":"$caller","kind":13,"line":169},{"kind":13,"line":172,"name":"$class","containerName":"new"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":173},{"containerName":"new","name":"$class","kind":13,"line":173},{"line":173,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":174,"containerName":"new","name":"$self"},{"kind":12,"line":174,"containerName":"new","name":"_initialize"},{"kind":13,"line":174,"name":"@args","containerName":"new"},{"kind":13,"line":175,"name":"$self","containerName":"new"},{"localvar":"my","containerName":"new","name":"%param","definition":"my","line":177,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":177},{"name":"@param","containerName":"new","kind":13,"line":178},{"line":178,"kind":13,"name":"%param","containerName":"new"},{"containerName":"new","name":"%param","kind":13,"line":178},{"localvar":"my","containerName":"new","name":"$format","definition":"my","line":179,"kind":13},{"line":179,"kind":13,"containerName":"new","name":"$class"},{"line":179,"kind":12,"name":"_map_format","containerName":"new"},{"name":"$param","containerName":"new","line":179,"kind":13},{"kind":13,"line":182,"containerName":"new","name":"$class"},{"line":182,"kind":12,"name":"_load_format_module","containerName":"new"},{"name":"$format","containerName":"new","line":182,"kind":13},{"line":183,"kind":12,"containerName":"new","name":"new"},{"name":"@args","containerName":"new","kind":13,"line":183}],"line":167,"name":"new","range":{"start":{"character":0,"line":167},"end":{"character":9999,"line":186}}},{"containerName":"new","name":"SUPER","line":173,"kind":12},{"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"containerName":"main::","definition":"sub","line":188,"children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"containerName":"_initialize","name":"@args"},{"kind":13,"line":192,"containerName":"_initialize","name":"$eng","definition":"my","localvar":"my"},{"kind":13,"line":192,"containerName":"_initialize","name":"$fact"},{"containerName":"_initialize","name":"$ontname","kind":13,"line":192},{"kind":13,"line":193,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"_rearrange","kind":12,"line":193},{"name":"@args","containerName":"_initialize","kind":13,"line":194},{"line":196,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"term_factory","line":196,"kind":12},{"containerName":"_initialize","name":"$fact","kind":13,"line":196},{"line":196,"kind":13,"containerName":"_initialize","name":"$fact"},{"name":"$self","containerName":"_initialize","line":199,"kind":13},{"name":"_initialize_io","containerName":"_initialize","kind":12,"line":199},{"kind":13,"line":199,"containerName":"_initialize","name":"@args"}],"kind":12,"range":{"start":{"line":188,"character":0},"end":{"line":200,"character":9999}},"name":"_initialize"},{"containerName":"main::","name":"next_ontology","definition":"sub","range":{"start":{"line":214,"character":0},"end":{"character":9999,"line":216}},"kind":12,"line":214,"children":[{"name":"throw_not_implemented","containerName":"next_ontology","line":215,"kind":12}]},{"kind":12,"children":[{"kind":13,"line":241,"containerName":"term_factory","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":243,"containerName":"term_factory","name":"$self"},{"name":"$self","containerName":"term_factory","line":244,"kind":13}],"line":240,"definition":"sub","name":"term_factory","containerName":"main::","range":{"end":{"line":245,"character":9999},"start":{"line":240,"character":0}}},{"range":{"end":{"character":9999,"line":283},"start":{"line":266,"character":0}},"name":"_load_format_module","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_load_format_module","line":267,"kind":13},{"kind":13,"line":267,"containerName":"_load_format_module","name":"$format"},{"kind":13,"line":268,"containerName":"_load_format_module","definition":"my","name":"$module","localvar":"my"},{"containerName":"_load_format_module","name":"$format","line":268,"kind":13},{"localvar":"my","containerName":"_load_format_module","name":"$ok","definition":"my","line":269,"kind":13},{"kind":13,"line":272,"containerName":"_load_format_module","name":"$ok"},{"name":"$self","containerName":"_load_format_module","kind":13,"line":272},{"containerName":"_load_format_module","name":"_load_module","line":272,"kind":12},{"line":272,"kind":13,"name":"$module","containerName":"_load_format_module"},{"line":282,"kind":13,"name":"$ok","containerName":"_load_format_module"}],"line":266,"kind":12,"signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: OntologyIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::OntologyIO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::OntologyIO - Parser factory for Ontology formats\n\n=head1 SYNOPSIS\n\n    use Bio::OntologyIO;\n\n    my $parser = Bio::OntologyIO->new(-format => \"go\",\n                                      -file=> $file);\n\n    while(my $ont = $parser->next_ontology()) {\n         print \"read ontology \",$ont->name(),\" with \",\n               scalar($ont->get_root_terms),\" root terms, and \",\n               scalar($ont->get_leaf_terms),\" leaf terms\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis is the parser factory for different ontology sources and\nformats. Conceptually, it is very similar to L<Bio::SeqIO>, but the\ndifference is that the chunk of data returned as an object is an\nentire ontology.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::OntologyIO;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n#\n# Maps from format name to driver suitable for the format.\n#\nmy %format_driver_map = (\n                         \"go\"          => \"goflat\",\n                         \"so\"          => \"soflat\",\n                         \"interpro\"    => \"InterProParser\",\n                         \"interprosax\" => \"Handlers::InterPro_BioSQL_Handler\",\n                         \"evoc\"        => \"simplehierarchy\",\n                         \"obo\"        => \"obo\"\n                         );\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::OntologyIO->new(-format => 'go', @args);\n Function: Returns a stream of ontologies opened on the specified input\n           for the specified format.\n Returns : An ontology parser (an instance of Bio::OntologyIO) initialized\n           for the specified format.\n Args    : Named parameters. Common parameters are\n\n              -format    - the format of the input; the following are\n                           presently supported:\n                  goflat: DAG-Edit Gene Ontology flat files\n                  go    : synonymous to goflat\n                  soflat: DAG-Edit Sequence Ontology flat files\n                  so    : synonymous to soflat\n                  simplehierarchy: text format with one term per line\n                          and indentation giving the hierarchy\n                  evoc  : synonymous to simplehierarchy\n                  interpro: InterPro XML\n                  interprosax: InterPro XML - this is actually not a\n                          Bio::OntologyIO compliant parser; instead it\n                          persists terms as they are encountered.\n                          L<Bio::OntologyIO::Handlers::InterPro_BioSQL_Handler>\n                  obo   : OBO format style from Gene Ontology Consortium\n              -file      - the file holding the data\n              -fh        - the stream providing the data (-file and -fh are\n                          mutually exclusive)\n              -ontology_name - the name of the ontology\n              -engine    - the L<Bio::Ontology::OntologyEngineI> object\n                          to be reused (will be created otherwise); note\n                          that every L<Bio::Ontology::OntologyI> will\n                          qualify as well since that one inherits from the\n                          former.\n              -term_factory - the ontology term factory to use. Provide a\n                          value only if you know what you are doing.\n\n           DAG-Edit flat file parsers will usually also accept the\n           following parameters.\n\n              -defs_file - the name of the file holding the term\n                          definitions\n              -files     - an array ref holding the file names (for GO,\n                          there will usually be 3 files: component.ontology,\n                          function.ontology, process.ontology)\n\n           Other parameters are specific to the parsers.\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::OntologyIO::(\\S+)/ ) {\n        my ($self) = $class->SUPER::new(@args);\n        $self->_initialize(@args);\n        return $self;\n    } else {\n        my %param = @args;\n        @param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n        my $format = $class->_map_format($param{'-format'});\n\n        # normalize capitalization\n        return unless( $class->_load_format_module($format) );\n        return \"Bio::OntologyIO::$format\"->new(@args);\n    }\n\n}\n\nsub _initialize {\n    my($self, @args) = @_;\n\n    # initialize factories etc\n    my ($eng,$fact,$ontname) =\n        $self->_rearrange([qw(TERM_FACTORY)\n                           ], @args);\n    # term object factory\n    $self->term_factory($fact) if $fact;\n\n    # initialize the Bio::Root::IO part\n    $self->_initialize_io(@args);\n}\n\n=head2 next_ontology\n\n Title   : next_ontology\n Usage   : $ont = $stream->next_ontology()\n Function: Reads the next ontology object from the stream and returns it.\n Returns : a L<Bio::Ontology::OntologyI> compliant object, or undef at the\n           end of the stream\n Args    : none\n\n\n\nsub next_ontology {\n    shift->throw_not_implemented();\n}\n\n=head2 term_factory\n\n Title   : term_factory\n Usage   : $obj->term_factory($newval)\n Function: Get/set the ontology term factory to use.\n\n           As a user of this module it is not necessary to call this\n           method as there will be default. In order to change the\n           default, the easiest way is to instantiate\n           L<Bio::Ontology::TermFactory> with the proper -type\n           argument. Most if not all parsers will actually use this\n           very implementation, so even easier than the aforementioned\n           way is to simply call\n           $ontio->term_factory->type(\"Bio::Ontology::MyTerm\").\n\n Example :\n Returns : value of term_factory (a Bio::Factory::ObjectFactoryI object)\n Args    : on set, new value (a Bio::Factory::ObjectFactoryI object, optional)\n\n\n\nsub term_factory{\n    my $self = shift;\n\n    return $self->{'term_factory'} = shift if @_;\n    return $self->{'term_factory'};\n}\n\n=head1 Private Methods\n\n  Some of these are actually 'protected' in OO speak, which means you\n  may or will want to utilize them in a derived ontology parser, but\n  you should not call them from outside.\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL OntologyIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}]},"detail":"($self,$format)","definition":"sub","containerName":"main::"},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"end":{"line":289,"character":9999},"start":{"character":0,"line":285}},"kind":12,"children":[{"containerName":"DESTROY","definition":"my","name":"$self","localvar":"my","kind":13,"line":286},{"name":"$self","containerName":"DESTROY","kind":13,"line":288},{"line":288,"kind":12,"containerName":"DESTROY","name":"close"}],"line":285},{"kind":12,"line":291,"children":[{"kind":13,"line":292,"name":"$self","definition":"my","containerName":"_map_format","localvar":"my"},{"localvar":"my","name":"$format","definition":"my","containerName":"_map_format","line":293,"kind":13},{"localvar":"my","name":"$mod","definition":"my","containerName":"_map_format","line":294,"kind":13},{"containerName":"_map_format","name":"$format","kind":13,"line":296},{"name":"$mod","containerName":"_map_format","line":297,"kind":13},{"name":"$format_driver_map","containerName":"_map_format","kind":13,"line":297},{"containerName":"_map_format","name":"$format","line":297,"kind":13},{"line":298,"kind":13,"name":"$mod","containerName":"_map_format"},{"kind":13,"line":298,"containerName":"_map_format","name":"$format"},{"line":298,"kind":13,"containerName":"_map_format","name":"$mod"},{"containerName":"_map_format","name":"$self","line":300,"kind":13},{"line":300,"kind":12,"name":"throw","containerName":"_map_format"},{"kind":13,"line":302,"containerName":"_map_format","name":"$mod"}],"containerName":"main::","name":"_map_format","definition":"sub","range":{"start":{"line":291,"character":0},"end":{"character":9999,"line":303}}},{"range":{"start":{"line":305,"character":0},"end":{"character":9999,"line":313}},"name":"unescape","signature":{"label":"unescape($self,$ref)","documentation":"","parameters":[{"label":"$self"},{"label":"$ref"}]},"detail":"($self,$ref)","definition":"sub","containerName":"main::","children":[{"line":306,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"unescape"},{"line":306,"kind":13,"containerName":"unescape","name":"$ref"},{"kind":13,"line":307,"name":"$ref","containerName":"unescape"},{"name":"$ref","containerName":"unescape","kind":13,"line":308},{"name":"$ref","containerName":"unescape","line":309,"kind":13},{"containerName":"unescape","name":"$ref","kind":13,"line":310},{"containerName":"unescape","name":"$ref","line":311,"kind":13},{"kind":13,"line":312,"name":"$ref","containerName":"unescape"}],"line":305,"kind":12}]}