{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":84},{"containerName":null,"definition":"my","name":"%instance","localvar":"my","kind":13,"line":87},{"line":90,"kind":13,"name":"$instance","containerName":null},{"containerName":"Data","name":"Dumper","line":90,"kind":2},{"kind":12,"line":92,"name":"ontology"},{"name":"definitions","kind":12,"line":93},{"name":"ontology","line":97,"kind":12},{"kind":12,"line":98,"name":"definitions"},{"name":"format","line":99,"kind":12},{"name":"ontology","kind":12,"line":105},{"line":106,"kind":12,"name":"definitions"},{"name":"format","line":107,"kind":12},{"name":"ontology","line":110,"kind":12},{"kind":12,"line":115,"name":"definitions"},{"name":"format","kind":12,"line":116},{"containerName":null,"name":"%instance","kind":13,"line":121},{"kind":12,"line":121,"name":"Gene_Ontology"},{"containerName":null,"name":"%instance","kind":13,"line":121},{"line":123,"kind":13,"name":"$instance","containerName":null},{"children":[{"containerName":"new","name":"get_instance","kind":12,"line":128}],"line":127,"kind":12,"range":{"end":{"character":9999,"line":129},"start":{"line":127,"character":0}},"definition":"sub","name":"new","containerName":"main::"},{"range":{"end":{"line":144,"character":9999},"start":{"character":0,"line":142}},"containerName":"main::","definition":"sub","name":"get_instance","line":142,"children":[{"containerName":"get_instance","name":"$instance","kind":13,"line":143}],"kind":12},{"signature":{"documentation":"1;\n# $Id: DocumentRegistry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::DocumentRegistry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Allen Day\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::DocumentRegistry - Keep track of where to find ontologies.\nAllows lookups by name.\n\n=head1 SYNOPSIS\n\n  my $registry = Bio::Ontology::DocumentRegistry->get_instance();\n  my($ont,$def,$fmt) = $registry->documents('Sequence Ontology');\n\n  my $io = Bio::OntologyIO->new(-url => $ont,\n                                -defs_url => $def,\n                                -format => $fmt);\n  my $so = $io->next_ontology();\n  #...\n\n=head1 DESCRIPTION\n\nDo not use this directly, use Bio::Ontology::OntologyStore instead.\nBio::Ontology::OntologyStore uses Bio::Ontology::DocumentRegistry to\nload and cache ontologies as object graphs, you can just ask it for\nwhat you want by name.  See L<Bio::Ontology::OntologyStore> for\ndetails.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Allen Day\n\nEmail allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::DocumentRegistry;\nuse strict;\nuse base qw(Bio::Root::Root);\nuse Data::Dumper;\n\nmy $instance;\n\nBEGIN {\n$instance = {\n   'Sequence Ontology' => {\n\t    ontology => \"http://song.cvs.sourceforge.net/*checkout*/song/ontology/so.ontology?rev=HEAD\",\n        definitions => \"http://song.cvs.sourceforge.net/*checkout*/song/ontology/so.definition?rev=HEAD\",\n        format => 'soflat',\n                                    },\n   'Sequence Ontology OBO' => {\n\t    ontology => \"http://song.cvs.sourceforge.net/*checkout*/song/ontology/so.obo?rev=HEAD\",\n        definitions => \"http://song.cvs.sourceforge.net/*checkout*/song/ontology/so.definition?rev=HEAD\",\n        format => 'obo',\n                                    },\n   \n   #### TODO Server http://umn.dl.sourceforge.net/ does not respond, are there\n   #### alternative sources? \n   'Sequence Ontology Feature Annotation' => {\n        ontology => 'http://umn.dl.sourceforge.net/sourceforge/song/sofa.ontology',\n        definitions =>'http://umn.dl.sourceforge.net/sourceforge/song/sofa.definition',\n        format => 'soflat',\n                                    },\n    'Gene Ontology' => {\n         ontology => [\n\t\t\t\t\t\t\t 'http://www.geneontology.org/ontology/function.ontology',\n\t\t\t\t\t\t\t 'http://www.geneontology.org/ontology/process.ontology',\n\t\t\t\t\t\t\t 'http://www.geneontology.org/ontology/component.ontology'\n\t\t\t\t\t\t\t],\n\t\t\tdefinitions => 'http://www.geneontology.org/ontology/GO.defs',\n         format => 'soflat',\n\t\t\t\t\t\t\t  },\n            };\n\n#aliases\n$instance->{Gene_Ontology} = $instance->{'Gene Ontology'};\n\nbless $instance, __PACKAGE__;\n}\n\n\nsub new {\n  return shift->get_instance(@_);\n}\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : my $singleton = Bio::Ontology::DocumentRegistry->get_instance();\n Function: constructor\n Returns : The Bio::Ontology::DocumentRegistry singleton.\n Args    : None\n Usage\n\n\nsub get_instance {\n  return $instance;\n}\n\n=head2 documents\n\n Title   : documents\n Usage   : my($ontology_url, $definitions_url, $format) = $obj->documents('Sequence Ontology');\n Function: Maps an ontology name to a list of (local or) remote URIs where the\n           files can be located.\n Returns : A 3-item list:\n           (1) URI for the ontology file\n           (2) URI for the ontology definitions file\n           (3) format of the files (dagedit, obo, etc)\n Args    : Name of an ontology, e.g. 'Sequence Ontology', or 'Cellular Component \n           (Gene Ontology)'","parameters":[{"label":"$self"},{"label":"$name"}],"label":"documents($self,$name)"},"detail":"($self,$name)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":163,"containerName":"documents","name":"$self","definition":"my","localvar":"my"},{"line":163,"kind":13,"containerName":"documents","name":"$name"},{"line":165,"kind":13,"name":"$self","containerName":"documents"},{"containerName":"documents","name":"$name","kind":13,"line":165},{"name":"$self","containerName":"documents","kind":13,"line":166},{"line":166,"kind":13,"containerName":"documents","name":"$name"},{"kind":13,"line":166,"containerName":"documents","name":"$self"},{"line":166,"kind":13,"name":"$name","containerName":"documents"},{"name":"$self","containerName":"documents","kind":13,"line":166},{"containerName":"documents","name":"$name","kind":13,"line":166}],"line":162,"kind":12,"range":{"end":{"line":170,"character":9999},"start":{"character":0,"line":162}},"name":"documents"},{"name":"ontology","kind":12,"line":166},{"name":"definitions","kind":12,"line":166},{"name":"format","kind":12,"line":166}]}