{"vars":[{"kind":2,"line":76,"name":"base","containerName":""},{"definition":"sub","containerName":"main::","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Scoring.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::Scoring\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::Scoring - Object which can hold scoring matrix information\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::Scoring;\n\n=head1 DESCRIPTION\n\nAn object which can handle AA or NT scoring matrix information.  Some\ntransformation properties are available too.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::Scoring;\nuse strict;\n\n\nuse base qw(Bio::Matrix::Generic);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::Scoring->new();\n Function: Builds a new Bio::Matrix::Scoring object \n Returns : an instance of Bio::Matrix::Scoring\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}]},"detail":"($class,@args)","kind":12,"children":[{"line":91,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"name":"@args","containerName":"new","line":91,"kind":13},{"kind":13,"line":92,"containerName":"new","name":"$self","definition":"my","localvar":"my"},{"containerName":"new","name":"$class","line":92,"kind":13},{"name":"@args","containerName":"new","kind":13,"line":92},{"line":94,"kind":13,"localvar":"my","containerName":"new","name":"$entropy","definition":"my"},{"line":94,"kind":13,"containerName":"new","name":"$expected"},{"name":"$scale","containerName":"new","line":94,"kind":13},{"name":"$scaleval","containerName":"new","line":94,"kind":13},{"name":"$database","containerName":"new","line":94,"kind":13},{"name":"$lowestscore","containerName":"new","line":95,"kind":13},{"name":"$highestscore","containerName":"new","kind":13,"line":95},{"line":95,"kind":13,"containerName":"new","name":"$lambda"},{"name":"$H","containerName":"new","line":95,"kind":13},{"line":96,"kind":13,"containerName":"new","name":"$self"},{"line":96,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","kind":13,"line":99},{"line":101,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":101,"name":"entropy","containerName":"new"},{"containerName":"new","name":"$entropy","line":101,"kind":13},{"line":102,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"expected_score","kind":12,"line":102},{"kind":13,"line":102,"name":"$expected","containerName":"new"},{"containerName":"new","name":"$self","line":103,"kind":13},{"containerName":"new","name":"scale","line":103,"kind":12},{"containerName":"new","name":"$scale","kind":13,"line":103},{"name":"$self","containerName":"new","line":104,"kind":13},{"line":104,"kind":12,"containerName":"new","name":"scale_value"},{"line":104,"kind":13,"containerName":"new","name":"$scaleval"},{"line":105,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"database","kind":12,"line":105},{"kind":13,"line":105,"containerName":"new","name":"$database"},{"name":"$self","containerName":"new","line":106,"kind":13},{"kind":12,"line":106,"containerName":"new","name":"lowest_score"},{"containerName":"new","name":"$lowestscore","kind":13,"line":106},{"containerName":"new","name":"$self","kind":13,"line":107},{"containerName":"new","name":"highest_score","kind":12,"line":107},{"line":107,"kind":13,"name":"$highestscore","containerName":"new"},{"line":108,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"lambda","kind":12,"line":108},{"line":108,"kind":13,"containerName":"new","name":"$lambda"},{"name":"$self","containerName":"new","line":109,"kind":13},{"name":"H","containerName":"new","kind":12,"line":109},{"line":109,"kind":13,"containerName":"new","name":"$H"},{"kind":13,"line":111,"name":"$self","containerName":"new"}],"line":90,"name":"new","range":{"start":{"line":90,"character":0},"end":{"line":112,"character":9999}}},{"containerName":"new","name":"SUPER","line":92,"kind":12},{"name":"entropy","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":131},"start":{"character":0,"line":126}},"kind":12,"children":[{"line":127,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"entropy"},{"name":"$self","containerName":"entropy","kind":13,"line":129},{"containerName":"entropy","name":"$self","kind":13,"line":130}],"line":126},{"definition":"sub","name":"expected_score","containerName":"main::","range":{"end":{"character":9999,"line":150},"start":{"line":145,"character":0}},"kind":12,"children":[{"kind":13,"line":146,"name":"$self","definition":"my","containerName":"expected_score","localvar":"my"},{"kind":13,"line":148,"name":"$self","containerName":"expected_score"},{"name":"$self","containerName":"expected_score","kind":13,"line":149}],"line":145},{"line":164,"children":[{"kind":13,"line":165,"name":"$self","definition":"my","containerName":"scale","localvar":"my"},{"kind":13,"line":167,"name":"$self","containerName":"scale"},{"name":"$self","containerName":"scale","line":168,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":164},"end":{"character":9999,"line":169}},"containerName":"main::","name":"scale","definition":"sub"},{"children":[{"containerName":"scale_value","definition":"my","name":"$self","localvar":"my","kind":13,"line":184},{"containerName":"scale_value","name":"$self","line":186,"kind":13},{"containerName":"scale_value","name":"$self","line":187,"kind":13}],"line":183,"kind":12,"range":{"start":{"line":183,"character":0},"end":{"line":188,"character":9999}},"definition":"sub","name":"scale_value","containerName":"main::"},{"range":{"end":{"character":9999,"line":207},"start":{"line":202,"character":0}},"name":"description","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"description","name":"$self","definition":"my","line":203,"kind":13},{"containerName":"description","name":"$self","line":205,"kind":13},{"line":206,"kind":13,"name":"$self","containerName":"description"}],"line":202,"kind":12},{"kind":12,"children":[{"kind":13,"line":222,"name":"$self","definition":"my","containerName":"database","localvar":"my"},{"line":224,"kind":13,"name":"$self","containerName":"database"},{"name":"$self","containerName":"database","line":225,"kind":13}],"line":221,"name":"database","definition":"sub","containerName":"main::","range":{"end":{"line":226,"character":9999},"start":{"character":0,"line":221}}},{"range":{"end":{"line":245,"character":9999},"start":{"line":240,"character":0}},"definition":"sub","name":"lowest_score","containerName":"main::","children":[{"line":241,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"lowest_score"},{"containerName":"lowest_score","name":"$self","line":243,"kind":13},{"line":244,"kind":13,"name":"$self","containerName":"lowest_score"}],"line":240,"kind":12},{"kind":12,"children":[{"containerName":"highest_score","name":"$self","definition":"my","localvar":"my","kind":13,"line":260},{"kind":13,"line":262,"containerName":"highest_score","name":"$self"},{"containerName":"highest_score","name":"$self","kind":13,"line":263}],"line":259,"definition":"sub","name":"highest_score","containerName":"main::","range":{"end":{"character":9999,"line":264},"start":{"character":0,"line":259}}},{"children":[{"containerName":"lambda","name":"$self","definition":"my","localvar":"my","kind":13,"line":279},{"name":"$self","containerName":"lambda","kind":13,"line":281},{"line":282,"kind":13,"containerName":"lambda","name":"$self"}],"line":278,"kind":12,"range":{"start":{"line":278,"character":0},"end":{"line":283,"character":9999}},"definition":"sub","name":"lambda","containerName":"main::"},{"range":{"start":{"line":297,"character":0},"end":{"character":9999,"line":301}},"name":"H","definition":"sub","containerName":"main::","children":[{"line":298,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"H"},{"kind":13,"line":299,"name":"$self","containerName":"H"},{"line":300,"kind":13,"containerName":"H","name":"$self"}],"line":297,"kind":12}],"version":5}