{"vars":[{"line":161,"kind":2,"name":"base","containerName":""},{"range":{"start":{"line":206,"character":0},"end":{"character":9999,"line":255}},"name":"new","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.","label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":206,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":207},{"name":"@args","containerName":"new","kind":13,"line":207},{"localvar":"my","containerName":"new","definition":"my","name":"$self","line":208,"kind":13},{"line":208,"kind":13,"name":"$class","containerName":"new"},{"line":208,"kind":13,"name":"@args","containerName":"new"},{"line":209,"kind":13,"localvar":"my","containerName":"new","name":"$consensus","definition":"my"},{"line":212,"kind":13,"localvar":"my","containerName":"new","name":"%input","definition":"my"},{"containerName":"new","name":"@args","line":213,"kind":13},{"name":"$key","definition":"my","containerName":"new","localvar":"my","kind":13,"line":214},{"line":214,"kind":13,"containerName":"new","name":"@args"},{"line":215,"kind":13,"name":"$input","containerName":"new"},{"line":215,"kind":13,"containerName":"new","name":"$key"},{"name":"@args","containerName":"new","kind":13,"line":215},{"line":217,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":218},{"name":"$input","containerName":"new","kind":13,"line":218},{"line":219,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$input","kind":13,"line":219},{"line":220,"kind":13,"containerName":"new","name":"$self"},{"line":220,"kind":13,"name":"$input","containerName":"new"},{"kind":13,"line":221,"containerName":"new","name":"$self"},{"name":"$input","containerName":"new","kind":13,"line":221},{"line":222,"kind":13,"name":"$self","containerName":"new"},{"line":222,"kind":13,"name":"$input","containerName":"new"},{"line":223,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$input","line":223,"kind":13},{"kind":13,"line":224,"containerName":"new","name":"$self"},{"kind":13,"line":224,"containerName":"new","name":"$input"},{"containerName":"new","name":"$self","kind":13,"line":225},{"name":"$input","containerName":"new","kind":13,"line":225},{"line":226,"kind":13,"containerName":"new","name":"$self"},{"name":"$input","containerName":"new","kind":13,"line":226},{"kind":13,"line":227,"containerName":"new","name":"$self"},{"line":227,"kind":13,"name":"$input","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":228},{"line":228,"kind":13,"containerName":"new","name":"$input"},{"containerName":"new","name":"$self","kind":13,"line":229},{"name":"$input","containerName":"new","line":229,"kind":13},{"line":229,"kind":13,"containerName":"new","name":"$input"},{"line":229,"kind":13,"containerName":"new","name":"$input"},{"name":"$input","containerName":"new","kind":13,"line":229},{"containerName":"new","name":"$input","kind":13,"line":233},{"kind":13,"line":234,"containerName":"new","name":"$self"},{"line":234,"kind":12,"containerName":"new","name":"throw"},{"containerName":"new","name":"$input","line":234,"kind":13},{"line":235,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":235,"name":"throw","containerName":"new"},{"containerName":"new","name":"$input","kind":13,"line":235},{"kind":13,"line":236,"name":"$self","containerName":"new"},{"kind":12,"line":236,"name":"throw","containerName":"new"},{"containerName":"new","name":"$input","kind":13,"line":236},{"name":"$self","containerName":"new","line":237,"kind":13},{"name":"$input","containerName":"new","kind":13,"line":237},{"kind":13,"line":238,"name":"$self","containerName":"new"},{"containerName":"new","name":"$input","kind":13,"line":238},{"containerName":"new","name":"$self","kind":13,"line":239},{"name":"$input","containerName":"new","kind":13,"line":239},{"kind":13,"line":240,"name":"$self","containerName":"new"},{"name":"$input","containerName":"new","line":240,"kind":13},{"name":"$self","containerName":"new","line":243,"kind":13},{"line":243,"kind":12,"containerName":"new","name":"throw"},{"name":"$input","containerName":"new","kind":13,"line":243},{"kind":13,"line":244,"name":"$self","containerName":"new"},{"name":"throw","containerName":"new","kind":12,"line":244},{"name":"$input","containerName":"new","line":244,"kind":13},{"kind":13,"line":245,"name":"$self","containerName":"new"},{"containerName":"new","name":"throw","line":245,"kind":12},{"line":245,"kind":13,"containerName":"new","name":"$input"},{"line":246,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$input","kind":13,"line":246},{"name":"$self","containerName":"new","line":247,"kind":13},{"name":"$input","containerName":"new","line":247,"kind":13},{"kind":13,"line":248,"containerName":"new","name":"$self"},{"kind":13,"line":248,"name":"$input","containerName":"new"},{"kind":13,"line":249,"containerName":"new","name":"$self"},{"line":249,"kind":13,"containerName":"new","name":"$input"},{"localvar":"my","definition":"my","name":"$i","containerName":"new","line":250,"kind":13},{"kind":13,"line":250,"containerName":"new","name":"$i"},{"line":250,"kind":13,"containerName":"new","name":"$self"},{"name":"$i","containerName":"new","kind":13,"line":250},{"name":"$self","containerName":"new","line":255,"kind":13},{"containerName":"new","name":"$i","kind":13,"line":255},{"containerName":"new","name":"$self","line":255,"kind":13}],"kind":12},{"containerName":"new","name":"SUPER","line":208,"kind":12},{"kind":12,"line":217,"name":"_position"},{"name":"IC","kind":12,"line":218},{"name":"IC","kind":12,"line":218},{"name":"e_val","kind":12,"line":219},{"name":"e_val","kind":12,"line":219},{"name":"width","line":220,"kind":12},{"line":220,"kind":12,"name":"width"},{"name":"logA","kind":12,"line":221},{"name":"lA","kind":12,"line":221},{"kind":12,"line":222,"name":"logC"},{"line":222,"kind":12,"name":"lC"},{"name":"logG","kind":12,"line":223},{"name":"lG","kind":12,"line":223},{"kind":12,"line":224,"name":"logT"},{"line":224,"kind":12,"name":"lT"},{"line":225,"kind":12,"name":"sites"},{"name":"sites","line":225,"kind":12},{"kind":12,"line":226,"name":"id"},{"kind":12,"line":226,"name":"id"},{"kind":12,"line":227,"name":"correction"},{"name":"correction","kind":12,"line":227},{"name":"accession_number","kind":12,"line":228},{"name":"accession_number","kind":12,"line":228},{"kind":12,"line":229,"name":"pA"},{"name":"pC","line":229,"kind":12},{"name":"pG","kind":12,"line":229},{"line":229,"kind":12,"name":"pT"},{"name":"pA","kind":12,"line":233},{"kind":12,"line":234,"name":"pC"},{"name":"pG","line":235,"kind":12},{"name":"pT","kind":12,"line":236},{"line":237,"kind":12,"name":"probA"},{"name":"pA","kind":12,"line":237},{"line":238,"kind":12,"name":"probC"},{"line":238,"kind":12,"name":"pC"},{"name":"probG","line":239,"kind":12},{"name":"pG","kind":12,"line":239},{"line":240,"kind":12,"name":"probT"},{"kind":12,"line":240,"name":"pT"},{"name":"pC","line":243,"kind":12},{"line":244,"kind":12,"name":"pG"},{"name":"pT","line":245,"kind":12},{"line":246,"kind":12,"name":"probA"},{"line":246,"kind":12,"name":"pA"},{"line":247,"kind":12,"name":"probC"},{"line":247,"kind":12,"name":"pC"},{"line":248,"kind":12,"name":"probG"},{"line":248,"kind":12,"name":"pG"},{"name":"probT","line":249,"kind":12},{"kind":12,"line":249,"name":"pT"},{"name":"probA","line":250,"kind":12},{"line":255,"kind":12,"name":"probA"},{"line":255,"kind":12,"name":"probA"},{"name":"%i","containerName":null,"line":255,"kind":13},{"line":256,"kind":13,"name":"%self","containerName":null},{"name":"probA","line":256,"kind":12},{"kind":13,"line":256,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","kind":13,"line":258},{"name":"probC","line":258,"kind":12},{"containerName":null,"name":"$i","line":258,"kind":13},{"line":258,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":258,"name":"probC"},{"containerName":null,"name":"%i","line":258,"kind":13},{"containerName":null,"name":"%self","line":259,"kind":13},{"name":"probC","kind":12,"line":259},{"line":259,"kind":13,"name":"$i","containerName":null},{"line":261,"kind":13,"name":"%self","containerName":null},{"name":"probG","line":261,"kind":12},{"containerName":null,"name":"$i","line":261,"kind":13},{"name":"%self","containerName":null,"line":261,"kind":13},{"line":261,"kind":12,"name":"probG"},{"line":261,"kind":13,"name":"%i","containerName":null},{"line":262,"kind":13,"containerName":null,"name":"%self"},{"line":262,"kind":12,"name":"probG"},{"kind":13,"line":262,"name":"$i","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":264},{"kind":12,"line":264,"name":"probT"},{"containerName":null,"name":"$i","line":264,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":264},{"name":"probT","line":264,"kind":12},{"name":"%i","containerName":null,"kind":13,"line":264},{"kind":13,"line":265,"name":"%self","containerName":null},{"name":"probT","kind":12,"line":265},{"containerName":null,"name":"$i","kind":13,"line":265},{"line":271,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":null},{"kind":13,"line":271,"containerName":null,"name":"$i"},{"name":"%self","containerName":null,"line":271,"kind":13},{"kind":12,"line":271,"name":"probA"},{"name":"%i","containerName":null,"kind":13,"line":271},{"containerName":null,"name":"%self","kind":13,"line":272},{"kind":12,"line":272,"name":"probA"},{"kind":13,"line":272,"name":"$i","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":272},{"line":272,"kind":12,"name":"probC"},{"kind":13,"line":272,"name":"$i","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":272},{"line":272,"kind":12,"name":"probG"},{"containerName":null,"name":"$i","line":272,"kind":13},{"kind":13,"line":272,"containerName":null,"name":"%self"},{"name":"probT","kind":12,"line":272},{"containerName":null,"name":"%i","kind":13,"line":272},{"containerName":null,"name":"$self","kind":13,"line":273},{"containerName":"main::","name":"throw","kind":12,"line":273},{"kind":13,"line":279,"name":"%self","containerName":null},{"name":"correction","kind":12,"line":279},{"kind":13,"line":280,"containerName":null,"name":"%self"},{"line":280,"kind":12,"name":"probA"},{"kind":13,"line":280,"name":"$i","containerName":null},{"name":"%self","containerName":null,"line":280,"kind":13},{"name":"correction","kind":12,"line":280},{"name":"%self","containerName":null,"kind":13,"line":281},{"line":281,"kind":12,"name":"probC"},{"kind":13,"line":281,"name":"$i","containerName":null},{"kind":13,"line":281,"containerName":null,"name":"%self"},{"name":"correction","line":281,"kind":12},{"name":"%self","containerName":null,"kind":13,"line":282},{"name":"probG","kind":12,"line":282},{"line":282,"kind":13,"name":"$i","containerName":null},{"line":282,"kind":13,"containerName":null,"name":"%self"},{"name":"correction","kind":12,"line":282},{"name":"%self","containerName":null,"kind":13,"line":283},{"name":"probT","line":283,"kind":12},{"kind":13,"line":283,"name":"$i","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":283},{"line":283,"kind":12,"name":"correction"},{"line":287,"kind":13,"localvar":"my","name":"$div","definition":"my","containerName":null},{"kind":13,"line":287,"containerName":null,"name":"%self"},{"line":287,"kind":12,"name":"probA"},{"name":"$i","containerName":null,"kind":13,"line":287},{"line":287,"kind":13,"containerName":null,"name":"%self"},{"name":"probC","line":287,"kind":12},{"name":"$i","containerName":null,"kind":13,"line":287},{"kind":13,"line":287,"containerName":null,"name":"%self"},{"name":"probG","line":287,"kind":12},{"containerName":null,"name":"$i","kind":13,"line":287},{"kind":13,"line":287,"containerName":null,"name":"%self"},{"line":287,"kind":12,"name":"probT"},{"name":"$i","containerName":null,"line":287,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":288},{"name":"probA","line":288,"kind":12},{"kind":13,"line":288,"name":"$i","containerName":null},{"line":288,"kind":13,"containerName":null,"name":"%self"},{"line":288,"kind":12,"name":"probA"},{"kind":13,"line":288,"name":"$i","containerName":null},{"kind":13,"line":288,"name":"$div","containerName":null},{"containerName":null,"name":"%self","line":289,"kind":13},{"line":289,"kind":12,"name":"probC"},{"name":"$i","containerName":null,"kind":13,"line":289},{"name":"%self","containerName":null,"line":289,"kind":13},{"kind":12,"line":289,"name":"probC"},{"kind":13,"line":289,"name":"$i","containerName":null},{"name":"$div","containerName":null,"kind":13,"line":289},{"kind":13,"line":290,"name":"%self","containerName":null},{"line":290,"kind":12,"name":"probG"},{"kind":13,"line":290,"name":"$i","containerName":null},{"line":290,"kind":13,"containerName":null,"name":"%self"},{"line":290,"kind":12,"name":"probG"},{"name":"$i","containerName":null,"kind":13,"line":290},{"name":"$div","containerName":null,"line":290,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":291},{"name":"probT","kind":12,"line":291},{"kind":13,"line":291,"name":"$i","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":291},{"name":"probT","kind":12,"line":291},{"containerName":null,"name":"$i","kind":13,"line":291},{"containerName":null,"name":"$div","line":291,"kind":13},{"name":"%self","containerName":null,"kind":13,"line":295},{"name":"logA","line":295,"kind":12},{"kind":13,"line":295,"containerName":null,"name":"%input"},{"name":"model","line":295,"kind":12},{"name":"$self","containerName":null,"line":296,"kind":13},{"name":"calc_weight","containerName":"main::","line":296,"kind":12},{"line":296,"kind":13,"containerName":null,"name":"%input"},{"line":296,"kind":12,"name":"model"},{"containerName":null,"name":"$self","kind":13,"line":300},{"name":"_calculate_consensus","containerName":"main::","kind":12,"line":300},{"containerName":null,"name":"$self","kind":13,"line":301},{"range":{"end":{"line":313,"character":9999},"start":{"line":311,"character":0}},"containerName":"main::","definition":"sub","name":"_calculate_consensus","line":311,"children":[{"localvar":"my","containerName":"_calculate_consensus","definition":"my","name":"$self","line":312,"kind":13},{"line":313,"kind":13,"localvar":"my","containerName":"_calculate_consensus","name":"$lc","definition":"my"},{"line":313,"kind":13,"containerName":"_calculate_consensus","name":"$lt"},{"line":313,"kind":13,"name":"$lg","containerName":"_calculate_consensus"},{"containerName":"_calculate_consensus","name":"$self","line":313,"kind":13}],"kind":12},{"line":313,"kind":12,"name":"probC"},{"kind":13,"line":313,"name":"%self","containerName":null},{"name":"probT","kind":12,"line":313},{"name":"%self","containerName":null,"line":313,"kind":13},{"name":"probG","line":313,"kind":12},{"line":314,"kind":13,"localvar":"my","containerName":null,"name":"$len","definition":"my"},{"line":314,"kind":13,"name":"%self","containerName":null},{"name":"probA","line":314,"kind":12},{"line":315,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"line":315,"name":"throw","containerName":"main::"},{"line":315,"kind":13,"name":"$len","containerName":null},{"containerName":null,"name":"$lc","kind":13,"line":315},{"containerName":null,"name":"$self","kind":13,"line":316},{"name":"throw","containerName":"main::","line":316,"kind":12},{"name":"$len","containerName":null,"line":316,"kind":13},{"name":"$lt","containerName":null,"kind":13,"line":316},{"containerName":null,"name":"$self","line":317,"kind":13},{"line":317,"kind":12,"name":"throw","containerName":"main::"},{"containerName":null,"name":"$len","kind":13,"line":317},{"name":"$lg","containerName":null,"line":317,"kind":13},{"kind":13,"line":318,"containerName":null,"name":"$i","definition":"my","localvar":"my"},{"line":318,"kind":13,"containerName":null,"name":"$i"},{"name":"$len","containerName":null,"line":318,"kind":13},{"kind":13,"line":318,"containerName":null,"name":"%i"},{"name":"%self","containerName":null,"kind":13,"line":320},{"line":320,"kind":12,"name":"IUPAC"},{"line":320,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","line":320,"kind":13},{"name":"IUPACp","line":320,"kind":12},{"kind":13,"line":320,"containerName":null,"name":"$i"},{"kind":12,"line":320,"name":"_to_IUPAC"},{"containerName":null,"name":"%self","kind":13,"line":320},{"name":"probA","line":320,"kind":12},{"line":320,"kind":13,"name":"$i","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":320},{"line":320,"kind":12,"name":"probC"},{"line":320,"kind":13,"name":"$i","containerName":null},{"line":320,"kind":13,"containerName":null,"name":"%self"},{"name":"probG","kind":12,"line":320},{"line":320,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","line":320,"kind":13},{"name":"probT","kind":12,"line":320},{"line":320,"kind":13,"name":"$i","containerName":null},{"line":321,"kind":13,"containerName":null,"name":"%self"},{"name":"seq","kind":12,"line":321},{"line":321,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","kind":13,"line":321},{"kind":12,"line":321,"name":"seqp"},{"name":"$i","containerName":null,"line":321,"kind":13},{"kind":12,"line":321,"name":"_to_cons"},{"line":321,"kind":13,"containerName":null,"name":"%self"},{"name":"probA","kind":12,"line":321},{"name":"$i","containerName":null,"line":321,"kind":13},{"line":321,"kind":13,"containerName":null,"name":"%self"},{"line":321,"kind":12,"name":"probC"},{"kind":13,"line":321,"name":"$i","containerName":null},{"kind":13,"line":321,"containerName":null,"name":"%self"},{"name":"probG","line":321,"kind":12},{"containerName":null,"name":"$i","kind":13,"line":321},{"name":"%self","containerName":null,"line":321,"kind":13},{"name":"probT","line":321,"kind":12},{"line":321,"kind":13,"name":"$i","containerName":null},{"containerName":null,"name":"$self","line":323,"kind":13},{"children":[{"localvar":"my","containerName":"calc_weight","name":"$self","definition":"my","line":339,"kind":13},{"containerName":"calc_weight","name":"$model","line":339,"kind":13},{"containerName":"calc_weight","definition":"my","name":"%model","localvar":"my","kind":13,"line":340},{"name":"$model","containerName":"calc_weight","line":341,"kind":13},{"name":"$model","containerName":"calc_weight","kind":13,"line":341},{"line":342,"kind":13,"containerName":"calc_weight","name":"$model"},{"name":"$model","containerName":"calc_weight","kind":13,"line":342},{"line":343,"kind":13,"containerName":"calc_weight","name":"$model"},{"kind":13,"line":343,"name":"$model","containerName":"calc_weight"},{"containerName":"calc_weight","name":"$model","line":344,"kind":13},{"line":344,"kind":13,"containerName":"calc_weight","name":"$model"},{"localvar":"my","name":"$let","definition":"my","containerName":"calc_weight","line":345,"kind":13},{"line":346,"kind":13,"localvar":"my","containerName":"calc_weight","definition":"my","name":"@str"},{"name":"$self","containerName":"calc_weight","kind":13,"line":347},{"containerName":"calc_weight","name":"throw","line":347,"kind":12},{"containerName":"calc_weight","name":"$model","line":347,"kind":13},{"line":347,"kind":13,"containerName":"calc_weight","name":"$let"},{"kind":13,"line":347,"containerName":"calc_weight","name":"$model"},{"kind":13,"line":347,"containerName":"calc_weight","name":"$let"},{"line":348,"kind":13,"localvar":"my","name":"$f","definition":"my","containerName":"calc_weight"},{"containerName":"calc_weight","name":"$self","kind":13,"line":348},{"name":"$let","containerName":"calc_weight","line":348,"kind":13},{"kind":13,"line":349,"definition":"my","name":"$w","containerName":"calc_weight","localvar":"my"},{"containerName":"calc_weight","name":"$f","kind":13,"line":349},{"name":"$model","containerName":"calc_weight","line":349,"kind":13},{"name":"$let","containerName":"calc_weight","line":349,"kind":13},{"name":"@str","containerName":"calc_weight","line":350,"kind":13},{"name":"$w","containerName":"calc_weight","kind":13,"line":350},{"name":"$llet","definition":"my","containerName":"calc_weight","localvar":"my","kind":13,"line":352},{"kind":13,"line":352,"containerName":"calc_weight","name":"$let"},{"kind":13,"line":353,"containerName":"calc_weight","name":"$llet"},{"name":"$self","containerName":"calc_weight","line":354,"kind":13},{"line":354,"kind":13,"name":"$llet","containerName":"calc_weight"},{"containerName":"calc_weight","name":"@str","kind":13,"line":354}],"line":338,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$model"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T","label":"calc_weight($self,$model)"},"detail":"($self,$model)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":355},"start":{"line":338,"character":0}},"name":"calc_weight"},{"name":"probA","kind":12,"line":341},{"kind":12,"line":342,"name":"probC"},{"line":343,"kind":12,"name":"probG"},{"kind":12,"line":344,"name":"probT"},{"containerName":null,"name":"$self","kind":13,"line":356},{"kind":12,"line":371,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_pos","line":372,"kind":13},{"line":373,"kind":13,"name":"$self","containerName":"next_pos"},{"kind":12,"line":373,"name":"throw","containerName":"next_pos"},{"name":"$self","containerName":"next_pos","kind":13,"line":373},{"kind":13,"line":374,"definition":"my","name":"$len","containerName":"next_pos","localvar":"my"},{"line":374,"kind":13,"name":"$self","containerName":"next_pos"}],"containerName":"main::","definition":"sub","name":"next_pos","range":{"start":{"line":371,"character":0},"end":{"line":374,"character":9999}}},{"kind":12,"line":374,"name":"seq"},{"line":375,"kind":13,"localvar":"my","name":"$pos","definition":"my","containerName":null},{"line":375,"kind":13,"name":"%self","containerName":null},{"line":375,"kind":12,"name":"_position"},{"containerName":null,"name":"$pos","line":377,"kind":13},{"kind":13,"line":377,"containerName":null,"name":"%len"},{"containerName":null,"name":"$pA","definition":"my","localvar":"my","kind":13,"line":378},{"line":378,"kind":13,"containerName":null,"name":"%self"},{"name":"probA","line":378,"kind":12},{"name":"$pos","containerName":null,"kind":13,"line":378},{"kind":13,"line":379,"name":"$pC","definition":"my","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":379},{"line":379,"kind":12,"name":"probC"},{"line":379,"kind":13,"containerName":null,"name":"$pos"},{"kind":13,"line":380,"containerName":null,"definition":"my","name":"$pG","localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":380},{"line":380,"kind":12,"name":"probG"},{"kind":13,"line":380,"name":"$pos","containerName":null},{"line":381,"kind":13,"localvar":"my","containerName":null,"name":"$pT","definition":"my"},{"containerName":null,"name":"%self","kind":13,"line":381},{"name":"probT","kind":12,"line":381},{"containerName":null,"name":"$pos","line":381,"kind":13},{"kind":13,"line":382,"name":"$lA","definition":"my","containerName":null,"localvar":"my"},{"name":"%self","containerName":null,"kind":13,"line":382},{"kind":12,"line":382,"name":"logA"},{"line":382,"kind":13,"name":"$pos","containerName":null},{"definition":"my","name":"$lC","containerName":null,"localvar":"my","kind":13,"line":383},{"kind":13,"line":383,"name":"%self","containerName":null},{"line":383,"kind":12,"name":"logC"},{"line":383,"kind":13,"containerName":null,"name":"$pos"},{"line":384,"kind":13,"localvar":"my","definition":"my","name":"$lG","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":384},{"kind":12,"line":384,"name":"logG"},{"containerName":null,"name":"$pos","line":384,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"$lT","line":385,"kind":13},{"line":385,"kind":13,"containerName":null,"name":"%self"},{"name":"logT","line":385,"kind":12},{"name":"$pos","containerName":null,"line":385,"kind":13},{"kind":13,"line":386,"containerName":null,"definition":"my","name":"$base","localvar":"my"},{"kind":13,"line":386,"name":"%self","containerName":null},{"name":"seq","line":386,"kind":12},{"name":"$pos","containerName":null,"line":386,"kind":13},{"localvar":"my","definition":"my","name":"$prob","containerName":null,"line":387,"kind":13},{"line":387,"kind":13,"name":"%self","containerName":null},{"name":"seqp","kind":12,"line":387},{"name":"$pos","containerName":null,"line":387,"kind":13},{"kind":13,"line":388,"containerName":null,"name":"%self"},{"name":"_position","kind":12,"line":388},{"kind":13,"line":389,"definition":"my","name":"%seq","containerName":null,"localvar":"my"},{"name":"pA","line":389,"kind":12},{"name":"$pA","containerName":null,"line":389,"kind":13},{"kind":12,"line":389,"name":"pT"},{"name":"$pT","containerName":null,"line":389,"kind":13},{"name":"pC","line":389,"kind":12},{"line":389,"kind":13,"containerName":null,"name":"$pC"},{"name":"pG","line":389,"kind":12},{"containerName":null,"name":"$pG","kind":13,"line":389},{"line":389,"kind":12,"name":"lA"},{"kind":13,"line":389,"containerName":null,"name":"$lA"},{"name":"lT","kind":12,"line":389},{"name":"$lT","containerName":null,"line":389,"kind":13},{"name":"lC","line":389,"kind":12},{"name":"$lC","containerName":null,"line":389,"kind":13},{"line":389,"kind":12,"name":"lG"},{"name":"$lG","containerName":null,"kind":13,"line":389},{"line":389,"kind":12,"name":"base"},{"containerName":null,"name":"$base","kind":13,"line":389},{"line":389,"kind":12,"name":"rel"},{"kind":13,"line":389,"containerName":null,"name":"$pos"},{"name":"prob","kind":12,"line":389},{"name":"$prob","containerName":null,"kind":13,"line":389},{"name":"%seq","containerName":null,"line":390,"kind":13},{"containerName":null,"name":"%self","line":392,"kind":13},{"kind":12,"line":392,"name":"_position"},{"kind":12,"children":[{"line":407,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"curpos"},{"name":"$prev","definition":"my","containerName":"curpos","localvar":"my","kind":13,"line":408},{"name":"$self","containerName":"curpos","kind":13,"line":408},{"line":409,"kind":13,"name":"$self","containerName":"curpos"},{"line":410,"kind":13,"containerName":"curpos","name":"$prev"}],"line":406,"definition":"sub","name":"curpos","containerName":"main::","range":{"end":{"character":9999,"line":411},"start":{"line":406,"character":0}}},{"kind":12,"line":408,"name":"_position"},{"name":"_position","kind":12,"line":409},{"name":"e_val","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":423},"end":{"line":428,"character":9999}},"kind":12,"children":[{"line":424,"kind":13,"localvar":"my","containerName":"e_val","definition":"my","name":"$self"},{"line":425,"kind":13,"localvar":"my","containerName":"e_val","definition":"my","name":"$prev"},{"containerName":"e_val","name":"$self","line":425,"kind":13},{"line":426,"kind":13,"containerName":"e_val","name":"$self"},{"containerName":"e_val","name":"$prev","line":427,"kind":13}],"line":423},{"line":425,"kind":12,"name":"e_val"},{"kind":12,"line":426,"name":"e_val"},{"kind":12,"line":440,"children":[{"name":"$self","definition":"my","containerName":"IC","localvar":"my","kind":13,"line":441},{"localvar":"my","containerName":"IC","definition":"my","name":"$prev","line":442,"kind":13},{"name":"$self","containerName":"IC","kind":13,"line":442},{"kind":13,"line":443,"containerName":"IC","name":"$self"},{"name":"$prev","containerName":"IC","kind":13,"line":444}],"containerName":"main::","definition":"sub","name":"IC","range":{"end":{"character":9999,"line":445},"start":{"line":440,"character":0}}},{"kind":12,"line":442,"name":"IC"},{"name":"IC","kind":12,"line":443},{"children":[{"kind":13,"line":459,"containerName":"accession_number","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","name":"$prev","definition":"my","containerName":"accession_number","line":460,"kind":13},{"name":"$self","containerName":"accession_number","kind":13,"line":460},{"kind":13,"line":461,"containerName":"accession_number","name":"$self"},{"line":462,"kind":13,"name":"$prev","containerName":"accession_number"}],"line":458,"kind":12,"range":{"end":{"line":463,"character":9999},"start":{"character":0,"line":458}},"definition":"sub","name":"accession_number","containerName":"main::"},{"kind":12,"line":460,"name":"accession_number"},{"line":461,"kind":12,"name":"accession_number"},{"line":477,"children":[{"kind":13,"line":478,"definition":"my","name":"$self","containerName":"consensus","localvar":"my"},{"name":"$thresh","containerName":"consensus","kind":13,"line":478},{"containerName":"consensus","name":"$thresh","kind":13,"line":479},{"line":480,"kind":13,"localvar":"my","containerName":"consensus","name":"$len","definition":"my"},{"containerName":"consensus","name":"$self","kind":13,"line":480},{"definition":"my","name":"$i","containerName":"consensus","localvar":"my","kind":13,"line":481},{"line":481,"kind":13,"name":"$i","containerName":"consensus"},{"kind":13,"line":481,"name":"$len","containerName":"consensus"},{"kind":13,"line":481,"name":"$i","containerName":"consensus"},{"name":"$self","containerName":"consensus","kind":13,"line":482},{"line":482,"kind":13,"name":"$i","containerName":"consensus"},{"kind":13,"line":482,"containerName":"consensus","name":"$self"}],"kind":12,"detail":"($self,$thresh)","signature":{"label":"consensus($self,$thresh)","parameters":[{"label":"$self"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position"},"containerName":"main::","definition":"sub","range":{"start":{"line":477,"character":0},"end":{"line":482,"character":9999}},"name":"consensus"},{"name":"probA","kind":12,"line":480},{"line":482,"kind":12,"name":"seq"},{"line":482,"kind":12,"name":"seqp"},{"kind":13,"line":482,"containerName":null,"name":"$i"},{"kind":12,"line":482,"name":"_to_cons"},{"kind":13,"line":482,"containerName":null,"name":"%self"},{"kind":12,"line":482,"name":"probA"},{"kind":13,"line":482,"containerName":null,"name":"$i"},{"kind":13,"line":482,"containerName":null,"name":"%self"},{"line":482,"kind":12,"name":"probC"},{"line":482,"kind":13,"name":"$i","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":482},{"line":482,"kind":12,"name":"probG"},{"name":"$i","containerName":null,"kind":13,"line":482},{"containerName":null,"name":"%self","kind":13,"line":482},{"name":"probT","line":482,"kind":12},{"line":482,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"line":482,"containerName":null,"name":"$thresh"},{"line":485,"kind":13,"localvar":"my","definition":"my","name":"$consensus","containerName":null},{"definition":"my","name":"$letter","containerName":null,"localvar":"my","kind":13,"line":486},{"containerName":null,"name":"%self","kind":13,"line":486},{"name":"seq","line":486,"kind":12},{"containerName":null,"name":"$consensus","line":487,"kind":13},{"line":487,"kind":13,"containerName":null,"name":"$letter"},{"kind":13,"line":489,"containerName":null,"name":"$consensus"},{"kind":12,"children":[{"containerName":"width","definition":"my","name":"$self","localvar":"my","kind":13,"line":503},{"localvar":"my","containerName":"width","name":"$width","definition":"my","line":504,"kind":13},{"kind":13,"line":504,"containerName":"width","name":"$self"}],"line":502,"definition":"sub","name":"width","containerName":"main::","range":{"end":{"line":504,"character":9999},"start":{"line":502,"character":0}}},{"name":"probA","kind":12,"line":504},{"line":505,"kind":13,"containerName":null,"name":"$width"},{"kind":12,"line":518,"children":[{"kind":13,"line":519,"containerName":"sites","name":"$self","definition":"my","localvar":"my"},{"line":520,"kind":13,"containerName":"sites","name":"$self"},{"name":"$self","containerName":"sites","line":521,"kind":13}],"containerName":"main::","name":"sites","definition":"sub","range":{"start":{"character":0,"line":518},"end":{"character":9999,"line":522}}},{"line":520,"kind":12,"name":"sites"},{"name":"sites","kind":12,"line":521},{"name":"IUPAC","range":{"end":{"character":9999,"line":542},"start":{"character":0,"line":537}},"containerName":"main::","definition":"sub","detail":"($self,$thresh)","signature":{"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.","parameters":[{"label":"$self"},{"label":"$thresh"}],"label":"IUPAC($self,$thresh)"},"kind":12,"line":537,"children":[{"localvar":"my","containerName":"IUPAC","definition":"my","name":"$self","line":538,"kind":13},{"kind":13,"line":538,"name":"$thresh","containerName":"IUPAC"},{"line":539,"kind":13,"containerName":"IUPAC","name":"$thresh"},{"localvar":"my","containerName":"IUPAC","definition":"my","name":"$len","line":540,"kind":13},{"name":"$self","containerName":"IUPAC","line":540,"kind":13},{"line":541,"kind":13,"localvar":"my","containerName":"IUPAC","name":"$i","definition":"my"},{"line":541,"kind":13,"name":"$i","containerName":"IUPAC"},{"name":"$len","containerName":"IUPAC","kind":13,"line":541},{"containerName":"IUPAC","name":"$i","line":541,"kind":13},{"line":542,"kind":13,"containerName":"IUPAC","name":"$self"},{"kind":13,"line":542,"name":"$i","containerName":"IUPAC"},{"kind":13,"line":542,"containerName":"IUPAC","name":"$self"}]},{"name":"probA","kind":12,"line":540},{"kind":12,"line":542,"name":"IUPAC"},{"line":542,"kind":12,"name":"IUPACp"},{"name":"$i","containerName":null,"line":542,"kind":13},{"line":542,"kind":12,"name":"_to_IUPAC"},{"containerName":null,"name":"%self","kind":13,"line":542},{"kind":12,"line":542,"name":"probA"},{"name":"$i","containerName":null,"line":542,"kind":13},{"line":542,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":542,"name":"probC"},{"containerName":null,"name":"$i","line":542,"kind":13},{"line":542,"kind":13,"name":"%self","containerName":null},{"kind":12,"line":542,"name":"probG"},{"line":542,"kind":13,"name":"$i","containerName":null},{"line":542,"kind":13,"name":"%self","containerName":null},{"name":"probT","kind":12,"line":542},{"line":542,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":542,"name":"$thresh","containerName":null},{"containerName":null,"name":"$iu","definition":"my","localvar":"my","kind":13,"line":545},{"kind":13,"line":545,"name":"%self","containerName":null},{"name":"IUPAC","line":545,"kind":12},{"localvar":"my","definition":"my","name":"$iupac","containerName":null,"line":546,"kind":13},{"kind":13,"line":547,"name":"$let","definition":"my","containerName":null,"localvar":"my"},{"name":"%iu","containerName":null,"line":547,"kind":13},{"kind":13,"line":548,"name":"$iupac","containerName":null},{"containerName":null,"name":"$let","line":548,"kind":13},{"name":"$iupac","containerName":null,"line":550,"kind":13},{"signature":{"parameters":[{"label":"$a"},{"label":"$c"},{"label":"$g"},{"label":"$t"},{"label":"$thresh"}],"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.","label":"_to_IUPAC($a,$c,$g,$t,$thresh)"},"detail":"($a,$c,$g,$t,$thresh)","definition":"sub","containerName":"main::","children":[{"line":570,"kind":13,"localvar":"my","containerName":"_to_IUPAC","name":"$a","definition":"my"},{"kind":13,"line":570,"name":"$c","containerName":"_to_IUPAC"},{"line":570,"kind":13,"containerName":"_to_IUPAC","name":"$g"},{"kind":13,"line":570,"name":"$t","containerName":"_to_IUPAC"},{"line":570,"kind":13,"name":"$thresh","containerName":"_to_IUPAC"},{"kind":13,"line":571,"name":"$thresh","containerName":"_to_IUPAC"},{"containerName":"_to_IUPAC","name":"$thresh","kind":13,"line":572},{"line":572,"kind":13,"name":"$thresh","containerName":"_to_IUPAC"},{"name":"$a","containerName":"_to_IUPAC","kind":13,"line":573},{"name":"$a","containerName":"_to_IUPAC","kind":13,"line":573},{"containerName":"_to_IUPAC","name":"$c","kind":13,"line":574},{"kind":13,"line":574,"containerName":"_to_IUPAC","name":"$c"},{"line":575,"kind":13,"name":"$g","containerName":"_to_IUPAC"},{"containerName":"_to_IUPAC","name":"$g","line":575,"kind":13},{"name":"$t","containerName":"_to_IUPAC","line":576,"kind":13},{"containerName":"_to_IUPAC","name":"$t","kind":13,"line":576},{"line":578,"kind":13,"localvar":"my","name":"$total","definition":"my","containerName":"_to_IUPAC"},{"containerName":"_to_IUPAC","name":"$a","kind":13,"line":578},{"kind":13,"line":578,"containerName":"_to_IUPAC","name":"$c"},{"kind":13,"line":578,"containerName":"_to_IUPAC","name":"$g"},{"line":578,"kind":13,"containerName":"_to_IUPAC","name":"$t"},{"name":"$a","containerName":"_to_IUPAC","line":580,"kind":13},{"kind":13,"line":580,"containerName":"_to_IUPAC","name":"$total"},{"kind":13,"line":581,"name":"$g","containerName":"_to_IUPAC"},{"kind":13,"line":581,"name":"$total","containerName":"_to_IUPAC"},{"line":582,"kind":13,"name":"$c","containerName":"_to_IUPAC"},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":582},{"kind":13,"line":583,"containerName":"_to_IUPAC","name":"$t"},{"kind":13,"line":583,"containerName":"_to_IUPAC","name":"$total"},{"localvar":"my","name":"$r","definition":"my","containerName":"_to_IUPAC","line":584,"kind":13},{"name":"$g","containerName":"_to_IUPAC","kind":13,"line":584},{"name":"$a","containerName":"_to_IUPAC","kind":13,"line":584},{"kind":13,"line":585,"containerName":"_to_IUPAC","name":"$r"},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":585},{"kind":13,"line":586,"name":"$y","definition":"my","containerName":"_to_IUPAC","localvar":"my"},{"containerName":"_to_IUPAC","name":"$t","kind":13,"line":586},{"name":"$c","containerName":"_to_IUPAC","line":586,"kind":13},{"line":587,"kind":13,"containerName":"_to_IUPAC","name":"$y"},{"line":587,"kind":13,"name":"$total","containerName":"_to_IUPAC"},{"localvar":"my","name":"$m","definition":"my","containerName":"_to_IUPAC","line":588,"kind":13},{"kind":13,"line":588,"containerName":"_to_IUPAC","name":"$a"},{"containerName":"_to_IUPAC","name":"$c","line":588,"kind":13},{"kind":13,"line":589,"name":"$m","containerName":"_to_IUPAC"},{"kind":13,"line":589,"containerName":"_to_IUPAC","name":"$total"},{"line":590,"kind":13,"localvar":"my","name":"$k","definition":"my","containerName":"_to_IUPAC"},{"kind":13,"line":590,"containerName":"_to_IUPAC","name":"$g"},{"line":590,"kind":13,"name":"$t","containerName":"_to_IUPAC"},{"kind":13,"line":591,"name":"$k","containerName":"_to_IUPAC"},{"name":"$total","containerName":"_to_IUPAC","line":591,"kind":13},{"name":"$s","definition":"my","containerName":"_to_IUPAC","localvar":"my","kind":13,"line":592},{"line":592,"kind":13,"name":"$g","containerName":"_to_IUPAC"},{"line":592,"kind":13,"containerName":"_to_IUPAC","name":"$c"},{"line":593,"kind":13,"containerName":"_to_IUPAC","name":"$s"},{"containerName":"_to_IUPAC","name":"$total","kind":13,"line":593},{"kind":13,"line":594,"name":"$w","definition":"my","containerName":"_to_IUPAC","localvar":"my"},{"containerName":"_to_IUPAC","name":"$a","line":594,"kind":13},{"line":594,"kind":13,"name":"$t","containerName":"_to_IUPAC"},{"line":595,"kind":13,"name":"$w","containerName":"_to_IUPAC"},{"line":595,"kind":13,"name":"$total","containerName":"_to_IUPAC"},{"localvar":"my","definition":"my","name":"$d","containerName":"_to_IUPAC","line":596,"kind":13},{"name":"$r","containerName":"_to_IUPAC","kind":13,"line":596},{"line":596,"kind":13,"name":"$t","containerName":"_to_IUPAC"},{"containerName":"_to_IUPAC","name":"$d","kind":13,"line":597},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":597},{"containerName":"_to_IUPAC","definition":"my","name":"$v","localvar":"my","kind":13,"line":598},{"name":"$r","containerName":"_to_IUPAC","kind":13,"line":598},{"kind":13,"line":598,"name":"$c","containerName":"_to_IUPAC"},{"line":599,"kind":13,"containerName":"_to_IUPAC","name":"$v"},{"name":"$total","containerName":"_to_IUPAC","kind":13,"line":599},{"localvar":"my","name":"$b","definition":"my","containerName":"_to_IUPAC","line":600,"kind":13},{"name":"$y","containerName":"_to_IUPAC","kind":13,"line":600},{"kind":13,"line":600,"name":"$g","containerName":"_to_IUPAC"},{"line":601,"kind":13,"containerName":"_to_IUPAC","name":"$b"},{"line":601,"kind":13,"name":"$total","containerName":"_to_IUPAC"},{"name":"$h","definition":"my","containerName":"_to_IUPAC","localvar":"my","kind":13,"line":602},{"line":602,"kind":13,"containerName":"_to_IUPAC","name":"$y"},{"line":602,"kind":13,"name":"$a","containerName":"_to_IUPAC"},{"kind":13,"line":603,"containerName":"_to_IUPAC","name":"$h"},{"containerName":"_to_IUPAC","name":"$total","kind":13,"line":603}],"line":569,"kind":12,"range":{"end":{"line":605,"character":9999},"start":{"character":0,"line":569}},"name":"_to_IUPAC"},{"name":"_to_cons","range":{"start":{"line":621,"character":0},"end":{"line":642,"character":9999}},"containerName":"main::","definition":"sub","detail":"($A,$C,$G,$T,$thresh)","signature":{"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)","parameters":[{"label":"$A"},{"label":"$C"},{"label":"$G"},{"label":"$T"},{"label":"$thresh"}],"label":"_to_cons($A,$C,$G,$T,$thresh)"},"kind":12,"line":621,"children":[{"line":622,"kind":13,"localvar":"my","name":"$A","definition":"my","containerName":"_to_cons"},{"line":622,"kind":13,"containerName":"_to_cons","name":"$C"},{"name":"$G","containerName":"_to_cons","kind":13,"line":622},{"name":"$T","containerName":"_to_cons","line":622,"kind":13},{"kind":13,"line":622,"containerName":"_to_cons","name":"$thresh"},{"containerName":"_to_cons","name":"$thresh","kind":13,"line":623},{"line":626,"kind":13,"localvar":"my","definition":"my","name":"$a","containerName":"_to_cons"},{"name":"$A","containerName":"_to_cons","line":626,"kind":13},{"containerName":"_to_cons","definition":"my","name":"$c","localvar":"my","kind":13,"line":627},{"containerName":"_to_cons","name":"$C","kind":13,"line":627},{"line":628,"kind":13,"localvar":"my","containerName":"_to_cons","definition":"my","name":"$g"},{"kind":13,"line":628,"containerName":"_to_cons","name":"$G"},{"localvar":"my","definition":"my","name":"$t","containerName":"_to_cons","line":629,"kind":13},{"line":629,"kind":13,"name":"$T","containerName":"_to_cons"},{"kind":13,"line":631,"containerName":"_to_cons","name":"$a"},{"name":"$thresh","containerName":"_to_cons","line":631,"kind":13},{"kind":13,"line":631,"name":"$c","containerName":"_to_cons"},{"kind":13,"line":631,"name":"$thresh","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$g","kind":13,"line":631},{"name":"$thresh","containerName":"_to_cons","line":631,"kind":13},{"containerName":"_to_cons","name":"$t","kind":13,"line":631},{"line":631,"kind":13,"containerName":"_to_cons","name":"$thresh"},{"containerName":"_to_cons","name":"$a","line":632,"kind":13},{"containerName":"_to_cons","name":"$t","kind":13,"line":632},{"name":"$a","containerName":"_to_cons","line":632,"kind":13},{"name":"$c","containerName":"_to_cons","line":632,"kind":13},{"kind":13,"line":632,"containerName":"_to_cons","name":"$a"},{"kind":13,"line":632,"name":"$g","containerName":"_to_cons"},{"name":"$a","containerName":"_to_cons","line":636,"kind":13},{"name":"$a","containerName":"_to_cons","kind":13,"line":636},{"line":636,"kind":13,"name":"$thresh","containerName":"_to_cons"},{"kind":13,"line":636,"name":"$a","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$t","line":636,"kind":13},{"kind":13,"line":636,"containerName":"_to_cons","name":"$a"},{"line":636,"kind":13,"name":"$c","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$a","kind":13,"line":636},{"name":"$g","containerName":"_to_cons","kind":13,"line":636},{"kind":13,"line":637,"containerName":"_to_cons","name":"$c"},{"kind":13,"line":637,"name":"$c","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$thresh","line":637,"kind":13},{"line":637,"kind":13,"name":"$c","containerName":"_to_cons"},{"line":637,"kind":13,"containerName":"_to_cons","name":"$t"},{"name":"$c","containerName":"_to_cons","kind":13,"line":637},{"line":637,"kind":13,"name":"$a","containerName":"_to_cons"},{"name":"$c","containerName":"_to_cons","kind":13,"line":637},{"kind":13,"line":637,"name":"$g","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$g","kind":13,"line":638},{"name":"$g","containerName":"_to_cons","kind":13,"line":638},{"line":638,"kind":13,"name":"$thresh","containerName":"_to_cons"},{"containerName":"_to_cons","name":"$g","kind":13,"line":638},{"containerName":"_to_cons","name":"$t","kind":13,"line":638},{"kind":13,"line":638,"name":"$g","containerName":"_to_cons"},{"name":"$c","containerName":"_to_cons","line":638,"kind":13},{"kind":13,"line":638,"name":"$g","containerName":"_to_cons"},{"name":"$a","containerName":"_to_cons","kind":13,"line":638},{"kind":13,"line":639,"containerName":"_to_cons","name":"$t"},{"line":639,"kind":13,"name":"$t","containerName":"_to_cons"},{"kind":13,"line":639,"containerName":"_to_cons","name":"$thresh"},{"kind":13,"line":639,"containerName":"_to_cons","name":"$t"},{"kind":13,"line":639,"containerName":"_to_cons","name":"$g"},{"name":"$t","containerName":"_to_cons","line":639,"kind":13},{"line":639,"kind":13,"containerName":"_to_cons","name":"$c"},{"containerName":"_to_cons","name":"$t","kind":13,"line":639},{"containerName":"_to_cons","name":"$a","line":639,"kind":13}]},{"kind":12,"children":[{"line":657,"kind":13,"localvar":"my","containerName":"get_string","definition":"my","name":"$self"},{"kind":13,"line":658,"containerName":"get_string","definition":"my","name":"$base","localvar":"my"},{"line":659,"kind":13,"localvar":"my","containerName":"get_string","name":"$string","definition":"my"},{"kind":13,"line":660,"containerName":"get_string","definition":"my","name":"@prob","localvar":"my"},{"kind":13,"line":663,"containerName":"get_string","name":"$base"},{"kind":13,"line":663,"name":"@prob","containerName":"get_string"},{"name":"$self","containerName":"get_string","line":663,"kind":13},{"name":"$base","containerName":"get_string","line":664,"kind":13},{"name":"@prob","containerName":"get_string","kind":13,"line":664},{"kind":13,"line":664,"containerName":"get_string","name":"$self"}],"line":656,"name":"get_string","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":656},"end":{"character":9999,"line":664}}},{"line":662,"kind":12,"name":"BASE"},{"name":"probA","kind":12,"line":663},{"name":"BASE","line":663,"kind":12},{"line":664,"kind":12,"name":"probC"},{"name":"BASE","kind":12,"line":664},{"containerName":null,"name":"%base","kind":13,"line":665},{"containerName":null,"name":"@prob","kind":13,"line":665},{"containerName":null,"name":"%self","line":665,"kind":13},{"name":"probG","line":665,"kind":12},{"line":665,"kind":12,"name":"BASE"},{"name":"%base","containerName":null,"kind":13,"line":666},{"containerName":null,"name":"@prob","kind":13,"line":666},{"containerName":null,"name":"%self","kind":13,"line":666},{"name":"probT","line":666,"kind":12},{"line":666,"kind":12,"name":"BASE"},{"kind":13,"line":667,"name":"$self","containerName":null},{"kind":12,"line":667,"containerName":"main::","name":"throw"},{"line":670,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$prob"},{"kind":13,"line":670,"containerName":null,"name":"@prob"},{"name":"$corrected","definition":"my","containerName":null,"localvar":"my","kind":13,"line":671},{"name":"$prob","containerName":null,"kind":13,"line":671},{"name":"$next","definition":"my","containerName":null,"localvar":"my","kind":13,"line":672},{"name":"$corrected","containerName":null,"line":672,"kind":13},{"name":"$next","containerName":null,"line":673,"kind":13},{"containerName":null,"name":"$next","line":673,"kind":13},{"containerName":null,"name":"$string","line":674,"kind":13},{"kind":13,"line":674,"name":"$next","containerName":null},{"name":"$string","containerName":null,"kind":13,"line":676},{"kind":12,"line":689,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_array","line":690,"kind":13},{"localvar":"my","name":"$base","definition":"my","containerName":"get_array","line":691,"kind":13},{"line":692,"kind":13,"containerName":"get_array","name":"$self"}],"containerName":"main::","name":"get_array","definition":"sub","range":{"start":{"character":0,"line":689},"end":{"character":9999,"line":692}}},{"name":"probA","line":692,"kind":12},{"kind":13,"line":692,"containerName":null,"name":"$base"},{"name":"%self","containerName":null,"kind":13,"line":693},{"line":693,"kind":12,"name":"probC"},{"containerName":null,"name":"$base","line":693,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":694},{"name":"probG","kind":12,"line":694},{"name":"$base","containerName":null,"kind":13,"line":694},{"line":695,"kind":13,"name":"%self","containerName":null},{"name":"probT","kind":12,"line":695},{"kind":13,"line":695,"name":"$base","containerName":null},{"kind":13,"line":696,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","kind":12,"line":696},{"children":[{"kind":13,"line":710,"name":"$self","definition":"my","containerName":"get_logs_array","localvar":"my"},{"localvar":"my","name":"$base","definition":"my","containerName":"get_logs_array","line":711,"kind":13},{"name":"$self","containerName":"get_logs_array","line":712,"kind":13}],"line":709,"kind":12,"range":{"start":{"line":709,"character":0},"end":{"line":712,"character":9999}},"definition":"sub","name":"get_logs_array","containerName":"main::"},{"name":"logA","kind":12,"line":712},{"line":712,"kind":13,"containerName":null,"name":"$base"},{"name":"%self","containerName":null,"line":712,"kind":13},{"name":"logA","kind":12,"line":712},{"name":"%self","containerName":null,"line":713,"kind":13},{"kind":12,"line":713,"name":"logC"},{"kind":13,"line":713,"name":"$base","containerName":null},{"name":"%self","containerName":null,"kind":13,"line":713},{"name":"logC","kind":12,"line":713},{"name":"%self","containerName":null,"line":714,"kind":13},{"kind":12,"line":714,"name":"logG"},{"containerName":null,"name":"$base","kind":13,"line":714},{"kind":13,"line":714,"name":"%self","containerName":null},{"kind":12,"line":714,"name":"logG"},{"containerName":null,"name":"%self","kind":13,"line":715},{"name":"logT","kind":12,"line":715},{"containerName":null,"name":"$base","kind":13,"line":715},{"kind":13,"line":715,"name":"%self","containerName":null},{"kind":12,"line":715,"name":"logT"},{"line":716,"kind":13,"containerName":null,"name":"$self"},{"line":716,"kind":12,"containerName":"main::","name":"throw"},{"containerName":"main::","definition":"sub","name":"id","range":{"end":{"line":735,"character":9999},"start":{"character":0,"line":730}},"kind":12,"line":730,"children":[{"kind":13,"line":731,"name":"$self","definition":"my","containerName":"id","localvar":"my"},{"localvar":"my","name":"$prev","definition":"my","containerName":"id","line":732,"kind":13},{"name":"$self","containerName":"id","kind":13,"line":732},{"kind":13,"line":733,"name":"$self","containerName":"id"},{"containerName":"id","name":"$prev","kind":13,"line":734}]},{"line":732,"kind":12,"name":"id"},{"line":733,"kind":12,"name":"id"},{"containerName":"main::","name":"regexp","definition":"sub","range":{"start":{"line":748,"character":0},"end":{"line":751,"character":9999}},"kind":12,"line":748,"children":[{"line":749,"kind":13,"localvar":"my","containerName":"regexp","name":"$self","definition":"my"},{"localvar":"my","definition":"my","name":"$regexp","containerName":"regexp","line":750,"kind":13},{"kind":13,"line":751,"name":"$letter","definition":"my","containerName":"regexp","localvar":"my"},{"line":751,"kind":13,"containerName":"regexp","name":"$self"}]},{"name":"IUPAC","kind":12,"line":751},{"localvar":"my","name":"$reg","definition":"my","containerName":null,"line":752,"kind":13},{"name":"LETTER","line":753,"kind":12},{"name":"%letter","containerName":null,"kind":13,"line":754},{"containerName":null,"name":"$reg","line":754,"kind":13},{"name":"LETTER","line":754,"kind":12},{"line":755,"kind":13,"containerName":null,"name":"%letter"},{"containerName":null,"name":"$reg","kind":13,"line":755},{"line":755,"kind":12,"name":"LETTER"},{"kind":13,"line":756,"containerName":null,"name":"%letter"},{"containerName":null,"name":"$reg","kind":13,"line":756},{"kind":12,"line":756,"name":"LETTER"},{"kind":13,"line":757,"name":"%letter","containerName":null},{"line":757,"kind":13,"containerName":null,"name":"$reg"},{"line":757,"kind":12,"name":"LETTER"},{"kind":13,"line":758,"containerName":null,"name":"%letter"},{"name":"$reg","containerName":null,"line":758,"kind":13},{"kind":12,"line":758,"name":"LETTER"},{"name":"%letter","containerName":null,"kind":13,"line":759},{"line":759,"kind":13,"name":"$reg","containerName":null},{"name":"LETTER","line":759,"kind":12},{"name":"%letter","containerName":null,"line":760,"kind":13},{"name":"$reg","containerName":null,"line":760,"kind":13},{"kind":12,"line":760,"name":"LETTER"},{"line":761,"kind":13,"name":"%letter","containerName":null},{"kind":13,"line":761,"name":"$reg","containerName":null},{"kind":12,"line":761,"name":"LETTER"},{"kind":13,"line":762,"containerName":null,"name":"%letter"},{"kind":13,"line":762,"name":"$reg","containerName":null},{"line":762,"kind":12,"name":"LETTER"},{"name":"%letter","containerName":null,"kind":13,"line":763},{"containerName":null,"name":"$reg","line":763,"kind":13},{"kind":12,"line":763,"name":"LETTER"},{"containerName":null,"name":"%letter","kind":13,"line":764},{"line":764,"kind":13,"name":"$reg","containerName":null},{"name":"LETTER","line":764,"kind":12},{"containerName":null,"name":"%letter","line":765,"kind":13},{"containerName":null,"name":"$reg","kind":13,"line":765},{"kind":12,"line":765,"name":"LETTER"},{"kind":13,"line":766,"containerName":null,"name":"%letter"},{"name":"$reg","containerName":null,"kind":13,"line":766},{"name":"LETTER","kind":12,"line":766},{"kind":13,"line":767,"name":"%letter","containerName":null},{"line":767,"kind":13,"name":"$reg","containerName":null},{"name":"LETTER","line":767,"kind":12},{"containerName":null,"name":"$reg","line":768,"kind":13},{"line":770,"kind":13,"containerName":null,"name":"$regexp"},{"name":"$reg","containerName":null,"kind":13,"line":770},{"kind":13,"line":772,"containerName":null,"name":"$regexp"},{"range":{"end":{"line":791,"character":9999},"start":{"line":788,"character":0}},"definition":"sub","name":"regexp_array","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"regexp_array","localvar":"my","kind":13,"line":789},{"localvar":"my","name":"@regexp","definition":"my","containerName":"regexp_array","line":790,"kind":13},{"definition":"my","name":"$letter","containerName":"regexp_array","localvar":"my","kind":13,"line":791},{"kind":13,"line":791,"containerName":"regexp_array","name":"$self"}],"line":788,"kind":12},{"name":"IUPAC","line":791,"kind":12},{"definition":"my","name":"$reg","containerName":null,"localvar":"my","kind":13,"line":792},{"line":793,"kind":12,"name":"LETTER"},{"line":794,"kind":13,"name":"%letter","containerName":null},{"name":"$reg","containerName":null,"line":794,"kind":13},{"kind":12,"line":794,"name":"LETTER"},{"containerName":null,"name":"%letter","line":795,"kind":13},{"containerName":null,"name":"$reg","line":795,"kind":13},{"kind":12,"line":795,"name":"LETTER"},{"line":796,"kind":13,"containerName":null,"name":"%letter"},{"line":796,"kind":13,"name":"$reg","containerName":null},{"name":"LETTER","kind":12,"line":796},{"line":797,"kind":13,"containerName":null,"name":"%letter"},{"kind":13,"line":797,"name":"$reg","containerName":null},{"line":797,"kind":12,"name":"LETTER"},{"line":798,"kind":13,"containerName":null,"name":"%letter"},{"containerName":null,"name":"$reg","kind":13,"line":798},{"name":"LETTER","kind":12,"line":798},{"kind":13,"line":799,"containerName":null,"name":"%letter"},{"containerName":null,"name":"$reg","line":799,"kind":13},{"kind":12,"line":799,"name":"LETTER"},{"containerName":null,"name":"%letter","line":800,"kind":13},{"kind":13,"line":800,"name":"$reg","containerName":null},{"name":"LETTER","line":800,"kind":12},{"name":"%letter","containerName":null,"line":801,"kind":13},{"kind":13,"line":801,"containerName":null,"name":"$reg"},{"name":"LETTER","line":801,"kind":12},{"containerName":null,"name":"%letter","line":802,"kind":13},{"line":802,"kind":13,"containerName":null,"name":"$reg"},{"name":"LETTER","kind":12,"line":802},{"kind":13,"line":803,"containerName":null,"name":"%letter"},{"kind":13,"line":803,"containerName":null,"name":"$reg"},{"kind":12,"line":803,"name":"LETTER"},{"line":804,"kind":13,"containerName":null,"name":"%letter"},{"containerName":null,"name":"$reg","kind":13,"line":804},{"name":"LETTER","line":804,"kind":12},{"line":805,"kind":13,"containerName":null,"name":"%letter"},{"kind":13,"line":805,"name":"$reg","containerName":null},{"name":"LETTER","line":805,"kind":12},{"kind":13,"line":806,"name":"%letter","containerName":null},{"containerName":null,"name":"$reg","kind":13,"line":806},{"name":"LETTER","kind":12,"line":806},{"line":807,"kind":13,"name":"%letter","containerName":null},{"kind":13,"line":807,"name":"$reg","containerName":null},{"name":"LETTER","kind":12,"line":807},{"containerName":null,"name":"$reg","line":808,"kind":13},{"name":"@regexp","containerName":null,"kind":13,"line":810},{"containerName":null,"name":"$reg","kind":13,"line":810},{"kind":13,"line":812,"name":"@regexp","containerName":null},{"line":829,"children":[{"kind":13,"line":830,"definition":"my","name":"$array","containerName":"_compress_array","localvar":"my"},{"containerName":"_compress_array","name":"$lm","kind":13,"line":830},{"name":"$direct","containerName":"_compress_array","line":830,"kind":13},{"name":"$str","definition":"my","containerName":"_compress_array","localvar":"my","kind":13,"line":831},{"kind":13,"line":832,"containerName":"_compress_array","name":"$array"},{"line":832,"kind":13,"name":"$lm","containerName":"_compress_array"},{"containerName":"_compress_array","name":"$direct","line":833,"kind":13},{"name":"$direct","containerName":"_compress_array","line":833,"kind":13},{"kind":13,"line":834,"definition":"my","name":"$k1","containerName":"_compress_array","localvar":"my"},{"containerName":"_compress_array","name":"$direct","line":834,"kind":13},{"line":834,"kind":13,"containerName":"_compress_array","name":"$lm"},{"line":834,"kind":13,"containerName":"_compress_array","name":"$lm"},{"localvar":"my","containerName":"_compress_array","name":"$c","definition":"my","line":835,"kind":13},{"line":835,"kind":13,"name":"$array","containerName":"_compress_array"}],"kind":12,"detail":"($array,$lm,$direct)","signature":{"documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. ","parameters":[{"label":"$array"},{"label":"$lm"},{"label":"$direct"}],"label":"_compress_array($array,$lm,$direct)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":829},"end":{"character":9999,"line":835}},"name":"_compress_array"},{"name":"$c","containerName":null,"kind":13,"line":836},{"line":836,"kind":13,"containerName":null,"name":"$lm"},{"containerName":null,"name":"$c","line":836,"kind":13},{"containerName":null,"name":"$lm","kind":13,"line":836},{"containerName":null,"name":"$c","kind":13,"line":837},{"kind":13,"line":837,"name":"$lm","containerName":null},{"line":837,"kind":13,"containerName":null,"name":"$c"},{"containerName":null,"name":"$lm","kind":13,"line":837},{"name":"$direct","containerName":null,"line":837,"kind":13},{"line":838,"kind":13,"name":"$c","containerName":null},{"name":"$c","containerName":null,"kind":13,"line":838},{"kind":13,"line":838,"name":"$direct","containerName":null},{"localvar":"my","definition":"my","name":"$byte","containerName":null,"line":839,"kind":13},{"kind":13,"line":839,"name":"$k1","containerName":null},{"containerName":null,"name":"$c","kind":13,"line":839},{"name":"$byte","containerName":null,"kind":13,"line":840},{"containerName":null,"name":"$byte","kind":13,"line":840},{"name":"$direct","containerName":null,"line":840,"kind":13},{"line":841,"kind":13,"localvar":"my","name":"$char","definition":"my","containerName":null},{"name":"$byte","containerName":null,"line":841,"kind":13},{"line":842,"kind":13,"name":"$str","containerName":null},{"line":842,"kind":13,"name":"$char","containerName":null},{"line":844,"kind":13,"name":"$str","containerName":null},{"kind":12,"children":[{"localvar":"my","name":"$str","definition":"my","containerName":"_uncompress_string","line":860,"kind":13},{"name":"$lm","containerName":"_uncompress_string","kind":13,"line":860},{"line":860,"kind":13,"containerName":"_uncompress_string","name":"$direct"},{"kind":13,"line":861,"containerName":"_uncompress_string","definition":"my","name":"@array","localvar":"my"},{"containerName":"_uncompress_string","name":"$str","line":862,"kind":13},{"name":"$lm","containerName":"_uncompress_string","kind":13,"line":862},{"containerName":"_uncompress_string","name":"$direct","kind":13,"line":863},{"name":"$direct","containerName":"_uncompress_string","line":863,"kind":13},{"line":864,"kind":13,"localvar":"my","containerName":"_uncompress_string","definition":"my","name":"$k1"},{"containerName":"_uncompress_string","name":"$direct","kind":13,"line":864},{"kind":13,"line":864,"name":"$lm","containerName":"_uncompress_string"},{"kind":13,"line":864,"containerName":"_uncompress_string","name":"$lm"},{"localvar":"my","containerName":"_uncompress_string","name":"$c","definition":"my","line":865,"kind":13},{"kind":13,"line":865,"name":"$str","containerName":"_uncompress_string"},{"containerName":"_uncompress_string","definition":"my","name":"$byte","localvar":"my","kind":13,"line":866},{"line":866,"kind":13,"containerName":"_uncompress_string","name":"$c"},{"containerName":"_uncompress_string","name":"$byte","kind":13,"line":867},{"containerName":"_uncompress_string","name":"$byte","line":867,"kind":13},{"kind":13,"line":867,"containerName":"_uncompress_string","name":"$direct"},{"containerName":"_uncompress_string","name":"$num","definition":"my","localvar":"my","kind":13,"line":868},{"name":"$byte","containerName":"_uncompress_string","kind":13,"line":868},{"kind":13,"line":868,"name":"$k1","containerName":"_uncompress_string"},{"kind":13,"line":869,"name":"@array","containerName":"_uncompress_string"},{"containerName":"_uncompress_string","name":"$num","kind":13,"line":869},{"line":871,"kind":13,"containerName":"_uncompress_string","name":"@array"}],"line":859,"definition":"sub","containerName":"main::","signature":{"label":"_uncompress_string($str,$lm,$direct)","documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. \n\n\nsub _compress_array {\n\tmy ($array,$lm,$direct)=@_;\n\tmy $str;\n\treturn  unless(($array) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (@{$array}) {\n\t\t$c=$lm if ($c>$lm);\n\t\t$c=-$lm if (($c<-$lm) && ($direct !=1));\n    $c=0 if (($c<0) && ($direct ==1));\n\t\tmy $byte=int($k1*$c);\n    $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n    my $char=chr($byte);\n\t\t$str.=$char;\n\t}\n\treturn $str;\n}\n\n=head2 _uncompress_string\n\n Title   : _uncompress_string\n Usage   :\n Function: Will uncompress a string (vector of bytes) to create an array of\n           real signed numbers (opposite to_compress_array)\n Returns : string, followed by an max value and\n \t\t   direction (optional, default 1-unsigned), 1 unsigned, any other is signed.\n Args    : array","parameters":[{"label":"$str"},{"label":"$lm"},{"label":"$direct"}]},"detail":"($str,$lm,$direct)","name":"_uncompress_string","range":{"end":{"character":9999,"line":872},"start":{"character":0,"line":859}}},{"children":[{"line":889,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_compressed_freq"},{"containerName":"get_compressed_freq","name":"$base","definition":"my","localvar":"my","kind":13,"line":890},{"line":891,"kind":13,"localvar":"my","name":"$string","definition":"my","containerName":"get_compressed_freq"},{"kind":13,"line":892,"name":"@prob","definition":"my","containerName":"get_compressed_freq","localvar":"my"},{"containerName":"get_compressed_freq","name":"$base","kind":13,"line":894},{"name":"@prob","containerName":"get_compressed_freq","kind":13,"line":895},{"line":895,"kind":13,"name":"$self","containerName":"get_compressed_freq"},{"name":"$self","containerName":"get_compressed_freq","line":895,"kind":13},{"kind":13,"line":898,"containerName":"get_compressed_freq","name":"$base"},{"line":899,"kind":13,"name":"@prob","containerName":"get_compressed_freq"},{"line":899,"kind":13,"name":"$self","containerName":"get_compressed_freq"},{"kind":13,"line":899,"containerName":"get_compressed_freq","name":"$self"}],"line":888,"kind":12,"range":{"end":{"character":9999,"line":901},"start":{"character":0,"line":888}},"definition":"sub","name":"get_compressed_freq","containerName":"main::"},{"name":"BASE","kind":12,"line":893},{"name":"probA","kind":12,"line":895},{"name":"probA","line":895,"kind":12},{"name":"BASE","line":896,"kind":12},{"name":"probG","line":899,"kind":12},{"name":"probG","line":899,"kind":12},{"name":"BASE","line":900,"kind":12},{"kind":13,"line":902,"containerName":null,"name":"%base"},{"line":903,"kind":13,"containerName":null,"name":"@prob"},{"line":903,"kind":13,"name":"%self","containerName":null},{"name":"probC","line":903,"kind":12},{"kind":13,"line":903,"containerName":null,"name":"%self"},{"line":903,"kind":12,"name":"probC"},{"name":"BASE","kind":12,"line":904},{"line":906,"kind":13,"name":"%base","containerName":null},{"kind":13,"line":907,"name":"@prob","containerName":null},{"containerName":null,"name":"%self","kind":13,"line":907},{"kind":12,"line":907,"name":"probT"},{"containerName":null,"name":"%self","kind":13,"line":907},{"name":"probT","kind":12,"line":907},{"name":"BASE","kind":12,"line":908},{"line":910,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":910,"containerName":"main::","name":"throw"},{"localvar":"my","containerName":null,"name":"$str","definition":"my","line":912,"kind":13},{"line":912,"kind":13,"containerName":null,"name":"@prob"},{"line":913,"kind":13,"name":"$str","containerName":null},{"children":[{"line":929,"kind":13,"localvar":"my","containerName":"get_compressed_logs","name":"$self","definition":"my"},{"kind":13,"line":930,"definition":"my","name":"$base","containerName":"get_compressed_logs","localvar":"my"},{"localvar":"my","containerName":"get_compressed_logs","name":"$string","definition":"my","line":931,"kind":13},{"kind":13,"line":932,"containerName":"get_compressed_logs","name":"@prob","definition":"my","localvar":"my"},{"line":934,"kind":13,"containerName":"get_compressed_logs","name":"$base"},{"line":934,"kind":13,"containerName":"get_compressed_logs","name":"@prob"},{"name":"$self","containerName":"get_compressed_logs","line":934,"kind":13},{"line":934,"kind":13,"name":"$self","containerName":"get_compressed_logs"},{"containerName":"get_compressed_logs","name":"$base","kind":13,"line":935},{"kind":13,"line":935,"containerName":"get_compressed_logs","name":"@prob"},{"containerName":"get_compressed_logs","name":"$self","kind":13,"line":935},{"containerName":"get_compressed_logs","name":"$self","kind":13,"line":935}],"line":928,"kind":12,"range":{"end":{"line":935,"character":9999},"start":{"character":0,"line":928}},"definition":"sub","name":"get_compressed_logs","containerName":"main::"},{"name":"BASE","kind":12,"line":933},{"name":"logA","kind":12,"line":934},{"name":"logA","line":934,"kind":12},{"kind":12,"line":934,"name":"BASE"},{"line":935,"kind":12,"name":"logC"},{"line":935,"kind":12,"name":"logC"},{"line":935,"kind":12,"name":"BASE"},{"containerName":null,"name":"%base","kind":13,"line":936},{"containerName":null,"name":"@prob","line":936,"kind":13},{"containerName":null,"name":"%self","line":936,"kind":13},{"name":"logG","kind":12,"line":936},{"name":"%self","containerName":null,"line":936,"kind":13},{"line":936,"kind":12,"name":"logG"},{"kind":12,"line":936,"name":"BASE"},{"kind":13,"line":937,"containerName":null,"name":"%base"},{"kind":13,"line":937,"containerName":null,"name":"@prob"},{"line":937,"kind":13,"containerName":null,"name":"%self"},{"name":"logT","kind":12,"line":937},{"line":937,"kind":13,"name":"%self","containerName":null},{"line":937,"kind":12,"name":"logT"},{"line":937,"kind":12,"name":"BASE"},{"name":"$self","containerName":null,"line":938,"kind":13},{"name":"throw","containerName":"main::","line":938,"kind":12},{"line":940,"kind":13,"containerName":null,"name":"@prob"},{"range":{"start":{"line":957,"character":0},"end":{"character":9999,"line":961}},"name":"sequence_match_weight","line":957,"children":[{"kind":13,"line":958,"name":"$self","definition":"my","containerName":"sequence_match_weight","localvar":"my"},{"containerName":"sequence_match_weight","name":"$seq","kind":13,"line":958},{"kind":13,"line":959,"containerName":"sequence_match_weight","name":"$self"},{"localvar":"my","containerName":"sequence_match_weight","name":"$width","definition":"my","line":960,"kind":13},{"containerName":"sequence_match_weight","name":"$self","line":960,"kind":13},{"name":"width","containerName":"sequence_match_weight","line":960,"kind":12},{"containerName":"sequence_match_weight","name":"$self","line":961,"kind":13},{"containerName":"sequence_match_weight","name":"throw","line":961,"kind":12},{"containerName":"sequence_match_weight","name":"$seq","kind":13,"line":961},{"kind":13,"line":961,"containerName":"sequence_match_weight","name":"$self"}],"kind":12,"detail":"($self,$seq)","signature":{"label":"sequence_match_weight($self,$seq)","documentation":"1;\n# $Id: SiteMatrix.pm 16123 2009-09-17 12:57:27Z cjfields $\n#---------------------------------------------------------\n\n=head1 NAME\n\nBio::Matrix::PSM::SiteMatrix - SiteMatrixI implementation, holds a\nposition scoring matrix (or position weight matrix) and log-odds\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::SiteMatrix;\n  # Create from memory by supplying probability matrix hash\n  # both as strings or arrays\n  # where the frequencies  $a,$c,$g and $t are supplied either as\n  # arrayref or string. Accordingly, lA, lC, lG and lT are the log\n  # odds (only as arrays, no checks done right now)\n  my ($a,$c,$g,$t,$score,$ic, $mid)=@_; \n  #or\n  my ($a,$c,$g,$t,$score,$ic,$mid)=('05a011','110550','400001',\n                                    '100104',0.001,19.2,'CRE1');\n  #Where a stands for all (this frequency=1), see explanation bellow\n  my %param=(-pA=>$a,-pC=>$c,-pG=>$g,-pT=>$t,\n             -lA=>$la, -lC=>$lc,-lG=>$lg,-lT=>$l,\n             -IC=>$ic,-e_val=>$score, -id=>$mid);\n  my $site=Bio::Matrix::PSM::SiteMatrix->new(%param);\n  #Or get it from a file:\n  use Bio::Matrix::PSM::IO;\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n  while (my $psm=$psmIO->next_psm) {\n    #Now we have a Bio::Matrix::PSM::Psm object, \n    # see Bio::Matrix::PSM::PsmI for details\n    #This is a Bio::Matrix::PSM::SiteMatrix object now\n    my $matrix=$psm->matrix;  \n  }\n\n  # Get a simple consensus, where alphabet is {A,C,G,T,N}, \n  # choosing the character that both satisfies a supplied or default threshold\n  # frequency and is the most frequenct character at each position, or N.\n  # So for the position with A, C, G, T frequencies of 0.5, 0.25, 0.10, 0.15,\n  # the simple consensus character will be 'A', whilst for 0.5, 0.5, 0, 0 it\n  # would be 'N'.\n  my $consensus=$site->consensus;\n\n  # Get the IUPAC ambiguity code representation of the data in the matrix.\n  # Because the frequencies may have been pseudo-count corrected, insignificant\n  # frequences (below 0.05 by default) are ignored. So a position with\n  # A, C, G, T frequencies of 0.5, 0.5, 0.01, 0.01 will get the IUPAC code 'M',\n  # while 0.97, 0.01, 0.01, 0.01 will get the code 'A' and\n  # 0.25, 0.25, 0.25, 0.25 would get 'N'.\n  my $iupac=$site->IUPAC;\n\n  # Getting/using regular expression (a representation of the IUPAC string)\n  my $regexp=$site->regexp;\n  my $count=grep($regexp,$seq);\n  my $count=($seq=~ s/$regexp/$1/eg);\n  print \"Motif $mid is present $count times in this sequence\\n\";\n\n=head1 DESCRIPTION\n\nSiteMatrix is designed to provide some basic methods when working with position\nscoring (weight) matrices, such as transcription factor binding sites for\nexample. A DNA PSM consists of four vectors with frequencies {A,C,G,T}. This is\nthe minimum information you should provide to construct a PSM object. The\nvectors can be provided as strings with frequenciesx10 rounded to an int, going\nfrom {0..a} and 'a' represents the maximum (10). This is like MEME's compressed\nrepresentation of a matrix and it is quite useful when working with relational\nDB. If arrays are provided as an input (references to arrays actually) they can\nbe any number, real or integer (frequency or count).\n\nWhen creating the object you can ask the constructor to make a simple pseudo\ncount correction by adding a number (typically 1) to all positions (with the\n-correction option). After adding the number the frequencies will be\ncalculated. Only use correction when you supply counts, not frequencies.\n\nThrows an exception if: You mix as an input array and string (for example A\nmatrix is given as array, C - as string). The position vector is (0,0,0,0). One\nof the probability vectors is shorter than the rest.\n\nSummary of the methods I use most frequently (details bellow):\n\n  iupac - return IUPAC compliant consensus as a string\n  score - Returns the score as a real number\n  IC - information content. Returns a real number\n  id - identifier. Returns a string\n  accession - accession number. Returns a string\n  next_pos - return the sequence probably for each letter, IUPAC\n      symbol, IUPAC probability and simple sequence\n  consenus letter for this position. Rewind at the end. Returns a hash.\n  pos - current position get/set. Returns an integer.\n  regexp - construct a regular expression based on IUPAC consensus.\n      For example AGWV will be [Aa][Gg][AaTt][AaCcGg]\n  width - site width\n  get_string - gets the probability vector for a single base as a string.\n  get_array - gets the probability vector for a single base as an array.\n  get_logs_array - gets the log-odds vector for a single base as an array.\n\nNew methods, which might be of interest to anyone who wants to store\nPSM in a relational database without creating an entry for each\nposition is the ability to compress the PSM vector into a string with\nlosing usually less than 1% of the data.  this can be done with:\n\n  my $str=$matrix->get_compressed_freq('A');\nor\n  my $str=$matrix->get_compressed_logs('A');\n\nLoading from a database should be done with new, but is not yest implemented.\nHowever you can still uncompress such string with:\n\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1,1); for PSM\nor\n  my @arr=Bio::Matrix::PSM::_uncompress_string ($str,1000,2); for log odds\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 CONTRIBUTORS\n\nSendu Bala, bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::SiteMatrix;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Matrix::PSM::SiteMatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $site=Bio::Matrix::PSM::SiteMatrix->new(-pA=>$a,-pC=>$c,\n\t\t\t\t\t\t     -pG=>$g,-pT=>$t,\n\t\t\t\t\t\t     -IC=>$ic,\n\t\t\t\t\t\t     -e_val=>$score, \n\t\t\t\t\t\t     -id=>$mid);\n Function: Creates a new Bio::Matrix::PSM::SiteMatrix object from memory\n Throws :  If inconsistent data for all vectors (A,C,G and T) is\n           provided, if you mix input types (string vs array) or if a\n           position freq is 0.\n Returns :  Bio::Matrix::PSM::SiteMatrix object\n Args    :  -pA    => vector with the frequencies or counts of A\n            -pC    => vector for C\n            -pG    => vector for G\n            -pt    => vector for T\n            -lA    => vector for the log of A\n            -lC    => vector for the log of C\n            -lG    => vector for the log of G\n            -lT    => vector for the log of T\n            -IC    => real number, the information content of this matrix\n            -e_val => real number, the expect value\n            -id    => string, an identifier\n            -width => int, width of the matrix in nucleotides\n            -sites => int, the number of sites that went into this matrix\n            -model => hash ref, background frequencies for A, C, G and T\n            -correction => number, the number to add to all positions to achieve\n                           psuedo count correction (default 0: no correction)\n                           NB: do not use correction when your input is\n                           frequences!\n            -accession_number => string, an accession number\n\n            Vectors can be strings of the frequencies where the frequencies are\n            multiplied by 10 and rounded to the nearest whole number, and where\n            'a' is used to denote the maximal frequency 10. There should be no\n            punctuation (spaces etc.) in the string. For example, 'a0501'.\n            Alternatively frequencies or counts can be represented by an array\n            ref containing the counts, frequencies or logs as any kind of\n            number.\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my $consensus;\n    # Too many things to rearrange, and I am creating simultanuously >500 \n    # such objects routinely, so this becomes performance issue\n    my %input;\n    while (@args) {\n        (my $key = shift @args) =~ s/-//g; #deletes all dashes (only dashes)!\n        $input{$key} = shift @args;\n    }\n    $self->{_position}   = 0;\n    $self->{IC}     = $input{IC};\n    $self->{e_val}  = $input{e_val};\n    $self->{width}  = $input{width};\n\t$self->{logA}   = $input{lA};\n\t$self->{logC}   = $input{lC};\n\t$self->{logG}   = $input{lG};\n\t$self->{logT}   = $input{lT};\n    $self->{sites}  = $input{sites};\n    $self->{id}     = $input{id} || 'null';\n    $self->{correction} = $input{correction} || 0;\n    $self->{accession_number} = $input{accession_number};\n\treturn $self unless (defined($input{pA}) && defined($input{pC}) && defined($input{pG}) && defined($input{pT}));\n    \n    # This should go to _initialize?\n    # Check for input type- no mixing alllowed, throw ex\n    if (ref($input{pA}) =~ /ARRAY/i ) {\n        $self->throw(\"Mixing matrix data types not allowed: C is not reference\") unless(ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is not reference\") unless (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is not reference\") unless (ref($input{pT}));\n        $self->{probA} = $input{pA};\n        $self->{probC} = $input{pC};\n        $self->{probG} = $input{pG};\n        $self->{probT} = $input{pT};\n    }\n    else {\n        $self->throw(\"Mixing matrix data types not allowed: C is reference\") if (ref($input{pC}));\n        $self->throw(\"Mixing matrix data types not allowed: G is reference\") if (ref($input{pG}));\n        $self->throw(\"Mixing matrix data types not allowed: T is reference\") if (ref($input{pT}));\n        $self->{probA} = [split(//,$input{pA})];\n        $self->{probC} = [split(//,$input{pC})];\n        $self->{probG} = [split(//,$input{pG})];\n        $self->{probT} = [split(//,$input{pT})];\n        for (my $i=0; $i<= @{$self->{probA}}+1; $i++) {\n            # we implictely assume these are MEME-style frequencies x 10, so\n            # 'a' represents the 'maximum', 10. Other positions can actually\n            # add up to over 10 due to rounding, but I don't think that is a\n            # problem?\n            if (${$self->{probA}}[$i] and ${$self->{probA}}[$i] eq 'a') {\n                ${$self->{probA}}[$i]='10';\n            }\n            if (${$self->{probC}}[$i] and ${$self->{probC}}[$i] eq 'a') {\n                ${$self->{probC}}[$i]='10';\n            }\n            if (${$self->{probG}}[$i] and ${$self->{probG}}[$i] eq 'a') {\n                ${$self->{probG}}[$i]='10';\n            }\n            if (${$self->{probT}}[$i] and ${$self->{probT}}[$i] eq 'a') {\n                ${$self->{probT}}[$i]='10';\n            }\n        }\n    }\n    \n    # Check for position with 0 for all bases, throw exception if so\n    for (my $i=0;$i <= $#{$self->{probA}}; $i++) {\n        if ((${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i]) == 0) {\n            $self->throw(\"Position meaningless-all frequencies are 0\");\n        }\n        \n        # apply psuedo-count correction to all values - this will result in\n        # very bad frequencies if the input is already frequences and a\n        # correction value as large as 1 is used!\n        if ($self->{correction}) {\n            ${$self->{probA}}[$i] += $self->{correction};\n            ${$self->{probC}}[$i] += $self->{correction};\n            ${$self->{probG}}[$i] += $self->{correction};\n            ${$self->{probT}}[$i] += $self->{correction};\n        }\n        \n        # (re)calculate frequencies\n        my $div= ${$self->{probA}}[$i] + ${$self->{probC}}[$i] + ${$self->{probG}}[$i] + ${$self->{probT}}[$i];\n        ${$self->{probA}}[$i]=${$self->{probA}}[$i]/$div;\n        ${$self->{probC}}[$i]=${$self->{probC}}[$i]/$div;\n        ${$self->{probG}}[$i]=${$self->{probG}}[$i]/$div;\n        ${$self->{probT}}[$i]=${$self->{probT}}[$i]/$div;\n    }\n    \n    # Calculate the logs\n    if ((!defined($self->{logA})) && ($input{model})) {\n        $self->calc_weight($input{model});\n    }\n    \n    # Make consensus, throw if any one of the vectors is shorter\n    $self->_calculate_consensus;\n    return $self;\n}\n\n=head2 _calculate_consensus\n\n Title   : _calculate_consensus\n Function: Internal stuff\n\n\nsub _calculate_consensus {\n    my $self=shift;\n    my ($lc,$lt,$lg)=($#{$self->{probC}},$#{$self->{probT}},$#{$self->{probG}});\n    my $len=$#{$self->{probA}};\n    $self->throw(\"Probability matrix is damaged for C: $len vs $lc\") if ($len != $lc);\n    $self->throw(\"Probability matrix is damaged for T: $len vs $lt\") if ($len != $lt);\n    $self->throw(\"Probability matrix is damaged for G: $len vs $lg\") if ($len != $lg);\n    for (my $i=0; $i<$len+1; $i++) {\n        #*** IUPACp values not actually used (eg. by next_pos)\n        (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n        (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i]);\n    }\n    return $self;\n}\n\n=head2 calc_weight\n\n Title   : calc_weight\n Usage   : $obj->calc_weight({A=>0.2562, C=>0.2438, G=>0.2432, T=>0.2568});\n Function: Recalculates the PSM (or weights) based on the PFM (the frequency\n           matrix) and user supplied background model.\n Throws  : if no model is supplied\n Returns : n/a\n Args    : reference to a hash with background frequencies for A,C,G and T\n\n\nsub calc_weight {\n    my ($self, $model) = @_;\n    my %model;\n    $model{probA}=$model->{A};\n    $model{probC}=$model->{C};\n    $model{probG}=$model->{G};\n    $model{probT}=$model->{T};\n    foreach my $let qw(probA probC probG probT) {\n      my @str;\n      $self->throw('You did not provide valid model\\n') unless (($model{$let}>0) && ($model{$let}<1));\n      foreach my $f (@{$self->{$let}}) {\n        my $w=log($f)-log($model{$let});\n        push @str,$w;\n      }\n      my $llet=$let;\n      $llet=~s/prob/log/;\n      $self->{$llet}=\\@str;\n    }\n    return $self;\n}\n\n=head2 next_pos\n\n Title   : next_pos\n Usage   :\n Function: Retrives the next position features: frequencies for A,C,G,T, the\n           main letter (as in consensus) and the probabilty for this letter to\n           occur at this position and the current position\n Returns : hash (pA,pC,pG,pT,logA,logC,logG,logT,base,prob,rel)\n Args    : none\n\n\nsub next_pos {\n    my $self = shift;\n    $self->throw(\"instance method called on class\") unless ref $self;\n    my $len=@{$self->{seq}};\n    my $pos=$self->{_position};\n    # End reached?\n    if ($pos<$len) {\n\tmy $pA=${$self->{probA}}[$pos];\n\tmy $pC=${$self->{probC}}[$pos];\n\tmy $pG=${$self->{probG}}[$pos];\n\tmy $pT=${$self->{probT}}[$pos];\n\tmy $lA=${$self->{logA}}[$pos];\n\tmy $lC=${$self->{logC}}[$pos];\n\tmy $lG=${$self->{logG}}[$pos];\n\tmy $lT=${$self->{logT}}[$pos];\n\tmy $base=${$self->{seq}}[$pos];\n\tmy $prob=${$self->{seqp}}[$pos];\n\t$self->{_position}++;\n\tmy %seq=(pA=>$pA,pT=>$pT,pC=>$pC,pG=>$pG, lA=>$lA,lT=>$lT,lC=>$lC,lG=>$lG,base=>$base,rel=>$pos, prob=>$prob);\n\treturn %seq;\n    }\n    else {$self->{_position}=0; return;}\n}\n\n=head2 curpos\n\n Title   : curpos\n Usage   :\n Function: Gets/sets the current position. Converts to 0 if argument is minus\n           and to width if greater than width\n Returns : integer\n Args    : integer\n\n\nsub curpos {\n    my $self = shift;\n    my $prev = $self->{_position};\n    if (@_) { $self->{_position} = shift; }\n    return $prev;\n}\n\n=head2 e_val\n\n Title   : e_val\n Usage   : \n Function: Gets/sets the e-value\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub e_val {\n    my $self = shift;\n    my $prev = $self->{e_val};\n    if (@_) { $self->{e_val} = shift; }\n    return $prev;\n}\n\n=head2 IC\n\n Title   : IC\n Usage   :\n Function: Get/set the Information Content\n Returns : real number\n Args    : none to get, real number to set\n\n\nsub IC {\n    my $self = shift;\n    my $prev = $self->{IC};\n    if (@_) { $self->{IC} = shift; }\n    return $prev;\n}\n\n=head2 accession_number\n\n Title   : accession_number\n Function: Get/set the accession number, this will be unique id for the\n           SiteMatrix object as well for any other object, inheriting from\n           SiteMatrix\n Returns : string\n Args    : none to get, string to set\n\n\nsub accession_number {\n    my $self = shift;\n    my $prev = $self->{accession_number};\n    if (@_) { $self->{accession_number} = shift; }\n    return $prev;\n}\n\n=head2 consensus\n\n Title   : consensus\n Usage   :\n Function: Returns the consensus\n Returns : string\n Args    : (optional) threshold value 1 to 10, default 5\n           '5' means the returned characters had a 50% or higher presence at\n           their position\n\n\nsub consensus {\n    my ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{seq}}[$i], ${$self->{seqp}}[$i]) = _to_cons(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n    my $consensus='';\n    foreach my $letter (@{$self->{seq}}) {\n        $consensus .= $letter;\n    }\n    return $consensus;\n}\n\n=head2 width\n\n Title   : width\n Usage   :\n Function: Returns the length of the sites in used to make this matrix\n Returns : int\n Args    : none\n\n\nsub width {\n    my $self = shift;\n    my $width=@{$self->{probA}};\n    return $width;\n}\n\n=head2 sites\n\n Title   : sites\n Usage   :\n Function: Get/set the number of sites that were used to make this matrix\n Returns : int\n Args    : none to get, int to set\n\n\nsub sites {\n    my $self = shift;\n    if (@_) { $self->{sites} = shift }\n    return $self->{sites} || return;\n}\n\n=head2 IUPAC\n\n Title   : IUPAC\n Usage   :\n Function: Returns IUPAC compliant consensus\n Returns : string\n Args    : optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub IUPAC {\n\tmy ($self, $thresh) = @_;\n    if ($thresh) {\n        my $len=$#{$self->{probA}};\n        for (my $i=0; $i<$len+1; $i++) {\n            (${$self->{IUPAC}}[$i],${$self->{IUPACp}}[$i])=_to_IUPAC(${$self->{probA}}[$i], ${$self->{probC}}[$i], ${$self->{probG}}[$i], ${$self->{probT}}[$i], $thresh);\n        }\n    }\n\tmy $iu=$self->{IUPAC};\n\tmy $iupac='';\n\tforeach my $let (@{$iu}) {\n\t\t$iupac .= $let;\n\t}\n    return $iupac;\n}\n\n=head2 _to_IUPAC\n\n Title   : _to_IUPAC\n Usage   :\n Function: Converts a single position to IUPAC compliant symbol.\n           For rules see the implementation\n Returns : char, real number\n Args    : real numbers for frequencies of A,C,G,T (positional)\n\n           optionally, also supply a whole number (int) of 1 or higher to set\n           the significance level when considering the frequencies. 1 (the\n           default) means a 0.05 significance level: frequencies lower than\n           0.05 will be ignored. 2 Means a 0.005 level, and so on.\n\n\nsub _to_IUPAC {\n\tmy ($a, $c, $g, $t, $thresh) = @_;\n    $thresh ||= 1;\n    $thresh = int($thresh);\n    $a = sprintf (\"%.${thresh}f\", $a);\n    $c = sprintf (\"%.${thresh}f\", $c);\n    $g = sprintf (\"%.${thresh}f\", $g);\n    $t = sprintf (\"%.${thresh}f\", $t);\n    \n    my $total = $a + $c + $g + $t;\n    \n\treturn 'A' if ($a == $total);\n\treturn 'G' if ($g == $total);\n\treturn 'C' if ($c == $total);\n\treturn 'T' if ($t == $total);\n\tmy $r=$g+$a;\n\treturn 'R' if ($r == $total);\n\tmy $y=$t+$c;\n\treturn 'Y' if ($y == $total);\n\tmy $m=$a+$c;\n\treturn 'M' if ($m == $total);\n\tmy $k=$g+$t;\n\treturn 'K' if ($k == $total);\n\tmy $s=$g+$c;\n\treturn 'S' if ($s == $total);\n\tmy $w=$a+$t;\n\treturn 'W' if ($w == $total);\n\tmy $d=$r+$t;\n\treturn 'D' if ($d == $total);\n\tmy $v=$r+$c;\n\treturn 'V' if ($v == $total);\n\tmy $b=$y+$g;\n\treturn 'B' if ($b == $total);\n\tmy $h=$y+$a;\n\treturn 'H' if ($h == $total);\n\treturn 'N';\n}\n\n=head2 _to_cons\n\n Title   : _to_cons\n Usage   :\n Function: Converts a single position to simple consensus character and returns\n           its probability. For rules see the implementation\n Returns : char, real number\n Args    : real numbers for A,C,G,T (positional), and optional 5th argument of\n           threshold (as a number between 1 and 10, where 5 is default and\n           means the returned character had a 50% or higher presence at this\n           position)\n\n\nsub _to_cons {\n\tmy ($A, $C, $G, $T, $thresh) = @_;\n    $thresh ||= 5;\n    \n    # this multiplication by 10 is just to satisfy the thresh range of 1-10\n\tmy $a = $A * 10;\n\tmy $c = $C * 10;\n\tmy $g = $G * 10;\n\tmy $t = $T * 10;\n    \n    return 'N',10 if (($a<$thresh) && ($c<$thresh) && ($g<$thresh) && ($t<$thresh));\n\treturn 'N',10 if (($a==$t) && ($a==$c) && ($a==$g));\n    \n    # threshold could be lower than 50%, so must check is not only over\n    # threshold, but also the highest frequency\n\treturn 'A',$a if (($a>=$thresh) && ($a>$t) && ($a>$c) && ($a>$g));\n\treturn 'C',$c if (($c>=$thresh) && ($c>$t) && ($c>$a) && ($c>$g));\n\treturn 'G',$g if (($g>=$thresh) && ($g>$t) && ($g>$c) && ($g>$a));\n\treturn 'T',$t if (($t>=$thresh) && ($t>$g) && ($t>$c) && ($t>$a));\n\t\n    return 'N',10;\n}\n\n=head2 get_string\n\n Title   : get_string\n Usage   :\n Function: Returns given probability vector as a string. Useful if you want to\n           store things in a rel database, where arrays are not first choice\n Throws  : If the argument is outside {A,C,G,T}\n Returns : string\n Args    : character {A,C,G,T}\n\n\nsub get_string {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n    \n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{probA}}; last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{probC}}; last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{probG}}; last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{probT}}; last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n    \n    foreach  my $prob (@prob) {\n        my $corrected = $prob*10;\n        my $next=sprintf(\"%.0f\",$corrected);\n        $next='a' if ($next eq '10');\n        $string .= $next;\n    }\n    return $string;\n}\n\n=head2 get_array\n\n Title   : get_array\n Usage   :\n Function: Returns an array with frequencies for a specified base\n Returns : array\n Args    : char\n\n\nsub get_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{probA}} if ($base eq 'A');\n\treturn  @{$self->{probC}} if ($base eq 'C');\n\treturn  @{$self->{probG}} if ($base eq 'G');\n\treturn  @{$self->{probT}} if ($base eq 'T');\n\t$self->throw(\"No such base: $base!\\n\");\n}\n\n=head2 get_logs_array\n\n Title   : get_logs_array\n Usage   :\n Function: Returns an array with log_odds for a specified base\n Returns : array\n Args    : char\n\n\nsub get_logs_array {\n\tmy $self=shift;\n\tmy $base=uc(shift);\n\treturn  @{$self->{logA}} if (($base eq 'A')  && ($self->{logA}));\n\treturn  @{$self->{logC}} if (($base eq 'C')  && ($self->{logC}));\n\treturn  @{$self->{logG}} if (($base eq 'G')  && ($self->{logG}));\n\treturn  @{$self->{logT}} if (($base eq 'T')  && ($self->{logT}));\n\t$self->throw (\"No such base: $base!\\n\") if (!grep(/$base/,qw(A C G T)));\n    return;\n}\n\n=head2 id\n\n Title   : id\n Usage   :\n Function: Gets/sets the site id\n Returns : string\n Args    : string\n\n\nsub id {\n    my $self = shift;\n    my $prev = $self->{id};\n    if (@_) { $self->{id} = shift; }\n    return $prev;\n}\n\n=head2 regexp\n\n Title   : regexp\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : string\n Args    : none (works at the threshold last used for making the IUPAC string)\n\n\nsub regexp {\n\tmy $self=shift;\n\tmy $regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\t$regexp .= $reg;\n\t}\n    return $regexp;\n}\n\n=head2 regexp_array\n\n Title   : regexp_array\n Usage   :\n Function: Returns a regular expression which matches the IUPAC convention.\n           N will match X, N, - and .\n Returns : array\n Args    : none (works at the threshold last used for making the IUPAC string)\n To do   : I have separated regexp and regexp_array, but\n           maybe they can be rewritten as one - just check what should be returned\n\n\nsub regexp_array {\n\tmy $self=shift;\n\tmy @regexp;\n\tforeach my $letter (@{$self->{IUPAC}}) {\n\t\tmy $reg;\n\t\tLETTER: {\n\t\t\tif ($letter eq 'A') { $reg='[Aa]'; last LETTER; }\n\t\t\tif ($letter eq 'C') { $reg='[Cc]'; last LETTER; }\n\t\t\tif ($letter eq 'G') { $reg='[Gg]'; last LETTER; }\n\t\t\tif ($letter eq 'T') { $reg='[Tt]'; last LETTER; }\n\t\t\tif ($letter eq 'M') { $reg='[AaCcMm]'; last LETTER; }\n\t\t\tif ($letter eq 'R') { $reg='[AaGgRr]'; last LETTER; }\n\t\t\tif ($letter eq 'W') { $reg='[AaTtWw]'; last LETTER; }\n\t\t\tif ($letter eq 'S') { $reg='[CcGgSs]'; last LETTER; }\n\t\t\tif ($letter eq 'Y') { $reg='[CcTtYy]'; last LETTER; }\n\t\t\tif ($letter eq 'K') { $reg='[GgTtKk]'; last LETTER; }\n\t\t\tif ($letter eq 'V') { $reg='[AaCcGgVv]'; last LETTER; }\n\t\t\tif ($letter eq 'H') { $reg='[AaCcTtHh]'; last LETTER; }\n\t\t\tif ($letter eq 'D') { $reg='[AaGgTtDd]'; last LETTER; }\n\t\t\tif ($letter eq 'B') { $reg='[CcGgTtBb]'; last LETTER; }\n\t\t\t$reg='\\S';\n\t\t}\n\t\tpush @regexp,$reg;\n\t}\n    return @regexp;\n}\n\n\n=head2 _compress_array\n\n Title   : _compress_array\n Usage   :\n Function: Will compress an array of real signed numbers to a string (ie vector\n           of bytes) -127 to +127 for bi-directional(signed) and 0..255 for\n           unsigned\n Returns : String\n Args    : array reference, followed by an max value and direction (optional,\n           default 1-unsigned),1 unsigned, any other is signed. \n\n\nsub _compress_array {\n\tmy ($array,$lm,$direct)=@_;\n\tmy $str;\n\treturn  unless(($array) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (@{$array}) {\n\t\t$c=$lm if ($c>$lm);\n\t\t$c=-$lm if (($c<-$lm) && ($direct !=1));\n    $c=0 if (($c<0) && ($direct ==1));\n\t\tmy $byte=int($k1*$c);\n    $byte=127+$byte if ($direct !=1);#Clumsy, should be really shift the bits\n    my $char=chr($byte);\n\t\t$str.=$char;\n\t}\n\treturn $str;\n}\n\n=head2 _uncompress_string\n\n Title   : _uncompress_string\n Usage   :\n Function: Will uncompress a string (vector of bytes) to create an array of\n           real signed numbers (opposite to_compress_array)\n Returns : string, followed by an max value and\n \t\t   direction (optional, default 1-unsigned), 1 unsigned, any other is signed.\n Args    : array\n\n\nsub _uncompress_string {\n\tmy ($str,$lm,$direct)=@_;\n\tmy @array;\n\treturn unless(($str) && ($lm));\n\t$direct=1 unless ($direct);\n\tmy $k1= ($direct==1) ? (255/$lm) : (127/$lm);\n\tforeach my $c (split(//,$str)) {\n\t\tmy $byte=ord($c);\n\t\t$byte=$byte-127 if ($direct !=1);#Clumsy, should be really shift the bits\n\t\tmy $num=$byte/$k1;\n\t\tpush @array,$num;\n\t}\n\treturn @array;\n}\n\n=head2 get_compressed_freq\n\n Title   : get_compressed_freq\n Usage   :\n Function: A method to provide a compressed frequency vector. It uses one byte\n           to code the frequence for one of the probability vectors for one\n           position. Useful for relational database. Improvment of the previous\n           0..a coding.\n Example :  my $strA=$self->get_compressed_freq('A');\n Returns :  String\n Args    :  char \n\n\nsub get_compressed_freq {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n\tBASE: {\n\t\tif ($base eq 'A') {\n      @prob= @{$self->{probA}} unless (!defined($self->{probA}));\n      last BASE;\n    }\n  \t\tif ($base eq 'G') {\n      @prob= @{$self->{probG}} unless (!defined($self->{probG}));\n      last BASE;\n    }\n  \t\tif ($base eq 'C') {\n      @prob= @{$self->{probC}} unless (!defined($self->{probC}));\n      last BASE;\n    }\n  \t\tif ($base eq 'T') {\n      @prob= @{$self->{probT}} unless (!defined($self->{probT}));\n      last BASE;\n    }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n\tmy $str= _compress_array(\\@prob,1,1);\n    return $str;\n}\n\n=head2 get_compressed_logs\n\n Title   : get_compressed_logs\n Usage   :\n Function: A method to provide a compressed log-odd vector. It uses one byte to\n \t\t   code the log value for one of the log-odds vectors for one position.\n Example : my $strA=$self->get_compressed_logs('A');\n Returns : String\n Args    : char \n\n\nsub get_compressed_logs {\n\tmy $self=shift;\n\tmy $base=shift;\n\tmy $string='';\n\tmy @prob;\n\tBASE: {\n\t\tif ($base eq 'A') {@prob= @{$self->{logA}} unless (!defined($self->{logA})); last BASE; }\n\t\tif ($base eq 'C') {@prob= @{$self->{logC}} unless (!defined($self->{logC})); last BASE; }\n\t\tif ($base eq 'G') {@prob= @{$self->{logG}} unless (!defined($self->{logG})); last BASE; }\n\t\tif ($base eq 'T') {@prob= @{$self->{logT}} unless (!defined($self->{logT})); last BASE; }\n\t\t$self->throw (\"No such base: $base!\\n\");\n\t}\n\treturn _compress_array(\\@prob,1000,2);\n}\n\n=head2 sequence_match_weight\n\n Title   : sequence_match_weight\n Usage   :\n Function: This method will calculate the score of a match, based on the PWM\n           if such is associated with the matrix object. Returns undef if no\n           PWM data is available.\n Throws  : if the length of the sequence is different from the matrix width\n Example : my $score=$matrix->sequence_match_weight('ACGGATAG');\n Returns : Floating point\n Args    : string","parameters":[{"label":"$self"},{"label":"$seq"}]},"containerName":"main::","definition":"sub"},{"name":"logA","line":959,"kind":12},{"kind":12,"line":961,"name":"logA"},{"containerName":null,"name":"$seq","line":962,"kind":13},{"line":962,"kind":13,"name":"$seq","containerName":null},{"localvar":"my","definition":"my","name":"@seq","containerName":null,"line":963,"kind":13},{"kind":13,"line":963,"containerName":null,"name":"$seq"},{"kind":13,"line":964,"containerName":null,"name":"$score","definition":"my","localvar":"my"},{"name":"$i","definition":"my","containerName":null,"localvar":"my","kind":13,"line":965},{"definition":"my","name":"$pos","containerName":null,"localvar":"my","kind":13,"line":966},{"containerName":null,"name":"@seq","line":966,"kind":13},{"containerName":null,"definition":"my","name":"$tv","localvar":"my","kind":13,"line":967},{"line":967,"kind":13,"name":"$pos","containerName":null},{"line":968,"kind":13,"containerName":null,"name":"$self"},{"line":968,"kind":12,"name":"warn","containerName":"main::"},{"line":968,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","kind":13,"line":968},{"containerName":null,"name":"$tv","kind":13,"line":968},{"line":969,"kind":13,"name":"$score","containerName":null},{"containerName":null,"name":"%self","line":969,"kind":13},{"containerName":null,"name":"$tv","kind":13,"line":969},{"name":"%self","containerName":null,"kind":13,"line":969},{"line":969,"kind":13,"containerName":null,"name":"@tv"},{"line":969,"kind":13,"containerName":null,"name":"$i"},{"containerName":null,"name":"$i","kind":13,"line":970},{"line":972,"kind":13,"containerName":null,"name":"$score"},{"name":"get_all_vectors","definition":"sub","containerName":"main::","range":{"start":{"line":988,"character":0},"end":{"character":9999,"line":994}},"kind":12,"children":[{"kind":13,"line":989,"definition":"my","name":"$self","containerName":"get_all_vectors","localvar":"my"},{"localvar":"my","containerName":"get_all_vectors","definition":"my","name":"$thresh","line":990,"kind":13},{"containerName":"get_all_vectors","name":"$self","kind":13,"line":991},{"containerName":"get_all_vectors","name":"throw","kind":12,"line":991},{"containerName":"get_all_vectors","name":"$thresh","kind":13,"line":991},{"kind":13,"line":991,"containerName":"get_all_vectors","name":"$thresh"},{"localvar":"my","definition":"my","name":"@seq","containerName":"get_all_vectors","line":992,"kind":13},{"name":"$self","containerName":"get_all_vectors","line":992,"kind":13},{"kind":12,"line":992,"containerName":"get_all_vectors","name":"consensus"},{"kind":13,"line":992,"name":"$thresh","containerName":"get_all_vectors"},{"localvar":"my","containerName":"get_all_vectors","definition":"my","name":"@perm","line":993,"kind":13},{"kind":13,"line":994,"containerName":"get_all_vectors","definition":"my","name":"$i","localvar":"my"},{"kind":13,"line":994,"name":"$self","containerName":"get_all_vectors"}],"line":988},{"kind":12,"line":994,"name":"probA"},{"name":"@perm","containerName":null,"line":995,"kind":13},{"name":"$i","containerName":null,"line":995,"kind":13},{"line":995,"kind":13,"name":"%self","containerName":null},{"line":995,"kind":12,"name":"probA"},{"kind":13,"line":995,"containerName":null,"name":"$i"},{"containerName":null,"name":"$thresh","kind":13,"line":995},{"containerName":null,"name":"@perm","kind":13,"line":996},{"kind":13,"line":996,"containerName":null,"name":"$i"},{"name":"%self","containerName":null,"kind":13,"line":996},{"kind":12,"line":996,"name":"probC"},{"kind":13,"line":996,"containerName":null,"name":"$i"},{"containerName":null,"name":"$thresh","kind":13,"line":996},{"line":997,"kind":13,"name":"@perm","containerName":null},{"kind":13,"line":997,"containerName":null,"name":"$i"},{"containerName":null,"name":"%self","kind":13,"line":997},{"name":"probG","kind":12,"line":997},{"line":997,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":997,"name":"$thresh","containerName":null},{"line":998,"kind":13,"containerName":null,"name":"@perm"},{"kind":13,"line":998,"containerName":null,"name":"$i"},{"line":998,"kind":13,"containerName":null,"name":"%self"},{"name":"probT","line":998,"kind":12},{"containerName":null,"name":"$i","line":998,"kind":13},{"name":"$thresh","containerName":null,"kind":13,"line":998},{"kind":13,"line":999,"containerName":null,"name":"@perm"},{"line":999,"kind":13,"name":"$i","containerName":null},{"containerName":null,"name":"@seq","kind":13,"line":999},{"line":999,"kind":13,"name":"$i","containerName":null},{"localvar":"my","definition":"my","name":"$fpos","containerName":null,"line":1001,"kind":13},{"containerName":null,"name":"@perm","kind":13,"line":1001},{"localvar":"my","definition":"my","name":"@strings","containerName":null,"line":1002,"kind":13},{"name":"$fpos","containerName":null,"line":1002,"kind":13},{"containerName":null,"name":"$pos","definition":"my","localvar":"my","kind":13,"line":1003},{"kind":13,"line":1003,"name":"@perm","containerName":null},{"containerName":null,"definition":"my","name":"@newstr","localvar":"my","kind":13,"line":1004},{"definition":"my","name":"%let","containerName":null,"localvar":"my","kind":13,"line":1005},{"localvar":"my","containerName":null,"name":"$string","definition":"my","line":1006,"kind":13},{"containerName":null,"name":"@strings","kind":13,"line":1006},{"kind":13,"line":1007,"name":"$newstring","definition":"my","containerName":null,"localvar":"my"},{"line":1007,"kind":13,"name":"$string","containerName":null},{"name":"$let","containerName":null,"kind":13,"line":1007},{"kind":13,"line":1008,"name":"@newstr","containerName":null},{"line":1008,"kind":13,"containerName":null,"name":"$newstring"},{"line":1011,"kind":13,"containerName":null,"name":"@strings"},{"containerName":null,"name":"@newstr","kind":13,"line":1011},{"name":"@strings","containerName":null,"line":1013,"kind":13}],"version":5}