{"vars":[{"line":130,"kind":2,"containerName":"","name":"base"},{"line":132,"kind":13,"containerName":null,"name":"@Bio"},{"kind":12,"line":132,"containerName":"PSM::Psm::HEADER","name":"Matrix"},{"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: Psm.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n#ISA SiteMatrix, HAS InstanceSite\n\n=head1 NAME\n\nBio::Matrix::PSM::Psm - handle combination of site matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  #To get a Psm object from a file use the Psm parser:\n  my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', -file=>$file);\n\n  # Now go through all entities in the file with next_psm, which\n  # returns a Psm object see Bio::Matrix::PSM::IO for detailed\n  # documentation (matrix predictions or matrix sequence matches or\n  # both):\n\n  while (my $psm=$psmIO->next_psm) {\n    my %psm_header=$psm->header;\n    my $ic=$psm_header{IC};\n    my $sites=$psm_header{sites};\n    my $width=$psm_header{width};\n    my $score=$psm_header{e_val};\n    my $IUPAC=$psm->IUPAC;\n    my $instances=$psm->instances;\n    foreach my $instance (@{$instances}) {\n      my $id=$instance->primary_id;\n      #Do something with the id\n    }\n  }\n\n #or create from memmory:\n  my $psm= Bio::Matrix::PSM::Psm->new( -pA=>\\@pA,-pC=>\\@pC,-pG=>\\@pG,-pT=>\\@pT,\n       -id=>$id,\n       -instances=>$instances, -e_val=>$e_val,\n       -IC=>$ic, -width=>$width, -sites=>$sites)\n\n  # where pA through pG are the respective frequencies of the matrix (see also\n  # Bio::Matrix::PSM::SiteMatrix), and everything else is self-explenatory, \n  # except for -instances (reference to an array of \n  #  Bio::Matrix::PSM::InstanceSite objects) which is documented bellow.\n\n=head1 DESCRIPTION\n\nTo handle a combination of site matrices and/or their corresponding\nsequence matches (instances). This object inherits from\nBio::Matrix::PSM::SiteMatrix, so you can use the respective\nmethods. It may hold also an array of Bio::Matrix::PSM::InstanceSite\nobject, but you will have to retrieve these through\nBio::Matrix::PSM::Psm-E<gt>instances method (see below). To some extent\nthis is an expanded SiteMatrix object, holding data from analysis that\nalso deal with sequence matches of a particular matrix.\n\n\n=head2 DESIGN ISSUES\n\nThis does not make too much sense to me I am mixing PSM with PSM\nsequence matches Though they are very closely related, I am not\nsatisfied by the way this is implemented here.  Heikki suggested\ndifferent objects when one has something like meme But does this mean\nwe have to write a different objects for mast, meme, transfac,\ntheiresias, etc.?  To me the best way is to return SiteMatrix object +\narrray of InstanceSite objects and then mast will return undef for\nSiteMatrix and transfac will return undef for InstanceSite. Probably I\ncannot see some other design issues that might arise from such\napproach, but it seems more straightforward.  Hilmar does not like\nthis beacause it is an exception from the general BioPerl rules Should\nI leave this as an option?  Also the header rightfully belongs the\ndriver object, and could be retrieved as hashes.  I do not think it\ncan be done any other way, unless we want to create even one more\nobject with very unclear content.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 DISCLAIMER\n\nThis software is provided \"as is\" without warranty of any kind.\n\n=head1 SEE ALSO\n\nSiteMatrix, meme, transfac, InstanceSite\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::Psm;\nuse Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::SiteMatrix Bio::Matrix::PSM::PsmI Bio::Annotation::Collection);\n\n@Bio::Matrix::PSM::Psm::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psm= Bio::Matrix::PSM::Psm->new( -pA=>\\@pA,-pC=>\\@pC,\n\t\t\t\t\t       -pG=>\\@pG,-pT=>\\@pT,-id=>$id,\n\t\t\t\t\t       -instances=>$instances, \n\t\t\t\t\t       -e_val=>$e_val,\n\t\t\t\t\t       -IC=>$ic, -width=>$width, \n\t\t\t\t\t       -sites=>$sites)\n Function: Creates a new Bio::Matrix::PSM::Psm object\n Throws  :\n Example :\n Returns :  Bio::Matrix::PSM::Psm object\n Args    :  hash","label":"new($caller,@args)"},"detail":"($caller,@args)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$caller","containerName":"new","localvar":"my","kind":13,"line":153},{"name":"@args","containerName":"new","kind":13,"line":153},{"line":154,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"new"},{"containerName":"new","name":"$caller","line":154,"kind":13},{"name":"$caller","containerName":"new","kind":13,"line":154},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":155,"kind":13},{"line":155,"kind":13,"name":"$class","containerName":"new"},{"containerName":"new","name":"@args","kind":13,"line":155},{"containerName":"new","name":"$self","line":156,"kind":13},{"name":"$self","containerName":"new","line":157,"kind":13},{"line":157,"kind":12,"containerName":"new","name":"_typemap"},{"kind":12,"line":157,"name":"new","containerName":"new"},{"kind":13,"line":158,"containerName":"new","name":"$self"},{"line":158,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":158,"containerName":"new","name":"_rearrange"},{"line":158,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":159,"containerName":"new","name":"$self"}],"line":152,"kind":12,"range":{"start":{"character":0,"line":152},"end":{"character":9999,"line":160}},"name":"new"},{"kind":12,"line":155,"containerName":"new","name":"SUPER"},{"containerName":"Annotation::TypeManager","name":"Bio","kind":12,"line":157},{"line":158,"kind":12,"name":"instances"},{"range":{"end":{"character":9999,"line":181},"start":{"line":176,"character":0}},"containerName":"main::","definition":"sub","name":"instances","line":176,"children":[{"containerName":"instances","definition":"my","name":"$self","localvar":"my","kind":13,"line":177},{"line":178,"kind":13,"localvar":"my","definition":"my","name":"$prev","containerName":"instances"},{"containerName":"instances","name":"$self","kind":13,"line":178},{"kind":13,"line":179,"containerName":"instances","name":"$self"},{"containerName":"instances","name":"$prev","kind":13,"line":180}],"kind":12},{"line":178,"kind":12,"name":"instances"},{"line":179,"kind":12,"name":"instances"},{"children":[{"line":204,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"header"},{"line":205,"kind":13,"name":"$self","containerName":"header"},{"line":206,"kind":13,"localvar":"my","definition":"my","name":"%header","containerName":"header"},{"definition":"my","name":"$key","containerName":"header","localvar":"my","kind":13,"line":207},{"name":"$self","containerName":"header","line":207,"kind":13},{"kind":13,"line":207,"name":"$key","containerName":"header"},{"name":"$key","definition":"my","containerName":"header","localvar":"my","kind":13,"line":208},{"line":208,"kind":13,"containerName":"header","name":"@Bio"},{"line":209,"kind":13,"containerName":"header","name":"$header"},{"name":"$key","containerName":"header","kind":13,"line":209},{"line":209,"kind":13,"containerName":"header","name":"$self"},{"kind":13,"line":209,"containerName":"header","name":"$key"},{"name":"%header","containerName":"header","kind":13,"line":211}],"line":203,"kind":12,"range":{"end":{"line":212,"character":9999},"start":{"character":0,"line":203}},"name":"header","definition":"sub","containerName":"main::"},{"line":205,"kind":12,"name":"end"},{"line":208,"kind":12,"name":"Matrix","containerName":"PSM::Psm::HEADER"},{"definition":"sub","name":"matrix","containerName":"main::","range":{"start":{"line":228,"character":0},"end":{"character":9999,"line":252}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"matrix","localvar":"my","kind":13,"line":229},{"containerName":"matrix","name":"$prev","definition":"my","localvar":"my","kind":13,"line":230},{"containerName":"matrix","name":"new","line":230,"kind":12},{"containerName":"matrix","name":"$self","line":230,"kind":13},{"name":"$self","containerName":"matrix","kind":13,"line":231},{"line":232,"kind":13,"containerName":"matrix","name":"$self"},{"containerName":"matrix","name":"$self","line":233,"kind":13},{"containerName":"matrix","name":"$self","line":234,"kind":13},{"name":"$self","containerName":"matrix","kind":13,"line":235},{"name":"$self","containerName":"matrix","line":236,"kind":13},{"containerName":"matrix","name":"$self","kind":13,"line":237},{"name":"$self","containerName":"matrix","line":238,"kind":13},{"name":"$self","containerName":"matrix","line":239,"kind":13},{"containerName":"matrix","name":"$self","kind":13,"line":240},{"name":"$matrix","definition":"my","containerName":"matrix","localvar":"my","kind":13,"line":242},{"containerName":"matrix","name":"$self","line":243,"kind":13},{"containerName":"matrix","name":"$matrix","kind":13,"line":243},{"name":"IC","containerName":"matrix","kind":12,"line":243},{"containerName":"matrix","name":"$self","line":244,"kind":13},{"line":244,"kind":13,"containerName":"matrix","name":"$matrix"},{"containerName":"matrix","name":"$self","line":245,"kind":13},{"containerName":"matrix","name":"$matrix","kind":13,"line":245},{"line":246,"kind":13,"name":"$self","containerName":"matrix"},{"name":"$matrix","containerName":"matrix","kind":13,"line":246},{"containerName":"matrix","name":"$self","kind":13,"line":247},{"containerName":"matrix","name":"$matrix","line":247,"kind":13},{"containerName":"matrix","name":"$self","kind":13,"line":248},{"containerName":"matrix","name":"$matrix","line":248,"kind":13},{"name":"e_val","containerName":"matrix","line":248,"kind":12},{"containerName":"matrix","name":"$self","kind":13,"line":249},{"name":"$matrix","containerName":"matrix","kind":13,"line":249},{"name":"id","containerName":"matrix","line":249,"kind":12},{"kind":13,"line":251,"containerName":"matrix","name":"$prev"}],"line":228},{"kind":12,"line":230,"name":"Bio","containerName":"Matrix::PSM::SiteMatrix"},{"name":"probA","line":230,"kind":12},{"name":"probC","line":231,"kind":12},{"name":"probG","kind":12,"line":232},{"name":"probT","line":233,"kind":12},{"name":"logA","line":234,"kind":12},{"name":"logC","line":235,"kind":12},{"line":236,"kind":12,"name":"logG"},{"name":"logT","kind":12,"line":237},{"kind":12,"line":238,"name":"IC"},{"line":239,"kind":12,"name":"e_val"},{"kind":12,"line":240,"name":"id"},{"name":"IC","kind":12,"line":243},{"kind":12,"line":244,"name":"probA"},{"name":"probA","kind":12,"line":244},{"kind":12,"line":245,"name":"probC"},{"kind":12,"line":245,"name":"probC"},{"line":246,"kind":12,"name":"probG"},{"name":"probG","kind":12,"line":246},{"name":"probT","kind":12,"line":247},{"name":"probT","kind":12,"line":247},{"name":"e_val","kind":12,"line":248},{"line":249,"kind":12,"name":"id"}],"version":5}