{"version":5,"vars":[{"line":90,"kind":2,"name":"base","containerName":""},{"line":109,"children":[{"line":110,"kind":13,"localvar":"my","definition":"my","name":"$class","containerName":"new"},{"line":110,"kind":13,"containerName":"new","name":"@args"},{"kind":13,"line":111,"definition":"my","name":"%args","containerName":"new","localvar":"my"},{"kind":13,"line":111,"name":"@args","containerName":"new"},{"name":"$args","containerName":"new","line":112,"kind":13},{"line":113,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$end"},{"name":"$args","containerName":"new","line":113,"kind":13},{"containerName":"new","name":"$args","line":113,"kind":13},{"name":"$args","containerName":"new","line":114,"kind":13},{"name":"$args","containerName":"new","line":115,"kind":13},{"name":"@args","containerName":"new","line":116,"kind":13},{"containerName":"new","name":"%args","line":116,"kind":13},{"line":118,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"kind":13,"line":118,"containerName":"new","name":"$class"},{"kind":13,"line":118,"name":"@args","containerName":"new"},{"line":118,"kind":13,"name":"$end","containerName":"new"},{"kind":13,"line":120,"name":"@args","containerName":"new"},{"definition":"my","name":"$key","containerName":"new","localvar":"my","kind":13,"line":121},{"line":121,"kind":13,"name":"@args","containerName":"new"},{"name":"$args","containerName":"new","line":122,"kind":13},{"name":"$key","containerName":"new","line":122,"kind":13},{"kind":13,"line":122,"name":"@args","containerName":"new"},{"kind":13,"line":125,"containerName":"new","name":"$args"},{"kind":13,"line":125,"name":"$args","containerName":"new"},{"kind":13,"line":126,"name":"$args","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":129},{"containerName":"new","name":"$args","kind":13,"line":129},{"containerName":"new","name":"$self","kind":13,"line":130},{"kind":12,"line":130,"name":"seq","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":130},{"kind":13,"line":131,"name":"$self","containerName":"new"},{"kind":12,"line":131,"containerName":"new","name":"desc"},{"kind":13,"line":131,"containerName":"new","name":"$args"},{"line":132,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"$args","kind":13,"line":132},{"containerName":"new","name":"$self","line":133,"kind":13},{"kind":13,"line":133,"containerName":"new","name":"$args"},{"kind":13,"line":134,"name":"$self","containerName":"new"},{"kind":13,"line":134,"containerName":"new","name":"$args"},{"name":"$self","containerName":"new","kind":13,"line":135},{"kind":13,"line":135,"containerName":"new","name":"$args"},{"kind":13,"line":136,"name":"$self","containerName":"new"}],"kind":12,"detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash","label":"new($class,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":109}},"name":"new"},{"line":118,"kind":12,"containerName":"new","name":"SUPER"},{"name":"seq","line":125,"kind":12},{"name":"seq","kind":12,"line":125},{"kind":12,"line":126,"name":"seq"},{"name":"mid","kind":12,"line":129},{"name":"mid","line":129,"kind":12},{"name":"seq","line":130,"kind":12},{"line":131,"kind":12,"name":"desc"},{"line":132,"kind":12,"name":"score"},{"name":"score","line":132,"kind":12},{"name":"relpos","kind":12,"line":133},{"name":"relpos","kind":12,"line":133},{"name":"frame","line":134,"kind":12},{"name":"frame","kind":12,"line":134},{"name":"anchor","kind":12,"line":135},{"kind":12,"line":135,"name":"anchor"},{"children":[{"kind":13,"line":154,"containerName":"mid","name":"$self","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$prev","containerName":"mid","line":155,"kind":13},{"line":155,"kind":13,"containerName":"mid","name":"$self"},{"line":156,"kind":13,"containerName":"mid","name":"$self"},{"containerName":"mid","name":"$prev","kind":13,"line":157}],"line":153,"kind":12,"range":{"start":{"line":153,"character":0},"end":{"character":9999,"line":158}},"name":"mid","definition":"sub","containerName":"main::"},{"line":155,"kind":12,"name":"mid"},{"kind":12,"line":156,"name":"mid"},{"definition":"sub","name":"score","containerName":"main::","range":{"start":{"character":0,"line":173},"end":{"character":9999,"line":178}},"kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"score","line":174,"kind":13},{"localvar":"my","name":"$prev","definition":"my","containerName":"score","line":175,"kind":13},{"containerName":"score","name":"$self","kind":13,"line":175},{"name":"$self","containerName":"score","line":176,"kind":13},{"name":"$prev","containerName":"score","line":177,"kind":13}],"line":173},{"name":"score","line":175,"kind":12},{"name":"score","kind":12,"line":176},{"kind":12,"line":192,"children":[{"definition":"my","name":"$self","containerName":"anchor","localvar":"my","kind":13,"line":193},{"line":194,"kind":13,"localvar":"my","containerName":"anchor","definition":"my","name":"$prev"},{"name":"$self","containerName":"anchor","kind":13,"line":194},{"name":"$self","containerName":"anchor","kind":13,"line":195},{"kind":13,"line":196,"name":"$prev","containerName":"anchor"}],"containerName":"main::","name":"anchor","definition":"sub","range":{"start":{"line":192,"character":0},"end":{"character":9999,"line":197}}},{"name":"anchor","line":194,"kind":12},{"name":"anchor","kind":12,"line":195},{"range":{"start":{"line":227,"character":0},"end":{"line":232,"character":9999}},"containerName":"main::","name":"minstance","definition":"sub","line":227,"children":[{"line":228,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"minstance"},{"line":229,"kind":13,"localvar":"my","containerName":"minstance","name":"$prev","definition":"my"},{"containerName":"minstance","name":"$self","kind":13,"line":229},{"line":230,"kind":13,"name":"$self","containerName":"minstance"},{"name":"$prev","containerName":"minstance","kind":13,"line":231}],"kind":12},{"line":229,"kind":12,"name":"minstance"},{"kind":12,"line":230,"name":"minstance"},{"children":[{"line":248,"kind":13,"localvar":"my","containerName":"relpos","definition":"my","name":"$self"},{"kind":13,"line":249,"name":"$prev","definition":"my","containerName":"relpos","localvar":"my"},{"name":"$self","containerName":"relpos","line":249,"kind":13},{"kind":13,"line":250,"containerName":"relpos","name":"$self"},{"line":251,"kind":13,"containerName":"relpos","name":"$prev"}],"line":247,"kind":12,"range":{"start":{"line":247,"character":0},"end":{"character":9999,"line":252}},"definition":"sub","name":"relpos","containerName":"main::"},{"line":249,"kind":12,"name":"relpos"},{"name":"relpos","line":250,"kind":12},{"name":"annotation","range":{"end":{"character":9999,"line":278},"start":{"character":0,"line":267}},"kind":12,"children":[{"line":268,"kind":13,"localvar":"my","containerName":"annotation","name":"$obj","definition":"my"},{"name":"$value","containerName":"annotation","line":268,"kind":13},{"containerName":"annotation","name":"$value","kind":13,"line":269},{"containerName":"annotation","name":"$obj","line":270,"kind":13},{"name":"throw","containerName":"annotation","line":270,"kind":12},{"containerName":"annotation","name":"$value","line":270,"kind":13},{"kind":13,"line":272,"name":"$value","containerName":"annotation"},{"line":272,"kind":12,"containerName":"annotation","name":"isa"},{"kind":13,"line":273,"containerName":"annotation","name":"$obj"},{"containerName":"annotation","name":"$value","kind":13,"line":273},{"containerName":"annotation","name":"$obj","kind":13,"line":274},{"name":"$obj","containerName":"annotation","kind":13,"line":275},{"name":"new","containerName":"annotation","kind":12,"line":275},{"line":277,"kind":13,"containerName":"annotation","name":"$obj"}],"line":267,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my %args = @args; #Too many things to rearrange, and I am creating >1K such objects routinely, so this is a performance issue    \n    $args{'-start'} ||= 1;\n    my $end = $args{'-start'} + length($args{-seq}) -1;\n    if (!defined($args{-strand})) {\n\t$args{-strand}=1;\n\t@args=%args;\n    }\n    my $self = $class->SUPER::new(@args,'-end',$end);\n    \n    while( @args ) {\n\t(my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n\t$args{$key} = shift @args;\n    }\n#should throw exception if seq is null, for now just warn\n    if (($args{seq} eq '') || (!defined($args{seq}))) {\n\t$args{seq}=\"AGCT\";\n\twarn \"No sequence?!\\n\";\n    }\n    $self->{mid}=$args{mid};\n    $self->seq($args{seq});\n    $self->desc($args{desc});\n    $self->{score}=$args{score};\n    $self->{relpos}=$args{relpos};\n    $self->{frame}=$args{frame};\n    $self->{anchor}=$args{anchor};\n    return $self;\n}\n\n\n=head2 mid\n\n Title   : mid\n Usage   : my $mid=$instance->mid;\n Function: Get/Set the motif id\n Throws  :\n Example :\n Returns : scalar\n Args    : scalar\n\n\n\nsub mid {\n    my $self = shift;\n    my $prev = $self->{mid};\n    if (@_) { $self->{mid} = shift; }\n    return $prev;\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score=$instance->score;\n Function: Get/Set the score (mismatches) between the instance and the attached (or\n            initial) PSM\n Throws  :\n Example :\n Returns : real number\n Args    : real number\n\n\nsub score {\n    my $self = shift;\n    my $prev = $self->{score};\n    if (@_) { $self->{score} = shift; }\n    return $prev;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor=$instance->anchor;\n Function: Get/Set the anchor which shows what coordinate system start/end use\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub anchor {\n    my $self = shift;\n    my $prev = $self->{anchor};\n    if (@_) { $self->{anchor} = shift; }\n    return $prev;\n}\n\n=head2 start\n\n Title   : start\n Usage   : my $start=$instance->start;\n Function: Get/Set the position of the instance on the sequence used\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\n\n#Provided by LocatableSeq\n\n=head2 minstance\n\n Title   : minstance\n Usage   : my $minstance=$misntance->score;\n Function: Get/Set the unique identifier- sequence id/motif id, for example PRM1_TATAbox.\n          Not necessarily human readable.\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub minstance {\n    my $self = shift;\n    my $prev = $self->{minstance};\n    if (@_) { $self->{minstance} = shift; }\n    return $prev;\n}\n\n=head2 relpos\n\n Title   : relpos\n Usage   : my $seqpos=$instance->relpos;\n Function: Get/Set the relative position of the instance with respect to the transcription start\n            site (if known). Can and usually is negative.\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\nsub relpos {\n    my $self = shift;\n    my $prev = $self->{relpos};\n    if (@_) { $self->{relpos} = shift; }\n    return $prev;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or $seq->annotation($annotation)\n Function: Gets or sets the annotation\n Returns : L<Bio::AnnotationCollectionI> object\n Args    : None or L<Bio::AnnotationCollectionI> object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information","label":"annotation($obj,$value)"},"detail":"($obj,$value)"},{"kind":12,"line":275,"name":"Bio","containerName":"Annotation::Collection"},{"children":[{"line":293,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"species"},{"containerName":"species","name":"$species","kind":13,"line":293},{"kind":13,"line":294,"containerName":"species","name":"$species"},{"kind":13,"line":295,"name":"$self","containerName":"species"},{"containerName":"species","name":"$species","kind":13,"line":295},{"containerName":"species","name":"$self","line":297,"kind":13}],"line":292,"kind":12,"signature":{"documentation":"1;\n# $Id: InstanceSite.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::InstanceSite - A PSM site occurance\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::InstanceSite;\n\n  #You can get an InstanceSite object either from a file:\n\n  my ($instances,$matrix)=$SomePSMFile->parse_next;\n\n  #or from memory\n\n  my %params=(seq=>'TATAAT',\n    id=>\"TATAbox1\", accession=>'ENSG00000122304', mid=>'TB1',\n    desc=>'TATA box, experimentally verified in PRM1 gene',\n    -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926);\n\n  #Last 2 arguments are passed to create a Bio::LocatableSeq object\n  #Anchor shows the coordinates system for the Bio::LocatableSeq object\n\n=head1 DESCRIPTION\n\nAbstract interface to PSM site occurrence (PSM sequence\nmatch). InstanceSite objects may be used to describe a PSM (See\nL<Bio::Matrix::PSM::SiteMatrix>) sequence matches.  The usual\ncharacteristic of such a match is sequence coordinates, score,\nsequence and sequence (gene) identifier- accession number or other id.\n\nThis object inherits from Bio::LocatableSeq (which defines the real\nsequence) and might hold a SiteMatrix object, used to detect the CRE\n(cis-regulatory element), or created from this CRE.\n\nWhile the documentation states that the motif id and gene id\n(accession) combination should be unique, this is not entirely true-\nthere might be more than one occurrence of the same cis-regulatory\nelement in the upstream region of the same gene.  Therefore relpos\nwould be the third element to create a really unique combination.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head2 Description\n\nBio::Matrix::PSM::InstanceSiteI implementation\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::InstanceSite;\nuse strict;\n\nuse base qw(Bio::LocatableSeq Bio::Matrix::PSM::InstanceSiteI);\n\n=head2 new\n\n Title   : new\n Usage   : my $isntance=Bio::Matrix::PSM::InstanceSite->new \n                         (-seq=>'TATAAT', -id=>\"TATAbox1\",\n                          -accession_number='ENSG00000122304', -mid=>'TB1',\n                          -desc=>'TATA box, experimentally verified in PRM1 gene',\n                          -relpos=>-35, -anchor=>'CHR7', -start=>35000921, -end=>35000926, strand=>1)\n Function: Creates an InstanceSite object from memory.\n Throws  :\n Example :\n Returns : Bio::Matrix::PSM::InstanceSite object\n Args    : hash\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my %args = @args; #Too many things to rearrange, and I am creating >1K such objects routinely, so this is a performance issue    \n    $args{'-start'} ||= 1;\n    my $end = $args{'-start'} + length($args{-seq}) -1;\n    if (!defined($args{-strand})) {\n\t$args{-strand}=1;\n\t@args=%args;\n    }\n    my $self = $class->SUPER::new(@args,'-end',$end);\n    \n    while( @args ) {\n\t(my $key = shift @args) =~ s/-//gi; #deletes all dashes (only dashes)!\n\t$args{$key} = shift @args;\n    }\n#should throw exception if seq is null, for now just warn\n    if (($args{seq} eq '') || (!defined($args{seq}))) {\n\t$args{seq}=\"AGCT\";\n\twarn \"No sequence?!\\n\";\n    }\n    $self->{mid}=$args{mid};\n    $self->seq($args{seq});\n    $self->desc($args{desc});\n    $self->{score}=$args{score};\n    $self->{relpos}=$args{relpos};\n    $self->{frame}=$args{frame};\n    $self->{anchor}=$args{anchor};\n    return $self;\n}\n\n\n=head2 mid\n\n Title   : mid\n Usage   : my $mid=$instance->mid;\n Function: Get/Set the motif id\n Throws  :\n Example :\n Returns : scalar\n Args    : scalar\n\n\n\nsub mid {\n    my $self = shift;\n    my $prev = $self->{mid};\n    if (@_) { $self->{mid} = shift; }\n    return $prev;\n}\n\n=head2 score\n\n Title   : score\n Usage   : my $score=$instance->score;\n Function: Get/Set the score (mismatches) between the instance and the attached (or\n            initial) PSM\n Throws  :\n Example :\n Returns : real number\n Args    : real number\n\n\nsub score {\n    my $self = shift;\n    my $prev = $self->{score};\n    if (@_) { $self->{score} = shift; }\n    return $prev;\n}\n\n=head2 anchor\n\n Title   : anchor\n Usage   : my $anchor=$instance->anchor;\n Function: Get/Set the anchor which shows what coordinate system start/end use\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub anchor {\n    my $self = shift;\n    my $prev = $self->{anchor};\n    if (@_) { $self->{anchor} = shift; }\n    return $prev;\n}\n\n=head2 start\n\n Title   : start\n Usage   : my $start=$instance->start;\n Function: Get/Set the position of the instance on the sequence used\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\n\n#Provided by LocatableSeq\n\n=head2 minstance\n\n Title   : minstance\n Usage   : my $minstance=$misntance->score;\n Function: Get/Set the unique identifier- sequence id/motif id, for example PRM1_TATAbox.\n          Not necessarily human readable.\n Throws  :\n Example :\n Returns : string\n Args    : string\n\n\nsub minstance {\n    my $self = shift;\n    my $prev = $self->{minstance};\n    if (@_) { $self->{minstance} = shift; }\n    return $prev;\n}\n\n=head2 relpos\n\n Title   : relpos\n Usage   : my $seqpos=$instance->relpos;\n Function: Get/Set the relative position of the instance with respect to the transcription start\n            site (if known). Can and usually is negative.\n Throws  :\n Example :\n Returns : integer\n Args    : integer\n\n\nsub relpos {\n    my $self = shift;\n    my $prev = $self->{relpos};\n    if (@_) { $self->{relpos} = shift; }\n    return $prev;\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $ann = $seq->annotation or $seq->annotation($annotation)\n Function: Gets or sets the annotation\n Returns : L<Bio::AnnotationCollectionI> object\n Args    : None or L<Bio::AnnotationCollectionI> object\n\nSee L<Bio::AnnotationCollectionI> and L<Bio::Annotation::Collection>\nfor more information\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n    if( defined $value ) {\n\t$obj->throw(\"object of class \".ref($value).\" does not implement \".\n\t\t    \"Bio::AnnotationCollectionI. Too bad.\")\n\t    unless $value->isa(\"Bio::AnnotationCollectionI\");\n\t$obj->{'_annotation'} = $value;\n    } elsif( ! defined $obj->{'_annotation'}) {\n\t$obj->{'_annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $obj->{'_annotation'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $species = $seq->species() or $seq->species($species)\n Function: Gets or sets the species\n Returns : L<Bio::Species> object\n Args    : None or L<Bio::Species> object\n\nSee L<Bio::Species> for more information","parameters":[{"label":"$self"},{"label":"$species"}],"label":"species($self,$species)"},"detail":"($self,$species)","definition":"sub","containerName":"main::","range":{"start":{"line":292,"character":0},"end":{"line":299,"character":9999}},"name":"species"},{"range":{"end":{"character":9999,"line":320},"start":{"line":315,"character":0}},"containerName":"main::","definition":"sub","name":"frame","line":315,"children":[{"definition":"my","name":"$self","containerName":"frame","localvar":"my","kind":13,"line":316},{"line":317,"kind":13,"localvar":"my","containerName":"frame","definition":"my","name":"$prev"},{"name":"$self","containerName":"frame","line":317,"kind":13},{"line":318,"kind":13,"containerName":"frame","name":"$self"},{"name":"$self","containerName":"frame","kind":13,"line":318},{"containerName":"frame","name":"throw","line":318,"kind":12},{"name":"$prev","containerName":"frame","line":319,"kind":13}],"kind":12},{"kind":12,"line":317,"name":"frame"},{"name":"frame","line":318,"kind":12}]}