{"version":5,"vars":[{"line":79,"kind":2,"containerName":"","name":"base"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"next_matrix","line":102,"kind":13},{"localvar":"my","name":"@matrix","definition":"my","containerName":"next_matrix","line":104,"kind":13},{"name":"$gap_open","containerName":"next_matrix","line":104,"kind":13},{"line":104,"kind":13,"containerName":"next_matrix","name":"$gap_cont"},{"name":"$self","containerName":"next_matrix","line":105,"kind":13},{"containerName":"next_matrix","name":"_readline","line":105,"kind":12},{"definition":"my","name":"@values","containerName":"next_matrix","localvar":"my","kind":13,"line":107},{"kind":13,"line":108,"containerName":"next_matrix","name":"@matrix"},{"kind":13,"line":108,"name":"@values","containerName":"next_matrix"},{"containerName":"next_matrix","name":"$gap_open","kind":13,"line":111},{"name":"$gap_cont","containerName":"next_matrix","line":111,"kind":13},{"name":"@matrix","containerName":"next_matrix","line":116,"kind":13},{"containerName":"next_matrix","name":"$self","line":116,"kind":13},{"kind":12,"line":116,"containerName":"next_matrix","name":"throw"},{"containerName":"next_matrix","name":"$matrix","definition":"my","localvar":"my","kind":13,"line":118},{"name":"new","containerName":"next_matrix","kind":12,"line":118},{"containerName":"next_matrix","name":"@matrix","kind":13,"line":118},{"line":119,"kind":13,"name":"$gap_open","containerName":"next_matrix"},{"kind":13,"line":120,"containerName":"next_matrix","name":"$gap_cont"},{"name":"$matrix","containerName":"next_matrix","kind":13,"line":122}],"line":101,"kind":12,"range":{"end":{"line":123,"character":9999},"start":{"line":101,"character":0}},"name":"next_matrix","definition":"sub","containerName":"main::"},{"name":"Bio","containerName":"Matrix::Mlagan","line":118,"kind":12},{"name":"write_matrix","range":{"end":{"character":9999,"line":160},"start":{"line":135,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: mlagan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::mlagan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::mlagan - A parser for the mlagan substitution matrix\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'mlagan',\n                                   -file   => 'nucmatrix.txt');\n  my $matrix = $parser->next_matrix;\n  my $gap_open = $parser->gap_open;\n  my $gap_continue = $parser->gap_continue;\n\n=head1 DESCRIPTION\n\nUse to read in and write out substitution matrix files suitable for use by\nmlagan.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Matrix::IO::mlagan;\nuse strict;\n\nuse Bio::Matrix::Mlagan;\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::mlagan->new();\n Function: Builds a new Bio::Matrix::IO::mlagan object \n Returns : an instance of Bio::Matrix::IO::mlagan\n Args    :\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $obj->next_matrix();\n Function: parses a matrix file\n Returns : L<Bio::Matrix::Mlagan>\n Args    : none\n\n\nsub next_matrix {\n    my $self = shift;\n    \n    my (@matrix, $gap_open, $gap_cont);\n    while (defined ($_ = $self->_readline)) {\n        if (/^[ACGTN\\.]/) {\n            my (undef, @values) = split;\n            push(@matrix, \\@values);\n        }\n        elsif (/^[-\\d]/) {\n            ($gap_open, $gap_cont) = split;\n            last;\n        }\n    }\n    \n    @matrix == 6 || $self->throw(\"Something wrong with file, was it the correct format?\");\n    \n    my $matrix = Bio::Matrix::Mlagan->new(-values => \\@matrix,\n                                          -gap_open => $gap_open,\n                                          -gap_continue => $gap_cont);\n    \n    return $matrix;\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $obj->write_matrix($matrix)\n Function: Write out a matrix in mlagan format\n Returns : n/a\n Args    : L<Bio::Matrix::Generic>","parameters":[{"label":"$self"},{"label":"$matrix"}],"label":"write_matrix($self,$matrix)"},"detail":"($self,$matrix)","kind":12,"children":[{"line":136,"kind":13,"localvar":"my","containerName":"write_matrix","name":"$self","definition":"my"},{"kind":13,"line":136,"containerName":"write_matrix","name":"$matrix"},{"name":"$matrix","containerName":"write_matrix","kind":13,"line":137},{"kind":13,"line":137,"name":"$self","containerName":"write_matrix"},{"kind":12,"line":137,"name":"throw","containerName":"write_matrix"},{"localvar":"my","containerName":"write_matrix","name":"$gap_open","definition":"my","line":138,"kind":13},{"name":"$matrix","containerName":"write_matrix","line":138,"kind":13},{"kind":12,"line":138,"name":"gap_open","containerName":"write_matrix"},{"containerName":"write_matrix","definition":"my","name":"$gap_continue","localvar":"my","kind":13,"line":139},{"kind":13,"line":139,"containerName":"write_matrix","name":"$matrix"},{"line":139,"kind":12,"containerName":"write_matrix","name":"gap_continue"},{"containerName":"write_matrix","name":"$gap_open","line":141,"kind":13},{"kind":13,"line":141,"name":"$gap_continue","containerName":"write_matrix"},{"name":"$self","containerName":"write_matrix","line":142,"kind":13},{"line":142,"kind":12,"containerName":"write_matrix","name":"throw"},{"kind":13,"line":145,"containerName":"write_matrix","name":"$self"},{"name":"_print","containerName":"write_matrix","line":145,"kind":12},{"line":147,"kind":13,"localvar":"my","containerName":"write_matrix","name":"$char","definition":"my"},{"definition":"my","name":"@row","containerName":"write_matrix","localvar":"my","kind":13,"line":148},{"containerName":"write_matrix","name":"$matrix","kind":13,"line":148},{"name":"get_row","containerName":"write_matrix","kind":12,"line":148},{"name":"$char","containerName":"write_matrix","kind":13,"line":148},{"kind":13,"line":149,"containerName":"write_matrix","definition":"my","name":"$row","localvar":"my"},{"name":"$char","containerName":"write_matrix","line":149,"kind":13},{"kind":13,"line":150,"containerName":"write_matrix","definition":"my","name":"$val","localvar":"my"},{"line":150,"kind":13,"containerName":"write_matrix","name":"@row"},{"name":"$row","containerName":"write_matrix","line":151,"kind":13},{"line":151,"kind":13,"containerName":"write_matrix","name":"$val"},{"name":"$val","containerName":"write_matrix","line":151,"kind":13},{"kind":13,"line":154,"containerName":"write_matrix","name":"$self"},{"line":154,"kind":12,"containerName":"write_matrix","name":"_print"},{"containerName":"write_matrix","name":"$row","line":154,"kind":13},{"name":"$self","containerName":"write_matrix","line":157,"kind":13},{"kind":12,"line":157,"name":"_print","containerName":"write_matrix"}],"line":135}]}