{"version":5,"vars":[{"line":82,"kind":2,"containerName":"","name":"base"},{"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :","label":"new($caller,@args)"},"detail":"($caller,@args)","definition":"sub","containerName":"main::","children":[{"containerName":"new","name":"$caller","definition":"my","localvar":"my","kind":13,"line":96},{"name":"@args","containerName":"new","line":96,"kind":13},{"kind":13,"line":97,"name":"$class","definition":"my","containerName":"new","localvar":"my"},{"containerName":"new","name":"$caller","kind":13,"line":97},{"line":97,"kind":13,"containerName":"new","name":"$caller"},{"name":"$class","containerName":"new","kind":13,"line":101},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":102},{"line":102,"kind":13,"name":"$class","containerName":"new"},{"kind":13,"line":102,"name":"@args","containerName":"new"},{"kind":13,"line":103,"name":"$self","containerName":"new"},{"containerName":"new","name":"_initialize","kind":12,"line":103},{"line":103,"kind":13,"name":"@args","containerName":"new"},{"line":104,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"line":107,"definition":"my","name":"%param","containerName":"new","localvar":"my"},{"containerName":"new","name":"@args","kind":13,"line":107},{"line":108,"kind":13,"containerName":"new","name":"@param"},{"kind":13,"line":108,"name":"%param","containerName":"new"},{"containerName":"new","name":"%param","kind":13,"line":108},{"line":109,"kind":13,"localvar":"my","definition":"my","name":"$format","containerName":"new"},{"line":109,"kind":13,"name":"$param","containerName":"new"},{"containerName":"new","name":"$class","kind":13,"line":110},{"kind":12,"line":110,"name":"_guess_format","containerName":"new"},{"kind":13,"line":110,"name":"$param","containerName":"new"},{"line":110,"kind":13,"containerName":"new","name":"$ARGV"},{"kind":13,"line":112,"containerName":"new","name":"$format"},{"line":115,"kind":13,"name":"$class","containerName":"new"},{"line":115,"kind":12,"name":"_load_format_module","containerName":"new"},{"containerName":"new","name":"$format","kind":13,"line":115},{"containerName":"new","name":"new","kind":12,"line":116},{"name":"@args","containerName":"new","kind":13,"line":116}],"line":95,"kind":12,"range":{"start":{"line":95,"character":0},"end":{"character":9999,"line":118}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":102},{"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"newFh","line":134,"kind":13},{"name":"$self","definition":"my","containerName":"newFh","localvar":"my","kind":13,"line":135},{"containerName":"newFh","name":"$class","line":135,"kind":13},{"name":"new","containerName":"newFh","kind":12,"line":135},{"kind":13,"line":136,"name":"$self","containerName":"newFh"},{"containerName":"newFh","name":"fh","line":136,"kind":12}],"line":133,"kind":12,"range":{"end":{"character":9999,"line":137},"start":{"character":0,"line":133}},"definition":"sub","name":"newFh","containerName":"main::"},{"range":{"start":{"line":153,"character":0},"end":{"line":159,"character":9999}},"name":"fh","definition":"sub","containerName":"main::","children":[{"kind":13,"line":154,"containerName":"fh","definition":"my","name":"$self","localvar":"my"},{"line":155,"kind":13,"localvar":"my","name":"$class","definition":"my","containerName":"fh"},{"containerName":"fh","name":"$self","kind":13,"line":155},{"containerName":"fh","name":"$self","kind":13,"line":155},{"line":156,"kind":13,"localvar":"my","name":"$s","definition":"my","containerName":"fh"},{"kind":13,"line":157,"name":"$class","containerName":"fh"},{"kind":13,"line":157,"containerName":"fh","name":"$self"},{"name":"$s","containerName":"fh","line":158,"kind":13}],"line":153,"kind":12},{"kind":12,"line":157,"name":"Symbol","containerName":"gensym"},{"range":{"end":{"character":9999,"line":176},"start":{"character":0,"line":173}},"name":"next_matrix","children":[{"line":174,"kind":13,"localvar":"my","containerName":"next_matrix","definition":"my","name":"$self"},{"kind":13,"line":175,"name":"$self","containerName":"next_matrix"},{"line":175,"kind":12,"containerName":"next_matrix","name":"throw_not_implemented"}],"line":173,"kind":12,"signature":{"label":"next_matrix($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::"},{"name":"write_matrix","range":{"start":{"character":0,"line":190},"end":{"character":9999,"line":193}},"kind":12,"children":[{"kind":13,"line":191,"containerName":"write_matrix","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":192,"name":"$self","containerName":"write_matrix"},{"containerName":"write_matrix","name":"throw_not_implemented","line":192,"kind":12}],"line":190,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none\n\n\n\nsub next_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $io->write_matrix($matrix)\n Function: Writes a matrix out to the data stream\n Returns : none\n Args    : Array of Bio::Matrix::MatrixI object\n          - note that not all matricies can be converted to \n            each format, beware with mixing matrix types and output formats","parameters":[{"label":"$self"}],"label":"write_matrix($self)"},"detail":"($self)"},{"name":"_initialize","range":{"start":{"character":0,"line":195},"end":{"line":198,"character":9999}},"definition":"sub","containerName":"main::","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"detail":"($self,@args)","kind":12,"children":[{"kind":13,"line":196,"definition":"my","name":"$self","containerName":"_initialize","localvar":"my"},{"kind":13,"line":196,"containerName":"_initialize","name":"@args"},{"containerName":"_initialize","name":"$self","line":197,"kind":13},{"kind":12,"line":197,"containerName":"_initialize","name":"_initialize_io"},{"name":"@args","containerName":"_initialize","kind":13,"line":197}],"line":195},{"kind":12,"line":208,"children":[{"line":209,"kind":13,"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$self"},{"line":209,"kind":13,"containerName":"_load_format_module","name":"$format"},{"kind":13,"line":210,"containerName":"_load_format_module","definition":"my","name":"$module","localvar":"my"},{"kind":13,"line":210,"containerName":"_load_format_module","name":"$format"},{"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$ok","line":211,"kind":13},{"kind":13,"line":214,"name":"$ok","containerName":"_load_format_module"},{"kind":13,"line":214,"containerName":"_load_format_module","name":"$self"},{"name":"_load_module","containerName":"_load_format_module","line":214,"kind":12},{"kind":13,"line":214,"name":"$module","containerName":"_load_format_module"},{"line":226,"kind":13,"name":"$ok","containerName":"_load_format_module"}],"containerName":"main::","definition":"sub","detail":"($self,$format)","signature":{"label":"_load_format_module($self,$format)","parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO - A factory for Matrix parsing\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUMN50');\n\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a general factory framework for writing parsers for Matricies.\nThis includes parsing output from distance output like PHYLIP's\nProtDist.  Additionally it should be possible to fit parsers for PWM\nand PSSMs once their Matrix objects are written.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO;\nuse strict;\n\n\nuse base qw(Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO->new();\n Function: Builds a new Bio::Matrix::IO object \n Returns : an instance of Bio::Matrix::IO\n Args    :\n\n\n\nsub new { \n  my($caller,@args) = @_;\n  my $class = ref($caller) || $caller;\n    \n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::IO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\t\n\t$self->_initialize(@args);\n\treturn $self;\n    } else { \n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} || \n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t\t'scoring';\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::IO::$format\"->new(@args);\n    }\n}\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Matrix::IO->newFh(-file=>$filename,-format=>'Format')\n           $matrix = <$fh>;   # read a matrix object\n           print $fh $matrix; # write a matrix object\n Returns : filehandle tied to the Bio::SeqIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n           print $fh $matrix;   # write a matrix object\n Returns : filehandle tied to Bio::Matrix::IO class\n Args    : none\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $matixio->next_matrix;\n Function: Parse the next matrix from the data stream\n Returns : L<Bio::Matrix::MatrixI> type object or undef when finished\n Args    : none\n\n\n\nsub next_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $io->write_matrix($matrix)\n Function: Writes a matrix out to the data stream\n Returns : none\n Args    : Array of Bio::Matrix::MatrixI object\n          - note that not all matricies can be converted to \n            each format, beware with mixing matrix types and output formats\n\n\nsub write_matrix{\n   my ($self) = @_;\n   $self->throw_not_implemented();\n}\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->_initialize_io(@args);\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Matrix::IO stuff*\n Function: Loads up (like use) a module at run time on demand"},"name":"_load_format_module","range":{"start":{"line":208,"character":0},"end":{"character":9999,"line":227}}},{"containerName":"main::","definition":"sub","name":"_guess_format","range":{"start":{"character":0,"line":239},"end":{"character":9999,"line":244}},"kind":12,"line":239,"children":[{"containerName":"_guess_format","name":"$class","definition":"my","localvar":"my","kind":13,"line":240}]},{"definition":"sub","name":"DESTROY","containerName":"main::","range":{"start":{"line":246,"character":0},"end":{"line":249,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"DESTROY","localvar":"my","kind":13,"line":247},{"containerName":"DESTROY","name":"$self","kind":13,"line":248},{"name":"close","containerName":"DESTROY","kind":12,"line":248}],"line":246},{"kind":12,"line":251,"children":[{"localvar":"my","definition":"my","name":"$class","containerName":"TIEHANDLE","line":252,"kind":13},{"kind":13,"line":253,"name":"$class","containerName":"TIEHANDLE"}],"containerName":"main::","name":"TIEHANDLE","definition":"sub","range":{"start":{"line":251,"character":0},"end":{"line":254,"character":9999}}},{"kind":12,"line":256,"children":[{"line":257,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"READLINE"},{"containerName":"READLINE","name":"$self","kind":13,"line":258},{"name":"next_tree","containerName":"READLINE","line":258,"kind":12},{"kind":13,"line":259,"definition":"my","name":"@list","containerName":"READLINE","localvar":"my"},{"name":"$obj","containerName":"READLINE","line":259,"kind":13},{"containerName":"READLINE","name":"@list","kind":13,"line":260},{"name":"$obj","containerName":"READLINE","kind":13,"line":260},{"containerName":"READLINE","name":"$obj","kind":13,"line":260},{"containerName":"READLINE","name":"$self","kind":13,"line":260},{"kind":12,"line":260,"containerName":"READLINE","name":"next_tree"},{"line":261,"kind":13,"name":"@list","containerName":"READLINE"}],"containerName":"main::","definition":"sub","name":"READLINE","range":{"start":{"character":0,"line":256},"end":{"line":262,"character":9999}}},{"range":{"end":{"character":9999,"line":267},"start":{"line":264,"character":0}},"containerName":"main::","definition":"sub","name":"PRINT","line":264,"children":[{"localvar":"my","containerName":"PRINT","name":"$self","definition":"my","line":265,"kind":13},{"name":"$self","containerName":"PRINT","kind":13,"line":266},{"name":"write_tree","containerName":"PRINT","line":266,"kind":12}],"kind":12}]}